/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.CdmaCallTracker;
import com.android.internal.telephony.cdma.CdmaConnection;
import java.util.List;

public final class CdmaCall
extends Call {
    CdmaCallTracker mOwner;

    CdmaCall(CdmaCallTracker owner) {
        this.mOwner = owner;
    }

    public void dispose() {
    }

    @Override
    public List<Connection> getConnections() {
        return this.mConnections;
    }

    @Override
    public Phone getPhone() {
        return this.mOwner.mPhone;
    }

    @Override
    public boolean isMultiparty() {
        return this.mConnections.size() > 1;
    }

    @Override
    public void hangup() throws CallStateException {
        this.mOwner.hangup(this);
    }

    public String toString() {
        return this.mState.toString();
    }

    void attach(Connection conn, DriverCall dc) {
        this.mConnections.add(conn);
        this.mState = CdmaCall.stateFromDCState(dc.state);
    }

    void attachFake(Connection conn, Call.State state) {
        this.mConnections.add(conn);
        this.mState = state;
    }

    boolean connectionDisconnected(CdmaConnection conn) {
        if (this.mState != Call.State.DISCONNECTED) {
            boolean hasOnlyDisconnectedConnections = true;
            int s = this.mConnections.size();
            for (int i = 0; i < s; ++i) {
                if (((Connection)this.mConnections.get(i)).getState() == Call.State.DISCONNECTED) continue;
                hasOnlyDisconnectedConnections = false;
                break;
            }
            if (hasOnlyDisconnectedConnections) {
                this.mState = Call.State.DISCONNECTED;
                return true;
            }
        }
        return false;
    }

    void detach(CdmaConnection conn) {
        this.mConnections.remove(conn);
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }

    boolean update(CdmaConnection conn, DriverCall dc) {
        boolean changed = false;
        Call.State newState = CdmaCall.stateFromDCState(dc.state);
        if (newState != this.mState) {
            this.mState = newState;
            changed = true;
        }
        return changed;
    }

    boolean isFull() {
        return this.mConnections.size() == 1;
    }

    void onHangupLocal() {
        int s = this.mConnections.size();
        for (int i = 0; i < s; ++i) {
            CdmaConnection cn = (CdmaConnection)this.mConnections.get(i);
            cn.onHangupLocal();
        }
        this.mState = Call.State.DISCONNECTING;
    }

    void clearDisconnected() {
        for (int i = this.mConnections.size() - 1; i >= 0; --i) {
            CdmaConnection cn = (CdmaConnection)this.mConnections.get(i);
            if (cn.getState() != Call.State.DISCONNECTED) continue;
            this.mConnections.remove(i);
        }
        if (this.mConnections.size() == 0) {
            this.mState = Call.State.IDLE;
        }
    }
}

