/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.os.AsyncResult;
import android.os.Build;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.telephony.CellIdentityLte;
import android.telephony.CellInfo;
import android.telephony.CellInfoLte;
import android.telephony.CellSignalStrengthLte;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.cdma.CDMALTEPhone;
import com.android.internal.telephony.cdma.CdmaServiceStateTracker;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class CdmaLteServiceStateTracker
extends CdmaServiceStateTracker {
    private CDMALTEPhone mCdmaLtePhone;
    private final CellInfoLte mCellInfoLte;
    private static final int EVENT_ALL_DATA_DISCONNECTED = 1001;
    private CellIdentityLte mNewCellIdentityLte = new CellIdentityLte();
    private CellIdentityLte mLasteCellIdentityLte = new CellIdentityLte();

    public CdmaLteServiceStateTracker(CDMALTEPhone phone) {
        super(phone, new CellInfoLte());
        this.mCdmaLtePhone = phone;
        this.mCdmaLtePhone.registerForSimRecordsLoaded(this, 16, null);
        this.mCellInfoLte = (CellInfoLte)this.mCellInfo;
        ((CellInfoLte)this.mCellInfo).setCellSignalStrength(new CellSignalStrengthLte());
        ((CellInfoLte)this.mCellInfo).setCellIdentity(new CellIdentityLte());
        this.log("CdmaLteServiceStateTracker Constructors");
    }

    @Override
    public void dispose() {
        this.mPhone.unregisterForSimRecordsLoaded(this);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        if (!this.mPhone.mIsTheCurrentActivePhone) {
            this.loge("Received message " + msg + "[" + msg.what + "]" + " while being destroyed. Ignoring.");
            return;
        }
        this.log("handleMessage: " + msg.what);
        switch (msg.what) {
            case 5: {
                this.log("handleMessage EVENT_POLL_STATE_GPRS");
                AsyncResult ar = (AsyncResult)msg.obj;
                this.handlePollStateResult(msg.what, ar);
                break;
            }
            case 27: {
                this.updatePhoneObject();
                RuimRecords ruim = (RuimRecords)this.mIccRecords;
                if (ruim != null) {
                    if (ruim.isProvisioned()) {
                        this.mMdn = ruim.getMdn();
                        this.mMin = ruim.getMin();
                        this.parseSidNid(ruim.getSid(), ruim.getNid());
                        this.mPrlVersion = ruim.getPrlVersion();
                        this.mIsMinInfoReady = true;
                    }
                    this.updateOtaspState();
                }
                this.mPhone.prepareEri();
                this.pollState();
                break;
            }
            case 16: {
                this.updatePhoneObject();
                break;
            }
            case 1001: {
                int dds = SubscriptionManager.getDefaultDataSubId();
                ProxyController.getInstance().unregisterForAllDataDisconnected(dds, this);
                CdmaLteServiceStateTracker cdmaLteServiceStateTracker = this;
                synchronized (cdmaLteServiceStateTracker) {
                    if (this.mPendingRadioPowerOffAfterDataOff) {
                        this.log("EVENT_ALL_DATA_DISCONNECTED, turn radio off now.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    } else {
                        this.log("EVENT_ALL_DATA_DISCONNECTED is stale");
                    }
                    break;
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    @Override
    protected void handlePollStateResultMessage(int what, AsyncResult ar) {
        if (what == 5) {
            String[] states = (String[])ar.result;
            this.log("handlePollStateResultMessage: EVENT_POLL_STATE_GPRS states.length=" + states.length + " states=" + states);
            int type = 0;
            int regState = -1;
            if (states.length > 0) {
                try {
                    regState = Integer.parseInt(states[0]);
                    if (states.length >= 4 && states[3] != null) {
                        type = Integer.parseInt(states[3]);
                    }
                }
                catch (NumberFormatException ex) {
                    this.loge("handlePollStateResultMessage: error parsing GprsRegistrationState: " + ex);
                }
                if (states.length >= 10) {
                    int eci;
                    int pci;
                    int tac;
                    int mnc;
                    int mcc;
                    String operatorNumeric = null;
                    try {
                        operatorNumeric = this.mNewSS.getOperatorNumeric();
                        mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
                    }
                    catch (Exception e) {
                        try {
                            operatorNumeric = this.mSS.getOperatorNumeric();
                            mcc = Integer.parseInt(operatorNumeric.substring(0, 3));
                        }
                        catch (Exception ex) {
                            this.loge("handlePollStateResultMessage: bad mcc operatorNumeric=" + operatorNumeric + " ex=" + ex);
                            operatorNumeric = "";
                            mcc = Integer.MAX_VALUE;
                        }
                    }
                    try {
                        mnc = Integer.parseInt(operatorNumeric.substring(3));
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad mnc operatorNumeric=" + operatorNumeric + " e=" + e);
                        mnc = Integer.MAX_VALUE;
                    }
                    try {
                        tac = Integer.decode(states[6]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad tac states[6]=" + states[6] + " e=" + e);
                        tac = Integer.MAX_VALUE;
                    }
                    try {
                        pci = Integer.decode(states[7]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad pci states[7]=" + states[7] + " e=" + e);
                        pci = Integer.MAX_VALUE;
                    }
                    try {
                        eci = Integer.decode(states[8]);
                    }
                    catch (Exception e) {
                        this.loge("handlePollStateResultMessage: bad eci states[8]=" + states[8] + " e=" + e);
                        eci = Integer.MAX_VALUE;
                    }
                    try {
                        int csgid = Integer.decode(states[9]);
                    }
                    catch (Exception e) {
                        int csgid = Integer.MAX_VALUE;
                    }
                    this.mNewCellIdentityLte = new CellIdentityLte(mcc, mnc, eci, pci, tac);
                    this.log("handlePollStateResultMessage: mNewLteCellIdentity=" + this.mNewCellIdentityLte);
                }
            }
            this.mNewSS.setRilDataRadioTechnology(type);
            int dataRegState = this.regCodeToServiceState(regState);
            this.mNewSS.setDataRegState(dataRegState);
            this.mNewSS.setDataRoaming(this.regCodeIsRoaming(regState));
            this.log("handlPollStateResultMessage: CdmaLteSST setDataRegState=" + dataRegState + " regState=" + regState + " dataRadioTechnology=" + type);
        } else {
            super.handlePollStateResultMessage(what, ar);
        }
    }

    @Override
    public void pollState() {
        this.mPollingContext = new int[1];
        this.mPollingContext[0] = 0;
        switch (this.mCi.getRadioState()) {
            case RADIO_UNAVAILABLE: {
                this.mNewSS.setStateOutOfService();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                this.pollStateDone();
                break;
            }
            case RADIO_OFF: {
                this.mNewSS.setStateOff();
                this.mNewCellLoc.setStateInvalid();
                this.setSignalStrengthDefaultValues();
                this.mGotCountryCode = false;
                if (18 != this.mSS.getRilDataRadioTechnology()) {
                    this.pollStateDone();
                }
            }
            default: {
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getOperator(this.obtainMessage(25, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getVoiceRegistrationState(this.obtainMessage(24, this.mPollingContext));
                this.mPollingContext[0] = this.mPollingContext[0] + 1;
                this.mCi.getDataRegistrationState(this.obtainMessage(5, this.mPollingContext));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void pollStateDone() {
        this.updateRoamingState();
        if (Build.IS_DEBUGGABLE && SystemProperties.getBoolean("telephony.test.forceRoaming", false)) {
            this.mNewSS.setVoiceRoaming(true);
            this.mNewSS.setDataRoaming(true);
        }
        this.useDataRegStateForDataOnlyDevices();
        this.resetServiceStateInIwlanMode();
        this.log("pollStateDone: lte 1 ss=[" + this.mSS + "] newSS=[" + this.mNewSS + "]");
        boolean hasRegistered = this.mSS.getVoiceRegState() != 0 && this.mNewSS.getVoiceRegState() == 0;
        boolean hasDeregistered = this.mSS.getVoiceRegState() == 0 && this.mNewSS.getVoiceRegState() != 0;
        boolean hasCdmaDataConnectionAttached = this.mSS.getDataRegState() != 0 && this.mNewSS.getDataRegState() == 0;
        boolean hasCdmaDataConnectionDetached = this.mSS.getDataRegState() == 0 && this.mNewSS.getDataRegState() != 0;
        boolean hasCdmaDataConnectionChanged = this.mSS.getDataRegState() != this.mNewSS.getDataRegState();
        boolean hasVoiceRadioTechnologyChanged = this.mSS.getRilVoiceRadioTechnology() != this.mNewSS.getRilVoiceRadioTechnology();
        boolean hasDataRadioTechnologyChanged = this.mSS.getRilDataRadioTechnology() != this.mNewSS.getRilDataRadioTechnology();
        boolean hasChanged = !this.mNewSS.equals(this.mSS);
        boolean hasVoiceRoamingOn = !this.mSS.getVoiceRoaming() && this.mNewSS.getVoiceRoaming();
        boolean hasVoiceRoamingOff = this.mSS.getVoiceRoaming() && !this.mNewSS.getVoiceRoaming();
        boolean hasDataRoamingOn = !this.mSS.getDataRoaming() && this.mNewSS.getDataRoaming();
        boolean hasDataRoamingOff = this.mSS.getDataRoaming() && !this.mNewSS.getDataRoaming();
        boolean hasLocationChanged = !this.mNewCellLoc.equals(this.mCellLoc);
        boolean has4gHandoff = this.mNewSS.getDataRegState() == 0 && (this.mSS.getRilDataRadioTechnology() == 14 && this.mNewSS.getRilDataRadioTechnology() == 13 || this.mSS.getRilDataRadioTechnology() == 13 && this.mNewSS.getRilDataRadioTechnology() == 14);
        boolean hasMultiApnSupport = (this.mNewSS.getRilDataRadioTechnology() == 14 || this.mNewSS.getRilDataRadioTechnology() == 13) && this.mSS.getRilDataRadioTechnology() != 14 && this.mSS.getRilDataRadioTechnology() != 13;
        boolean hasLostMultiApnSupport = this.mNewSS.getRilDataRadioTechnology() >= 4 && this.mNewSS.getRilDataRadioTechnology() <= 8;
        TelephonyManager tm = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeegistered=" + hasDeregistered + " hasCdmaDataConnectionAttached=" + hasCdmaDataConnectionAttached + " hasCdmaDataConnectionDetached=" + hasCdmaDataConnectionDetached + " hasCdmaDataConnectionChanged=" + hasCdmaDataConnectionChanged + " hasVoiceRadioTechnologyChanged= " + hasVoiceRadioTechnologyChanged + " hasDataRadioTechnologyChanged=" + hasDataRadioTechnologyChanged + " hasChanged=" + hasChanged + " hasVoiceRoamingOn=" + hasVoiceRoamingOn + " hasVoiceRoamingOff=" + hasVoiceRoamingOff + " hasDataRoamingOn=" + hasDataRoamingOn + " hasDataRoamingOff=" + hasDataRoamingOff + " hasLocationChanged=" + hasLocationChanged + " has4gHandoff = " + has4gHandoff + " hasMultiApnSupport=" + hasMultiApnSupport + " hasLostMultiApnSupport=" + hasLostMultiApnSupport);
        if (this.mSS.getVoiceRegState() != this.mNewSS.getVoiceRegState() || this.mSS.getDataRegState() != this.mNewSS.getDataRegState()) {
            EventLog.writeEvent(50116, this.mSS.getVoiceRegState(), this.mSS.getDataRegState(), this.mNewSS.getVoiceRegState(), this.mNewSS.getDataRegState());
        }
        ServiceState tss = this.mSS;
        this.mSS = this.mNewSS;
        this.mNewSS = tss;
        this.mNewSS.setStateOutOfService();
        CdmaCellLocation tcl = this.mCellLoc;
        this.mCellLoc = this.mNewCellLoc;
        this.mNewCellLoc = tcl;
        this.mNewSS.setStateOutOfService();
        if (hasVoiceRadioTechnologyChanged) {
            this.updatePhoneObject();
        }
        if (hasDataRadioTechnologyChanged) {
            tm.setDataNetworkTypeForPhone(this.mPhone.getPhoneId(), this.mSS.getRilDataRadioTechnology());
            if (18 == this.mSS.getRilDataRadioTechnology()) {
                this.log("pollStateDone: IWLAN enabled");
            }
        }
        if (hasRegistered) {
            this.mNetworkAttachedRegistrants.notifyRegistrants();
        }
        if (hasChanged) {
            boolean hasBrandOverride;
            boolean bl = this.mUiccController.getUiccCard(this.getPhoneId()) == null ? false : (hasBrandOverride = this.mUiccController.getUiccCard(this.getPhoneId()).getOperatorBrandOverride() != null);
            if (!hasBrandOverride && this.mCi.getRadioState().isOn() && this.mPhone.isEriFileLoaded() && (this.mSS.getRilVoiceRadioTechnology() != 14 || this.mPhone.getContext().getResources().getBoolean(17957014))) {
                String eriText = this.mSS.getOperatorAlphaLong();
                if (this.mSS.getVoiceRegState() == 0) {
                    eriText = this.mPhone.getCdmaEriText();
                } else if (this.mSS.getVoiceRegState() == 3) {
                    String string2 = eriText = this.mIccRecords != null ? this.mIccRecords.getServiceProviderName() : null;
                    if (TextUtils.isEmpty(eriText)) {
                        eriText = SystemProperties.get("ro.cdma.home.operator.alpha");
                    }
                } else if (this.mSS.getDataRegState() != 0) {
                    eriText = this.mPhone.getContext().getText(17039556).toString();
                }
                this.mSS.setOperatorAlphaLong(eriText);
            }
            if (this.mUiccApplcation != null && this.mUiccApplcation.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY && this.mIccRecords != null && this.mSS.getVoiceRegState() == 0 && this.mSS.getRilVoiceRadioTechnology() != 14) {
                boolean showSpn = ((RuimRecords)this.mIccRecords).getCsimSpnDisplayCondition();
                int iconIndex = this.mSS.getCdmaEriIconIndex();
                if (showSpn && iconIndex == 1 && this.isInHomeSidNid(this.mSS.getSystemId(), this.mSS.getNetworkId()) && this.mIccRecords != null) {
                    this.mSS.setOperatorAlphaLong(this.mIccRecords.getServiceProviderName());
                }
            }
            tm.setNetworkOperatorNameForPhone(this.mPhone.getPhoneId(), this.mSS.getOperatorAlphaLong());
            String prevOperatorNumeric = tm.getNetworkOperatorForPhone(this.mPhone.getPhoneId());
            String operatorNumeric = this.mSS.getOperatorNumeric();
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                int sid = this.mSS.getSystemId();
                operatorNumeric = this.fixUnknownMcc(operatorNumeric, sid);
            }
            tm.setNetworkOperatorNumericForPhone(this.mPhone.getPhoneId(), operatorNumeric);
            this.updateCarrierMccMncConfiguration(operatorNumeric, prevOperatorNumeric, this.mPhone.getContext());
            if (this.isInvalidOperatorNumeric(operatorNumeric)) {
                this.log("operatorNumeric is null");
                tm.setNetworkCountryIsoForPhone(this.mPhone.getPhoneId(), "");
                this.mGotCountryCode = false;
            } else {
                String isoCountryCode = "";
                String mcc = operatorNumeric.substring(0, 3);
                try {
                    isoCountryCode = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
                }
                catch (NumberFormatException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                catch (StringIndexOutOfBoundsException ex) {
                    this.loge("countryCodeForMcc error" + ex);
                }
                tm.setNetworkCountryIsoForPhone(this.mPhone.getPhoneId(), isoCountryCode);
                this.mGotCountryCode = true;
                this.setOperatorIdd(operatorNumeric);
                if (this.shouldFixTimeZoneNow(this.mPhone, operatorNumeric, prevOperatorNumeric, this.mNeedFixZone)) {
                    this.fixTimeZone(isoCountryCode);
                }
            }
            tm.setNetworkRoamingForPhone(this.mPhone.getPhoneId(), this.mSS.getVoiceRoaming() || this.mSS.getDataRoaming());
            this.updateSpnDisplay();
            this.setRoamingType(this.mSS);
            this.log("Broadcasting ServiceState : " + this.mSS);
            this.mPhone.notifyServiceStateChanged(this.mSS);
        }
        if (hasCdmaDataConnectionAttached || has4gHandoff) {
            this.mAttachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionDetached) {
            this.mDetachedRegistrants.notifyRegistrants();
        }
        if (hasCdmaDataConnectionChanged || hasDataRadioTechnologyChanged) {
            this.notifyDataRegStateRilRadioTechnologyChanged();
            if (18 == this.mSS.getRilDataRadioTechnology()) {
                this.mPhone.notifyDataConnection("iwlanAvailable");
            } else {
                this.mPhone.notifyDataConnection(null);
            }
        }
        if (hasVoiceRoamingOn) {
            this.mVoiceRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasVoiceRoamingOff) {
            this.mVoiceRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOn) {
            this.mDataRoamingOnRegistrants.notifyRegistrants();
        }
        if (hasDataRoamingOff) {
            this.mDataRoamingOffRegistrants.notifyRegistrants();
        }
        if (hasLocationChanged) {
            this.mPhone.notifyLocationChanged();
        }
        ArrayList<CellInfo> arrayCi = new ArrayList<CellInfo>();
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            boolean cidChanged;
            CellInfoLte cil = (CellInfoLte)this.mCellInfo;
            boolean bl = cidChanged = !this.mNewCellIdentityLte.equals(this.mLasteCellIdentityLte);
            if (hasRegistered || hasDeregistered || cidChanged) {
                long timeStamp = SystemClock.elapsedRealtime() * 1000L;
                boolean registered = this.mSS.getVoiceRegState() == 0;
                this.mLasteCellIdentityLte = this.mNewCellIdentityLte;
                cil.setRegistered(registered);
                cil.setCellIdentity(this.mLasteCellIdentityLte);
                this.log("pollStateDone: hasRegistered=" + hasRegistered + " hasDeregistered=" + hasDeregistered + " cidChanged=" + cidChanged + " mCellInfo=" + this.mCellInfo);
                arrayCi.add(this.mCellInfo);
            }
            this.mPhoneBase.notifyCellInfo(arrayCi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean onSignalStrengthResult(AsyncResult ar, boolean isGsm) {
        if (this.mSS.getRilDataRadioTechnology() == 14) {
            isGsm = true;
        }
        boolean ssChanged = super.onSignalStrengthResult(ar, isGsm);
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            if (this.mSS.getRilDataRadioTechnology() == 14) {
                this.mCellInfoLte.setTimeStamp(SystemClock.elapsedRealtime() * 1000L);
                this.mCellInfoLte.setTimeStampType(4);
                this.mCellInfoLte.getCellSignalStrength().initialize(this.mSignalStrength, Integer.MAX_VALUE);
            }
            if (this.mCellInfoLte.getCellIdentity() != null) {
                ArrayList<CellInfo> arrayCi = new ArrayList<CellInfo>();
                arrayCi.add(this.mCellInfoLte);
                this.mPhoneBase.notifyCellInfo(arrayCi);
            }
        }
        return ssChanged;
    }

    @Override
    public boolean isConcurrentVoiceAndDataAllowed() {
        return this.mSS.getCssIndicator() == 1;
    }

    private boolean isInHomeSidNid(int sid, int nid) {
        if (this.isSidsAllZeros()) {
            return true;
        }
        if (this.mHomeSystemId.length != this.mHomeNetworkId.length) {
            return true;
        }
        if (sid == 0) {
            return true;
        }
        for (int i = 0; i < this.mHomeSystemId.length; ++i) {
            if (this.mHomeSystemId[i] != sid || this.mHomeNetworkId[i] != 0 && this.mHomeNetworkId[i] != 65535 && nid != 0 && nid != 65535 && this.mHomeNetworkId[i] != nid) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CellInfo> getAllCellInfo() {
        if (this.mCi.getRilVersion() >= 8) {
            return super.getAllCellInfo();
        }
        ArrayList<CellInfo> arrayList = new ArrayList<CellInfo>();
        CellInfo cellInfo = this.mCellInfo;
        synchronized (cellInfo) {
            arrayList.add(this.mCellInfoLte);
        }
        this.log("getAllCellInfo: arrayList=" + arrayList);
        return arrayList;
    }

    @Override
    protected UiccCardApplication getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(((CDMALTEPhone)this.mPhone).getPhoneId(), 2);
    }

    protected void updateCdmaSubscription() {
        this.mCi.getCDMASubscription(this.obtainMessage(34));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void powerOffRadioSafely(DcTrackerBase dcTracker) {
        CdmaLteServiceStateTracker cdmaLteServiceStateTracker = this;
        synchronized (cdmaLteServiceStateTracker) {
            if (!this.mPendingRadioPowerOffAfterDataOff) {
                int dds = SubscriptionManager.getDefaultDataSubId();
                if (dcTracker.isDisconnected() && (dds == this.mPhone.getSubId() || dds != this.mPhone.getSubId() && ProxyController.getInstance().isDataDisconnected(dds))) {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    this.log("Data disconnected, turn off radio right away.");
                    this.hangupAndPowerOff();
                } else {
                    dcTracker.cleanUpAllConnections("radioTurnedOff");
                    if (dds != this.mPhone.getSubId() && !ProxyController.getInstance().isDataDisconnected(dds)) {
                        this.log("Data is active on DDS.  Wait for all data disconnect");
                        ProxyController.getInstance().registerForAllDataDisconnected(dds, this, 1001, null);
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    }
                    Message msg = Message.obtain(this);
                    msg.what = 38;
                    msg.arg1 = ++this.mPendingRadioPowerOffAfterDataOffTag;
                    if (this.sendMessageDelayed(msg, 30000L)) {
                        this.log("Wait upto 30s for data to disconnect, then turn off radio.");
                        this.mPendingRadioPowerOffAfterDataOff = true;
                    } else {
                        this.log("Cannot send delayed Msg, turn off radio right away.");
                        this.hangupAndPowerOff();
                        this.mPendingRadioPowerOffAfterDataOff = false;
                    }
                }
            }
        }
    }

    @Override
    protected void log(String s) {
        Rlog.d("CdmaSST", "[CdmaLteSST] " + s);
    }

    @Override
    protected void loge(String s) {
        Rlog.e("CdmaSST", "[CdmaLteSST] " + s);
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("CdmaLteServiceStateTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mCdmaLtePhone=" + this.mCdmaLtePhone);
    }
}

