/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.app.PendingIntent;
import android.content.Context;
import android.content.res.Resources;
import android.net.NetworkConfig;
import android.telephony.Rlog;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.SparseIntArray;
import com.android.internal.telephony.DctConstants;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DcAsyncChannel;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ApnContext {
    public final String LOG_TAG;
    protected static final boolean DBG = false;
    private final Context mContext;
    private final String mApnType;
    private DctConstants.State mState;
    private ArrayList<ApnSetting> mWaitingApns = null;
    private ArrayList<ApnSetting> mOriginalWaitingApns = null;
    public final int priority;
    private AtomicInteger mWaitingApnsPermanentFailureCountDown;
    private ApnSetting mApnSetting;
    DcAsyncChannel mDcAc;
    String mReason;
    PendingIntent mReconnectAlarmIntent;
    AtomicBoolean mDataEnabled;
    private final Object mRefCountLock = new Object();
    private int mRefCount = 0;
    AtomicBoolean mDependencyMet;
    private final DcTrackerBase mDcTracker;
    private boolean mConcurrentVoiceAndDataAllowed;
    private final ArrayList<LocalLog> mLocalLogs = new ArrayList();
    private final SparseIntArray mRetriesLeftPerErrorCode = new SparseIntArray();

    public ApnContext(Context context, String apnType, String logTag, NetworkConfig config, DcTrackerBase tracker) {
        this.mContext = context;
        this.mApnType = apnType;
        this.mState = DctConstants.State.IDLE;
        this.setReason("dataEnabled");
        this.mDataEnabled = new AtomicBoolean(false);
        this.mDependencyMet = new AtomicBoolean(config.dependencyMet);
        this.mWaitingApnsPermanentFailureCountDown = new AtomicInteger(0);
        this.priority = config.priority;
        this.LOG_TAG = logTag;
        this.mDcTracker = tracker;
    }

    public String getApnType() {
        return this.mApnType;
    }

    public synchronized DcAsyncChannel getDcAc() {
        return this.mDcAc;
    }

    public synchronized void setDataConnectionAc(DcAsyncChannel dcac) {
        this.mDcAc = dcac;
    }

    public synchronized void releaseDataConnection(String reason) {
        if (this.mDcAc != null) {
            this.mDcAc.tearDown(this, reason, null);
            this.mDcAc = null;
        }
        this.setState(DctConstants.State.IDLE);
    }

    public synchronized PendingIntent getReconnectIntent() {
        return this.mReconnectAlarmIntent;
    }

    public synchronized void setReconnectIntent(PendingIntent intent) {
        this.mReconnectAlarmIntent = intent;
    }

    public synchronized ApnSetting getApnSetting() {
        return this.mApnSetting;
    }

    public synchronized void setApnSetting(ApnSetting apnSetting) {
        this.mApnSetting = apnSetting;
    }

    public synchronized void setWaitingApns(ArrayList<ApnSetting> waitingApns) {
        this.mWaitingApns = waitingApns;
        this.mOriginalWaitingApns = new ArrayList<ApnSetting>(waitingApns);
        this.mWaitingApnsPermanentFailureCountDown.set(this.mWaitingApns.size());
    }

    public int getWaitingApnsPermFailCount() {
        return this.mWaitingApnsPermanentFailureCountDown.get();
    }

    public void decWaitingApnsPermFailCount() {
        this.mWaitingApnsPermanentFailureCountDown.decrementAndGet();
    }

    public synchronized ApnSetting getNextWaitingApn() {
        ArrayList<ApnSetting> list = this.mWaitingApns;
        ApnSetting apn = null;
        if (list != null && !list.isEmpty()) {
            apn = list.get(0);
        }
        return apn;
    }

    public synchronized void removeWaitingApn(ApnSetting apn) {
        if (this.mWaitingApns != null) {
            this.mWaitingApns.remove(apn);
        }
    }

    public synchronized ArrayList<ApnSetting> getOriginalWaitingApns() {
        return this.mOriginalWaitingApns;
    }

    public synchronized ArrayList<ApnSetting> getWaitingApns() {
        return this.mWaitingApns;
    }

    public synchronized void setConcurrentVoiceAndDataAllowed(boolean allowed) {
        this.mConcurrentVoiceAndDataAllowed = allowed;
    }

    public synchronized boolean isConcurrentVoiceAndDataAllowed() {
        return this.mConcurrentVoiceAndDataAllowed;
    }

    public synchronized void setState(DctConstants.State s) {
        this.mState = s;
        if (this.mState == DctConstants.State.FAILED && this.mWaitingApns != null) {
            this.mWaitingApns.clear();
        }
    }

    public synchronized DctConstants.State getState() {
        return this.mState;
    }

    public boolean isDisconnected() {
        DctConstants.State currentState = this.getState();
        return currentState == DctConstants.State.IDLE || currentState == DctConstants.State.FAILED;
    }

    public synchronized void setReason(String reason) {
        this.mReason = reason;
    }

    public synchronized String getReason() {
        return this.mReason;
    }

    public boolean isReady() {
        return this.mDataEnabled.get() && this.mDependencyMet.get();
    }

    public boolean isConnectable() {
        return this.isReady() && (this.mState == DctConstants.State.IDLE || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING || this.mState == DctConstants.State.FAILED);
    }

    public boolean isConnectedOrConnecting() {
        return this.isReady() && (this.mState == DctConstants.State.CONNECTED || this.mState == DctConstants.State.CONNECTING || this.mState == DctConstants.State.SCANNING || this.mState == DctConstants.State.RETRYING);
    }

    public void setEnabled(boolean enabled) {
        this.mDataEnabled.set(enabled);
    }

    public boolean isEnabled() {
        return this.mDataEnabled.get();
    }

    public void setDependencyMet(boolean met) {
        this.mDependencyMet.set(met);
    }

    public boolean getDependencyMet() {
        return this.mDependencyMet.get();
    }

    public boolean isProvisioningApn() {
        String provisioningApn = this.mContext.getResources().getString(17039406);
        if (!TextUtils.isEmpty(provisioningApn) && this.mApnSetting != null && this.mApnSetting.apn != null) {
            return this.mApnSetting.apn.equals(provisioningApn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestLog(String str) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            for (LocalLog l : this.mLocalLogs) {
                l.log(str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incRefCount(LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (this.mRefCount == 0) {
                this.requestLog("clearing log with size=" + this.mLocalLogs.size());
                this.mLocalLogs.clear();
            }
            if (this.mLocalLogs.contains(log)) {
                log.log("ApnContext.incRefCount has duplicate add - " + this.mRefCount);
            } else {
                this.mLocalLogs.add(log);
                log.log("ApnContext.incRefCount - " + this.mRefCount);
            }
            if (this.mRefCount++ == 0) {
                this.mDcTracker.setEnabled(this.mDcTracker.apnTypeToId(this.mApnType), true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decRefCount(LocalLog log) {
        Object object = this.mRefCountLock;
        synchronized (object) {
            if (this.mRefCount != 1) {
                if (this.mLocalLogs.remove(log)) {
                    log.log("ApnContext.decRefCount - " + this.mRefCount);
                } else {
                    log.log("ApnContext.decRefCount didn't find log - " + this.mRefCount);
                }
            } else {
                log.log("ApnContext.decRefCount - 1");
            }
            if (this.mRefCount-- == 1) {
                this.mDcTracker.setEnabled(this.mDcTracker.apnTypeToId(this.mApnType), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetErrorCodeRetries() {
        this.requestLog("ApnContext.resetErrorCodeRetries");
        String[] config = Resources.getSystem().getStringArray(17236036);
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            this.mRetriesLeftPerErrorCode.clear();
            for (String c : config) {
                String[] errorValue = c.split(",");
                if (errorValue != null && errorValue.length == 2) {
                    int count = 0;
                    int errorCode = 0;
                    try {
                        errorCode = Integer.parseInt(errorValue[0]);
                        count = Integer.parseInt(errorValue[1]);
                    }
                    catch (NumberFormatException e) {
                        this.log("Exception parsing config_retries_per_error_code: " + e);
                        continue;
                    }
                    if (count <= 0 || errorCode <= 0) continue;
                    this.mRetriesLeftPerErrorCode.put(errorCode, count);
                    continue;
                }
                this.log("Exception parsing config_retries_per_error_code: " + c);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean restartOnError(int errorCode) {
        boolean result = false;
        int retriesLeft = 0;
        SparseIntArray sparseIntArray = this.mRetriesLeftPerErrorCode;
        synchronized (sparseIntArray) {
            retriesLeft = this.mRetriesLeftPerErrorCode.get(errorCode);
            switch (retriesLeft) {
                case 0: {
                    break;
                }
                case 1: {
                    this.resetErrorCodeRetries();
                    result = true;
                    break;
                }
                default: {
                    this.mRetriesLeftPerErrorCode.put(errorCode, retriesLeft - 1);
                    result = false;
                }
            }
        }
        String str = "ApnContext.restartOnError(" + errorCode + ") found " + retriesLeft + " and returned " + result;
        this.requestLog(str);
        return result;
    }

    public synchronized String toString() {
        return "{mApnType=" + this.mApnType + " mState=" + (Object)((Object)this.getState()) + " mWaitingApns={" + this.mWaitingApns + "} mWaitingApnsPermanentFailureCountDown=" + this.mWaitingApnsPermanentFailureCountDown + " mApnSetting={" + this.mApnSetting + "} mReason=" + this.mReason + " mDataEnabled=" + this.mDataEnabled + " mDependencyMet=" + this.mDependencyMet + "}";
    }

    private void log(String s) {
        Rlog.d(this.LOG_TAG, "[ApnContext:" + this.mApnType + "] " + s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(FileDescriptor fd, PrintWriter printWriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printWriter, "  ");
        Object object = this.mRefCountLock;
        synchronized (object) {
            pw.println(this.toString());
            if (this.mRefCount > 0) {
                pw.increaseIndent();
                for (LocalLog l : this.mLocalLogs) {
                    l.dump(fd, pw, args);
                }
                pw.decreaseIndent();
            }
        }
    }
}

