/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.ProxyInfo;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.dataconnection.ApnContext;
import com.android.internal.telephony.dataconnection.ApnSetting;
import com.android.internal.telephony.dataconnection.DataConnection;
import com.android.internal.util.AsyncChannel;

public class DcAsyncChannel
extends AsyncChannel {
    private static final boolean DBG = false;
    private String mLogTag;
    private DataConnection mDc;
    private long mDcThreadId;
    public static final int BASE = 266240;
    public static final int REQ_IS_INACTIVE = 266240;
    public static final int RSP_IS_INACTIVE = 266241;
    public static final int REQ_GET_CID = 266242;
    public static final int RSP_GET_CID = 266243;
    public static final int REQ_GET_APNSETTING = 266244;
    public static final int RSP_GET_APNSETTING = 266245;
    public static final int REQ_GET_LINK_PROPERTIES = 266246;
    public static final int RSP_GET_LINK_PROPERTIES = 266247;
    public static final int REQ_SET_LINK_PROPERTIES_HTTP_PROXY = 266248;
    public static final int RSP_SET_LINK_PROPERTIES_HTTP_PROXY = 266249;
    public static final int REQ_GET_NETWORK_CAPABILITIES = 266250;
    public static final int RSP_GET_NETWORK_CAPABILITIES = 266251;
    public static final int REQ_RESET = 266252;
    public static final int RSP_RESET = 266253;
    private static final int CMD_TO_STRING_COUNT = 14;
    private static String[] sCmdToString = new String[14];

    protected static String cmdToString(int cmd) {
        if ((cmd -= 266240) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return AsyncChannel.cmdToString(cmd + 266240);
    }

    public DcAsyncChannel(DataConnection dc, String logTag) {
        this.mDc = dc;
        this.mDcThreadId = this.mDc.getHandler().getLooper().getThread().getId();
        this.mLogTag = logTag;
    }

    public void reqIsInactive() {
        this.sendMessage(266240);
    }

    public boolean rspIsInactive(Message response) {
        boolean retVal = response.arg1 == 1;
        return retVal;
    }

    public boolean isInactiveSync() {
        boolean value;
        if (this.isCallerOnDifferentThread()) {
            Message response = this.sendMessageSynchronously(266240);
            if (response != null && response.what == 266241) {
                value = this.rspIsInactive(response);
            } else {
                this.log("rspIsInactive error response=" + response);
                value = false;
            }
        } else {
            value = this.mDc.getIsInactive();
        }
        return value;
    }

    public void reqCid() {
        this.sendMessage(266242);
    }

    public int rspCid(Message response) {
        int retVal = response.arg1;
        return retVal;
    }

    public int getCidSync() {
        int value;
        if (this.isCallerOnDifferentThread()) {
            Message response = this.sendMessageSynchronously(266242);
            if (response != null && response.what == 266243) {
                value = this.rspCid(response);
            } else {
                this.log("rspCid error response=" + response);
                value = -1;
            }
        } else {
            value = this.mDc.getCid();
        }
        return value;
    }

    public void reqApnSetting() {
        this.sendMessage(266244);
    }

    public ApnSetting rspApnSetting(Message response) {
        ApnSetting retVal = (ApnSetting)response.obj;
        return retVal;
    }

    public ApnSetting getApnSettingSync() {
        ApnSetting value;
        if (this.isCallerOnDifferentThread()) {
            Message response = this.sendMessageSynchronously(266244);
            if (response != null && response.what == 266245) {
                value = this.rspApnSetting(response);
            } else {
                this.log("getApnSetting error response=" + response);
                value = null;
            }
        } else {
            value = this.mDc.getApnSetting();
        }
        return value;
    }

    public void reqLinkProperties() {
        this.sendMessage(266246);
    }

    public LinkProperties rspLinkProperties(Message response) {
        LinkProperties retVal = (LinkProperties)response.obj;
        return retVal;
    }

    public LinkProperties getLinkPropertiesSync() {
        LinkProperties value;
        if (this.isCallerOnDifferentThread()) {
            Message response = this.sendMessageSynchronously(266246);
            if (response != null && response.what == 266247) {
                value = this.rspLinkProperties(response);
            } else {
                this.log("getLinkProperties error response=" + response);
                value = null;
            }
        } else {
            value = this.mDc.getCopyLinkProperties();
        }
        return value;
    }

    public void reqSetLinkPropertiesHttpProxy(ProxyInfo proxy) {
        this.sendMessage(266248, proxy);
    }

    public void setLinkPropertiesHttpProxySync(ProxyInfo proxy) {
        if (this.isCallerOnDifferentThread()) {
            Message response = this.sendMessageSynchronously(266248, proxy);
            if (response == null || response.what != 266249) {
                this.log("setLinkPropertiesHttpPoxy error response=" + response);
            }
        } else {
            this.mDc.setLinkPropertiesHttpProxy(proxy);
        }
    }

    public void reqNetworkCapabilities() {
        this.sendMessage(266250);
    }

    public NetworkCapabilities rspNetworkCapabilities(Message response) {
        NetworkCapabilities retVal = (NetworkCapabilities)response.obj;
        return retVal;
    }

    public NetworkCapabilities getNetworkCapabilitiesSync() {
        Message response;
        NetworkCapabilities value = this.isCallerOnDifferentThread() ? ((response = this.sendMessageSynchronously(266250)) != null && response.what == 266251 ? this.rspNetworkCapabilities(response) : null) : this.mDc.getCopyNetworkCapabilities();
        return value;
    }

    public void reqReset() {
        this.sendMessage(266252);
    }

    public void bringUp(ApnContext apnContext, int initialMaxRetry, int profileId, int rilRadioTechnology, boolean retryWhenSSChange, Message onCompletedMsg) {
        this.sendMessage(262144, new DataConnection.ConnectionParams(apnContext, initialMaxRetry, profileId, rilRadioTechnology, retryWhenSSChange, onCompletedMsg));
    }

    public void tearDown(ApnContext apnContext, String reason, Message onCompletedMsg) {
        this.sendMessage(262148, new DataConnection.DisconnectParams(apnContext, reason, onCompletedMsg));
    }

    public void tearDownAll(String reason, Message onCompletedMsg) {
        this.sendMessage(262150, new DataConnection.DisconnectParams(null, reason, onCompletedMsg));
    }

    public int getDataConnectionIdSync() {
        return this.mDc.getDataConnectionId();
    }

    public String toString() {
        return this.mDc.getName();
    }

    private boolean isCallerOnDifferentThread() {
        long curThreadId = Thread.currentThread().getId();
        boolean value = this.mDcThreadId != curThreadId;
        return value;
    }

    private void log(String s) {
        Rlog.d(this.mLogTag, "DataConnectionAc " + s);
    }

    public String[] getPcscfAddr() {
        return this.mDc.mPcscfAddr;
    }

    static {
        DcAsyncChannel.sCmdToString[0] = "REQ_IS_INACTIVE";
        DcAsyncChannel.sCmdToString[1] = "RSP_IS_INACTIVE";
        DcAsyncChannel.sCmdToString[2] = "REQ_GET_CID";
        DcAsyncChannel.sCmdToString[3] = "RSP_GET_CID";
        DcAsyncChannel.sCmdToString[4] = "REQ_GET_APNSETTING";
        DcAsyncChannel.sCmdToString[5] = "RSP_GET_APNSETTING";
        DcAsyncChannel.sCmdToString[6] = "REQ_GET_LINK_PROPERTIES";
        DcAsyncChannel.sCmdToString[7] = "RSP_GET_LINK_PROPERTIES";
        DcAsyncChannel.sCmdToString[8] = "REQ_SET_LINK_PROPERTIES_HTTP_PROXY";
        DcAsyncChannel.sCmdToString[9] = "RSP_SET_LINK_PROPERTIES_HTTP_PROXY";
        DcAsyncChannel.sCmdToString[10] = "REQ_GET_NETWORK_CAPABILITIES";
        DcAsyncChannel.sCmdToString[11] = "RSP_GET_NETWORK_CAPABILITIES";
        DcAsyncChannel.sCmdToString[12] = "REQ_RESET";
        DcAsyncChannel.sCmdToString[13] = "RSP_RESET";
    }

    public static enum LinkPropertyChangeAction {
        NONE,
        CHANGED,
        RESET;


        public static LinkPropertyChangeAction fromInt(int value) {
            if (value == NONE.ordinal()) {
                return NONE;
            }
            if (value == CHANGED.ordinal()) {
                return CHANGED;
            }
            if (value == RESET.ordinal()) {
                return RESET;
            }
            throw new RuntimeException("LinkPropertyChangeAction.fromInt: bad value=" + value);
        }
    }
}

