/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.net.NetworkRequest;
import android.os.Message;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.dataconnection.DcSwitchStateMachine;
import com.android.internal.util.AsyncChannel;

public class DcSwitchAsyncChannel
extends AsyncChannel {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "DcSwitchAsyncChannel";
    private int tagId = 0;
    private DcSwitchStateMachine mDcSwitchState;
    private static final int BASE = 278528;
    static final int REQ_CONNECT = 278528;
    static final int REQ_RETRY_CONNECT = 278529;
    static final int REQ_DISCONNECT_ALL = 278530;
    static final int REQ_IS_IDLE_STATE = 278531;
    static final int RSP_IS_IDLE_STATE = 278532;
    static final int REQ_IS_IDLE_OR_DETACHING_STATE = 278533;
    static final int RSP_IS_IDLE_OR_DETACHING_STATE = 278534;
    static final int EVENT_DATA_ATTACHED = 278535;
    static final int EVENT_DATA_DETACHED = 278536;
    static final int EVENT_EMERGENCY_CALL_STARTED = 278537;
    static final int EVENT_EMERGENCY_CALL_ENDED = 278538;
    private static final int CMD_TO_STRING_COUNT = 11;
    private static String[] sCmdToString = new String[11];

    protected static String cmdToString(int cmd) {
        if ((cmd -= 278528) >= 0 && cmd < sCmdToString.length) {
            return sCmdToString[cmd];
        }
        return AsyncChannel.cmdToString(cmd + 278528);
    }

    public DcSwitchAsyncChannel(DcSwitchStateMachine dcSwitchState, int id2) {
        this.mDcSwitchState = dcSwitchState;
        this.tagId = id2;
    }

    public int connect(RequestInfo apnRequest) {
        this.sendMessage(278528, apnRequest);
        return 1;
    }

    public void retryConnect() {
        this.sendMessage(278529);
    }

    public int disconnectAll() {
        this.sendMessage(278530);
        return 1;
    }

    public void notifyDataAttached() {
        this.sendMessage(278535);
    }

    public void notifyDataDetached() {
        this.sendMessage(278536);
    }

    public void notifyEmergencyCallToggled(int start) {
        if (start != 0) {
            this.sendMessage(278537);
        } else {
            this.sendMessage(278538);
        }
    }

    private boolean rspIsIdle(Message response) {
        boolean retVal = response.arg1 == 1;
        this.log("rspIsIdle=" + retVal);
        return retVal;
    }

    public boolean isIdleSync() {
        Message response = this.sendMessageSynchronously(278531);
        if (response != null && response.what == 278532) {
            return this.rspIsIdle(response);
        }
        this.log("rspIsIndle error response=" + response);
        return false;
    }

    public void reqIsIdleOrDetaching() {
        this.sendMessage(278533);
        this.log("reqIsIdleOrDetaching");
    }

    public boolean rspIsIdleOrDetaching(Message response) {
        boolean retVal = response.arg1 == 1;
        this.log("rspIsIdleOrDetaching=" + retVal);
        return retVal;
    }

    public boolean isIdleOrDetachingSync() {
        Message response = this.sendMessageSynchronously(278533);
        if (response != null && response.what == 278534) {
            return this.rspIsIdleOrDetaching(response);
        }
        this.log("rspIsIdleOrDetaching error response=" + response);
        return false;
    }

    public String toString() {
        return this.mDcSwitchState.getName();
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, "[DcSwitchAsyncChannel-" + this.tagId + "]: " + s);
    }

    static {
        DcSwitchAsyncChannel.sCmdToString[0] = "REQ_CONNECT";
        DcSwitchAsyncChannel.sCmdToString[1] = "REQ_RETRY_CONNECT";
        DcSwitchAsyncChannel.sCmdToString[2] = "REQ_DISCONNECT_ALL";
        DcSwitchAsyncChannel.sCmdToString[3] = "REQ_IS_IDLE_STATE";
        DcSwitchAsyncChannel.sCmdToString[4] = "RSP_IS_IDLE_STATE";
        DcSwitchAsyncChannel.sCmdToString[5] = "REQ_IS_IDLE_OR_DETACHING_STATE";
        DcSwitchAsyncChannel.sCmdToString[6] = "RSP_IS_IDLE_OR_DETACHING_STATE";
        DcSwitchAsyncChannel.sCmdToString[7] = "EVENT_DATA_ATTACHED";
        DcSwitchAsyncChannel.sCmdToString[8] = "EVENT_DATA_DETACHED";
        DcSwitchAsyncChannel.sCmdToString[9] = "EVENT_EMERGENCY_CALL_STARTED";
        DcSwitchAsyncChannel.sCmdToString[10] = "EVENT_EMERGENCY_CALL_ENDED";
    }

    public static class RequestInfo {
        boolean executed;
        final NetworkRequest request;
        final int priority;
        final int phoneId;
        private final LocalLog requestLog;

        public RequestInfo(NetworkRequest request, int priority, LocalLog l, int phoneId) {
            this.request = request;
            this.priority = priority;
            this.requestLog = l;
            this.executed = false;
            this.phoneId = phoneId;
        }

        public void log(String str) {
            this.requestLog.log(str);
        }

        public LocalLog getLog() {
            return this.requestLog;
        }

        public String toString() {
            return "[ request=" + this.request + ", executed=" + this.executed + ", priority=" + this.priority + ", phoneId=" + this.phoneId + "]";
        }
    }
}

