/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.os.AsyncResult;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.dataconnection.DcSwitchAsyncChannel;
import com.android.internal.telephony.dataconnection.DctController;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IState;
import com.android.internal.util.State;
import com.android.internal.util.StateMachine;

public class DcSwitchStateMachine
extends StateMachine {
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final String LOG_TAG = "DcSwitchSM";
    private static final int BASE = 274432;
    private static final int EVENT_CONNECTED = 274432;
    private static final int EVENT_DATA_ALLOWED = 274433;
    private static final int CMD_RETRY_ATTACH = 274434;
    private static final int EVENT_DATA_DISALLOWED = 274435;
    private int mId;
    private Phone mPhone;
    private AsyncChannel mAc;
    private IdleState mIdleState = new IdleState();
    private EmergencyState mEmergencyState = new EmergencyState();
    private AttachingState mAttachingState = new AttachingState();
    private AttachedState mAttachedState = new AttachedState();
    private DetachingState mDetachingState = new DetachingState();
    private DefaultState mDefaultState = new DefaultState();
    private IState mPreEmergencyState;

    protected DcSwitchStateMachine(Phone phone, String name, int id2) {
        super(name);
        this.log("DcSwitchState constructor E");
        this.mPhone = phone;
        this.mId = id2;
        this.addState(this.mDefaultState);
        this.addState(this.mIdleState, this.mDefaultState);
        this.addState(this.mEmergencyState, this.mDefaultState);
        this.addState(this.mAttachingState, this.mDefaultState);
        this.addState(this.mAttachedState, this.mDefaultState);
        this.addState(this.mDetachingState, this.mDefaultState);
        this.setInitialState(this.mIdleState);
        this.log("DcSwitchState constructor X");
    }

    @Override
    protected void log(String s) {
        Rlog.d(LOG_TAG, "[" + this.getName() + "] " + s);
    }

    private class DefaultState
    extends State {
        private DefaultState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            switch (msg.what) {
                case 69633: {
                    if (DcSwitchStateMachine.this.mAc != null) {
                        DcSwitchStateMachine.this.mAc.replyToMessage(msg, 69634, 3);
                        break;
                    }
                    DcSwitchStateMachine.this.mAc = new AsyncChannel();
                    DcSwitchStateMachine.this.mAc.connected(null, DcSwitchStateMachine.this.getHandler(), msg.replyTo);
                    DcSwitchStateMachine.this.mAc.replyToMessage(msg, 69634, 0, DcSwitchStateMachine.this.mId, "hi");
                    break;
                }
                case 69635: {
                    DcSwitchStateMachine.this.mAc.disconnect();
                    break;
                }
                case 69636: {
                    DcSwitchStateMachine.this.mAc = null;
                    break;
                }
                case 278531: {
                    boolean val = DcSwitchStateMachine.this.getCurrentState() == DcSwitchStateMachine.this.mIdleState;
                    DcSwitchStateMachine.this.mAc.replyToMessage(msg, 278532, val ? 1 : 0);
                    break;
                }
                case 278533: {
                    boolean val = DcSwitchStateMachine.this.getCurrentState() == DcSwitchStateMachine.this.mIdleState || DcSwitchStateMachine.this.getCurrentState() == DcSwitchStateMachine.this.mDetachingState;
                    DcSwitchStateMachine.this.mAc.replyToMessage(msg, 278534, val ? 1 : 0);
                    break;
                }
                case 278537: {
                    DcSwitchStateMachine.this.mPreEmergencyState = DcSwitchStateMachine.this.getCurrentState();
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mEmergencyState);
                    break;
                }
                default: {
                    DcSwitchStateMachine.this.log("DefaultState: shouldn't happen but ignore msg.what=0x" + Integer.toHexString(msg.what));
                }
            }
            return true;
        }
    }

    private class DetachingState
    extends State {
        private int mCurrentDisallowedSequence = 0;

        private DetachingState() {
        }

        @Override
        public void enter() {
            DcSwitchStateMachine.this.log("DetachingState: enter");
            PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchStateMachine.this.mPhone).getActivePhone();
            pb.mCi.setDataAllowed(false, DcSwitchStateMachine.this.obtainMessage(274435, ++this.mCurrentDisallowedSequence, 0));
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 278528: {
                    DcSwitchAsyncChannel.RequestInfo apnRequest = (DcSwitchAsyncChannel.RequestInfo)msg.obj;
                    apnRequest.log("DcSwitchStateMachine.DetachingState: REQ_CONNECT");
                    DcSwitchStateMachine.this.log("DetachingState: REQ_CONNECT, apnRequest=" + apnRequest);
                    DcSwitchStateMachine.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                case 278536: {
                    DcSwitchStateMachine.this.log("DetachingState: EVENT_DATA_DETACHED");
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mIdleState);
                    retVal = true;
                    break;
                }
                case 274435: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (this.mCurrentDisallowedSequence != msg.arg1) {
                        DcSwitchStateMachine.this.loge("EVENT_DATA_DISALLOWED ignored arg1=" + msg.arg1 + ", seq=" + this.mCurrentDisallowedSequence);
                    } else if (ar.exception != null) {
                        DcSwitchStateMachine.this.loge("EVENT_DATA_DISALLOWED failed, " + ar.exception);
                        DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mAttachedState);
                    }
                    retVal = true;
                    break;
                }
                case 278530: {
                    DcSwitchStateMachine.this.log("DetachingState: REQ_DISCONNECT_ALL, already detaching");
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class AttachedState
    extends State {
        private AttachedState() {
        }

        @Override
        public void enter() {
            DcSwitchStateMachine.this.log("AttachedState: enter");
            DctController.getInstance().executeAllRequests(DcSwitchStateMachine.this.mId);
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 278528: {
                    DcSwitchAsyncChannel.RequestInfo apnRequest = (DcSwitchAsyncChannel.RequestInfo)msg.obj;
                    apnRequest.log("DcSwitchStateMachine.AttachedState: REQ_CONNECT");
                    DcSwitchStateMachine.this.log("AttachedState: REQ_CONNECT, apnRequest=" + apnRequest);
                    DctController.getInstance().executeRequest(apnRequest);
                    retVal = true;
                    break;
                }
                case 278530: {
                    DcSwitchStateMachine.this.log("AttachedState: REQ_DISCONNECT_ALL");
                    DctController.getInstance().releaseAllRequests(DcSwitchStateMachine.this.mId);
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mDetachingState);
                    retVal = true;
                    break;
                }
                case 278536: {
                    DcSwitchStateMachine.this.log("AttachedState: EVENT_DATA_DETACHED");
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mAttachingState);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class AttachingState
    extends State {
        private int mCurrentAllowedSequence = 0;

        private AttachingState() {
        }

        @Override
        public void enter() {
            DcSwitchStateMachine.this.log("AttachingState: enter");
            this.doEnter();
        }

        private void doEnter() {
            PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchStateMachine.this.mPhone).getActivePhone();
            pb.mCi.setDataAllowed(true, DcSwitchStateMachine.this.obtainMessage(274433, ++this.mCurrentAllowedSequence, 0));
            if (pb.mDcTracker.getAutoAttachOnCreation()) {
                DcSwitchStateMachine.this.log("AttachingState executeAll due to autoAttach");
                DctController.getInstance().executeAllRequests(DcSwitchStateMachine.this.mId);
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 278528: {
                    DcSwitchAsyncChannel.RequestInfo apnRequest = (DcSwitchAsyncChannel.RequestInfo)msg.obj;
                    apnRequest.log("DcSwitchStateMachine.AttachingState: REQ_CONNECT");
                    DcSwitchStateMachine.this.log("AttachingState: REQ_CONNECT, apnRequest=" + apnRequest);
                    PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchStateMachine.this.mPhone).getActivePhone();
                    if (pb.mDcTracker.getAutoAttachOnCreation()) {
                        apnRequest.log("DcSwitchStateMachine processing due to autoAttach");
                        DctController.getInstance().executeRequest(apnRequest);
                    }
                    retVal = true;
                    break;
                }
                case 274433: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (this.mCurrentAllowedSequence != msg.arg1) {
                        DcSwitchStateMachine.this.loge("EVENT_DATA_ALLOWED ignored arg1=" + msg.arg1 + ", seq=" + this.mCurrentAllowedSequence);
                    } else if (ar.exception != null) {
                        CommandException e;
                        if (ar.exception instanceof CommandException && (e = (CommandException)ar.exception).getCommandError() == CommandException.Error.REQUEST_NOT_SUPPORTED) {
                            retVal = true;
                            break;
                        }
                        DcSwitchStateMachine.this.loge("EVENT_DATA_ALLOWED failed, " + ar.exception);
                        DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mIdleState);
                    }
                    retVal = true;
                    break;
                }
                case 278529: {
                    DcSwitchStateMachine.this.log("AttachingState going to retry");
                    this.doEnter();
                    retVal = true;
                    break;
                }
                case 278535: {
                    DcSwitchStateMachine.this.log("AttachingState: EVENT_DATA_ATTACHED");
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mAttachedState);
                    retVal = true;
                    break;
                }
                case 278530: {
                    DcSwitchStateMachine.this.log("AttachingState: REQ_DISCONNECT_ALL");
                    PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchStateMachine.this.mPhone).getActivePhone();
                    if (pb.mDcTracker.getAutoAttachOnCreation()) {
                        DcSwitchStateMachine.this.log("releasingAll due to autoAttach");
                        DctController.getInstance().releaseAllRequests(DcSwitchStateMachine.this.mId);
                    }
                    DcSwitchStateMachine.this.deferMessage(msg);
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }

    private class EmergencyState
    extends State {
        private EmergencyState() {
        }

        @Override
        public boolean processMessage(Message msg) {
            PhoneBase pb = (PhoneBase)((PhoneProxy)DcSwitchStateMachine.this.mPhone).getActivePhone();
            if (!pb.mDcTracker.isEmergency()) {
                DcSwitchStateMachine.this.loge("EmergencyState: isEmergency() is false. deferMessage msg.what=0x" + Integer.toHexString(msg.what));
                DcSwitchStateMachine.this.deferMessage(msg);
                DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mPreEmergencyState);
                return true;
            }
            switch (msg.what) {
                case 278538: {
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mPreEmergencyState);
                    break;
                }
                case 278537: {
                    DcSwitchStateMachine.this.loge("EmergencyState: ignoring EVENT_EMERGENCY_CALL_STARTED");
                    break;
                }
                case 278528: 
                case 278529: 
                case 278530: 
                case 278535: 
                case 278536: {
                    DcSwitchStateMachine.this.log("EmergencyState: deferMessage msg.what=0x" + Integer.toHexString(msg.what));
                    DcSwitchStateMachine.this.deferMessage(msg);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
    }

    private class IdleState
    extends State {
        private IdleState() {
        }

        @Override
        public void enter() {
            DcSwitchStateMachine.this.log("IdleState: enter");
            try {
                DctController.getInstance().processRequests();
            }
            catch (RuntimeException e) {
                DcSwitchStateMachine.this.loge("DctController is not ready");
            }
        }

        @Override
        public boolean processMessage(Message msg) {
            boolean retVal;
            switch (msg.what) {
                case 278528: {
                    DcSwitchAsyncChannel.RequestInfo apnRequest = (DcSwitchAsyncChannel.RequestInfo)msg.obj;
                    apnRequest.log("DcSwitchStateMachine.IdleState: REQ_CONNECT");
                    DcSwitchStateMachine.this.log("IdleState: REQ_CONNECT, apnRequest=" + apnRequest);
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mAttachingState);
                    retVal = true;
                    break;
                }
                case 278530: {
                    DcSwitchStateMachine.this.log("AttachingState: REQ_DISCONNECT_ALL");
                    DctController.getInstance().releaseAllRequests(DcSwitchStateMachine.this.mId);
                    retVal = true;
                    break;
                }
                case 278535: {
                    DcSwitchStateMachine.this.log("AttachingState: EVENT_DATA_ATTACHED");
                    DcSwitchStateMachine.this.transitionTo(DcSwitchStateMachine.this.mAttachedState);
                    retVal = true;
                    break;
                }
                case 274432: {
                    DcSwitchStateMachine.this.log("IdleState: Receive invalid event EVENT_CONNECTED!");
                    retVal = true;
                    break;
                }
                default: {
                    retVal = false;
                }
            }
            return retVal;
        }
    }
}

