/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.dataconnection;

import android.content.Context;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.util.LocalLog;
import android.util.SparseArray;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcSwitchAsyncChannel;
import com.android.internal.telephony.dataconnection.DcSwitchStateMachine;
import com.android.internal.telephony.dataconnection.DcTrackerBase;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DctController
extends Handler {
    private static final String LOG_TAG = "DctController";
    private static final boolean DBG = true;
    private static final int EVENT_PROCESS_REQUESTS = 100;
    private static final int EVENT_EXECUTE_REQUEST = 101;
    private static final int EVENT_EXECUTE_ALL_REQUESTS = 102;
    private static final int EVENT_RELEASE_REQUEST = 103;
    private static final int EVENT_RELEASE_ALL_REQUESTS = 104;
    private static final int EVENT_RETRY_ATTACH = 105;
    private static final int EVENT_SETTINGS_CHANGED = 106;
    private static final int EVENT_SUBSCRIPTIONS_CHANGED = 107;
    private static final int EVENT_DATA_ATTACHED = 500;
    private static final int EVENT_DATA_DETACHED = 600;
    private static final int EVENT_EMERGENCY_CALL_TOGGLED = 700;
    private static DctController sDctController;
    private int mPhoneNum;
    private PhoneProxy[] mPhones;
    private DcSwitchStateMachine[] mDcSwitchStateMachine;
    private DcSwitchAsyncChannel[] mDcSwitchAsyncChannel;
    private Handler[] mDcSwitchStateHandler;
    private HashMap<Integer, DcSwitchAsyncChannel.RequestInfo> mRequestInfos = new HashMap();
    private Context mContext;
    private Messenger[] mNetworkFactoryMessenger;
    private NetworkFactory[] mNetworkFactory;
    private NetworkCapabilities[] mNetworkFilter;
    private SubscriptionController mSubController = SubscriptionController.getInstance();
    private SubscriptionManager mSubMgr;
    private SubscriptionManager.OnSubscriptionsChangedListener mOnSubscriptionsChangedListener = new SubscriptionManager.OnSubscriptionsChangedListener(){

        @Override
        public void onSubscriptionsChanged() {
            DctController.this.obtainMessage(107).sendToTarget();
        }
    };
    private ContentObserver mObserver = new ContentObserver(new Handler()){

        @Override
        public void onChange(boolean selfChange) {
            DctController.logd("Settings change");
            DctController.this.obtainMessage(106).sendToTarget();
        }
    };
    private Handler mRspHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            if (msg.what >= 700) {
                DctController.logd("EVENT_PHONE" + (msg.what - 700 + 1) + "_EMERGENCY_CALL_END.");
                AsyncResult ar = (AsyncResult)msg.obj;
                Integer toggle = (Integer)ar.result;
                DctController.this.mDcSwitchAsyncChannel[msg.what - 700].notifyEmergencyCallToggled(toggle);
            } else if (msg.what >= 600) {
                DctController.logd("EVENT_PHONE" + (msg.what - 600 + 1) + "_DATA_DETACH.");
                DctController.this.mDcSwitchAsyncChannel[msg.what - 600].notifyDataDetached();
            } else if (msg.what >= 500) {
                DctController.logd("EVENT_PHONE" + (msg.what - 500 + 1) + "_DATA_ATTACH.");
                DctController.this.mDcSwitchAsyncChannel[msg.what - 500].notifyDataAttached();
            }
        }
    };

    public void updatePhoneObject(PhoneProxy phone) {
        if (phone == null) {
            DctController.loge("updatePhoneObject phone = null");
            return;
        }
        PhoneBase phoneBase = (PhoneBase)phone.getActivePhone();
        if (phoneBase == null) {
            DctController.loge("updatePhoneObject phoneBase = null");
            return;
        }
        for (int i = 0; i < this.mPhoneNum; ++i) {
            if (this.mPhones[i] != phone) continue;
            this.updatePhoneBaseForIndex(i, phoneBase);
            break;
        }
    }

    private void updatePhoneBaseForIndex(int index, PhoneBase phoneBase) {
        DctController.logd("updatePhoneBaseForIndex for phone index=" + index);
        phoneBase.getServiceStateTracker().registerForDataConnectionAttached(this.mRspHandler, 500 + index, null);
        phoneBase.getServiceStateTracker().registerForDataConnectionDetached(this.mRspHandler, 600 + index, null);
        phoneBase.registerForEmergencyCallToggle(this.mRspHandler, 700 + index, null);
        ConnectivityManager cm = (ConnectivityManager)this.mPhones[index].getContext().getSystemService("connectivity");
        if (this.mNetworkFactoryMessenger != null) {
            DctController.logd("unregister TelephonyNetworkFactory for phone index=" + index);
            cm.unregisterNetworkFactory(this.mNetworkFactoryMessenger[index]);
            this.mNetworkFactoryMessenger[index] = null;
            this.mNetworkFactory[index] = null;
            this.mNetworkFilter[index] = null;
        }
        this.mNetworkFilter[index] = new NetworkCapabilities();
        this.mNetworkFilter[index].addTransportType(0);
        this.mNetworkFilter[index].addCapability(0);
        this.mNetworkFilter[index].addCapability(1);
        this.mNetworkFilter[index].addCapability(2);
        this.mNetworkFilter[index].addCapability(3);
        this.mNetworkFilter[index].addCapability(4);
        this.mNetworkFilter[index].addCapability(5);
        this.mNetworkFilter[index].addCapability(7);
        this.mNetworkFilter[index].addCapability(8);
        this.mNetworkFilter[index].addCapability(9);
        this.mNetworkFilter[index].addCapability(10);
        this.mNetworkFilter[index].addCapability(13);
        this.mNetworkFilter[index].addCapability(12);
        this.mNetworkFactory[index] = new TelephonyNetworkFactory(this.getLooper(), this.mPhones[index].getContext(), "TelephonyNetworkFactory", phoneBase, this.mNetworkFilter[index]);
        this.mNetworkFactory[index].setScoreFilter(50);
        this.mNetworkFactoryMessenger[index] = new Messenger(this.mNetworkFactory[index]);
        cm.registerNetworkFactory(this.mNetworkFactoryMessenger[index], "Telephony");
    }

    public static DctController getInstance() {
        if (sDctController == null) {
            throw new RuntimeException("DctController.getInstance can't be called before makeDCTController()");
        }
        return sDctController;
    }

    public static DctController makeDctController(PhoneProxy[] phones) {
        if (sDctController == null) {
            DctController.logd("makeDctController: new DctController phones.length=" + phones.length);
            sDctController = new DctController(phones);
        }
        DctController.logd("makeDctController: X sDctController=" + sDctController);
        return sDctController;
    }

    private DctController(PhoneProxy[] phones) {
        DctController.logd("DctController(): phones.length=" + phones.length);
        if (phones == null || phones.length == 0) {
            if (phones == null) {
                DctController.loge("DctController(phones): UNEXPECTED phones=null, ignore");
            } else {
                DctController.loge("DctController(phones): UNEXPECTED phones.length=0, ignore");
            }
            return;
        }
        this.mPhoneNum = phones.length;
        this.mPhones = phones;
        this.mDcSwitchStateMachine = new DcSwitchStateMachine[this.mPhoneNum];
        this.mDcSwitchAsyncChannel = new DcSwitchAsyncChannel[this.mPhoneNum];
        this.mDcSwitchStateHandler = new Handler[this.mPhoneNum];
        this.mNetworkFactoryMessenger = new Messenger[this.mPhoneNum];
        this.mNetworkFactory = new NetworkFactory[this.mPhoneNum];
        this.mNetworkFilter = new NetworkCapabilities[this.mPhoneNum];
        for (int i = 0; i < this.mPhoneNum; ++i) {
            int phoneId = i;
            this.mDcSwitchStateMachine[i] = new DcSwitchStateMachine(this.mPhones[i], "DcSwitchStateMachine-" + phoneId, phoneId);
            this.mDcSwitchStateMachine[i].start();
            this.mDcSwitchAsyncChannel[i] = new DcSwitchAsyncChannel(this.mDcSwitchStateMachine[i], phoneId);
            this.mDcSwitchStateHandler[i] = new Handler();
            int status = this.mDcSwitchAsyncChannel[i].fullyConnectSync(this.mPhones[i].getContext(), this.mDcSwitchStateHandler[i], this.mDcSwitchStateMachine[i].getHandler());
            if (status == 0) {
                DctController.logd("DctController(phones): Connect success: " + i);
            } else {
                DctController.loge("DctController(phones): Could not connect to " + i);
            }
            PhoneBase phoneBase = (PhoneBase)this.mPhones[i].getActivePhone();
            this.updatePhoneBaseForIndex(i, phoneBase);
        }
        this.mContext = this.mPhones[0].getContext();
        this.mSubMgr = SubscriptionManager.from(this.mContext);
        this.mSubMgr.addOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mContext.getContentResolver().registerContentObserver(Settings.Global.getUriFor("multi_sim_data_call"), false, this.mObserver);
    }

    public void dispose() {
        DctController.logd("DctController.dispose");
        for (int i = 0; i < this.mPhoneNum; ++i) {
            ConnectivityManager cm = (ConnectivityManager)this.mPhones[i].getContext().getSystemService("connectivity");
            cm.unregisterNetworkFactory(this.mNetworkFactoryMessenger[i]);
            this.mNetworkFactoryMessenger[i] = null;
        }
        this.mSubMgr.removeOnSubscriptionsChangedListener(this.mOnSubscriptionsChangedListener);
        this.mContext.getContentResolver().unregisterContentObserver(this.mObserver);
    }

    @Override
    public void handleMessage(Message msg) {
        DctController.logd("handleMessage msg=" + msg);
        switch (msg.what) {
            case 100: {
                this.onProcessRequest();
                break;
            }
            case 101: {
                this.onExecuteRequest((DcSwitchAsyncChannel.RequestInfo)msg.obj);
                break;
            }
            case 102: {
                this.onExecuteAllRequests(msg.arg1);
                break;
            }
            case 103: {
                this.onReleaseRequest((DcSwitchAsyncChannel.RequestInfo)msg.obj);
                break;
            }
            case 104: {
                this.onReleaseAllRequests(msg.arg1);
                break;
            }
            case 105: {
                this.onRetryAttach(msg.arg1);
                break;
            }
            case 106: {
                this.onSettingsChanged();
                break;
            }
            case 107: {
                this.onSubInfoReady();
                break;
            }
            default: {
                DctController.loge("Un-handled message [" + msg.what + "]");
            }
        }
    }

    private int requestNetwork(NetworkRequest request, int priority, LocalLog l, int phoneId) {
        DctController.logd("requestNetwork request=" + request + ", priority=" + priority);
        l.log("Dctc.requestNetwork, priority=" + priority);
        DcSwitchAsyncChannel.RequestInfo requestInfo = new DcSwitchAsyncChannel.RequestInfo(request, priority, l, phoneId);
        this.mRequestInfos.put(request.requestId, requestInfo);
        this.processRequests();
        return 1;
    }

    private int releaseNetwork(NetworkRequest request) {
        DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(request.requestId);
        DctController.logd("releaseNetwork request=" + request + ", requestInfo=" + requestInfo);
        if (requestInfo != null) {
            requestInfo.log("DctController.releaseNetwork");
        }
        this.mRequestInfos.remove(request.requestId);
        this.releaseRequest(requestInfo);
        this.processRequests();
        return 1;
    }

    void processRequests() {
        DctController.logd("processRequests");
        this.sendMessage(this.obtainMessage(100));
    }

    void executeRequest(DcSwitchAsyncChannel.RequestInfo request) {
        DctController.logd("executeRequest, request= " + request);
        this.sendMessage(this.obtainMessage(101, request));
    }

    void executeAllRequests(int phoneId) {
        DctController.logd("executeAllRequests, phone:" + phoneId);
        this.sendMessage(this.obtainMessage(102, phoneId, 0));
    }

    void releaseRequest(DcSwitchAsyncChannel.RequestInfo request) {
        DctController.logd("releaseRequest, request= " + request);
        this.sendMessage(this.obtainMessage(103, request));
    }

    void releaseAllRequests(int phoneId) {
        DctController.logd("releaseAllRequests, phone:" + phoneId);
        this.sendMessage(this.obtainMessage(104, phoneId, 0));
    }

    public void retryAttach(int phoneId) {
        DctController.logd("retryAttach, phone:" + phoneId);
        this.sendMessage(this.obtainMessage(105, phoneId, 0));
    }

    private void onProcessRequest() {
        int phoneId = this.getTopPriorityRequestPhoneId();
        int activePhoneId = -1;
        for (int i = 0; i < this.mDcSwitchStateMachine.length; ++i) {
            if (this.mDcSwitchAsyncChannel[i].isIdleSync()) continue;
            activePhoneId = i;
            break;
        }
        DctController.logd("onProcessRequest phoneId=" + phoneId + ", activePhoneId=" + activePhoneId);
        if (activePhoneId == -1 || activePhoneId == phoneId) {
            Iterator<Integer> iterator = this.mRequestInfos.keySet().iterator();
            while (iterator.hasNext()) {
                DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(iterator.next());
                if (requestInfo.phoneId != phoneId || requestInfo.executed) continue;
                this.mDcSwitchAsyncChannel[phoneId].connect(requestInfo);
            }
        } else {
            this.mDcSwitchAsyncChannel[activePhoneId].disconnectAll();
        }
    }

    private void onExecuteRequest(DcSwitchAsyncChannel.RequestInfo requestInfo) {
        if (!requestInfo.executed && this.mRequestInfos.containsKey(requestInfo.request.requestId)) {
            DctController.logd("onExecuteRequest request=" + requestInfo);
            requestInfo.log("DctController.onExecuteRequest - executed=" + requestInfo.executed);
            requestInfo.executed = true;
            String apn = this.apnForNetworkRequest(requestInfo.request);
            int phoneId = requestInfo.phoneId;
            PhoneBase phoneBase = (PhoneBase)this.mPhones[phoneId].getActivePhone();
            DcTrackerBase dcTracker = phoneBase.mDcTracker;
            dcTracker.incApnRefCount(apn, requestInfo.getLog());
        }
    }

    private void onExecuteAllRequests(int phoneId) {
        DctController.logd("onExecuteAllRequests phoneId=" + phoneId);
        Iterator<Integer> iterator = this.mRequestInfos.keySet().iterator();
        while (iterator.hasNext()) {
            DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(iterator.next());
            if (requestInfo.phoneId != phoneId) continue;
            this.onExecuteRequest(requestInfo);
        }
    }

    private void onReleaseRequest(DcSwitchAsyncChannel.RequestInfo requestInfo) {
        DctController.logd("onReleaseRequest request=" + requestInfo);
        if (requestInfo != null) {
            requestInfo.log("DctController.onReleaseRequest");
            if (requestInfo.executed) {
                String apn = this.apnForNetworkRequest(requestInfo.request);
                int phoneId = requestInfo.phoneId;
                PhoneBase phoneBase = (PhoneBase)this.mPhones[phoneId].getActivePhone();
                DcTrackerBase dcTracker = phoneBase.mDcTracker;
                dcTracker.decApnRefCount(apn, requestInfo.getLog());
                requestInfo.executed = false;
            }
        }
    }

    private void onReleaseAllRequests(int phoneId) {
        DctController.logd("onReleaseAllRequests phoneId=" + phoneId);
        Iterator<Integer> iterator = this.mRequestInfos.keySet().iterator();
        while (iterator.hasNext()) {
            DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(iterator.next());
            if (requestInfo.phoneId != phoneId) continue;
            this.onReleaseRequest(requestInfo);
        }
    }

    private void onRetryAttach(int phoneId) {
        int topPriPhone = this.getTopPriorityRequestPhoneId();
        DctController.logd("onRetryAttach phoneId=" + phoneId + " topPri phone = " + topPriPhone);
        if (phoneId != -1 && phoneId == topPriPhone) {
            this.mDcSwitchAsyncChannel[phoneId].retryConnect();
        }
    }

    private void onSettingsChanged() {
        int[] subIds;
        long dataSubId = this.mSubController.getDefaultDataSubId();
        int activePhoneId = -1;
        for (int i = 0; i < this.mDcSwitchStateMachine.length; ++i) {
            if (this.mDcSwitchAsyncChannel[i].isIdleSync()) continue;
            activePhoneId = i;
            break;
        }
        if ((subIds = SubscriptionManager.getSubId(activePhoneId)) == null || subIds.length == 0) {
            DctController.loge("onSettingsChange, subIds null or length 0 for activePhoneId " + activePhoneId);
            return;
        }
        DctController.logd("onSettingsChange, data sub: " + dataSubId + ", active data sub: " + subIds[0]);
        if ((long)subIds[0] != dataSubId) {
            Iterator<Integer> iterator = this.mRequestInfos.keySet().iterator();
            while (iterator.hasNext()) {
                DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(iterator.next());
                String specifier = requestInfo.request.networkCapabilities.getNetworkSpecifier();
                if (specifier != null && !specifier.equals("") || !requestInfo.executed) continue;
                String apn = this.apnForNetworkRequest(requestInfo.request);
                DctController.logd("[setDataSubId] activePhoneId:" + activePhoneId + ", subId =" + dataSubId);
                requestInfo.log("DctController.onSettingsChange releasing request");
                PhoneBase phoneBase = (PhoneBase)this.mPhones[activePhoneId].getActivePhone();
                DcTrackerBase dcTracker = phoneBase.mDcTracker;
                dcTracker.decApnRefCount(apn, requestInfo.getLog());
                requestInfo.executed = false;
            }
        }
        for (int i = 0; i < this.mPhoneNum; ++i) {
            ((TelephonyNetworkFactory)this.mNetworkFactory[i]).evalPendingRequest();
        }
        this.processRequests();
    }

    private int getTopPriorityRequestPhoneId() {
        DcSwitchAsyncChannel.RequestInfo retRequestInfo = null;
        int phoneId = 0;
        int priority = -1;
        for (int i = 0; i < this.mPhoneNum; ++i) {
            Iterator<Integer> iterator = this.mRequestInfos.keySet().iterator();
            while (iterator.hasNext()) {
                DcSwitchAsyncChannel.RequestInfo requestInfo = this.mRequestInfos.get(iterator.next());
                DctController.logd("selectExecPhone requestInfo = " + requestInfo);
                if (requestInfo.phoneId != i || priority >= requestInfo.priority) continue;
                priority = requestInfo.priority;
                retRequestInfo = requestInfo;
            }
        }
        if (retRequestInfo != null) {
            phoneId = this.getRequestPhoneId(retRequestInfo.request);
        } else {
            int defaultDds = this.mSubController.getDefaultDataSubId();
            phoneId = this.mSubController.getPhoneId(defaultDds);
            DctController.logd("getTopPriorityRequestPhoneId: RequestInfo list is empty, use Dds sub phone id");
        }
        DctController.logd("getTopPriorityRequestPhoneId = " + phoneId + ", priority = " + priority);
        return phoneId;
    }

    private void onSubInfoReady() {
        DctController.logd("onSubInfoReady mPhoneNum=" + this.mPhoneNum);
        for (int i = 0; i < this.mPhoneNum; ++i) {
            int subId = this.mPhones[i].getSubId();
            DctController.logd("onSubInfoReady handle pending requests subId=" + subId);
            this.mNetworkFilter[i].setNetworkSpecifier(String.valueOf(subId));
            ((TelephonyNetworkFactory)this.mNetworkFactory[i]).evalPendingRequest();
        }
        this.processRequests();
    }

    private String apnForNetworkRequest(NetworkRequest nr) {
        NetworkCapabilities nc = nr.networkCapabilities;
        if (nc.getTransportTypes().length > 0 && !nc.hasTransport(0)) {
            return null;
        }
        int type = -1;
        String name = null;
        boolean error = false;
        if (nc.hasCapability(12)) {
            if (name != null) {
                error = true;
            }
            name = "default";
            type = 0;
        }
        if (nc.hasCapability(0)) {
            if (name != null) {
                error = true;
            }
            name = "mms";
            type = 2;
        }
        if (nc.hasCapability(1)) {
            if (name != null) {
                error = true;
            }
            name = "supl";
            type = 3;
        }
        if (nc.hasCapability(2)) {
            if (name != null) {
                error = true;
            }
            name = "dun";
            type = 4;
        }
        if (nc.hasCapability(3)) {
            if (name != null) {
                error = true;
            }
            name = "fota";
            type = 10;
        }
        if (nc.hasCapability(4)) {
            if (name != null) {
                error = true;
            }
            name = "ims";
            type = 11;
        }
        if (nc.hasCapability(5)) {
            if (name != null) {
                error = true;
            }
            name = "cbs";
            type = 12;
        }
        if (nc.hasCapability(7)) {
            if (name != null) {
                error = true;
            }
            name = "ia";
            type = 14;
        }
        if (nc.hasCapability(8)) {
            if (name != null) {
                error = true;
            }
            name = null;
            DctController.loge("RCS APN type not yet supported");
        }
        if (nc.hasCapability(9)) {
            if (name != null) {
                error = true;
            }
            name = null;
            DctController.loge("XCAP APN type not yet supported");
        }
        if (nc.hasCapability(10)) {
            if (name != null) {
                error = true;
            }
            name = "emergency";
            type = 15;
        }
        if (error) {
            DctController.loge("Multiple apn types specified in request - result is unspecified!");
        }
        if (type == -1 || name == null) {
            DctController.loge("Unsupported NetworkRequest in Telephony: nr=" + nr);
            return null;
        }
        return name;
    }

    private int getRequestPhoneId(NetworkRequest networkRequest) {
        String specifier = networkRequest.networkCapabilities.getNetworkSpecifier();
        int subId = specifier == null || specifier.equals("") ? this.mSubController.getDefaultDataSubId() : Integer.parseInt(specifier);
        int phoneId = this.mSubController.getPhoneId(subId);
        if (!SubscriptionManager.isValidPhoneId(phoneId) && !SubscriptionManager.isValidPhoneId(phoneId = 0)) {
            throw new RuntimeException("Should not happen, no valid phoneId");
        }
        return phoneId;
    }

    private static void logd(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private static void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("DctController:");
        try {
            for (DcSwitchStateMachine dssm : this.mDcSwitchStateMachine) {
                dssm.dump(fd, pw, args);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            for (Map.Entry<Integer, DcSwitchAsyncChannel.RequestInfo> entry : this.mRequestInfos.entrySet()) {
                pw.println("mRequestInfos[" + entry.getKey() + "]=" + entry.getValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.flush();
        pw.println("TelephonyNetworkFactories:");
        for (NetworkFactory tnf : this.mNetworkFactory) {
            tnf.dump(fd, pw, args);
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.flush();
    }

    private class TelephonyNetworkFactory
    extends NetworkFactory {
        private final SparseArray<NetworkRequest> mPendingReq;
        private Phone mPhone;
        private static final int MAX_REQUESTS_LOGGED = 20;
        private static final int MAX_LOG_LINES_PER_REQUEST = 50;
        private ArrayDeque<RequestLogger> mRequestLogs;

        public TelephonyNetworkFactory(Looper l, Context c, String TAG, Phone phone, NetworkCapabilities nc) {
            super(l, c, TAG, nc);
            this.mPendingReq = new SparseArray();
            this.mRequestLogs = new ArrayDeque();
            this.mPhone = phone;
            this.log("NetworkCapabilities: " + nc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public LocalLog requestLog(int requestId, String l) {
            ArrayDeque<RequestLogger> arrayDeque = this.mRequestLogs;
            synchronized (arrayDeque) {
                for (RequestLogger r : this.mRequestLogs) {
                    if (r.request.requestId != requestId) continue;
                    r.log.log(l);
                    return r.log;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LocalLog addLogger(NetworkRequest request) {
            ArrayDeque<RequestLogger> arrayDeque = this.mRequestLogs;
            synchronized (arrayDeque) {
                for (RequestLogger r : this.mRequestLogs) {
                    if (r.request.requestId != request.requestId) continue;
                    return r.log;
                }
                LocalLog l = new LocalLog(50);
                RequestLogger logger = new RequestLogger(request, l);
                while (this.mRequestLogs.size() >= 20) {
                    this.mRequestLogs.removeFirst();
                }
                this.mRequestLogs.addLast(logger);
                return l;
            }
        }

        @Override
        protected void needNetworkFor(NetworkRequest networkRequest, int score) {
            this.log("Cellular needs Network for " + networkRequest);
            LocalLog l = this.addLogger(networkRequest);
            if (!SubscriptionManager.isUsableSubIdValue(this.mPhone.getSubId()) || DctController.this.getRequestPhoneId(networkRequest) != this.mPhone.getPhoneId()) {
                String str = "Request not useable, pending request.";
                this.log("Request not useable, pending request.");
                l.log("Request not useable, pending request.");
                this.mPendingReq.put(networkRequest.requestId, networkRequest);
                return;
            }
            DcTrackerBase dcTracker = ((PhoneBase)this.mPhone).mDcTracker;
            String apn = DctController.this.apnForNetworkRequest(networkRequest);
            if (dcTracker.isApnSupported(apn)) {
                DctController.this.requestNetwork(networkRequest, dcTracker.getApnPriority(apn), l, this.mPhone.getPhoneId());
            } else {
                String str = "Unsupported APN";
                this.log("Unsupported APN");
                l.log("Unsupported APN");
            }
        }

        @Override
        protected void releaseNetworkFor(NetworkRequest networkRequest) {
            String str = "Cellular releasing Network for ";
            this.log(str + networkRequest);
            LocalLog l = this.requestLog(networkRequest.requestId, str);
            if (this.mPendingReq.get(networkRequest.requestId) != null) {
                str = "Sub Info has not been ready, remove request.";
                this.log(str);
                if (l != null) {
                    l.log(str);
                }
                this.mPendingReq.remove(networkRequest.requestId);
                return;
            }
            DctController.this.releaseNetwork(networkRequest);
        }

        @Override
        protected void log(String s) {
            Rlog.d(DctController.LOG_TAG, "[TNF " + this.mPhone.getSubId() + "]" + s);
        }

        public void evalPendingRequest() {
            this.log("evalPendingRequest, pending request size is " + this.mPendingReq.size());
            int key = 0;
            for (int i = 0; i < this.mPendingReq.size(); ++i) {
                key = this.mPendingReq.keyAt(i);
                NetworkRequest request = this.mPendingReq.get(key);
                this.log("evalPendingRequest: request = " + request);
                this.mPendingReq.remove(request.requestId);
                this.needNetworkFor(request, 0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            super.dump(fd, writer, args);
            IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
            pw.increaseIndent();
            pw.println("Pending Requests:");
            pw.increaseIndent();
            for (int i = 0; i < this.mPendingReq.size(); ++i) {
                NetworkRequest request = this.mPendingReq.valueAt(i);
                pw.println(request);
            }
            pw.decreaseIndent();
            pw.println("Request History:");
            pw.increaseIndent();
            ArrayDeque<RequestLogger> arrayDeque = this.mRequestLogs;
            synchronized (arrayDeque) {
                for (RequestLogger r : this.mRequestLogs) {
                    pw.println(r.request);
                    pw.increaseIndent();
                    r.log.dump(fd, pw, args);
                    pw.decreaseIndent();
                }
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }

        private class RequestLogger {
            public NetworkRequest request;
            public LocalLog log;

            public RequestLogger(NetworkRequest r, LocalLog log) {
                this.request = r;
                this.log = log;
            }
        }
    }
}

