/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneProxy;
import com.android.internal.telephony.PhoneSubInfo;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.gsm.GsmCall;
import com.android.internal.telephony.gsm.GsmCallTracker;
import com.android.internal.telephony.gsm.GsmConnection;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.GsmServiceStateTracker;
import com.android.internal.telephony.gsm.SimPhoneBookInterfaceManager;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class GSMPhone
extends PhoneBase {
    static final String LOG_TAG = "GSMPhone";
    private static final boolean LOCAL_DEBUG = true;
    private static final boolean VDBG = false;
    public static final String CIPHERING_KEY = "ciphering_key";
    public static final String VM_NUMBER = "vm_number_key";
    public static final String VM_SIM_IMSI = "vm_sim_imsi_key";
    GsmCallTracker mCT;
    GsmServiceStateTracker mSST;
    ArrayList<GsmMmiCode> mPendingMMIs = new ArrayList();
    SimPhoneBookInterfaceManager mSimPhoneBookIntManager;
    PhoneSubInfo mSubInfo;
    Registrant mPostDialHandler;
    RegistrantList mSsnRegistrants = new RegistrantList();
    private final RegistrantList mEcmTimerResetRegistrants = new RegistrantList();
    private String mImei;
    private String mImeiSv;
    private String mVmNumber;
    private IsimUiccRecords mIsimUiccRecords;

    public GSMPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode) {
        super("GSM", notifier, context, ci, unitTestMode);
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCi.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mDcTracker = new DcTracker(this);
        if (!unitTestMode) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mCi.setOnSs(this, 36, null);
        this.setProperties();
    }

    public GSMPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId) {
        this(context, ci, notifier, false, phoneId);
    }

    public GSMPhone(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode, int phoneId) {
        super("GSM", notifier, context, ci, unitTestMode, phoneId);
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCi.setPhoneType(1);
        this.mCT = new GsmCallTracker(this);
        this.mSST = new GsmServiceStateTracker(this);
        this.mDcTracker = new DcTracker(this);
        if (!unitTestMode) {
            this.mSimPhoneBookIntManager = new SimPhoneBookInterfaceManager(this);
            this.mSubInfo = new PhoneSubInfo(this);
        }
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mCi.setOnSs(this, 36, null);
        this.setProperties();
        this.log("GSMPhone: constructor: sub = " + this.mPhoneId);
        this.setProperties();
    }

    protected void setProperties() {
        TelephonyManager.from(this.mContext).setPhoneType(this.getPhoneId(), 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = PhoneProxy.lockForRadioTechnologyChange;
        synchronized (object) {
            super.dispose();
            this.mCi.unregisterForAvailable(this);
            this.unregisterForSimRecordEvents();
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCi.unregisterForOn(this);
            this.mSST.unregisterForNetworkAttached(this);
            this.mCi.unSetOnUSSD(this);
            this.mCi.unSetOnSuppServiceNotification(this);
            this.mCi.unSetOnSs(this);
            this.mPendingMMIs.clear();
            this.mCT.dispose();
            this.mDcTracker.dispose();
            this.mSST.dispose();
            this.mSimPhoneBookIntManager.dispose();
            this.mSubInfo.dispose();
        }
    }

    @Override
    public void removeReferences() {
        Rlog.d(LOG_TAG, "removeReferences");
        this.mSimulatedRadioControl = null;
        this.mSimPhoneBookIntManager = null;
        this.mSubInfo = null;
        this.mCT = null;
        this.mSST = null;
        super.removeReferences();
    }

    protected void finalize() {
        Rlog.d(LOG_TAG, "GSMPhone finalized");
    }

    @Override
    public ServiceState getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null) {
            return ServiceState.mergeServiceStates(this.mSST == null ? new ServiceState() : this.mSST.mSS, this.mImsPhone.getServiceState());
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    @Override
    public CellLocation getCellLocation() {
        return this.mSST.getCellLocation();
    }

    @Override
    public PhoneConstants.State getState() {
        PhoneConstants.State imsState;
        if (this.mImsPhone != null && (imsState = this.mImsPhone.getState()) != PhoneConstants.State.IDLE) {
            return imsState;
        }
        return this.mCT.mState;
    }

    @Override
    public int getPhoneType() {
        return 1;
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return this.mSST;
    }

    @Override
    public CallTracker getCallTracker() {
        return this.mCT;
    }

    private void updateVoiceMail() {
        int countVoiceMessages = 0;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            countVoiceMessages = r.getVoiceMessageCount();
        }
        int countVoiceMessagesStored = this.getStoredVoiceMessageCount();
        if (countVoiceMessages == -1 && countVoiceMessagesStored != 0) {
            countVoiceMessages = countVoiceMessagesStored;
        }
        Rlog.d(LOG_TAG, "updateVoiceMail countVoiceMessages = " + countVoiceMessages + " subId " + this.getSubId());
        this.setVoiceMessageCount(countVoiceMessages);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!apnType.equals("emergency") && this.mSST.getCurrentDataConnectionState() != 0) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (!this.mDcTracker.isApnTypeEnabled(apnType) || !this.mDcTracker.isApnTypeActive(apnType)) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (this.mDcTracker.getState(apnType)) {
                case RETRYING: 
                case FAILED: 
                case IDLE: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case CONNECTED: 
                case DISCONNECTING: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case CONNECTING: 
                case SCANNING: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        return ret;
    }

    @Override
    public Phone.DataActivityState getDataActivityState() {
        Phone.DataActivityState ret = Phone.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (this.mDcTracker.getActivity()) {
                case DATAIN: {
                    ret = Phone.DataActivityState.DATAIN;
                    break;
                }
                case DATAOUT: {
                    ret = Phone.DataActivityState.DATAOUT;
                    break;
                }
                case DATAINANDOUT: {
                    ret = Phone.DataActivityState.DATAINANDOUT;
                    break;
                }
                case DORMANT: {
                    ret = Phone.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = Phone.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    void notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    void notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    public void notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    void notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    void notifyUnknownConnection(Connection cn) {
        this.mUnknownConnectionRegistrants.notifyResult(cn);
    }

    void notifySuppServiceFailed(Phone.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    void notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    void notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    @Override
    public void notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    @Override
    public void setSystemProperty(String property, String value) {
        TelephonyManager.setTelephonyProperty(this.mPhoneId, property, value);
    }

    @Override
    public void registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCi.setSuppServiceNotifications(true, null);
        }
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCi.setSuppServiceNotifications(false, null);
        }
    }

    @Override
    public void registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        this.mSimRecordsLoadedRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler h) {
        this.mSimRecordsLoadedRegistrants.remove(h);
    }

    @Override
    public void acceptCall(int videoState) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    @Override
    public void rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    @Override
    public boolean canConference() {
        boolean canImsConference = false;
        if (this.mImsPhone != null) {
            canImsConference = this.mImsPhone.canConference();
        }
        return this.mCT.canConference() || canImsConference;
    }

    public boolean canDial() {
        return this.mCT.canDial();
    }

    @Override
    public void conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.log("conference() - delegated to IMS phone");
            this.mImsPhone.conference();
            return;
        }
        this.mCT.conference();
    }

    @Override
    public void clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    @Override
    public boolean canTransfer() {
        return this.mCT.canTransfer();
    }

    @Override
    public void explicitCallTransfer() {
        this.mCT.explicitCallTransfer();
    }

    @Override
    public GsmCall getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    @Override
    public GsmCall getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    @Override
    public Call getRingingCall() {
        ImsPhone imsPhone = this.mImsPhone;
        if (this.mCT.mRingingCall != null && this.mCT.mRingingCall.isRinging()) {
            return this.mCT.mRingingCall;
        }
        if (imsPhone != null) {
            return imsPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d(LOG_TAG, "reject failed", e);
                this.notifySuppServiceFailed(Phone.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            Rlog.d(LOG_TAG, "MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
        }
        return true;
    }

    private boolean handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        GsmCall call = this.getForegroundCall();
        try {
            if (len > 1) {
                char ch = dialString.charAt(1);
                int callIndex = ch - 48;
                if (callIndex >= 1 && callIndex <= 7) {
                    Rlog.d(LOG_TAG, "MmiCode 1: hangupConnectionByIndex " + callIndex);
                    this.mCT.hangupConnectionByIndex(call, callIndex);
                }
            } else if (call.getState() != Call.State.IDLE) {
                Rlog.d(LOG_TAG, "MmiCode 1: hangup foreground");
                this.mCT.hangup(call);
            } else {
                Rlog.d(LOG_TAG, "MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d(LOG_TAG, "hangup failed", e);
            this.notifySuppServiceFailed(Phone.SuppService.HANGUP);
        }
        return true;
    }

    private boolean handleCallHoldIncallSupplementaryService(String dialString) {
        block10: {
            int len = dialString.length();
            if (len > 2) {
                return false;
            }
            GsmCall call = this.getForegroundCall();
            if (len > 1) {
                try {
                    char ch = dialString.charAt(1);
                    int callIndex = ch - 48;
                    GsmConnection conn = this.mCT.getConnectionByIndex(call, callIndex);
                    if (conn != null && callIndex >= 1 && callIndex <= 7) {
                        Rlog.d(LOG_TAG, "MmiCode 2: separate call " + callIndex);
                        this.mCT.separate(conn);
                        break block10;
                    }
                    Rlog.d(LOG_TAG, "separate: invalid call index " + callIndex);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "separate failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SEPARATE);
                }
            } else {
                try {
                    if (this.getRingingCall().getState() != Call.State.IDLE) {
                        Rlog.d(LOG_TAG, "MmiCode 2: accept ringing call");
                        this.mCT.acceptCall();
                    } else {
                        Rlog.d(LOG_TAG, "MmiCode 2: switchWaitingOrHoldingAndActive");
                        this.mCT.switchWaitingOrHoldingAndActive();
                    }
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "switch failed", e);
                    this.notifySuppServiceFailed(Phone.SuppService.SWITCH);
                }
            }
        }
        return true;
    }

    private boolean handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private boolean handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        Rlog.d(LOG_TAG, "MmiCode 4: explicit call transfer");
        this.explicitCallTransfer();
        return true;
    }

    private boolean handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i(LOG_TAG, "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(Phone.SuppService.UNKNOWN);
        return true;
    }

    @Override
    public boolean handleInCallMmiCommands(String dialString) throws CallStateException {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return imsPhone.handleInCallMmiCommands(dialString);
        }
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    boolean isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    @Override
    public Connection dial(String dialString, int videoState) throws CallStateException {
        return this.dial(dialString, null, videoState, null);
    }

    @Override
    public Connection dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isEmergency;
        block4: {
            isEmergency = PhoneNumberUtils.isEmergencyNumber(dialString);
            ImsPhone imsPhone = this.mImsPhone;
            boolean imsUseEnabled = this.isImsUseEnabled() && imsPhone != null && (imsPhone.isVolteEnabled() || imsPhone.isVowifiEnabled()) && imsPhone.getServiceState().getState() == 0;
            boolean useImsForEmergency = ImsManager.isVolteEnabledByPlatform((Context)this.mContext) && imsPhone != null && isEmergency && this.mContext.getResources().getBoolean(17956994) && ImsManager.isNonTtyOrTtyOnVolteEnabled((Context)this.mContext) && imsPhone.getServiceState().getState() != 3;
            Rlog.d(LOG_TAG, "imsUseEnabled=" + imsUseEnabled + ", useImsForEmergency=" + useImsForEmergency + ", imsPhone=" + imsPhone + ", imsPhone.isVolteEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVolteEnabled()) : "N/A") + ", imsPhone.isVowifiEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVowifiEnabled()) : "N/A") + ", imsPhone.getServiceState().getState()=" + (imsPhone != null ? Integer.valueOf(imsPhone.getServiceState().getState()) : "N/A"));
            ImsPhone.checkWfcWifiOnlyModeBeforeDial(this.mImsPhone, this.mContext);
            if (imsUseEnabled || useImsForEmergency) {
                try {
                    Rlog.d(LOG_TAG, "Trying IMS PS call");
                    return imsPhone.dial(dialString, uusInfo, videoState, intentExtras);
                }
                catch (CallStateException e) {
                    Rlog.d(LOG_TAG, "IMS PS call exception " + e + "imsUseEnabled =" + imsUseEnabled + ", imsPhone =" + imsPhone);
                    if ("cs_fallback".equals(e.getMessage())) break block4;
                    CallStateException ce = new CallStateException(e.getMessage());
                    ce.setStackTrace(e.getStackTrace());
                    throw ce;
                }
            }
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 1 && this.mSST.mSS.getDataRegState() != 0 && !isEmergency) {
            throw new CallStateException("cannot dial in current state");
        }
        Rlog.d(LOG_TAG, "Trying (non-IMS) CS call");
        return this.dialInternal(dialString, null, 0, intentExtras);
    }

    @Override
    protected Connection dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.handleInCallMmiCommands(newDialString)) {
            return null;
        }
        String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(networkPortion, this, (UiccCardApplication)this.mUiccApplication.get());
        Rlog.d(LOG_TAG, "dialing w/ mmi '" + mmi + "'...");
        if (mmi == null) {
            return this.mCT.dial(newDialString, uusInfo, intentExtras);
        }
        if (mmi.isTemporaryModeCLIR()) {
            return this.mCT.dial(mmi.mDialingNumber, mmi.getCLIRMode(), uusInfo, intentExtras);
        }
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.processCode();
        return null;
    }

    @Override
    public boolean handlePinMmi(String dialString) {
        GsmMmiCode mmi = GsmMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi != null && mmi.isPinPukCommand()) {
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return true;
        }
        return false;
    }

    @Override
    public void sendUssdResponse(String ussdMessge) {
        GsmMmiCode mmi = GsmMmiCode.newFromUssdUserInput(ussdMessge, this, (UiccCardApplication)this.mUiccApplication.get());
        this.mPendingMMIs.add(mmi);
        this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        mmi.sendUssd(ussdMessge);
    }

    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            Rlog.e(LOG_TAG, "startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    @Override
    public void stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    public void sendBurstDtmf(String dtmfString) {
        Rlog.e(LOG_TAG, "[GSMPhone] sendBurstDtmf() is a CDMA method");
    }

    @Override
    public void setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    private void storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_NUMBER + this.getPhoneId(), number);
        editor.apply();
        this.setVmSimImsi(this.getSubscriberId());
    }

    @Override
    public String getVoiceMailNumber() {
        String[] listArray;
        String number;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String string2 = number = r != null ? r.getVoiceMailNumber() : "";
        if (TextUtils.isEmpty(number)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            number = sp.getString(VM_NUMBER + this.getPhoneId(), null);
        }
        if (TextUtils.isEmpty(number) && (listArray = this.getContext().getResources().getStringArray(17236030)) != null && listArray.length > 0) {
            for (int i = 0; i < listArray.length; ++i) {
                String[] defaultVMNumberArray;
                if (TextUtils.isEmpty(listArray[i]) || (defaultVMNumberArray = listArray[i].split(";")) == null || defaultVMNumberArray.length <= 0) continue;
                if (defaultVMNumberArray.length == 1) {
                    number = defaultVMNumberArray[0];
                    continue;
                }
                if (defaultVMNumberArray.length != 2 || TextUtils.isEmpty(defaultVMNumberArray[1]) || !defaultVMNumberArray[1].equalsIgnoreCase(this.getGroupIdLevel1())) continue;
                number = defaultVMNumberArray[0];
                break;
            }
        }
        return number;
    }

    private String getVmSimImsi() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString(VM_SIM_IMSI + this.getPhoneId(), null);
    }

    private void setVmSimImsi(String imsi) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(VM_SIM_IMSI + this.getPhoneId(), imsi);
        editor.apply();
    }

    @Override
    public String getVoiceMailAlphaTag() {
        String ret;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        String string2 = ret = r != null ? r.getVoiceMailAlphaTag() : "";
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    @Override
    public String getDeviceId() {
        return this.mImei;
    }

    @Override
    public String getDeviceSvn() {
        return this.mImeiSv;
    }

    @Override
    public IsimRecords getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    @Override
    public String getImei() {
        return this.mImei;
    }

    @Override
    public String getEsn() {
        Rlog.e(LOG_TAG, "[GSMPhone] getEsn() is a CDMA method");
        return "0";
    }

    @Override
    public String getMeid() {
        Rlog.e(LOG_TAG, "[GSMPhone] getMeid() is a CDMA method");
        return "0";
    }

    @Override
    public String getNai() {
        IccRecords r = this.mUiccController.getIccRecords(this.mPhoneId, 2);
        if (Log.isLoggable(LOG_TAG, 2)) {
            Rlog.v(LOG_TAG, "IccRecords is " + r);
        }
        return r != null ? r.getNAI() : null;
    }

    @Override
    public String getSubscriberId() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getIMSI() : null;
    }

    @Override
    public String getGroupIdLevel1() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getGid1() : null;
    }

    @Override
    public String getGroupIdLevel2() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getGid2() : null;
    }

    @Override
    public String getLine1Number() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnNumber() : null;
    }

    @Override
    public String getMsisdn() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnNumber() : null;
    }

    @Override
    public String getLine1AlphaTag() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.getMsisdnAlphaTag() : null;
    }

    @Override
    public boolean setLine1Number(String alphaTag, String number, Message onComplete) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setMsisdnNumber(alphaTag, number, onComplete);
            return true;
        }
        return false;
    }

    @Override
    public void setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    private boolean isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return TelephonyManager.getTelephonyProperty(this.mPhoneId, property, defValue);
    }

    private boolean isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void updateDataConnectionTracker() {
        ((DcTracker)this.mDcTracker).update();
    }

    protected boolean isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    @Override
    public void getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
            return;
        }
        if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Rlog.d(LOG_TAG, "requesting call forwarding query.");
            Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(13, onComplete) : onComplete;
            this.mCi.queryCallForwardStatus(commandInterfaceCFReason, 0, null, resp);
        }
    }

    @Override
    public void setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, timerSeconds, onComplete);
            return;
        }
        if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
            Message resp;
            if (commandInterfaceCFReason == 0) {
                Cfu cfu = new Cfu(dialingNumber, onComplete);
                resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cfu);
            } else {
                resp = onComplete;
            }
            this.mCi.setCallForward(commandInterfaceCFAction, commandInterfaceCFReason, 1, dialingNumber, timerSeconds, resp);
        }
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        this.mCi.getCLIR(onComplete);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        this.mCi.setCLIR(commandInterfaceCLIRMode, this.obtainMessage(18, commandInterfaceCLIRMode, 0, onComplete));
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.getCallWaiting(onComplete);
            return;
        }
        this.mCi.queryCallWaiting(0, onComplete);
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        ImsPhone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            imsPhone.setCallWaiting(enable, onComplete);
            return;
        }
        this.mCi.setCallWaiting(enable, 1, onComplete);
    }

    @Override
    public void getAvailableNetworks(Message response) {
        this.mCi.getAvailableNetworks(response);
    }

    @Override
    public void getNeighboringCids(Message response) {
        this.mCi.getNeighboringCids(response);
    }

    @Override
    public void setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    @Override
    public void setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsPhone != null) {
            this.mImsPhone.setUiTTYMode(uiTtyMode, onComplete);
        }
    }

    @Override
    public void setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    @Override
    public boolean getMute() {
        return this.mCT.getMute();
    }

    @Override
    public void getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    @Override
    public void updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    @Override
    public void enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    @Override
    public void disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return this.mDcTracker.getDataOnRoamingEnabled();
    }

    @Override
    public void setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataOnRoamingEnabled(enable);
    }

    @Override
    public boolean getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    @Override
    public void setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    void onMMIDone(GsmMmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || mmi.isUssdRequest() || mmi.isSsInfo()) {
            this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
        }
    }

    private void onNetworkInitiatedUssd(GsmMmiCode mmi) {
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    private void onIncomingUSSD(int ussdMode, String ussdMessage) {
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        boolean isUssdRelease = ussdMode == 2;
        GsmMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
            found = this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdRelease) {
                found.onUssdRelease();
            } else if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            GsmMmiCode mmi = GsmMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this, (UiccCardApplication)this.mUiccApplication.get());
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    protected void syncClirSetting() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        int clirSetting = sp.getInt("clir_key" + this.getPhoneId(), -1);
        if (clirSetting >= 0) {
            this.mCi.setCLIR(clirSetting, null);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 16: 
            case 17: {
                super.handleMessage(msg);
                return;
            }
        }
        if (!this.mIsTheCurrentActivePhone) {
            Rlog.e(LOG_TAG, "Received message " + msg + "[" + msg.what + "] while being destroyed. Ignoring.");
            return;
        }
        switch (msg.what) {
            case 1: {
                this.mCi.getBasebandVersion(this.obtainMessage(6));
                this.mCi.getIMEI(this.obtainMessage(9));
                this.mCi.getIMEISV(this.obtainMessage(10));
                this.mCi.getRadioCapability(this.obtainMessage(35));
                this.startLceAfterRadioIsAvailable();
                break;
            }
            case 5: {
                this.setPreferredNetworkTypeIfSimLoaded();
                break;
            }
            case 19: {
                this.syncClirSetting();
                break;
            }
            case 3: {
                this.updateCurrentCarrierInProvider();
                String imsi = this.getVmSimImsi();
                String imsiFromSIM = this.getSubscriberId();
                if (imsi != null && imsiFromSIM != null && !imsiFromSIM.equals(imsi)) {
                    this.storeVoiceMailNumber(null);
                    this.setVmSimImsi(null);
                }
                this.mSimRecordsLoadedRegistrants.notifyRegistrants();
                this.updateVoiceMail();
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                Rlog.d(LOG_TAG, "Baseband version: " + ar.result);
                TelephonyManager.from(this.mContext).setBasebandVersionForPhone(this.getPhoneId(), (String)ar.result);
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImei = (String)ar.result;
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImeiSv = (String)ar.result;
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String[] ussdResult = (String[])ar.result;
                if (ussdResult.length <= 1) break;
                try {
                    this.onIncomingUSSD(Integer.parseInt(ussdResult[0]), ussdResult[1]);
                }
                catch (NumberFormatException e) {
                    Rlog.w(LOG_TAG, "error parsing USSD");
                }
                break;
            }
            case 8: {
                for (int i = this.mPendingMMIs.size() - 1; i >= 0; --i) {
                    if (!this.mPendingMMIs.get(i).isPendingUSSD()) continue;
                    this.mPendingMMIs.get(i).onUssdFinishedError();
                }
                ImsPhone imsPhone = this.mImsPhone;
                if (imsPhone != null) {
                    imsPhone.getServiceState().setStateOff();
                }
                this.mRadioOffOrNotAvailableRegistrants.notifyRegistrants();
                break;
            }
            case 2: {
                AsyncResult ar = (AsyncResult)msg.obj;
                SuppServiceNotification not = (SuppServiceNotification)ar.result;
                this.mSsnRegistrants.notifyRegistrants(ar);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                IccRecords r = (IccRecords)this.mIccRecords.get();
                Cfu cfu = (Cfu)ar.userObj;
                if (ar.exception == null && r != null) {
                    r.setVoiceCallForwardingFlag(1, msg.arg1 == 1, cfu.mSetCfNumber);
                }
                if (cfu.mOnComplete == null) break;
                AsyncResult.forMessage(cfu.mOnComplete, ar.result, ar.exception);
                cfu.mOnComplete.sendToTarget();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (IccVmNotSupportedException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 13: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleCfuQueryResult((CallForwardInfo[])ar.result);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 28: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mSST.mSS.getIsManualSelection()) {
                    this.setNetworkSelectionModeAutomatic((Message)ar.result);
                    Rlog.d(LOG_TAG, "SET_NETWORK_SELECTION_AUTOMATIC: set to automatic");
                    break;
                }
                Rlog.d(LOG_TAG, "SET_NETWORK_SELECTION_AUTOMATIC: already automatic, ignore");
                break;
            }
            case 29: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.processIccRecordEvents((Integer)ar.result);
                break;
            }
            case 18: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 36: {
                AsyncResult ar = (AsyncResult)msg.obj;
                Rlog.d(LOG_TAG, "Event EVENT_SS received");
                GsmMmiCode mmi = new GsmMmiCode(this, (UiccCardApplication)this.mUiccApplication.get());
                mmi.processSsData(ar);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    protected UiccCardApplication getUiccCardApplication() {
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
    }

    @Override
    protected void onUpdateIccAvailability() {
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 3);
        IsimUiccRecords newIsimUiccRecords = null;
        if (newUiccApplication != null) {
            newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
            this.log("New ISIM application found");
        }
        this.mIsimUiccRecords = newIsimUiccRecords;
        newUiccApplication = this.getUiccCardApplication();
        UiccCardApplication app = (UiccCardApplication)this.mUiccApplication.get();
        if (app != newUiccApplication) {
            if (app != null) {
                this.log("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForSimRecordEvents();
                    this.mSimPhoneBookIntManager.updateIccRecords(null);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.log("New Uicc application found");
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForSimRecordEvents();
                this.mSimPhoneBookIntManager.updateIccRecords((IccRecords)this.mIccRecords.get());
            }
        }
    }

    private void processIccRecordEvents(int eventCode) {
        switch (eventCode) {
            case 1: {
                this.notifyCallForwardingIndicator();
            }
        }
    }

    public boolean updateCurrentCarrierInProvider() {
        long currentDds = SubscriptionManager.getDefaultDataSubId();
        String operatorNumeric = this.getOperatorNumeric();
        this.log("updateCurrentCarrierInProvider: mSubId = " + this.getSubId() + " currentDds = " + currentDds + " operatorNumeric = " + operatorNumeric);
        if (!TextUtils.isEmpty(operatorNumeric) && (long)this.getSubId() == currentDds) {
            try {
                Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                ContentValues map = new ContentValues();
                map.put("numeric", operatorNumeric);
                this.mContext.getContentResolver().insert(uri, map);
                return true;
            }
            catch (SQLException e) {
                Rlog.e(LOG_TAG, "Can't store current operator", e);
            }
        }
        return false;
    }

    public void saveClirSetting(int commandInterfaceCLIRMode) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("clir_key" + this.getPhoneId(), commandInterfaceCLIRMode);
        if (!editor.commit()) {
            Rlog.e(LOG_TAG, "failed to commit CLIR preference");
        }
    }

    private void handleCfuQueryResult(CallForwardInfo[] infos) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            if (infos == null || infos.length == 0) {
                r.setVoiceCallForwardingFlag(1, false, null);
            } else {
                int s = infos.length;
                for (int i = 0; i < s; ++i) {
                    if ((infos[i].serviceClass & 1) == 0) continue;
                    r.setVoiceCallForwardingFlag(1, infos[i].status == 1, infos[i].number);
                    break;
                }
            }
        }
    }

    @Override
    public PhoneSubInfo getPhoneSubInfo() {
        return this.mSubInfo;
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return this.mSimPhoneBookIntManager;
    }

    @Override
    public void activateCellBroadcastSms(int activate, Message response) {
        Rlog.e(LOG_TAG, "[GSMPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void getCellBroadcastSmsConfig(Message response) {
        Rlog.e(LOG_TAG, "[GSMPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        Rlog.e(LOG_TAG, "[GSMPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    @Override
    public boolean isCspPlmnEnabled() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.isCspPlmnEnabled() : false;
    }

    boolean isManualNetSelAllowed() {
        int nwMode = Phone.PREFERRED_NT_MODE;
        int subId = this.getSubId();
        nwMode = Settings.Global.getInt(this.mContext.getContentResolver(), "preferred_network_mode" + subId, nwMode);
        Rlog.d(LOG_TAG, "isManualNetSelAllowed in mode = " + nwMode);
        if (this.isManualSelProhibitedInGlobalMode() && (nwMode == 10 || nwMode == 7)) {
            Rlog.d(LOG_TAG, "Manual selection not supported in mode = " + nwMode);
            return false;
        }
        Rlog.d(LOG_TAG, "Manual selection is supported in mode = " + nwMode);
        return true;
    }

    private boolean isManualSelProhibitedInGlobalMode() {
        String[] configArray;
        boolean isProhibited = false;
        String configString = this.getContext().getResources().getString(17039436);
        if (!TextUtils.isEmpty(configString) && (configArray = configString.split(";")) != null && (configArray.length == 1 && configArray[0].equalsIgnoreCase("true") || configArray.length == 2 && !TextUtils.isEmpty(configArray[1]) && configArray[0].equalsIgnoreCase("true") && configArray[1].equalsIgnoreCase(this.getGroupIdLevel1()))) {
            isProhibited = true;
        }
        Rlog.d(LOG_TAG, "isManualNetSelAllowedInGlobal in current carrier is " + isProhibited);
        return isProhibited;
    }

    private void registerForSimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.registerForNetworkSelectionModeAutomatic(this, 28, null);
        r.registerForRecordsEvents(this, 29, null);
        r.registerForRecordsLoaded(this, 3, null);
    }

    private void unregisterForSimRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForNetworkSelectionModeAutomatic(this);
        r.unregisterForRecordsEvents(this);
        r.unregisterForRecordsLoaded(this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        if (this.mImsPhone != null) {
            this.mImsPhone.exitEmergencyCallbackMode();
        }
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("GSMPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mPendingMMIs=" + this.mPendingMMIs);
        pw.println(" mSimPhoneBookIntManager=" + this.mSimPhoneBookIntManager);
        pw.println(" mSubInfo=" + this.mSubInfo);
        pw.println(" mVmNumber=" + this.mVmNumber);
    }

    @Override
    public boolean setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard(this.getPhoneId());
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                TelephonyManager.from(this.mContext).setSimOperatorNameForPhone(this.getPhoneId(), iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }

    public String getOperatorNumeric() {
        String operatorNumeric = null;
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            operatorNumeric = r.getOperatorNumeric();
        }
        return operatorNumeric;
    }

    public void registerForAllDataDisconnected(Handler h, int what, Object obj) {
        ((DcTracker)this.mDcTracker).registerForAllDataDisconnected(h, what, obj);
    }

    public void unregisterForAllDataDisconnected(Handler h) {
        ((DcTracker)this.mDcTracker).unregisterForAllDataDisconnected(h);
    }

    public void setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        ((DcTracker)this.mDcTracker).setInternalDataEnabled(enable, onCompleteMsg);
    }

    public boolean setInternalDataEnabledFlag(boolean enable) {
        return ((DcTracker)this.mDcTracker).setInternalDataEnabledFlag(enable);
    }

    public void notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    @Override
    public void registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    @Override
    public void setVoiceMessageWaiting(int line, int countWaiting) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMessageWaiting(line, countWaiting);
        } else {
            this.log("SIM Records not found, MWI not updated");
        }
    }

    protected void log(String s) {
        Rlog.d(LOG_TAG, "[GSMPhone] " + s);
    }

    private static class Cfu {
        final String mSetCfNumber;
        final Message mOnComplete;

        Cfu(String cfNumber, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mOnComplete = onComplete;
        }
    }
}

