/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.CellLocation;
import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.telephony.TelephonyManager;
import android.telephony.gsm.GsmCellLocation;
import com.android.internal.telephony.CellBroadcastHandler;
import com.android.internal.telephony.PhoneBase;
import com.android.internal.telephony.gsm.GsmSmsCbMessage;
import com.android.internal.telephony.gsm.SmsCbHeader;
import java.util.HashMap;
import java.util.Iterator;

public class GsmCellBroadcastHandler
extends CellBroadcastHandler {
    private static final boolean VDBG = false;
    private final HashMap<SmsCbConcatInfo, byte[][]> mSmsCbPageMap = new HashMap(4);

    protected GsmCellBroadcastHandler(Context context, PhoneBase phone) {
        super("GsmCellBroadcastHandler", context, phone);
        phone.mCi.setOnNewGsmBroadcastSms(this.getHandler(), 1, null);
    }

    @Override
    protected void onQuitting() {
        this.mPhone.mCi.unSetOnNewGsmBroadcastSms(this.getHandler());
        super.onQuitting();
    }

    public static GsmCellBroadcastHandler makeGsmCellBroadcastHandler(Context context, PhoneBase phone) {
        GsmCellBroadcastHandler handler = new GsmCellBroadcastHandler(context, phone);
        handler.start();
        return handler;
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        SmsCbMessage cbMessage;
        if (message.obj instanceof AsyncResult && (cbMessage = this.handleGsmBroadcastSms((AsyncResult)message.obj)) != null) {
            this.handleBroadcastSms(cbMessage);
            return true;
        }
        return super.handleSmsMessage(message);
    }

    private SmsCbMessage handleGsmBroadcastSms(AsyncResult ar) {
        try {
            Object pdus;
            SmsCbLocation location;
            byte[] receivedPdu = (byte[])ar.result;
            SmsCbHeader header = new SmsCbHeader(receivedPdu);
            String plmn = TelephonyManager.from(this.mContext).getNetworkOperatorForPhone(this.mPhone.getPhoneId());
            int lac = -1;
            int cid = -1;
            CellLocation cl = this.mPhone.getCellLocation();
            if (cl instanceof GsmCellLocation) {
                GsmCellLocation cellLocation = (GsmCellLocation)cl;
                lac = cellLocation.getLac();
                cid = cellLocation.getCid();
            }
            switch (header.getGeographicalScope()) {
                case 2: {
                    location = new SmsCbLocation(plmn, lac, -1);
                    break;
                }
                case 0: 
                case 3: {
                    location = new SmsCbLocation(plmn, lac, cid);
                    break;
                }
                default: {
                    location = new SmsCbLocation(plmn);
                }
            }
            int pageCount = header.getNumberOfPages();
            if (pageCount > 1) {
                SmsCbConcatInfo concatInfo = new SmsCbConcatInfo(header, location);
                pdus = this.mSmsCbPageMap.get(concatInfo);
                if (pdus == null) {
                    pdus = new byte[pageCount][];
                    this.mSmsCbPageMap.put(concatInfo, (byte[][])pdus);
                }
                pdus[header.getPageIndex() - 1] = receivedPdu;
                for (byte[] pdu : pdus) {
                    if (pdu != null) continue;
                    return null;
                }
                this.mSmsCbPageMap.remove(concatInfo);
            } else {
                pdus = new byte[][]{receivedPdu};
            }
            Iterator<SmsCbConcatInfo> iter = this.mSmsCbPageMap.keySet().iterator();
            while (iter.hasNext()) {
                SmsCbConcatInfo smsCbConcatInfo = iter.next();
                if (smsCbConcatInfo.matchesLocation(plmn, lac, cid)) continue;
                iter.remove();
            }
            return GsmSmsCbMessage.createSmsCbMessage(header, location, pdus);
        }
        catch (RuntimeException e) {
            this.loge("Error in decoding SMS CB pdu", e);
            return null;
        }
    }

    private static final class SmsCbConcatInfo {
        private final SmsCbHeader mHeader;
        private final SmsCbLocation mLocation;

        SmsCbConcatInfo(SmsCbHeader header, SmsCbLocation location) {
            this.mHeader = header;
            this.mLocation = location;
        }

        public int hashCode() {
            return this.mHeader.getSerialNumber() * 31 + this.mLocation.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SmsCbConcatInfo) {
                SmsCbConcatInfo other = (SmsCbConcatInfo)obj;
                return this.mHeader.getSerialNumber() == other.mHeader.getSerialNumber() && this.mLocation.equals(other.mLocation);
            }
            return false;
        }

        public boolean matchesLocation(String plmn, int lac, int cid) {
            return this.mLocation.isInLocationArea(plmn, lac, cid);
        }
    }
}

