/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.util.Pair;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.gsm.SmsCbHeader;
import java.io.UnsupportedEncodingException;

public class GsmSmsCbMessage {
    private static final String[] LANGUAGE_CODES_GROUP_0 = new String[]{"de", "en", "it", "fr", "es", "nl", "sv", "da", "pt", "fi", "no", "el", "tr", "hu", "pl", null};
    private static final String[] LANGUAGE_CODES_GROUP_2 = new String[]{"cs", "he", "ar", "ru", "is", null, null, null, null, null, null, null, null, null, null, null};
    private static final char CARRIAGE_RETURN = '\r';
    private static final int PDU_BODY_PAGE_LENGTH = 82;

    private GsmSmsCbMessage() {
    }

    static SmsCbMessage createSmsCbMessage(SmsCbHeader header, SmsCbLocation location, byte[][] pdus) throws IllegalArgumentException {
        if (header.isEtwsPrimaryNotification()) {
            return new SmsCbMessage(1, header.getGeographicalScope(), header.getSerialNumber(), location, header.getServiceCategory(), null, "ETWS", 3, header.getEtwsInfo(), header.getCmasInfo());
        }
        String language = null;
        StringBuilder sb = new StringBuilder();
        for (byte[] pdu : pdus) {
            Pair<String, String> p = GsmSmsCbMessage.parseBody(header, pdu);
            language = (String)p.first;
            sb.append((String)p.second);
        }
        int priority = header.isEmergencyMessage() ? 3 : 0;
        return new SmsCbMessage(1, header.getGeographicalScope(), header.getSerialNumber(), location, header.getServiceCategory(), language, sb.toString(), priority, header.getEtwsInfo(), header.getCmasInfo());
    }

    public static SmsCbMessage createSmsCbMessage(SmsCbLocation location, byte[][] pdus) throws IllegalArgumentException {
        SmsCbHeader header = new SmsCbHeader(pdus[0]);
        return GsmSmsCbMessage.createSmsCbMessage(header, location, pdus);
    }

    private static Pair<String, String> parseBody(SmsCbHeader header, byte[] pdu) {
        int encoding;
        String language = null;
        boolean hasLanguageIndicator = false;
        int dataCodingScheme = header.getDataCodingScheme();
        block0 : switch ((dataCodingScheme & 0xF0) >> 4) {
            case 0: {
                encoding = 1;
                language = LANGUAGE_CODES_GROUP_0[dataCodingScheme & 0xF];
                break;
            }
            case 1: {
                hasLanguageIndicator = true;
                if ((dataCodingScheme & 0xF) == 1) {
                    encoding = 3;
                    break;
                }
                encoding = 1;
                break;
            }
            case 2: {
                encoding = 1;
                language = LANGUAGE_CODES_GROUP_2[dataCodingScheme & 0xF];
                break;
            }
            case 3: {
                encoding = 1;
                break;
            }
            case 4: 
            case 5: {
                switch ((dataCodingScheme & 0xC) >> 2) {
                    case 1: {
                        encoding = 2;
                        break block0;
                    }
                    case 2: {
                        encoding = 3;
                        break block0;
                    }
                }
                encoding = 1;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 14: {
                throw new IllegalArgumentException("Unsupported GSM dataCodingScheme " + dataCodingScheme);
            }
            case 15: {
                if ((dataCodingScheme & 4) >> 2 == 1) {
                    encoding = 2;
                    break;
                }
                encoding = 1;
                break;
            }
            default: {
                encoding = 1;
            }
        }
        if (header.isUmtsFormat()) {
            int nrPages = pdu[6];
            if (pdu.length < 7 + 83 * nrPages) {
                throw new IllegalArgumentException("Pdu length " + pdu.length + " does not match " + nrPages + " pages");
            }
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < nrPages; ++i) {
                int offset = 7 + 83 * i;
                byte length = pdu[offset + 82];
                if (length > 82) {
                    throw new IllegalArgumentException("Page length " + length + " exceeds maximum value " + 82);
                }
                Pair<String, String> p = GsmSmsCbMessage.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator, language);
                language = (String)p.first;
                sb.append((String)p.second);
            }
            return new Pair<String, String>(language, sb.toString());
        }
        int offset = 6;
        int length = pdu.length - offset;
        return GsmSmsCbMessage.unpackBody(pdu, encoding, offset, length, hasLanguageIndicator, language);
    }

    private static Pair<String, String> unpackBody(byte[] pdu, int encoding, int offset, int length, boolean hasLanguageIndicator, String language) {
        String body = null;
        switch (encoding) {
            case 1: {
                body = GsmAlphabet.gsm7BitPackedToString(pdu, offset, length * 8 / 7);
                if (!hasLanguageIndicator || body == null || body.length() <= 2) break;
                language = body.substring(0, 2);
                body = body.substring(3);
                break;
            }
            case 3: {
                if (hasLanguageIndicator && pdu.length >= offset + 2) {
                    language = GsmAlphabet.gsm7BitPackedToString(pdu, offset, 2);
                    offset += 2;
                    length -= 2;
                }
                try {
                    body = new String(pdu, offset, length & 0xFFFE, "utf-16");
                    break;
                }
                catch (UnsupportedEncodingException e) {
                    throw new IllegalArgumentException("Error decoding UTF-16 message", e);
                }
            }
        }
        if (body != null) {
            for (int i = body.length() - 1; i >= 0; --i) {
                if (body.charAt(i) == '\r') continue;
                body = body.substring(0, i + 1);
                break;
            }
        } else {
            body = "";
        }
        return new Pair<String, String>(language, body);
    }
}

