/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.gsm;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.gsm.SimTlv;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UsimPhoneBookManager
extends Handler
implements IccConstants {
    private static final String LOG_TAG = "UsimPhoneBookManager";
    private static final boolean DBG = true;
    private PbrFile mPbrFile;
    private Boolean mIsPbrPresent;
    private IccFileHandler mFh;
    private AdnRecordCache mAdnCache;
    private Object mLock = new Object();
    private ArrayList<AdnRecord> mPhoneBookRecords;
    private boolean mEmailPresentInIap = false;
    private int mEmailTagNumberInIap = 0;
    private ArrayList<byte[]> mIapFileRecord;
    private ArrayList<byte[]> mEmailFileRecord;
    private Map<Integer, ArrayList<String>> mEmailsForAdnRec;
    private boolean mRefreshCache = false;
    private static final int EVENT_PBR_LOAD_DONE = 1;
    private static final int EVENT_USIM_ADN_LOAD_DONE = 2;
    private static final int EVENT_IAP_LOAD_DONE = 3;
    private static final int EVENT_EMAIL_LOAD_DONE = 4;
    private static final int USIM_TYPE1_TAG = 168;
    private static final int USIM_TYPE2_TAG = 169;
    private static final int USIM_TYPE3_TAG = 170;
    private static final int USIM_EFADN_TAG = 192;
    private static final int USIM_EFIAP_TAG = 193;
    private static final int USIM_EFEXT1_TAG = 194;
    private static final int USIM_EFSNE_TAG = 195;
    private static final int USIM_EFANR_TAG = 196;
    private static final int USIM_EFPBC_TAG = 197;
    private static final int USIM_EFGRP_TAG = 198;
    private static final int USIM_EFAAS_TAG = 199;
    private static final int USIM_EFGSD_TAG = 200;
    private static final int USIM_EFUID_TAG = 201;
    private static final int USIM_EFEMAIL_TAG = 202;
    private static final int USIM_EFCCP1_TAG = 203;

    public UsimPhoneBookManager(IccFileHandler fh, AdnRecordCache cache) {
        this.mFh = fh;
        this.mPhoneBookRecords = new ArrayList();
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
        this.mAdnCache = cache;
    }

    public void reset() {
        this.mPhoneBookRecords.clear();
        this.mIapFileRecord = null;
        this.mEmailFileRecord = null;
        this.mPbrFile = null;
        this.mIsPbrPresent = true;
        this.mRefreshCache = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AdnRecord> loadEfFilesFromUsim() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPhoneBookRecords.isEmpty()) {
                if (this.mRefreshCache) {
                    this.mRefreshCache = false;
                    this.refreshCache();
                }
                return this.mPhoneBookRecords;
            }
            if (!this.mIsPbrPresent.booleanValue()) {
                return null;
            }
            if (this.mPbrFile == null) {
                this.readPbrFileAndWait();
            }
            if (this.mPbrFile == null) {
                return null;
            }
            int numRecs = this.mPbrFile.mFileIds.size();
            for (int i = 0; i < numRecs; ++i) {
                this.readAdnFileAndWait(i);
                this.readEmailFileAndWait(i);
            }
        }
        return this.mPhoneBookRecords;
    }

    private void refreshCache() {
        if (this.mPbrFile == null) {
            return;
        }
        this.mPhoneBookRecords.clear();
        int numRecs = this.mPbrFile.mFileIds.size();
        for (int i = 0; i < numRecs; ++i) {
            this.readAdnFileAndWait(i);
        }
    }

    public void invalidateCache() {
        this.mRefreshCache = true;
    }

    private void readPbrFileAndWait() {
        this.mFh.loadEFLinearFixedAll(20272, this.obtainMessage(1));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
        }
    }

    private void readEmailFileAndWait(int recNum) {
        Map<Integer, Integer> fileIds = this.mPbrFile.mFileIds.get(recNum);
        if (fileIds == null) {
            return;
        }
        if (fileIds.containsKey(202)) {
            int efid = fileIds.get(202);
            if (this.mEmailPresentInIap) {
                this.readIapFileAndWait(fileIds.get(193));
                if (this.mIapFileRecord == null) {
                    Rlog.e(LOG_TAG, "Error: IAP file is empty");
                    return;
                }
            }
            this.mFh.loadEFLinearFixedAll(fileIds.get(202), this.obtainMessage(4));
            try {
                this.mLock.wait();
            }
            catch (InterruptedException e) {
                Rlog.e(LOG_TAG, "Interrupted Exception in readEmailFileAndWait");
            }
            if (this.mEmailFileRecord == null) {
                Rlog.e(LOG_TAG, "Error: Email file is empty");
                return;
            }
            this.updatePhoneAdnRecord();
        }
    }

    private void readIapFileAndWait(int efid) {
        this.mFh.loadEFLinearFixedAll(efid, this.obtainMessage(3));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e(LOG_TAG, "Interrupted Exception in readIapFileAndWait");
        }
    }

    private void updatePhoneAdnRecord() {
        if (this.mEmailFileRecord == null) {
            return;
        }
        int numAdnRecs = this.mPhoneBookRecords.size();
        if (this.mIapFileRecord != null) {
            for (int i = 0; i < numAdnRecs; ++i) {
                byte[] record = null;
                try {
                    record = this.mIapFileRecord.get(i);
                }
                catch (IndexOutOfBoundsException e) {
                    Rlog.e(LOG_TAG, "Error: Improper ICC card: No IAP record for ADN, continuing");
                    break;
                }
                byte recNum = record[this.mEmailTagNumberInIap];
                if (recNum == -1) continue;
                String[] emails = new String[]{this.readEmailRecord(recNum - 1)};
                AdnRecord rec = this.mPhoneBookRecords.get(i);
                if (rec != null) {
                    rec.setEmails(emails);
                } else {
                    rec = new AdnRecord("", "", emails);
                }
                this.mPhoneBookRecords.set(i, rec);
            }
        }
        int len = this.mPhoneBookRecords.size();
        if (this.mEmailsForAdnRec == null) {
            this.parseType1EmailFile(len);
        }
        for (int i = 0; i < numAdnRecs; ++i) {
            ArrayList<String> emailList = null;
            try {
                emailList = this.mEmailsForAdnRec.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                break;
            }
            if (emailList == null) continue;
            AdnRecord rec = this.mPhoneBookRecords.get(i);
            String[] emails = new String[emailList.size()];
            System.arraycopy(emailList.toArray(), 0, emails, 0, emailList.size());
            rec.setEmails(emails);
            this.mPhoneBookRecords.set(i, rec);
        }
    }

    void parseType1EmailFile(int numRecs) {
        this.mEmailsForAdnRec = new HashMap<Integer, ArrayList<String>>();
        byte[] emailRec = null;
        for (int i = 0; i < numRecs; ++i) {
            String email;
            try {
                emailRec = this.mEmailFileRecord.get(i);
            }
            catch (IndexOutOfBoundsException e) {
                Rlog.e(LOG_TAG, "Error: Improper ICC card: No email record for ADN, continuing");
                break;
            }
            byte adnRecNum = emailRec[emailRec.length - 1];
            if (adnRecNum == -1 || (email = this.readEmailRecord(i)) == null || email.equals("")) continue;
            ArrayList<String> val = this.mEmailsForAdnRec.get(adnRecNum - 1);
            if (val == null) {
                val = new ArrayList();
            }
            val.add(email);
            this.mEmailsForAdnRec.put(adnRecNum - 1, val);
        }
    }

    private String readEmailRecord(int recNum) {
        byte[] emailRec = null;
        try {
            emailRec = this.mEmailFileRecord.get(recNum);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
        String email = IccUtils.adnStringFieldToString(emailRec, 0, emailRec.length - 2);
        return email;
    }

    private void readAdnFileAndWait(int recNum) {
        Map<Integer, Integer> fileIds = this.mPbrFile.mFileIds.get(recNum);
        if (fileIds == null || fileIds.isEmpty()) {
            return;
        }
        int extEf = 0;
        if (fileIds.containsKey(194)) {
            extEf = fileIds.get(194);
        }
        this.mAdnCache.requestLoadAllAdnLike(fileIds.get(192), extEf, this.obtainMessage(2));
        try {
            this.mLock.wait();
        }
        catch (InterruptedException e) {
            Rlog.e(LOG_TAG, "Interrupted Exception in readAdnFileAndWait");
        }
    }

    private void createPbrFile(ArrayList<byte[]> records) {
        if (records == null) {
            this.mPbrFile = null;
            this.mIsPbrPresent = false;
            return;
        }
        this.mPbrFile = new PbrFile(records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.createPbrFile((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 2: {
                this.log("Loading USIM ADN records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mPhoneBookRecords.addAll((ArrayList)ar.result);
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 3: {
                this.log("Loading USIM IAP records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mIapFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
            case 4: {
                this.log("Loading USIM Email records done");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.mEmailFileRecord = (ArrayList)ar.result;
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notify();
                    break;
                }
            }
        }
    }

    private void log(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private class PbrFile {
        HashMap<Integer, Map<Integer, Integer>> mFileIds = new HashMap();

        PbrFile(ArrayList<byte[]> records) {
            int recNum = 0;
            for (byte[] record : records) {
                SimTlv recTlv = new SimTlv(record, 0, record.length);
                this.parseTag(recTlv, recNum);
                ++recNum;
            }
        }

        void parseTag(SimTlv tlv, int recNum) {
            HashMap<Integer, Integer> val = new HashMap<Integer, Integer>();
            do {
                int tag = tlv.getTag();
                switch (tag) {
                    case 168: 
                    case 169: 
                    case 170: {
                        byte[] data = tlv.getData();
                        SimTlv tlvEf = new SimTlv(data, 0, data.length);
                        this.parseEf(tlvEf, val, tag);
                    }
                }
            } while (tlv.nextObject());
            this.mFileIds.put(recNum, val);
        }

        void parseEf(SimTlv tlv, Map<Integer, Integer> val, int parentTag) {
            int tagNumberWithinParentTag = 0;
            do {
                int tag = tlv.getTag();
                if (parentTag == 169 && tag == 202) {
                    UsimPhoneBookManager.this.mEmailPresentInIap = true;
                    UsimPhoneBookManager.this.mEmailTagNumberInIap = tagNumberWithinParentTag;
                }
                switch (tag) {
                    case 192: 
                    case 193: 
                    case 194: 
                    case 195: 
                    case 196: 
                    case 197: 
                    case 198: 
                    case 199: 
                    case 200: 
                    case 201: 
                    case 202: 
                    case 203: {
                        byte[] data = tlv.getData();
                        int efid = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
                        val.put(tag, efid);
                    }
                }
                ++tagNumberWithinParentTag;
            } while (tlv.nextObject());
        }
    }
}

