/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telecom.ConferenceParticipant;
import android.telecom.Connection;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import com.android.ims.ImsCall;
import com.android.ims.ImsCallProfile;
import com.android.ims.ImsConnectionStateListener;
import com.android.ims.ImsEcbm;
import com.android.ims.ImsException;
import com.android.ims.ImsManager;
import com.android.ims.ImsReasonInfo;
import com.android.ims.ImsUtInterface;
import com.android.ims.internal.IImsVideoCallProvider;
import com.android.ims.internal.ImsVideoCallProviderWrapper;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.imsphone.ImsPhone;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.imsphone.ImsPhoneConnection;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public final class ImsPhoneCallTracker
extends CallTracker {
    static final String LOG_TAG = "ImsPhoneCallTracker";
    private static final boolean DBG = true;
    private static final boolean VERBOSE_STATE_LOGGING = false;
    private boolean[] mImsFeatureEnabled = new boolean[]{false, false, false, false};
    private final String[] mImsFeatureStrings = new String[]{"VoLTE", "ViLTE", "VoWiFi", "ViWiFi"};
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("com.android.ims.IMS_INCOMING_CALL")) {
                ImsPhoneCallTracker.this.log("onReceive : incoming call intent");
                if (ImsPhoneCallTracker.this.mImsManager == null) {
                    return;
                }
                if (ImsPhoneCallTracker.this.mServiceId < 0) {
                    return;
                }
                try {
                    boolean isUssd = intent.getBooleanExtra("android:ussd", false);
                    if (isUssd) {
                        ImsPhoneCallTracker.this.log("onReceive : USSD");
                        ImsPhoneCallTracker.this.mUssdSession = ImsPhoneCallTracker.this.mImsManager.takeCall(ImsPhoneCallTracker.this.mServiceId, intent, ImsPhoneCallTracker.this.mImsUssdListener);
                        if (ImsPhoneCallTracker.this.mUssdSession != null) {
                            ImsPhoneCallTracker.this.mUssdSession.accept(2);
                        }
                        return;
                    }
                    ImsCall imsCall = ImsPhoneCallTracker.this.mImsManager.takeCall(ImsPhoneCallTracker.this.mServiceId, intent, ImsPhoneCallTracker.this.mImsCallListener);
                    ImsPhoneConnection conn = new ImsPhoneConnection(ImsPhoneCallTracker.this.mPhone.getContext(), imsCall, ImsPhoneCallTracker.this, ImsPhoneCallTracker.this.mRingingCall);
                    ImsPhoneCallTracker.this.addConnection(conn);
                    ImsPhoneCallTracker.this.setVideoCallProvider(conn, imsCall);
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() != Call.State.IDLE || ImsPhoneCallTracker.this.mBackgroundCall.getState() != Call.State.IDLE) {
                        conn.update(imsCall, Call.State.WAITING);
                    }
                    ImsPhoneCallTracker.this.mPhone.notifyNewRingingConnection(conn);
                    ImsPhoneCallTracker.this.mPhone.notifyIncomingRing();
                    ImsPhoneCallTracker.this.updatePhoneState();
                    ImsPhoneCallTracker.this.mPhone.notifyPreciseCallStateChanged();
                }
                catch (ImsException e) {
                    ImsPhoneCallTracker.this.loge("onReceive : exception " + (Object)((Object)e));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    };
    static final int MAX_CONNECTIONS = 7;
    static final int MAX_CONNECTIONS_PER_CALL = 5;
    private static final int EVENT_HANGUP_PENDINGMO = 18;
    private static final int EVENT_RESUME_BACKGROUND = 19;
    private static final int EVENT_DIAL_PENDINGMO = 20;
    private static final int TIMEOUT_HANGUP_PENDINGMO = 500;
    private ArrayList<ImsPhoneConnection> mConnections = new ArrayList();
    private RegistrantList mVoiceCallEndedRegistrants = new RegistrantList();
    private RegistrantList mVoiceCallStartedRegistrants = new RegistrantList();
    final ImsPhoneCall mRingingCall = new ImsPhoneCall(this, "RG");
    final ImsPhoneCall mForegroundCall = new ImsPhoneCall(this, "FG");
    final ImsPhoneCall mBackgroundCall = new ImsPhoneCall(this, "BG");
    final ImsPhoneCall mHandoverCall = new ImsPhoneCall(this, "HO");
    private ImsPhoneConnection mPendingMO;
    private int mClirMode = 0;
    private Object mSyncHold = new Object();
    private ImsCall mUssdSession = null;
    private Message mPendingUssd = null;
    ImsPhone mPhone;
    private boolean mDesiredMute = false;
    private boolean mOnHoldToneStarted = false;
    PhoneConstants.State mState = PhoneConstants.State.IDLE;
    private ImsManager mImsManager;
    private int mServiceId = -1;
    private Call.SrvccState mSrvccState = Call.SrvccState.NONE;
    private boolean mIsInEmergencyCall = false;
    private int pendingCallClirMode;
    private int mPendingCallVideoState;
    private boolean pendingCallInEcm = false;
    private boolean mSwitchingFgAndBgCalls = false;
    private ImsCall mCallExpectedToResume = null;
    private ImsCall.Listener mImsCallListener = new ImsCall.Listener(){

        public void onCallProgressing(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallProgressing");
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ALERTING, 0);
        }

        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallStarted");
            ImsPhoneCallTracker.this.mPendingMO = null;
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
        }

        public void onCallUpdated(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallUpdated");
            if (imsCall == null) {
                return;
            }
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, conn.getCall().mState, 0, true);
            }
        }

        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallStartFailed reasonCode=" + reasonInfo.getCode());
            if (ImsPhoneCallTracker.this.mPendingMO != null) {
                if (reasonInfo.getCode() == 146 && ImsPhoneCallTracker.this.mBackgroundCall.getState() == Call.State.IDLE && ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.IDLE) {
                    ImsPhoneCallTracker.this.mForegroundCall.detach(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.removeConnection(ImsPhoneCallTracker.this.mPendingMO);
                    ImsPhoneCallTracker.this.mPendingMO.finalize();
                    ImsPhoneCallTracker.this.mPendingMO = null;
                    ImsPhoneCallTracker.this.mPhone.initiateSilentRedial();
                    return;
                }
                int cause = ImsPhoneCallTracker.this.getDisconnectCauseFromReasonInfo(reasonInfo);
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
                ImsPhoneCallTracker.this.mPendingMO = null;
            }
        }

        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallTerminated reasonCode=" + reasonInfo.getCode());
            Call.State oldState = ImsPhoneCallTracker.this.mForegroundCall.getState();
            int cause = ImsPhoneCallTracker.this.getDisconnectCauseFromReasonInfo(reasonInfo);
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            ImsPhoneCallTracker.this.log("cause = " + cause + " conn = " + conn);
            if (conn != null && conn.isIncoming() && conn.getConnectTime() == 0L) {
                if (cause == 2) {
                    cause = 1;
                }
                ImsPhoneCallTracker.this.log("Incoming connection of 0 connect time detected - translated cause = " + cause);
            }
            if (cause == 2 && conn != null && conn.getImsCall().isMerged()) {
                cause = 45;
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.DISCONNECTED, cause);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallHeld(ImsCall imsCall) {
            if (ImsPhoneCallTracker.this.mForegroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (fg) " + imsCall);
            } else if (ImsPhoneCallTracker.this.mBackgroundCall.getImsCall() == imsCall) {
                ImsPhoneCallTracker.this.log("onCallHeld (bg) " + imsCall);
            }
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State oldState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.HOLDING, 0);
                if (oldState == Call.State.ACTIVE) {
                    if (ImsPhoneCallTracker.this.mForegroundCall.getState() == Call.State.HOLDING || ImsPhoneCallTracker.this.mRingingCall.getState() == Call.State.WAITING) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(19);
                    } else {
                        if (ImsPhoneCallTracker.this.mPendingMO != null) {
                            ImsPhoneCallTracker.this.sendEmptyMessage(20);
                        }
                        ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallHoldFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHoldFailed reasonCode=" + reasonInfo.getCode());
            Object object = ImsPhoneCallTracker.this.mSyncHold;
            synchronized (object) {
                Call.State bgState = ImsPhoneCallTracker.this.mBackgroundCall.getState();
                if (reasonInfo.getCode() == 148) {
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.sendEmptyMessage(20);
                    }
                } else if (bgState == Call.State.ACTIVE) {
                    ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                    if (ImsPhoneCallTracker.this.mPendingMO != null) {
                        ImsPhoneCallTracker.this.mPendingMO.setDisconnectCause(36);
                        ImsPhoneCallTracker.this.sendEmptyMessageDelayed(18, 500L);
                    }
                }
            }
        }

        public void onCallResumed(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallResumed");
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls && imsCall != ImsPhoneCallTracker.this.mCallExpectedToResume) {
                ImsPhoneCallTracker.this.log("onCallResumed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
            }
            ImsPhoneCallTracker.this.processCallStateChange(imsCall, Call.State.ACTIVE, 0);
        }

        public void onCallResumeFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            if (ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls && imsCall == ImsPhoneCallTracker.this.mCallExpectedToResume) {
                ImsPhoneCallTracker.this.log("onCallResumeFailed : switching " + ImsPhoneCallTracker.this.mForegroundCall + " with " + ImsPhoneCallTracker.this.mBackgroundCall);
                ImsPhoneCallTracker.this.mForegroundCall.switchWith(ImsPhoneCallTracker.this.mBackgroundCall);
                ImsPhoneCallTracker.this.mCallExpectedToResume = null;
                ImsPhoneCallTracker.this.mSwitchingFgAndBgCalls = false;
            }
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(Phone.SuppService.RESUME);
        }

        public void onCallResumeReceived(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallResumeReceived");
            if (ImsPhoneCallTracker.this.mOnHoldToneStarted) {
                ImsPhoneCallTracker.this.mPhone.stopOnHoldTone();
                ImsPhoneCallTracker.this.mOnHoldToneStarted = false;
            }
        }

        public void onCallHoldReceived(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("onCallHoldReceived");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null && conn.getState() == Call.State.ACTIVE && !ImsPhoneCallTracker.this.mOnHoldToneStarted && ImsPhoneCall.isLocalTone(imsCall)) {
                ImsPhoneCallTracker.this.mPhone.startOnHoldTone();
                ImsPhoneCallTracker.this.mOnHoldToneStarted = true;
            }
        }

        public void onCallMerged(final ImsCall call, ImsCall peerCall, boolean swapCalls) {
            ImsPhoneCall peerImsPhoneCall;
            ImsPhoneCallTracker.this.log("onCallMerged");
            ImsPhoneCall foregroundImsPhoneCall = ImsPhoneCallTracker.this.findConnection(call).getCall();
            ImsPhoneConnection peerConnection = ImsPhoneCallTracker.this.findConnection(peerCall);
            ImsPhoneCall imsPhoneCall = peerImsPhoneCall = peerConnection == null ? null : peerConnection.getCall();
            if (swapCalls) {
                ImsPhoneCallTracker.this.switchAfterConferenceSuccess();
            }
            foregroundImsPhoneCall.merge(peerImsPhoneCall, Call.State.ACTIVE);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
                        ImsPhoneCallTracker.this.log("onCallMerged: ImsPhoneConnection=" + conn);
                        ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                        ImsPhoneCallTracker.this.setVideoCallProvider(conn, call);
                        ImsPhoneCallTracker.this.log("onCallMerged: CurrentVideoProvider=" + conn.getVideoProvider());
                    }
                    catch (Exception e) {
                        ImsPhoneCallTracker.this.loge("onCallMerged: exception " + e);
                    }
                }
            };
            ImsPhoneCallTracker.this.post(r);
            ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mForegroundCall.getImsCall(), Call.State.ACTIVE, 0);
            if (peerConnection != null) {
                ImsPhoneCallTracker.this.processCallStateChange(ImsPhoneCallTracker.this.mBackgroundCall.getImsCall(), Call.State.HOLDING, 0);
            }
            if (!call.isMergeRequestedByConf()) {
                ImsPhoneCallTracker.this.log("onCallMerged :: calling onMultipartyStateChanged()");
                this.onMultipartyStateChanged(call, true);
            } else {
                ImsPhoneCallTracker.this.log("onCallMerged :: Merge requested by existing conference.");
                call.resetIsMergeRequestedByConf(false);
            }
            ImsPhoneCallTracker.this.logState();
        }

        public void onCallMergeFailed(ImsCall call, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallMergeFailed reasonInfo=" + reasonInfo);
            ImsPhoneCallTracker.this.mPhone.notifySuppServiceFailed(Phone.SuppService.CONFERENCE);
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                conn.onConferenceMergeFailed();
            }
        }

        public void onConferenceParticipantsStateChanged(ImsCall call, List<ConferenceParticipant> participants) {
            ImsPhoneCallTracker.this.log("onConferenceParticipantsStateChanged");
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(call);
            if (conn != null) {
                conn.updateConferenceParticipants(participants);
            }
        }

        public void onCallSessionTtyModeReceived(ImsCall call, int mode) {
            ImsPhoneCallTracker.this.mPhone.onTtyModeReceived(mode);
        }

        public void onCallHandover(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHandover ::  srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
        }

        public void onCallHandoverFailed(ImsCall imsCall, int srcAccessTech, int targetAccessTech, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("onCallHandoverFailed :: srcAccessTech=" + srcAccessTech + ", targetAccessTech=" + targetAccessTech + ", reasonInfo=" + reasonInfo);
        }

        public void onMultipartyStateChanged(ImsCall imsCall, boolean isMultiParty) {
            ImsPhoneCallTracker.this.log("onMultipartyStateChanged to " + (isMultiParty ? "Y" : "N"));
            ImsPhoneConnection conn = ImsPhoneCallTracker.this.findConnection(imsCall);
            if (conn != null) {
                conn.updateMultipartyState(isMultiParty);
            }
        }
    };
    private ImsCall.Listener mImsUssdListener = new ImsCall.Listener(){

        public void onCallStarted(ImsCall imsCall) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStarted");
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession && ImsPhoneCallTracker.this.mPendingUssd != null) {
                AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd);
                ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                ImsPhoneCallTracker.this.mPendingUssd = null;
            }
        }

        public void onCallStartFailed(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallStartFailed reasonCode=" + reasonInfo.getCode());
            this.onCallTerminated(imsCall, reasonInfo);
        }

        public void onCallTerminated(ImsCall imsCall, ImsReasonInfo reasonInfo) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallTerminated reasonCode=" + reasonInfo.getCode());
            if (imsCall == ImsPhoneCallTracker.this.mUssdSession) {
                ImsPhoneCallTracker.this.mUssdSession = null;
                if (ImsPhoneCallTracker.this.mPendingUssd != null) {
                    CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                    AsyncResult.forMessage(ImsPhoneCallTracker.this.mPendingUssd, null, ex);
                    ImsPhoneCallTracker.this.mPendingUssd.sendToTarget();
                    ImsPhoneCallTracker.this.mPendingUssd = null;
                }
            }
            imsCall.close();
        }

        public void onCallUssdMessageReceived(ImsCall call, int mode, String ussdMessage) {
            ImsPhoneCallTracker.this.log("mImsUssdListener onCallUssdMessageReceived mode=" + mode);
            int ussdMode = -1;
            switch (mode) {
                case 1: {
                    ussdMode = 1;
                    break;
                }
                case 0: {
                    ussdMode = 0;
                }
            }
            ImsPhoneCallTracker.this.mPhone.onIncomingUSSD(ussdMode, ussdMessage);
        }
    };
    private ImsConnectionStateListener mImsConnectionStateListener = new ImsConnectionStateListener(){

        public void onImsConnected() {
            ImsPhoneCallTracker.this.log("onImsConnected");
            ImsPhoneCallTracker.this.mPhone.setServiceState(0);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(true);
        }

        public void onImsDisconnected(ImsReasonInfo imsReasonInfo) {
            ImsPhoneCallTracker.this.log("onImsDisconnected imsReasonInfo=" + imsReasonInfo);
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
            ImsPhoneCallTracker.this.mPhone.setImsRegistered(false);
            ImsPhoneCallTracker.this.mPhone.processDisconnectReason(imsReasonInfo);
        }

        public void onImsProgressing() {
            ImsPhoneCallTracker.this.log("onImsProgressing");
        }

        public void onImsResumed() {
            ImsPhoneCallTracker.this.log("onImsResumed");
            ImsPhoneCallTracker.this.mPhone.setServiceState(0);
        }

        public void onImsSuspended() {
            ImsPhoneCallTracker.this.log("onImsSuspended");
            ImsPhoneCallTracker.this.mPhone.setServiceState(1);
        }

        public void onFeatureCapabilityChanged(int serviceClass, int[] enabledFeatures, int[] disabledFeatures) {
            if (serviceClass == 1) {
                boolean tmpIsVideoCallEnabled = ImsPhoneCallTracker.this.isVideoCallEnabled();
                for (int i = 0; i <= 3; ++i) {
                    if (enabledFeatures[i] == i) {
                        ImsPhoneCallTracker.this.log("onFeatureCapabilityChanged(" + i + ", " + ImsPhoneCallTracker.this.mImsFeatureStrings[i] + "): value=true");
                        ((ImsPhoneCallTracker)ImsPhoneCallTracker.this).mImsFeatureEnabled[i] = true;
                        continue;
                    }
                    if (enabledFeatures[i] == -1) {
                        ImsPhoneCallTracker.this.log("onFeatureCapabilityChanged(" + i + ", " + ImsPhoneCallTracker.this.mImsFeatureStrings[i] + "): value=false");
                        ((ImsPhoneCallTracker)ImsPhoneCallTracker.this).mImsFeatureEnabled[i] = false;
                        continue;
                    }
                    ImsPhoneCallTracker.this.loge("onFeatureCapabilityChanged(" + i + ", " + ImsPhoneCallTracker.this.mImsFeatureStrings[i] + "): unexpectedValue=" + enabledFeatures[i]);
                }
                if (tmpIsVideoCallEnabled != ImsPhoneCallTracker.this.isVideoCallEnabled()) {
                    ImsPhoneCallTracker.this.mPhone.notifyForVideoCapabilityChanged(ImsPhoneCallTracker.this.isVideoCallEnabled());
                }
                ImsPhoneCallTracker.this.log("onFeatureCapabilityChanged: isVowifiEnabled=" + ImsPhoneCallTracker.this.isVowifiEnabled());
                for (ImsPhoneConnection connection : ImsPhoneCallTracker.this.mConnections) {
                    connection.updateWifiState();
                }
                ImsPhoneCallTracker.this.mPhone.onFeatureCapabilityChanged();
            }
        }
    };

    ImsPhoneCallTracker(ImsPhone phone) {
        this.mPhone = phone;
        IntentFilter intentfilter = new IntentFilter();
        intentfilter.addAction("com.android.ims.IMS_INCOMING_CALL");
        this.mPhone.getContext().registerReceiver(this.mReceiver, intentfilter);
        Thread t = new Thread(){

            @Override
            public void run() {
                ImsPhoneCallTracker.this.getImsService();
            }
        };
        t.start();
    }

    private PendingIntent createIncomingCallPendingIntent() {
        Intent intent = new Intent("com.android.ims.IMS_INCOMING_CALL");
        intent.addFlags(0x10000000);
        return PendingIntent.getBroadcast(this.mPhone.getContext(), 0, intent, 0x8000000);
    }

    private void getImsService() {
        this.log("getImsService");
        this.mImsManager = ImsManager.getInstance((Context)this.mPhone.getContext(), (int)this.mPhone.getPhoneId());
        try {
            this.mServiceId = this.mImsManager.open(1, this.createIncomingCallPendingIntent(), this.mImsConnectionStateListener);
            this.getEcbmInterface().setEcbmStateListener(this.mPhone.mImsEcbmStateListener);
            if (this.mPhone.isInEcm()) {
                this.mPhone.exitEmergencyCallbackMode();
            }
            int mPreferredTtyMode = Settings.Secure.getInt(this.mPhone.getContext().getContentResolver(), "preferred_tty_mode", 0);
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), this.mServiceId, mPreferredTtyMode, null);
        }
        catch (ImsException e) {
            this.loge("getImsService: " + (Object)((Object)e));
            this.mImsManager = null;
        }
    }

    public void dispose() {
        this.log("dispose");
        this.mRingingCall.dispose();
        this.mBackgroundCall.dispose();
        this.mForegroundCall.dispose();
        this.mHandoverCall.dispose();
        this.clearDisconnected();
        this.mPhone.getContext().unregisterReceiver(this.mReceiver);
    }

    protected void finalize() {
        this.log("ImsPhoneCallTracker finalized");
    }

    @Override
    public void registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    @Override
    public void registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    Connection dial(String dialString, int videoState, Bundle intentExtras) throws CallStateException {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mPhone.getContext());
        int oirMode = sp.getInt("clir_key", 0);
        return this.dial(dialString, oirMode, videoState, intentExtras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Connection dial(String dialString, int clirMode, int videoState, Bundle intentExtras) throws CallStateException {
        boolean isPhoneInEcmMode = SystemProperties.getBoolean("ril.cdma.inecmmode", false);
        boolean isEmergencyNumber = PhoneNumberUtils.isEmergencyNumber(dialString);
        this.log("dial clirMode=" + clirMode);
        this.clearDisconnected();
        if (this.mImsManager == null) {
            throw new CallStateException("service not available");
        }
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        if (isPhoneInEcmMode && isEmergencyNumber) {
            this.handleEcmTimer(1);
        }
        boolean holdBeforeDial = false;
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            if (this.mBackgroundCall.getState() != Call.State.IDLE) {
                throw new CallStateException("cannot dial in current state");
            }
            holdBeforeDial = true;
            this.mPendingCallVideoState = videoState;
            this.switchWaitingOrHoldingAndActive();
        }
        Call.State fgState = Call.State.IDLE;
        Call.State bgState = Call.State.IDLE;
        this.mClirMode = clirMode;
        Object object = this.mSyncHold;
        synchronized (object) {
            if (holdBeforeDial) {
                fgState = this.mForegroundCall.getState();
                bgState = this.mBackgroundCall.getState();
                if (fgState == Call.State.ACTIVE) {
                    throw new CallStateException("cannot dial in current state");
                }
                if (bgState == Call.State.HOLDING) {
                    holdBeforeDial = false;
                }
            }
            this.mPendingMO = new ImsPhoneConnection(this.mPhone.getContext(), this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall);
        }
        this.addConnection(this.mPendingMO);
        if (!holdBeforeDial) {
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyNumber) {
                this.dialInternal(this.mPendingMO, clirMode, videoState);
            } else {
                try {
                    this.getEcbmInterface().exitEmergencyCallbackMode();
                }
                catch (ImsException e) {
                    e.printStackTrace();
                    throw new CallStateException("service not available");
                }
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.pendingCallClirMode = clirMode;
                this.mPendingCallVideoState = videoState;
                this.pendingCallInEcm = true;
            }
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private void handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                this.log("handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private void dialInternal(ImsPhoneConnection conn, int clirMode, int videoState) {
        if (conn == null) {
            return;
        }
        if (conn.getAddress() == null || conn.getAddress().length() == 0 || conn.getAddress().indexOf(78) >= 0) {
            conn.setDisconnectCause(7);
            this.sendEmptyMessageDelayed(18, 500L);
            return;
        }
        this.setMute(false);
        int serviceType = PhoneNumberUtils.isEmergencyNumber(conn.getAddress()) ? 2 : 1;
        int callType = ImsCallProfile.getCallTypeFromVideoState(videoState);
        conn.setVideoState(videoState);
        try {
            String[] callees = new String[]{conn.getAddress()};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, serviceType, callType);
            profile.setCallExtraInt("oir", clirMode);
            ImsCall imsCall = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsCallListener);
            conn.setImsCall(imsCall);
            this.setVideoCallProvider(conn, imsCall);
        }
        catch (ImsException e) {
            this.loge("dialInternal : " + (Object)((Object)e));
            conn.setDisconnectCause(36);
            this.sendEmptyMessageDelayed(18, 500L);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    void acceptCall(int videoState) throws CallStateException {
        this.log("acceptCall");
        if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
            throw new CallStateException("cannot accept call");
        }
        if (this.mRingingCall.getState() == Call.State.WAITING && this.mForegroundCall.getState().isAlive()) {
            this.setMute(false);
            this.mPendingCallVideoState = videoState;
            this.switchWaitingOrHoldingAndActive();
        } else if (this.mRingingCall.getState().isRinging()) {
            this.log("acceptCall: incoming...");
            this.setMute(false);
            try {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall == null) {
                    throw new CallStateException("no valid ims call");
                }
                imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(videoState));
            }
            catch (ImsException e) {
                throw new CallStateException("cannot accept call");
            }
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    void rejectCall() throws CallStateException {
        this.log("rejectCall");
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.hangup(this.mRingingCall);
    }

    private void switchAfterConferenceSuccess() {
        this.log("switchAfterConferenceSuccess fg =" + (Object)((Object)this.mForegroundCall.getState()) + ", bg = " + (Object)((Object)this.mBackgroundCall.getState()));
        if (this.mBackgroundCall.getState() == Call.State.HOLDING) {
            this.log("switchAfterConferenceSuccess");
            this.mForegroundCall.switchWith(this.mBackgroundCall);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void switchWaitingOrHoldingAndActive() throws CallStateException {
        this.log("switchWaitingOrHoldingAndActive");
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            ImsCall imsCall = this.mForegroundCall.getImsCall();
            if (imsCall == null) {
                throw new CallStateException("no ims call");
            }
            this.mSwitchingFgAndBgCalls = true;
            this.mCallExpectedToResume = this.mBackgroundCall.getImsCall();
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            try {
                imsCall.hold();
                if (this.mCallExpectedToResume != null) return;
                this.mSwitchingFgAndBgCalls = false;
                return;
            }
            catch (ImsException e) {
                this.mForegroundCall.switchWith(this.mBackgroundCall);
                throw new CallStateException(e.getMessage());
            }
        } else {
            if (this.mBackgroundCall.getState() != Call.State.HOLDING) return;
            this.resumeWaitingOrHolding();
        }
    }

    void conference() {
        long conferenceConnectTime;
        this.log("conference");
        ImsCall fgImsCall = this.mForegroundCall.getImsCall();
        if (fgImsCall == null) {
            this.log("conference no foreground ims call");
            return;
        }
        ImsCall bgImsCall = this.mBackgroundCall.getImsCall();
        if (bgImsCall == null) {
            this.log("conference no background ims call");
            return;
        }
        long foregroundConnectTime = this.mForegroundCall.getEarliestConnectTime();
        long backgroundConnectTime = this.mBackgroundCall.getEarliestConnectTime();
        if (foregroundConnectTime > 0L && backgroundConnectTime > 0L) {
            conferenceConnectTime = Math.min(this.mForegroundCall.getEarliestConnectTime(), this.mBackgroundCall.getEarliestConnectTime());
            this.log("conference - using connect time = " + conferenceConnectTime);
        } else if (foregroundConnectTime > 0L) {
            this.log("conference - bg call connect time is 0; using fg = " + foregroundConnectTime);
            conferenceConnectTime = foregroundConnectTime;
        } else {
            this.log("conference - fg call connect time is 0; using bg = " + backgroundConnectTime);
            conferenceConnectTime = backgroundConnectTime;
        }
        ImsPhoneConnection foregroundConnection = this.mForegroundCall.getFirstConnection();
        if (foregroundConnection != null) {
            foregroundConnection.setConferenceConnectTime(conferenceConnectTime);
        }
        try {
            fgImsCall.merge(bgImsCall);
        }
        catch (ImsException e) {
            this.log("conference " + e.getMessage());
        }
    }

    void explicitCallTransfer() {
    }

    void clearDisconnected() {
        this.log("clearDisconnected");
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    boolean canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    boolean canDial() {
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive());
        return ret;
    }

    boolean canTransfer() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING;
    }

    private void internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
        this.mHandoverCall.clearDisconnected();
    }

    private void updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        this.mState = this.mRingingCall.isRinging() ? PhoneConstants.State.RINGING : (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle() ? PhoneConstants.State.OFFHOOK : PhoneConstants.State.IDLE);
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("updatePhoneState oldState=" + (Object)((Object)oldState) + ", newState=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
        }
    }

    private void handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private void dumpState() {
        int i;
        this.log("Phone State:" + (Object)((Object)this.mState));
        this.log("Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
        this.log("Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            this.log(((Object)l.get(i)).toString());
        }
    }

    void setUiTTYMode(int uiTtyMode, Message onComplete) {
        try {
            this.mImsManager.setUiTTYMode(this.mPhone.getContext(), this.mServiceId, uiTtyMode, onComplete);
        }
        catch (ImsException e) {
            this.loge("setTTYMode : " + (Object)((Object)e));
            this.mPhone.sendErrorResponse(onComplete, e);
        }
    }

    void setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mForegroundCall.setMute(mute);
    }

    boolean getMute() {
        return this.mDesiredMute;
    }

    void sendDtmf(char c, Message result) {
        this.log("sendDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.sendDtmf(c, result);
        }
    }

    void startDtmf(char c) {
        this.log("startDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.startDtmf(c);
        } else {
            this.loge("startDtmf : no foreground call");
        }
    }

    void stopDtmf() {
        this.log("stopDtmf");
        ImsCall imscall = this.mForegroundCall.getImsCall();
        if (imscall != null) {
            imscall.stopDtmf();
        } else {
            this.loge("stopDtmf : no foreground call");
        }
    }

    void hangup(ImsPhoneConnection conn) throws CallStateException {
        this.log("hangup connection");
        if (conn.getOwner() != this) {
            throw new CallStateException("ImsPhoneConnection " + conn + "does not belong to ImsPhoneCallTracker " + this);
        }
        this.hangup(conn.getCall());
    }

    void hangup(ImsPhoneCall call) throws CallStateException {
        this.log("hangup call");
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections");
        }
        ImsCall imsCall = call.getImsCall();
        boolean rejectCall = false;
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup incoming");
            rejectCall = true;
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
            } else {
                this.log("(foregnd) hangup foreground");
            }
        } else if (call == this.mBackgroundCall) {
            this.log("(backgnd) hangup waiting or background");
        } else {
            throw new CallStateException("ImsPhoneCall " + call + "does not belong to ImsPhoneCallTracker " + this);
        }
        call.onHangupLocal();
        try {
            if (imsCall != null) {
                if (rejectCall) {
                    imsCall.reject(504);
                } else {
                    imsCall.terminate(501);
                }
            } else if (this.mPendingMO != null && call == this.mForegroundCall) {
                this.mPendingMO.update(null, Call.State.DISCONNECTED);
                this.mPendingMO.onDisconnect();
                this.removeConnection(this.mPendingMO);
                this.mPendingMO = null;
                this.updatePhoneState();
                this.removeMessages(20);
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
        this.mPhone.notifyPreciseCallStateChanged();
    }

    void callEndCleanupHandOverCallIfAny() {
        if (this.mHandoverCall.mConnections.size() > 0) {
            this.log("callEndCleanupHandOverCallIfAny, mHandoverCall.mConnections=" + this.mHandoverCall.mConnections);
            this.mHandoverCall.mConnections.clear();
            this.mState = PhoneConstants.State.IDLE;
        }
    }

    void resumeWaitingOrHolding() throws CallStateException {
        this.log("resumeWaitingOrHolding");
        try {
            if (this.mForegroundCall.getState().isAlive()) {
                ImsCall imsCall = this.mForegroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                }
            } else if (this.mRingingCall.getState() == Call.State.WAITING) {
                ImsCall imsCall = this.mRingingCall.getImsCall();
                if (imsCall != null) {
                    imsCall.accept(ImsCallProfile.getCallTypeFromVideoState(this.mPendingCallVideoState));
                }
            } else {
                ImsCall imsCall = this.mBackgroundCall.getImsCall();
                if (imsCall != null) {
                    imsCall.resume();
                }
            }
        }
        catch (ImsException e) {
            throw new CallStateException(e.getMessage());
        }
    }

    void sendUSSD(String ussdString, Message response) {
        this.log("sendUSSD");
        try {
            if (this.mUssdSession != null) {
                this.mUssdSession.sendUssd(ussdString);
                AsyncResult.forMessage(response, null, null);
                response.sendToTarget();
                return;
            }
            String[] callees = new String[]{ussdString};
            ImsCallProfile profile = this.mImsManager.createCallProfile(this.mServiceId, 1, 2);
            profile.setCallExtraInt("dialstring", 2);
            this.mUssdSession = this.mImsManager.makeCall(this.mServiceId, profile, callees, this.mImsUssdListener);
        }
        catch (ImsException e) {
            this.loge("sendUSSD : " + (Object)((Object)e));
            this.mPhone.sendErrorResponse(response, e);
        }
    }

    void cancelUSSD() {
        if (this.mUssdSession == null) {
            return;
        }
        try {
            this.mUssdSession.terminate(501);
        }
        catch (ImsException imsException) {
            // empty catch block
        }
    }

    private synchronized ImsPhoneConnection findConnection(ImsCall imsCall) {
        for (ImsPhoneConnection conn : this.mConnections) {
            if (conn.getImsCall() != imsCall) continue;
            return conn;
        }
        return null;
    }

    private synchronized void removeConnection(ImsPhoneConnection conn) {
        this.mConnections.remove(conn);
    }

    private synchronized void addConnection(ImsPhoneConnection conn) {
        this.mConnections.add(conn);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause) {
        this.log("processCallStateChange " + imsCall + " state=" + (Object)((Object)state) + " cause=" + cause);
        this.processCallStateChange(imsCall, state, cause, false);
    }

    private void processCallStateChange(ImsCall imsCall, Call.State state, int cause, boolean ignoreState) {
        this.log("processCallStateChange state=" + (Object)((Object)state) + " cause=" + cause + " ignoreState=" + ignoreState);
        if (imsCall == null) {
            return;
        }
        boolean changed = false;
        ImsPhoneConnection conn = this.findConnection(imsCall);
        if (conn == null) {
            return;
        }
        if (ignoreState) {
            conn.updateMediaCapabilities(imsCall);
            return;
        }
        changed = conn.update(imsCall, state);
        if (state == Call.State.DISCONNECTED) {
            changed = conn.onDisconnect(cause) || changed;
            conn.getCall().detach(conn);
            this.removeConnection(conn);
        }
        if (changed) {
            if (conn.getCall() == this.mHandoverCall) {
                return;
            }
            this.updatePhoneState();
            this.mPhone.notifyPreciseCallStateChanged();
        }
    }

    private int getDisconnectCauseFromReasonInfo(ImsReasonInfo reasonInfo) {
        int cause = 36;
        int code = reasonInfo.getCode();
        switch (code) {
            case 337: 
            case 341: {
                return 8;
            }
            case 338: {
                return 4;
            }
            case 501: {
                return 3;
            }
            case 143: {
                return 16;
            }
            case 510: {
                return 2;
            }
            case 321: 
            case 331: 
            case 332: 
            case 340: 
            case 361: 
            case 362: {
                return 12;
            }
            case 333: 
            case 352: 
            case 354: {
                return 9;
            }
            case 106: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 131: 
            case 132: 
            case 144: {
                return 18;
            }
            case 201: 
            case 202: 
            case 203: 
            case 335: {
                return 13;
            }
            case 111: 
            case 112: {
                return 17;
            }
        }
        return cause;
    }

    ImsUtInterface getUtInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsUtInterface ut = this.mImsManager.getSupplementaryServiceConfiguration(this.mServiceId);
        return ut;
    }

    private void transferHandoverConnections(ImsPhoneCall call) {
        if (call.mConnections != null) {
            for (Connection c : call.mConnections) {
                c.mPreHandoverState = call.mState;
                this.log("Connection state before handover is " + (Object)((Object)c.getStateBeforeHandover()));
            }
        }
        if (this.mHandoverCall.mConnections == null) {
            this.mHandoverCall.mConnections = call.mConnections;
        } else {
            this.mHandoverCall.mConnections.addAll(call.mConnections);
        }
        if (this.mHandoverCall.mConnections != null) {
            if (call.getImsCall() != null) {
                call.getImsCall().close();
            }
            for (Connection c : this.mHandoverCall.mConnections) {
                ((ImsPhoneConnection)c).changeParent(this.mHandoverCall);
                ((ImsPhoneConnection)c).releaseWakeLock();
            }
        }
        if (call.getState().isAlive()) {
            this.log("Call is alive and state is " + (Object)((Object)call.mState));
            this.mHandoverCall.mState = call.mState;
        }
        call.mConnections.clear();
        call.mState = Call.State.IDLE;
    }

    void notifySrvccState(Call.SrvccState state) {
        this.log("notifySrvccState state=" + (Object)((Object)state));
        this.mSrvccState = state;
        if (this.mSrvccState == Call.SrvccState.COMPLETED) {
            this.transferHandoverConnections(this.mForegroundCall);
            this.transferHandoverConnections(this.mBackgroundCall);
            this.transferHandoverConnections(this.mRingingCall);
        }
    }

    @Override
    public void handleMessage(Message msg) {
        this.log("handleMessage what=" + msg.what);
        switch (msg.what) {
            case 18: {
                if (this.mPendingMO != null) {
                    this.mPendingMO.onDisconnect();
                    this.removeConnection(this.mPendingMO);
                    this.mPendingMO = null;
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                break;
            }
            case 19: {
                try {
                    this.resumeWaitingOrHolding();
                }
                catch (CallStateException e) {
                    this.loge("handleMessage EVENT_RESUME_BACKGROUND exception=" + e);
                }
                break;
            }
            case 20: {
                this.dialInternal(this.mPendingMO, this.mClirMode, this.mPendingCallVideoState);
                break;
            }
            case 14: {
                if (this.pendingCallInEcm) {
                    this.dialInternal(this.mPendingMO, this.pendingCallClirMode, this.mPendingCallVideoState);
                    this.pendingCallInEcm = false;
                }
                this.mPhone.unsetOnEcbModeExitResponse(this);
            }
        }
    }

    @Override
    protected void log(String msg) {
        Rlog.d(LOG_TAG, "[ImsPhoneCallTracker] " + msg);
    }

    protected void loge(String msg) {
        Rlog.e(LOG_TAG, "[ImsPhoneCallTracker] " + msg);
    }

    void logState() {
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("ImsPhoneCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mHandoverCall=" + this.mHandoverCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
    }

    @Override
    protected void handlePollCalls(AsyncResult ar) {
    }

    ImsEcbm getEcbmInterface() throws ImsException {
        if (this.mImsManager == null) {
            throw new ImsException("no ims manager", 0);
        }
        ImsEcbm ecbm = this.mImsManager.getEcbmInterface(this.mServiceId);
        return ecbm;
    }

    public boolean isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    public boolean isVolteEnabled() {
        return this.mImsFeatureEnabled[0];
    }

    public boolean isVowifiEnabled() {
        return this.mImsFeatureEnabled[2];
    }

    public boolean isVideoCallEnabled() {
        return this.mImsFeatureEnabled[1] || this.mImsFeatureEnabled[3];
    }

    @Override
    public PhoneConstants.State getState() {
        return this.mState;
    }

    private void setVideoCallProvider(ImsPhoneConnection conn, ImsCall imsCall) throws RemoteException {
        IImsVideoCallProvider imsVideoCallProvider = imsCall.getCallSession().getVideoCallProvider();
        if (imsVideoCallProvider != null) {
            ImsVideoCallProviderWrapper imsVideoCallProviderWrapper = new ImsVideoCallProviderWrapper(imsVideoCallProvider);
            conn.setVideoProvider((Connection.VideoProvider)imsVideoCallProviderWrapper);
        }
    }
}

