/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.sip;

import android.content.Context;
import android.media.AudioManager;
import android.net.rtp.AudioGroup;
import android.net.sip.SipAudioCall;
import android.net.sip.SipErrorCode;
import android.net.sip.SipException;
import android.net.sip.SipManager;
import android.net.sip.SipProfile;
import android.os.AsyncResult;
import android.os.Message;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.text.TextUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.sip.SipCallBase;
import com.android.internal.telephony.sip.SipConnectionBase;
import com.android.internal.telephony.sip.SipPhoneBase;
import java.text.ParseException;
import java.util.List;
import java.util.regex.Pattern;

public class SipPhone
extends SipPhoneBase {
    private static final String LOG_TAG = "SipPhone";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final int TIMEOUT_MAKE_CALL = 15;
    private static final int TIMEOUT_ANSWER_CALL = 8;
    private static final int TIMEOUT_HOLD_CALL = 15;
    private SipCall mRingingCall = new SipCall();
    private SipCall mForegroundCall = new SipCall();
    private SipCall mBackgroundCall = new SipCall();
    private SipManager mSipManager;
    private SipProfile mProfile;

    SipPhone(Context context, PhoneNotifier notifier, SipProfile profile) {
        super("SIP:" + profile.getUriString(), context, notifier);
        this.log("new SipPhone: " + profile.getUriString());
        this.mRingingCall = new SipCall();
        this.mForegroundCall = new SipCall();
        this.mBackgroundCall = new SipCall();
        this.mProfile = profile;
        this.mSipManager = SipManager.newInstance((Context)context);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SipPhone)) {
            return false;
        }
        SipPhone that = (SipPhone)o;
        return this.mProfile.getUriString().equals(that.mProfile.getUriString());
    }

    public String getSipUri() {
        return this.mProfile.getUriString();
    }

    public boolean equals(SipPhone phone) {
        return this.getSipUri().equals(phone.getSipUri());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection takeIncomingCall(Object incomingCall) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(incomingCall instanceof SipAudioCall)) {
                this.log("takeIncomingCall: ret=null, not a SipAudioCall");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (this.mRingingCall.getState().isAlive()) {
                this.log("takeIncomingCall: ret=null, ringingCall not alive");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            if (this.mForegroundCall.getState().isAlive() && this.mBackgroundCall.getState().isAlive()) {
                this.log("takeIncomingCall: ret=null, foreground and background both alive");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            try {
                SipAudioCall sipAudioCall = (SipAudioCall)incomingCall;
                this.log("takeIncomingCall: taking call from: " + sipAudioCall.getPeerProfile().getUriString());
                String localUri = sipAudioCall.getLocalProfile().getUriString();
                if (localUri.equals(this.mProfile.getUriString())) {
                    boolean makeCallWait = this.mForegroundCall.getState().isAlive();
                    SipConnection connection = this.mRingingCall.initIncomingCall(sipAudioCall, makeCallWait);
                    if (sipAudioCall.getState() != 3) {
                        this.log("    takeIncomingCall: call cancelled !!");
                        this.mRingingCall.reset();
                        connection = null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return connection;
                }
            }
            catch (Exception e) {
                this.log("    takeIncomingCall: exception e=" + e);
                this.mRingingCall.reset();
            }
            this.log("takeIncomingCall: NOT taking !!");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acceptCall(int videoState) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.mRingingCall.getState() != Call.State.INCOMING && this.mRingingCall.getState() != Call.State.WAITING) {
                this.log("acceptCall: throw CallStateException(\"phone not ringing\")");
                throw new CallStateException("phone not ringing");
            }
            this.log("acceptCall: accepting");
            this.mRingingCall.setMute(false);
            this.mRingingCall.acceptCall();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rejectCall() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!this.mRingingCall.getState().isRinging()) {
                this.log("rejectCall: throw CallStateException(\"phone not ringing\")");
                throw new CallStateException("phone not ringing");
            }
            this.log("rejectCall: rejecting");
            this.mRingingCall.rejectCall();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection dial(String dialString, int videoState) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.dialInternal(dialString, videoState);
        }
    }

    private Connection dialInternal(String dialString, int videoState) throws CallStateException {
        this.log("dialInternal: dialString=" + "xxxxxx");
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("dialInternal: cannot dial in current state");
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            this.switchHoldingAndActive();
        }
        if (this.mForegroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        this.mForegroundCall.setMute(false);
        try {
            Connection c = this.mForegroundCall.dial(dialString);
            return c;
        }
        catch (SipException e) {
            this.loge("dialInternal: ", (Exception)((Object)e));
            throw new CallStateException("dial error: " + (Object)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchHoldingAndActive() throws CallStateException {
        this.log("switchHoldingAndActive: switch fg and bg");
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.switchWith(this.mBackgroundCall);
            if (this.mBackgroundCall.getState().isAlive()) {
                this.mBackgroundCall.hold();
            }
            if (this.mForegroundCall.getState().isAlive()) {
                this.mForegroundCall.unhold();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean canConference() {
        this.log("canConference: ret=true");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void conference() throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (this.mForegroundCall.getState() != Call.State.ACTIVE || this.mForegroundCall.getState() != Call.State.ACTIVE) {
                throw new CallStateException("wrong state to merge calls: fg=" + (Object)((Object)this.mForegroundCall.getState()) + ", bg=" + (Object)((Object)this.mBackgroundCall.getState()));
            }
            this.log("conference: merge fg & bg");
            this.mForegroundCall.merge(this.mBackgroundCall);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conference(Call that) throws CallStateException {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            if (!(that instanceof SipCall)) {
                throw new CallStateException("expect " + SipCall.class + ", cannot merge with " + that.getClass());
            }
            this.mForegroundCall.merge((SipCall)that);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean canTransfer() {
        return false;
    }

    @Override
    public void explicitCallTransfer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDisconnected() {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mRingingCall.clearDisconnected();
            this.mForegroundCall.clearDisconnected();
            this.mBackgroundCall.clearDisconnected();
            this.updatePhoneState();
            this.notifyPreciseCallStateChanged();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("sendDtmf called with invalid character '" + c + "'");
            return;
        }
        if (!this.mForegroundCall.getState().isAlive()) return;
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.sendDtmf(c);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("startDtmf called with invalid character '" + c + "'");
        } else {
            this.sendDtmf(c);
        }
    }

    @Override
    public void stopDtmf() {
    }

    public void sendBurstDtmf(String dtmfString) {
        this.loge("sendBurstDtmf() is a CDMA method");
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void getCallWaiting(Message onComplete) {
        AsyncResult.forMessage(onComplete, null, null);
        onComplete.sendToTarget();
    }

    @Override
    public void setCallWaiting(boolean enable, Message onComplete) {
        this.loge("call waiting not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEchoSuppressionEnabled() {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            AudioManager audioManager = (AudioManager)this.mContext.getSystemService("audio");
            String echoSuppression = audioManager.getParameters("ec_supported");
            if (echoSuppression.contains("off")) {
                this.mForegroundCall.setAudioGroupMode();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMute(boolean muted) {
        Class<SipPhone> clazz = SipPhone.class;
        synchronized (SipPhone.class) {
            this.mForegroundCall.setMute(muted);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean getMute() {
        return this.mForegroundCall.getState().isAlive() ? this.mForegroundCall.getMute() : this.mBackgroundCall.getMute();
    }

    @Override
    public Call getForegroundCall() {
        return this.mForegroundCall;
    }

    @Override
    public Call getBackgroundCall() {
        return this.mBackgroundCall;
    }

    @Override
    public Call getRingingCall() {
        return this.mRingingCall;
    }

    @Override
    public ServiceState getServiceState() {
        return super.getServiceState();
    }

    private String getUriString(SipProfile p) {
        return p.getUserName() + "@" + this.getSipDomain(p);
    }

    private String getSipDomain(SipProfile p) {
        String domain = p.getSipDomain();
        if (domain.endsWith(":5060")) {
            return domain.substring(0, domain.length() - 5);
        }
        return domain;
    }

    private static Call.State getCallStateFrom(SipAudioCall sipAudioCall) {
        if (sipAudioCall.isOnHold()) {
            return Call.State.HOLDING;
        }
        int sessionState = sipAudioCall.getState();
        switch (sessionState) {
            case 0: {
                return Call.State.IDLE;
            }
            case 3: 
            case 4: {
                return Call.State.INCOMING;
            }
            case 5: {
                return Call.State.DIALING;
            }
            case 6: {
                return Call.State.ALERTING;
            }
            case 7: {
                return Call.State.DISCONNECTING;
            }
            case 8: {
                return Call.State.ACTIVE;
            }
        }
        SipPhone.slog("illegal connection state: " + sessionState);
        return Call.State.DISCONNECTED;
    }

    private void log(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private static void slog(String s) {
        Rlog.d(LOG_TAG, s);
    }

    private void loge(String s) {
        Rlog.e(LOG_TAG, s);
    }

    private void loge(String s, Exception e) {
        Rlog.e(LOG_TAG, s, e);
    }

    private abstract class SipAudioCallAdapter
    extends SipAudioCall.Listener {
        private static final String SACA_TAG = "SipAudioCallAdapter";
        private static final boolean SACA_DBG = true;

        private SipAudioCallAdapter() {
        }

        protected abstract void onCallEnded(int var1);

        protected abstract void onError(int var1);

        public void onCallEnded(SipAudioCall call) {
            this.log("onCallEnded: call=" + call);
            this.onCallEnded(call.isInCall() ? 2 : 1);
        }

        public void onCallBusy(SipAudioCall call) {
            this.log("onCallBusy: call=" + call);
            this.onCallEnded(4);
        }

        public void onError(SipAudioCall call, int errorCode, String errorMessage) {
            this.log("onError: call=" + call + " code=" + SipErrorCode.toString((int)errorCode) + ": " + errorMessage);
            switch (errorCode) {
                case -12: {
                    this.onError(9);
                    break;
                }
                case -7: {
                    this.onError(8);
                    break;
                }
                case -6: {
                    this.onError(7);
                    break;
                }
                case -5: 
                case -3: {
                    this.onError(13);
                    break;
                }
                case -10: {
                    this.onError(14);
                    break;
                }
                case -8: {
                    this.onError(10);
                    break;
                }
                case -11: {
                    this.onError(11);
                    break;
                }
                case -2: {
                    this.onError(12);
                    break;
                }
                default: {
                    this.onError(36);
                }
            }
        }

        private void log(String s) {
            Rlog.d(SACA_TAG, s);
        }
    }

    private class SipConnection
    extends SipConnectionBase {
        private static final String SCN_TAG = "SipConnection";
        private static final boolean SCN_DBG = true;
        private SipCall mOwner;
        private SipAudioCall mSipAudioCall;
        private Call.State mState;
        private SipProfile mPeer;
        private boolean mIncoming;
        private String mOriginalNumber;
        private SipAudioCallAdapter mAdapter;

        public SipConnection(SipCall owner, SipProfile callee, String originalNumber) {
            super(originalNumber);
            this.mState = Call.State.IDLE;
            this.mIncoming = false;
            this.mAdapter = new SipAudioCallAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void onCallEnded(int cause) {
                    if (SipConnection.this.getDisconnectCause() != 3) {
                        SipConnection.this.setDisconnectCause(cause);
                    }
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        SipConnection.this.setState(Call.State.DISCONNECTED);
                        SipAudioCall sipAudioCall = SipConnection.this.mSipAudioCall;
                        SipConnection.this.mSipAudioCall = null;
                        String sessionState = sipAudioCall == null ? "" : sipAudioCall.getState() + ", ";
                        SipConnection.this.log("[SipAudioCallAdapter] onCallEnded: " + SipConnection.this.mPeer.getUriString() + ": " + sessionState + "cause: " + SipConnection.this.getDisconnectCause() + ", on phone " + SipConnection.this.getPhone());
                        if (sipAudioCall != null) {
                            sipAudioCall.setListener(null);
                            sipAudioCall.close();
                        }
                        SipConnection.this.mOwner.onConnectionEnded(SipConnection.this);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                public void onCallEstablished(SipAudioCall call) {
                    this.onChanged(call);
                    if (SipConnection.this.mState == Call.State.ACTIVE) {
                        call.startAudio();
                    }
                }

                public void onCallHeld(SipAudioCall call) {
                    this.onChanged(call);
                    if (SipConnection.this.mState == Call.State.HOLDING) {
                        call.startAudio();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onChanged(SipAudioCall call) {
                    Class<SipPhone> clazz = SipPhone.class;
                    synchronized (SipPhone.class) {
                        Call.State newState = SipPhone.getCallStateFrom(call);
                        if (SipConnection.this.mState == newState) {
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                        if (newState == Call.State.INCOMING) {
                            SipConnection.this.setState(SipConnection.this.mOwner.getState());
                        } else {
                            if (SipConnection.this.mOwner == SipPhone.this.mRingingCall) {
                                if (SipPhone.this.mRingingCall.getState() == Call.State.WAITING) {
                                    try {
                                        SipPhone.this.switchHoldingAndActive();
                                    }
                                    catch (CallStateException e) {
                                        this.onCallEnded(3);
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        return;
                                    }
                                }
                                SipPhone.this.mForegroundCall.switchWith(SipPhone.this.mRingingCall);
                            }
                            SipConnection.this.setState(newState);
                        }
                        SipConnection.this.mOwner.onConnectionStateChanged(SipConnection.this);
                        SipConnection.this.log("onChanged: " + SipConnection.this.mPeer.getUriString() + ": " + (Object)((Object)SipConnection.this.mState) + " on phone " + SipConnection.this.getPhone());
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }

                @Override
                protected void onError(int cause) {
                    SipConnection.this.log("onError: " + cause);
                    this.onCallEnded(cause);
                }
            };
            this.mOwner = owner;
            this.mPeer = callee;
            this.mOriginalNumber = originalNumber;
        }

        public SipConnection(SipCall owner, SipProfile callee) {
            this(owner, callee, sipPhone.getUriString(callee));
        }

        @Override
        public String getCnapName() {
            String displayName = this.mPeer.getDisplayName();
            return TextUtils.isEmpty(displayName) ? null : displayName;
        }

        @Override
        public int getNumberPresentation() {
            return 1;
        }

        void initIncomingCall(SipAudioCall sipAudioCall, Call.State newState) {
            this.setState(newState);
            this.mSipAudioCall = sipAudioCall;
            sipAudioCall.setListener((SipAudioCall.Listener)this.mAdapter);
            this.mIncoming = true;
        }

        void acceptCall() throws CallStateException {
            try {
                this.mSipAudioCall.answerCall(8);
            }
            catch (SipException e) {
                throw new CallStateException("acceptCall(): " + (Object)((Object)e));
            }
        }

        void changeOwner(SipCall owner) {
            this.mOwner = owner;
        }

        AudioGroup getAudioGroup() {
            if (this.mSipAudioCall == null) {
                return null;
            }
            return this.mSipAudioCall.getAudioGroup();
        }

        void dial() throws SipException {
            this.setState(Call.State.DIALING);
            this.mSipAudioCall = SipPhone.this.mSipManager.makeAudioCall(SipPhone.this.mProfile, this.mPeer, null, 15);
            this.mSipAudioCall.setListener((SipAudioCall.Listener)this.mAdapter);
        }

        void hold() throws CallStateException {
            this.setState(Call.State.HOLDING);
            try {
                this.mSipAudioCall.holdCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("hold(): " + (Object)((Object)e));
            }
        }

        void unhold(AudioGroup audioGroup) throws CallStateException {
            this.mSipAudioCall.setAudioGroup(audioGroup);
            this.setState(Call.State.ACTIVE);
            try {
                this.mSipAudioCall.continueCall(15);
            }
            catch (SipException e) {
                throw new CallStateException("unhold(): " + (Object)((Object)e));
            }
        }

        void setMute(boolean muted) {
            if (this.mSipAudioCall != null && muted != this.mSipAudioCall.isMuted()) {
                this.log("setState: prev muted=" + !muted + " new muted=" + muted);
                this.mSipAudioCall.toggleMute();
            }
        }

        boolean getMute() {
            return this.mSipAudioCall == null ? false : this.mSipAudioCall.isMuted();
        }

        @Override
        protected void setState(Call.State state) {
            if (state == this.mState) {
                return;
            }
            super.setState(state);
            this.mState = state;
        }

        @Override
        public Call.State getState() {
            return this.mState;
        }

        @Override
        public boolean isIncoming() {
            return this.mIncoming;
        }

        @Override
        public String getAddress() {
            return this.mOriginalNumber;
        }

        @Override
        public SipCall getCall() {
            return this.mOwner;
        }

        @Override
        protected Phone getPhone() {
            return this.mOwner.getPhone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                this.log("hangup: conn=" + this.mPeer.getUriString() + ": " + (Object)((Object)this.mState) + ": on phone " + this.getPhone().getPhoneName());
                if (!this.mState.isAlive()) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    SipAudioCall sipAudioCall = this.mSipAudioCall;
                    if (sipAudioCall != null) {
                        sipAudioCall.setListener(null);
                        sipAudioCall.endCall();
                    }
                    this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? 16 : 3);
                }
                catch (SipException e) {
                    try {
                        throw new CallStateException("hangup(): " + (Object)((Object)e));
                    }
                    catch (Throwable throwable) {
                        this.mAdapter.onCallEnded(this.mState == Call.State.INCOMING || this.mState == Call.State.WAITING ? 16 : 3);
                        throw throwable;
                    }
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void separate() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall call;
                SipCall sipCall = call = this.getPhone() == SipPhone.this ? (SipCall)SipPhone.this.getBackgroundCall() : (SipCall)SipPhone.this.getForegroundCall();
                if (call.getState() != Call.State.IDLE) {
                    throw new CallStateException("cannot put conn back to a call in non-idle state: " + (Object)((Object)call.getState()));
                }
                this.log("separate: conn=" + this.mPeer.getUriString() + " from " + this.mOwner + " back to " + call);
                Phone originalPhone = this.getPhone();
                AudioGroup audioGroup = call.getAudioGroup();
                call.add(this);
                this.mSipAudioCall.setAudioGroup(audioGroup);
                originalPhone.switchHoldingAndActive();
                call = (SipCall)SipPhone.this.getForegroundCall();
                this.mSipAudioCall.startAudio();
                call.onConnectionStateChanged(this);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void log(String s) {
            Rlog.d(SCN_TAG, s);
        }
    }

    private class SipCall
    extends SipCallBase {
        private static final String SC_TAG = "SipCall";
        private static final boolean SC_DBG = true;
        private static final boolean SC_VDBG = false;

        private SipCall() {
        }

        void reset() {
            this.log("reset");
            this.mConnections.clear();
            this.setState(Call.State.IDLE);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void switchWith(SipCall that) {
            this.log("switchWith");
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                SipCall tmp = new SipCall();
                tmp.takeOver(this);
                this.takeOver(that);
                that.takeOver(tmp);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        private void takeOver(SipCall that) {
            this.log("takeOver");
            this.mConnections = that.mConnections;
            this.mState = that.mState;
            for (Connection c : this.mConnections) {
                ((SipConnection)c).changeOwner(this);
            }
        }

        @Override
        public Phone getPhone() {
            return SipPhone.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<Connection> getConnections() {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.mConnections;
            }
        }

        Connection dial(String originalNumber) throws SipException {
            this.log("dial: num=" + "xxx");
            String calleeSipUri = originalNumber;
            if (!calleeSipUri.contains("@")) {
                String replaceStr = Pattern.quote(SipPhone.this.mProfile.getUserName() + "@");
                calleeSipUri = SipPhone.this.mProfile.getUriString().replaceFirst(replaceStr, calleeSipUri + "@");
            }
            try {
                SipProfile callee = new SipProfile.Builder(calleeSipUri).build();
                SipConnection c = new SipConnection(this, callee, originalNumber);
                c.dial();
                this.mConnections.add(c);
                this.setState(Call.State.DIALING);
                return c;
            }
            catch (ParseException e) {
                throw new SipException("dial", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hangup() throws CallStateException {
            Class<SipPhone> clazz = SipPhone.class;
            synchronized (SipPhone.class) {
                if (this.mState.isAlive()) {
                    this.log("hangup: call " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                    this.setState(Call.State.DISCONNECTING);
                    CallStateException excp = null;
                    for (Connection c : this.mConnections) {
                        try {
                            c.hangup();
                        }
                        catch (CallStateException e) {
                            excp = e;
                        }
                    }
                    if (excp != null) {
                        throw excp;
                    }
                } else {
                    this.log("hangup: dead call " + (Object)((Object)this.getState()) + ": " + this + " on phone " + this.getPhone());
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        SipConnection initIncomingCall(SipAudioCall sipAudioCall, boolean makeCallWait) {
            SipProfile callee = sipAudioCall.getPeerProfile();
            SipConnection c = new SipConnection(this, callee);
            this.mConnections.add(c);
            Call.State newState = makeCallWait ? Call.State.WAITING : Call.State.INCOMING;
            c.initIncomingCall(sipAudioCall, newState);
            this.setState(newState);
            SipPhone.this.notifyNewRingingConnectionP(c);
            return c;
        }

        void rejectCall() throws CallStateException {
            this.log("rejectCall:");
            this.hangup();
        }

        void acceptCall() throws CallStateException {
            this.log("acceptCall: accepting");
            if (this != SipPhone.this.mRingingCall) {
                throw new CallStateException("acceptCall() in a non-ringing call");
            }
            if (this.mConnections.size() != 1) {
                throw new CallStateException("acceptCall() in a conf call");
            }
            ((SipConnection)this.mConnections.get(0)).acceptCall();
        }

        private boolean isSpeakerOn() {
            Boolean ret = ((AudioManager)SipPhone.this.mContext.getSystemService("audio")).isSpeakerphoneOn();
            return ret;
        }

        void setAudioGroupMode() {
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                this.log("setAudioGroupMode: audioGroup == null ignore");
                return;
            }
            int mode = audioGroup.getMode();
            if (this.mState == Call.State.HOLDING) {
                audioGroup.setMode(0);
            } else if (this.getMute()) {
                audioGroup.setMode(1);
            } else if (this.isSpeakerOn()) {
                audioGroup.setMode(3);
            } else {
                audioGroup.setMode(2);
            }
            this.log(String.format("setAudioGroupMode change: %d --> %d", mode, audioGroup.getMode()));
        }

        void hold() throws CallStateException {
            this.log("hold:");
            this.setState(Call.State.HOLDING);
            for (Connection c : this.mConnections) {
                ((SipConnection)c).hold();
            }
            this.setAudioGroupMode();
        }

        void unhold() throws CallStateException {
            this.log("unhold:");
            this.setState(Call.State.ACTIVE);
            AudioGroup audioGroup = new AudioGroup();
            for (Connection c : this.mConnections) {
                ((SipConnection)c).unhold(audioGroup);
            }
            this.setAudioGroupMode();
        }

        void setMute(boolean muted) {
            this.log("setMute: muted=" + muted);
            for (Connection c : this.mConnections) {
                ((SipConnection)c).setMute(muted);
            }
        }

        boolean getMute() {
            boolean ret = this.mConnections.isEmpty() ? false : ((SipConnection)this.mConnections.get(0)).getMute();
            this.log("getMute: ret=" + ret);
            return ret;
        }

        void merge(SipCall that) throws CallStateException {
            Connection[] cc;
            this.log("merge:");
            AudioGroup audioGroup = this.getAudioGroup();
            for (Connection c : cc = that.mConnections.toArray(new Connection[that.mConnections.size()])) {
                SipConnection conn = (SipConnection)c;
                this.add(conn);
                if (conn.getState() != Call.State.HOLDING) continue;
                conn.unhold(audioGroup);
            }
            that.setState(Call.State.IDLE);
        }

        private void add(SipConnection conn) {
            this.log("add:");
            SipCall call = conn.getCall();
            if (call == this) {
                return;
            }
            if (call != null) {
                call.mConnections.remove(conn);
            }
            this.mConnections.add(conn);
            conn.changeOwner(this);
        }

        void sendDtmf(char c) {
            this.log("sendDtmf: c=" + c);
            AudioGroup audioGroup = this.getAudioGroup();
            if (audioGroup == null) {
                this.log("sendDtmf: audioGroup == null, ignore c=" + c);
                return;
            }
            audioGroup.sendDtmf(this.convertDtmf(c));
        }

        private int convertDtmf(char c) {
            int code = c - 48;
            if (code < 0 || code > 9) {
                switch (c) {
                    case '*': {
                        return 10;
                    }
                    case '#': {
                        return 11;
                    }
                    case 'A': {
                        return 12;
                    }
                    case 'B': {
                        return 13;
                    }
                    case 'C': {
                        return 14;
                    }
                    case 'D': {
                        return 15;
                    }
                }
                throw new IllegalArgumentException("invalid DTMF char: " + c);
            }
            return code;
        }

        @Override
        protected void setState(Call.State newState) {
            if (this.mState != newState) {
                this.log("setState: cur state" + (Object)((Object)this.mState) + " --> " + (Object)((Object)newState) + ": " + this + ": on phone " + this.getPhone() + " " + this.mConnections.size());
                if (newState == Call.State.ALERTING) {
                    this.mState = newState;
                    SipPhone.this.startRingbackTone();
                } else if (this.mState == Call.State.ALERTING) {
                    SipPhone.this.stopRingbackTone();
                }
                this.mState = newState;
                SipPhone.this.updatePhoneState();
                SipPhone.this.notifyPreciseCallStateChanged();
            }
        }

        void onConnectionStateChanged(SipConnection conn) {
            this.log("onConnectionStateChanged: conn=" + conn);
            if (this.mState != Call.State.ACTIVE) {
                this.setState(conn.getState());
            }
        }

        void onConnectionEnded(SipConnection conn) {
            this.log("onConnectionEnded: conn=" + conn);
            if (this.mState != Call.State.DISCONNECTED) {
                boolean allConnectionsDisconnected = true;
                this.log("---check connections: " + this.mConnections.size());
                for (Connection c : this.mConnections) {
                    this.log("   state=" + (Object)((Object)c.getState()) + ": " + c);
                    if (c.getState() == Call.State.DISCONNECTED) continue;
                    allConnectionsDisconnected = false;
                    break;
                }
                if (allConnectionsDisconnected) {
                    this.setState(Call.State.DISCONNECTED);
                }
            }
            SipPhone.this.notifyDisconnectP(conn);
        }

        private AudioGroup getAudioGroup() {
            if (this.mConnections.isEmpty()) {
                return null;
            }
            return ((SipConnection)this.mConnections.get(0)).getAudioGroup();
        }

        private void log(String s) {
            Rlog.d(SC_TAG, s);
        }
    }
}

