/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.os.Bundle;
import android.util.Log;
import android.util.Xml;
import com.android.ims.ImsConferenceState;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.io.InputStream;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TestConferenceEventPackageParser {
    private static final String LOG_TAG = "TestConferenceEventPackageParser";
    private static final String PARTICIPANT_TAG = "participant";
    private InputStream mInputStream;

    public TestConferenceEventPackageParser(InputStream inputStream) {
        this.mInputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImsConferenceState parse() {
        ImsConferenceState conferenceState = new ImsConferenceState();
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(this.mInputStream, null);
            parser.nextTag();
            int outerDepth = parser.getDepth();
            while (XmlUtils.nextElementWithin(parser, outerDepth)) {
                if (!parser.getName().equals(PARTICIPANT_TAG)) continue;
                Log.v(LOG_TAG, "Found participant.");
                Bundle participant = this.parseParticipant(parser);
                conferenceState.mParticipants.put(participant.getString("endpoint"), participant);
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.e(LOG_TAG, "Failed to read test conference event package from XML file", e);
            ImsConferenceState imsConferenceState = null;
            return imsConferenceState;
        }
        finally {
            try {
                this.mInputStream.close();
            }
            catch (IOException e) {
                Log.e(LOG_TAG, "Failed to close test conference event package InputStream", e);
                return null;
            }
        }
        return conferenceState;
    }

    private Bundle parseParticipant(XmlPullParser parser) throws IOException, XmlPullParserException {
        Bundle bundle = new Bundle();
        String user = "";
        String displayText = "";
        String endpoint = "";
        String status = "";
        int outerDepth = parser.getDepth();
        while (XmlUtils.nextElementWithin(parser, outerDepth)) {
            if (parser.getName().equals("user")) {
                parser.next();
                user = parser.getText();
                continue;
            }
            if (parser.getName().equals("display-text")) {
                parser.next();
                displayText = parser.getText();
                continue;
            }
            if (parser.getName().equals("endpoint")) {
                parser.next();
                endpoint = parser.getText();
                continue;
            }
            if (!parser.getName().equals("status")) continue;
            parser.next();
            status = parser.getText();
        }
        Log.v(LOG_TAG, "User: " + user);
        Log.v(LOG_TAG, "DisplayText: " + displayText);
        Log.v(LOG_TAG, "Endpoint: " + endpoint);
        Log.v(LOG_TAG, "Status: " + status);
        bundle.putString("user", user);
        bundle.putString("display-text", displayText);
        bundle.putString("endpoint", endpoint);
        bundle.putString("status", status);
        return bundle;
    }
}

