/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.Context;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Base64;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.AdnRecordCache;
import com.android.internal.telephony.uicc.AdnRecordLoader;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccConstants;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccIoResult;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class IccRecords
extends Handler
implements IccConstants {
    protected static final boolean DBG = true;
    protected static final boolean VDBG = false;
    protected AtomicBoolean mDestroyed = new AtomicBoolean(false);
    protected Context mContext;
    protected CommandsInterface mCi;
    protected IccFileHandler mFh;
    protected UiccCardApplication mParentApp;
    protected TelephonyManager mTelephonyManager;
    protected RegistrantList mRecordsLoadedRegistrants = new RegistrantList();
    protected RegistrantList mImsiReadyRegistrants = new RegistrantList();
    protected RegistrantList mRecordsEventsRegistrants = new RegistrantList();
    protected RegistrantList mNewSmsRegistrants = new RegistrantList();
    protected RegistrantList mNetworkSelectionModeAutomaticRegistrants = new RegistrantList();
    protected int mRecordsToLoad;
    protected AdnRecordCache mAdnCache;
    protected boolean mRecordsRequested = false;
    protected String mIccId;
    protected String mMsisdn = null;
    protected String mMsisdnTag = null;
    protected String mNewMsisdn = null;
    protected String mNewMsisdnTag = null;
    protected String mVoiceMailNum = null;
    protected String mVoiceMailTag = null;
    protected String mNewVoiceMailNum = null;
    protected String mNewVoiceMailTag = null;
    protected boolean mIsVoiceMailFixed = false;
    protected String mImsi;
    private IccIoResult auth_rsp;
    protected int mMncLength = -1;
    protected int mMailboxIndex = 0;
    private String mSpn;
    protected String mGid1;
    protected String mGid2;
    protected String mPrefLang;
    private final Object mLock = new Object();
    protected static final int UNINITIALIZED = -1;
    protected static final int UNKNOWN = 0;
    public static final int SPN_RULE_SHOW_SPN = 1;
    public static final int SPN_RULE_SHOW_PLMN = 2;
    protected static final int EVENT_SET_MSISDN_DONE = 30;
    public static final int EVENT_MWI = 0;
    public static final int EVENT_CFI = 1;
    public static final int EVENT_SPN = 2;
    public static final int EVENT_GET_ICC_RECORD_DONE = 100;
    protected static final int EVENT_APP_READY = 1;
    private static final int EVENT_AKA_AUTHENTICATE_DONE = 90;

    @Override
    public String toString() {
        return "mDestroyed=" + this.mDestroyed + " mContext=" + this.mContext + " mCi=" + this.mCi + " mFh=" + this.mFh + " mParentApp=" + this.mParentApp + " recordsLoadedRegistrants=" + this.mRecordsLoadedRegistrants + " mImsiReadyRegistrants=" + this.mImsiReadyRegistrants + " mRecordsEventsRegistrants=" + this.mRecordsEventsRegistrants + " mNewSmsRegistrants=" + this.mNewSmsRegistrants + " mNetworkSelectionModeAutomaticRegistrants=" + this.mNetworkSelectionModeAutomaticRegistrants + " recordsToLoad=" + this.mRecordsToLoad + " adnCache=" + this.mAdnCache + " recordsRequested=" + this.mRecordsRequested + " iccid=" + this.mIccId + " msisdnTag=" + this.mMsisdnTag + " voiceMailNum=" + this.mVoiceMailNum + " voiceMailTag=" + this.mVoiceMailTag + " newVoiceMailNum=" + this.mNewVoiceMailNum + " newVoiceMailTag=" + this.mNewVoiceMailTag + " isVoiceMailFixed=" + this.mIsVoiceMailFixed + "" + " mncLength=" + this.mMncLength + " mailboxIndex=" + this.mMailboxIndex + " spn=" + this.mSpn;
    }

    public IccRecords(UiccCardApplication app, Context c, CommandsInterface ci) {
        this.mContext = c;
        this.mCi = ci;
        this.mFh = app.getIccFileHandler();
        this.mParentApp = app;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
    }

    public void dispose() {
        this.mDestroyed.set(true);
        this.mParentApp = null;
        this.mFh = null;
        this.mCi = null;
        this.mContext = null;
    }

    public abstract void onReady();

    public AdnRecordCache getAdnCache() {
        return this.mAdnCache;
    }

    public String getIccId() {
        return this.mIccId;
    }

    public void registerForRecordsLoaded(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsLoadedRegistrants.add(r);
        if (this.mRecordsToLoad == 0 && this.mRecordsRequested) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForRecordsLoaded(Handler h) {
        this.mRecordsLoadedRegistrants.remove(h);
    }

    public void registerForImsiReady(Handler h, int what, Object obj) {
        if (this.mDestroyed.get()) {
            return;
        }
        Registrant r = new Registrant(h, what, obj);
        this.mImsiReadyRegistrants.add(r);
        if (this.mImsi != null) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    public void unregisterForImsiReady(Handler h) {
        this.mImsiReadyRegistrants.remove(h);
    }

    public void registerForRecordsEvents(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mRecordsEventsRegistrants.add(r);
        r.notifyResult(0);
        r.notifyResult(1);
    }

    public void unregisterForRecordsEvents(Handler h) {
        this.mRecordsEventsRegistrants.remove(h);
    }

    public void registerForNewSms(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNewSmsRegistrants.add(r);
    }

    public void unregisterForNewSms(Handler h) {
        this.mNewSmsRegistrants.remove(h);
    }

    public void registerForNetworkSelectionModeAutomatic(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mNetworkSelectionModeAutomaticRegistrants.add(r);
    }

    public void unregisterForNetworkSelectionModeAutomatic(Handler h) {
        this.mNetworkSelectionModeAutomaticRegistrants.remove(h);
    }

    public String getIMSI() {
        return null;
    }

    public void setImsi(String imsi) {
        this.mImsi = imsi;
        this.mImsiReadyRegistrants.notifyRegistrants();
    }

    public String getNAI() {
        return null;
    }

    public String getMsisdnNumber() {
        return this.mMsisdn;
    }

    public String getGid1() {
        return null;
    }

    public String getGid2() {
        return null;
    }

    public void setMsisdnNumber(String alphaTag, String number, Message onComplete) {
        this.mMsisdn = number;
        this.mMsisdnTag = alphaTag;
        this.log("Set MSISDN: " + this.mMsisdnTag + " " + this.mMsisdn);
        AdnRecord adn = new AdnRecord(this.mMsisdnTag, this.mMsisdn);
        new AdnRecordLoader(this.mFh).updateEF(adn, 28480, 28490, 1, null, this.obtainMessage(30, onComplete));
    }

    public String getMsisdnAlphaTag() {
        return this.mMsisdnTag;
    }

    public String getVoiceMailNumber() {
        return this.mVoiceMailNum;
    }

    public String getServiceProviderName() {
        String providerName = this.mSpn;
        UiccCardApplication parentApp = this.mParentApp;
        if (parentApp != null) {
            UiccCard card = parentApp.getUiccCard();
            if (card != null) {
                String brandOverride = card.getOperatorBrandOverride();
                if (brandOverride != null) {
                    this.log("getServiceProviderName: override");
                    providerName = brandOverride;
                } else {
                    this.log("getServiceProviderName: no brandOverride");
                }
            } else {
                this.log("getServiceProviderName: card is null");
            }
        } else {
            this.log("getServiceProviderName: mParentApp is null");
        }
        this.log("getServiceProviderName: providerName=" + providerName);
        return providerName;
    }

    protected void setServiceProviderName(String spn) {
        this.mSpn = spn;
    }

    public abstract void setVoiceMailNumber(String var1, String var2, Message var3);

    public String getVoiceMailAlphaTag() {
        return this.mVoiceMailTag;
    }

    public abstract void setVoiceMessageWaiting(int var1, int var2);

    public abstract int getVoiceMessageCount();

    public abstract void onRefresh(boolean var1, int[] var2);

    protected void onIccRefreshInit() {
        this.mAdnCache.reset();
        UiccCardApplication parentApp = this.mParentApp;
        if (parentApp != null && parentApp.getState() == IccCardApplicationStatus.AppState.APPSTATE_READY) {
            this.sendMessage(this.obtainMessage(1));
        }
    }

    public boolean getRecordsLoaded() {
        return this.mRecordsToLoad == 0 && this.mRecordsRequested;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 100: {
                try {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    IccRecordLoaded recordLoaded = (IccRecordLoaded)ar.userObj;
                    this.log(recordLoaded.getEfName() + " LOADED");
                    if (ar.exception != null) {
                        this.loge("Record Load Exception: " + ar.exception);
                        break;
                    }
                    recordLoaded.onRecordLoaded(ar);
                    break;
                }
                catch (RuntimeException exc) {
                    this.loge("Exception parsing SIM record: " + exc);
                    break;
                }
                finally {
                    this.onRecordLoaded();
                }
            }
            case 90: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.auth_rsp = null;
                this.log("EVENT_AKA_AUTHENTICATE_DONE");
                if (ar.exception != null) {
                    this.loge("Exception ICC SIM AKA: " + ar.exception);
                } else {
                    try {
                        this.auth_rsp = (IccIoResult)ar.result;
                        this.log("ICC SIM AKA: auth_rsp = " + this.auth_rsp);
                    }
                    catch (Exception e) {
                        this.loge("Failed to parse ICC SIM AKA contents: " + e);
                    }
                }
                Object object = this.mLock;
                synchronized (object) {
                    this.mLock.notifyAll();
                    break;
                }
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    public String getSimLanguage() {
        return this.mPrefLang;
    }

    protected void setSimLanguage(byte[] efLi, byte[] efPl) {
        String[] locales = this.mContext.getAssets().getLocales();
        try {
            this.mPrefLang = IccRecords.findBestLanguage(efLi, locales);
        }
        catch (UnsupportedEncodingException uee) {
            this.log("Unable to parse EF-LI: " + Arrays.toString(efLi));
        }
        if (this.mPrefLang == null) {
            try {
                this.mPrefLang = IccRecords.findBestLanguage(efPl, locales);
            }
            catch (UnsupportedEncodingException uee) {
                this.log("Unable to parse EF-PL: " + Arrays.toString(efLi));
            }
        }
    }

    protected static String findBestLanguage(byte[] languages, String[] locales) throws UnsupportedEncodingException {
        if (languages == null || locales == null) {
            return null;
        }
        int i = 0;
        while (i + 1 < languages.length) {
            String lang = new String(languages, i, 2, "ISO-8859-1");
            for (int j = 0; j < locales.length; ++j) {
                if (locales[j] == null || locales[j].length() < 2 || !locales[j].substring(0, 2).equalsIgnoreCase(lang)) continue;
                return lang;
            }
            i += 2;
        }
        return null;
    }

    protected abstract void onRecordLoaded();

    protected abstract void onAllRecordsLoaded();

    public abstract int getDisplayRule(String var1);

    public boolean isCspPlmnEnabled() {
        return false;
    }

    public String getOperatorNumeric() {
        return null;
    }

    public boolean getVoiceCallForwardingFlag() {
        return false;
    }

    public void setVoiceCallForwardingFlag(int line, boolean enable, String number) {
    }

    public boolean isProvisioned() {
        return true;
    }

    protected abstract void log(String var1);

    protected abstract void loge(String var1);

    public IsimRecords getIsimRecords() {
        return null;
    }

    public UsimServiceTable getUsimServiceTable() {
        return null;
    }

    protected void setSystemProperty(String key, String val) {
        TelephonyManager.getDefault();
        TelephonyManager.setTelephonyProperty(this.mParentApp.getPhoneId(), key, val);
        this.log("[key, value]=" + key + ", " + val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIccSimChallengeResponse(int authContext, String data) {
        this.log("getIccSimChallengeResponse:");
        try {
            Object object = this.mLock;
            synchronized (object) {
                CommandsInterface ci = this.mCi;
                UiccCardApplication parentApp = this.mParentApp;
                if (ci != null && parentApp != null) {
                    ci.requestIccSimAuthentication(authContext, data, parentApp.getAid(), this.obtainMessage(90));
                    try {
                        this.mLock.wait();
                    }
                    catch (InterruptedException e) {
                        this.loge("getIccSimChallengeResponse: Fail, interrupted while trying to request Icc Sim Auth");
                        return null;
                    }
                } else {
                    this.loge("getIccSimChallengeResponse: Fail, ci or parentApp is null");
                    return null;
                }
            }
        }
        catch (Exception e) {
            this.loge("getIccSimChallengeResponse: Fail while trying to request Icc Sim Auth");
            return null;
        }
        this.log("getIccSimChallengeResponse: return auth_rsp");
        return Base64.encodeToString(this.auth_rsp.payload, 2);
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("IccRecords: " + this);
        pw.println(" mDestroyed=" + this.mDestroyed);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mFh=" + this.mFh);
        pw.println(" mParentApp=" + this.mParentApp);
        pw.println(" recordsLoadedRegistrants: size=" + this.mRecordsLoadedRegistrants.size());
        for (i = 0; i < this.mRecordsLoadedRegistrants.size(); ++i) {
            pw.println("  recordsLoadedRegistrants[" + i + "]=" + ((Registrant)this.mRecordsLoadedRegistrants.get(i)).getHandler());
        }
        pw.println(" mImsiReadyRegistrants: size=" + this.mImsiReadyRegistrants.size());
        for (i = 0; i < this.mImsiReadyRegistrants.size(); ++i) {
            pw.println("  mImsiReadyRegistrants[" + i + "]=" + ((Registrant)this.mImsiReadyRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsEventsRegistrants: size=" + this.mRecordsEventsRegistrants.size());
        for (i = 0; i < this.mRecordsEventsRegistrants.size(); ++i) {
            pw.println("  mRecordsEventsRegistrants[" + i + "]=" + ((Registrant)this.mRecordsEventsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNewSmsRegistrants: size=" + this.mNewSmsRegistrants.size());
        for (i = 0; i < this.mNewSmsRegistrants.size(); ++i) {
            pw.println("  mNewSmsRegistrants[" + i + "]=" + ((Registrant)this.mNewSmsRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkSelectionModeAutomaticRegistrants: size=" + this.mNetworkSelectionModeAutomaticRegistrants.size());
        for (i = 0; i < this.mNetworkSelectionModeAutomaticRegistrants.size(); ++i) {
            pw.println("  mNetworkSelectionModeAutomaticRegistrants[" + i + "]=" + ((Registrant)this.mNetworkSelectionModeAutomaticRegistrants.get(i)).getHandler());
        }
        pw.println(" mRecordsRequested=" + this.mRecordsRequested);
        pw.println(" mRecordsToLoad=" + this.mRecordsToLoad);
        pw.println(" mRdnCache=" + this.mAdnCache);
        pw.println(" iccid=" + this.mIccId);
        if (TextUtils.isEmpty(this.mMsisdn)) {
            pw.println(" mMsisdn=null");
        } else {
            pw.println(" mMsisdn=" + "XXX");
        }
        pw.println(" mMsisdnTag=" + this.mMsisdnTag);
        pw.println(" mVoiceMailNum=" + this.mVoiceMailNum);
        pw.println(" mVoiceMailTag=" + this.mVoiceMailTag);
        pw.println(" mNewVoiceMailNum=" + this.mNewVoiceMailNum);
        pw.println(" mNewVoiceMailTag=" + this.mNewVoiceMailTag);
        pw.println(" mIsVoiceMailFixed=" + this.mIsVoiceMailFixed);
        pw.println(" mMncLength=" + this.mMncLength);
        pw.println(" mMailboxIndex=" + this.mMailboxIndex);
        pw.println(" mSpn=" + this.mSpn);
        pw.flush();
    }

    public static interface IccRecordLoaded {
        public String getEfName();

        public void onRecordLoaded(AsyncResult var1);
    }
}

