/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.telephony.Rlog;
import com.android.internal.telephony.GsmAlphabet;
import java.io.UnsupportedEncodingException;

public class IccUtils {
    static final String LOG_TAG = "IccUtils";

    public static String bcdToString(byte[] data, int offset, int length) {
        int v;
        StringBuilder ret = new StringBuilder(length * 2);
        for (int i = offset; i < offset + length && (v = data[i] & 0xF) <= 9; ++i) {
            ret.append((char)(48 + v));
            v = data[i] >> 4 & 0xF;
            if (v == 15) continue;
            if (v > 9) break;
            ret.append((char)(48 + v));
        }
        return ret.toString();
    }

    public static String cdmaBcdToString(byte[] data, int offset, int length) {
        StringBuilder ret = new StringBuilder(length);
        int count = 0;
        int i = offset;
        while (count < length) {
            int v = data[i] & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            if (++count == length) break;
            v = data[i] >> 4 & 0xF;
            if (v > 9) {
                v = 0;
            }
            ret.append((char)(48 + v));
            ++count;
            ++i;
        }
        return ret.toString();
    }

    public static int gsmBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = b >> 4 & 0xF;
        }
        if ((b & 0xF) <= 9) {
            ret += (b & 0xF) * 10;
        }
        return ret;
    }

    public static int cdmaBcdByteToInt(byte b) {
        int ret = 0;
        if ((b & 0xF0) <= 144) {
            ret = (b >> 4 & 0xF) * 10;
        }
        if ((b & 0xF) <= 9) {
            ret += b & 0xF;
        }
        return ret;
    }

    public static String adnStringFieldToString(byte[] data, int offset, int length) {
        if (length == 0) {
            return "";
        }
        if (length >= 1 && data[offset] == -128) {
            int ucslen = (length - 1) / 2;
            String ret = null;
            try {
                ret = new String(data, offset + 1, ucslen * 2, "utf-16be");
            }
            catch (UnsupportedEncodingException ex) {
                Rlog.e(LOG_TAG, "implausible UnsupportedEncodingException", ex);
            }
            if (ret != null) {
                for (ucslen = ret.length(); ucslen > 0 && ret.charAt(ucslen - 1) == '\uffff'; --ucslen) {
                }
                return ret.substring(0, ucslen);
            }
        }
        boolean isucs2 = false;
        int base = 0;
        int len = 0;
        if (length >= 3 && data[offset] == -127) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 3) {
                len = length - 3;
            }
            base = (char)((data[offset + 2] & 0xFF) << 7);
            offset += 3;
            isucs2 = true;
        } else if (length >= 4 && data[offset] == -126) {
            len = data[offset + 1] & 0xFF;
            if (len > length - 4) {
                len = length - 4;
            }
            base = (char)((data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF);
            offset += 4;
            isucs2 = true;
        }
        if (isucs2) {
            StringBuilder ret = new StringBuilder();
            while (len > 0) {
                int count;
                if (data[offset] < 0) {
                    ret.append((char)(base + (data[offset] & 0x7F)));
                    ++offset;
                    --len;
                }
                for (count = 0; count < len && data[offset + count] >= 0; ++count) {
                }
                ret.append(GsmAlphabet.gsm8BitUnpackedToString(data, offset, count));
                offset += count;
                len -= count;
            }
            return ret.toString();
        }
        Resources resource = Resources.getSystem();
        String defaultCharset = "";
        try {
            defaultCharset = resource.getString(17039408);
        }
        catch (Resources.NotFoundException e) {
            // empty catch block
        }
        return GsmAlphabet.gsm8BitUnpackedToString(data, offset, length, defaultCharset.trim());
    }

    static int hexCharToInt(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        throw new RuntimeException("invalid hex char '" + c + "'");
    }

    public static byte[] hexStringToBytes(String s) {
        if (s == null) {
            return null;
        }
        int sz = s.length();
        byte[] ret = new byte[sz / 2];
        for (int i = 0; i < sz; i += 2) {
            ret[i / 2] = (byte)(IccUtils.hexCharToInt(s.charAt(i)) << 4 | IccUtils.hexCharToInt(s.charAt(i + 1)));
        }
        return ret;
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = 0xF & bytes[i] >> 4;
            ret.append("0123456789abcdef".charAt(b));
            b = 0xF & bytes[i];
            ret.append("0123456789abcdef".charAt(b));
        }
        return ret.toString();
    }

    public static String networkNameToString(byte[] data, int offset, int length) {
        String ret;
        if ((data[offset] & 0x80) != 128 || length < 1) {
            return "";
        }
        switch (data[offset] >>> 4 & 7) {
            case 0: {
                int unusedBits = data[offset] & 7;
                int countSeptets = ((length - 1) * 8 - unusedBits) / 7;
                ret = GsmAlphabet.gsm7BitPackedToString(data, offset + 1, countSeptets);
                break;
            }
            case 1: {
                try {
                    ret = new String(data, offset + 1, length - 1, "utf-16");
                }
                catch (UnsupportedEncodingException ex) {
                    ret = "";
                    Rlog.e(LOG_TAG, "implausible UnsupportedEncodingException", ex);
                }
                break;
            }
            default: {
                ret = "";
            }
        }
        if ((data[offset] & 0x40) != 0) {
            // empty if block
        }
        return ret;
    }

    public static Bitmap parseToBnW(byte[] data, int length) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int numOfPixels = width * height;
        int[] pixels = new int[numOfPixels];
        int pixelIndex = 0;
        int bitIndex = 7;
        byte currentByte = 0;
        while (pixelIndex < numOfPixels) {
            if (pixelIndex % 8 == 0) {
                currentByte = data[valueIndex++];
                bitIndex = 7;
            }
            pixels[pixelIndex++] = IccUtils.bitToRGB(currentByte >> bitIndex-- & 1);
        }
        if (pixelIndex != numOfPixels) {
            Rlog.e(LOG_TAG, "parse end and size error");
        }
        return Bitmap.createBitmap(pixels, width, height, Bitmap.Config.ARGB_8888);
    }

    private static int bitToRGB(int bit) {
        if (bit == 1) {
            return -1;
        }
        return -16777216;
    }

    public static Bitmap parseToRGB(byte[] data, int length, boolean transparency) {
        int valueIndex = 0;
        int width = data[valueIndex++] & 0xFF;
        int height = data[valueIndex++] & 0xFF;
        int bits = data[valueIndex++] & 0xFF;
        int colorNumber = data[valueIndex++] & 0xFF;
        int clutOffset = (data[valueIndex++] & 0xFF) << 8 | data[valueIndex++] & 0xFF;
        int[] colorIndexArray = IccUtils.getCLUT(data, clutOffset, colorNumber);
        if (transparency) {
            colorIndexArray[colorNumber - 1] = 0;
        }
        int[] resultArray = null;
        resultArray = 0 == 8 % bits ? IccUtils.mapTo2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits) : IccUtils.mapToNon2OrderBitColor(data, valueIndex, width * height, colorIndexArray, bits);
        return Bitmap.createBitmap(resultArray, width, height, Bitmap.Config.RGB_565);
    }

    private static int[] mapTo2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 != 8 % bits) {
            Rlog.e(LOG_TAG, "not event number of color");
            return IccUtils.mapToNon2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int mask = 1;
        switch (bits) {
            case 1: {
                mask = 1;
                break;
            }
            case 2: {
                mask = 3;
                break;
            }
            case 4: {
                mask = 15;
                break;
            }
            case 8: {
                mask = 255;
            }
        }
        int[] resultArray = new int[length];
        int resultIndex = 0;
        int run = 8 / bits;
        while (resultIndex < length) {
            byte tempByte = data[valueIndex++];
            for (int runIndex = 0; runIndex < run; ++runIndex) {
                int offset = run - runIndex - 1;
                resultArray[resultIndex++] = colorArray[tempByte >> offset * bits & mask];
            }
        }
        return resultArray;
    }

    private static int[] mapToNon2OrderBitColor(byte[] data, int valueIndex, int length, int[] colorArray, int bits) {
        if (0 == 8 % bits) {
            Rlog.e(LOG_TAG, "not odd number of color");
            return IccUtils.mapTo2OrderBitColor(data, valueIndex, length, colorArray, bits);
        }
        int[] resultArray = new int[length];
        return resultArray;
    }

    private static int[] getCLUT(byte[] rawData, int offset, int number) {
        if (null == rawData) {
            return null;
        }
        int[] result = new int[number];
        int endIndex = offset + number * 3;
        int valueIndex = offset;
        int colorIndex = 0;
        int alpha = -16777216;
        do {
            result[colorIndex++] = alpha | (rawData[valueIndex++] & 0xFF) << 16 | (rawData[valueIndex++] & 0xFF) << 8 | rawData[valueIndex++] & 0xFF;
        } while (valueIndex < endIndex);
        return result;
    }
}

