/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;

public class IndentingPrintWriter
extends PrintWriter {
    private final String mSingleIndent;
    private final int mWrapLength;
    private StringBuilder mIndentBuilder = new StringBuilder();
    private char[] mCurrentIndent;
    private int mCurrentLength;
    private boolean mEmptyLine = true;

    public IndentingPrintWriter(Writer writer, String singleIndent) {
        this(writer, singleIndent, -1);
    }

    public IndentingPrintWriter(Writer writer, String singleIndent, int wrapLength) {
        super(writer);
        this.mSingleIndent = singleIndent;
        this.mWrapLength = wrapLength;
    }

    public void increaseIndent() {
        this.mIndentBuilder.append(this.mSingleIndent);
        this.mCurrentIndent = null;
    }

    public void decreaseIndent() {
        this.mIndentBuilder.delete(0, this.mSingleIndent.length());
        this.mCurrentIndent = null;
    }

    public void printPair(String key, Object value) {
        this.print(key + "=" + String.valueOf(value) + " ");
    }

    public void printPair(String key, Object[] value) {
        this.print(key + "=" + Arrays.toString(value) + " ");
    }

    public void printHexPair(String key, int value) {
        this.print(key + "=0x" + Integer.toHexString(value) + " ");
    }

    @Override
    public void write(char[] buf, int offset, int count) {
        int indentLength = this.mIndentBuilder.length();
        int bufferEnd = offset + count;
        int lineStart = offset;
        int lineEnd = offset;
        while (lineEnd < bufferEnd) {
            char ch = buf[lineEnd++];
            ++this.mCurrentLength;
            if (ch == '\n') {
                this.maybeWriteIndent();
                super.write(buf, lineStart, lineEnd - lineStart);
                lineStart = lineEnd;
                this.mEmptyLine = true;
                this.mCurrentLength = 0;
            }
            if (this.mWrapLength <= 0 || this.mCurrentLength < this.mWrapLength - indentLength) continue;
            if (!this.mEmptyLine) {
                super.write(10);
                this.mEmptyLine = true;
                this.mCurrentLength = lineEnd - lineStart;
                continue;
            }
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
            super.write(10);
            this.mEmptyLine = true;
            lineStart = lineEnd;
            this.mCurrentLength = 0;
        }
        if (lineStart != lineEnd) {
            this.maybeWriteIndent();
            super.write(buf, lineStart, lineEnd - lineStart);
        }
    }

    private void maybeWriteIndent() {
        if (this.mEmptyLine) {
            this.mEmptyLine = false;
            if (this.mIndentBuilder.length() != 0) {
                if (this.mCurrentIndent == null) {
                    this.mCurrentIndent = this.mIndentBuilder.toString().toCharArray();
                }
                super.write(this.mCurrentIndent, 0, this.mCurrentIndent.length);
            }
        }
    }
}

