/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.text.TextUtils;
import android.util.Size;
import android.view.ContextThemeWrapper;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.Transformation;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class FloatingToolbar {
    private static final MenuItem.OnMenuItemClickListener NO_OP_MENUITEM_CLICK_LISTENER = new MenuItem.OnMenuItemClickListener(){

        @Override
        public boolean onMenuItemClick(MenuItem item) {
            return false;
        }
    };
    private final Context mContext;
    private final FloatingToolbarPopup mPopup;
    private final Rect mContentRect = new Rect();
    private final Rect mPreviousContentRect = new Rect();
    private Menu mMenu;
    private List<Object> mShowingMenuItems = new ArrayList<Object>();
    private MenuItem.OnMenuItemClickListener mMenuItemClickListener = NO_OP_MENUITEM_CLICK_LISTENER;
    private int mSuggestedWidth;
    private boolean mWidthChanged = true;
    private final ComponentCallbacks mOrientationChangeHandler = new ComponentCallbacks(){

        @Override
        public void onConfigurationChanged(Configuration newConfig) {
            if (FloatingToolbar.this.mPopup.isShowing() && FloatingToolbar.this.mPopup.viewPortHasChanged()) {
                FloatingToolbar.this.mWidthChanged = true;
                FloatingToolbar.this.updateLayout();
            }
        }

        @Override
        public void onLowMemory() {
        }
    };

    public FloatingToolbar(Context context, Window window) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(window);
        this.mContext = FloatingToolbar.applyDefaultTheme(context);
        this.mPopup = new FloatingToolbarPopup(this.mContext, window.getDecorView());
    }

    public FloatingToolbar setMenu(Menu menu2) {
        this.mMenu = Preconditions.checkNotNull(menu2);
        return this;
    }

    public FloatingToolbar setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener menuItemClickListener) {
        this.mMenuItemClickListener = menuItemClickListener != null ? menuItemClickListener : NO_OP_MENUITEM_CLICK_LISTENER;
        return this;
    }

    public FloatingToolbar setContentRect(Rect rect) {
        this.mContentRect.set(Preconditions.checkNotNull(rect));
        return this;
    }

    public FloatingToolbar setSuggestedWidth(int suggestedWidth) {
        int difference = Math.abs(suggestedWidth - this.mSuggestedWidth);
        this.mWidthChanged = (double)difference > (double)this.mSuggestedWidth * 0.2;
        this.mSuggestedWidth = suggestedWidth;
        return this;
    }

    public FloatingToolbar show() {
        this.mContext.unregisterComponentCallbacks(this.mOrientationChangeHandler);
        this.mContext.registerComponentCallbacks(this.mOrientationChangeHandler);
        List<MenuItem> menuItems = this.getVisibleAndEnabledMenuItems(this.mMenu);
        if (!this.isCurrentlyShowing(menuItems) || this.mWidthChanged) {
            this.mPopup.dismiss();
            this.mPopup.layoutMenuItems(menuItems, this.mMenuItemClickListener, this.mSuggestedWidth);
            this.mShowingMenuItems = this.getShowingMenuItemsReferences(menuItems);
        }
        if (!this.mPopup.isShowing()) {
            this.mPopup.show(this.mContentRect);
        } else if (!this.mPreviousContentRect.equals(this.mContentRect)) {
            this.mPopup.updateCoordinates(this.mContentRect);
        }
        this.mWidthChanged = false;
        this.mPreviousContentRect.set(this.mContentRect);
        return this;
    }

    public FloatingToolbar updateLayout() {
        if (this.mPopup.isShowing()) {
            this.show();
        }
        return this;
    }

    public void dismiss() {
        this.mContext.unregisterComponentCallbacks(this.mOrientationChangeHandler);
        this.mPopup.dismiss();
    }

    public void hide() {
        this.mPopup.hide();
    }

    public boolean isShowing() {
        return this.mPopup.isShowing();
    }

    public boolean isHidden() {
        return this.mPopup.isHidden();
    }

    private boolean isCurrentlyShowing(List<MenuItem> menuItems) {
        return this.mShowingMenuItems.equals(this.getShowingMenuItemsReferences(menuItems));
    }

    private List<MenuItem> getVisibleAndEnabledMenuItems(Menu menu2) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        for (int i = 0; menu2 != null && i < menu2.size(); ++i) {
            MenuItem menuItem = menu2.getItem(i);
            if (!menuItem.isVisible() || !menuItem.isEnabled()) continue;
            SubMenu subMenu = menuItem.getSubMenu();
            if (subMenu != null) {
                menuItems.addAll(this.getVisibleAndEnabledMenuItems(subMenu));
                continue;
            }
            menuItems.add(menuItem);
        }
        return menuItems;
    }

    private List<Object> getShowingMenuItemsReferences(List<MenuItem> menuItems) {
        ArrayList<Object> references = new ArrayList<Object>();
        for (MenuItem menuItem : menuItems) {
            if (FloatingToolbar.isIconOnlyMenuItem(menuItem)) {
                references.add(menuItem.getIcon());
                continue;
            }
            references.add(menuItem.getTitle());
        }
        return references;
    }

    private static boolean isIconOnlyMenuItem(MenuItem menuItem) {
        return TextUtils.isEmpty(menuItem.getTitle()) && menuItem.getIcon() != null;
    }

    private static View createMenuItemButton(Context context, MenuItem menuItem) {
        if (FloatingToolbar.isIconOnlyMenuItem(menuItem)) {
            View imageMenuItemButton = LayoutInflater.from(context).inflate(17367131, null);
            ((ImageButton)imageMenuItemButton.findViewById(16908372)).setImageDrawable(menuItem.getIcon());
            return imageMenuItemButton;
        }
        Button menuItemButton = (Button)LayoutInflater.from(context).inflate(17367130, null);
        menuItemButton.setText(menuItem.getTitle());
        menuItemButton.setContentDescription(menuItem.getTitle());
        return menuItemButton;
    }

    private static TextView createOverflowMenuItemButton(Context context) {
        return (TextView)LayoutInflater.from(context).inflate(17367134, null);
    }

    private static ViewGroup createContentContainer(Context context) {
        return (ViewGroup)LayoutInflater.from(context).inflate(17367129, null);
    }

    private static PopupWindow createPopupWindow(View content) {
        LinearLayout popupContentHolder = new LinearLayout(content.getContext());
        PopupWindow popupWindow = new PopupWindow(popupContentHolder);
        popupWindow.setClippingEnabled(false);
        popupWindow.setWindowLayoutType(1005);
        popupWindow.setAnimationStyle(0);
        popupWindow.setBackgroundDrawable(new ColorDrawable(0));
        content.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        popupContentHolder.addView(content);
        return popupWindow;
    }

    private static AnimatorSet createEnterAnimation(View view) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f).setDuration(200L), ObjectAnimator.ofFloat(view, View.X, view.getX(), view.getX()));
        animation.setStartDelay(50L);
        return animation;
    }

    private static AnimatorSet createExitAnimation(View view, int startDelay, Animator.AnimatorListener listener) {
        AnimatorSet animation = new AnimatorSet();
        animation.playTogether(ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f).setDuration(200L));
        animation.setStartDelay(startDelay);
        animation.addListener(listener);
        return animation;
    }

    private static Context applyDefaultTheme(Context originalContext) {
        TypedArray a = originalContext.obtainStyledAttributes(new int[]{0x1160000});
        boolean isLightTheme = a.getBoolean(0, true);
        int themeId = isLightTheme ? 16974391 : 16974372;
        a.recycle();
        return new ContextThemeWrapper(originalContext, themeId);
    }

    private static int getEstimatedToolbarHeight(Context context) {
        return context.getResources().getDimensionPixelSize(17105045);
    }

    private static int getEstimatedOpenOverflowButtonWidth(Context context) {
        return context.getResources().getDimensionPixelSize(17105052);
    }

    private static final class ViewFader {
        private static final int FADE_OUT_DURATION = 250;
        private static final int FADE_IN_DURATION = 150;
        private final View mView;
        private final ObjectAnimator mFadeOutAnimation;
        private final ObjectAnimator mFadeInAnimation;

        private ViewFader(View view) {
            this.mView = Preconditions.checkNotNull(view);
            this.mFadeOutAnimation = ObjectAnimator.ofFloat(view, View.ALPHA, 1.0f, 0.0f).setDuration(250L);
            this.mFadeInAnimation = ObjectAnimator.ofFloat(view, View.ALPHA, 0.0f, 1.0f).setDuration(150L);
        }

        public void fadeIn(boolean animate) {
            this.cancelFadeAnimations();
            if (animate) {
                this.mFadeInAnimation.start();
            } else {
                this.mView.setAlpha(1.0f);
            }
        }

        public void fadeOut(boolean animate) {
            this.cancelFadeAnimations();
            if (animate) {
                this.mFadeOutAnimation.start();
            } else {
                this.mView.setAlpha(0.0f);
            }
        }

        private void cancelFadeAnimations() {
            this.mFadeInAnimation.cancel();
            this.mFadeOutAnimation.cancel();
        }
    }

    private static final class FloatingToolbarOverflowPanel {
        private final LinearLayout mContentView;
        private final ViewGroup mBackButtonContainer;
        private final View mBackButton;
        private final ListView mListView;
        private final TextView mListViewItemWidthCalculator;
        private final ViewFader mViewFader;
        private final Runnable mCloseOverflow;
        private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;
        private int mOverflowWidth;
        private int mSuggestedHeight;

        public FloatingToolbarOverflowPanel(Context context, Runnable closeOverflow) {
            this.mCloseOverflow = Preconditions.checkNotNull(closeOverflow);
            this.mContentView = new LinearLayout(context);
            this.mContentView.setOrientation(1);
            this.mViewFader = new ViewFader(this.mContentView);
            this.mBackButton = LayoutInflater.from(context).inflate(17367128, null);
            this.mBackButton.setOnClickListener(new View.OnClickListener(){

                @Override
                public void onClick(View v) {
                    FloatingToolbarOverflowPanel.this.mCloseOverflow.run();
                }
            });
            this.mBackButtonContainer = new LinearLayout(context);
            this.mBackButtonContainer.addView(this.mBackButton);
            this.mListView = this.createOverflowListView();
            this.mListView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                @Override
                public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                    MenuItem menuItem = (MenuItem)FloatingToolbarOverflowPanel.this.mListView.getAdapter().getItem(position);
                    if (FloatingToolbarOverflowPanel.this.mOnMenuItemClickListener != null) {
                        FloatingToolbarOverflowPanel.this.mOnMenuItemClickListener.onMenuItemClick(menuItem);
                    }
                }
            });
            this.mContentView.addView(this.mListView);
            this.mContentView.addView(this.mBackButtonContainer);
            this.mListViewItemWidthCalculator = FloatingToolbar.createOverflowMenuItemButton(context);
            this.mListViewItemWidthCalculator.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        }

        public void setMenuItems(List<MenuItem> menuItems) {
            ArrayAdapter overflowListViewAdapter = (ArrayAdapter)this.mListView.getAdapter();
            overflowListViewAdapter.clear();
            overflowListViewAdapter.addAll(menuItems);
            this.setListViewHeight();
            this.setOverflowWidth();
        }

        public void setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener listener) {
            this.mOnMenuItemClickListener = listener;
        }

        public void setOverflowDirection(int overflowDirection) {
            this.mContentView.removeView(this.mBackButtonContainer);
            int index = overflowDirection == 0 ? 1 : 0;
            this.mContentView.addView((View)this.mBackButtonContainer, index);
        }

        public void setSuggestedHeight(int height) {
            this.mSuggestedHeight = height;
            this.setListViewHeight();
        }

        public int getMinimumHeight() {
            return this.mContentView.getContext().getResources().getDimensionPixelSize(17105054) + FloatingToolbar.getEstimatedToolbarHeight(this.mContentView.getContext());
        }

        public View getView() {
            return this.mContentView;
        }

        public void fadeIn(boolean animate) {
            this.mViewFader.fadeIn(animate);
        }

        public void fadeOut(boolean animate) {
            this.mViewFader.fadeOut(animate);
        }

        public Size measure() {
            Preconditions.checkState(this.mContentView.getParent() == null);
            this.mContentView.measure(0, 0);
            return new Size(this.mContentView.getMeasuredWidth(), this.mContentView.getMeasuredHeight());
        }

        private void setListViewHeight() {
            int itemHeight = FloatingToolbar.getEstimatedToolbarHeight(this.mContentView.getContext());
            int height = this.mListView.getAdapter().getCount() * itemHeight;
            int maxHeight = this.mContentView.getContext().getResources().getDimensionPixelSize(17105055);
            int minHeight = this.mContentView.getContext().getResources().getDimensionPixelSize(17105054);
            int suggestedListViewHeight = this.mSuggestedHeight - this.mSuggestedHeight % itemHeight - itemHeight;
            ViewGroup.LayoutParams params = this.mListView.getLayoutParams();
            params.height = suggestedListViewHeight <= 0 ? Math.min(maxHeight, height) : (suggestedListViewHeight < minHeight ? minHeight : Math.min(Math.min(suggestedListViewHeight, maxHeight), height));
            this.mListView.setLayoutParams(params);
        }

        private void setOverflowWidth() {
            this.mOverflowWidth = 0;
            for (int i = 0; i < this.mListView.getAdapter().getCount(); ++i) {
                MenuItem menuItem = (MenuItem)this.mListView.getAdapter().getItem(i);
                Preconditions.checkNotNull(menuItem);
                this.mListViewItemWidthCalculator.setText(menuItem.getTitle());
                this.mListViewItemWidthCalculator.measure(0, 0);
                this.mOverflowWidth = Math.max(this.mListViewItemWidthCalculator.getMeasuredWidth(), this.mOverflowWidth);
            }
        }

        private ListView createOverflowListView() {
            final Context context = this.mContentView.getContext();
            ListView overflowListView = new ListView(context);
            overflowListView.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
            overflowListView.setDivider(null);
            overflowListView.setDividerHeight(0);
            int viewTypeCount = 2;
            boolean stringLabelViewType = false;
            boolean iconOnlyViewType = true;
            ArrayAdapter<MenuItem> overflowListViewAdapter = new ArrayAdapter<MenuItem>(context, 0){

                @Override
                public int getViewTypeCount() {
                    return 2;
                }

                @Override
                public int getItemViewType(int position) {
                    if (FloatingToolbar.isIconOnlyMenuItem((MenuItem)this.getItem(position))) {
                        return 1;
                    }
                    return 0;
                }

                @Override
                public View getView(int position, View convertView, ViewGroup parent) {
                    if (this.getItemViewType(position) == 1) {
                        return this.getIconOnlyView(position, convertView);
                    }
                    return this.getStringTitleView(position, convertView);
                }

                private View getStringTitleView(int position, View convertView) {
                    TextView menuButton = convertView != null ? (TextView)convertView : FloatingToolbar.createOverflowMenuItemButton(context);
                    MenuItem menuItem = (MenuItem)this.getItem(position);
                    menuButton.setText(menuItem.getTitle());
                    menuButton.setContentDescription(menuItem.getTitle());
                    menuButton.setMinimumWidth(FloatingToolbarOverflowPanel.this.mOverflowWidth);
                    return menuButton;
                }

                private View getIconOnlyView(int position, View convertView) {
                    View menuButton = convertView != null ? convertView : LayoutInflater.from(context).inflate(17367133, null);
                    MenuItem menuItem = (MenuItem)this.getItem(position);
                    ((ImageView)menuButton.findViewById(16908372)).setImageDrawable(menuItem.getIcon());
                    menuButton.setMinimumWidth(FloatingToolbarOverflowPanel.this.mOverflowWidth);
                    return menuButton;
                }
            };
            overflowListView.setAdapter(overflowListViewAdapter);
            return overflowListView;
        }
    }

    private static final class FloatingToolbarMainPanel {
        private final Context mContext;
        private final ViewGroup mContentView;
        private final View.OnClickListener mMenuItemButtonOnClickListener = new View.OnClickListener(){

            @Override
            public void onClick(View v) {
                if (v.getTag() instanceof MenuItem && FloatingToolbarMainPanel.this.mOnMenuItemClickListener != null) {
                    FloatingToolbarMainPanel.this.mOnMenuItemClickListener.onMenuItemClick((MenuItem)v.getTag());
                }
            }
        };
        private final ViewFader viewFader;
        private final Runnable mOpenOverflow;
        private View mOpenOverflowButton;
        private MenuItem.OnMenuItemClickListener mOnMenuItemClickListener;

        public FloatingToolbarMainPanel(Context context, Runnable openOverflow) {
            this.mContext = Preconditions.checkNotNull(context);
            this.mContentView = new LinearLayout(context);
            this.viewFader = new ViewFader(this.mContentView);
            this.mOpenOverflow = Preconditions.checkNotNull(openOverflow);
        }

        public List<MenuItem> layoutMenuItems(List<MenuItem> menuItems, int width) {
            int toolbarWidth;
            Preconditions.checkNotNull(menuItems);
            int availableWidth = toolbarWidth = width - FloatingToolbar.getEstimatedOpenOverflowButtonWidth(this.mContext);
            LinkedList<MenuItem> remainingMenuItems = new LinkedList<MenuItem>(menuItems);
            this.mContentView.removeAllViews();
            boolean isFirstItem = true;
            while (!remainingMenuItems.isEmpty()) {
                MenuItem menuItem = remainingMenuItems.peek();
                View menuItemButton = FloatingToolbar.createMenuItemButton(this.mContext, menuItem);
                if (isFirstItem) {
                    menuItemButton.setPaddingRelative((int)(1.5 * (double)menuItemButton.getPaddingStart()), menuItemButton.getPaddingTop(), menuItemButton.getPaddingEnd(), menuItemButton.getPaddingBottom());
                    isFirstItem = false;
                }
                if (remainingMenuItems.size() == 1) {
                    menuItemButton.setPaddingRelative(menuItemButton.getPaddingStart(), menuItemButton.getPaddingTop(), (int)(1.5 * (double)menuItemButton.getPaddingEnd()), menuItemButton.getPaddingBottom());
                }
                menuItemButton.measure(0, 0);
                int menuItemButtonWidth = Math.min(menuItemButton.getMeasuredWidth(), toolbarWidth);
                if (menuItemButtonWidth <= availableWidth) {
                    this.setButtonTagAndClickListener(menuItemButton, menuItem);
                    this.mContentView.addView(menuItemButton);
                    ViewGroup.LayoutParams params = menuItemButton.getLayoutParams();
                    params.width = menuItemButtonWidth;
                    menuItemButton.setLayoutParams(params);
                    availableWidth -= menuItemButtonWidth;
                    remainingMenuItems.pop();
                    continue;
                }
                if (this.mOpenOverflowButton == null) {
                    this.mOpenOverflowButton = LayoutInflater.from(this.mContext).inflate(17367132, null);
                    this.mOpenOverflowButton.setOnClickListener(new View.OnClickListener(){

                        @Override
                        public void onClick(View v) {
                            if (FloatingToolbarMainPanel.this.mOpenOverflowButton != null) {
                                FloatingToolbarMainPanel.this.mOpenOverflow.run();
                            }
                        }
                    });
                }
                this.mContentView.addView(this.mOpenOverflowButton);
                break;
            }
            return remainingMenuItems;
        }

        public void setOnMenuItemClickListener(MenuItem.OnMenuItemClickListener listener) {
            this.mOnMenuItemClickListener = listener;
        }

        public View getView() {
            return this.mContentView;
        }

        public void fadeIn(boolean animate) {
            this.viewFader.fadeIn(animate);
        }

        public void fadeOut(boolean animate) {
            this.viewFader.fadeOut(animate);
        }

        public Size measure() throws IllegalStateException {
            Preconditions.checkState(this.mContentView.getParent() == null);
            this.mContentView.measure(0, 0);
            return new Size(this.mContentView.getMeasuredWidth(), this.mContentView.getMeasuredHeight());
        }

        private void setButtonTagAndClickListener(View menuItemButton, MenuItem menuItem) {
            View button = menuItemButton;
            if (FloatingToolbar.isIconOnlyMenuItem(menuItem)) {
                button = menuItemButton.findViewById(16908372);
            }
            button.setTag(menuItem);
            button.setOnClickListener(this.mMenuItemButtonOnClickListener);
        }
    }

    private static final class FloatingToolbarPopup {
        public static final int OVERFLOW_DIRECTION_UP = 0;
        public static final int OVERFLOW_DIRECTION_DOWN = 1;
        private final Context mContext;
        private final View mParent;
        private final PopupWindow mPopupWindow;
        private final ViewGroup mContentContainer;
        private final int mMarginHorizontal;
        private final int mMarginVertical;
        private final Animation.AnimationListener mOnOverflowOpened = new Animation.AnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                FloatingToolbarPopup.this.setOverflowPanelAsContent();
                FloatingToolbarPopup.this.mOverflowPanel.fadeIn(true);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }
        };
        private final Animation.AnimationListener mOnOverflowClosed = new Animation.AnimationListener(){

            @Override
            public void onAnimationStart(Animation animation) {
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                FloatingToolbarPopup.this.setMainPanelAsContent();
                FloatingToolbarPopup.this.mMainPanel.fadeIn(true);
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
            }
        };
        private final AnimatorSet mDismissAnimation;
        private final AnimatorSet mHideAnimation;
        private final AnimationSet mOpenOverflowAnimation = new AnimationSet(true);
        private final AnimationSet mCloseOverflowAnimation = new AnimationSet(true);
        private final Runnable mOpenOverflow = new Runnable(){

            @Override
            public void run() {
                FloatingToolbarPopup.this.openOverflow();
            }
        };
        private final Runnable mCloseOverflow = new Runnable(){

            @Override
            public void run() {
                FloatingToolbarPopup.this.closeOverflow();
            }
        };
        private final Rect mViewPortOnScreen = new Rect();
        private final Point mCoordsOnWindow = new Point();
        private final int[] mTmpCoords = new int[2];
        private final Rect mTmpRect = new Rect();
        private final Region mTouchableRegion = new Region();
        private final ViewTreeObserver.OnComputeInternalInsetsListener mInsetsComputer = new ViewTreeObserver.OnComputeInternalInsetsListener(){

            @Override
            public void onComputeInternalInsets(ViewTreeObserver.InternalInsetsInfo info) {
                info.contentInsets.setEmpty();
                info.visibleInsets.setEmpty();
                info.touchableRegion.set(FloatingToolbarPopup.this.mTouchableRegion);
                info.setTouchableInsets(3);
            }
        };
        private boolean mDismissed = true;
        private boolean mHidden;
        private FloatingToolbarOverflowPanel mOverflowPanel;
        private FloatingToolbarMainPanel mMainPanel;
        private int mOverflowDirection;

        public FloatingToolbarPopup(Context context, View parent) {
            this.mParent = Preconditions.checkNotNull(parent);
            this.mContext = Preconditions.checkNotNull(context);
            this.mContentContainer = FloatingToolbar.createContentContainer(context);
            this.mPopupWindow = FloatingToolbar.createPopupWindow(this.mContentContainer);
            this.mDismissAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 150, new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    FloatingToolbarPopup.this.mPopupWindow.dismiss();
                    FloatingToolbarPopup.this.mContentContainer.removeAllViews();
                }
            });
            this.mHideAnimation = FloatingToolbar.createExitAnimation(this.mContentContainer, 0, new AnimatorListenerAdapter(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    FloatingToolbarPopup.this.mPopupWindow.dismiss();
                }
            });
            this.mMarginHorizontal = parent.getResources().getDimensionPixelSize(17105056);
            this.mMarginVertical = parent.getResources().getDimensionPixelSize(17105057);
        }

        public void layoutMenuItems(List<MenuItem> menuItems, MenuItem.OnMenuItemClickListener menuItemClickListener, int suggestedWidth) {
            Preconditions.checkNotNull(menuItems);
            this.mContentContainer.removeAllViews();
            if (this.mMainPanel == null) {
                this.mMainPanel = new FloatingToolbarMainPanel(this.mContext, this.mOpenOverflow);
            }
            List<MenuItem> overflowMenuItems = this.mMainPanel.layoutMenuItems(menuItems, this.getToolbarWidth(suggestedWidth));
            this.mMainPanel.setOnMenuItemClickListener(menuItemClickListener);
            if (!overflowMenuItems.isEmpty()) {
                if (this.mOverflowPanel == null) {
                    this.mOverflowPanel = new FloatingToolbarOverflowPanel(this.mContext, this.mCloseOverflow);
                }
                this.mOverflowPanel.setMenuItems(overflowMenuItems);
                this.mOverflowPanel.setOnMenuItemClickListener(menuItemClickListener);
            }
            this.updatePopupSize();
        }

        public void show(Rect contentRectOnScreen) {
            Preconditions.checkNotNull(contentRectOnScreen);
            if (this.isShowing()) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = false;
            this.cancelDismissAndHideAnimations();
            this.cancelOverflowAnimations();
            if (this.mContentContainer.getChildCount() == 0) {
                this.setMainPanelAsContent();
                this.mContentContainer.setAlpha(0.0f);
            }
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.showAtLocation(this.mParent, 0, this.mCoordsOnWindow.x, this.mCoordsOnWindow.y);
            this.setTouchableSurfaceInsetsComputer();
            this.runShowAnimation();
        }

        public void dismiss() {
            if (this.mDismissed) {
                return;
            }
            this.mHidden = false;
            this.mDismissed = true;
            this.mHideAnimation.cancel();
            this.runDismissAnimation();
            this.setZeroTouchableSurface();
        }

        public void hide() {
            if (!this.isShowing()) {
                return;
            }
            this.mHidden = true;
            this.runHideAnimation();
            this.setZeroTouchableSurface();
        }

        public boolean isShowing() {
            return !this.mDismissed && !this.mHidden;
        }

        public boolean isHidden() {
            return this.mHidden;
        }

        public void updateCoordinates(Rect contentRectOnScreen) {
            Preconditions.checkNotNull(contentRectOnScreen);
            if (!this.isShowing() || !this.mPopupWindow.isShowing()) {
                return;
            }
            this.cancelOverflowAnimations();
            this.refreshCoordinatesAndOverflowDirection(contentRectOnScreen);
            this.preparePopupContent();
            this.mPopupWindow.update(this.mCoordsOnWindow.x, this.mCoordsOnWindow.y, this.getWidth(), this.getHeight());
        }

        public int getWidth() {
            return this.mPopupWindow.getWidth();
        }

        public int getHeight() {
            return this.mPopupWindow.getHeight();
        }

        public Context getContext() {
            return this.mContext;
        }

        private void refreshCoordinatesAndOverflowDirection(Rect contentRectOnScreen) {
            int y;
            this.refreshViewPort();
            int x = contentRectOnScreen.centerX() - this.getWidth() / 2;
            x = Math.max(0, Math.min(x, this.mViewPortOnScreen.right - this.getWidth()));
            int availableHeightAboveContent = contentRectOnScreen.top - this.mViewPortOnScreen.top;
            int availableHeightBelowContent = this.mViewPortOnScreen.bottom - contentRectOnScreen.bottom;
            if (this.mOverflowPanel == null) {
                y = availableHeightAboveContent >= this.getToolbarHeightWithVerticalMargin() ? contentRectOnScreen.top - this.getToolbarHeightWithVerticalMargin() : (availableHeightBelowContent >= this.getToolbarHeightWithVerticalMargin() ? contentRectOnScreen.bottom : (availableHeightBelowContent >= FloatingToolbar.getEstimatedToolbarHeight(this.mContext) ? contentRectOnScreen.bottom - this.mMarginVertical : Math.max(this.mViewPortOnScreen.top, contentRectOnScreen.top - this.getToolbarHeightWithVerticalMargin())));
            } else {
                int margin = 2 * this.mMarginVertical;
                int minimumOverflowHeightWithMargin = this.mOverflowPanel.getMinimumHeight() + margin;
                int availableHeightThroughContentDown = this.mViewPortOnScreen.bottom - contentRectOnScreen.top + this.getToolbarHeightWithVerticalMargin();
                int availableHeightThroughContentUp = contentRectOnScreen.bottom - this.mViewPortOnScreen.top + this.getToolbarHeightWithVerticalMargin();
                if (availableHeightAboveContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightAboveContent - margin);
                    y = contentRectOnScreen.top - this.getHeight();
                    this.mOverflowDirection = 0;
                } else if (availableHeightAboveContent >= this.getToolbarHeightWithVerticalMargin() && availableHeightThroughContentDown >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentDown - margin);
                    y = contentRectOnScreen.top - this.getToolbarHeightWithVerticalMargin();
                    this.mOverflowDirection = 1;
                } else if (availableHeightBelowContent >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightBelowContent - margin);
                    y = contentRectOnScreen.bottom;
                    this.mOverflowDirection = 1;
                } else if (availableHeightBelowContent >= this.getToolbarHeightWithVerticalMargin() && this.mViewPortOnScreen.height() >= minimumOverflowHeightWithMargin) {
                    this.updateOverflowHeight(availableHeightThroughContentUp - margin);
                    y = contentRectOnScreen.bottom + this.getToolbarHeightWithVerticalMargin() - this.getHeight();
                    this.mOverflowDirection = 0;
                } else {
                    this.updateOverflowHeight(this.mViewPortOnScreen.height() - margin);
                    y = this.mViewPortOnScreen.top;
                    this.mOverflowDirection = 1;
                }
                this.mOverflowPanel.setOverflowDirection(this.mOverflowDirection);
            }
            this.mParent.getRootView().getLocationOnScreen(this.mTmpCoords);
            int rootViewLeftOnScreen = this.mTmpCoords[0];
            int rootViewTopOnScreen = this.mTmpCoords[1];
            this.mParent.getRootView().getLocationInWindow(this.mTmpCoords);
            int rootViewLeftOnWindow = this.mTmpCoords[0];
            int rootViewTopOnWindow = this.mTmpCoords[1];
            int windowLeftOnScreen = rootViewLeftOnScreen - rootViewLeftOnWindow;
            int windowTopOnScreen = rootViewTopOnScreen - rootViewTopOnWindow;
            this.mCoordsOnWindow.set(x - windowLeftOnScreen, y - windowTopOnScreen);
        }

        private int getToolbarHeightWithVerticalMargin() {
            return FloatingToolbar.getEstimatedToolbarHeight(this.mContext) + this.mMarginVertical * 2;
        }

        private void runShowAnimation() {
            FloatingToolbar.createEnterAnimation(this.mContentContainer).start();
        }

        private void runDismissAnimation() {
            this.mDismissAnimation.start();
        }

        private void runHideAnimation() {
            this.mHideAnimation.start();
        }

        private void cancelDismissAndHideAnimations() {
            this.mDismissAnimation.cancel();
            this.mHideAnimation.cancel();
        }

        private void cancelOverflowAnimations() {
            if (this.mOpenOverflowAnimation.hasStarted() && !this.mOpenOverflowAnimation.hasEnded()) {
                this.mOpenOverflowAnimation.setAnimationListener(null);
                this.mContentContainer.clearAnimation();
                this.mOnOverflowOpened.onAnimationEnd(null);
            }
            if (this.mCloseOverflowAnimation.hasStarted() && !this.mCloseOverflowAnimation.hasEnded()) {
                this.mCloseOverflowAnimation.setAnimationListener(null);
                this.mContentContainer.clearAnimation();
                this.mOnOverflowClosed.onAnimationEnd(null);
            }
        }

        private void openOverflow() {
            Preconditions.checkState(this.mMainPanel != null);
            Preconditions.checkState(this.mOverflowPanel != null);
            this.mMainPanel.fadeOut(true);
            Size overflowPanelSize = this.mOverflowPanel.measure();
            final int targetWidth = overflowPanelSize.getWidth();
            final int targetHeight = overflowPanelSize.getHeight();
            final boolean morphUpwards = this.mOverflowDirection == 0;
            final int startWidth = this.mContentContainer.getWidth();
            final int startHeight = this.mContentContainer.getHeight();
            final float startY = this.mContentContainer.getY();
            final float left = this.mContentContainer.getX();
            final float right = left + (float)this.mContentContainer.getWidth();
            Animation widthAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    ViewGroup.LayoutParams params = FloatingToolbarPopup.this.mContentContainer.getLayoutParams();
                    int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                    params.width = startWidth + deltaWidth;
                    FloatingToolbarPopup.this.mContentContainer.setLayoutParams(params);
                    if (FloatingToolbarPopup.this.isRTL()) {
                        FloatingToolbarPopup.this.mContentContainer.setX(left);
                    } else {
                        FloatingToolbarPopup.this.mContentContainer.setX(right - (float)FloatingToolbarPopup.this.mContentContainer.getWidth());
                    }
                }
            };
            Animation heightAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    ViewGroup.LayoutParams params = FloatingToolbarPopup.this.mContentContainer.getLayoutParams();
                    int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                    params.height = startHeight + deltaHeight;
                    FloatingToolbarPopup.this.mContentContainer.setLayoutParams(params);
                    if (morphUpwards) {
                        float y = startY - (float)(FloatingToolbarPopup.this.mContentContainer.getHeight() - startHeight);
                        FloatingToolbarPopup.this.mContentContainer.setY(y);
                    }
                }
            };
            widthAnimation.setDuration(240L);
            heightAnimation.setDuration(180L);
            heightAnimation.setStartOffset(60L);
            this.mOpenOverflowAnimation.getAnimations().clear();
            this.mOpenOverflowAnimation.setAnimationListener(this.mOnOverflowOpened);
            this.mOpenOverflowAnimation.addAnimation(widthAnimation);
            this.mOpenOverflowAnimation.addAnimation(heightAnimation);
            this.mContentContainer.startAnimation(this.mOpenOverflowAnimation);
        }

        private void closeOverflow() {
            Preconditions.checkState(this.mMainPanel != null);
            Preconditions.checkState(this.mOverflowPanel != null);
            this.mOverflowPanel.fadeOut(true);
            Size mainPanelSize = this.mMainPanel.measure();
            final int targetWidth = mainPanelSize.getWidth();
            final int targetHeight = mainPanelSize.getHeight();
            final int startWidth = this.mContentContainer.getWidth();
            final int startHeight = this.mContentContainer.getHeight();
            final float bottom = this.mContentContainer.getY() + (float)this.mContentContainer.getHeight();
            final boolean morphedUpwards = this.mOverflowDirection == 0;
            final float left = this.mContentContainer.getX();
            final float right = left + (float)this.mContentContainer.getWidth();
            Animation widthAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    ViewGroup.LayoutParams params = FloatingToolbarPopup.this.mContentContainer.getLayoutParams();
                    int deltaWidth = (int)(interpolatedTime * (float)(targetWidth - startWidth));
                    params.width = startWidth + deltaWidth;
                    FloatingToolbarPopup.this.mContentContainer.setLayoutParams(params);
                    if (FloatingToolbarPopup.this.isRTL()) {
                        FloatingToolbarPopup.this.mContentContainer.setX(left);
                    } else {
                        FloatingToolbarPopup.this.mContentContainer.setX(right - (float)FloatingToolbarPopup.this.mContentContainer.getWidth());
                    }
                }
            };
            Animation heightAnimation = new Animation(){

                @Override
                protected void applyTransformation(float interpolatedTime, Transformation t) {
                    ViewGroup.LayoutParams params = FloatingToolbarPopup.this.mContentContainer.getLayoutParams();
                    int deltaHeight = (int)(interpolatedTime * (float)(targetHeight - startHeight));
                    params.height = startHeight + deltaHeight;
                    FloatingToolbarPopup.this.mContentContainer.setLayoutParams(params);
                    if (morphedUpwards) {
                        FloatingToolbarPopup.this.mContentContainer.setY(bottom - (float)FloatingToolbarPopup.this.mContentContainer.getHeight());
                    }
                }
            };
            widthAnimation.setDuration(150L);
            widthAnimation.setStartOffset(150L);
            heightAnimation.setDuration(210L);
            this.mCloseOverflowAnimation.getAnimations().clear();
            this.mCloseOverflowAnimation.setAnimationListener(this.mOnOverflowClosed);
            this.mCloseOverflowAnimation.addAnimation(widthAnimation);
            this.mCloseOverflowAnimation.addAnimation(heightAnimation);
            this.mContentContainer.startAnimation(this.mCloseOverflowAnimation);
        }

        private void preparePopupContent() {
            if (this.mMainPanel != null) {
                this.mMainPanel.fadeIn(false);
            }
            if (this.mOverflowPanel != null) {
                this.mOverflowPanel.fadeIn(false);
            }
            if (this.isMainPanelContent()) {
                this.positionMainPanel();
            }
            if (this.isOverflowPanelContent()) {
                this.positionOverflowPanel();
            }
        }

        private boolean isMainPanelContent() {
            return this.mMainPanel != null && this.mContentContainer.getChildAt(0) == this.mMainPanel.getView();
        }

        private boolean isOverflowPanelContent() {
            return this.mOverflowPanel != null && this.mContentContainer.getChildAt(0) == this.mOverflowPanel.getView();
        }

        private void setMainPanelAsContent() {
            Preconditions.checkNotNull(this.mMainPanel);
            this.mContentContainer.removeAllViews();
            Size mainPanelSize = this.mMainPanel.measure();
            ViewGroup.LayoutParams params = this.mContentContainer.getLayoutParams();
            params.width = mainPanelSize.getWidth();
            params.height = mainPanelSize.getHeight();
            this.mContentContainer.setLayoutParams(params);
            this.mContentContainer.addView(this.mMainPanel.getView());
            this.setContentAreaAsTouchableSurface();
        }

        private void setOverflowPanelAsContent() {
            Preconditions.checkNotNull(this.mOverflowPanel);
            this.mContentContainer.removeAllViews();
            Size overflowPanelSize = this.mOverflowPanel.measure();
            ViewGroup.LayoutParams params = this.mContentContainer.getLayoutParams();
            params.width = overflowPanelSize.getWidth();
            params.height = overflowPanelSize.getHeight();
            this.mContentContainer.setLayoutParams(params);
            this.mContentContainer.addView(this.mOverflowPanel.getView());
            this.setContentAreaAsTouchableSurface();
        }

        private void positionMainPanel() {
            Preconditions.checkNotNull(this.mMainPanel);
            this.mContentContainer.setX(this.mMarginHorizontal);
            float y = this.mMarginVertical;
            if (this.mOverflowDirection == 0) {
                y = this.getHeight() - (this.mMainPanel.getView().getMeasuredHeight() + this.mMarginVertical);
            }
            this.mContentContainer.setY(y);
            this.setContentAreaAsTouchableSurface();
        }

        private void positionOverflowPanel() {
            Preconditions.checkNotNull(this.mOverflowPanel);
            float x = this.isRTL() ? (float)this.mMarginHorizontal : (float)(this.mPopupWindow.getWidth() - (this.mOverflowPanel.getView().getMeasuredWidth() + this.mMarginHorizontal));
            this.mContentContainer.setX(x);
            this.mContentContainer.setY(this.mMarginVertical);
            this.setContentAreaAsTouchableSurface();
        }

        private void updateOverflowHeight(int height) {
            if (this.mOverflowPanel != null) {
                this.mOverflowPanel.setSuggestedHeight(height);
                boolean mainPanelContent = this.isMainPanelContent();
                boolean overflowPanelContent = this.isOverflowPanelContent();
                this.mContentContainer.removeAllViews();
                this.updatePopupSize();
                if (mainPanelContent) {
                    this.setMainPanelAsContent();
                }
                if (overflowPanelContent) {
                    this.setOverflowPanelAsContent();
                }
            }
        }

        private void updatePopupSize() {
            int width = 0;
            int height = 0;
            if (this.mMainPanel != null) {
                Size mainPanelSize = this.mMainPanel.measure();
                width = mainPanelSize.getWidth();
                height = mainPanelSize.getHeight();
            }
            if (this.mOverflowPanel != null) {
                Size overflowPanelSize = this.mOverflowPanel.measure();
                width = Math.max(width, overflowPanelSize.getWidth());
                height = Math.max(height, overflowPanelSize.getHeight());
            }
            this.mPopupWindow.setWidth(width + this.mMarginHorizontal * 2);
            this.mPopupWindow.setHeight(height + this.mMarginVertical * 2);
        }

        private void refreshViewPort() {
            this.mParent.getWindowVisibleDisplayFrame(this.mViewPortOnScreen);
        }

        private boolean viewPortHasChanged() {
            this.mParent.getWindowVisibleDisplayFrame(this.mTmpRect);
            return !this.mTmpRect.equals(this.mViewPortOnScreen);
        }

        private int getToolbarWidth(int suggestedWidth) {
            int width = suggestedWidth;
            this.refreshViewPort();
            int maximumWidth = this.mViewPortOnScreen.width() - 2 * this.mParent.getResources().getDimensionPixelSize(17105056);
            if (width <= 0) {
                width = this.mParent.getResources().getDimensionPixelSize(17105053);
            }
            return Math.min(width, maximumWidth);
        }

        private void setZeroTouchableSurface() {
            this.mTouchableRegion.setEmpty();
        }

        private void setContentAreaAsTouchableSurface() {
            if (!this.mPopupWindow.isShowing()) {
                this.mContentContainer.measure(0, 0);
            }
            int width = this.mContentContainer.getMeasuredWidth();
            int height = this.mContentContainer.getMeasuredHeight();
            this.mTouchableRegion.set((int)this.mContentContainer.getX(), (int)this.mContentContainer.getY(), (int)this.mContentContainer.getX() + width, (int)this.mContentContainer.getY() + height);
        }

        private void setTouchableSurfaceInsetsComputer() {
            ViewTreeObserver viewTreeObserver = this.mPopupWindow.getContentView().getRootView().getViewTreeObserver();
            viewTreeObserver.removeOnComputeInternalInsetsListener(this.mInsetsComputer);
            viewTreeObserver.addOnComputeInternalInsetsListener(this.mInsetsComputer);
        }

        private boolean isRTL() {
            return this.mContentContainer.getLayoutDirection() == 1;
        }
    }
}

