/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManager;
import android.app.admin.DevicePolicyManager;
import android.app.trust.TrustManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.os.AsyncTask;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternView;
import com.android.internal.widget.VerifyCredentialResponse;
import com.google.android.collect.Lists;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import libcore.util.HexEncoding;

public class LockPatternUtils {
    private static final String TAG = "LockPatternUtils";
    private static final boolean DEBUG = false;
    public static final int FAILED_ATTEMPTS_BEFORE_RESET = 20;
    public static final long FAILED_ATTEMPT_COUNTDOWN_INTERVAL_MS = 1000L;
    public static final int FAILED_ATTEMPTS_BEFORE_WIPE_GRACE = 5;
    public static final int MIN_LOCK_PATTERN_SIZE = 4;
    public static final int MIN_LOCK_PASSWORD_SIZE = 4;
    public static final int MIN_PATTERN_REGISTER_FAIL = 4;
    @Deprecated
    public static final String LOCKOUT_PERMANENT_KEY = "lockscreen.lockedoutpermanently";
    public static final String LOCKOUT_ATTEMPT_DEADLINE = "lockscreen.lockoutattemptdeadline";
    public static final String LOCKOUT_ATTEMPT_TIMEOUT_MS = "lockscreen.lockoutattempttimeoutmss";
    public static final String PATTERN_EVER_CHOSEN_KEY = "lockscreen.patterneverchosen";
    public static final String PASSWORD_TYPE_KEY = "lockscreen.password_type";
    @Deprecated
    public static final String PASSWORD_TYPE_ALTERNATE_KEY = "lockscreen.password_type_alternate";
    public static final String LOCK_PASSWORD_SALT_KEY = "lockscreen.password_salt";
    public static final String DISABLE_LOCKSCREEN_KEY = "lockscreen.disabled";
    public static final String LOCKSCREEN_OPTIONS = "lockscreen.options";
    @Deprecated
    public static final String LOCKSCREEN_BIOMETRIC_WEAK_FALLBACK = "lockscreen.biometric_weak_fallback";
    @Deprecated
    public static final String BIOMETRIC_WEAK_EVER_CHOSEN_KEY = "lockscreen.biometricweakeverchosen";
    public static final String LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS = "lockscreen.power_button_instantly_locks";
    @Deprecated
    public static final String LOCKSCREEN_WIDGETS_ENABLED = "lockscreen.widgets_enabled";
    public static final String PASSWORD_HISTORY_KEY = "lockscreen.passwordhistory";
    private static final String LOCK_SCREEN_OWNER_INFO = "lock_screen_owner_info";
    private static final String LOCK_SCREEN_OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
    private static final String ENABLED_TRUST_AGENTS = "lockscreen.enabledtrustagents";
    public static final int MAX_ALLOWED_SEQUENCE = 3;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private DevicePolicyManager mDevicePolicyManager;
    private ILockSettings mLockSettingsService;

    public DevicePolicyManager getDevicePolicyManager() {
        if (this.mDevicePolicyManager == null) {
            this.mDevicePolicyManager = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
            if (this.mDevicePolicyManager == null) {
                Log.e(TAG, "Can't get DevicePolicyManagerService: is it running?", new IllegalStateException("Stack trace:"));
            }
        }
        return this.mDevicePolicyManager;
    }

    private TrustManager getTrustManager() {
        TrustManager trust = (TrustManager)this.mContext.getSystemService("trust");
        if (trust == null) {
            Log.e(TAG, "Can't get TrustManagerService: is it running?", new IllegalStateException("Stack trace:"));
        }
        return trust;
    }

    public LockPatternUtils(Context context) {
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    private ILockSettings getLockSettings() {
        if (this.mLockSettingsService == null) {
            ILockSettings service;
            this.mLockSettingsService = service = ILockSettings.Stub.asInterface(ServiceManager.getService("lock_settings"));
        }
        return this.mLockSettingsService;
    }

    public int getRequestedMinimumPasswordLength(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLength(null, userId);
    }

    public int getRequestedPasswordQuality(int userId) {
        return this.getDevicePolicyManager().getPasswordQuality(null, userId);
    }

    private int getRequestedPasswordHistoryLength(int userId) {
        return this.getDevicePolicyManager().getPasswordHistoryLength(null, userId);
    }

    public int getRequestedPasswordMinimumLetters(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLetters(null, userId);
    }

    public int getRequestedPasswordMinimumUpperCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumUpperCase(null, userId);
    }

    public int getRequestedPasswordMinimumLowerCase(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumLowerCase(null, userId);
    }

    public int getRequestedPasswordMinimumNumeric(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNumeric(null, userId);
    }

    public int getRequestedPasswordMinimumSymbols(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumSymbols(null, userId);
    }

    public int getRequestedPasswordMinimumNonLetter(int userId) {
        return this.getDevicePolicyManager().getPasswordMinimumNonLetter(null, userId);
    }

    public void reportFailedPasswordAttempt(int userId) {
        this.getDevicePolicyManager().reportFailedPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(false, userId);
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    public void reportSuccessfulPasswordAttempt(int userId) {
        this.getDevicePolicyManager().reportSuccessfulPasswordAttempt(userId);
        this.getTrustManager().reportUnlockAttempt(true, userId);
    }

    public byte[] verifyPattern(List<LockPatternView.Cell> pattern, long challenge, int userId) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyPattern(LockPatternUtils.patternToString(pattern), challenge, userId);
            if (response == null) {
                return null;
            }
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    public boolean checkPattern(List<LockPatternView.Cell> pattern, int userId) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkPattern(LockPatternUtils.patternToString(pattern), userId);
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public byte[] verifyPassword(String password, long challenge, int userId) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().verifyPassword(password, challenge, userId);
            if (response.getResponseCode() == 0) {
                return response.getPayload();
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return null;
        }
        catch (RemoteException re) {
            return null;
        }
    }

    public boolean checkPassword(String password, int userId) throws RequestThrottledException {
        try {
            VerifyCredentialResponse response = this.getLockSettings().checkPassword(password, userId);
            if (response.getResponseCode() == 0) {
                return true;
            }
            if (response.getResponseCode() == 1) {
                throw new RequestThrottledException(response.getTimeout());
            }
            return false;
        }
        catch (RemoteException re) {
            return true;
        }
    }

    public boolean checkVoldPassword(int userId) {
        try {
            return this.getLockSettings().checkVoldPassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean checkPasswordHistory(String password, int userId) {
        String passwordHashString = new String(this.passwordToHash(password, userId), StandardCharsets.UTF_8);
        String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userId);
        if (passwordHistory == null) {
            return false;
        }
        int passwordHashLength = passwordHashString.length();
        int passwordHistoryLength = this.getRequestedPasswordHistoryLength(userId);
        if (passwordHistoryLength == 0) {
            return false;
        }
        int neededPasswordHistoryLength = passwordHashLength * passwordHistoryLength + passwordHistoryLength - 1;
        if (passwordHistory.length() > neededPasswordHistoryLength) {
            passwordHistory = passwordHistory.substring(0, neededPasswordHistoryLength);
        }
        return passwordHistory.contains(passwordHashString);
    }

    private boolean savedPatternExists(int userId) {
        try {
            return this.getLockSettings().havePattern(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    private boolean savedPasswordExists(int userId) {
        try {
            return this.getLockSettings().havePassword(userId);
        }
        catch (RemoteException re) {
            return false;
        }
    }

    public boolean isPatternEverChosen(int userId) {
        return this.getBoolean(PATTERN_EVER_CHOSEN_KEY, false, userId);
    }

    public int getActivePasswordQuality(int userId) {
        int quality = this.getKeyguardStoredPasswordQuality(userId);
        if (this.isLockPasswordEnabled(quality, userId)) {
            return quality;
        }
        if (this.isLockPatternEnabled(quality, userId)) {
            return quality;
        }
        return 0;
    }

    public void clearLock(int userHandle) {
        this.setLong(PASSWORD_TYPE_KEY, 0L, userHandle);
        try {
            this.getLockSettings().setLockPassword(null, null, userHandle);
            this.getLockSettings().setLockPattern(null, null, userHandle);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (userHandle == 0) {
            this.updateEncryptionPassword(1, null);
        }
        this.setCredentialRequiredToDecrypt(false);
        this.getDevicePolicyManager().setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
        this.onAfterChangingPassword(userHandle);
    }

    public void setLockScreenDisabled(boolean disable, int userId) {
        this.setBoolean(DISABLE_LOCKSCREEN_KEY, disable, userId);
    }

    public boolean isLockScreenDisabled(int userId) {
        return !this.isSecure(userId) && this.getBoolean(DISABLE_LOCKSCREEN_KEY, false, userId);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern, int userId) {
        this.saveLockPattern(pattern, null, userId);
    }

    public void saveLockPattern(List<LockPatternView.Cell> pattern, String savedPattern, int userId) {
        try {
            if (pattern == null || pattern.size() < 4) {
                throw new IllegalArgumentException("pattern must not be null and at least 4 dots long.");
            }
            this.getLockSettings().setLockPattern(LockPatternUtils.patternToString(pattern), savedPattern, userId);
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (userId == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                if (!this.shouldEncryptWithCredentials(true)) {
                    this.clearEncryptionPassword();
                } else {
                    String stringPattern = LockPatternUtils.patternToString(pattern);
                    this.updateEncryptionPassword(2, stringPattern);
                }
            }
            this.setBoolean(PATTERN_EVER_CHOSEN_KEY, true, userId);
            this.setLong(PASSWORD_TYPE_KEY, 65536L, userId);
            dpm.setActivePasswordState(65536, pattern.size(), 0, 0, 0, 0, 0, 0, userId);
            this.onAfterChangingPassword(userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't save lock pattern " + re);
        }
    }

    private void updateCryptoUserInfo(int userId) {
        if (userId != 0) {
            return;
        }
        String ownerInfo = this.isOwnerInfoEnabled(userId) ? this.getOwnerInfo(userId) : "";
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            Log.d(TAG, "Setting owner info");
            mountService.setField("OwnerInfo", ownerInfo);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing user info", e);
        }
    }

    public void setOwnerInfo(String info, int userId) {
        this.setString(LOCK_SCREEN_OWNER_INFO, info, userId);
        this.updateCryptoUserInfo(userId);
    }

    public void setOwnerInfoEnabled(boolean enabled, int userId) {
        this.setBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, enabled, userId);
        this.updateCryptoUserInfo(userId);
    }

    public String getOwnerInfo(int userId) {
        return this.getString(LOCK_SCREEN_OWNER_INFO, userId);
    }

    public boolean isOwnerInfoEnabled(int userId) {
        return this.getBoolean(LOCK_SCREEN_OWNER_INFO_ENABLED, false, userId);
    }

    public static int computePasswordQuality(String password) {
        boolean hasDigit = false;
        boolean hasNonDigit = false;
        int len = password.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(password.charAt(i))) {
                hasDigit = true;
                continue;
            }
            hasNonDigit = true;
        }
        if (hasNonDigit && hasDigit) {
            return 327680;
        }
        if (hasNonDigit) {
            return 262144;
        }
        if (hasDigit) {
            return LockPatternUtils.maxLengthSequence(password) > 3 ? 131072 : 196608;
        }
        return 0;
    }

    private static int categoryChar(char c) {
        if ('a' <= c && c <= 'z') {
            return 0;
        }
        if ('A' <= c && c <= 'Z') {
            return 1;
        }
        if ('0' <= c && c <= '9') {
            return 2;
        }
        return 3;
    }

    private static int maxDiffCategory(int category) {
        if (category == 0 || category == 1) {
            return 1;
        }
        if (category == 2) {
            return 10;
        }
        return 0;
    }

    public static int maxLengthSequence(String string2) {
        if (string2.length() == 0) {
            return 0;
        }
        char previousChar = string2.charAt(0);
        int category = LockPatternUtils.categoryChar(previousChar);
        int diff = 0;
        boolean hasDiff = false;
        int maxLength = 0;
        int startSequence = 0;
        for (int current = 1; current < string2.length(); ++current) {
            char currentChar = string2.charAt(current);
            int categoryCurrent = LockPatternUtils.categoryChar(currentChar);
            int currentDiff = currentChar - previousChar;
            if (categoryCurrent != category || Math.abs(currentDiff) > LockPatternUtils.maxDiffCategory(category)) {
                maxLength = Math.max(maxLength, current - startSequence);
                startSequence = current;
                hasDiff = false;
                category = categoryCurrent;
            } else {
                if (hasDiff && currentDiff != diff) {
                    maxLength = Math.max(maxLength, current - startSequence);
                    startSequence = current - 1;
                }
                diff = currentDiff;
                hasDiff = true;
            }
            previousChar = currentChar;
        }
        maxLength = Math.max(maxLength, string2.length() - startSequence);
        return maxLength;
    }

    private void updateEncryptionPassword(final int type, final String password) {
        if (!LockPatternUtils.isDeviceEncryptionEnabled()) {
            return;
        }
        final IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the encryption password");
            return;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... dummy) {
                IMountService mountService = IMountService.Stub.asInterface(service);
                try {
                    mountService.changeEncryptionPassword(type, password);
                }
                catch (RemoteException e) {
                    Log.e(LockPatternUtils.TAG, "Error changing encryption password", e);
                }
                return null;
            }
        }.execute(new Void[0]);
    }

    public void saveLockPassword(String password, String savedPassword, int quality, int userHandle) {
        try {
            int passwordHistoryLength;
            DevicePolicyManager dpm = this.getDevicePolicyManager();
            if (password == null || password.length() < 4) {
                throw new IllegalArgumentException("password must not be null and at least of length 4");
            }
            this.getLockSettings().setLockPassword(password, savedPassword, userHandle);
            int computedQuality = LockPatternUtils.computePasswordQuality(password);
            if (userHandle == 0 && LockPatternUtils.isDeviceEncryptionEnabled()) {
                if (!this.shouldEncryptWithCredentials(true)) {
                    this.clearEncryptionPassword();
                } else {
                    boolean numeric = computedQuality == 131072;
                    boolean numericComplex = computedQuality == 196608;
                    int type = numeric || numericComplex ? 3 : 0;
                    this.updateEncryptionPassword(type, password);
                }
            }
            this.setLong(PASSWORD_TYPE_KEY, Math.max(quality, computedQuality), userHandle);
            if (computedQuality != 0) {
                int letters = 0;
                int uppercase = 0;
                int lowercase = 0;
                int numbers = 0;
                int symbols = 0;
                int nonletter = 0;
                for (int i = 0; i < password.length(); ++i) {
                    char c = password.charAt(i);
                    if (c >= 'A' && c <= 'Z') {
                        ++letters;
                        ++uppercase;
                        continue;
                    }
                    if (c >= 'a' && c <= 'z') {
                        ++letters;
                        ++lowercase;
                        continue;
                    }
                    if (c >= '0' && c <= '9') {
                        ++numbers;
                        ++nonletter;
                        continue;
                    }
                    ++symbols;
                    ++nonletter;
                }
                dpm.setActivePasswordState(Math.max(quality, computedQuality), password.length(), letters, uppercase, lowercase, numbers, symbols, nonletter, userHandle);
            } else {
                dpm.setActivePasswordState(0, 0, 0, 0, 0, 0, 0, 0, userHandle);
            }
            String passwordHistory = this.getString(PASSWORD_HISTORY_KEY, userHandle);
            if (passwordHistory == null) {
                passwordHistory = "";
            }
            if ((passwordHistoryLength = this.getRequestedPasswordHistoryLength(userHandle)) == 0) {
                passwordHistory = "";
            } else {
                byte[] hash = this.passwordToHash(password, userHandle);
                passwordHistory = new String(hash, StandardCharsets.UTF_8) + "," + passwordHistory;
                passwordHistory = passwordHistory.substring(0, Math.min(hash.length * passwordHistoryLength + passwordHistoryLength - 1, passwordHistory.length()));
            }
            this.setString(PASSWORD_HISTORY_KEY, passwordHistory, userHandle);
            this.onAfterChangingPassword(userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Unable to save lock password " + re);
        }
    }

    public static boolean isDeviceEncrypted() {
        IMountService mountService = IMountService.Stub.asInterface(ServiceManager.getService("mount"));
        try {
            return mountService.getEncryptionState() != 1 && mountService.getPasswordType() != 1;
        }
        catch (RemoteException re) {
            Log.e(TAG, "Error getting encryption state", re);
            return true;
        }
    }

    public static boolean isDeviceEncryptionEnabled() {
        String status = SystemProperties.get("ro.crypto.state", "unsupported");
        return "encrypted".equalsIgnoreCase(status);
    }

    public void clearEncryptionPassword() {
        this.updateEncryptionPassword(1, null);
    }

    public int getKeyguardStoredPasswordQuality(int userHandle) {
        return (int)this.getLong(PASSWORD_TYPE_KEY, 0L, userHandle);
    }

    public static List<LockPatternView.Cell> stringToPattern(String string2) {
        if (string2 == null) {
            return null;
        }
        ArrayList<LockPatternView.Cell> result = Lists.newArrayList();
        byte[] bytes = string2.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = (byte)(bytes[i] - 49);
            result.add(LockPatternView.Cell.of(b / 3, b % 3));
        }
        return result;
    }

    public static String patternToString(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn() + 49);
        }
        return new String(res);
    }

    public static String patternStringToBaseZero(String pattern) {
        if (pattern == null) {
            return "";
        }
        int patternSize = pattern.length();
        byte[] res = new byte[patternSize];
        byte[] bytes = pattern.getBytes();
        for (int i = 0; i < patternSize; ++i) {
            res[i] = (byte)(bytes[i] - 49);
        }
        return new String(res);
    }

    public static byte[] patternToHash(List<LockPatternView.Cell> pattern) {
        if (pattern == null) {
            return null;
        }
        int patternSize = pattern.size();
        byte[] res = new byte[patternSize];
        for (int i = 0; i < patternSize; ++i) {
            LockPatternView.Cell cell = pattern.get(i);
            res[i] = (byte)(cell.getRow() * 3 + cell.getColumn());
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] hash = md.digest(res);
            return hash;
        }
        catch (NoSuchAlgorithmException nsa) {
            return res;
        }
    }

    private String getSalt(int userId) {
        long salt = this.getLong(LOCK_PASSWORD_SALT_KEY, 0L, userId);
        if (salt == 0L) {
            try {
                salt = SecureRandom.getInstance("SHA1PRNG").nextLong();
                this.setLong(LOCK_PASSWORD_SALT_KEY, salt, userId);
                Log.v(TAG, "Initialized lock password salt for user: " + userId);
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalStateException("Couldn't get SecureRandom number", e);
            }
        }
        return Long.toHexString(salt);
    }

    public byte[] passwordToHash(String password, int userId) {
        if (password == null) {
            return null;
        }
        try {
            byte[] saltedPassword = (password + this.getSalt(userId)).getBytes();
            byte[] sha1 = MessageDigest.getInstance("SHA-1").digest(saltedPassword);
            byte[] md5 = MessageDigest.getInstance("MD5").digest(saltedPassword);
            byte[] combined = new byte[sha1.length + md5.length];
            System.arraycopy((byte[])sha1, (int)0, (byte[])combined, (int)0, (int)sha1.length);
            System.arraycopy((byte[])md5, (int)0, (byte[])combined, (int)sha1.length, (int)md5.length);
            char[] hexEncoded = HexEncoding.encode(combined);
            return new String(hexEncoded).getBytes(StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError("Missing digest algorithm: ", e);
        }
    }

    public boolean isSecure(int userId) {
        int mode = this.getKeyguardStoredPasswordQuality(userId);
        return this.isLockPatternEnabled(mode, userId) || this.isLockPasswordEnabled(mode, userId);
    }

    public boolean isLockPasswordEnabled(int userId) {
        return this.isLockPasswordEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    private boolean isLockPasswordEnabled(int mode, int userId) {
        boolean passwordEnabled = mode == 262144 || mode == 131072 || mode == 196608 || mode == 327680 || mode == 393216;
        return passwordEnabled && this.savedPasswordExists(userId);
    }

    public boolean isLockPatternEnabled(int userId) {
        return this.isLockPatternEnabled(this.getKeyguardStoredPasswordQuality(userId), userId);
    }

    private boolean isLockPatternEnabled(int mode, int userId) {
        return mode == 65536 && this.savedPatternExists(userId);
    }

    public boolean isVisiblePatternEnabled(int userId) {
        return this.getBoolean("lock_pattern_visible_pattern", false, userId);
    }

    public void setVisiblePatternEnabled(boolean enabled, int userId) {
        this.setBoolean("lock_pattern_visible_pattern", enabled, userId);
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PatternVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing pattern visible state", e);
        }
    }

    public void setVisiblePasswordEnabled(boolean enabled, int userId) {
        if (userId != 0) {
            return;
        }
        IBinder service = ServiceManager.getService("mount");
        if (service == null) {
            Log.e(TAG, "Could not find the mount service to update the user info");
            return;
        }
        IMountService mountService = IMountService.Stub.asInterface(service);
        try {
            mountService.setField("PasswordVisible", enabled ? "1" : "0");
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error changing password visible state", e);
        }
    }

    public boolean isTactileFeedbackEnabled() {
        return Settings.System.getIntForUser(this.mContentResolver, "haptic_feedback_enabled", 1, -2) != 0;
    }

    public long setLockoutAttemptDeadline(int userId, int timeoutMs) {
        long deadline = SystemClock.elapsedRealtime() + (long)timeoutMs;
        this.setLong(LOCKOUT_ATTEMPT_DEADLINE, deadline, userId);
        this.setLong(LOCKOUT_ATTEMPT_TIMEOUT_MS, timeoutMs, userId);
        return deadline;
    }

    public long getLockoutAttemptDeadline(int userId) {
        long deadline = this.getLong(LOCKOUT_ATTEMPT_DEADLINE, 0L, userId);
        long timeoutMs = this.getLong(LOCKOUT_ATTEMPT_TIMEOUT_MS, 0L, userId);
        long now = SystemClock.elapsedRealtime();
        if (deadline < now || deadline > now + timeoutMs) {
            return 0L;
        }
        return deadline;
    }

    private boolean getBoolean(String secureSettingKey, boolean defaultValue, int userId) {
        try {
            return this.getLockSettings().getBoolean(secureSettingKey, defaultValue, userId);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setBoolean(String secureSettingKey, boolean enabled, int userId) {
        try {
            this.getLockSettings().setBoolean(secureSettingKey, enabled, userId);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write boolean " + secureSettingKey + re);
        }
    }

    private long getLong(String secureSettingKey, long defaultValue, int userHandle) {
        try {
            return this.getLockSettings().getLong(secureSettingKey, defaultValue, userHandle);
        }
        catch (RemoteException re) {
            return defaultValue;
        }
    }

    private void setLong(String secureSettingKey, long value, int userHandle) {
        try {
            this.getLockSettings().setLong(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write long " + secureSettingKey + re);
        }
    }

    private String getString(String secureSettingKey, int userHandle) {
        try {
            return this.getLockSettings().getString(secureSettingKey, null, userHandle);
        }
        catch (RemoteException re) {
            return null;
        }
    }

    private void setString(String secureSettingKey, String value, int userHandle) {
        try {
            this.getLockSettings().setString(secureSettingKey, value, userHandle);
        }
        catch (RemoteException re) {
            Log.e(TAG, "Couldn't write string " + secureSettingKey + re);
        }
    }

    public void setPowerButtonInstantlyLocks(boolean enabled, int userId) {
        this.setBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, enabled, userId);
    }

    public boolean getPowerButtonInstantlyLocks(int userId) {
        return this.getBoolean(LOCKSCREEN_POWER_BUTTON_INSTANTLY_LOCKS, true, userId);
    }

    public void setEnabledTrustAgents(Collection<ComponentName> activeTrustAgents, int userId) {
        StringBuilder sb = new StringBuilder();
        for (ComponentName cn : activeTrustAgents) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(cn.flattenToShortString());
        }
        this.setString(ENABLED_TRUST_AGENTS, sb.toString(), userId);
        this.getTrustManager().reportEnabledTrustAgentsChanged(userId);
    }

    public List<ComponentName> getEnabledTrustAgents(int userId) {
        String serialized = this.getString(ENABLED_TRUST_AGENTS, userId);
        if (TextUtils.isEmpty(serialized)) {
            return null;
        }
        String[] split = serialized.split(",");
        ArrayList<ComponentName> activeTrustAgents = new ArrayList<ComponentName>(split.length);
        for (String s : split) {
            if (TextUtils.isEmpty(s)) continue;
            activeTrustAgents.add(ComponentName.unflattenFromString(s));
        }
        return activeTrustAgents;
    }

    public void requireCredentialEntry(int userId) {
        this.getTrustManager().reportRequireCredentialEntry(userId);
    }

    private void onAfterChangingPassword(int userHandle) {
        this.getTrustManager().reportEnabledTrustAgentsChanged(userHandle);
    }

    public boolean isCredentialRequiredToDecrypt(boolean defaultValue) {
        int value = Settings.Global.getInt(this.mContentResolver, "require_password_to_decrypt", -1);
        return value == -1 ? defaultValue : value != 0;
    }

    public void setCredentialRequiredToDecrypt(boolean required) {
        if (ActivityManager.getCurrentUser() != 0) {
            Log.w(TAG, "Only device owner may call setCredentialRequiredForDecrypt()");
            return;
        }
        if (LockPatternUtils.isDeviceEncryptionEnabled()) {
            Settings.Global.putInt(this.mContext.getContentResolver(), "require_password_to_decrypt", required ? 1 : 0);
        }
    }

    private boolean isDoNotAskCredentialsOnBootSet() {
        return this.mDevicePolicyManager.getDoNotAskCredentialsOnBoot();
    }

    private boolean shouldEncryptWithCredentials(boolean defaultValue) {
        return this.isCredentialRequiredToDecrypt(defaultValue) && !this.isDoNotAskCredentialsOnBootSet();
    }

    public static final class RequestThrottledException
    extends Exception {
        private int mTimeoutMs;

        public RequestThrottledException(int timeoutMs) {
            this.mTimeoutMs = timeoutMs;
        }

        public int getTimeoutMs() {
            return this.mTimeoutMs;
        }
    }
}

