/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.MediaType;
import com.android.okhttp.RequestBody;
import com.android.okhttp.okio.Buffer;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class FormEncodingBuilder {
    private static final MediaType CONTENT_TYPE = MediaType.parse("application/x-www-form-urlencoded");
    private final Buffer content = new Buffer();

    public FormEncodingBuilder add(String name, String value) {
        if (this.content.size() > 0L) {
            this.content.writeByte(38);
        }
        try {
            this.content.writeUtf8(URLEncoder.encode(name, "UTF-8"));
            this.content.writeByte(61);
            this.content.writeUtf8(URLEncoder.encode(value, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
        return this;
    }

    public RequestBody build() {
        if (this.content.size() == 0L) {
            throw new IllegalStateException("Form encoded body must have at least one part.");
        }
        return RequestBody.create(CONTENT_TYPE, this.content.snapshot());
    }
}

