/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.AndroidInternal;
import com.android.okhttp.ConfigAwareConnectionPool;
import com.android.okhttp.ConnectionSpec;
import com.android.okhttp.OkHttpClient;
import com.android.okhttp.OkUrlFactory;
import java.io.IOException;
import java.net.Proxy;
import java.net.ResponseCache;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Collections;
import java.util.List;
import libcore.net.NetworkSecurityPolicy;

public class HttpHandler
extends URLStreamHandler {
    private static final List<ConnectionSpec> CLEARTEXT_ONLY = Collections.singletonList(ConnectionSpec.CLEARTEXT);
    private final ConfigAwareConnectionPool configAwareConnectionPool = ConfigAwareConnectionPool.getInstance();

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        return this.newOkUrlFactory(null).open(url);
    }

    @Override
    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        if (url == null || proxy == null) {
            throw new IllegalArgumentException("url == null || proxy == null");
        }
        return this.newOkUrlFactory(proxy).open(url);
    }

    @Override
    protected int getDefaultPort() {
        return 80;
    }

    protected OkUrlFactory newOkUrlFactory(Proxy proxy) {
        OkUrlFactory okUrlFactory = HttpHandler.createHttpOkUrlFactory(proxy);
        okUrlFactory.client().setConnectionPool(this.configAwareConnectionPool.get());
        return okUrlFactory;
    }

    public static OkUrlFactory createHttpOkUrlFactory(Proxy proxy) {
        OkHttpClient client = new OkHttpClient();
        client.setFollowSslRedirects(false);
        if (NetworkSecurityPolicy.isCleartextTrafficPermitted()) {
            client.setConnectionSpecs(CLEARTEXT_ONLY);
        } else {
            client.setConnectionSpecs(Collections.emptyList());
        }
        if (proxy != null) {
            client.setProxy(proxy);
        }
        OkUrlFactory okUrlFactory = new OkUrlFactory(client);
        ResponseCache responseCache = ResponseCache.getDefault();
        if (responseCache != null) {
            AndroidInternal.setResponseCache(okUrlFactory, responseCache);
        }
        return okUrlFactory;
    }
}

