/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.internal.Util;
import com.android.okhttp.okio.Buffer;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public final class HttpUrl {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final String scheme;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String path;
    private final String query;
    private final String fragment;
    private final String url;

    private HttpUrl(String scheme, String username, String password, String host, int port, String path, String query, String fragment, String url) {
        this.scheme = scheme;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port;
        this.path = path;
        this.query = query;
        this.fragment = fragment;
        this.url = url;
    }

    public URL url() {
        throw new UnsupportedOperationException();
    }

    public URI uri() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String scheme() {
        return this.scheme;
    }

    public boolean isHttps() {
        return this.scheme.equals("https");
    }

    public String username() {
        return this.username;
    }

    public String decodeUsername() {
        return HttpUrl.decode(this.username, 0, this.username.length());
    }

    public String password() {
        return this.password;
    }

    public String decodePassword() {
        return this.password != null ? HttpUrl.decode(this.password, 0, this.password.length()) : null;
    }

    public String host() {
        return this.host;
    }

    public String decodeHost() {
        throw new UnsupportedOperationException();
    }

    public int port() {
        return this.port;
    }

    public static int defaultPort(String scheme) {
        if (scheme.equals("http")) {
            return 80;
        }
        if (scheme.equals("https")) {
            return 443;
        }
        return -1;
    }

    public String path() {
        return this.path;
    }

    public List<String> decodePathSegments() {
        int segmentStart;
        ArrayList<String> result = new ArrayList<String>();
        for (int i = segmentStart = 1; i < this.path.length(); ++i) {
            if (this.path.charAt(i) != '/') continue;
            result.add(HttpUrl.decode(this.path, segmentStart, i));
            segmentStart = i + 1;
        }
        result.add(HttpUrl.decode(this.path, segmentStart, this.path.length()));
        return Util.immutableList(result);
    }

    public String query() {
        return this.query;
    }

    public String queryParameter(String name) {
        throw new UnsupportedOperationException();
    }

    public Set<String> queryParameterNames() {
        throw new UnsupportedOperationException();
    }

    public List<String> queryParameterValues(String name) {
        throw new UnsupportedOperationException();
    }

    public String queryParameterName(int index) {
        throw new UnsupportedOperationException();
    }

    public String queryParameterValue(int index) {
        throw new UnsupportedOperationException();
    }

    public String fragment() {
        return this.fragment;
    }

    public HttpUrl resolve(String link) {
        return new Builder().parse(this, link);
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public static HttpUrl parse(String url) {
        return new Builder().parse(null, url);
    }

    public static HttpUrl get(URL url) {
        return HttpUrl.parse(url.toString());
    }

    public static HttpUrl get(URI uri) {
        return HttpUrl.parse(uri.toString());
    }

    public boolean equals(Object o) {
        return o instanceof HttpUrl && ((HttpUrl)o).url.equals(this.url);
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public String toString() {
        return this.url;
    }

    private static String decode(String encoded, int pos, int limit) {
        for (int i = pos; i < limit; ++i) {
            if (encoded.charAt(i) != '%') continue;
            Buffer out = new Buffer();
            out.writeUtf8(encoded, pos, i);
            return HttpUrl.decode(out, encoded, i, limit);
        }
        return encoded.substring(pos, limit);
    }

    private static String decode(Buffer out, String encoded, int pos, int limit) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = encoded.codePointAt(i);
            if (codePoint == 37 && i + 2 < limit) {
                int d1 = HttpUrl.decodeHexDigit(encoded.charAt(i + 1));
                int d2 = HttpUrl.decodeHexDigit(encoded.charAt(i + 2));
                if (d1 != -1 && d2 != -1) {
                    out.writeByte((d1 << 4) + d2);
                    i += 2;
                    continue;
                }
            }
            out.writeUtf8CodePoint(codePoint);
        }
        return out.readUtf8();
    }

    private static int decodeHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    static String encode(String input, int pos, int limit, String encodeSet) {
        int codePoint;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint >= 32 && codePoint < 127 && encodeSet.indexOf(codePoint) == -1) continue;
            StringBuilder out = new StringBuilder();
            out.append(input, pos, i);
            HttpUrl.encode(out, input, i, limit, encodeSet);
            return out.toString();
        }
        return input.substring(pos, limit);
    }

    static void encode(StringBuilder out, String input, int pos, int limit, String encodeSet) {
        int codePoint;
        Buffer utf8Buffer = null;
        for (int i = pos; i < limit; i += Character.charCount(codePoint)) {
            codePoint = input.codePointAt(i);
            if (codePoint == 9 || codePoint == 10 || codePoint == 12 || codePoint == 13) continue;
            if (codePoint < 32 || codePoint >= 127 || encodeSet.indexOf(codePoint) != -1) {
                if (utf8Buffer == null) {
                    utf8Buffer = new Buffer();
                }
                utf8Buffer.writeUtf8CodePoint(codePoint);
                while (!utf8Buffer.exhausted()) {
                    int b = utf8Buffer.readByte() & 0xFF;
                    out.append('%');
                    out.append(HEX_DIGITS[b >> 4 & 0xF]);
                    out.append(HEX_DIGITS[b & 0xF]);
                }
                continue;
            }
            out.append((char)codePoint);
        }
    }

    public static final class Builder {
        String scheme;
        String username = "";
        String password;
        String host;
        int port = -1;
        StringBuilder pathBuilder = new StringBuilder();
        String query;
        String fragment;

        public Builder() {
        }

        private Builder(HttpUrl url) {
            throw new UnsupportedOperationException();
        }

        public Builder scheme(String scheme) {
            throw new UnsupportedOperationException();
        }

        public Builder user(String user) {
            throw new UnsupportedOperationException();
        }

        public Builder encodedUser(String encodedUser) {
            throw new UnsupportedOperationException();
        }

        public Builder password(String password) {
            throw new UnsupportedOperationException();
        }

        public Builder encodedPassword(String encodedPassword) {
            throw new UnsupportedOperationException();
        }

        public Builder host(String host) {
            throw new UnsupportedOperationException();
        }

        public Builder port(int port) {
            throw new UnsupportedOperationException();
        }

        public Builder addPathSegment(String pathSegment) {
            if (pathSegment == null) {
                throw new IllegalArgumentException("pathSegment == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder addEncodedPathSegment(String encodedPathSegment) {
            if (encodedPathSegment == null) {
                throw new IllegalArgumentException("encodedPathSegment == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder encodedPath(String encodedPath) {
            throw new UnsupportedOperationException();
        }

        public Builder encodedQuery(String encodedQuery) {
            throw new UnsupportedOperationException();
        }

        public Builder addQueryParameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder addEncodedQueryParameter(String encodedName, String encodedValue) {
            if (encodedName == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (encodedValue == null) {
                throw new IllegalArgumentException("encodedValue == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder setQueryParameter(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            if (value == null) {
                throw new IllegalArgumentException("value == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder setEncodedQueryParameter(String encodedName, String encodedValue) {
            if (encodedName == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            if (encodedValue == null) {
                throw new IllegalArgumentException("encodedValue == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder removeAllQueryParameters(String name) {
            if (name == null) {
                throw new IllegalArgumentException("name == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder removeAllEncodedQueryParameters(String encodedName) {
            if (encodedName == null) {
                throw new IllegalArgumentException("encodedName == null");
            }
            throw new UnsupportedOperationException();
        }

        public Builder fragment(String fragment) {
            throw new UnsupportedOperationException();
        }

        public HttpUrl build() {
            int effectivePort;
            String effectivePassword;
            StringBuilder url = new StringBuilder();
            url.append(this.scheme);
            url.append("://");
            String string2 = effectivePassword = this.password != null && !this.password.isEmpty() ? this.password : null;
            if (!this.username.isEmpty() || effectivePassword != null) {
                url.append(this.username);
                if (effectivePassword != null) {
                    url.append(':');
                    url.append(effectivePassword);
                }
                url.append('@');
            }
            if (this.host.indexOf(58) != -1) {
                url.append('[');
                url.append(this.host);
                url.append(']');
            } else {
                url.append(this.host);
            }
            int defaultPort = HttpUrl.defaultPort(this.scheme);
            int n = effectivePort = this.port != -1 ? this.port : defaultPort;
            if (effectivePort != defaultPort) {
                url.append(':');
                url.append(this.port);
            }
            String effectivePath = this.pathBuilder.length() > 0 ? this.pathBuilder.toString() : "/";
            url.append(effectivePath);
            if (this.query != null) {
                url.append('?');
                url.append(this.query);
            }
            if (this.fragment != null) {
                url.append('#');
                url.append(this.fragment);
            }
            return new HttpUrl(this.scheme, this.username, effectivePassword, this.host, effectivePort, effectivePath, this.query, this.fragment, url.toString());
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        HttpUrl parse(HttpUrl base, String input) {
            int limit;
            int pos;
            block29: {
                pos = this.skipLeadingAsciiWhitespace(input, 0, input.length());
                int schemeDelimiterOffset = Builder.schemeDelimiterOffset(input, pos, limit = this.skipTrailingAsciiWhitespace(input, pos, input.length()));
                if (schemeDelimiterOffset != -1) {
                    if (input.regionMatches(true, pos, "https:", 0, 6)) {
                        this.scheme = "https";
                        pos += "https:".length();
                    } else {
                        if (!input.regionMatches(true, pos, "http:", 0, 5)) return null;
                        this.scheme = "http";
                        pos += "http:".length();
                    }
                } else {
                    if (base == null) return null;
                    this.scheme = base.scheme;
                }
                boolean hasUsername = false;
                int slashCount = Builder.slashCount(input, pos, limit);
                if (slashCount >= 2 || base == null || !base.scheme.equals(this.scheme)) {
                    pos += slashCount;
                    while (true) {
                        int componentDelimiterOffset;
                        int c = (componentDelimiterOffset = Builder.delimiterOffset(input, pos, limit, "@/\\?#")) != limit ? (int)input.charAt(componentDelimiterOffset) : -1;
                        switch (c) {
                            case 64: {
                                if (this.password == null) {
                                    int passwordColonOffset = Builder.delimiterOffset(input, pos, componentDelimiterOffset, ":");
                                    String string2 = this.username = hasUsername ? this.username + "%40" + this.username(input, pos, passwordColonOffset) : this.username(input, pos, passwordColonOffset);
                                    if (passwordColonOffset != componentDelimiterOffset) {
                                        this.password = this.password(input, passwordColonOffset + 1, componentDelimiterOffset);
                                    }
                                    hasUsername = true;
                                } else {
                                    this.password = this.password + "%40" + this.password(input, pos, componentDelimiterOffset);
                                }
                                pos = componentDelimiterOffset + 1;
                                break;
                            }
                            case -1: 
                            case 35: 
                            case 47: 
                            case 63: 
                            case 92: {
                                int portColonOffset = Builder.portColonOffset(input, pos, componentDelimiterOffset);
                                if (portColonOffset + 1 < componentDelimiterOffset) {
                                    this.host = Builder.host(input, pos, portColonOffset);
                                    this.port = this.port(input, portColonOffset + 1, componentDelimiterOffset);
                                    if (this.port == -1) {
                                        return null;
                                    }
                                } else {
                                    this.host = Builder.host(input, pos, portColonOffset);
                                    this.port = HttpUrl.defaultPort(this.scheme);
                                }
                                if (this.host == null) {
                                    return null;
                                }
                                pos = componentDelimiterOffset;
                                break block29;
                            }
                        }
                    }
                }
                this.username = base.username;
                this.password = base.password;
                this.host = base.host;
                this.port = base.port;
                int c = pos != limit ? (int)input.charAt(pos) : -1;
                switch (c) {
                    case -1: 
                    case 35: {
                        this.pathBuilder.append(base.path);
                        this.query = base.query;
                        break;
                    }
                    case 63: {
                        this.pathBuilder.append(base.path);
                        break;
                    }
                    case 47: 
                    case 92: {
                        break;
                    }
                    default: {
                        this.pathBuilder.append(base.path);
                        this.pathBuilder.append('/');
                        this.pop();
                    }
                }
            }
            int pathDelimiterOffset = Builder.delimiterOffset(input, pos, limit, "?#");
            while (pos < pathDelimiterOffset) {
                int pathSegmentDelimiterOffset = Builder.delimiterOffset(input, pos, pathDelimiterOffset, "/\\");
                int segmentLength = pathSegmentDelimiterOffset - pos;
                if (segmentLength == 2 && input.regionMatches(false, pos, "..", 0, 2) || segmentLength == 4 && input.regionMatches(true, pos, "%2e.", 0, 4) || segmentLength == 4 && input.regionMatches(true, pos, ".%2e", 0, 4) || segmentLength == 6 && input.regionMatches(true, pos, "%2e%2e", 0, 6)) {
                    this.pop();
                } else if (!(segmentLength == 1 && input.regionMatches(false, pos, ".", 0, 1) || segmentLength == 3 && input.regionMatches(true, pos, "%2e", 0, 3))) {
                    if (pathSegmentDelimiterOffset < pathDelimiterOffset) {
                        this.pathSegment(input, pos, pathSegmentDelimiterOffset);
                        this.pathBuilder.append('/');
                    } else {
                        this.pathSegment(input, pos, pathSegmentDelimiterOffset);
                    }
                }
                pos = pathSegmentDelimiterOffset;
                if (pathSegmentDelimiterOffset >= pathDelimiterOffset) continue;
                ++pos;
            }
            if (pos < limit && input.charAt(pos) == '?') {
                int queryDelimiterOffset = Builder.delimiterOffset(input, pos, limit, "#");
                this.query = this.query(input, pos + 1, queryDelimiterOffset);
                pos = queryDelimiterOffset;
            }
            if (pos >= limit || input.charAt(pos) != '#') return this.build();
            this.fragment = this.fragment(input, pos + 1, limit);
            return this.build();
        }

        private void pop() {
            if (this.pathBuilder.charAt(this.pathBuilder.length() - 1) != '/') {
                throw new IllegalStateException();
            }
            for (int i = this.pathBuilder.length() - 2; i >= 0; --i) {
                if (this.pathBuilder.charAt(i) != '/') continue;
                this.pathBuilder.delete(i + 1, this.pathBuilder.length());
                return;
            }
        }

        private int skipLeadingAsciiWhitespace(String input, int pos, int limit) {
            block3: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return i;
                    }
                }
            }
            return limit;
        }

        private int skipTrailingAsciiWhitespace(String input, int pos, int limit) {
            block3: for (int i = limit - 1; i >= pos; --i) {
                switch (input.charAt(i)) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        continue block3;
                    }
                    default: {
                        return i + 1;
                    }
                }
            }
            return pos;
        }

        private static int schemeDelimiterOffset(String input, int pos, int limit) {
            if (limit - pos < 2) {
                return -1;
            }
            char c0 = input.charAt(pos);
            if (!(c0 >= 'a' && c0 <= 'z' || c0 >= 'A' && c0 <= 'Z')) {
                return -1;
            }
            for (int i = pos + 1; i < limit; ++i) {
                char c = input.charAt(i);
                if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '+' || c == '-' || c == '.') continue;
                if (c == ':') {
                    return i;
                }
                return -1;
            }
            return -1;
        }

        private static int slashCount(String input, int pos, int limit) {
            char c;
            int slashCount = 0;
            while (pos < limit && ((c = input.charAt(pos)) == '\\' || c == '/')) {
                ++slashCount;
                ++pos;
            }
            return slashCount;
        }

        private static int delimiterOffset(String input, int pos, int limit, String delimiters) {
            for (int i = pos; i < limit; ++i) {
                if (delimiters.indexOf(input.charAt(i)) == -1) continue;
                return i;
            }
            return limit;
        }

        private static int portColonOffset(String input, int pos, int limit) {
            block4: for (int i = pos; i < limit; ++i) {
                switch (input.charAt(i)) {
                    case '[': {
                        while (++i < limit && input.charAt(i) != ']') {
                        }
                        continue block4;
                    }
                    case ':': {
                        return i;
                    }
                }
            }
            return limit;
        }

        private String username(String input, int pos, int limit) {
            return HttpUrl.encode(input, pos, limit, " \"';<=>@[]^`{}|");
        }

        private String password(String input, int pos, int limit) {
            return HttpUrl.encode(input, pos, limit, " \"':;<=>@[]\\^`{}|");
        }

        private static String host(String input, int pos, int limit) {
            int length;
            String percentDecoded = HttpUrl.decode(input, pos, limit);
            if (percentDecoded.startsWith("[") && percentDecoded.endsWith("]")) {
                return Builder.decodeIpv6(percentDecoded, 1, percentDecoded.length() - 1);
            }
            String idnDecoded = Builder.domainToAscii(percentDecoded);
            if (Builder.delimiterOffset(idnDecoded, 0, length = idnDecoded.length(), "\u0000\t\n\r #%/:?@[\\]") != length) {
                return null;
            }
            return idnDecoded;
        }

        private static String decodeIpv6(String input, int pos, int limit) {
            return input.substring(pos, limit);
        }

        private static String domainToAscii(String input) {
            return input;
        }

        private int port(String input, int pos, int limit) {
            try {
                String portString = HttpUrl.encode(input, pos, limit, "");
                int i = Integer.parseInt(portString);
                if (i > 0 && i <= 65535) {
                    return i;
                }
                return -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        private void pathSegment(String input, int pos, int limit) {
            HttpUrl.encode(this.pathBuilder, input, pos, limit, " \"<>^`{}|");
        }

        private String query(String input, int pos, int limit) {
            return HttpUrl.encode(input, pos, limit, " \"'<>");
        }

        private String fragment(String input, int pos, int limit) {
            return HttpUrl.encode(input, pos, limit, "");
        }
    }
}

