/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp.internal.http;

import com.android.okhttp.Protocol;
import com.android.okhttp.Request;
import java.net.Proxy;
import java.net.URL;

public final class RequestLine {
    private RequestLine() {
    }

    static String get(Request request, Proxy.Type proxyType, Protocol protocol) {
        StringBuilder result = new StringBuilder();
        result.append(request.method());
        result.append(' ');
        if (RequestLine.includeAuthorityInRequestLine(request, proxyType)) {
            result.append(request.url());
        } else {
            result.append(RequestLine.requestPath(request.url()));
        }
        result.append(' ');
        result.append(RequestLine.version(protocol));
        return result.toString();
    }

    private static boolean includeAuthorityInRequestLine(Request request, Proxy.Type proxyType) {
        return !request.isHttps() && proxyType == Proxy.Type.HTTP;
    }

    public static String requestPath(URL url) {
        String pathAndQuery = url.getFile();
        if (pathAndQuery == null) {
            return "/";
        }
        if (!pathAndQuery.startsWith("/")) {
            return "/" + pathAndQuery;
        }
        return pathAndQuery;
    }

    public static String version(Protocol protocol) {
        return protocol == Protocol.HTTP_1_0 ? "HTTP/1.0" : "HTTP/1.1";
    }
}

