/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.SSLClientSessionCache;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;

public class ClientSessionContext
extends AbstractSessionContext {
    final Map<HostAndPort, SSLSession> sessionsByHostAndPort = new HashMap<HostAndPort, SSLSession>();
    private SSLClientSessionCache persistentCache;

    public ClientSessionContext() {
        super(10);
    }

    public int size() {
        return this.sessionsByHostAndPort.size();
    }

    public void setPersistentCache(SSLClientSessionCache persistentCache) {
        this.persistentCache = persistentCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sessionRemoved(SSLSession session) {
        String host = session.getPeerHost();
        int port = session.getPeerPort();
        if (host == null) {
            return;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map<HostAndPort, SSLSession> map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.remove(hostAndPortKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSession getSession(String host, int port) {
        byte[] data;
        SSLSession session;
        if (host == null) {
            return null;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map<HostAndPort, SSLSession> map = this.sessionsByHostAndPort;
        synchronized (map) {
            session = this.sessionsByHostAndPort.get(hostAndPortKey);
        }
        if (session != null && session.isValid()) {
            return session;
        }
        if (this.persistentCache != null && (data = this.persistentCache.getSessionData(host, port)) != null && (session = this.toSession(data, host, port)) != null && session.isValid()) {
            super.putSession(session);
            Map<HostAndPort, SSLSession> map2 = this.sessionsByHostAndPort;
            synchronized (map2) {
                this.sessionsByHostAndPort.put(hostAndPortKey, session);
            }
            return session;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putSession(SSLSession session) {
        byte[] data;
        super.putSession(session);
        String host = session.getPeerHost();
        int port = session.getPeerPort();
        if (host == null) {
            return;
        }
        HostAndPort hostAndPortKey = new HostAndPort(host, port);
        Map<HostAndPort, SSLSession> map = this.sessionsByHostAndPort;
        synchronized (map) {
            this.sessionsByHostAndPort.put(hostAndPortKey, session);
        }
        if (this.persistentCache != null && (data = this.toBytes(session)) != null) {
            this.persistentCache.putSessionData(session, data);
        }
    }

    static class HostAndPort {
        final String host;
        final int port;

        HostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public int hashCode() {
            return this.host.hashCode() * 31 + this.port;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostAndPort)) {
                return false;
            }
            HostAndPort lhs = (HostAndPort)o;
            return this.host.equals(lhs.host) && this.port == lhs.port;
        }
    }
}

