/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractSessionContext;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLBIOSink;
import com.android.org.conscrypt.OpenSSLBIOSource;
import com.android.org.conscrypt.OpenSSLKey;
import com.android.org.conscrypt.OpenSSLSessionImpl;
import com.android.org.conscrypt.OpenSSLX509Certificate;
import com.android.org.conscrypt.PSKKeyManager;
import com.android.org.conscrypt.Platform;
import com.android.org.conscrypt.SSLNullSession;
import com.android.org.conscrypt.SSLParametersImpl;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;

public class OpenSSLEngineImpl
extends SSLEngine
implements NativeCrypto.SSLHandshakeCallbacks,
SSLParametersImpl.AliasChooser,
SSLParametersImpl.PSKCallbacks {
    private final SSLParametersImpl sslParameters;
    private final Object stateLock = new Object();
    private EngineState engineState = EngineState.NEW;
    private long sslNativePointer;
    private static OpenSSLBIOSource nullSource = OpenSSLBIOSource.wrap(ByteBuffer.allocate(0));
    private OpenSSLBIOSink handshakeSink;
    private final OpenSSLBIOSink localToRemoteSink = OpenSSLBIOSink.create();
    private OpenSSLSessionImpl sslSession;
    private OpenSSLSessionImpl handshakeSession;
    OpenSSLKey channelIdPrivateKey;

    public OpenSSLEngineImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
    }

    public OpenSSLEngineImpl(String host, int port, SSLParametersImpl sslParameters) {
        super(host, port);
        this.sslParameters = sslParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginHandshake() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND || this.engineState == EngineState.CLOSED_INBOUND) {
                throw new IllegalStateException("Engine has already been closed");
            }
            if (this.engineState == EngineState.HANDSHAKE_STARTED) {
                throw new IllegalStateException("Handshake has already been started");
            }
            if (this.engineState != EngineState.MODE_SET) {
                throw new IllegalStateException("Client/server mode must be set before handshake");
            }
            this.engineState = this.getUseClientMode() ? EngineState.HANDSHAKE_WANTED : EngineState.HANDSHAKE_STARTED;
        }
        boolean releaseResources = true;
        try {
            AbstractSessionContext sessionContext = this.sslParameters.getSessionContext();
            long sslCtxNativePointer = sessionContext.sslCtxNativePointer;
            this.sslNativePointer = NativeCrypto.SSL_new(sslCtxNativePointer);
            this.sslSession = this.sslParameters.getSessionToReuse(this.sslNativePointer, this.getPeerHost(), this.getPeerPort());
            this.sslParameters.setSSLParameters(sslCtxNativePointer, this.sslNativePointer, this, this, this.getPeerHost());
            this.sslParameters.setCertificateValidation(this.sslNativePointer);
            this.sslParameters.setTlsChannelId(this.sslNativePointer, this.channelIdPrivateKey);
            if (this.getUseClientMode()) {
                NativeCrypto.SSL_set_connect_state(this.sslNativePointer);
            } else {
                NativeCrypto.SSL_set_accept_state(this.sslNativePointer);
            }
            this.handshakeSink = OpenSSLBIOSink.create();
            releaseResources = false;
        }
        catch (IOException e) {
            String message = e.getMessage();
            if (message.contains("unexpected CCS")) {
                String logMessage = String.format("ssl_unexpected_ccs: host=%s", this.getPeerHost());
                Platform.logEvent(logMessage);
            }
            throw new SSLException(e);
        }
        finally {
            if (releaseResources) {
                Object object2 = this.stateLock;
                synchronized (object2) {
                    this.engineState = EngineState.CLOSED;
                }
                this.shutdownAndFreeSslNative();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeInbound() throws SSLException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED) {
                return;
            }
            this.engineState = this.engineState == EngineState.CLOSED_OUTBOUND ? EngineState.CLOSED : EngineState.CLOSED_INBOUND;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeOutbound() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND) {
                return;
            }
            if (this.engineState != EngineState.MODE_SET && this.engineState != EngineState.NEW) {
                this.shutdownAndFreeSslNative();
            }
            this.engineState = this.engineState == EngineState.CLOSED_INBOUND ? EngineState.CLOSED : EngineState.CLOSED_OUTBOUND;
        }
        this.shutdown();
    }

    @Override
    public Runnable getDelegatedTask() {
        return null;
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslParameters.getEnabledProtocols();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslParameters.getEnableSessionCreation();
    }

    @Override
    public SSLEngineResult.HandshakeStatus getHandshakeStatus() {
        Object object = this.stateLock;
        synchronized (object) {
            switch (this.engineState) {
                case HANDSHAKE_WANTED: {
                    if (this.getUseClientMode()) {
                        return SSLEngineResult.HandshakeStatus.NEED_WRAP;
                    }
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                case HANDSHAKE_STARTED: {
                    if (this.handshakeSink.available() > 0) {
                        return SSLEngineResult.HandshakeStatus.NEED_WRAP;
                    }
                    return SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
                }
                case HANDSHAKE_COMPLETED: {
                    if (this.handshakeSink.available() == 0) {
                        this.handshakeSink = null;
                        this.engineState = EngineState.READY;
                        return SSLEngineResult.HandshakeStatus.FINISHED;
                    }
                    return SSLEngineResult.HandshakeStatus.NEED_WRAP;
                }
                case NEW: 
                case MODE_SET: 
                case CLOSED: 
                case CLOSED_INBOUND: 
                case CLOSED_OUTBOUND: 
                case READY: 
                case READY_HANDSHAKE_CUT_THROUGH: {
                    return SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING;
                }
            }
            throw new IllegalStateException("Unexpected engine state: " + (Object)((Object)this.engineState));
        }
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public SSLSession getSession() {
        if (this.sslSession == null) {
            return SSLNullSession.getNullSession();
        }
        return this.sslSession;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public String[] getSupportedProtocols() {
        return NativeCrypto.getSupportedProtocols();
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslParameters.getUseClientMode();
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_INBOUND;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 2) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOutboundDone() {
        if (this.sslNativePointer == 0L) {
            Object object = this.stateLock;
            synchronized (object) {
                return this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND;
            }
        }
        return (NativeCrypto.SSL_get_shutdown(this.sslNativePointer) & 1) != 0;
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setEnabledCipherSuites(suites);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setEnabledProtocols(protocols);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        this.sslParameters.setEnableSessionCreation(flag);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUseClientMode(boolean mode) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState != EngineState.MODE_SET && this.engineState != EngineState.NEW) {
                throw new IllegalArgumentException("Can not change mode after handshake: engineState == " + (Object)((Object)this.engineState));
            }
            this.engineState = EngineState.MODE_SET;
        }
        this.sslParameters.setUseClientMode(mode);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    private static void checkIndex(int length, int offset, int count) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException("offset < 0");
        }
        if (count < 0) {
            throw new IndexOutOfBoundsException("count < 0");
        }
        if (offset > length) {
            throw new IndexOutOfBoundsException("offset > length");
        }
        if (offset > length - count) {
            throw new IndexOutOfBoundsException("offset + count > length");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult unwrap(ByteBuffer src, ByteBuffer[] dsts, int offset, int length) throws SSLException {
        if (src == null) {
            throw new IllegalArgumentException("src == null");
        }
        if (dsts == null) {
            throw new IllegalArgumentException("dsts == null");
        }
        OpenSSLEngineImpl.checkIndex(dsts.length, offset, length);
        int dstRemaining = 0;
        for (int i = 0; i < dsts.length; ++i) {
            ByteBuffer dst = dsts[i];
            if (dst == null) {
                throw new IllegalArgumentException("one of the dst == null");
            }
            if (dst.isReadOnly()) {
                throw new ReadOnlyBufferException();
            }
            if (i < offset || i >= offset + length) continue;
            dstRemaining += dst.remaining();
        }
        Object i = this.stateLock;
        synchronized (i) {
            if (this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_INBOUND) {
                return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
            }
            if (this.engineState == EngineState.NEW || this.engineState == EngineState.MODE_SET) {
                this.beginHandshake();
            }
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
            int positionBeforeHandshake = src.position();
            OpenSSLBIOSource source = OpenSSLBIOSource.wrap(src);
            long sslSessionCtx = 0L;
            try {
                sslSessionCtx = NativeCrypto.SSL_do_handshake_bio(this.sslNativePointer, source.getContext(), this.handshakeSink.getContext(), this, this.getUseClientMode(), this.sslParameters.npnProtocols, this.sslParameters.alpnProtocols);
                if (sslSessionCtx != 0L) {
                    if (this.sslSession != null && this.engineState == EngineState.HANDSHAKE_STARTED) {
                        this.engineState = EngineState.READY_HANDSHAKE_CUT_THROUGH;
                    }
                    this.sslSession = this.sslParameters.setupSession(sslSessionCtx, this.sslNativePointer, this.sslSession, this.getPeerHost(), this.getPeerPort(), true);
                }
                int bytesWritten = this.handshakeSink.position();
                int bytesConsumed = src.position() - positionBeforeHandshake;
                SSLEngineResult sSLEngineResult = new SSLEngineResult(bytesConsumed > 0 ? SSLEngineResult.Status.OK : SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), bytesConsumed, bytesWritten);
                return sSLEngineResult;
            }
            catch (Exception e) {
                throw (SSLHandshakeException)new SSLHandshakeException("Handshake failed").initCause(e);
            }
            finally {
                if (this.sslSession == null && sslSessionCtx != 0L) {
                    NativeCrypto.SSL_SESSION_free(sslSessionCtx);
                }
                source.release();
            }
        }
        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        if (dstRemaining == 0) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
        }
        ByteBuffer srcDuplicate = src.duplicate();
        OpenSSLBIOSource source = OpenSSLBIOSource.wrap(srcDuplicate);
        try {
            int positionBeforeRead = srcDuplicate.position();
            int produced = 0;
            boolean shouldStop = false;
            while (!shouldStop) {
                ByteBuffer dst = this.getNextAvailableByteBuffer(dsts, offset, length);
                if (dst == null) {
                    shouldStop = true;
                    continue;
                }
                ByteBuffer arrayDst = dst;
                if (dst.isDirect()) {
                    arrayDst = ByteBuffer.allocate(dst.remaining());
                }
                int dstOffset = arrayDst.arrayOffset() + arrayDst.position();
                int internalProduced = NativeCrypto.SSL_read_BIO(this.sslNativePointer, arrayDst.array(), dstOffset, dst.remaining(), source.getContext(), this.localToRemoteSink.getContext(), this);
                if (internalProduced <= 0) {
                    shouldStop = true;
                    continue;
                }
                arrayDst.position(arrayDst.position() + internalProduced);
                produced += internalProduced;
                if (dst == arrayDst) continue;
                arrayDst.flip();
                dst.put(arrayDst);
            }
            int consumed = srcDuplicate.position() - positionBeforeRead;
            src.position(srcDuplicate.position());
            SSLEngineResult sSLEngineResult = new SSLEngineResult(consumed > 0 ? SSLEngineResult.Status.OK : SSLEngineResult.Status.BUFFER_UNDERFLOW, this.getHandshakeStatus(), consumed, produced);
            return sSLEngineResult;
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
        finally {
            source.release();
        }
    }

    private ByteBuffer getNextAvailableByteBuffer(ByteBuffer[] buffers, int offset, int length) {
        for (int i = offset; i < length; ++i) {
            if (buffers[i].remaining() <= 0) continue;
            return buffers[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLEngineResult wrap(ByteBuffer[] srcs, int offset, int length, ByteBuffer dst) throws SSLException {
        if (srcs == null) {
            throw new IllegalArgumentException("srcs == null");
        }
        if (dst == null) {
            throw new IllegalArgumentException("dst == null");
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        for (ByteBuffer src : srcs) {
            if (src != null) continue;
            throw new IllegalArgumentException("one of the src == null");
        }
        OpenSSLEngineImpl.checkIndex(srcs.length, offset, length);
        if (dst.remaining() < 16709) {
            return new SSLEngineResult(SSLEngineResult.Status.BUFFER_OVERFLOW, this.getHandshakeStatus(), 0, 0);
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.engineState == EngineState.CLOSED || this.engineState == EngineState.CLOSED_OUTBOUND) {
                return new SSLEngineResult(SSLEngineResult.Status.CLOSED, this.getHandshakeStatus(), 0, 0);
            }
            if (this.engineState == EngineState.NEW || this.engineState == EngineState.MODE_SET) {
                this.beginHandshake();
            }
        }
        SSLEngineResult.HandshakeStatus handshakeStatus = this.getHandshakeStatus();
        if (handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_WRAP) {
            if (this.handshakeSink.available() == 0) {
                long sslSessionCtx = 0L;
                try {
                    sslSessionCtx = NativeCrypto.SSL_do_handshake_bio(this.sslNativePointer, nullSource.getContext(), this.handshakeSink.getContext(), this, this.getUseClientMode(), this.sslParameters.npnProtocols, this.sslParameters.alpnProtocols);
                    if (sslSessionCtx != 0L) {
                        if (this.sslSession != null && this.engineState == EngineState.HANDSHAKE_STARTED) {
                            this.engineState = EngineState.READY_HANDSHAKE_CUT_THROUGH;
                        }
                        this.sslSession = this.sslParameters.setupSession(sslSessionCtx, this.sslNativePointer, this.sslSession, this.getPeerHost(), this.getPeerPort(), true);
                    }
                }
                catch (Exception e) {
                    throw (SSLHandshakeException)new SSLHandshakeException("Handshake failed").initCause(e);
                }
                finally {
                    if (this.sslSession == null && sslSessionCtx != 0L) {
                        NativeCrypto.SSL_SESSION_free(sslSessionCtx);
                    }
                }
            }
            int bytesWritten = OpenSSLEngineImpl.writeSinkToByteBuffer(this.handshakeSink, dst);
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.getHandshakeStatus(), 0, bytesWritten);
        }
        if (handshakeStatus != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            return new SSLEngineResult(SSLEngineResult.Status.OK, handshakeStatus, 0, 0);
        }
        try {
            int totalRead = 0;
            byte[] buffer = null;
            for (ByteBuffer src : srcs) {
                int toRead = src.remaining();
                if (buffer == null || toRead > buffer.length) {
                    buffer = new byte[toRead];
                }
                src.duplicate().get(buffer, 0, toRead);
                int numRead = NativeCrypto.SSL_write_BIO(this.sslNativePointer, buffer, toRead, this.localToRemoteSink.getContext(), this);
                if (numRead <= 0) continue;
                src.position(src.position() + numRead);
                totalRead += numRead;
            }
            return new SSLEngineResult(SSLEngineResult.Status.OK, this.getHandshakeStatus(), totalRead, OpenSSLEngineImpl.writeSinkToByteBuffer(this.localToRemoteSink, dst));
        }
        catch (IOException e) {
            throw new SSLException(e);
        }
    }

    private static int writeSinkToByteBuffer(OpenSSLBIOSink sink, ByteBuffer dst) {
        int toWrite = Math.min(sink.available(), dst.remaining());
        dst.put(sink.toByteArray(), sink.position(), toWrite);
        sink.skip(toWrite);
        return toWrite;
    }

    @Override
    public int clientPSKKeyRequested(String identityHint, byte[] identity, byte[] key) {
        return this.sslParameters.clientPSKKeyRequested(identityHint, identity, key, this);
    }

    @Override
    public int serverPSKKeyRequested(String identityHint, String identity, byte[] key) {
        return this.sslParameters.serverPSKKeyRequested(identityHint, identity, key, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSSLStateChange(long sslSessionNativePtr, int type, int val) {
        Object object = this.stateLock;
        synchronized (object) {
            switch (type) {
                case 32: {
                    if (this.engineState != EngineState.HANDSHAKE_STARTED && this.engineState != EngineState.READY_HANDSHAKE_CUT_THROUGH) {
                        throw new IllegalStateException("Completed handshake while in mode " + (Object)((Object)this.engineState));
                    }
                    this.engineState = EngineState.HANDSHAKE_COMPLETED;
                    break;
                }
                case 16: {
                    this.engineState = EngineState.HANDSHAKE_STARTED;
                }
            }
        }
    }

    @Override
    public void verifyCertificateChain(long sslSessionNativePtr, long[] certRefs, String authMethod) throws CertificateException {
        try {
            X509TrustManager x509tm = this.sslParameters.getX509TrustManager();
            if (x509tm == null) {
                throw new CertificateException("No X.509 TrustManager");
            }
            if (certRefs == null || certRefs.length == 0) {
                throw new SSLException("Peer sent no certificate");
            }
            X509Certificate[] peerCertChain = new OpenSSLX509Certificate[certRefs.length];
            for (int i = 0; i < certRefs.length; ++i) {
                peerCertChain[i] = new OpenSSLX509Certificate(certRefs[i]);
            }
            this.handshakeSession = new OpenSSLSessionImpl(sslSessionNativePtr, null, peerCertChain, this.getPeerHost(), this.getPeerPort(), null);
            boolean client = this.sslParameters.getUseClientMode();
            if (client) {
                Platform.checkServerTrusted(x509tm, peerCertChain, authMethod, this.getPeerHost());
            } else {
                String authType = ((OpenSSLX509Certificate)peerCertChain[0]).getPublicKey().getAlgorithm();
                x509tm.checkClientTrusted(peerCertChain, authType);
            }
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CertificateException(e);
        }
        finally {
            this.handshakeSession = null;
        }
    }

    @Override
    public void clientCertificateRequested(byte[] keyTypeBytes, byte[][] asn1DerEncodedPrincipals) throws CertificateEncodingException, SSLException {
        this.sslParameters.chooseClientCertificate(keyTypeBytes, asn1DerEncodedPrincipals, this.sslNativePointer, this);
    }

    private void shutdown() {
        try {
            NativeCrypto.SSL_shutdown_BIO(this.sslNativePointer, nullSource.getContext(), this.localToRemoteSink.getContext(), this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownAndFreeSslNative() {
        try {
            this.shutdown();
        }
        finally {
            this.free();
        }
    }

    private void free() {
        if (this.sslNativePointer == 0L) {
            return;
        }
        NativeCrypto.SSL_free(this.sslNativePointer);
        this.sslNativePointer = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.free();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public String chooseServerAlias(X509KeyManager keyManager, String keyType) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineServerAlias(keyType, null, this);
        }
        return keyManager.chooseServerAlias(keyType, null, null);
    }

    @Override
    public String chooseClientAlias(X509KeyManager keyManager, X500Principal[] issuers, String[] keyTypes) {
        if (keyManager instanceof X509ExtendedKeyManager) {
            X509ExtendedKeyManager ekm = (X509ExtendedKeyManager)keyManager;
            return ekm.chooseEngineClientAlias(keyTypes, issuers, this);
        }
        return keyManager.chooseClientAlias(keyTypes, issuers, null);
    }

    @Override
    public String chooseServerPSKIdentityHint(PSKKeyManager keyManager) {
        return keyManager.chooseServerKeyIdentityHint(this);
    }

    @Override
    public String chooseClientPSKIdentity(PSKKeyManager keyManager, String identityHint) {
        return keyManager.chooseClientKeyIdentity(identityHint, this);
    }

    @Override
    public SecretKey getPSKKey(PSKKeyManager keyManager, String identityHint, String identity) {
        return keyManager.getKey(identityHint, identity, this);
    }

    private static enum EngineState {
        NEW,
        MODE_SET,
        HANDSHAKE_WANTED,
        HANDSHAKE_STARTED,
        HANDSHAKE_COMPLETED,
        READY_HANDSHAKE_CUT_THROUGH,
        READY,
        CLOSED_INBOUND,
        CLOSED_OUTBOUND,
        CLOSED;

    }
}

