/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.util.Log;
import com.android.server.BluetoothManagerService;
import com.android.server.SystemService;

class BluetoothService
extends SystemService {
    private static final String TAG = "BluetoothService";
    private BluetoothManagerService mBluetoothManagerService;

    public BluetoothService(Context context) {
        super(context);
        this.mBluetoothManagerService = new BluetoothManagerService(context);
    }

    @Override
    public void onStart() {
        Log.d(TAG, "onStart: publishing BluetoothManagerService");
        this.publishBinderService("bluetooth_manager", this.mBluetoothManagerService);
    }

    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            Log.d(TAG, "onBootPhase: PHASE_SYSTEM_SERVICES_READY");
            this.mBluetoothManagerService.handleOnBootPhase();
        }
    }

    @Override
    public void onSwitchUser(int userHandle) {
        Log.d(TAG, "onSwitchUser: switching to user " + userHandle);
        this.mBluetoothManagerService.handleOnSwitchUser(userHandle);
    }
}

