/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.IConnectivityManager;
import android.net.INetworkManagementEventObserver;
import android.net.INetworkPolicyListener;
import android.net.INetworkPolicyManager;
import android.net.INetworkStatsService;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkConfig;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkQuotaInfo;
import android.net.NetworkRequest;
import android.net.NetworkState;
import android.net.NetworkUtils;
import android.net.ProxyInfo;
import android.net.RouteInfo;
import android.net.UidRange;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileUtils;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.INetworkManagementService;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.security.KeyStore;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.LocalLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.util.Xml;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.net.LegacyVpnInfo;
import com.android.internal.net.NetworkStatsFactory;
import com.android.internal.net.VpnConfig;
import com.android.internal.net.VpnInfo;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.AsyncChannel;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.XmlUtils;
import com.android.server.am.BatteryStatsService;
import com.android.server.connectivity.DataConnectionStats;
import com.android.server.connectivity.Nat464Xlat;
import com.android.server.connectivity.NetworkAgentInfo;
import com.android.server.connectivity.NetworkDiagnostics;
import com.android.server.connectivity.NetworkMonitor;
import com.android.server.connectivity.PacManager;
import com.android.server.connectivity.PermissionMonitor;
import com.android.server.connectivity.Tethering;
import com.android.server.connectivity.Vpn;
import com.android.server.net.BaseNetworkObserver;
import com.android.server.net.LockdownVpnTracker;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConnectivityService
extends IConnectivityManager.Stub
implements PendingIntent.OnFinished {
    private static final String TAG = "ConnectivityService";
    private static final boolean DBG = true;
    private static final boolean VDBG = false;
    private static final boolean LOGD_RULES = false;
    private static final int RESTORE_DEFAULT_NETWORK_DELAY = 60000;
    private static final String NETWORK_RESTORE_DELAY_PROP_NAME = "android.telephony.apn-restore";
    private static final int PROMPT_UNVALIDATED_DELAY_MS = 8000;
    private final int mReleasePendingIntentDelayMs;
    private Tethering mTethering;
    private final PermissionMonitor mPermissionMonitor;
    private KeyStore mKeyStore;
    @GuardedBy(value="mVpns")
    private final SparseArray<Vpn> mVpns = new SparseArray();
    private boolean mLockdownEnabled;
    private LockdownVpnTracker mLockdownTracker;
    private Object mRulesLock = new Object();
    private SparseIntArray mUidRules = new SparseIntArray();
    private HashSet<String> mMeteredIfaces = Sets.newHashSet();
    private final Context mContext;
    private int mNetworkPreference;
    private int mDefaultInetConditionPublished = 0;
    private int mNumDnsEntries;
    private boolean mTestMode;
    private static ConnectivityService sServiceInstance;
    private INetworkManagementService mNetd;
    private INetworkStatsService mStatsService;
    private INetworkPolicyManager mPolicyManager;
    private String mCurrentTcpBufferSizes;
    private static final int ENABLED = 1;
    private static final int DISABLED = 0;
    private static final int EVENT_CHANGE_MOBILE_DATA_ENABLED = 2;
    private static final int EVENT_CLEAR_NET_TRANSITION_WAKELOCK = 8;
    private static final int EVENT_APPLY_GLOBAL_HTTP_PROXY = 9;
    private static final int EVENT_SEND_STICKY_BROADCAST_INTENT = 11;
    private static final int EVENT_PROXY_HAS_CHANGED = 16;
    private static final int EVENT_REGISTER_NETWORK_FACTORY = 17;
    private static final int EVENT_REGISTER_NETWORK_AGENT = 18;
    private static final int EVENT_REGISTER_NETWORK_REQUEST = 19;
    private static final int EVENT_TIMEOUT_NETWORK_REQUEST = 20;
    private static final int EVENT_REGISTER_NETWORK_LISTENER = 21;
    private static final int EVENT_RELEASE_NETWORK_REQUEST = 22;
    private static final int EVENT_UNREGISTER_NETWORK_FACTORY = 23;
    private static final int EVENT_EXPIRE_NET_TRANSITION_WAKELOCK = 24;
    private static final int EVENT_SYSTEM_READY = 25;
    private static final int EVENT_REGISTER_NETWORK_REQUEST_WITH_INTENT = 26;
    private static final int EVENT_RELEASE_NETWORK_REQUEST_WITH_INTENT = 27;
    private static final int EVENT_SET_ACCEPT_UNVALIDATED = 28;
    private static final int EVENT_PROMPT_UNVALIDATED = 29;
    private static final int EVENT_CONFIGURE_MOBILE_DATA_ALWAYS_ON = 30;
    private static final int EVENT_REGISTER_NETWORK_LISTENER_WITH_INTENT = 31;
    private final InternalHandler mHandler;
    private final NetworkStateTrackerHandler mTrackerHandler;
    private boolean mSystemReady;
    private Intent mInitialBroadcast;
    private PowerManager.WakeLock mNetTransitionWakeLock;
    private String mNetTransitionWakeLockCausedBy = "";
    private int mNetTransitionWakeLockSerialNumber;
    private int mNetTransitionWakeLockTimeout;
    private final PowerManager.WakeLock mPendingIntentWakeLock;
    private InetAddress mDefaultDns;
    private static final int INET_CONDITION_LOG_MAX_SIZE = 15;
    private ArrayList mInetLog;
    private volatile ProxyInfo mDefaultProxy = null;
    private Object mProxyLock = new Object();
    private boolean mDefaultProxyDisabled = false;
    private ProxyInfo mGlobalProxy = null;
    private PacManager mPacManager = null;
    private final SettingsObserver mSettingsObserver;
    private UserManager mUserManager;
    NetworkConfig[] mNetConfigs;
    int mNetworksDefined;
    List mProtectedNetworks;
    private DataConnectionStats mDataConnectionStats;
    TelephonyManager mTelephonyManager;
    private static final int MIN_NET_ID = 100;
    private static final int MAX_NET_ID = 65535;
    private int mNextNetId = 100;
    private int mNextNetworkRequestId = 1;
    private static final int MAX_NETWORK_REQUEST_LOGS = 20;
    private final LocalLog mNetworkRequestInfoLogs = new LocalLog(20);
    private static final int MAX_VALIDATION_LOGS = 10;
    private final ArrayDeque<Pair<Network, LocalLog.ReadOnlyLocalLog>> mValidationLogs = new ArrayDeque(10);
    private LegacyTypeTracker mLegacyTypeTracker = new LegacyTypeTracker();
    private INetworkManagementEventObserver mDataActivityObserver = new BaseNetworkObserver(){

        @Override
        public void interfaceClassDataActivityChanged(String label, boolean active, long tsNanos) {
            int deviceType = Integer.parseInt(label);
            ConnectivityService.this.sendDataActivityBroadcast(deviceType, active, tsNanos);
        }
    };
    private INetworkPolicyListener mPolicyListener = new INetworkPolicyListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onUidRulesChanged(int uid, int uidRules) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                int oldRules = ConnectivityService.this.mUidRules.get(uid, 0);
                if (oldRules == uidRules) {
                    return;
                }
                ConnectivityService.this.mUidRules.put(uid, uidRules);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onMeteredIfacesChanged(String[] meteredIfaces) {
            Object object = ConnectivityService.this.mRulesLock;
            synchronized (object) {
                ConnectivityService.this.mMeteredIfaces.clear();
                for (String iface : meteredIfaces) {
                    ConnectivityService.this.mMeteredIfaces.add(iface);
                }
            }
        }

        @Override
        public void onRestrictBackgroundChanged(boolean restrictBackground) {
        }
    };
    private BroadcastReceiver mUserPresentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (ConnectivityService.this.updateLockdownVpn()) {
                ConnectivityService.this.mContext.unregisterReceiver(this);
            }
        }
    };
    private static final String DEFAULT_TCP_BUFFER_SIZES = "4096,87380,110208,4096,16384,110208";
    private static final String DEFAULT_TCP_RWND_KEY = "net.tcp.default_init_rwnd";
    private static final String NOTIFICATION_ID = "CaptivePortal.Notification";
    private static final String PROVISIONING_URL_PATH = "/data/misc/radio/provisioning_urls.xml";
    private final File mProvisioningUrlFile = new File("/data/misc/radio/provisioning_urls.xml");
    private static final String TAG_PROVISIONING_URLS = "provisioningUrls";
    private static final String TAG_PROVISIONING_URL = "provisioningUrl";
    private static final String ATTR_MCC = "mcc";
    private static final String ATTR_MNC = "mnc";
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_STARTING".equals(action)) {
                ConnectivityService.this.onUserStart(userId);
            } else if ("android.intent.action.USER_STOPPING".equals(action)) {
                ConnectivityService.this.onUserStop(userId);
            }
        }
    };
    private final HashMap<Messenger, NetworkFactoryInfo> mNetworkFactoryInfos = new HashMap();
    private final HashMap<NetworkRequest, NetworkRequestInfo> mNetworkRequests = new HashMap();
    private final SparseArray<NetworkAgentInfo> mNetworkForRequestId = new SparseArray();
    @GuardedBy(value="mNetworkForNetId")
    private final SparseArray<NetworkAgentInfo> mNetworkForNetId = new SparseArray();
    @GuardedBy(value="mNetworkForNetId")
    private final SparseBooleanArray mNetIdInUse = new SparseBooleanArray();
    private final HashMap<Messenger, NetworkAgentInfo> mNetworkAgentInfos = new HashMap();
    private final NetworkRequest mDefaultRequest;
    private final NetworkRequest mDefaultMobileDataRequest;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addValidationLogs(LocalLog.ReadOnlyLocalLog log, Network network) {
        ArrayDeque<Pair<Network, LocalLog.ReadOnlyLocalLog>> arrayDeque = this.mValidationLogs;
        synchronized (arrayDeque) {
            while (this.mValidationLogs.size() >= 10) {
                this.mValidationLogs.removeLast();
            }
            this.mValidationLogs.addFirst(new Pair<Network, LocalLog.ReadOnlyLocalLog>(network, log));
        }
    }

    public ConnectivityService(Context context, INetworkManagementService netManager, INetworkStatsService statsService, INetworkPolicyManager policyManager) {
        int[] protectedNetworks;
        String[] naStrings;
        String dns;
        String id2;
        ConnectivityService.log("ConnectivityService starting up");
        this.mDefaultRequest = this.createInternetRequestForTransport(-1);
        NetworkRequestInfo defaultNRI = new NetworkRequestInfo(null, this.mDefaultRequest, new Binder(), true);
        this.mNetworkRequests.put(this.mDefaultRequest, defaultNRI);
        this.mNetworkRequestInfoLogs.log("REGISTER " + defaultNRI);
        this.mDefaultMobileDataRequest = this.createInternetRequestForTransport(0);
        HandlerThread handlerThread = new HandlerThread("ConnectivityServiceThread");
        handlerThread.start();
        this.mHandler = new InternalHandler(handlerThread.getLooper());
        this.mTrackerHandler = new NetworkStateTrackerHandler(handlerThread.getLooper());
        if (TextUtils.isEmpty(SystemProperties.get("net.hostname")) && (id2 = Settings.Secure.getString(context.getContentResolver(), "android_id")) != null && id2.length() > 0) {
            String name = new String("android-").concat(id2);
            SystemProperties.set("net.hostname", name);
        }
        if ((dns = Settings.Global.getString(context.getContentResolver(), "default_dns_server")) == null || dns.length() == 0) {
            dns = context.getResources().getString(17039405);
        }
        try {
            this.mDefaultDns = NetworkUtils.numericToInetAddress(dns);
        }
        catch (IllegalArgumentException e) {
            ConnectivityService.loge("Error setting defaultDns using " + dns);
        }
        this.mReleasePendingIntentDelayMs = Settings.Secure.getInt(context.getContentResolver(), "connectivity_release_pending_intent_delay_ms", 5000);
        this.mContext = ConnectivityService.checkNotNull(context, "missing Context");
        this.mNetd = ConnectivityService.checkNotNull(netManager, "missing INetworkManagementService");
        this.mStatsService = ConnectivityService.checkNotNull(statsService, "missing INetworkStatsService");
        this.mPolicyManager = ConnectivityService.checkNotNull(policyManager, "missing INetworkPolicyManager");
        this.mKeyStore = KeyStore.getInstance();
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        try {
            this.mPolicyManager.registerListener(this.mPolicyListener);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("unable to register INetworkPolicyListener" + e.toString());
        }
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        this.mNetTransitionWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetTransitionWakeLockTimeout = this.mContext.getResources().getInteger(17694733);
        this.mPendingIntentWakeLock = powerManager.newWakeLock(1, TAG);
        this.mNetConfigs = new NetworkConfig[18];
        boolean wifiOnly = SystemProperties.getBoolean("ro.radio.noril", false);
        ConnectivityService.log("wifiOnly=" + wifiOnly);
        for (String naString : naStrings = context.getResources().getStringArray(17235980)) {
            try {
                NetworkConfig n = new NetworkConfig(naString);
                if (n.type > 17) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to define type " + n.type);
                    continue;
                }
                if (wifiOnly && ConnectivityManager.isNetworkTypeMobile(n.type)) {
                    ConnectivityService.log("networkAttributes - ignoring mobile as this dev is wifiOnly " + n.type);
                    continue;
                }
                if (this.mNetConfigs[n.type] != null) {
                    ConnectivityService.loge("Error in networkAttributes - ignoring attempt to redefine type " + n.type);
                    continue;
                }
                this.mLegacyTypeTracker.addSupportedType(n.type);
                this.mNetConfigs[n.type] = n;
                ++this.mNetworksDefined;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.mNetConfigs[17] == null) {
            this.mLegacyTypeTracker.addSupportedType(17);
            ++this.mNetworksDefined;
        }
        this.mProtectedNetworks = new ArrayList();
        for (int p : protectedNetworks = context.getResources().getIntArray(17235981)) {
            if (this.mNetConfigs[p] != null && !this.mProtectedNetworks.contains(p)) {
                this.mProtectedNetworks.add(p);
                continue;
            }
            ConnectivityService.loge("Ignoring protectedNetwork " + p);
        }
        this.mTestMode = SystemProperties.get("cm.test.mode").equals("true") && SystemProperties.get("ro.build.type").equals("eng");
        this.mTethering = new Tethering(this.mContext, this.mNetd, statsService, this.mHandler.getLooper());
        this.mPermissionMonitor = new PermissionMonitor(this.mContext, this.mNetd);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_STARTING");
        intentFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        try {
            this.mNetd.registerObserver(this.mTethering);
            this.mNetd.registerObserver(this.mDataActivityObserver);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("Error registering observer :" + e);
        }
        this.mInetLog = new ArrayList();
        this.mSettingsObserver = new SettingsObserver(this.mContext, this.mHandler);
        this.registerSettingsCallbacks();
        this.mDataConnectionStats = new DataConnectionStats(this.mContext);
        this.mDataConnectionStats.startMonitoring();
        this.mPacManager = new PacManager(this.mContext, this.mHandler, 16);
        this.mUserManager = (UserManager)context.getSystemService("user");
    }

    private NetworkRequest createInternetRequestForTransport(int transportType) {
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addCapability(12);
        netCap.addCapability(13);
        if (transportType > -1) {
            netCap.addTransportType(transportType);
        }
        return new NetworkRequest(netCap, -1, this.nextNetworkRequestId());
    }

    private void handleMobileDataAlwaysOn() {
        boolean isEnabled;
        boolean enable = Settings.Global.getInt(this.mContext.getContentResolver(), "mobile_data_always_on", 0) == 1;
        boolean bl = isEnabled = this.mNetworkRequests.get(this.mDefaultMobileDataRequest) != null;
        if (enable == isEnabled) {
            return;
        }
        if (enable) {
            this.handleRegisterNetworkRequest(new NetworkRequestInfo(null, this.mDefaultMobileDataRequest, new Binder(), true));
        } else {
            this.handleReleaseNetworkRequest(this.mDefaultMobileDataRequest, 1000);
        }
    }

    private void registerSettingsCallbacks() {
        this.mSettingsObserver.observe(Settings.Global.getUriFor("http_proxy"), 9);
        this.mSettingsObserver.observe(Settings.Global.getUriFor("mobile_data_always_on"), 30);
    }

    private synchronized int nextNetworkRequestId() {
        return this.mNextNetworkRequestId++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int reserveNetId() {
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            for (int i = 100; i <= 65535; ++i) {
                int netId = this.mNextNetId++;
                if (this.mNextNetId > 65535) {
                    this.mNextNetId = 100;
                }
                if (this.mNetIdInUse.get(netId)) continue;
                this.mNetIdInUse.put(netId, true);
                return netId;
            }
        }
        throw new IllegalStateException("No free netIds");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkState getFilteredNetworkState(int networkType, int uid) {
        NetworkInfo info = null;
        LinkProperties lp = null;
        NetworkCapabilities nc = null;
        Network network = null;
        String subscriberId = null;
        if (this.mLegacyTypeTracker.isTypeSupported(networkType)) {
            NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
            if (nai != null) {
                NetworkAgentInfo networkAgentInfo = nai;
                synchronized (networkAgentInfo) {
                    info = new NetworkInfo(nai.networkInfo);
                    lp = new LinkProperties(nai.linkProperties);
                    nc = new NetworkCapabilities(nai.networkCapabilities);
                    network = nai.network;
                    subscriberId = nai.networkMisc != null ? nai.networkMisc.subscriberId : null;
                }
                info.setType(networkType);
            } else {
                info = new NetworkInfo(networkType, 0, ConnectivityManager.getNetworkTypeName(networkType), "");
                info.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
                info.setIsAvailable(true);
                lp = new LinkProperties();
                nc = new NetworkCapabilities();
                network = null;
            }
            info = this.getFilteredNetworkInfo(info, lp, uid);
        }
        return new NetworkState(info, lp, nc, network, subscriberId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkAgentInfo getNetworkAgentInfoForNetwork(Network network) {
        if (network == null) {
            return null;
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            return this.mNetworkForNetId.get(network.netId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Network[] getVpnUnderlyingNetworks(int uid) {
        if (!this.mLockdownEnabled) {
            int user = UserHandle.getUserId(uid);
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                Vpn vpn = this.mVpns.get(user);
                if (vpn != null && vpn.appliesToUid(uid)) {
                    return vpn.getUnderlyingNetworks();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkState getUnfilteredActiveNetworkState(int uid) {
        NetworkInfo info = null;
        LinkProperties lp = null;
        NetworkCapabilities nc = null;
        Network network = null;
        String subscriberId = null;
        NetworkAgentInfo nai = this.getDefaultNetwork();
        Network[] networks = this.getVpnUnderlyingNetworks(uid);
        if (networks != null) {
            nai = networks.length > 0 ? this.getNetworkAgentInfoForNetwork(networks[0]) : null;
        }
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                info = new NetworkInfo(nai.networkInfo);
                lp = new LinkProperties(nai.linkProperties);
                nc = new NetworkCapabilities(nai.networkCapabilities);
                network = nai.network;
                subscriberId = nai.networkMisc != null ? nai.networkMisc.subscriberId : null;
            }
        }
        return new NetworkState(info, lp, nc, network, subscriberId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNetworkWithLinkPropertiesBlocked(LinkProperties lp, int uid) {
        int uidRules;
        boolean networkCostly;
        String iface = lp == null ? "" : lp.getInterfaceName();
        Object object = this.mRulesLock;
        synchronized (object) {
            networkCostly = this.mMeteredIfaces.contains(iface);
            uidRules = this.mUidRules.get(uid, 0);
        }
        return (uidRules & 2) != 0 || networkCostly && (uidRules & 1) != 0;
    }

    private NetworkInfo getFilteredNetworkInfo(NetworkInfo info, LinkProperties lp, int uid) {
        if (info != null && this.isNetworkWithLinkPropertiesBlocked(lp, uid)) {
            info = new NetworkInfo(info);
            info.setDetailedState(NetworkInfo.DetailedState.BLOCKED, null, null);
        }
        if (info != null && this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        return info;
    }

    @Override
    public NetworkInfo getActiveNetworkInfo() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return this.getFilteredNetworkInfo(state.networkInfo, state.linkProperties, uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network getActiveNetwork() {
        NetworkAgentInfo nai;
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        int user = UserHandle.getUserId(uid);
        int vpnNetId = 0;
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(user);
            if (vpn != null && vpn.appliesToUid(uid)) {
                vpnNetId = vpn.getNetId();
            }
        }
        if (vpnNetId != 0) {
            SparseArray<NetworkAgentInfo> sparseArray2 = this.mNetworkForNetId;
            synchronized (sparseArray2) {
                nai = this.mNetworkForNetId.get(vpnNetId);
            }
            if (nai != null) {
                return nai.network;
            }
        }
        if ((nai = this.getDefaultNetwork()) != null && this.isNetworkWithLinkPropertiesBlocked(nai.linkProperties, uid)) {
            nai = null;
        }
        return nai != null ? nai.network : null;
    }

    public NetworkInfo getActiveNetworkInfoUnfiltered() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.networkInfo;
    }

    @Override
    public NetworkInfo getActiveNetworkInfoForUid(int uid) {
        this.enforceConnectivityInternalPermission();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return this.getFilteredNetworkInfo(state.networkInfo, state.linkProperties, uid);
    }

    @Override
    public NetworkInfo getNetworkInfo(int networkType) {
        NetworkState state;
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        if (this.getVpnUnderlyingNetworks(uid) != null) {
            state = this.getUnfilteredActiveNetworkState(uid);
            if (state.networkInfo != null && state.networkInfo.getType() == networkType) {
                return this.getFilteredNetworkInfo(state.networkInfo, state.linkProperties, uid);
            }
        }
        state = this.getFilteredNetworkState(networkType, uid);
        return state.networkInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkInfo getNetworkInfoForNetwork(Network network) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkInfo info = null;
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                info = new NetworkInfo(nai.networkInfo);
                info = this.getFilteredNetworkInfo(info, nai.linkProperties, uid);
            }
        }
        return info;
    }

    @Override
    public NetworkInfo[] getAllNetworkInfo() {
        this.enforceAccessPermission();
        ArrayList<NetworkInfo> result = Lists.newArrayList();
        for (int networkType = 0; networkType <= 17; ++networkType) {
            NetworkInfo info = this.getNetworkInfo(networkType);
            if (info == null) continue;
            result.add(info);
        }
        return result.toArray(new NetworkInfo[result.size()]);
    }

    @Override
    public Network getNetworkForType(int networkType) {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getFilteredNetworkState(networkType, uid);
        if (!this.isNetworkWithLinkPropertiesBlocked(state.linkProperties, uid)) {
            return state.network;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Network[] getAllNetworks() {
        this.enforceAccessPermission();
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            Network[] result = new Network[this.mNetworkForNetId.size()];
            for (int i = 0; i < this.mNetworkForNetId.size(); ++i) {
                result[i] = this.mNetworkForNetId.valueAt((int)i).network;
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkCapabilities[] getDefaultNetworkCapabilitiesForUser(int userId) {
        this.enforceAccessPermission();
        HashMap<Network, NetworkCapabilities> result = new HashMap<Network, NetworkCapabilities>();
        NetworkAgentInfo nai = this.getDefaultNetwork();
        NetworkCapabilities nc = this.getNetworkCapabilitiesInternal(nai);
        if (nc != null) {
            result.put(nai.network, nc);
        }
        if (!this.mLockdownEnabled) {
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                Network[] networks;
                Vpn vpn = this.mVpns.get(userId);
                if (vpn != null && (networks = vpn.getUnderlyingNetworks()) != null) {
                    for (Network network : networks) {
                        nai = this.getNetworkAgentInfoForNetwork(network);
                        nc = this.getNetworkCapabilitiesInternal(nai);
                        if (nc == null) continue;
                        result.put(network, nc);
                    }
                }
            }
        }
        NetworkCapabilities[] out = new NetworkCapabilities[result.size()];
        out = result.values().toArray(out);
        return out;
    }

    @Override
    public boolean isNetworkSupported(int networkType) {
        this.enforceAccessPermission();
        return this.mLegacyTypeTracker.isTypeSupported(networkType);
    }

    @Override
    public LinkProperties getActiveLinkProperties() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        return state.linkProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkProperties getLinkPropertiesForType(int networkType) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinkProperties getLinkProperties(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                return new LinkProperties(nai.linkProperties);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkCapabilities getNetworkCapabilitiesInternal(NetworkAgentInfo nai) {
        if (nai != null) {
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                if (nai.networkCapabilities != null) {
                    return new NetworkCapabilities(nai.networkCapabilities);
                }
            }
        }
        return null;
    }

    @Override
    public NetworkCapabilities getNetworkCapabilities(Network network) {
        this.enforceAccessPermission();
        return this.getNetworkCapabilitiesInternal(this.getNetworkAgentInfoForNetwork(network));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkState[] getAllNetworkState() {
        this.enforceConnectivityInternalPermission();
        ArrayList<NetworkState> result = Lists.newArrayList();
        for (Network network : this.getAllNetworks()) {
            NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
            if (nai == null) continue;
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                String subscriberId = nai.networkMisc != null ? nai.networkMisc.subscriberId : null;
                result.add(new NetworkState(nai.networkInfo, nai.linkProperties, nai.networkCapabilities, network, subscriberId, null));
            }
        }
        return result.toArray(new NetworkState[result.size()]);
    }

    /*
     * Exception decompiling
     */
    @Override
    public NetworkQuotaInfo getActiveNetworkQuotaInfo() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActiveNetworkMetered() {
        this.enforceAccessPermission();
        int uid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            boolean bl = this.isActiveNetworkMeteredUnchecked(uid);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean isActiveNetworkMeteredUnchecked(int uid) {
        NetworkState state = this.getUnfilteredActiveNetworkState(uid);
        if (state.networkInfo != null) {
            try {
                return this.mPolicyManager.isNetworkMetered(state);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestRouteToHostAddress(int networkType, byte[] hostAddress) {
        NetworkInfo.DetailedState netState;
        InetAddress addr;
        this.enforceChangePermission();
        if (this.mProtectedNetworks.contains(networkType)) {
            this.enforceConnectivityInternalPermission();
        }
        try {
            addr = InetAddress.getByAddress(hostAddress);
        }
        catch (UnknownHostException e) {
            ConnectivityService.log("requestRouteToHostAddress got " + e.toString());
            return false;
        }
        if (!ConnectivityManager.isNetworkTypeValid(networkType)) {
            ConnectivityService.log("requestRouteToHostAddress on invalid network: " + networkType);
            return false;
        }
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            if (!this.mLegacyTypeTracker.isTypeSupported(networkType)) {
                ConnectivityService.log("requestRouteToHostAddress on unsupported network: " + networkType);
            } else {
                ConnectivityService.log("requestRouteToHostAddress on down network: " + networkType);
            }
            return false;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            netState = nai.networkInfo.getDetailedState();
        }
        if (netState != NetworkInfo.DetailedState.CONNECTED && netState != NetworkInfo.DetailedState.CAPTIVE_PORTAL_CHECK) {
            return false;
        }
        int uid = Binder.getCallingUid();
        long token = Binder.clearCallingIdentity();
        try {
            int netId;
            LinkProperties lp;
            NetworkAgentInfo networkAgentInfo2 = nai;
            synchronized (networkAgentInfo2) {
                lp = nai.linkProperties;
                netId = nai.network.netId;
            }
            boolean ok = this.addLegacyRouteToHost(lp, addr, netId, uid);
            ConnectivityService.log("requestRouteToHostAddress ok=" + ok);
            boolean bl = ok;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean addLegacyRouteToHost(LinkProperties lp, InetAddress addr, int netId, int uid) {
        RouteInfo bestRoute = RouteInfo.selectBestRoute(lp.getAllRoutes(), addr);
        if (bestRoute == null) {
            bestRoute = RouteInfo.makeHostRoute(addr, lp.getInterfaceName());
        } else {
            String iface = bestRoute.getInterface();
            bestRoute = bestRoute.getGateway().equals(addr) ? RouteInfo.makeHostRoute(addr, iface) : RouteInfo.makeHostRoute(addr, bestRoute.getGateway(), iface);
        }
        ConnectivityService.log("Adding " + bestRoute + " for interface " + bestRoute.getInterface());
        try {
            this.mNetd.addLegacyRouteForNetId(netId, bestRoute, uid);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception trying to add a route: " + e);
            return false;
        }
        return true;
    }

    private void enforceCrossUserPermission(int userId) {
        if (userId == UserHandle.getCallingUserId()) {
            return;
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", TAG);
    }

    private void enforceInternetPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.INTERNET", TAG);
    }

    private void enforceAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceChangePermission() {
        int uid = Binder.getCallingUid();
        Settings.checkAndNoteChangeNetworkStateOperation(this.mContext, uid, Settings.getPackageNameForUid(this.mContext, uid), true);
    }

    private void enforceTetherAccessPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_NETWORK_STATE", TAG);
    }

    private void enforceConnectivityInternalPermission() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.CONNECTIVITY_INTERNAL", TAG);
    }

    public void sendConnectedBroadcast(NetworkInfo info) {
        this.enforceConnectivityInternalPermission();
        this.sendGeneralBroadcast(info, "android.net.conn.CONNECTIVITY_CHANGE");
    }

    private void sendInetConditionBroadcast(NetworkInfo info) {
        this.sendGeneralBroadcast(info, "android.net.conn.INET_CONDITION_ACTION");
    }

    private Intent makeGeneralIntent(NetworkInfo info, String bcastType) {
        if (this.mLockdownTracker != null) {
            info = this.mLockdownTracker.augmentNetworkInfo(info);
        }
        Intent intent = new Intent(bcastType);
        intent.putExtra("networkInfo", new NetworkInfo(info));
        intent.putExtra("networkType", info.getType());
        if (info.isFailover()) {
            intent.putExtra("isFailover", true);
            info.setFailover(false);
        }
        if (info.getReason() != null) {
            intent.putExtra("reason", info.getReason());
        }
        if (info.getExtraInfo() != null) {
            intent.putExtra("extraInfo", info.getExtraInfo());
        }
        intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
        return intent;
    }

    private void sendGeneralBroadcast(NetworkInfo info, String bcastType) {
        this.sendStickyBroadcast(this.makeGeneralIntent(info, bcastType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDataActivityBroadcast(int deviceType, boolean active, long tsNanos) {
        Intent intent = new Intent("android.net.conn.DATA_ACTIVITY_CHANGE");
        intent.putExtra("deviceType", deviceType);
        intent.putExtra("isActive", active);
        intent.putExtra("tsNanos", tsNanos);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, "android.permission.RECEIVE_DATA_ACTIVITY_CHANGE", null, null, 0, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStickyBroadcast(Intent intent) {
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (!this.mSystemReady) {
                this.mInitialBroadcast = new Intent(intent);
            }
            intent.addFlags(0x4000000);
            ConnectivityService.log("sendStickyBroadcast: action=" + intent.getAction());
            long ident = Binder.clearCallingIdentity();
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                IBatteryStats bs = BatteryStatsService.getService();
                try {
                    NetworkInfo ni = (NetworkInfo)intent.getParcelableExtra("networkInfo");
                    bs.noteConnectivityChanged(intent.getIntExtra("networkType", -1), ni != null ? ni.getState().toString() : "?");
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            try {
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void systemReady() {
        this.loadGlobalProxy();
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            this.mSystemReady = true;
            if (this.mInitialBroadcast != null) {
                this.mContext.sendStickyBroadcastAsUser(this.mInitialBroadcast, UserHandle.ALL);
                this.mInitialBroadcast = null;
            }
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(9));
        if (!this.updateLockdownVpn()) {
            IntentFilter filter = new IntentFilter("android.intent.action.USER_PRESENT");
            this.mContext.registerReceiver(this.mUserPresentReceiver, filter);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(30));
        this.mHandler.sendMessage(this.mHandler.obtainMessage(25));
        this.mPermissionMonitor.startMonitoring();
    }

    private void setupDataActivityTracking(NetworkAgentInfo networkAgent) {
        int timeout;
        String iface = networkAgent.linkProperties.getInterfaceName();
        int type = -1;
        if (networkAgent.networkCapabilities.hasTransport(0)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_mobile", 10);
            type = 0;
        } else if (networkAgent.networkCapabilities.hasTransport(1)) {
            timeout = Settings.Global.getInt(this.mContext.getContentResolver(), "data_activity_timeout_wifi", 15);
            type = 1;
        } else {
            timeout = 0;
        }
        if (timeout > 0 && iface != null && type != -1) {
            try {
                this.mNetd.addIdleTimer(iface, timeout, type);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setupDataActivityTracking " + e);
            }
        }
    }

    private void removeDataActivityTracking(NetworkAgentInfo networkAgent) {
        String iface = networkAgent.linkProperties.getInterfaceName();
        NetworkCapabilities caps = networkAgent.networkCapabilities;
        if (iface != null && (caps.hasTransport(0) || caps.hasTransport(1))) {
            try {
                this.mNetd.removeIdleTimer(iface);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeDataActivityTracking " + e);
            }
        }
    }

    private void updateMtu(LinkProperties newLp, LinkProperties oldLp) {
        String iface = newLp.getInterfaceName();
        int mtu = newLp.getMtu();
        if (oldLp != null && newLp.isIdenticalMtu(oldLp)) {
            return;
        }
        if (!LinkProperties.isValidMtu(mtu, newLp.hasGlobalIPv6Address())) {
            ConnectivityService.loge("Unexpected mtu value: " + mtu + ", " + iface);
            return;
        }
        if (TextUtils.isEmpty(iface)) {
            ConnectivityService.loge("Setting MTU size with null iface.");
            return;
        }
        try {
            ConnectivityService.log("Setting MTU size: " + iface + ", " + mtu);
            this.mNetd.setMtu(iface, mtu);
        }
        catch (Exception e) {
            Slog.e(TAG, "exception in setMtu()" + e);
        }
    }

    protected int getDefaultTcpRwnd() {
        return SystemProperties.getInt(DEFAULT_TCP_RWND_KEY, 0);
    }

    private void updateTcpBufferSizes(NetworkAgentInfo nai) {
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        String tcpBufferSizes = nai.linkProperties.getTcpBufferSizes();
        String[] values = null;
        if (tcpBufferSizes != null) {
            values = tcpBufferSizes.split(",");
        }
        if (values == null || values.length != 6) {
            ConnectivityService.log("Invalid tcpBufferSizes string: " + tcpBufferSizes + ", using defaults");
            tcpBufferSizes = DEFAULT_TCP_BUFFER_SIZES;
            values = tcpBufferSizes.split(",");
        }
        if (tcpBufferSizes.equals(this.mCurrentTcpBufferSizes)) {
            return;
        }
        try {
            Slog.d(TAG, "Setting tx/rx TCP buffers to " + tcpBufferSizes);
            String prefix = "/sys/kernel/ipv4/tcp_";
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_min", values[0]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_def", values[1]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_rmem_max", values[2]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_min", values[3]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_def", values[4]);
            FileUtils.stringToFile("/sys/kernel/ipv4/tcp_wmem_max", values[5]);
            this.mCurrentTcpBufferSizes = tcpBufferSizes;
        }
        catch (IOException e) {
            ConnectivityService.loge("Can't set TCP buffer sizes:" + e);
        }
        Integer rwndValue = Settings.Global.getInt(this.mContext.getContentResolver(), "tcp_default_init_rwnd", this.getDefaultTcpRwnd());
        String sysctlKey = "sys.sysctl.tcp_def_init_rwnd";
        if (rwndValue != 0) {
            SystemProperties.set("sys.sysctl.tcp_def_init_rwnd", rwndValue.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushVmDnsCache() {
        Intent intent = new Intent("android.intent.action.CLEAR_DNS_CACHE");
        intent.addFlags(0x20000000);
        intent.addFlags(0x4000000);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public int getRestoreDefaultNetworkDelay(int networkType) {
        String restoreDefaultNetworkDelayStr = SystemProperties.get(NETWORK_RESTORE_DELAY_PROP_NAME);
        if (restoreDefaultNetworkDelayStr != null && restoreDefaultNetworkDelayStr.length() != 0) {
            try {
                return Integer.valueOf(restoreDefaultNetworkDelayStr);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int ret = 60000;
        if (networkType <= 17 && this.mNetConfigs[networkType] != null) {
            ret = this.mNetConfigs[networkType].restoreTime;
        }
        return ret;
    }

    private boolean argsContain(String[] args, String target) {
        for (String arg : args) {
            if (!arg.equals(target)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ConnectivityService from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        ArrayList<NetworkDiagnostics> netDiags = new ArrayList<NetworkDiagnostics>();
        if (this.argsContain(args, "--diag")) {
            long DIAG_TIME_MS = 5000L;
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                netDiags.add(new NetworkDiagnostics(nai.network, new LinkProperties(nai.linkProperties), 5000L));
            }
            for (NetworkDiagnostics netDiag : netDiags) {
                pw.println();
                netDiag.waitForMeasurements();
                netDiag.dump(pw);
            }
            return;
        }
        pw.print("NetworkFactories for:");
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            pw.print(" " + nfi.name);
        }
        pw.println();
        pw.println();
        NetworkAgentInfo defaultNai = this.getDefaultNetwork();
        pw.print("Active default network: ");
        if (defaultNai == null) {
            pw.println("none");
        } else {
            pw.println(defaultNai.network.netId);
        }
        pw.println();
        pw.println("Current Networks:");
        pw.increaseIndent();
        for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
            pw.println(nai.toString());
            pw.increaseIndent();
            pw.println("Requests:");
            pw.increaseIndent();
            for (int i = 0; i < nai.networkRequests.size(); ++i) {
                pw.println(nai.networkRequests.valueAt(i).toString());
            }
            pw.decreaseIndent();
            pw.println("Lingered:");
            pw.increaseIndent();
            for (NetworkRequest nr : nai.networkLingered) {
                pw.println(nr.toString());
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }
        pw.decreaseIndent();
        pw.println();
        pw.println("Network Requests:");
        pw.increaseIndent();
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            pw.println(nri.toString());
        }
        pw.println();
        pw.decreaseIndent();
        this.mLegacyTypeTracker.dump(pw);
        ConnectivityService i$ = this;
        synchronized (i$) {
            pw.print("mNetTransitionWakeLock: currently " + (this.mNetTransitionWakeLock.isHeld() ? "" : "not ") + "held");
            if (!TextUtils.isEmpty(this.mNetTransitionWakeLockCausedBy)) {
                pw.println(", last requested for " + this.mNetTransitionWakeLockCausedBy);
            } else {
                pw.println(", last requested never");
            }
        }
        pw.println();
        this.mTethering.dump(fd, pw, args);
        if (this.mInetLog != null && this.mInetLog.size() > 0) {
            pw.println();
            pw.println("Inet condition reports:");
            pw.increaseIndent();
            for (int i = 0; i < this.mInetLog.size(); ++i) {
                pw.println(this.mInetLog.get(i));
            }
            pw.decreaseIndent();
        }
        if (!this.argsContain(args, "--short")) {
            pw.println();
            ArrayDeque<Pair<Network, LocalLog.ReadOnlyLocalLog>> arrayDeque = this.mValidationLogs;
            synchronized (arrayDeque) {
                pw.println("mValidationLogs (most recent first):");
                for (Pair<Network, LocalLog.ReadOnlyLocalLog> p : this.mValidationLogs) {
                    pw.println(p.first);
                    pw.increaseIndent();
                    ((LocalLog.ReadOnlyLocalLog)p.second).dump(fd, pw, args);
                    pw.decreaseIndent();
                }
            }
            pw.println();
            pw.println("mNetworkRequestInfoLogs (most recent first):");
            pw.increaseIndent();
            this.mNetworkRequestInfoLogs.reverseDump(fd, pw, args);
            pw.decreaseIndent();
        }
    }

    private boolean isLiveNetworkAgent(NetworkAgentInfo nai, String msg) {
        if (nai.network == null) {
            return false;
        }
        NetworkAgentInfo officialNai = this.getNetworkAgentInfoForNetwork(nai.network);
        if (officialNai != null && officialNai.equals(nai)) {
            return true;
        }
        if (officialNai != null) {
            ConnectivityService.loge(msg + " - isLiveNetworkAgent found mismatched netId: " + officialNai + " - " + nai);
        }
        return false;
    }

    private boolean isRequest(NetworkRequest request) {
        return this.mNetworkRequests.get((Object)request).isRequest;
    }

    private void linger(NetworkAgentInfo nai) {
        nai.lingering = true;
        nai.networkMonitor.sendMessage(532483);
        this.notifyNetworkCallbacks(nai, 524291);
    }

    private void unlinger(NetworkAgentInfo nai) {
        nai.networkLingered.clear();
        if (!nai.lingering) {
            return;
        }
        nai.lingering = false;
        nai.networkMonitor.sendMessage(532481);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelHalfConnect(Message msg) {
        AsyncChannel ac = (AsyncChannel)msg.obj;
        if (this.mNetworkFactoryInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
                    if (!nri.isRequest) continue;
                    NetworkAgentInfo nai = this.mNetworkForRequestId.get(nri.request.requestId);
                    ac.sendMessage(536576, nai != null ? nai.getCurrentScore() : 0, 0, nri.request);
                }
            } else {
                ConnectivityService.loge("Error connecting NetworkFactory");
                this.mNetworkFactoryInfos.remove(msg.obj);
            }
        } else if (this.mNetworkAgentInfos.containsKey(msg.replyTo)) {
            if (msg.arg1 == 0) {
                this.mNetworkAgentInfos.get((Object)msg.replyTo).asyncChannel.sendMessage(69633);
            } else {
                ConnectivityService.loge("Error connecting NetworkAgent");
                NetworkAgentInfo nai = this.mNetworkAgentInfos.remove(msg.replyTo);
                if (nai != null) {
                    boolean wasDefault = this.isDefaultNetwork(nai);
                    SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
                    synchronized (sparseArray) {
                        this.mNetworkForNetId.remove(nai.network.netId);
                        this.mNetIdInUse.delete(nai.network.netId);
                    }
                    this.mLegacyTypeTracker.remove(nai, wasDefault);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAsyncChannelDisconnected(Message msg) {
        NetworkAgentInfo nai = this.mNetworkAgentInfos.get(msg.replyTo);
        if (nai != null) {
            boolean wasDefault;
            ConnectivityService.log(nai.name() + " got DISCONNECTED, was satisfying " + nai.networkRequests.size());
            if (nai.networkInfo.isConnected()) {
                nai.networkInfo.setDetailedState(NetworkInfo.DetailedState.DISCONNECTED, null, null);
            }
            if (wasDefault = this.isDefaultNetwork(nai)) {
                this.mDefaultInetConditionPublished = 0;
            }
            this.notifyIfacesChanged();
            this.notifyNetworkCallbacks(nai, 524292);
            nai.networkMonitor.sendMessage(532487);
            this.mNetworkAgentInfos.remove(msg.replyTo);
            this.updateClat(null, nai.linkProperties, nai);
            SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
            synchronized (sparseArray) {
                this.mNetworkForNetId.remove(nai.network.netId);
            }
            for (int i = 0; i < nai.networkRequests.size(); ++i) {
                NetworkRequest request = nai.networkRequests.valueAt(i);
                NetworkAgentInfo currentNetwork = this.mNetworkForRequestId.get(request.requestId);
                if (currentNetwork == null || currentNetwork.network.netId != nai.network.netId) continue;
                this.mNetworkForRequestId.remove(request.requestId);
                this.sendUpdatedScoreToFactories(request, 0);
            }
            if (nai.networkRequests.get(this.mDefaultRequest.requestId) != null) {
                this.removeDataActivityTracking(nai);
                this.notifyLockdownVpn(nai);
                this.requestNetworkTransitionWakelock(nai.name());
            }
            this.mLegacyTypeTracker.remove(nai, wasDefault);
            this.rematchAllNetworksAndRequests(null, 0);
            if (nai.created) {
                try {
                    this.mNetd.removeNetwork(nai.network.netId);
                }
                catch (Exception e) {
                    ConnectivityService.loge("Exception removing network: " + e);
                }
            }
            SparseArray<NetworkAgentInfo> sparseArray2 = this.mNetworkForNetId;
            synchronized (sparseArray2) {
                this.mNetIdInUse.delete(nai.network.netId);
            }
        }
        NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(msg.replyTo);
        if (nfi != null) {
            ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
        }
    }

    private NetworkRequestInfo findExistingNetworkRequestInfo(PendingIntent pendingIntent) {
        Intent intent = pendingIntent.getIntent();
        for (Map.Entry<NetworkRequest, NetworkRequestInfo> entry : this.mNetworkRequests.entrySet()) {
            PendingIntent existingPendingIntent = entry.getValue().mPendingIntent;
            if (existingPendingIntent == null || !existingPendingIntent.getIntent().filterEquals(intent)) continue;
            return entry.getValue();
        }
        return null;
    }

    private void handleRegisterNetworkRequestWithIntent(Message msg) {
        NetworkRequestInfo nri = (NetworkRequestInfo)msg.obj;
        NetworkRequestInfo existingRequest = this.findExistingNetworkRequestInfo(nri.mPendingIntent);
        if (existingRequest != null) {
            ConnectivityService.log("Replacing " + existingRequest.request + " with " + nri.request + " because their intents matched.");
            this.handleReleaseNetworkRequest(existingRequest.request, ConnectivityService.getCallingUid());
        }
        this.handleRegisterNetworkRequest(nri);
    }

    private void handleRegisterNetworkRequest(NetworkRequestInfo nri) {
        this.mNetworkRequests.put(nri.request, nri);
        this.mNetworkRequestInfoLogs.log("REGISTER " + nri);
        this.rematchAllNetworksAndRequests(null, 0);
        if (nri.isRequest && this.mNetworkForRequestId.get(nri.request.requestId) == null) {
            this.sendUpdatedScoreToFactories(nri.request, 0);
        }
    }

    private void handleReleaseNetworkRequestWithIntent(PendingIntent pendingIntent, int callingUid) {
        NetworkRequestInfo nri = this.findExistingNetworkRequestInfo(pendingIntent);
        if (nri != null) {
            this.handleReleaseNetworkRequest(nri.request, callingUid);
        }
    }

    private boolean unneeded(NetworkAgentInfo nai) {
        if (!nai.created || nai.isVPN() || nai.lingering) {
            return false;
        }
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            if (!nri.isRequest || !nai.satisfies(nri.request) || nai.networkRequests.get(nri.request.requestId) == null && this.mNetworkForRequestId.get(nri.request.requestId).getCurrentScore() >= nai.getCurrentScoreAsValidated()) continue;
            return false;
        }
        return true;
    }

    private void handleReleaseNetworkRequest(NetworkRequest request, int callingUid) {
        NetworkRequestInfo nri = this.mNetworkRequests.get(request);
        if (nri != null) {
            if (1000 != callingUid && nri.mUid != callingUid) {
                ConnectivityService.log("Attempt to release unowned NetworkRequest " + request);
                return;
            }
            ConnectivityService.log("releasing NetworkRequest " + request);
            nri.unlinkDeathRecipient();
            this.mNetworkRequests.remove(request);
            this.mNetworkRequestInfoLogs.log("RELEASE " + nri);
            if (nri.isRequest) {
                boolean wasKept = false;
                for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                    if (nai.networkRequests.get(nri.request.requestId) == null) continue;
                    nai.networkRequests.remove(nri.request.requestId);
                    ConnectivityService.log(" Removing from current network " + nai.name() + ", leaving " + nai.networkRequests.size() + " requests.");
                    if (this.unneeded(nai)) {
                        ConnectivityService.log("no live requests for " + nai.name() + "; disconnecting");
                        this.teardownUnneededNetwork(nai);
                        continue;
                    }
                    wasKept |= true;
                }
                NetworkAgentInfo nai = this.mNetworkForRequestId.get(nri.request.requestId);
                if (nai != null) {
                    this.mNetworkForRequestId.remove(nri.request.requestId);
                }
                if (nri.request.legacyType != -1 && nai != null) {
                    boolean doRemove = true;
                    if (wasKept) {
                        for (int i = 0; i < nai.networkRequests.size(); ++i) {
                            NetworkRequest otherRequest = nai.networkRequests.valueAt(i);
                            if (otherRequest.legacyType != nri.request.legacyType || !this.isRequest(otherRequest)) continue;
                            ConnectivityService.log(" still have other legacy request - leaving");
                            doRemove = false;
                        }
                    }
                    if (doRemove) {
                        this.mLegacyTypeTracker.remove(nri.request.legacyType, nai, false);
                    }
                }
                for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
                    nfi.asyncChannel.sendMessage(536577, nri.request);
                }
            } else {
                for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                    nai.networkRequests.remove(nri.request.requestId);
                }
            }
            this.callCallbackForRequest(nri, null, 524296);
        }
    }

    @Override
    public void setAcceptUnvalidated(Network network, boolean accept, boolean always) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(28, accept ? 1 : 0, always ? 1 : 0, network));
    }

    private void handleSetAcceptUnvalidated(Network network, boolean accept, boolean always) {
        ConnectivityService.log("handleSetAcceptUnvalidated network=" + network + " accept=" + accept + " always=" + always);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return;
        }
        if (nai.everValidated) {
            return;
        }
        if (!nai.networkMisc.explicitlySelected) {
            Slog.wtf(TAG, "BUG: setAcceptUnvalidated non non-explicitly selected network");
        }
        if (accept != nai.networkMisc.acceptUnvalidated) {
            int oldScore = nai.getCurrentScore();
            nai.networkMisc.acceptUnvalidated = accept;
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.sendUpdatedScoreToFactories(nai);
        }
        if (always) {
            nai.asyncChannel.sendMessage(528393, accept ? 1 : 0);
        }
        if (!accept) {
            nai.asyncChannel.sendMessage(528395);
            this.teardownUnneededNetwork(nai);
        }
    }

    private void scheduleUnvalidatedPrompt(NetworkAgentInfo nai) {
        ConnectivityService.log("scheduleUnvalidatedPrompt " + nai.network);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(29, nai.network), 8000L);
    }

    private void handlePromptUnvalidated(Network network) {
        ConnectivityService.log("handlePromptUnvalidated " + network);
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.everValidated || nai.everCaptivePortalDetected || !nai.networkMisc.explicitlySelected || nai.networkMisc.acceptUnvalidated) {
            return;
        }
        Intent intent = new Intent("android.net.conn.PROMPT_UNVALIDATED");
        intent.setData(Uri.fromParts("netId", Integer.toString(network.netId), null));
        intent.addFlags(0x10000000);
        intent.setClassName("com.android.settings", "com.android.settings.wifi.WifiNoInternetDialog");
        PendingIntent pendingIntent = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, UserHandle.CURRENT);
        this.setProvNotificationVisibleIntent(true, nai.network.netId, NotificationType.NO_INTERNET, nai.networkInfo.getType(), nai.networkInfo.getExtraInfo(), pendingIntent, true);
    }

    @Override
    public int tether(String iface) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.tether(iface);
        }
        return 3;
    }

    @Override
    public int untether(String iface) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.untether(iface);
        }
        return 3;
    }

    @Override
    public int getLastTetherError(String iface) {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getLastTetherError(iface);
        }
        return 3;
    }

    @Override
    public String[] getTetherableUsbRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableUsbRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableWifiRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableWifiRegexs();
        }
        return new String[0];
    }

    @Override
    public String[] getTetherableBluetoothRegexs() {
        this.enforceTetherAccessPermission();
        if (this.isTetheringSupported()) {
            return this.mTethering.getTetherableBluetoothRegexs();
        }
        return new String[0];
    }

    @Override
    public int setUsbTethering(boolean enable) {
        ConnectivityManager.enforceTetherChangePermission(this.mContext);
        if (this.isTetheringSupported()) {
            return this.mTethering.setUsbTethering(enable);
        }
        return 3;
    }

    @Override
    public String[] getTetherableIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetherableIfaces();
    }

    @Override
    public String[] getTetheredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getTetheredIfaces();
    }

    @Override
    public String[] getTetheringErroredIfaces() {
        this.enforceTetherAccessPermission();
        return this.mTethering.getErroredIfaces();
    }

    @Override
    public String[] getTetheredDhcpRanges() {
        this.enforceConnectivityInternalPermission();
        return this.mTethering.getTetheredDhcpRanges();
    }

    @Override
    public boolean isTetheringSupported() {
        this.enforceTetherAccessPermission();
        int defaultVal = SystemProperties.get("ro.tether.denied").equals("true") ? 0 : 1;
        boolean tetherEnabledInSettings = Settings.Global.getInt(this.mContext.getContentResolver(), "tether_supported", defaultVal) != 0 && !this.mUserManager.hasUserRestriction("no_config_tethering");
        return tetherEnabledInSettings && (this.mTethering.getTetherableUsbRegexs().length != 0 || this.mTethering.getTetherableWifiRegexs().length != 0 || this.mTethering.getTetherableBluetoothRegexs().length != 0) && this.mTethering.getUpstreamIfaceTypes().length != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestNetworkTransitionWakelock(String forWhom) {
        int serialNum = 0;
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            if (this.mNetTransitionWakeLock.isHeld()) {
                return;
            }
            serialNum = ++this.mNetTransitionWakeLockSerialNumber;
            this.mNetTransitionWakeLock.acquire();
            this.mNetTransitionWakeLockCausedBy = forWhom;
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(24, serialNum, 0), this.mNetTransitionWakeLockTimeout);
    }

    @Override
    public void reportInetCondition(int networkType, int percentage) {
        NetworkAgentInfo nai = this.mLegacyTypeTracker.getNetworkForType(networkType);
        if (nai == null) {
            return;
        }
        this.reportNetworkConnectivity(nai.network, percentage > 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportNetworkConnectivity(Network network, boolean hasConnectivity) {
        this.enforceAccessPermission();
        this.enforceInternetPermission();
        NetworkAgentInfo nai = network == null ? this.getDefaultNetwork() : this.getNetworkAgentInfoForNetwork(network);
        if (nai == null || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTING || nai.networkInfo.getState() == NetworkInfo.State.DISCONNECTED) {
            return;
        }
        if (hasConnectivity == nai.lastValidated) {
            return;
        }
        int uid = Binder.getCallingUid();
        ConnectivityService.log("reportNetworkConnectivity(" + nai.network.netId + ", " + hasConnectivity + ") by " + uid);
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            if (!nai.created) {
                return;
            }
            if (this.isNetworkWithLinkPropertiesBlocked(nai.linkProperties, uid)) {
                return;
            }
            nai.networkMonitor.sendMessage(532488, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProxyInfo getDefaultProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            ProxyInfo ret = this.mGlobalProxy;
            if (ret == null && !this.mDefaultProxyDisabled) {
                ret = this.mDefaultProxy;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getProxyForNetwork(Network network) {
        if (network == null) {
            return this.getDefaultProxy();
        }
        ProxyInfo globalProxy = this.getGlobalProxy();
        if (globalProxy != null) {
            return globalProxy;
        }
        if (!NetworkUtils.queryUserAccess(Binder.getCallingUid(), network.netId)) {
            return null;
        }
        NetworkAgentInfo nai = this.getNetworkAgentInfoForNetwork(network);
        if (nai == null) {
            return null;
        }
        NetworkAgentInfo networkAgentInfo = nai;
        synchronized (networkAgentInfo) {
            ProxyInfo proxyInfo = nai.linkProperties.getHttpProxy();
            if (proxyInfo == null) {
                return null;
            }
            return new ProxyInfo(proxyInfo);
        }
    }

    private ProxyInfo canonicalizeProxyInfo(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && (proxy.getPacFileUrl() == null || Uri.EMPTY.equals(proxy.getPacFileUrl()))) {
            proxy = null;
        }
        return proxy;
    }

    private boolean proxyInfoEqual(ProxyInfo a, ProxyInfo b) {
        return Objects.equals(a = this.canonicalizeProxyInfo(a), b = this.canonicalizeProxyInfo(b)) && (a == null || Objects.equals(a.getHost(), b.getHost()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setGlobalProxy(ProxyInfo proxyProperties) {
        this.enforceConnectivityInternalPermission();
        Object object = this.mProxyLock;
        synchronized (object) {
            if (proxyProperties == this.mGlobalProxy) {
                return;
            }
            if (proxyProperties != null && proxyProperties.equals(this.mGlobalProxy)) {
                return;
            }
            if (this.mGlobalProxy != null && this.mGlobalProxy.equals(proxyProperties)) {
                return;
            }
            String host = "";
            int port = 0;
            String exclList = "";
            String pacFileUrl = "";
            if (!(proxyProperties == null || TextUtils.isEmpty(proxyProperties.getHost()) && Uri.EMPTY.equals(proxyProperties.getPacFileUrl()))) {
                if (!proxyProperties.isValid()) {
                    ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                    return;
                }
                this.mGlobalProxy = new ProxyInfo(proxyProperties);
                host = this.mGlobalProxy.getHost();
                port = this.mGlobalProxy.getPort();
                exclList = this.mGlobalProxy.getExclusionListAsString();
                if (!Uri.EMPTY.equals(proxyProperties.getPacFileUrl())) {
                    pacFileUrl = proxyProperties.getPacFileUrl().toString();
                }
            } else {
                this.mGlobalProxy = null;
            }
            ContentResolver res = this.mContext.getContentResolver();
            long token = Binder.clearCallingIdentity();
            try {
                Settings.Global.putString(res, "global_http_proxy_host", host);
                Settings.Global.putInt(res, "global_http_proxy_port", port);
                Settings.Global.putString(res, "global_http_proxy_exclusion_list", exclList);
                Settings.Global.putString(res, "global_proxy_pac_url", pacFileUrl);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            if (this.mGlobalProxy == null) {
                proxyProperties = this.mDefaultProxy;
            }
            this.sendProxyBroadcast(proxyProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadGlobalProxy() {
        ContentResolver res = this.mContext.getContentResolver();
        String host = Settings.Global.getString(res, "global_http_proxy_host");
        int port = Settings.Global.getInt(res, "global_http_proxy_port", 0);
        String exclList = Settings.Global.getString(res, "global_http_proxy_exclusion_list");
        String pacFileUrl = Settings.Global.getString(res, "global_proxy_pac_url");
        if (!TextUtils.isEmpty(host) || !TextUtils.isEmpty(pacFileUrl)) {
            ProxyInfo proxyProperties = !TextUtils.isEmpty(pacFileUrl) ? new ProxyInfo(pacFileUrl) : new ProxyInfo(host, port, exclList);
            if (!proxyProperties.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxyProperties.toString());
                return;
            }
            Object object = this.mProxyLock;
            synchronized (object) {
                this.mGlobalProxy = proxyProperties;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxyInfo getGlobalProxy() {
        Object object = this.mProxyLock;
        synchronized (object) {
            return this.mGlobalProxy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyDefaultProxy(ProxyInfo proxy) {
        if (proxy != null && TextUtils.isEmpty(proxy.getHost()) && Uri.EMPTY.equals(proxy.getPacFileUrl())) {
            proxy = null;
        }
        Object object = this.mProxyLock;
        synchronized (object) {
            if (this.mDefaultProxy != null && this.mDefaultProxy.equals(proxy)) {
                return;
            }
            if (this.mDefaultProxy == proxy) {
                return;
            }
            if (proxy != null && !proxy.isValid()) {
                ConnectivityService.log("Invalid proxy properties, ignoring: " + proxy.toString());
                return;
            }
            if (this.mGlobalProxy != null && proxy != null && !Uri.EMPTY.equals(proxy.getPacFileUrl()) && proxy.getPacFileUrl().equals(this.mGlobalProxy.getPacFileUrl())) {
                this.mGlobalProxy = proxy;
                this.sendProxyBroadcast(this.mGlobalProxy);
                return;
            }
            this.mDefaultProxy = proxy;
            if (this.mGlobalProxy != null) {
                return;
            }
            if (!this.mDefaultProxyDisabled) {
                this.sendProxyBroadcast(proxy);
            }
        }
    }

    private void updateProxy(LinkProperties newLp, LinkProperties oldLp, NetworkAgentInfo nai) {
        ProxyInfo oldProxyInfo;
        ProxyInfo newProxyInfo = newLp == null ? null : newLp.getHttpProxy();
        ProxyInfo proxyInfo = oldProxyInfo = oldLp == null ? null : oldLp.getHttpProxy();
        if (!this.proxyInfoEqual(newProxyInfo, oldProxyInfo)) {
            this.sendProxyBroadcast(this.getDefaultProxy());
        }
    }

    private void handleDeprecatedGlobalHttpProxy() {
        String proxy = Settings.Global.getString(this.mContext.getContentResolver(), "http_proxy");
        if (!TextUtils.isEmpty(proxy)) {
            String[] data = proxy.split(":");
            if (data.length == 0) {
                return;
            }
            String proxyHost = data[0];
            int proxyPort = 8080;
            if (data.length > 1) {
                try {
                    proxyPort = Integer.parseInt(data[1]);
                }
                catch (NumberFormatException e) {
                    return;
                }
            }
            ProxyInfo p = new ProxyInfo(data[0], proxyPort, "");
            this.setGlobalProxy(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendProxyBroadcast(ProxyInfo proxy) {
        if (proxy == null) {
            proxy = new ProxyInfo("", 0, "");
        }
        if (this.mPacManager.setCurrentProxyScriptUrl(proxy)) {
            return;
        }
        ConnectivityService.log("sending Proxy Broadcast for " + proxy);
        Intent intent = new Intent("android.intent.action.PROXY_CHANGE");
        intent.addFlags(0x24000000);
        intent.putExtra("android.intent.extra.PROXY_INFO", proxy);
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    private static void log(String s) {
        Slog.d(TAG, s);
    }

    private static void loge(String s) {
        Slog.e(TAG, s);
    }

    private static <T> T checkNotNull(T value, String message) {
        if (value == null) {
            throw new NullPointerException(message);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareVpn(String oldPackage, String newPackage, int userId) {
        this.enforceCrossUserPermission(userId);
        this.throwIfLockdownEnabled();
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.prepare(oldPackage, newPackage);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVpnPackageAuthorization(String packageName, int userId, boolean authorized) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                vpn.setPackageAuthorization(packageName, authorized);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor establishVpn(VpnConfig config) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).establish(config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLegacyVpn(VpnProfile profile) {
        this.throwIfLockdownEnabled();
        LinkProperties egress = this.getActiveLinkProperties();
        if (egress == null) {
            throw new IllegalStateException("Missing active network connection");
        }
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            this.mVpns.get(user).startLegacyVpn(profile, this.mKeyStore, egress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LegacyVpnInfo getLegacyVpnInfo(int userId) {
        this.enforceCrossUserPermission(userId);
        if (this.mLockdownEnabled) {
            return null;
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(userId).getLegacyVpnInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnInfo[] getAllVpnInfo() {
        this.enforceConnectivityInternalPermission();
        if (this.mLockdownEnabled) {
            return new VpnInfo[0];
        }
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            ArrayList<VpnInfo> infoList = new ArrayList<VpnInfo>();
            for (int i = 0; i < this.mVpns.size(); ++i) {
                VpnInfo info = this.createVpnInfo(this.mVpns.valueAt(i));
                if (info == null) continue;
                infoList.add(info);
            }
            return infoList.toArray(new VpnInfo[infoList.size()]);
        }
    }

    private VpnInfo createVpnInfo(Vpn vpn) {
        LinkProperties linkProperties;
        VpnInfo info = vpn.getVpnInfo();
        if (info == null) {
            return null;
        }
        Network[] underlyingNetworks = vpn.getUnderlyingNetworks();
        if (underlyingNetworks == null) {
            NetworkAgentInfo defaultNetwork = this.getDefaultNetwork();
            if (defaultNetwork != null && defaultNetwork.linkProperties != null) {
                info.primaryUnderlyingIface = this.getDefaultNetwork().linkProperties.getInterfaceName();
            }
        } else if (underlyingNetworks.length > 0 && (linkProperties = this.getLinkProperties(underlyingNetworks[0])) != null) {
            info.primaryUnderlyingIface = linkProperties.getInterfaceName();
        }
        return info.primaryUnderlyingIface == null ? null : info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VpnConfig getVpnConfig(int userId) {
        this.enforceCrossUserPermission(userId);
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn vpn = this.mVpns.get(userId);
            if (vpn != null) {
                return vpn.getVpnConfig();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateLockdownVpn() {
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Lockdown VPN only available to AID_SYSTEM");
            return false;
        }
        this.mLockdownEnabled = LockdownVpnTracker.isEnabled();
        if (this.mLockdownEnabled) {
            if (!this.mKeyStore.isUnlocked()) {
                Slog.w(TAG, "KeyStore locked; unable to create LockdownTracker");
                return false;
            }
            String profileName = new String(this.mKeyStore.get("LOCKDOWN_VPN"));
            VpnProfile profile = VpnProfile.decode(profileName, this.mKeyStore.get("VPN_" + profileName));
            int user = UserHandle.getUserId(Binder.getCallingUid());
            SparseArray<Vpn> sparseArray = this.mVpns;
            synchronized (sparseArray) {
                this.setLockdownTracker(new LockdownVpnTracker(this.mContext, this.mNetd, this, this.mVpns.get(user), profile));
            }
        } else {
            this.setLockdownTracker(null);
        }
        return true;
    }

    private void setLockdownTracker(LockdownVpnTracker tracker) {
        LockdownVpnTracker existing = this.mLockdownTracker;
        this.mLockdownTracker = null;
        if (existing != null) {
            existing.shutdown();
        }
        try {
            if (tracker != null) {
                this.mNetd.setFirewallEnabled(true);
                this.mNetd.setFirewallInterfaceRule("lo", true);
                this.mLockdownTracker = tracker;
                this.mLockdownTracker.init();
            } else {
                this.mNetd.setFirewallEnabled(false);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void throwIfLockdownEnabled() {
        if (this.mLockdownEnabled) {
            throw new IllegalStateException("Unavailable in lockdown mode");
        }
    }

    @Override
    public int checkMobileProvisioning(int suggestedTimeOutMs) {
        return -1;
    }

    private void setProvNotificationVisible(boolean visible, int networkType, String action) {
        ConnectivityService.log("setProvNotificationVisible: E visible=" + visible + " networkType=" + networkType + " action=" + action);
        Intent intent = new Intent(action);
        PendingIntent pendingIntent = PendingIntent.getBroadcast(this.mContext, 0, intent, 0);
        int id2 = 65536 + (networkType - -1);
        this.setProvNotificationVisibleIntent(visible, id2, NotificationType.SIGN_IN, networkType, null, pendingIntent, false);
    }

    private void setProvNotificationVisibleIntent(boolean visible, int id2, NotificationType notifyType, int networkType, String extraInfo, PendingIntent intent, boolean highPriority) {
        ConnectivityService.log("setProvNotificationVisibleIntent " + (Object)((Object)notifyType) + " visible=" + visible + " networkType=" + ConnectivityManager.getNetworkTypeName(networkType) + " extraInfo=" + extraInfo + " highPriority=" + highPriority);
        Resources r = Resources.getSystem();
        NotificationManager notificationManager = (NotificationManager)this.mContext.getSystemService("notification");
        if (visible) {
            int icon;
            String details;
            String title;
            if (notifyType == NotificationType.NO_INTERNET && networkType == 1) {
                title = r.getString(17040277, 0);
                details = r.getString(17040278);
                icon = 17303105;
            } else if (notifyType == NotificationType.SIGN_IN) {
                switch (networkType) {
                    case 1: {
                        title = r.getString(17040274, 0);
                        details = r.getString(17040276, extraInfo);
                        icon = 17303105;
                        break;
                    }
                    case 0: 
                    case 5: {
                        title = r.getString(17040275, 0);
                        details = this.mTelephonyManager.getNetworkOperatorName();
                        icon = 17303101;
                        break;
                    }
                    default: {
                        title = r.getString(17040275, 0);
                        details = r.getString(17040276, extraInfo);
                        icon = 17303101;
                        break;
                    }
                }
            } else {
                Slog.wtf(TAG, "Unknown notification type " + (Object)((Object)notifyType) + "on network type " + ConnectivityManager.getNetworkTypeName(networkType));
                return;
            }
            Notification notification = new Notification.Builder(this.mContext).setWhen(0L).setSmallIcon(icon).setAutoCancel(true).setTicker(title).setColor(this.mContext.getColor(17170521)).setContentTitle(title).setContentText(details).setContentIntent(intent).setLocalOnly(true).setPriority(highPriority ? 1 : 0).setDefaults(-1).setOnlyAlertOnce(true).build();
            try {
                notificationManager.notify(NOTIFICATION_ID, id2, notification);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificationVisible: visible notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        } else {
            try {
                notificationManager.cancel(NOTIFICATION_ID, id2);
            }
            catch (NullPointerException npe) {
                ConnectivityService.loge("setNotificationVisible: cancel notificationManager npe=" + npe);
                npe.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getProvisioningUrlBaseFromFile() {
        block28: {
            String element;
            FileReader fileReader = null;
            XmlPullParser parser = null;
            Configuration config = this.mContext.getResources().getConfiguration();
            try {
                fileReader = new FileReader(this.mProvisioningUrlFile);
                parser = Xml.newPullParser();
                parser.setInput(fileReader);
                XmlUtils.beginDocument(parser, TAG_PROVISIONING_URLS);
                while (true) {
                    XmlUtils.nextElement(parser);
                    element = parser.getName();
                    if (element == null) break;
                    if (!element.equals(TAG_PROVISIONING_URL)) continue;
                    String mcc = parser.getAttributeValue(null, ATTR_MCC);
                    try {
                        String mnc;
                        if (mcc != null && Integer.parseInt(mcc) == config.mcc && (mnc = parser.getAttributeValue(null, ATTR_MNC)) != null && Integer.parseInt(mnc) == config.mnc) {
                            parser.next();
                            if (parser.getEventType() == 4) {
                                String string2 = parser.getText();
                                return string2;
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        ConnectivityService.loge("NumberFormatException in getProvisioningUrlBaseFromFile: " + e);
                    }
                }
                element = null;
            }
            catch (FileNotFoundException e) {
                ConnectivityService.loge("Carrier Provisioning Urls file not found");
                break block28;
            }
            catch (XmlPullParserException e) {
                ConnectivityService.loge("Xml parser exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            catch (IOException e) {
                ConnectivityService.loge("I/O exception reading Carrier Provisioning Urls file: " + e);
                break block28;
            }
            finally {
                if (fileReader != null) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException e) {}
                }
            }
            return element;
        }
        return null;
    }

    @Override
    public String getMobileProvisioningUrl() {
        this.enforceConnectivityInternalPermission();
        String url = this.getProvisioningUrlBaseFromFile();
        if (TextUtils.isEmpty(url)) {
            url = this.mContext.getResources().getString(17039407);
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioining_url from resource =" + url);
        } else {
            ConnectivityService.log("getMobileProvisioningUrl: mobile_provisioning_url from File =" + url);
        }
        if (!TextUtils.isEmpty(url)) {
            String phoneNumber = this.mTelephonyManager.getLine1Number();
            if (TextUtils.isEmpty(phoneNumber)) {
                phoneNumber = "0000000000";
            }
            url = String.format(url, this.mTelephonyManager.getSimSerialNumber(), this.mTelephonyManager.getDeviceId(), phoneNumber);
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProvisioningNotificationVisible(boolean visible, int networkType, String action) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            this.setProvNotificationVisible(visible, networkType, action);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAirplaneMode(boolean enable) {
        this.enforceConnectivityInternalPermission();
        long ident = Binder.clearCallingIdentity();
        try {
            ContentResolver cr = this.mContext.getContentResolver();
            Settings.Global.putInt(cr, "airplane_mode_on", enable ? 1 : 0);
            Intent intent = new Intent("android.intent.action.AIRPLANE_MODE");
            intent.putExtra("state", enable);
            this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStart(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn != null) {
                ConnectivityService.loge("Starting user already has a VPN");
                return;
            }
            userVpn = new Vpn(this.mHandler.getLooper(), this.mContext, this.mNetd, userId);
            this.mVpns.put(userId, userVpn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStop(int userId) {
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            Vpn userVpn = this.mVpns.get(userId);
            if (userVpn == null) {
                ConnectivityService.loge("Stopping user has no VPN");
                return;
            }
            this.mVpns.delete(userId);
        }
    }

    private void ensureImmutableCapabilities(NetworkCapabilities networkCapabilities) {
        if (networkCapabilities.hasCapability(16)) {
            throw new IllegalArgumentException("Cannot request network with NET_CAPABILITY_VALIDATED");
        }
        if (networkCapabilities.hasCapability(17)) {
            throw new IllegalArgumentException("Cannot request network with NET_CAPABILITY_CAPTIVE_PORTAL");
        }
    }

    @Override
    public NetworkRequest requestNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, int timeoutMs, IBinder binder, int legacyType) {
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        this.enforceNetworkRequestPermissions(networkCapabilities);
        this.enforceMeteredApnPolicy(networkCapabilities);
        this.ensureImmutableCapabilities(networkCapabilities);
        if (timeoutMs < 0 || timeoutMs > 6000000) {
            throw new IllegalArgumentException("Bad timeout specified");
        }
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, legacyType, this.nextNetworkRequestId());
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder, true);
        ConnectivityService.log("requestNetwork for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(19, nri));
        if (timeoutMs > 0) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(20, nri), timeoutMs);
        }
        return networkRequest;
    }

    private void enforceNetworkRequestPermissions(NetworkCapabilities networkCapabilities) {
        if (!networkCapabilities.hasCapability(13)) {
            this.enforceConnectivityInternalPermission();
        } else {
            this.enforceChangePermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requestBandwidthUpdate(Network network) {
        this.enforceAccessPermission();
        NetworkAgentInfo nai = null;
        if (network == null) {
            return false;
        }
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            nai = this.mNetworkForNetId.get(network.netId);
        }
        if (nai != null) {
            nai.asyncChannel.sendMessage(528394);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enforceMeteredApnPolicy(NetworkCapabilities networkCapabilities) {
        if (!networkCapabilities.hasCapability(11)) {
            int uidRules;
            int uid = Binder.getCallingUid();
            Object object = this.mRulesLock;
            synchronized (object) {
                uidRules = this.mUidRules.get(uid, 0);
            }
            if ((uidRules & 3) != 0) {
                networkCapabilities.addCapability(11);
            }
        }
    }

    @Override
    public NetworkRequest pendingRequestForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        ConnectivityService.checkNotNull(operation, "PendingIntent cannot be null.");
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        this.enforceNetworkRequestPermissions(networkCapabilities);
        this.enforceMeteredApnPolicy(networkCapabilities);
        this.ensureImmutableCapabilities(networkCapabilities);
        NetworkRequest networkRequest = new NetworkRequest(networkCapabilities, -1, this.nextNetworkRequestId());
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation, true);
        ConnectivityService.log("pendingRequest for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(26, nri));
        return networkRequest;
    }

    private void releasePendingNetworkRequestWithDelay(PendingIntent operation) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation), this.mReleasePendingIntentDelayMs);
    }

    @Override
    public void releasePendingNetworkRequest(PendingIntent operation) {
        ConnectivityService.checkNotNull(operation, "PendingIntent cannot be null.");
        this.mHandler.sendMessage(this.mHandler.obtainMessage(27, ConnectivityService.getCallingUid(), 0, operation));
    }

    private boolean hasWifiNetworkListenPermission(NetworkCapabilities nc) {
        if (nc == null) {
            return false;
        }
        int[] transportTypes = nc.getTransportTypes();
        if (transportTypes.length != 1 || transportTypes[0] != 1) {
            return false;
        }
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.ACCESS_WIFI_STATE", TAG);
        }
        catch (SecurityException e) {
            return false;
        }
        return true;
    }

    @Override
    public NetworkRequest listenForNetwork(NetworkCapabilities networkCapabilities, Messenger messenger, IBinder binder) {
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        NetworkRequest networkRequest = new NetworkRequest(new NetworkCapabilities(networkCapabilities), -1, this.nextNetworkRequestId());
        NetworkRequestInfo nri = new NetworkRequestInfo(messenger, networkRequest, binder, false);
        ConnectivityService.log("listenForNetwork for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
        return networkRequest;
    }

    @Override
    public void pendingListenForNetwork(NetworkCapabilities networkCapabilities, PendingIntent operation) {
        ConnectivityService.checkNotNull(operation, "PendingIntent cannot be null.");
        if (!this.hasWifiNetworkListenPermission(networkCapabilities)) {
            this.enforceAccessPermission();
        }
        NetworkRequest networkRequest = new NetworkRequest(new NetworkCapabilities(networkCapabilities), -1, this.nextNetworkRequestId());
        NetworkRequestInfo nri = new NetworkRequestInfo(networkRequest, operation, false);
        ConnectivityService.log("pendingListenForNetwork for " + nri);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(21, nri));
    }

    @Override
    public void releaseNetworkRequest(NetworkRequest networkRequest) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(22, ConnectivityService.getCallingUid(), 0, networkRequest));
    }

    @Override
    public void registerNetworkFactory(Messenger messenger, String name) {
        this.enforceConnectivityInternalPermission();
        NetworkFactoryInfo nfi = new NetworkFactoryInfo(name, messenger, new AsyncChannel());
        this.mHandler.sendMessage(this.mHandler.obtainMessage(17, nfi));
    }

    private void handleRegisterNetworkFactory(NetworkFactoryInfo nfi) {
        ConnectivityService.log("Got NetworkFactory Messenger for " + nfi.name);
        this.mNetworkFactoryInfos.put(nfi.messenger, nfi);
        nfi.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, nfi.messenger);
    }

    @Override
    public void unregisterNetworkFactory(Messenger messenger) {
        this.enforceConnectivityInternalPermission();
        this.mHandler.sendMessage(this.mHandler.obtainMessage(23, messenger));
    }

    private void handleUnregisterNetworkFactory(Messenger messenger) {
        NetworkFactoryInfo nfi = this.mNetworkFactoryInfos.remove(messenger);
        if (nfi == null) {
            ConnectivityService.loge("Failed to find Messenger in unregisterNetworkFactory");
            return;
        }
        ConnectivityService.log("unregisterNetworkFactory for " + nfi.name);
    }

    private NetworkAgentInfo getDefaultNetwork() {
        return this.mNetworkForRequestId.get(this.mDefaultRequest.requestId);
    }

    private boolean isDefaultNetwork(NetworkAgentInfo nai) {
        return nai == this.getDefaultNetwork();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int registerNetworkAgent(Messenger messenger, NetworkInfo networkInfo, LinkProperties linkProperties, NetworkCapabilities networkCapabilities, int currentScore, NetworkMisc networkMisc) {
        this.enforceConnectivityInternalPermission();
        NetworkAgentInfo nai = new NetworkAgentInfo(messenger, new AsyncChannel(), new Network(this.reserveNetId()), new NetworkInfo(networkInfo), new LinkProperties(linkProperties), new NetworkCapabilities(networkCapabilities), currentScore, this.mContext, this.mTrackerHandler, new NetworkMisc(networkMisc), this.mDefaultRequest, this);
        ConnectivityService connectivityService = this;
        synchronized (connectivityService) {
            nai.networkMonitor.systemReady = this.mSystemReady;
        }
        this.addValidationLogs(nai.networkMonitor.getValidationLogs(), nai.network);
        ConnectivityService.log("registerNetworkAgent " + nai);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(18, nai));
        return nai.network.netId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegisterNetworkAgent(NetworkAgentInfo na) {
        this.mNetworkAgentInfos.put(na.messenger, na);
        SparseArray<NetworkAgentInfo> sparseArray = this.mNetworkForNetId;
        synchronized (sparseArray) {
            this.mNetworkForNetId.put(na.network.netId, na);
        }
        na.asyncChannel.connect(this.mContext, (Handler)this.mTrackerHandler, na.messenger);
        NetworkInfo networkInfo = na.networkInfo;
        na.networkInfo = null;
        this.updateNetworkInfo(na, networkInfo);
    }

    private void updateLinkProperties(NetworkAgentInfo networkAgent, LinkProperties oldLp) {
        LinkProperties newLp = networkAgent.linkProperties;
        int netId = networkAgent.network.netId;
        if (networkAgent.clatd != null) {
            networkAgent.clatd.fixupLinkProperties(oldLp);
        }
        this.updateInterfaces(newLp, oldLp, netId);
        this.updateMtu(newLp, oldLp);
        this.updateTcpBufferSizes(networkAgent);
        boolean useDefaultDns = false;
        boolean flushDns = this.updateRoutes(newLp, oldLp, netId);
        this.updateDnses(newLp, oldLp, netId, flushDns, false);
        this.updateClat(newLp, oldLp, networkAgent);
        if (this.isDefaultNetwork(networkAgent)) {
            this.handleApplyDefaultProxy(newLp.getHttpProxy());
        } else {
            this.updateProxy(newLp, oldLp, networkAgent);
        }
        if (!Objects.equals(newLp, oldLp)) {
            this.notifyIfacesChanged();
            this.notifyNetworkCallbacks(networkAgent, 524295);
        }
    }

    private void updateClat(LinkProperties newLp, LinkProperties oldLp, NetworkAgentInfo nai) {
        boolean wasRunningClat = nai.clatd != null && nai.clatd.isStarted();
        boolean shouldRunClat = Nat464Xlat.requiresClat(nai);
        if (!wasRunningClat && shouldRunClat) {
            nai.clatd = new Nat464Xlat(this.mContext, this.mNetd, this.mTrackerHandler, nai);
            nai.clatd.start();
        } else if (wasRunningClat && !shouldRunClat) {
            nai.clatd.stop();
        }
    }

    private void updateInterfaces(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<Object> interfaceDiff = new LinkProperties.CompareResult();
        if (oldLp != null) {
            interfaceDiff = oldLp.compareAllInterfaceNames(newLp);
        } else if (newLp != null) {
            interfaceDiff.added = newLp.getAllInterfaceNames();
        }
        for (String iface : interfaceDiff.added) {
            try {
                ConnectivityService.log("Adding iface " + iface + " to network " + netId);
                this.mNetd.addInterfaceToNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception adding interface: " + e);
            }
        }
        for (String iface : interfaceDiff.removed) {
            try {
                ConnectivityService.log("Removing iface " + iface + " from network " + netId);
                this.mNetd.removeInterfaceFromNetwork(iface, netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception removing interface: " + e);
            }
        }
    }

    private boolean updateRoutes(LinkProperties newLp, LinkProperties oldLp, int netId) {
        LinkProperties.CompareResult<Object> routeDiff = new LinkProperties.CompareResult();
        if (oldLp != null) {
            routeDiff = oldLp.compareAllRoutes(newLp);
        } else if (newLp != null) {
            routeDiff.added = newLp.getAllRoutes();
        }
        for (RouteInfo route : routeDiff.added) {
            if (route.hasGateway()) continue;
            ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getDestination().getAddress() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for non-gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.added) {
            if (!route.hasGateway()) continue;
            ConnectivityService.log("Adding Route [" + route + "] to network " + netId);
            try {
                this.mNetd.addRoute(netId, route);
            }
            catch (Exception e) {
                if (!(route.getGateway() instanceof Inet4Address)) continue;
                ConnectivityService.loge("Exception in addRoute for gateway: " + e);
            }
        }
        for (RouteInfo route : routeDiff.removed) {
            ConnectivityService.log("Removing Route [" + route + "] from network " + netId);
            try {
                this.mNetd.removeRoute(netId, route);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in removeRoute: " + e);
            }
        }
        return !routeDiff.added.isEmpty() || !routeDiff.removed.isEmpty();
    }

    private void updateDnses(LinkProperties newLp, LinkProperties oldLp, int netId, boolean flush, boolean useDefaultDns) {
        if (oldLp == null || !newLp.isIdenticalDnses(oldLp)) {
            List<InetAddress> dnses = newLp.getDnsServers();
            if (dnses.size() == 0 && this.mDefaultDns != null && useDefaultDns) {
                dnses = new ArrayList<InetAddress>();
                dnses.add(this.mDefaultDns);
                ConnectivityService.loge("no dns provided for netId " + netId + ", so using defaults");
            }
            ConnectivityService.log("Setting Dns servers for network " + netId + " to " + dnses);
            try {
                this.mNetd.setDnsServersForNetwork(netId, NetworkUtils.makeStrings(dnses), newLp.getDomains());
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in setDnsServersForNetwork: " + e);
            }
            NetworkAgentInfo defaultNai = this.getDefaultNetwork();
            if (defaultNai != null && defaultNai.network.netId == netId) {
                this.setDefaultDnsSystemProperties(dnses);
            }
            this.flushVmDnsCache();
        } else if (flush) {
            try {
                this.mNetd.flushNetworkDnsCache(netId);
            }
            catch (Exception e) {
                ConnectivityService.loge("Exception in flushNetworkDnsCache: " + e);
            }
            this.flushVmDnsCache();
        }
    }

    private void setDefaultDnsSystemProperties(Collection<InetAddress> dnses) {
        int last = 0;
        for (InetAddress dns : dnses) {
            String key = "net.dns" + ++last;
            String value = dns.getHostAddress();
            SystemProperties.set(key, value);
        }
        for (int i = last + 1; i <= this.mNumDnsEntries; ++i) {
            String key = "net.dns" + i;
            SystemProperties.set(key, "");
        }
        this.mNumDnsEntries = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCapabilities(NetworkAgentInfo nai, NetworkCapabilities networkCapabilities) {
        networkCapabilities = new NetworkCapabilities(networkCapabilities);
        if (nai.lastValidated) {
            networkCapabilities.addCapability(16);
        } else {
            networkCapabilities.removeCapability(16);
        }
        if (nai.lastCaptivePortalDetected) {
            networkCapabilities.addCapability(17);
        } else {
            networkCapabilities.removeCapability(17);
        }
        if (!Objects.equals(nai.networkCapabilities, networkCapabilities)) {
            int oldScore = nai.getCurrentScore();
            if (nai.networkCapabilities.hasCapability(13) != networkCapabilities.hasCapability(13)) {
                try {
                    this.mNetd.setNetworkPermission(nai.network.netId, networkCapabilities.hasCapability(13) ? null : "SYSTEM");
                }
                catch (RemoteException e) {
                    ConnectivityService.loge("Exception in setNetworkPermission: " + e);
                }
            }
            NetworkAgentInfo networkAgentInfo = nai;
            synchronized (networkAgentInfo) {
                nai.networkCapabilities = networkCapabilities;
            }
            this.rematchAllNetworksAndRequests(nai, oldScore);
            this.notifyNetworkCallbacks(nai, 524294);
        }
    }

    private void sendUpdatedScoreToFactories(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.networkRequests.size(); ++i) {
            NetworkRequest nr = nai.networkRequests.valueAt(i);
            if (!this.isRequest(nr)) continue;
            this.sendUpdatedScoreToFactories(nr, nai.getCurrentScore());
        }
    }

    private void sendUpdatedScoreToFactories(NetworkRequest networkRequest, int score) {
        for (NetworkFactoryInfo nfi : this.mNetworkFactoryInfos.values()) {
            nfi.asyncChannel.sendMessage(536576, score, 0, networkRequest);
        }
    }

    private void sendPendingIntentForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType) {
        if (notificationType == 524290 && !nri.mPendingIntentSent) {
            Intent intent = new Intent();
            intent.putExtra("android.net.extra.NETWORK", networkAgent.network);
            intent.putExtra("android.net.extra.NETWORK_REQUEST", nri.request);
            nri.mPendingIntentSent = true;
            this.sendIntent(nri.mPendingIntent, intent);
        }
    }

    private void sendIntent(PendingIntent pendingIntent, Intent intent) {
        this.mPendingIntentWakeLock.acquire();
        try {
            ConnectivityService.log("Sending " + pendingIntent);
            pendingIntent.send(this.mContext, 0, intent, this, null);
        }
        catch (PendingIntent.CanceledException e) {
            ConnectivityService.log(pendingIntent + " was not sent, it had been canceled.");
            this.mPendingIntentWakeLock.release();
            this.releasePendingNetworkRequest(pendingIntent);
        }
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        ConnectivityService.log("Finished sending " + pendingIntent);
        this.mPendingIntentWakeLock.release();
        this.releasePendingNetworkRequestWithDelay(pendingIntent);
    }

    private void callCallbackForRequest(NetworkRequestInfo nri, NetworkAgentInfo networkAgent, int notificationType) {
        if (nri.messenger == null) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putParcelable(NetworkRequest.class.getSimpleName(), new NetworkRequest(nri.request));
        Message msg = Message.obtain();
        if (notificationType != 524293 && notificationType != 524296) {
            bundle.putParcelable(Network.class.getSimpleName(), networkAgent.network);
        }
        switch (notificationType) {
            case 524291: {
                msg.arg1 = 30000;
                break;
            }
            case 524294: {
                bundle.putParcelable(NetworkCapabilities.class.getSimpleName(), new NetworkCapabilities(networkAgent.networkCapabilities));
                break;
            }
            case 524295: {
                bundle.putParcelable(LinkProperties.class.getSimpleName(), new LinkProperties(networkAgent.linkProperties));
            }
        }
        msg.what = notificationType;
        msg.setData(bundle);
        try {
            nri.messenger.send(msg);
        }
        catch (RemoteException e) {
            ConnectivityService.loge("RemoteException caught trying to send a callback msg for " + nri.request);
        }
    }

    private void teardownUnneededNetwork(NetworkAgentInfo nai) {
        for (int i = 0; i < nai.networkRequests.size(); ++i) {
            NetworkRequest nr = nai.networkRequests.valueAt(i);
            if (!this.isRequest(nr)) continue;
            ConnectivityService.loge("Dead network still had at least " + nr);
            break;
        }
        nai.asyncChannel.disconnect();
    }

    private void handleLingerComplete(NetworkAgentInfo oldNetwork) {
        if (oldNetwork == null) {
            ConnectivityService.loge("Unknown NetworkAgentInfo in handleLingerComplete");
            return;
        }
        ConnectivityService.log("handleLingerComplete for " + oldNetwork.name());
        this.teardownUnneededNetwork(oldNetwork);
    }

    private void makeDefault(NetworkAgentInfo newNetwork) {
        ConnectivityService.log("Switching to new default network: " + newNetwork);
        this.setupDataActivityTracking(newNetwork);
        try {
            this.mNetd.setDefaultNetId(newNetwork.network.netId);
        }
        catch (Exception e) {
            ConnectivityService.loge("Exception setting default network :" + e);
        }
        this.notifyLockdownVpn(newNetwork);
        this.handleApplyDefaultProxy(newNetwork.linkProperties.getHttpProxy());
        this.updateTcpBufferSizes(newNetwork);
        this.setDefaultDnsSystemProperties(newNetwork.linkProperties.getDnsServers());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rematchNetworkAndRequests(NetworkAgentInfo newNetwork, ReapUnvalidatedNetworks reapUnvalidatedNetworks) {
        if (!newNetwork.created) {
            return;
        }
        boolean keep = newNetwork.isVPN();
        boolean isNewDefault = false;
        NetworkAgentInfo oldDefaultNetwork = null;
        ConnectivityService.log("rematching " + newNetwork.name());
        ArrayList<NetworkAgentInfo> affectedNetworks = new ArrayList<NetworkAgentInfo>();
        ArrayList<NetworkRequestInfo> addedRequests = new ArrayList<NetworkRequestInfo>();
        for (NetworkRequestInfo nri : this.mNetworkRequests.values()) {
            NetworkAgentInfo currentNetwork = this.mNetworkForRequestId.get(nri.request.requestId);
            boolean satisfies = newNetwork.satisfies(nri.request);
            if (newNetwork == currentNetwork && satisfies) {
                keep = true;
                continue;
            }
            if (satisfies) {
                if (!nri.isRequest) {
                    if (!newNetwork.addRequest(nri.request)) continue;
                    addedRequests.add(nri);
                    continue;
                }
                if (currentNetwork != null && currentNetwork.getCurrentScore() >= newNetwork.getCurrentScore()) continue;
                if (currentNetwork != null) {
                    ConnectivityService.log("   accepting network in place of " + currentNetwork.name());
                    currentNetwork.networkRequests.remove(nri.request.requestId);
                    currentNetwork.networkLingered.add(nri.request);
                    affectedNetworks.add(currentNetwork);
                } else {
                    ConnectivityService.log("   accepting network in place of null");
                }
                this.unlinger(newNetwork);
                this.mNetworkForRequestId.put(nri.request.requestId, newNetwork);
                if (!newNetwork.addRequest(nri.request)) {
                    Slog.wtf(TAG, "BUG: " + newNetwork.name() + " already has " + nri.request);
                }
                addedRequests.add(nri);
                keep = true;
                this.sendUpdatedScoreToFactories(nri.request, newNetwork.getCurrentScore());
                if (this.mDefaultRequest.requestId != nri.request.requestId) continue;
                isNewDefault = true;
                oldDefaultNetwork = currentNetwork;
                continue;
            }
            if (newNetwork.networkRequests.get(nri.request.requestId) == null) continue;
            ConnectivityService.log("Network " + newNetwork.name() + " stopped satisfying" + " request " + nri.request.requestId);
            newNetwork.networkRequests.remove(nri.request.requestId);
            if (currentNetwork == newNetwork) {
                this.mNetworkForRequestId.remove(nri.request.requestId);
                this.sendUpdatedScoreToFactories(nri.request, 0);
            } else if (nri.isRequest) {
                Slog.wtf(TAG, "BUG: Removing request " + nri.request.requestId + " from " + newNetwork.name() + " without updating mNetworkForRequestId or factories!");
            }
            this.callCallbackForRequest(nri, newNetwork, 524292);
        }
        for (NetworkAgentInfo nai : affectedNetworks) {
            if (nai.lingering) continue;
            if (this.unneeded(nai)) {
                this.linger(nai);
                continue;
            }
            this.unlinger(nai);
        }
        if (isNewDefault) {
            this.makeDefault(newNetwork);
            ConnectivityService i$ = this;
            synchronized (i$) {
                if (this.mNetTransitionWakeLock.isHeld()) {
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(8, this.mNetTransitionWakeLockSerialNumber, 0), 1000L);
                }
            }
        }
        for (NetworkRequestInfo nri : addedRequests) {
            this.notifyNetworkCallback(newNetwork, nri);
        }
        if (isNewDefault) {
            if (oldDefaultNetwork != null) {
                this.mLegacyTypeTracker.remove(oldDefaultNetwork.networkInfo.getType(), oldDefaultNetwork, true);
            }
            this.mDefaultInetConditionPublished = newNetwork.lastValidated ? 100 : 0;
            this.mLegacyTypeTracker.add(newNetwork.networkInfo.getType(), newNetwork);
            this.notifyLockdownVpn(newNetwork);
        }
        if (keep) {
            try {
                IBatteryStats bs = BatteryStatsService.getService();
                int type = newNetwork.networkInfo.getType();
                String baseIface = newNetwork.linkProperties.getInterfaceName();
                bs.noteNetworkInterfaceType(baseIface, type);
                for (LinkProperties stacked : newNetwork.linkProperties.getStackedLinks()) {
                    String stackedIface = stacked.getInterfaceName();
                    bs.noteNetworkInterfaceType(stackedIface, type);
                    NetworkStatsFactory.noteStackedIface(stackedIface, baseIface);
                }
            }
            catch (RemoteException ignored) {
                // empty catch block
            }
            for (int i = 0; i < newNetwork.networkRequests.size(); ++i) {
                NetworkRequest nr = newNetwork.networkRequests.valueAt(i);
                if (nr.legacyType == -1 || !this.isRequest(nr)) continue;
                this.mLegacyTypeTracker.add(nr.legacyType, newNetwork);
            }
            if (newNetwork.isVPN()) {
                this.mLegacyTypeTracker.add(17, newNetwork);
            }
        }
        if (reapUnvalidatedNetworks == ReapUnvalidatedNetworks.REAP) {
            for (NetworkAgentInfo nai : this.mNetworkAgentInfos.values()) {
                if (!this.unneeded(nai)) continue;
                ConnectivityService.log("Reaping " + nai.name());
                this.teardownUnneededNetwork(nai);
            }
        }
    }

    private void rematchAllNetworksAndRequests(NetworkAgentInfo changed, int oldScore) {
        if (changed != null && oldScore < changed.getCurrentScore()) {
            this.rematchNetworkAndRequests(changed, ReapUnvalidatedNetworks.REAP);
        } else {
            Object[] nais = this.mNetworkAgentInfos.values().toArray(new NetworkAgentInfo[this.mNetworkAgentInfos.size()]);
            Arrays.sort(nais);
            for (Object nai : nais) {
                this.rematchNetworkAndRequests((NetworkAgentInfo)nai, nai != nais[nais.length - 1] ? ReapUnvalidatedNetworks.DONT_REAP : ReapUnvalidatedNetworks.REAP);
            }
        }
    }

    private void updateInetCondition(NetworkAgentInfo nai) {
        int newInetCondition;
        if (!nai.everValidated) {
            return;
        }
        if (!this.isDefaultNetwork(nai)) {
            return;
        }
        int n = newInetCondition = nai.lastValidated ? 100 : 0;
        if (newInetCondition == this.mDefaultInetConditionPublished) {
            return;
        }
        this.mDefaultInetConditionPublished = newInetCondition;
        this.sendInetConditionBroadcast(nai.networkInfo);
    }

    private void notifyLockdownVpn(NetworkAgentInfo nai) {
        if (this.mLockdownTracker != null) {
            if (nai != null && nai.isVPN()) {
                this.mLockdownTracker.onVpnStateChanged(nai.networkInfo);
            } else {
                this.mLockdownTracker.onNetworkInfoChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkInfo(NetworkAgentInfo networkAgent, NetworkInfo newInfo) {
        NetworkInfo.State state = newInfo.getState();
        NetworkInfo oldInfo = null;
        int oldScore = networkAgent.getCurrentScore();
        Object object = networkAgent;
        synchronized (object) {
            oldInfo = networkAgent.networkInfo;
            networkAgent.networkInfo = newInfo;
        }
        this.notifyLockdownVpn(networkAgent);
        if (oldInfo != null && oldInfo.getState() == state) {
            return;
        }
        ConnectivityService.log(networkAgent.name() + " EVENT_NETWORK_INFO_CHANGED, going from " + (oldInfo == null ? "null" : oldInfo.getState()) + " to " + (Object)((Object)state));
        if (state == NetworkInfo.State.CONNECTED && !networkAgent.created) {
            try {
                if (networkAgent.isVPN()) {
                    this.mNetd.createVirtualNetwork(networkAgent.network.netId, !networkAgent.linkProperties.getDnsServers().isEmpty(), networkAgent.networkMisc == null || !networkAgent.networkMisc.allowBypass);
                } else {
                    this.mNetd.createPhysicalNetwork(networkAgent.network.netId, networkAgent.networkCapabilities.hasCapability(13) ? null : "SYSTEM");
                }
            }
            catch (Exception e) {
                ConnectivityService.loge("Error creating network " + networkAgent.network.netId + ": " + e.getMessage());
                return;
            }
            networkAgent.created = true;
            this.updateLinkProperties(networkAgent, null);
            this.notifyIfacesChanged();
            networkAgent.networkMonitor.sendMessage(532481);
            this.scheduleUnvalidatedPrompt(networkAgent);
            if (networkAgent.isVPN()) {
                object = this.mProxyLock;
                synchronized (object) {
                    if (!this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = true;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(null);
                        }
                    }
                }
            }
            this.rematchNetworkAndRequests(networkAgent, ReapUnvalidatedNetworks.REAP);
            this.notifyNetworkCallbacks(networkAgent, 524289);
        } else if (state == NetworkInfo.State.DISCONNECTED) {
            networkAgent.asyncChannel.disconnect();
            if (networkAgent.isVPN()) {
                object = this.mProxyLock;
                synchronized (object) {
                    if (this.mDefaultProxyDisabled) {
                        this.mDefaultProxyDisabled = false;
                        if (this.mGlobalProxy == null && this.mDefaultProxy != null) {
                            this.sendProxyBroadcast(this.mDefaultProxy);
                        }
                    }
                }
            }
        } else if (oldInfo != null && oldInfo.getState() == NetworkInfo.State.SUSPENDED || state == NetworkInfo.State.SUSPENDED) {
            if (networkAgent.getCurrentScore() != oldScore) {
                this.rematchAllNetworksAndRequests(networkAgent, oldScore);
            }
            this.notifyNetworkCallbacks(networkAgent, state == NetworkInfo.State.SUSPENDED ? 524299 : 524300);
            this.mLegacyTypeTracker.update(networkAgent);
        }
    }

    private void updateNetworkScore(NetworkAgentInfo nai, int score) {
        ConnectivityService.log("updateNetworkScore for " + nai.name() + " to " + score);
        if (score < 0) {
            ConnectivityService.loge("updateNetworkScore for " + nai.name() + " got a negative score (" + score + ").  Bumping score to min of 0");
            score = 0;
        }
        int oldScore = nai.getCurrentScore();
        nai.setCurrentScore(score);
        this.rematchAllNetworksAndRequests(nai, oldScore);
        this.sendUpdatedScoreToFactories(nai);
    }

    protected void notifyNetworkCallback(NetworkAgentInfo nai, NetworkRequestInfo nri) {
        int notifyType = 524290;
        if (nri.mPendingIntent == null) {
            this.callCallbackForRequest(nri, nai, notifyType);
        } else {
            this.sendPendingIntentForRequest(nri, nai, notifyType);
        }
    }

    private void sendLegacyNetworkBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type) {
        NetworkInfo info = new NetworkInfo(nai.networkInfo);
        info.setType(type);
        if (state != NetworkInfo.DetailedState.DISCONNECTED) {
            info.setDetailedState(state, null, info.getExtraInfo());
            this.sendConnectedBroadcast(info);
        } else {
            info.setDetailedState(state, info.getReason(), info.getExtraInfo());
            Intent intent = new Intent("android.net.conn.CONNECTIVITY_CHANGE");
            intent.putExtra("networkInfo", info);
            intent.putExtra("networkType", info.getType());
            if (info.isFailover()) {
                intent.putExtra("isFailover", true);
                nai.networkInfo.setFailover(false);
            }
            if (info.getReason() != null) {
                intent.putExtra("reason", info.getReason());
            }
            if (info.getExtraInfo() != null) {
                intent.putExtra("extraInfo", info.getExtraInfo());
            }
            NetworkAgentInfo newDefaultAgent = null;
            if (nai.networkRequests.get(this.mDefaultRequest.requestId) != null) {
                newDefaultAgent = this.getDefaultNetwork();
                if (newDefaultAgent != null) {
                    intent.putExtra("otherNetwork", newDefaultAgent.networkInfo);
                } else {
                    intent.putExtra("noConnectivity", true);
                }
            }
            intent.putExtra("inetCondition", this.mDefaultInetConditionPublished);
            this.sendStickyBroadcast(intent);
            if (newDefaultAgent != null) {
                this.sendConnectedBroadcast(newDefaultAgent.networkInfo);
            }
        }
    }

    protected void notifyNetworkCallbacks(NetworkAgentInfo networkAgent, int notifyType) {
        ConnectivityService.log("notifyType " + this.notifyTypeToName(notifyType) + " for " + networkAgent.name());
        for (int i = 0; i < networkAgent.networkRequests.size(); ++i) {
            NetworkRequest nr = networkAgent.networkRequests.valueAt(i);
            NetworkRequestInfo nri = this.mNetworkRequests.get(nr);
            if (nri.mPendingIntent == null) {
                this.callCallbackForRequest(nri, networkAgent, notifyType);
                continue;
            }
            this.sendPendingIntentForRequest(nri, networkAgent, notifyType);
        }
    }

    private String notifyTypeToName(int notifyType) {
        switch (notifyType) {
            case 524289: {
                return "PRECHECK";
            }
            case 524290: {
                return "AVAILABLE";
            }
            case 524291: {
                return "LOSING";
            }
            case 524292: {
                return "LOST";
            }
            case 524293: {
                return "UNAVAILABLE";
            }
            case 524294: {
                return "CAP_CHANGED";
            }
            case 524295: {
                return "IP_CHANGED";
            }
            case 524296: {
                return "RELEASED";
            }
        }
        return "UNKNOWN";
    }

    private void notifyIfacesChanged() {
        try {
            this.mStatsService.forceUpdateIfaces();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addVpnAddress(String address, int prefixLength) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).addAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeVpnAddress(String address, int prefixLength) {
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            return this.mVpns.get(user).removeAddress(address, prefixLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setUnderlyingNetworksForVpn(Network[] networks) {
        boolean success;
        this.throwIfLockdownEnabled();
        int user = UserHandle.getUserId(Binder.getCallingUid());
        SparseArray<Vpn> sparseArray = this.mVpns;
        synchronized (sparseArray) {
            success = this.mVpns.get(user).setUnderlyingNetworks(networks);
        }
        if (success) {
            this.notifyIfacesChanged();
        }
        return success;
    }

    @Override
    public void factoryReset() {
        VpnConfig vpnConfig;
        this.enforceConnectivityInternalPermission();
        if (this.mUserManager.hasUserRestriction("no_network_reset")) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        this.setAirplaneMode(false);
        if (!this.mUserManager.hasUserRestriction("no_config_tethering")) {
            for (String tether : this.getTetheredIfaces()) {
                this.untether(tether);
            }
        }
        if (!this.mUserManager.hasUserRestriction("no_config_vpn") && (vpnConfig = this.getVpnConfig(userId)) != null) {
            if (vpnConfig.legacy) {
                this.prepareVpn("[Legacy VPN]", "[Legacy VPN]", userId);
            } else {
                this.setVpnPackageAuthorization(vpnConfig.user, userId, false);
                this.prepareVpn(vpnConfig.user, "[Legacy VPN]", userId);
            }
        }
    }

    public NetworkMonitor createNetworkMonitor(Context context, Handler handler, NetworkAgentInfo nai, NetworkRequest defaultRequest) {
        return new NetworkMonitor(context, handler, nai, defaultRequest);
    }

    private class NetworkRequestInfo
    implements IBinder.DeathRecipient {
        static final boolean REQUEST = true;
        static final boolean LISTEN = false;
        final NetworkRequest request;
        final PendingIntent mPendingIntent;
        boolean mPendingIntentSent;
        private final IBinder mBinder;
        final int mPid;
        final int mUid;
        final Messenger messenger;
        final boolean isRequest;

        NetworkRequestInfo(NetworkRequest r, PendingIntent pi, boolean isRequest) {
            this.request = r;
            this.mPendingIntent = pi;
            this.messenger = null;
            this.mBinder = null;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.isRequest = isRequest;
        }

        NetworkRequestInfo(Messenger m, NetworkRequest r, IBinder binder, boolean isRequest) {
            this.messenger = m;
            this.request = r;
            this.mBinder = binder;
            this.mPid = Binder.getCallingPid();
            this.mUid = Binder.getCallingUid();
            this.isRequest = isRequest;
            this.mPendingIntent = null;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        void unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        @Override
        public void binderDied() {
            ConnectivityService.log("ConnectivityService NetworkRequestInfo binderDied(" + this.request + ", " + this.mBinder + ")");
            ConnectivityService.this.releaseNetworkRequest(this.request);
        }

        public String toString() {
            return (this.isRequest ? "Request" : "Listen") + " from uid/pid:" + this.mUid + "/" + this.mPid + " for " + this.request + (this.mPendingIntent == null ? "" : " to trigger " + this.mPendingIntent);
        }
    }

    private static class NetworkFactoryInfo {
        public final String name;
        public final Messenger messenger;
        public final AsyncChannel asyncChannel;

        public NetworkFactoryInfo(String name, Messenger messenger, AsyncChannel asyncChannel) {
            this.name = name;
            this.messenger = messenger;
            this.asyncChannel = asyncChannel;
        }
    }

    private static enum NotificationType {
        SIGN_IN,
        NO_INTERNET;

    }

    private static class SettingsObserver
    extends ContentObserver {
        private final HashMap<Uri, Integer> mUriEventMap = new HashMap();
        private final Context mContext;
        private final Handler mHandler;

        SettingsObserver(Context context, Handler handler) {
            super(null);
            this.mContext = context;
            this.mHandler = handler;
        }

        void observe(Uri uri, int what) {
            this.mUriEventMap.put(uri, what);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(uri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            Slog.wtf(ConnectivityService.TAG, "Should never be reached.");
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Integer what = this.mUriEventMap.get(uri);
            if (what != null) {
                this.mHandler.obtainMessage(what).sendToTarget();
            } else {
                ConnectivityService.loge("No matching event to send for URI=" + uri);
            }
        }
    }

    private class InternalHandler
    extends Handler {
        public InternalHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 8: 
                case 24: {
                    String causedBy = null;
                    ConnectivityService connectivityService = ConnectivityService.this;
                    synchronized (connectivityService) {
                        if (msg.arg1 != ConnectivityService.this.mNetTransitionWakeLockSerialNumber || !ConnectivityService.this.mNetTransitionWakeLock.isHeld()) {
                            break;
                        }
                        ConnectivityService.this.mNetTransitionWakeLock.release();
                        causedBy = ConnectivityService.this.mNetTransitionWakeLockCausedBy;
                    }
                    if (msg.what == 24) {
                        ConnectivityService.log("Failed to find a new network - expiring NetTransition Wakelock");
                        break;
                    }
                    ConnectivityService.log("NetTransition Wakelock (" + (causedBy == null ? "unknown" : causedBy) + " cleared because we found a replacement network");
                    break;
                }
                case 9: {
                    ConnectivityService.this.handleDeprecatedGlobalHttpProxy();
                    break;
                }
                case 11: {
                    Intent intent = (Intent)msg.obj;
                    ConnectivityService.this.sendStickyBroadcast(intent);
                    break;
                }
                case 16: {
                    ConnectivityService.this.handleApplyDefaultProxy((ProxyInfo)msg.obj);
                    break;
                }
                case 17: {
                    ConnectivityService.this.handleRegisterNetworkFactory((NetworkFactoryInfo)msg.obj);
                    break;
                }
                case 23: {
                    ConnectivityService.this.handleUnregisterNetworkFactory((Messenger)msg.obj);
                    break;
                }
                case 18: {
                    ConnectivityService.this.handleRegisterNetworkAgent((NetworkAgentInfo)msg.obj);
                    break;
                }
                case 19: 
                case 21: {
                    ConnectivityService.this.handleRegisterNetworkRequest((NetworkRequestInfo)msg.obj);
                    break;
                }
                case 26: 
                case 31: {
                    ConnectivityService.this.handleRegisterNetworkRequestWithIntent(msg);
                    break;
                }
                case 27: {
                    ConnectivityService.this.handleReleaseNetworkRequestWithIntent((PendingIntent)msg.obj, msg.arg1);
                    break;
                }
                case 22: {
                    ConnectivityService.this.handleReleaseNetworkRequest((NetworkRequest)msg.obj, msg.arg1);
                    break;
                }
                case 28: {
                    ConnectivityService.this.handleSetAcceptUnvalidated((Network)msg.obj, msg.arg1 != 0, msg.arg2 != 0);
                    break;
                }
                case 29: {
                    ConnectivityService.this.handlePromptUnvalidated((Network)msg.obj);
                    break;
                }
                case 30: {
                    ConnectivityService.this.handleMobileDataAlwaysOn();
                    break;
                }
                case 25: {
                    for (NetworkAgentInfo nai : ConnectivityService.this.mNetworkAgentInfos.values()) {
                        nai.networkMonitor.systemReady = true;
                    }
                    break;
                }
            }
        }
    }

    private class NetworkStateTrackerHandler
    extends Handler {
        public NetworkStateTrackerHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 69632: {
                    ConnectivityService.this.handleAsyncChannelHalfConnect(msg);
                    break;
                }
                case 69635: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) break;
                    nai.asyncChannel.disconnect();
                    break;
                }
                case 69636: {
                    ConnectivityService.this.handleAsyncChannelDisconnected(msg);
                    break;
                }
                case 528386: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_CAPABILITIES_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    NetworkCapabilities networkCapabilities = (NetworkCapabilities)msg.obj;
                    if (networkCapabilities.hasCapability(17) || networkCapabilities.hasCapability(16)) {
                        Slog.wtf(ConnectivityService.TAG, "BUG: " + nai + " has stateful capability.");
                    }
                    ConnectivityService.this.updateCapabilities(nai, networkCapabilities);
                    break;
                }
                case 528387: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("NetworkAgent not found for EVENT_NETWORK_PROPERTIES_CHANGED");
                        break;
                    }
                    LinkProperties oldLp = nai.linkProperties;
                    NetworkAgentInfo networkAgentInfo = nai;
                    synchronized (networkAgentInfo) {
                        nai.linkProperties = (LinkProperties)msg.obj;
                    }
                    if (!nai.created) break;
                    ConnectivityService.this.updateLinkProperties(nai, oldLp);
                    break;
                }
                case 528385: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_INFO_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    NetworkInfo info = (NetworkInfo)msg.obj;
                    ConnectivityService.this.updateNetworkInfo(nai, info);
                    break;
                }
                case 528388: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_NETWORK_SCORE_CHANGED from unknown NetworkAgent");
                        break;
                    }
                    Integer score = (Integer)msg.obj;
                    if (score == null) break;
                    ConnectivityService.this.updateNetworkScore(nai, score);
                    break;
                }
                case 528389: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_UID_RANGES_ADDED from unknown NetworkAgent");
                        break;
                    }
                    try {
                        ConnectivityService.this.mNetd.addVpnUidRanges(nai.network.netId, (UidRange[])msg.obj);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception in addVpnUidRanges: " + e);
                    }
                    break;
                }
                case 528390: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_UID_RANGES_REMOVED from unknown NetworkAgent");
                        break;
                    }
                    try {
                        ConnectivityService.this.mNetd.removeVpnUidRanges(nai.network.netId, (UidRange[])msg.obj);
                    }
                    catch (Exception e) {
                        ConnectivityService.loge("Exception in removeVpnUidRanges: " + e);
                    }
                    break;
                }
                case 528392: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkAgentInfos.get(msg.replyTo);
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_SET_EXPLICITLY_SELECTED from unknown NetworkAgent");
                        break;
                    }
                    if (nai.created && !nai.networkMisc.explicitlySelected) {
                        ConnectivityService.loge("ERROR: created network explicitly selected.");
                    }
                    nai.networkMisc.explicitlySelected = true;
                    nai.networkMisc.acceptUnvalidated = (Boolean)msg.obj;
                    break;
                }
                case 532482: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                    if (!ConnectivityService.this.isLiveNetworkAgent(nai, "EVENT_NETWORK_TESTED")) break;
                    boolean valid = msg.arg1 == 0;
                    ConnectivityService.log(nai.name() + " validation " + (valid ? " passed" : "failed"));
                    if (valid != nai.lastValidated) {
                        int oldScore = nai.getCurrentScore();
                        nai.lastValidated = valid;
                        nai.everValidated |= valid;
                        ConnectivityService.this.updateCapabilities(nai, nai.networkCapabilities);
                        if (oldScore != nai.getCurrentScore()) {
                            ConnectivityService.this.sendUpdatedScoreToFactories(nai);
                        }
                    }
                    ConnectivityService.this.updateInetCondition(nai);
                    nai.asyncChannel.sendMessage(528391, valid ? 1 : 2, 0, null);
                    break;
                }
                case 532485: {
                    NetworkAgentInfo nai = (NetworkAgentInfo)msg.obj;
                    if (!ConnectivityService.this.isLiveNetworkAgent(nai, "EVENT_NETWORK_LINGER_COMPLETE")) break;
                    ConnectivityService.this.handleLingerComplete(nai);
                    break;
                }
                case 532490: {
                    NetworkAgentInfo nai;
                    int netId = msg.arg2;
                    boolean visible = msg.arg1 != 0;
                    SparseArray sparseArray = ConnectivityService.this.mNetworkForNetId;
                    synchronized (sparseArray) {
                        nai = (NetworkAgentInfo)ConnectivityService.this.mNetworkForNetId.get(netId);
                    }
                    if (nai != null && visible != nai.lastCaptivePortalDetected) {
                        nai.lastCaptivePortalDetected = visible;
                        nai.everCaptivePortalDetected |= visible;
                        ConnectivityService.this.updateCapabilities(nai, nai.networkCapabilities);
                    }
                    if (!visible) {
                        ConnectivityService.this.setProvNotificationVisibleIntent(false, netId, null, 0, null, null, false);
                        break;
                    }
                    if (nai == null) {
                        ConnectivityService.loge("EVENT_PROVISIONING_NOTIFICATION from unknown NetworkMonitor");
                        break;
                    }
                    ConnectivityService.this.setProvNotificationVisibleIntent(true, netId, NotificationType.SIGN_IN, nai.networkInfo.getType(), nai.networkInfo.getExtraInfo(), (PendingIntent)msg.obj, nai.networkMisc.explicitlySelected);
                    break;
                }
            }
        }
    }

    private class LegacyTypeTracker {
        private static final boolean DBG = true;
        private static final boolean VDBG = false;
        private static final String TAG = "CSLegacyTypeTracker";
        private ArrayList<NetworkAgentInfo>[] mTypeLists = new ArrayList[18];

        public void addSupportedType(int type) {
            if (this.mTypeLists[type] != null) {
                throw new IllegalStateException("legacy list for type " + type + "already initialized");
            }
            this.mTypeLists[type] = new ArrayList();
        }

        public boolean isTypeSupported(int type) {
            return ConnectivityManager.isNetworkTypeValid(type) && this.mTypeLists[type] != null;
        }

        public NetworkAgentInfo getNetworkForType(int type) {
            if (this.isTypeSupported(type) && !this.mTypeLists[type].isEmpty()) {
                return this.mTypeLists[type].get(0);
            }
            return null;
        }

        private void maybeLogBroadcast(NetworkAgentInfo nai, NetworkInfo.DetailedState state, int type, boolean isDefaultNetwork) {
            this.log("Sending " + (Object)((Object)state) + " broadcast for type " + type + " " + nai.name() + " isDefaultNetwork=" + isDefaultNetwork);
        }

        public void add(int type, NetworkAgentInfo nai) {
            if (!this.isTypeSupported(type)) {
                return;
            }
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list.contains(nai)) {
                ConnectivityService.loge("Attempting to register duplicate agent for type " + type + ": " + nai);
                return;
            }
            list.add(nai);
            boolean isDefaultNetwork = ConnectivityService.this.isDefaultNetwork(nai);
            if (list.size() == 1 || isDefaultNetwork) {
                this.maybeLogBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type, isDefaultNetwork);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, NetworkInfo.DetailedState.CONNECTED, type);
            }
        }

        public void remove(int type, NetworkAgentInfo nai, boolean wasDefault) {
            ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
            if (list == null || list.isEmpty()) {
                return;
            }
            boolean wasFirstNetwork = list.get(0).equals(nai);
            if (!list.remove(nai)) {
                return;
            }
            NetworkInfo.DetailedState state = NetworkInfo.DetailedState.DISCONNECTED;
            if (wasFirstNetwork || wasDefault) {
                this.maybeLogBroadcast(nai, state, type, wasDefault);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, state, type);
            }
            if (!list.isEmpty() && wasFirstNetwork) {
                this.log("Other network available for type " + type + ", sending connected broadcast");
                NetworkAgentInfo replacement = list.get(0);
                this.maybeLogBroadcast(replacement, state, type, ConnectivityService.this.isDefaultNetwork(replacement));
                ConnectivityService.this.sendLegacyNetworkBroadcast(replacement, state, type);
            }
        }

        public void remove(NetworkAgentInfo nai, boolean wasDefault) {
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                this.remove(type, nai, wasDefault);
            }
        }

        public void update(NetworkAgentInfo nai) {
            boolean isDefault = ConnectivityService.this.isDefaultNetwork(nai);
            NetworkInfo.DetailedState state = nai.networkInfo.getDetailedState();
            for (int type = 0; type < this.mTypeLists.length; ++type) {
                boolean isFirst;
                ArrayList<NetworkAgentInfo> list = this.mTypeLists[type];
                boolean contains = list != null && list.contains(nai);
                boolean bl = isFirst = list != null && list.size() > 0 && nai == list.get(0);
                if (!isFirst && (!contains || !isDefault)) continue;
                this.maybeLogBroadcast(nai, state, type, isDefault);
                ConnectivityService.this.sendLegacyNetworkBroadcast(nai, state, type);
            }
        }

        private String naiToString(NetworkAgentInfo nai) {
            String name = nai != null ? nai.name() : "null";
            String state = nai.networkInfo != null ? (Object)((Object)nai.networkInfo.getState()) + "/" + (Object)((Object)nai.networkInfo.getDetailedState()) : "???/???";
            return name + " " + state;
        }

        public void dump(IndentingPrintWriter pw) {
            int type;
            pw.println("mLegacyTypeTracker:");
            pw.increaseIndent();
            pw.print("Supported types:");
            for (type = 0; type < this.mTypeLists.length; ++type) {
                if (this.mTypeLists[type] == null) continue;
                pw.print(" " + type);
            }
            pw.println();
            pw.println("Current state:");
            pw.increaseIndent();
            for (type = 0; type < this.mTypeLists.length; ++type) {
                if (this.mTypeLists[type] == null || this.mTypeLists[type].size() == 0) continue;
                for (NetworkAgentInfo nai : this.mTypeLists[type]) {
                    pw.println(type + " " + this.naiToString(nai));
                }
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
            pw.println();
        }

        private void log(String s) {
            Slog.d(TAG, s);
        }
    }

    private static enum ReapUnvalidatedNetworks {
        REAP,
        DONT_REAP;

    }
}

