/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.hardware.TriggerEvent;
import android.hardware.TriggerEventListener;
import android.hardware.display.DisplayManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationRequest;
import android.net.INetworkPolicyManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.KeyValueListParser;
import android.util.MutableLong;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.TimeUtils;
import android.util.Xml;
import android.view.Display;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.AtomicFile;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import com.android.server.AnyMotionDetector;
import com.android.server.EventLogTags;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.am.BatteryStatsService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class DeviceIdleController
extends SystemService
implements AnyMotionDetector.DeviceIdleCallback {
    private static final String TAG = "DeviceIdleController";
    private static final boolean DEBUG = false;
    private static final boolean COMPRESS_TIME = false;
    private static final String ACTION_STEP_IDLE_STATE = "com.android.server.device_idle.STEP_IDLE_STATE";
    private AlarmManager mAlarmManager;
    private IBatteryStats mBatteryStats;
    private PowerManagerInternal mLocalPowerManager;
    private INetworkPolicyManager mNetworkPolicyManager;
    private DisplayManager mDisplayManager;
    private SensorManager mSensorManager;
    private Sensor mSigMotionSensor;
    private LocationManager mLocationManager;
    private LocationRequest mLocationRequest;
    private PendingIntent mSensingAlarmIntent;
    private PendingIntent mAlarmIntent;
    private Intent mIdleIntent;
    private Display mCurDisplay;
    private AnyMotionDetector mAnyMotionDetector;
    private boolean mEnabled;
    private boolean mForceIdle;
    private boolean mScreenOn;
    private boolean mCharging;
    private boolean mSigMotionActive;
    private boolean mSensing;
    private boolean mNotMoving;
    private boolean mLocating;
    private boolean mLocated;
    private boolean mHaveGps;
    private Location mLastGenericLocation;
    private Location mLastGpsLocation;
    private static final int STATE_ACTIVE = 0;
    private static final int STATE_INACTIVE = 1;
    private static final int STATE_IDLE_PENDING = 2;
    private static final int STATE_SENSING = 3;
    private static final int STATE_LOCATING = 4;
    private static final int STATE_IDLE = 5;
    private static final int STATE_IDLE_MAINTENANCE = 6;
    private int mState;
    private long mInactiveTimeout;
    private long mNextAlarmTime;
    private long mNextIdlePendingDelay;
    private long mNextIdleDelay;
    public final AtomicFile mConfigFile;
    private final ArrayMap<String, Integer> mPowerSaveWhitelistAppsExceptIdle = new ArrayMap();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistApps = new ArrayMap();
    private final ArrayMap<String, Integer> mPowerSaveWhitelistUserApps = new ArrayMap();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIdsExceptIdle = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistSystemAppIds = new SparseBooleanArray();
    private final SparseBooleanArray mPowerSaveWhitelistExceptIdleAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistExceptIdleAppIdArray = new int[0];
    private final SparseBooleanArray mPowerSaveWhitelistAllAppIds = new SparseBooleanArray();
    private int[] mPowerSaveWhitelistAllAppIdArray = new int[0];
    private final SparseArray<Pair<MutableLong, String>> mTempWhitelistAppIdEndTimes = new SparseArray();
    Runnable mNetworkPolicyTempWhitelistCallback;
    private int[] mTempWhitelistAppIdArray = new int[0];
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.BATTERY_CHANGED".equals(intent.getAction())) {
                int plugged = intent.getIntExtra("plugged", 0);
                DeviceIdleController.this.updateChargingLocked(plugged != 0);
            } else if (DeviceIdleController.ACTION_STEP_IDLE_STATE.equals(intent.getAction())) {
                DeviceIdleController deviceIdleController = DeviceIdleController.this;
                synchronized (deviceIdleController) {
                    DeviceIdleController.this.stepIdleStateLocked();
                }
            }
        }
    };
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int displayId) {
        }

        @Override
        public void onDisplayRemoved(int displayId) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(int displayId) {
            if (displayId == 0) {
                DeviceIdleController deviceIdleController = DeviceIdleController.this;
                synchronized (deviceIdleController) {
                    DeviceIdleController.this.updateDisplayLocked();
                }
            }
        }
    };
    private final TriggerEventListener mSigMotionListener = new TriggerEventListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTrigger(TriggerEvent event) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.significantMotionLocked();
            }
        }
    };
    private final LocationListener mGenericLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGenericLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private final LocationListener mGpsLocationListener = new LocationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onLocationChanged(Location location) {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                DeviceIdleController.this.receivedGpsLocationLocked(location);
            }
        }

        @Override
        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        @Override
        public void onProviderEnabled(String provider) {
        }

        @Override
        public void onProviderDisabled(String provider) {
        }
    };
    private Constants mConstants;
    static final int MSG_WRITE_CONFIG = 1;
    static final int MSG_REPORT_IDLE_ON = 2;
    static final int MSG_REPORT_IDLE_OFF = 3;
    static final int MSG_REPORT_ACTIVE = 4;
    static final int MSG_TEMP_APP_WHITELIST_TIMEOUT = 5;
    final MyHandler mHandler;

    private static String stateToString(int state) {
        switch (state) {
            case 0: {
                return "ACTIVE";
            }
            case 1: {
                return "INACTIVE";
            }
            case 2: {
                return "IDLE_PENDING";
            }
            case 3: {
                return "SENSING";
            }
            case 4: {
                return "LOCATING";
            }
            case 5: {
                return "IDLE";
            }
            case 6: {
                return "IDLE_MAINTENANCE";
            }
        }
        return Integer.toString(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAnyMotionResult(int result) {
        if (result == 1) {
            DeviceIdleController deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.handleMotionDetectedLocked(this.mConstants.INACTIVE_TIMEOUT, "sense_motion");
            }
        }
        if (result == 0) {
            if (this.mState == 3) {
                DeviceIdleController deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    this.stepIdleStateLocked();
                }
            }
            if (this.mState == 4) {
                DeviceIdleController deviceIdleController = this;
                synchronized (deviceIdleController) {
                    this.mNotMoving = true;
                    if (this.mLocated) {
                        this.stepIdleStateLocked();
                    }
                }
            }
        }
    }

    public DeviceIdleController(Context context) {
        super(context);
        this.mConfigFile = new AtomicFile(new File(DeviceIdleController.getSystemDir(), "deviceidle.xml"));
        this.mHandler = new MyHandler(BackgroundThread.getHandler().getLooper());
    }

    private static File getSystemDir() {
        return new File(Environment.getDataDirectory(), "system");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        PackageManager pm = this.getContext().getPackageManager();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mEnabled = this.getContext().getResources().getBoolean(17956885);
            SystemConfig sysConfig = SystemConfig.getInstance();
            ArraySet<String> allowPowerExceptIdle = sysConfig.getAllowInPowerSaveExceptIdle();
            for (int i = 0; i < allowPowerExceptIdle.size(); ++i) {
                String pkg = allowPowerExceptIdle.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0);
                    if ((ai.flags & 1) == 0) continue;
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            ArraySet<String> allowPower = sysConfig.getAllowInPowerSave();
            for (int i = 0; i < allowPower.size(); ++i) {
                String pkg = allowPower.valueAt(i);
                try {
                    ApplicationInfo ai = pm.getApplicationInfo(pkg, 0);
                    if ((ai.flags & 1) == 0) continue;
                    int appid = UserHandle.getAppId(ai.uid);
                    this.mPowerSaveWhitelistAppsExceptIdle.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIdsExceptIdle.put(appid, true);
                    this.mPowerSaveWhitelistApps.put(ai.packageName, appid);
                    this.mPowerSaveWhitelistSystemAppIds.put(appid, true);
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
            }
            this.mConstants = new Constants(this.mHandler, this.getContext().getContentResolver());
            this.readConfigFileLocked();
            this.updateWhitelistAppIdsLocked();
            this.mScreenOn = true;
            this.mCharging = true;
            this.mState = 0;
            this.mInactiveTimeout = this.mConstants.INACTIVE_TIMEOUT;
        }
        this.publishBinderService("deviceidle", new BinderService());
        this.publishLocalService(LocalService.class, new LocalService());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBootPhase(int phase) {
        if (phase == 500) {
            DeviceIdleController deviceIdleController = this;
            synchronized (deviceIdleController) {
                this.mAlarmManager = (AlarmManager)this.getContext().getSystemService("alarm");
                this.mBatteryStats = BatteryStatsService.getService();
                this.mLocalPowerManager = this.getLocalService(PowerManagerInternal.class);
                this.mNetworkPolicyManager = INetworkPolicyManager.Stub.asInterface(ServiceManager.getService("netpolicy"));
                this.mDisplayManager = (DisplayManager)this.getContext().getSystemService("display");
                this.mSensorManager = (SensorManager)this.getContext().getSystemService("sensor");
                this.mSigMotionSensor = this.mSensorManager.getDefaultSensor(17);
                this.mLocationManager = (LocationManager)this.getContext().getSystemService("location");
                this.mLocationRequest = new LocationRequest().setQuality(100).setInterval(0L).setFastestInterval(0L).setNumUpdates(1);
                this.mAnyMotionDetector = new AnyMotionDetector((PowerManager)this.getContext().getSystemService("power"), this.mHandler, this.mSensorManager, this);
                Intent intent = new Intent(ACTION_STEP_IDLE_STATE).setPackage("android").setFlags(0x40000000);
                this.mAlarmIntent = PendingIntent.getBroadcast(this.getContext(), 0, intent, 0);
                Intent intentSensing = new Intent(ACTION_STEP_IDLE_STATE).setPackage("android").setFlags(0x40000000);
                this.mSensingAlarmIntent = PendingIntent.getBroadcast(this.getContext(), 0, intentSensing, 0);
                this.mIdleIntent = new Intent("android.os.action.DEVICE_IDLE_MODE_CHANGED");
                this.mIdleIntent.addFlags(0x50000000);
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.BATTERY_CHANGED");
                filter.addAction(ACTION_STEP_IDLE_STATE);
                this.getContext().registerReceiver(this.mReceiver, filter);
                this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
                this.mDisplayManager.registerDisplayListener(this.mDisplayListener, null);
                this.updateDisplayLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addPowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            try {
                ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfo(name, 0);
                if (this.mPowerSaveWhitelistUserApps.put(name, UserHandle.getAppId(ai.uid)) == null) {
                    this.reportPowerSaveWhitelistChangedLocked();
                    this.updateWhitelistAppIdsLocked();
                    this.writeConfigFileLocked();
                }
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removePowerSaveWhitelistAppInternal(String name) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            if (this.mPowerSaveWhitelistUserApps.remove(name) != null) {
                this.reportPowerSaveWhitelistChangedLocked();
                this.updateWhitelistAppIdsLocked();
                this.writeConfigFileLocked();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSystemPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int size = this.mPowerSaveWhitelistApps.size();
            String[] apps = new String[size];
            for (int i = 0; i < size; ++i) {
                apps[i] = this.mPowerSaveWhitelistApps.keyAt(i);
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistAppsExceptIdle.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistAppsExceptIdle.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistAppsExceptIdle.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFullPowerWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            int i;
            int size = this.mPowerSaveWhitelistApps.size() + this.mPowerSaveWhitelistUserApps.size();
            String[] apps = new String[size];
            int cur = 0;
            for (i = 0; i < this.mPowerSaveWhitelistApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistApps.keyAt(i);
                ++cur;
            }
            for (i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
                apps[cur] = this.mPowerSaveWhitelistUserApps.keyAt(i);
                ++cur;
            }
            return apps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistExceptIdleAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAppsExceptIdle.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPowerSaveWhitelistAppInternal(String packageName) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistApps.containsKey(packageName) || this.mPowerSaveWhitelistUserApps.containsKey(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistExceptIdleInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistExceptIdleAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mPowerSaveWhitelistAllAppIdArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAppIdTempWhitelistInternal() {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            return this.mTempWhitelistAppIdArray;
        }
    }

    public void addPowerSaveTempWhitelistAppInternal(int callingUid, String packageName, long duration, int userId, boolean sync, String reason) {
        try {
            int uid = this.getContext().getPackageManager().getPackageUid(packageName, userId);
            int appId = UserHandle.getAppId(uid);
            this.addPowerSaveTempWhitelistAppDirectInternal(callingUid, appId, duration, sync, reason);
        }
        catch (PackageManager.NameNotFoundException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPowerSaveTempWhitelistAppDirectInternal(int callingUid, int appId, long duration, boolean sync, String reason) {
        long timeNow = SystemClock.elapsedRealtime();
        Runnable networkPolicyTempWhitelistCallback = null;
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            boolean newEntry;
            int callingAppId = UserHandle.getAppId(callingUid);
            if (callingAppId >= 10000 && !this.mPowerSaveWhitelistSystemAppIds.get(callingAppId)) {
                throw new SecurityException("Calling app " + UserHandle.formatUid(callingUid) + " is not on whitelist");
            }
            duration = Math.min(duration, this.mConstants.MAX_TEMP_APP_WHITELIST_DURATION);
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(appId);
            boolean bl = newEntry = entry == null;
            if (newEntry) {
                entry = new Pair<MutableLong, String>(new MutableLong(0L), reason);
                this.mTempWhitelistAppIdEndTimes.put(appId, entry);
            }
            ((MutableLong)entry.first).value = timeNow + duration;
            if (newEntry) {
                try {
                    this.mBatteryStats.noteEvent(32785, reason, appId);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                this.postTempActiveTimeoutMessage(appId, duration);
                this.updateTempWhitelistAppIdsLocked();
                if (this.mNetworkPolicyTempWhitelistCallback != null) {
                    if (!sync) {
                        this.mHandler.post(this.mNetworkPolicyTempWhitelistCallback);
                    } else {
                        networkPolicyTempWhitelistCallback = this.mNetworkPolicyTempWhitelistCallback;
                    }
                }
                this.reportTempWhitelistChangedLocked();
            }
        }
        if (networkPolicyTempWhitelistCallback != null) {
            networkPolicyTempWhitelistCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNetworkPolicyTempWhitelistCallbackInternal(Runnable callback) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.mNetworkPolicyTempWhitelistCallback = callback;
        }
    }

    private void postTempActiveTimeoutMessage(int uid, long delay) {
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(5, uid, 0), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkTempAppWhitelistTimeout(int uid) {
        long timeNow = SystemClock.elapsedRealtime();
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            Pair<MutableLong, String> entry = this.mTempWhitelistAppIdEndTimes.get(uid);
            if (entry == null) {
                return;
            }
            if (timeNow >= ((MutableLong)entry.first).value) {
                this.mTempWhitelistAppIdEndTimes.delete(uid);
                this.updateTempWhitelistAppIdsLocked();
                if (this.mNetworkPolicyTempWhitelistCallback != null) {
                    this.mHandler.post(this.mNetworkPolicyTempWhitelistCallback);
                }
                this.reportTempWhitelistChangedLocked();
                try {
                    this.mBatteryStats.noteEvent(16401, (String)entry.second, uid);
                }
                catch (RemoteException e) {}
            } else {
                this.postTempActiveTimeoutMessage(uid, ((MutableLong)entry.first).value - timeNow);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitIdleInternal(String reason) {
        DeviceIdleController deviceIdleController = this;
        synchronized (deviceIdleController) {
            this.becomeActiveLocked(reason, Binder.getCallingUid());
        }
    }

    void updateDisplayLocked() {
        boolean screenOn;
        this.mCurDisplay = this.mDisplayManager.getDisplay(0);
        boolean bl = screenOn = this.mCurDisplay.getState() == 2;
        if (!screenOn && this.mScreenOn) {
            this.mScreenOn = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (screenOn) {
            this.mScreenOn = true;
            if (!this.mForceIdle) {
                this.becomeActiveLocked("screen", Process.myUid());
            }
        }
    }

    void updateChargingLocked(boolean charging) {
        if (!charging && this.mCharging) {
            this.mCharging = false;
            if (!this.mForceIdle) {
                this.becomeInactiveIfAppropriateLocked();
            }
        } else if (charging) {
            this.mCharging = charging;
            if (!this.mForceIdle) {
                this.becomeActiveLocked("charging", Process.myUid());
            }
        }
    }

    void scheduleReportActiveLocked(String activeReason, int activeUid) {
        Message msg = this.mHandler.obtainMessage(4, activeUid, this.mState == 5 ? 1 : 0, activeReason);
        this.mHandler.sendMessage(msg);
    }

    void becomeActiveLocked(String activeReason, int activeUid) {
        if (this.mState != 0) {
            EventLogTags.writeDeviceIdle(0, activeReason);
            this.scheduleReportActiveLocked(activeReason, activeUid);
            this.mState = 0;
            this.mInactiveTimeout = this.mConstants.INACTIVE_TIMEOUT;
            this.resetIdleManagementLocked();
        }
    }

    void becomeInactiveIfAppropriateLocked() {
        if ((!this.mScreenOn && !this.mCharging || this.mForceIdle) && this.mEnabled && this.mState == 0) {
            this.mState = 1;
            this.resetIdleManagementLocked();
            this.scheduleAlarmLocked(this.mInactiveTimeout, false);
            EventLogTags.writeDeviceIdle(this.mState, "no activity");
        }
    }

    void resetIdleManagementLocked() {
        this.mNextIdlePendingDelay = 0L;
        this.mNextIdleDelay = 0L;
        this.cancelAlarmLocked();
        this.cancelSensingAlarmLocked();
        this.cancelLocatingLocked();
        this.stopMonitoringSignificantMotion();
        this.mAnyMotionDetector.stop();
    }

    void exitForceIdleLocked() {
        if (this.mForceIdle) {
            this.mForceIdle = false;
            if (this.mScreenOn || this.mCharging) {
                this.becomeActiveLocked("exit-force-idle", Process.myUid());
            }
        }
    }

    void stepIdleStateLocked() {
        EventLogTags.writeDeviceIdleStep();
        long now = SystemClock.elapsedRealtime();
        if (now + this.mConstants.MIN_TIME_TO_ALARM > this.mAlarmManager.getNextWakeFromIdleTime()) {
            if (this.mState != 0) {
                this.becomeActiveLocked("alarm", Process.myUid());
            }
            return;
        }
        switch (this.mState) {
            case 1: {
                this.startMonitoringSignificantMotion();
                this.scheduleAlarmLocked(this.mConstants.IDLE_AFTER_INACTIVE_TIMEOUT, false);
                this.mNextIdlePendingDelay = this.mConstants.IDLE_PENDING_TIMEOUT;
                this.mNextIdleDelay = this.mConstants.IDLE_TIMEOUT;
                this.mState = 2;
                EventLogTags.writeDeviceIdle(this.mState, "step");
                break;
            }
            case 2: {
                this.mState = 3;
                EventLogTags.writeDeviceIdle(this.mState, "step");
                this.scheduleSensingAlarmLocked(this.mConstants.SENSING_TIMEOUT);
                this.cancelSensingAlarmLocked();
                this.cancelLocatingLocked();
                this.mAnyMotionDetector.checkForAnyMotion();
                this.mNotMoving = false;
                this.mLocated = false;
                this.mLastGenericLocation = null;
                this.mLastGpsLocation = null;
                break;
            }
            case 3: {
                this.mState = 4;
                EventLogTags.writeDeviceIdle(this.mState, "step");
                this.cancelSensingAlarmLocked();
                this.scheduleSensingAlarmLocked(this.mConstants.LOCATING_TIMEOUT);
                this.mLocating = true;
                this.mLocationManager.requestLocationUpdates(this.mLocationRequest, this.mGenericLocationListener, this.mHandler.getLooper());
                if (this.mLocationManager.getProvider("gps") != null) {
                    this.mHaveGps = true;
                    this.mLocationManager.requestLocationUpdates("gps", 1000L, 5.0f, this.mGpsLocationListener, this.mHandler.getLooper());
                    break;
                }
                this.mHaveGps = false;
                break;
            }
            case 4: {
                this.cancelSensingAlarmLocked();
                this.cancelLocatingLocked();
                this.mAnyMotionDetector.stop();
            }
            case 6: {
                this.scheduleAlarmLocked(this.mNextIdleDelay, true);
                this.mNextIdleDelay = (long)((float)this.mNextIdleDelay * this.mConstants.IDLE_FACTOR);
                this.mNextIdleDelay = Math.min(this.mNextIdleDelay, this.mConstants.MAX_IDLE_TIMEOUT);
                this.mState = 5;
                EventLogTags.writeDeviceIdle(this.mState, "step");
                this.mHandler.sendEmptyMessage(2);
                break;
            }
            case 5: {
                this.scheduleAlarmLocked(this.mNextIdlePendingDelay, false);
                this.mNextIdlePendingDelay = Math.min(this.mConstants.MAX_IDLE_PENDING_TIMEOUT, (long)((float)this.mNextIdlePendingDelay * this.mConstants.IDLE_PENDING_FACTOR));
                this.mState = 6;
                EventLogTags.writeDeviceIdle(this.mState, "step");
                this.mHandler.sendEmptyMessage(3);
            }
        }
    }

    void significantMotionLocked() {
        this.mSigMotionActive = false;
        this.handleMotionDetectedLocked(this.mConstants.MOTION_INACTIVE_TIMEOUT, "motion");
    }

    void handleMotionDetectedLocked(long timeout, String type) {
        if (this.mState != 0) {
            this.scheduleReportActiveLocked(type, Process.myUid());
            this.mState = 0;
            this.mInactiveTimeout = timeout;
            EventLogTags.writeDeviceIdle(this.mState, type);
            this.becomeInactiveIfAppropriateLocked();
        }
    }

    void receivedGenericLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGenericLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY && this.mHaveGps) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked();
        }
    }

    void receivedGpsLocationLocked(Location location) {
        if (this.mState != 4) {
            this.cancelLocatingLocked();
            return;
        }
        this.mLastGpsLocation = new Location(location);
        if (location.getAccuracy() > this.mConstants.LOCATION_ACCURACY) {
            return;
        }
        this.mLocated = true;
        if (this.mNotMoving) {
            this.stepIdleStateLocked();
        }
    }

    void startMonitoringSignificantMotion() {
        if (this.mSigMotionSensor != null && !this.mSigMotionActive) {
            this.mSensorManager.requestTriggerSensor(this.mSigMotionListener, this.mSigMotionSensor);
            this.mSigMotionActive = true;
        }
    }

    void stopMonitoringSignificantMotion() {
        if (this.mSigMotionActive) {
            this.mSensorManager.cancelTriggerSensor(this.mSigMotionListener, this.mSigMotionSensor);
            this.mSigMotionActive = false;
        }
    }

    void cancelAlarmLocked() {
        if (this.mNextAlarmTime != 0L) {
            this.mNextAlarmTime = 0L;
            this.mAlarmManager.cancel(this.mAlarmIntent);
        }
    }

    void cancelSensingAlarmLocked() {
        if (this.mSensing) {
            this.mAlarmManager.cancel(this.mSensingAlarmIntent);
            this.mSensing = false;
        }
    }

    void cancelLocatingLocked() {
        if (this.mLocating) {
            this.mLocationManager.removeUpdates(this.mGenericLocationListener);
            this.mLocationManager.removeUpdates(this.mGpsLocationListener);
            this.mLocating = false;
        }
    }

    void scheduleAlarmLocked(long delay, boolean idleUntil) {
        if (this.mSigMotionSensor == null) {
            return;
        }
        this.mNextAlarmTime = SystemClock.elapsedRealtime() + delay;
        if (idleUntil) {
            this.mAlarmManager.setIdleUntil(2, this.mNextAlarmTime, this.mAlarmIntent);
        } else {
            this.mAlarmManager.set(2, this.mNextAlarmTime, this.mAlarmIntent);
        }
    }

    void scheduleSensingAlarmLocked(long delay) {
        this.cancelSensingAlarmLocked();
        this.mNextAlarmTime = SystemClock.elapsedRealtime() + delay;
        this.mAlarmManager.set(2, this.mNextAlarmTime, this.mSensingAlarmIntent);
        this.mSensing = true;
    }

    private static int[] buildAppIdArray(ArrayMap<String, Integer> systemApps, ArrayMap<String, Integer> userApps, SparseBooleanArray outAppIds) {
        int i;
        outAppIds.clear();
        for (i = 0; i < systemApps.size(); ++i) {
            outAppIds.put(systemApps.valueAt(i), true);
        }
        for (i = 0; i < userApps.size(); ++i) {
            outAppIds.put(userApps.valueAt(i), true);
        }
        int size = outAppIds.size();
        int[] appids = new int[size];
        for (int i2 = 0; i2 < size; ++i2) {
            appids[i2] = outAppIds.keyAt(i2);
        }
        return appids;
    }

    private void updateWhitelistAppIdsLocked() {
        this.mPowerSaveWhitelistExceptIdleAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistAppsExceptIdle, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistExceptIdleAppIds);
        this.mPowerSaveWhitelistAllAppIdArray = DeviceIdleController.buildAppIdArray(this.mPowerSaveWhitelistApps, this.mPowerSaveWhitelistUserApps, this.mPowerSaveWhitelistAllAppIds);
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleWhitelist(this.mPowerSaveWhitelistAllAppIdArray);
        }
    }

    private void updateTempWhitelistAppIdsLocked() {
        int size = this.mTempWhitelistAppIdEndTimes.size();
        if (this.mTempWhitelistAppIdArray.length != size) {
            this.mTempWhitelistAppIdArray = new int[size];
        }
        for (int i = 0; i < size; ++i) {
            this.mTempWhitelistAppIdArray[i] = this.mTempWhitelistAppIdEndTimes.keyAt(i);
        }
        if (this.mLocalPowerManager != null) {
            this.mLocalPowerManager.setDeviceIdleTempWhitelist(this.mTempWhitelistAppIdArray);
        }
    }

    private void reportPowerSaveWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.OWNER);
    }

    private void reportTempWhitelistChangedLocked() {
        Intent intent = new Intent("android.os.action.POWER_SAVE_TEMP_WHITELIST_CHANGED");
        intent.addFlags(0x40000000);
        this.getContext().sendBroadcastAsUser(intent, UserHandle.OWNER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readConfigFileLocked() {
        FileInputStream stream;
        this.mPowerSaveWhitelistUserApps.clear();
        try {
            stream = this.mConfigFile.openRead();
        }
        catch (FileNotFoundException e) {
            return;
        }
        try {
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput(stream, StandardCharsets.UTF_8.name());
            this.readConfigFileLocked(parser);
        }
        catch (XmlPullParserException e) {
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    private void readConfigFileLocked(XmlPullParser parser) {
        PackageManager pm = this.getContext().getPackageManager();
        try {
            int type;
            while ((type = parser.next()) != 2 && type != 1) {
            }
            if (type != 2) {
                throw new IllegalStateException("no start tag found");
            }
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4) continue;
                String tagName = parser.getName();
                if (tagName.equals("wl")) {
                    String name = parser.getAttributeValue(null, "n");
                    if (name == null) continue;
                    try {
                        ApplicationInfo ai = pm.getApplicationInfo(name, 0);
                        this.mPowerSaveWhitelistUserApps.put(ai.packageName, UserHandle.getAppId(ai.uid));
                    }
                    catch (PackageManager.NameNotFoundException e) {}
                    continue;
                }
                Slog.w(TAG, "Unknown element under <config>: " + parser.getName());
                XmlUtils.skipCurrentTag(parser);
            }
        }
        catch (IllegalStateException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NullPointerException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (NumberFormatException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (XmlPullParserException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IOException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
        catch (IndexOutOfBoundsException e) {
            Slog.w(TAG, "Failed parsing config " + e);
        }
    }

    void writeConfigFileLocked() {
        this.mHandler.removeMessages(1);
        this.mHandler.sendEmptyMessageDelayed(1, 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleWriteConfigFile() {
        Object object;
        ByteArrayOutputStream memStream = new ByteArrayOutputStream();
        try {
            object = this;
            synchronized (object) {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(memStream, StandardCharsets.UTF_8.name());
                this.writeConfigFileLocked(out);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this.mConfigFile;
        synchronized (object) {
            FileOutputStream stream = null;
            try {
                stream = this.mConfigFile.startWrite();
                memStream.writeTo(stream);
                stream.flush();
                FileUtils.sync(stream);
                stream.close();
                this.mConfigFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Error writing config file", e);
                this.mConfigFile.failWrite(stream);
            }
        }
    }

    void writeConfigFileLocked(XmlSerializer out) throws IOException {
        out.startDocument(null, true);
        out.startTag(null, "config");
        for (int i = 0; i < this.mPowerSaveWhitelistUserApps.size(); ++i) {
            String name = this.mPowerSaveWhitelistUserApps.keyAt(i);
            out.startTag(null, "wl");
            out.attribute(null, "n", name);
            out.endTag(null, "wl");
        }
        out.endTag(null, "config");
        out.endDocument();
    }

    private void dumpHelp(PrintWriter pw) {
        pw.println("Device idle controller (deviceidle) dump options:");
        pw.println("  [-h] [CMD]");
        pw.println("  -h: print this help text.");
        pw.println("Commands:");
        pw.println("  step");
        pw.println("    Immediately step to next state, without waiting for alarm.");
        pw.println("  force-idle");
        pw.println("    Force directly into idle mode, regardless of other device state.");
        pw.println("    Use \"step\" to get out.");
        pw.println("  disable");
        pw.println("    Completely disable device idle mode.");
        pw.println("  enable");
        pw.println("    Re-enable device idle mode after it had previously been disabled.");
        pw.println("  enabled");
        pw.println("    Print 1 if device idle mode is currently enabled, else 0.");
        pw.println("  whitelist");
        pw.println("    Print currently whitelisted apps.");
        pw.println("  whitelist [package ...]");
        pw.println("    Add (prefix with +) or remove (prefix with -) packages.");
        pw.println("  tempwhitelist [package ..]");
        pw.println("    Temporarily place packages in whitelist for 10 seconds.");
    }

    /*
     * Exception decompiling
     */
    void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 74[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final class LocalService {
        public void addPowerSaveTempWhitelistAppDirect(int appId, long duration, boolean sync, String reason) {
            DeviceIdleController.this.addPowerSaveTempWhitelistAppDirectInternal(0, appId, duration, sync, reason);
        }

        public void setNetworkPolicyTempWhitelistCallback(Runnable callback) {
            DeviceIdleController.this.setNetworkPolicyTempWhitelistCallbackInternal(callback);
        }
    }

    private final class BinderService
    extends IDeviceIdleController.Stub {
        private BinderService() {
        }

        @Override
        public void addPowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            DeviceIdleController.this.addPowerSaveWhitelistAppInternal(name);
        }

        @Override
        public void removePowerSaveWhitelistApp(String name) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            DeviceIdleController.this.removePowerSaveWhitelistAppInternal(name);
        }

        @Override
        public String[] getSystemPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getSystemPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getSystemPowerWhitelist() {
            return DeviceIdleController.this.getSystemPowerWhitelistInternal();
        }

        @Override
        public String[] getFullPowerWhitelistExceptIdle() {
            return DeviceIdleController.this.getFullPowerWhitelistExceptIdleInternal();
        }

        @Override
        public String[] getFullPowerWhitelist() {
            return DeviceIdleController.this.getFullPowerWhitelistInternal();
        }

        @Override
        public int[] getAppIdWhitelistExceptIdle() {
            return DeviceIdleController.this.getAppIdWhitelistExceptIdleInternal();
        }

        @Override
        public int[] getAppIdWhitelist() {
            return DeviceIdleController.this.getAppIdWhitelistInternal();
        }

        @Override
        public int[] getAppIdTempWhitelist() {
            return DeviceIdleController.this.getAppIdTempWhitelistInternal();
        }

        @Override
        public boolean isPowerSaveWhitelistExceptIdleApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistExceptIdleAppInternal(name);
        }

        @Override
        public boolean isPowerSaveWhitelistApp(String name) {
            return DeviceIdleController.this.isPowerSaveWhitelistAppInternal(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addPowerSaveTempWhitelistApp(String packageName, long duration, int userId, String reason) throws RemoteException {
            DeviceIdleController.this.getContext().enforceCallingPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", "No permission to change device idle whitelist");
            int callingUid = Binder.getCallingUid();
            userId = ActivityManagerNative.getDefault().handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, false, "addPowerSaveTempWhitelistApp", null);
            long token = Binder.clearCallingIdentity();
            try {
                DeviceIdleController.this.addPowerSaveTempWhitelistAppInternal(callingUid, packageName, duration, userId, true, reason);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public long addPowerSaveTempWhitelistAppForMms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.MMS_TEMP_APP_WHITELIST_DURATION;
            this.addPowerSaveTempWhitelistApp(packageName, duration, userId, reason);
            return duration;
        }

        @Override
        public long addPowerSaveTempWhitelistAppForSms(String packageName, int userId, String reason) throws RemoteException {
            long duration = ((DeviceIdleController)DeviceIdleController.this).mConstants.SMS_TEMP_APP_WHITELIST_DURATION;
            this.addPowerSaveTempWhitelistApp(packageName, duration, userId, reason);
            return duration;
        }

        @Override
        public void exitIdle(String reason) {
            DeviceIdleController.this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
            DeviceIdleController.this.exitIdleInternal(reason);
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            DeviceIdleController.this.dump(fd, pw, args);
        }
    }

    final class MyHandler
    extends Handler {
        MyHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    DeviceIdleController.this.handleWriteConfigFile();
                    break;
                }
                case 2: {
                    EventLogTags.writeDeviceIdleOnStart();
                    DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(true);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(true);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(true, null, Process.myUid());
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    EventLogTags.writeDeviceIdleOnComplete();
                    break;
                }
                case 3: {
                    EventLogTags.writeDeviceIdleOffStart("unknown");
                    DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(false, null, Process.myUid());
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 4: {
                    String activeReason = (String)msg.obj;
                    int activeUid = msg.arg1;
                    boolean needBroadcast = msg.arg2 != 0;
                    EventLogTags.writeDeviceIdleOffStart(activeReason != null ? activeReason : "unknown");
                    DeviceIdleController.this.mLocalPowerManager.setDeviceIdleMode(false);
                    try {
                        DeviceIdleController.this.mNetworkPolicyManager.setDeviceIdleMode(false);
                        DeviceIdleController.this.mBatteryStats.noteDeviceIdleMode(false, activeReason, activeUid);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (needBroadcast) {
                        DeviceIdleController.this.getContext().sendBroadcastAsUser(DeviceIdleController.this.mIdleIntent, UserHandle.ALL);
                    }
                    EventLogTags.writeDeviceIdleOffComplete();
                    break;
                }
                case 5: {
                    int uid = msg.arg1;
                    DeviceIdleController.this.checkTempAppWhitelistTimeout(uid);
                }
            }
        }
    }

    private final class Constants
    extends ContentObserver {
        private static final String KEY_INACTIVE_TIMEOUT = "inactive_to";
        private static final String KEY_SENSING_TIMEOUT = "sensing_to";
        private static final String KEY_LOCATING_TIMEOUT = "locating_to";
        private static final String KEY_LOCATION_ACCURACY = "location_accuracy";
        private static final String KEY_MOTION_INACTIVE_TIMEOUT = "motion_inactive_to";
        private static final String KEY_IDLE_AFTER_INACTIVE_TIMEOUT = "idle_after_inactive_to";
        private static final String KEY_IDLE_PENDING_TIMEOUT = "idle_pending_to";
        private static final String KEY_MAX_IDLE_PENDING_TIMEOUT = "max_idle_pending_to";
        private static final String KEY_IDLE_PENDING_FACTOR = "idle_pending_factor";
        private static final String KEY_IDLE_TIMEOUT = "idle_to";
        private static final String KEY_MAX_IDLE_TIMEOUT = "max_idle_to";
        private static final String KEY_IDLE_FACTOR = "idle_factor";
        private static final String KEY_MIN_TIME_TO_ALARM = "min_time_to_alarm";
        private static final String KEY_MAX_TEMP_APP_WHITELIST_DURATION = "max_temp_app_whitelist_duration";
        private static final String KEY_MMS_TEMP_APP_WHITELIST_DURATION = "mms_temp_app_whitelist_duration";
        private static final String KEY_SMS_TEMP_APP_WHITELIST_DURATION = "sms_temp_app_whitelist_duration";
        public long INACTIVE_TIMEOUT;
        public long SENSING_TIMEOUT;
        public long LOCATING_TIMEOUT;
        public float LOCATION_ACCURACY;
        public long MOTION_INACTIVE_TIMEOUT;
        public long IDLE_AFTER_INACTIVE_TIMEOUT;
        public long IDLE_PENDING_TIMEOUT;
        public long MAX_IDLE_PENDING_TIMEOUT;
        public float IDLE_PENDING_FACTOR;
        public long IDLE_TIMEOUT;
        public long MAX_IDLE_TIMEOUT;
        public float IDLE_FACTOR;
        public long MIN_TIME_TO_ALARM;
        public long MAX_TEMP_APP_WHITELIST_DURATION;
        public long MMS_TEMP_APP_WHITELIST_DURATION;
        public long SMS_TEMP_APP_WHITELIST_DURATION;
        private final ContentResolver mResolver;
        private final KeyValueListParser mParser;

        public Constants(Handler handler, ContentResolver resolver) {
            super(handler);
            this.mParser = new KeyValueListParser(',');
            this.mResolver = resolver;
            this.mResolver.registerContentObserver(Settings.Global.getUriFor("device_idle_constants"), false, this);
            this.updateConstants();
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            this.updateConstants();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConstants() {
            DeviceIdleController deviceIdleController = DeviceIdleController.this;
            synchronized (deviceIdleController) {
                try {
                    this.mParser.setString(Settings.Global.getString(this.mResolver, "device_idle_constants"));
                }
                catch (IllegalArgumentException e) {
                    Slog.e(DeviceIdleController.TAG, "Bad device idle settings", e);
                }
                this.INACTIVE_TIMEOUT = this.mParser.getLong(KEY_INACTIVE_TIMEOUT, 1800000L);
                this.SENSING_TIMEOUT = this.mParser.getLong(KEY_SENSING_TIMEOUT, 240000L);
                this.LOCATING_TIMEOUT = this.mParser.getLong(KEY_LOCATING_TIMEOUT, 30000L);
                this.LOCATION_ACCURACY = this.mParser.getFloat(KEY_LOCATION_ACCURACY, 20.0f);
                this.MOTION_INACTIVE_TIMEOUT = this.mParser.getLong(KEY_MOTION_INACTIVE_TIMEOUT, 600000L);
                this.IDLE_AFTER_INACTIVE_TIMEOUT = this.mParser.getLong(KEY_IDLE_AFTER_INACTIVE_TIMEOUT, 1800000L);
                this.IDLE_PENDING_TIMEOUT = this.mParser.getLong(KEY_IDLE_PENDING_TIMEOUT, 300000L);
                this.MAX_IDLE_PENDING_TIMEOUT = this.mParser.getLong(KEY_MAX_IDLE_PENDING_TIMEOUT, 600000L);
                this.IDLE_PENDING_FACTOR = this.mParser.getFloat(KEY_IDLE_PENDING_FACTOR, 2.0f);
                this.IDLE_TIMEOUT = this.mParser.getLong(KEY_IDLE_TIMEOUT, 3600000L);
                this.MAX_IDLE_TIMEOUT = this.mParser.getLong(KEY_MAX_IDLE_TIMEOUT, 21600000L);
                this.IDLE_FACTOR = this.mParser.getFloat(KEY_IDLE_FACTOR, 2.0f);
                this.MIN_TIME_TO_ALARM = this.mParser.getLong(KEY_MIN_TIME_TO_ALARM, 3600000L);
                this.MAX_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_MAX_TEMP_APP_WHITELIST_DURATION, 300000L);
                this.MMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_MMS_TEMP_APP_WHITELIST_DURATION, 60000L);
                this.SMS_TEMP_APP_WHITELIST_DURATION = this.mParser.getLong(KEY_SMS_TEMP_APP_WHITELIST_DURATION, 20000L);
            }
        }

        void dump(PrintWriter pw) {
            pw.println("  Settings:");
            pw.print("    ");
            pw.print(KEY_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SENSING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.SENSING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.LOCATING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_LOCATION_ACCURACY);
            pw.print("=");
            pw.print(this.LOCATION_ACCURACY);
            pw.print("m");
            pw.println();
            pw.print("    ");
            pw.print(KEY_MOTION_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MOTION_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_AFTER_INACTIVE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_AFTER_INACTIVE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_PENDING_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_PENDING_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_PENDING_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_PENDING_FACTOR);
            pw.print("    ");
            pw.print(KEY_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_IDLE_TIMEOUT);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_IDLE_TIMEOUT, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_IDLE_FACTOR);
            pw.print("=");
            pw.println(this.IDLE_FACTOR);
            pw.print("    ");
            pw.print(KEY_MIN_TIME_TO_ALARM);
            pw.print("=");
            TimeUtils.formatDuration(this.MIN_TIME_TO_ALARM, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MAX_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MAX_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_MMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.MMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
            pw.print("    ");
            pw.print(KEY_SMS_TEMP_APP_WHITELIST_DURATION);
            pw.print("=");
            TimeUtils.formatDuration(this.SMS_TEMP_APP_WHITELIST_DURATION, pw);
            pw.println();
        }
    }
}

