/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.IBinder;
import android.os.MemoryFile;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import android.view.IGraphicsStats;
import android.view.ThreadedRenderer;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class GraphicsStatsService
extends IGraphicsStats.Stub {
    public static final String GRAPHICS_STATS_SERVICE = "graphicsstats";
    private static final String TAG = "GraphicsStatsService";
    private static final int ASHMEM_SIZE = 256;
    private static final int HISTORY_SIZE = 20;
    private final Context mContext;
    private final Object mLock = new Object();
    private ArrayList<ActiveBuffer> mActive = new ArrayList();
    private HistoricalData[] mHistoricalLog = new HistoricalData[20];
    private int mNextHistoricalSlot = 0;
    private byte[] mTempBuffer = new byte[256];

    public GraphicsStatsService(Context context) {
        this.mContext = context;
    }

    private boolean isValid(int uid, String packageName) {
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(packageName, 0);
            return info.applicationInfo.uid == uid;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor requestBufferForProcess(String packageName, IBinder token) throws RemoteException {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        ParcelFileDescriptor pfd = null;
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            if (!this.isValid(uid, packageName)) {
                throw new RemoteException("Invalid package name");
            }
            Object object = this.mLock;
            synchronized (object) {
                pfd = this.requestBufferForProcessLocked(token, uid, pid, packageName);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return pfd;
    }

    private ParcelFileDescriptor getPfd(MemoryFile file) {
        try {
            return new ParcelFileDescriptor(file.getFileDescriptor());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to get PFD from memory file", ex);
        }
    }

    private ParcelFileDescriptor requestBufferForProcessLocked(IBinder token, int uid, int pid, String packageName) throws RemoteException {
        ActiveBuffer buffer = this.fetchActiveBuffersLocked(token, uid, pid, packageName);
        return this.getPfd(buffer.mProcessBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDied(ActiveBuffer buffer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActive.remove(buffer);
            Log.d("GraphicsStats", "Buffer count: " + this.mActive.size());
        }
        HistoricalData data = buffer.mPreviousData;
        buffer.mPreviousData = null;
        if (data == null && (data = this.mHistoricalLog[this.mNextHistoricalSlot]) == null) {
            data = new HistoricalData();
        }
        data.update(buffer.mPackageName, buffer.mUid, buffer.mProcessBuffer);
        buffer.closeAllBuffers();
        this.mHistoricalLog[this.mNextHistoricalSlot] = data;
        this.mNextHistoricalSlot = (this.mNextHistoricalSlot + 1) % this.mHistoricalLog.length;
    }

    private ActiveBuffer fetchActiveBuffersLocked(IBinder token, int uid, int pid, String packageName) throws RemoteException {
        int size = this.mActive.size();
        for (int i = 0; i < size; ++i) {
            ActiveBuffer buffers = this.mActive.get(i);
            if (buffers.mPid != pid || buffers.mUid != uid) continue;
            return buffers;
        }
        try {
            ActiveBuffer buffers = new ActiveBuffer(token, uid, pid, packageName);
            this.mActive.add(buffers);
            return buffers;
        }
        catch (IOException ex) {
            throw new RemoteException("Failed to allocate space");
        }
    }

    private HistoricalData removeHistoricalDataLocked(int uid, String packageName) {
        for (int i = 0; i < this.mHistoricalLog.length; ++i) {
            HistoricalData data = this.mHistoricalLog[i];
            if (data == null || data.mUid != uid || !data.mPackageName.equals(packageName)) continue;
            if (i == this.mNextHistoricalSlot) {
                this.mHistoricalLog[i] = null;
            } else {
                this.mHistoricalLog[i] = this.mHistoricalLog[this.mNextHistoricalSlot];
                this.mHistoricalLog[this.mNextHistoricalSlot] = null;
            }
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < this.mActive.size(); ++i) {
                ActiveBuffer buffer = this.mActive.get(i);
                fout.print("Package: ");
                fout.print(buffer.mPackageName);
                fout.flush();
                try {
                    buffer.mProcessBuffer.readBytes(this.mTempBuffer, 0, 0, 256);
                    ThreadedRenderer.dumpProfileData(this.mTempBuffer, fd);
                }
                catch (IOException e) {
                    fout.println("Failed to dump");
                }
                fout.println();
            }
            for (HistoricalData buffer : this.mHistoricalLog) {
                if (buffer == null) continue;
                fout.print("Package: ");
                fout.print(buffer.mPackageName);
                fout.flush();
                ThreadedRenderer.dumpProfileData(buffer.mBuffer, fd);
                fout.println();
            }
        }
    }

    private static final class HistoricalData {
        final byte[] mBuffer = new byte[256];
        int mUid;
        String mPackageName;

        private HistoricalData() {
        }

        void update(String packageName, int uid, MemoryFile file) {
            this.mUid = uid;
            this.mPackageName = packageName;
            try {
                file.readBytes(this.mBuffer, 0, 0, 256);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private final class ActiveBuffer
    implements IBinder.DeathRecipient {
        final int mUid;
        final int mPid;
        final String mPackageName;
        final IBinder mToken;
        MemoryFile mProcessBuffer;
        HistoricalData mPreviousData;

        ActiveBuffer(IBinder token, int uid, int pid, String packageName) throws RemoteException, IOException {
            this.mUid = uid;
            this.mPid = pid;
            this.mPackageName = packageName;
            this.mToken = token;
            this.mToken.linkToDeath(this, 0);
            this.mProcessBuffer = new MemoryFile("GFXStats-" + uid, 256);
            this.mPreviousData = GraphicsStatsService.this.removeHistoricalDataLocked(this.mUid, this.mPackageName);
            if (this.mPreviousData != null) {
                this.mProcessBuffer.writeBytes(this.mPreviousData.mBuffer, 0, 0, 256);
            }
        }

        @Override
        public void binderDied() {
            this.mToken.unlinkToDeath(this, 0);
            GraphicsStatsService.this.processDied(this);
        }

        void closeAllBuffers() {
            if (this.mProcessBuffer != null) {
                this.mProcessBuffer.close();
                this.mProcessBuffer = null;
            }
        }
    }
}

