/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Intent;
import android.content.IntentFilter;
import android.net.Uri;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.FastImmutableArraySet;
import android.util.LogPrinter;
import android.util.MutableInt;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import com.android.internal.util.FastPrintWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class IntentResolver<F extends IntentFilter, R> {
    private static final String TAG = "IntentResolver";
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final boolean localVerificationLOGV = false;
    private static final Comparator mResolvePrioritySorter = new Comparator(){

        public int compare(Object o1, Object o2) {
            int q2;
            int q1 = ((IntentFilter)o1).getPriority();
            return q1 > (q2 = ((IntentFilter)o2).getPriority()) ? -1 : (q1 < q2 ? 1 : 0);
        }
    };
    private final ArraySet<F> mFilters = new ArraySet();
    private final ArrayMap<String, F[]> mTypeToFilter = new ArrayMap();
    private final ArrayMap<String, F[]> mBaseTypeToFilter = new ArrayMap();
    private final ArrayMap<String, F[]> mWildTypeToFilter = new ArrayMap();
    private final ArrayMap<String, F[]> mSchemeToFilter = new ArrayMap();
    private final ArrayMap<String, F[]> mActionToFilter = new ArrayMap();
    private final ArrayMap<String, F[]> mTypedActionToFilter = new ArrayMap();

    public void addFilter(F f) {
        this.mFilters.add(f);
        int numS = this.register_intent_filter(f, ((IntentFilter)f).schemesIterator(), this.mSchemeToFilter, "      Scheme: ");
        int numT = this.register_mime_types(f, "      Type: ");
        if (numS == 0 && numT == 0) {
            this.register_intent_filter(f, ((IntentFilter)f).actionsIterator(), this.mActionToFilter, "      Action: ");
        }
        if (numT != 0) {
            this.register_intent_filter(f, ((IntentFilter)f).actionsIterator(), this.mTypedActionToFilter, "      TypedAction: ");
        }
    }

    private boolean filterEquals(IntentFilter f1, IntentFilter f2) {
        int i;
        int s2;
        int s1 = f1.countActions();
        if (s1 != (s2 = f2.countActions())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasAction(f1.getAction(i))) continue;
            return false;
        }
        s1 = f1.countCategories();
        if (s1 != (s2 = f2.countCategories())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasCategory(f1.getCategory(i))) continue;
            return false;
        }
        s1 = f1.countDataTypes();
        if (s1 != (s2 = f2.countDataTypes())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasExactDataType(f1.getDataType(i))) continue;
            return false;
        }
        s1 = f1.countDataSchemes();
        if (s1 != (s2 = f2.countDataSchemes())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasDataScheme(f1.getDataScheme(i))) continue;
            return false;
        }
        s1 = f1.countDataAuthorities();
        if (s1 != (s2 = f2.countDataAuthorities())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasDataAuthority(f1.getDataAuthority(i))) continue;
            return false;
        }
        s1 = f1.countDataPaths();
        if (s1 != (s2 = f2.countDataPaths())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasDataPath(f1.getDataPath(i))) continue;
            return false;
        }
        s1 = f1.countDataSchemeSpecificParts();
        if (s1 != (s2 = f2.countDataSchemeSpecificParts())) {
            return false;
        }
        for (i = 0; i < s1; ++i) {
            if (f2.hasDataSchemeSpecificPart(f1.getDataSchemeSpecificPart(i))) continue;
            return false;
        }
        return true;
    }

    private ArrayList<F> collectFilters(F[] array2, IntentFilter matching) {
        ArrayList<F> res = null;
        if (array2 != null) {
            F cur;
            for (int i = 0; i < array2.length && (cur = array2[i]) != null; ++i) {
                if (!this.filterEquals((IntentFilter)cur, matching)) continue;
                if (res == null) {
                    res = new ArrayList<F>();
                }
                res.add(cur);
            }
        }
        return res;
    }

    public ArrayList<F> findFilters(IntentFilter matching) {
        if (matching.countDataSchemes() == 1) {
            return this.collectFilters((IntentFilter[])this.mSchemeToFilter.get(matching.getDataScheme(0)), matching);
        }
        if (matching.countDataTypes() != 0 && matching.countActions() == 1) {
            return this.collectFilters((IntentFilter[])this.mTypedActionToFilter.get(matching.getAction(0)), matching);
        }
        if (matching.countDataTypes() == 0 && matching.countDataSchemes() == 0 && matching.countActions() == 1) {
            return this.collectFilters((IntentFilter[])this.mActionToFilter.get(matching.getAction(0)), matching);
        }
        ArrayList<IntentFilter> res = null;
        for (IntentFilter cur : this.mFilters) {
            if (!this.filterEquals(cur, matching)) continue;
            if (res == null) {
                res = new ArrayList<IntentFilter>();
            }
            res.add(cur);
        }
        return res;
    }

    public void removeFilter(F f) {
        this.removeFilterInternal(f);
        this.mFilters.remove(f);
    }

    void removeFilterInternal(F f) {
        int numS = this.unregister_intent_filter(f, ((IntentFilter)f).schemesIterator(), this.mSchemeToFilter, "      Scheme: ");
        int numT = this.unregister_mime_types(f, "      Type: ");
        if (numS == 0 && numT == 0) {
            this.unregister_intent_filter(f, ((IntentFilter)f).actionsIterator(), this.mActionToFilter, "      Action: ");
        }
        if (numT != 0) {
            this.unregister_intent_filter(f, ((IntentFilter)f).actionsIterator(), this.mTypedActionToFilter, "      TypedAction: ");
        }
    }

    boolean dumpMap(PrintWriter out, String titlePrefix, String title, String prefix, ArrayMap<String, F[]> map, String packageName, boolean printFilter, boolean collapseDuplicates) {
        String eprefix = prefix + "  ";
        String fprefix = prefix + "    ";
        ArrayMap<Object, MutableInt> found = new ArrayMap<Object, MutableInt>();
        boolean printedSomething = false;
        PrintWriterPrinter printer = null;
        for (int mapi = 0; mapi < map.size(); ++mapi) {
            IntentFilter filter;
            int i;
            IntentFilter[] a = (IntentFilter[])map.valueAt(mapi);
            int N = a.length;
            boolean printedHeader = false;
            if (collapseDuplicates) {
                found.clear();
                for (i = 0; i < N && (filter = a[i]) != null; ++i) {
                    if (packageName != null && !this.isPackageForFilter(packageName, filter)) continue;
                    Object label = this.filterToLabel(filter);
                    int index = found.indexOfKey(label);
                    if (index < 0) {
                        found.put(label, new MutableInt(1));
                        continue;
                    }
                    ++((MutableInt)found.valueAt((int)index)).value;
                }
                for (i = 0; i < found.size(); ++i) {
                    if (title != null) {
                        out.print(titlePrefix);
                        out.println(title);
                        title = null;
                    }
                    if (!printedHeader) {
                        out.print(eprefix);
                        out.print(map.keyAt(mapi));
                        out.println(":");
                        printedHeader = true;
                    }
                    printedSomething = true;
                    this.dumpFilterLabel(out, fprefix, found.keyAt(i), ((MutableInt)found.valueAt((int)i)).value);
                }
                continue;
            }
            for (i = 0; i < N && (filter = a[i]) != null; ++i) {
                if (packageName != null && !this.isPackageForFilter(packageName, filter)) continue;
                if (title != null) {
                    out.print(titlePrefix);
                    out.println(title);
                    title = null;
                }
                if (!printedHeader) {
                    out.print(eprefix);
                    out.print(map.keyAt(mapi));
                    out.println(":");
                    printedHeader = true;
                }
                printedSomething = true;
                this.dumpFilter(out, fprefix, filter);
                if (!printFilter) continue;
                if (printer == null) {
                    printer = new PrintWriterPrinter(out);
                }
                filter.dump(printer, fprefix + "  ");
            }
        }
        return printedSomething;
    }

    public boolean dump(PrintWriter out, String title, String prefix, String packageName, boolean printFilter, boolean collapseDuplicates) {
        String innerPrefix = prefix + "  ";
        String sepPrefix = "\n" + prefix;
        String curPrefix = title + "\n" + prefix;
        if (this.dumpMap(out, curPrefix, "Full MIME Types:", innerPrefix, this.mTypeToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Base MIME Types:", innerPrefix, this.mBaseTypeToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Wild MIME Types:", innerPrefix, this.mWildTypeToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Schemes:", innerPrefix, this.mSchemeToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "Non-Data Actions:", innerPrefix, this.mActionToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        if (this.dumpMap(out, curPrefix, "MIME Typed Actions:", innerPrefix, this.mTypedActionToFilter, packageName, printFilter, collapseDuplicates)) {
            curPrefix = sepPrefix;
        }
        return curPrefix == sepPrefix;
    }

    public Iterator<F> filterIterator() {
        return new IteratorWrapper(this.mFilters.iterator());
    }

    public Set<F> filterSet() {
        return Collections.unmodifiableSet(this.mFilters);
    }

    public List<R> queryIntentFromList(Intent intent, String resolvedType, boolean defaultOnly, ArrayList<F[]> listCut, int userId) {
        ArrayList resultList = new ArrayList();
        boolean debug = (intent.getFlags() & 8) != 0;
        FastImmutableArraySet<String> categories = IntentResolver.getFastIntentCategories(intent);
        String scheme = intent.getScheme();
        int N = listCut.size();
        for (int i = 0; i < N; ++i) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (IntentFilter[])listCut.get(i), resultList, userId);
        }
        this.sortResults(resultList);
        return resultList;
    }

    public List<R> queryIntent(Intent intent, String resolvedType, boolean defaultOnly, int userId) {
        int slashpos;
        boolean debug;
        String scheme = intent.getScheme();
        ArrayList finalList = new ArrayList();
        boolean bl = debug = (intent.getFlags() & 8) != 0;
        if (debug) {
            Slog.v(TAG, "Resolving type=" + resolvedType + " scheme=" + scheme + " defaultOnly=" + defaultOnly + " userId=" + userId + " of " + intent);
        }
        Object[] firstTypeCut = null;
        Object[] secondTypeCut = null;
        Object[] thirdTypeCut = null;
        Object[] schemeCut = null;
        if (resolvedType != null && (slashpos = resolvedType.indexOf(47)) > 0) {
            String baseType = resolvedType.substring(0, slashpos);
            if (!baseType.equals("*")) {
                if (resolvedType.length() != slashpos + 2 || resolvedType.charAt(slashpos + 1) != '*') {
                    firstTypeCut = (IntentFilter[])this.mTypeToFilter.get(resolvedType);
                    if (debug) {
                        Slog.v(TAG, "First type cut: " + Arrays.toString(firstTypeCut));
                    }
                    secondTypeCut = (IntentFilter[])this.mWildTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v(TAG, "Second type cut: " + Arrays.toString(secondTypeCut));
                    }
                } else {
                    firstTypeCut = (IntentFilter[])this.mBaseTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v(TAG, "First type cut: " + Arrays.toString(firstTypeCut));
                    }
                    secondTypeCut = (IntentFilter[])this.mWildTypeToFilter.get(baseType);
                    if (debug) {
                        Slog.v(TAG, "Second type cut: " + Arrays.toString(secondTypeCut));
                    }
                }
                thirdTypeCut = (IntentFilter[])this.mWildTypeToFilter.get("*");
                if (debug) {
                    Slog.v(TAG, "Third type cut: " + Arrays.toString(thirdTypeCut));
                }
            } else if (intent.getAction() != null) {
                firstTypeCut = (IntentFilter[])this.mTypedActionToFilter.get(intent.getAction());
                if (debug) {
                    Slog.v(TAG, "Typed Action list: " + Arrays.toString(firstTypeCut));
                }
            }
        }
        if (scheme != null) {
            schemeCut = (IntentFilter[])this.mSchemeToFilter.get(scheme);
            if (debug) {
                Slog.v(TAG, "Scheme list: " + Arrays.toString(schemeCut));
            }
        }
        if (resolvedType == null && scheme == null && intent.getAction() != null) {
            firstTypeCut = (IntentFilter[])this.mActionToFilter.get(intent.getAction());
            if (debug) {
                Slog.v(TAG, "Action list: " + Arrays.toString(firstTypeCut));
            }
        }
        FastImmutableArraySet<String> categories = IntentResolver.getFastIntentCategories(intent);
        if (firstTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (IntentFilter[])firstTypeCut, finalList, userId);
        }
        if (secondTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (IntentFilter[])secondTypeCut, finalList, userId);
        }
        if (thirdTypeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (IntentFilter[])thirdTypeCut, finalList, userId);
        }
        if (schemeCut != null) {
            this.buildResolveList(intent, categories, debug, defaultOnly, resolvedType, scheme, (IntentFilter[])schemeCut, finalList, userId);
        }
        this.sortResults(finalList);
        if (debug) {
            Slog.v(TAG, "Final result list:");
            for (int i = 0; i < finalList.size(); ++i) {
                Slog.v(TAG, "  " + finalList.get(i));
            }
        }
        return finalList;
    }

    protected boolean allowFilterResult(F filter, List<R> dest) {
        return true;
    }

    protected boolean isFilterStopped(F filter, int userId) {
        return false;
    }

    protected boolean isFilterVerified(F filter) {
        return ((IntentFilter)filter).isVerified();
    }

    protected abstract boolean isPackageForFilter(String var1, F var2);

    protected abstract F[] newArray(int var1);

    protected R newResult(F filter, int match, int userId) {
        return (R)filter;
    }

    protected void sortResults(List<R> results) {
        Collections.sort(results, mResolvePrioritySorter);
    }

    protected void dumpFilter(PrintWriter out, String prefix, F filter) {
        out.print(prefix);
        out.println(filter);
    }

    protected Object filterToLabel(F filter) {
        return "IntentFilter";
    }

    protected void dumpFilterLabel(PrintWriter out, String prefix, Object label, int count) {
        out.print(prefix);
        out.print(label);
        out.print(": ");
        out.println(count);
    }

    private final void addFilter(ArrayMap<String, F[]> map, String name, F filter) {
        IntentFilter[] array2 = (IntentFilter[])map.get(name);
        if (array2 == null) {
            array2 = this.newArray(2);
            map.put(name, array2);
            array2[0] = filter;
        } else {
            int N;
            int i;
            for (i = N = array2.length; i > 0 && array2[i - 1] == null; --i) {
            }
            if (i < N) {
                array2[i] = filter;
            } else {
                IntentFilter[] newa = this.newArray(N * 3 / 2);
                System.arraycopy(array2, 0, newa, 0, N);
                newa[N] = filter;
                map.put(name, newa);
            }
        }
    }

    private final int register_mime_types(F filter, String prefix) {
        Iterator<String> i = ((IntentFilter)filter).typesIterator();
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            String baseName = name;
            int slashpos = name.indexOf(47);
            if (slashpos > 0) {
                baseName = name.substring(0, slashpos).intern();
            } else {
                name = name + "/*";
            }
            this.addFilter(this.mTypeToFilter, name, filter);
            if (slashpos > 0) {
                this.addFilter(this.mBaseTypeToFilter, baseName, filter);
                continue;
            }
            this.addFilter(this.mWildTypeToFilter, baseName, filter);
        }
        return num;
    }

    private final int unregister_mime_types(F filter, String prefix) {
        Iterator<String> i = ((IntentFilter)filter).typesIterator();
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            String baseName = name;
            int slashpos = name.indexOf(47);
            if (slashpos > 0) {
                baseName = name.substring(0, slashpos).intern();
            } else {
                name = name + "/*";
            }
            this.remove_all_objects(this.mTypeToFilter, name, filter);
            if (slashpos > 0) {
                this.remove_all_objects(this.mBaseTypeToFilter, baseName, filter);
                continue;
            }
            this.remove_all_objects(this.mWildTypeToFilter, baseName, filter);
        }
        return num;
    }

    private final int register_intent_filter(F filter, Iterator<String> i, ArrayMap<String, F[]> dest, String prefix) {
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            this.addFilter(dest, name, filter);
        }
        return num;
    }

    private final int unregister_intent_filter(F filter, Iterator<String> i, ArrayMap<String, F[]> dest, String prefix) {
        if (i == null) {
            return 0;
        }
        int num = 0;
        while (i.hasNext()) {
            String name = i.next();
            ++num;
            this.remove_all_objects(dest, name, filter);
        }
        return num;
    }

    private final void remove_all_objects(ArrayMap<String, F[]> map, String name, Object object) {
        IntentFilter[] array2 = (IntentFilter[])map.get(name);
        if (array2 != null) {
            int LAST;
            for (LAST = array2.length - 1; LAST >= 0 && array2[LAST] == null; --LAST) {
            }
            for (int idx = LAST; idx >= 0; --idx) {
                if (array2[idx] != object) continue;
                int remain = LAST - idx;
                if (remain > 0) {
                    System.arraycopy(array2, idx + 1, array2, idx, remain);
                }
                array2[LAST] = null;
                --LAST;
            }
            if (LAST < 0) {
                map.remove(name);
            } else if (LAST < array2.length / 2) {
                IntentFilter[] newa = this.newArray(LAST + 2);
                System.arraycopy(array2, 0, newa, 0, LAST + 1);
                map.put(name, newa);
            }
        }
    }

    private static FastImmutableArraySet<String> getFastIntentCategories(Intent intent) {
        Set<String> categories = intent.getCategories();
        if (categories == null) {
            return null;
        }
        return new FastImmutableArraySet<String>(categories.toArray(new String[categories.size()]));
    }

    private void buildResolveList(Intent intent, FastImmutableArraySet<String> categories, boolean debug, boolean defaultOnly, String resolvedType, String scheme, F[] src, List<R> dest, int userId) {
        F filter;
        FastPrintWriter logPrintWriter;
        LogPrinter logPrinter;
        String action = intent.getAction();
        Uri data = intent.getData();
        String packageName = intent.getPackage();
        boolean excludingStopped = intent.isExcludingStopped();
        if (debug) {
            logPrinter = new LogPrinter(2, TAG, 3);
            logPrintWriter = new FastPrintWriter(logPrinter);
        } else {
            logPrinter = null;
            logPrintWriter = null;
        }
        int N = src != null ? src.length : 0;
        boolean hasNonDefaults = false;
        for (int i = 0; i < N && (filter = src[i]) != null; ++i) {
            String reason;
            if (debug) {
                Slog.v(TAG, "Matching against filter " + filter);
            }
            if (excludingStopped && this.isFilterStopped(filter, userId)) {
                if (!debug) continue;
                Slog.v(TAG, "  Filter's target is stopped; skipping");
                continue;
            }
            if (packageName != null && !this.isPackageForFilter(packageName, filter)) {
                if (!debug) continue;
                Slog.v(TAG, "  Filter is not from package " + packageName + "; skipping");
                continue;
            }
            if (((IntentFilter)filter).getAutoVerify() && debug) {
                Slog.v(TAG, "  Filter verified: " + this.isFilterVerified(filter));
                int authorities = ((IntentFilter)filter).countDataAuthorities();
                for (int z = 0; z < authorities; ++z) {
                    Slog.v(TAG, "   " + ((IntentFilter)filter).getDataAuthority(z).getHost());
                }
            }
            if (!this.allowFilterResult(filter, dest)) {
                if (!debug) continue;
                Slog.v(TAG, "  Filter's target already added");
                continue;
            }
            int match = ((IntentFilter)filter).match(action, resolvedType, scheme, data, categories, TAG);
            if (match >= 0) {
                if (debug) {
                    Slog.v(TAG, "  Filter matched!  match=0x" + Integer.toHexString(match) + " hasDefault=" + ((IntentFilter)filter).hasCategory("android.intent.category.DEFAULT"));
                }
                if (!defaultOnly || ((IntentFilter)filter).hasCategory("android.intent.category.DEFAULT")) {
                    R oneResult = this.newResult(filter, match, userId);
                    if (oneResult == null) continue;
                    dest.add(oneResult);
                    if (!debug) continue;
                    this.dumpFilter(logPrintWriter, "    ", filter);
                    ((PrintWriter)logPrintWriter).flush();
                    ((IntentFilter)filter).dump(logPrinter, "    ");
                    continue;
                }
                hasNonDefaults = true;
                continue;
            }
            if (!debug) continue;
            switch (match) {
                case -3: {
                    reason = "action";
                    break;
                }
                case -4: {
                    reason = "category";
                    break;
                }
                case -2: {
                    reason = "data";
                    break;
                }
                case -1: {
                    reason = "type";
                    break;
                }
                default: {
                    reason = "unknown reason";
                }
            }
            Slog.v(TAG, "  Filter did not match: " + reason);
        }
        if (hasNonDefaults) {
            if (dest.size() == 0) {
                Slog.w(TAG, "resolveIntent failed: found match, but none with CATEGORY_DEFAULT");
            } else if (dest.size() > 1) {
                Slog.w(TAG, "resolveIntent: multiple matches, only some with CATEGORY_DEFAULT");
            }
        }
    }

    private class IteratorWrapper
    implements Iterator<F> {
        private final Iterator<F> mI;
        private F mCur;

        IteratorWrapper(Iterator<F> it) {
            this.mI = it;
        }

        @Override
        public boolean hasNext() {
            return this.mI.hasNext();
        }

        @Override
        public F next() {
            this.mCur = (IntentFilter)this.mI.next();
            return this.mCur;
        }

        @Override
        public void remove() {
            if (this.mCur != null) {
                IntentResolver.this.removeFilterInternal(this.mCur);
            }
            this.mI.remove();
        }
    }
}

