/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.backup.BackupManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.database.sqlite.SQLiteDatabase;
import android.os.Binder;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.IMountService;
import android.provider.Settings;
import android.security.KeyStore;
import android.service.gatekeeper.GateKeeperResponse;
import android.service.gatekeeper.IGateKeeperService;
import android.text.TextUtils;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.ILockSettings;
import com.android.internal.widget.LockPatternUtils;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.LockSettingsStorage;
import java.util.Arrays;
import java.util.List;

public class LockSettingsService
extends ILockSettings.Stub {
    private static final String PERMISSION = "android.permission.ACCESS_KEYGUARD_SECURE_STORAGE";
    private static final String TAG = "LockSettingsService";
    private final Context mContext;
    private final LockSettingsStorage mStorage;
    private LockPatternUtils mLockPatternUtils;
    private boolean mFirstCallToVold;
    private IGateKeeperService mGateKeeperService;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            int userHandle;
            if ("android.intent.action.USER_ADDED".equals(intent.getAction())) {
                int userHandle2 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                KeyStore ks = KeyStore.getInstance();
                UserManager um = (UserManager)LockSettingsService.this.mContext.getSystemService("user");
                UserInfo parentInfo = um.getProfileParent(userHandle2);
                int parentHandle = parentInfo != null ? parentInfo.id : -1;
                ks.onUserAdded(userHandle2, parentHandle);
            } else if ("android.intent.action.USER_STARTING".equals(intent.getAction())) {
                int userHandle3 = intent.getIntExtra("android.intent.extra.user_handle", 0);
                LockSettingsService.this.mStorage.prefetchUser(userHandle3);
            } else if ("android.intent.action.USER_REMOVED".equals(intent.getAction()) && (userHandle = intent.getIntExtra("android.intent.extra.user_handle", 0)) > 0) {
                LockSettingsService.this.removeUser(userHandle);
            }
        }
    };
    private static final String[] VALID_SETTINGS = new String[]{"lockscreen.lockedoutpermanently", "lockscreen.lockoutattemptdeadline", "lockscreen.patterneverchosen", "lockscreen.password_type", "lockscreen.password_type_alternate", "lockscreen.password_salt", "lockscreen.disabled", "lockscreen.options", "lockscreen.biometric_weak_fallback", "lockscreen.biometricweakeverchosen", "lockscreen.power_button_instantly_locks", "lockscreen.passwordhistory", "lock_pattern_autolock", "lock_biometric_weak_flags", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled"};
    private static final String[] READ_CONTACTS_PROTECTED_SETTINGS = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};
    private static final String[] READ_PASSWORD_PROTECTED_SETTINGS = new String[]{"lockscreen.password_salt", "lockscreen.passwordhistory", "lockscreen.password_type"};
    private static final String[] SETTINGS_TO_BACKUP = new String[]{"lock_screen_owner_info_enabled", "lock_screen_owner_info"};

    public LockSettingsService(Context context) {
        this.mContext = context;
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.mFirstCallToVold = true;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_STARTING");
        filter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(this.mBroadcastReceiver, UserHandle.ALL, filter, null, null);
        this.mStorage = new LockSettingsStorage(context, new LockSettingsStorage.Callback(){

            @Override
            public void initialize(SQLiteDatabase db) {
                boolean lockScreenDisable = SystemProperties.getBoolean("ro.lockscreen.disable.default", false);
                if (lockScreenDisable) {
                    LockSettingsService.this.mStorage.writeKeyValue(db, "lockscreen.disabled", "1", 0);
                }
            }
        });
    }

    public void systemReady() {
        this.migrateOldData();
        try {
            this.getGateKeeperService();
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failure retrieving IGateKeeperService", e);
        }
        this.mStorage.prefetchUser(0);
    }

    private void migrateOldData() {
        try {
            List<UserInfo> users;
            UserManager um;
            if (this.getString("migrated", null, 0) == null) {
                ContentResolver cr = this.mContext.getContentResolver();
                for (String validSetting : VALID_SETTINGS) {
                    String value = Settings.Secure.getString(cr, validSetting);
                    if (value == null) continue;
                    this.setString(validSetting, value, 0);
                }
                this.setString("migrated", "true", 0);
                Slog.i(TAG, "Migrated lock settings to new location");
            }
            if (this.getString("migrated_user_specific", null, 0) == null) {
                um = (UserManager)this.mContext.getSystemService("user");
                ContentResolver cr = this.mContext.getContentResolver();
                List<UserInfo> users2 = um.getUsers();
                for (int user = 0; user < users2.size(); ++user) {
                    int userId;
                    block16: {
                        userId = users2.get((int)user).id;
                        String OWNER_INFO = "lock_screen_owner_info";
                        String ownerInfo = Settings.Secure.getStringForUser(cr, "lock_screen_owner_info", userId);
                        if (ownerInfo != null) {
                            this.setString("lock_screen_owner_info", ownerInfo, userId);
                            Settings.Secure.putStringForUser(cr, ownerInfo, "", userId);
                        }
                        String OWNER_INFO_ENABLED = "lock_screen_owner_info_enabled";
                        try {
                            int ivalue = Settings.Secure.getIntForUser(cr, "lock_screen_owner_info_enabled", userId);
                            boolean enabled = ivalue != 0;
                            this.setLong("lock_screen_owner_info_enabled", enabled ? 1L : 0L, userId);
                        }
                        catch (Settings.SettingNotFoundException e) {
                            if (TextUtils.isEmpty(ownerInfo)) break block16;
                            this.setLong("lock_screen_owner_info_enabled", 1L, userId);
                        }
                    }
                    Settings.Secure.putIntForUser(cr, "lock_screen_owner_info_enabled", 0, userId);
                }
                this.setString("migrated_user_specific", "true", 0);
                Slog.i(TAG, "Migrated per-user lock settings to new location");
            }
            if (this.getString("migrated_biometric_weak", null, 0) == null) {
                um = (UserManager)this.mContext.getSystemService("user");
                users = um.getUsers();
                for (int i = 0; i < users.size(); ++i) {
                    int userId = users.get((int)i).id;
                    long type = this.getLong("lockscreen.password_type", 0L, userId);
                    long alternateType = this.getLong("lockscreen.password_type_alternate", 0L, userId);
                    if (type == 32768L) {
                        this.setLong("lockscreen.password_type", alternateType, userId);
                    }
                    this.setLong("lockscreen.password_type_alternate", 0L, userId);
                }
                this.setString("migrated_biometric_weak", "true", 0);
                Slog.i(TAG, "Migrated biometric weak to use the fallback instead");
            }
            if (this.getString("migrated_lockscreen_disabled", null, 0) == null) {
                int i;
                um = (UserManager)this.mContext.getSystemService("user");
                users = um.getUsers();
                int userCount = users.size();
                int switchableUsers = 0;
                for (i = 0; i < userCount; ++i) {
                    if (!users.get(i).supportsSwitchTo()) continue;
                    ++switchableUsers;
                }
                if (switchableUsers > 1) {
                    for (i = 0; i < userCount; ++i) {
                        int id2 = users.get((int)i).id;
                        if (!this.getBoolean("lockscreen.disabled", false, id2)) continue;
                        this.setBoolean("lockscreen.disabled", false, id2);
                    }
                }
                this.setString("migrated_lockscreen_disabled", "true", 0);
                Slog.i(TAG, "Migrated lockscreen disabled flag");
            }
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Unable to migrate old data", re);
        }
    }

    private final void checkWritePermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsWrite");
    }

    private final void checkPasswordReadPermission(int userId) {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "LockSettingsRead");
    }

    private final void checkReadPermission(String requestedKey, int userId) {
        String key;
        int i;
        int callingUid = Binder.getCallingUid();
        for (i = 0; i < READ_CONTACTS_PROTECTED_SETTINGS.length; ++i) {
            key = READ_CONTACTS_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission("android.permission.READ_CONTACTS") == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + "android.permission.READ_CONTACTS" + " to read " + requestedKey + " for user " + userId);
        }
        for (i = 0; i < READ_PASSWORD_PROTECTED_SETTINGS.length; ++i) {
            key = READ_PASSWORD_PROTECTED_SETTINGS[i];
            if (!key.equals(requestedKey) || this.mContext.checkCallingOrSelfPermission(PERMISSION) == 0) continue;
            throw new SecurityException("uid=" + callingUid + " needs permission " + PERMISSION + " to read " + requestedKey + " for user " + userId);
        }
    }

    @Override
    public void setBoolean(String key, boolean value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value ? "1" : "0");
    }

    @Override
    public void setLong(String key, long value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, Long.toString(value));
    }

    @Override
    public void setString(String key, String value, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        this.setStringUnchecked(key, userId, value);
    }

    private void setStringUnchecked(String key, int userId, String value) {
        this.mStorage.writeKeyValue(key, value, userId);
        if (ArrayUtils.contains(SETTINGS_TO_BACKUP, key)) {
            BackupManager.dataChanged("com.android.providers.settings");
        }
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : value.equals("1") || value.equals("true");
    }

    @Override
    public long getLong(String key, long defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        String value = this.getStringUnchecked(key, null, userId);
        return TextUtils.isEmpty(value) ? defaultValue : Long.parseLong(value);
    }

    @Override
    public String getString(String key, String defaultValue, int userId) throws RemoteException {
        this.checkReadPermission(key, userId);
        return this.getStringUnchecked(key, defaultValue, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringUnchecked(String key, String defaultValue, int userId) {
        if ("lock_pattern_autolock".equals(key)) {
            long ident = Binder.clearCallingIdentity();
            try {
                String string2 = this.mLockPatternUtils.isLockPatternEnabled(userId) ? "1" : "0";
                return string2;
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return this.mStorage.readKeyValue(key, defaultValue, userId);
    }

    @Override
    public boolean havePassword(int userId) throws RemoteException {
        return this.mStorage.hasPassword(userId);
    }

    @Override
    public boolean havePattern(int userId) throws RemoteException {
        return this.mStorage.hasPattern(userId);
    }

    private void setKeystorePassword(String password, int userHandle) {
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        KeyStore ks = KeyStore.getInstance();
        List<UserInfo> profiles = um.getProfiles(userHandle);
        for (UserInfo pi : profiles) {
            ks.onUserPasswordChanged(pi.id, password);
        }
    }

    private void unlockKeystore(String password, int userHandle) {
        UserManager um = (UserManager)this.mContext.getSystemService("user");
        KeyStore ks = KeyStore.getInstance();
        List<UserInfo> profiles = um.getProfiles(userHandle);
        for (UserInfo pi : profiles) {
            ks.unlock(pi.id, password);
        }
    }

    private byte[] getCurrentHandle(int userId) {
        byte[] currentHandle;
        int currentHandleType = this.mStorage.getStoredCredentialType(userId);
        switch (currentHandleType) {
            case 1: {
                LockSettingsStorage.CredentialHash credential = this.mStorage.readPatternHash(userId);
                currentHandle = credential != null ? credential.hash : null;
                break;
            }
            case 2: {
                LockSettingsStorage.CredentialHash credential = this.mStorage.readPasswordHash(userId);
                currentHandle = credential != null ? credential.hash : null;
                break;
            }
            default: {
                currentHandle = null;
            }
        }
        if (currentHandleType != -1 && currentHandle == null) {
            Slog.e(TAG, "Stored handle type [" + currentHandleType + "] but no handle available");
        }
        return currentHandle;
    }

    @Override
    public void setLockPattern(String pattern, String savedCredential, int userId) throws RemoteException {
        byte[] enrolledHandle;
        byte[] currentHandle = this.getCurrentHandle(userId);
        if (pattern == null) {
            this.getGateKeeperService().clearSecureUserId(userId);
            this.mStorage.writePatternHash(null, userId);
            this.setKeystorePassword(null, userId);
            return;
        }
        if (currentHandle == null) {
            if (savedCredential != null) {
                Slog.w(TAG, "Saved credential provided, but none stored");
            }
            savedCredential = null;
        }
        if ((enrolledHandle = this.enrollCredential(currentHandle, savedCredential, pattern, userId)) != null) {
            this.mStorage.writePatternHash(enrolledHandle, userId);
        } else {
            Slog.e(TAG, "Failed to enroll pattern");
        }
    }

    @Override
    public void setLockPassword(String password, String savedCredential, int userId) throws RemoteException {
        byte[] enrolledHandle;
        byte[] currentHandle = this.getCurrentHandle(userId);
        if (password == null) {
            this.getGateKeeperService().clearSecureUserId(userId);
            this.mStorage.writePasswordHash(null, userId);
            this.setKeystorePassword(null, userId);
            return;
        }
        if (currentHandle == null) {
            if (savedCredential != null) {
                Slog.w(TAG, "Saved credential provided, but none stored");
            }
            savedCredential = null;
        }
        if ((enrolledHandle = this.enrollCredential(currentHandle, savedCredential, password, userId)) != null) {
            this.mStorage.writePasswordHash(enrolledHandle, userId);
        } else {
            Slog.e(TAG, "Failed to enroll password");
        }
    }

    private byte[] enrollCredential(byte[] enrolledHandle, String enrolledCredential, String toEnroll, int userId) throws RemoteException {
        this.checkWritePermission(userId);
        byte[] enrolledCredentialBytes = enrolledCredential == null ? null : enrolledCredential.getBytes();
        byte[] toEnrollBytes = toEnroll == null ? null : toEnroll.getBytes();
        GateKeeperResponse response = this.getGateKeeperService().enroll(userId, enrolledHandle, enrolledCredentialBytes, toEnrollBytes);
        if (response == null) {
            return null;
        }
        byte[] hash = response.getPayload();
        if (hash != null) {
            this.setKeystorePassword(toEnroll, userId);
        } else {
            Slog.e(TAG, "Throttled while enrolling a password");
        }
        return hash;
    }

    @Override
    public VerifyCredentialResponse checkPattern(String pattern, int userId) throws RemoteException {
        return this.doVerifyPattern(pattern, false, 0L, userId);
    }

    @Override
    public VerifyCredentialResponse verifyPattern(String pattern, long challenge, int userId) throws RemoteException {
        return this.doVerifyPattern(pattern, true, challenge, userId);
    }

    private VerifyCredentialResponse doVerifyPattern(String pattern, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        LockSettingsStorage.CredentialHash storedHash = this.mStorage.readPatternHash(userId);
        boolean shouldReEnrollBaseZero = storedHash != null && storedHash.isBaseZeroPattern;
        String patternToVerify = shouldReEnrollBaseZero ? LockPatternUtils.patternStringToBaseZero(pattern) : pattern;
        VerifyCredentialResponse response = this.verifyCredential(userId, storedHash, patternToVerify, hasChallenge, challenge, new CredentialUtil(){

            @Override
            public void setCredential(String pattern, String oldPattern, int userId) throws RemoteException {
                LockSettingsService.this.setLockPattern(pattern, oldPattern, userId);
            }

            @Override
            public byte[] toHash(String pattern, int userId) {
                return LockPatternUtils.patternToHash(LockPatternUtils.stringToPattern(pattern));
            }

            @Override
            public String adjustForKeystore(String pattern) {
                return LockPatternUtils.patternStringToBaseZero(pattern);
            }
        });
        if (response.getResponseCode() == 0 && shouldReEnrollBaseZero) {
            this.setLockPattern(pattern, patternToVerify, userId);
        }
        return response;
    }

    @Override
    public VerifyCredentialResponse checkPassword(String password, int userId) throws RemoteException {
        return this.doVerifyPassword(password, false, 0L, userId);
    }

    @Override
    public VerifyCredentialResponse verifyPassword(String password, long challenge, int userId) throws RemoteException {
        return this.doVerifyPassword(password, true, challenge, userId);
    }

    private VerifyCredentialResponse doVerifyPassword(String password, boolean hasChallenge, long challenge, int userId) throws RemoteException {
        this.checkPasswordReadPermission(userId);
        LockSettingsStorage.CredentialHash storedHash = this.mStorage.readPasswordHash(userId);
        return this.verifyCredential(userId, storedHash, password, hasChallenge, challenge, new CredentialUtil(){

            @Override
            public void setCredential(String password, String oldPassword, int userId) throws RemoteException {
                LockSettingsService.this.setLockPassword(password, oldPassword, userId);
            }

            @Override
            public byte[] toHash(String password, int userId) {
                return LockSettingsService.this.mLockPatternUtils.passwordToHash(password, userId);
            }

            @Override
            public String adjustForKeystore(String password) {
                return password;
            }
        });
    }

    private VerifyCredentialResponse verifyCredential(int userId, LockSettingsStorage.CredentialHash storedHash, String credential, boolean hasChallenge, long challenge, CredentialUtil credentialUtil) throws RemoteException {
        VerifyCredentialResponse response;
        if ((storedHash == null || storedHash.hash.length == 0) && TextUtils.isEmpty(credential)) {
            return VerifyCredentialResponse.OK;
        }
        if (TextUtils.isEmpty(credential)) {
            return VerifyCredentialResponse.ERROR;
        }
        if (storedHash.version == 0) {
            byte[] hash = credentialUtil.toHash(credential, userId);
            if (Arrays.equals(hash, storedHash.hash)) {
                this.unlockKeystore(credentialUtil.adjustForKeystore(credential), userId);
                credentialUtil.setCredential(credential, null, userId);
                if (!hasChallenge) {
                    return VerifyCredentialResponse.OK;
                }
            } else {
                return VerifyCredentialResponse.ERROR;
            }
        }
        boolean shouldReEnroll = false;
        if (hasChallenge) {
            byte[] token = null;
            GateKeeperResponse gateKeeperResponse = this.getGateKeeperService().verifyChallenge(userId, challenge, storedHash.hash, credential.getBytes());
            int responseCode = gateKeeperResponse.getResponseCode();
            if (responseCode == 1) {
                response = new VerifyCredentialResponse(gateKeeperResponse.getTimeout());
            } else if (responseCode == 0) {
                token = gateKeeperResponse.getPayload();
                if (token == null) {
                    Slog.e(TAG, "verifyChallenge response had no associated payload");
                    response = VerifyCredentialResponse.ERROR;
                } else {
                    shouldReEnroll = gateKeeperResponse.getShouldReEnroll();
                    response = new VerifyCredentialResponse(token);
                }
            } else {
                response = VerifyCredentialResponse.ERROR;
            }
        } else {
            GateKeeperResponse gateKeeperResponse = this.getGateKeeperService().verify(userId, storedHash.hash, credential.getBytes());
            int responseCode = gateKeeperResponse.getResponseCode();
            if (responseCode == 1) {
                response = new VerifyCredentialResponse(gateKeeperResponse.getTimeout());
            } else if (responseCode == 0) {
                shouldReEnroll = gateKeeperResponse.getShouldReEnroll();
                response = VerifyCredentialResponse.OK;
            } else {
                response = VerifyCredentialResponse.ERROR;
            }
        }
        if (response.getResponseCode() == 0) {
            this.unlockKeystore(credential, userId);
            if (shouldReEnroll) {
                credentialUtil.setCredential(credential, credential, userId);
            }
        }
        return response;
    }

    @Override
    public boolean checkVoldPassword(int userId) throws RemoteException {
        if (!this.mFirstCallToVold) {
            return false;
        }
        this.mFirstCallToVold = false;
        this.checkPasswordReadPermission(userId);
        IMountService service = this.getMountService();
        String password = service.getPassword();
        service.clearPassword();
        if (password == null) {
            return false;
        }
        try {
            if (this.mLockPatternUtils.isLockPatternEnabled(userId) && this.checkPattern(password, userId).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.mLockPatternUtils.isLockPasswordEnabled(userId) && this.checkPassword(password, userId).getResponseCode() == 0) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return false;
    }

    private void removeUser(int userId) {
        this.mStorage.removeUser(userId);
        KeyStore ks = KeyStore.getInstance();
        ks.onUserRemoved(userId);
        try {
            IGateKeeperService gk = this.getGateKeeperService();
            if (gk != null) {
                gk.clearSecureUserId(userId);
            }
        }
        catch (RemoteException ex) {
            Slog.w(TAG, "unable to clear GK secure user id");
        }
    }

    private IMountService getMountService() {
        IBinder service = ServiceManager.getService("mount");
        if (service != null) {
            return IMountService.Stub.asInterface(service);
        }
        return null;
    }

    private synchronized IGateKeeperService getGateKeeperService() throws RemoteException {
        if (this.mGateKeeperService != null) {
            return this.mGateKeeperService;
        }
        IBinder service = ServiceManager.getService("android.service.gatekeeper.IGateKeeperService");
        if (service != null) {
            service.linkToDeath(new GateKeeperDiedRecipient(), 0);
            this.mGateKeeperService = IGateKeeperService.Stub.asInterface(service);
            return this.mGateKeeperService;
        }
        Slog.e(TAG, "Unable to acquire GateKeeperService");
        return null;
    }

    private class GateKeeperDiedRecipient
    implements IBinder.DeathRecipient {
        private GateKeeperDiedRecipient() {
        }

        @Override
        public void binderDied() {
            LockSettingsService.this.mGateKeeperService.asBinder().unlinkToDeath(this, 0);
            LockSettingsService.this.mGateKeeperService = null;
        }
    }

    private static interface CredentialUtil {
        public void setCredential(String var1, String var2, int var3) throws RemoteException;

        public byte[] toHash(String var1, int var2);

        public String adjustForKeystore(String var1);
    }
}

