/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.ActivityManagerNative;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.MountService;
import java.util.Calendar;

public class MountServiceIdler
extends JobService {
    private static final String TAG = "MountServiceIdler";
    private static ComponentName sIdleService = new ComponentName("android", MountServiceIdler.class.getName());
    private static int MOUNT_JOB_ID = 808;
    private boolean mStarted;
    private JobParameters mJobParams;
    private Runnable mFinishCallback = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Slog.i(MountServiceIdler.TAG, "Got mount service completion callback");
            Runnable runnable = MountServiceIdler.this.mFinishCallback;
            synchronized (runnable) {
                if (MountServiceIdler.this.mStarted) {
                    MountServiceIdler.this.jobFinished(MountServiceIdler.this.mJobParams, false);
                    MountServiceIdler.this.mStarted = false;
                }
            }
            MountServiceIdler.scheduleIdlePass(MountServiceIdler.this);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStartJob(JobParameters params) {
        try {
            ActivityManagerNative.getDefault().performIdleMaintenance();
        }
        catch (RemoteException e) {
            // empty catch block
        }
        this.mJobParams = params;
        MountService ms = MountService.sSelf;
        if (ms != null) {
            Runnable runnable = this.mFinishCallback;
            synchronized (runnable) {
                this.mStarted = true;
            }
            ms.runIdleMaintenance(this.mFinishCallback);
        }
        return ms != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onStopJob(JobParameters params) {
        Runnable runnable = this.mFinishCallback;
        synchronized (runnable) {
            this.mStarted = false;
        }
        return false;
    }

    public static void scheduleIdlePass(Context context) {
        JobScheduler tm = (JobScheduler)context.getSystemService("jobscheduler");
        Calendar calendar = MountServiceIdler.tomorrowMidnight();
        long timeToMidnight = calendar.getTimeInMillis() - System.currentTimeMillis();
        JobInfo.Builder builder = new JobInfo.Builder(MOUNT_JOB_ID, sIdleService);
        builder.setRequiresDeviceIdle(true);
        builder.setRequiresCharging(true);
        builder.setMinimumLatency(timeToMidnight);
        tm.schedule(builder.build());
    }

    private static Calendar tomorrowMidnight() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(System.currentTimeMillis());
        calendar.set(11, 3);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar;
    }
}

