/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkScorerAppManager;
import android.net.ScoredNetwork;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetworkScoreService
extends INetworkScoreService.Stub {
    private static final String TAG = "NetworkScoreService";
    private final Context mContext;
    private final Map<Integer, INetworkScoreCache> mScoreCaches;
    private Object mReceiverLock = new Object[0];
    @GuardedBy(value="mReceiverLock")
    private ScorerChangedReceiver mReceiver;

    public NetworkScoreService(Context context) {
        this.mContext = context;
        this.mScoreCaches = new HashMap<Integer, INetworkScoreCache>();
    }

    void systemReady() {
        ContentResolver cr = this.mContext.getContentResolver();
        if (Settings.Global.getInt(cr, "network_scoring_provisioned", 0) == 0) {
            String defaultPackage = this.mContext.getResources().getString(17039433);
            if (!TextUtils.isEmpty(defaultPackage)) {
                NetworkScorerAppManager.setActiveScorer(this.mContext, defaultPackage);
            }
            Settings.Global.putInt(cr, "network_scoring_provisioned", 1);
        }
        this.registerPackageReceiverIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPackageReceiverIfNeeded() {
        NetworkScorerAppManager.NetworkScorerAppData scorer = NetworkScorerAppManager.getActiveScorer(this.mContext);
        Object object = this.mReceiverLock;
        synchronized (object) {
            if (this.mReceiver != null) {
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Unregistering receiver for " + this.mReceiver.mRegisteredPackage);
                }
                this.mContext.unregisterReceiver(this.mReceiver);
                this.mReceiver = null;
            }
            if (scorer != null) {
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.intent.action.PACKAGE_CHANGED");
                filter.addAction("android.intent.action.PACKAGE_REPLACED");
                filter.addAction("android.intent.action.PACKAGE_FULLY_REMOVED");
                filter.addDataScheme("package");
                filter.addDataSchemeSpecificPart(scorer.mPackageName, 0);
                this.mReceiver = new ScorerChangedReceiver(scorer.mPackageName);
                this.mContext.registerReceiverAsUser(this.mReceiver, UserHandle.OWNER, filter, null, null);
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Registered receiver for " + scorer.mPackageName);
                }
            }
        }
    }

    @Override
    public boolean updateScores(ScoredNetwork[] networks) {
        if (!NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid())) {
            throw new SecurityException("Caller with UID " + NetworkScoreService.getCallingUid() + " is not the active scorer.");
        }
        HashMap<Integer, ArrayList<ScoredNetwork>> networksByType = new HashMap<Integer, ArrayList<ScoredNetwork>>();
        for (ScoredNetwork network : networks) {
            ArrayList<ScoredNetwork> networkList = (ArrayList<ScoredNetwork>)networksByType.get(network.networkKey.type);
            if (networkList == null) {
                networkList = new ArrayList<ScoredNetwork>();
                networksByType.put(network.networkKey.type, networkList);
            }
            networkList.add(network);
        }
        for (Map.Entry entry : networksByType.entrySet()) {
            INetworkScoreCache scoreCache = this.mScoreCaches.get(entry.getKey());
            if (scoreCache != null) {
                try {
                    scoreCache.updateScores((List)entry.getValue());
                }
                catch (RemoteException e) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Unable to update scores of type " + entry.getKey(), e);
                }
                continue;
            }
            if (!Log.isLoggable(TAG, 2)) continue;
            Log.v(TAG, "No scorer registered for type " + entry.getKey() + ", discarding");
        }
        return true;
    }

    @Override
    public boolean clearScores() {
        if (NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid()) || this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED") == 0) {
            this.clearInternal();
            return true;
        }
        throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
    }

    @Override
    public boolean setActiveScorer(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SCORE_NETWORKS", TAG);
        return this.setScorerInternal(packageName);
    }

    @Override
    public void disableScoring() {
        if (!NetworkScorerAppManager.isCallerActiveScorer(this.mContext, NetworkScoreService.getCallingUid()) && this.mContext.checkCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED") != 0) {
            throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
        }
        this.setScorerInternal(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setScorerInternal(String packageName) {
        long token = Binder.clearCallingIdentity();
        try {
            this.clearInternal();
            boolean result = NetworkScorerAppManager.setActiveScorer(this.mContext, packageName);
            if (result) {
                this.registerPackageReceiverIfNeeded();
                Intent intent = new Intent("android.net.scoring.SCORER_CHANGED");
                intent.putExtra("newScorer", packageName);
                this.mContext.sendBroadcastAsUser(intent, UserHandle.ALL);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private void clearInternal() {
        Set<INetworkScoreCache> cachesToClear = this.getScoreCaches();
        for (INetworkScoreCache scoreCache : cachesToClear) {
            try {
                scoreCache.clearScores();
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to clear scores", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BROADCAST_NETWORK_PRIVILEGED", TAG);
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            if (this.mScoreCaches.containsKey(networkType)) {
                throw new IllegalArgumentException("Score cache already registered for type " + networkType);
            }
            this.mScoreCaches.put(networkType, scoreCache);
        }
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        NetworkScorerAppManager.NetworkScorerAppData currentScorer = NetworkScorerAppManager.getActiveScorer(this.mContext);
        if (currentScorer == null) {
            writer.println("Scoring is disabled.");
            return;
        }
        writer.println("Current scorer: " + currentScorer.mPackageName);
        writer.flush();
        for (INetworkScoreCache scoreCache : this.getScoreCaches()) {
            try {
                scoreCache.asBinder().dump(fd, args);
            }
            catch (RemoteException e) {
                writer.println("Unable to dump score cache");
                if (!Log.isLoggable(TAG, 2)) continue;
                Log.v(TAG, "Unable to dump score cache", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<INetworkScoreCache> getScoreCaches() {
        Map<Integer, INetworkScoreCache> map = this.mScoreCaches;
        synchronized (map) {
            return new HashSet<INetworkScoreCache>(this.mScoreCaches.values());
        }
    }

    private class ScorerChangedReceiver
    extends BroadcastReceiver {
        final String mRegisteredPackage;

        ScorerChangedReceiver(String packageName) {
            this.mRegisteredPackage = packageName;
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (("android.intent.action.PACKAGE_CHANGED".equals(action) || "android.intent.action.PACKAGE_REPLACED".equals(action) || "android.intent.action.PACKAGE_FULLY_REMOVED".equals(action)) && NetworkScorerAppManager.getActiveScorer(NetworkScoreService.this.mContext) == null) {
                Log.i(NetworkScoreService.TAG, "Package " + this.mRegisteredPackage + " is no longer valid, disabling scoring");
                NetworkScoreService.this.setScorerInternal(null);
            }
        }
    }
}

