/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accessibility;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.accessibilityservice.IAccessibilityServiceClient;
import android.accessibilityservice.IAccessibilityServiceConnection;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Region;
import android.hardware.display.DisplayManager;
import android.hardware.input.InputManager;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Pools;
import android.util.Slog;
import android.util.SparseArray;
import android.view.Display;
import android.view.IWindow;
import android.view.InputEventConsistencyVerifier;
import android.view.KeyEvent;
import android.view.MagnificationSpec;
import android.view.WindowInfo;
import android.view.WindowManagerInternal;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityInteractionClient;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnection;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import android.view.accessibility.IAccessibilityManager;
import android.view.accessibility.IAccessibilityManagerClient;
import com.android.internal.content.PackageMonitor;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.accessibility.AccessibilityInputFilter;
import com.android.server.accessibility.DisplayAdjustmentUtils;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.xmlpull.v1.XmlPullParserException;

public class AccessibilityManagerService
extends IAccessibilityManager.Stub {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "AccessibilityManagerService";
    private static final int WAIT_FOR_USER_STATE_FULLY_INITIALIZED_MILLIS = 3000;
    private static final int WAIT_WINDOWS_TIMEOUT_MILLIS = 5000;
    private static final String FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE = "registerUiTestAutomationService";
    private static final String TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED = "temporaryEnableAccessibilityStateUntilKeyguardRemoved";
    private static final String GET_WINDOW_TOKEN = "getWindowToken";
    private static final ComponentName sFakeAccessibilityServiceComponentName = new ComponentName("foo.bar", "FakeService");
    private static final String FUNCTION_DUMP = "dump";
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final int OWN_PROCESS_ID = Process.myPid();
    private static final int MAX_POOL_SIZE = 10;
    private static final int WINDOW_ID_UNKNOWN = -1;
    private static int sIdCounter = 0;
    private static int sNextWindowId;
    private final Context mContext;
    private final Object mLock = new Object();
    private final Pools.Pool<PendingEvent> mPendingEventPool = new Pools.SimplePool<PendingEvent>(10);
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private final List<AccessibilityServiceInfo> mEnabledServicesForFeedbackTempList = new ArrayList<AccessibilityServiceInfo>();
    private final Rect mTempRect = new Rect();
    private final Rect mTempRect1 = new Rect();
    private final Point mTempPoint = new Point();
    private final PackageManager mPackageManager;
    private final WindowManagerInternal mWindowManagerService;
    private final SecurityPolicy mSecurityPolicy;
    private final MainHandler mMainHandler;
    private InteractionBridge mInteractionBridge;
    private AlertDialog mEnableTouchExplorationDialog;
    private AccessibilityInputFilter mInputFilter;
    private boolean mHasInputFilter;
    private final Set<ComponentName> mTempComponentNameSet = new HashSet<ComponentName>();
    private final List<AccessibilityServiceInfo> mTempAccessibilityServiceInfoList = new ArrayList<AccessibilityServiceInfo>();
    private final RemoteCallbackList<IAccessibilityManagerClient> mGlobalClients = new RemoteCallbackList();
    private final SparseArray<AccessibilityConnectionWrapper> mGlobalInteractionConnections = new SparseArray();
    private final SparseArray<IBinder> mGlobalWindowTokens = new SparseArray();
    private final SparseArray<UserState> mUserStates = new SparseArray();
    private final UserManager mUserManager;
    private final LockPatternUtils mLockPatternUtils;
    private int mCurrentUserId = 0;
    private boolean mInitialized;
    private WindowsForAccessibilityCallback mWindowsForAccessibilityCallback;

    private UserState getCurrentUserStateLocked() {
        return this.getUserStateLocked(this.mCurrentUserId);
    }

    public AccessibilityManagerService(Context context) {
        this.mContext = context;
        this.mPackageManager = this.mContext.getPackageManager();
        this.mWindowManagerService = LocalServices.getService(WindowManagerInternal.class);
        this.mUserManager = (UserManager)context.getSystemService("user");
        this.mSecurityPolicy = new SecurityPolicy();
        this.mMainHandler = new MainHandler(this.mContext.getMainLooper());
        this.mLockPatternUtils = new LockPatternUtils(context);
        this.registerBroadcastReceivers();
        new AccessibilityContentObserver(this.mMainHandler).register(context.getContentResolver());
    }

    private UserState getUserStateLocked(int userId) {
        UserState state = this.mUserStates.get(userId);
        if (state == null) {
            state = new UserState(userId);
            this.mUserStates.put(userId, state);
        }
        return state;
    }

    private void registerBroadcastReceivers() {
        PackageMonitor monitor = new PackageMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSomePackagesChanged() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    if (this.getChangingUserId() != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    userState.mInstalledServices.clear();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPackageRemoved(String packageName, int uid) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        if (!compPkg.equals(packageName)) continue;
                        it.remove();
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                        userState.mTouchExplorationGrantedServices.remove(comp);
                        AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", userState.mTouchExplorationGrantedServices, userId);
                        if (userState.mUiAutomationService == null) {
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                        return;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    int userId = this.getChangingUserId();
                    if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                        return false;
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(userId);
                    Iterator<ComponentName> it = userState.mEnabledServices.iterator();
                    while (it.hasNext()) {
                        ComponentName comp = it.next();
                        String compPkg = comp.getPackageName();
                        for (String pkg : packages) {
                            if (!compPkg.equals(pkg)) continue;
                            if (!doit) {
                                return true;
                            }
                            it.remove();
                            AccessibilityManagerService.this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, userId);
                            if (userState.mUiAutomationService != null) continue;
                            AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                        }
                    }
                    return false;
                }
            }
        };
        monitor.register(this.mContext, null, UserHandle.ALL, true);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_SWITCHED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_PRESENT");
        intentFilter.addAction("android.os.action.SETTING_RESTORED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String which;
                String action = intent.getAction();
                if ("android.intent.action.USER_SWITCHED".equals(action)) {
                    AccessibilityManagerService.this.switchUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    AccessibilityManagerService.this.removeUser(intent.getIntExtra("android.intent.extra.user_handle", 0));
                } else if ("android.intent.action.USER_PRESENT".equals(action)) {
                    UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                    if (userState.mUiAutomationService == null && AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if ("android.os.action.SETTING_RESTORED".equals(action) && "enabled_accessibility_services".equals(which = intent.getStringExtra("setting_name"))) {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        AccessibilityManagerService.this.restoreEnabledAccessibilityServicesLocked(intent.getStringExtra("previous_value"), intent.getStringExtra("new_value"));
                    }
                }
            }
        }, UserHandle.ALL, intentFilter, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addClient(IAccessibilityManagerClient client, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                this.mGlobalClients.register(client);
                return userState.getClientState();
            }
            userState.mClients.register(client);
            return resolvedUserId == this.mCurrentUserId ? userState.getClientState() : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendAccessibilityEvent(AccessibilityEvent event, int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return true;
            }
            if (this.mSecurityPolicy.canDispatchAccessibilityEventLocked(event)) {
                this.mSecurityPolicy.updateActiveAndAccessibilityFocusedWindowLocked(event.getWindowId(), event.getSourceNodeId(), event.getEventType());
                this.mSecurityPolicy.updateEventSourceLocked(event);
                this.notifyAccessibilityServicesDelayedLocked(event, false);
                this.notifyAccessibilityServicesDelayedLocked(event, true);
            }
            if (this.mHasInputFilter && this.mInputFilter != null) {
                this.mMainHandler.obtainMessage(1, AccessibilityEvent.obtain(event)).sendToTarget();
            }
            event.recycle();
            this.getUserStateLocked((int)resolvedUserId).mHandledFeedbackTypes = 0;
        }
        return OWN_PROCESS_ID != Binder.getCallingPid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.mUiAutomationService != null) {
                ArrayList<AccessibilityServiceInfo> installedServices = new ArrayList<AccessibilityServiceInfo>();
                installedServices.addAll(userState.mInstalledServices);
                installedServices.remove(((UserState)userState).mUiAutomationService.mAccessibilityServiceInfo);
                return installedServices;
            }
            return userState.mInstalledServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackType, int userId) {
        List<AccessibilityServiceInfo> result = null;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            UserState userState = this.getUserStateLocked(resolvedUserId);
            if (userState.mUiAutomationService != null) {
                return Collections.emptyList();
            }
            result = this.mEnabledServicesForFeedbackTempList;
            result.clear();
            CopyOnWriteArrayList<Service> services = userState.mBoundServices;
            while (feedbackType != 0) {
                int feedbackTypeBit = 1 << Integer.numberOfTrailingZeros(feedbackType);
                feedbackType &= ~feedbackTypeBit;
                int serviceCount = services.size();
                for (int i = 0; i < serviceCount; ++i) {
                    Service service = (Service)services.get(i);
                    if ((service.mFeedbackType & feedbackTypeBit) == 0) continue;
                    result.add(service.mAccessibilityServiceInfo);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt(int userId) {
        CopyOnWriteArrayList<Service> services;
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            if (resolvedUserId != this.mCurrentUserId) {
                return;
            }
            services = this.getUserStateLocked((int)resolvedUserId).mBoundServices;
        }
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = services.get(i);
            try {
                service.mServiceInterface.onInterrupt();
                continue;
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Error during sending interrupt request to " + service.mService, re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addAccessibilityInteractionConnection(IWindow windowToken, IAccessibilityInteractionConnection connection, int userId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(userId);
            int windowId = sNextWindowId++;
            if (this.mSecurityPolicy.isCallerInteractingAcrossUsers(userId)) {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, -1);
                wrapper.linkToDeath();
                this.mGlobalInteractionConnections.put(windowId, wrapper);
                this.mGlobalWindowTokens.put(windowId, windowToken.asBinder());
            } else {
                AccessibilityConnectionWrapper wrapper = new AccessibilityConnectionWrapper(windowId, connection, resolvedUserId);
                wrapper.linkToDeath();
                UserState userState = this.getUserStateLocked(resolvedUserId);
                userState.mInteractionConnections.put(windowId, wrapper);
                userState.mWindowTokens.put(windowId, windowToken.asBinder());
            }
            return windowId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccessibilityInteractionConnection(IWindow window) {
        Object object = this.mLock;
        synchronized (object) {
            this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
            IBinder token = window.asBinder();
            int removedWindowId = this.removeAccessibilityInteractionConnectionInternalLocked(token, this.mGlobalWindowTokens, this.mGlobalInteractionConnections);
            if (removedWindowId >= 0) {
                return;
            }
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                int removedWindowIdForUser = this.removeAccessibilityInteractionConnectionInternalLocked(token, userState.mWindowTokens, userState.mInteractionConnections);
                if (removedWindowIdForUser < 0) continue;
                return;
            }
        }
    }

    private int removeAccessibilityInteractionConnectionInternalLocked(IBinder windowToken, SparseArray<IBinder> windowTokens, SparseArray<AccessibilityConnectionWrapper> interactionConnections) {
        int count = windowTokens.size();
        for (int i = 0; i < count; ++i) {
            if (windowTokens.valueAt(i) != windowToken) continue;
            int windowId = windowTokens.keyAt(i);
            windowTokens.removeAt(i);
            AccessibilityConnectionWrapper wrapper = interactionConnections.get(windowId);
            wrapper.unlinkToDeath();
            interactionConnections.remove(windowId);
            return windowId;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUiTestAutomationService(IBinder owner, IAccessibilityServiceClient serviceClient, AccessibilityServiceInfo accessibilityServiceInfo) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_CONTENT", FUNCTION_REGISTER_UI_TEST_AUTOMATION_SERVICE);
        accessibilityServiceInfo.setComponentName(sFakeAccessibilityServiceComponentName);
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + "already registered!");
            }
            try {
                owner.linkToDeath(userState.mUiAutomationSerivceOnwerDeathRecipient, 0);
            }
            catch (RemoteException re) {
                Slog.e(LOG_TAG, "Couldn't register for the death of a UiTestAutomationService!", re);
                return;
            }
            userState.mUiAutomationServiceOwner = owner;
            userState.mUiAutomationServiceClient = serviceClient;
            userState.mIsAccessibilityEnabled = true;
            userState.mIsTouchExplorationEnabled = false;
            userState.mIsEnhancedWebAccessibilityEnabled = false;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mInstalledServices.add(accessibilityServiceInfo);
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(sFakeAccessibilityServiceComponentName);
            userState.mTouchExplorationGrantedServices.add(sFakeAccessibilityServiceComponentName);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUiTestAutomationService(IAccessibilityServiceClient serviceClient) {
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService == null || serviceClient == null || ((UserState)userState).mUiAutomationService.mServiceInterface == null || ((UserState)userState).mUiAutomationService.mServiceInterface.asBinder() != serviceClient.asBinder()) {
                throw new IllegalStateException("UiAutomationService " + serviceClient + " not registered!");
            }
            userState.mUiAutomationService.binderDied();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void temporaryEnableAccessibilityStateUntilKeyguardRemoved(ComponentName service, boolean touchExplorationEnabled) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.TEMPORARY_ENABLE_ACCESSIBILITY", TEMPORARY_ENABLE_ACCESSIBILITY_UNTIL_KEYGUARD_REMOVED);
        if (!this.mWindowManagerService.isKeyguardLocked()) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                return;
            }
            userState.mIsAccessibilityEnabled = true;
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            userState.mIsEnhancedWebAccessibilityEnabled = false;
            userState.mIsDisplayMagnificationEnabled = false;
            userState.mEnabledServices.clear();
            userState.mEnabledServices.add(service);
            userState.mBindingServices.clear();
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.add(service);
            this.onUserStateChangedLocked(userState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder getWindowToken(int windowId) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.RETRIEVE_WINDOW_TOKEN", GET_WINDOW_TOKEN);
        Object object = this.mLock;
        synchronized (object) {
            int resolvedUserId = this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(UserHandle.getCallingUserId());
            if (resolvedUserId != this.mCurrentUserId) {
                return null;
            }
            if (this.mSecurityPolicy.findWindowById(windowId) == null) {
                return null;
            }
            IBinder token = this.mGlobalWindowTokens.get(windowId);
            if (token != null) {
                return token;
            }
            return this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onGesture(int gestureId) {
        Object object = this.mLock;
        synchronized (object) {
            boolean handled = this.notifyGestureLocked(gestureId, false);
            if (!handled) {
                handled = this.notifyGestureLocked(gestureId, true);
            }
            return handled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean notifyKeyEvent(KeyEvent event, int policyFlags) {
        Object object = this.mLock;
        synchronized (object) {
            KeyEvent localClone = KeyEvent.obtain(event);
            boolean handled = this.notifyKeyEventLocked(localClone, policyFlags, false);
            if (!handled) {
                handled = this.notifyKeyEventLocked(localClone, policyFlags, true);
            }
            return handled;
        }
    }

    boolean getAccessibilityFocusClickPointInScreen(Point outPoint) {
        return this.getInteractionBridgeLocked().getAccessibilityFocusClickPointInScreenNotLocked(outPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean getWindowBounds(int windowId, Rect outBounds) {
        IBinder token;
        Object object = this.mLock;
        synchronized (object) {
            token = this.mGlobalWindowTokens.get(windowId);
            if (token == null) {
                token = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
            }
        }
        this.mWindowManagerService.getWindowFrame(token, outBounds);
        return !outBounds.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean accessibilityFocusOnlyInActiveWindow() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mWindowsForAccessibilityCallback == null;
        }
    }

    int getActiveWindowId() {
        return this.mSecurityPolicy.getActiveWindowId();
    }

    void onTouchInteractionStart() {
        this.mSecurityPolicy.onTouchInteractionStart();
    }

    void onTouchInteractionEnd() {
        this.mSecurityPolicy.onTouchInteractionEnd();
    }

    void onMagnificationStateChanged() {
        this.notifyClearAccessibilityCacheLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            UserManager userManager;
            if (this.mCurrentUserId == userId && this.mInitialized) {
                return;
            }
            UserState oldUserState = this.getCurrentUserStateLocked();
            oldUserState.onSwitchToAnotherUser();
            if (oldUserState.mClients.getRegisteredCallbackCount() > 0) {
                this.mMainHandler.obtainMessage(3, oldUserState.mUserId, 0).sendToTarget();
            }
            boolean announceNewUser = (userManager = (UserManager)this.mContext.getSystemService("user")).getUsers().size() > 1;
            this.mCurrentUserId = userId;
            UserState userState = this.getCurrentUserStateLocked();
            if (userState.mUiAutomationService != null) {
                userState.mUiAutomationService.binderDied();
            }
            this.readConfigurationForUserStateLocked(userState);
            this.onUserStateChangedLocked(userState);
            if (announceNewUser) {
                this.mMainHandler.sendEmptyMessageDelayed(5, 3000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUser(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            this.mUserStates.remove(userId);
        }
    }

    void restoreEnabledAccessibilityServicesLocked(String oldSetting, String newSetting) {
        this.readComponentNamesFromStringLocked(oldSetting, this.mTempComponentNameSet, false);
        this.readComponentNamesFromStringLocked(newSetting, this.mTempComponentNameSet, true);
        UserState userState = this.getUserStateLocked(0);
        userState.mEnabledServices.clear();
        userState.mEnabledServices.addAll(this.mTempComponentNameSet);
        this.persistComponentNamesToSettingLocked("enabled_accessibility_services", userState.mEnabledServices, 0);
        this.onUserStateChangedLocked(userState);
    }

    private InteractionBridge getInteractionBridgeLocked() {
        if (this.mInteractionBridge == null) {
            this.mInteractionBridge = new InteractionBridge();
        }
        return this.mInteractionBridge;
    }

    private boolean notifyGestureLocked(int gestureId, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestTouchExplorationMode || service.mIsDefault != isDefault) continue;
            service.notifyGesture(gestureId);
            return true;
        }
        return false;
    }

    private boolean notifyKeyEventLocked(KeyEvent event, int policyFlags, boolean isDefault) {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0 || service.mIsDefault != isDefault) continue;
            service.notifyKeyEvent(event, policyFlags);
            return true;
        }
        return false;
    }

    private void notifyClearAccessibilityCacheLocked() {
        UserState state = this.getCurrentUserStateLocked();
        for (int i = state.mBoundServices.size() - 1; i >= 0; --i) {
            Service service = state.mBoundServices.get(i);
            service.notifyClearAccessibilityNodeInfoCache();
        }
    }

    private void removeAccessibilityInteractionConnectionLocked(int windowId, int userId) {
        if (userId == -1) {
            this.mGlobalWindowTokens.remove(windowId);
            this.mGlobalInteractionConnections.remove(windowId);
        } else {
            UserState userState = this.getCurrentUserStateLocked();
            userState.mWindowTokens.remove(windowId);
            userState.mInteractionConnections.remove(windowId);
        }
    }

    private boolean readInstalledAccessibilityServiceLocked(UserState userState) {
        this.mTempAccessibilityServiceInfoList.clear();
        List<ResolveInfo> installedServices = this.mPackageManager.queryIntentServicesAsUser(new Intent("android.accessibilityservice.AccessibilityService"), 32900, this.mCurrentUserId);
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ResolveInfo resolveInfo = installedServices.get(i);
            ServiceInfo serviceInfo = resolveInfo.serviceInfo;
            if (!"android.permission.BIND_ACCESSIBILITY_SERVICE".equals(serviceInfo.permission)) {
                Slog.w(LOG_TAG, "Skipping accessibilty service " + new ComponentName(serviceInfo.packageName, serviceInfo.name).flattenToShortString() + ": it does not require the permission " + "android.permission.BIND_ACCESSIBILITY_SERVICE");
                continue;
            }
            try {
                AccessibilityServiceInfo accessibilityServiceInfo = new AccessibilityServiceInfo(resolveInfo, this.mContext);
                this.mTempAccessibilityServiceInfoList.add(accessibilityServiceInfo);
                continue;
            }
            catch (IOException | XmlPullParserException xppe) {
                Slog.e(LOG_TAG, "Error while initializing AccessibilityServiceInfo", xppe);
            }
        }
        if (!this.mTempAccessibilityServiceInfoList.equals(userState.mInstalledServices)) {
            userState.mInstalledServices.clear();
            userState.mInstalledServices.addAll(this.mTempAccessibilityServiceInfoList);
            this.mTempAccessibilityServiceInfoList.clear();
            return true;
        }
        this.mTempAccessibilityServiceInfoList.clear();
        return false;
    }

    private boolean readEnabledAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("enabled_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mEnabledServices)) {
            userState.mEnabledServices.clear();
            userState.mEnabledServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private boolean readTouchExplorationGrantedAccessibilityServicesLocked(UserState userState) {
        this.mTempComponentNameSet.clear();
        this.readComponentNamesFromSettingLocked("touch_exploration_granted_accessibility_services", userState.mUserId, this.mTempComponentNameSet);
        if (!this.mTempComponentNameSet.equals(userState.mTouchExplorationGrantedServices)) {
            userState.mTouchExplorationGrantedServices.clear();
            userState.mTouchExplorationGrantedServices.addAll(this.mTempComponentNameSet);
            this.mTempComponentNameSet.clear();
            return true;
        }
        this.mTempComponentNameSet.clear();
        return false;
    }

    private void notifyAccessibilityServicesDelayedLocked(AccessibilityEvent event, boolean isDefault) {
        try {
            UserState state = this.getCurrentUserStateLocked();
            int count = state.mBoundServices.size();
            for (int i = 0; i < count; ++i) {
                Service service = state.mBoundServices.get(i);
                if (service.mIsDefault != isDefault || !this.canDispatchEventToServiceLocked(service, event, state.mHandledFeedbackTypes)) continue;
                state.mHandledFeedbackTypes |= service.mFeedbackType;
                service.notifyAccessibilityEvent(event);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void addServiceLocked(Service service, UserState userState) {
        try {
            service.onAdded();
            userState.mBoundServices.add(service);
            userState.mComponentNameToServiceMap.put(service.mComponentName, service);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void removeServiceLocked(Service service, UserState userState) {
        userState.mBoundServices.remove(service);
        userState.mComponentNameToServiceMap.remove(service.mComponentName);
        service.onRemoved();
    }

    private boolean canDispatchEventToServiceLocked(Service service, AccessibilityEvent event, int handledFeedbackTypes) {
        int feedbackType;
        String packageName;
        if (!service.canReceiveEventsLocked()) {
            return false;
        }
        if (event.getWindowId() != -1 && !event.isImportantForAccessibility() && (service.mFetchFlags & 8) == 0) {
            return false;
        }
        int eventType = event.getEventType();
        if ((service.mEventTypes & eventType) != eventType) {
            return false;
        }
        Set<String> packageNames = service.mPackageNames;
        String string2 = packageName = event.getPackageName() != null ? event.getPackageName().toString() : null;
        return !(!packageNames.isEmpty() && !packageNames.contains(packageName) || (handledFeedbackTypes & (feedbackType = service.mFeedbackType)) == feedbackType && feedbackType != 16);
    }

    private void unbindAllServicesLocked(UserState userState) {
        CopyOnWriteArrayList<Service> services = userState.mBoundServices;
        int count = services.size();
        for (int i = 0; i < count; ++i) {
            Service service = (Service)services.get(i);
            if (!service.unbindLocked()) continue;
            --i;
            --count;
        }
    }

    private void readComponentNamesFromSettingLocked(String settingName, int userId, Set<ComponentName> outComponentNames) {
        String settingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), settingName, userId);
        this.readComponentNamesFromStringLocked(settingValue, outComponentNames, false);
    }

    private void readComponentNamesFromStringLocked(String names, Set<ComponentName> outComponentNames, boolean doMerge) {
        if (!doMerge) {
            outComponentNames.clear();
        }
        if (names != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(names);
            while (splitter.hasNext()) {
                ComponentName enabledService;
                String str = splitter.next();
                if (str == null || str.length() <= 0 || (enabledService = ComponentName.unflattenFromString(str)) == null) continue;
                outComponentNames.add(enabledService);
            }
        }
    }

    private void persistComponentNamesToSettingLocked(String settingName, Set<ComponentName> componentNames, int userId) {
        StringBuilder builder = new StringBuilder();
        for (ComponentName componentName : componentNames) {
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append(componentName.flattenToShortString());
        }
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), settingName, builder.toString(), userId);
    }

    private void manageServicesLocked(UserState userState) {
        Map<ComponentName, Service> componentNameToServiceMap = userState.mComponentNameToServiceMap;
        boolean isEnabled = userState.mIsAccessibilityEnabled;
        int count = userState.mInstalledServices.size();
        for (int i = 0; i < count; ++i) {
            AccessibilityServiceInfo installedService = userState.mInstalledServices.get(i);
            ComponentName componentName = ComponentName.unflattenFromString(installedService.getId());
            Service service = componentNameToServiceMap.get(componentName);
            if (isEnabled) {
                if (userState.mBindingServices.contains(componentName)) continue;
                if (userState.mEnabledServices.contains(componentName)) {
                    if (service == null) {
                        service = new Service(userState.mUserId, componentName, installedService);
                    } else if (userState.mBoundServices.contains(service)) continue;
                    service.bindLocked();
                    continue;
                }
                if (service == null) continue;
                service.unbindLocked();
                continue;
            }
            if (service != null) {
                service.unbindLocked();
                continue;
            }
            userState.mBindingServices.remove(componentName);
        }
        if (isEnabled && userState.mBoundServices.isEmpty() && userState.mBindingServices.isEmpty()) {
            userState.mIsAccessibilityEnabled = false;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", 0, userState.mUserId);
        }
    }

    private void scheduleUpdateClientsIfNeededLocked(UserState userState) {
        int clientState = userState.getClientState();
        if (userState.mLastSentClientState != clientState && (this.mGlobalClients.getRegisteredCallbackCount() > 0 || userState.mClients.getRegisteredCallbackCount() > 0)) {
            userState.mLastSentClientState = clientState;
            this.mMainHandler.obtainMessage(2, clientState, userState.mUserId).sendToTarget();
        }
    }

    private void scheduleUpdateInputFilter(UserState userState) {
        this.mMainHandler.obtainMessage(6, userState).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInputFilter(UserState userState) {
        boolean setInputFilter = false;
        AccessibilityInputFilter inputFilter = null;
        Object object = this.mLock;
        synchronized (object) {
            int flags = 0;
            if (userState.mIsDisplayMagnificationEnabled) {
                flags |= 1;
            }
            if (userState.mIsAccessibilityEnabled && userState.mIsTouchExplorationEnabled) {
                flags |= 2;
            }
            if (userState.mIsFilterKeyEventsEnabled) {
                flags |= 4;
            }
            if (flags != 0) {
                if (!this.mHasInputFilter) {
                    this.mHasInputFilter = true;
                    if (this.mInputFilter == null) {
                        this.mInputFilter = new AccessibilityInputFilter(this.mContext, this);
                    }
                    inputFilter = this.mInputFilter;
                    setInputFilter = true;
                }
                this.mInputFilter.setEnabledFeatures(flags);
            } else if (this.mHasInputFilter) {
                this.mHasInputFilter = false;
                this.mInputFilter.disableFeatures();
                inputFilter = null;
                setInputFilter = true;
            }
        }
        if (setInputFilter) {
            this.mWindowManagerService.setInputFilter(inputFilter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showEnableTouchExplorationDialog(final Service service) {
        Object object = this.mLock;
        synchronized (object) {
            String label = service.mResolveInfo.loadLabel(this.mContext.getPackageManager()).toString();
            final UserState state = this.getCurrentUserStateLocked();
            if (state.mIsTouchExplorationEnabled) {
                return;
            }
            if (this.mEnableTouchExplorationDialog != null && this.mEnableTouchExplorationDialog.isShowing()) {
                return;
            }
            this.mEnableTouchExplorationDialog = new AlertDialog.Builder(this.mContext).setIconAttribute(16843605).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    state.mTouchExplorationGrantedServices.add(service.mComponentName);
                    AccessibilityManagerService.this.persistComponentNamesToSettingLocked("touch_exploration_granted_accessibility_services", state.mTouchExplorationGrantedServices, state.mUserId);
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(service.mUserId);
                    userState.mIsTouchExplorationEnabled = true;
                    Settings.Secure.putIntForUser(AccessibilityManagerService.this.mContext.getContentResolver(), "touch_exploration_enabled", 1, service.mUserId);
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.dismiss();
                }
            }).setTitle(17040156).setMessage(this.mContext.getString(17040157, label)).create();
            this.mEnableTouchExplorationDialog.getWindow().setType(2003);
            this.mEnableTouchExplorationDialog.getWindow().getAttributes().privateFlags |= 0x10;
            this.mEnableTouchExplorationDialog.setCanceledOnTouchOutside(true);
            this.mEnableTouchExplorationDialog.show();
        }
    }

    private void onUserStateChangedLocked(UserState userState) {
        this.mInitialized = true;
        this.updateLegacyCapabilitiesLocked(userState);
        this.updateServicesLocked(userState);
        this.updateWindowsForAccessibilityCallbackLocked(userState);
        this.updateAccessibilityFocusBehaviorLocked(userState);
        this.updateFilterKeyEventsLocked(userState);
        this.updateTouchExplorationLocked(userState);
        this.updateEnhancedWebAccessibilityLocked(userState);
        this.updateDisplayColorAdjustmentSettingsLocked(userState);
        this.scheduleUpdateInputFilter(userState);
        this.scheduleUpdateClientsIfNeededLocked(userState);
    }

    private void updateAccessibilityFocusBehaviorLocked(UserState userState) {
        CopyOnWriteArrayList<Service> boundServices = userState.mBoundServices;
        int boundServiceCount = boundServices.size();
        for (int i = 0; i < boundServiceCount; ++i) {
            Service boundService = (Service)boundServices.get(i);
            if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
            userState.mAccessibilityFocusOnlyInActiveWindow = false;
            return;
        }
        userState.mAccessibilityFocusOnlyInActiveWindow = true;
    }

    private void updateWindowsForAccessibilityCallbackLocked(UserState userState) {
        if (userState.mIsAccessibilityEnabled) {
            boolean boundServiceCanRetrieveInteractiveWindows = false;
            CopyOnWriteArrayList<Service> boundServices = userState.mBoundServices;
            int boundServiceCount = boundServices.size();
            for (int i = 0; i < boundServiceCount; ++i) {
                Service boundService = (Service)boundServices.get(i);
                if (!boundService.canRetrieveInteractiveWindowsLocked()) continue;
                boundServiceCanRetrieveInteractiveWindows = true;
                break;
            }
            if (boundServiceCanRetrieveInteractiveWindows) {
                if (this.mWindowsForAccessibilityCallback == null) {
                    this.mWindowsForAccessibilityCallback = new WindowsForAccessibilityCallback();
                    this.mWindowManagerService.setWindowsForAccessibilityCallback(this.mWindowsForAccessibilityCallback);
                }
                return;
            }
        }
        if (this.mWindowsForAccessibilityCallback != null) {
            this.mWindowsForAccessibilityCallback = null;
            this.mWindowManagerService.setWindowsForAccessibilityCallback(null);
            this.mSecurityPolicy.clearWindowsLocked();
        }
    }

    private void updateLegacyCapabilitiesLocked(UserState userState) {
        int installedServiceCount = userState.mInstalledServices.size();
        for (int i = 0; i < installedServiceCount; ++i) {
            ComponentName componentName;
            AccessibilityServiceInfo serviceInfo = userState.mInstalledServices.get(i);
            ResolveInfo resolveInfo = serviceInfo.getResolveInfo();
            if ((serviceInfo.getCapabilities() & 2) != 0 || resolveInfo.serviceInfo.applicationInfo.targetSdkVersion > 17 || !userState.mTouchExplorationGrantedServices.contains(componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name))) continue;
            serviceInfo.setCapabilities(serviceInfo.getCapabilities() | 2);
        }
    }

    private void updateFilterKeyEventsLocked(UserState userState) {
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!service.mRequestFilterKeyEvents || (service.mAccessibilityServiceInfo.getCapabilities() & 8) == 0) continue;
            userState.mIsFilterKeyEventsEnabled = true;
            return;
        }
        userState.mIsFilterKeyEventsEnabled = false;
    }

    private void updateServicesLocked(UserState userState) {
        if (userState.mIsAccessibilityEnabled) {
            this.manageServicesLocked(userState);
        } else {
            this.unbindAllServicesLocked(userState);
        }
    }

    private boolean readConfigurationForUserStateLocked(UserState userState) {
        boolean somthingChanged = this.readAccessibilityEnabledSettingLocked(userState);
        somthingChanged |= this.readInstalledAccessibilityServiceLocked(userState);
        somthingChanged |= this.readEnabledAccessibilityServicesLocked(userState);
        somthingChanged |= this.readTouchExplorationGrantedAccessibilityServicesLocked(userState);
        somthingChanged |= this.readTouchExplorationEnabledSettingLocked(userState);
        somthingChanged |= this.readHighTextContrastEnabledSettingLocked(userState);
        somthingChanged |= this.readEnhancedWebAccessibilityEnabledChangedLocked(userState);
        somthingChanged |= this.readDisplayMagnificationEnabledSettingLocked(userState);
        return somthingChanged |= this.readDisplayColorAdjustmentSettingsLocked(userState);
    }

    private boolean readAccessibilityEnabledSettingLocked(UserState userState) {
        boolean accessibilityEnabled;
        boolean bl = accessibilityEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_enabled", 0, userState.mUserId) == 1;
        if (accessibilityEnabled != userState.mIsAccessibilityEnabled) {
            userState.mIsAccessibilityEnabled = accessibilityEnabled;
            return true;
        }
        return false;
    }

    private boolean readTouchExplorationEnabledSettingLocked(UserState userState) {
        boolean touchExplorationEnabled;
        boolean bl = touchExplorationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", 0, userState.mUserId) == 1;
        if (touchExplorationEnabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = touchExplorationEnabled;
            return true;
        }
        return false;
    }

    private boolean readDisplayMagnificationEnabledSettingLocked(UserState userState) {
        boolean displayMagnificationEnabled;
        boolean bl = displayMagnificationEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_display_magnification_enabled", 0, userState.mUserId) == 1;
        if (displayMagnificationEnabled != userState.mIsDisplayMagnificationEnabled) {
            userState.mIsDisplayMagnificationEnabled = displayMagnificationEnabled;
            return true;
        }
        return false;
    }

    private boolean readEnhancedWebAccessibilityEnabledChangedLocked(UserState userState) {
        boolean enhancedWeAccessibilityEnabled;
        boolean bl = enhancedWeAccessibilityEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "accessibility_script_injection", 0, userState.mUserId) == 1;
        if (enhancedWeAccessibilityEnabled != userState.mIsEnhancedWebAccessibilityEnabled) {
            userState.mIsEnhancedWebAccessibilityEnabled = enhancedWeAccessibilityEnabled;
            return true;
        }
        return false;
    }

    private boolean readDisplayColorAdjustmentSettingsLocked(UserState userState) {
        boolean displayAdjustmentsEnabled = DisplayAdjustmentUtils.hasAdjustments(this.mContext, userState.mUserId);
        if (displayAdjustmentsEnabled != userState.mHasDisplayColorAdjustment) {
            userState.mHasDisplayColorAdjustment = displayAdjustmentsEnabled;
            return true;
        }
        return displayAdjustmentsEnabled;
    }

    private boolean readHighTextContrastEnabledSettingLocked(UserState userState) {
        boolean highTextContrastEnabled;
        boolean bl = highTextContrastEnabled = Settings.Secure.getIntForUser(this.mContext.getContentResolver(), "high_text_contrast_enabled", 0, userState.mUserId) == 1;
        if (highTextContrastEnabled != userState.mIsTextHighContrastEnabled) {
            userState.mIsTextHighContrastEnabled = highTextContrastEnabled;
            return true;
        }
        return false;
    }

    private void updateTouchExplorationLocked(UserState userState) {
        boolean enabled = false;
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsTouchExplorationLocked(service)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsTouchExplorationEnabled) {
            userState.mIsTouchExplorationEnabled = enabled;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "touch_exploration_enabled", enabled ? 1 : 0, userState.mUserId);
        }
    }

    private boolean canRequestAndRequestsTouchExplorationLocked(Service service) {
        if (!service.canReceiveEventsLocked() || !service.mRequestTouchExplorationMode) {
            return false;
        }
        if (service.mIsAutomation) {
            return true;
        }
        if (service.mResolveInfo.serviceInfo.applicationInfo.targetSdkVersion <= 17) {
            UserState userState = this.getUserStateLocked(service.mUserId);
            if (userState.mTouchExplorationGrantedServices.contains(service.mComponentName)) {
                return true;
            }
            if (this.mEnableTouchExplorationDialog == null || !this.mEnableTouchExplorationDialog.isShowing()) {
                this.mMainHandler.obtainMessage(7, service).sendToTarget();
            }
        } else if ((service.mAccessibilityServiceInfo.getCapabilities() & 2) != 0) {
            return true;
        }
        return false;
    }

    private void updateEnhancedWebAccessibilityLocked(UserState userState) {
        boolean enabled = false;
        int serviceCount = userState.mBoundServices.size();
        for (int i = 0; i < serviceCount; ++i) {
            Service service = userState.mBoundServices.get(i);
            if (!this.canRequestAndRequestsEnhancedWebAccessibilityLocked(service)) continue;
            enabled = true;
            break;
        }
        if (enabled != userState.mIsEnhancedWebAccessibilityEnabled) {
            userState.mIsEnhancedWebAccessibilityEnabled = enabled;
            Settings.Secure.putIntForUser(this.mContext.getContentResolver(), "accessibility_script_injection", enabled ? 1 : 0, userState.mUserId);
        }
    }

    private boolean canRequestAndRequestsEnhancedWebAccessibilityLocked(Service service) {
        if (!service.canReceiveEventsLocked() || !service.mRequestEnhancedWebAccessibility) {
            return false;
        }
        return service.mIsAutomation || (service.mAccessibilityServiceInfo.getCapabilities() & 4) != 0;
    }

    private void updateDisplayColorAdjustmentSettingsLocked(UserState userState) {
        DisplayAdjustmentUtils.applyAdjustments(this.mContext, userState.mUserId);
    }

    private boolean hasRunningServicesLocked(UserState userState) {
        return !userState.mBoundServices.isEmpty() || !userState.mBindingServices.isEmpty();
    }

    private MagnificationSpec getCompatibleMagnificationSpecLocked(int windowId) {
        IBinder windowToken = this.mGlobalWindowTokens.get(windowId);
        if (windowToken == null) {
            windowToken = this.getCurrentUserStateLocked().mWindowTokens.get(windowId);
        }
        if (windowToken != null) {
            return this.mWindowManagerService.getCompatibleMagnificationSpecForWindow(windowToken);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mSecurityPolicy.enforceCallingPermission("android.permission.DUMP", FUNCTION_DUMP);
        Object object = this.mLock;
        synchronized (object) {
            pw.println("ACCESSIBILITY MANAGER (dumpsys accessibility)");
            pw.println();
            int userCount = this.mUserStates.size();
            for (int i = 0; i < userCount; ++i) {
                UserState userState = this.mUserStates.valueAt(i);
                pw.append("User state[attributes:{id=" + userState.mUserId);
                pw.append(", currentUser=" + (userState.mUserId == this.mCurrentUserId));
                pw.append(", accessibilityEnabled=" + userState.mIsAccessibilityEnabled);
                pw.append(", touchExplorationEnabled=" + userState.mIsTouchExplorationEnabled);
                pw.append(", displayMagnificationEnabled=" + userState.mIsDisplayMagnificationEnabled);
                if (userState.mUiAutomationService != null) {
                    pw.append(", ");
                    userState.mUiAutomationService.dump(fd, pw, args);
                    pw.println();
                }
                pw.append("}");
                pw.println();
                pw.append("           services:{");
                int serviceCount = userState.mBoundServices.size();
                for (int j = 0; j < serviceCount; ++j) {
                    if (j > 0) {
                        pw.append(", ");
                        pw.println();
                        pw.append("                     ");
                    }
                    Service service = userState.mBoundServices.get(j);
                    service.dump(fd, pw, args);
                }
                pw.println("}]");
                pw.println();
            }
            if (this.mSecurityPolicy.mWindows != null) {
                int windowCount = this.mSecurityPolicy.mWindows.size();
                for (int j = 0; j < windowCount; ++j) {
                    if (j > 0) {
                        pw.append(',');
                        pw.println();
                    }
                    pw.append("Window[");
                    AccessibilityWindowInfo window = this.mSecurityPolicy.mWindows.get(j);
                    pw.append(window.toString());
                    pw.append(']');
                }
            }
        }
    }

    private PendingEvent obtainPendingEventLocked(KeyEvent event, int policyFlags, int sequence) {
        PendingEvent pendingEvent = this.mPendingEventPool.acquire();
        if (pendingEvent == null) {
            pendingEvent = new PendingEvent();
        }
        pendingEvent.event = event;
        pendingEvent.policyFlags = policyFlags;
        pendingEvent.sequence = sequence;
        return pendingEvent;
    }

    private void recyclePendingEventLocked(PendingEvent pendingEvent) {
        pendingEvent.clear();
        this.mPendingEventPool.release(pendingEvent);
    }

    private int findWindowIdLocked(IBinder token) {
        int globalIndex = this.mGlobalWindowTokens.indexOfValue(token);
        if (globalIndex >= 0) {
            return this.mGlobalWindowTokens.keyAt(globalIndex);
        }
        UserState userState = this.getCurrentUserStateLocked();
        int userIndex = userState.mWindowTokens.indexOfValue(token);
        if (userIndex >= 0) {
            return userState.mWindowTokens.keyAt(userIndex);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureWindowsAvailableTimed() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSecurityPolicy.mWindows != null) {
                return;
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                UserState userState = this.getCurrentUserStateLocked();
                this.onUserStateChangedLocked(userState);
            }
            if (this.mWindowsForAccessibilityCallback == null) {
                return;
            }
            long startMillis = SystemClock.uptimeMillis();
            while (this.mSecurityPolicy.mWindows == null) {
                long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                long remainMillis = 5000L - elapsedMillis;
                if (remainMillis <= 0L) {
                    return;
                }
                try {
                    this.mLock.wait(remainMillis);
                }
                catch (InterruptedException ie) {}
            }
        }
    }

    private final class AccessibilityContentObserver
    extends ContentObserver {
        private final Uri mAccessibilityEnabledUri;
        private final Uri mTouchExplorationEnabledUri;
        private final Uri mDisplayMagnificationEnabledUri;
        private final Uri mEnabledAccessibilityServicesUri;
        private final Uri mTouchExplorationGrantedAccessibilityServicesUri;
        private final Uri mEnhancedWebAccessibilityUri;
        private final Uri mDisplayInversionEnabledUri;
        private final Uri mDisplayDaltonizerEnabledUri;
        private final Uri mDisplayDaltonizerUri;
        private final Uri mHighTextContrastUri;

        public AccessibilityContentObserver(Handler handler) {
            super(handler);
            this.mAccessibilityEnabledUri = Settings.Secure.getUriFor("accessibility_enabled");
            this.mTouchExplorationEnabledUri = Settings.Secure.getUriFor("touch_exploration_enabled");
            this.mDisplayMagnificationEnabledUri = Settings.Secure.getUriFor("accessibility_display_magnification_enabled");
            this.mEnabledAccessibilityServicesUri = Settings.Secure.getUriFor("enabled_accessibility_services");
            this.mTouchExplorationGrantedAccessibilityServicesUri = Settings.Secure.getUriFor("touch_exploration_granted_accessibility_services");
            this.mEnhancedWebAccessibilityUri = Settings.Secure.getUriFor("accessibility_script_injection");
            this.mDisplayInversionEnabledUri = Settings.Secure.getUriFor("accessibility_display_inversion_enabled");
            this.mDisplayDaltonizerEnabledUri = Settings.Secure.getUriFor("accessibility_display_daltonizer_enabled");
            this.mDisplayDaltonizerUri = Settings.Secure.getUriFor("accessibility_display_daltonizer");
            this.mHighTextContrastUri = Settings.Secure.getUriFor("high_text_contrast_enabled");
        }

        public void register(ContentResolver contentResolver) {
            contentResolver.registerContentObserver(this.mAccessibilityEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayMagnificationEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnabledAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mTouchExplorationGrantedAccessibilityServicesUri, false, this, -1);
            contentResolver.registerContentObserver(this.mEnhancedWebAccessibilityUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayInversionEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerEnabledUri, false, this, -1);
            contentResolver.registerContentObserver(this.mDisplayDaltonizerUri, false, this, -1);
            contentResolver.registerContentObserver(this.mHighTextContrastUri, false, this, -1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.mUiAutomationService != null) {
                    return;
                }
                if (this.mAccessibilityEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readAccessibilityEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mTouchExplorationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayMagnificationEnabledUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readDisplayMagnificationEnabledSettingLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mEnabledAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readEnabledAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mTouchExplorationGrantedAccessibilityServicesUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readTouchExplorationGrantedAccessibilityServicesLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mEnhancedWebAccessibilityUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readEnhancedWebAccessibilityEnabledChangedLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                } else if (this.mDisplayInversionEnabledUri.equals(uri) || this.mDisplayDaltonizerEnabledUri.equals(uri) || this.mDisplayDaltonizerUri.equals(uri)) {
                    if (AccessibilityManagerService.this.readDisplayColorAdjustmentSettingsLocked(userState)) {
                        AccessibilityManagerService.this.updateDisplayColorAdjustmentSettingsLocked(userState);
                    }
                } else if (this.mHighTextContrastUri.equals(uri) && AccessibilityManagerService.this.readHighTextContrastEnabledSettingLocked(userState)) {
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
        }
    }

    private class UserState {
        public final int mUserId;
        public final RemoteCallbackList<IAccessibilityManagerClient> mClients = new RemoteCallbackList();
        public final SparseArray<AccessibilityConnectionWrapper> mInteractionConnections = new SparseArray();
        public final SparseArray<IBinder> mWindowTokens = new SparseArray();
        public final CopyOnWriteArrayList<Service> mBoundServices = new CopyOnWriteArrayList();
        public final Map<ComponentName, Service> mComponentNameToServiceMap = new HashMap<ComponentName, Service>();
        public final List<AccessibilityServiceInfo> mInstalledServices = new ArrayList<AccessibilityServiceInfo>();
        public final Set<ComponentName> mBindingServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mEnabledServices = new HashSet<ComponentName>();
        public final Set<ComponentName> mTouchExplorationGrantedServices = new HashSet<ComponentName>();
        public int mHandledFeedbackTypes = 0;
        public int mLastSentClientState = -1;
        public boolean mIsAccessibilityEnabled;
        public boolean mIsTouchExplorationEnabled;
        public boolean mIsTextHighContrastEnabled;
        public boolean mIsEnhancedWebAccessibilityEnabled;
        public boolean mIsDisplayMagnificationEnabled;
        public boolean mIsFilterKeyEventsEnabled;
        public boolean mHasDisplayColorAdjustment;
        public boolean mAccessibilityFocusOnlyInActiveWindow;
        private Service mUiAutomationService;
        private IAccessibilityServiceClient mUiAutomationServiceClient;
        private IBinder mUiAutomationServiceOwner;
        private final IBinder.DeathRecipient mUiAutomationSerivceOnwerDeathRecipient = new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                UserState.this.mUiAutomationServiceOwner.unlinkToDeath(UserState.this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                UserState.this.mUiAutomationServiceOwner = null;
                if (UserState.this.mUiAutomationService != null) {
                    UserState.this.mUiAutomationService.binderDied();
                }
            }
        };

        public UserState(int userId) {
            this.mUserId = userId;
        }

        public int getClientState() {
            int clientState = 0;
            if (this.mIsAccessibilityEnabled) {
                clientState |= 1;
            }
            if (this.mIsAccessibilityEnabled && this.mIsTouchExplorationEnabled) {
                clientState |= 2;
            }
            if (this.mIsTextHighContrastEnabled) {
                clientState |= 4;
            }
            return clientState;
        }

        public void onSwitchToAnotherUser() {
            if (this.mUiAutomationService != null) {
                this.mUiAutomationService.binderDied();
            }
            AccessibilityManagerService.this.unbindAllServicesLocked(this);
            this.mBoundServices.clear();
            this.mBindingServices.clear();
            this.mHandledFeedbackTypes = 0;
            this.mLastSentClientState = -1;
            this.mEnabledServices.clear();
            this.mTouchExplorationGrantedServices.clear();
            this.mIsAccessibilityEnabled = false;
            this.mIsTouchExplorationEnabled = false;
            this.mIsEnhancedWebAccessibilityEnabled = false;
            this.mIsDisplayMagnificationEnabled = false;
        }

        public void destroyUiAutomationService() {
            this.mUiAutomationService = null;
            this.mUiAutomationServiceClient = null;
            if (this.mUiAutomationServiceOwner != null) {
                this.mUiAutomationServiceOwner.unlinkToDeath(this.mUiAutomationSerivceOnwerDeathRecipient, 0);
                this.mUiAutomationServiceOwner = null;
            }
        }
    }

    final class SecurityPolicy {
        public static final int INVALID_WINDOW_ID = -1;
        private static final int RETRIEVAL_ALLOWING_EVENT_TYPES = 244159;
        public List<AccessibilityWindowInfo> mWindows;
        public int mActiveWindowId = -1;
        public int mFocusedWindowId = -1;
        public int mAccessibilityFocusedWindowId = -1;
        public long mAccessibilityFocusNodeId = Integer.MAX_VALUE;
        private boolean mTouchInteractionInProgress;

        SecurityPolicy() {
        }

        private boolean canDispatchAccessibilityEventLocked(AccessibilityEvent event) {
            int eventType = event.getEventType();
            switch (eventType) {
                case 32: 
                case 64: 
                case 128: 
                case 256: 
                case 512: 
                case 1024: 
                case 16384: 
                case 262144: 
                case 524288: 
                case 0x100000: 
                case 0x200000: 
                case 0x400000: 
                case 0x1000000: {
                    return true;
                }
            }
            return this.isRetrievalAllowingWindow(event.getWindowId());
        }

        public void clearWindowsLocked() {
            List<AccessibilityWindowInfo> windows = Collections.emptyList();
            int activeWindowId = this.mActiveWindowId;
            this.updateWindowsLocked(windows);
            this.mActiveWindowId = activeWindowId;
            this.mWindows = null;
        }

        public void updateWindowsLocked(List<AccessibilityWindowInfo> windows) {
            if (this.mWindows == null) {
                this.mWindows = new ArrayList<AccessibilityWindowInfo>();
            }
            int oldWindowCount = this.mWindows.size();
            for (int i = oldWindowCount - 1; i >= 0; --i) {
                this.mWindows.remove(i).recycle();
            }
            this.mFocusedWindowId = -1;
            if (!this.mTouchInteractionInProgress) {
                this.mActiveWindowId = -1;
            }
            boolean activeWindowGone = true;
            int windowCount = windows.size();
            if (windowCount > 0) {
                AccessibilityWindowInfo window;
                int i;
                for (i = 0; i < windowCount; ++i) {
                    window = windows.get(i);
                    int windowId = window.getId();
                    if (window.isFocused()) {
                        this.mFocusedWindowId = windowId;
                        if (!this.mTouchInteractionInProgress) {
                            this.mActiveWindowId = windowId;
                            window.setActive(true);
                        } else if (windowId == this.mActiveWindowId) {
                            activeWindowGone = false;
                        }
                    }
                    this.mWindows.add(window);
                }
                if (this.mTouchInteractionInProgress && activeWindowGone) {
                    this.mActiveWindowId = this.mFocusedWindowId;
                }
                for (i = 0; i < windowCount; ++i) {
                    window = this.mWindows.get(i);
                    if (window.getId() == this.mActiveWindowId) {
                        window.setActive(true);
                    }
                    if (window.getId() != this.mAccessibilityFocusedWindowId) continue;
                    window.setAccessibilityFocused(true);
                }
            }
            this.notifyWindowsChanged();
        }

        public boolean computePartialInteractiveRegionForWindowLocked(int windowId, Region outRegion) {
            if (this.mWindows == null) {
                return false;
            }
            Region windowInteractiveRegion = null;
            boolean windowInteractiveRegionChanged = false;
            int windowCount = this.mWindows.size();
            for (int i = windowCount - 1; i >= 0; --i) {
                Rect currentWindowBounds;
                AccessibilityWindowInfo currentWindow = this.mWindows.get(i);
                if (windowInteractiveRegion == null) {
                    if (currentWindow.getId() != windowId) continue;
                    currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                    currentWindow.getBoundsInScreen(currentWindowBounds);
                    outRegion.set(currentWindowBounds);
                    windowInteractiveRegion = outRegion;
                    continue;
                }
                if (currentWindow.getType() == 4) continue;
                currentWindowBounds = AccessibilityManagerService.this.mTempRect;
                currentWindow.getBoundsInScreen(currentWindowBounds);
                if (!windowInteractiveRegion.op(currentWindowBounds, Region.Op.DIFFERENCE)) continue;
                windowInteractiveRegionChanged = true;
            }
            return windowInteractiveRegionChanged;
        }

        public void updateEventSourceLocked(AccessibilityEvent event) {
            if ((event.getEventType() & 0x3B9BF) == 0) {
                event.setSource(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateActiveAndAccessibilityFocusedWindowLocked(int windowId, long nodeId, int eventType) {
            switch (eventType) {
                case 32: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mWindowsForAccessibilityCallback == null) {
                            this.mFocusedWindowId = this.getFocusedWindowId();
                            if (windowId == this.mFocusedWindowId) {
                                this.mActiveWindowId = windowId;
                            }
                        }
                        break;
                    }
                }
                case 128: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mTouchInteractionInProgress && this.mActiveWindowId != windowId) {
                            this.setActiveWindowLocked(windowId);
                        }
                        break;
                    }
                }
                case 32768: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusedWindowId != windowId) {
                            AccessibilityManagerService.this.mMainHandler.obtainMessage(9, this.mAccessibilityFocusedWindowId, 0).sendToTarget();
                            AccessibilityManagerService.this.mSecurityPolicy.setAccessibilityFocusedWindowLocked(windowId);
                            this.mAccessibilityFocusNodeId = nodeId;
                        }
                        break;
                    }
                }
                case 65536: {
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (this.mAccessibilityFocusNodeId == nodeId) {
                            this.mAccessibilityFocusNodeId = Integer.MAX_VALUE;
                        }
                        if (this.mAccessibilityFocusNodeId == Integer.MAX_VALUE && this.mAccessibilityFocusedWindowId == windowId) {
                            this.mAccessibilityFocusedWindowId = -1;
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionStart() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTouchInteractionEnd() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mTouchInteractionInProgress = false;
                int oldActiveWindow = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId;
                this.setActiveWindowLocked(this.mFocusedWindowId);
                if (oldActiveWindow != ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId && this.mAccessibilityFocusedWindowId == oldActiveWindow && ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mAccessibilityFocusOnlyInActiveWindow) {
                    AccessibilityManagerService.this.mMainHandler.obtainMessage(9, oldActiveWindow, 0).sendToTarget();
                }
            }
        }

        public int getActiveWindowId() {
            if (this.mActiveWindowId == -1 && !this.mTouchInteractionInProgress) {
                this.mActiveWindowId = this.getFocusedWindowId();
            }
            return this.mActiveWindowId;
        }

        private void setActiveWindowLocked(int windowId) {
            if (this.mActiveWindowId != windowId) {
                this.mActiveWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window;
                        window.setActive((window = this.mWindows.get(i)).getId() == windowId);
                    }
                }
                this.notifyWindowsChanged();
            }
        }

        private void setAccessibilityFocusedWindowLocked(int windowId) {
            if (this.mAccessibilityFocusedWindowId != windowId) {
                this.mAccessibilityFocusedWindowId = windowId;
                if (this.mWindows != null) {
                    int windowCount = this.mWindows.size();
                    for (int i = 0; i < windowCount; ++i) {
                        AccessibilityWindowInfo window;
                        window.setAccessibilityFocused((window = this.mWindows.get(i)).getId() == windowId);
                    }
                }
                this.notifyWindowsChanged();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyWindowsChanged() {
            if (AccessibilityManagerService.this.mWindowsForAccessibilityCallback == null) {
                return;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityEvent event = AccessibilityEvent.obtain(0x400000);
                event.setEventTime(SystemClock.uptimeMillis());
                AccessibilityManagerService.this.sendAccessibilityEvent(event, AccessibilityManagerService.this.mCurrentUserId);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        public boolean canGetAccessibilityNodeInfoLocked(Service service, int windowId) {
            return this.canRetrieveWindowContentLocked(service) && this.isRetrievalAllowingWindow(windowId);
        }

        public boolean canRetrieveWindowsLocked(Service service) {
            return this.canRetrieveWindowContentLocked(service) && service.mRetrieveInteractiveWindows;
        }

        public boolean canRetrieveWindowContentLocked(Service service) {
            return (service.mAccessibilityServiceInfo.getCapabilities() & 1) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int resolveProfileParentLocked(int userId) {
            if (userId != AccessibilityManagerService.this.mCurrentUserId) {
                long identity = Binder.clearCallingIdentity();
                try {
                    UserInfo parent = AccessibilityManagerService.this.mUserManager.getProfileParent(userId);
                    if (parent != null) {
                        int n = parent.getUserHandle().getIdentifier();
                        return n;
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(identity);
                }
            }
            return userId;
        }

        public int resolveCallingUserIdEnforcingPermissionsLocked(int userId) {
            int callingUid = Binder.getCallingUid();
            if (callingUid == 0 || callingUid == 1000 || callingUid == 2000) {
                if (userId == -2 || userId == -3) {
                    return AccessibilityManagerService.this.mCurrentUserId;
                }
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserId = UserHandle.getUserId(callingUid);
            if (callingUserId == userId) {
                return this.resolveProfileParentLocked(userId);
            }
            int callingUserParentId = this.resolveProfileParentLocked(callingUserId);
            if (callingUserParentId == AccessibilityManagerService.this.mCurrentUserId && (userId == -2 || userId == -3)) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            if (!this.hasPermission("android.permission.INTERACT_ACROSS_USERS") && !this.hasPermission("android.permission.INTERACT_ACROSS_USERS_FULL")) {
                throw new SecurityException("Call from user " + callingUserId + " as user " + userId + " without permission INTERACT_ACROSS_USERS or " + "INTERACT_ACROSS_USERS_FULL not allowed.");
            }
            if (userId == -2 || userId == -3) {
                return AccessibilityManagerService.this.mCurrentUserId;
            }
            throw new IllegalArgumentException("Calling user can be changed to only UserHandle.USER_CURRENT or UserHandle.USER_CURRENT_OR_SELF.");
        }

        public boolean isCallerInteractingAcrossUsers(int userId) {
            int callingUid = Binder.getCallingUid();
            return Binder.getCallingPid() == Process.myPid() || callingUid == 2000 || userId == -2 || userId == -3;
        }

        private boolean isRetrievalAllowingWindow(int windowId) {
            if (Binder.getCallingUid() == 1000) {
                return true;
            }
            if (windowId == this.mActiveWindowId) {
                return true;
            }
            return this.findWindowById(windowId) != null;
        }

        private AccessibilityWindowInfo findWindowById(int windowId) {
            if (this.mWindows != null) {
                int windowCount = this.mWindows.size();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = this.mWindows.get(i);
                    if (window.getId() != windowId) continue;
                    return window;
                }
            }
            return null;
        }

        private void enforceCallingPermission(String permission2, String function) {
            if (OWN_PROCESS_ID == Binder.getCallingPid()) {
                return;
            }
            if (!this.hasPermission(permission2)) {
                throw new SecurityException("You do not have " + permission2 + " required to call " + function + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            }
        }

        private boolean hasPermission(String permission2) {
            return AccessibilityManagerService.this.mContext.checkCallingPermission(permission2) == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int getFocusedWindowId() {
            IBinder token = AccessibilityManagerService.this.mWindowManagerService.getFocusedWindowToken();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return AccessibilityManagerService.this.findWindowIdLocked(token);
            }
        }
    }

    private final class InteractionBridge {
        private final Display mDefaultDisplay;
        private final int mConnectionId;
        private final AccessibilityInteractionClient mClient;

        public InteractionBridge() {
            AccessibilityServiceInfo info = new AccessibilityServiceInfo();
            info.setCapabilities(1);
            info.flags |= 0x40;
            info.flags |= 2;
            Service service = new Service(-10000, sFakeAccessibilityServiceComponentName, info);
            this.mConnectionId = service.mId;
            this.mClient = AccessibilityInteractionClient.getInstance();
            this.mClient.addConnection(this.mConnectionId, service);
            DisplayManager displayManager = (DisplayManager)AccessibilityManagerService.this.mContext.getSystemService("display");
            this.mDefaultDisplay = displayManager.getDisplay(0);
        }

        public void clearAccessibilityFocusNotLocked(int windowId) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked(windowId);
            if (focus != null) {
                focus.performAction(128);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean getAccessibilityFocusClickPointInScreenNotLocked(Point outPoint) {
            AccessibilityNodeInfo focus = this.getAccessibilityFocusNotLocked();
            if (focus == null) {
                return false;
            }
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                Rect boundsInScreen = AccessibilityManagerService.this.mTempRect;
                focus.getBoundsInScreen(boundsInScreen);
                Rect windowBounds = AccessibilityManagerService.this.mTempRect1;
                AccessibilityManagerService.this.getWindowBounds(focus.getWindowId(), windowBounds);
                if (!boundsInScreen.intersect(windowBounds)) {
                    return false;
                }
                MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(focus.getWindowId());
                if (spec != null && !spec.isNop()) {
                    boundsInScreen.offset((int)(-spec.offsetX), (int)(-spec.offsetY));
                    boundsInScreen.scale(1.0f / spec.scale);
                }
                Point screenSize = AccessibilityManagerService.this.mTempPoint;
                this.mDefaultDisplay.getRealSize(screenSize);
                if (!boundsInScreen.intersect(0, 0, screenSize.x, screenSize.y)) {
                    return false;
                }
                outPoint.set(boundsInScreen.centerX(), boundsInScreen.centerY());
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AccessibilityNodeInfo getAccessibilityFocusNotLocked() {
            int focusedWindowId;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                focusedWindowId = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mAccessibilityFocusedWindowId;
                if (focusedWindowId == -1) {
                    return null;
                }
            }
            return this.getAccessibilityFocusNotLocked(focusedWindowId);
        }

        private AccessibilityNodeInfo getAccessibilityFocusNotLocked(int windowId) {
            return this.mClient.findFocus(this.mConnectionId, windowId, AccessibilityNodeInfo.ROOT_NODE_ID, 2);
        }
    }

    final class WindowsForAccessibilityCallback
    implements WindowManagerInternal.WindowsForAccessibilityCallback {
        WindowsForAccessibilityCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onWindowsForAccessibilityChanged(List<WindowInfo> windows) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                ArrayList<AccessibilityWindowInfo> reportedWindows = new ArrayList<AccessibilityWindowInfo>();
                int receivedWindowCount = windows.size();
                for (int i = 0; i < receivedWindowCount; ++i) {
                    WindowInfo receivedWindow = windows.get(i);
                    AccessibilityWindowInfo reportedWindow = this.populateReportedWindow(receivedWindow);
                    if (reportedWindow == null) continue;
                    reportedWindows.add(reportedWindow);
                }
                AccessibilityManagerService.this.mSecurityPolicy.updateWindowsLocked(reportedWindows);
                AccessibilityManagerService.this.mLock.notifyAll();
            }
        }

        private AccessibilityWindowInfo populateReportedWindow(WindowInfo window) {
            int windowId = AccessibilityManagerService.this.findWindowIdLocked(window.token);
            if (windowId < 0) {
                return null;
            }
            AccessibilityWindowInfo reportedWindow = AccessibilityWindowInfo.obtain();
            reportedWindow.setId(windowId);
            reportedWindow.setType(this.getTypeForWindowManagerWindowType(window.type));
            reportedWindow.setLayer(window.layer);
            reportedWindow.setFocused(window.focused);
            reportedWindow.setBoundsInScreen(window.boundsInScreen);
            int parentId = AccessibilityManagerService.this.findWindowIdLocked(window.parentToken);
            if (parentId >= 0) {
                reportedWindow.setParentId(parentId);
            }
            if (window.childTokens != null) {
                int childCount = window.childTokens.size();
                for (int i = 0; i < childCount; ++i) {
                    IBinder childToken = window.childTokens.get(i);
                    int childId = AccessibilityManagerService.this.findWindowIdLocked(childToken);
                    if (childId < 0) continue;
                    reportedWindow.addChild(childId);
                }
            }
            return reportedWindow;
        }

        private int getTypeForWindowManagerWindowType(int windowType) {
            switch (windowType) {
                case 1: 
                case 2: 
                case 3: 
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1005: 
                case 2002: 
                case 2005: 
                case 2007: {
                    return 1;
                }
                case 2011: 
                case 2012: {
                    return 2;
                }
                case 2000: 
                case 2001: 
                case 2003: 
                case 2006: 
                case 2008: 
                case 2009: 
                case 2010: 
                case 2014: 
                case 2017: 
                case 2019: 
                case 2020: 
                case 2024: {
                    return 3;
                }
                case 2032: {
                    return 4;
                }
            }
            return -1;
        }
    }

    private static final class PendingEvent {
        PendingEvent next;
        KeyEvent event;
        int policyFlags;
        int sequence;
        boolean handled;

        private PendingEvent() {
        }

        public void clear() {
            if (this.event != null) {
                this.event.recycle();
                this.event = null;
            }
            this.next = null;
            this.policyFlags = 0;
            this.sequence = 0;
            this.handled = false;
        }
    }

    class Service
    extends IAccessibilityServiceConnection.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final int mUserId;
        int mId = 0;
        AccessibilityServiceInfo mAccessibilityServiceInfo;
        IBinder mService;
        IAccessibilityServiceClient mServiceInterface;
        int mEventTypes;
        int mFeedbackType;
        Set<String> mPackageNames = new HashSet<String>();
        boolean mIsDefault;
        boolean mRequestTouchExplorationMode;
        boolean mRequestEnhancedWebAccessibility;
        boolean mRequestFilterKeyEvents;
        boolean mRetrieveInteractiveWindows;
        int mFetchFlags;
        long mNotificationTimeout;
        ComponentName mComponentName;
        Intent mIntent;
        boolean mIsAutomation;
        final ResolveInfo mResolveInfo;
        final IBinder mOverlayWindowToken = new Binder();
        final SparseArray<AccessibilityEvent> mPendingEvents = new SparseArray();
        final KeyEventDispatcher mKeyEventDispatcher = new KeyEventDispatcher();
        boolean mWasConnectedAndDied;
        public Handler mEventDispatchHandler = new Handler(AccessibilityManagerService.access$2600(AccessibilityManagerService.this).getLooper()){

            @Override
            public void handleMessage(Message message) {
                int eventType = message.what;
                Service.this.notifyAccessibilityEventInternal(eventType);
            }
        };
        public InvocationHandler mInvocationHandler = new InvocationHandler(AccessibilityManagerService.access$2600(AccessibilityManagerService.this).getLooper());

        public Service(int userId, ComponentName componentName, AccessibilityServiceInfo accessibilityServiceInfo) {
            this.mUserId = userId;
            this.mResolveInfo = accessibilityServiceInfo.getResolveInfo();
            this.mId = sIdCounter++;
            this.mComponentName = componentName;
            this.mAccessibilityServiceInfo = accessibilityServiceInfo;
            this.mIsAutomation = sFakeAccessibilityServiceComponentName.equals(componentName);
            if (!this.mIsAutomation) {
                this.mIntent = new Intent().setComponent(this.mComponentName);
                this.mIntent.putExtra("android.intent.extra.client_label", 17040427);
                this.mIntent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivity(AccessibilityManagerService.this.mContext, 0, new Intent("android.settings.ACCESSIBILITY_SETTINGS"), 0));
            }
            this.setDynamicallyConfigurableProperties(accessibilityServiceInfo);
        }

        public void setDynamicallyConfigurableProperties(AccessibilityServiceInfo info) {
            this.mEventTypes = info.eventTypes;
            this.mFeedbackType = info.feedbackType;
            String[] packageNames = info.packageNames;
            if (packageNames != null) {
                this.mPackageNames.addAll(Arrays.asList(packageNames));
            }
            this.mNotificationTimeout = info.notificationTimeout;
            boolean bl = this.mIsDefault = (info.flags & 1) != 0;
            if (this.mIsAutomation || info.getResolveInfo().serviceInfo.applicationInfo.targetSdkVersion >= 16) {
                this.mFetchFlags = (info.flags & 2) != 0 ? (this.mFetchFlags |= 8) : (this.mFetchFlags &= 0xFFFFFFF7);
            }
            this.mFetchFlags = (info.flags & 0x10) != 0 ? (this.mFetchFlags |= 0x10) : (this.mFetchFlags &= 0xFFFFFFEF);
            this.mRequestTouchExplorationMode = (info.flags & 4) != 0;
            this.mRequestEnhancedWebAccessibility = (info.flags & 8) != 0;
            this.mRequestFilterKeyEvents = (info.flags & 0x20) != 0;
            this.mRetrieveInteractiveWindows = (info.flags & 0x40) != 0;
        }

        public boolean bindLocked() {
            UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            if (!this.mIsAutomation) {
                if (this.mService == null && AccessibilityManagerService.this.mContext.bindServiceAsUser(this.mIntent, this, 0x2000001, new UserHandle(this.mUserId))) {
                    userState.mBindingServices.add(this.mComponentName);
                }
            } else {
                userState.mBindingServices.add(this.mComponentName);
                this.mService = userState.mUiAutomationServiceClient.asBinder();
                AccessibilityManagerService.this.mMainHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        Service.this.onServiceConnected(Service.this.mComponentName, Service.this.mService);
                    }
                });
                userState.mUiAutomationService = this;
            }
            return false;
        }

        public boolean unbindLocked() {
            if (this.mService == null) {
                return false;
            }
            UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
            this.mKeyEventDispatcher.flush();
            if (!this.mIsAutomation) {
                AccessibilityManagerService.this.mContext.unbindService(this);
            } else {
                userState.destroyUiAutomationService();
            }
            AccessibilityManagerService.this.removeServiceLocked(this, userState);
            this.resetLocked();
            return true;
        }

        public boolean canReceiveEventsLocked() {
            return this.mEventTypes != 0 && this.mFeedbackType != 0 && this.mService != null;
        }

        @Override
        public void setOnKeyEventResult(boolean handled, int sequence) {
            this.mKeyEventDispatcher.setOnKeyEventResult(handled, sequence);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityServiceInfo getServiceInfo() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                return this.mAccessibilityServiceInfo;
            }
        }

        public boolean canRetrieveInteractiveWindowsLocked() {
            return AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContentLocked(this) && this.mRetrieveInteractiveWindows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setServiceInfo(AccessibilityServiceInfo info) {
            long identity = Binder.clearCallingIdentity();
            try {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    AccessibilityServiceInfo oldInfo = this.mAccessibilityServiceInfo;
                    if (oldInfo != null) {
                        oldInfo.updateDynamicallyConfigurableProperties(info);
                        this.setDynamicallyConfigurableProperties(oldInfo);
                    } else {
                        this.setDynamicallyConfigurableProperties(info);
                    }
                    UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                    AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                }
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onServiceConnected(ComponentName componentName, IBinder service) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                this.mService = service;
                this.mServiceInterface = IAccessibilityServiceClient.Stub.asInterface(service);
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                AccessibilityManagerService.this.addServiceLocked(this, userState);
                if (userState.mBindingServices.contains(this.mComponentName) || this.mWasConnectedAndDied) {
                    userState.mBindingServices.remove(this.mComponentName);
                    this.mWasConnectedAndDied = false;
                    try {
                        this.mServiceInterface.init(this, this.mId, this.mOverlayWindowToken);
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                    catch (RemoteException re) {
                        Slog.w(AccessibilityManagerService.LOG_TAG, "Error while setting connection for service: " + service, re);
                        this.binderDied();
                    }
                } else {
                    this.binderDied();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<AccessibilityWindowInfo> getWindows() {
            AccessibilityManagerService.this.ensureWindowsAvailableTimed();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return null;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowsLocked(this);
                if (!permissionGranted) {
                    return null;
                }
                if (((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows == null) {
                    return null;
                }
                ArrayList<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>();
                int windowCount = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows.size();
                for (int i = 0; i < windowCount; ++i) {
                    AccessibilityWindowInfo window = ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mWindows.get(i);
                    AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                    windowClone.setConnectionId(this.mId);
                    windows.add(windowClone);
                }
                return windows;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AccessibilityWindowInfo getWindow(int windowId) {
            AccessibilityManagerService.this.ensureWindowsAvailableTimed();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return null;
                }
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowsLocked(this);
                if (!permissionGranted) {
                    return null;
                }
                AccessibilityWindowInfo window = AccessibilityManagerService.this.mSecurityPolicy.findWindowById(windowId);
                if (window != null) {
                    AccessibilityWindowInfo windowClone = AccessibilityWindowInfo.obtain(window);
                    windowClone.setConnectionId(this.mId);
                    return windowClone;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfosByViewId(int accessibilityWindowId, long accessibilityNodeId, String viewIdResName, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfosByViewId(accessibilityNodeId, viewIdResName, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfosByText(int accessibilityWindowId, long accessibilityNodeId, String text, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfosByText(accessibilityNodeId, text, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findAccessibilityNodeInfoByAccessibilityId(int accessibilityWindowId, long accessibilityNodeId, int interactionId, IAccessibilityInteractionConnectionCallback callback, int flags, long interrogatingTid) throws RemoteException {
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            try {
                connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityNodeId, partialInteractiveRegion, interactionId, callback, this.mFetchFlags | flags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean findFocus(int accessibilityWindowId, long accessibilityNodeId, int focusType, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdForFindFocusLocked(accessibilityWindowId, focusType);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            try {
                connection.findFocus(accessibilityNodeId, focusType, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean focusSearch(int accessibilityWindowId, long accessibilityNodeId, int direction, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            int resolvedWindowId;
            IAccessibilityInteractionConnection connection = null;
            Region partialInteractiveRegion = Region.obtain();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
                if (!AccessibilityManagerService.this.mSecurityPolicy.computePartialInteractiveRegionForWindowLocked(resolvedWindowId, partialInteractiveRegion)) {
                    partialInteractiveRegion.recycle();
                    partialInteractiveRegion = null;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            MagnificationSpec spec = AccessibilityManagerService.this.getCompatibleMagnificationSpecLocked(resolvedWindowId);
            try {
                connection.focusSearch(accessibilityNodeId, direction, partialInteractiveRegion, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid, spec);
                boolean bl = true;
                return bl;
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
                if (partialInteractiveRegion != null && Binder.isProxy(connection)) {
                    partialInteractiveRegion.recycle();
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean performAccessibilityAction(int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments, int interactionId, IAccessibilityInteractionConnectionCallback callback, long interrogatingTid) throws RemoteException {
            IAccessibilityInteractionConnection connection = null;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
                int resolvedWindowId = this.resolveAccessibilityWindowIdLocked(accessibilityWindowId);
                boolean permissionGranted = AccessibilityManagerService.this.mSecurityPolicy.canGetAccessibilityNodeInfoLocked(this, resolvedWindowId);
                if (!permissionGranted) {
                    return false;
                }
                connection = this.getConnectionLocked(resolvedWindowId);
                if (connection == null) {
                    return false;
                }
            }
            int interrogatingPid = Binder.getCallingPid();
            long identityToken = Binder.clearCallingIdentity();
            try {
                connection.performAccessibilityAction(accessibilityNodeId, action, arguments, interactionId, callback, this.mFetchFlags, interrogatingPid, interrogatingTid);
            }
            catch (RemoteException re) {
            }
            finally {
                Binder.restoreCallingIdentity(identityToken);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean performGlobalAction(int action) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int resolvedUserId = AccessibilityManagerService.this.mSecurityPolicy.resolveCallingUserIdEnforcingPermissionsLocked(-2);
                if (resolvedUserId != AccessibilityManagerService.this.mCurrentUserId) {
                    return false;
                }
            }
            long identity = Binder.clearCallingIdentity();
            try {
                switch (action) {
                    case 1: {
                        this.sendDownAndUpKeyEvents(4);
                        boolean bl = true;
                        return bl;
                    }
                    case 2: {
                        this.sendDownAndUpKeyEvents(3);
                        boolean bl = true;
                        return bl;
                    }
                    case 3: {
                        this.openRecents();
                        boolean bl = true;
                        return bl;
                    }
                    case 4: {
                        this.expandNotifications();
                        boolean bl = true;
                        return bl;
                    }
                    case 5: {
                        this.expandQuickSettings();
                        boolean bl = true;
                        return bl;
                    }
                    case 6: {
                        this.showGlobalActions();
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            AccessibilityManagerService.this.mSecurityPolicy.enforceCallingPermission("android.permission.DUMP", AccessibilityManagerService.FUNCTION_DUMP);
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                pw.append("Service[label=" + this.mAccessibilityServiceInfo.getResolveInfo().loadLabel(AccessibilityManagerService.this.mContext.getPackageManager()));
                pw.append(", feedbackType" + AccessibilityServiceInfo.feedbackTypeToString(this.mFeedbackType));
                pw.append(", capabilities=" + this.mAccessibilityServiceInfo.getCapabilities());
                pw.append(", eventTypes=" + AccessibilityEvent.eventTypeToString(this.mEventTypes));
                pw.append(", notificationTimeout=" + this.mNotificationTimeout);
                pw.append("]");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onAdded() throws RemoteException {
            this.linkToOwnDeathLocked();
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mWindowManagerService.addWindowToken(this.mOverlayWindowToken, 2032);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemoved() {
            long identity = Binder.clearCallingIdentity();
            try {
                AccessibilityManagerService.this.mWindowManagerService.removeWindowToken(this.mOverlayWindowToken, true);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            this.unlinkToOwnDeathLocked();
        }

        public void linkToOwnDeathLocked() throws RemoteException {
            this.mService.linkToDeath(this, 0);
        }

        public void unlinkToOwnDeathLocked() {
            this.mService.unlinkToDeath(this, 0);
        }

        public void resetLocked() {
            try {
                this.mServiceInterface.init(null, this.mId, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.mService = null;
            this.mServiceInterface = null;
        }

        public boolean isConnectedLocked() {
            return this.mService != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                if (!this.isConnectedLocked()) {
                    return;
                }
                this.mWasConnectedAndDied = true;
                this.mKeyEventDispatcher.flush();
                UserState userState = AccessibilityManagerService.this.getUserStateLocked(this.mUserId);
                AccessibilityManagerService.this.removeServiceLocked(this, userState);
                this.resetLocked();
                if (this.mIsAutomation) {
                    userState.mInstalledServices.remove(this.mAccessibilityServiceInfo);
                    userState.mEnabledServices.remove(this.mComponentName);
                    userState.destroyUiAutomationService();
                    if (AccessibilityManagerService.this.readConfigurationForUserStateLocked(userState)) {
                        AccessibilityManagerService.this.onUserStateChangedLocked(userState);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void notifyAccessibilityEvent(AccessibilityEvent event) {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                int eventType = event.getEventType();
                AccessibilityEvent newEvent = AccessibilityEvent.obtain(event);
                AccessibilityEvent oldEvent = this.mPendingEvents.get(eventType);
                this.mPendingEvents.put(eventType, newEvent);
                int what = eventType;
                if (oldEvent != null) {
                    this.mEventDispatchHandler.removeMessages(what);
                    oldEvent.recycle();
                }
                Message message = this.mEventDispatchHandler.obtainMessage(what);
                this.mEventDispatchHandler.sendMessageDelayed(message, this.mNotificationTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyAccessibilityEventInternal(int eventType) {
            AccessibilityEvent event;
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
                if (listener == null) {
                    return;
                }
                event = this.mPendingEvents.get(eventType);
                if (event == null) {
                    return;
                }
                this.mPendingEvents.remove(eventType);
                if (AccessibilityManagerService.this.mSecurityPolicy.canRetrieveWindowContentLocked(this)) {
                    event.setConnectionId(this.mId);
                } else {
                    event.setSource(null);
                }
                event.setSealed(true);
            }
            try {
                listener.onAccessibilityEvent(event);
            }
            catch (RemoteException re) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending " + event + " to " + listener, re);
            }
            finally {
                event.recycle();
            }
        }

        public void notifyGesture(int gestureId) {
            this.mInvocationHandler.obtainMessage(1, gestureId, 0).sendToTarget();
        }

        public void notifyKeyEvent(KeyEvent event, int policyFlags) {
            this.mInvocationHandler.obtainMessage(2, policyFlags, 0, event).sendToTarget();
        }

        public void notifyClearAccessibilityNodeInfoCache() {
            this.mInvocationHandler.sendEmptyMessage(3);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyGestureInternal(int gestureId) {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.onGesture(gestureId);
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during sending gesture " + gestureId + " to " + this.mService, re);
                }
            }
        }

        private void notifyKeyEventInternal(KeyEvent event, int policyFlags) {
            this.mKeyEventDispatcher.notifyKeyEvent(event, policyFlags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyClearAccessibilityCacheInternal() {
            IAccessibilityServiceClient listener;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                listener = this.mServiceInterface;
            }
            if (listener != null) {
                try {
                    listener.clearAccessibilityCache();
                }
                catch (RemoteException re) {
                    Slog.e(AccessibilityManagerService.LOG_TAG, "Error during requesting accessibility info cache to be cleared.", re);
                }
            }
        }

        private void sendDownAndUpKeyEvents(int keyCode) {
            long token = Binder.clearCallingIdentity();
            long downTime = SystemClock.uptimeMillis();
            KeyEvent down = KeyEvent.obtain(downTime, downTime, 0, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(down, 0);
            down.recycle();
            long upTime = SystemClock.uptimeMillis();
            KeyEvent up = KeyEvent.obtain(downTime, upTime, 1, keyCode, 0, 0, -1, 0, 8, 257, null);
            InputManager.getInstance().injectInputEvent(up, 0);
            up.recycle();
            Binder.restoreCallingIdentity(token);
        }

        private void expandNotifications() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandNotificationsPanel();
            Binder.restoreCallingIdentity(token);
        }

        private void expandQuickSettings() {
            long token = Binder.clearCallingIdentity();
            StatusBarManager statusBarManager = (StatusBarManager)AccessibilityManagerService.this.mContext.getSystemService("statusbar");
            statusBarManager.expandSettingsPanel();
            Binder.restoreCallingIdentity(token);
        }

        private void openRecents() {
            long token = Binder.clearCallingIdentity();
            IStatusBarService statusBarService = IStatusBarService.Stub.asInterface(ServiceManager.getService("statusbar"));
            try {
                statusBarService.toggleRecentApps();
            }
            catch (RemoteException e) {
                Slog.e(AccessibilityManagerService.LOG_TAG, "Error toggling recent apps.");
            }
            Binder.restoreCallingIdentity(token);
        }

        private void showGlobalActions() {
            AccessibilityManagerService.this.mWindowManagerService.showGlobalActions();
        }

        private IAccessibilityInteractionConnection getConnectionLocked(int windowId) {
            AccessibilityConnectionWrapper wrapper = (AccessibilityConnectionWrapper)AccessibilityManagerService.this.mGlobalInteractionConnections.get(windowId);
            if (wrapper == null) {
                wrapper = ((AccessibilityManagerService)AccessibilityManagerService.this).getCurrentUserStateLocked().mInteractionConnections.get(windowId);
            }
            if (wrapper != null && wrapper.mConnection != null) {
                return wrapper.mConnection;
            }
            return null;
        }

        private int resolveAccessibilityWindowIdLocked(int accessibilityWindowId) {
            if (accessibilityWindowId == Integer.MAX_VALUE) {
                return AccessibilityManagerService.this.mSecurityPolicy.getActiveWindowId();
            }
            return accessibilityWindowId;
        }

        private int resolveAccessibilityWindowIdForFindFocusLocked(int windowId, int focusType) {
            if (windowId == Integer.MAX_VALUE) {
                return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mActiveWindowId;
            }
            if (windowId == -2) {
                if (focusType == 1) {
                    return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mFocusedWindowId;
                }
                if (focusType == 2) {
                    return ((AccessibilityManagerService)AccessibilityManagerService.this).mSecurityPolicy.mAccessibilityFocusedWindowId;
                }
            }
            return windowId;
        }

        private final class KeyEventDispatcher {
            private static final long ON_KEY_EVENT_TIMEOUT_MILLIS = 500L;
            private PendingEvent mPendingEvents;
            private final InputEventConsistencyVerifier mSentEventsVerifier = InputEventConsistencyVerifier.isInstrumentationEnabled() ? new InputEventConsistencyVerifier(this, 0, KeyEventDispatcher.class.getSimpleName()) : null;

            private KeyEventDispatcher() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notifyKeyEvent(KeyEvent event, int policyFlags) {
                PendingEvent pendingEvent;
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    pendingEvent = this.addPendingEventLocked(event, policyFlags);
                }
                Message message = Service.this.mInvocationHandler.obtainMessage(4, pendingEvent);
                Service.this.mInvocationHandler.sendMessageDelayed(message, 500L);
                try {
                    Service.this.mServiceInterface.onKeyEvent(pendingEvent.event, pendingEvent.sequence);
                }
                catch (RemoteException re) {
                    this.setOnKeyEventResult(false, pendingEvent.sequence);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setOnKeyEventResult(boolean handled, int sequence) {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    PendingEvent pendingEvent = this.removePendingEventLocked(sequence);
                    if (pendingEvent != null) {
                        Service.this.mInvocationHandler.removeMessages(4, pendingEvent);
                        pendingEvent.handled = handled;
                        this.finishPendingEventLocked(pendingEvent);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void flush() {
                Object object = AccessibilityManagerService.this.mLock;
                synchronized (object) {
                    this.cancelAllPendingEventsLocked();
                    if (this.mSentEventsVerifier != null) {
                        this.mSentEventsVerifier.reset();
                    }
                }
            }

            private PendingEvent addPendingEventLocked(KeyEvent event, int policyFlags) {
                int sequence = event.getSequenceNumber();
                PendingEvent pendingEvent = AccessibilityManagerService.this.obtainPendingEventLocked(event, policyFlags, sequence);
                pendingEvent.next = this.mPendingEvents;
                this.mPendingEvents = pendingEvent;
                return pendingEvent;
            }

            private PendingEvent removePendingEventLocked(int sequence) {
                PendingEvent previous = null;
                PendingEvent current = this.mPendingEvents;
                while (current != null) {
                    if (current.sequence == sequence) {
                        if (previous != null) {
                            previous.next = current.next;
                        } else {
                            this.mPendingEvents = current.next;
                        }
                        current.next = null;
                        return current;
                    }
                    previous = current;
                    current = current.next;
                }
                return null;
            }

            private void finishPendingEventLocked(PendingEvent pendingEvent) {
                if (!pendingEvent.handled) {
                    this.sendKeyEventToInputFilter(pendingEvent.event, pendingEvent.policyFlags);
                }
                pendingEvent.event = null;
                AccessibilityManagerService.this.recyclePendingEventLocked(pendingEvent);
            }

            private void sendKeyEventToInputFilter(KeyEvent event, int policyFlags) {
                if (this.mSentEventsVerifier != null) {
                    this.mSentEventsVerifier.onKeyEvent(event, 0);
                }
                AccessibilityManagerService.this.mMainHandler.obtainMessage(8, policyFlags |= 0x40000000, 0, event).sendToTarget();
            }

            private void cancelAllPendingEventsLocked() {
                while (this.mPendingEvents != null) {
                    PendingEvent pendingEvent = this.removePendingEventLocked(this.mPendingEvents.sequence);
                    pendingEvent.handled = false;
                    Service.this.mInvocationHandler.removeMessages(4, pendingEvent);
                    this.finishPendingEventLocked(pendingEvent);
                }
            }
        }

        private final class InvocationHandler
        extends Handler {
            public static final int MSG_ON_GESTURE = 1;
            public static final int MSG_ON_KEY_EVENT = 2;
            public static final int MSG_CLEAR_ACCESSIBILITY_CACHE = 3;
            public static final int MSG_ON_KEY_EVENT_TIMEOUT = 4;

            public InvocationHandler(Looper looper) {
                super(looper, null, true);
            }

            @Override
            public void handleMessage(Message message) {
                int type = message.what;
                switch (type) {
                    case 1: {
                        int gestureId = message.arg1;
                        Service.this.notifyGestureInternal(gestureId);
                        break;
                    }
                    case 2: {
                        KeyEvent event = (KeyEvent)message.obj;
                        int policyFlags = message.arg1;
                        Service.this.notifyKeyEventInternal(event, policyFlags);
                        break;
                    }
                    case 3: {
                        Service.this.notifyClearAccessibilityCacheInternal();
                        break;
                    }
                    case 4: {
                        PendingEvent eventState = (PendingEvent)message.obj;
                        Service.this.setOnKeyEventResult(false, eventState.sequence);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown message: " + type);
                    }
                }
            }
        }
    }

    private final class MainHandler
    extends Handler {
        public static final int MSG_SEND_ACCESSIBILITY_EVENT_TO_INPUT_FILTER = 1;
        public static final int MSG_SEND_STATE_TO_CLIENTS = 2;
        public static final int MSG_SEND_CLEARED_STATE_TO_CLIENTS_FOR_USER = 3;
        public static final int MSG_ANNOUNCE_NEW_USER_IF_NEEDED = 5;
        public static final int MSG_UPDATE_INPUT_FILTER = 6;
        public static final int MSG_SHOW_ENABLED_TOUCH_EXPLORATION_DIALOG = 7;
        public static final int MSG_SEND_KEY_EVENT_TO_INPUT_FILTER = 8;
        public static final int MSG_CLEAR_ACCESSIBILITY_FOCUS = 9;

        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            int type = msg.what;
            switch (type) {
                case 1: {
                    AccessibilityEvent event = (AccessibilityEvent)msg.obj;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.notifyAccessibilityEvent(event);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 8: {
                    KeyEvent event = (KeyEvent)msg.obj;
                    int policyFlags = msg.arg1;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        if (AccessibilityManagerService.this.mHasInputFilter && AccessibilityManagerService.this.mInputFilter != null) {
                            AccessibilityManagerService.this.mInputFilter.sendInputEvent(event, policyFlags);
                        }
                    }
                    event.recycle();
                    break;
                }
                case 2: {
                    int clientState = msg.arg1;
                    int userId = msg.arg2;
                    this.sendStateToClients(clientState, AccessibilityManagerService.this.mGlobalClients);
                    this.sendStateToClientsForUser(clientState, userId);
                    break;
                }
                case 3: {
                    int userId = msg.arg1;
                    this.sendStateToClientsForUser(0, userId);
                    break;
                }
                case 5: {
                    this.announceNewUserIfNeeded();
                    break;
                }
                case 6: {
                    UserState userState = (UserState)msg.obj;
                    AccessibilityManagerService.this.updateInputFilter(userState);
                    break;
                }
                case 7: {
                    Service service = (Service)msg.obj;
                    AccessibilityManagerService.this.showEnableTouchExplorationDialog(service);
                    break;
                }
                case 9: {
                    InteractionBridge bridge;
                    int windowId = msg.arg1;
                    Object object = AccessibilityManagerService.this.mLock;
                    synchronized (object) {
                        bridge = AccessibilityManagerService.this.getInteractionBridgeLocked();
                    }
                    bridge.clearAccessibilityFocusNotLocked(windowId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void announceNewUserIfNeeded() {
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                UserState userState = AccessibilityManagerService.this.getCurrentUserStateLocked();
                if (userState.mIsAccessibilityEnabled) {
                    UserManager userManager = (UserManager)AccessibilityManagerService.this.mContext.getSystemService("user");
                    String message = AccessibilityManagerService.this.mContext.getString(17040617, userManager.getUserInfo((int)((AccessibilityManagerService)AccessibilityManagerService.this).mCurrentUserId).name);
                    AccessibilityEvent event = AccessibilityEvent.obtain(16384);
                    event.getText().add(message);
                    AccessibilityManagerService.this.sendAccessibilityEvent(event, AccessibilityManagerService.this.mCurrentUserId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStateToClientsForUser(int clientState, int userId) {
            UserState userState;
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                userState = AccessibilityManagerService.this.getUserStateLocked(userId);
            }
            this.sendStateToClients(clientState, userState.mClients);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendStateToClients(int clientState, RemoteCallbackList<IAccessibilityManagerClient> clients) {
            try {
                int userClientCount = clients.beginBroadcast();
                for (int i = 0; i < userClientCount; ++i) {
                    IAccessibilityManagerClient client = clients.getBroadcastItem(i);
                    try {
                        client.setState(clientState);
                        continue;
                    }
                    catch (RemoteException re) {
                        // empty catch block
                    }
                }
            }
            finally {
                clients.finishBroadcast();
            }
        }
    }

    private class AccessibilityConnectionWrapper
    implements IBinder.DeathRecipient {
        private final int mWindowId;
        private final int mUserId;
        private final IAccessibilityInteractionConnection mConnection;

        public AccessibilityConnectionWrapper(int windowId, IAccessibilityInteractionConnection connection, int userId) {
            this.mWindowId = windowId;
            this.mUserId = userId;
            this.mConnection = connection;
        }

        public void linkToDeath() throws RemoteException {
            this.mConnection.asBinder().linkToDeath(this, 0);
        }

        public void unlinkToDeath() {
            this.mConnection.asBinder().unlinkToDeath(this, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            this.unlinkToDeath();
            Object object = AccessibilityManagerService.this.mLock;
            synchronized (object) {
                AccessibilityManagerService.this.removeAccessibilityInteractionConnectionLocked(this.mWindowId, this.mUserId);
            }
        }
    }
}

