/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.accounts;

import android.accounts.Account;
import android.accounts.AccountAndUser;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AuthenticatorDescription;
import android.accounts.CantAddAccountActivity;
import android.accounts.GrantCredentialsPermissionActivity;
import android.accounts.IAccountAuthenticator;
import android.accounts.IAccountAuthenticatorResponse;
import android.accounts.IAccountManager;
import android.accounts.IAccountManagerResponse;
import android.app.ActivityManager;
import android.app.ActivityManagerNative;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.FgThread;
import com.android.server.accounts.AccountAuthenticatorCache;
import com.android.server.accounts.IAccountAuthenticatorCache;
import com.android.server.accounts.TokenCache;
import com.google.android.collect.Lists;
import com.google.android.collect.Sets;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class AccountManagerService
extends IAccountManager.Stub
implements RegisteredServicesCacheListener<AuthenticatorDescription> {
    private static final String TAG = "AccountManagerService";
    private static final String DATABASE_NAME = "accounts.db";
    private static final int DATABASE_VERSION = 8;
    private static final int MAX_DEBUG_DB_SIZE = 64;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final AppOpsManager mAppOpsManager;
    private UserManager mUserManager;
    private final MessageHandler mMessageHandler;
    private static final int MESSAGE_TIMED_OUT = 3;
    private static final int MESSAGE_COPY_SHARED_ACCOUNT = 4;
    private final IAccountAuthenticatorCache mAuthenticatorCache;
    private static final String TABLE_ACCOUNTS = "accounts";
    private static final String ACCOUNTS_ID = "_id";
    private static final String ACCOUNTS_NAME = "name";
    private static final String ACCOUNTS_TYPE = "type";
    private static final String ACCOUNTS_TYPE_COUNT = "count(type)";
    private static final String ACCOUNTS_PASSWORD = "password";
    private static final String ACCOUNTS_PREVIOUS_NAME = "previous_name";
    private static final String ACCOUNTS_LAST_AUTHENTICATE_TIME_EPOCH_MILLIS = "last_password_entry_time_millis_epoch";
    private static final String TABLE_AUTHTOKENS = "authtokens";
    private static final String AUTHTOKENS_ID = "_id";
    private static final String AUTHTOKENS_ACCOUNTS_ID = "accounts_id";
    private static final String AUTHTOKENS_TYPE = "type";
    private static final String AUTHTOKENS_AUTHTOKEN = "authtoken";
    private static final String TABLE_GRANTS = "grants";
    private static final String GRANTS_ACCOUNTS_ID = "accounts_id";
    private static final String GRANTS_AUTH_TOKEN_TYPE = "auth_token_type";
    private static final String GRANTS_GRANTEE_UID = "uid";
    private static final String TABLE_EXTRAS = "extras";
    private static final String EXTRAS_ID = "_id";
    private static final String EXTRAS_ACCOUNTS_ID = "accounts_id";
    private static final String EXTRAS_KEY = "key";
    private static final String EXTRAS_VALUE = "value";
    private static final String TABLE_META = "meta";
    private static final String META_KEY = "key";
    private static final String META_VALUE = "value";
    private static final String TABLE_SHARED_ACCOUNTS = "shared_accounts";
    private static final String[] ACCOUNT_TYPE_COUNT_PROJECTION = new String[]{"type", "count(type)"};
    private static final Intent ACCOUNTS_CHANGED_INTENT = new Intent("android.accounts.LOGIN_ACCOUNTS_CHANGED");
    private static final String COUNT_OF_MATCHING_GRANTS = "SELECT COUNT(*) FROM grants, accounts WHERE accounts_id=_id AND uid=? AND auth_token_type=? AND name=? AND type=?";
    private static final String SELECTION_AUTHTOKENS_BY_ACCOUNT = "accounts_id=(select _id FROM accounts WHERE name=? AND type=?)";
    private static final String[] COLUMNS_AUTHTOKENS_TYPE_AND_AUTHTOKEN;
    private static final String SELECTION_USERDATA_BY_ACCOUNT = "accounts_id=(select _id FROM accounts WHERE name=? AND type=?)";
    private static final String[] COLUMNS_EXTRAS_KEY_AND_VALUE;
    private final LinkedHashMap<String, Session> mSessions = new LinkedHashMap();
    private final AtomicInteger mNotificationIds = new AtomicInteger(1);
    private final SparseArray<UserAccounts> mUsers = new SparseArray();
    private static AtomicReference<AccountManagerService> sThis;
    private static final Account[] EMPTY_ACCOUNT_ARRAY;

    public static AccountManagerService getSingleton() {
        return sThis.get();
    }

    public AccountManagerService(Context context) {
        this(context, context.getPackageManager(), new AccountAuthenticatorCache(context));
    }

    public AccountManagerService(Context context, PackageManager packageManager, IAccountAuthenticatorCache authenticatorCache) {
        this.mContext = context;
        this.mPackageManager = packageManager;
        this.mAppOpsManager = this.mContext.getSystemService(AppOpsManager.class);
        this.mMessageHandler = new MessageHandler(FgThread.get().getLooper());
        this.mAuthenticatorCache = authenticatorCache;
        this.mAuthenticatorCache.setListener(this, null);
        sThis.set(this);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context1, Intent intent) {
                if (!intent.getBooleanExtra("android.intent.extra.REPLACING", false)) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            AccountManagerService.this.purgeOldGrantsAll();
                        }
                    };
                    new Thread(r).start();
                }
            }
        }, intentFilter);
        IntentFilter userFilter = new IntentFilter();
        userFilter.addAction("android.intent.action.USER_REMOVED");
        userFilter.addAction("android.intent.action.USER_STARTED");
        this.mContext.registerReceiverAsUser(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if ("android.intent.action.USER_REMOVED".equals(action)) {
                    AccountManagerService.this.onUserRemoved(intent);
                } else if ("android.intent.action.USER_STARTED".equals(action)) {
                    AccountManagerService.this.onUserStarted(intent);
                }
            }
        }, UserHandle.ALL, userFilter, null, null);
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Account Manager Crash", e);
            }
            throw e;
        }
    }

    public void systemReady() {
    }

    private UserManager getUserManager() {
        if (this.mUserManager == null) {
            this.mUserManager = UserManager.get(this.mContext);
        }
        return this.mUserManager;
    }

    public void validateAccounts(int userId) {
        UserAccounts accounts = this.getUserAccounts(userId);
        this.validateAccountsInternal(accounts, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateAccountsInternal(UserAccounts accounts, boolean invalidateAuthenticatorCache) {
        if (invalidateAuthenticatorCache) {
            this.mAuthenticatorCache.invalidateCache(accounts.userId);
        }
        HashSet knownAuth = Sets.newHashSet();
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> service : this.mAuthenticatorCache.getAllServices(accounts.userId)) {
            knownAuth.add(service.type);
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            boolean accountDeleted = false;
            Cursor cursor = db.query(TABLE_ACCOUNTS, new String[]{"_id", "type", ACCOUNTS_NAME}, null, null, null, null, "_id");
            try {
                String accountType;
                accounts.accountCache.clear();
                LinkedHashMap<String, ArrayList<String>> accountNamesByType = new LinkedHashMap<String, ArrayList<String>>();
                while (cursor.moveToNext()) {
                    long accountId = cursor.getLong(0);
                    accountType = cursor.getString(1);
                    String accountName = cursor.getString(2);
                    if (!knownAuth.contains(AuthenticatorDescription.newKey(accountType))) {
                        Slog.w(TAG, "deleting account " + accountName + " because type " + accountType + " no longer has a registered authenticator");
                        db.delete(TABLE_ACCOUNTS, "_id=" + accountId, null);
                        accountDeleted = true;
                        this.logRecord(db, DebugDbHelper.ACTION_AUTHENTICATOR_REMOVE, TABLE_ACCOUNTS, accountId, accounts);
                        Account account = new Account(accountName, accountType);
                        accounts.userDataCache.remove(account);
                        accounts.authTokenCache.remove(account);
                        accounts.accountTokenCaches.remove(account);
                        continue;
                    }
                    ArrayList<String> accountNames = (ArrayList<String>)((HashMap)accountNamesByType).get(accountType);
                    if (accountNames == null) {
                        accountNames = new ArrayList<String>();
                        accountNamesByType.put(accountType, accountNames);
                    }
                    accountNames.add(accountName);
                }
                for (Map.Entry cur : accountNamesByType.entrySet()) {
                    accountType = (String)cur.getKey();
                    ArrayList accountNames = (ArrayList)cur.getValue();
                    Account[] accountsForType = new Account[accountNames.size()];
                    int i = 0;
                    for (String accountName : accountNames) {
                        accountsForType[i] = new Account(accountName, accountType);
                        ++i;
                    }
                    accounts.accountCache.put(accountType, accountsForType);
                }
            }
            finally {
                cursor.close();
                if (accountDeleted) {
                    this.sendAccountsChangedBroadcast(accounts.userId);
                }
            }
        }
    }

    private UserAccounts getUserAccountsForCaller() {
        return this.getUserAccounts(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UserAccounts getUserAccounts(int userId) {
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            UserAccounts accounts = this.mUsers.get(userId);
            if (accounts == null) {
                accounts = new UserAccounts(this.mContext, userId);
                this.initializeDebugDbSizeAndCompileSqlStatementForLogging(accounts.openHelper.getWritableDatabase(), accounts);
                this.mUsers.append(userId, accounts);
                this.purgeOldGrants(accounts);
                this.validateAccountsInternal(accounts, true);
            }
            return accounts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOldGrantsAll() {
        SparseArray<UserAccounts> sparseArray = this.mUsers;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mUsers.size(); ++i) {
                this.purgeOldGrants(this.mUsers.valueAt(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOldGrants(UserAccounts accounts) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            try (Cursor cursor = db.query(TABLE_GRANTS, new String[]{GRANTS_GRANTEE_UID}, null, null, GRANTS_GRANTEE_UID, null, null);){
                while (cursor.moveToNext()) {
                    boolean packageExists;
                    int uid = cursor.getInt(0);
                    boolean bl = packageExists = this.mPackageManager.getPackagesForUid(uid) != null;
                    if (packageExists) continue;
                    Log.d(TAG, "deleting grants for UID " + uid + " because its package is no longer installed");
                    db.delete(TABLE_GRANTS, "uid=?", new String[]{Integer.toString(uid)});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(Intent intent) {
        UserAccounts accounts;
        int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
        if (userId < 1) {
            return;
        }
        Object object = this.mUsers;
        synchronized (object) {
            accounts = this.mUsers.get(userId);
            this.mUsers.remove(userId);
        }
        if (accounts == null) {
            File dbFile = new File(AccountManagerService.getDatabaseName(userId));
            dbFile.delete();
            return;
        }
        object = accounts.cacheLock;
        synchronized (object) {
            accounts.openHelper.close();
            File dbFile = new File(AccountManagerService.getDatabaseName(userId));
            dbFile.delete();
        }
    }

    private void onUserStarted(Intent intent) {
        int userId = intent.getIntExtra("android.intent.extra.user_handle", -1);
        if (userId < 1) {
            return;
        }
        Account[] sharedAccounts = this.getSharedAccountsAsUser(userId);
        if (sharedAccounts == null || sharedAccounts.length == 0) {
            return;
        }
        Account[] accounts = this.getAccountsAsUser(null, userId, this.mContext.getOpPackageName());
        for (Account sa : sharedAccounts) {
            if (ArrayUtils.contains(accounts, sa)) continue;
            this.copyAccountToUser(null, sa, 0, userId);
        }
    }

    @Override
    public void onServiceChanged(AuthenticatorDescription desc, int userId, boolean removed) {
        this.validateAccountsInternal(this.getUserAccounts(userId), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPassword(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getPassword: " + account + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot get secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readPasswordInternal(accounts, account);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readPasswordInternal(UserAccounts accounts, Account account) {
        if (account == null) {
            return null;
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getReadableDatabase();
            try (Cursor cursor = db.query(TABLE_ACCOUNTS, new String[]{ACCOUNTS_PASSWORD}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);){
                if (cursor.moveToNext()) {
                    String string2 = cursor.getString(0);
                    return string2;
                }
                String string3 = null;
                return string3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPreviousName(Account account) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getPreviousName: " + account + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readPreviousNameInternal(accounts, account);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readPreviousNameInternal(UserAccounts accounts, Account account) {
        if (account == null) {
            return null;
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            Cursor cursor;
            block10: {
                String string2;
                AtomicReference<String> previousNameRef = (AtomicReference<String>)accounts.previousNameCache.get(account);
                if (previousNameRef != null) return (String)previousNameRef.get();
                SQLiteDatabase db = accounts.openHelper.getReadableDatabase();
                cursor = db.query(TABLE_ACCOUNTS, new String[]{ACCOUNTS_PREVIOUS_NAME}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);
                try {
                    if (!cursor.moveToNext()) break block10;
                    String previousName = cursor.getString(0);
                    previousNameRef = new AtomicReference<String>(previousName);
                    accounts.previousNameCache.put(account, previousNameRef);
                    string2 = previousName;
                    cursor.close();
                }
                catch (Throwable throwable) {
                    cursor.close();
                    throw throwable;
                }
                return string2;
            }
            String string3 = null;
            cursor.close();
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getUserData(Account account, String key) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            String msg = String.format("getUserData( account: %s, key: %s, callerUid: %s, pid: %s", account, key, callingUid, Binder.getCallingPid());
            Log.v(TAG, msg);
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot get user data for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readUserDataInternal(accounts, account, key);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthenticatorDescription[] getAuthenticatorTypes(int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAuthenticatorTypes: for user id " + userId + "caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s tying to get authenticator types for %s", UserHandle.getCallingUserId(), userId));
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            AuthenticatorDescription[] authenticatorDescriptionArray = this.getAuthenticatorTypesInternal(userId);
            return authenticatorDescriptionArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private AuthenticatorDescription[] getAuthenticatorTypesInternal(int userId) {
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> authenticatorCollection = this.mAuthenticatorCache.getAllServices(userId);
        AuthenticatorDescription[] types = new AuthenticatorDescription[authenticatorCollection.size()];
        int i = 0;
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticator : authenticatorCollection) {
            types[i] = (AuthenticatorDescription)authenticator.type;
            ++i;
        }
        return types;
    }

    private boolean isCrossUser(int callingUid, int userId) {
        return userId != UserHandle.getCallingUserId() && callingUid != Process.myUid() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAccountExplicitly(Account account, String password, Bundle extras) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccountExplicitly: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot explicitly add accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            boolean bl = this.addAccountInternal(accounts, account, password, extras, false, callingUid);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyAccountToUser(final IAccountManagerResponse response, final Account account, int userFrom, int userTo) {
        int callingUid = Binder.getCallingUid();
        if (this.isCrossUser(callingUid, -1)) {
            throw new SecurityException("Calling copyAccountToUser requires android.permission.INTERACT_ACROSS_USERS_FULL");
        }
        UserAccounts fromAccounts = this.getUserAccounts(userFrom);
        final UserAccounts toAccounts = this.getUserAccounts(userTo);
        if (fromAccounts == null || toAccounts == null) {
            if (response != null) {
                Bundle result = new Bundle();
                result.putBoolean("booleanResult", false);
                try {
                    response.onResult(result);
                }
                catch (RemoteException e) {
                    Slog.w(TAG, "Failed to report error back to the client." + e);
                }
            }
            return;
        }
        Slog.d(TAG, "Copying account " + account.name + " from user " + userFrom + " to user " + userTo);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            new Session(fromAccounts, response, account.type, false, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAccountCredentialsForClone" + ", " + account.type;
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.getAccountCredentialsForCloning(this, account);
                }

                @Override
                public void onResult(Bundle result) {
                    if (result != null && result.getBoolean("booleanResult", false)) {
                        AccountManagerService.this.completeCloningAccount(response, result, account, toAccounts);
                    } else {
                        super.onResult(result);
                    }
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accountAuthenticated(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            String msg = String.format("accountAuthenticated( account: %s, callerUid: %s)", account, callingUid);
            Log.v(TAG, msg);
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot notify authentication for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.canUserModifyAccounts(userId) || !this.canUserModifyAccountsForType(userId, account.type)) {
            return false;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            boolean bl = this.updateLastAuthenticatedTime(account);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateLastAuthenticatedTime(Account account) {
        UserAccounts accounts = this.getUserAccountsForCaller();
        Object object = accounts.cacheLock;
        synchronized (object) {
            ContentValues values = new ContentValues();
            values.put(ACCOUNTS_LAST_AUTHENTICATE_TIME_EPOCH_MILLIS, System.currentTimeMillis());
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            int i = db.update(TABLE_ACCOUNTS, values, "name=? AND type=?", new String[]{account.name, account.type});
            if (i > 0) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeCloningAccount(IAccountManagerResponse response, final Bundle accountCredentials, final Account account, UserAccounts targetUser) {
        long id2 = AccountManagerService.clearCallingIdentity();
        try {
            new Session(targetUser, response, account.type, false, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAccountCredentialsForClone" + ", " + account.type;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() throws RemoteException {
                    UserAccounts owner = AccountManagerService.this.getUserAccounts(0);
                    Object object = owner.cacheLock;
                    synchronized (object) {
                        for (Account acc : AccountManagerService.this.getAccounts(0, AccountManagerService.this.mContext.getOpPackageName())) {
                            if (!acc.equals(account)) continue;
                            this.mAuthenticator.addAccountFromCredentials(this, account, accountCredentials);
                            break;
                        }
                    }
                }

                @Override
                public void onResult(Bundle result) {
                    super.onResult(result);
                }

                @Override
                public void onError(int errorCode, String errorMessage) {
                    super.onError(errorCode, errorMessage);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(id2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean addAccountInternal(UserAccounts accounts, Account account, String password, Bundle extras, boolean restricted, int callingUid) {
        if (account == null) {
            return false;
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                long numMatches = DatabaseUtils.longForQuery(db, "select count(*) from accounts WHERE name=? AND type=?", new String[]{account.name, account.type});
                if (numMatches > 0L) {
                    Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping since the account already exists");
                    boolean bl = false;
                    return bl;
                }
                ContentValues values = new ContentValues();
                values.put(ACCOUNTS_NAME, account.name);
                values.put("type", account.type);
                values.put(ACCOUNTS_PASSWORD, password);
                values.put(ACCOUNTS_LAST_AUTHENTICATE_TIME_EPOCH_MILLIS, System.currentTimeMillis());
                long accountId = db.insert(TABLE_ACCOUNTS, ACCOUNTS_NAME, values);
                if (accountId < 0L) {
                    Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping the DB insert failed");
                    boolean bl = false;
                    return bl;
                }
                if (extras != null) {
                    for (String key : extras.keySet()) {
                        String value;
                        if (this.insertExtraLocked(db, accountId, key, value = extras.getString(key)) >= 0L) continue;
                        Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping since insertExtra failed for key " + key);
                        boolean bl = false;
                        return bl;
                    }
                }
                db.setTransactionSuccessful();
                this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_ADD, TABLE_ACCOUNTS, accountId, accounts, callingUid);
                this.insertAccountIntoCacheLocked(accounts, account);
            }
            finally {
                db.endTransaction();
            }
            this.sendAccountsChangedBroadcast(accounts.userId);
        }
        if (accounts.userId != 0) return true;
        this.addAccountToLimitedUsers(account);
        return true;
    }

    private void addAccountToLimitedUsers(Account account) {
        List<UserInfo> users = this.getUserManager().getUsers();
        for (UserInfo user : users) {
            if (!user.isRestricted()) continue;
            this.addSharedAccountAsUser(account, user.id);
            try {
                if (!ActivityManagerNative.getDefault().isUserRunning(user.id, false)) continue;
                this.mMessageHandler.sendMessage(this.mMessageHandler.obtainMessage(4, 0, user.id, account));
            }
            catch (RemoteException re) {}
        }
    }

    private long insertExtraLocked(SQLiteDatabase db, long accountId, String key, String value) {
        ContentValues values = new ContentValues();
        values.put("key", key);
        values.put("accounts_id", accountId);
        values.put("value", value);
        return db.insert(TABLE_EXTRAS, "key", values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hasFeatures(IAccountManagerResponse response, Account account, String[] features, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "hasFeatures: " + account + ", response " + response + ", features " + AccountManagerService.stringArrayToString(features) + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (features == null) {
            throw new IllegalArgumentException("features is null");
        }
        int userId = UserHandle.getCallingUserId();
        this.checkReadAccountsPermitted(callingUid, account.type, userId, opPackageName);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new TestFeaturesSession(accounts, response, account, features).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameAccount(IAccountManagerResponse response, Account accountToRename, String newName) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "renameAccount: " + accountToRename + " -> " + newName + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (accountToRename == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(accountToRename.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot rename accounts of type: %s", callingUid, accountToRename.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account resultingAccount = this.renameAccountInternal(accounts, accountToRename, newName);
            Bundle result = new Bundle();
            result.putString("authAccount", resultingAccount.name);
            result.putString("accountType", resultingAccount.type);
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                Log.w(TAG, e.getMessage());
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account renameAccountInternal(UserAccounts accounts, Account accountToRename, String newName) {
        Account resultAccount = null;
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, accountToRename), new UserHandle(accounts.userId));
        Object object = accounts.credentialsPermissionNotificationIds;
        synchronized (object) {
            for (Pair pair : accounts.credentialsPermissionNotificationIds.keySet()) {
                if (!accountToRename.equals(((Pair)pair.first).first)) continue;
                int id2 = (Integer)accounts.credentialsPermissionNotificationIds.get(pair);
                this.cancelNotification(id2, new UserHandle(accounts.userId));
            }
        }
        object = accounts.cacheLock;
        synchronized (object) {
            block15: {
                SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
                db.beginTransaction();
                boolean isSuccessful = false;
                Account renamedAccount = new Account(newName, accountToRename.type);
                try {
                    ContentValues values = new ContentValues();
                    values.put(ACCOUNTS_NAME, newName);
                    values.put(ACCOUNTS_PREVIOUS_NAME, accountToRename.name);
                    long accountId = this.getAccountIdLocked(db, accountToRename);
                    if (accountId >= 0L) {
                        String[] argsAccountId = new String[]{String.valueOf(accountId)};
                        db.update(TABLE_ACCOUNTS, values, "_id=?", argsAccountId);
                        db.setTransactionSuccessful();
                        isSuccessful = true;
                        this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_RENAME, TABLE_ACCOUNTS, accountId, accounts);
                    }
                    db.endTransaction();
                    if (!isSuccessful) break block15;
                    this.insertAccountIntoCacheLocked(accounts, renamedAccount);
                }
                catch (Throwable throwable) {
                    db.endTransaction();
                    if (isSuccessful) {
                        this.insertAccountIntoCacheLocked(accounts, renamedAccount);
                        HashMap tmpData = (HashMap)accounts.userDataCache.get(accountToRename);
                        HashMap tmpTokens = (HashMap)accounts.authTokenCache.get(accountToRename);
                        this.removeAccountFromCacheLocked(accounts, accountToRename);
                        accounts.userDataCache.put(renamedAccount, tmpData);
                        accounts.authTokenCache.put(renamedAccount, tmpTokens);
                        accounts.previousNameCache.put(renamedAccount, new AtomicReference<String>(accountToRename.name));
                        resultAccount = renamedAccount;
                        if (accounts.userId == 0) {
                            List<UserInfo> users = this.mUserManager.getUsers(true);
                            for (UserInfo user : users) {
                                if (user.isPrimary() || !user.isRestricted()) continue;
                                this.renameSharedAccountAsUser(accountToRename, newName, user.id);
                            }
                        }
                        this.sendAccountsChangedBroadcast(accounts.userId);
                    }
                    throw throwable;
                }
                HashMap tmpData = (HashMap)accounts.userDataCache.get(accountToRename);
                HashMap tmpTokens = (HashMap)accounts.authTokenCache.get(accountToRename);
                this.removeAccountFromCacheLocked(accounts, accountToRename);
                accounts.userDataCache.put(renamedAccount, tmpData);
                accounts.authTokenCache.put(renamedAccount, tmpTokens);
                accounts.previousNameCache.put(renamedAccount, new AtomicReference<String>(accountToRename.name));
                resultAccount = renamedAccount;
                if (accounts.userId == 0) {
                    List<UserInfo> users = this.mUserManager.getUsers(true);
                    for (UserInfo user : users) {
                        if (user.isPrimary() || !user.isRestricted()) continue;
                        this.renameSharedAccountAsUser(accountToRename, newName, user.id);
                    }
                }
                this.sendAccountsChangedBroadcast(accounts.userId);
            }
        }
        return resultAccount;
    }

    @Override
    public void removeAccount(IAccountManagerResponse response, Account account, boolean expectActivityLaunch) {
        this.removeAccountAsUser(response, account, expectActivityLaunch, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAccountAsUser(IAccountManagerResponse response, Account account, boolean expectActivityLaunch, int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "removeAccount: " + account + ", response " + response + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid() + ", for user id " + userId);
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s tying remove account for %s", UserHandle.getCallingUserId(), userId));
        }
        UserHandle user = new UserHandle(userId);
        if (!this.isAccountManagedByCaller(account.type, callingUid, user.getIdentifier()) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot remove accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        if (!this.canUserModifyAccounts(userId)) {
            try {
                response.onError(100, "User cannot modify accounts");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, account.type)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            return;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        UserAccounts accounts = this.getUserAccounts(userId);
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), user);
        HashMap hashMap = accounts.credentialsPermissionNotificationIds;
        synchronized (hashMap) {
            for (Pair pair : accounts.credentialsPermissionNotificationIds.keySet()) {
                if (!account.equals(((Pair)pair.first).first)) continue;
                int id2 = (Integer)accounts.credentialsPermissionNotificationIds.get(pair);
                this.cancelNotification(id2, user);
            }
        }
        this.logRecord(accounts, DebugDbHelper.ACTION_CALLED_ACCOUNT_REMOVE, TABLE_ACCOUNTS);
        try {
            new RemoveAccountSession(accounts, response, account, expectActivityLaunch).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAccountExplicitly(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "removeAccountExplicitly: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        int userId = Binder.getCallingUserHandle().getIdentifier();
        if (account == null) {
            Log.e(TAG, "account is null");
            return false;
        }
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot explicitly add accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        UserAccounts accounts = this.getUserAccountsForCaller();
        if (!this.canUserModifyAccounts(userId) || !this.canUserModifyAccountsForType(userId, account.type)) {
            return false;
        }
        this.logRecord(accounts, DebugDbHelper.ACTION_CALLED_ACCOUNT_REMOVE, TABLE_ACCOUNTS);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            boolean bl = this.removeAccountInternal(accounts, account);
            return bl;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    protected void removeAccountInternal(Account account) {
        this.removeAccountInternal(this.getUserAccountsForCaller(), account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeAccountInternal(UserAccounts accounts, Account account) {
        int deleted;
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            long accountId = this.getAccountIdLocked(db, account);
            deleted = db.delete(TABLE_ACCOUNTS, "name=? AND type=?", new String[]{account.name, account.type});
            this.removeAccountFromCacheLocked(accounts, account);
            this.sendAccountsChangedBroadcast(accounts.userId);
            this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_REMOVE, TABLE_ACCOUNTS, accountId, accounts);
        }
        if (accounts.userId == 0) {
            int callingUid = AccountManagerService.getCallingUid();
            long id2 = Binder.clearCallingIdentity();
            try {
                List<UserInfo> users = this.mUserManager.getUsers(true);
                for (UserInfo user : users) {
                    if (user.isPrimary() || !user.isRestricted()) continue;
                    this.removeSharedAccountAsUser(account, user.id, callingUid);
                }
            }
            finally {
                Binder.restoreCallingIdentity(id2);
            }
        }
        return deleted > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateAuthToken(String accountType, String authToken) {
        int callerUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "invalidateAuthToken: accountType " + accountType + ", caller's uid " + callerUid + ", pid " + Binder.getCallingPid());
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (authToken == null) {
            throw new IllegalArgumentException("authToken is null");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Object object = accounts.cacheLock;
            synchronized (object) {
                SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
                db.beginTransaction();
                try {
                    this.invalidateAuthTokenLocked(accounts, db, accountType, authToken);
                    this.invalidateCustomTokenLocked(accounts, accountType, authToken);
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private void invalidateCustomTokenLocked(UserAccounts accounts, String accountType, String authToken) {
        if (authToken == null || accountType == null) {
            return;
        }
        accounts.accountTokenCaches.remove(accountType, authToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAuthTokenLocked(UserAccounts accounts, SQLiteDatabase db, String accountType, String authToken) {
        if (authToken == null || accountType == null) {
            return;
        }
        try (Cursor cursor = db.rawQuery("SELECT authtokens._id, accounts.name, authtokens.type FROM accounts JOIN authtokens ON accounts._id = accounts_id WHERE authtoken = ? AND accounts.type = ?", new String[]{authToken, accountType});){
            while (cursor.moveToNext()) {
                long authTokenId = cursor.getLong(0);
                String accountName = cursor.getString(1);
                String authTokenType = cursor.getString(2);
                db.delete(TABLE_AUTHTOKENS, "_id=" + authTokenId, null);
                this.writeAuthTokenIntoCacheLocked(accounts, db, new Account(accountName, accountType), authTokenType, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveCachedToken(UserAccounts accounts, Account account, String callerPkg, byte[] callerSigDigest, String tokenType, String token, long expiryMillis) {
        if (account == null || tokenType == null || callerPkg == null || callerSigDigest == null) {
            return;
        }
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), new UserHandle(accounts.userId));
        Object object = accounts.cacheLock;
        synchronized (object) {
            accounts.accountTokenCaches.put(account, token, tokenType, callerPkg, callerSigDigest, expiryMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveAuthTokenToDatabase(UserAccounts accounts, Account account, String type, String authToken) {
        if (account == null || type == null) {
            return false;
        }
        this.cancelNotification(this.getSigninRequiredNotificationId(accounts, account), new UserHandle(accounts.userId));
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                long accountId = this.getAccountIdLocked(db, account);
                if (accountId < 0L) {
                    boolean bl = false;
                    return bl;
                }
                db.delete(TABLE_AUTHTOKENS, "accounts_id=" + accountId + " AND " + "type" + "=?", new String[]{type});
                ContentValues values = new ContentValues();
                values.put("accounts_id", accountId);
                values.put("type", type);
                values.put(AUTHTOKENS_AUTHTOKEN, authToken);
                if (db.insert(TABLE_AUTHTOKENS, AUTHTOKENS_AUTHTOKEN, values) >= 0L) {
                    db.setTransactionSuccessful();
                    this.writeAuthTokenIntoCacheLocked(accounts, db, account, type, authToken);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                db.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String peekAuthToken(Account account, String authTokenType) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "peekAuthToken: " + account + ", authTokenType " + authTokenType + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot peek the authtokens associated with accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            String string2 = this.readAuthTokenInternal(accounts, account, authTokenType);
            return string2;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAuthToken(Account account, String authTokenType, String authToken) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setAuthToken: " + account + ", authTokenType " + authTokenType + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set auth tokens associated with accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.saveAuthTokenToDatabase(accounts, account, authTokenType, authToken);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPassword(Account account, String password) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setAuthToken: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set secrets for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.setPasswordInternal(accounts, account, password, callingUid);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPasswordInternal(UserAccounts accounts, Account account, String password, int callingUid) {
        if (account == null) {
            return;
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                ContentValues values = new ContentValues();
                values.put(ACCOUNTS_PASSWORD, password);
                long accountId = this.getAccountIdLocked(db, account);
                if (accountId >= 0L) {
                    String[] argsAccountId = new String[]{String.valueOf(accountId)};
                    db.update(TABLE_ACCOUNTS, values, "_id=?", argsAccountId);
                    db.delete(TABLE_AUTHTOKENS, "accounts_id=?", argsAccountId);
                    accounts.authTokenCache.remove(account);
                    accounts.accountTokenCaches.remove(account);
                    db.setTransactionSuccessful();
                    String action = password == null || password.length() == 0 ? DebugDbHelper.ACTION_CLEAR_PASSWORD : DebugDbHelper.ACTION_SET_PASSWORD;
                    this.logRecord(db, action, TABLE_ACCOUNTS, accountId, accounts, callingUid);
                }
            }
            finally {
                db.endTransaction();
            }
            this.sendAccountsChangedBroadcast(accounts.userId);
        }
    }

    private void sendAccountsChangedBroadcast(int userId) {
        Log.i(TAG, "the accounts changed, sending broadcast of " + ACCOUNTS_CHANGED_INTENT.getAction());
        this.mContext.sendBroadcastAsUser(ACCOUNTS_CHANGED_INTENT, new UserHandle(userId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPassword(Account account) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "clearPassword: " + account + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot clear passwords for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.setPasswordInternal(accounts, account, null, callingUid);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Account account, String key, String value) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "setUserData: " + account + ", key " + key + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (key == null) {
            throw new IllegalArgumentException("key is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(account.type, callingUid, userId)) {
            String msg = String.format("uid %s cannot set user data for accounts of type: %s", callingUid, account.type);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.setUserdataInternal(accounts, account, key, value);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setUserdataInternal(UserAccounts accounts, Account account, String key, String value) {
        if (account == null) return;
        if (key == null) {
            return;
        }
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                long accountId = this.getAccountIdLocked(db, account);
                if (accountId < 0L) {
                    return;
                }
                long extrasId = this.getExtrasIdLocked(db, accountId, key);
                if (extrasId < 0L) {
                    extrasId = this.insertExtraLocked(db, accountId, key, value);
                    if (extrasId < 0L) {
                        return;
                    }
                } else {
                    ContentValues values = new ContentValues();
                    values.put("value", value);
                    if (1 != db.update(TABLE_EXTRAS, values, "_id=" + extrasId, null)) {
                        return;
                    }
                }
                this.writeUserDataIntoCacheLocked(accounts, db, account, key, value);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            return;
        }
    }

    private void onResult(IAccountManagerResponse response, Bundle result) {
        block4: {
            if (result == null) {
                Log.e(TAG, "the result is unexpectedly null", new Exception());
            }
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
            }
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                if (!Log.isLoggable(TAG, 2)) break block4;
                Log.v(TAG, "failure while notifying response", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAuthTokenLabel(IAccountManagerResponse response, final String accountType, final String authTokenType) throws RemoteException {
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        int callingUid = AccountManagerService.getCallingUid();
        AccountManagerService.clearCallingIdentity();
        if (callingUid != 1000) {
            throw new SecurityException("can only call from system");
        }
        int userId = UserHandle.getUserId(callingUid);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, accountType, false, false, null, false){

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", getAuthTokenLabel" + ", " + accountType + ", authTokenType " + authTokenType;
                }

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                }

                @Override
                public void onResult(Bundle result) {
                    if (result != null) {
                        String label = result.getString("authTokenLabelKey");
                        Bundle bundle = new Bundle();
                        bundle.putString("authTokenLabelKey", label);
                        super.onResult(bundle);
                        return;
                    }
                    super.onResult(result);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAuthToken(IAccountManagerResponse response, final Account account, final String authTokenType, final boolean notifyOnAuthFailure, boolean expectActivityLaunch, final Bundle loginOptions) {
        List<String> callerOwnedPackageNames;
        RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo;
        UserAccounts accounts;
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAuthToken: " + account + ", response " + response + ", authTokenType " + authTokenType + ", notifyOnAuthFailure " + notifyOnAuthFailure + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        try {
            if (account == null) {
                Slog.w(TAG, "getAuthToken called with null account");
                response.onError(7, "account is null");
                return;
            }
            if (authTokenType == null) {
                Slog.w(TAG, "getAuthToken called with null authTokenType");
                response.onError(7, "authTokenType is null");
                return;
            }
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Failed to report error back to the client." + e);
            return;
        }
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            accounts = this.getUserAccounts(userId);
            authenticatorInfo = this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(account.type), accounts.userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        final boolean customTokens = authenticatorInfo != null && ((AuthenticatorDescription)authenticatorInfo.type).customTokens;
        final int callerUid = Binder.getCallingUid();
        final boolean permissionGranted = customTokens || this.permissionIsGranted(account, authTokenType, callerUid, userId);
        final String callerPkg = loginOptions.getString("androidPackageName");
        ident = Binder.clearCallingIdentity();
        try {
            callerOwnedPackageNames = Arrays.asList(this.mPackageManager.getPackagesForUid(callerUid));
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (callerPkg == null || !callerOwnedPackageNames.contains(callerPkg)) {
            String msg = String.format("Uid %s is attempting to illegally masquerade as package %s!", callerUid, callerPkg);
            throw new SecurityException(msg);
        }
        loginOptions.putInt("callerUid", callerUid);
        loginOptions.putInt("callerPid", Binder.getCallingPid());
        if (notifyOnAuthFailure) {
            loginOptions.putBoolean("notifyOnAuthFailure", true);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            String token;
            String authToken;
            final byte[] callerPkgSigDigest = this.calculatePackageSignatureDigest(callerPkg);
            if (!customTokens && permissionGranted && (authToken = this.readAuthTokenInternal(accounts, account, authTokenType)) != null) {
                Bundle result = new Bundle();
                result.putString(AUTHTOKENS_AUTHTOKEN, authToken);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                this.onResult(response, result);
                return;
            }
            if (customTokens && (token = this.readCachedTokenInternal(accounts, account, authTokenType, callerPkg, callerPkgSigDigest)) != null) {
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "getAuthToken: cache hit ofr custom token authenticator.");
                }
                Bundle result = new Bundle();
                result.putString(AUTHTOKENS_AUTHTOKEN, token);
                result.putString("authAccount", account.name);
                result.putString("accountType", account.type);
                this.onResult(response, result);
                return;
            }
            new Session(accounts, response, account.type, expectActivityLaunch, false, account.name, false){

                @Override
                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", getAuthToken" + ", " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions + ", notifyOnAuthFailure " + notifyOnAuthFailure;
                }

                @Override
                public void run() throws RemoteException {
                    if (!permissionGranted) {
                        this.mAuthenticator.getAuthTokenLabel(this, authTokenType);
                    } else {
                        this.mAuthenticator.getAuthToken(this, account, authTokenType, loginOptions);
                    }
                }

                @Override
                public void onResult(Bundle result) {
                    if (result != null) {
                        Intent intent;
                        if (result.containsKey("authTokenLabelKey")) {
                            Intent intent2 = AccountManagerService.this.newGrantCredentialsPermissionIntent(account, callerUid, new AccountAuthenticatorResponse(this), authTokenType);
                            Bundle bundle = new Bundle();
                            bundle.putParcelable("intent", intent2);
                            this.onResult(bundle);
                            return;
                        }
                        String authToken = result.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                        if (authToken != null) {
                            String name = result.getString("authAccount");
                            String type = result.getString("accountType");
                            if (TextUtils.isEmpty(type) || TextUtils.isEmpty(name)) {
                                this.onError(5, "the type and name should not be empty");
                                return;
                            }
                            Account resultAccount = new Account(name, type);
                            if (!customTokens) {
                                AccountManagerService.this.saveAuthTokenToDatabase(this.mAccounts, resultAccount, authTokenType, authToken);
                            }
                            long expiryMillis = result.getLong("android.accounts.expiry", 0L);
                            if (customTokens && expiryMillis > System.currentTimeMillis()) {
                                AccountManagerService.this.saveCachedToken(this.mAccounts, account, callerPkg, callerPkgSigDigest, authTokenType, authToken, expiryMillis);
                            }
                        }
                        if ((intent = (Intent)result.getParcelable("intent")) != null && notifyOnAuthFailure && !customTokens) {
                            AccountManagerService.this.doNotification(this.mAccounts, account, result.getString("authFailedMessage"), intent, accounts.userId);
                        }
                    }
                    super.onResult(result);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private byte[] calculatePackageSignatureDigest(String callerPkg) {
        MessageDigest digester;
        try {
            digester = MessageDigest.getInstance("SHA-256");
            PackageInfo pkgInfo = this.mPackageManager.getPackageInfo(callerPkg, 64);
            for (Signature sig : pkgInfo.signatures) {
                digester.update(sig.toByteArray());
            }
        }
        catch (NoSuchAlgorithmException x) {
            Log.wtf(TAG, "SHA-256 should be available", x);
            digester = null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w(TAG, "Could not find packageinfo for: " + callerPkg);
            digester = null;
        }
        return digester == null ? null : digester.digest();
    }

    private void createNoCredentialsPermissionNotification(Account account, Intent intent, int userId) {
        int uid = intent.getIntExtra(GRANTS_GRANTEE_UID, -1);
        String authTokenType = intent.getStringExtra("authTokenType");
        String titleAndSubtitle = this.mContext.getString(17040422, account.name);
        int index = titleAndSubtitle.indexOf(10);
        String title = titleAndSubtitle;
        String subtitle = "";
        if (index > 0) {
            title = titleAndSubtitle.substring(0, index);
            subtitle = titleAndSubtitle.substring(index + 1);
        }
        UserHandle user = new UserHandle(userId);
        Context contextForUser = this.getContextForUser(user);
        Notification n = new Notification.Builder(contextForUser).setSmallIcon(17301642).setWhen(0L).setColor(contextForUser.getColor(17170521)).setContentTitle(title).setContentText(subtitle).setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, user)).build();
        this.installNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), n, user);
    }

    private Intent newGrantCredentialsPermissionIntent(Account account, int uid, AccountAuthenticatorResponse response, String authTokenType) {
        Intent intent = new Intent(this.mContext, GrantCredentialsPermissionActivity.class);
        intent.setFlags(0x10000000);
        intent.addCategory(String.valueOf(this.getCredentialPermissionNotificationId(account, authTokenType, uid)));
        intent.putExtra("account", account);
        intent.putExtra("authTokenType", authTokenType);
        intent.putExtra("response", response);
        intent.putExtra(GRANTS_GRANTEE_UID, uid);
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getCredentialPermissionNotificationId(Account account, String authTokenType, int uid) {
        Integer id2;
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        HashMap hashMap = accounts.credentialsPermissionNotificationIds;
        synchronized (hashMap) {
            Pair<Pair<Account, String>, Integer> key = new Pair<Pair<Account, String>, Integer>(new Pair<Account, String>(account, authTokenType), uid);
            id2 = (Integer)accounts.credentialsPermissionNotificationIds.get(key);
            if (id2 == null) {
                id2 = this.mNotificationIds.incrementAndGet();
                accounts.credentialsPermissionNotificationIds.put(key, id2);
            }
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getSigninRequiredNotificationId(UserAccounts accounts, Account account) {
        Integer id2;
        HashMap hashMap = accounts.signinRequiredNotificationIds;
        synchronized (hashMap) {
            id2 = (Integer)accounts.signinRequiredNotificationIds.get(account);
            if (id2 == null) {
                id2 = this.mNotificationIds.incrementAndGet();
                accounts.signinRequiredNotificationIds.put(account, id2);
            }
        }
        return id2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccount(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, Bundle optionsIn) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccount: accountType " + accountType + ", response " + response + ", authTokenType " + authTokenType + ", requiredFeatures " + AccountManagerService.stringArrayToString(requiredFeatures) + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = Binder.getCallingUserHandle().getIdentifier();
        if (!this.canUserModifyAccounts(userId)) {
            try {
                response.onError(100, "User is not allowed to add an account!");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            this.showCantAddAccount(100, userId);
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            this.showCantAddAccount(101, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        final Bundle options = optionsIn == null ? new Bundle() : optionsIn;
        options.putInt("callerUid", uid);
        options.putInt("callerPid", pid);
        int usrId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(usrId);
            this.logRecordWithUid(accounts, DebugDbHelper.ACTION_CALLED_ACCOUNT_ADD, TABLE_ACCOUNTS, uid);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", addAccount" + ", accountType " + accountType + ", requiredFeatures " + (requiredFeatures != null ? TextUtils.join((CharSequence)",", requiredFeatures) : null);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAccountAsUser(IAccountManagerResponse response, final String accountType, final String authTokenType, final String[] requiredFeatures, boolean expectActivityLaunch, Bundle optionsIn, int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "addAccount: accountType " + accountType + ", response " + response + ", authTokenType " + authTokenType + ", requiredFeatures " + AccountManagerService.stringArrayToString(requiredFeatures) + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid() + ", for user id " + userId);
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s trying to add account for %s", UserHandle.getCallingUserId(), userId));
        }
        if (!this.canUserModifyAccounts(userId)) {
            try {
                response.onError(100, "User is not allowed to add an account!");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            this.showCantAddAccount(100, userId);
            return;
        }
        if (!this.canUserModifyAccountsForType(userId, accountType)) {
            try {
                response.onError(101, "User cannot modify accounts of this type (policy).");
            }
            catch (RemoteException re) {
                // empty catch block
            }
            this.showCantAddAccount(101, userId);
            return;
        }
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        final Bundle options = optionsIn == null ? new Bundle() : optionsIn;
        options.putInt("callerUid", uid);
        options.putInt("callerPid", pid);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            this.logRecordWithUid(accounts, DebugDbHelper.ACTION_CALLED_ACCOUNT_ADD, TABLE_ACCOUNTS, userId);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.addAccount(this, this.mAccountType, authTokenType, requiredFeatures, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", addAccount" + ", accountType " + accountType + ", requiredFeatures " + (requiredFeatures != null ? TextUtils.join((CharSequence)",", requiredFeatures) : null);
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showCantAddAccount(int errorCode, int userId) {
        Intent cantAddAccount = new Intent(this.mContext, CantAddAccountActivity.class);
        cantAddAccount.putExtra("android.accounts.extra.ERROR_CODE", errorCode);
        cantAddAccount.addFlags(0x10000000);
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            this.mContext.startActivityAsUser(cantAddAccount, new UserHandle(userId));
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void confirmCredentialsAsUser(IAccountManagerResponse response, final Account account, final Bundle options, boolean expectActivityLaunch, int userId) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "confirmCredentials: " + account + ", response " + response + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (this.isCrossUser(callingUid, userId)) {
            throw new SecurityException(String.format("User %s trying to confirm account credentials for %s", UserHandle.getCallingUserId(), userId));
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, account.type, expectActivityLaunch, true, account.name, true, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.confirmCredentials(this, account, options);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", confirmCredentials" + ", " + account;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredentials(IAccountManagerResponse response, final Account account, final String authTokenType, boolean expectActivityLaunch, final Bundle loginOptions) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "updateCredentials: " + account + ", response " + response + ", authTokenType " + authTokenType + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (account == null) {
            throw new IllegalArgumentException("account is null");
        }
        if (authTokenType == null) {
            throw new IllegalArgumentException("authTokenType is null");
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, account.type, expectActivityLaunch, true, account.name, false, true){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.updateCredentials(this, account, authTokenType, loginOptions);
                }

                @Override
                protected String toDebugString(long now) {
                    if (loginOptions != null) {
                        loginOptions.keySet();
                    }
                    return super.toDebugString(now) + ", updateCredentials" + ", " + account + ", authTokenType " + authTokenType + ", loginOptions " + loginOptions;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void editProperties(IAccountManagerResponse response, final String accountType, boolean expectActivityLaunch) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "editProperties: accountType " + accountType + ", response " + response + ", expectActivityLaunch " + expectActivityLaunch + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (accountType == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = UserHandle.getCallingUserId();
        if (!this.isAccountManagedByCaller(accountType, callingUid, userId) && !this.isSystemUid(callingUid)) {
            String msg = String.format("uid %s cannot edit authenticator properites for account type: %s", callingUid, accountType);
            throw new SecurityException(msg);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            new Session(accounts, response, accountType, expectActivityLaunch, true, null, false){

                @Override
                public void run() throws RemoteException {
                    this.mAuthenticator.editProperties(this, this.mAccountType);
                }

                @Override
                protected String toDebugString(long now) {
                    return super.toDebugString(now) + ", editProperties" + ", accountType " + accountType;
                }
            }.bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account[] getAccounts(int userId, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        List<String> visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName);
        if (visibleAccountTypes.isEmpty()) {
            return new Account[0];
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account[] accountArray = this.getAccountsInternal(accounts, callingUid, null, visibleAccountTypes);
            return accountArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    public AccountAndUser[] getRunningAccounts() {
        int[] runningUserIds;
        try {
            runningUserIds = ActivityManagerNative.getDefault().getRunningUserIds();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        return this.getAccounts(runningUserIds);
    }

    public AccountAndUser[] getAllAccounts() {
        List<UserInfo> users = this.getUserManager().getUsers();
        int[] userIds = new int[users.size()];
        for (int i = 0; i < userIds.length; ++i) {
            userIds[i] = users.get((int)i).id;
        }
        return this.getAccounts(userIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AccountAndUser[] getAccounts(int[] userIds) {
        ArrayList<AccountAndUser> runningAccounts = Lists.newArrayList();
        for (int userId : userIds) {
            UserAccounts userAccounts = this.getUserAccounts(userId);
            if (userAccounts == null) continue;
            Object object = userAccounts.cacheLock;
            synchronized (object) {
                Account[] accounts = this.getAccountsFromCacheLocked(userAccounts, null, Binder.getCallingUid(), null);
                for (int a = 0; a < accounts.length; ++a) {
                    runningAccounts.add(new AccountAndUser(accounts[a], userId));
                }
            }
        }
        AccountAndUser[] accountsArray = new AccountAndUser[runningAccounts.size()];
        return runningAccounts.toArray(accountsArray);
    }

    @Override
    public Account[] getAccountsAsUser(String type, int userId, String opPackageName) {
        return this.getAccountsAsUser(type, userId, null, -1, opPackageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account[] getAccountsAsUser(String type, int userId, String callingPackage, int packageUid, String opPackageName) {
        List<String> visibleAccountTypes;
        int callingUid = Binder.getCallingUid();
        if (userId != UserHandle.getCallingUserId() && callingUid != Process.myUid() && this.mContext.checkCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            throw new SecurityException("User " + UserHandle.getCallingUserId() + " trying to get account for " + userId);
        }
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAccounts: accountType " + type + ", caller's uid " + Binder.getCallingUid() + ", pid " + Binder.getCallingPid());
        }
        if (packageUid != -1 && UserHandle.isSameApp(callingUid, Process.myUid())) {
            callingUid = packageUid;
            opPackageName = callingPackage;
        }
        if ((visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName)).isEmpty() || type != null && !visibleAccountTypes.contains(type)) {
            return new Account[0];
        }
        if (visibleAccountTypes.contains(type)) {
            visibleAccountTypes = new ArrayList<String>();
            visibleAccountTypes.add(type);
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts accounts = this.getUserAccounts(userId);
            Account[] accountArray = this.getAccountsInternal(accounts, callingUid, callingPackage, visibleAccountTypes);
            return accountArray;
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Account[] getAccountsInternal(UserAccounts userAccounts, int callingUid, String callingPackage, List<String> visibleAccountTypes) {
        Object object = userAccounts.cacheLock;
        synchronized (object) {
            ArrayList<Account> visibleAccounts = new ArrayList<Account>();
            for (String visibleType : visibleAccountTypes) {
                Account[] accountsForType = this.getAccountsFromCacheLocked(userAccounts, visibleType, callingUid, callingPackage);
                if (accountsForType == null) continue;
                visibleAccounts.addAll(Arrays.asList(accountsForType));
            }
            Account[] result = new Account[visibleAccounts.size()];
            for (int i = 0; i < visibleAccounts.size(); ++i) {
                result[i] = (Account)visibleAccounts.get(i);
            }
            return result;
        }
    }

    @Override
    public boolean addSharedAccountAsUser(Account account, int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put(ACCOUNTS_NAME, account.name);
        values.put("type", account.type);
        db.delete(TABLE_SHARED_ACCOUNTS, "name=? AND type=?", new String[]{account.name, account.type});
        long accountId = db.insert(TABLE_SHARED_ACCOUNTS, ACCOUNTS_NAME, values);
        if (accountId < 0L) {
            Log.w(TAG, "insertAccountIntoDatabase: " + account + ", skipping the DB insert failed");
            return false;
        }
        this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_ADD, TABLE_SHARED_ACCOUNTS, accountId, accounts);
        return true;
    }

    @Override
    public boolean renameSharedAccountAsUser(Account account, String newName, int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
        long sharedTableAccountId = this.getAccountIdFromSharedTable(db, account);
        ContentValues values = new ContentValues();
        values.put(ACCOUNTS_NAME, newName);
        values.put(ACCOUNTS_PREVIOUS_NAME, account.name);
        int r = db.update(TABLE_SHARED_ACCOUNTS, values, "name=? AND type=?", new String[]{account.name, account.type});
        if (r > 0) {
            int callingUid = AccountManagerService.getCallingUid();
            this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_RENAME, TABLE_SHARED_ACCOUNTS, sharedTableAccountId, accounts, callingUid);
            this.renameAccountInternal(accounts, account, newName);
        }
        return r > 0;
    }

    @Override
    public boolean removeSharedAccountAsUser(Account account, int userId) {
        return this.removeSharedAccountAsUser(account, userId, AccountManagerService.getCallingUid());
    }

    private boolean removeSharedAccountAsUser(Account account, int userId, int callingUid) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
        long sharedTableAccountId = this.getAccountIdFromSharedTable(db, account);
        int r = db.delete(TABLE_SHARED_ACCOUNTS, "name=? AND type=?", new String[]{account.name, account.type});
        if (r > 0) {
            this.logRecord(db, DebugDbHelper.ACTION_ACCOUNT_REMOVE, TABLE_SHARED_ACCOUNTS, sharedTableAccountId, accounts, callingUid);
            this.removeAccountInternal(accounts, account);
        }
        return r > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Account[] getSharedAccountsAsUser(int userId) {
        userId = this.handleIncomingUser(userId);
        UserAccounts accounts = this.getUserAccounts(userId);
        ArrayList<Account> accountList = new ArrayList<Account>();
        try (Cursor cursor = null;){
            cursor = accounts.openHelper.getReadableDatabase().query(TABLE_SHARED_ACCOUNTS, new String[]{ACCOUNTS_NAME, "type"}, null, null, null, null, null);
            if (cursor != null && cursor.moveToFirst()) {
                int nameIndex = cursor.getColumnIndex(ACCOUNTS_NAME);
                int typeIndex = cursor.getColumnIndex("type");
                do {
                    accountList.add(new Account(cursor.getString(nameIndex), cursor.getString(typeIndex)));
                } while (cursor.moveToNext());
            }
        }
        Account[] accountArray = new Account[accountList.size()];
        accountList.toArray(accountArray);
        return accountArray;
    }

    @Override
    public Account[] getAccounts(String type, String opPackageName) {
        return this.getAccountsAsUser(type, UserHandle.getCallingUserId(), opPackageName);
    }

    @Override
    public Account[] getAccountsForPackage(String packageName, int uid, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        if (!UserHandle.isSameApp(callingUid, Process.myUid())) {
            throw new SecurityException("getAccountsForPackage() called from unauthorized uid " + callingUid + " with uid=" + uid);
        }
        return this.getAccountsAsUser(null, UserHandle.getCallingUserId(), packageName, uid, opPackageName);
    }

    @Override
    public Account[] getAccountsByTypeForPackage(String type, String packageName, String opPackageName) {
        int packageUid = -1;
        try {
            packageUid = AppGlobals.getPackageManager().getPackageUid(packageName, UserHandle.getCallingUserId());
        }
        catch (RemoteException re) {
            Slog.e(TAG, "Couldn't determine the packageUid for " + packageName + re);
            return new Account[0];
        }
        return this.getAccountsAsUser(type, UserHandle.getCallingUserId(), packageName, packageUid, opPackageName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAccountsByFeatures(IAccountManagerResponse response, String type, String[] features, String opPackageName) {
        int callingUid = Binder.getCallingUid();
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "getAccounts: accountType " + type + ", response " + response + ", features " + AccountManagerService.stringArrayToString(features) + ", caller's uid " + callingUid + ", pid " + Binder.getCallingPid());
        }
        if (response == null) {
            throw new IllegalArgumentException("response is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("accountType is null");
        }
        int userId = UserHandle.getCallingUserId();
        List<String> visibleAccountTypes = this.getTypesVisibleToCaller(callingUid, userId, opPackageName);
        if (!visibleAccountTypes.contains(type)) {
            Bundle result = new Bundle();
            result.putParcelableArray(TABLE_ACCOUNTS, new Account[0]);
            try {
                response.onResult(result);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Cannot respond to caller do to exception.", e);
            }
            return;
        }
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            UserAccounts userAccounts = this.getUserAccounts(userId);
            if (features == null || features.length == 0) {
                Parcelable[] accounts;
                Object object = userAccounts.cacheLock;
                synchronized (object) {
                    accounts = this.getAccountsFromCacheLocked(userAccounts, type, callingUid, null);
                }
                Bundle result = new Bundle();
                result.putParcelableArray(TABLE_ACCOUNTS, accounts);
                this.onResult(response, result);
                return;
            }
            new GetAccountsByTypeAndFeatureSession(userAccounts, response, type, features, callingUid).bind();
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAccountIdFromSharedTable(SQLiteDatabase db, Account account) {
        try (Cursor cursor = db.query(TABLE_SHARED_ACCOUNTS, new String[]{"_id"}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);){
            if (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getAccountIdLocked(SQLiteDatabase db, Account account) {
        try (Cursor cursor = db.query(TABLE_ACCOUNTS, new String[]{"_id"}, "name=? AND type=?", new String[]{account.name, account.type}, null, null, null);){
            if (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getExtrasIdLocked(SQLiteDatabase db, long accountId, String key) {
        try (Cursor cursor = db.query(TABLE_EXTRAS, new String[]{"_id"}, "accounts_id=" + accountId + " AND " + "key" + "=?", new String[]{key}, null, null, null);){
            if (cursor.moveToNext()) {
                long l = cursor.getLong(0);
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    private static String getDatabaseName(int userId) {
        File oldFile;
        File systemDir = Environment.getSystemSecureDirectory();
        File databaseFile = new File(Environment.getUserSystemDirectory(userId), DATABASE_NAME);
        if (userId == 0 && (oldFile = new File(systemDir, DATABASE_NAME)).exists() && !databaseFile.exists()) {
            File userDir = Environment.getUserSystemDirectory(userId);
            if (!userDir.exists() && !userDir.mkdirs()) {
                throw new IllegalStateException("User dir cannot be created: " + userDir);
            }
            if (!oldFile.renameTo(databaseFile)) {
                throw new IllegalStateException("User dir cannot be migrated: " + databaseFile);
            }
        }
        return databaseFile.getPath();
    }

    private void logRecord(UserAccounts accounts, String action, String tableName) {
        SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
        this.logRecord(db, action, tableName, -1L, accounts);
    }

    private void logRecordWithUid(UserAccounts accounts, String action, String tableName, int uid) {
        SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
        this.logRecord(db, action, tableName, -1L, accounts, uid);
    }

    private void logRecord(SQLiteDatabase db, String action, String tableName, long accountId, UserAccounts userAccount) {
        this.logRecord(db, action, tableName, accountId, userAccount, AccountManagerService.getCallingUid());
    }

    private void logRecord(SQLiteDatabase db, String action, String tableName, long accountId, UserAccounts userAccount, int callingUid) {
        SQLiteStatement logStatement = userAccount.statementForLogging;
        logStatement.bindLong(1, accountId);
        logStatement.bindString(2, action);
        logStatement.bindString(3, DebugDbHelper.dateFromat.format(new Date()));
        logStatement.bindLong(4, callingUid);
        logStatement.bindString(5, tableName);
        logStatement.bindLong(6, userAccount.debugDbInsertionPoint);
        logStatement.execute();
        logStatement.clearBindings();
        userAccount.debugDbInsertionPoint = (userAccount.debugDbInsertionPoint + 1) % 64;
    }

    private void initializeDebugDbSizeAndCompileSqlStatementForLogging(SQLiteDatabase db, UserAccounts userAccount) {
        int size = (int)this.getDebugTableRowCount(db);
        if (size >= 64) {
            userAccount.debugDbInsertionPoint = (int)this.getDebugTableInsertionPoint(db);
        } else {
            userAccount.debugDbInsertionPoint = size;
        }
        this.compileSqlStatementForLogging(db, userAccount);
    }

    private void compileSqlStatementForLogging(SQLiteDatabase db, UserAccounts userAccount) {
        String sql = "INSERT OR REPLACE INTO " + DebugDbHelper.TABLE_DEBUG + " VALUES (?,?,?,?,?,?)";
        userAccount.statementForLogging = db.compileStatement(sql);
    }

    private long getDebugTableRowCount(SQLiteDatabase db) {
        String queryCountDebugDbRows = "SELECT COUNT(*) FROM " + DebugDbHelper.TABLE_DEBUG;
        return DatabaseUtils.longForQuery(db, queryCountDebugDbRows, null);
    }

    private long getDebugTableInsertionPoint(SQLiteDatabase db) {
        String queryCountDebugDbRows = "SELECT " + DebugDbHelper.KEY + " FROM " + DebugDbHelper.TABLE_DEBUG + " ORDER BY " + DebugDbHelper.TIMESTAMP + "," + DebugDbHelper.KEY + " LIMIT 1";
        return DatabaseUtils.longForQuery(db, queryCountDebugDbRows, null);
    }

    public IBinder onBind(Intent intent) {
        return this.asBinder();
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            fout.println("Permission Denial: can't dump AccountsManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean isCheckinRequest = AccountManagerService.scanArgs(args, "--checkin") || AccountManagerService.scanArgs(args, "-c");
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)fout, "  ");
        List<UserInfo> users = this.getUserManager().getUsers();
        for (UserInfo user : users) {
            ipw.println("User " + user + ":");
            ipw.increaseIndent();
            this.dumpUser(this.getUserAccounts(user.id), fd, ipw, args, isCheckinRequest);
            ipw.println();
            ipw.decreaseIndent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpUser(UserAccounts userAccounts, FileDescriptor fd, PrintWriter fout, String[] args, boolean isCheckinRequest) {
        Object object = userAccounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = userAccounts.openHelper.getReadableDatabase();
            if (isCheckinRequest) {
                try (Cursor cursor = db.query(TABLE_ACCOUNTS, ACCOUNT_TYPE_COUNT_PROJECTION, null, null, "type", null, null);){
                    while (cursor.moveToNext()) {
                        fout.println(cursor.getString(0) + "," + cursor.getString(1));
                    }
                }
            }
            Account[] accounts = this.getAccountsFromCacheLocked(userAccounts, null, Process.myUid(), null);
            fout.println("Accounts: " + accounts.length);
            for (Account account : accounts) {
                fout.println("  " + account);
            }
            fout.println();
            Cursor cursor = db.query(DebugDbHelper.TABLE_DEBUG, null, null, null, null, null, DebugDbHelper.TIMESTAMP);
            fout.println("AccountId, Action_Type, timestamp, UID, TableName, Key");
            fout.println("Accounts History");
            try {
                while (cursor.moveToNext()) {
                    fout.println(cursor.getString(0) + "," + cursor.getString(1) + "," + cursor.getString(2) + "," + cursor.getString(3) + "," + cursor.getString(4) + "," + cursor.getString(5));
                }
            }
            finally {
                cursor.close();
            }
            fout.println();
            LinkedHashMap<String, Session> linkedHashMap = this.mSessions;
            synchronized (linkedHashMap) {
                long now = SystemClock.elapsedRealtime();
                fout.println("Active Sessions: " + this.mSessions.size());
                for (Session session : this.mSessions.values()) {
                    fout.println("  " + session.toDebugString(now));
                }
            }
            fout.println();
            this.mAuthenticatorCache.dump(fd, fout, args, userAccounts.userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotification(UserAccounts accounts, Account account, CharSequence message, Intent intent, int userId) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "doNotification: " + message + " intent:" + intent);
            }
            if (intent.getComponent() != null && GrantCredentialsPermissionActivity.class.getName().equals(intent.getComponent().getClassName())) {
                this.createNoCredentialsPermissionNotification(account, intent, userId);
            } else {
                Integer notificationId = this.getSigninRequiredNotificationId(accounts, account);
                intent.addCategory(String.valueOf(notificationId));
                UserHandle user = new UserHandle(userId);
                Context contextForUser = this.getContextForUser(user);
                String notificationTitleFormat = contextForUser.getText(17039585).toString();
                Notification n = new Notification.Builder(contextForUser).setWhen(0L).setSmallIcon(17301642).setColor(contextForUser.getColor(17170521)).setContentTitle(String.format(notificationTitleFormat, account.name)).setContentText(message).setContentIntent(PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x10000000, null, user)).build();
                this.installNotification(notificationId, n, user);
            }
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    protected void installNotification(int notificationId, Notification n, UserHandle user) {
        ((NotificationManager)this.mContext.getSystemService("notification")).notifyAsUser(null, notificationId, n, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelNotification(int id2, UserHandle user) {
        long identityToken = AccountManagerService.clearCallingIdentity();
        try {
            ((NotificationManager)this.mContext.getSystemService("notification")).cancelAsUser(null, id2, user);
        }
        finally {
            AccountManagerService.restoreCallingIdentity(identityToken);
        }
    }

    private boolean isPermitted(String opPackageName, int callingUid, String ... permissions) {
        for (String perm : permissions) {
            int opCode;
            if (this.mContext.checkCallingOrSelfPermission(perm) != 0) continue;
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "  caller uid " + callingUid + " has " + perm);
            }
            if ((opCode = AppOpsManager.permissionToOpCode(perm)) != -1 && this.mAppOpsManager.noteOp(opCode, callingUid, opPackageName) != 0) continue;
            return true;
        }
        return false;
    }

    private int handleIncomingUser(int userId) {
        try {
            return ActivityManagerNative.getDefault().handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, true, "", null);
        }
        catch (RemoteException remoteException) {
            return userId;
        }
    }

    private boolean isPrivileged(int callingUid) {
        String[] packages;
        PackageManager userPackageManager;
        int callingUserId = UserHandle.getUserId(callingUid);
        try {
            userPackageManager = this.mContext.createPackageContextAsUser("android", 0, new UserHandle(callingUserId)).getPackageManager();
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        for (String name : packages = userPackageManager.getPackagesForUid(callingUid)) {
            try {
                PackageInfo packageInfo = userPackageManager.getPackageInfo(name, 0);
                if (packageInfo == null || (packageInfo.applicationInfo.privateFlags & 8) == 0) continue;
                return true;
            }
            catch (PackageManager.NameNotFoundException e) {
                return false;
            }
        }
        return false;
    }

    private boolean permissionIsGranted(Account account, String authTokenType, int callerUid, int userId) {
        boolean hasExplicitGrants;
        boolean isPrivileged = this.isPrivileged(callerUid);
        boolean fromAuthenticator = account != null && this.isAccountManagedByCaller(account.type, callerUid, userId);
        boolean bl = hasExplicitGrants = account != null && this.hasExplicitlyGrantedPermission(account, authTokenType, callerUid);
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "checkGrantsOrCallingUidAgainstAuthenticator: caller uid " + callerUid + ", " + account + ": is authenticator? " + fromAuthenticator + ", has explicit permission? " + hasExplicitGrants);
        }
        return fromAuthenticator || hasExplicitGrants || isPrivileged;
    }

    private boolean isAccountVisibleToCaller(String accountType, int callingUid, int userId, String opPackageName) {
        if (accountType == null) {
            return false;
        }
        return this.getTypesVisibleToCaller(callingUid, userId, opPackageName).contains(accountType);
    }

    private boolean isAccountManagedByCaller(String accountType, int callingUid, int userId) {
        if (accountType == null) {
            return false;
        }
        return this.getTypesManagedByCaller(callingUid, userId).contains(accountType);
    }

    private List<String> getTypesVisibleToCaller(int callingUid, int userId, String opPackageName) {
        boolean isPermitted = this.isPermitted(opPackageName, callingUid, "android.permission.GET_ACCOUNTS", "android.permission.GET_ACCOUNTS_PRIVILEGED");
        Log.i(TAG, String.format("getTypesVisibleToCaller: isPermitted? %s", isPermitted));
        return this.getTypesForCaller(callingUid, userId, isPermitted);
    }

    private List<String> getTypesManagedByCaller(int callingUid, int userId) {
        return this.getTypesForCaller(callingUid, userId, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTypesForCaller(int callingUid, int userId, boolean isOtherwisePermitted) {
        Collection<RegisteredServicesCache.ServiceInfo<AuthenticatorDescription>> serviceInfos;
        ArrayList<String> managedAccountTypes = new ArrayList<String>();
        long identityToken = Binder.clearCallingIdentity();
        try {
            serviceInfos = this.mAuthenticatorCache.getAllServices(userId);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
        for (RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> serviceInfo : serviceInfos) {
            int sigChk = this.mPackageManager.checkSignatures(serviceInfo.uid, callingUid);
            if (!isOtherwisePermitted && sigChk != 0) continue;
            managedAccountTypes.add(((AuthenticatorDescription)serviceInfo.type).type);
        }
        return managedAccountTypes;
    }

    private boolean isAccountPresentForCaller(String accountName, String accountType) {
        if (this.getUserAccountsForCaller().accountCache.containsKey(accountType)) {
            for (Account account : (Account[])this.getUserAccountsForCaller().accountCache.get(accountType)) {
                if (!account.name.equals(accountName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasExplicitlyGrantedPermission(Account account, String authTokenType, int callerUid) {
        if (callerUid == 1000) {
            return true;
        }
        UserAccounts accounts = this.getUserAccountsForCaller();
        Object object = accounts.cacheLock;
        synchronized (object) {
            boolean permissionGranted;
            SQLiteDatabase db = accounts.openHelper.getReadableDatabase();
            String[] args = new String[]{String.valueOf(callerUid), authTokenType, account.name, account.type};
            boolean bl = permissionGranted = DatabaseUtils.longForQuery(db, COUNT_OF_MATCHING_GRANTS, args) != 0L;
            if (!permissionGranted && ActivityManager.isRunningInTestHarness()) {
                Log.d(TAG, "no credentials permission for usage of " + account + ", " + authTokenType + " by uid " + callerUid + " but ignoring since device is in test harness.");
                return true;
            }
            return permissionGranted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSystemUid(int callingUid) {
        String[] packages = null;
        long ident = Binder.clearCallingIdentity();
        try {
            packages = this.mPackageManager.getPackagesForUid(callingUid);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (packages != null) {
            for (String name : packages) {
                try {
                    PackageInfo packageInfo = this.mPackageManager.getPackageInfo(name, 0);
                    if (packageInfo == null || (packageInfo.applicationInfo.flags & 1) == 0) continue;
                    return true;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.w(TAG, String.format("Could not find package [%s]", name), e);
                }
            }
        } else {
            Log.w(TAG, "No known packages with uid " + callingUid);
        }
        return false;
    }

    private void checkReadAccountsPermitted(int callingUid, String accountType, int userId, String opPackageName) {
        if (!this.isAccountVisibleToCaller(accountType, callingUid, userId, opPackageName)) {
            String msg = String.format("caller uid %s cannot access %s accounts", callingUid, accountType);
            Log.w(TAG, "  " + msg);
            throw new SecurityException(msg);
        }
    }

    private boolean canUserModifyAccounts(int userId) {
        return !this.getUserManager().getUserRestrictions(new UserHandle(userId)).getBoolean("no_modify_accounts");
    }

    private boolean canUserModifyAccountsForType(int userId, String accountType) {
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        String[] typesArray = dpm.getAccountTypesWithManagementDisabledAsUser(userId);
        if (typesArray == null) {
            return true;
        }
        for (String forbiddenType : typesArray) {
            if (!forbiddenType.equals(accountType)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateAppPermission(Account account, String authTokenType, int uid, boolean value) throws RemoteException {
        int callingUid = AccountManagerService.getCallingUid();
        if (callingUid != 1000) {
            throw new SecurityException();
        }
        if (value) {
            this.grantAppPermission(account, authTokenType, uid);
        } else {
            this.revokeAppPermission(account, authTokenType, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grantAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "grantAppPermission: called with invalid arguments", new Exception());
            return;
        }
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                long accountId = this.getAccountIdLocked(db, account);
                if (accountId >= 0L) {
                    ContentValues values = new ContentValues();
                    values.put("accounts_id", accountId);
                    values.put(GRANTS_AUTH_TOKEN_TYPE, authTokenType);
                    values.put(GRANTS_GRANTEE_UID, uid);
                    db.insert(TABLE_GRANTS, "accounts_id", values);
                    db.setTransactionSuccessful();
                }
            }
            finally {
                db.endTransaction();
            }
            this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), new UserHandle(accounts.userId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void revokeAppPermission(Account account, String authTokenType, int uid) {
        if (account == null || authTokenType == null) {
            Log.e(TAG, "revokeAppPermission: called with invalid arguments", new Exception());
            return;
        }
        UserAccounts accounts = this.getUserAccounts(UserHandle.getUserId(uid));
        Object object = accounts.cacheLock;
        synchronized (object) {
            SQLiteDatabase db = accounts.openHelper.getWritableDatabase();
            db.beginTransaction();
            try {
                long accountId = this.getAccountIdLocked(db, account);
                if (accountId >= 0L) {
                    db.delete(TABLE_GRANTS, "accounts_id=? AND auth_token_type=? AND uid=?", new String[]{String.valueOf(accountId), authTokenType, String.valueOf(uid)});
                    db.setTransactionSuccessful();
                }
            }
            finally {
                db.endTransaction();
            }
            this.cancelNotification(this.getCredentialPermissionNotificationId(account, authTokenType, uid), new UserHandle(accounts.userId));
        }
    }

    private static final String stringArrayToString(String[] value) {
        return value != null ? "[" + TextUtils.join((CharSequence)",", value) + "]" : null;
    }

    private void removeAccountFromCacheLocked(UserAccounts accounts, Account account) {
        Account[] oldAccountsForType = (Account[])accounts.accountCache.get(account.type);
        if (oldAccountsForType != null) {
            ArrayList<Account> newAccountsList = new ArrayList<Account>();
            for (Account curAccount : oldAccountsForType) {
                if (curAccount.equals(account)) continue;
                newAccountsList.add(curAccount);
            }
            if (newAccountsList.isEmpty()) {
                accounts.accountCache.remove(account.type);
            } else {
                Account[] newAccountsForType = new Account[newAccountsList.size()];
                newAccountsForType = newAccountsList.toArray(newAccountsForType);
                accounts.accountCache.put(account.type, newAccountsForType);
            }
        }
        accounts.userDataCache.remove(account);
        accounts.authTokenCache.remove(account);
        accounts.previousNameCache.remove(account);
    }

    private void insertAccountIntoCacheLocked(UserAccounts accounts, Account account) {
        Account[] accountsForType = (Account[])accounts.accountCache.get(account.type);
        int oldLength = accountsForType != null ? accountsForType.length : 0;
        Account[] newAccountsForType = new Account[oldLength + 1];
        if (accountsForType != null) {
            System.arraycopy(accountsForType, 0, newAccountsForType, 0, oldLength);
        }
        newAccountsForType[oldLength] = account;
        accounts.accountCache.put(account.type, newAccountsForType);
    }

    private Account[] filterSharedAccounts(UserAccounts userAccounts, Account[] unfiltered, int callingUid, String callingPackage) {
        if (this.getUserManager() == null || userAccounts == null || userAccounts.userId < 0 || callingUid == Process.myUid()) {
            return unfiltered;
        }
        UserInfo user = this.mUserManager.getUserInfo(userAccounts.userId);
        if (user != null && user.isRestricted()) {
            String requiredAccountType;
            Account[] sharedAccounts;
            ArrayList<Object> allowed;
            block12: {
                String[] packages = this.mPackageManager.getPackagesForUid(callingUid);
                String whiteList = this.mContext.getResources().getString(17039432);
                for (String packageName : packages) {
                    if (!whiteList.contains(";" + packageName + ";")) continue;
                    return unfiltered;
                }
                allowed = new ArrayList<Object>();
                sharedAccounts = this.getSharedAccountsAsUser(userAccounts.userId);
                if (sharedAccounts == null || sharedAccounts.length == 0) {
                    return unfiltered;
                }
                requiredAccountType = "";
                try {
                    if (callingPackage != null) {
                        PackageInfo pi = this.mPackageManager.getPackageInfo(callingPackage, 0);
                        if (pi != null && pi.restrictedAccountType != null) {
                            requiredAccountType = pi.restrictedAccountType;
                        }
                        break block12;
                    }
                    for (String packageName : packages) {
                        PackageInfo pi = this.mPackageManager.getPackageInfo(packageName, 0);
                        if (pi == null || pi.restrictedAccountType == null) continue;
                        requiredAccountType = pi.restrictedAccountType;
                        break;
                    }
                }
                catch (PackageManager.NameNotFoundException nnfe) {
                    // empty catch block
                }
            }
            for (Account account : unfiltered) {
                if (account.type.equals(requiredAccountType)) {
                    allowed.add(account);
                    continue;
                }
                boolean found = false;
                for (Account shared : sharedAccounts) {
                    if (!shared.equals(account)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                allowed.add(account);
            }
            Account[] filtered = new Account[allowed.size()];
            allowed.toArray(filtered);
            return filtered;
        }
        return unfiltered;
    }

    protected Account[] getAccountsFromCacheLocked(UserAccounts userAccounts, String accountType, int callingUid, String callingPackage) {
        if (accountType != null) {
            Account[] accounts = (Account[])userAccounts.accountCache.get(accountType);
            if (accounts == null) {
                return EMPTY_ACCOUNT_ARRAY;
            }
            return this.filterSharedAccounts(userAccounts, Arrays.copyOf(accounts, accounts.length), callingUid, callingPackage);
        }
        int totalLength = 0;
        for (Account[] accounts : userAccounts.accountCache.values()) {
            totalLength += accounts.length;
        }
        if (totalLength == 0) {
            return EMPTY_ACCOUNT_ARRAY;
        }
        Account[] accounts = new Account[totalLength];
        totalLength = 0;
        for (Account[] accountsOfType : userAccounts.accountCache.values()) {
            System.arraycopy(accountsOfType, 0, accounts, totalLength, accountsOfType.length);
            totalLength += accountsOfType.length;
        }
        return this.filterSharedAccounts(userAccounts, accounts, callingUid, callingPackage);
    }

    protected void writeUserDataIntoCacheLocked(UserAccounts accounts, SQLiteDatabase db, Account account, String key, String value) {
        HashMap<String, String> userDataForAccount = (HashMap<String, String>)accounts.userDataCache.get(account);
        if (userDataForAccount == null) {
            userDataForAccount = this.readUserDataForAccountFromDatabaseLocked(db, account);
            accounts.userDataCache.put(account, userDataForAccount);
        }
        if (value == null) {
            userDataForAccount.remove(key);
        } else {
            userDataForAccount.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readCachedTokenInternal(UserAccounts accounts, Account account, String tokenType, String callingPackage, byte[] pkgSigDigest) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            return accounts.accountTokenCaches.get(account, tokenType, callingPackage, pkgSigDigest);
        }
    }

    protected void writeAuthTokenIntoCacheLocked(UserAccounts accounts, SQLiteDatabase db, Account account, String key, String value) {
        HashMap<String, String> authTokensForAccount = (HashMap<String, String>)accounts.authTokenCache.get(account);
        if (authTokensForAccount == null) {
            authTokensForAccount = this.readAuthTokensForAccountFromDatabaseLocked(db, account);
            accounts.authTokenCache.put(account, authTokensForAccount);
        }
        if (value == null) {
            authTokensForAccount.remove(key);
        } else {
            authTokensForAccount.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readAuthTokenInternal(UserAccounts accounts, Account account, String authTokenType) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            HashMap<String, String> authTokensForAccount = (HashMap<String, String>)accounts.authTokenCache.get(account);
            if (authTokensForAccount == null) {
                SQLiteDatabase db = accounts.openHelper.getReadableDatabase();
                authTokensForAccount = this.readAuthTokensForAccountFromDatabaseLocked(db, account);
                accounts.authTokenCache.put(account, authTokensForAccount);
            }
            return (String)authTokensForAccount.get(authTokenType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readUserDataInternal(UserAccounts accounts, Account account, String key) {
        Object object = accounts.cacheLock;
        synchronized (object) {
            HashMap<String, String> userDataForAccount = (HashMap<String, String>)accounts.userDataCache.get(account);
            if (userDataForAccount == null) {
                SQLiteDatabase db = accounts.openHelper.getReadableDatabase();
                userDataForAccount = this.readUserDataForAccountFromDatabaseLocked(db, account);
                accounts.userDataCache.put(account, userDataForAccount);
            }
            return (String)userDataForAccount.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, String> readUserDataForAccountFromDatabaseLocked(SQLiteDatabase db, Account account) {
        HashMap<String, String> userDataForAccount = new HashMap<String, String>();
        try (Cursor cursor = db.query(TABLE_EXTRAS, COLUMNS_EXTRAS_KEY_AND_VALUE, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?)", new String[]{account.name, account.type}, null, null, null);){
            while (cursor.moveToNext()) {
                String tmpkey = cursor.getString(0);
                String value = cursor.getString(1);
                userDataForAccount.put(tmpkey, value);
            }
        }
        return userDataForAccount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HashMap<String, String> readAuthTokensForAccountFromDatabaseLocked(SQLiteDatabase db, Account account) {
        HashMap<String, String> authTokensForAccount = new HashMap<String, String>();
        try (Cursor cursor = db.query(TABLE_AUTHTOKENS, COLUMNS_AUTHTOKENS_TYPE_AND_AUTHTOKEN, "accounts_id=(select _id FROM accounts WHERE name=? AND type=?)", new String[]{account.name, account.type}, null, null, null);){
            while (cursor.moveToNext()) {
                String type = cursor.getString(0);
                String authToken = cursor.getString(1);
                authTokensForAccount.put(type, authToken);
            }
        }
        return authTokensForAccount;
    }

    private Context getContextForUser(UserHandle user) {
        try {
            return this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return this.mContext;
        }
    }

    static {
        ACCOUNTS_CHANGED_INTENT.setFlags(0x4000000);
        COLUMNS_AUTHTOKENS_TYPE_AND_AUTHTOKEN = new String[]{"type", AUTHTOKENS_AUTHTOKEN};
        COLUMNS_EXTRAS_KEY_AND_VALUE = new String[]{"key", "value"};
        sThis = new AtomicReference();
        EMPTY_ACCOUNT_ARRAY = new Account[0];
    }

    static class DatabaseHelper
    extends SQLiteOpenHelper {
        public DatabaseHelper(Context context, int userId) {
            super(context, AccountManagerService.getDatabaseName(userId), null, 8);
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE accounts ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, type TEXT NOT NULL, password TEXT, previous_name TEXT, last_password_entry_time_millis_epoch INTEGER DEFAULT 0, UNIQUE(name,type))");
            db.execSQL("CREATE TABLE authtokens (  _id INTEGER PRIMARY KEY AUTOINCREMENT,  accounts_id INTEGER NOT NULL, type TEXT NOT NULL,  authtoken TEXT,  UNIQUE (accounts_id,type))");
            this.createGrantsTable(db);
            db.execSQL("CREATE TABLE extras ( _id INTEGER PRIMARY KEY AUTOINCREMENT, accounts_id INTEGER, key TEXT NOT NULL, value TEXT, UNIQUE(accounts_id,key))");
            db.execSQL("CREATE TABLE meta ( key TEXT PRIMARY KEY NOT NULL, value TEXT)");
            this.createSharedAccountsTable(db);
            this.createAccountsDeletionTrigger(db);
            DebugDbHelper.createDebugTable(db);
        }

        private void createSharedAccountsTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE shared_accounts ( _id INTEGER PRIMARY KEY AUTOINCREMENT, name TEXT NOT NULL, type TEXT NOT NULL, UNIQUE(name,type))");
        }

        private void addLastSuccessfullAuthenticatedTimeColumn(SQLiteDatabase db) {
            db.execSQL("ALTER TABLE accounts ADD COLUMN last_password_entry_time_millis_epoch DEFAULT 0");
        }

        private void addOldAccountNameColumn(SQLiteDatabase db) {
            db.execSQL("ALTER TABLE accounts ADD COLUMN previous_name");
        }

        private void addDebugTable(SQLiteDatabase db) {
            DebugDbHelper.createDebugTable(db);
        }

        private void createAccountsDeletionTrigger(SQLiteDatabase db) {
            db.execSQL(" CREATE TRIGGER accountsDelete DELETE ON accounts BEGIN   DELETE FROM authtokens     WHERE accounts_id=OLD._id ;   DELETE FROM extras     WHERE accounts_id=OLD._id ;   DELETE FROM grants     WHERE accounts_id=OLD._id ; END");
        }

        private void createGrantsTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE grants (  accounts_id INTEGER NOT NULL, auth_token_type STRING NOT NULL,  uid INTEGER NOT NULL,  UNIQUE (accounts_id,auth_token_type,uid))");
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            Log.e(AccountManagerService.TAG, "upgrade from version " + oldVersion + " to version " + newVersion);
            if (oldVersion == 1) {
                ++oldVersion;
            }
            if (oldVersion == 2) {
                this.createGrantsTable(db);
                db.execSQL("DROP TRIGGER accountsDelete");
                this.createAccountsDeletionTrigger(db);
                ++oldVersion;
            }
            if (oldVersion == 3) {
                db.execSQL("UPDATE accounts SET type = 'com.google' WHERE type == 'com.google.GAIA'");
                ++oldVersion;
            }
            if (oldVersion == 4) {
                this.createSharedAccountsTable(db);
                ++oldVersion;
            }
            if (oldVersion == 5) {
                this.addOldAccountNameColumn(db);
                ++oldVersion;
            }
            if (oldVersion == 6) {
                this.addLastSuccessfullAuthenticatedTimeColumn(db);
                ++oldVersion;
            }
            if (oldVersion == 7) {
                this.addDebugTable(db);
                ++oldVersion;
            }
            if (oldVersion != newVersion) {
                Log.e(AccountManagerService.TAG, "failed to upgrade version " + oldVersion + " to version " + newVersion);
            }
        }

        @Override
        public void onOpen(SQLiteDatabase db) {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "opened database accounts.db");
            }
        }
    }

    private static class DebugDbHelper {
        private static String TABLE_DEBUG = "debug_table";
        private static String ACTION_TYPE = "action_type";
        private static String TIMESTAMP = "time";
        private static String CALLER_UID = "caller_uid";
        private static String TABLE_NAME = "table_name";
        private static String KEY = "primary_key";
        private static String ACTION_SET_PASSWORD = "action_set_password";
        private static String ACTION_CLEAR_PASSWORD = "action_clear_password";
        private static String ACTION_ACCOUNT_ADD = "action_account_add";
        private static String ACTION_ACCOUNT_REMOVE = "action_account_remove";
        private static String ACTION_AUTHENTICATOR_REMOVE = "action_authenticator_remove";
        private static String ACTION_ACCOUNT_RENAME = "action_account_rename";
        private static String ACTION_CALLED_ACCOUNT_ADD = "action_called_account_add";
        private static String ACTION_CALLED_ACCOUNT_REMOVE = "action_called_account_remove";
        private static SimpleDateFormat dateFromat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        private DebugDbHelper() {
        }

        private static void createDebugTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE " + TABLE_DEBUG + " ( " + "_id" + " INTEGER," + ACTION_TYPE + " TEXT NOT NULL, " + TIMESTAMP + " DATETIME," + CALLER_UID + " INTEGER NOT NULL," + TABLE_NAME + " TEXT NOT NULL," + KEY + " INTEGER PRIMARY KEY)");
            db.execSQL("CREATE INDEX timestamp_index ON " + TABLE_DEBUG + " (" + TIMESTAMP + ")");
        }
    }

    private class MessageHandler
    extends Handler {
        MessageHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    Session session = (Session)msg.obj;
                    session.onTimedOut();
                    break;
                }
                case 4: {
                    AccountManagerService.this.copyAccountToUser(null, (Account)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                default: {
                    throw new IllegalStateException("unhandled message: " + msg.what);
                }
            }
        }
    }

    private abstract class Session
    extends IAccountAuthenticatorResponse.Stub
    implements IBinder.DeathRecipient,
    ServiceConnection {
        IAccountManagerResponse mResponse;
        final String mAccountType;
        final boolean mExpectActivityLaunch;
        final long mCreationTime;
        final String mAccountName;
        final boolean mAuthDetailsRequired;
        final boolean mUpdateLastAuthenticatedTime;
        public int mNumResults = 0;
        private int mNumRequestContinued = 0;
        private int mNumErrors = 0;
        IAccountAuthenticator mAuthenticator = null;
        private final boolean mStripAuthTokenFromResult;
        protected final UserAccounts mAccounts;

        public Session(UserAccounts accounts, IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, boolean stripAuthTokenFromResult, String accountName, boolean authDetailsRequired) {
            this(accounts, response, accountType, expectActivityLaunch, stripAuthTokenFromResult, accountName, authDetailsRequired, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Session(UserAccounts accounts, IAccountManagerResponse response, String accountType, boolean expectActivityLaunch, boolean stripAuthTokenFromResult, String accountName, boolean authDetailsRequired, boolean updateLastAuthenticatedTime) {
            if (accountType == null) {
                throw new IllegalArgumentException("accountType is null");
            }
            this.mAccounts = accounts;
            this.mStripAuthTokenFromResult = stripAuthTokenFromResult;
            this.mResponse = response;
            this.mAccountType = accountType;
            this.mExpectActivityLaunch = expectActivityLaunch;
            this.mCreationTime = SystemClock.elapsedRealtime();
            this.mAccountName = accountName;
            this.mAuthDetailsRequired = authDetailsRequired;
            this.mUpdateLastAuthenticatedTime = updateLastAuthenticatedTime;
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                AccountManagerService.this.mSessions.put(this.toString(), this);
            }
            if (response != null) {
                try {
                    response.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.mResponse = null;
                    this.binderDied();
                }
            }
        }

        IAccountManagerResponse getResponseAndClose() {
            if (this.mResponse == null) {
                return null;
            }
            IAccountManagerResponse response = this.mResponse;
            this.close();
            return response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void close() {
            LinkedHashMap linkedHashMap = AccountManagerService.this.mSessions;
            synchronized (linkedHashMap) {
                if (AccountManagerService.this.mSessions.remove(this.toString()) == null) {
                    return;
                }
            }
            if (this.mResponse != null) {
                this.mResponse.asBinder().unlinkToDeath(this, 0);
                this.mResponse = null;
            }
            this.cancelTimeout();
            this.unbind();
        }

        @Override
        public void binderDied() {
            this.mResponse = null;
            this.close();
        }

        protected String toDebugString() {
            return this.toDebugString(SystemClock.elapsedRealtime());
        }

        protected String toDebugString(long now) {
            return "Session: expectLaunch " + this.mExpectActivityLaunch + ", connected " + (this.mAuthenticator != null) + ", stats (" + this.mNumResults + "/" + this.mNumRequestContinued + "/" + this.mNumErrors + ")" + ", lifetime " + (double)(now - this.mCreationTime) / 1000.0;
        }

        void bind() {
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "initiating bind to authenticator type " + this.mAccountType);
            }
            if (!this.bindToAuthenticator(this.mAccountType)) {
                Log.d(AccountManagerService.TAG, "bind attempt failed for " + this.toDebugString());
                this.onError(1, "bind failure");
            }
        }

        private void unbind() {
            if (this.mAuthenticator != null) {
                this.mAuthenticator = null;
                AccountManagerService.this.mContext.unbindService(this);
            }
        }

        public void cancelTimeout() {
            AccountManagerService.this.mMessageHandler.removeMessages(3, this);
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            this.mAuthenticator = IAccountAuthenticator.Stub.asInterface(service);
            try {
                this.run();
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            block3: {
                this.mAuthenticator = null;
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        response.onError(1, "disconnected");
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block3;
                        Log.v(AccountManagerService.TAG, "Session.onServiceDisconnected: caught RemoteException while responding", e);
                    }
                }
            }
        }

        public abstract void run() throws RemoteException;

        public void onTimedOut() {
            block3: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        response.onError(1, "timeout");
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block3;
                        Log.v(AccountManagerService.TAG, "Session.onTimedOut: caught RemoteException while responding", e);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResult(Bundle result) {
            block23: {
                IAccountManagerResponse response;
                ++this.mNumResults;
                Intent intent = null;
                if (result != null) {
                    boolean needUpdate;
                    boolean isSuccessfulConfirmCreds = result.getBoolean("booleanResult", false);
                    boolean isSuccessfulUpdateCredsOrAddAccount = result.containsKey("authAccount") && result.containsKey("accountType");
                    boolean bl = needUpdate = this.mUpdateLastAuthenticatedTime && (isSuccessfulConfirmCreds || isSuccessfulUpdateCredsOrAddAccount);
                    if (needUpdate || this.mAuthDetailsRequired) {
                        boolean accountPresent = AccountManagerService.this.isAccountPresentForCaller(this.mAccountName, this.mAccountType);
                        if (needUpdate && accountPresent) {
                            AccountManagerService.this.updateLastAuthenticatedTime(new Account(this.mAccountName, this.mAccountType));
                        }
                        if (this.mAuthDetailsRequired) {
                            long lastAuthenticatedTime = -1L;
                            if (accountPresent) {
                                lastAuthenticatedTime = DatabaseUtils.longForQuery(this.mAccounts.openHelper.getReadableDatabase(), "select last_password_entry_time_millis_epoch from accounts WHERE name=? AND type=?", new String[]{this.mAccountName, this.mAccountType});
                            }
                            result.putLong("lastAuthenticatedTime", lastAuthenticatedTime);
                        }
                    }
                }
                if (result != null && (intent = (Intent)result.getParcelable("intent")) != null) {
                    int authenticatorUid = Binder.getCallingUid();
                    long bid = Binder.clearCallingIdentity();
                    try {
                        PackageManager pm = AccountManagerService.this.mContext.getPackageManager();
                        ResolveInfo resolveInfo = pm.resolveActivityAsUser(intent, 0, this.mAccounts.userId);
                        int targetUid = resolveInfo.activityInfo.applicationInfo.uid;
                        if (0 != pm.checkSignatures(authenticatorUid, targetUid)) {
                            throw new SecurityException("Activity to be started with KEY_INTENT must share Authenticator's signatures");
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(bid);
                    }
                }
                if (result != null && !TextUtils.isEmpty(result.getString(AccountManagerService.AUTHTOKENS_AUTHTOKEN))) {
                    String accountName = result.getString("authAccount");
                    String accountType = result.getString("accountType");
                    if (!TextUtils.isEmpty(accountName) && !TextUtils.isEmpty(accountType)) {
                        Account account = new Account(accountName, accountType);
                        AccountManagerService.this.cancelNotification(AccountManagerService.this.getSigninRequiredNotificationId(this.mAccounts, account), new UserHandle(this.mAccounts.userId));
                    }
                }
                if ((response = this.mExpectActivityLaunch && result != null && result.containsKey("intent") ? this.mResponse : this.getResponseAndClose()) != null) {
                    try {
                        if (result == null) {
                            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                                Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onError() on response " + response);
                            }
                            response.onError(5, "null bundle returned");
                        } else {
                            if (this.mStripAuthTokenFromResult) {
                                result.remove(AccountManagerService.AUTHTOKENS_AUTHTOKEN);
                            }
                            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                                Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                            }
                            if (result.getInt("errorCode", -1) > 0 && intent == null) {
                                response.onError(result.getInt("errorCode"), result.getString("errorMessage"));
                            } else {
                                response.onResult(result);
                            }
                        }
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block23;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        public void onRequestContinued() {
            ++this.mNumRequestContinued;
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
            ++this.mNumErrors;
            IAccountManagerResponse response = this.getResponseAndClose();
            if (response != null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onError() on response " + response);
                }
                try {
                    response.onError(errorCode, errorMessage);
                }
                catch (RemoteException e) {
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, "Session.onError: caught RemoteException while responding", e);
                    }
                }
            } else if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "Session.onError: already closed");
            }
        }

        private boolean bindToAuthenticator(String authenticatorType) {
            RegisteredServicesCache.ServiceInfo<AuthenticatorDescription> authenticatorInfo = AccountManagerService.this.mAuthenticatorCache.getServiceInfo(AuthenticatorDescription.newKey(authenticatorType), this.mAccounts.userId);
            if (authenticatorInfo == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "there is no authenticator for " + authenticatorType + ", bailing out");
                }
                return false;
            }
            Intent intent = new Intent();
            intent.setAction("android.accounts.AccountAuthenticator");
            intent.setComponent(authenticatorInfo.componentName);
            if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                Log.v(AccountManagerService.TAG, "performing bindService to " + authenticatorInfo.componentName);
            }
            if (!AccountManagerService.this.mContext.bindServiceAsUser(intent, this, 1, new UserHandle(this.mAccounts.userId))) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "bindService to " + authenticatorInfo.componentName + " failed");
                }
                return false;
            }
            return true;
        }
    }

    private class GetAccountsByTypeAndFeatureSession
    extends Session {
        private final String[] mFeatures;
        private volatile Account[] mAccountsOfType;
        private volatile ArrayList<Account> mAccountsWithFeatures;
        private volatile int mCurrentAccount;
        private final int mCallingUid;

        public GetAccountsByTypeAndFeatureSession(UserAccounts accounts, IAccountManagerResponse response, String type, String[] features, int callingUid) {
            super(accounts, response, type, false, true, null, false);
            this.mAccountsOfType = null;
            this.mAccountsWithFeatures = null;
            this.mCurrentAccount = 0;
            this.mCallingUid = callingUid;
            this.mFeatures = features;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws RemoteException {
            Object object = this.mAccounts.cacheLock;
            synchronized (object) {
                this.mAccountsOfType = AccountManagerService.this.getAccountsFromCacheLocked(this.mAccounts, this.mAccountType, this.mCallingUid, null);
            }
            this.mAccountsWithFeatures = new ArrayList(this.mAccountsOfType.length);
            this.mCurrentAccount = 0;
            this.checkAccount();
        }

        public void checkAccount() {
            if (this.mCurrentAccount >= this.mAccountsOfType.length) {
                this.sendResult();
                return;
            }
            IAccountAuthenticator accountAuthenticator = this.mAuthenticator;
            if (accountAuthenticator == null) {
                if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                    Log.v(AccountManagerService.TAG, "checkAccount: aborting session since we are no longer connected to the authenticator, " + this.toDebugString());
                }
                return;
            }
            try {
                accountAuthenticator.hasFeatures(this, this.mAccountsOfType[this.mCurrentAccount], this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onResult(Bundle result) {
            ++this.mNumResults;
            if (result == null) {
                this.onError(5, "null bundle");
                return;
            }
            if (result.getBoolean("booleanResult", false)) {
                this.mAccountsWithFeatures.add(this.mAccountsOfType[this.mCurrentAccount]);
            }
            ++this.mCurrentAccount;
            this.checkAccount();
        }

        public void sendResult() {
            block5: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        Parcelable[] accounts = new Account[this.mAccountsWithFeatures.size()];
                        for (int i = 0; i < accounts.length; ++i) {
                            accounts[i] = this.mAccountsWithFeatures.get(i);
                        }
                        if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                            Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                        }
                        Bundle result = new Bundle();
                        result.putParcelableArray(AccountManagerService.TABLE_ACCOUNTS, accounts);
                        response.onResult(result);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block5;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", getAccountsByTypeAndFeatures" + ", " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    private class RemoveAccountSession
    extends Session {
        final Account mAccount;

        public RemoveAccountSession(UserAccounts accounts, IAccountManagerResponse response, Account account, boolean expectActivityLaunch) {
            super(accounts, response, account.type, expectActivityLaunch, true, account.name, false);
            this.mAccount = account;
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", removeAccount" + ", account " + this.mAccount;
        }

        @Override
        public void run() throws RemoteException {
            this.mAuthenticator.getAccountRemovalAllowed(this, this.mAccount);
        }

        @Override
        public void onResult(Bundle result) {
            if (result != null && result.containsKey("booleanResult") && !result.containsKey("intent")) {
                IAccountManagerResponse response;
                boolean removalAllowed = result.getBoolean("booleanResult");
                if (removalAllowed) {
                    AccountManagerService.this.removeAccountInternal(this.mAccounts, this.mAccount);
                }
                if ((response = this.getResponseAndClose()) != null) {
                    if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                        Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                    }
                    Bundle result2 = new Bundle();
                    result2.putBoolean("booleanResult", removalAllowed);
                    try {
                        response.onResult(result2);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            super.onResult(result);
        }
    }

    private class TestFeaturesSession
    extends Session {
        private final String[] mFeatures;
        private final Account mAccount;

        public TestFeaturesSession(UserAccounts accounts, IAccountManagerResponse response, Account account, String[] features) {
            super(accounts, response, account.type, false, true, account.name, false);
            this.mFeatures = features;
            this.mAccount = account;
        }

        @Override
        public void run() throws RemoteException {
            try {
                this.mAuthenticator.hasFeatures(this, this.mAccount, this.mFeatures);
            }
            catch (RemoteException e) {
                this.onError(1, "remote exception");
            }
        }

        @Override
        public void onResult(Bundle result) {
            block5: {
                IAccountManagerResponse response = this.getResponseAndClose();
                if (response != null) {
                    try {
                        if (result == null) {
                            response.onError(5, "null bundle");
                            return;
                        }
                        if (Log.isLoggable(AccountManagerService.TAG, 2)) {
                            Log.v(AccountManagerService.TAG, this.getClass().getSimpleName() + " calling onResult() on response " + response);
                        }
                        Bundle newResult = new Bundle();
                        newResult.putBoolean("booleanResult", result.getBoolean("booleanResult", false));
                        response.onResult(newResult);
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(AccountManagerService.TAG, 2)) break block5;
                        Log.v(AccountManagerService.TAG, "failure while notifying response", e);
                    }
                }
            }
        }

        @Override
        protected String toDebugString(long now) {
            return super.toDebugString(now) + ", hasFeatures" + ", " + this.mAccount + ", " + (this.mFeatures != null ? TextUtils.join((CharSequence)",", this.mFeatures) : null);
        }
    }

    static class UserAccounts {
        private final int userId;
        private final DatabaseHelper openHelper;
        private final HashMap<Pair<Pair<Account, String>, Integer>, Integer> credentialsPermissionNotificationIds = new HashMap();
        private final HashMap<Account, Integer> signinRequiredNotificationIds = new HashMap();
        private final Object cacheLock = new Object();
        private final HashMap<String, Account[]> accountCache = new LinkedHashMap<String, Account[]>();
        private final HashMap<Account, HashMap<String, String>> userDataCache = new HashMap();
        private final HashMap<Account, HashMap<String, String>> authTokenCache = new HashMap();
        private final TokenCache accountTokenCaches = new TokenCache();
        private final HashMap<Account, AtomicReference<String>> previousNameCache = new HashMap();
        private int debugDbInsertionPoint = -1;
        private SQLiteStatement statementForLogging;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        UserAccounts(Context context, int userId) {
            this.userId = userId;
            Object object = this.cacheLock;
            synchronized (object) {
                this.openHelper = new DatabaseHelper(context, userId);
            }
        }
    }
}

