/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityManagerInternal;
import android.app.ActivityManagerNative;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.AppGlobals;
import android.app.ApplicationErrorReport;
import android.app.ApplicationThreadNative;
import android.app.BroadcastOptions;
import android.app.Dialog;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IAppTask;
import android.app.IApplicationThread;
import android.app.IInstrumentationWatcher;
import android.app.INotificationManager;
import android.app.IProcessObserver;
import android.app.IServiceConnection;
import android.app.IStopUserCallback;
import android.app.ITaskStackListener;
import android.app.IUiAutomationConnection;
import android.app.IUidObserver;
import android.app.IUserSwitchObserver;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.ProfilerInfo;
import android.app.admin.DevicePolicyManager;
import android.app.assist.AssistContent;
import android.app.assist.AssistStructure;
import android.app.backup.IBackupManager;
import android.app.usage.UsageStatsManagerInternal;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ComponentName;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ConfigurationInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageManager;
import android.content.pm.InstrumentationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.PathPermission;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.ProxyInfo;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FactoryTest;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IBinder;
import android.os.IPermissionController;
import android.os.IProcessInfoService;
import android.os.IRemoteCallback;
import android.os.IUserManager;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.StrictMode;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os.TransactionTooLargeException;
import android.os.UpdateLock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.os.storage.IMountService;
import android.os.storage.MountServiceInternal;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.DebugUtils;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import android.util.PrintWriterPrinter;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.util.TimeUtils;
import android.util.Xml;
import android.view.LayoutInflater;
import android.view.View;
import android.view.WindowManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.AssistUtils;
import com.android.internal.app.DumpHeapActivity;
import com.android.internal.app.IAppOpsService;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.app.ProcessMap;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.IResultReceiver;
import com.android.internal.os.ProcessCpuTracker;
import com.android.internal.os.TransferPipe;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.MemInfoReader;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.AppOpsService;
import com.android.server.AttributeCache;
import com.android.server.DeviceIdleController;
import com.android.server.IntentResolver;
import com.android.server.LocalServices;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import com.android.server.SystemServiceManager;
import com.android.server.UiThread;
import com.android.server.Watchdog;
import com.android.server.am.ActiveServices;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppErrorDialog;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.AppWaitingForDebuggerDialog;
import com.android.server.am.BackupRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.BatteryStatsService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastQueue;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.CompatModeDialog;
import com.android.server.am.CompatModePackages;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.CoreSettingsObserver;
import com.android.server.am.DumpHeapProvider;
import com.android.server.am.EventLogTags;
import com.android.server.am.FactoryErrorDialog;
import com.android.server.am.LaunchWarningWindow;
import com.android.server.am.NativeCrashListener;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessList;
import com.android.server.am.ProcessMemInfo;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ProviderMap;
import com.android.server.am.ReceiverList;
import com.android.server.am.RecentTasks;
import com.android.server.am.ServiceRecord;
import com.android.server.am.StrictModeViolationDialog;
import com.android.server.am.TaskPersister;
import com.android.server.am.TaskRecord;
import com.android.server.am.UidRecord;
import com.android.server.am.UriPermission;
import com.android.server.am.UriPermissionOwner;
import com.android.server.am.UserState;
import com.android.server.am.UserSwitchingDialog;
import com.android.server.firewall.IntentFirewall;
import com.android.server.pm.Installer;
import com.android.server.pm.UserManagerService;
import com.android.server.statusbar.StatusBarManagerInternal;
import com.android.server.wm.WindowManagerService;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import dalvik.system.VMRuntime;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import libcore.io.IoUtils;
import libcore.util.EmptyArray;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public final class ActivityManagerService
extends ActivityManagerNative
implements Watchdog.Monitor,
BatteryStatsImpl.BatteryCallback {
    static final String CALLED_PRE_BOOTS_FILENAME = "called_pre_boots.dat";
    private static final String TAG = "ActivityManager";
    private static final String TAG_BACKUP = "ActivityManager";
    private static final String TAG_BROADCAST = "ActivityManager";
    private static final String TAG_CLEANUP = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_IMMERSIVE = "ActivityManager";
    private static final String TAG_LOCKSCREEN = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    private static final String TAG_LRU = "ActivityManager";
    private static final String TAG_MU = "ActivityManager_MU";
    private static final String TAG_OOM_ADJ = "ActivityManager";
    private static final String TAG_POWER = "ActivityManager";
    private static final String TAG_PROCESS_OBSERVERS = "ActivityManager";
    private static final String TAG_PROCESSES = "ActivityManager";
    private static final String TAG_PROVIDER = "ActivityManager";
    private static final String TAG_PSS = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_SERVICE = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_UID_OBSERVERS = "ActivityManager";
    private static final String TAG_URI_PERMISSION = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    private static final String TAG_VISIBLE_BEHIND = "ActivityManager";
    static final long BATTERY_STATS_TIME = 1800000L;
    static final boolean MONITOR_CPU_USAGE = true;
    static final long MONITOR_CPU_MIN_TIME = 5000L;
    static final long MONITOR_CPU_MAX_TIME = 0xFFFFFFFL;
    static final boolean MONITOR_THREAD_CPU_USAGE = false;
    static final int STOCK_PM_FLAGS = 1024;
    private static final String SYSTEM_DEBUGGABLE = "ro.debuggable";
    static final boolean IS_USER_BUILD = "user".equals(Build.TYPE);
    static final long APP_SWITCH_DELAY_TIME = 5000L;
    static final int PROC_START_TIMEOUT = 10000;
    static final int PROC_START_TIMEOUT_WITH_WRAPPER = 1200000;
    static final int GC_TIMEOUT = 5000;
    static final int GC_MIN_INTERVAL = 60000;
    static final int FULL_PSS_MIN_INTERVAL = 600000;
    static final int FULL_PSS_LOWERED_INTERVAL = 120000;
    static final int POWER_CHECK_DELAY = 900000;
    static final int WAKE_LOCK_MIN_CHECK_DURATION = 300000;
    static final int CPU_MIN_CHECK_DURATION = 300000;
    static final int BROADCAST_FG_TIMEOUT = 10000;
    static final int BROADCAST_BG_TIMEOUT = 60000;
    static final int KEY_DISPATCHING_TIMEOUT = 5000;
    static final int INSTRUMENTATION_KEY_DISPATCHING_TIMEOUT = 60000;
    static final int USER_SWITCH_TIMEOUT = 2000;
    static final int SERVICE_USAGE_INTERACTION_TIME = 1800000;
    static final int MAX_RUNNING_USERS = 3;
    static final int PENDING_ASSIST_EXTRAS_TIMEOUT = 500;
    static final int PENDING_ASSIST_EXTRAS_LONG_TIMEOUT = 2000;
    static final int MAX_PERSISTED_URI_GRANTS = 128;
    static final int MY_PID = android.os.Process.myPid();
    static final String[] EMPTY_STRING_ARRAY = new String[0];
    static final int DROPBOX_MAX_SIZE = 262144;
    static final int ALLOW_NON_FULL = 0;
    static final int ALLOW_NON_FULL_IN_PROFILE = 1;
    static final int ALLOW_FULL_ONLY = 2;
    static final int LAST_PREBOOT_DELIVERED_FILE_VERSION = 10000;
    static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_DELAY = 1000;
    private static final int PERSISTENT_MASK = 9;
    SystemServiceManager mSystemServiceManager;
    private Installer mInstaller;
    ActivityStackSupervisor mStackSupervisor;
    private RemoteCallbackList<ITaskStackListener> mTaskStackListeners = new RemoteCallbackList();
    public IntentFirewall mIntentFirewall;
    private boolean mShowDialogs = true;
    BroadcastQueue mFgBroadcastQueue;
    BroadcastQueue mBgBroadcastQueue;
    final BroadcastQueue[] mBroadcastQueues = new BroadcastQueue[2];
    ActivityRecord mFocusedActivity = null;
    private int mLastFocusedUserId;
    private AppTimeTracker mCurAppTimeTracker;
    private final RecentTasks mRecentTasks;
    ComponentName mLastAddedTaskComponent;
    int mLastAddedTaskUid;
    ActivityInfo mLastAddedTaskActivity;
    SparseArray<String[]> mLockTaskPackages = new SparseArray();
    String mDeviceOwnerName;
    final ArrayList<PendingAssistExtras> mPendingAssistExtras = new ArrayList();
    final ProcessList mProcessList = new ProcessList();
    final ProcessMap<ProcessRecord> mProcessNames = new ProcessMap();
    final ProcessStatsService mProcessStats;
    final SparseArray<ProcessRecord> mIsolatedProcesses = new SparseArray();
    int mNextIsolatedProcessUid = 0;
    ProcessRecord mHeavyWeightProcess = null;
    final ProcessMap<Long> mProcessCrashTimes = new ProcessMap();
    final ProcessMap<BadProcessInfo> mBadProcesses = new ProcessMap();
    final SparseArray<ProcessRecord> mPidsSelfLocked = new SparseArray();
    final SparseArray<ForegroundToken> mForegroundProcesses = new SparseArray();
    final ArrayList<ProcessRecord> mProcessesOnHold = new ArrayList();
    final ArrayList<ProcessRecord> mPersistentStartingProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mRemovedProcesses = new ArrayList();
    final ArrayList<ProcessRecord> mLruProcesses = new ArrayList();
    int mLruProcessActivityStart = 0;
    int mLruProcessServiceStart = 0;
    final ArrayList<ProcessRecord> mProcessesToGc = new ArrayList();
    final ArrayList<ProcessRecord> mPendingPssProcesses = new ArrayList();
    long mLastFullPssTime = SystemClock.uptimeMillis();
    boolean mFullPssPending = false;
    ProcessRecord mHomeProcess;
    ProcessRecord mPreviousProcess;
    long mPreviousProcessVisibleTime;
    final SparseArray<UidRecord> mActiveUids = new SparseArray();
    final SparseArray<UserState> mStartedUsers = new SparseArray();
    final ArrayList<Integer> mUserLru = new ArrayList();
    int[] mStartedUserArray = new int[]{0};
    final RemoteCallbackList<IUserSwitchObserver> mUserSwitchObservers = new RemoteCallbackList();
    Object mCurUserSwitchCallback;
    final CompatModePackages mCompatModePackages;
    final HashMap<PendingIntentRecord.Key, WeakReference<PendingIntentRecord>> mIntentSenderRecords = new HashMap();
    private final HashSet<Integer> mAlreadyLoggedViolatedStacks = new HashSet();
    private static final int MAX_DUP_SUPPRESSED_STACKS = 5000;
    private final StringBuilder mStrictModeBuffer = new StringBuilder();
    final HashMap<IBinder, ReceiverList> mRegisteredReceivers = new HashMap();
    final IntentResolver<BroadcastFilter, BroadcastFilter> mReceiverResolver = new IntentResolver<BroadcastFilter, BroadcastFilter>(){

        @Override
        protected boolean allowFilterResult(BroadcastFilter filter, List<BroadcastFilter> dest) {
            IBinder target = filter.receiverList.receiver.asBinder();
            for (int i = dest.size() - 1; i >= 0; --i) {
                if (dest.get((int)i).receiverList.receiver.asBinder() != target) continue;
                return false;
            }
            return true;
        }

        @Override
        protected BroadcastFilter newResult(BroadcastFilter filter, int match, int userId) {
            if (userId == -1 || filter.owningUserId == -1 || userId == filter.owningUserId) {
                return (BroadcastFilter)super.newResult(filter, match, userId);
            }
            return null;
        }

        protected BroadcastFilter[] newArray(int size) {
            return new BroadcastFilter[size];
        }

        @Override
        protected boolean isPackageForFilter(String packageName, BroadcastFilter filter) {
            return packageName.equals(filter.packageName);
        }
    };
    final SparseArray<ArrayMap<String, ArrayList<Intent>>> mStickyBroadcasts = new SparseArray();
    final ActiveServices mServices;
    final SparseArray<ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>>> mAssociations = new SparseArray();
    boolean mTrackingAssociations;
    String mBackupAppName = null;
    BackupRecord mBackupTarget = null;
    final ProviderMap mProviderMap;
    final ArrayList<ContentProviderRecord> mLaunchingProviders = new ArrayList();
    private final AtomicFile mGrantFile;
    private static final String TAG_URI_GRANTS = "uri-grants";
    private static final String TAG_URI_GRANT = "uri-grant";
    private static final String ATTR_USER_HANDLE = "userHandle";
    private static final String ATTR_SOURCE_USER_ID = "sourceUserId";
    private static final String ATTR_TARGET_USER_ID = "targetUserId";
    private static final String ATTR_SOURCE_PKG = "sourcePkg";
    private static final String ATTR_TARGET_PKG = "targetPkg";
    private static final String ATTR_URI = "uri";
    private static final String ATTR_MODE_FLAGS = "modeFlags";
    private static final String ATTR_CREATED_TIME = "createdTime";
    private static final String ATTR_PREFIX = "prefix";
    @GuardedBy(value="this")
    private final SparseArray<ArrayMap<GrantUri, UriPermission>> mGrantedUriPermissions = new SparseArray();
    CoreSettingsObserver mCoreSettingsObserver;
    private static final ThreadLocal<Identity> sCallerIdentity = new ThreadLocal();
    final BatteryStatsService mBatteryStatsService;
    UsageStatsManagerInternal mUsageStatsService;
    DeviceIdleController.LocalService mLocalDeviceIdleController;
    final AppOpsService mAppOpsService;
    final TaskPersister mTaskPersister;
    Configuration mConfiguration = new Configuration();
    int mConfigurationSeq = 0;
    final int GL_ES_VERSION;
    HashMap<String, IBinder> mAppBindArgs;
    final StringBuilder mStringBuilder = new StringBuilder(256);
    ComponentName mTopComponent;
    String mTopAction = "android.intent.action.MAIN";
    String mTopData;
    boolean mProcessesReady = false;
    boolean mSystemReady = false;
    boolean mBooting = false;
    boolean mCallFinishBooting = false;
    boolean mBootAnimationComplete = false;
    boolean mWaitingUpdate = false;
    boolean mDidUpdate = false;
    boolean mOnBattery = false;
    boolean mLaunchWarningShown = false;
    Context mContext;
    int mFactoryTest;
    boolean mCheckedForSetup;
    long mAppSwitchesAllowedTime;
    boolean mDidAppSwitch;
    long mLastPowerCheckRealtime;
    long mLastPowerCheckUptime;
    private boolean mSleeping = false;
    int mTopProcessState = 2;
    private IVoiceInteractionSession mRunningVoice;
    PowerManagerInternal mLocalPowerManager;
    PowerManager.WakeLock mVoiceWakeLock;
    private int mWakefulness = 1;
    final ArrayList<ActivityManagerInternal.SleepToken> mSleepTokens = new ArrayList();
    static final int LOCK_SCREEN_HIDDEN = 0;
    static final int LOCK_SCREEN_LEAVING = 1;
    static final int LOCK_SCREEN_SHOWN = 2;
    int mLockScreenShown = 0;
    boolean mShuttingDown = false;
    int mAdjSeq = 0;
    int mLruSeq = 0;
    int mNumNonCachedProcs = 0;
    int mNumCachedHiddenProcs = 0;
    int mNumServiceProcs = 0;
    int mNewNumAServiceProcs = 0;
    int mNewNumServiceProcs = 0;
    boolean mAllowLowerMemLevel = false;
    int mLastMemoryLevel = 0;
    int mLastNumProcesses;
    long mLastIdleTime = SystemClock.uptimeMillis();
    long mLowRamTimeSinceLastIdle = 0L;
    long mLowRamStartTime = 0L;
    private String mCurResumedPackage = null;
    private int mCurResumedUid = -1;
    final ProcessMap<ArrayList<ProcessRecord>> mForegroundPackages = new ProcessMap();
    boolean mDidDexOpt;
    boolean mSafeMode;
    boolean mTestPssMode = false;
    String mDebugApp = null;
    boolean mWaitForDebugger = false;
    boolean mDebugTransient = false;
    String mOrigDebugApp = null;
    boolean mOrigWaitForDebugger = false;
    boolean mAlwaysFinishActivities = false;
    IActivityController mController = null;
    String mProfileApp = null;
    ProcessRecord mProfileProc = null;
    String mProfileFile;
    ParcelFileDescriptor mProfileFd;
    int mSamplingInterval = 0;
    boolean mAutoStopProfiler = false;
    int mProfileType = 0;
    String mOpenGlTraceApp = null;
    final ProcessMap<Pair<Long, String>> mMemWatchProcesses = new ProcessMap();
    String mMemWatchDumpProcName;
    String mMemWatchDumpFile;
    int mMemWatchDumpPid;
    int mMemWatchDumpUid;
    final long[] mTmpLong = new long[1];
    final RemoteCallbackList<IProcessObserver> mProcessObservers = new RemoteCallbackList();
    ProcessChangeItem[] mActiveProcessChanges = new ProcessChangeItem[5];
    final ArrayList<ProcessChangeItem> mPendingProcessChanges = new ArrayList();
    final ArrayList<ProcessChangeItem> mAvailProcessChanges = new ArrayList();
    final RemoteCallbackList<IUidObserver> mUidObservers = new RemoteCallbackList();
    UidRecord.ChangeItem[] mActiveUidChanges = new UidRecord.ChangeItem[5];
    final ArrayList<UidRecord.ChangeItem> mPendingUidChanges = new ArrayList();
    final ArrayList<UidRecord.ChangeItem> mAvailUidChanges = new ArrayList();
    final Thread mProcessCpuThread;
    final ProcessCpuTracker mProcessCpuTracker = new ProcessCpuTracker(false);
    final AtomicLong mLastCpuTime = new AtomicLong(0L);
    final AtomicBoolean mProcessCpuMutexFree = new AtomicBoolean(true);
    long mLastWriteTime = 0L;
    final UpdateLock mUpdateLock = new UpdateLock("immersive");
    boolean mBooted = false;
    int mProcessLimit = 32;
    int mProcessLimitOverride = -1;
    WindowManagerService mWindowManager;
    final ActivityThread mSystemThread;
    int mCurrentUserId = 0;
    int mTargetUserId = -10000;
    int[] mCurrentProfileIds = new int[]{0};
    SparseIntArray mUserProfileGroupIdsSelfLocked = new SparseIntArray();
    private UserManagerService mUserManager;
    static final int SHOW_ERROR_MSG = 1;
    static final int SHOW_NOT_RESPONDING_MSG = 2;
    static final int SHOW_FACTORY_ERROR_MSG = 3;
    static final int UPDATE_CONFIGURATION_MSG = 4;
    static final int GC_BACKGROUND_PROCESSES_MSG = 5;
    static final int WAIT_FOR_DEBUGGER_MSG = 6;
    static final int SERVICE_TIMEOUT_MSG = 12;
    static final int UPDATE_TIME_ZONE = 13;
    static final int SHOW_UID_ERROR_MSG = 14;
    static final int SHOW_FINGERPRINT_ERROR_MSG = 15;
    static final int PROC_START_TIMEOUT_MSG = 20;
    static final int DO_PENDING_ACTIVITY_LAUNCHES_MSG = 21;
    static final int KILL_APPLICATION_MSG = 22;
    static final int FINALIZE_PENDING_INTENT_MSG = 23;
    static final int POST_HEAVY_NOTIFICATION_MSG = 24;
    static final int CANCEL_HEAVY_NOTIFICATION_MSG = 25;
    static final int SHOW_STRICT_MODE_VIOLATION_MSG = 26;
    static final int CHECK_EXCESSIVE_WAKE_LOCKS_MSG = 27;
    static final int CLEAR_DNS_CACHE_MSG = 28;
    static final int UPDATE_HTTP_PROXY_MSG = 29;
    static final int SHOW_COMPAT_MODE_DIALOG_MSG = 30;
    static final int DISPATCH_PROCESSES_CHANGED = 31;
    static final int DISPATCH_PROCESS_DIED = 32;
    static final int REPORT_MEM_USAGE_MSG = 33;
    static final int REPORT_USER_SWITCH_MSG = 34;
    static final int CONTINUE_USER_SWITCH_MSG = 35;
    static final int USER_SWITCH_TIMEOUT_MSG = 36;
    static final int IMMERSIVE_MODE_LOCK_MSG = 37;
    static final int PERSIST_URI_GRANTS_MSG = 38;
    static final int REQUEST_ALL_PSS_MSG = 39;
    static final int START_PROFILES_MSG = 40;
    static final int UPDATE_TIME = 41;
    static final int SYSTEM_USER_START_MSG = 42;
    static final int SYSTEM_USER_CURRENT_MSG = 43;
    static final int ENTER_ANIMATION_COMPLETE_MSG = 44;
    static final int FINISH_BOOTING_MSG = 45;
    static final int START_USER_SWITCH_MSG = 46;
    static final int SEND_LOCALE_TO_MOUNT_DAEMON_MSG = 47;
    static final int DISMISS_DIALOG_MSG = 48;
    static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_MSG = 49;
    static final int NOTIFY_CLEARTEXT_NETWORK_MSG = 50;
    static final int POST_DUMP_HEAP_NOTIFICATION_MSG = 51;
    static final int DELETE_DUMPHEAP_MSG = 52;
    static final int FOREGROUND_PROFILE_CHANGED_MSG = 53;
    static final int DISPATCH_UIDS_CHANGED_MSG = 54;
    static final int REPORT_TIME_TRACKER_MSG = 55;
    static final int REPORT_USER_SWITCH_COMPLETE_MSG = 56;
    static final int SHUTDOWN_UI_AUTOMATION_CONNECTION_MSG = 57;
    static final int FIRST_ACTIVITY_STACK_MSG = 100;
    static final int FIRST_BROADCAST_QUEUE_MSG = 200;
    static final int FIRST_COMPAT_MODE_MSG = 300;
    static final int FIRST_SUPERVISOR_STACK_MSG = 100;
    CompatModeDialog mCompatModeDialog;
    long mLastMemUsageReportTime = 0L;
    private boolean mUserIsMonkey;
    boolean mHasRecents;
    int mThumbnailWidth;
    int mThumbnailHeight;
    final ServiceThread mHandlerThread;
    final MainHandler mHandler;
    final UiHandler mUiHandler;
    static final int COLLECT_PSS_BG_MSG = 1;
    final Handler mBgHandler = new Handler(BackgroundThread.getHandler().getLooper()){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    long start = SystemClock.uptimeMillis();
                    MemInfoReader memInfo = null;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    // MONITORENTER : activityManagerService
                    if (ActivityManagerService.this.mFullPssPending) {
                        ActivityManagerService.this.mFullPssPending = false;
                        memInfo = new MemInfoReader();
                    }
                    // MONITOREXIT : activityManagerService
                    if (memInfo != null) {
                        ActivityManagerService.this.updateCpuStatsNow();
                        long nativeTotalPss = 0L;
                        Object object = ActivityManagerService.this.mProcessCpuTracker;
                        // MONITORENTER : object
                        int N = ActivityManagerService.this.mProcessCpuTracker.countStats();
                        for (int j = 0; j < N; ++j) {
                            ProcessCpuTracker.Stats st = ActivityManagerService.this.mProcessCpuTracker.getStats(j);
                            if (st.vsize <= 0L || st.uid >= 10000) continue;
                            SparseArray<ProcessRecord> sparseArray = ActivityManagerService.this.mPidsSelfLocked;
                            // MONITORENTER : sparseArray
                            if (ActivityManagerService.this.mPidsSelfLocked.indexOfKey(st.pid) >= 0) {
                                // MONITOREXIT : sparseArray
                                continue;
                            }
                            // MONITOREXIT : sparseArray
                            nativeTotalPss += Debug.getPss(st.pid, null, null);
                        }
                        // MONITOREXIT : object
                        memInfo.readMemInfo();
                        object = ActivityManagerService.this;
                        // MONITORENTER : object
                        long cachedKb = memInfo.getCachedSizeKb();
                        long freeKb = memInfo.getFreeSizeKb();
                        long zramKb = memInfo.getZramTotalSizeKb();
                        long kernelKb = memInfo.getKernelUsedSizeKb();
                        EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeTotalPss * 1024L);
                        ActivityManagerService.this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeTotalPss);
                        // MONITOREXIT : object
                    }
                    int num = 0;
                    long[] tmp = new long[1];
                    while (true) {
                        int pid;
                        ActivityManagerService zramKb = ActivityManagerService.this;
                        // MONITORENTER : zramKb
                        if (ActivityManagerService.this.mPendingPssProcesses.size() <= 0) {
                            if (ActivityManagerService.this.mTestPssMode) {
                                Slog.d("ActivityManager", "Collected PSS of " + num + " processes in " + (SystemClock.uptimeMillis() - start) + "ms");
                            }
                            ActivityManagerService.this.mPendingPssProcesses.clear();
                            // MONITOREXIT : zramKb
                            return;
                        }
                        ProcessRecord proc = ActivityManagerService.this.mPendingPssProcesses.remove(0);
                        int procState = proc.pssProcState;
                        long lastPssTime = proc.lastPssTime;
                        if (proc.thread != null && procState == proc.setProcState && lastPssTime + 1000L < SystemClock.uptimeMillis()) {
                            pid = proc.pid;
                        } else {
                            proc = null;
                            pid = 0;
                        }
                        // MONITOREXIT : zramKb
                        if (proc == null) continue;
                        long pss = Debug.getPss(pid, tmp, null);
                        ActivityManagerService activityManagerService2 = ActivityManagerService.this;
                        // MONITORENTER : activityManagerService2
                        if (pss != 0L && proc.thread != null && proc.setProcState == procState && proc.pid == pid && proc.lastPssTime == lastPssTime) {
                            ++num;
                            ActivityManagerService.this.recordPssSampleLocked(proc, procState, pss, tmp[0], SystemClock.uptimeMillis());
                        }
                        // MONITOREXIT : activityManagerService2
                    }
                }
            }
        }
    };
    static final long[] DUMP_MEM_BUCKETS = new long[]{5120L, 7168L, 10240L, 15360L, 20480L, 30720L, 40960L, 81920L, 122880L, 163840L, 204800L, 256000L, 307200L, 358400L, 409600L, 512000L, 614400L, 819200L, 0x100000L, 0x200000L, 0x500000L, 0xA00000L, 0x1400000L};
    static final int[] DUMP_MEM_OOM_ADJ = new int[]{-17, -16, -12, -11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 15};
    static final String[] DUMP_MEM_OOM_LABEL = new String[]{"Native", "System", "Persistent", "Persistent Service", "Foreground", "Visible", "Perceptible", "Heavy Weight", "Backup", "A Services", "Home", "Previous", "B Services", "Cached"};
    static final String[] DUMP_MEM_OOM_COMPACT_LABEL = new String[]{"native", "sys", "pers", "persvc", "fore", "vis", "percept", "heavy", "backup", "servicea", "home", "prev", "serviceb", "cached"};
    private static final int KSM_SHARED = 0;
    private static final int KSM_SHARING = 1;
    private static final int KSM_UNSHARED = 2;
    private static final int KSM_VOLATILE = 3;

    BroadcastQueue broadcastQueueForIntent(Intent intent) {
        boolean isFg = (intent.getFlags() & 0x10000000) != 0;
        return isFg ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemProcess() {
        try {
            ServiceManager.addService("activity", this, true);
            ServiceManager.addService("procstats", this.mProcessStats);
            ServiceManager.addService("meminfo", new MemBinder(this));
            ServiceManager.addService("gfxinfo", new GraphicsBinder(this));
            ServiceManager.addService("dbinfo", new DbBinder(this));
            ServiceManager.addService("cpuinfo", new CpuBinder(this));
            ServiceManager.addService("permission", new PermissionController(this));
            ServiceManager.addService("processinfo", new ProcessInfoService(this));
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo("android", 1024);
            this.mSystemThread.installSystemApplicationInfo(info, this.getClass().getClassLoader());
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.newProcessRecordLocked(info, info.processName, false, 0);
                app.persistent = true;
                app.pid = MY_PID;
                app.maxAdj = -16;
                app.makeActive(this.mSystemThread.getApplicationThread(), this.mProcessStats);
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    this.mPidsSelfLocked.put(app.pid, app);
                }
                this.updateLruProcessLocked(app, false, null);
                this.updateOomAdjLocked();
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Unable to find android system package", e);
        }
    }

    public void setWindowManager(WindowManagerService wm) {
        this.mWindowManager = wm;
        this.mStackSupervisor.setWindowManager(wm);
    }

    public void setUsageStatsManager(UsageStatsManagerInternal usageStatsManager) {
        this.mUsageStatsService = usageStatsManager;
    }

    public void startObservingNativeCrashes() {
        NativeCrashListener ncl = new NativeCrashListener(this);
        ncl.start();
    }

    public IAppOpsService getAppOpsService() {
        return this.mAppOpsService;
    }

    public ActivityManagerService(Context systemContext) {
        this.mContext = systemContext;
        this.mFactoryTest = FactoryTest.getMode();
        this.mSystemThread = ActivityThread.currentActivityThread();
        Slog.i("ActivityManager", "Memory class: " + ActivityManager.staticGetMemoryClass());
        this.mHandlerThread = new ServiceThread("ActivityManager", -2, false);
        this.mHandlerThread.start();
        this.mHandler = new MainHandler(this.mHandlerThread.getLooper());
        this.mUiHandler = new UiHandler();
        this.mFgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "foreground", 10000L, false);
        this.mBgBroadcastQueue = new BroadcastQueue(this, this.mHandler, "background", 60000L, true);
        this.mBroadcastQueues[0] = this.mFgBroadcastQueue;
        this.mBroadcastQueues[1] = this.mBgBroadcastQueue;
        this.mServices = new ActiveServices(this);
        this.mProviderMap = new ProviderMap(this);
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        systemDir.mkdirs();
        this.mBatteryStatsService = new BatteryStatsService(systemDir, this.mHandler);
        this.mBatteryStatsService.getActiveStatistics().readLocked();
        this.mBatteryStatsService.scheduleWriteToDisk();
        this.mOnBattery = this.mBatteryStatsService.getActiveStatistics().getIsOnBattery();
        this.mBatteryStatsService.getActiveStatistics().setCallback(this);
        this.mProcessStats = new ProcessStatsService(this, new File(systemDir, "procstats"));
        this.mAppOpsService = new AppOpsService(new File(systemDir, "appops.xml"), this.mHandler);
        this.mGrantFile = new AtomicFile(new File(systemDir, "urigrants.xml"));
        this.mStartedUsers.put(0, new UserState(UserHandle.OWNER, true));
        this.mUserLru.add(0);
        this.updateStartedUserArrayLocked();
        this.GL_ES_VERSION = SystemProperties.getInt("ro.opengles.version", 0);
        this.mTrackingAssociations = "1".equals(SystemProperties.get("debug.track-associations"));
        this.mConfiguration.setToDefaults();
        this.mConfiguration.setLocale(Locale.getDefault());
        this.mConfiguration.seq = 1;
        this.mConfigurationSeq = 1;
        this.mProcessCpuTracker.init();
        this.mCompatModePackages = new CompatModePackages(this, systemDir, this.mHandler);
        this.mIntentFirewall = new IntentFirewall(new IntentFirewallInterface(), this.mHandler);
        this.mRecentTasks = new RecentTasks(this);
        this.mStackSupervisor = new ActivityStackSupervisor(this, this.mRecentTasks);
        this.mTaskPersister = new TaskPersister(systemDir, this.mStackSupervisor, this.mRecentTasks);
        this.mProcessCpuThread = new Thread("CpuTracker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            try {
                                3 var1_1 = this;
                                synchronized (var1_1) {
                                    long now = SystemClock.uptimeMillis();
                                    long nextCpuDelay = ActivityManagerService.this.mLastCpuTime.get() + 0xFFFFFFFL - now;
                                    long nextWriteDelay = ActivityManagerService.this.mLastWriteTime + 1800000L - now;
                                    if (nextWriteDelay < nextCpuDelay) {
                                        nextCpuDelay = nextWriteDelay;
                                    }
                                    if (nextCpuDelay > 0L) {
                                        ActivityManagerService.this.mProcessCpuMutexFree.set(true);
                                        this.wait(nextCpuDelay);
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            ActivityManagerService.this.updateCpuStatsNow();
                        }
                    }
                    catch (Exception e) {
                        Slog.e("ActivityManager", "Unexpected exception collecting process stats", e);
                        continue;
                    }
                    break;
                }
            }
        };
        Watchdog.getInstance().addMonitor(this);
        Watchdog.getInstance().addThread(this.mHandler);
    }

    public void setSystemServiceManager(SystemServiceManager mgr) {
        this.mSystemServiceManager = mgr;
    }

    public void setInstaller(Installer installer) {
        this.mInstaller = installer;
    }

    private void start() {
        android.os.Process.removeAllProcessGroups();
        this.mProcessCpuThread.start();
        this.mBatteryStatsService.publish(this.mContext);
        this.mAppOpsService.publish(this.mContext);
        Slog.d("AppOps", "AppOpsService published");
        LocalServices.addService(ActivityManagerInternal.class, new LocalService());
    }

    public void initPowerManagement() {
        this.mStackSupervisor.initPowerManagement();
        this.mBatteryStatsService.initPowerManagement();
        this.mLocalPowerManager = LocalServices.getService(PowerManagerInternal.class);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mVoiceWakeLock = pm.newWakeLock(1, "*voice*");
        this.mVoiceWakeLock.setReferenceCounted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        if (code == 1599295570) {
            ArrayList<IBinder> procs = new ArrayList<IBinder>();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.thread == null) continue;
                        procs.add(app.thread.asBinder());
                    }
                }
            }
            int N = procs.size();
            for (int i = 0; i < N; ++i) {
                Parcel data2 = Parcel.obtain();
                try {
                    ((IBinder)procs.get(i)).transact(1599295570, data2, null, 0);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                data2.recycle();
            }
        }
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf("ActivityManager", "Activity Manager Crash", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStats() {
        long now = SystemClock.uptimeMillis();
        if (this.mLastCpuTime.get() >= now - 5000L) {
            return;
        }
        if (this.mProcessCpuMutexFree.compareAndSet(true, false)) {
            Thread thread = this.mProcessCpuThread;
            synchronized (thread) {
                this.mProcessCpuThread.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCpuStatsNow() {
        ProcessCpuTracker processCpuTracker = this.mProcessCpuTracker;
        synchronized (processCpuTracker) {
            BatteryStatsImpl bstats;
            this.mProcessCpuMutexFree.set(false);
            long now = SystemClock.uptimeMillis();
            boolean haveNewCpuStats = false;
            if (this.mLastCpuTime.get() < now - 5000L) {
                this.mLastCpuTime.set(now);
                this.mProcessCpuTracker.update();
                if (this.mProcessCpuTracker.hasGoodLastStats()) {
                    haveNewCpuStats = true;
                    if ("true".equals(SystemProperties.get("events.cpu"))) {
                        int idle;
                        int softIrq;
                        int irq;
                        int iowait;
                        int system;
                        int user = this.mProcessCpuTracker.getLastUserTime();
                        int total = user + (system = this.mProcessCpuTracker.getLastSystemTime()) + (iowait = this.mProcessCpuTracker.getLastIoWaitTime()) + (irq = this.mProcessCpuTracker.getLastIrqTime()) + (softIrq = this.mProcessCpuTracker.getLastSoftIrqTime()) + (idle = this.mProcessCpuTracker.getLastIdleTime());
                        if (total == 0) {
                            total = 1;
                        }
                        EventLog.writeEvent(2721, (user + system + iowait + irq + softIrq) * 100 / total, user * 100 / total, system * 100 / total, iowait * 100 / total, irq * 100 / total, softIrq * 100 / total);
                    }
                }
            }
            BatteryStatsImpl batteryStatsImpl = bstats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    if (haveNewCpuStats && bstats.startAddingCpuLocked()) {
                        int totalUTime = 0;
                        int totalSTime = 0;
                        int N = this.mProcessCpuTracker.countStats();
                        for (int i = 0; i < N; ++i) {
                            BatteryStatsImpl.Uid.Proc ps;
                            ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                            if (!st.working) continue;
                            ProcessRecord pr = this.mPidsSelfLocked.get(st.pid);
                            totalUTime += st.rel_utime;
                            totalSTime += st.rel_stime;
                            if (pr != null) {
                                ps = pr.curProcBatteryStats;
                                if (ps == null || !ps.isActive()) {
                                    pr.curProcBatteryStats = ps = bstats.getProcessStatsLocked(pr.info.uid, pr.processName);
                                }
                                ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                                pr.curCpuTime += (long)(st.rel_utime + st.rel_stime);
                                continue;
                            }
                            ps = st.batteryStats;
                            if (ps == null || !ps.isActive()) {
                                st.batteryStats = ps = bstats.getProcessStatsLocked(bstats.mapUid(st.uid), st.name);
                            }
                            ps.addCpuTimeLocked(st.rel_utime, st.rel_stime);
                        }
                        int userTime = this.mProcessCpuTracker.getLastUserTime();
                        int systemTime = this.mProcessCpuTracker.getLastSystemTime();
                        int iowaitTime = this.mProcessCpuTracker.getLastIoWaitTime();
                        int irqTime = this.mProcessCpuTracker.getLastIrqTime();
                        int softIrqTime = this.mProcessCpuTracker.getLastSoftIrqTime();
                        int idleTime = this.mProcessCpuTracker.getLastIdleTime();
                        bstats.finishAddingCpuLocked(totalUTime, totalSTime, userTime, systemTime, iowaitTime, irqTime, softIrqTime, idleTime);
                    }
                }
                if (this.mLastWriteTime < now - 1800000L) {
                    this.mLastWriteTime = now;
                    this.mBatteryStatsService.scheduleWriteToDisk();
                }
            }
        }
    }

    @Override
    public void batteryNeedsCpuUpdate() {
        this.updateCpuStatsNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void batteryPowerChanged(boolean onBattery) {
        this.updateCpuStatsNow();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mOnBattery = onBattery;
            }
        }
    }

    @Override
    public void batterySendBroadcast(Intent intent) {
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, -1);
    }

    private HashMap<String, IBinder> getCommonServicesLocked(boolean isolated) {
        if (this.mAppBindArgs == null) {
            this.mAppBindArgs = new HashMap();
            if (!isolated) {
                this.mAppBindArgs.put("package", ServiceManager.getService("package"));
                this.mAppBindArgs.put("window", ServiceManager.getService("window"));
                this.mAppBindArgs.put("alarm", ServiceManager.getService("alarm"));
            }
        }
        return this.mAppBindArgs;
    }

    final void setFocusedActivityLocked(ActivityRecord r, String reason) {
        if (r != null && this.mFocusedActivity != r) {
            ActivityRecord last = this.mFocusedActivity;
            this.mFocusedActivity = r;
            if (r.task.taskType != 1 && r.task.taskType != 2) {
                if (this.mCurAppTimeTracker != r.appTimeTracker) {
                    if (this.mCurAppTimeTracker != null) {
                        this.mCurAppTimeTracker.stop();
                        this.mHandler.obtainMessage(55, this.mCurAppTimeTracker).sendToTarget();
                        this.mStackSupervisor.clearOtherAppTimeTrackers(r.appTimeTracker);
                        this.mCurAppTimeTracker = null;
                    }
                    if (r.appTimeTracker != null) {
                        this.mCurAppTimeTracker = r.appTimeTracker;
                        this.startTimeTrackingFocusedActivityLocked();
                    }
                } else {
                    this.startTimeTrackingFocusedActivityLocked();
                }
            } else {
                r.appTimeTracker = null;
            }
            if (r.task != null && r.task.voiceInteractor != null) {
                this.startRunningVoiceLocked(r.task.voiceSession, r.info.applicationInfo.uid);
            } else {
                this.finishRunningVoiceLocked();
                if (last != null && last.task.voiceSession != null) {
                    this.finishVoiceTask(last.task.voiceSession);
                }
            }
            if (this.mStackSupervisor.setFocusedStack(r, reason + " setFocusedActivity")) {
                this.mWindowManager.setFocusedApp(r.appToken, true);
            }
            this.applyUpdateLockStateLocked(r);
            if (this.mFocusedActivity.userId != this.mLastFocusedUserId) {
                this.mHandler.removeMessages(53);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(53, this.mFocusedActivity.userId, 0));
                this.mLastFocusedUserId = this.mFocusedActivity.userId;
            }
        }
        EventLog.writeEvent(30043, this.mFocusedActivity == null ? -1 : this.mFocusedActivity.userId, this.mFocusedActivity == null ? "NULL" : this.mFocusedActivity.shortComponentName);
    }

    final void clearFocusedActivity(ActivityRecord r) {
        if (this.mFocusedActivity == r) {
            ActivityRecord top;
            ActivityStack stack = this.mStackSupervisor.getFocusedStack();
            if (stack != null && (top = stack.topActivity()) != null && top.userId != this.mLastFocusedUserId) {
                this.mHandler.removeMessages(53);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(53, top.userId, 0));
                this.mLastFocusedUserId = top.userId;
            }
            this.mFocusedActivity = null;
            EventLog.writeEvent(30043, -1, "NULL");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFocusedStack(int stackId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r;
            ActivityStack stack = this.mStackSupervisor.getStack(stackId);
            if (stack != null && (r = stack.topRunningActivityLocked(null)) != null) {
                this.setFocusedActivityLocked(r, "setFocusedStack");
                this.mStackSupervisor.resumeTopActivitiesLocked(stack, null, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerTaskStackListener(ITaskStackListener listener) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (listener != null) {
                this.mTaskStackListeners.register(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyActivityDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.mStackSupervisor.isInAnyStackLocked(token);
            if (r != null) {
                r.task.stack.notifyActivityDrawnLocked(r);
            }
        }
    }

    final void applyUpdateLockStateLocked(ActivityRecord r) {
        boolean nextState = r != null && r.immersive;
        this.mHandler.sendMessage(this.mHandler.obtainMessage(37, nextState ? 1 : 0, 0, r));
    }

    final void showAskCompatModeDialogLocked(ActivityRecord r) {
        Message msg = Message.obtain();
        msg.what = 30;
        msg.obj = r.task.askedCompatMode ? null : r;
        this.mUiHandler.sendMessage(msg);
    }

    private int updateLruProcessInternalLocked(ProcessRecord app, long now, int index, String what, Object obj, ProcessRecord srcApp) {
        app.lastActivityTime = now;
        if (app.activities.size() > 0) {
            return index;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui < 0) {
            Slog.wtf("ActivityManager", "Adding dependent process " + app + " not on LRU list: " + what + " " + obj + " from " + srcApp);
            return index;
        }
        if (lrui >= index) {
            return index;
        }
        if (lrui >= this.mLruProcessActivityStart) {
            return index;
        }
        this.mLruProcesses.remove(lrui);
        if (index > 0) {
            --index;
        }
        this.mLruProcesses.add(index, app);
        return index;
    }

    private static void killProcessGroup(int uid, int pid) {
        Trace.traceBegin(64L, "killProcessGroup");
        android.os.Process.killProcessGroup(uid, pid);
        Trace.traceEnd(64L);
    }

    final void removeLruProcessLocked(ProcessRecord app) {
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (lrui >= 0) {
            if (!app.killed) {
                Slog.wtfStack("ActivityManager", "Removing process that hasn't been killed: " + app);
                android.os.Process.killProcessQuiet(app.pid);
                ActivityManagerService.killProcessGroup(app.info.uid, app.pid);
            }
            if (lrui <= this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui <= this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
    }

    final void updateLruProcessLocked(ProcessRecord app, boolean activityChange, ProcessRecord client) {
        int j;
        int nextIndex;
        int N;
        long now;
        boolean hasActivity = app.activities.size() > 0 || app.hasClientActivities || app.treatLikeActivity;
        boolean hasService = false;
        if (!activityChange && hasActivity) {
            return;
        }
        ++this.mLruSeq;
        app.lastActivityTime = now = SystemClock.uptimeMillis();
        if (hasActivity ? (N = this.mLruProcesses.size()) > 0 && this.mLruProcesses.get(N - 1) == app : this.mLruProcessServiceStart > 0 && this.mLruProcesses.get(this.mLruProcessServiceStart - 1) == app) {
            return;
        }
        int lrui = this.mLruProcesses.lastIndexOf(app);
        if (app.persistent && lrui >= 0) {
            return;
        }
        if (lrui >= 0) {
            if (lrui < this.mLruProcessActivityStart) {
                --this.mLruProcessActivityStart;
            }
            if (lrui < this.mLruProcessServiceStart) {
                --this.mLruProcessServiceStart;
            }
            this.mLruProcesses.remove(lrui);
        }
        if (hasActivity) {
            int N2 = this.mLruProcesses.size();
            if (app.activities.size() == 0 && this.mLruProcessActivityStart < N2 - 1) {
                this.mLruProcesses.add(N2 - 1, app);
                int uid = app.info.uid;
                for (int i = N2 - 2; i > this.mLruProcessActivityStart; --i) {
                    ProcessRecord subProc = this.mLruProcesses.get(i);
                    if (subProc.info.uid == uid) {
                        if (this.mLruProcesses.get((int)(i - 1)).info.uid == uid) continue;
                        ProcessRecord tmp = this.mLruProcesses.get(i);
                        this.mLruProcesses.set(i, this.mLruProcesses.get(i - 1));
                        this.mLruProcesses.set(i - 1, tmp);
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                this.mLruProcesses.add(app);
            }
            nextIndex = this.mLruProcessServiceStart;
        } else {
            int index = this.mLruProcessServiceStart;
            if (client != null) {
                int clientIndex = this.mLruProcesses.lastIndexOf(client);
                if (clientIndex <= lrui) {
                    clientIndex = lrui;
                }
                if (clientIndex >= 0 && index > clientIndex) {
                    index = clientIndex;
                }
            }
            this.mLruProcesses.add(index, app);
            nextIndex = index - 1;
            ++this.mLruProcessActivityStart;
            ++this.mLruProcessServiceStart;
        }
        for (j = app.connections.size() - 1; j >= 0; --j) {
            ConnectionRecord cr = app.connections.valueAt(j);
            if (cr.binding == null || cr.serviceDead || cr.binding.service == null || cr.binding.service.app == null || cr.binding.service.app.lruSeq == this.mLruSeq || cr.binding.service.app.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cr.binding.service.app, now, nextIndex, "service connection", cr, app);
        }
        for (j = app.conProviders.size() - 1; j >= 0; --j) {
            ContentProviderRecord cpr = app.conProviders.get((int)j).provider;
            if (cpr.proc == null || cpr.proc.lruSeq == this.mLruSeq || cpr.proc.persistent) continue;
            nextIndex = this.updateLruProcessInternalLocked(cpr.proc, now, nextIndex, "provider reference", cpr, app);
        }
    }

    final ProcessRecord getProcessRecordLocked(String processName, int uid, boolean keepIfLarge) {
        ProcessRecord proc;
        if (uid == 1000) {
            SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().get(processName);
            if (procs == null) {
                return null;
            }
            int procCount = procs.size();
            for (int i = 0; i < procCount; ++i) {
                int procUid = procs.keyAt(i);
                if (UserHandle.isApp(procUid) || !UserHandle.isSameUser(procUid, uid)) continue;
                return procs.valueAt(i);
            }
        }
        if ((proc = this.mProcessNames.get(processName, uid)) != null && !keepIfLarge && this.mLastMemoryLevel > 0 && proc.setProcState >= 16 && proc.lastCachedPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
            if (proc.baseProcessTracker != null) {
                proc.baseProcessTracker.reportCachedKill(proc.pkgList, proc.lastCachedPss);
            }
            proc.kill(Long.toString(proc.lastCachedPss) + "k from cached", true);
        }
        return proc;
    }

    void ensurePackageDexOpt(String packageName) {
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            if (pm.performDexOptIfNeeded(packageName, null)) {
                this.mDidDexOpt = true;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    boolean isNextTransitionForward() {
        int transit = this.mWindowManager.getPendingAppTransition();
        return transit == 6 || transit == 8 || transit == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ApplicationInfo info = new ApplicationInfo();
            info.uid = 1000;
            info.processName = processName;
            info.className = entryPoint;
            info.packageName = "android";
            ProcessRecord proc = this.startProcessLocked(processName, info, false, 0, "", null, true, true, uid, true, abiOverride, entryPoint, entryPointArgs, crashHandler);
            return proc != null ? proc.pid : 0;
        }
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting, boolean isolated, boolean keepIfLarge) {
        return this.startProcessLocked(processName, info, knownToBeDead, intentFlags, hostingType, hostingName, allowWhileBooting, isolated, 0, keepIfLarge, null, null, null, null);
    }

    final ProcessRecord startProcessLocked(String processName, ApplicationInfo info, boolean knownToBeDead, int intentFlags, String hostingType, ComponentName hostingName, boolean allowWhileBooting, boolean isolated, int isolatedUid, boolean keepIfLarge, String abiOverride, String entryPoint, String[] entryPointArgs, Runnable crashHandler) {
        String hostingNameStr;
        ProcessRecord app;
        long startTime = SystemClock.elapsedRealtime();
        if (!isolated) {
            app = this.getProcessRecordLocked(processName, info.uid, keepIfLarge);
            this.checkTime(startTime, "startProcess: after getProcessRecord");
            if ((intentFlags & 4) != 0) {
                if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                    return null;
                }
            } else {
                this.mProcessCrashTimes.remove(info.processName, info.uid);
                if (this.mBadProcesses.get(info.processName, info.uid) != null) {
                    EventLog.writeEvent(30016, UserHandle.getUserId(info.uid), info.uid, info.processName);
                    this.mBadProcesses.remove(info.processName, info.uid);
                    if (app != null) {
                        app.bad = false;
                    }
                }
            }
        } else {
            app = null;
        }
        if (app != null && app.pid > 0) {
            if (!knownToBeDead || app.thread == null) {
                app.addPackage(info.packageName, info.versionCode, this.mProcessStats);
                this.checkTime(startTime, "startProcess: done, added package to proc");
                return app;
            }
            this.checkTime(startTime, "startProcess: bad proc running, killing");
            ActivityManagerService.killProcessGroup(app.info.uid, app.pid);
            this.handleAppDiedLocked(app, true, true);
            this.checkTime(startTime, "startProcess: done killing old proc");
        }
        String string2 = hostingNameStr = hostingName != null ? hostingName.flattenToShortString() : null;
        if (app == null) {
            this.checkTime(startTime, "startProcess: creating new process record");
            app = this.newProcessRecordLocked(info, processName, isolated, isolatedUid);
            if (app == null) {
                Slog.w("ActivityManager", "Failed making new process record for " + processName + "/" + info.uid + " isolated=" + isolated);
                return null;
            }
            app.crashHandler = crashHandler;
            this.checkTime(startTime, "startProcess: done creating new process record");
        } else {
            app.addPackage(info.packageName, info.versionCode, this.mProcessStats);
            this.checkTime(startTime, "startProcess: added package to existing proc");
        }
        if (!(this.mProcessesReady || this.isAllowedWhileBooting(info) || allowWhileBooting)) {
            if (!this.mProcessesOnHold.contains(app)) {
                this.mProcessesOnHold.add(app);
            }
            this.checkTime(startTime, "startProcess: returning with proc on hold");
            return app;
        }
        this.checkTime(startTime, "startProcess: stepping in to startProcess");
        this.startProcessLocked(app, hostingType, hostingNameStr, abiOverride, entryPoint, entryPointArgs);
        this.checkTime(startTime, "startProcess: done starting proc!");
        return app.pid != 0 ? app : null;
    }

    boolean isAllowedWhileBooting(ApplicationInfo ai) {
        return (ai.flags & 8) != 0;
    }

    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr) {
        this.startProcessLocked(app, hostingType, hostingNameStr, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void startProcessLocked(ProcessRecord app, String hostingType, String hostingNameStr, String abiOverride, String entryPoint, String[] entryPointArgs) {
        long startTime = SystemClock.elapsedRealtime();
        if (app.pid > 0 && app.pid != MY_PID) {
            this.checkTime(startTime, "startProcess: removing from pids map");
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            this.checkTime(startTime, "startProcess: done removing from pids map");
            app.setPid(0);
        }
        this.mProcessesOnHold.remove(app);
        this.checkTime(startTime, "startProcess: starting to update cpu stats");
        this.updateCpuStats();
        this.checkTime(startTime, "startProcess: done updating cpu stats");
        try {
            boolean isActivityProcess;
            String requiredAbi;
            String jitDebugProperty;
            try {
                if (AppGlobals.getPackageManager().isPackageFrozen(app.info.packageName)) {
                    throw new RuntimeException("Package " + app.info.packageName + " is frozen!");
                }
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            int uid = app.uid;
            int[] gids = null;
            int mountExternal = 0;
            if (!app.isolated) {
                int[] permGids = null;
                try {
                    this.checkTime(startTime, "startProcess: getting gids from package manager");
                    IPackageManager pm = AppGlobals.getPackageManager();
                    permGids = pm.getPackageGids(app.info.packageName, app.userId);
                    MountServiceInternal mountServiceInternal = LocalServices.getService(MountServiceInternal.class);
                    mountExternal = mountServiceInternal.getExternalStorageMountMode(uid, app.info.packageName);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                if (ArrayUtils.isEmpty(permGids)) {
                    gids = new int[2];
                } else {
                    gids = new int[permGids.length + 2];
                    System.arraycopy((int[])permGids, (int)0, (int[])gids, (int)2, (int)permGids.length);
                }
                gids[0] = UserHandle.getSharedAppGid(UserHandle.getAppId(uid));
                gids[1] = UserHandle.getUserGid(UserHandle.getUserId(uid));
            }
            this.checkTime(startTime, "startProcess: building args");
            if (this.mFactoryTest != 0) {
                if (this.mFactoryTest == 1 && this.mTopComponent != null && app.processName.equals(this.mTopComponent.getPackageName())) {
                    uid = 0;
                }
                if (this.mFactoryTest == 2 && (app.info.flags & 0x10) != 0) {
                    uid = 0;
                }
            }
            int debugFlags = 0;
            if ((app.info.flags & 2) != 0) {
                debugFlags |= 1;
                debugFlags |= 2;
            }
            if ((app.info.flags & 0x4000) != 0 || this.mSafeMode) {
                debugFlags |= 8;
            }
            if ("1".equals(SystemProperties.get("debug.checkjni"))) {
                debugFlags |= 2;
            }
            if ("true".equals(jitDebugProperty = SystemProperties.get("debug.usejit"))) {
                debugFlags |= 0x20;
            } else if (!"false".equals(jitDebugProperty) && "true".equals(SystemProperties.get("dalvik.vm.usejit"))) {
                debugFlags |= 0x20;
            }
            String genDebugInfoProperty = SystemProperties.get("debug.generate-debug-info");
            if ("true".equals(genDebugInfoProperty)) {
                debugFlags |= 0x40;
            }
            if ("1".equals(SystemProperties.get("debug.jni.logging"))) {
                debugFlags |= 0x10;
            }
            if ("1".equals(SystemProperties.get("debug.assert"))) {
                debugFlags |= 4;
            }
            String string2 = requiredAbi = abiOverride != null ? abiOverride : app.info.primaryCpuAbi;
            if (requiredAbi == null) {
                requiredAbi = Build.SUPPORTED_ABIS[0];
            }
            String instructionSet = null;
            if (app.info.primaryCpuAbi != null) {
                instructionSet = VMRuntime.getInstructionSet(app.info.primaryCpuAbi);
            }
            app.gids = gids;
            app.requiredAbi = requiredAbi;
            app.instructionSet = instructionSet;
            boolean bl = isActivityProcess = entryPoint == null;
            if (entryPoint == null) {
                entryPoint = "android.app.ActivityThread";
            }
            Trace.traceBegin(64L, "Start proc: " + app.processName);
            this.checkTime(startTime, "startProcess: asking zygote to start proc");
            Process.ProcessStartResult startResult = android.os.Process.start(entryPoint, app.processName, uid, uid, gids, debugFlags, mountExternal, app.info.targetSdkVersion, app.info.seinfo, requiredAbi, instructionSet, app.info.dataDir, entryPointArgs);
            this.checkTime(startTime, "startProcess: returned from zygote!");
            Trace.traceEnd(64L);
            if (app.isolated) {
                this.mBatteryStatsService.addIsolatedUid(app.uid, app.info.uid);
            }
            this.mBatteryStatsService.noteProcessStart(app.processName, app.info.uid);
            this.checkTime(startTime, "startProcess: done updating battery stats");
            EventLog.writeEvent(30014, UserHandle.getUserId(uid), startResult.pid, uid, app.processName, hostingType, hostingNameStr != null ? hostingNameStr : "");
            if (app.persistent) {
                Watchdog.getInstance().processStarted(app.processName, startResult.pid);
            }
            this.checkTime(startTime, "startProcess: building log message");
            StringBuilder buf = this.mStringBuilder;
            buf.setLength(0);
            buf.append("Start proc ");
            buf.append(startResult.pid);
            buf.append(':');
            buf.append(app.processName);
            buf.append('/');
            UserHandle.formatUid(buf, uid);
            if (!isActivityProcess) {
                buf.append(" [");
                buf.append(entryPoint);
                buf.append("]");
            }
            buf.append(" for ");
            buf.append(hostingType);
            if (hostingNameStr != null) {
                buf.append(" ");
                buf.append(hostingNameStr);
            }
            Slog.i("ActivityManager", buf.toString());
            app.setPid(startResult.pid);
            app.usingWrapper = startResult.usingWrapper;
            app.removed = false;
            app.killed = false;
            app.killedByAm = false;
            this.checkTime(startTime, "startProcess: starting to update pids map");
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.put(startResult.pid, app);
                if (isActivityProcess) {
                    Message msg = this.mHandler.obtainMessage(20);
                    msg.obj = app;
                    this.mHandler.sendMessageDelayed(msg, startResult.usingWrapper ? 1200000L : 10000L);
                }
            }
            this.checkTime(startTime, "startProcess: done updating pids map");
        }
        catch (RuntimeException e) {
            app.setPid(0);
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            Slog.e("ActivityManager", "Failure starting process " + app.processName, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateUsageStats(ActivityRecord component, boolean resumed) {
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        if (resumed) {
            if (this.mUsageStatsService != null) {
                this.mUsageStatsService.reportEvent(component.realActivity, component.userId, 1);
            }
            BatteryStatsImpl batteryStatsImpl = stats;
            synchronized (batteryStatsImpl) {
                stats.noteActivityResumedLocked(component.app.uid);
            }
        }
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.reportEvent(component.realActivity, component.userId, 2);
        }
        BatteryStatsImpl batteryStatsImpl = stats;
        synchronized (batteryStatsImpl) {
            stats.noteActivityPausedLocked(component.app.uid);
        }
    }

    Intent getHomeIntent() {
        Intent intent = new Intent(this.mTopAction, this.mTopData != null ? Uri.parse(this.mTopData) : null);
        intent.setComponent(this.mTopComponent);
        if (this.mFactoryTest != 1) {
            intent.addCategory("android.intent.category.HOME");
        }
        return intent;
    }

    boolean startHomeActivityLocked(int userId, String reason) {
        if (this.mFactoryTest == 1 && this.mTopAction == null) {
            return false;
        }
        Intent intent = this.getHomeIntent();
        ActivityInfo aInfo = this.resolveActivityInfo(intent, 1024, userId);
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            aInfo = new ActivityInfo(aInfo);
            aInfo.applicationInfo = this.getAppInfoForUser(aInfo.applicationInfo, userId);
            ProcessRecord app = this.getProcessRecordLocked(aInfo.processName, aInfo.applicationInfo.uid, true);
            if (app == null || app.instrumentationClass == null) {
                intent.setFlags(intent.getFlags() | 0x10000000);
                this.mStackSupervisor.startHomeActivity(intent, aInfo, reason);
            }
        }
        return true;
    }

    private ActivityInfo resolveActivityInfo(Intent intent, int flags, int userId) {
        ActivityInfo ai = null;
        ComponentName comp = intent.getComponent();
        try {
            if (comp != null) {
                ai = AppGlobals.getPackageManager().getActivityInfo(comp, flags, userId);
            } else {
                ResolveInfo info = AppGlobals.getPackageManager().resolveIntent(intent, intent.resolveTypeIfNeeded(this.mContext.getContentResolver()), flags, userId);
                if (info != null) {
                    ai = info.activityInfo;
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return ai;
    }

    void startSetupActivityLocked() {
        if (this.mCheckedForSetup) {
            return;
        }
        ContentResolver resolver = this.mContext.getContentResolver();
        if (this.mFactoryTest != 1 && Settings.Global.getInt(resolver, "device_provisioned", 0) != 0) {
            this.mCheckedForSetup = true;
            Intent intent = new Intent("android.intent.action.UPGRADE_SETUP");
            List<ResolveInfo> ris = this.mContext.getPackageManager().queryIntentActivities(intent, 128);
            ResolveInfo ri = null;
            for (int i = 0; ris != null && i < ris.size(); ++i) {
                if ((ris.get((int)i).activityInfo.applicationInfo.flags & 1) == 0) continue;
                ri = ris.get(i);
                break;
            }
            if (ri != null) {
                String vers;
                String string2 = vers = ri.activityInfo.metaData != null ? ri.activityInfo.metaData.getString("android.SETUP_VERSION") : null;
                if (vers == null && ri.activityInfo.applicationInfo.metaData != null) {
                    vers = ri.activityInfo.applicationInfo.metaData.getString("android.SETUP_VERSION");
                }
                String lastVers = Settings.Secure.getString(resolver, "last_setup_shown");
                if (vers != null && !vers.equals(lastVers)) {
                    intent.setFlags(0x10000000);
                    intent.setComponent(new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name));
                    this.mStackSupervisor.startActivityLocked(null, intent, null, ri.activityInfo, null, null, null, null, 0, 0, 0, null, 0, 0, 0, null, false, false, null, null, null);
                }
            }
        }
    }

    CompatibilityInfo compatibilityInfoForPackageLocked(ApplicationInfo ai) {
        return this.mCompatModePackages.compatibilityInfoForPackageLocked(ai);
    }

    void enforceNotIsolatedCaller(String caller) {
        if (UserHandle.isIsolated(Binder.getCallingUid())) {
            throw new SecurityException("Isolated process not allowed to call " + caller);
        }
    }

    void enforceShellRestriction(String restriction, int userHandle) {
        if (Binder.getCallingUid() == 2000 && (userHandle < 0 || this.mUserManager.hasUserRestriction(restriction, userHandle))) {
            throw new SecurityException("Shell does not have permission to access user " + userHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getFrontActivityScreenCompatMode() {
        this.enforceNotIsolatedCaller("getFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getFrontActivityScreenCompatModeLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFrontActivityScreenCompatMode(int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setFrontActivityScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setFrontActivityScreenCompatModeLocked(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageScreenCompatMode(String packageName) {
        this.enforceNotIsolatedCaller("getPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageScreenCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageScreenCompatMode(String packageName, int mode) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageScreenCompatMode");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageScreenCompatModeLocked(packageName, mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getPackageAskScreenCompat(String packageName) {
        this.enforceNotIsolatedCaller("getPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mCompatModePackages.getPackageAskCompatModeLocked(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPackageAskScreenCompat(String packageName, boolean ask) {
        this.enforceCallingPermission("android.permission.SET_SCREEN_COMPATIBILITY", "setPackageAskScreenCompat");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mCompatModePackages.setPackageAskCompatModeLocked(packageName, ask);
        }
    }

    private boolean hasUsageStatsPermission(String callingPackage) {
        int mode = this.mAppOpsService.checkOperation(43, Binder.getCallingUid(), callingPackage);
        if (mode == 3) {
            return this.checkCallingPermission("android.permission.PACKAGE_USAGE_STATS") == 0;
        }
        return mode == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPackageProcessState(String packageName, String callingPackage) {
        if (!this.hasUsageStatsPermission(callingPackage)) {
            this.enforceCallingPermission("android.permission.GET_PACKAGE_IMPORTANCE", "getPackageProcessState");
        }
        int procState = -1;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            block3: for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                int j;
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (procState != -1 && procState <= proc.setProcState) continue;
                boolean found = false;
                for (j = proc.pkgList.size() - 1; j >= 0 && !found; --j) {
                    if (!proc.pkgList.keyAt(j).equals(packageName)) continue;
                    procState = proc.setProcState;
                    found = true;
                }
                if (proc.pkgDeps == null || found) continue;
                for (j = proc.pkgDeps.size() - 1; j >= 0; --j) {
                    if (!proc.pkgDeps.valueAt(j).equals(packageName)) continue;
                    procState = proc.setProcState;
                    continue block3;
                }
            }
        }
        return procState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setProcessMemoryTrimLevel(String process, int userId, int level) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.findProcessLocked(process, userId, "setProcessMemoryTrimLevel");
            if (app == null) {
                return false;
            }
            if (app.trimMemoryLevel < level && app.thread != null && (level < 20 || app.curProcState >= 7)) {
                try {
                    app.thread.scheduleTrimMemory(level);
                    app.trimMemoryLevel = level;
                    return true;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchProcessesChanged() {
        int j;
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingProcessChanges.size();
            if (this.mActiveProcessChanges.length < N) {
                this.mActiveProcessChanges = new ProcessChangeItem[N];
            }
            this.mPendingProcessChanges.toArray(this.mActiveProcessChanges);
            this.mPendingProcessChanges.clear();
        }
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                for (j = 0; j < N; ++j) {
                    ProcessChangeItem item = this.mActiveProcessChanges[j];
                    if ((item.changes & 1) != 0) {
                        observer.onForegroundActivitiesChanged(item.pid, item.uid, item.foregroundActivities);
                    }
                    if ((item.changes & 2) == 0) continue;
                    observer.onProcessStateChanged(item.pid, item.uid, item.processState);
                }
            }
            catch (RemoteException e) {
            }
        }
        this.mProcessObservers.finishBroadcast();
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            for (j = 0; j < N; ++j) {
                this.mAvailProcessChanges.add(this.mActiveProcessChanges[j]);
            }
        }
    }

    private void dispatchProcessDied(int pid, int uid) {
        int i = this.mProcessObservers.beginBroadcast();
        while (i > 0) {
            IProcessObserver observer;
            if ((observer = this.mProcessObservers.getBroadcastItem(--i)) == null) continue;
            try {
                observer.onProcessDied(pid, uid);
            }
            catch (RemoteException e) {}
        }
        this.mProcessObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchUidsChanged() {
        int N;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            N = this.mPendingUidChanges.size();
            if (this.mActiveUidChanges.length < N) {
                this.mActiveUidChanges = new UidRecord.ChangeItem[N];
            }
            for (int i = 0; i < N; ++i) {
                UidRecord.ChangeItem change;
                this.mActiveUidChanges[i] = change = this.mPendingUidChanges.get(i);
                change.uidRecord.pendingChange = null;
                change.uidRecord = null;
            }
            this.mPendingUidChanges.clear();
        }
        if (this.mLocalPowerManager != null) {
            for (int j = 0; j < N; ++j) {
                UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                if (item.gone) {
                    this.mLocalPowerManager.uidGone(item.uid);
                    continue;
                }
                this.mLocalPowerManager.updateUidProcState(item.uid, item.processState);
            }
        }
        int i = this.mUidObservers.beginBroadcast();
        while (i > 0) {
            IUidObserver observer;
            if ((observer = this.mUidObservers.getBroadcastItem(--i)) == null) continue;
            try {
                for (int j = 0; j < N; ++j) {
                    UidRecord.ChangeItem item = this.mActiveUidChanges[j];
                    if (item.gone) {
                        observer.onUidGone(item.uid);
                        continue;
                    }
                    observer.onUidStateChanged(item.uid, item.processState);
                }
            }
            catch (RemoteException e) {
            }
        }
        this.mUidObservers.finishBroadcast();
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            for (int j = 0; j < N; ++j) {
                this.mAvailUidChanges.add(this.mActiveUidChanges[j]);
            }
        }
    }

    @Override
    public final int startActivity(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle options) {
        return this.startActivityAsUser(caller, callingPackage, intent, resolvedType, resultTo, resultWho, requestCode, startFlags, profilerInfo, options, UserHandle.getCallingUserId());
    }

    @Override
    public final int startActivityAsUser(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivity");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivity", null);
        return this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, profilerInfo, null, null, options, false, userId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int startActivityAsCaller(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle options, boolean ignoreTargetSecurity, int userId) {
        String targetPackage;
        int targetUid;
        ActivityRecord sourceRecord;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (resultTo == null) {
                throw new SecurityException("Must be called from an activity");
            }
            sourceRecord = this.mStackSupervisor.isInAnyStackLocked(resultTo);
            if (sourceRecord == null) {
                throw new SecurityException("Called with bad activity token: " + resultTo);
            }
            if (!sourceRecord.info.packageName.equals("android")) {
                throw new SecurityException("Must be called from an activity that is declared in the android package");
            }
            if (sourceRecord.app == null) {
                throw new SecurityException("Called without a process attached to activity");
            }
            if (UserHandle.getAppId(sourceRecord.app.uid) != 1000 && sourceRecord.app.uid != sourceRecord.launchedFromUid) {
                throw new SecurityException("Calling activity in uid " + sourceRecord.app.uid + " must be system uid or original calling uid " + sourceRecord.launchedFromUid);
            }
            if (ignoreTargetSecurity) {
                if (intent.getComponent() == null) {
                    throw new SecurityException("Component must be specified with ignoreTargetSecurity");
                }
                if (intent.getSelector() != null) {
                    throw new SecurityException("Selector not allowed with ignoreTargetSecurity");
                }
            }
            targetUid = sourceRecord.launchedFromUid;
            targetPackage = sourceRecord.launchedFromPackage;
        }
        if (userId == -10000) {
            userId = UserHandle.getUserId(sourceRecord.app.uid);
        }
        int ret = this.mStackSupervisor.startActivityMayWait(null, targetUid, targetPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, null, options, ignoreTargetSecurity, userId, null, null);
        return ret;
    }

    @Override
    public final IActivityManager.WaitResult startActivityAndWait(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivityAndWait");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityAndWait", null);
        IActivityManager.WaitResult res = new IActivityManager.WaitResult();
        this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, profilerInfo, res, null, options, false, userId, null, null);
        return res;
    }

    @Override
    public final int startActivityWithConfig(IApplicationThread caller, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Configuration config, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivityWithConfig");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityWithConfig", null);
        int ret = this.mStackSupervisor.startActivityMayWait(caller, -1, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, config, options, false, userId, null, null);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startActivityIntentSender(IApplicationThread caller, IntentSender intent, Intent fillInIntent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues, Bundle options) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("startActivityIntentSender");
        if (fillInIntent != null && fillInIntent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        IIntentSender sender = intent.getTarget();
        if (!(sender instanceof PendingIntentRecord)) {
            throw new IllegalArgumentException("Bad PendingIntent object");
        }
        PendingIntentRecord pir = (PendingIntentRecord)sender;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = this.getFocusedStack();
            if (stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == Binder.getCallingUid()) {
                this.mAppSwitchesAllowedTime = 0L;
            }
        }
        int ret = pir.sendInner(0, fillInIntent, resolvedType, null, null, resultTo, resultWho, requestCode, flagsMask, flagsValues, options, null);
        return ret;
    }

    @Override
    public int startVoiceActivity(String callingPackage, int callingPid, int callingUid, Intent intent, String resolvedType, IVoiceInteractionSession session, IVoiceInteractor interactor, int startFlags, ProfilerInfo profilerInfo, Bundle options, int userId) {
        if (this.checkCallingPermission("android.permission.BIND_VOICE_INTERACTION") != 0) {
            String msg = "Permission Denial: startVoiceActivity() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BIND_VOICE_INTERACTION";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        if (session == null || interactor == null) {
            throw new NullPointerException("null session or interactor");
        }
        userId = this.handleIncomingUser(callingPid, callingUid, userId, false, 2, "startVoiceActivity", null);
        return this.mStackSupervisor.startActivityMayWait(null, callingUid, callingPackage, intent, resolvedType, session, interactor, null, null, 0, startFlags, profilerInfo, null, null, options, false, userId, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVoiceKeepAwake(IVoiceInteractionSession session, boolean keepAwake) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mRunningVoice != null && this.mRunningVoice.asBinder() == session.asBinder()) {
                if (keepAwake) {
                    this.mVoiceWakeLock.acquire();
                } else {
                    this.mVoiceWakeLock.release();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startNextMatchingActivity(IBinder callingActivity, Intent intent, Bundle options) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(callingActivity);
            if (r == null) {
                ActivityOptions.abort(options);
                return false;
            }
            if (r.app == null || r.app.thread == null) {
                ActivityOptions.abort(options);
                return false;
            }
            intent = new Intent(intent);
            intent.setDataAndType(r.intent.getData(), r.intent.getType());
            intent.setComponent(null);
            boolean debug = (intent.getFlags() & 8) != 0;
            ActivityInfo aInfo = null;
            try {
                List<ResolveInfo> resolves = AppGlobals.getPackageManager().queryIntentActivities(intent, r.resolvedType, 66560, UserHandle.getCallingUserId());
                int N = resolves != null ? resolves.size() : 0;
                for (int i = 0; i < N; ++i) {
                    ResolveInfo rInfo = resolves.get(i);
                    if (!rInfo.activityInfo.packageName.equals(r.packageName) || !rInfo.activityInfo.name.equals(r.info.name)) continue;
                    if (++i < N) {
                        aInfo = resolves.get((int)i).activityInfo;
                    }
                    if (debug) {
                        Slog.v("ActivityManager", "Next matching activity: found current " + r.packageName + "/" + r.info.name);
                        Slog.v("ActivityManager", "Next matching activity: next is " + aInfo.packageName + "/" + aInfo.name);
                    }
                    break;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (aInfo == null) {
                ActivityOptions.abort(options);
                if (debug) {
                    Slog.d("ActivityManager", "Next matching activity: nothing found");
                }
                return false;
            }
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            intent.setFlags(intent.getFlags() & 0xE1FFFFFF);
            boolean wasFinishing = r.finishing;
            r.finishing = true;
            ActivityRecord resultTo = r.resultTo;
            String resultWho = r.resultWho;
            int requestCode = r.requestCode;
            r.resultTo = null;
            if (resultTo != null) {
                resultTo.removeResultsLocked(r, resultWho, requestCode);
            }
            long origId = Binder.clearCallingIdentity();
            int res = this.mStackSupervisor.startActivityLocked(r.app.thread, intent, r.resolvedType, aInfo, null, null, resultTo != null ? resultTo.appToken : null, resultWho, requestCode, -1, r.launchedFromUid, r.launchedFromPackage, -1, r.launchedFromUid, 0, options, false, false, null, null, null);
            Binder.restoreCallingIdentity(origId);
            r.finishing = wasFinishing;
            return res == 0;
            {
            }
        }
    }

    @Override
    public final int startActivityFromRecents(int taskId, Bundle options) {
        if (this.checkCallingPermission("android.permission.START_TASKS_FROM_RECENTS") != 0) {
            String msg = "Permission Denial: startActivityFromRecents called without android.permission.START_TASKS_FROM_RECENTS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        return this.startActivityFromRecentsInner(taskId, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityFromRecentsInner(int taskId, Bundle options) {
        int userId;
        Intent intent;
        String callingPackage;
        int callingUid;
        TaskRecord task;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
            if (task == null) {
                throw new IllegalArgumentException("Task " + taskId + " not found.");
            }
            if (task.getRootActivity() != null) {
                this.moveTaskToFrontLocked(task.taskId, 0, null);
                return 2;
            }
            callingUid = task.mCallingUid;
            callingPackage = task.mCallingPackage;
            intent = task.intent;
            intent.addFlags(0x100000);
            userId = task.userId;
        }
        return this.startActivityInPackage(callingUid, callingPackage, intent, null, null, null, 0, 0, options, userId, null, task);
    }

    final int startActivityInPackage(int uid, String callingPackage, Intent intent, String resolvedType, IBinder resultTo, String resultWho, int requestCode, int startFlags, Bundle options, int userId, IActivityContainer container, TaskRecord inTask) {
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityInPackage", null);
        int ret = this.mStackSupervisor.startActivityMayWait(null, uid, callingPackage, intent, resolvedType, null, null, resultTo, resultWho, requestCode, startFlags, null, null, null, options, false, userId, container, inTask);
        return ret;
    }

    @Override
    public final int startActivities(IApplicationThread caller, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("startActivities");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivity", null);
        int ret = this.mStackSupervisor.startActivities(caller, -1, callingPackage, intents, resolvedTypes, resultTo, options, userId);
        return ret;
    }

    final int startActivitiesInPackage(int uid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startActivityInPackage", null);
        int ret = this.mStackSupervisor.startActivities(null, uid, callingPackage, intents, resolvedTypes, resultTo, options, userId);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportActivityFullyDrawn(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            r.reportFullyDrawnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRequestedOrientation(IBinder token, int requestedOrientation) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return;
            }
            if (r.task != null && r.task.mResizeable) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.mWindowManager.setAppOrientation(r.appToken, requestedOrientation);
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mConfiguration, r.mayFreezeScreenLocked(r.app) ? r.appToken : null);
            if (config != null) {
                r.frozenBeforeDestroy = true;
                if (!this.updateConfigurationLocked(config, r, false, false)) {
                    this.mStackSupervisor.resumeTopActivitiesLocked();
                }
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestedOrientation(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return -1;
            }
            return this.mWindowManager.getAppOrientation(r.appToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean finishActivity(IBinder token, int resultCode, Intent resultData, boolean finishTask) {
        if (resultData != null && resultData.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            ActivityRecord next;
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return true;
            }
            TaskRecord tr = r.task;
            ActivityRecord rootR = tr.getRootActivity();
            if (rootR == null) {
                Slog.w("ActivityManager", "Finishing task with all activities already finished");
            }
            if (tr.mLockTaskAuth != 4 && rootR == r && this.mStackSupervisor.isLastLockedTask(tr)) {
                Slog.i("ActivityManager", "Not finishing task in lock task mode");
                this.mStackSupervisor.showLockTaskToast();
                return false;
            }
            if (this.mController != null && (next = r.task.stack.topRunningActivityLocked(token, 0)) != null) {
                boolean resumeOK = true;
                try {
                    resumeOK = this.mController.activityResuming(next.packageName);
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
                if (!resumeOK) {
                    Slog.i("ActivityManager", "Not finishing activity because controller resumed");
                    return false;
                }
            }
            long origId = Binder.clearCallingIdentity();
            try {
                boolean res;
                if (finishTask && r == rootR) {
                    res = this.removeTaskByIdLocked(tr.taskId, false);
                    if (!res) {
                        Slog.i("ActivityManager", "Removing task failed to finish activity");
                    }
                } else {
                    res = tr.stack.requestFinishActivityLocked(token, resultCode, resultData, "app-request", true);
                    if (!res) {
                        Slog.i("ActivityManager", "Failed to finish by app-request");
                    }
                }
                bl = res;
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishHeavyWeightApp() {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: finishHeavyWeightApp() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mHeavyWeightProcess == null) {
                return;
            }
            ArrayList<ActivityRecord> activities = new ArrayList<ActivityRecord>(this.mHeavyWeightProcess.activities);
            for (int i = 0; i < activities.size(); ++i) {
                ActivityRecord r = activities.get(i);
                if (r.finishing || !r.isInStackLocked()) continue;
                r.task.stack.finishActivityLocked(r, 0, null, "finish-heavy", true);
            }
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crashApplication(int uid, int initialPid, String packageName, String message) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: crashApplication() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc = null;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                for (int i = 0; i < this.mPidsSelfLocked.size(); ++i) {
                    ProcessRecord p = this.mPidsSelfLocked.valueAt(i);
                    if (p.uid != uid) continue;
                    if (p.pid == initialPid) {
                        proc = p;
                        break;
                    }
                    if (!p.pkgList.containsKey(packageName)) continue;
                    proc = p;
                }
            }
            if (proc == null) {
                Slog.w("ActivityManager", "crashApplication: nothing for uid=" + uid + " initialPid=" + initialPid + " packageName=" + packageName);
                return;
            }
            if (proc.thread != null) {
                if (proc.pid == android.os.Process.myPid()) {
                    Log.w("ActivityManager", "crashApplication: trying to crash self!");
                    return;
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    proc.thread.scheduleCrash(message);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finishSubActivity(IBinder token, String resultWho, int requestCode) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.task.stack.finishSubActivityLocked(r, resultWho, requestCode);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean finishActivityAffinity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) {
                    boolean bl = false;
                    return bl;
                }
                TaskRecord task = r.task;
                if (task.mLockTaskAuth != 4 && this.mStackSupervisor.isLastLockedTask(task) && task.getRootActivity() == r) {
                    this.mStackSupervisor.showLockTaskToast();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = task.stack.finishActivityAffinityLocked(r);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishVoiceTask(IVoiceInteractionSession session) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.finishVoiceTask(session);
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean releaseActivityInstance(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) {
                    boolean bl = false;
                    return bl;
                }
                boolean bl = r.task.stack.safelyDestroyActivityLocked(r, "app-req");
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseSomeActivities(IApplicationThread appInt) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                ProcessRecord app = this.getRecordForAppLocked(appInt);
                this.mStackSupervisor.releaseSomeActivitiesLocked(app, "low-mem");
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean willActivityBeVisible(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                return stack.willActivityBeVisibleLocked(token);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overridePendingTransition(IBinder token, String packageName, int enterAnim, int exitAnim) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord self = ActivityRecord.isInStackLocked(token);
            if (self == null) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            if (self.state == ActivityStack.ActivityState.RESUMED || self.state == ActivityStack.ActivityState.PAUSING) {
                this.mWindowManager.overridePendingAppTransition(packageName, enterAnim, exitAnim, null);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final void handleAppDiedLocked(ProcessRecord app, boolean restarting, boolean allowRestart) {
        int pid = app.pid;
        boolean kept = this.cleanUpApplicationRecordLocked(app, restarting, allowRestart, -1);
        if (!kept && !restarting) {
            this.removeLruProcessLocked(app);
            if (pid > 0) {
                ProcessList.remove(pid);
            }
        }
        if (this.mProfileProc == app) {
            this.clearProfilerLocked();
        }
        boolean hasVisibleActivities = this.mStackSupervisor.handleAppDiedLocked(app);
        app.activities.clear();
        if (app.instrumentationClass != null) {
            Slog.w("ActivityManager", "Crash of app " + app.processName + " running instrumentation " + app.instrumentationClass);
            Bundle info = new Bundle();
            info.putString("shortMsg", "Process crashed.");
            this.finishInstrumentationLocked(app, 0, info);
        }
        if (!restarting && hasVisibleActivities && !this.mStackSupervisor.resumeTopActivitiesLocked()) {
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
        }
    }

    private final int getLRURecordIndexForAppLocked(IApplicationThread thread) {
        IBinder threadBinder = thread.asBinder();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.thread.asBinder() != threadBinder) continue;
            return i;
        }
        return -1;
    }

    final ProcessRecord getRecordForAppLocked(IApplicationThread thread) {
        if (thread == null) {
            return null;
        }
        int appIndex = this.getLRURecordIndexForAppLocked(thread);
        return appIndex >= 0 ? this.mLruProcesses.get(appIndex) : null;
    }

    final void doLowMemReportIfNeededLocked(ProcessRecord dyingProc) {
        boolean haveBg = false;
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord rec = this.mLruProcesses.get(i);
            if (rec.thread == null || rec.setProcState < 14) continue;
            haveBg = true;
            break;
        }
        if (!haveBg) {
            boolean doReport = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (doReport) {
                long now = SystemClock.uptimeMillis();
                if (now < this.mLastMemUsageReportTime + 300000L) {
                    doReport = false;
                } else {
                    this.mLastMemUsageReportTime = now;
                }
            }
            ArrayList<ProcessMemInfo> memInfos = doReport ? new ArrayList<ProcessMemInfo>(this.mLruProcesses.size()) : null;
            EventLog.writeEvent(30017, this.mLruProcesses.size());
            long now = SystemClock.uptimeMillis();
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord rec = this.mLruProcesses.get(i);
                if (rec == dyingProc || rec.thread == null) continue;
                if (doReport) {
                    memInfos.add(new ProcessMemInfo(rec.processName, rec.pid, rec.setAdj, rec.setProcState, rec.adjType, rec.makeAdjReason()));
                }
                if (rec.lastLowMemory + 60000L > now) continue;
                rec.lastRequestedGc = rec.setAdj <= 4 ? 0L : rec.lastLowMemory;
                rec.reportLowMemory = true;
                rec.lastLowMemory = now;
                this.mProcessesToGc.remove(rec);
                this.addProcessToGcListLocked(rec);
            }
            if (doReport) {
                Message msg = this.mHandler.obtainMessage(33, memInfos);
                this.mHandler.sendMessage(msg);
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void appDiedLocked(ProcessRecord app) {
        this.appDiedLocked(app, app.pid, app.thread, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appDiedLocked(ProcessRecord app, int pid, IApplicationThread thread, boolean fromBinderDied) {
        Object curProc;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            curProc = this.mPidsSelfLocked.get(pid);
            if (curProc != app) {
                Slog.w("ActivityManager", "Spurious death for " + app + ", curProc for " + pid + ": " + curProc);
                return;
            }
        }
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        curProc = stats;
        synchronized (curProc) {
            stats.noteProcessDiedLocked(app.info.uid, pid);
        }
        if (!app.killed) {
            if (!fromBinderDied) {
                android.os.Process.killProcessQuiet(pid);
            }
            ActivityManagerService.killProcessGroup(app.info.uid, pid);
            app.killed = true;
        }
        if (app.pid == pid && app.thread != null && app.thread.asBinder() == thread.asBinder()) {
            boolean doLowMem;
            boolean doOomAdj = doLowMem = app.instrumentationClass == null;
            if (!app.killedByAm) {
                Slog.i("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died");
                this.mAllowLowerMemLevel = true;
            } else {
                this.mAllowLowerMemLevel = false;
                doLowMem = false;
            }
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
            this.handleAppDiedLocked(app, false, true);
            if (doOomAdj) {
                this.updateOomAdjLocked();
            }
            if (doLowMem) {
                this.doLowMemReportIfNeededLocked(app);
            }
        } else if (app.pid != pid) {
            Slog.i("ActivityManager", "Process " + app.processName + " (pid " + pid + ") has died and restarted (pid " + app.pid + ").");
            EventLog.writeEvent(30011, app.userId, app.pid, app.processName);
        }
    }

    public static File dumpStackTraces(boolean clearTraces, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, String[] nativeProcs) {
        String tracesPath = SystemProperties.get("dalvik.vm.stack-trace-file", null);
        if (tracesPath == null || tracesPath.length() == 0) {
            return null;
        }
        File tracesFile = new File(tracesPath);
        try {
            File tracesDir = tracesFile.getParentFile();
            if (!tracesDir.exists()) {
                tracesDir.mkdirs();
                if (!SELinux.restorecon(tracesDir)) {
                    return null;
                }
            }
            FileUtils.setPermissions(tracesDir.getPath(), 509, -1, -1);
            if (clearTraces && tracesFile.exists()) {
                tracesFile.delete();
            }
            tracesFile.createNewFile();
            FileUtils.setPermissions(tracesFile.getPath(), 438, -1, -1);
        }
        catch (IOException e) {
            Slog.w("ActivityManager", "Unable to prepare ANR traces file: " + tracesPath, e);
            return null;
        }
        ActivityManagerService.dumpStackTraces(tracesPath, firstPids, processCpuTracker, lastPids, nativeProcs);
        return tracesFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpStackTraces(String tracesPath, ArrayList<Integer> firstPids, ProcessCpuTracker processCpuTracker, SparseArray<Boolean> lastPids, String[] nativeProcs) {
        block23: {
            FileObserver observer = new FileObserver(tracesPath, 8){

                @Override
                public synchronized void onEvent(int event, String path) {
                    this.notify();
                }
            };
            try {
                int[] pids2;
                observer.startWatching();
                if (firstPids != null) {
                    try {
                        int num = firstPids.size();
                        for (int i = 0; i < num; ++i) {
                            FileObserver fileObserver = observer;
                            synchronized (fileObserver) {
                                android.os.Process.sendSignal(firstPids.get(i), 3);
                                observer.wait(200L);
                                continue;
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Slog.wtf("ActivityManager", e);
                    }
                }
                if (nativeProcs != null && (pids2 = android.os.Process.getPidsForCommands(nativeProcs)) != null) {
                    for (int pid : pids2) {
                        Debug.dumpNativeBacktraceToFile(pid, tracesPath);
                    }
                }
                if (processCpuTracker == null) break block23;
                processCpuTracker.init();
                System.gc();
                processCpuTracker.update();
                try {
                    ProcessCpuTracker pids2 = processCpuTracker;
                    synchronized (pids2) {
                        processCpuTracker.wait(500L);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                processCpuTracker.update();
                int N = processCpuTracker.countWorkingStats();
                int numProcs = 0;
                for (int i = 0; i < N && numProcs < 5; ++i) {
                    ProcessCpuTracker.Stats stats = processCpuTracker.getWorkingStats(i);
                    if (lastPids.indexOfKey(stats.pid) < 0) continue;
                    ++numProcs;
                    try {
                        FileObserver pid = observer;
                        synchronized (pid) {
                            android.os.Process.sendSignal(stats.pid, 3);
                            observer.wait(200L);
                            continue;
                        }
                    }
                    catch (InterruptedException e) {
                        Slog.wtf("ActivityManager", e);
                    }
                }
            }
            finally {
                observer.stopWatching();
            }
        }
    }

    final void logAppTooSlow(ProcessRecord app, long startTime, String msg) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appNotResponding(ProcessRecord app, ActivityRecord activity, ActivityRecord parent, boolean aboveSystem, String annotation) {
        StringBuilder info;
        block35: {
            ArrayList<Integer> firstPids = new ArrayList<Integer>(5);
            SparseArray<Boolean> lastPids = new SparseArray<Boolean>(20);
            if (this.mController != null) {
                try {
                    int res = this.mController.appEarlyNotResponding(app.processName, app.pid, annotation);
                    if (res < 0 && app.pid != MY_PID) {
                        app.kill("anr", true);
                    }
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            long anrTime = SystemClock.uptimeMillis();
            this.updateCpuStatsNow();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (this.mShuttingDown) {
                    Slog.i("ActivityManager", "During shutdown skipping ANR: " + app + " " + annotation);
                    return;
                }
                if (app.notResponding) {
                    Slog.i("ActivityManager", "Skipping duplicate ANR: " + app + " " + annotation);
                    return;
                }
                if (app.crashing) {
                    Slog.i("ActivityManager", "Crashing app skipping ANR: " + app + " " + annotation);
                    return;
                }
                app.notResponding = true;
                EventLog.writeEvent(30008, app.userId, app.pid, app.processName, app.info.flags, annotation);
                firstPids.add(app.pid);
                int parentPid = app.pid;
                if (parent != null && parent.app != null && parent.app.pid > 0) {
                    parentPid = parent.app.pid;
                }
                if (parentPid != app.pid) {
                    firstPids.add(parentPid);
                }
                if (MY_PID != app.pid && MY_PID != parentPid) {
                    firstPids.add(MY_PID);
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    int pid;
                    ProcessRecord r = this.mLruProcesses.get(i);
                    if (r == null || r.thread == null || (pid = r.pid) <= 0 || pid == app.pid || pid == parentPid || pid == MY_PID) continue;
                    if (r.persistent) {
                        firstPids.add(pid);
                        continue;
                    }
                    lastPids.put(pid, Boolean.TRUE);
                }
            }
            info = new StringBuilder();
            info.setLength(0);
            info.append("ANR in ").append(app.processName);
            if (activity != null && activity.shortComponentName != null) {
                info.append(" (").append(activity.shortComponentName).append(")");
            }
            info.append("\n");
            info.append("PID: ").append(app.pid).append("\n");
            if (annotation != null) {
                info.append("Reason: ").append(annotation).append("\n");
            }
            if (parent != null && parent != activity) {
                info.append("Parent: ").append(parent.shortComponentName).append("\n");
            }
            ProcessCpuTracker processCpuTracker = new ProcessCpuTracker(true);
            File tracesFile = ActivityManagerService.dumpStackTraces(true, firstPids, processCpuTracker, lastPids, Watchdog.NATIVE_STACKS_OF_INTEREST);
            String cpuInfo = null;
            this.updateCpuStatsNow();
            ProcessCpuTracker pid = this.mProcessCpuTracker;
            synchronized (pid) {
                cpuInfo = this.mProcessCpuTracker.printCurrentState(anrTime);
            }
            info.append(processCpuTracker.printCurrentLoad());
            info.append(cpuInfo);
            info.append(processCpuTracker.printCurrentState(anrTime));
            Slog.e("ActivityManager", info.toString());
            if (tracesFile == null) {
                android.os.Process.sendSignal(app.pid, 3);
            }
            this.addErrorToDropBox("anr", app, app.processName, activity, parent, annotation, cpuInfo, tracesFile, null);
            if (this.mController != null) {
                try {
                    int res = this.mController.appNotResponding(app.processName, app.pid, info.toString());
                    if (res == 0) break block35;
                    if (res < 0 && app.pid != MY_PID) {
                        app.kill("anr", true);
                    } else {
                        ActivityManagerService activityManagerService2 = this;
                        synchronized (activityManagerService2) {
                            this.mServices.scheduleServiceTimeoutLocked(app);
                        }
                    }
                    return;
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
        }
        boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mBatteryStatsService.noteProcessAnr(app.processName, app.uid);
            if (!showBackground && !app.isInterestingToUserLocked() && app.pid != MY_PID) {
                app.kill("bg anr", true);
                return;
            }
            this.makeAppNotRespondingLocked(app, activity != null ? activity.shortComponentName : null, annotation != null ? "ANR " + annotation : "ANR", info.toString());
            Message msg = Message.obtain();
            HashMap<String, Object> map = new HashMap<String, Object>();
            msg.what = 2;
            msg.obj = map;
            msg.arg1 = aboveSystem ? 1 : 0;
            map.put("app", app);
            if (activity != null) {
                map.put("activity", activity);
            }
            this.mUiHandler.sendMessage(msg);
        }
    }

    final void showLaunchWarningLocked(final ActivityRecord cur, final ActivityRecord next) {
        if (!this.mLaunchWarningShown) {
            this.mLaunchWarningShown = true;
            this.mUiHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        final LaunchWarningWindow d = new LaunchWarningWindow(ActivityManagerService.this.mContext, cur, next);
                        d.show();
                        ActivityManagerService.this.mUiHandler.postDelayed(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                ActivityManagerService activityManagerService = ActivityManagerService.this;
                                synchronized (activityManagerService) {
                                    d.dismiss();
                                    ActivityManagerService.this.mLaunchWarningShown = false;
                                }
                            }
                        }, 4000L);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearApplicationUserData(String packageName, IPackageDataObserver observer, int userId) {
        this.enforceNotIsolatedCaller("clearApplicationUserData");
        if (packageName != null && packageName.equals(this.mDeviceOwnerName)) {
            throw new SecurityException("Clearing DeviceOwner data is forbidden.");
        }
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        userId = this.handleIncomingUser(pid, uid, userId, false, 2, "clearApplicationUserData", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            int pkgUid = -1;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                block21: {
                    try {
                        pkgUid = pm.getPackageUid(packageName, userId);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (pkgUid != -1) break block21;
                    Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                    if (observer != null) {
                        try {
                            observer.onRemoveCompleted(packageName, false);
                        }
                        catch (RemoteException e) {
                            Slog.i("ActivityManager", "Observer no longer exists.");
                        }
                    }
                    boolean e = false;
                    return e;
                }
                if (uid != pkgUid && this.checkComponentPermission("android.permission.CLEAR_APP_USER_DATA", pid, uid, -1, true) != 0) {
                    throw new SecurityException("PID " + pid + " does not have permission " + "android.permission.CLEAR_APP_USER_DATA" + " to clear data" + " of package " + packageName);
                }
                this.forceStopPackageLocked(packageName, pkgUid, "clear data");
                for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
                    TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                    String taskPackageName = tr.getBaseIntent().getComponent().getPackageName();
                    if (tr.userId != userId || !taskPackageName.equals(packageName)) continue;
                    this.removeTaskByIdLocked(tr.taskId, false);
                }
            }
            try {
                pm.clearApplicationUserData(packageName, observer, userId);
                activityManagerService = this;
                synchronized (activityManagerService) {
                    this.removeUriPermissionsForPackageLocked(packageName, userId, true);
                }
                Intent intent = new Intent("android.intent.action.PACKAGE_DATA_CLEARED", Uri.fromParts("package", packageName, null));
                intent.putExtra("android.intent.extra.UID", pkgUid);
                this.broadcastIntentInPackage("android", 1000, intent, null, null, 0, null, null, null, null, false, false, userId);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killBackgroundProcesses(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0 && this.checkCallingPermission("android.permission.RESTART_PACKAGES") != 0) {
            String msg = "Permission Denial: killBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, "killBackgroundProcesses", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int appId;
                block11: {
                    appId = -1;
                    try {
                        appId = UserHandle.getAppId(pm.getPackageUid(packageName, 0));
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (appId != -1) break block11;
                    Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                    return;
                }
                this.killPackageProcessesLocked(packageName, appId, userId, 5, false, true, true, false, "kill background");
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killAllBackgroundProcesses() {
        if (this.checkCallingPermission("android.permission.KILL_BACKGROUND_PROCESSES") != 0) {
            String msg = "Permission Denial: killAllBackgroundProcesses() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.KILL_BACKGROUND_PROCESSES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        long callingId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
                int NP = this.mProcessNames.getMap().size();
                for (int ip = 0; ip < NP; ++ip) {
                    SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                    int NA = apps.size();
                    for (int ia = 0; ia < NA; ++ia) {
                        ProcessRecord app = apps.valueAt(ia);
                        if (app.persistent) continue;
                        if (app.removed) {
                            procs.add(app);
                            continue;
                        }
                        if (app.setAdj < 9) continue;
                        app.removed = true;
                        procs.add(app);
                    }
                }
                int N = procs.size();
                for (int i = 0; i < N; ++i) {
                    this.removeProcessLocked((ProcessRecord)procs.get(i), false, true, "kill all background");
                }
                this.mAllowLowerMemLevel = true;
                this.updateOomAdjLocked();
                this.doLowMemReportIfNeededLocked(null);
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceStopPackage(String packageName, int userId) {
        if (this.checkCallingPermission("android.permission.FORCE_STOP_PACKAGES") != 0) {
            String msg = "Permission Denial: forceStopPackage() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.FORCE_STOP_PACKAGES";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingPid = Binder.getCallingPid();
        userId = this.handleIncomingUser(callingPid, Binder.getCallingUid(), userId, true, 2, "forceStopPackage", null);
        long callingId = Binder.clearCallingIdentity();
        try {
            IPackageManager pm = AppGlobals.getPackageManager();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int[] users;
                int[] nArray;
                if (userId == -1) {
                    nArray = this.getUsersLocked();
                } else {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = userId;
                }
                for (int user : users = nArray) {
                    int pkgUid = -1;
                    try {
                        pkgUid = pm.getPackageUid(packageName, user);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (pkgUid == -1) {
                        Slog.w("ActivityManager", "Invalid packageName: " + packageName);
                        continue;
                    }
                    try {
                        pm.setPackageStoppedState(packageName, true, user);
                    }
                    catch (RemoteException e) {
                    }
                    catch (IllegalArgumentException e) {
                        Slog.w("ActivityManager", "Failed trying to unstop package " + packageName + ": " + e);
                    }
                    if (!this.isUserRunningLocked(user, false)) continue;
                    this.forceStopPackageLocked(packageName, pkgUid, "from pid " + callingPid);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(callingId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPackageDependency(String packageName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc;
            int callingPid = Binder.getCallingPid();
            if (callingPid == android.os.Process.myPid()) {
                return;
            }
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
            }
            if (proc != null) {
                if (proc.pkgDeps == null) {
                    proc.pkgDeps = new ArraySet(1);
                }
                proc.pkgDeps.add(packageName);
            }
        }
    }

    @Override
    public void killApplicationWithAppId(String pkg, int appid, String reason) {
        if (pkg == null) {
            return;
        }
        if (appid < 0) {
            Slog.w("ActivityManager", "Invalid appid specified for pkg : " + pkg);
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (UserHandle.getAppId(callerUid) != 1000) {
            throw new SecurityException(callerUid + " cannot kill pkg: " + pkg);
        }
        Message msg = this.mHandler.obtainMessage(22);
        msg.arg1 = appid;
        msg.arg2 = 0;
        Bundle bundle = new Bundle();
        bundle.putString("pkg", pkg);
        bundle.putString("reason", reason);
        msg.obj = bundle;
        this.mHandler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeSystemDialogs(String reason) {
        this.enforceNotIsolatedCaller("closeSystemDialogs");
        int pid = Binder.getCallingPid();
        int uid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                block11: {
                    ProcessRecord proc;
                    if (uid < 10000) break block11;
                    SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                    synchronized (sparseArray) {
                        proc = this.mPidsSelfLocked.get(pid);
                    }
                    if (proc.curRawAdj <= 2) break block11;
                    Slog.w("ActivityManager", "Ignoring closeSystemDialogs " + reason + " from background process " + proc);
                    return;
                }
                this.closeSystemDialogsLocked(reason);
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void closeSystemDialogsLocked(String reason) {
        Intent intent = new Intent("android.intent.action.CLOSE_SYSTEM_DIALOGS");
        intent.addFlags(0x50000000);
        if (reason != null) {
            intent.putExtra("reason", reason);
        }
        this.mWindowManager.closeSystemDialogs(reason);
        this.mStackSupervisor.closeSystemDialogsLocked();
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, -1, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Debug.MemoryInfo[] getProcessMemoryInfo(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessMemoryInfo");
        Debug.MemoryInfo[] infos = new Debug.MemoryInfo[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
                synchronized (sparseArray) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            infos[i] = new Debug.MemoryInfo();
            Debug.getMemoryInfo(pids[i], infos[i]);
            if (proc == null) continue;
            activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(infos[i].getTotalPss(), infos[i].getTotalUss(), false, proc.pkgList);
                }
                continue;
            }
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getProcessPss(int[] pids) {
        this.enforceNotIsolatedCaller("getProcessPss");
        long[] pss = new long[pids.length];
        for (int i = pids.length - 1; i >= 0; --i) {
            int oomAdj;
            ProcessRecord proc;
            Object object;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                object = this.mPidsSelfLocked;
                synchronized (object) {
                    proc = this.mPidsSelfLocked.get(pids[i]);
                    oomAdj = proc != null ? proc.setAdj : 0;
                }
            }
            long[] tmpUss = new long[1];
            pss[i] = Debug.getPss(pids[i], tmpUss, null);
            if (proc == null) continue;
            object = this;
            synchronized (object) {
                if (proc.thread != null && proc.setAdj == oomAdj) {
                    proc.baseProcessTracker.addPss(pss[i], tmpUss[0], false, proc.pkgList);
                }
                continue;
            }
        }
        return pss;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killApplicationProcess(String processName, int uid) {
        if (processName == null) {
            return;
        }
        int callerUid = Binder.getCallingUid();
        if (callerUid == 1000) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ProcessRecord app = this.getProcessRecordLocked(processName, uid, true);
                if (app != null && app.thread != null) {
                    try {
                        app.thread.scheduleSuicide();
                    }
                    catch (RemoteException e) {}
                } else {
                    Slog.w("ActivityManager", "Process/uid not found attempting kill of " + processName + " / " + uid);
                }
            }
        } else {
            throw new SecurityException(callerUid + " cannot kill app process: " + processName);
        }
    }

    private void forceStopPackageLocked(String packageName, int uid, String reason) {
        this.forceStopPackageLocked(packageName, UserHandle.getAppId(uid), false, false, true, false, false, UserHandle.getUserId(uid), reason);
        Intent intent = new Intent("android.intent.action.PACKAGE_RESTARTED", Uri.fromParts("package", packageName, null));
        if (!this.mProcessesReady) {
            intent.addFlags(0x50000000);
        }
        intent.putExtra("android.intent.extra.UID", uid);
        intent.putExtra("android.intent.extra.user_handle", UserHandle.getUserId(uid));
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, UserHandle.getUserId(uid));
    }

    private void forceStopUserLocked(int userId, String reason) {
        this.forceStopPackageLocked(null, -1, false, false, true, false, false, userId, reason);
        Intent intent = new Intent("android.intent.action.USER_STOPPED");
        intent.addFlags(0x50000000);
        intent.putExtra("android.intent.extra.user_handle", userId);
        this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, -1);
    }

    private final boolean killPackageProcessesLocked(String packageName, int appId, int userId, int minOomAdj, boolean callerWillRestart, boolean allowRestart, boolean doit, boolean evenPersistent, String reason) {
        ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>();
        int NP = this.mProcessNames.getMap().size();
        for (int ip = 0; ip < NP; ++ip) {
            SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
            int NA = apps.size();
            for (int ia = 0; ia < NA; ++ia) {
                ProcessRecord app = apps.valueAt(ia);
                if (app.persistent && !evenPersistent) continue;
                if (app.removed) {
                    if (!doit) continue;
                    procs.add(app);
                    continue;
                }
                if (app.setAdj < minOomAdj) continue;
                if (packageName == null) {
                    if (userId != -1 && app.userId != userId || appId >= 0 && UserHandle.getAppId(app.uid) != appId) {
                        continue;
                    }
                } else {
                    boolean isDep;
                    boolean bl = isDep = app.pkgDeps != null && app.pkgDeps.contains(packageName);
                    if (!isDep && UserHandle.getAppId(app.uid) != appId || userId != -1 && app.userId != userId || !app.pkgList.containsKey(packageName) && !isDep) continue;
                }
                if (!doit) {
                    return true;
                }
                app.removed = true;
                procs.add(app);
            }
        }
        int N = procs.size();
        for (int i = 0; i < N; ++i) {
            this.removeProcessLocked((ProcessRecord)procs.get(i), callerWillRestart, allowRestart, reason);
        }
        this.updateOomAdjLocked();
        return N > 0;
    }

    private void cleanupDisabledPackageComponentsLocked(String packageName, int userId, boolean killProcess, String[] changedClasses) {
        int i;
        ArraySet<String> disabledClasses = null;
        boolean packageDisabled = false;
        IPackageManager pm = AppGlobals.getPackageManager();
        if (changedClasses == null) {
            return;
        }
        int enabled = 0;
        for (int i2 = changedClasses.length - 1; i2 >= 0; --i2) {
            String changedClass = changedClasses[i2];
            if (changedClass.equals(packageName)) {
                try {
                    enabled = pm.getApplicationEnabledSetting(packageName, userId != -1 ? userId : 0);
                }
                catch (Exception e) {
                    return;
                }
                boolean bl = packageDisabled = enabled != 1 && enabled != 0;
                if (!packageDisabled) continue;
                disabledClasses = null;
                break;
            }
            try {
                enabled = pm.getComponentEnabledSetting(new ComponentName(packageName, changedClass), userId != -1 ? userId : 0);
            }
            catch (Exception e) {
                return;
            }
            if (enabled == 1 || enabled == 0) continue;
            if (disabledClasses == null) {
                disabledClasses = new ArraySet<String>(changedClasses.length);
            }
            disabledClasses.add(changedClass);
        }
        if (!packageDisabled && disabledClasses == null) {
            return;
        }
        if (this.mStackSupervisor.finishDisabledPackageActivitiesLocked(packageName, disabledClasses, true, false, userId) && this.mBooted) {
            this.mStackSupervisor.resumeTopActivitiesLocked();
            this.mStackSupervisor.scheduleIdleLocked();
        }
        this.cleanupDisabledPackageTasksLocked(packageName, disabledClasses, userId);
        this.mServices.bringDownDisabledPackageServicesLocked(packageName, disabledClasses, userId, false, killProcess, true);
        ArrayList<ContentProviderRecord> providers = new ArrayList<ContentProviderRecord>();
        this.mProviderMap.collectPackageProvidersLocked(packageName, disabledClasses, true, false, userId, providers);
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
            this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, disabledClasses, userId, true);
        }
    }

    private final boolean forceStopPackageLocked(String packageName, int appId, boolean callerWillRestart, boolean purgeCache, boolean doit, boolean evenPersistent, boolean uninstalling, int userId, String reason) {
        ArrayList<ContentProviderRecord> providers;
        int i;
        if (userId == -1 && packageName == null) {
            Slog.w("ActivityManager", "Can't force stop all processes of all users, that is insane!");
        }
        if (appId < 0 && packageName != null) {
            try {
                appId = UserHandle.getAppId(AppGlobals.getPackageManager().getPackageUid(packageName, 0));
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (doit) {
            if (packageName != null) {
                Slog.i("ActivityManager", "Force stopping " + packageName + " appid=" + appId + " user=" + userId + ": " + reason);
            } else {
                Slog.i("ActivityManager", "Force stopping u" + userId + ": " + reason);
            }
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            for (int ip = pmap.size() - 1; ip >= 0; --ip) {
                SparseArray<Long> ba = pmap.valueAt(ip);
                for (i = ba.size() - 1; i >= 0; --i) {
                    boolean remove = false;
                    int entUid = ba.keyAt(i);
                    if (packageName != null) {
                        if (userId == -1) {
                            if (UserHandle.getAppId(entUid) == appId) {
                                remove = true;
                            }
                        } else if (entUid == UserHandle.getUid(userId, appId)) {
                            remove = true;
                        }
                    } else if (UserHandle.getUserId(entUid) == userId) {
                        remove = true;
                    }
                    if (!remove) continue;
                    ba.removeAt(i);
                }
                if (ba.size() != 0) continue;
                pmap.removeAt(ip);
            }
        }
        boolean didSomething = this.killPackageProcessesLocked(packageName, appId, userId, -100, callerWillRestart, true, doit, evenPersistent, packageName == null ? "stop user " + userId : "stop " + packageName);
        if (this.mStackSupervisor.finishDisabledPackageActivitiesLocked(packageName, null, doit, evenPersistent, userId)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (this.mServices.bringDownDisabledPackageServicesLocked(packageName, null, userId, evenPersistent, true, doit)) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        if (packageName == null) {
            this.mStickyBroadcasts.remove(userId);
        }
        if (this.mProviderMap.collectPackageProvidersLocked(packageName, null, doit, evenPersistent, userId, providers = new ArrayList<ContentProviderRecord>())) {
            if (!doit) {
                return true;
            }
            didSomething = true;
        }
        for (i = providers.size() - 1; i >= 0; --i) {
            this.removeDyingProviderLocked(null, providers.get(i), true);
        }
        this.removeUriPermissionsForPackageLocked(packageName, userId, false);
        if (doit) {
            for (i = this.mBroadcastQueues.length - 1; i >= 0; --i) {
                didSomething |= this.mBroadcastQueues[i].cleanupDisabledPackageReceiversLocked(packageName, null, userId, doit);
            }
        }
        if ((packageName == null || uninstalling) && this.mIntentSenderRecords.size() > 0) {
            Iterator<WeakReference<PendingIntentRecord>> it = this.mIntentSenderRecords.values().iterator();
            while (it.hasNext()) {
                WeakReference<PendingIntentRecord> wpir = it.next();
                if (wpir == null) {
                    it.remove();
                    continue;
                }
                PendingIntentRecord pir = (PendingIntentRecord)wpir.get();
                if (pir == null) {
                    it.remove();
                    continue;
                }
                if (packageName != null ? UserHandle.getAppId(pir.uid) != appId || userId != -1 && pir.key.userId != userId || !pir.key.packageName.equals(packageName) : pir.key.userId != userId) continue;
                if (!doit) {
                    return true;
                }
                didSomething = true;
                it.remove();
                pir.canceled = true;
                if (pir.key.activity == null || pir.key.activity.pendingResults == null) continue;
                pir.key.activity.pendingResults.remove(pir.ref);
            }
        }
        if (doit) {
            AttributeCache ac;
            if (purgeCache && packageName != null && (ac = AttributeCache.instance()) != null) {
                ac.removePackage(packageName);
            }
            if (this.mBooted) {
                this.mStackSupervisor.resumeTopActivitiesLocked();
                this.mStackSupervisor.scheduleIdleLocked();
            }
        }
        return didSomething;
    }

    private final ProcessRecord removeProcessNameLocked(String name, int uid) {
        ProcessRecord old = this.mProcessNames.remove(name, uid);
        if (old != null) {
            --old.uidRecord.numProcs;
            if (old.uidRecord.numProcs == 0) {
                this.enqueueUidChangeLocked(old.uidRecord, true);
                this.mActiveUids.remove(uid);
            }
            old.uidRecord = null;
        }
        this.mIsolatedProcesses.remove(uid);
        return old;
    }

    private final void addProcessNameLocked(ProcessRecord proc) {
        ProcessRecord old = this.removeProcessNameLocked(proc.processName, proc.uid);
        if (old == proc && proc.persistent) {
            Slog.w("ActivityManager", "Re-adding persistent process " + proc);
        } else if (old != null) {
            Slog.wtf("ActivityManager", "Already have existing proc " + old + " when adding " + proc);
        }
        UidRecord uidRec = this.mActiveUids.get(proc.uid);
        if (uidRec == null) {
            uidRec = new UidRecord(proc.uid);
            this.mActiveUids.put(proc.uid, uidRec);
            this.enqueueUidChangeLocked(uidRec, false);
        }
        proc.uidRecord = uidRec;
        ++uidRec.numProcs;
        this.mProcessNames.put(proc.processName, proc.uid, proc);
        if (proc.isolated) {
            this.mIsolatedProcesses.put(proc.uid, proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeProcessLocked(ProcessRecord app, boolean callerWillRestart, boolean allowRestart, String reason) {
        String name = app.processName;
        int uid = app.uid;
        this.removeProcessNameLocked(name, uid);
        if (this.mHeavyWeightProcess == app) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
            this.mHeavyWeightProcess = null;
        }
        boolean needRestart = false;
        if (app.pid > 0 && app.pid != MY_PID) {
            int pid = app.pid;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(pid);
                this.mHandler.removeMessages(20, app);
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            boolean willRestart = false;
            if (app.persistent && !app.isolated) {
                if (!callerWillRestart) {
                    willRestart = true;
                } else {
                    needRestart = true;
                }
            }
            app.kill(reason, true);
            this.handleAppDiedLocked(app, willRestart, allowRestart);
            if (willRestart) {
                this.removeLruProcessLocked(app);
                this.addAppLocked(app.info, false, null);
            }
        } else {
            this.mRemovedProcesses.add(app);
        }
        return needRestart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processStartTimedOutLocked(ProcessRecord app) {
        int pid = app.pid;
        boolean gone = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord knownApp = this.mPidsSelfLocked.get(pid);
            if (knownApp != null && knownApp.thread == null) {
                this.mPidsSelfLocked.remove(pid);
                gone = true;
            }
        }
        if (gone) {
            Slog.w("ActivityManager", "Process " + app + " failed to attach");
            EventLog.writeEvent(30037, app.userId, pid, app.uid, app.processName);
            this.removeProcessNameLocked(app.processName, app.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            this.checkAppInLaunchingProvidersLocked(app, true);
            this.mServices.processStartTimedOutLocked(app);
            app.kill("start timeout", true);
            this.removeLruProcessLocked(app);
            if (this.mBackupTarget != null && this.mBackupTarget.app.pid == pid) {
                Slog.w("ActivityManager", "Unattached app died before backup, skipping");
                try {
                    IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                    bm.agentDisconnected(app.info.packageName);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            if (this.isPendingBroadcastProcessLocked(pid)) {
                Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
                this.skipPendingBroadcastLocked(pid);
            }
        } else {
            Slog.w("ActivityManager", "Spurious process start timeout - pid not known for " + app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean attachApplicationLocked(IApplicationThread thread, int pid) {
        List<ProviderInfo> providers;
        ProcessRecord app;
        if (pid != MY_PID && pid >= 0) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                app = this.mPidsSelfLocked.get(pid);
            }
        } else {
            app = null;
        }
        if (app == null) {
            Slog.w("ActivityManager", "No pending application record for pid " + pid + " (IApplicationThread " + thread + "); dropping process");
            EventLog.writeEvent(30033, pid);
            if (pid > 0 && pid != MY_PID) {
                android.os.Process.killProcessQuiet(pid);
            } else {
                try {
                    thread.scheduleExit();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            return false;
        }
        if (app.thread != null) {
            this.handleAppDiedLocked(app, true, true);
        }
        String processName = app.processName;
        try {
            AppDeathRecipient adr = new AppDeathRecipient(app, pid, thread);
            thread.asBinder().linkToDeath(adr, 0);
            app.deathRecipient = adr;
        }
        catch (RemoteException e) {
            app.resetPackageList(this.mProcessStats);
            this.startProcessLocked(app, "link fail", processName);
            return false;
        }
        EventLog.writeEvent(30010, app.userId, app.pid, app.processName);
        app.makeActive(thread, this.mProcessStats);
        app.setAdj = -100;
        app.curAdj = -100;
        app.setSchedGroup = -1;
        app.curSchedGroup = -1;
        app.forcingToForeground = null;
        this.updateProcessForegroundLocked(app, false, false);
        app.hasShownUi = false;
        app.debugging = false;
        app.cached = false;
        app.killedByAm = false;
        this.mHandler.removeMessages(20, app);
        boolean normalMode = this.mProcessesReady || this.isAllowedWhileBooting(app.info);
        List<ProviderInfo> list = providers = normalMode ? this.generateApplicationProvidersLocked(app) : null;
        if (!normalMode) {
            Slog.i("ActivityManager", "Launching preboot mode app: " + app);
        }
        try {
            int testMode = 0;
            if (this.mDebugApp != null && this.mDebugApp.equals(processName)) {
                testMode = this.mWaitForDebugger ? 2 : 1;
                app.debugging = true;
                if (this.mDebugTransient) {
                    this.mDebugApp = this.mOrigDebugApp;
                    this.mWaitForDebugger = this.mOrigWaitForDebugger;
                }
            }
            String profileFile = app.instrumentationProfileFile;
            ParcelFileDescriptor profileFd = null;
            int samplingInterval = 0;
            boolean profileAutoStop = false;
            if (this.mProfileApp != null && this.mProfileApp.equals(processName)) {
                this.mProfileProc = app;
                profileFile = this.mProfileFile;
                profileFd = this.mProfileFd;
                samplingInterval = this.mSamplingInterval;
                profileAutoStop = this.mAutoStopProfiler;
            }
            boolean enableOpenGlTrace = false;
            if (this.mOpenGlTraceApp != null && this.mOpenGlTraceApp.equals(processName)) {
                enableOpenGlTrace = true;
                this.mOpenGlTraceApp = null;
            }
            boolean isRestrictedBackupMode = false;
            if (this.mBackupTarget != null && this.mBackupAppName.equals(processName)) {
                isRestrictedBackupMode = this.mBackupTarget.backupMode == 2 || this.mBackupTarget.backupMode == 3 || this.mBackupTarget.backupMode == 1;
            }
            this.ensurePackageDexOpt(app.instrumentationInfo != null ? app.instrumentationInfo.packageName : app.info.packageName);
            if (app.instrumentationClass != null) {
                this.ensurePackageDexOpt(app.instrumentationClass.getPackageName());
            }
            ApplicationInfo appInfo = app.instrumentationInfo != null ? app.instrumentationInfo : app.info;
            app.compat = this.compatibilityInfoForPackageLocked(appInfo);
            if (profileFd != null) {
                profileFd = profileFd.dup();
            }
            ProfilerInfo profilerInfo = profileFile == null ? null : new ProfilerInfo(profileFile, profileFd, samplingInterval, profileAutoStop);
            thread.bindApplication(processName, appInfo, providers, app.instrumentationClass, profilerInfo, app.instrumentationArguments, app.instrumentationWatcher, app.instrumentationUiAutomationConnection, testMode, enableOpenGlTrace, isRestrictedBackupMode || !normalMode, app.persistent, new Configuration(this.mConfiguration), app.compat, this.getCommonServicesLocked(app.isolated), this.mCoreSettingsObserver.getCoreSettingsLocked());
            this.updateLruProcessLocked(app, false, null);
            app.lastRequestedGc = app.lastLowMemory = SystemClock.uptimeMillis();
        }
        catch (Exception e) {
            Slog.wtf("ActivityManager", "Exception thrown during bind of " + app, e);
            app.resetPackageList(this.mProcessStats);
            app.unlinkDeathRecipient();
            this.startProcessLocked(app, "bind fail", processName);
            return false;
        }
        this.mPersistentStartingProcesses.remove(app);
        this.mProcessesOnHold.remove(app);
        boolean badApp = false;
        boolean didSomething = false;
        if (normalMode) {
            try {
                if (this.mStackSupervisor.attachApplicationLocked(app)) {
                    didSomething = true;
                }
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown launching activities in " + app, e);
                badApp = true;
            }
        }
        if (!badApp) {
            try {
                didSomething |= this.mServices.attachApplicationLocked(app, processName);
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown starting services in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && this.isPendingBroadcastProcessLocked(pid)) {
            try {
                didSomething |= this.sendPendingBroadcastsLocked(app);
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown dispatching broadcasts in " + app, e);
                badApp = true;
            }
        }
        if (!badApp && this.mBackupTarget != null && this.mBackupTarget.appInfo.uid == app.uid) {
            this.ensurePackageDexOpt(this.mBackupTarget.appInfo.packageName);
            try {
                thread.scheduleCreateBackupAgent(this.mBackupTarget.appInfo, this.compatibilityInfoForPackageLocked(this.mBackupTarget.appInfo), this.mBackupTarget.backupMode);
            }
            catch (Exception e) {
                Slog.wtf("ActivityManager", "Exception thrown creating backup agent in " + app, e);
                badApp = true;
            }
        }
        if (badApp) {
            app.kill("error during init", true);
            this.handleAppDiedLocked(app, false, true);
            return false;
        }
        if (!didSomething) {
            this.updateOomAdjLocked();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void attachApplication(IApplicationThread thread) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            long origId = Binder.clearCallingIdentity();
            this.attachApplicationLocked(thread, callingPid);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityIdle(IBinder token, Configuration config, boolean stopProfiling) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                ActivityRecord r = this.mStackSupervisor.activityIdleInternalLocked(token, false, config);
                if (stopProfiling && this.mProfileProc == r.app && this.mProfileFd != null) {
                    try {
                        this.mProfileFd.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    this.clearProfilerLocked();
                }
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    void postFinishBooting(boolean finishBooting, boolean enableScreen) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(45, finishBooting ? 1 : 0, enableScreen ? 1 : 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enableScreenAfterBoot() {
        EventLog.writeEvent(3050, SystemClock.uptimeMillis());
        this.mWindowManager.enableScreenAfterBoot();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.updateEventDispatchingLocked();
        }
    }

    @Override
    public void showBootMessage(CharSequence msg, boolean always) {
        if (Binder.getCallingUid() != android.os.Process.myUid()) {
            // empty if block
        }
        this.mWindowManager.showBootMessage(msg, always);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyguardWaitingForActivityDrawn() {
        this.enforceNotIsolatedCaller("keyguardWaitingForActivityDrawn");
        long token = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mWindowManager.keyguardWaitingForActivityDrawn();
                if (this.mLockScreenShown == 2) {
                    this.mLockScreenShown = 1;
                    this.updateSleepIfNeededLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keyguardGoingAway(boolean disableWindowAnimations, boolean keyguardGoingToNotificationShade) {
        this.enforceNotIsolatedCaller("keyguardGoingAway");
        long token = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mWindowManager.keyguardGoingAway(disableWindowAnimations, keyguardGoingToNotificationShade);
                if (this.mLockScreenShown == 2) {
                    this.mLockScreenShown = 0;
                    this.updateSleepIfNeededLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void finishBooting() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mBootAnimationComplete) {
                this.mCallFinishBooting = true;
                return;
            }
            this.mCallFinishBooting = false;
        }
        ArraySet<String> completedIsas = new ArraySet<String>();
        for (String abi : Build.SUPPORTED_ABIS) {
            android.os.Process.establishZygoteConnectionForAbi(abi);
            String instructionSet = VMRuntime.getInstructionSet(abi);
            if (completedIsas.contains(instructionSet)) continue;
            if (this.mInstaller.markBootComplete(VMRuntime.getInstructionSet(abi)) != 0) {
                Slog.e("ActivityManager", "Unable to mark boot complete for abi: " + abi);
            }
            completedIsas.add(instructionSet);
        }
        IntentFilter pkgFilter = new IntentFilter();
        pkgFilter.addAction("android.intent.action.QUERY_PACKAGE_RESTART");
        pkgFilter.addDataScheme("package");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onReceive(Context context, Intent intent) {
                String[] pkgs = intent.getStringArrayExtra("android.intent.extra.PACKAGES");
                if (pkgs != null) {
                    for (String pkg : pkgs) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (ActivityManagerService.this.forceStopPackageLocked(pkg, -1, false, false, false, false, false, 0, "query restart")) {
                                this.setResultCode(-1);
                                return;
                            }
                        }
                    }
                }
            }
        }, pkgFilter);
        IntentFilter dumpheapFilter = new IntentFilter();
        dumpheapFilter.addAction("com.android.server.am.DELETE_DUMPHEAP");
        this.mContext.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                if (intent.getBooleanExtra("delay_delete", false)) {
                    ActivityManagerService.this.mHandler.sendEmptyMessageDelayed(51, 300000L);
                } else {
                    ActivityManagerService.this.mHandler.sendEmptyMessage(51);
                }
            }
        }, dumpheapFilter);
        this.mSystemServiceManager.startBootPhase(1000);
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            int NP = this.mProcessesOnHold.size();
            if (NP > 0) {
                ArrayList<ProcessRecord> procs = new ArrayList<ProcessRecord>(this.mProcessesOnHold);
                for (int ip = 0; ip < NP; ++ip) {
                    this.startProcessLocked(procs.get(ip), "on-hold", null);
                }
            }
            if (this.mFactoryTest != 1) {
                Message nmsg = this.mHandler.obtainMessage(27);
                this.mHandler.sendMessageDelayed(nmsg, 900000L);
                SystemProperties.set("sys.boot_completed", "1");
                if (!"trigger_restart_min_framework".equals(SystemProperties.get("vold.decrypt")) || "".equals(SystemProperties.get("vold.encrypt_progress"))) {
                    SystemProperties.set("dev.bootcomplete", "1");
                }
                for (int i = 0; i < this.mStartedUsers.size(); ++i) {
                    UserState uss = this.mStartedUsers.valueAt(i);
                    if (uss.mState != 0) continue;
                    uss.mState = 1;
                    int userId = this.mStartedUsers.keyAt(i);
                    Intent intent = new Intent("android.intent.action.BOOT_COMPLETED", null);
                    intent.putExtra("android.intent.extra.user_handle", userId);
                    intent.addFlags(0x8000000);
                    this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                            ActivityManagerService activityManagerService = ActivityManagerService.this;
                            synchronized (activityManagerService) {
                                ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                            }
                        }
                    }, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, MY_PID, 1000, userId);
                }
                this.scheduleStartProfilesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bootAnimationComplete() {
        boolean callFinishBooting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            callFinishBooting = this.mCallFinishBooting;
            this.mBootAnimationComplete = true;
        }
        if (callFinishBooting) {
            this.finishBooting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureBootCompleted() {
        boolean enableScreen;
        boolean booting;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            booting = this.mBooting;
            this.mBooting = false;
            enableScreen = !this.mBooted;
            this.mBooted = true;
        }
        if (booting) {
            this.finishBooting();
        }
        if (enableScreen) {
            this.enableScreenAfterBoot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityResumed(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                ActivityRecord.activityResumedLocked(token);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityPaused(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityPausedLocked(token, false);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityStopped(IBinder token, Bundle icicle, PersistableBundle persistentState, CharSequence description) {
        if (icicle != null && icicle.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.task.stack.activityStoppedLocked(r, icicle, persistentState, description);
            }
        }
        this.trimApplications();
        Binder.restoreCallingIdentity(origId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activityDestroyed(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(token);
            if (stack != null) {
                stack.activityDestroyedLocked(token, "activityDestroyed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void backgroundResourcesReleased(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityStack stack = ActivityRecord.getStackLocked(token);
                if (stack != null) {
                    stack.backgroundResourcesReleased();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    @Override
    public final void notifyLaunchTaskBehindComplete(IBinder token) {
        this.mStackSupervisor.scheduleLaunchTaskBehindComplete(token);
    }

    @Override
    public final void notifyEnterAnimationComplete(IBinder token) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(44, token));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCallingPackage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.info.packageName : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getCallingActivity(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getCallingRecordLocked(token);
            return r != null ? r.intent.getComponent() : null;
        }
    }

    private ActivityRecord getCallingRecordLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r == null) {
            return null;
        }
        return r.resultTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName getActivityClassForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.intent.getComponent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPackageForToken(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return null;
            }
            return r.packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRootVoiceInteraction(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                return false;
            }
            return r.rootVoiceInteraction;
        }
    }

    @Override
    public IIntentSender getIntentSender(int type, String packageName, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle options, int userId) {
        this.enforceNotIsolatedCaller("getIntentSender");
        if (intents != null) {
            if (intents.length < 1) {
                throw new IllegalArgumentException("Intents array length must be >= 1");
            }
            for (int i = 0; i < intents.length; ++i) {
                Intent intent = intents[i];
                if (intent == null) continue;
                if (intent.hasFileDescriptors()) {
                    throw new IllegalArgumentException("File descriptors passed in Intent");
                }
                if (type == 1 && (intent.getFlags() & 0x2000000) != 0) {
                    throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
                }
                intents[i] = new Intent(intent);
            }
            if (resolvedTypes != null && resolvedTypes.length != intents.length) {
                throw new IllegalArgumentException("Intent array length does not match resolvedTypes length");
            }
        }
        if (options != null && options.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in options");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            int origUserId = userId;
            userId = this.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, type == 1, 0, "getIntentSender", null);
            if (origUserId == -2) {
                userId = -2;
            }
            try {
                int uid;
                if (callingUid != 0 && callingUid != 1000 && !UserHandle.isSameApp(callingUid, uid = AppGlobals.getPackageManager().getPackageUid(packageName, UserHandle.getUserId(callingUid)))) {
                    String msg = "Permission Denial: getIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + ", (need uid=" + uid + ")" + " is not allowed to send as package " + packageName;
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                return this.getIntentSenderLocked(type, packageName, callingUid, userId, token, resultWho, requestCode, intents, resolvedTypes, flags, options);
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
        }
    }

    IIntentSender getIntentSenderLocked(int type, String packageName, int callingUid, int userId, IBinder token, String resultWho, int requestCode, Intent[] intents, String[] resolvedTypes, int flags, Bundle options) {
        PendingIntentRecord rec;
        ActivityRecord activity = null;
        if (type == 3) {
            activity = ActivityRecord.isInStackLocked(token);
            if (activity == null) {
                return null;
            }
            if (activity.finishing) {
                return null;
            }
        }
        boolean noCreate = (flags & 0x20000000) != 0;
        boolean cancelCurrent = (flags & 0x10000000) != 0;
        boolean updateCurrent = (flags & 0x8000000) != 0;
        PendingIntentRecord.Key key = new PendingIntentRecord.Key(type, packageName, activity, resultWho, requestCode, intents, resolvedTypes, flags &= 0xC7FFFFFF, options, userId);
        WeakReference<PendingIntentRecord> ref = this.mIntentSenderRecords.get(key);
        PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
        if (rec != null) {
            if (!cancelCurrent) {
                if (updateCurrent) {
                    if (rec.key.requestIntent != null) {
                        rec.key.requestIntent.replaceExtras(intents != null ? intents[intents.length - 1] : null);
                    }
                    if (intents != null) {
                        intents[intents.length - 1] = rec.key.requestIntent;
                        rec.key.allIntents = intents;
                        rec.key.allResolvedTypes = resolvedTypes;
                    } else {
                        rec.key.allIntents = null;
                        rec.key.allResolvedTypes = null;
                    }
                }
                return rec;
            }
            rec.canceled = true;
            this.mIntentSenderRecords.remove(key);
        }
        if (noCreate) {
            return rec;
        }
        rec = new PendingIntentRecord(this, key, callingUid);
        this.mIntentSenderRecords.put(key, rec.ref);
        if (type == 3) {
            if (activity.pendingResults == null) {
                activity.pendingResults = new HashSet();
            }
            activity.pendingResults.add(rec.ref);
        }
        return rec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelIntentSender(IIntentSender sender) {
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            PendingIntentRecord rec = (PendingIntentRecord)sender;
            try {
                int uid = AppGlobals.getPackageManager().getPackageUid(rec.key.packageName, UserHandle.getCallingUserId());
                if (!UserHandle.isSameApp(uid, Binder.getCallingUid())) {
                    String msg = "Permission Denial: cancelIntentSender() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " is not allowed to cancel packges " + rec.key.packageName;
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
            }
            catch (RemoteException e) {
                throw new SecurityException(e);
            }
            this.cancelIntentSenderLocked(rec, true);
        }
    }

    void cancelIntentSenderLocked(PendingIntentRecord rec, boolean cleanActivity) {
        rec.canceled = true;
        this.mIntentSenderRecords.remove(rec.key);
        if (cleanActivity && rec.key.activity != null) {
            rec.key.activity.pendingResults.remove(rec.ref);
        }
    }

    @Override
    public String getPackageForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.packageName;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    @Override
    public int getUidForIntentSender(IIntentSender sender) {
        if (sender instanceof PendingIntentRecord) {
            try {
                PendingIntentRecord res = (PendingIntentRecord)sender;
                return res.uid;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return -1;
    }

    @Override
    public boolean isIntentSenderTargetedToPackage(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            if (res.key.allIntents == null) {
                return false;
            }
            for (int i = 0; i < res.key.allIntents.length; ++i) {
                Intent intent = res.key.allIntents[i];
                if (intent.getPackage() == null || intent.getComponent() == null) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public boolean isIntentSenderAnActivity(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return false;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.type == 2;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public Intent getIntentForIntentSender(IIntentSender pendingResult) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            return res.key.requestIntent != null ? new Intent(res.key.requestIntent) : null;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getTagForIntentSender(IIntentSender pendingResult, String prefix) {
        if (!(pendingResult instanceof PendingIntentRecord)) {
            return null;
        }
        try {
            PendingIntentRecord res = (PendingIntentRecord)pendingResult;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                return this.getTagForIntentSenderLocked(res, prefix);
            }
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    String getTagForIntentSenderLocked(PendingIntentRecord res, String prefix) {
        Intent intent = res.key.requestIntent;
        if (intent != null) {
            if (res.lastTag != null && res.lastTagPrefix == prefix && (res.lastTagPrefix == null || res.lastTagPrefix.equals(prefix))) {
                return res.lastTag;
            }
            res.lastTagPrefix = prefix;
            StringBuilder sb = new StringBuilder(128);
            if (prefix != null) {
                sb.append(prefix);
            }
            if (intent.getAction() != null) {
                sb.append(intent.getAction());
            } else if (intent.getComponent() != null) {
                intent.getComponent().appendShortString(sb);
            } else {
                sb.append("?");
            }
            res.lastTag = sb.toString();
            return res.lastTag;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessLimit(int max) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessLimit()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessLimit = max < 0 ? 32 : max;
            this.mProcessLimitOverride = max;
        }
        this.trimApplications();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getProcessLimit() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mProcessLimitOverride;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void foregroundTokenDied(ForegroundToken token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ForegroundToken cur = this.mForegroundProcesses.get(token.pid);
                if (cur != token) {
                    return;
                }
                this.mForegroundProcesses.remove(token.pid);
                ProcessRecord pr = this.mPidsSelfLocked.get(token.pid);
                if (pr == null) {
                    return;
                }
                pr.forcingToForeground = null;
                this.updateProcessForegroundLocked(pr, false, false);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProcessForeground(IBinder token, int pid, boolean isForeground) {
        this.enforceCallingPermission("android.permission.SET_PROCESS_LIMIT", "setProcessForeground()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean changed = false;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pid);
                if (pr == null && isForeground) {
                    Slog.w("ActivityManager", "setProcessForeground called on unknown pid: " + pid);
                    return;
                }
                ForegroundToken oldToken = this.mForegroundProcesses.get(pid);
                if (oldToken != null) {
                    oldToken.token.unlinkToDeath(oldToken, 0);
                    this.mForegroundProcesses.remove(pid);
                    if (pr != null) {
                        pr.forcingToForeground = null;
                    }
                    changed = true;
                }
                if (isForeground && token != null) {
                    ForegroundToken newToken = new ForegroundToken(){

                        @Override
                        public void binderDied() {
                            ActivityManagerService.this.foregroundTokenDied(this);
                        }
                    };
                    newToken.pid = pid;
                    newToken.token = token;
                    try {
                        token.linkToDeath(newToken, 0);
                        this.mForegroundProcesses.put(pid, newToken);
                        pr.forcingToForeground = token;
                        changed = true;
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
            }
            if (changed) {
                this.updateOomAdjLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getProcessStatesForPIDs(int[] pids, int[] states) {
        if (pids == null) {
            throw new NullPointerException("pids");
        }
        if (states == null) {
            throw new NullPointerException("states");
        }
        if (pids.length != states.length) {
            throw new IllegalArgumentException("input and output arrays have different lengths!");
        }
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            for (int i = 0; i < pids.length; ++i) {
                ProcessRecord pr = this.mPidsSelfLocked.get(pids[i]);
                states[i] = pr == null ? -1 : pr.curProcState;
            }
        }
    }

    int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
        if (pid == MY_PID) {
            return 0;
        }
        return ActivityManager.checkComponentPermission(permission2, uid, owningUid, exported);
    }

    @Override
    public int checkPermission(String permission2, int pid, int uid) {
        if (permission2 == null) {
            return -1;
        }
        return this.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    @Override
    public int checkPermissionWithToken(String permission2, int pid, int uid, IBinder callerToken) {
        if (permission2 == null) {
            return -1;
        }
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            Slog.d("ActivityManager", "checkComponentPermission() adjusting {pid,uid} to {" + tlsIdentity.pid + "," + tlsIdentity.uid + "}");
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        return this.checkComponentPermission(permission2, pid, uid, -1, true);
    }

    int checkCallingPermission(String permission2) {
        return this.checkPermission(permission2, Binder.getCallingPid(), UserHandle.getAppId(Binder.getCallingUid()));
    }

    void enforceCallingPermission(String permission2, String func) {
        if (this.checkCallingPermission(permission2) == 0) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + permission2;
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    private final boolean checkHoldingPermissionsLocked(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags) {
        if (UserHandle.getUserId(uid) != grantUri.sourceUserId && ActivityManager.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", uid, -1, true) != 0) {
            return false;
        }
        return this.checkHoldingPermissionsInternalLocked(pm, pi, grantUri, uid, modeFlags, true);
    }

    private final boolean checkHoldingPermissionsInternalLocked(IPackageManager pm, ProviderInfo pi, GrantUri grantUri, int uid, int modeFlags, boolean considerUidPermissions) {
        if (pi.applicationInfo.uid == uid) {
            return true;
        }
        if (!pi.exported) {
            return false;
        }
        boolean readMet = (modeFlags & 1) == 0;
        boolean writeMet = (modeFlags & 2) == 0;
        try {
            if (!readMet && pi.readPermission != null && considerUidPermissions && pm.checkUidPermission(pi.readPermission, uid) == 0) {
                readMet = true;
            }
            if (!writeMet && pi.writePermission != null && considerUidPermissions && pm.checkUidPermission(pi.writePermission, uid) == 0) {
                writeMet = true;
            }
            boolean allowDefaultRead = pi.readPermission == null;
            boolean allowDefaultWrite = pi.writePermission == null;
            PathPermission[] pps = pi.pathPermissions;
            if (pps != null) {
                String path = grantUri.uri.getPath();
                int i = pps.length;
                while (!(i <= 0 || readMet && writeMet)) {
                    String ppwperm;
                    String pprperm;
                    PathPermission pp;
                    if (!(pp = pps[--i]).match(path)) continue;
                    if (!readMet && (pprperm = pp.getReadPermission()) != null) {
                        if (considerUidPermissions && pm.checkUidPermission(pprperm, uid) == 0) {
                            readMet = true;
                        } else {
                            allowDefaultRead = false;
                        }
                    }
                    if (writeMet || (ppwperm = pp.getWritePermission()) == null) continue;
                    if (considerUidPermissions && pm.checkUidPermission(ppwperm, uid) == 0) {
                        writeMet = true;
                        continue;
                    }
                    allowDefaultWrite = false;
                }
            }
            if (allowDefaultRead) {
                readMet = true;
            }
            if (allowDefaultWrite) {
                writeMet = true;
            }
        }
        catch (RemoteException e) {
            return false;
        }
        return readMet && writeMet;
    }

    private ProviderInfo getProviderInfoLocked(String authority, int userHandle) {
        ProviderInfo pi = null;
        ContentProviderRecord cpr = this.mProviderMap.getProviderByName(authority, userHandle);
        if (cpr != null) {
            pi = cpr.info;
        } else {
            try {
                pi = AppGlobals.getPackageManager().resolveContentProvider(authority, 2048, userHandle);
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
        return pi;
    }

    private UriPermission findUriPermissionLocked(int targetUid, GrantUri grantUri) {
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris != null) {
            return targetUris.get(grantUri);
        }
        return null;
    }

    private UriPermission findOrCreateUriPermissionLocked(String sourcePkg, String targetPkg, int targetUid, GrantUri grantUri) {
        UriPermission perm;
        ArrayMap<GrantUri, UriPermission> targetUris = this.mGrantedUriPermissions.get(targetUid);
        if (targetUris == null) {
            targetUris = Maps.newArrayMap();
            this.mGrantedUriPermissions.put(targetUid, targetUris);
        }
        if ((perm = targetUris.get(grantUri)) == null) {
            perm = new UriPermission(sourcePkg, targetPkg, targetUid, grantUri);
            targetUris.put(grantUri, perm);
        }
        return perm;
    }

    private final boolean checkUriPermissionLocked(GrantUri grantUri, int uid, int modeFlags) {
        int minStrength;
        boolean persistable = (modeFlags & 0x40) != 0;
        int n = minStrength = persistable ? 3 : 1;
        if (uid == 0) {
            return true;
        }
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        UriPermission exactPerm = perms.get(grantUri);
        if (exactPerm != null && exactPerm.getStrength(modeFlags) >= minStrength) {
            return true;
        }
        int N = perms.size();
        for (int i = 0; i < N; ++i) {
            UriPermission perm = perms.valueAt(i);
            if (!perm.uri.prefix || !grantUri.uri.isPathPrefixMatch(perm.uri.uri) || perm.getStrength(modeFlags) < minStrength) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkUriPermission(Uri uri, int pid, int uid, int modeFlags, int userId, IBinder callerToken) {
        this.enforceNotIsolatedCaller("checkUriPermission");
        Identity tlsIdentity = sCallerIdentity.get();
        if (tlsIdentity != null && tlsIdentity.token == callerToken) {
            uid = tlsIdentity.uid;
            pid = tlsIdentity.pid;
        }
        if (pid == MY_PID) {
            return 0;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkUriPermissionLocked(new GrantUri(userId, uri, false), uid, modeFlags) ? 0 : -1;
        }
    }

    int checkGrantUriPermissionLocked(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, int lastTargetUid) {
        boolean specialCrossUserGrant;
        if (!Intent.isAccessUriMode(modeFlags)) {
            return -1;
        }
        if (targetPkg != null) {
            // empty if block
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (!"content".equals(grantUri.uri.getScheme())) {
            return -1;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for permission check: " + grantUri.uri.toSafeString());
            return -1;
        }
        int targetUid = lastTargetUid;
        if (targetUid < 0 && targetPkg != null) {
            try {
                targetUid = pm.getPackageUid(targetPkg, UserHandle.getUserId(callingUid));
                if (targetUid < 0) {
                    return -1;
                }
            }
            catch (RemoteException ex) {
                return -1;
            }
        }
        if (targetUid >= 0) {
            if (this.checkHoldingPermissionsLocked(pm, pi, grantUri, targetUid, modeFlags)) {
                return -1;
            }
        } else {
            boolean allowed = pi.exported;
            if ((modeFlags & 1) != 0 && pi.readPermission != null) {
                allowed = false;
            }
            if ((modeFlags & 2) != 0 && pi.writePermission != null) {
                allowed = false;
            }
            if (allowed) {
                return -1;
            }
        }
        boolean bl = specialCrossUserGrant = UserHandle.getUserId(targetUid) != grantUri.sourceUserId && this.checkHoldingPermissionsInternalLocked(pm, pi, grantUri, callingUid, modeFlags, false);
        if (!specialCrossUserGrant) {
            if (!pi.grantUriPermissions) {
                throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of Uri permissions (uri " + grantUri + ")");
            }
            if (pi.uriPermissionPatterns != null) {
                int N = pi.uriPermissionPatterns.length;
                boolean allowed = false;
                for (int i = 0; i < N; ++i) {
                    if (pi.uriPermissionPatterns[i] == null || !pi.uriPermissionPatterns[i].match(grantUri.uri.getPath())) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    throw new SecurityException("Provider " + pi.packageName + "/" + pi.name + " does not allow granting of permission to path of Uri " + grantUri);
                }
            }
        }
        if (UserHandle.getAppId(callingUid) != 1000 && !this.checkHoldingPermissionsLocked(pm, pi, grantUri, callingUid, modeFlags) && !this.checkUriPermissionLocked(grantUri, callingUid, modeFlags)) {
            throw new SecurityException("Uid " + callingUid + " does not have permission to uri " + grantUri);
        }
        return targetUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int checkGrantUriPermission(int callingUid, String targetPkg, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("checkGrantUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.checkGrantUriPermissionLocked(callingUid, targetPkg, new GrantUri(userId, uri, false), modeFlags, -1);
        }
    }

    void grantUriPermissionUncheckedLocked(int targetUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner) {
        if (!Intent.isAccessUriMode(modeFlags)) {
            return;
        }
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for grant: " + grantUri.toSafeString());
            return;
        }
        if ((modeFlags & 0x80) != 0) {
            grantUri.prefix = true;
        }
        UriPermission perm = this.findOrCreateUriPermissionLocked(pi.packageName, targetPkg, targetUid, grantUri);
        perm.grantModes(modeFlags, owner);
    }

    void grantUriPermissionLocked(int callingUid, String targetPkg, GrantUri grantUri, int modeFlags, UriPermissionOwner owner, int targetUserId) {
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            targetUid = pm.getPackageUid(targetPkg, targetUserId);
        }
        catch (RemoteException ex) {
            return;
        }
        targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri, modeFlags, targetUid);
        if (targetUid < 0) {
            return;
        }
        this.grantUriPermissionUncheckedLocked(targetUid, targetPkg, grantUri, modeFlags, owner);
    }

    NeededUriGrants checkGrantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, int mode, NeededUriGrants needed, int targetUserId) {
        GrantUri grantUri;
        int targetUid;
        if (targetPkg == null) {
            throw new NullPointerException(ATTR_TARGET_PKG);
        }
        if (intent == null) {
            return null;
        }
        Uri data = intent.getData();
        ClipData clip = intent.getClipData();
        if (data == null && clip == null) {
            return null;
        }
        int contentUserHint = intent.getContentUserHint();
        if (contentUserHint == -2) {
            contentUserHint = UserHandle.getUserId(callingUid);
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (needed != null) {
            targetUid = needed.targetUid;
        } else {
            try {
                targetUid = pm.getPackageUid(targetPkg, targetUserId);
            }
            catch (RemoteException ex) {
                return null;
            }
            if (targetUid < 0) {
                return null;
            }
        }
        if (data != null && (targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri = GrantUri.resolve(contentUserHint, data), mode, targetUid)) > 0) {
            if (needed == null) {
                needed = new NeededUriGrants(targetPkg, targetUid, mode);
            }
            needed.add(grantUri);
        }
        if (clip != null) {
            for (int i = 0; i < clip.getItemCount(); ++i) {
                NeededUriGrants newNeeded;
                Uri uri = clip.getItemAt(i).getUri();
                if (uri != null) {
                    GrantUri grantUri2 = GrantUri.resolve(contentUserHint, uri);
                    targetUid = this.checkGrantUriPermissionLocked(callingUid, targetPkg, grantUri2, mode, targetUid);
                    if (targetUid <= 0) continue;
                    if (needed == null) {
                        needed = new NeededUriGrants(targetPkg, targetUid, mode);
                    }
                    needed.add(grantUri2);
                    continue;
                }
                Intent clipIntent = clip.getItemAt(i).getIntent();
                if (clipIntent == null || (newNeeded = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, clipIntent, mode, needed, targetUserId)) == null) continue;
                needed = newNeeded;
            }
        }
        return needed;
    }

    void grantUriPermissionUncheckedFromIntentLocked(NeededUriGrants needed, UriPermissionOwner owner) {
        if (needed != null) {
            for (int i = 0; i < needed.size(); ++i) {
                GrantUri grantUri = (GrantUri)needed.get(i);
                this.grantUriPermissionUncheckedLocked(needed.targetUid, needed.targetPkg, grantUri, needed.flags, owner);
            }
        }
    }

    void grantUriPermissionFromIntentLocked(int callingUid, String targetPkg, Intent intent, UriPermissionOwner owner, int targetUserId) {
        NeededUriGrants needed = this.checkGrantUriPermissionFromIntentLocked(callingUid, targetPkg, intent, intent != null ? intent.getFlags() : 0, null, targetUserId);
        if (needed == null) {
            return;
        }
        this.grantUriPermissionUncheckedFromIntentLocked(needed, owner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermission(IApplicationThread caller, String targetPkg, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("grantUriPermission");
        GrantUri grantUri = new GrantUri(userId, uri, false);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when granting permission to uri " + grantUri);
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (grantUri == null) {
                throw new IllegalArgumentException("null uri");
            }
            Preconditions.checkFlagsArgument(modeFlags, 195);
            this.grantUriPermissionLocked(r.uid, targetPkg, grantUri, modeFlags, null, UserHandle.getUserId(r.uid));
        }
    }

    void removeUriPermissionIfNeededLocked(UriPermission perm) {
        ArrayMap<GrantUri, UriPermission> perms;
        if (perm.modeFlags == 0 && (perms = this.mGrantedUriPermissions.get(perm.targetUid)) != null) {
            perms.remove(perm.uri);
            if (perms.isEmpty()) {
                this.mGrantedUriPermissions.remove(perm.targetUid);
            }
        }
    }

    private void revokeUriPermissionLocked(int callingUid, GrantUri grantUri, int modeFlags) {
        IPackageManager pm = AppGlobals.getPackageManager();
        String authority = grantUri.uri.getAuthority();
        ProviderInfo pi = this.getProviderInfoLocked(authority, grantUri.sourceUserId);
        if (pi == null) {
            Slog.w("ActivityManager", "No content provider found for permission revoke: " + grantUri.toSafeString());
            return;
        }
        if (!this.checkHoldingPermissionsLocked(pm, pi, grantUri, callingUid, modeFlags)) {
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
            if (perms != null) {
                boolean persistChanged = false;
                Iterator<UriPermission> it = perms.values().iterator();
                while (it.hasNext()) {
                    UriPermission perm = it.next();
                    if (perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                    persistChanged |= perm.revokeModes(modeFlags | 0x40, false);
                    if (perm.modeFlags != 0) continue;
                    it.remove();
                }
                if (perms.isEmpty()) {
                    this.mGrantedUriPermissions.remove(callingUid);
                }
                if (persistChanged) {
                    this.schedulePersistUriGrants();
                }
            }
            return;
        }
        boolean persistChanged = false;
        int N = this.mGrantedUriPermissions.size();
        for (int i = 0; i < N; ++i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            Iterator<UriPermission> it = perms.values().iterator();
            while (it.hasNext()) {
                UriPermission perm = it.next();
                if (perm.uri.sourceUserId != grantUri.sourceUserId || !perm.uri.uri.isPathPrefixMatch(grantUri.uri)) continue;
                persistChanged |= perm.revokeModes(modeFlags | 0x40, true);
                if (perm.modeFlags != 0) continue;
                it.remove();
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.remove(targetUid);
            --N;
            --i;
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermission(IApplicationThread caller, Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("revokeUriPermission");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " when revoking permission to uri " + uri);
            }
            if (uri == null) {
                Slog.w("ActivityManager", "revokeUriPermission: null uri");
                return;
            }
            if (!Intent.isAccessUriMode(modeFlags)) {
                return;
            }
            String authority = uri.getAuthority();
            ProviderInfo pi = this.getProviderInfoLocked(authority, userId);
            if (pi == null) {
                Slog.w("ActivityManager", "No content provider found for permission revoke: " + uri.toSafeString());
                return;
            }
            this.revokeUriPermissionLocked(r.uid, new GrantUri(userId, uri, false), modeFlags);
        }
    }

    private void removeUriPermissionsForPackageLocked(String packageName, int userHandle, boolean persistable) {
        if (userHandle == -1 && packageName == null) {
            throw new IllegalArgumentException("Must narrow by either package or user");
        }
        boolean persistChanged = false;
        int N = this.mGrantedUriPermissions.size();
        for (int i = 0; i < N; ++i) {
            int targetUid = this.mGrantedUriPermissions.keyAt(i);
            ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
            if (userHandle != -1 && userHandle != UserHandle.getUserId(targetUid)) continue;
            Iterator<UriPermission> it = perms.values().iterator();
            while (it.hasNext()) {
                UriPermission perm = it.next();
                if (packageName != null && !perm.sourcePkg.equals(packageName) && !perm.targetPkg.equals(packageName)) continue;
                persistChanged |= perm.revokeModes(persistable ? -1 : -65, true);
                if (perm.modeFlags != 0) continue;
                it.remove();
            }
            if (!perms.isEmpty()) continue;
            this.mGrantedUriPermissions.remove(targetUid);
            --N;
            --i;
        }
        if (persistChanged) {
            this.schedulePersistUriGrants();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder newUriPermissionOwner(String name) {
        this.enforceNotIsolatedCaller("newUriPermissionOwner");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = new UriPermissionOwner(this, name);
            return owner.getExternalTokenLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void grantUriPermissionFromOwner(IBinder token, int fromUid, String targetPkg, Uri uri, int modeFlags, int sourceUserId, int targetUserId) {
        targetUserId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), targetUserId, false, 2, "grantUriPermissionFromOwner", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (fromUid != Binder.getCallingUid() && Binder.getCallingUid() != android.os.Process.myUid()) {
                throw new SecurityException("nice try");
            }
            if (targetPkg == null) {
                throw new IllegalArgumentException("null target");
            }
            if (uri == null) {
                throw new IllegalArgumentException("null uri");
            }
            this.grantUriPermissionLocked(fromUid, targetPkg, new GrantUri(sourceUserId, uri, false), modeFlags, owner, targetUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeUriPermissionFromOwner(IBinder token, Uri uri, int mode, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UriPermissionOwner owner = UriPermissionOwner.fromExternalToken(token);
            if (owner == null) {
                throw new IllegalArgumentException("Unknown owner: " + token);
            }
            if (uri == null) {
                owner.removeUriPermissionsLocked(mode);
            } else {
                owner.removeUriPermissionLocked(new GrantUri(userId, uri, false), mode);
            }
        }
    }

    private void schedulePersistUriGrants() {
        if (!this.mHandler.hasMessages(38)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(38), 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGrantedUriPermissions() {
        block8: {
            ArrayList<UriPermission.Snapshot> persist = Lists.newArrayList();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (UriPermission perm : perms.values()) {
                        if (perm.persistedModeFlags == 0) continue;
                        persist.add(perm.snapshot());
                    }
                }
            }
            FileOutputStream fos = null;
            try {
                fos = this.mGrantFile.startWrite();
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(fos, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, TAG_URI_GRANTS);
                for (UriPermission.Snapshot perm : persist) {
                    out.startTag(null, TAG_URI_GRANT);
                    XmlUtils.writeIntAttribute(out, ATTR_SOURCE_USER_ID, perm.uri.sourceUserId);
                    XmlUtils.writeIntAttribute(out, ATTR_TARGET_USER_ID, perm.targetUserId);
                    out.attribute(null, ATTR_SOURCE_PKG, perm.sourcePkg);
                    out.attribute(null, ATTR_TARGET_PKG, perm.targetPkg);
                    out.attribute(null, ATTR_URI, String.valueOf(perm.uri.uri));
                    XmlUtils.writeBooleanAttribute(out, ATTR_PREFIX, perm.uri.prefix);
                    XmlUtils.writeIntAttribute(out, ATTR_MODE_FLAGS, perm.persistedModeFlags);
                    XmlUtils.writeLongAttribute(out, ATTR_CREATED_TIME, perm.persistedCreateTime);
                    out.endTag(null, TAG_URI_GRANT);
                }
                out.endTag(null, TAG_URI_GRANTS);
                out.endDocument();
                this.mGrantFile.finishWrite(fos);
            }
            catch (IOException e) {
                if (fos == null) break block8;
                this.mGrantFile.failWrite(fos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readGrantedUriPermissionsLocked() {
        long now = System.currentTimeMillis();
        FileInputStream fis = null;
        try {
            int type;
            fis = this.mGrantFile.openRead();
            XmlPullParser in = Xml.newPullParser();
            in.setInput(fis, StandardCharsets.UTF_8.name());
            while ((type = in.next()) != 1) {
                int targetUserId;
                int sourceUserId;
                String tag = in.getName();
                if (type != 2 || !TAG_URI_GRANT.equals(tag)) continue;
                int userHandle = XmlUtils.readIntAttribute(in, ATTR_USER_HANDLE, -10000);
                if (userHandle != -10000) {
                    sourceUserId = userHandle;
                    targetUserId = userHandle;
                } else {
                    sourceUserId = XmlUtils.readIntAttribute(in, ATTR_SOURCE_USER_ID);
                    targetUserId = XmlUtils.readIntAttribute(in, ATTR_TARGET_USER_ID);
                }
                String sourcePkg = in.getAttributeValue(null, ATTR_SOURCE_PKG);
                String targetPkg = in.getAttributeValue(null, ATTR_TARGET_PKG);
                Uri uri = Uri.parse(in.getAttributeValue(null, ATTR_URI));
                boolean prefix = XmlUtils.readBooleanAttribute(in, ATTR_PREFIX);
                int modeFlags = XmlUtils.readIntAttribute(in, ATTR_MODE_FLAGS);
                long createdTime = XmlUtils.readLongAttribute(in, ATTR_CREATED_TIME, now);
                ProviderInfo pi = this.getProviderInfoLocked(uri.getAuthority(), sourceUserId);
                if (pi != null && sourcePkg.equals(pi.packageName)) {
                    int targetUid = -1;
                    try {
                        targetUid = AppGlobals.getPackageManager().getPackageUid(targetPkg, targetUserId);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                    if (targetUid == -1) continue;
                    UriPermission perm = this.findOrCreateUriPermissionLocked(sourcePkg, targetPkg, targetUid, new GrantUri(sourceUserId, uri, prefix));
                    perm.initPersistedModes(modeFlags, createdTime);
                    continue;
                }
                Slog.w("ActivityManager", "Persisted grant for " + uri + " had source " + sourcePkg + " but instead found " + pi);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.wtf("ActivityManager", "Failed reading Uri grants", e);
        }
        catch (XmlPullParserException e) {
            Slog.wtf("ActivityManager", "Failed reading Uri grants", e);
        }
        finally {
            IoUtils.closeQuietly(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void takePersistableUriPermission(Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("takePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean prefixValid;
            int callingUid = Binder.getCallingUid();
            boolean persistChanged = false;
            GrantUri grantUri = new GrantUri(userId, uri, false);
            UriPermission exactPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, false));
            UriPermission prefixPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, true));
            boolean exactValid = exactPerm != null && (modeFlags & exactPerm.persistableModeFlags) == modeFlags;
            boolean bl = prefixValid = prefixPerm != null && (modeFlags & prefixPerm.persistableModeFlags) == modeFlags;
            if (!exactValid && !prefixValid) {
                throw new SecurityException("No persistable permission grants found for UID " + callingUid + " and Uri " + grantUri.toSafeString());
            }
            if (exactValid) {
                persistChanged |= exactPerm.takePersistableModes(modeFlags);
            }
            if (prefixValid) {
                persistChanged |= prefixPerm.takePersistableModes(modeFlags);
            }
            if (persistChanged |= this.maybePrunePersistedUriGrantsLocked(callingUid)) {
                this.schedulePersistUriGrants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releasePersistableUriPermission(Uri uri, int modeFlags, int userId) {
        this.enforceNotIsolatedCaller("releasePersistableUriPermission");
        Preconditions.checkFlagsArgument(modeFlags, 3);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingUid = Binder.getCallingUid();
            boolean persistChanged = false;
            UriPermission exactPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, false));
            UriPermission prefixPerm = this.findUriPermissionLocked(callingUid, new GrantUri(userId, uri, true));
            if (exactPerm == null && prefixPerm == null) {
                throw new SecurityException("No permission grants found for UID " + callingUid + " and Uri " + uri.toSafeString());
            }
            if (exactPerm != null) {
                persistChanged |= exactPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeededLocked(exactPerm);
            }
            if (prefixPerm != null) {
                persistChanged |= prefixPerm.releasePersistableModes(modeFlags);
                this.removeUriPermissionIfNeededLocked(prefixPerm);
            }
            if (persistChanged) {
                this.schedulePersistUriGrants();
            }
        }
    }

    private boolean maybePrunePersistedUriGrantsLocked(int uid) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(uid);
        if (perms == null) {
            return false;
        }
        if (perms.size() < 128) {
            return false;
        }
        ArrayList<UriPermission> persisted = Lists.newArrayList();
        for (UriPermission perm : perms.values()) {
            if (perm.persistedModeFlags == 0) continue;
            persisted.add(perm);
        }
        int trimCount = persisted.size() - 128;
        if (trimCount <= 0) {
            return false;
        }
        Collections.sort(persisted, new UriPermission.PersistedTimeComparator());
        for (int i = 0; i < trimCount; ++i) {
            UriPermission perm = (UriPermission)persisted.get(i);
            perm.releasePersistableModes(-1);
            this.removeUriPermissionIfNeededLocked(perm);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParceledListSlice<android.content.UriPermission> getPersistedUriPermissions(String packageName, boolean incoming) {
        this.enforceNotIsolatedCaller("getPersistedUriPermissions");
        Preconditions.checkNotNull(packageName, "packageName");
        int callingUid = Binder.getCallingUid();
        IPackageManager pm = AppGlobals.getPackageManager();
        try {
            int packageUid = pm.getPackageUid(packageName, UserHandle.getUserId(callingUid));
            if (packageUid != callingUid) {
                throw new SecurityException("Package " + packageName + " does not belong to calling UID " + callingUid);
            }
        }
        catch (RemoteException e) {
            throw new SecurityException("Failed to verify package name ownership");
        }
        ArrayList<android.content.UriPermission> result = Lists.newArrayList();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (incoming) {
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
                if (perms == null) {
                    Slog.w("ActivityManager", "No permission grants found for " + packageName);
                } else {
                    for (UriPermission perm : perms.values()) {
                        if (!packageName.equals(perm.targetPkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            } else {
                int size = this.mGrantedUriPermissions.size();
                for (int i = 0; i < size; ++i) {
                    ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                    for (UriPermission perm : perms.values()) {
                        if (!packageName.equals(perm.sourcePkg) || perm.persistedModeFlags == 0) continue;
                        result.add(perm.buildPersistedPublicApiObject());
                    }
                }
            }
        }
        return new ParceledListSlice<android.content.UriPermission>(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showWaitingForDebugger(IApplicationThread who, boolean waiting) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app;
            ProcessRecord processRecord = app = who != null ? this.getRecordForAppLocked(who) : null;
            if (app == null) {
                return;
            }
            Message msg = Message.obtain();
            msg.what = 6;
            msg.obj = app;
            msg.arg1 = waiting ? 1 : 0;
            this.mUiHandler.sendMessage(msg);
        }
    }

    @Override
    public void getMemoryInfo(ActivityManager.MemoryInfo outInfo) {
        long homeAppMem = this.mProcessList.getMemLevel(6);
        long cachedAppMem = this.mProcessList.getMemLevel(9);
        outInfo.availMem = android.os.Process.getFreeMemory();
        outInfo.totalMem = android.os.Process.getTotalMemory();
        outInfo.threshold = homeAppMem;
        outInfo.lowMemory = outInfo.availMem < homeAppMem + (cachedAppMem - homeAppMem) / 2L;
        outInfo.hiddenAppThreshold = cachedAppMem;
        outInfo.secondaryServerThreshold = this.mProcessList.getMemLevel(5);
        outInfo.visibleAppThreshold = this.mProcessList.getMemLevel(1);
        outInfo.foregroundAppThreshold = this.mProcessList.getMemLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IAppTask> getAppTasks(String callingPackage) {
        int callingUid = Binder.getCallingUid();
        long ident = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ArrayList<IAppTask> list = new ArrayList<IAppTask>();
            try {
                int N = this.mRecentTasks.size();
                for (int i = 0; i < N; ++i) {
                    Intent intent;
                    TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                    if (tr.effectiveUid != callingUid || (intent = tr.getBaseIntent()) == null || !callingPackage.equals(intent.getComponent().getPackageName())) continue;
                    ActivityManager.RecentTaskInfo taskInfo = this.createRecentTaskInfoFromTaskRecord(tr);
                    AppTaskImpl taskImpl = new AppTaskImpl(taskInfo.persistentId, callingUid);
                    list.add(taskImpl);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningTaskInfo> getTasks(int maxNum, int flags) {
        int callingUid = Binder.getCallingUid();
        ArrayList<ActivityManager.RunningTaskInfo> list = new ArrayList<ActivityManager.RunningTaskInfo>();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean allowed = this.isGetTasksAllowed("getTasks", Binder.getCallingPid(), callingUid);
            this.mStackSupervisor.getTasksLocked(maxNum, list, callingUid, allowed);
        }
        return list;
    }

    private ActivityManager.RecentTaskInfo createRecentTaskInfoFromTaskRecord(TaskRecord tr) {
        tr.updateTaskDescription();
        ActivityManager.RecentTaskInfo rti = new ActivityManager.RecentTaskInfo();
        rti.id = tr.getTopActivity() == null ? -1 : tr.taskId;
        rti.persistentId = tr.taskId;
        rti.baseIntent = new Intent(tr.getBaseIntent());
        rti.origActivity = tr.origActivity;
        rti.description = tr.lastDescription;
        rti.stackId = tr.stack != null ? tr.stack.mStackId : -1;
        rti.userId = tr.userId;
        rti.taskDescription = new ActivityManager.TaskDescription(tr.lastTaskDescription);
        rti.firstActiveTime = tr.firstActiveTime;
        rti.lastActiveTime = tr.lastActiveTime;
        rti.affiliatedTaskId = tr.mAffiliatedTaskId;
        rti.affiliatedTaskColor = tr.mAffiliatedTaskColor;
        rti.numActivities = 0;
        ActivityRecord base = null;
        ActivityRecord top = null;
        for (int i = tr.mActivities.size() - 1; i >= 0; --i) {
            ActivityRecord tmp = tr.mActivities.get(i);
            if (tmp.finishing) continue;
            base = tmp;
            if (top == null || top.state == ActivityStack.ActivityState.INITIALIZING) {
                top = base;
            }
            ++rti.numActivities;
        }
        rti.baseActivity = base != null ? base.intent.getComponent() : null;
        rti.topActivity = top != null ? top.intent.getComponent() : null;
        return rti;
    }

    private boolean isGetTasksAllowed(String caller, int callingPid, int callingUid) {
        boolean allowed;
        boolean bl = allowed = this.checkPermission("android.permission.REAL_GET_TASKS", callingPid, callingUid) == 0;
        if (!allowed && this.checkPermission("android.permission.GET_TASKS", callingPid, callingUid) == 0) {
            try {
                if (AppGlobals.getPackageManager().isUidPrivileged(callingUid)) {
                    allowed = true;
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (!allowed) {
            // empty if block
        }
        return allowed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RecentTaskInfo> getRecentTasks(int maxNum, int flags, int userId) {
        int callingUid = Binder.getCallingUid();
        userId = this.handleIncomingUser(Binder.getCallingPid(), callingUid, userId, false, 2, "getRecentTasks", null);
        boolean includeProfiles = (flags & 4) != 0;
        boolean withExcluded = (flags & 1) != 0;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean allowed = this.isGetTasksAllowed("getRecentTasks", Binder.getCallingPid(), callingUid);
            boolean detailed = this.checkCallingPermission("android.permission.GET_DETAILED_TASKS") == 0;
            int recentsCount = this.mRecentTasks.size();
            ArrayList<ActivityManager.RecentTaskInfo> res = new ArrayList<ActivityManager.RecentTaskInfo>(maxNum < recentsCount ? maxNum : recentsCount);
            Set<Integer> includedUsers = includeProfiles ? this.getProfileIdsLocked(userId) : new HashSet<Integer>();
            includedUsers.add(userId);
            for (int i = 0; i < recentsCount && maxNum > 0; ++i) {
                TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                if (!includedUsers.contains(tr.userId) || i != 0 && !withExcluded && tr.intent != null && (tr.intent.getFlags() & 0x800000) != 0 || !allowed && !tr.isHomeTask() && tr.effectiveUid != callingUid || (flags & 8) != 0 && tr.stack != null && tr.stack.isHomeStack() || tr.autoRemoveRecents && tr.getTopActivity() == null || (flags & 2) != 0 && !tr.isAvailable) continue;
                ActivityManager.RecentTaskInfo rti = this.createRecentTaskInfoFromTaskRecord(tr);
                if (!detailed) {
                    rti.baseIntent.replaceExtras((Bundle)null);
                }
                res.add(rti);
                --maxNum;
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.TaskThumbnail getTaskThumbnail(int id2) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.enforceCallingPermission("android.permission.READ_FRAME_BUFFER", "getTaskThumbnail()");
            TaskRecord tr = this.mStackSupervisor.anyTaskForIdLocked(id2, false);
            if (tr != null) {
                return tr.getTaskThumbnailLocked();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int addAppTask(IBinder activityToken, Intent intent, ActivityManager.TaskDescription description, Bitmap thumbnail) throws RemoteException {
        TaskRecord task;
        ActivityRecord r;
        long callingIdent;
        block19: {
            int n;
            int callingUid = Binder.getCallingUid();
            callingIdent = Binder.clearCallingIdentity();
            try {
                int trimIdx;
                ActivityInfo ainfo;
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(activityToken);
                if (r == null) {
                    throw new IllegalArgumentException("Activity does not exist; token=" + activityToken);
                }
                ComponentName comp = intent.getComponent();
                if (comp == null) {
                    throw new IllegalArgumentException("Intent " + intent + " must specify explicit component");
                }
                if (thumbnail.getWidth() != this.mThumbnailWidth) throw new IllegalArgumentException("Bad thumbnail size: got " + thumbnail.getWidth() + "x" + thumbnail.getHeight() + ", require " + this.mThumbnailWidth + "x" + this.mThumbnailHeight);
                if (thumbnail.getHeight() != this.mThumbnailHeight) {
                    throw new IllegalArgumentException("Bad thumbnail size: got " + thumbnail.getWidth() + "x" + thumbnail.getHeight() + ", require " + this.mThumbnailWidth + "x" + this.mThumbnailHeight);
                }
                if (intent.getSelector() != null) {
                    intent.setSelector(null);
                }
                if (intent.getSourceBounds() != null) {
                    intent.setSourceBounds(null);
                }
                if ((intent.getFlags() & 0x80000) != 0) {
                    if ((intent.getFlags() & 0x2000) == 0) {
                        intent.addFlags(8192);
                    }
                } else if ((intent.getFlags() & 0x10000000) != 0) {
                    intent.addFlags(0x10000000);
                }
                if (!comp.equals(this.mLastAddedTaskComponent) || callingUid != this.mLastAddedTaskUid) {
                    this.mLastAddedTaskActivity = null;
                }
                if ((ainfo = this.mLastAddedTaskActivity) == null) {
                    ainfo = this.mLastAddedTaskActivity = AppGlobals.getPackageManager().getActivityInfo(comp, 0, UserHandle.getUserId(callingUid));
                    if (ainfo.applicationInfo.uid != callingUid) {
                        throw new SecurityException("Can't add task for another application: target uid=" + ainfo.applicationInfo.uid + ", calling uid=" + callingUid);
                    }
                }
                if ((trimIdx = this.mRecentTasks.trimForTaskLocked(task = new TaskRecord(this, this.mStackSupervisor.getNextTaskId(), ainfo, intent, description), false)) < 0) break block19;
                n = -1;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(callingIdent);
                throw throwable;
            }
            Binder.restoreCallingIdentity(callingIdent);
            return n;
        }
        int N = this.mRecentTasks.size();
        if (N >= ActivityManager.getMaxRecentTasksStatic() - 1) {
            TaskRecord tr = (TaskRecord)this.mRecentTasks.remove(N - 1);
            tr.removedFromRecents();
        }
        task.inRecents = true;
        this.mRecentTasks.add(task);
        r.task.stack.addTask(task, false, false);
        task.setLastThumbnail(thumbnail);
        task.freeLastThumbnail();
        int n = task.taskId;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(callingIdent);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point getAppTaskThumbnailSize() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return new Point(this.mThumbnailWidth, this.mThumbnailHeight);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaskDescription(IBinder token, ActivityManager.TaskDescription td) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                r.setTaskDescription(td);
                r.task.updateTaskDescription();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTaskResizeable(int taskId, boolean resizeable) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId, false);
            if (task == null) {
                Slog.w("ActivityManager", "setTaskResizeable: taskId=" + taskId + " not found");
                return;
            }
            if (task.mResizeable != resizeable) {
                task.mResizeable = resizeable;
                this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
                this.mStackSupervisor.resumeTopActivitiesLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeTask(int taskId, Rect bounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeTask()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord task;
                block8: {
                    task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                    if (task != null) break block8;
                    Slog.w("ActivityManager", "resizeTask: taskId=" + taskId + " not found");
                    return;
                }
                this.mStackSupervisor.resizeTaskLocked(task, bounds);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public Bitmap getTaskDescriptionIcon(String filename) {
        if (!FileUtils.isValidExtFilename(filename) || !filename.contains("_activity_icon_")) {
            throw new IllegalArgumentException("Bad filename: " + filename);
        }
        return this.mTaskPersister.getTaskDescriptionIcon(filename);
    }

    @Override
    public void startInPlaceAnimationOnFrontMostApplication(ActivityOptions opts) throws RemoteException {
        if (opts.getAnimationType() != 10 || opts.getCustomInPlaceResId() == 0) {
            throw new IllegalArgumentException("Expected in-place ActivityOption with valid animation");
        }
        this.mWindowManager.prepareAppTransition(17, false);
        this.mWindowManager.overridePendingAppTransitionInPlace(opts.getPackageName(), opts.getCustomInPlaceResId());
        this.mWindowManager.executeAppTransition();
    }

    private void cleanUpRemovedTaskLocked(TaskRecord tr, boolean killProcess) {
        int i;
        this.mRecentTasks.remove(tr);
        tr.removedFromRecents();
        ComponentName component = tr.getBaseIntent().getComponent();
        if (component == null) {
            Slog.w("ActivityManager", "No component for base intent of task: " + tr);
            return;
        }
        this.mServices.cleanUpRemovedTaskLocked(tr, component, new Intent(tr.getBaseIntent()));
        if (!killProcess) {
            return;
        }
        String pkg = component.getPackageName();
        ArrayList<ProcessRecord> procsToKill = new ArrayList<ProcessRecord>();
        ArrayMap<String, SparseArray<ProcessRecord>> pmap = this.mProcessNames.getMap();
        for (i = 0; i < pmap.size(); ++i) {
            SparseArray<ProcessRecord> uids = pmap.valueAt(i);
            for (int j = 0; j < uids.size(); ++j) {
                ProcessRecord proc = uids.valueAt(j);
                if (proc.userId != tr.userId || proc == this.mHomeProcess || !proc.pkgList.containsKey(pkg)) continue;
                for (int k = 0; k < proc.activities.size(); ++k) {
                    TaskRecord otherTask = proc.activities.get((int)k).task;
                    if (tr.taskId == otherTask.taskId || !otherTask.inRecents) continue;
                    return;
                }
                if (proc.foregroundServices) {
                    return;
                }
                procsToKill.add(proc);
            }
        }
        for (i = 0; i < procsToKill.size(); ++i) {
            ProcessRecord pr = (ProcessRecord)procsToKill.get(i);
            if (pr.setSchedGroup == 0 && pr.curReceiver == null) {
                pr.kill("remove task", true);
                continue;
            }
            pr.waitingToKill = "remove task";
        }
    }

    private void removeTasksByPackageNameLocked(String packageName, int userId) {
        for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
            ComponentName cn;
            TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
            if (tr.userId != userId || (cn = tr.intent.getComponent()) == null || !cn.getPackageName().equals(packageName)) continue;
            this.removeTaskByIdLocked(tr.taskId, true);
        }
    }

    private void cleanupDisabledPackageTasksLocked(String packageName, Set<String> filterByClasses, int userId) {
        for (int i = this.mRecentTasks.size() - 1; i >= 0; --i) {
            boolean sameComponent;
            TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
            if (userId != -1 && tr.userId != userId) continue;
            ComponentName cn = tr.intent.getComponent();
            boolean bl = sameComponent = cn != null && cn.getPackageName().equals(packageName) && (filterByClasses == null || filterByClasses.contains(cn.getClassName()));
            if (!sameComponent) continue;
            this.removeTaskByIdLocked(tr.taskId, false);
        }
    }

    private boolean removeTaskByIdLocked(int taskId, boolean killProcess) {
        TaskRecord tr = this.mStackSupervisor.anyTaskForIdLocked(taskId, false);
        if (tr != null) {
            tr.removeTaskActivitiesLocked();
            this.cleanUpRemovedTaskLocked(tr, killProcess);
            if (tr.isPersistable) {
                this.notifyTaskPersisterLocked(null, true);
            }
            return true;
        }
        Slog.w("ActivityManager", "Request to remove task ignored for non-existent task " + taskId);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTask(int taskId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean bl;
            this.enforceCallingPermission("android.permission.REMOVE_TASKS", "removeTask()");
            long ident = Binder.clearCallingIdentity();
            try {
                bl = this.removeTaskByIdLocked(taskId, true);
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(ident);
                throw throwable;
            }
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToFront(int taskId, int flags, Bundle options) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskToFront()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.moveTaskToFrontLocked(taskId, flags, options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveTaskToFrontLocked(int taskId, int flags, Bundle options) {
        if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), -1, -1, "Task to front")) {
            ActivityOptions.abort(options);
            return;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
            if (task == null) {
                Slog.d("ActivityManager", "Could not find task for id: " + taskId);
                return;
            }
            if (this.mStackSupervisor.isLockTaskModeViolation(task)) {
                this.mStackSupervisor.showLockTaskToast();
                Slog.e("ActivityManager", "moveTaskToFront: Attempt to violate Lock Task Mode");
                return;
            }
            ActivityRecord prev = this.mStackSupervisor.topRunningActivityLocked();
            if (prev != null && prev.isRecentsActivity()) {
                task.setTaskToReturnTo(2);
            }
            this.mStackSupervisor.findTaskToMoveToFrontLocked(task, flags, options, "moveTaskToFront");
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        ActivityOptions.abort(options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean moveActivityTaskToBack(IBinder token, boolean nonRoot) {
        this.enforceNotIsolatedCaller("moveActivityTaskToBack");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                int taskId = ActivityRecord.getTaskForActivityLocked(token, !nonRoot);
                TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
                if (task == null) return false;
                if (this.mStackSupervisor.isLockedTask(task)) {
                    this.mStackSupervisor.showLockTaskToast();
                    boolean bl = false;
                    return bl;
                }
                boolean bl = ActivityRecord.getStackLocked(token).moveTaskToBackLocked(taskId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskBackwards(int task) {
        this.enforceCallingPermission("android.permission.REORDER_TASKS", "moveTaskBackwards()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.checkAppSwitchAllowedLocked(Binder.getCallingPid(), Binder.getCallingUid(), -1, -1, "Task backwards")) {
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.moveTaskBackwardsLocked(task);
            Binder.restoreCallingIdentity(origId);
        }
    }

    private final void moveTaskBackwardsLocked(int task) {
        Slog.e("ActivityManager", "moveTaskBackwards not yet implemented!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActivityContainer createVirtualActivityContainer(IBinder parentActivityToken, IActivityContainerCallback callback) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "createActivityContainer()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (parentActivityToken == null) {
                throw new IllegalArgumentException("parent token must not be null");
            }
            ActivityRecord r = ActivityRecord.forTokenLocked(parentActivityToken);
            if (r == null) {
                return null;
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback must not be null");
            }
            return this.mStackSupervisor.createVirtualActivityContainer(r, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteActivityContainer(IActivityContainer container) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "deleteActivityContainer()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mStackSupervisor.deleteActivityContainer(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IActivityContainer createStackOnDisplay(int displayId) throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "createStackOnDisplay()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int stackId = this.mStackSupervisor.getNextStackId();
            ActivityStack stack = this.mStackSupervisor.createStackOnDisplay(stackId, displayId);
            if (stack == null) {
                return null;
            }
            return stack.mActivityContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActivityDisplayId(IBinder activityToken) throws RemoteException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityStack stack = ActivityRecord.getStackLocked(activityToken);
            if (stack != null && stack.mActivityContainer.isAttachedLocked()) {
                return stack.mActivityContainer.getDisplayId();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTaskToStack(int taskId, int stackId, boolean toTop) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "moveTaskToStack()");
        if (stackId == 0) {
            Slog.e("ActivityManager", "moveTaskToStack: Attempt to move task " + taskId + " to home stack", new RuntimeException("here").fillInStackTrace());
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mStackSupervisor.moveTaskToStackLocked(taskId, stackId, toTop);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resizeStack(int stackId, Rect bounds) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "resizeStack()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mStackSupervisor.resizeStackLocked(stackId, bounds);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.StackInfo> getAllStackInfos() {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getAllStackInfos()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ArrayList<ActivityManager.StackInfo> arrayList = this.mStackSupervisor.getAllStackInfosLocked();
                return arrayList;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ActivityManager.StackInfo getStackInfo(int stackId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getStackInfo()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityManager.StackInfo stackInfo = this.mStackSupervisor.getStackInfoLocked(stackId);
                return stackInfo;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInHomeStack(int taskId) {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "getStackInfo()");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                TaskRecord tr = this.mStackSupervisor.anyTaskForIdLocked(taskId, false);
                boolean bl = tr != null && tr.stack != null && tr.stack.isHomeStack();
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTaskForActivity(IBinder token, boolean onlyRoot) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return ActivityRecord.getTaskForActivityLocked(token, onlyRoot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDeviceOwner(String packageName) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("updateDeviceOwner called from non-system process");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mDeviceOwnerName = packageName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLockTaskPackages(int userId, String[] packages) {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != 1000) {
            throw new SecurityException("updateLockTaskPackage called from non-system process");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mLockTaskPackages.put(userId, packages);
            this.mStackSupervisor.onLockTaskPackagesUpdatedLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startLockTaskModeLocked(TaskRecord task) {
        if (task.mLockTaskAuth == 0) {
            return;
        }
        int callingUid = Binder.getCallingUid();
        boolean isSystemInitiated = callingUid == 1000;
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityStack stack = this.mStackSupervisor.getFocusedStack();
            if (!isSystemInitiated) {
                task.mLockTaskUid = callingUid;
                if (task.mLockTaskAuth == 1) {
                    StatusBarManagerInternal statusBarManager = LocalServices.getService(StatusBarManagerInternal.class);
                    if (statusBarManager != null) {
                        statusBarManager.showScreenPinningRequest();
                    }
                    return;
                }
                if (stack == null || task != stack.topTask()) {
                    throw new IllegalArgumentException("Invalid task, not in foreground");
                }
            }
            this.mStackSupervisor.setLockTaskModeLocked(task, isSystemInitiated ? 2 : 1, "startLockTask", true);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLockTaskMode(int taskId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            TaskRecord task = this.mStackSupervisor.anyTaskForIdLocked(taskId);
            if (task != null) {
                this.startLockTaskModeLocked(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLockTaskMode(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r == null) {
                return;
            }
            TaskRecord task = r.task;
            if (task != null) {
                this.startLockTaskModeLocked(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startLockTaskModeOnCurrent() throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "startLockTaskModeOnCurrent");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityRecord r = this.mStackSupervisor.topRunningActivityLocked();
                if (r != null) {
                    this.startLockTaskModeLocked(r.task);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLockTaskMode() {
        TaskRecord lockTask = this.mStackSupervisor.getLockedTaskLocked();
        if (lockTask == null) {
            return;
        }
        int callingUid = Binder.getCallingUid();
        int lockTaskUid = lockTask.mLockTaskUid;
        if (this.getLockTaskModeState() == 1 && callingUid != lockTaskUid && (lockTaskUid != 0 || lockTaskUid == 0 && callingUid != lockTask.effectiveUid)) {
            throw new SecurityException("Invalid uid, expected " + lockTaskUid + " callingUid=" + callingUid + " effectiveUid=" + lockTask.effectiveUid);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            Log.d("ActivityManager", "stopLockTaskMode");
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.mStackSupervisor.setLockTaskModeLocked(null, 0, "stopLockTask", true);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopLockTaskModeOnCurrent() throws RemoteException {
        this.enforceCallingPermission("android.permission.MANAGE_ACTIVITY_STACKS", "stopLockTaskModeOnCurrent");
        long ident = Binder.clearCallingIdentity();
        try {
            this.stopLockTaskMode();
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean isInLockTaskMode() {
        return this.getLockTaskModeState() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLockTaskModeState() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mStackSupervisor.getLockTaskModeState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showLockTaskEscapeMessage(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r == null) {
                return;
            }
            this.mStackSupervisor.showLockTaskEscapeMessageLocked(r.task);
        }
    }

    private final List<ProviderInfo> generateApplicationProvidersLocked(ProcessRecord app) {
        List providers = null;
        try {
            ParceledListSlice slice = AppGlobals.getPackageManager().queryContentProviders(app.processName, app.uid, 3072);
            providers = slice != null ? slice.getList() : null;
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        int userId = app.userId;
        if (providers != null) {
            int N = providers.size();
            app.pubProviders.ensureCapacity(N + app.pubProviders.size());
            for (int i = 0; i < N; ++i) {
                ProviderInfo cpi = (ProviderInfo)providers.get(i);
                boolean singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags);
                if (singleton && UserHandle.getUserId(app.uid) != 0) {
                    providers.remove(i);
                    --N;
                    --i;
                    continue;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                ContentProviderRecord cpr = this.mProviderMap.getProviderByClass(comp, userId);
                if (cpr == null) {
                    cpr = new ContentProviderRecord(this, cpi, app.info, comp, singleton);
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                app.pubProviders.put(cpi.name, cpr);
                if (!cpi.multiprocess || !"android".equals(cpi.packageName)) {
                    app.addPackage(cpi.applicationInfo.packageName, cpi.applicationInfo.versionCode, this.mProcessStats);
                }
                this.ensurePackageDexOpt(cpi.applicationInfo.packageName);
            }
        }
        return providers;
    }

    private final String checkContentProviderPermissionLocked(ProviderInfo cpi, ProcessRecord r, int userId, boolean checkUser) {
        int callingPid = r != null ? r.pid : Binder.getCallingPid();
        int callingUid = r != null ? r.uid : Binder.getCallingUid();
        boolean checkedGrants = false;
        if (checkUser) {
            int tmpTargetUserId = this.unsafeConvertIncomingUser(userId);
            if (tmpTargetUserId != UserHandle.getUserId(callingUid)) {
                if (this.checkAuthorityGrants(callingUid, cpi, tmpTargetUserId, checkUser)) {
                    return null;
                }
                checkedGrants = true;
            }
            if ((userId = this.handleIncomingUser(callingPid, callingUid, userId, false, 0, "checkContentProviderPermissionLocked " + cpi.authority, null)) != tmpTargetUserId) {
                checkedGrants = false;
            }
        }
        if (this.checkComponentPermission(cpi.readPermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        if (this.checkComponentPermission(cpi.writePermission, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
            return null;
        }
        PathPermission[] pps = cpi.pathPermissions;
        if (pps != null) {
            int i = pps.length;
            while (i > 0) {
                PathPermission pp;
                String pprperm;
                if ((pprperm = (pp = pps[--i]).getReadPermission()) != null && this.checkComponentPermission(pprperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) == 0) {
                    return null;
                }
                String ppwperm = pp.getWritePermission();
                if (ppwperm == null || this.checkComponentPermission(ppwperm, callingPid, callingUid, cpi.applicationInfo.uid, cpi.exported) != 0) continue;
                return null;
            }
        }
        if (!checkedGrants && this.checkAuthorityGrants(callingUid, cpi, userId, checkUser)) {
            return null;
        }
        String msg = !cpi.exported ? "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") that is not exported from uid " + cpi.applicationInfo.uid : "Permission Denial: opening provider " + cpi.name + " from " + (r != null ? r : "(null)") + " (pid=" + callingPid + ", uid=" + callingUid + ") requires " + cpi.readPermission + " or " + cpi.writePermission;
        Slog.w("ActivityManager", msg);
        return msg;
    }

    boolean checkAuthorityGrants(int callingUid, ProviderInfo cpi, int userId, boolean checkUser) {
        ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.get(callingUid);
        if (perms != null) {
            for (int i = perms.size() - 1; i >= 0; --i) {
                GrantUri grantUri = perms.keyAt(i);
                if (grantUri.sourceUserId != userId && checkUser || !this.matchesProvider(grantUri.uri, cpi)) continue;
                return true;
            }
        }
        return false;
    }

    boolean matchesProvider(Uri uri, ProviderInfo cpi) {
        String uriAuth = uri.getAuthority();
        String cpiAuth = cpi.authority;
        if (cpiAuth.indexOf(59) == -1) {
            return cpiAuth.equals(uriAuth);
        }
        String[] cpiAuths = cpiAuth.split(";");
        int length = cpiAuths.length;
        for (int i = 0; i < length; ++i) {
            if (!cpiAuths[i].equals(uriAuth)) continue;
            return true;
        }
        return false;
    }

    ContentProviderConnection incProviderCountLocked(ProcessRecord r, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (r != null) {
            for (int i = 0; i < r.conProviders.size(); ++i) {
                ContentProviderConnection conn = r.conProviders.get(i);
                if (conn.provider != cpr) continue;
                if (stable) {
                    ++conn.stableCount;
                    ++conn.numStableIncs;
                } else {
                    ++conn.unstableCount;
                    ++conn.numUnstableIncs;
                }
                return conn;
            }
            ContentProviderConnection conn = new ContentProviderConnection(cpr, r);
            if (stable) {
                conn.stableCount = 1;
                conn.numStableIncs = 1;
            } else {
                conn.unstableCount = 1;
                conn.numUnstableIncs = 1;
            }
            cpr.connections.add(conn);
            r.conProviders.add(conn);
            this.startAssociationLocked(r.uid, r.processName, cpr.uid, cpr.name, cpr.info.processName);
            return conn;
        }
        cpr.addExternalProcessHandleLocked(externalProcessToken);
        return null;
    }

    boolean decProviderCountLocked(ContentProviderConnection conn, ContentProviderRecord cpr, IBinder externalProcessToken, boolean stable) {
        if (conn != null) {
            cpr = conn.provider;
            if (stable) {
                --conn.stableCount;
            } else {
                --conn.unstableCount;
            }
            if (conn.stableCount == 0 && conn.unstableCount == 0) {
                cpr.connections.remove(conn);
                conn.client.conProviders.remove(conn);
                this.stopAssociationLocked(conn.client.uid, conn.client.processName, cpr.uid, cpr.name);
                return true;
            }
            return false;
        }
        cpr.removeExternalProcessHandleLocked(externalProcessToken);
        return false;
    }

    private void checkTime(long startTime, String where) {
        long now = SystemClock.elapsedRealtime();
        if (now - startTime > 1000L) {
            Slog.w("ActivityManager", "Slow operation: " + (now - startTime) + "ms so far, now at " + where);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final IActivityManager.ContentProviderHolder getContentProviderImpl(IApplicationThread caller, String name, IBinder token, boolean stable, int userId) {
        ContentProviderRecord cpr;
        ContentProviderConnection conn = null;
        ProviderInfo cpi = null;
        Object object = this;
        synchronized (object) {
            boolean providerRunning;
            long startTime = SystemClock.elapsedRealtime();
            ProcessRecord r = null;
            if (caller != null && (r = this.getRecordForAppLocked(caller)) == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when getting content provider " + name);
            }
            boolean checkCrossUser = true;
            this.checkTime(startTime, "getContentProviderImpl: getProviderByName");
            cpr = this.mProviderMap.getProviderByName(name, userId);
            if (cpr == null && userId != 0 && (cpr = this.mProviderMap.getProviderByName(name, 0)) != null) {
                cpi = cpr.info;
                if (this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid)) {
                    userId = 0;
                    checkCrossUser = false;
                } else {
                    cpr = null;
                    cpi = null;
                }
            }
            boolean bl = providerRunning = cpr != null;
            if (providerRunning) {
                cpi = cpr.info;
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                String msg = this.checkContentProviderPermissionLocked(cpi, r, userId, checkCrossUser);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                if (r != null && cpr.canRunHere(r)) {
                    IActivityManager.ContentProviderHolder holder = cpr.newHolder(null);
                    holder.provider = null;
                    return holder;
                }
                long origId = Binder.clearCallingIdentity();
                this.checkTime(startTime, "getContentProviderImpl: incProviderCountLocked");
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null && conn.stableCount + conn.unstableCount == 1 && cpr.proc != null && r.setAdj <= 2) {
                    this.checkTime(startTime, "getContentProviderImpl: before updateLruProcess");
                    this.updateLruProcessLocked(cpr.proc, false, null);
                    this.checkTime(startTime, "getContentProviderImpl: after updateLruProcess");
                }
                if (cpr.proc != null) {
                    this.checkTime(startTime, "getContentProviderImpl: before updateOomAdj");
                    boolean success = this.updateOomAdjLocked(cpr.proc);
                    this.maybeUpdateProviderUsageStatsLocked(r, cpr.info.packageName, name);
                    this.checkTime(startTime, "getContentProviderImpl: after updateOomAdj");
                    if (!success) {
                        Slog.i("ActivityManager", "Existing provider " + cpr.name.flattenToShortString() + " is crashing; detaching " + r);
                        boolean lastRef = this.decProviderCountLocked(conn, cpr, token, stable);
                        this.checkTime(startTime, "getContentProviderImpl: before appDied");
                        this.appDiedLocked(cpr.proc);
                        this.checkTime(startTime, "getContentProviderImpl: after appDied");
                        if (!lastRef) {
                            return null;
                        }
                        providerRunning = false;
                        conn = null;
                    }
                }
                Binder.restoreCallingIdentity(origId);
            }
            if (!providerRunning) {
                int i;
                boolean firstClass;
                boolean singleton;
                try {
                    this.checkTime(startTime, "getContentProviderImpl: before resolveContentProvider");
                    cpi = AppGlobals.getPackageManager().resolveContentProvider(name, 3072, userId);
                    this.checkTime(startTime, "getContentProviderImpl: after resolveContentProvider");
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
                if (cpi == null) {
                    return null;
                }
                boolean bl2 = singleton = this.isSingleton(cpi.processName, cpi.applicationInfo, cpi.name, cpi.flags) && this.isValidSingletonCall(r.uid, cpi.applicationInfo.uid);
                if (singleton) {
                    userId = 0;
                }
                cpi.applicationInfo = this.getAppInfoForUser(cpi.applicationInfo, userId);
                this.checkTime(startTime, "getContentProviderImpl: got app info for user");
                this.checkTime(startTime, "getContentProviderImpl: before checkContentProviderPermission");
                String msg = this.checkContentProviderPermissionLocked(cpi, r, userId, !singleton);
                if (msg != null) {
                    throw new SecurityException(msg);
                }
                this.checkTime(startTime, "getContentProviderImpl: after checkContentProviderPermission");
                if (!(this.mProcessesReady || this.mDidUpdate || this.mWaitingUpdate || cpi.processName.equals("system"))) {
                    throw new IllegalArgumentException("Attempt to launch content provider before system ready");
                }
                if (!this.isUserRunningLocked(userId, false)) {
                    Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": user " + userId + " is stopped");
                    return null;
                }
                ComponentName comp = new ComponentName(cpi.packageName, cpi.name);
                this.checkTime(startTime, "getContentProviderImpl: before getProviderByClass");
                cpr = this.mProviderMap.getProviderByClass(comp, userId);
                this.checkTime(startTime, "getContentProviderImpl: after getProviderByClass");
                boolean bl3 = firstClass = cpr == null;
                if (firstClass) {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        this.checkTime(startTime, "getContentProviderImpl: before getApplicationInfo");
                        ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(cpi.applicationInfo.packageName, 1024, userId);
                        this.checkTime(startTime, "getContentProviderImpl: after getApplicationInfo");
                        if (ai == null) {
                            Slog.w("ActivityManager", "No package info for content provider " + cpi.name);
                            IActivityManager.ContentProviderHolder contentProviderHolder = null;
                            return contentProviderHolder;
                        }
                        ai = this.getAppInfoForUser(ai, userId);
                        cpr = new ContentProviderRecord(this, cpi, ai, comp, singleton);
                    }
                    catch (RemoteException ex) {
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                this.checkTime(startTime, "getContentProviderImpl: now have ContentProviderRecord");
                if (r != null && cpr.canRunHere(r)) {
                    return cpr.newHolder(null);
                }
                int N = this.mLaunchingProviders.size();
                for (i = 0; i < N && this.mLaunchingProviders.get(i) != cpr; ++i) {
                }
                if (i >= N) {
                    long origId = Binder.clearCallingIdentity();
                    try {
                        try {
                            this.checkTime(startTime, "getContentProviderImpl: before set stopped state");
                            AppGlobals.getPackageManager().setPackageStoppedState(cpr.appInfo.packageName, false, userId);
                            this.checkTime(startTime, "getContentProviderImpl: after set stopped state");
                        }
                        catch (RemoteException e) {
                        }
                        catch (IllegalArgumentException e) {
                            Slog.w("ActivityManager", "Failed trying to unstop package " + cpr.appInfo.packageName + ": " + e);
                        }
                        this.checkTime(startTime, "getContentProviderImpl: looking for process record");
                        ProcessRecord proc = this.getProcessRecordLocked(cpi.processName, cpr.appInfo.uid, false);
                        if (proc != null && proc.thread != null) {
                            if (!proc.pubProviders.containsKey(cpi.name)) {
                                this.checkTime(startTime, "getContentProviderImpl: scheduling install");
                                proc.pubProviders.put(cpi.name, cpr);
                                try {
                                    proc.thread.scheduleInstallProvider(cpi);
                                }
                                catch (RemoteException e) {}
                            }
                        } else {
                            this.checkTime(startTime, "getContentProviderImpl: before start process");
                            proc = this.startProcessLocked(cpi.processName, cpr.appInfo, false, 0, "content provider", new ComponentName(cpi.applicationInfo.packageName, cpi.name), false, false, false);
                            this.checkTime(startTime, "getContentProviderImpl: after start process");
                            if (proc == null) {
                                Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": process is bad");
                                IActivityManager.ContentProviderHolder contentProviderHolder = null;
                                return contentProviderHolder;
                            }
                        }
                        cpr.launchingApp = proc;
                        this.mLaunchingProviders.add(cpr);
                    }
                    finally {
                        Binder.restoreCallingIdentity(origId);
                    }
                }
                this.checkTime(startTime, "getContentProviderImpl: updating data structures");
                if (firstClass) {
                    this.mProviderMap.putProviderByClass(comp, cpr);
                }
                this.mProviderMap.putProviderByName(name, cpr);
                conn = this.incProviderCountLocked(r, cpr, token, stable);
                if (conn != null) {
                    conn.waiting = true;
                }
            }
            this.checkTime(startTime, "getContentProviderImpl: done!");
        }
        object = cpr;
        synchronized (object) {
            while (cpr.provider == null) {
                if (cpr.launchingApp == null) {
                    Slog.w("ActivityManager", "Unable to launch app " + cpi.applicationInfo.packageName + "/" + cpi.applicationInfo.uid + " for provider " + name + ": launching app became null");
                    EventLog.writeEvent(30036, UserHandle.getUserId(cpi.applicationInfo.uid), cpi.applicationInfo.packageName, cpi.applicationInfo.uid, name);
                    return null;
                }
                try {
                    if (conn != null) {
                        conn.waiting = true;
                    }
                    cpr.wait();
                }
                catch (InterruptedException ex) {}
                continue;
                finally {
                    if (conn == null) continue;
                    conn.waiting = false;
                }
            }
        }
        if (cpr == null) return null;
        IActivityManager.ContentProviderHolder contentProviderHolder = cpr.newHolder(conn);
        return contentProviderHolder;
    }

    @Override
    public final IActivityManager.ContentProviderHolder getContentProvider(IApplicationThread caller, String name, int userId, boolean stable) {
        this.enforceNotIsolatedCaller("getContentProvider");
        if (caller == null) {
            String msg = "null IApplicationThread when getting content provider " + name;
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        return this.getContentProviderImpl(caller, name, null, stable, userId);
    }

    @Override
    public IActivityManager.ContentProviderHolder getContentProviderExternal(String name, int userId, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call getContentProviderExternal()");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "getContentProvider", null);
        return this.getContentProviderExternalUnchecked(name, token, userId);
    }

    private IActivityManager.ContentProviderHolder getContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        return this.getContentProviderImpl(null, name, token, true, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProvider(IBinder connection, boolean stable) {
        this.enforceNotIsolatedCaller("removeContentProvider");
        long ident = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ContentProviderConnection conn;
                try {
                    conn = (ContentProviderConnection)connection;
                }
                catch (ClassCastException e) {
                    String msg = "removeContentProvider: " + connection + " not a ContentProviderConnection";
                    Slog.w("ActivityManager", msg);
                    throw new IllegalArgumentException(msg);
                }
                if (conn == null) {
                    throw new NullPointerException("connection is null");
                }
                if (this.decProviderCountLocked(conn, null, null, stable)) {
                    this.updateOomAdjLocked();
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeContentProviderExternal(String name, IBinder token) {
        this.enforceCallingPermission("android.permission.ACCESS_CONTENT_PROVIDERS_EXTERNALLY", "Do not have permission in call removeContentProviderExternal()");
        int userId = UserHandle.getCallingUserId();
        long ident = Binder.clearCallingIdentity();
        try {
            this.removeContentProviderExternalUnchecked(name, token, userId);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeContentProviderExternalUnchecked(String name, IBinder token, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ContentProviderRecord cpr = this.mProviderMap.getProviderByName(name, userId);
            if (cpr == null) {
                return;
            }
            ComponentName comp = new ComponentName(cpr.info.packageName, cpr.info.name);
            ContentProviderRecord localCpr = this.mProviderMap.getProviderByClass(comp, userId);
            if (localCpr.hasExternalProcessHandles()) {
                if (localCpr.removeExternalProcessHandleLocked(token)) {
                    this.updateOomAdjLocked();
                } else {
                    Slog.e("ActivityManager", "Attmpt to remove content provider " + localCpr + " with no external reference for token: " + token + ".");
                }
            } else {
                Slog.e("ActivityManager", "Attmpt to remove content provider: " + localCpr + " with no external references.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void publishContentProviders(IApplicationThread caller, List<IActivityManager.ContentProviderHolder> providers) {
        if (providers == null) {
            return;
        }
        this.enforceNotIsolatedCaller("publishContentProviders");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord r = this.getRecordForAppLocked(caller);
            if (r == null) {
                throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when publishing content providers");
            }
            long origId = Binder.clearCallingIdentity();
            int N = providers.size();
            for (int i = 0; i < N; ++i) {
                ContentProviderRecord dst;
                IActivityManager.ContentProviderHolder src = providers.get(i);
                if (src == null || src.info == null || src.provider == null || (dst = r.pubProviders.get(src.info.name)) == null) continue;
                ComponentName comp = new ComponentName(dst.info.packageName, dst.info.name);
                this.mProviderMap.putProviderByClass(comp, dst);
                String[] names = dst.info.authority.split(";");
                for (int j = 0; j < names.length; ++j) {
                    this.mProviderMap.putProviderByName(names[j], dst);
                }
                int NL = this.mLaunchingProviders.size();
                for (int j = 0; j < NL; ++j) {
                    if (this.mLaunchingProviders.get(j) != dst) continue;
                    this.mLaunchingProviders.remove(j);
                    --j;
                    --NL;
                }
                ContentProviderRecord contentProviderRecord = dst;
                synchronized (contentProviderRecord) {
                    dst.provider = src.provider;
                    dst.proc = r;
                    dst.notifyAll();
                }
                this.updateOomAdjLocked(r);
                this.maybeUpdateProviderUsageStatsLocked(r, src.info.packageName, src.info.authority);
            }
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refContentProvider(IBinder connection, int stable, int unstable) {
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w("ActivityManager", msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (stable > 0) {
                conn.numStableIncs += stable;
            }
            if ((stable = conn.stableCount + stable) < 0) {
                throw new IllegalStateException("stableCount < 0: " + stable);
            }
            if (unstable > 0) {
                conn.numUnstableIncs += unstable;
            }
            if ((unstable = conn.unstableCount + unstable) < 0) {
                throw new IllegalStateException("unstableCount < 0: " + unstable);
            }
            if (stable + unstable <= 0) {
                throw new IllegalStateException("ref counts can't go to zero here: stable=" + stable + " unstable=" + unstable);
            }
            conn.stableCount = stable;
            conn.unstableCount = unstable;
            return !conn.dead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unstableProviderDied(IBinder connection) {
        IContentProvider provider;
        ContentProviderConnection conn;
        try {
            conn = (ContentProviderConnection)connection;
        }
        catch (ClassCastException e) {
            String msg = "refContentProvider: " + connection + " not a ContentProviderConnection";
            Slog.w("ActivityManager", msg);
            throw new IllegalArgumentException(msg);
        }
        if (conn == null) {
            throw new NullPointerException("connection is null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            provider = conn.provider.provider;
        }
        if (provider == null) {
            return;
        }
        if (provider.asBinder().pingBinder()) {
            activityManagerService = this;
            synchronized (activityManagerService) {
                Slog.w("ActivityManager", "unstableProviderDied: caller " + Binder.getCallingUid() + " says " + conn + " died, but we don't agree");
                return;
            }
        }
        activityManagerService = this;
        synchronized (activityManagerService) {
            if (conn.provider.provider != provider) {
                return;
            }
            ProcessRecord proc = conn.provider.proc;
            if (proc == null || proc.thread == null) {
                return;
            }
            Slog.i("ActivityManager", "Process " + proc.processName + " (pid " + proc.pid + ") early provider death");
            long ident = Binder.clearCallingIdentity();
            try {
                this.appDiedLocked(proc);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appNotRespondingViaProvider(IBinder connection) {
        this.enforceCallingPermission("android.permission.REMOVE_TASKS", "appNotRespondingViaProvider()");
        ContentProviderConnection conn = (ContentProviderConnection)connection;
        if (conn == null) {
            Slog.w("ActivityManager", "ContentProviderConnection is null");
            return;
        }
        ProcessRecord host = conn.provider.proc;
        if (host == null) {
            Slog.w("ActivityManager", "Failed to find hosting ProcessRecord");
            return;
        }
        long token = Binder.clearCallingIdentity();
        try {
            this.appNotResponding(host, null, null, false, "ContentProvider not responding");
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void installSystemProviders() {
        List<ProviderInfo> providers;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.mProcessNames.get("system", 1000);
            providers = this.generateApplicationProvidersLocked(app);
            if (providers != null) {
                for (int i = providers.size() - 1; i >= 0; --i) {
                    ProviderInfo pi = providers.get(i);
                    if ((pi.applicationInfo.flags & 1) != 0) continue;
                    Slog.w("ActivityManager", "Not installing system proc provider " + pi.name + ": not system .apk");
                    providers.remove(i);
                }
            }
        }
        if (providers != null) {
            this.mSystemThread.installSystemProviders(providers);
        }
        this.mCoreSettingsObserver = new CoreSettingsObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getProviderMimeType(Uri uri, int userId) {
        this.enforceNotIsolatedCaller("getProviderMimeType");
        String name = uri.getAuthority();
        int callingUid = Binder.getCallingUid();
        int callingPid = Binder.getCallingPid();
        long ident = 0L;
        boolean clearedIdentity = false;
        userId = this.unsafeConvertIncomingUser(userId);
        if (this.canClearIdentity(callingPid, callingUid, userId)) {
            clearedIdentity = true;
            ident = Binder.clearCallingIdentity();
        }
        IActivityManager.ContentProviderHolder holder = null;
        try {
            holder = this.getContentProviderExternalUnchecked(name, null, userId);
            if (holder != null) {
                String string2 = holder.provider.getType(uri);
                return string2;
            }
        }
        catch (RemoteException e) {
            Log.w("ActivityManager", "Content provider dead retrieving " + uri, e);
            String string3 = null;
            return string3;
        }
        finally {
            if (!clearedIdentity) {
                ident = Binder.clearCallingIdentity();
            }
            try {
                if (holder != null) {
                    this.removeContentProviderExternalUnchecked(name, null, userId);
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return null;
    }

    private boolean canClearIdentity(int callingPid, int callingUid, int userId) {
        if (UserHandle.getUserId(callingUid) == userId) {
            return true;
        }
        return this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) == 0 || this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    final ProcessRecord newProcessRecordLocked(ApplicationInfo info, String customProcess, boolean isolated, int isolatedUid) {
        int uid;
        int userId;
        BatteryStatsImpl stats;
        String proc;
        block6: {
            proc = customProcess != null ? customProcess : info.processName;
            stats = this.mBatteryStatsService.getActiveStatistics();
            userId = UserHandle.getUserId(info.uid);
            uid = info.uid;
            if (isolated) {
                if (isolatedUid != 0) {
                    uid = isolatedUid;
                } else {
                    int stepsLeft = 1000;
                    do {
                        if (this.mNextIsolatedProcessUid < 99000 || this.mNextIsolatedProcessUid > 99999) {
                            this.mNextIsolatedProcessUid = 99000;
                        }
                        uid = UserHandle.getUid(userId, this.mNextIsolatedProcessUid);
                        ++this.mNextIsolatedProcessUid;
                        if (this.mIsolatedProcesses.indexOfKey(uid) < 0) break block6;
                    } while (--stepsLeft > 0);
                    return null;
                }
            }
        }
        ProcessRecord r = new ProcessRecord(stats, info, proc, uid);
        if (!this.mBooted && !this.mBooting && userId == 0 && (info.flags & 9) == 9) {
            r.persistent = true;
        }
        this.addProcessNameLocked(r);
        return r;
    }

    final ProcessRecord addAppLocked(ApplicationInfo info, boolean isolated, String abiOverride) {
        ProcessRecord app = !isolated ? this.getProcessRecordLocked(info.processName, info.uid, true) : null;
        if (app == null) {
            app = this.newProcessRecordLocked(info, null, isolated, 0);
            this.updateLruProcessLocked(app, false, null);
            this.updateOomAdjLocked();
        }
        try {
            AppGlobals.getPackageManager().setPackageStoppedState(info.packageName, false, UserHandle.getUserId(app.uid));
        }
        catch (RemoteException e) {
        }
        catch (IllegalArgumentException e) {
            Slog.w("ActivityManager", "Failed trying to unstop package " + info.packageName + ": " + e);
        }
        if ((info.flags & 9) == 9) {
            app.persistent = true;
            app.maxAdj = -12;
        }
        if (app.thread == null && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            this.startProcessLocked(app, "added application", app.processName, abiOverride, null, null);
        }
        return app;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unhandledBack() {
        this.enforceCallingPermission("android.permission.FORCE_BACK", "unhandledBack()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            try {
                this.getFocusedStack().unhandledBackLocked();
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor openContentUri(Uri uri) throws RemoteException {
        this.enforceNotIsolatedCaller("openContentUri");
        int userId = UserHandle.getCallingUserId();
        String name = uri.getAuthority();
        IActivityManager.ContentProviderHolder cph = this.getContentProviderExternalUnchecked(name, null, userId);
        ParcelFileDescriptor pfd = null;
        if (cph != null) {
            Binder token = new Binder();
            sCallerIdentity.set(new Identity(token, Binder.getCallingPid(), Binder.getCallingUid()));
            try {
                pfd = cph.provider.openFile(null, uri, "r", null, token);
            }
            catch (FileNotFoundException e) {
            }
            finally {
                sCallerIdentity.remove();
                this.removeContentProviderExternalUnchecked(name, null, userId);
            }
        } else {
            Slog.d("ActivityManager", "Failed to get provider for authority '" + name + "'");
        }
        return pfd;
    }

    public boolean isSleepingOrShuttingDown() {
        return this.isSleeping() || this.mShuttingDown;
    }

    public boolean isSleeping() {
        return this.mSleeping;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onWakefulnessChanged(int wakefulness) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mWakefulness = wakefulness;
            this.updateSleepIfNeededLocked();
        }
    }

    void finishRunningVoiceLocked() {
        if (this.mRunningVoice != null) {
            this.mRunningVoice = null;
            this.mVoiceWakeLock.release();
            this.updateSleepIfNeededLocked();
        }
    }

    void startTimeTrackingFocusedActivityLocked() {
        if (!this.mSleeping && this.mCurAppTimeTracker != null && this.mFocusedActivity != null) {
            this.mCurAppTimeTracker.start(this.mFocusedActivity.packageName);
        }
    }

    void updateSleepIfNeededLocked() {
        if (this.mSleeping && !this.shouldSleepLocked()) {
            this.mSleeping = false;
            this.startTimeTrackingFocusedActivityLocked();
            this.mTopProcessState = 2;
            this.mStackSupervisor.comeOutOfSleepIfNeededLocked();
            this.updateOomAdjLocked();
        } else if (!this.mSleeping && this.shouldSleepLocked()) {
            this.mSleeping = true;
            if (this.mCurAppTimeTracker != null) {
                this.mCurAppTimeTracker.stop();
            }
            this.mTopProcessState = 5;
            this.mStackSupervisor.goingToSleepLocked();
            this.updateOomAdjLocked();
            this.checkExcessivePowerUsageLocked(false);
            this.mHandler.removeMessages(27);
            Message nmsg = this.mHandler.obtainMessage(27);
            this.mHandler.sendMessageDelayed(nmsg, 900000L);
        }
    }

    private boolean shouldSleepLocked() {
        if (this.mRunningVoice != null) {
            return false;
        }
        switch (this.mWakefulness) {
            case 1: 
            case 2: 
            case 3: {
                return this.mLockScreenShown != 0 || !this.mSleepTokens.isEmpty();
            }
        }
        return true;
    }

    void notifyTaskPersisterLocked(TaskRecord task, boolean flush) {
        if (task != null && task.stack != null && task.stack.isHomeStack()) {
            return;
        }
        this.mTaskPersister.wakeup(task, flush);
    }

    void notifyTaskStackChangedLocked() {
        this.mHandler.removeMessages(49);
        Message nmsg = this.mHandler.obtainMessage(49);
        this.mHandler.sendMessageDelayed(nmsg, 1000L);
    }

    @Override
    public void notifyCleartextNetwork(int uid, byte[] firstPacket) {
        this.mHandler.obtainMessage(50, uid, 0, firstPacket).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(int timeout) {
        if (this.checkCallingPermission("android.permission.SHUTDOWN") != 0) {
            throw new SecurityException("Requires permission android.permission.SHUTDOWN");
        }
        boolean timedout = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mShuttingDown = true;
            this.updateEventDispatchingLocked();
            timedout = this.mStackSupervisor.shutdownLocked(timeout);
        }
        this.mAppOpsService.shutdown();
        if (this.mUsageStatsService != null) {
            this.mUsageStatsService.prepareShutdown();
        }
        this.mBatteryStatsService.shutdown();
        activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessStats.shutdownLocked();
            this.notifyTaskPersisterLocked(null, true);
        }
        return timedout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void activitySlept(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r != null) {
                this.mStackSupervisor.activitySleptLocked(r);
            }
        }
        Binder.restoreCallingIdentity(origId);
    }

    private String lockScreenShownToString() {
        switch (this.mLockScreenShown) {
            case 0: {
                return "LOCK_SCREEN_HIDDEN";
            }
            case 1: {
                return "LOCK_SCREEN_LEAVING";
            }
            case 2: {
                return "LOCK_SCREEN_SHOWN";
            }
        }
        return "Unknown=" + this.mLockScreenShown;
    }

    void logLockScreen(String msg) {
    }

    void startRunningVoiceLocked(IVoiceInteractionSession session, int targetUid) {
        this.mVoiceWakeLock.setWorkSource(new WorkSource(targetUid));
        if (this.mRunningVoice == null || this.mRunningVoice.asBinder() != session.asBinder()) {
            boolean wasRunningVoice = this.mRunningVoice != null;
            this.mRunningVoice = session;
            if (!wasRunningVoice) {
                this.mVoiceWakeLock.acquire();
                this.updateSleepIfNeededLocked();
            }
        }
    }

    private void updateEventDispatchingLocked() {
        this.mWindowManager.setEventDispatching(this.mBooted && !this.mShuttingDown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLockScreenShown(boolean shown) {
        if (this.checkCallingPermission("android.permission.DEVICE_POWER") != 0) {
            throw new SecurityException("Requires permission android.permission.DEVICE_POWER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long ident = Binder.clearCallingIdentity();
            try {
                this.mLockScreenShown = shown ? 2 : 0;
                this.updateSleepIfNeededLocked();
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = SystemClock.uptimeMillis() + 5000L;
            this.mDidAppSwitch = false;
            this.mHandler.removeMessages(21);
            Message msg = this.mHandler.obtainMessage(21);
            this.mHandler.sendMessageDelayed(msg, 5000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAppSwitches() {
        if (this.checkCallingPermission("android.permission.STOP_APP_SWITCHES") != 0) {
            throw new SecurityException("Requires permission android.permission.STOP_APP_SWITCHES");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAppSwitchesAllowedTime = 0L;
        }
    }

    boolean checkAppSwitchAllowedLocked(int sourcePid, int sourceUid, int callingPid, int callingUid, String name) {
        if (this.mAppSwitchesAllowedTime < SystemClock.uptimeMillis()) {
            return true;
        }
        int perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", sourcePid, sourceUid, -1, true);
        if (perm == 0) {
            return true;
        }
        if (callingUid != -1 && callingUid != sourceUid && (perm = this.checkComponentPermission("android.permission.STOP_APP_SWITCHES", callingPid, callingUid, -1, true)) == 0) {
            return true;
        }
        Slog.w("ActivityManager", name + " request from " + sourceUid + " stopped");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDebugApp(String packageName, boolean waitForDebugger, boolean persistent) {
        this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDebugApp()");
        long ident = Binder.clearCallingIdentity();
        try {
            if (persistent) {
                ContentResolver resolver = this.mContext.getContentResolver();
                Settings.Global.putString(resolver, "debug_app", packageName);
                Settings.Global.putInt(resolver, "wait_for_debugger", waitForDebugger ? 1 : 0);
            }
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (!persistent) {
                    this.mOrigDebugApp = this.mDebugApp;
                    this.mOrigWaitForDebugger = this.mWaitForDebugger;
                }
                this.mDebugApp = packageName;
                this.mWaitForDebugger = waitForDebugger;
                boolean bl = this.mDebugTransient = !persistent;
                if (packageName != null) {
                    this.forceStopPackageLocked(packageName, -1, false, false, true, true, false, -1, "set debug app");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOpenGlTraceApp(ApplicationInfo app, String processName) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mOpenGlTraceApp = processName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProfileApp(ApplicationInfo app, String processName, ProfilerInfo profilerInfo) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (app.flags & 2) == 0) {
                throw new SecurityException("Process not debuggable: " + app.packageName);
            }
            this.mProfileApp = processName;
            this.mProfileFile = profilerInfo.profileFile;
            if (this.mProfileFd != null) {
                try {
                    this.mProfileFd.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.mProfileFd = null;
            }
            this.mProfileFd = profilerInfo.profileFd;
            this.mSamplingInterval = profilerInfo.samplingInterval;
            this.mAutoStopProfiler = profilerInfo.autoStopProfiler;
            this.mProfileType = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlwaysFinish(boolean enabled) {
        this.enforceCallingPermission("android.permission.SET_ALWAYS_FINISH", "setAlwaysFinish()");
        Settings.Global.putInt(this.mContext.getContentResolver(), "always_finish_activities", enabled ? 1 : 0);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mAlwaysFinishActivities = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActivityController(IActivityController controller) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "setActivityController()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mController = controller;
            Watchdog.getInstance().setActivityController(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserIsMonkey(boolean userIsMonkey) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                int callingPid = Binder.getCallingPid();
                ProcessRecord precessRecord = this.mPidsSelfLocked.get(callingPid);
                if (precessRecord == null) {
                    throw new SecurityException("Unknown process: " + callingPid);
                }
                if (precessRecord.instrumentationUiAutomationConnection == null) {
                    throw new SecurityException("Only an instrumentation process with a UiAutomation can call setUserIsMonkey");
                }
            }
            this.mUserIsMonkey = userIsMonkey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserAMonkey() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mUserIsMonkey || this.mController != null;
        }
    }

    @Override
    public void requestBugReport() {
        this.enforceCallingPermission("android.permission.DUMP", "requestBugReport");
        SystemProperties.set("ctl.start", "bugreport");
    }

    public static long getInputDispatchingTimeoutLocked(ActivityRecord r) {
        return r != null ? ActivityManagerService.getInputDispatchingTimeoutLocked(r.app) : 5000L;
    }

    public static long getInputDispatchingTimeoutLocked(ProcessRecord r) {
        if (r != null && (r.instrumentationClass != null || r.usingWrapper)) {
            return 60000L;
        }
        return 5000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long inputDispatchingTimedOut(int pid, boolean aboveSystem, String reason) {
        long timeout;
        ProcessRecord proc;
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
            timeout = ActivityManagerService.getInputDispatchingTimeoutLocked(proc);
        }
        if (!this.inputDispatchingTimedOut(proc, null, null, aboveSystem, reason)) {
            return -1L;
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inputDispatchingTimedOut(final ProcessRecord proc, final ActivityRecord activity, final ActivityRecord parent, final boolean aboveSystem, String reason) {
        if (this.checkCallingPermission("android.permission.FILTER_EVENTS") != 0) {
            throw new SecurityException("Requires permission android.permission.FILTER_EVENTS");
        }
        final String annotation = reason == null ? "Input dispatching timed out" : "Input dispatching timed out (" + reason + ")";
        if (proc != null) {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (proc.debugging) {
                    return false;
                }
                if (this.mDidDexOpt) {
                    this.mDidDexOpt = false;
                    return false;
                }
                if (proc.instrumentationClass != null) {
                    Bundle info = new Bundle();
                    info.putString("shortMsg", "keyDispatchingTimedOut");
                    info.putString("longMsg", annotation);
                    this.finishInstrumentationLocked(proc, 0, info);
                    return true;
                }
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.appNotResponding(proc, activity, parent, aboveSystem, annotation);
                }
            });
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bundle getAssistContextExtras(int requestType) {
        PendingAssistExtras pae = this.enqueueAssistContext(requestType, null, null, null, null, UserHandle.getCallingUserId(), null, 500L);
        if (pae == null) {
            return null;
        }
        Binder binder = pae;
        synchronized (binder) {
            while (!pae.haveResult) {
                try {
                    pae.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        binder = this;
        synchronized (binder) {
            this.buildAssistBundleLocked(pae, pae.result);
            this.mPendingAssistExtras.remove(pae);
            this.mUiHandler.removeCallbacks(pae);
        }
        return pae.extras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAssistDataAllowedOnCurrentActivity() {
        int userId = this.mCurrentUserId;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord activity = this.getFocusedStack().topActivity();
            if (activity == null) {
                return false;
            }
            userId = activity.userId;
        }
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        return dpm == null || !dpm.getScreenCaptureDisabled(null, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean showAssistFromActivity(IBinder token, Bundle args) {
        ActivityRecord top;
        ActivityRecord caller;
        long ident;
        block9: {
            ident = Binder.clearCallingIdentity();
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            caller = ActivityRecord.forTokenLocked(token);
            top = this.getFocusedStack().topActivity();
            if (top == caller) break block9;
            Slog.w("ActivityManager", "showAssistFromActivity failed: caller " + caller + " is not current top " + top);
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (!top.nowVisible) {
            Slog.w("ActivityManager", "showAssistFromActivity failed: caller " + caller + " is not visible");
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            // MONITOREXIT : activityManagerService
            AssistUtils utils = new AssistUtils(this.mContext);
            boolean bl = utils.showSessionForActiveService(args, 8, null, token);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean requestAssistContextExtras(int requestType, IResultReceiver receiver, IBinder activityToken) {
        return this.enqueueAssistContext(requestType, null, null, receiver, activityToken, UserHandle.getCallingUserId(), null, 2000L) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PendingAssistExtras enqueueAssistContext(int requestType, Intent intent, String hint, IResultReceiver receiver, IBinder activityToken, int userHandle, Bundle args, long timeout) {
        this.enforceCallingPermission("android.permission.GET_TOP_ACTIVITY_INFO", "enqueueAssistContext()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord caller;
            ActivityRecord activity = this.getFocusedStack().topActivity();
            if (activity == null) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: no top activity");
                return null;
            }
            if (activity.app == null || activity.app.thread == null) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: no process for " + activity);
                return null;
            }
            if (activityToken != null && activity != (caller = ActivityRecord.forTokenLocked(activityToken))) {
                Slog.w("ActivityManager", "enqueueAssistContext failed: caller " + caller + " is not current top " + activity);
                return null;
            }
            Bundle extras = new Bundle();
            if (args != null) {
                extras.putAll(args);
            }
            extras.putString("android.intent.extra.ASSIST_PACKAGE", activity.packageName);
            extras.putInt("android.intent.extra.ASSIST_UID", activity.app.uid);
            PendingAssistExtras pae = new PendingAssistExtras(activity, extras, intent, hint, receiver, userHandle);
            try {
                activity.app.thread.requestAssistContextExtras(activity.appToken, pae, requestType);
                this.mPendingAssistExtras.add(pae);
                this.mUiHandler.postDelayed(pae, timeout);
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "getAssistContextExtras failed: crash calling " + activity);
                return null;
            }
            return pae;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pendingAssistExtrasTimedOut(PendingAssistExtras pae) {
        IResultReceiver receiver;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mPendingAssistExtras.remove(pae);
            receiver = pae.receiver;
        }
        if (receiver != null) {
            try {
                pae.receiver.send(0, null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private void buildAssistBundleLocked(PendingAssistExtras pae, Bundle result) {
        if (result != null) {
            pae.extras.putBundle("android.intent.extra.ASSIST_CONTEXT", result);
        }
        if (pae.hint != null) {
            pae.extras.putBoolean(pae.hint, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reportAssistContextExtras(IBinder token, Bundle extras, AssistStructure structure, AssistContent content, Uri referrer) {
        PendingAssistExtras pae;
        PendingAssistExtras pendingAssistExtras = pae = (PendingAssistExtras)token;
        synchronized (pendingAssistExtras) {
            pae.result = extras;
            pae.structure = structure;
            pae.content = content;
            if (referrer != null) {
                pae.extras.putParcelable("android.intent.extra.REFERRER", referrer);
            }
            pae.haveResult = true;
            pae.notifyAll();
            if (pae.intent == null && pae.receiver == null) {
                return;
            }
        }
        IResultReceiver sendReceiver = null;
        Bundle sendBundle = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.buildAssistBundleLocked(pae, extras);
            boolean exists = this.mPendingAssistExtras.remove(pae);
            this.mUiHandler.removeCallbacks(pae);
            if (!exists) {
                return;
            }
            sendReceiver = pae.receiver;
            if (sendReceiver != null) {
                sendBundle = new Bundle();
                sendBundle.putBundle("data", pae.extras);
                sendBundle.putParcelable("structure", pae.structure);
                sendBundle.putParcelable("content", pae.content);
            }
        }
        if (sendReceiver != null) {
            try {
                sendReceiver.send(0, sendBundle);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            pae.intent.replaceExtras(pae.extras);
            pae.intent.setFlags(0x34000000);
            this.closeSystemDialogs("assist");
            try {
                this.mContext.startActivityAsUser(pae.intent, new UserHandle(pae.userHandle));
            }
            catch (ActivityNotFoundException e) {
                Slog.w("ActivityManager", "No activity to handle assist action.", e);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    @Override
    public boolean launchAssistIntent(Intent intent, int requestType, String hint, int userHandle, Bundle args) {
        return this.enqueueAssistContext(requestType, intent, hint, null, null, userHandle, args, 500L) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerProcessObserver(IProcessObserver observer) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerProcessObserver()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.register(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterProcessObserver(IProcessObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mProcessObservers.unregister(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerUidObserver(IUidObserver observer) {
        this.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerUidObserver()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mUidObservers.register(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterUidObserver(IUidObserver observer) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mUidObservers.unregister(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean convertFromTranslucent(IBinder token) {
        ActivityRecord r;
        long origId;
        block7: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(token);
                if (r != null) break block7;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        boolean translucentChanged = r.changeWindowTranslucency(true);
        if (translucentChanged) {
            r.task.stack.releaseBackgroundResources(r);
            this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
        }
        this.mWindowManager.setAppFullscreen(token, true);
        boolean bl = translucentChanged;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean convertToTranslucent(IBinder token, ActivityOptions options) {
        boolean translucentChanged;
        ActivityRecord r;
        long origId;
        block8: {
            boolean bl;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                r = ActivityRecord.isInStackLocked(token);
                if (r != null) break block8;
                bl = false;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return bl;
        }
        int index = r.task.mActivities.lastIndexOf(r);
        if (index > 0) {
            ActivityRecord under = r.task.mActivities.get(index - 1);
            under.returningOptions = options;
        }
        if (translucentChanged = r.changeWindowTranslucency(false)) {
            r.task.stack.convertActivityToTranslucent(r);
        }
        this.mStackSupervisor.ensureActivitiesVisibleLocked(null, 0);
        this.mWindowManager.setAppFullscreen(token, false);
        boolean bl = translucentChanged;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean requestVisibleBehind(IBinder token, boolean visible) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r != null) {
                    boolean bl = this.mStackSupervisor.requestVisibleBehindLocked(r, visible);
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackgroundVisibleBehind(IBinder token) {
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                boolean visible;
                ActivityStack stack = ActivityRecord.getStackLocked(token);
                boolean bl = visible = stack == null ? false : stack.hasVisibleBehindActivity();
                return bl;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public ActivityOptions getActivityOptions(IBinder token) {
        long origId;
        block6: {
            ActivityOptions activityOptions;
            origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = this;
                // MONITORENTER : activityManagerService
                ActivityRecord r = ActivityRecord.isInStackLocked(token);
                if (r == null) break block6;
                ActivityOptions activityOptions2 = r.pendingOptions;
                r.pendingOptions = null;
                activityOptions = activityOptions2;
                // MONITOREXIT : activityManagerService
            }
            catch (Throwable throwable) {
                Binder.restoreCallingIdentity(origId);
                throw throwable;
            }
            Binder.restoreCallingIdentity(origId);
            return activityOptions;
        }
        ActivityOptions activityOptions = null;
        // MONITOREXIT : activityManagerService
        Binder.restoreCallingIdentity(origId);
        return activityOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImmersive(IBinder token, boolean immersive) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            r.immersive = immersive;
            if (r == this.mFocusedActivity) {
                this.applyUpdateLockStateLocked(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isImmersive(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.immersive;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopActivityImmersive() {
        this.enforceNotIsolatedCaller("startActivity");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = this.getFocusedStack().topRunningActivityLocked(null);
            return r != null ? r.immersive : false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTopOfTask(IBinder token) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.isInStackLocked(token);
            if (r == null) {
                throw new IllegalArgumentException();
            }
            return r.task.getTopActivity() == r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void enterSafeMode() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!this.mSystemReady) {
                try {
                    AppGlobals.getPackageManager().enterSafeMode();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSafeMode = true;
        }
    }

    public final void showSafeModeOverlay() {
        View v = LayoutInflater.from(this.mContext).inflate(17367236, null);
        WindowManager.LayoutParams lp = new WindowManager.LayoutParams();
        lp.type = 2015;
        lp.width = -2;
        lp.height = -2;
        lp.gravity = 8388691;
        lp.format = v.getBackground().getOpacity();
        lp.flags = 24;
        lp.privateFlags |= 0x10;
        ((WindowManager)this.mContext.getSystemService("window")).addView(v, lp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeupAlarm(IIntentSender sender, int sourceUid, String sourcePkg, String tag) {
        BatteryStatsImpl stats;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            if (this.mBatteryStatsService.isOnBattery()) {
                this.mBatteryStatsService.enforceCallingPermission();
                int MY_UID = Binder.getCallingUid();
                int uid = rec.uid == MY_UID ? 1000 : rec.uid;
                BatteryStatsImpl.Uid.Pkg pkg = stats.getPackageStatsLocked(sourceUid >= 0 ? sourceUid : uid, sourcePkg != null ? sourcePkg : rec.key.packageName);
                pkg.noteWakeupAlarmLocked(tag);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteAlarmStart(IIntentSender sender, int sourceUid, String tag) {
        BatteryStatsImpl stats;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            this.mBatteryStatsService.enforceCallingPermission();
            int MY_UID = Binder.getCallingUid();
            int uid = rec.uid == MY_UID ? 1000 : rec.uid;
            this.mBatteryStatsService.noteAlarmStart(tag, sourceUid >= 0 ? sourceUid : uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteAlarmFinish(IIntentSender sender, int sourceUid, String tag) {
        BatteryStatsImpl stats;
        if (!(sender instanceof PendingIntentRecord)) {
            return;
        }
        PendingIntentRecord rec = (PendingIntentRecord)sender;
        BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
        synchronized (batteryStatsImpl) {
            this.mBatteryStatsService.enforceCallingPermission();
            int MY_UID = Binder.getCallingUid();
            int uid = rec.uid == MY_UID ? 1000 : rec.uid;
            this.mBatteryStatsService.noteAlarmFinish(tag, sourceUid >= 0 ? sourceUid : uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean killPids(int[] pids, String pReason, boolean secure) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killPids only available to the system");
        }
        String reason = pReason == null ? "Unknown" : pReason;
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            ProcessRecord proc;
            int i;
            int[] types = new int[pids.length];
            int worstType = 0;
            for (i = 0; i < pids.length; ++i) {
                int type;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null) continue;
                types[i] = type = proc.setAdj;
                if (type <= worstType) continue;
                worstType = type;
            }
            if (worstType < 15 && worstType > 9) {
                worstType = 9;
            }
            if (!secure && worstType < 5) {
                worstType = 5;
            }
            Slog.w("ActivityManager", "Killing processes " + reason + " at adjustment " + worstType);
            for (i = 0; i < pids.length; ++i) {
                int adj;
                proc = this.mPidsSelfLocked.get(pids[i]);
                if (proc == null || (adj = proc.setAdj) < worstType || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killUid(int appId, int userId, String reason) {
        this.enforceCallingPermission("android.permission.KILL_UID", "killUid");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long identity = Binder.clearCallingIdentity();
            try {
                this.killPackageProcessesLocked(null, appId, userId, -12, false, true, true, true, reason != null ? reason : "kill uid");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }

    @Override
    public boolean killProcessesBelowForeground(String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowForeground() only available to system");
        }
        return this.killProcessesBelowAdj(0, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean killProcessesBelowAdj(int belowAdj, String reason) {
        if (Binder.getCallingUid() != 1000) {
            throw new SecurityException("killProcessesBelowAdj() only available to system");
        }
        boolean killed = false;
        SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
        synchronized (sparseArray) {
            int size = this.mPidsSelfLocked.size();
            for (int i = 0; i < size; ++i) {
                int adj;
                int pid = this.mPidsSelfLocked.keyAt(i);
                ProcessRecord proc = this.mPidsSelfLocked.valueAt(i);
                if (proc == null || (adj = proc.setAdj) <= belowAdj || proc.killedByAm) continue;
                proc.kill(reason, true);
                killed = true;
            }
        }
        return killed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hang(IBinder who, boolean allowRestart) {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        IBinder.DeathRecipient death = new IBinder.DeathRecipient(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                11 var1_1 = this;
                synchronized (var1_1) {
                    this.notifyAll();
                }
            }
        };
        try {
            who.linkToDeath(death, 0);
        }
        catch (RemoteException e) {
            Slog.w("ActivityManager", "hang: given caller IBinder is already dead.");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Watchdog.getInstance().setAllowRestart(allowRestart);
            Slog.i("ActivityManager", "Hanging system process at request of pid " + Binder.getCallingPid());
            IBinder.DeathRecipient deathRecipient = death;
            synchronized (deathRecipient) {
                while (who.isBinderAlive()) {
                    try {
                        death.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            Watchdog.getInstance().setAllowRestart(true);
        }
    }

    @Override
    public void restart() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        Log.i("ActivityManager", "Sending shutdown broadcast...");
        BroadcastReceiver br = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                Log.i("ActivityManager", "Shutting down activity manager...");
                ActivityManagerService.this.shutdown(10000);
                Log.i("ActivityManager", "Shutdown complete, restarting!");
                android.os.Process.killProcess(android.os.Process.myPid());
                System.exit(10);
            }
        };
        Intent intent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        intent.addFlags(0x10000000);
        intent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
        br.onReceive(this.mContext, intent);
    }

    private long getLowRamTimeSinceIdle(long now) {
        return this.mLowRamTimeSinceLastIdle + (this.mLowRamStartTime > 0L ? now - this.mLowRamStartTime : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performIdleMaintenance() {
        if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
            throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long now = SystemClock.uptimeMillis();
            long timeSinceLastIdle = now - this.mLastIdleTime;
            long lowRamSinceLastIdle = this.getLowRamTimeSinceIdle(now);
            this.mLastIdleTime = now;
            this.mLowRamTimeSinceLastIdle = 0L;
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamStartTime = now;
            }
            StringBuilder sb = new StringBuilder(128);
            sb.append("Idle maintenance over ");
            TimeUtils.formatDuration(timeSinceLastIdle, sb);
            sb.append(" low RAM for ");
            TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
            Slog.i("ActivityManager", sb.toString());
            boolean doKilling = lowRamSinceLastIdle > timeSinceLastIdle / 3L;
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord proc = this.mLruProcesses.get(i);
                if (proc.notCachedSinceIdle) {
                    if (proc.setProcState == 5 || proc.setProcState < 4 || proc.setProcState > 10 || !doKilling || proc.initialIdlePss == 0L || proc.lastPss <= proc.initialIdlePss * 3L / 2L) continue;
                    sb = new StringBuilder(128);
                    sb.append("Kill");
                    sb.append(proc.processName);
                    sb.append(" in idle maint: pss=");
                    sb.append(proc.lastPss);
                    sb.append(", initialPss=");
                    sb.append(proc.initialIdlePss);
                    sb.append(", period=");
                    TimeUtils.formatDuration(timeSinceLastIdle, sb);
                    sb.append(", lowRamPeriod=");
                    TimeUtils.formatDuration(lowRamSinceLastIdle, sb);
                    Slog.wtfQuiet("ActivityManager", sb.toString());
                    proc.kill("idle maint (pss " + proc.lastPss + " from " + proc.initialIdlePss + ")", true);
                    continue;
                }
                if (proc.setProcState >= 12) continue;
                proc.notCachedSinceIdle = true;
                proc.initialIdlePss = 0L;
                proc.nextPssTime = ProcessList.computeNextPssTime(proc.curProcState, true, this.mTestPssMode, this.isSleeping(), now);
            }
            this.mHandler.removeMessages(39);
            this.mHandler.sendEmptyMessageDelayed(39, 120000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retrieveSettings() {
        ContentResolver resolver = this.mContext.getContentResolver();
        String debugApp = Settings.Global.getString(resolver, "debug_app");
        boolean waitForDebugger = Settings.Global.getInt(resolver, "wait_for_debugger", 0) != 0;
        boolean alwaysFinishActivities = Settings.Global.getInt(resolver, "always_finish_activities", 0) != 0;
        boolean forceRtl = Settings.Global.getInt(resolver, "debug.force_rtl", 0) != 0;
        SystemProperties.set("debug.force_rtl", forceRtl ? "1" : "0");
        Configuration configuration = new Configuration();
        Settings.System.getConfiguration(resolver, configuration);
        if (forceRtl) {
            configuration.setLayoutDirection(configuration.locale);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mDebugApp = this.mOrigDebugApp = debugApp;
            this.mWaitForDebugger = this.mOrigWaitForDebugger = waitForDebugger;
            this.mAlwaysFinishActivities = alwaysFinishActivities;
            this.updateConfigurationLocked(configuration, null, false, true);
        }
    }

    private void loadResourcesOnSystemReady() {
        Resources res = this.mContext.getResources();
        this.mHasRecents = res.getBoolean(17956990);
        this.mThumbnailWidth = res.getDimensionPixelSize(17104898);
        this.mThumbnailHeight = res.getDimensionPixelSize(0x1050001);
    }

    @Override
    public boolean testIsSystemReady() {
        return this.mSystemReady;
    }

    private static File getCalledPreBootReceiversFile() {
        File dataDir = Environment.getDataDirectory();
        File systemDir = new File(dataDir, "system");
        File fname = new File(systemDir, CALLED_PRE_BOOTS_FILENAME);
        return fname;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList<ComponentName> readLastDonePreBootReceivers() {
        ArrayList<ComponentName> lastDoneReceivers = new ArrayList<ComponentName>();
        File file = ActivityManagerService.getCalledPreBootReceiversFile();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            DataInputStream dis = new DataInputStream(new BufferedInputStream(fis, 2048));
            int fvers = dis.readInt();
            if (fvers == 10000) {
                String vers = dis.readUTF();
                String codename = dis.readUTF();
                String build = dis.readUTF();
                if (Build.VERSION.RELEASE.equals(vers) && Build.VERSION.CODENAME.equals(codename) && Build.VERSION.INCREMENTAL.equals(build)) {
                    for (int num = dis.readInt(); num > 0; --num) {
                        String pkg = dis.readUTF();
                        String cls = dis.readUTF();
                        lastDoneReceivers.add(new ComponentName(pkg, cls));
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException e) {
            Slog.w("ActivityManager", "Failure reading last done pre-boot receivers", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lastDoneReceivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLastDonePreBootReceivers(ArrayList<ComponentName> list) {
        File file = ActivityManagerService.getCalledPreBootReceiversFile();
        FileOutputStream fos = null;
        FilterOutputStream dos = null;
        try {
            fos = new FileOutputStream(file);
            dos = new DataOutputStream(new BufferedOutputStream(fos, 2048));
            ((DataOutputStream)dos).writeInt(10000);
            ((DataOutputStream)dos).writeUTF(Build.VERSION.RELEASE);
            ((DataOutputStream)dos).writeUTF(Build.VERSION.CODENAME);
            ((DataOutputStream)dos).writeUTF(Build.VERSION.INCREMENTAL);
            ((DataOutputStream)dos).writeInt(list.size());
            for (int i = 0; i < list.size(); ++i) {
                ((DataOutputStream)dos).writeUTF(list.get(i).getPackageName());
                ((DataOutputStream)dos).writeUTF(list.get(i).getClassName());
            }
        }
        catch (IOException e) {
            try {
                Slog.w("ActivityManager", "Failure writing last done pre-boot receivers", e);
                file.delete();
            }
            catch (Throwable throwable) {
                FileUtils.sync(fos);
                if (dos != null) {
                    try {
                        dos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
                throw throwable;
            }
            FileUtils.sync(fos);
            if (dos != null) {
                try {
                    dos.close();
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
            }
        }
        FileUtils.sync(fos);
        if (dos != null) {
            try {
                dos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean deliverPreBootCompleted(Runnable onFinishCallback, ArrayList<ComponentName> doneReceivers, int userId) {
        int[] nArray;
        Intent intent = new Intent("android.intent.action.PRE_BOOT_COMPLETED");
        List<ResolveInfo> ris = null;
        try {
            ris = AppGlobals.getPackageManager().queryIntentReceivers(intent, null, 0, userId);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (ris == null) {
            return false;
        }
        for (int i = ris.size() - 1; i >= 0; --i) {
            if ((ris.get((int)i).activityInfo.applicationInfo.flags & 1) != 0) continue;
            ris.remove(i);
        }
        intent.addFlags(0x2000000);
        if (userId == 0) {
            ArrayList<ComponentName> lastDoneReceivers = ActivityManagerService.readLastDonePreBootReceivers();
            for (int i = 0; i < ris.size(); ++i) {
                ActivityInfo ai = ris.get((int)i).activityInfo;
                ComponentName comp = new ComponentName(ai.packageName, ai.name);
                if (!lastDoneReceivers.contains(comp)) continue;
                ris.remove(i);
                --i;
                doneReceivers.add(comp);
            }
        }
        if (ris.size() <= 0) {
            return false;
        }
        if (userId == 0) {
            nArray = this.getUsersLocked();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        int[] users = nArray;
        if (users.length <= 0) {
            return false;
        }
        PreBootContinuation cont = new PreBootContinuation(intent, onFinishCallback, doneReceivers, ris, users);
        cont.go();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void systemReady(final Runnable goingCallback) {
        ProcessRecord proc;
        int i;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mSystemReady) {
                if (goingCallback != null) {
                    goingCallback.run();
                }
                return;
            }
            this.mLocalDeviceIdleController = LocalServices.getService(DeviceIdleController.LocalService.class);
            this.updateCurrentProfileIdsLocked();
            this.mRecentTasks.clear();
            this.mRecentTasks.addAll(this.mTaskPersister.restoreTasksLocked());
            this.mRecentTasks.cleanupLocked(-1);
            this.mTaskPersister.startPersisting();
            if (!this.mDidUpdate) {
                if (this.mWaitingUpdate) {
                    return;
                }
                final ArrayList<ComponentName> doneReceivers = new ArrayList<ComponentName>();
                this.mWaitingUpdate = this.deliverPreBootCompleted(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            ActivityManagerService.this.mDidUpdate = true;
                        }
                        ActivityManagerService.this.showBootMessage(ActivityManagerService.this.mContext.getText(17040241), false);
                        ActivityManagerService.writeLastDonePreBootReceivers(doneReceivers);
                        ActivityManagerService.this.systemReady(goingCallback);
                    }
                }, doneReceivers, 0);
                if (this.mWaitingUpdate) {
                    return;
                }
                this.mDidUpdate = true;
            }
            this.mAppOpsService.systemReady();
            this.mSystemReady = true;
        }
        ArrayList<ProcessRecord> procsToKill = null;
        Object object = this.mPidsSelfLocked;
        synchronized (object) {
            for (i = this.mPidsSelfLocked.size() - 1; i >= 0; --i) {
                proc = this.mPidsSelfLocked.valueAt(i);
                if (this.isAllowedWhileBooting(proc.info)) continue;
                if (procsToKill == null) {
                    procsToKill = new ArrayList<ProcessRecord>();
                }
                procsToKill.add(proc);
            }
        }
        object = this;
        synchronized (object) {
            if (procsToKill != null) {
                for (i = procsToKill.size() - 1; i >= 0; --i) {
                    proc = (ProcessRecord)procsToKill.get(i);
                    Slog.i("ActivityManager", "Removing system update proc: " + proc);
                    this.removeProcessLocked(proc, true, false, "system update done");
                }
            }
            this.mProcessesReady = true;
        }
        Slog.i("ActivityManager", "System now ready");
        EventLog.writeEvent(3040, SystemClock.uptimeMillis());
        object = this;
        synchronized (object) {
            if (this.mFactoryTest == 1) {
                ResolveInfo ri = this.mContext.getPackageManager().resolveActivity(new Intent("android.intent.action.FACTORY_TEST"), 1024);
                CharSequence errorMsg = null;
                if (ri != null) {
                    ActivityInfo ai = ri.activityInfo;
                    ApplicationInfo app = ai.applicationInfo;
                    if ((app.flags & 1) != 0) {
                        this.mTopAction = "android.intent.action.FACTORY_TEST";
                        this.mTopData = null;
                        this.mTopComponent = new ComponentName(app.packageName, ai.name);
                    } else {
                        errorMsg = this.mContext.getResources().getText(17040057);
                    }
                } else {
                    errorMsg = this.mContext.getResources().getText(17040058);
                }
                if (errorMsg != null) {
                    this.mTopAction = null;
                    this.mTopData = null;
                    this.mTopComponent = null;
                    Message msg = Message.obtain();
                    msg.what = 3;
                    msg.getData().putCharSequence("msg", errorMsg);
                    this.mUiHandler.sendMessage(msg);
                }
            }
        }
        this.retrieveSettings();
        this.loadResourcesOnSystemReady();
        object = this;
        synchronized (object) {
            this.readGrantedUriPermissionsLocked();
        }
        if (goingCallback != null) {
            goingCallback.run();
        }
        this.mBatteryStatsService.noteEvent(32775, Integer.toString(this.mCurrentUserId), this.mCurrentUserId);
        this.mBatteryStatsService.noteEvent(32776, Integer.toString(this.mCurrentUserId), this.mCurrentUserId);
        this.mSystemServiceManager.startUser(this.mCurrentUserId);
        object = this;
        synchronized (object) {
            if (this.mFactoryTest != 1) {
                try {
                    List<ApplicationInfo> apps = AppGlobals.getPackageManager().getPersistentApplications(1024);
                    if (apps != null) {
                        int N = apps.size();
                        for (int i2 = 0; i2 < N; ++i2) {
                            ApplicationInfo info = apps.get(i2);
                            if (info == null || info.packageName.equals("android")) continue;
                            this.addAppLocked(info, false, null);
                        }
                    }
                }
                catch (RemoteException ex) {
                    // empty catch block
                }
            }
            this.mBooting = true;
            this.startHomeActivityLocked(this.mCurrentUserId, "systemReady");
            try {
                if (AppGlobals.getPackageManager().hasSystemUidErrors()) {
                    Slog.e("ActivityManager", "UIDs on the system are inconsistent, you need to wipe your data partition or your device will be unstable.");
                    this.mUiHandler.obtainMessage(14).sendToTarget();
                }
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (!Build.isBuildConsistent()) {
                Slog.e("ActivityManager", "Build fingerprint is not consistent, warning user");
                this.mUiHandler.obtainMessage(15).sendToTarget();
            }
            long ident = Binder.clearCallingIdentity();
            try {
                Intent intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", this.mCurrentUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, this.mCurrentUserId);
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", this.mCurrentUserId);
                this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, MY_PID, 1000, -1);
            }
            catch (Throwable t) {
                Slog.wtf("ActivityManager", "Failed sending first user broadcasts", t);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
            this.mStackSupervisor.resumeTopActivitiesLocked();
            this.sendUserSwitchBroadcastsLocked(-1, this.mCurrentUserId);
        }
    }

    private boolean makeAppCrashingLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace) {
        app.crashing = true;
        app.crashingReport = this.generateProcessError(app, 1, null, shortMsg, longMsg, stackTrace);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
        return this.handleAppCrashLocked(app, "force-crash", shortMsg, longMsg, stackTrace);
    }

    private void makeAppNotRespondingLocked(ProcessRecord app, String activity, String shortMsg, String longMsg) {
        app.notResponding = true;
        app.notRespondingReport = this.generateProcessError(app, 2, activity, shortMsg, longMsg, null);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
    }

    private ActivityManager.ProcessErrorStateInfo generateProcessError(ProcessRecord app, int condition, String activity, String shortMsg, String longMsg, String stackTrace) {
        ActivityManager.ProcessErrorStateInfo report = new ActivityManager.ProcessErrorStateInfo();
        report.condition = condition;
        report.processName = app.processName;
        report.pid = app.pid;
        report.uid = app.info.uid;
        report.tag = activity;
        report.shortMsg = shortMsg;
        report.longMsg = longMsg;
        report.stackTrace = stackTrace;
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void killAppAtUsersRequest(ProcessRecord app, Dialog fromDialog) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            app.crashing = false;
            app.crashingReport = null;
            app.notResponding = false;
            app.notRespondingReport = null;
            if (app.anrDialog == fromDialog) {
                app.anrDialog = null;
            }
            if (app.waitDialog == fromDialog) {
                app.waitDialog = null;
            }
            if (app.pid > 0 && app.pid != MY_PID) {
                this.handleAppCrashLocked(app, "user-terminated", null, null, null);
                app.kill("user request after error", true);
            }
        }
    }

    private boolean handleAppCrashLocked(ProcessRecord app, String reason, String shortMsg, String longMsg, String stackTrace) {
        long now = SystemClock.uptimeMillis();
        Long crashTime = !app.isolated ? this.mProcessCrashTimes.get(app.info.processName, app.uid) : null;
        if (crashTime != null && now < crashTime + 60000L) {
            Slog.w("ActivityManager", "Process " + app.info.processName + " has crashed too many times: killing!");
            EventLog.writeEvent(30032, app.userId, app.info.processName, app.uid);
            this.mStackSupervisor.handleAppCrashLocked(app);
            if (!app.persistent) {
                EventLog.writeEvent(30015, app.userId, app.uid, app.info.processName);
                if (!app.isolated) {
                    this.mBadProcesses.put(app.info.processName, app.uid, new BadProcessInfo(now, shortMsg, longMsg, stackTrace));
                    this.mProcessCrashTimes.remove(app.info.processName, app.uid);
                }
                app.bad = true;
                app.removed = true;
                this.removeProcessLocked(app, false, false, "crash");
                this.mStackSupervisor.resumeTopActivitiesLocked();
                return false;
            }
            this.mStackSupervisor.resumeTopActivitiesLocked();
        } else {
            this.mStackSupervisor.finishTopRunningActivityLocked(app, reason);
        }
        for (int i = app.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = app.services.valueAt(i);
            ++sr.crashCount;
        }
        ArrayList<ActivityRecord> activities = app.activities;
        if (app == this.mHomeProcess && activities.size() > 0 && (this.mHomeProcess.info.flags & 1) == 0) {
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isHomeActivity()) continue;
                Log.i("ActivityManager", "Clearing package preferred activities from " + r.packageName);
                try {
                    ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                    continue;
                }
                catch (RemoteException c) {
                    // empty catch block
                }
            }
        }
        if (!app.isolated) {
            this.mProcessCrashTimes.put(app.info.processName, app.uid, now);
        }
        if (app.crashHandler != null) {
            this.mHandler.post(app.crashHandler);
        }
        return true;
    }

    void startAppProblemLocked(ProcessRecord app) {
        app.errorReportReceiver = null;
        for (int userId : this.mCurrentProfileIds) {
            if (app.userId != userId) continue;
            app.errorReportReceiver = ApplicationErrorReport.getErrorReportReceiver(this.mContext, app.info.packageName, app.info.flags);
        }
        this.skipCurrentReceiverLocked(app);
    }

    void skipCurrentReceiverLocked(ProcessRecord app) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipCurrentReceiverLocked(app);
        }
    }

    @Override
    public void handleApplicationCrash(IBinder app, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "Crash");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        this.handleApplicationCrashInner("crash", r, processName, crashInfo);
    }

    void handleApplicationCrashInner(String eventType, ProcessRecord r, String processName, ApplicationErrorReport.CrashInfo crashInfo) {
        EventLog.writeEvent(30039, Binder.getCallingPid(), UserHandle.getUserId(Binder.getCallingUid()), processName, r == null ? -1 : r.info.flags, crashInfo.exceptionClassName, crashInfo.exceptionMessage, crashInfo.throwFileName, crashInfo.throwLineNumber);
        this.addErrorToDropBox(eventType, r, processName, null, null, null, null, null, crashInfo);
        this.crashApplication(r, crashInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleApplicationStrictModeViolation(IBinder app, int violationMask, StrictMode.ViolationInfo info) {
        ProcessRecord r = this.findAppProcess(app, "StrictMode");
        if (r == null) {
            return;
        }
        if ((violationMask & 0x200000) != 0) {
            Integer stackFingerprint = info.hashCode();
            boolean logIt = true;
            HashSet<Integer> hashSet = this.mAlreadyLoggedViolatedStacks;
            synchronized (hashSet) {
                if (this.mAlreadyLoggedViolatedStacks.contains(stackFingerprint)) {
                    logIt = false;
                } else {
                    if (this.mAlreadyLoggedViolatedStacks.size() >= 5000) {
                        this.mAlreadyLoggedViolatedStacks.clear();
                    }
                    this.mAlreadyLoggedViolatedStacks.add(stackFingerprint);
                }
            }
            if (logIt) {
                this.logStrictModeViolationToDropBox(r, info);
            }
        }
        if ((violationMask & 0x20000) != 0) {
            AppErrorResult result = new AppErrorResult();
            ActivityManagerService logIt = this;
            synchronized (logIt) {
                long origId = Binder.clearCallingIdentity();
                Message msg = Message.obtain();
                msg.what = 26;
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("result", result);
                data.put("app", r);
                data.put("violationMask", violationMask);
                data.put("info", info);
                msg.obj = data;
                this.mUiHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(origId);
            }
            int res = result.get();
            Slog.w("ActivityManager", "handleApplicationStrictModeViolation; res=" + res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logStrictModeViolationToDropBox(ProcessRecord process, StrictMode.ViolationInfo info) {
        boolean needsFlush;
        boolean bufferWasEmpty;
        StringBuilder sb;
        if (info == null) {
            return;
        }
        boolean isSystemApp = process == null || (process.info.flags & 0x81) != 0;
        String processName = process == null ? "unknown" : process.processName;
        final String dropboxTag = isSystemApp ? "system_app_strictmode" : "data_app_strictmode";
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        StringBuilder stringBuilder = sb = isSystemApp ? this.mStrictModeBuffer : new StringBuilder(1024);
        synchronized (stringBuilder) {
            bufferWasEmpty = sb.length() == 0;
            this.appendDropBoxProcessHeaders(process, processName, sb);
            sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
            sb.append("System-App: ").append(isSystemApp).append("\n");
            sb.append("Uptime-Millis: ").append(info.violationUptimeMillis).append("\n");
            if (info.violationNumThisLoop != 0) {
                sb.append("Loop-Violation-Number: ").append(info.violationNumThisLoop).append("\n");
            }
            if (info.numAnimationsRunning != 0) {
                sb.append("Animations-Running: ").append(info.numAnimationsRunning).append("\n");
            }
            if (info.broadcastIntentAction != null) {
                sb.append("Broadcast-Intent-Action: ").append(info.broadcastIntentAction).append("\n");
            }
            if (info.durationMillis != -1) {
                sb.append("Duration-Millis: ").append(info.durationMillis).append("\n");
            }
            if (info.numInstances != -1L) {
                sb.append("Instance-Count: ").append(info.numInstances).append("\n");
            }
            if (info.tags != null) {
                for (String tag : info.tags) {
                    sb.append("Span-Tag: ").append(tag).append("\n");
                }
            }
            sb.append("\n");
            if (info.crashInfo != null && info.crashInfo.stackTrace != null) {
                sb.append(info.crashInfo.stackTrace);
                sb.append("\n");
            }
            if (info.message != null) {
                sb.append(info.message);
                sb.append("\n");
            }
            needsFlush = sb.length() > 65536;
        }
        if (!isSystemApp || needsFlush) {
            new Thread("Error dump: " + dropboxTag){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String report;
                    StringBuilder stringBuilder = sb;
                    synchronized (stringBuilder) {
                        report = sb.toString();
                        sb.delete(0, sb.length());
                        sb.trimToSize();
                    }
                    if (report.length() != 0) {
                        dbox.addText(dropboxTag, report);
                    }
                }
            }.start();
            return;
        }
        if (!bufferWasEmpty) {
            return;
        }
        new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String errorReport;
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                StringBuilder stringBuilder = ActivityManagerService.this.mStrictModeBuffer;
                synchronized (stringBuilder) {
                    errorReport = ActivityManagerService.this.mStrictModeBuffer.toString();
                    if (errorReport.length() == 0) {
                        return;
                    }
                    ActivityManagerService.this.mStrictModeBuffer.delete(0, ActivityManagerService.this.mStrictModeBuffer.length());
                    ActivityManagerService.this.mStrictModeBuffer.trimToSize();
                }
                dbox.addText(dropboxTag, errorReport);
            }
        }.start();
    }

    @Override
    public boolean handleApplicationWtf(final IBinder app, final String tag, boolean system, final ApplicationErrorReport.CrashInfo crashInfo) {
        final int callingUid = Binder.getCallingUid();
        final int callingPid = Binder.getCallingPid();
        if (system) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ActivityManagerService.this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
                }
            });
            return false;
        }
        ProcessRecord r = this.handleApplicationWtfInner(callingUid, callingPid, app, tag, crashInfo);
        if (r != null && r.pid != android.os.Process.myPid() && Settings.Global.getInt(this.mContext.getContentResolver(), "wtf_is_fatal", 0) != 0) {
            this.crashApplication(r, crashInfo);
            return true;
        }
        return false;
    }

    ProcessRecord handleApplicationWtfInner(int callingUid, int callingPid, IBinder app, String tag, ApplicationErrorReport.CrashInfo crashInfo) {
        ProcessRecord r = this.findAppProcess(app, "WTF");
        String processName = app == null ? "system_server" : (r == null ? "unknown" : r.processName);
        EventLog.writeEvent(30040, UserHandle.getUserId(callingUid), callingPid, processName, r == null ? -1 : r.info.flags, tag, crashInfo.exceptionMessage);
        this.addErrorToDropBox("wtf", r, processName, null, null, tag, null, null, crashInfo);
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findAppProcess(IBinder app, String reason) {
        if (app == null) {
            return null;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> apps = this.mProcessNames.getMap().valueAt(ip);
                int NA = apps.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord p = apps.valueAt(ia);
                    if (p.thread == null || p.thread.asBinder() != app) continue;
                    return p;
                }
            }
            Slog.w("ActivityManager", "Can't find mystery application for " + reason + " from pid=" + Binder.getCallingPid() + " uid=" + Binder.getCallingUid() + ": " + app);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendDropBoxProcessHeaders(ProcessRecord process, String processName, StringBuilder sb) {
        if (process == null) {
            sb.append("Process: ").append(processName).append("\n");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            sb.append("Process: ").append(processName).append("\n");
            int flags = process.info.flags;
            IPackageManager pm = AppGlobals.getPackageManager();
            sb.append("Flags: 0x").append(Integer.toString(flags, 16)).append("\n");
            for (int ip = 0; ip < process.pkgList.size(); ++ip) {
                String pkg = process.pkgList.keyAt(ip);
                sb.append("Package: ").append(pkg);
                try {
                    PackageInfo pi = pm.getPackageInfo(pkg, 0, UserHandle.getCallingUserId());
                    if (pi != null) {
                        sb.append(" v").append(pi.versionCode);
                        if (pi.versionName != null) {
                            sb.append(" (").append(pi.versionName).append(")");
                        }
                    }
                }
                catch (RemoteException e) {
                    Slog.e("ActivityManager", "Error getting package info: " + pkg, e);
                }
                sb.append("\n");
            }
        }
    }

    private static String processClass(ProcessRecord process) {
        if (process == null || process.pid == MY_PID) {
            return "system_server";
        }
        if ((process.info.flags & 1) != 0) {
            return "system_app";
        }
        return "data_app";
    }

    public void addErrorToDropBox(String eventType, ProcessRecord process, String processName, ActivityRecord activity, ActivityRecord parent, String subject, final String report, final File logFile, final ApplicationErrorReport.CrashInfo crashInfo) {
        final String dropboxTag = ActivityManagerService.processClass(process) + "_" + eventType;
        final DropBoxManager dbox = (DropBoxManager)this.mContext.getSystemService("dropbox");
        if (dbox == null || !dbox.isTagEnabled(dropboxTag)) {
            return;
        }
        final StringBuilder sb = new StringBuilder(1024);
        this.appendDropBoxProcessHeaders(process, processName, sb);
        if (activity != null) {
            sb.append("Activity: ").append(activity.shortComponentName).append("\n");
        }
        if (parent != null && parent.app != null && parent.app.pid != process.pid) {
            sb.append("Parent-Process: ").append(parent.app.processName).append("\n");
        }
        if (parent != null && parent != activity) {
            sb.append("Parent-Activity: ").append(parent.shortComponentName).append("\n");
        }
        if (subject != null) {
            sb.append("Subject: ").append(subject).append("\n");
        }
        sb.append("Build: ").append(Build.FINGERPRINT).append("\n");
        if (Debug.isDebuggerConnected()) {
            sb.append("Debugger: Connected\n");
        }
        sb.append("\n");
        Thread worker = new Thread("Error dump: " + dropboxTag){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (report != null) {
                    sb.append(report);
                }
                if (logFile != null) {
                    try {
                        sb.append(FileUtils.readTextFile(logFile, 262144, "\n\n[[TRUNCATED]]"));
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error reading " + logFile, e);
                    }
                }
                if (crashInfo != null && crashInfo.stackTrace != null) {
                    sb.append(crashInfo.stackTrace);
                }
                String setting = "logcat_for_" + dropboxTag;
                int lines = Settings.Global.getInt(ActivityManagerService.this.mContext.getContentResolver(), setting, 0);
                if (lines > 0) {
                    sb.append("\n");
                    InputStreamReader input = null;
                    try {
                        int num;
                        Process logcat = new ProcessBuilder("/system/bin/logcat", "-v", "time", "-b", "events", "-b", "system", "-b", "main", "-b", "crash", "-t", String.valueOf(lines)).redirectErrorStream(true).start();
                        try {
                            logcat.getOutputStream().close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        try {
                            logcat.getErrorStream().close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        input = new InputStreamReader(logcat.getInputStream());
                        char[] buf = new char[8192];
                        while ((num = input.read(buf)) > 0) {
                            sb.append(buf, 0, num);
                        }
                    }
                    catch (IOException e) {
                        Slog.e("ActivityManager", "Error running logcat", e);
                    }
                    finally {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                dbox.addText(dropboxTag, sb.toString());
            }
        };
        if (process == null) {
            worker.run();
        } else {
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void crashApplication(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo) {
        long timeMillis = System.currentTimeMillis();
        String shortMsg = crashInfo.exceptionClassName;
        String longMsg = crashInfo.exceptionMessage;
        String stackTrace = crashInfo.stackTrace;
        if (shortMsg != null && longMsg != null) {
            longMsg = shortMsg + ": " + longMsg;
        } else if (shortMsg != null) {
            longMsg = shortMsg;
        }
        AppErrorResult result = new AppErrorResult();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.mController != null) {
                try {
                    int uid;
                    String name = r != null ? r.processName : null;
                    int pid = r != null ? r.pid : Binder.getCallingPid();
                    int n = uid = r != null ? r.info.uid : Binder.getCallingUid();
                    if (!this.mController.appCrashed(name, pid, shortMsg, longMsg, timeMillis, crashInfo.stackTrace)) {
                        if ("1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0")) && "Native crash".equals(crashInfo.exceptionClassName)) {
                            Slog.w("ActivityManager", "Skip killing native crashed app " + name + "(" + pid + ") during testing");
                        } else {
                            Slog.w("ActivityManager", "Force-killing crashed app " + name + " at watcher's request");
                            if (r != null) {
                                r.kill("crash", true);
                            } else {
                                android.os.Process.killProcess(pid);
                                ActivityManagerService.killProcessGroup(uid, pid);
                            }
                        }
                        return;
                    }
                }
                catch (RemoteException e) {
                    this.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            long origId = Binder.clearCallingIdentity();
            if (r != null && r.instrumentationClass != null) {
                Slog.w("ActivityManager", "Error in app " + r.processName + " running instrumentation " + r.instrumentationClass + ":");
                if (shortMsg != null) {
                    Slog.w("ActivityManager", "  " + shortMsg);
                }
                if (longMsg != null) {
                    Slog.w("ActivityManager", "  " + longMsg);
                }
                Bundle info = new Bundle();
                info.putString("shortMsg", shortMsg);
                info.putString("longMsg", longMsg);
                this.finishInstrumentationLocked(r, 0, info);
                Binder.restoreCallingIdentity(origId);
                return;
            }
            if (r != null) {
                this.mBatteryStatsService.noteProcessCrash(r.processName, r.uid);
            }
            if (r == null || !this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace)) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
            Message msg = Message.obtain();
            msg.what = 1;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("result", result);
            data.put("app", r);
            msg.obj = data;
            this.mUiHandler.sendMessage(msg);
            Binder.restoreCallingIdentity(origId);
        }
        int res = result.get();
        Intent appErrorIntent = null;
        ActivityManagerService pid = this;
        synchronized (pid) {
            if (r != null && !r.isolated) {
                this.mProcessCrashTimes.put(r.info.processName, r.uid, SystemClock.uptimeMillis());
            }
            if (res == 1) {
                appErrorIntent = this.createAppErrorIntentLocked(r, timeMillis, crashInfo);
            }
        }
        if (appErrorIntent != null) {
            try {
                this.mContext.startActivityAsUser(appErrorIntent, new UserHandle(r.userId));
            }
            catch (ActivityNotFoundException e) {
                Slog.w("ActivityManager", "bug report receiver dissappeared", e);
            }
        }
    }

    Intent createAppErrorIntentLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        ApplicationErrorReport report = this.createAppErrorReportLocked(r, timeMillis, crashInfo);
        if (report == null) {
            return null;
        }
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(r.errorReportReceiver);
        result.putExtra("android.intent.extra.BUG_REPORT", report);
        result.addFlags(0x10000000);
        return result;
    }

    private ApplicationErrorReport createAppErrorReportLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        if (r.errorReportReceiver == null) {
            return null;
        }
        if (!(r.crashing || r.notResponding || r.forceCrashReport)) {
            return null;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = r.info.packageName;
        report.installerPackageName = r.errorReportReceiver.getPackageName();
        report.processName = r.processName;
        report.time = timeMillis;
        boolean bl = report.systemApp = (r.info.flags & 1) != 0;
        if (r.crashing || r.forceCrashReport) {
            report.type = 1;
            report.crashInfo = crashInfo;
        } else if (r.notResponding) {
            report.type = 2;
            report.anrInfo = new ApplicationErrorReport.AnrInfo();
            report.anrInfo.activity = r.notRespondingReport.tag;
            report.anrInfo.cause = r.notRespondingReport.shortMsg;
            report.anrInfo.info = r.notRespondingReport.longMsg;
        }
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.ProcessErrorStateInfo> getProcessesInErrorState() {
        this.enforceNotIsolatedCaller("getProcessesInErrorState");
        ArrayList<ActivityManager.ProcessErrorStateInfo> errList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", Binder.getCallingUid()) == 0;
        int userId = UserHandle.getUserId(Binder.getCallingUid());
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || app.thread == null || !app.crashing && !app.notResponding) continue;
                ActivityManager.ProcessErrorStateInfo report = null;
                if (app.crashing) {
                    report = app.crashingReport;
                } else if (app.notResponding) {
                    report = app.notRespondingReport;
                }
                if (report != null) {
                    if (errList == null) {
                        errList = new ArrayList<ActivityManager.ProcessErrorStateInfo>(1);
                    }
                    errList.add(report);
                    continue;
                }
                Slog.w("ActivityManager", "Missing app error report, app = " + app.processName + " crashing = " + app.crashing + " notResponding = " + app.notResponding);
            }
        }
        return errList;
    }

    static int procStateToImportance(int procState, int memAdj, ActivityManager.RunningAppProcessInfo currApp) {
        int imp = ActivityManager.RunningAppProcessInfo.procStateToImportance(procState);
        currApp.lru = imp == 400 ? memAdj : 0;
        return imp;
    }

    private void fillInProcMemInfo(ProcessRecord app, ActivityManager.RunningAppProcessInfo outInfo) {
        outInfo.pid = app.pid;
        outInfo.uid = app.info.uid;
        if (this.mHeavyWeightProcess == app) {
            outInfo.flags |= 1;
        }
        if (app.persistent) {
            outInfo.flags |= 2;
        }
        if (app.activities.size() > 0) {
            outInfo.flags |= 4;
        }
        outInfo.lastTrimLevel = app.trimMemoryLevel;
        int adj = app.curAdj;
        int procState = app.curProcState;
        outInfo.importance = ActivityManagerService.procStateToImportance(procState, adj, outInfo);
        outInfo.importanceReasonCode = app.adjTypeCode;
        outInfo.processState = app.curProcState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningAppProcessInfo> getRunningAppProcesses() {
        this.enforceNotIsolatedCaller("getRunningAppProcesses");
        int callingUid = Binder.getCallingUid();
        ArrayList<ActivityManager.RunningAppProcessInfo> runList = null;
        boolean allUsers = ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingUid) == 0;
        int userId = UserHandle.getUserId(callingUid);
        boolean allUids = this.isGetTasksAllowed("getRunningAppProcesses", Binder.getCallingPid(), callingUid);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (!allUsers && app.userId != userId || !allUids && app.uid != callingUid || app.thread == null || app.crashing || app.notResponding) continue;
                ActivityManager.RunningAppProcessInfo currApp = new ActivityManager.RunningAppProcessInfo(app.processName, app.pid, app.getPackageList());
                this.fillInProcMemInfo(app, currApp);
                if (app.adjSource instanceof ProcessRecord) {
                    currApp.importanceReasonPid = ((ProcessRecord)app.adjSource).pid;
                    currApp.importanceReasonImportance = ActivityManager.RunningAppProcessInfo.procStateToImportance(app.adjSourceProcState);
                } else if (app.adjSource instanceof ActivityRecord) {
                    ActivityRecord r = (ActivityRecord)app.adjSource;
                    if (r.app != null) {
                        currApp.importanceReasonPid = r.app.pid;
                    }
                }
                if (app.adjTarget instanceof ComponentName) {
                    currApp.importanceReasonComponent = (ComponentName)app.adjTarget;
                }
                if (runList == null) {
                    runList = new ArrayList<ActivityManager.RunningAppProcessInfo>();
                }
                runList.add(currApp);
            }
        }
        return runList;
    }

    @Override
    public List<ApplicationInfo> getRunningExternalApplications() {
        this.enforceNotIsolatedCaller("getRunningExternalApplications");
        List<ActivityManager.RunningAppProcessInfo> runningApps = this.getRunningAppProcesses();
        ArrayList<ApplicationInfo> retList = new ArrayList<ApplicationInfo>();
        if (runningApps != null && runningApps.size() > 0) {
            HashSet<String> extList = new HashSet<String>();
            for (ActivityManager.RunningAppProcessInfo app : runningApps) {
                if (app.pkgList == null) continue;
                for (String pkg : app.pkgList) {
                    extList.add(pkg);
                }
            }
            IPackageManager pm = AppGlobals.getPackageManager();
            for (String pkg : extList) {
                try {
                    ApplicationInfo info = pm.getApplicationInfo(pkg, 0, UserHandle.getCallingUserId());
                    if ((info.flags & 0x40000) == 0) continue;
                    retList.add(info);
                }
                catch (RemoteException e) {}
            }
        }
        return retList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMyMemoryState(ActivityManager.RunningAppProcessInfo outInfo) {
        this.enforceNotIsolatedCaller("getMyMemoryState");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord proc;
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
            }
            this.fillInProcMemInfo(proc, outInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        String opt;
        if (this.checkCallingPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump ActivityManager from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        boolean dumpAll = false;
        boolean dumpClient = false;
        String dumpPackage = null;
        int opti = 0;
        while (opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-') {
            ++opti;
            if ("-a".equals(opt)) {
                dumpAll = true;
                continue;
            }
            if ("-c".equals(opt)) {
                dumpClient = true;
                continue;
            }
            if ("-p".equals(opt)) {
                if (opti < args.length) {
                    dumpPackage = args[opti];
                    ++opti;
                } else {
                    pw.println("Error: -p option requires package argument");
                    return;
                }
                dumpClient = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("Activity manager dump options:");
                pw.println("  [-a] [-c] [-p package] [-h] [cmd] ...");
                pw.println("  cmd may be one of:");
                pw.println("    a[ctivities]: activity stack state");
                pw.println("    r[recents]: recent activities state");
                pw.println("    b[roadcasts] [PACKAGE_NAME] [history [-s]]: broadcast state");
                pw.println("    i[ntents] [PACKAGE_NAME]: pending intent state");
                pw.println("    p[rocesses] [PACKAGE_NAME]: process state");
                pw.println("    o[om]: out of memory management");
                pw.println("    perm[issions]: URI permission grant state");
                pw.println("    prov[iders] [COMP_SPEC ...]: content provider state");
                pw.println("    provider [COMP_SPEC]: provider client-side state");
                pw.println("    s[ervices] [COMP_SPEC ...]: service state");
                pw.println("    as[sociations]: tracked app associations");
                pw.println("    service [COMP_SPEC]: service client-side state");
                pw.println("    package [PACKAGE_NAME]: all state related to given package");
                pw.println("    all: dump all activities");
                pw.println("    top: dump the top activity");
                pw.println("    write: write all pending state to storage");
                pw.println("    track-associations: enable association tracking");
                pw.println("    untrack-associations: disable and clear association tracking");
                pw.println("  cmd may also be a COMP_SPEC to dump activities.");
                pw.println("  COMP_SPEC may be a component name (com.foo/.myApp),");
                pw.println("    a partial substring in a component name, a");
                pw.println("    hex object identifier.");
                pw.println("  -a: include all available server state.");
                pw.println("  -c: include client state.");
                pw.println("  -p: limit output to given package.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        long origId = Binder.clearCallingIdentity();
        boolean more = false;
        if (opti < args.length) {
            String cmd = args[opti];
            ++opti;
            if ("activities".equals(cmd) || "a".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpActivitiesLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                }
            }
            if ("recents".equals(cmd) || "r".equals(cmd)) {
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpRecentsLocked(fd, pw, args, opti, true, dumpPackage);
                }
            }
            if ("broadcasts".equals(cmd) || "b".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpBroadcastsLocked(fd, pw, args, opti, true, dumpPackage);
                }
            }
            if ("intents".equals(cmd) || "i".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpPendingIntentsLocked(fd, pw, args, opti, true, dumpPackage);
                }
            }
            if ("processes".equals(cmd) || "p".equals(cmd)) {
                if (opti >= args.length) {
                    Object name = null;
                    String[] newArgs = EMPTY_STRING_ARRAY;
                } else {
                    dumpPackage = args[opti];
                    String[] newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    this.dumpProcessesLocked(fd, pw, args, opti, true, dumpPackage);
                }
            }
            if ("oom".equals(cmd) || "o".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpOomLocked(fd, pw, args, opti, true);
                }
            }
            if ("permissions".equals(cmd) || "perm".equals(cmd)) {
                ActivityManagerService newArgs = this;
                synchronized (newArgs) {
                    this.dumpPermissionsLocked(fd, pw, args, opti, true, null);
                }
            }
            if ("provider".equals(cmd)) {
                String[] newArgs;
                String name;
                if (opti >= args.length) {
                    name = null;
                    newArgs = EMPTY_STRING_ARRAY;
                } else {
                    name = args[opti];
                    newArgs = new String[args.length - ++opti];
                    if (args.length > 2) {
                        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                    }
                }
                if (!this.dumpProvider(fd, pw, name, newArgs, 0, dumpAll)) {
                    pw.println("No providers match: " + name);
                    pw.println("Use -h for help.");
                }
            } else {
                if ("providers".equals(cmd) || "prov".equals(cmd)) {
                    ActivityManagerService newArgs = this;
                    synchronized (newArgs) {
                        this.dumpProvidersLocked(fd, pw, args, opti, true, null);
                    }
                }
                if ("service".equals(cmd)) {
                    String[] newArgs;
                    String name;
                    if (opti >= args.length) {
                        name = null;
                        newArgs = EMPTY_STRING_ARRAY;
                    } else {
                        name = args[opti];
                        newArgs = new String[args.length - ++opti];
                        if (args.length > 2) {
                            System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                        }
                    }
                    if (!this.mServices.dumpService(fd, pw, name, newArgs, 0, dumpAll)) {
                        pw.println("No services match: " + name);
                        pw.println("Use -h for help.");
                    }
                } else if ("package".equals(cmd)) {
                    if (opti >= args.length) {
                        pw.println("package: no package name specified");
                        pw.println("Use -h for help.");
                    } else {
                        dumpPackage = args[opti];
                        String[] newArgs = new String[args.length - ++opti];
                        if (args.length > 2) {
                            System.arraycopy(args, opti, newArgs, 0, args.length - opti);
                        }
                        args = newArgs;
                        opti = 0;
                        more = true;
                    }
                } else {
                    if ("associations".equals(cmd) || "as".equals(cmd)) {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            this.dumpAssociationsLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                        }
                    }
                    if ("services".equals(cmd) || "s".equals(cmd)) {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            this.mServices.dumpServicesLocked(fd, pw, args, opti, true, dumpClient, dumpPackage);
                        }
                    }
                    if ("write".equals(cmd)) {
                        this.mTaskPersister.flush();
                        pw.println("All tasks persisted.");
                        return;
                    }
                    if ("track-associations".equals(cmd)) {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            if (!this.mTrackingAssociations) {
                                this.mTrackingAssociations = true;
                                pw.println("Association tracking started.");
                            } else {
                                pw.println("Association tracking already enabled.");
                            }
                        }
                        return;
                    }
                    if ("untrack-associations".equals(cmd)) {
                        ActivityManagerService activityManagerService = this;
                        synchronized (activityManagerService) {
                            if (this.mTrackingAssociations) {
                                this.mTrackingAssociations = false;
                                this.mAssociations.clear();
                                pw.println("Association tracking stopped.");
                            } else {
                                pw.println("Association tracking not running.");
                            }
                        }
                        return;
                    }
                    if (!this.dumpActivity(fd, pw, cmd, args, opti, dumpAll)) {
                        pw.println("Bad activity command, or no activities match: " + cmd);
                        pw.println("Use -h for help.");
                    }
                }
            }
            if (!more) {
                Binder.restoreCallingIdentity(origId);
                return;
            }
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.dumpPendingIntentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpBroadcastsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProvidersLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpPermissionsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.mServices.dumpServicesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpRecentsLocked(fd, pw, args, opti, dumpAll, dumpPackage);
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpActivitiesLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            if (this.mAssociations.size() > 0) {
                pw.println();
                if (dumpAll) {
                    pw.println("-------------------------------------------------------------------------------");
                }
                this.dumpAssociationsLocked(fd, pw, args, opti, dumpAll, dumpClient, dumpPackage);
            }
            pw.println();
            if (dumpAll) {
                pw.println("-------------------------------------------------------------------------------");
            }
            this.dumpProcessesLocked(fd, pw, args, opti, dumpAll, dumpPackage);
        }
        Binder.restoreCallingIdentity(origId);
    }

    void dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printedAnything;
        pw.println("ACTIVITY MANAGER ACTIVITIES (dumpsys activity activities)");
        boolean needSep = printedAnything = this.mStackSupervisor.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage);
        boolean printed = ActivityStackSupervisor.printThisActivity(pw, this.mFocusedActivity, dumpPackage, needSep, "  mFocusedActivity: ");
        if (printed) {
            printedAnything = true;
            needSep = false;
        }
        if (dumpPackage == null) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            this.mStackSupervisor.dump(pw, "  ");
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpRecentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        pw.println("ACTIVITY MANAGER RECENT TASKS (dumpsys activity recents)");
        boolean printedAnything = false;
        if (this.mRecentTasks != null && this.mRecentTasks.size() > 0) {
            boolean printedHeader = false;
            int N = this.mRecentTasks.size();
            for (int i = 0; i < N; ++i) {
                TaskRecord tr = (TaskRecord)this.mRecentTasks.get(i);
                if (dumpPackage != null && (tr.realActivity == null || !dumpPackage.equals(tr.realActivity))) continue;
                if (!printedHeader) {
                    pw.println("  Recent tasks:");
                    printedHeader = true;
                    printedAnything = true;
                }
                pw.print("  * Recent #");
                pw.print(i);
                pw.print(": ");
                pw.println(tr);
                if (!dumpAll) continue;
                ((TaskRecord)this.mRecentTasks.get(i)).dump(pw, "    ");
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpAssociationsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        pw.println("ACTIVITY MANAGER ASSOCIATIONS (dumpsys activity associations)");
        int dumpUid = 0;
        if (dumpPackage != null) {
            IPackageManager pm = AppGlobals.getPackageManager();
            try {
                dumpUid = pm.getPackageUid(dumpPackage, 0);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        boolean printedAnything = false;
        long now = SystemClock.uptimeMillis();
        int N1 = this.mAssociations.size();
        for (int i1 = 0; i1 < N1; ++i1) {
            ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> targetComponents = this.mAssociations.valueAt(i1);
            int N2 = targetComponents.size();
            for (int i2 = 0; i2 < N2; ++i2) {
                SparseArray<ArrayMap<String, Association>> sourceUids = targetComponents.valueAt(i2);
                int N3 = sourceUids.size();
                for (int i3 = 0; i3 < N3; ++i3) {
                    ArrayMap<String, Association> sourceProcesses = sourceUids.valueAt(i3);
                    int N4 = sourceProcesses.size();
                    for (int i4 = 0; i4 < N4; ++i4) {
                        Association ass = sourceProcesses.valueAt(i4);
                        if (dumpPackage != null && !ass.mTargetComponent.getPackageName().equals(dumpPackage) && UserHandle.getAppId(ass.mSourceUid) != dumpUid) continue;
                        printedAnything = true;
                        pw.print("  ");
                        pw.print(ass.mTargetProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mTargetUid);
                        pw.print(" <- ");
                        pw.print(ass.mSourceProcess);
                        pw.print("/");
                        UserHandle.formatUid(pw, ass.mSourceUid);
                        pw.println();
                        pw.print("    via ");
                        pw.print(ass.mTargetComponent.flattenToShortString());
                        pw.println();
                        pw.print("    ");
                        long dur = ass.mTime;
                        if (ass.mNesting > 0) {
                            dur += now - ass.mStartTime;
                        }
                        TimeUtils.formatDuration(dur, pw);
                        pw.print(" (");
                        pw.print(ass.mCount);
                        pw.println(" times)");
                        if (ass.mNesting <= 0) continue;
                        pw.print("    ");
                        pw.print(" Currently active: ");
                        TimeUtils.formatDuration(now - ass.mStartTime, pw);
                        pw.println();
                    }
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpProcessesLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed;
        int i3;
        boolean printed2;
        boolean needSep = false;
        boolean printedAnything = false;
        int numPers = 0;
        pw.println("ACTIVITY MANAGER RUNNING PROCESSES (dumpsys activity processes)");
        if (dumpAll) {
            int NP = this.mProcessNames.getMap().size();
            for (int ip = 0; ip < NP; ++ip) {
                SparseArray<ProcessRecord> procs = this.mProcessNames.getMap().valueAt(ip);
                int NA = procs.size();
                for (int ia = 0; ia < NA; ++ia) {
                    ProcessRecord r = procs.valueAt(ia);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!needSep) {
                        pw.println("  All known processes:");
                        needSep = true;
                        printedAnything = true;
                    }
                    pw.print(r.persistent ? "  *PERS*" : "  *APP*");
                    pw.print(" UID ");
                    pw.print(procs.keyAt(ia));
                    pw.print(" ");
                    pw.println(r);
                    r.dump(pw, "    ");
                    if (!r.persistent) continue;
                    ++numPers;
                }
            }
        }
        if (this.mIsolatedProcesses.size() > 0) {
            printed2 = false;
            for (int i2 = 0; i2 < this.mIsolatedProcesses.size(); ++i2) {
                ProcessRecord r = this.mIsolatedProcesses.valueAt(i2);
                if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                if (!printed2) {
                    if (needSep) {
                        pw.println();
                    }
                    pw.println("  Isolated process list (sorted by uid):");
                    printedAnything = true;
                    printed2 = true;
                    needSep = true;
                }
                pw.println(String.format("%sIsolated #%2d: %s", "    ", i2, r.toString()));
            }
        }
        if (this.mActiveUids.size() > 0) {
            if (needSep) {
                pw.println();
            }
            pw.println("  UID states:");
            for (i3 = 0; i3 < this.mActiveUids.size(); ++i3) {
                UidRecord uidRec = this.mActiveUids.valueAt(i3);
                pw.print("    UID ");
                UserHandle.formatUid(pw, uidRec.uid);
                pw.print(": ");
                pw.println(uidRec);
            }
            needSep = true;
            printedAnything = true;
        }
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            pw.print("  Process LRU list (sorted by oom_adj, ");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", false, dumpPackage);
            needSep = true;
            printedAnything = true;
        }
        if (dumpAll || dumpPackage != null) {
            SparseArray<ProcessRecord> i3 = this.mPidsSelfLocked;
            synchronized (i3) {
                printed = false;
                for (int i4 = 0; i4 < this.mPidsSelfLocked.size(); ++i4) {
                    ProcessRecord r = this.mPidsSelfLocked.valueAt(i4);
                    if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  PID mappings:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mPidsSelfLocked.keyAt(i4));
                    pw.print(": ");
                    pw.println(this.mPidsSelfLocked.valueAt(i4));
                }
            }
        }
        if (this.mForegroundProcesses.size() > 0) {
            SparseArray<ProcessRecord> i3 = this.mPidsSelfLocked;
            synchronized (i3) {
                printed = false;
                for (int i5 = 0; i5 < this.mForegroundProcesses.size(); ++i5) {
                    ProcessRecord r = this.mPidsSelfLocked.get(this.mForegroundProcesses.valueAt((int)i5).pid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Foreground Processes:");
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("    PID #");
                    pw.print(this.mForegroundProcesses.keyAt(i5));
                    pw.print(": ");
                    pw.println(this.mForegroundProcesses.valueAt(i5));
                }
            }
        }
        if (this.mPersistentStartingProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Persisent processes that are starting:");
            ActivityManagerService.dumpProcessList(pw, this, this.mPersistentStartingProcesses, "    ", "Starting Norm", "Restarting PERS", dumpPackage);
        }
        if (this.mRemovedProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are being removed:");
            ActivityManagerService.dumpProcessList(pw, this, this.mRemovedProcesses, "    ", "Removed Norm", "Removed PERS", dumpPackage);
        }
        if (this.mProcessesOnHold.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            printedAnything = true;
            pw.println("  Processes that are on old until the system is ready:");
            ActivityManagerService.dumpProcessList(pw, this, this.mProcessesOnHold, "    ", "OnHold Norm", "OnHold PERS", dumpPackage);
        }
        needSep = this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, dumpPackage);
        if (this.mProcessCrashTimes.getMap().size() > 0) {
            printed2 = false;
            long now = SystemClock.uptimeMillis();
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            int NP = pmap.size();
            for (int ip = 0; ip < NP; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<Long> uids = pmap.valueAt(ip);
                int N = uids.size();
                for (int i6 = 0; i6 < N; ++i6) {
                    int puid = uids.keyAt(i6);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed2) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Time since processes crashed:");
                        printed2 = true;
                        printedAnything = true;
                    }
                    pw.print("    Process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": last crashed ");
                    TimeUtils.formatDuration(now - uids.valueAt(i6), pw);
                    pw.println(" ago");
                }
            }
        }
        if (this.mBadProcesses.getMap().size() > 0) {
            printed2 = false;
            ArrayMap<String, SparseArray<BadProcessInfo>> pmap = this.mBadProcesses.getMap();
            int NP = pmap.size();
            for (int ip = 0; ip < NP; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<BadProcessInfo> uids = pmap.valueAt(ip);
                int N = uids.size();
                for (int i7 = 0; i7 < N; ++i7) {
                    int puid = uids.keyAt(i7);
                    ProcessRecord r = this.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed2) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Bad processes:");
                        printedAnything = true;
                    }
                    BadProcessInfo info = uids.valueAt(i7);
                    pw.print("    Bad process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": crashed at time ");
                    pw.println(info.time);
                    if (info.shortMsg != null) {
                        pw.print("      Short msg: ");
                        pw.println(info.shortMsg);
                    }
                    if (info.longMsg != null) {
                        pw.print("      Long msg: ");
                        pw.println(info.longMsg);
                    }
                    if (info.stack == null) continue;
                    pw.println("      Stack:");
                    int lastPos = 0;
                    for (int pos = 0; pos < info.stack.length(); ++pos) {
                        if (info.stack.charAt(pos) != '\n') continue;
                        pw.print("        ");
                        pw.write(info.stack, lastPos, pos - lastPos);
                        pw.println();
                        lastPos = pos + 1;
                    }
                    if (lastPos >= info.stack.length()) continue;
                    pw.print("        ");
                    pw.write(info.stack, lastPos, info.stack.length() - lastPos);
                    pw.println();
                }
            }
        }
        if (dumpPackage == null) {
            pw.println();
            needSep = false;
            pw.println("  mStartedUsers:");
            for (i3 = 0; i3 < this.mStartedUsers.size(); ++i3) {
                UserState uss = this.mStartedUsers.valueAt(i3);
                pw.print("    User #");
                pw.print(uss.mHandle.getIdentifier());
                pw.print(": ");
                uss.dump("", pw);
            }
            pw.print("  mStartedUserArray: [");
            for (i3 = 0; i3 < this.mStartedUserArray.length; ++i3) {
                if (i3 > 0) {
                    pw.print(", ");
                }
                pw.print(this.mStartedUserArray[i3]);
            }
            pw.println("]");
            pw.print("  mUserLru: [");
            for (i3 = 0; i3 < this.mUserLru.size(); ++i3) {
                if (i3 > 0) {
                    pw.print(", ");
                }
                pw.print(this.mUserLru.get(i3));
            }
            pw.println("]");
            if (dumpAll) {
                pw.print("  mStartedUserArray: ");
                pw.println(Arrays.toString(this.mStartedUserArray));
            }
            SparseIntArray i8 = this.mUserProfileGroupIdsSelfLocked;
            synchronized (i8) {
                if (this.mUserProfileGroupIdsSelfLocked.size() > 0) {
                    pw.println("  mUserProfileGroupIds:");
                    for (int i9 = 0; i9 < this.mUserProfileGroupIdsSelfLocked.size(); ++i9) {
                        pw.print("    User #");
                        pw.print(this.mUserProfileGroupIdsSelfLocked.keyAt(i9));
                        pw.print(" -> profile #");
                        pw.println(this.mUserProfileGroupIdsSelfLocked.valueAt(i9));
                    }
                }
            }
        }
        if (this.mHomeProcess != null && (dumpPackage == null || this.mHomeProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHomeProcess: " + this.mHomeProcess);
        }
        if (this.mPreviousProcess != null && (dumpPackage == null || this.mPreviousProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        }
        if (dumpAll) {
            StringBuilder sb = new StringBuilder(128);
            sb.append("  mPreviousProcessVisibleTime: ");
            TimeUtils.formatDuration(this.mPreviousProcessVisibleTime, sb);
            pw.println(sb);
        }
        if (this.mHeavyWeightProcess != null && (dumpPackage == null || this.mHeavyWeightProcess.pkgList.containsKey(dumpPackage))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        if (dumpPackage == null) {
            pw.println("  mConfiguration: " + this.mConfiguration);
        }
        if (dumpAll) {
            pw.println("  mConfigWillChange: " + this.getFocusedStack().mConfigWillChange);
            if (this.mCompatModePackages.getPackages().size() > 0) {
                boolean printed3 = false;
                for (Map.Entry<String, Integer> entry : this.mCompatModePackages.getPackages().entrySet()) {
                    String pkg = entry.getKey();
                    int mode = entry.getValue();
                    if (dumpPackage != null && !dumpPackage.equals(pkg)) continue;
                    if (!printed3) {
                        pw.println("  mScreenCompatPackages:");
                        printed3 = true;
                    }
                    pw.print("    ");
                    pw.print(pkg);
                    pw.print(": ");
                    pw.print(mode);
                    pw.println();
                }
            }
        }
        if (dumpPackage == null) {
            pw.println("  mWakefulness=" + PowerManagerInternal.wakefulnessToString(this.mWakefulness));
            pw.println("  mSleepTokens=" + this.mSleepTokens);
            pw.println("  mSleeping=" + this.mSleeping + " mLockScreenShown=" + this.lockScreenShownToString());
            pw.println("  mShuttingDown=" + this.mShuttingDown + " mTestPssMode=" + this.mTestPssMode);
            if (this.mRunningVoice != null) {
                pw.println("  mRunningVoice=" + this.mRunningVoice);
                pw.println("  mVoiceWakeLock" + this.mVoiceWakeLock);
            }
        }
        if ((this.mDebugApp != null || this.mOrigDebugApp != null || this.mDebugTransient || this.mOrigWaitForDebugger) && (dumpPackage == null || dumpPackage.equals(this.mDebugApp) || dumpPackage.equals(this.mOrigDebugApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mDebugApp=" + this.mDebugApp + "/orig=" + this.mOrigDebugApp + " mDebugTransient=" + this.mDebugTransient + " mOrigWaitForDebugger=" + this.mOrigWaitForDebugger);
        }
        if (this.mCurAppTimeTracker != null) {
            this.mCurAppTimeTracker.dumpWithHeader(pw, "  ", true);
        }
        if (this.mMemWatchProcesses.getMap().size() > 0) {
            pw.println("  Mem watch processes:");
            ArrayMap<String, SparseArray<Pair<Long, String>>> procs = this.mMemWatchProcesses.getMap();
            for (int i10 = 0; i10 < procs.size(); ++i10) {
                String proc = procs.keyAt(i10);
                SparseArray<Pair<Long, String>> uids = procs.valueAt(i10);
                for (int j = 0; j < uids.size(); ++j) {
                    if (needSep) {
                        pw.println();
                        needSep = false;
                    }
                    StringBuilder sb = new StringBuilder();
                    sb.append("    ").append(proc).append('/');
                    UserHandle.formatUid(sb, uids.keyAt(j));
                    Pair<Long, String> val = uids.valueAt(j);
                    sb.append(": ");
                    DebugUtils.sizeValueToString((Long)val.first, sb);
                    if (val.second != null) {
                        sb.append(", report to ").append((String)val.second);
                    }
                    pw.println(sb.toString());
                }
            }
            pw.print("  mMemWatchDumpProcName=");
            pw.println(this.mMemWatchDumpProcName);
            pw.print("  mMemWatchDumpFile=");
            pw.println(this.mMemWatchDumpFile);
            pw.print("  mMemWatchDumpPid=");
            pw.print(this.mMemWatchDumpPid);
            pw.print(" mMemWatchDumpUid=");
            pw.println(this.mMemWatchDumpUid);
        }
        if (this.mOpenGlTraceApp != null && (dumpPackage == null || dumpPackage.equals(this.mOpenGlTraceApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mOpenGlTraceApp=" + this.mOpenGlTraceApp);
        }
        if (!(this.mProfileApp == null && this.mProfileProc == null && this.mProfileFile == null && this.mProfileFd == null || dumpPackage != null && !dumpPackage.equals(this.mProfileApp))) {
            if (needSep) {
                pw.println();
                needSep = false;
            }
            pw.println("  mProfileApp=" + this.mProfileApp + " mProfileProc=" + this.mProfileProc);
            pw.println("  mProfileFile=" + this.mProfileFile + " mProfileFd=" + this.mProfileFd);
            pw.println("  mSamplingInterval=" + this.mSamplingInterval + " mAutoStopProfiler=" + this.mAutoStopProfiler);
            pw.println("  mProfileType=" + this.mProfileType);
        }
        if (dumpPackage == null) {
            if (this.mAlwaysFinishActivities || this.mController != null) {
                pw.println("  mAlwaysFinishActivities=" + this.mAlwaysFinishActivities + " mController=" + this.mController);
            }
            if (dumpAll) {
                pw.println("  Total persistent processes: " + numPers);
                pw.println("  mProcessesReady=" + this.mProcessesReady + " mSystemReady=" + this.mSystemReady + " mBooted=" + this.mBooted + " mFactoryTest=" + this.mFactoryTest);
                pw.println("  mBooting=" + this.mBooting + " mCallFinishBooting=" + this.mCallFinishBooting + " mBootAnimationComplete=" + this.mBootAnimationComplete);
                pw.print("  mLastPowerCheckRealtime=");
                TimeUtils.formatDuration(this.mLastPowerCheckRealtime, pw);
                pw.println("");
                pw.print("  mLastPowerCheckUptime=");
                TimeUtils.formatDuration(this.mLastPowerCheckUptime, pw);
                pw.println("");
                pw.println("  mGoingToSleep=" + this.mStackSupervisor.mGoingToSleep);
                pw.println("  mLaunchingActivity=" + this.mStackSupervisor.mLaunchingActivity);
                pw.println("  mAdjSeq=" + this.mAdjSeq + " mLruSeq=" + this.mLruSeq);
                pw.println("  mNumNonCachedProcs=" + this.mNumNonCachedProcs + " (" + this.mLruProcesses.size() + " total)" + " mNumCachedHiddenProcs=" + this.mNumCachedHiddenProcs + " mNumServiceProcs=" + this.mNumServiceProcs + " mNewNumServiceProcs=" + this.mNewNumServiceProcs);
                pw.println("  mAllowLowerMemLevel=" + this.mAllowLowerMemLevel + " mLastMemoryLevel" + this.mLastMemoryLevel + " mLastNumProcesses" + this.mLastNumProcesses);
                long now = SystemClock.uptimeMillis();
                pw.print("  mLastIdleTime=");
                TimeUtils.formatDuration(now, this.mLastIdleTime, pw);
                pw.print(" mLowRamSinceLastIdle=");
                TimeUtils.formatDuration(this.getLowRamTimeSinceIdle(now), pw);
                pw.println();
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    boolean dumpProcessesToGc(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean needSep, boolean dumpAll, String dumpPackage) {
        if (this.mProcessesToGc.size() > 0) {
            boolean printed = false;
            long now = SystemClock.uptimeMillis();
            for (int i = 0; i < this.mProcessesToGc.size(); ++i) {
                ProcessRecord proc = this.mProcessesToGc.get(i);
                if (dumpPackage != null && !dumpPackage.equals(proc.info.packageName)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Processes that are waiting to GC:");
                    printed = true;
                }
                pw.print("    Process ");
                pw.println(proc);
                pw.print("      lowMem=");
                pw.print(proc.reportLowMemory);
                pw.print(", last gced=");
                pw.print(now - proc.lastRequestedGc);
                pw.print(" ms ago, last lowMem=");
                pw.print(now - proc.lastLowMemory);
                pw.println(" ms ago");
            }
        }
        return needSep;
    }

    void printOomLevel(PrintWriter pw, String name, int adj) {
        pw.print("    ");
        if (adj >= 0) {
            pw.print(' ');
            if (adj < 10) {
                pw.print(' ');
            }
        } else if (adj > -10) {
            pw.print(' ');
        }
        pw.print(adj);
        pw.print(": ");
        pw.print(name);
        pw.print(" (");
        pw.print(this.mProcessList.getMemLevel(adj) / 1024L);
        pw.println(" kB)");
    }

    boolean dumpOomLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll) {
        boolean needSep = false;
        if (this.mLruProcesses.size() > 0) {
            if (needSep) {
                pw.println();
            }
            needSep = true;
            pw.println("  OOM levels:");
            this.printOomLevel(pw, "SYSTEM_ADJ", -16);
            this.printOomLevel(pw, "PERSISTENT_PROC_ADJ", -12);
            this.printOomLevel(pw, "PERSISTENT_SERVICE_ADJ", -11);
            this.printOomLevel(pw, "FOREGROUND_APP_ADJ", 0);
            this.printOomLevel(pw, "VISIBLE_APP_ADJ", 1);
            this.printOomLevel(pw, "PERCEPTIBLE_APP_ADJ", 2);
            this.printOomLevel(pw, "BACKUP_APP_ADJ", 3);
            this.printOomLevel(pw, "HEAVY_WEIGHT_APP_ADJ", 4);
            this.printOomLevel(pw, "SERVICE_ADJ", 5);
            this.printOomLevel(pw, "HOME_APP_ADJ", 6);
            this.printOomLevel(pw, "PREVIOUS_APP_ADJ", 7);
            this.printOomLevel(pw, "SERVICE_B_ADJ", 8);
            this.printOomLevel(pw, "CACHED_APP_MIN_ADJ", 9);
            this.printOomLevel(pw, "CACHED_APP_MAX_ADJ", 15);
            if (needSep) {
                pw.println();
            }
            pw.print("  Process OOM control (");
            pw.print(this.mLruProcesses.size());
            pw.print(" total, non-act at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessActivityStart);
            pw.print(", non-svc at ");
            pw.print(this.mLruProcesses.size() - this.mLruProcessServiceStart);
            pw.println("):");
            ActivityManagerService.dumpProcessOomList(pw, this, this.mLruProcesses, "    ", "Proc", "PERS", true, null);
            needSep = true;
        }
        this.dumpProcessesToGc(fd, pw, args, opti, needSep, dumpAll, null);
        pw.println();
        pw.println("  mHomeProcess: " + this.mHomeProcess);
        pw.println("  mPreviousProcess: " + this.mPreviousProcess);
        if (this.mHeavyWeightProcess != null) {
            pw.println("  mHeavyWeightProcess: " + this.mHeavyWeightProcess);
        }
        return true;
    }

    protected boolean dumpProvider(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        return this.mProviderMap.dumpProvider(fd, pw, name, args, opti, dumpAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean dumpActivity(FileDescriptor fd, PrintWriter pw, String name, String[] args, int opti, boolean dumpAll) {
        ArrayList<ActivityRecord> activities;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            activities = this.mStackSupervisor.getDumpActivitiesLocked(name);
        }
        if (activities.size() <= 0) {
            return false;
        }
        String[] newArgs = new String[args.length - opti];
        System.arraycopy(args, opti, newArgs, 0, args.length - opti);
        TaskRecord lastTask = null;
        boolean needSep = false;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord r = activities.get(i);
            if (needSep) {
                pw.println();
            }
            needSep = true;
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                if (lastTask != r.task) {
                    lastTask = r.task;
                    pw.print("TASK ");
                    pw.print(lastTask.affinity);
                    pw.print(" id=");
                    pw.println(lastTask.taskId);
                    if (dumpAll) {
                        lastTask.dump(pw, "  ");
                    }
                }
            }
            this.dumpActivity("  ", fd, pw, activities.get(i), newArgs, dumpAll);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpActivity(String prefix, FileDescriptor fd, PrintWriter pw, ActivityRecord r, String[] args, boolean dumpAll) {
        String innerPrefix = prefix + "  ";
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            pw.print(prefix);
            pw.print("ACTIVITY ");
            pw.print(r.shortComponentName);
            pw.print(" ");
            pw.print(Integer.toHexString(System.identityHashCode(r)));
            pw.print(" pid=");
            if (r.app != null) {
                pw.println(r.app.pid);
            } else {
                pw.println("(not running)");
            }
            if (dumpAll) {
                r.dump(pw, innerPrefix);
            }
        }
        if (r.app != null && r.app.thread != null) {
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), r.appToken, innerPrefix, args);
                    tp.go(fd);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
        }
    }

    void dumpBroadcastsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean onlyHistory = false;
        boolean printedAnything = false;
        if ("history".equals(dumpPackage)) {
            if (opti < args.length && "-s".equals(args[opti])) {
                dumpAll = false;
            }
            onlyHistory = true;
            dumpPackage = null;
        }
        pw.println("ACTIVITY MANAGER BROADCAST STATE (dumpsys activity broadcasts)");
        if (!onlyHistory && dumpAll) {
            if (this.mRegisteredReceivers.size() > 0) {
                boolean printed = false;
                for (ReceiverList r : this.mRegisteredReceivers.values()) {
                    if (dumpPackage != null && (r.app == null || !dumpPackage.equals(r.app.info.packageName))) continue;
                    if (!printed) {
                        pw.println("  Registered Receivers:");
                        needSep = true;
                        printed = true;
                        printedAnything = true;
                    }
                    pw.print("  * ");
                    pw.println(r);
                    r.dump(pw, "    ");
                }
            }
            if (this.mReceiverResolver.dump(pw, needSep ? "\n  Receiver Resolver Table:" : "  Receiver Resolver Table:", "    ", dumpPackage, false, false)) {
                needSep = true;
                printedAnything = true;
            }
        }
        for (BroadcastQueue q : this.mBroadcastQueues) {
            needSep = q.dumpLocked(fd, pw, args, opti, dumpAll, dumpPackage, needSep);
            printedAnything |= needSep;
        }
        needSep = true;
        if (!onlyHistory && this.mStickyBroadcasts != null && dumpPackage == null) {
            for (int user = 0; user < this.mStickyBroadcasts.size(); ++user) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                printedAnything = true;
                pw.print("  Sticky broadcasts for user ");
                pw.print(this.mStickyBroadcasts.keyAt(user));
                pw.println(":");
                StringBuilder sb = new StringBuilder(128);
                for (Map.Entry<String, ArrayList<Intent>> ent : this.mStickyBroadcasts.valueAt(user).entrySet()) {
                    pw.print("  * Sticky action ");
                    pw.print(ent.getKey());
                    if (dumpAll) {
                        pw.println(":");
                        ArrayList<Intent> intents = ent.getValue();
                        int N = intents.size();
                        for (int i = 0; i < N; ++i) {
                            sb.setLength(0);
                            sb.append("    Intent: ");
                            intents.get(i).toShortString(sb, false, true, false, false);
                            pw.println(sb.toString());
                            Bundle bundle = intents.get(i).getExtras();
                            if (bundle == null) continue;
                            pw.print("      ");
                            pw.println(bundle.toString());
                        }
                        continue;
                    }
                    pw.println("");
                }
            }
        }
        if (!onlyHistory && dumpAll) {
            pw.println();
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                pw.println("  mBroadcastsScheduled [" + queue.mQueueName + "]=" + queue.mBroadcastsScheduled);
            }
            pw.println("  mHandler:");
            this.mHandler.dump(new PrintWriterPrinter(pw), "    ");
            needSep = true;
            printedAnything = true;
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpProvidersLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printedAnything = false;
        ItemMatcher matcher = new ItemMatcher();
        matcher.build(args, opti);
        pw.println("ACTIVITY MANAGER CONTENT PROVIDERS (dumpsys activity providers)");
        boolean needSep = this.mProviderMap.dumpProvidersLocked(pw, dumpAll, dumpPackage);
        printedAnything |= needSep;
        if (this.mLaunchingProviders.size() > 0) {
            boolean printed = false;
            for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
                ContentProviderRecord r = this.mLaunchingProviders.get(i);
                if (dumpPackage != null && !dumpPackage.equals(r.name.getPackageName())) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Launching content providers:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  Launching #");
                pw.print(i);
                pw.print(": ");
                pw.println(r);
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpPermissionsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean needSep = false;
        boolean printedAnything = false;
        pw.println("ACTIVITY MANAGER URI PERMISSIONS (dumpsys activity permissions)");
        if (this.mGrantedUriPermissions.size() > 0) {
            boolean printed = false;
            int dumpUid = -2;
            if (dumpPackage != null) {
                try {
                    dumpUid = this.mContext.getPackageManager().getPackageUid(dumpPackage, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    dumpUid = -1;
                }
            }
            for (int i = 0; i < this.mGrantedUriPermissions.size(); ++i) {
                int uid = this.mGrantedUriPermissions.keyAt(i);
                if (dumpUid >= -1 && UserHandle.getAppId(uid) != dumpUid) continue;
                ArrayMap<GrantUri, UriPermission> perms = this.mGrantedUriPermissions.valueAt(i);
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Granted Uri Permissions:");
                    printed = true;
                    printedAnything = true;
                }
                pw.print("  * UID ");
                pw.print(uid);
                pw.println(" holds:");
                for (UriPermission perm : perms.values()) {
                    pw.print("    ");
                    pw.println(perm);
                    if (!dumpAll) continue;
                    perm.dump(pw, "      ");
                }
            }
        }
        if (!printedAnything) {
            pw.println("  (nothing)");
        }
    }

    void dumpPendingIntentsLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage) {
        boolean printed = false;
        pw.println("ACTIVITY MANAGER PENDING INTENTS (dumpsys activity intents)");
        if (this.mIntentSenderRecords.size() > 0) {
            for (WeakReference<PendingIntentRecord> ref : this.mIntentSenderRecords.values()) {
                PendingIntentRecord rec;
                PendingIntentRecord pendingIntentRecord = rec = ref != null ? (PendingIntentRecord)ref.get() : null;
                if (dumpPackage != null && (rec == null || !dumpPackage.equals(rec.key.packageName))) continue;
                printed = true;
                if (rec != null) {
                    pw.print("  * ");
                    pw.println(rec);
                    if (!dumpAll) continue;
                    rec.dump(pw, "    ");
                    continue;
                }
                pw.print("  * ");
                pw.println(ref);
            }
        }
        if (!printed) {
            pw.println("  (nothing)");
        }
    }

    private static final int dumpProcessList(PrintWriter pw, ActivityManagerService service, List list, String prefix, String normalLabel, String persistentLabel, String dumpPackage) {
        int N;
        int numPers = 0;
        for (int i = N = list.size() - 1; i >= 0; --i) {
            ProcessRecord r = (ProcessRecord)list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.info.packageName)) continue;
            pw.println(String.format("%s%s #%2d: %s", prefix, r.persistent ? persistentLabel : normalLabel, i, r.toString()));
            if (!r.persistent) continue;
            ++numPers;
        }
        return numPers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean dumpProcessOomList(PrintWriter pw, ActivityManagerService service, List<ProcessRecord> origList, String prefix, String normalLabel, String persistentLabel, boolean inclDetails, String dumpPackage) {
        ArrayList<Pair<ProcessRecord, Integer>> list = new ArrayList<Pair<ProcessRecord, Integer>>(origList.size());
        for (int i = 0; i < origList.size(); ++i) {
            ProcessRecord r = origList.get(i);
            if (dumpPackage != null && !r.pkgList.containsKey(dumpPackage)) continue;
            list.add(new Pair<ProcessRecord, Integer>(origList.get(i), i));
        }
        if (list.size() <= 0) {
            return false;
        }
        Comparator<Pair<ProcessRecord, Integer>> comparator = new Comparator<Pair<ProcessRecord, Integer>>(){

            @Override
            public int compare(Pair<ProcessRecord, Integer> object1, Pair<ProcessRecord, Integer> object2) {
                if (((ProcessRecord)object1.first).setAdj != ((ProcessRecord)object2.first).setAdj) {
                    return ((ProcessRecord)object1.first).setAdj > ((ProcessRecord)object2.first).setAdj ? -1 : 1;
                }
                if (((Integer)object1.second).intValue() != ((Integer)object2.second).intValue()) {
                    return (Integer)object1.second > (Integer)object2.second ? -1 : 1;
                }
                return 0;
            }
        };
        Collections.sort(list, comparator);
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - service.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - service.mLastPowerCheckUptime;
        for (int i = list.size() - 1; i >= 0; --i) {
            char schedGroup;
            ProcessRecord r = (ProcessRecord)((Pair)list.get((int)i)).first;
            String oomAdj = ProcessList.makeOomAdjString(r.setAdj);
            switch (r.setSchedGroup) {
                case 0: {
                    schedGroup = 'B';
                    break;
                }
                case -1: {
                    schedGroup = 'F';
                    break;
                }
                default: {
                    schedGroup = '?';
                }
            }
            char foreground = r.foregroundActivities ? (char)'A' : (r.foregroundServices ? (char)'S' : ' ');
            String procState = ProcessList.makeProcStateString(r.curProcState);
            pw.print(prefix);
            pw.print(r.persistent ? persistentLabel : normalLabel);
            pw.print(" #");
            int num = origList.size() - 1 - (Integer)((Pair)list.get((int)i)).second;
            if (num < 10) {
                pw.print(' ');
            }
            pw.print(num);
            pw.print(": ");
            pw.print(oomAdj);
            pw.print(' ');
            pw.print(schedGroup);
            pw.print('/');
            pw.print(foreground);
            pw.print('/');
            pw.print(procState);
            pw.print(" trm:");
            if (r.trimMemoryLevel < 10) {
                pw.print(' ');
            }
            pw.print(r.trimMemoryLevel);
            pw.print(' ');
            pw.print(r.toShortString());
            pw.print(" (");
            pw.print(r.adjType);
            pw.println(')');
            if (r.adjSource != null || r.adjTarget != null) {
                pw.print(prefix);
                pw.print("    ");
                if (r.adjTarget instanceof ComponentName) {
                    pw.print(((ComponentName)r.adjTarget).flattenToShortString());
                } else if (r.adjTarget != null) {
                    pw.print(r.adjTarget.toString());
                } else {
                    pw.print("{null}");
                }
                pw.print("<=");
                if (r.adjSource instanceof ProcessRecord) {
                    pw.print("Proc{");
                    pw.print(((ProcessRecord)r.adjSource).toShortString());
                    pw.println("}");
                } else if (r.adjSource != null) {
                    pw.println(r.adjSource.toString());
                } else {
                    pw.println("{null}");
                }
            }
            if (!inclDetails) continue;
            pw.print(prefix);
            pw.print("    ");
            pw.print("oom: max=");
            pw.print(r.maxAdj);
            pw.print(" curRaw=");
            pw.print(r.curRawAdj);
            pw.print(" setRaw=");
            pw.print(r.setRawAdj);
            pw.print(" cur=");
            pw.print(r.curAdj);
            pw.print(" set=");
            pw.println(r.setAdj);
            pw.print(prefix);
            pw.print("    ");
            pw.print("state: cur=");
            pw.print(ProcessList.makeProcStateString(r.curProcState));
            pw.print(" set=");
            pw.print(ProcessList.makeProcStateString(r.setProcState));
            pw.print(" lastPss=");
            DebugUtils.printSizeValue(pw, r.lastPss * 1024L);
            pw.print(" lastCachedPss=");
            DebugUtils.printSizeValue(pw, r.lastCachedPss * 1024L);
            pw.println();
            pw.print(prefix);
            pw.print("    ");
            pw.print("cached=");
            pw.print(r.cached);
            pw.print(" empty=");
            pw.print(r.empty);
            pw.print(" hasAboveClient=");
            pw.println(r.hasAboveClient);
            if (r.setProcState < 10) continue;
            if (r.lastWakeTime != 0L) {
                long wtime;
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = service.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    wtime = stats.getProcessWakeTime(r.info.uid, r.pid, curRealtime);
                }
                long timeUsed = wtime - r.lastWakeTime;
                pw.print(prefix);
                pw.print("    ");
                pw.print("keep awake over ");
                TimeUtils.formatDuration(realtimeSince, pw);
                pw.print(" used ");
                TimeUtils.formatDuration(timeUsed, pw);
                pw.print(" (");
                pw.print(timeUsed * 100L / realtimeSince);
                pw.println("%)");
            }
            if (r.lastCpuTime == 0L) continue;
            long timeUsed = r.curCpuTime - r.lastCpuTime;
            pw.print(prefix);
            pw.print("    ");
            pw.print("run cpu over ");
            TimeUtils.formatDuration(uptimeSince, pw);
            pw.print(" used ");
            TimeUtils.formatDuration(timeUsed, pw);
            pw.print(" (");
            pw.print(timeUsed * 100L / uptimeSince);
            pw.println("%)");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<ProcessRecord> collectProcesses(PrintWriter pw, int start, boolean allPkgs, String[] args) {
        ArrayList<ProcessRecord> procs;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (args != null && args.length > start && args[start].charAt(0) != '-') {
                procs = new ArrayList();
                int pid = -1;
                try {
                    pid = Integer.parseInt(args[start]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                    ProcessRecord proc = this.mLruProcesses.get(i);
                    if (proc.pid == pid) {
                        procs.add(proc);
                        continue;
                    }
                    if (allPkgs && proc.pkgList != null && proc.pkgList.containsKey(args[start])) {
                        procs.add(proc);
                        continue;
                    }
                    if (!proc.processName.equals(args[start])) continue;
                    procs.add(proc);
                }
                if (procs.size() <= 0) {
                    return null;
                }
            } else {
                procs = new ArrayList<ProcessRecord>(this.mLruProcesses);
            }
        }
        return procs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpGraphicsHardwareUsage(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        pw.println("Applications Graphics Acceleration Info:");
        pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Graphics info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpGfxInfo(tp.getWriteFd().getFileDescriptor(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpDbInfo(FileDescriptor fd, PrintWriter pw, String[] args) {
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, 0, false, args);
        if (procs == null) {
            pw.println("No process found for: " + args[0]);
            return;
        }
        pw.println("Applications Database Info:");
        for (int i = procs.size() - 1; i >= 0; --i) {
            ProcessRecord r = procs.get(i);
            if (r.thread == null) continue;
            pw.println("\n** Database info for pid " + r.pid + " [" + r.processName + "] **");
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.thread.dumpDbInfo(tp.getWriteFd().getFileDescriptor(), args);
                    tp.go(fd);
                    continue;
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println("Failure while dumping the app: " + r);
                pw.flush();
                continue;
            }
            catch (RemoteException e) {
                pw.println("Got a RemoteException while dumping the app " + r);
                pw.flush();
            }
        }
    }

    static final void dumpMemItems(PrintWriter pw, String prefix, String tag, ArrayList<MemItem> items, boolean sort, boolean isCompact) {
        if (sort && !isCompact) {
            Collections.sort(items, new Comparator<MemItem>(){

                @Override
                public int compare(MemItem lhs, MemItem rhs) {
                    if (lhs.pss < rhs.pss) {
                        return 1;
                    }
                    if (lhs.pss > rhs.pss) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        for (int i = 0; i < items.size(); ++i) {
            MemItem mi = items.get(i);
            if (!isCompact) {
                pw.print(prefix);
                pw.printf("%7d kB: ", mi.pss);
                pw.println(mi.label);
            } else if (mi.isProc) {
                pw.print("proc,");
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.print(mi.id);
                pw.print(",");
                pw.print(mi.pss);
                pw.println(mi.hasActivities ? ",a" : ",e");
            } else {
                pw.print(tag);
                pw.print(",");
                pw.print(mi.shortLabel);
                pw.print(",");
                pw.println(mi.pss);
            }
            if (mi.subitems == null) continue;
            ActivityManagerService.dumpMemItems(pw, prefix + "           ", mi.shortLabel, mi.subitems, true, isCompact);
        }
    }

    static final void appendMemBucket(StringBuilder out, long memKB, String label, boolean stackLike) {
        int start = label.lastIndexOf(46);
        start = start >= 0 ? ++start : 0;
        int end = label.length();
        for (int i = 0; i < DUMP_MEM_BUCKETS.length; ++i) {
            if (DUMP_MEM_BUCKETS[i] < memKB) continue;
            long bucket = DUMP_MEM_BUCKETS[i] / 1024L;
            out.append(bucket);
            out.append(stackLike ? "MB." : "MB ");
            out.append(label, start, end);
            return;
        }
        out.append(memKB / 1024L);
        out.append(stackLike ? "MB." : "MB ");
        out.append(label, start, end);
    }

    private final void dumpApplicationMemoryUsageHeader(PrintWriter pw, long uptime, long realtime, boolean isCheckinRequest, boolean isCompact) {
        if (isCheckinRequest || isCompact) {
            pw.print("time,");
            pw.print(uptime);
            pw.print(",");
            pw.println(realtime);
        } else {
            pw.println("Applications Memory Usage (kB):");
            pw.println("Uptime: " + uptime + " Realtime: " + realtime);
        }
    }

    private final long[] getKsmInfo() {
        long[] longOut = new long[4];
        int[] SINGLE_LONG_FORMAT = new int[]{8224};
        long[] longTmp = new long[1];
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_shared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[0] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_sharing", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[1] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_unshared", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[2] = longTmp[0] * 4096L / 1024L;
        longTmp[0] = 0L;
        android.os.Process.readProcFile("/sys/kernel/mm/ksm/pages_volatile", SINGLE_LONG_FORMAT, null, longTmp, null);
        longOut[3] = longTmp[0] * 4096L / 1024L;
        return longOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dumpApplicationMemoryUsage(FileDescriptor fd, PrintWriter pw, String prefix, String[] args, boolean brief, PrintWriter categoryPw) {
        Object thread;
        String opt;
        int opti;
        boolean dumpDetails = false;
        boolean dumpFullDetails = false;
        boolean dumpDalvik = false;
        boolean dumpSummaryOnly = false;
        boolean oomOnly = false;
        boolean isCompact = false;
        boolean localOnly = false;
        boolean packages = false;
        for (opti = 0; opti < args.length && (opt = args[opti]) != null && opt.length() > 0 && opt.charAt(0) == '-'; ++opti) {
            if ("-a".equals(opt)) {
                dumpDetails = true;
                dumpFullDetails = true;
                dumpDalvik = true;
                continue;
            }
            if ("-d".equals(opt)) {
                dumpDalvik = true;
                continue;
            }
            if ("-c".equals(opt)) {
                isCompact = true;
                continue;
            }
            if ("-s".equals(opt)) {
                dumpDetails = true;
                dumpSummaryOnly = true;
                continue;
            }
            if ("--oom".equals(opt)) {
                oomOnly = true;
                continue;
            }
            if ("--local".equals(opt)) {
                localOnly = true;
                continue;
            }
            if ("--package".equals(opt)) {
                packages = true;
                continue;
            }
            if ("-h".equals(opt)) {
                pw.println("meminfo dump options: [-a] [-d] [-c] [-s] [--oom] [process]");
                pw.println("  -a: include all available information for each process.");
                pw.println("  -d: include dalvik details.");
                pw.println("  -c: dump in a compact machine-parseable representation.");
                pw.println("  -s: dump only summary of application memory usage.");
                pw.println("  --oom: only show processes organized by oom adj.");
                pw.println("  --local: only collect details locally, don't call process.");
                pw.println("  --package: interpret process arg as package, dumping all");
                pw.println("             processes that have loaded that package.");
                pw.println("If [process] is specified it can be the name or ");
                pw.println("pid of a specific process to dump.");
                return;
            }
            pw.println("Unknown argument: " + opt + "; use -h for help");
        }
        boolean isCheckinRequest = ActivityManagerService.scanArgs(args, "--checkin");
        long uptime = SystemClock.uptimeMillis();
        long realtime = SystemClock.elapsedRealtime();
        long[] tmpLong = new long[1];
        ArrayList<ProcessRecord> procs = this.collectProcesses(pw, opti, packages, args);
        if (procs == null) {
            if (args != null && args.length > opti && args[opti].charAt(0) != '-') {
                ArrayList<ProcessCpuTracker.Stats> nativeProcs = new ArrayList<ProcessCpuTracker.Stats>();
                this.updateCpuStatsNow();
                int findPid = -1;
                try {
                    findPid = Integer.parseInt(args[opti]);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ProcessCpuTracker e = this.mProcessCpuTracker;
                synchronized (e) {
                    int N = this.mProcessCpuTracker.countStats();
                    for (int i = 0; i < N; ++i) {
                        ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                        if (st.pid != findPid && (st.baseName == null || !st.baseName.equals(args[opti]))) continue;
                        nativeProcs.add(st);
                    }
                }
                if (nativeProcs.size() > 0) {
                    this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
                    Debug.MemoryInfo mi = null;
                    for (int i = nativeProcs.size() - 1; i >= 0; --i) {
                        ProcessCpuTracker.Stats r = (ProcessCpuTracker.Stats)nativeProcs.get(i);
                        int pid = r.pid;
                        if (!isCheckinRequest && dumpDetails) {
                            pw.println("\n** MEMINFO in pid " + pid + " [" + r.baseName + "] **");
                        }
                        if (mi == null) {
                            mi = new Debug.MemoryInfo();
                        }
                        if (dumpDetails || !brief && !oomOnly) {
                            Debug.getMemoryInfo(pid, mi);
                        } else {
                            mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                            mi.dalvikPrivateDirty = (int)tmpLong[0];
                        }
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, pid, r.baseName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (!isCheckinRequest) continue;
                        pw.println();
                    }
                    return;
                }
            }
            pw.println("No process found for: " + args[opti]);
            return;
        }
        if (!brief && !oomOnly && (procs.size() == 1 || isCheckinRequest || packages)) {
            dumpDetails = true;
        }
        this.dumpApplicationMemoryUsageHeader(pw, uptime, realtime, isCheckinRequest, isCompact);
        String[] innerArgs = new String[args.length - opti];
        System.arraycopy(args, opti, innerArgs, 0, args.length - opti);
        ArrayList<MemItem> procMems = new ArrayList<MemItem>();
        SparseArray<MemItem> procMemsMap = new SparseArray<MemItem>();
        long nativePss = 0L;
        long dalvikPss = 0L;
        long[] dalvikSubitemPss = dumpDalvik ? new long[8] : EmptyArray.LONG;
        long otherPss = 0L;
        long[] miscPss = new long[17];
        long[] oomPss = new long[DUMP_MEM_OOM_LABEL.length];
        ArrayList[] oomProcs = new ArrayList[DUMP_MEM_OOM_LABEL.length];
        long totalPss = 0L;
        long cachedPss = 0L;
        Debug.MemoryInfo mi = null;
        block28: for (int i = procs.size() - 1; i >= 0; --i) {
            int j;
            boolean hasActivities;
            int oomAdj;
            int pid;
            ProcessRecord r;
            block92: {
                r = procs.get(i);
                ActivityManagerService activityManagerService = this;
                synchronized (activityManagerService) {
                    thread = r.thread;
                    pid = r.pid;
                    oomAdj = r.getSetAdjWithServices();
                    hasActivities = r.activities.size() > 0;
                }
                if (thread == null) continue;
                if (!isCheckinRequest && dumpDetails) {
                    pw.println("\n** MEMINFO in pid " + pid + " [" + r.processName + "] **");
                }
                if (mi == null) {
                    mi = new Debug.MemoryInfo();
                }
                if (dumpDetails || !brief && !oomOnly) {
                    Debug.getMemoryInfo(pid, mi);
                } else {
                    mi.dalvikPss = (int)Debug.getPss(pid, tmpLong, null);
                    mi.dalvikPrivateDirty = (int)tmpLong[0];
                }
                if (dumpDetails) {
                    if (localOnly) {
                        ActivityThread.dumpMemInfoTable(pw, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, pid, r.processName, 0L, 0L, 0L, 0L, 0L, 0L);
                        if (isCheckinRequest) {
                            pw.println();
                        }
                    } else {
                        try {
                            pw.flush();
                            thread.dumpMemInfo(fd, mi, isCheckinRequest, dumpFullDetails, dumpDalvik, dumpSummaryOnly, innerArgs);
                        }
                        catch (RemoteException e) {
                            if (isCheckinRequest) break block92;
                            pw.println("Got RemoteException!");
                            pw.flush();
                        }
                    }
                }
            }
            long myTotalPss = mi.getTotalPss();
            long myTotalUss = mi.getTotalUss();
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                if (r.thread != null && oomAdj == r.getSetAdjWithServices()) {
                    r.baseProcessTracker.addPss(myTotalPss, myTotalUss, true, r.pkgList);
                }
            }
            if (isCheckinRequest || mi == null) continue;
            totalPss += myTotalPss;
            MemItem pssItem = new MemItem(r.processName + " (pid " + pid + (hasActivities ? " / activities)" : ")"), r.processName, myTotalPss, pid, hasActivities);
            procMems.add(pssItem);
            procMemsMap.put(pid, pssItem);
            nativePss += (long)mi.nativePss;
            dalvikPss += (long)mi.dalvikPss;
            for (j = 0; j < dalvikSubitemPss.length; ++j) {
                int n = j;
                dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j);
            }
            otherPss += (long)mi.otherPss;
            j = 0;
            while (j < 17) {
                long mem = mi.getOtherPss(j);
                int n = j++;
                miscPss[n] = miscPss[n] + mem;
                otherPss -= mem;
            }
            if (oomAdj >= 9) {
                cachedPss += myTotalPss;
            }
            for (int oomIndex = 0; oomIndex < oomPss.length; ++oomIndex) {
                if (oomAdj > DUMP_MEM_OOM_ADJ[oomIndex] && oomIndex != oomPss.length - 1) continue;
                int n = oomIndex;
                oomPss[n] = oomPss[n] + myTotalPss;
                if (oomProcs[oomIndex] == null) {
                    oomProcs[oomIndex] = new ArrayList();
                }
                oomProcs[oomIndex].add(pssItem);
                continue block28;
            }
        }
        long nativeProcTotalPss = 0L;
        if (!isCheckinRequest && procs.size() > 1 && !packages) {
            int j;
            this.updateCpuStatsNow();
            mi = null;
            thread = this.mProcessCpuTracker;
            synchronized (thread) {
                int N = this.mProcessCpuTracker.countStats();
                for (int i = 0; i < N; ++i) {
                    int j2;
                    ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                    if (st.vsize <= 0L || procMemsMap.indexOfKey(st.pid) >= 0) continue;
                    if (mi == null) {
                        mi = new Debug.MemoryInfo();
                    }
                    if (!brief && !oomOnly) {
                        Debug.getMemoryInfo(st.pid, mi);
                    } else {
                        mi.nativePss = (int)Debug.getPss(st.pid, tmpLong, null);
                        mi.nativePrivateDirty = (int)tmpLong[0];
                    }
                    long myTotalPss = mi.getTotalPss();
                    totalPss += myTotalPss;
                    nativeProcTotalPss += myTotalPss;
                    MemItem pssItem = new MemItem(st.name + " (pid " + st.pid + ")", st.name, myTotalPss, st.pid, false);
                    procMems.add(pssItem);
                    nativePss += (long)mi.nativePss;
                    dalvikPss += (long)mi.dalvikPss;
                    for (j2 = 0; j2 < dalvikSubitemPss.length; ++j2) {
                        int n = j2;
                        dalvikSubitemPss[n] = dalvikSubitemPss[n] + (long)mi.getOtherPss(17 + j2);
                    }
                    otherPss += (long)mi.otherPss;
                    j2 = 0;
                    while (j2 < 17) {
                        long mem = mi.getOtherPss(j2);
                        int n = j2++;
                        miscPss[n] = miscPss[n] + mem;
                        otherPss -= mem;
                    }
                    oomPss[0] = oomPss[0] + myTotalPss;
                    if (oomProcs[0] == null) {
                        oomProcs[0] = new ArrayList();
                    }
                    oomProcs[0].add(pssItem);
                }
            }
            ArrayList<MemItem> catMems = new ArrayList<MemItem>();
            catMems.add(new MemItem("Native", "Native", nativePss, -1));
            MemItem dalvikItem = new MemItem("Dalvik", "Dalvik", dalvikPss, -2);
            if (dalvikSubitemPss.length > 0) {
                dalvikItem.subitems = new ArrayList();
                for (j = 0; j < dalvikSubitemPss.length; ++j) {
                    String name = Debug.MemoryInfo.getOtherLabel(17 + j);
                    dalvikItem.subitems.add(new MemItem(name, name, dalvikSubitemPss[j], j));
                }
            }
            catMems.add(dalvikItem);
            catMems.add(new MemItem("Unknown", "Unknown", otherPss, -3));
            for (j = 0; j < 17; ++j) {
                String label = Debug.MemoryInfo.getOtherLabel(j);
                catMems.add(new MemItem(label, label, miscPss[j], j));
            }
            ArrayList<MemItem> oomMems = new ArrayList<MemItem>();
            for (int j3 = 0; j3 < oomPss.length; ++j3) {
                if (oomPss[j3] == 0L) continue;
                String label = isCompact ? DUMP_MEM_OOM_COMPACT_LABEL[j3] : DUMP_MEM_OOM_LABEL[j3];
                MemItem item = new MemItem(label, label, oomPss[j3], DUMP_MEM_OOM_ADJ[j3]);
                item.subitems = oomProcs[j3];
                oomMems.add(item);
            }
            if (!(brief || oomOnly || isCompact)) {
                pw.println();
                pw.println("Total PSS by process:");
                ActivityManagerService.dumpMemItems(pw, "  ", "proc", procMems, true, isCompact);
                pw.println();
            }
            if (!isCompact) {
                pw.println("Total PSS by OOM adjustment:");
            }
            ActivityManagerService.dumpMemItems(pw, "  ", "oom", oomMems, false, isCompact);
            if (!brief && !oomOnly) {
                PrintWriter out;
                PrintWriter printWriter = out = categoryPw != null ? categoryPw : pw;
                if (!isCompact) {
                    out.println();
                    out.println("Total PSS by category:");
                }
                ActivityManagerService.dumpMemItems(out, "  ", "cat", catMems, true, isCompact);
            }
            if (!isCompact) {
                pw.println();
            }
            MemInfoReader memInfo = new MemInfoReader();
            memInfo.readMemInfo();
            if (nativeProcTotalPss > 0L) {
                ActivityManagerService label = this;
                synchronized (label) {
                    long cachedKb = memInfo.getCachedSizeKb();
                    long freeKb = memInfo.getFreeSizeKb();
                    long zramKb = memInfo.getZramTotalSizeKb();
                    long kernelKb = memInfo.getKernelUsedSizeKb();
                    EventLogTags.writeAmMeminfo(cachedKb * 1024L, freeKb * 1024L, zramKb * 1024L, kernelKb * 1024L, nativeProcTotalPss * 1024L);
                    this.mProcessStats.addSysMemUsageLocked(cachedKb, freeKb, zramKb, kernelKb, nativeProcTotalPss);
                }
            }
            if (!brief) {
                if (!isCompact) {
                    pw.print("Total RAM: ");
                    pw.print(memInfo.getTotalSizeKb());
                    pw.print(" kB (status ");
                    switch (this.mLastMemoryLevel) {
                        case 0: {
                            pw.println("normal)");
                            break;
                        }
                        case 1: {
                            pw.println("moderate)");
                            break;
                        }
                        case 2: {
                            pw.println("low)");
                            break;
                        }
                        case 3: {
                            pw.println("critical)");
                            break;
                        }
                        default: {
                            pw.print(this.mLastMemoryLevel);
                            pw.println(")");
                        }
                    }
                    pw.print(" Free RAM: ");
                    pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                    pw.print(" kB (");
                    pw.print(cachedPss);
                    pw.print(" cached pss + ");
                    pw.print(memInfo.getCachedSizeKb());
                    pw.print(" cached kernel + ");
                    pw.print(memInfo.getFreeSizeKb());
                    pw.println(" free)");
                } else {
                    pw.print("ram,");
                    pw.print(memInfo.getTotalSizeKb());
                    pw.print(",");
                    pw.print(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
                    pw.print(",");
                    pw.println(totalPss - cachedPss);
                }
            }
            if (!isCompact) {
                pw.print(" Used RAM: ");
                pw.print(totalPss - cachedPss + memInfo.getKernelUsedSizeKb());
                pw.print(" kB (");
                pw.print(totalPss - cachedPss);
                pw.print(" used pss + ");
                pw.print(memInfo.getKernelUsedSizeKb());
                pw.print(" kernel)\n");
                pw.print(" Lost RAM: ");
                pw.print(memInfo.getTotalSizeKb() - totalPss - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb());
                pw.println(" kB");
            }
            if (!brief) {
                if (memInfo.getZramTotalSizeKb() != 0L) {
                    if (!isCompact) {
                        pw.print("     ZRAM: ");
                        pw.print(memInfo.getZramTotalSizeKb());
                        pw.print(" kB physical used for ");
                        pw.print(memInfo.getSwapTotalSizeKb() - memInfo.getSwapFreeSizeKb());
                        pw.print(" kB in swap (");
                        pw.print(memInfo.getSwapTotalSizeKb());
                        pw.println(" kB total swap)");
                    } else {
                        pw.print("zram,");
                        pw.print(memInfo.getZramTotalSizeKb());
                        pw.print(",");
                        pw.print(memInfo.getSwapTotalSizeKb());
                        pw.print(",");
                        pw.println(memInfo.getSwapFreeSizeKb());
                    }
                }
                long[] ksm = this.getKsmInfo();
                if (!isCompact) {
                    if (ksm[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
                        pw.print("      KSM: ");
                        pw.print(ksm[1]);
                        pw.print(" kB saved from shared ");
                        pw.print(ksm[0]);
                        pw.println(" kB");
                        pw.print("           ");
                        pw.print(ksm[2]);
                        pw.print(" kB unshared; ");
                        pw.print(ksm[3]);
                        pw.println(" kB volatile");
                    }
                    pw.print("   Tuning: ");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(" (large ");
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print("), oom ");
                    pw.print(this.mProcessList.getMemLevel(15) / 1024L);
                    pw.print(" kB");
                    pw.print(", restore limit ");
                    pw.print(this.mProcessList.getCachedRestoreThresholdKb());
                    pw.print(" kB");
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(" (low-ram)");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(" (high-end-gfx)");
                    }
                    pw.println();
                } else {
                    pw.print("ksm,");
                    pw.print(ksm[1]);
                    pw.print(",");
                    pw.print(ksm[0]);
                    pw.print(",");
                    pw.print(ksm[2]);
                    pw.print(",");
                    pw.println(ksm[3]);
                    pw.print("tuning,");
                    pw.print(ActivityManager.staticGetMemoryClass());
                    pw.print(',');
                    pw.print(ActivityManager.staticGetLargeMemoryClass());
                    pw.print(',');
                    pw.print(this.mProcessList.getMemLevel(15) / 1024L);
                    if (ActivityManager.isLowRamDeviceStatic()) {
                        pw.print(",low-ram");
                    }
                    if (ActivityManager.isHighEndGfx()) {
                        pw.print(",high-end-gfx");
                    }
                    pw.println();
                }
            }
        }
    }

    private void appendBasicMemEntry(StringBuilder sb, int oomAdj, int procState, long pss, long memtrack, String name) {
        sb.append("  ");
        sb.append(ProcessList.makeOomAdjString(oomAdj));
        sb.append(' ');
        sb.append(ProcessList.makeProcStateString(procState));
        sb.append(' ');
        ProcessList.appendRamKb(sb, pss);
        sb.append(" kB: ");
        sb.append(name);
        if (memtrack > 0L) {
            sb.append(" (");
            sb.append(memtrack);
            sb.append(" kB memtrack)");
        }
    }

    private void appendMemInfo(StringBuilder sb, ProcessMemInfo mi) {
        this.appendBasicMemEntry(sb, mi.oomAdj, mi.procState, mi.pss, mi.memtrack, mi.name);
        sb.append(" (pid ");
        sb.append(mi.pid);
        sb.append(") ");
        sb.append(mi.adjType);
        sb.append('\n');
        if (mi.adjReason != null) {
            sb.append("                      ");
            sb.append(mi.adjReason);
            sb.append('\n');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reportMemUsage(ArrayList<ProcessMemInfo> memInfos) {
        long[] ksm;
        ProcessMemInfo mi;
        SparseArray<ProcessMemInfo> infoMap = new SparseArray<ProcessMemInfo>(memInfos.size());
        int N22 = memInfos.size();
        for (int i = 0; i < N22; ++i) {
            ProcessMemInfo mi2 = memInfos.get(i);
            infoMap.put(mi2.pid, mi2);
        }
        this.updateCpuStatsNow();
        long[] memtrackTmp = new long[1];
        ProcessCpuTracker N22 = this.mProcessCpuTracker;
        synchronized (N22) {
            int N = this.mProcessCpuTracker.countStats();
            for (int i = 0; i < N; ++i) {
                long pss;
                ProcessCpuTracker.Stats st = this.mProcessCpuTracker.getStats(i);
                if (st.vsize <= 0L || (pss = Debug.getPss(st.pid, null, memtrackTmp)) <= 0L || infoMap.indexOfKey(st.pid) >= 0) continue;
                mi = new ProcessMemInfo(st.name, st.pid, -17, -1, "native", null);
                mi.pss = pss;
                mi.memtrack = memtrackTmp[0];
                memInfos.add(mi);
            }
        }
        long totalPss = 0L;
        long totalMemtrack = 0L;
        int N = memInfos.size();
        for (int i = 0; i < N; ++i) {
            mi = memInfos.get(i);
            if (mi.pss == 0L) {
                mi.pss = Debug.getPss(mi.pid, null, memtrackTmp);
                mi.memtrack = memtrackTmp[0];
            }
            totalPss += mi.pss;
            totalMemtrack += mi.memtrack;
        }
        Collections.sort(memInfos, new Comparator<ProcessMemInfo>(){

            @Override
            public int compare(ProcessMemInfo lhs, ProcessMemInfo rhs) {
                if (lhs.oomAdj != rhs.oomAdj) {
                    return lhs.oomAdj < rhs.oomAdj ? -1 : 1;
                }
                if (lhs.pss != rhs.pss) {
                    return lhs.pss < rhs.pss ? 1 : -1;
                }
                return 0;
            }
        });
        StringBuilder tag = new StringBuilder(128);
        StringBuilder stack = new StringBuilder(128);
        tag.append("Low on memory -- ");
        ActivityManagerService.appendMemBucket(tag, totalPss, "total", false);
        ActivityManagerService.appendMemBucket(stack, totalPss, "total", true);
        StringBuilder fullNativeBuilder = new StringBuilder(1024);
        StringBuilder shortNativeBuilder = new StringBuilder(1024);
        StringBuilder fullJavaBuilder = new StringBuilder(1024);
        boolean firstLine = true;
        int lastOomAdj = Integer.MIN_VALUE;
        long extraNativeRam = 0L;
        long extraNativeMemtrack = 0L;
        long cachedPss = 0L;
        int N3 = memInfos.size();
        for (int i = 0; i < N3; ++i) {
            ProcessMemInfo mi3 = memInfos.get(i);
            if (mi3.oomAdj >= 9) {
                cachedPss += mi3.pss;
            }
            if (mi3.oomAdj != -17 && (mi3.oomAdj < 5 || mi3.oomAdj == 6 || mi3.oomAdj == 7)) {
                if (lastOomAdj != mi3.oomAdj) {
                    lastOomAdj = mi3.oomAdj;
                    if (mi3.oomAdj <= 0) {
                        tag.append(" / ");
                    }
                    if (mi3.oomAdj >= 0) {
                        if (firstLine) {
                            stack.append(":");
                            firstLine = false;
                        }
                        stack.append("\n\t at ");
                    } else {
                        stack.append("$");
                    }
                } else {
                    tag.append(" ");
                    stack.append("$");
                }
                if (mi3.oomAdj <= 0) {
                    ActivityManagerService.appendMemBucket(tag, mi3.pss, mi3.name, false);
                }
                ActivityManagerService.appendMemBucket(stack, mi3.pss, mi3.name, true);
                if (mi3.oomAdj >= 0 && (i + 1 >= N3 || memInfos.get((int)(i + 1)).oomAdj != lastOomAdj)) {
                    stack.append("(");
                    for (int k = 0; k < DUMP_MEM_OOM_ADJ.length; ++k) {
                        if (DUMP_MEM_OOM_ADJ[k] != mi3.oomAdj) continue;
                        stack.append(DUMP_MEM_OOM_LABEL[k]);
                        stack.append(":");
                        stack.append(DUMP_MEM_OOM_ADJ[k]);
                    }
                    stack.append(")");
                }
            }
            this.appendMemInfo(fullNativeBuilder, mi3);
            if (mi3.oomAdj == -17) {
                if (mi3.pss >= 512L) {
                    this.appendMemInfo(shortNativeBuilder, mi3);
                    continue;
                }
                extraNativeRam += mi3.pss;
                extraNativeMemtrack += mi3.memtrack;
                continue;
            }
            if (extraNativeRam > 0L) {
                this.appendBasicMemEntry(shortNativeBuilder, -17, -1, extraNativeRam, extraNativeMemtrack, "(Other native)");
                shortNativeBuilder.append('\n');
                extraNativeRam = 0L;
            }
            this.appendMemInfo(fullJavaBuilder, mi3);
        }
        fullJavaBuilder.append("           ");
        ProcessList.appendRamKb(fullJavaBuilder, totalPss);
        fullJavaBuilder.append(" kB: TOTAL");
        if (totalMemtrack > 0L) {
            fullJavaBuilder.append(" (");
            fullJavaBuilder.append(totalMemtrack);
            fullJavaBuilder.append(" kB memtrack)");
        }
        fullJavaBuilder.append("\n");
        MemInfoReader memInfo = new MemInfoReader();
        memInfo.readMemInfo();
        long[] infos = memInfo.getRawInfo();
        StringBuilder memInfoBuilder = new StringBuilder(1024);
        Debug.getMemInfo(infos);
        memInfoBuilder.append("  MemInfo: ");
        memInfoBuilder.append(infos[5]).append(" kB slab, ");
        memInfoBuilder.append(infos[4]).append(" kB shmem, ");
        memInfoBuilder.append(infos[10]).append(" kB vm alloc, ");
        memInfoBuilder.append(infos[11]).append(" kB page tables ");
        memInfoBuilder.append(infos[12]).append(" kB kernel stack\n");
        memInfoBuilder.append("           ");
        memInfoBuilder.append(infos[2]).append(" kB buffers, ");
        memInfoBuilder.append(infos[3]).append(" kB cached, ");
        memInfoBuilder.append(infos[9]).append(" kB mapped, ");
        memInfoBuilder.append(infos[1]).append(" kB free\n");
        if (infos[8] != 0L) {
            memInfoBuilder.append("  ZRAM: ");
            memInfoBuilder.append(infos[8]);
            memInfoBuilder.append(" kB RAM, ");
            memInfoBuilder.append(infos[6]);
            memInfoBuilder.append(" kB swap total, ");
            memInfoBuilder.append(infos[7]);
            memInfoBuilder.append(" kB swap free\n");
        }
        if ((ksm = this.getKsmInfo())[1] != 0L || ksm[0] != 0L || ksm[2] != 0L || ksm[3] != 0L) {
            memInfoBuilder.append("  KSM: ");
            memInfoBuilder.append(ksm[1]);
            memInfoBuilder.append(" kB saved from shared ");
            memInfoBuilder.append(ksm[0]);
            memInfoBuilder.append(" kB\n");
            memInfoBuilder.append("       ");
            memInfoBuilder.append(ksm[2]);
            memInfoBuilder.append(" kB unshared; ");
            memInfoBuilder.append(ksm[3]);
            memInfoBuilder.append(" kB volatile\n");
        }
        memInfoBuilder.append("  Free RAM: ");
        memInfoBuilder.append(cachedPss + memInfo.getCachedSizeKb() + memInfo.getFreeSizeKb());
        memInfoBuilder.append(" kB\n");
        memInfoBuilder.append("  Used RAM: ");
        memInfoBuilder.append(totalPss - cachedPss + memInfo.getKernelUsedSizeKb());
        memInfoBuilder.append(" kB\n");
        memInfoBuilder.append("  Lost RAM: ");
        memInfoBuilder.append(memInfo.getTotalSizeKb() - totalPss - memInfo.getFreeSizeKb() - memInfo.getCachedSizeKb() - memInfo.getKernelUsedSizeKb());
        memInfoBuilder.append(" kB\n");
        Slog.i("ActivityManager", "Low on memory:");
        Slog.i("ActivityManager", shortNativeBuilder.toString());
        Slog.i("ActivityManager", fullJavaBuilder.toString());
        Slog.i("ActivityManager", memInfoBuilder.toString());
        StringBuilder dropBuilder = new StringBuilder(1024);
        dropBuilder.append("Low on memory:");
        dropBuilder.append((CharSequence)stack);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)fullNativeBuilder);
        dropBuilder.append((CharSequence)fullJavaBuilder);
        dropBuilder.append('\n');
        dropBuilder.append((CharSequence)memInfoBuilder);
        dropBuilder.append('\n');
        StringWriter catSw = new StringWriter();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            FastPrintWriter catPw = new FastPrintWriter(catSw, false, 256);
            String[] emptyArgs = new String[]{};
            ((PrintWriter)catPw).println();
            this.dumpProcessesLocked(null, catPw, emptyArgs, 0, false, null);
            ((PrintWriter)catPw).println();
            this.mServices.dumpServicesLocked(null, catPw, emptyArgs, 0, false, false, null);
            ((PrintWriter)catPw).println();
            this.dumpActivitiesLocked(null, catPw, emptyArgs, 0, false, false, null);
            ((PrintWriter)catPw).flush();
        }
        dropBuilder.append(catSw.toString());
        this.addErrorToDropBox("lowmem", null, "system_server", null, null, tag.toString(), dropBuilder.toString(), null, null);
        activityManagerService = this;
        synchronized (activityManagerService) {
            long now = SystemClock.uptimeMillis();
            if (this.mLastMemUsageReportTime < now) {
                this.mLastMemUsageReportTime = now;
            }
        }
    }

    private static boolean scanArgs(String[] args, String value) {
        if (args != null) {
            for (String arg : args) {
                if (!value.equals(arg)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean removeDyingProviderLocked(ProcessRecord proc, ContentProviderRecord cpr, boolean always) {
        boolean inLaunching = this.mLaunchingProviders.contains(cpr);
        if (!inLaunching || always) {
            ContentProviderRecord contentProviderRecord = cpr;
            synchronized (contentProviderRecord) {
                cpr.launchingApp = null;
                cpr.notifyAll();
            }
            this.mProviderMap.removeProviderByClass(cpr.name, UserHandle.getUserId(cpr.uid));
            String[] names = cpr.info.authority.split(";");
            for (int j = 0; j < names.length; ++j) {
                this.mProviderMap.removeProviderByName(names[j], UserHandle.getUserId(cpr.uid));
            }
        }
        for (int i = cpr.connections.size() - 1; i >= 0; --i) {
            ContentProviderConnection conn = cpr.connections.get(i);
            if (conn.waiting && inLaunching && !always) continue;
            ProcessRecord capp = conn.client;
            conn.dead = true;
            if (conn.stableCount > 0) {
                if (capp.persistent || capp.thread == null || capp.pid == 0 || capp.pid == MY_PID) continue;
                capp.kill("depends on provider " + cpr.name.flattenToShortString() + " in dying proc " + (proc != null ? proc.processName : "??"), true);
                continue;
            }
            if (capp.thread == null || conn.provider.provider == null) continue;
            try {
                capp.thread.unstableProviderDied(conn.provider.provider.asBinder());
            }
            catch (RemoteException e) {
                // empty catch block
            }
            cpr.connections.remove(i);
            if (!conn.client.conProviders.remove(conn)) continue;
            this.stopAssociationLocked(capp.uid, capp.processName, cpr.uid, cpr.name);
        }
        if (inLaunching && always) {
            this.mLaunchingProviders.remove(cpr);
        }
        return inLaunching;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean cleanUpApplicationRecordLocked(ProcessRecord app, boolean restarting, boolean allowRestart, int index) {
        int i;
        if (index >= 0) {
            this.removeLruProcessLocked(app);
            ProcessList.remove(app.pid);
        }
        this.mProcessesToGc.remove(app);
        this.mPendingPssProcesses.remove(app);
        if (app.crashDialog != null && !app.forceCrashReport) {
            app.crashDialog.dismiss();
            app.crashDialog = null;
        }
        if (app.anrDialog != null) {
            app.anrDialog.dismiss();
            app.anrDialog = null;
        }
        if (app.waitDialog != null) {
            app.waitDialog.dismiss();
            app.waitDialog = null;
        }
        app.crashing = false;
        app.notResponding = false;
        app.resetPackageList(this.mProcessStats);
        app.unlinkDeathRecipient();
        app.makeInactive(this.mProcessStats);
        app.waitingToKill = null;
        app.forcingToForeground = null;
        this.updateProcessForegroundLocked(app, false, false);
        app.foregroundActivities = false;
        app.hasShownUi = false;
        app.treatLikeActivity = false;
        app.hasAboveClient = false;
        app.hasClientActivities = false;
        this.mServices.killServicesLocked(app, allowRestart);
        boolean restart = false;
        for (i = app.pubProviders.size() - 1; i >= 0; --i) {
            boolean always;
            ContentProviderRecord cpr = app.pubProviders.valueAt(i);
            boolean inLaunching = this.removeDyingProviderLocked(app, cpr, always = app.bad || !allowRestart);
            if ((inLaunching || always) && cpr.hasConnectionOrHandle()) {
                restart = true;
            }
            cpr.provider = null;
            cpr.proc = null;
        }
        app.pubProviders.clear();
        if (this.checkAppInLaunchingProvidersLocked(app, false)) {
            restart = true;
        }
        if (!app.conProviders.isEmpty()) {
            for (i = app.conProviders.size() - 1; i >= 0; --i) {
                ContentProviderConnection conn = app.conProviders.get(i);
                conn.provider.connections.remove(conn);
                this.stopAssociationLocked(app.uid, app.processName, conn.provider.uid, conn.provider.name);
            }
            app.conProviders.clear();
        }
        this.skipCurrentReceiverLocked(app);
        for (i = app.receivers.size() - 1; i >= 0; --i) {
            this.removeReceiverLocked(app.receivers.valueAt(i));
        }
        app.receivers.clear();
        if (this.mBackupTarget != null && app.pid == this.mBackupTarget.app.pid) {
            try {
                IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
                bm.agentDisconnected(app.info.packageName);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        for (int i2 = this.mPendingProcessChanges.size() - 1; i2 >= 0; --i2) {
            ProcessChangeItem item = this.mPendingProcessChanges.get(i2);
            if (item.pid != app.pid) continue;
            this.mPendingProcessChanges.remove(i2);
            this.mAvailProcessChanges.add(item);
        }
        this.mUiHandler.obtainMessage(32, app.pid, app.info.uid, null).sendToTarget();
        if (restarting) {
            return false;
        }
        if (!app.persistent || app.isolated) {
            this.removeProcessNameLocked(app.processName, app.uid);
            if (this.mHeavyWeightProcess == app) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(25, this.mHeavyWeightProcess.userId, 0));
                this.mHeavyWeightProcess = null;
            }
        } else if (!app.removed && this.mPersistentStartingProcesses.indexOf(app) < 0) {
            this.mPersistentStartingProcesses.add(app);
            restart = true;
        }
        this.mProcessesOnHold.remove(app);
        if (app == this.mHomeProcess) {
            this.mHomeProcess = null;
        }
        if (app == this.mPreviousProcess) {
            this.mPreviousProcess = null;
        }
        if (restart && !app.isolated) {
            if (index < 0) {
                ProcessList.remove(app.pid);
            }
            this.addProcessNameLocked(app);
            this.startProcessLocked(app, "restart", app.processName);
            return true;
        }
        if (app.pid > 0 && app.pid != MY_PID) {
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                this.mPidsSelfLocked.remove(app.pid);
                this.mHandler.removeMessages(20, app);
            }
            this.mBatteryStatsService.noteProcessFinish(app.processName, app.info.uid);
            if (app.isolated) {
                this.mBatteryStatsService.removeIsolatedUid(app.uid, app.info.uid);
            }
            app.setPid(0);
        }
        return false;
    }

    boolean checkAppInLaunchingProvidersLocked(ProcessRecord app, boolean alwaysBad) {
        boolean restart = false;
        for (int i = this.mLaunchingProviders.size() - 1; i >= 0; --i) {
            ContentProviderRecord cpr = this.mLaunchingProviders.get(i);
            if (cpr.launchingApp != app) continue;
            if (!alwaysBad && !app.bad && cpr.hasConnectionOrHandle()) {
                restart = true;
                continue;
            }
            this.removeDyingProviderLocked(app, cpr, true);
        }
        return restart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ActivityManager.RunningServiceInfo> getServices(int maxNum, int flags) {
        this.enforceNotIsolatedCaller("getServices");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceInfoLocked(maxNum, flags);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PendingIntent getRunningServiceControlPanel(ComponentName name) {
        this.enforceNotIsolatedCaller("getRunningServiceControlPanel");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.getRunningServiceControlPanelLocked(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentName startService(IApplicationThread caller, Intent service, String resolvedType, String callingPackage, int userId) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("startService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.mServices.startServiceLocked(caller, service, resolvedType, callingPid, callingUid, callingPackage, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ComponentName startServiceInPackage(int uid, Intent service, String resolvedType, String callingPackage, int userId) throws TransactionTooLargeException {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            ComponentName res = this.mServices.startServiceLocked(null, service, resolvedType, -1, uid, callingPackage, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopService(IApplicationThread caller, Intent service, String resolvedType, int userId) {
        this.enforceNotIsolatedCaller("stopService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceLocked(caller, service, resolvedType, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBinder peekService(Intent service, String resolvedType, String callingPackage) {
        this.enforceNotIsolatedCaller("peekService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.peekServiceLocked(service, resolvedType, callingPackage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stopServiceToken(ComponentName className, IBinder token, int startId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.stopServiceTokenLocked(className, token, startId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setServiceForeground(ComponentName className, IBinder token, int id2, Notification notification, boolean removeNotification) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.setServiceForegroundLocked(className, token, id2, notification, removeNotification);
        }
    }

    @Override
    public int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, boolean requireFull, String name, String callerPackage) {
        return this.handleIncomingUser(callingPid, callingUid, userId, allowAll, requireFull ? 2 : 0, name, callerPackage);
    }

    int unsafeConvertIncomingUser(int userId) {
        return userId == -2 || userId == -3 ? this.mCurrentUserId : userId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, int allowMode, String name, String callerPackage) {
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId == userId) {
            return userId;
        }
        int targetUserId = this.unsafeConvertIncomingUser(userId);
        if (callingUid != 0 && callingUid != 1000) {
            boolean allow;
            if (this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0) {
                allow = true;
            } else if (allowMode == 2) {
                allow = false;
            } else if (this.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) != 0) {
                allow = false;
            } else if (allowMode == 0) {
                allow = true;
            } else if (allowMode == 1) {
                SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
                synchronized (sparseIntArray) {
                    int callingProfile = this.mUserProfileGroupIdsSelfLocked.get(callingUserId, -1);
                    int targetProfile = this.mUserProfileGroupIdsSelfLocked.get(targetUserId, -1);
                    allow = callingProfile != -1 && callingProfile == targetProfile;
                }
            } else {
                throw new IllegalArgumentException("Unknown mode: " + allowMode);
            }
            if (!allow) {
                if (userId == -3) {
                    targetUserId = callingUserId;
                } else {
                    StringBuilder builder = new StringBuilder(128);
                    builder.append("Permission Denial: ");
                    builder.append(name);
                    if (callerPackage != null) {
                        builder.append(" from ");
                        builder.append(callerPackage);
                    }
                    builder.append(" asks to run as user ");
                    builder.append(userId);
                    builder.append(" but is calling from user ");
                    builder.append(UserHandle.getUserId(callingUid));
                    builder.append("; this requires ");
                    builder.append("android.permission.INTERACT_ACROSS_USERS_FULL");
                    if (allowMode != 2) {
                        builder.append(" or ");
                        builder.append("android.permission.INTERACT_ACROSS_USERS");
                    }
                    String msg = builder.toString();
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
            }
        }
        if (!allowAll && targetUserId < 0) {
            throw new IllegalArgumentException("Call does not support special user #" + targetUserId);
        }
        if (callingUid == 2000 && targetUserId >= 0 && this.mUserManager.hasUserRestriction("no_debugging_features", targetUserId)) {
            throw new SecurityException("Shell does not have permission to access user " + targetUserId + "\n " + Debug.getCallers(3));
        }
        return targetUserId;
    }

    boolean isSingleton(String componentProcessName, ApplicationInfo aInfo, String className, int flags) {
        boolean result = false;
        if (UserHandle.getAppId(aInfo.uid) >= 10000) {
            if ((flags & 0x40000000) != 0) {
                if (ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", aInfo.uid) != 0) {
                    ComponentName comp = new ComponentName(aInfo.packageName, className);
                    String msg = "Permission Denial: Component " + comp.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS";
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                result = true;
            }
        } else if ("system".equals(componentProcessName)) {
            result = true;
        } else if ((flags & 0x40000000) != 0) {
            result = UserHandle.isSameApp(aInfo.uid, 1001) || (aInfo.flags & 8) != 0;
        }
        return result;
    }

    boolean isValidSingletonCall(int callingUid, int componentUid) {
        int componentAppId = UserHandle.getAppId(componentUid);
        return UserHandle.isSameApp(callingUid, componentUid) || componentAppId == 1000 || componentAppId == 1001 || ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS_FULL", componentUid) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int bindService(IApplicationThread caller, IBinder token, Intent service, String resolvedType, IServiceConnection connection, int flags, String callingPackage, int userId) throws TransactionTooLargeException {
        this.enforceNotIsolatedCaller("bindService");
        if (service != null && service.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        if (callingPackage == null) {
            throw new IllegalArgumentException("callingPackage cannot be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.bindServiceLocked(caller, token, service, resolvedType, connection, flags, callingPackage, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unbindService(IServiceConnection connection) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mServices.unbindServiceLocked(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishService(IBinder token, Intent intent, IBinder service) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.publishServiceLocked((ServiceRecord)token, intent, service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unbindFinished(IBinder token, Intent intent, boolean doRebind) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mServices.unbindFinishedLocked((ServiceRecord)token, intent, doRebind);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceDoneExecuting(IBinder token, int type, int startId, int res) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!(token instanceof ServiceRecord)) {
                Slog.e("ActivityManager", "serviceDoneExecuting: Invalid service token=" + token);
                throw new IllegalArgumentException("Invalid service token");
            }
            this.mServices.serviceDoneExecutingLocked((ServiceRecord)token, type, startId, res);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bindBackupAgent(ApplicationInfo app, int backupMode) {
        this.enforceCallingPermission("android.permission.CONFIRM_FULL_BACKUP", "bindBackupAgent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            BatteryStatsImpl stats;
            BatteryStatsImpl.Uid.Pkg.Serv ss = null;
            BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
            synchronized (batteryStatsImpl) {
                ss = stats.getServiceStatsLocked(app.uid, app.packageName, app.name);
            }
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(app.packageName, false, UserHandle.getUserId(app.uid));
            }
            catch (RemoteException e) {
            }
            catch (IllegalArgumentException e) {
                Slog.w("ActivityManager", "Failed trying to unstop package " + app.packageName + ": " + e);
            }
            BackupRecord r = new BackupRecord(ss, app, backupMode);
            ComponentName hostingName = backupMode == 0 ? new ComponentName(app.packageName, app.backupAgentName) : new ComponentName("android", "FullBackupAgent");
            ProcessRecord proc = this.startProcessLocked(app.processName, app, false, 0, "backup", hostingName, false, false, false);
            if (proc == null) {
                Slog.e("ActivityManager", "Unable to start backup agent process " + r);
                return false;
            }
            r.app = proc;
            this.mBackupTarget = r;
            this.mBackupAppName = app.packageName;
            this.updateOomAdjLocked(proc);
            if (proc.thread != null) {
                try {
                    proc.thread.scheduleCreateBackupAgent(app, this.compatibilityInfoForPackageLocked(app), backupMode);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearPendingBackup() {
        this.enforceCallingPermission("android.permission.BACKUP", "clearPendingBackup");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mBackupTarget = null;
            this.mBackupAppName = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupAgentCreated(String agentPackageName, IBinder agent) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (!agentPackageName.equals(this.mBackupAppName)) {
                Slog.e("ActivityManager", "Backup agent created for " + agentPackageName + " but not requested!");
                return;
            }
        }
        long oldIdent = Binder.clearCallingIdentity();
        try {
            IBackupManager bm = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
            bm.agentConnected(agentPackageName, agent);
        }
        catch (RemoteException e) {
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception trying to deliver BackupAgent binding: ");
            e.printStackTrace();
        }
        finally {
            Binder.restoreCallingIdentity(oldIdent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void unbindBackupAgent(ApplicationInfo appInfo) {
        if (appInfo == null) {
            Slog.w("ActivityManager", "unbind backup agent for null app");
            return;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            try {
                if (this.mBackupAppName == null) {
                    Slog.w("ActivityManager", "Unbinding backup agent with no active backup");
                    return;
                }
                if (!this.mBackupAppName.equals(appInfo.packageName)) {
                    Slog.e("ActivityManager", "Unbind of " + appInfo + " but is not the current backup target");
                    return;
                }
                ProcessRecord proc = this.mBackupTarget.app;
                this.updateOomAdjLocked(proc);
                if (proc.thread == null) return;
                try {
                    proc.thread.scheduleDestroyBackupAgent(appInfo, this.compatibilityInfoForPackageLocked(appInfo));
                }
                catch (Exception e) {
                    Slog.e("ActivityManager", "Exception when unbinding backup agent:");
                    e.printStackTrace();
                }
            }
            finally {
                this.mBackupTarget = null;
                this.mBackupAppName = null;
            }
            return;
        }
    }

    boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mFgBroadcastQueue.isPendingBroadcastProcessLocked(pid) || this.mBgBroadcastQueue.isPendingBroadcastProcessLocked(pid);
    }

    void skipPendingBroadcastLocked(int pid) {
        Slog.w("ActivityManager", "Unattached app died before broadcast acknowledged, skipping");
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.skipPendingBroadcastLocked(pid);
        }
    }

    boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            didSomething |= queue.sendPendingBroadcastsLocked(app);
        }
        return didSomething;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Intent registerReceiver(IApplicationThread caller, String callerPackage, IIntentReceiver receiver, IntentFilter filter, String permission2, int userId) {
        Intent sticky;
        int callingPid;
        int callingUid;
        this.enforceNotIsolatedCaller("registerReceiver");
        ArrayList<Intent> stickyIntents = null;
        ProcessRecord callerApp = null;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (caller != null) {
                callerApp = this.getRecordForAppLocked(caller);
                if (callerApp == null) {
                    throw new SecurityException("Unable to find app for caller " + caller + " (pid=" + Binder.getCallingPid() + ") when registering receiver " + receiver);
                }
                if (callerApp.info.uid != 1000 && !callerApp.pkgList.containsKey(callerPackage) && !"android".equals(callerPackage)) {
                    throw new SecurityException("Given caller package " + callerPackage + " is not running in process " + callerApp);
                }
                callingUid = callerApp.info.uid;
                callingPid = callerApp.pid;
            } else {
                callerPackage = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
            }
            userId = this.handleIncomingUser(callingPid, callingUid, userId, true, 2, "registerReceiver", callerPackage);
            Iterator<String> actions = filter.actionsIterator();
            if (actions == null) {
                ArrayList noAction = new ArrayList(1);
                noAction.add(null);
                actions = noAction.iterator();
            }
            int[] userIds = new int[]{-1, UserHandle.getUserId(callingUid)};
            while (actions.hasNext()) {
                String action = actions.next();
                for (int id2 : userIds) {
                    ArrayList<Intent> intents;
                    ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(id2);
                    if (stickies == null || (intents = stickies.get(action)) == null) continue;
                    if (stickyIntents == null) {
                        stickyIntents = new ArrayList<Intent>();
                    }
                    stickyIntents.addAll(intents);
                }
            }
        }
        ArrayList<Intent> allSticky = null;
        if (stickyIntents != null) {
            ContentResolver resolver = this.mContext.getContentResolver();
            int N = stickyIntents.size();
            for (int i = 0; i < N; ++i) {
                Intent intent = (Intent)stickyIntents.get(i);
                if (filter.match(resolver, intent, true, "ActivityManager") < 0) continue;
                if (allSticky == null) {
                    allSticky = new ArrayList<Intent>();
                }
                allSticky.add(intent);
            }
        }
        Intent intent = sticky = allSticky != null ? (Intent)allSticky.get(0) : null;
        if (receiver == null) {
            return sticky;
        }
        ActivityManagerService activityManagerService2 = this;
        synchronized (activityManagerService2) {
            if (callerApp != null && (callerApp.thread == null || callerApp.thread.asBinder() != caller.asBinder())) {
                return null;
            }
            ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
            if (rl == null) {
                rl = new ReceiverList(this, callerApp, callingPid, callingUid, userId, receiver);
                if (rl.app != null) {
                    rl.app.receivers.add(rl);
                } else {
                    try {
                        receiver.asBinder().linkToDeath(rl, 0);
                    }
                    catch (RemoteException e) {
                        return sticky;
                    }
                    rl.linkedToDeath = true;
                }
                this.mRegisteredReceivers.put(receiver.asBinder(), rl);
            } else {
                if (rl.uid != callingUid) {
                    throw new IllegalArgumentException("Receiver requested to register for uid " + callingUid + " was previously registered for uid " + rl.uid);
                }
                if (rl.pid != callingPid) {
                    throw new IllegalArgumentException("Receiver requested to register for pid " + callingPid + " was previously registered for pid " + rl.pid);
                }
                if (rl.userId != userId) {
                    throw new IllegalArgumentException("Receiver requested to register for user " + userId + " was previously registered for user " + rl.userId);
                }
            }
            BroadcastFilter bf = new BroadcastFilter(filter, rl, callerPackage, permission2, callingUid, userId);
            rl.add(bf);
            if (!bf.debugCheck()) {
                Slog.w("ActivityManager", "==> For Dynamic broadcast");
            }
            this.mReceiverResolver.addFilter(bf);
            if (allSticky != null) {
                ArrayList<BroadcastFilter> receivers = new ArrayList<BroadcastFilter>();
                receivers.add(bf);
                int stickyCount = allSticky.size();
                for (int i = 0; i < stickyCount; ++i) {
                    Intent intent2 = (Intent)allSticky.get(i);
                    BroadcastQueue queue = this.broadcastQueueForIntent(intent2);
                    BroadcastRecord r = new BroadcastRecord(queue, intent2, null, null, -1, -1, null, null, -1, null, receivers, null, 0, null, null, false, true, true, -1);
                    queue.enqueueParallelBroadcastLocked(r);
                    queue.scheduleBroadcastsLocked();
                }
            }
            return sticky;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterReceiver(IIntentReceiver receiver) {
        long origId = Binder.clearCallingIdentity();
        try {
            boolean doTrim = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                ReceiverList rl = this.mRegisteredReceivers.get(receiver.asBinder());
                if (rl != null) {
                    boolean doNext;
                    BroadcastRecord r = rl.curBroadcast;
                    if (r != null && r == r.queue.getMatchingOrderedReceiver(r) && (doNext = r.queue.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false))) {
                        doTrim = true;
                        r.queue.processNextBroadcast(false);
                    }
                    if (rl.app != null) {
                        rl.app.receivers.remove(rl);
                    }
                    this.removeReceiverLocked(rl);
                    if (rl.linkedToDeath) {
                        rl.linkedToDeath = false;
                        rl.receiver.asBinder().unlinkToDeath(rl, 0);
                    }
                }
            }
            if (doTrim) {
                this.trimApplications();
                return;
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    void removeReceiverLocked(ReceiverList rl) {
        this.mRegisteredReceivers.remove(rl.receiver.asBinder());
        for (int i = rl.size() - 1; i >= 0; --i) {
            this.mReceiverResolver.removeFilter((BroadcastFilter)((IntentFilter)rl.get(i)));
        }
    }

    private final void sendPackageBroadcastLocked(int cmd, String[] packages, int userId) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord r = this.mLruProcesses.get(i);
            if (r.thread == null || userId != -1 && r.userId != userId) continue;
            try {
                r.thread.dispatchPackageBroadcast(cmd, packages);
                continue;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    private List<ResolveInfo> collectReceiverComponents(Intent intent, String resolvedType, int callingUid, int[] users) {
        List<ResolveInfo> receivers = null;
        try {
            HashSet<ComponentName> singleUserReceivers = null;
            boolean scannedFirstReceivers = false;
            for (int user : users) {
                ComponentName cn;
                ResolveInfo ri;
                int i;
                if (callingUid == 2000 && this.getUserManagerLocked().hasUserRestriction("no_debugging_features", user)) continue;
                List<ResolveInfo> newReceivers = AppGlobals.getPackageManager().queryIntentReceivers(intent, resolvedType, 1024, user);
                if (user != 0 && newReceivers != null) {
                    for (i = 0; i < newReceivers.size(); ++i) {
                        ri = newReceivers.get(i);
                        if ((ri.activityInfo.flags & 0x20000000) == 0) continue;
                        newReceivers.remove(i);
                        --i;
                    }
                }
                if (newReceivers != null && newReceivers.size() == 0) {
                    newReceivers = null;
                }
                if (receivers == null) {
                    receivers = newReceivers;
                    continue;
                }
                if (newReceivers == null) continue;
                if (!scannedFirstReceivers) {
                    scannedFirstReceivers = true;
                    for (i = 0; i < receivers.size(); ++i) {
                        ri = receivers.get(i);
                        if ((ri.activityInfo.flags & 0x40000000) == 0) continue;
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet();
                        }
                        singleUserReceivers.add(cn);
                    }
                }
                for (i = 0; i < newReceivers.size(); ++i) {
                    ri = newReceivers.get(i);
                    if ((ri.activityInfo.flags & 0x40000000) != 0) {
                        cn = new ComponentName(ri.activityInfo.packageName, ri.activityInfo.name);
                        if (singleUserReceivers == null) {
                            singleUserReceivers = new HashSet<ComponentName>();
                        }
                        if (singleUserReceivers.contains(cn)) continue;
                        singleUserReceivers.add(cn);
                        receivers.add(ri);
                        continue;
                    }
                    receivers.add(ri);
                }
            }
        }
        catch (RemoteException ex) {
            // empty catch block
        }
        return receivers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int broadcastIntentLocked(ProcessRecord callerApp, String callerPackage, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle options, boolean ordered, boolean sticky, int callingPid, int callingUid, int userId) {
        int NR;
        String action;
        intent = new Intent(intent);
        intent.addFlags(16);
        if (!this.mProcessesReady && (intent.getFlags() & 0x2000000) == 0) {
            intent.addFlags(0x40000000);
        }
        if (resultTo != null && !ordered) {
            Slog.w("ActivityManager", "Broadcast " + intent + " not ordered but result callback requested!");
        }
        if (!((userId = this.handleIncomingUser(callingPid, callingUid, userId, true, 0, "broadcast", callerPackage)) == -1 || this.isUserRunningLocked(userId, false) || callingUid == 1000 && (intent.getFlags() & 0x2000000) != 0 || "android.intent.action.ACTION_SHUTDOWN".equals(intent.getAction()))) {
            Slog.w("ActivityManager", "Skipping broadcast of " + intent + ": user " + userId + " is stopped");
            return -2;
        }
        BroadcastOptions brOptions = null;
        if (options != null && (brOptions = new BroadcastOptions(options)).getTemporaryAppWhitelistDuration() > 0L && this.checkComponentPermission("android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST", Binder.getCallingPid(), Binder.getCallingUid(), -1, true) != 0) {
            String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.CHANGE_DEVICE_IDLE_TEMP_WHITELIST";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        int callingAppId = UserHandle.getAppId(callingUid);
        if (!(callingAppId == 1000 || callingAppId == 1001 || callingAppId == 2000 || callingAppId == 1002 || callingAppId == 1027 || callingUid == 0 || callerApp != null && callerApp.persistent)) {
            try {
                if (AppGlobals.getPackageManager().isProtectedBroadcast(intent.getAction())) {
                    String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " from pid=" + callingPid + ", uid=" + callingUid;
                    Slog.w("ActivityManager", msg);
                    throw new SecurityException(msg);
                }
                if ("android.appwidget.action.APPWIDGET_CONFIGURE".equals(intent.getAction())) {
                    if (callerApp == null) {
                        String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " from unknown caller.";
                        Slog.w("ActivityManager", msg);
                        throw new SecurityException(msg);
                    }
                    if (intent.getComponent() != null) {
                        if (!intent.getComponent().getPackageName().equals(callerApp.info.packageName)) {
                            String msg = "Permission Denial: not allowed to send broadcast " + intent.getAction() + " to " + intent.getComponent().getPackageName() + " from " + callerApp.info.packageName;
                            Slog.w("ActivityManager", msg);
                            throw new SecurityException(msg);
                        }
                    } else {
                        intent.setPackage(callerApp.info.packageName);
                    }
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Remote exception", e);
                return 0;
            }
        }
        if ((action = intent.getAction()) != null) {
            switch (action) {
                case "android.intent.action.UID_REMOVED": 
                case "android.intent.action.PACKAGE_REMOVED": 
                case "android.intent.action.PACKAGE_CHANGED": 
                case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": 
                case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": {
                    String[] list;
                    if (this.checkComponentPermission("android.permission.BROADCAST_PACKAGE_REMOVED", callingPid, callingUid, -1, true) != 0) {
                        String msg = "Permission Denial: " + intent.getAction() + " broadcast from " + callerPackage + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + "android.permission.BROADCAST_PACKAGE_REMOVED";
                        Slog.w("ActivityManager", msg);
                        throw new SecurityException(msg);
                    }
                    switch (action) {
                        case "android.intent.action.UID_REMOVED": {
                            int uid;
                            Bundle intentExtras = intent.getExtras();
                            int n = uid = intentExtras != null ? intentExtras.getInt("android.intent.extra.UID") : -1;
                            if (uid < 0) break;
                            this.mBatteryStatsService.removeUid(uid);
                            this.mAppOpsService.uidRemoved(uid);
                            break;
                        }
                        case "android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE": {
                            list = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
                            if (list == null || list.length <= 0) break;
                            for (int i = 0; i < list.length; ++i) {
                                this.forceStopPackageLocked(list[i], -1, false, true, true, false, false, userId, "storage unmount");
                            }
                            this.mRecentTasks.cleanupLocked(-1);
                            this.sendPackageBroadcastLocked(1, list, userId);
                            break;
                        }
                        case "android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE": {
                            this.mRecentTasks.cleanupLocked(-1);
                            break;
                        }
                        case "android.intent.action.PACKAGE_REMOVED": 
                        case "android.intent.action.PACKAGE_CHANGED": {
                            boolean killProcess;
                            String ssp;
                            Uri data = intent.getData();
                            if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                            boolean removed = "android.intent.action.PACKAGE_REMOVED".equals(action);
                            boolean fullUninstall = removed && !intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                            boolean bl = killProcess = !intent.getBooleanExtra("android.intent.extra.DONT_KILL_APP", false);
                            if (killProcess) {
                                this.forceStopPackageLocked(ssp, UserHandle.getAppId(intent.getIntExtra("android.intent.extra.UID", -1)), false, true, true, false, fullUninstall, userId, removed ? "pkg removed" : "pkg changed");
                            }
                            if (removed) {
                                this.sendPackageBroadcastLocked(0, new String[]{ssp}, userId);
                                if (!fullUninstall) break;
                                this.mAppOpsService.packageRemoved(intent.getIntExtra("android.intent.extra.UID", -1), ssp);
                                this.removeUriPermissionsForPackageLocked(ssp, userId, true);
                                this.removeTasksByPackageNameLocked(ssp, userId);
                                this.mBatteryStatsService.notePackageUninstalled(ssp);
                                break;
                            }
                            this.cleanupDisabledPackageComponentsLocked(ssp, userId, killProcess, intent.getStringArrayExtra("android.intent.extra.changed_component_name_list"));
                        }
                    }
                    break;
                }
                case "android.intent.action.PACKAGE_ADDED": {
                    String ssp;
                    Uri data = intent.getData();
                    if (data == null || (ssp = data.getSchemeSpecificPart()) == null) break;
                    boolean replacing = intent.getBooleanExtra("android.intent.extra.REPLACING", false);
                    this.mCompatModePackages.handlePackageAddedLocked(ssp, replacing);
                    try {
                        ApplicationInfo ai = AppGlobals.getPackageManager().getApplicationInfo(ssp, 0, 0);
                        this.mBatteryStatsService.notePackageInstalled(ssp, ai != null ? ai.versionCode : 0);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case "android.intent.action.TIMEZONE_CHANGED": {
                    this.mHandler.sendEmptyMessage(13);
                    break;
                }
                case "android.intent.action.TIME_SET": {
                    int is24Hour = intent.getBooleanExtra("android.intent.extra.TIME_PREF_24_HOUR_FORMAT", false) ? 1 : 0;
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(41, is24Hour, 0));
                    BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
                    String[] list = stats;
                    synchronized (list) {
                        stats.noteCurrentTimeChangedLocked();
                        break;
                    }
                }
                case "android.intent.action.CLEAR_DNS_CACHE": {
                    this.mHandler.sendEmptyMessage(28);
                    break;
                }
                case "android.intent.action.PROXY_CHANGE": {
                    ProxyInfo proxy = (ProxyInfo)intent.getParcelableExtra("android.intent.extra.PROXY_INFO");
                    this.mHandler.sendMessage(this.mHandler.obtainMessage(29, proxy));
                }
            }
        }
        if (sticky) {
            int i;
            ArrayList<Intent> list;
            ArrayMap<String, ArrayList<Intent>> stickies;
            if (this.checkPermission("android.permission.BROADCAST_STICKY", callingPid, callingUid) != 0) {
                String msg = "Permission Denial: broadcastIntent() requesting a sticky broadcast from pid=" + callingPid + ", uid=" + callingUid + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            if (requiredPermissions != null && requiredPermissions.length > 0) {
                Slog.w("ActivityManager", "Can't broadcast sticky intent " + intent + " and enforce permissions " + Arrays.toString(requiredPermissions));
                return -1;
            }
            if (intent.getComponent() != null) {
                throw new SecurityException("Sticky broadcasts can't target a specific component");
            }
            if (userId != -1 && (stickies = this.mStickyBroadcasts.get(-1)) != null && (list = stickies.get(intent.getAction())) != null) {
                int N = list.size();
                for (int i2 = 0; i2 < N; ++i2) {
                    if (!intent.filterEquals(list.get(i2))) continue;
                    throw new IllegalArgumentException("Sticky broadcast " + intent + " for user " + userId + " conflicts with existing global broadcast");
                }
            }
            if ((stickies = this.mStickyBroadcasts.get(userId)) == null) {
                stickies = new ArrayMap();
                this.mStickyBroadcasts.put(userId, stickies);
            }
            if ((list = stickies.get(intent.getAction())) == null) {
                list = new ArrayList();
                stickies.put(intent.getAction(), list);
            }
            int stickiesCount = list.size();
            for (i = 0; i < stickiesCount; ++i) {
                if (!intent.filterEquals(list.get(i))) continue;
                list.set(i, new Intent(intent));
                break;
            }
            if (i >= stickiesCount) {
                list.add(new Intent(intent));
            }
        }
        int[] users = userId == -1 ? this.mStartedUserArray : new int[]{userId};
        List<ResolveInfo> receivers = null;
        List<BroadcastFilter> registeredReceivers = null;
        if ((intent.getFlags() & 0x40000000) == 0) {
            receivers = this.collectReceiverComponents(intent, resolvedType, callingUid, users);
        }
        if (intent.getComponent() == null) {
            if (userId == -1 && callingUid == 2000) {
                UserManagerService ums = this.getUserManagerLocked();
                for (int i = 0; i < users.length; ++i) {
                    if (ums.hasUserRestriction("no_debugging_features", users[i])) continue;
                    List<BroadcastFilter> registeredReceiversForUser = this.mReceiverResolver.queryIntent(intent, resolvedType, false, users[i]);
                    if (registeredReceivers == null) {
                        registeredReceivers = registeredReceiversForUser;
                        continue;
                    }
                    if (registeredReceiversForUser == null) continue;
                    registeredReceivers.addAll(registeredReceiversForUser);
                }
            } else {
                registeredReceivers = this.mReceiverResolver.queryIntent(intent, resolvedType, false, userId);
            }
        }
        boolean replacePending = (intent.getFlags() & 0x20000000) != 0;
        int n = NR = registeredReceivers != null ? registeredReceivers.size() : 0;
        if (!ordered && NR > 0) {
            boolean replaced;
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, resolvedType, requiredPermissions, appOp, brOptions, registeredReceivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId);
            boolean bl = replaced = replacePending && queue.replaceParallelBroadcastLocked(r);
            if (!replaced) {
                queue.enqueueParallelBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
            registeredReceivers = null;
            NR = 0;
        }
        int ir = 0;
        if (receivers != null) {
            String[] skipPackages = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(intent.getAction()) || "android.intent.action.PACKAGE_RESTARTED".equals(intent.getAction()) || "android.intent.action.PACKAGE_DATA_CLEARED".equals(intent.getAction())) {
                String pkgName;
                Uri data = intent.getData();
                if (data != null && (pkgName = data.getSchemeSpecificPart()) != null) {
                    skipPackages = new String[]{pkgName};
                }
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(intent.getAction())) {
                skipPackages = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (skipPackages != null && skipPackages.length > 0) {
                for (String skipPackage : skipPackages) {
                    if (skipPackage == null) continue;
                    int NT = receivers.size();
                    for (int it = 0; it < NT; ++it) {
                        ResolveInfo curt = receivers.get(it);
                        if (!curt.activityInfo.packageName.equals(skipPackage)) continue;
                        receivers.remove(it);
                        --it;
                        --NT;
                    }
                }
            }
            int NT = receivers != null ? receivers.size() : 0;
            int it = 0;
            ResolveInfo curt = null;
            IntentFilter curr = null;
            while (it < NT && ir < NR) {
                if (curt == null) {
                    curt = receivers.get(it);
                }
                if (curr == null) {
                    curr = registeredReceivers.get(ir);
                }
                if (curr.getPriority() >= curt.priority) {
                    receivers.add(it, (ResolveInfo)((Object)curr));
                    ++ir;
                    curr = null;
                    ++it;
                    ++NT;
                    continue;
                }
                ++it;
                curt = null;
            }
        }
        while (ir < NR) {
            if (receivers == null) {
                receivers = new ArrayList<ResolveInfo>();
            }
            receivers.add((ResolveInfo)((Object)registeredReceivers.get(ir)));
            ++ir;
        }
        if (receivers != null && receivers.size() > 0 || resultTo != null) {
            boolean replaced;
            BroadcastQueue queue = this.broadcastQueueForIntent(intent);
            BroadcastRecord r = new BroadcastRecord(queue, intent, callerApp, callerPackage, callingPid, callingUid, resolvedType, requiredPermissions, appOp, brOptions, receivers, resultTo, resultCode, resultData, resultExtras, ordered, sticky, false, userId);
            boolean bl = replaced = replacePending && queue.replaceOrderedBroadcastLocked(r);
            if (!replaced) {
                queue.enqueueOrderedBroadcastLocked(r);
                queue.scheduleBroadcastsLocked();
            }
        }
        return 0;
    }

    final Intent verifyBroadcastLocked(Intent intent) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        int flags = intent.getFlags();
        if (!this.mProcessesReady && (flags & 0x4000000) == 0 && (flags & 0x40000000) == 0) {
            Slog.e("ActivityManager", "Attempt to launch receivers of broadcast intent " + intent + " before boot completion");
            throw new IllegalStateException("Cannot broadcast before boot completed");
        }
        if ((flags & 0x2000000) != 0) {
            throw new IllegalArgumentException("Can't use FLAG_RECEIVER_BOOT_UPGRADE here");
        }
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int broadcastIntent(IApplicationThread caller, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle options, boolean serialized, boolean sticky, int userId) {
        this.enforceNotIsolatedCaller("broadcastIntent");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            intent = this.verifyBroadcastLocked(intent);
            ProcessRecord callerApp = this.getRecordForAppLocked(caller);
            int callingPid = Binder.getCallingPid();
            int callingUid = Binder.getCallingUid();
            long origId = Binder.clearCallingIdentity();
            int res = this.broadcastIntentLocked(callerApp, callerApp != null ? callerApp.info.packageName : null, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, appOp, null, serialized, sticky, callingPid, callingUid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int broadcastIntentInPackage(String packageName, int uid, Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String requiredPermission, Bundle options, boolean serialized, boolean sticky, int userId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            String[] stringArray;
            intent = this.verifyBroadcastLocked(intent);
            long origId = Binder.clearCallingIdentity();
            if (requiredPermission == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = requiredPermission;
            }
            String[] requiredPermissions = stringArray;
            int res = this.broadcastIntentLocked(null, packageName, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, -1, options, serialized, sticky, -1, uid, userId);
            Binder.restoreCallingIdentity(origId);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void unbroadcastIntent(IApplicationThread caller, Intent intent, int userId) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 0, "removeStickyBroadcast", null);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.BROADCAST_STICKY") != 0) {
                String msg = "Permission Denial: unbroadcastIntent() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.BROADCAST_STICKY";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            ArrayMap<String, ArrayList<Intent>> stickies = this.mStickyBroadcasts.get(userId);
            if (stickies != null) {
                ArrayList<Intent> list = stickies.get(intent.getAction());
                if (list != null) {
                    int N = list.size();
                    for (int i = 0; i < N; ++i) {
                        if (!intent.filterEquals(list.get(i))) continue;
                        list.remove(i);
                        break;
                    }
                    if (list.size() <= 0) {
                        stickies.remove(intent.getAction());
                    }
                }
                if (stickies.size() <= 0) {
                    this.mStickyBroadcasts.remove(userId);
                }
            }
        }
    }

    void backgroundServicesFinishedLocked(int userId) {
        for (BroadcastQueue queue : this.mBroadcastQueues) {
            queue.backgroundServicesFinishedLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishReceiver(IBinder who, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, int flags) {
        if (resultExtras != null && resultExtras.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        long origId = Binder.clearCallingIdentity();
        try {
            BroadcastRecord r;
            boolean doNext = false;
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                BroadcastQueue queue = (flags & 0x10000000) != 0 ? this.mFgBroadcastQueue : this.mBgBroadcastQueue;
                r = queue.getMatchingOrderedReceiver(who);
                if (r != null) {
                    doNext = r.queue.finishReceiverLocked(r, resultCode, resultData, resultExtras, resultAbort, true);
                }
            }
            if (doNext) {
                r.queue.processNextBroadcast(false);
            }
            this.trimApplications();
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean startInstrumentation(ComponentName className, String profileFile, int flags, Bundle arguments, IInstrumentationWatcher watcher, IUiAutomationConnection uiAutomationConnection, int userId, String abiOverride) {
        this.enforceNotIsolatedCaller("startInstrumentation");
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, false, 2, "startInstrumentation", null);
        if (arguments != null && arguments.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Bundle");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            InstrumentationInfo ii = null;
            ApplicationInfo ai = null;
            try {
                ii = this.mContext.getPackageManager().getInstrumentationInfo(className, 1024);
                ai = AppGlobals.getPackageManager().getApplicationInfo(ii.targetPackage, 1024, userId);
            }
            catch (PackageManager.NameNotFoundException e) {
            }
            catch (RemoteException e) {
                // empty catch block
            }
            if (ii == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation info for: " + className);
                return false;
            }
            if (ai == null) {
                this.reportStartInstrumentationFailure(watcher, className, "Unable to find instrumentation target package: " + ii.targetPackage);
                return false;
            }
            int match = this.mContext.getPackageManager().checkSignatures(ii.targetPackage, ii.packageName);
            if (match < 0 && match != -1) {
                String msg = "Permission Denial: starting instrumentation " + className + " from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingPid() + " not allowed because package " + ii.packageName + " does not have a signature matching the target " + ii.targetPackage;
                this.reportStartInstrumentationFailure(watcher, className, msg);
                throw new SecurityException(msg);
            }
            long origId = Binder.clearCallingIdentity();
            this.forceStopPackageLocked(ii.targetPackage, -1, true, false, true, true, false, userId, "start instr");
            ProcessRecord app = this.addAppLocked(ai, false, abiOverride);
            app.instrumentationClass = className;
            app.instrumentationInfo = ai;
            app.instrumentationProfileFile = profileFile;
            app.instrumentationArguments = arguments;
            app.instrumentationWatcher = watcher;
            app.instrumentationUiAutomationConnection = uiAutomationConnection;
            app.instrumentationResultClass = className;
            Binder.restoreCallingIdentity(origId);
        }
        return true;
    }

    private void reportStartInstrumentationFailure(IInstrumentationWatcher watcher, ComponentName cn, String report) {
        Slog.w("ActivityManager", report);
        try {
            if (watcher != null) {
                Bundle results = new Bundle();
                results.putString("id", "ActivityManagerService");
                results.putString("Error", report);
                watcher.instrumentationStatus(cn, -1, results);
            }
        }
        catch (RemoteException e) {
            Slog.w("ActivityManager", e);
        }
    }

    void finishInstrumentationLocked(ProcessRecord app, int resultCode, Bundle results) {
        if (app.instrumentationWatcher != null) {
            try {
                app.instrumentationWatcher.instrumentationFinished(app.instrumentationClass, resultCode, results);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (app.instrumentationUiAutomationConnection != null) {
            this.mHandler.obtainMessage(57, app.instrumentationUiAutomationConnection).sendToTarget();
        }
        app.instrumentationWatcher = null;
        app.instrumentationUiAutomationConnection = null;
        app.instrumentationClass = null;
        app.instrumentationInfo = null;
        app.instrumentationProfileFile = null;
        app.instrumentationArguments = null;
        this.forceStopPackageLocked(app.info.packageName, -1, false, false, true, true, false, app.userId, "finished inst");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishInstrumentation(IApplicationThread target, int resultCode, Bundle results) {
        int userId = UserHandle.getCallingUserId();
        if (results != null && results.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ProcessRecord app = this.getRecordForAppLocked(target);
            if (app == null) {
                Slog.w("ActivityManager", "finishInstrumentation: no app for " + target);
                return;
            }
            long origId = Binder.clearCallingIdentity();
            this.finishInstrumentationLocked(app, resultCode, results);
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurationInfo getDeviceConfigurationInfo() {
        ConfigurationInfo config = new ConfigurationInfo();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            config.reqTouchScreen = this.mConfiguration.touchscreen;
            config.reqKeyboardType = this.mConfiguration.keyboard;
            config.reqNavigation = this.mConfiguration.navigation;
            if (this.mConfiguration.navigation == 2 || this.mConfiguration.navigation == 3) {
                config.reqInputFeatures |= 2;
            }
            if (this.mConfiguration.keyboard != 0 && this.mConfiguration.keyboard != 1) {
                config.reqInputFeatures |= 1;
            }
            config.reqGlEsVersion = this.GL_ES_VERSION;
        }
        return config;
    }

    ActivityStack getFocusedStack() {
        return this.mStackSupervisor.getFocusedStack();
    }

    @Override
    public int getFocusedStackId() throws RemoteException {
        ActivityStack focusedStack = this.getFocusedStack();
        if (focusedStack != null) {
            return focusedStack.getStackId();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configuration getConfiguration() {
        Configuration ci;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ci = new Configuration(this.mConfiguration);
            ci.userSetLocale = false;
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePersistentConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        this.enforceWriteSettingsPermission("updateConfiguration()");
        if (values == null) {
            throw new NullPointerException("Configuration must not be null");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            long origId = Binder.clearCallingIdentity();
            this.updateConfigurationLocked(values, null, true, false);
            Binder.restoreCallingIdentity(origId);
        }
    }

    private void enforceWriteSettingsPermission(String func) {
        int uid = Binder.getCallingUid();
        if (uid == 0) {
            return;
        }
        if (Settings.checkAndNoteWriteSettingsOperation(this.mContext, uid, Settings.getPackageNameForUid(this.mContext, uid), false)) {
            return;
        }
        String msg = "Permission Denial: " + func + " from pid=" + Binder.getCallingPid() + ", uid=" + uid + " requires " + "android.permission.WRITE_SETTINGS";
        Slog.w("ActivityManager", msg);
        throw new SecurityException(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfiguration(Configuration values) {
        this.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (values == null && this.mWindowManager != null) {
                values = this.mWindowManager.computeNewConfiguration();
            }
            if (this.mWindowManager != null) {
                this.mProcessList.applyDisplaySize(this.mWindowManager);
            }
            long origId = Binder.clearCallingIdentity();
            if (values != null) {
                Settings.System.clearConfiguration(values);
            }
            this.updateConfigurationLocked(values, null, false, false);
            Binder.restoreCallingIdentity(origId);
        }
    }

    boolean updateConfigurationLocked(Configuration values, ActivityRecord starting, boolean persistent, boolean initLocale) {
        Configuration newConfig;
        int changes = 0;
        if (values != null && (changes = (newConfig = new Configuration(this.mConfiguration)).updateFrom(values)) != 0) {
            EventLog.writeEvent(2719, changes);
            if (!initLocale && values.locale != null && values.userSetLocale) {
                String languageTag = values.locale.toLanguageTag();
                SystemProperties.set("persist.sys.locale", languageTag);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(47, values.locale));
            }
            ++this.mConfigurationSeq;
            if (this.mConfigurationSeq <= 0) {
                this.mConfigurationSeq = 1;
            }
            newConfig.seq = this.mConfigurationSeq;
            this.mConfiguration = newConfig;
            Slog.i("ActivityManager", "Config changes=" + Integer.toHexString(changes) + " " + newConfig);
            this.mUsageStatsService.reportConfigurationChange(newConfig, this.mCurrentUserId);
            Configuration configCopy = new Configuration(this.mConfiguration);
            this.mShowDialogs = ActivityManagerService.shouldShowDialogs(newConfig);
            AttributeCache ac = AttributeCache.instance();
            if (ac != null) {
                ac.updateConfiguration(configCopy);
            }
            this.mSystemThread.applyConfigurationToResources(configCopy);
            if (persistent && Settings.System.hasInterestingConfigurationChanges(changes)) {
                Message msg = this.mHandler.obtainMessage(4);
                msg.obj = new Configuration(configCopy);
                this.mHandler.sendMessage(msg);
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                try {
                    if (app.thread == null) continue;
                    app.thread.scheduleConfigurationChanged(configCopy);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            Intent intent = new Intent("android.intent.action.CONFIGURATION_CHANGED");
            intent.addFlags(0x70000000);
            this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, -1);
            if ((changes & 4) != 0) {
                intent = new Intent("android.intent.action.LOCALE_CHANGED");
                intent.addFlags(0x10000000);
                if (!this.mProcessesReady) {
                    intent.addFlags(0x40000000);
                }
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, -1);
            }
        }
        boolean kept = true;
        ActivityStack mainStack = this.mStackSupervisor.getFocusedStack();
        if (mainStack != null) {
            if (changes != 0 && starting == null) {
                starting = mainStack.topRunningActivityLocked(null);
            }
            if (starting != null) {
                kept = mainStack.ensureActivityConfigurationLocked(starting, changes);
                this.mStackSupervisor.ensureActivitiesVisibleLocked(starting, changes);
            }
        }
        if (values != null && this.mWindowManager != null) {
            this.mWindowManager.setNewConfiguration(this.mConfiguration);
        }
        return kept;
    }

    private static final boolean shouldShowDialogs(Configuration config) {
        return config.keyboard != 1 || config.touchscreen != 1 || config.navigation != 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldUpRecreateTask(IBinder token, String destAffinity) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord srec = ActivityRecord.forTokenLocked(token);
            if (srec != null) {
                return srec.task.stack.shouldUpRecreateTaskLocked(srec, destAffinity);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean navigateUpTo(IBinder token, Intent destIntent, int resultCode, Intent resultData) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            ActivityRecord r = ActivityRecord.forTokenLocked(token);
            if (r != null) {
                return r.task.stack.navigateUpToLocked(r, destIntent, resultCode, resultData);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLaunchedFromUid(IBinder activityToken) {
        ActivityRecord srec;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            srec = ActivityRecord.forTokenLocked(activityToken);
        }
        if (srec == null) {
            return -1;
        }
        return srec.launchedFromUid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLaunchedFromPackage(IBinder activityToken) {
        ActivityRecord srec;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            srec = ActivityRecord.forTokenLocked(activityToken);
        }
        if (srec == null) {
            return null;
        }
        return srec.launchedFromPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BroadcastQueue isReceivingBroadcast(ProcessRecord app) {
        BroadcastRecord r = app.curReceiver;
        if (r != null) {
            return r.queue;
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (BroadcastQueue queue : this.mBroadcastQueues) {
                r = queue.mPendingBroadcast;
                if (r == null || r.curApp != app) continue;
                return queue;
            }
        }
        return null;
    }

    Association startAssociationLocked(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent, String targetProcess) {
        Association ass;
        ArrayMap<String, Association> sourceProcesses;
        SparseArray<ArrayMap<String, Association>> sourceUids;
        if (!this.mTrackingAssociations) {
            return null;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            components = new ArrayMap();
            this.mAssociations.put(targetUid, components);
        }
        if ((sourceUids = components.get(targetComponent)) == null) {
            sourceUids = new SparseArray();
            components.put(targetComponent, sourceUids);
        }
        if ((sourceProcesses = sourceUids.get(sourceUid)) == null) {
            sourceProcesses = new ArrayMap();
            sourceUids.put(sourceUid, sourceProcesses);
        }
        if ((ass = sourceProcesses.get(sourceProcess)) == null) {
            ass = new Association(sourceUid, sourceProcess, targetUid, targetComponent, targetProcess);
            sourceProcesses.put(sourceProcess, ass);
        }
        ++ass.mCount;
        ++ass.mNesting;
        if (ass.mNesting == 1) {
            ass.mStartTime = SystemClock.uptimeMillis();
        }
        return ass;
    }

    void stopAssociationLocked(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent) {
        if (!this.mTrackingAssociations) {
            return;
        }
        ArrayMap<ComponentName, SparseArray<ArrayMap<String, Association>>> components = this.mAssociations.get(targetUid);
        if (components == null) {
            return;
        }
        SparseArray<ArrayMap<String, Association>> sourceUids = components.get(targetComponent);
        if (sourceUids == null) {
            return;
        }
        ArrayMap<String, Association> sourceProcesses = sourceUids.get(sourceUid);
        if (sourceProcesses == null) {
            return;
        }
        Association ass = sourceProcesses.get(sourceProcess);
        if (ass == null || ass.mNesting <= 0) {
            return;
        }
        --ass.mNesting;
        if (ass.mNesting == 0) {
            ass.mTime += SystemClock.uptimeMillis() - ass.mStartTime;
        }
    }

    private final int computeOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        int procState;
        int schedGroup;
        int adj;
        if (this.mAdjSeq == app.adjSeq) {
            return app.curRawAdj;
        }
        if (app.thread == null) {
            app.adjSeq = this.mAdjSeq;
            app.curSchedGroup = 0;
            app.curProcState = 16;
            app.curRawAdj = 15;
            app.curAdj = 15;
            return 15;
        }
        app.adjTypeCode = 0;
        app.adjSource = null;
        app.adjTarget = null;
        app.empty = false;
        app.cached = false;
        int activitiesSize = app.activities.size();
        if (app.maxAdj <= 0) {
            app.adjType = "fixed";
            app.adjSeq = this.mAdjSeq;
            app.curRawAdj = app.maxAdj;
            app.foregroundActivities = false;
            app.curSchedGroup = -1;
            app.curProcState = 0;
            app.systemNoUi = true;
            if (app == TOP_APP) {
                app.systemNoUi = false;
            } else if (activitiesSize > 0) {
                for (int j = 0; j < activitiesSize; ++j) {
                    ActivityRecord r = app.activities.get(j);
                    if (!r.visible) continue;
                    app.systemNoUi = false;
                }
            }
            if (!app.systemNoUi) {
                app.curProcState = 1;
            }
            app.curAdj = app.maxAdj;
            return app.curAdj;
        }
        app.systemNoUi = false;
        int PROCESS_STATE_TOP = this.mTopProcessState;
        boolean foregroundActivities = false;
        if (app == TOP_APP) {
            adj = 0;
            schedGroup = -1;
            app.adjType = "top-activity";
            foregroundActivities = true;
            procState = PROCESS_STATE_TOP;
        } else if (app.instrumentationClass != null) {
            adj = 0;
            schedGroup = -1;
            app.adjType = "instrumentation";
            procState = 4;
        } else {
            BroadcastQueue queue = this.isReceivingBroadcast(app);
            if (queue != null) {
                adj = 0;
                schedGroup = queue == this.mFgBroadcastQueue ? -1 : 0;
                app.adjType = "broadcast";
                procState = 11;
            } else if (app.executingServices.size() > 0) {
                adj = 0;
                schedGroup = app.execServicesFg ? -1 : 0;
                app.adjType = "exec-service";
                procState = 10;
            } else {
                schedGroup = 0;
                adj = cachedAdj;
                procState = 16;
                app.cached = true;
                app.empty = true;
                app.adjType = "cch-empty";
            }
        }
        if (!foregroundActivities && activitiesSize > 0) {
            for (int j = 0; j < activitiesSize; ++j) {
                ActivityRecord r = app.activities.get(j);
                if (r.app != app) {
                    Slog.w("ActivityManager", "Wtf, activity " + r + " in proc activity list not using proc " + app + "?!? Using " + r.app + " instead.");
                    continue;
                }
                if (r.visible) {
                    if (adj > 1) {
                        adj = 1;
                        app.adjType = "visible";
                    }
                    if (procState > PROCESS_STATE_TOP) {
                        procState = PROCESS_STATE_TOP;
                    }
                    schedGroup = -1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    break;
                }
                if (r.state == ActivityStack.ActivityState.PAUSING || r.state == ActivityStack.ActivityState.PAUSED) {
                    if (adj > 2) {
                        adj = 2;
                        app.adjType = "pausing";
                    }
                    if (procState > PROCESS_STATE_TOP) {
                        procState = PROCESS_STATE_TOP;
                    }
                    schedGroup = -1;
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (r.state == ActivityStack.ActivityState.STOPPING) {
                    if (adj > 2) {
                        adj = 2;
                        app.adjType = "stopping";
                    }
                    if (!r.finishing && procState > 13) {
                        procState = 13;
                    }
                    app.cached = false;
                    app.empty = false;
                    foregroundActivities = true;
                    continue;
                }
                if (procState <= 14) continue;
                procState = 14;
                app.adjType = "cch-act";
            }
        }
        if (adj > 2) {
            if (app.foregroundServices) {
                adj = 2;
                procState = 4;
                app.cached = false;
                app.adjType = "fg-service";
                schedGroup = -1;
            } else if (app.forcingToForeground != null) {
                adj = 2;
                procState = 6;
                app.cached = false;
                app.adjType = "force-fg";
                app.adjSource = app.forcingToForeground;
                schedGroup = -1;
            }
        }
        if (app == this.mHeavyWeightProcess) {
            if (adj > 4) {
                adj = 4;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "heavy";
            }
            if (procState > 9) {
                procState = 9;
            }
        }
        if (app == this.mHomeProcess) {
            if (adj > 6) {
                adj = 6;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "home";
            }
            if (procState > 12) {
                procState = 12;
            }
        }
        if (app == this.mPreviousProcess && app.activities.size() > 0) {
            if (adj > 7) {
                adj = 7;
                schedGroup = 0;
                app.cached = false;
                app.adjType = "previous";
            }
            if (procState > 13) {
                procState = 13;
            }
        }
        app.adjSeq = this.mAdjSeq;
        app.curRawAdj = adj;
        app.hasStartedServices = false;
        if (this.mBackupTarget != null && app == this.mBackupTarget.app) {
            if (adj > 3) {
                adj = 3;
                if (procState > 7) {
                    procState = 7;
                }
                app.adjType = "backup";
                app.cached = false;
            }
            if (procState > 8) {
                procState = 8;
            }
        }
        boolean mayBeTop = false;
        for (int is = app.services.size() - 1; is >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --is) {
            ServiceRecord s = app.services.valueAt(is);
            if (s.startRequested) {
                app.hasStartedServices = true;
                if (procState > 10) {
                    procState = 10;
                }
                if (app.hasShownUi && app != this.mHomeProcess) {
                    if (adj > 5) {
                        app.adjType = "cch-started-ui-services";
                    }
                } else {
                    if (now < s.lastActivity + 1800000L && adj > 5) {
                        adj = 5;
                        app.adjType = "started-services";
                        app.cached = false;
                    }
                    if (adj > 5) {
                        app.adjType = "cch-started-services";
                    }
                }
            }
            for (int conni = s.connections.size() - 1; conni >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --conni) {
                ArrayList<ConnectionRecord> clist = s.connections.valueAt(conni);
                for (int i = 0; i < clist.size() && (adj > 0 || schedGroup == 0 || procState > 2); ++i) {
                    ConnectionRecord cr = clist.get(i);
                    if (cr.binding.client == app) continue;
                    if ((cr.flags & 0x20) == 0) {
                        ProcessRecord client = cr.binding.client;
                        int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                        int clientProcState = client.curProcState;
                        if (clientProcState >= 14) {
                            clientProcState = 16;
                        }
                        String adjType = null;
                        if ((cr.flags & 0x10) != 0) {
                            if (app.hasShownUi && app != this.mHomeProcess) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-ui-services";
                                }
                                app.cached = false;
                                clientAdj = adj;
                                clientProcState = procState;
                            } else if (now >= s.lastActivity + 1800000L) {
                                if (adj > clientAdj) {
                                    adjType = "cch-bound-services";
                                }
                                clientAdj = adj;
                            }
                        }
                        if (adj > clientAdj) {
                            if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                                adjType = "cch-bound-ui-services";
                            } else {
                                if ((cr.flags & 0x48) != 0) {
                                    adj = clientAdj >= -11 ? clientAdj : -11;
                                } else if ((cr.flags & 0x40000000) != 0 && clientAdj < 2 && adj > 2) {
                                    adj = 2;
                                } else if (clientAdj > 1) {
                                    adj = clientAdj;
                                } else if (adj > 1) {
                                    adj = 1;
                                }
                                if (!client.cached) {
                                    app.cached = false;
                                }
                                adjType = "service";
                            }
                        }
                        if ((cr.flags & 4) == 0) {
                            if (client.curSchedGroup == -1) {
                                schedGroup = -1;
                            }
                            if (clientProcState <= 2) {
                                if (clientProcState == 2) {
                                    mayBeTop = true;
                                    clientProcState = 16;
                                } else {
                                    clientProcState = (cr.flags & 0x4000000) != 0 ? 3 : (this.mWakefulness == 1 && (cr.flags & 0x2000000) != 0 ? 3 : 6);
                                }
                            }
                        } else if (clientProcState < 7) {
                            clientProcState = 7;
                        }
                        if (procState > clientProcState) {
                            procState = clientProcState;
                        }
                        if (procState < 7 && (cr.flags & 0x20000000) != 0) {
                            app.pendingUiClean = true;
                        }
                        if (adjType != null) {
                            app.adjType = adjType;
                            app.adjTypeCode = 2;
                            app.adjSource = cr.binding.client;
                            app.adjSourceProcState = clientProcState;
                            app.adjTarget = s.name;
                        }
                    }
                    if ((cr.flags & 0x8000000) != 0) {
                        app.treatLikeActivity = true;
                    }
                    ActivityRecord a = cr.activity;
                    if ((cr.flags & 0x80) == 0 || a == null || adj <= 0 || !a.visible && a.state != ActivityStack.ActivityState.RESUMED && a.state != ActivityStack.ActivityState.PAUSING) continue;
                    adj = 0;
                    if ((cr.flags & 4) == 0) {
                        schedGroup = -1;
                    }
                    app.cached = false;
                    app.adjType = "service";
                    app.adjTypeCode = 2;
                    app.adjSource = a;
                    app.adjSourceProcState = procState;
                    app.adjTarget = s.name;
                }
            }
        }
        for (int provi = app.pubProviders.size() - 1; provi >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --provi) {
            ContentProviderRecord cpr = app.pubProviders.valueAt(provi);
            for (int i = cpr.connections.size() - 1; i >= 0 && (adj > 0 || schedGroup == 0 || procState > 2); --i) {
                ContentProviderConnection conn = cpr.connections.get(i);
                ProcessRecord client = conn.client;
                if (client == app) continue;
                int clientAdj = this.computeOomAdjLocked(client, cachedAdj, TOP_APP, doingAll, now);
                int clientProcState = client.curProcState;
                if (clientProcState >= 14) {
                    clientProcState = 16;
                }
                if (adj > clientAdj) {
                    if (app.hasShownUi && app != this.mHomeProcess && clientAdj > 2) {
                        app.adjType = "cch-ui-provider";
                    } else {
                        adj = clientAdj > 0 ? clientAdj : 0;
                        app.adjType = "provider";
                    }
                    app.cached &= client.cached;
                    app.adjTypeCode = 1;
                    app.adjSource = client;
                    app.adjSourceProcState = clientProcState;
                    app.adjTarget = cpr.name;
                }
                if (clientProcState <= 2) {
                    if (clientProcState == 2) {
                        mayBeTop = true;
                        clientProcState = 16;
                    } else {
                        clientProcState = 3;
                    }
                }
                if (procState > clientProcState) {
                    procState = clientProcState;
                }
                if (client.curSchedGroup != -1) continue;
                schedGroup = -1;
            }
            if (!cpr.hasExternalProcessHandles()) continue;
            if (adj > 0) {
                adj = 0;
                schedGroup = -1;
                app.cached = false;
                app.adjType = "provider";
                app.adjTarget = cpr.name;
            }
            if (procState <= 6) continue;
            procState = 6;
        }
        if (mayBeTop && procState > 2) {
            switch (procState) {
                case 6: 
                case 7: 
                case 10: {
                    procState = 3;
                    break;
                }
                default: {
                    procState = 2;
                }
            }
        }
        if (procState >= 16) {
            if (app.hasClientActivities) {
                procState = 15;
                app.adjType = "cch-client-act";
            } else if (app.treatLikeActivity) {
                procState = 14;
                app.adjType = "cch-as-act";
            }
        }
        if (adj == 5) {
            if (doingAll) {
                app.serviceb = this.mNewNumAServiceProcs > this.mNumServiceProcs / 3;
                ++this.mNewNumServiceProcs;
                if (!app.serviceb) {
                    if (this.mLastMemoryLevel > 0 && app.lastPss >= this.mProcessList.getCachedRestoreThresholdKb()) {
                        app.serviceHighRam = true;
                        app.serviceb = true;
                    } else {
                        ++this.mNewNumAServiceProcs;
                    }
                } else {
                    app.serviceHighRam = false;
                }
            }
            if (app.serviceb) {
                adj = 8;
            }
        }
        app.curRawAdj = adj;
        if (adj > app.maxAdj) {
            adj = app.maxAdj;
            if (app.maxAdj <= 2) {
                schedGroup = -1;
            }
        }
        app.curAdj = app.modifyRawOomAdj(adj);
        app.curSchedGroup = schedGroup;
        app.curProcState = procState;
        app.foregroundActivities = foregroundActivities;
        return app.curRawAdj;
    }

    void recordPssSampleLocked(ProcessRecord proc, int procState, long pss, long uss, long now) {
        EventLogTags.writeAmPss(proc.pid, proc.uid, proc.processName, pss * 1024L, uss * 1024L);
        proc.lastPssTime = now;
        proc.baseProcessTracker.addPss(pss, uss, true, proc.pkgList);
        if (proc.initialIdlePss == 0L) {
            proc.initialIdlePss = pss;
        }
        proc.lastPss = pss;
        if (procState >= 12) {
            proc.lastCachedPss = pss;
        }
        SparseArray<Pair<Long, String>> watchUids = this.mMemWatchProcesses.getMap().get(proc.processName);
        Long check = null;
        if (watchUids != null) {
            Pair<Long, String> val = watchUids.get(proc.uid);
            if (val == null) {
                val = watchUids.get(0);
            }
            if (val != null) {
                check = (Long)val.first;
            }
        }
        if (check != null && pss * 1024L >= check && proc.thread != null && this.mMemWatchDumpProcName == null) {
            boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
            if (!isDebuggable && (proc.info.flags & 2) != 0) {
                isDebuggable = true;
            }
            if (isDebuggable) {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + "; reporting");
                final ProcessRecord myProc = proc;
                final File heapdumpFile = DumpHeapProvider.getJavaFile();
                this.mMemWatchDumpProcName = proc.processName;
                this.mMemWatchDumpFile = heapdumpFile.toString();
                this.mMemWatchDumpPid = proc.pid;
                this.mMemWatchDumpUid = proc.uid;
                BackgroundThread.getHandler().post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        ActivityManagerService.this.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
                        ParcelFileDescriptor fd = null;
                        try {
                            heapdumpFile.delete();
                            fd = ParcelFileDescriptor.open(heapdumpFile, 0x2E000000);
                            IApplicationThread thread = myProc.thread;
                            if (thread != null) {
                                try {
                                    thread.dumpHeap(true, heapdumpFile.toString(), fd);
                                }
                                catch (RemoteException remoteException) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        finally {
                            if (fd != null) {
                                try {
                                    fd.close();
                                }
                                catch (IOException iOException) {}
                            }
                        }
                    }
                });
            } else {
                Slog.w("ActivityManager", "Process " + proc + " exceeded pss limit " + check + ", but debugging not enabled");
            }
        }
    }

    void requestPssLocked(ProcessRecord proc, int procState) {
        if (this.mPendingPssProcesses.contains(proc)) {
            return;
        }
        if (this.mPendingPssProcesses.size() == 0) {
            this.mBgHandler.sendEmptyMessage(1);
        }
        proc.pssProcState = procState;
        this.mPendingPssProcesses.add(proc);
    }

    void requestPssAllProcsLocked(long now, boolean always, boolean memLowered) {
        if (!always && now < this.mLastFullPssTime + (long)(memLowered ? 120000 : 600000)) {
            return;
        }
        this.mLastFullPssTime = now;
        this.mFullPssPending = true;
        this.mPendingPssProcesses.ensureCapacity(this.mLruProcesses.size());
        this.mPendingPssProcesses.clear();
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord app = this.mLruProcesses.get(i);
            if (app.thread == null || app.curProcState == -1 || !memLowered && now <= app.lastStateTime + 600000L) continue;
            app.pssProcState = app.setProcState;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mTestPssMode, this.isSleeping(), now);
            this.mPendingPssProcesses.add(app);
        }
        this.mBgHandler.sendEmptyMessage(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTestPssMode(boolean enabled) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.mTestPssMode = enabled;
            if (enabled) {
                this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, true);
            }
        }
    }

    final void performAppGcLocked(ProcessRecord app) {
        try {
            app.lastRequestedGc = SystemClock.uptimeMillis();
            if (app.thread != null) {
                if (app.reportLowMemory) {
                    app.reportLowMemory = false;
                    app.thread.scheduleLowMemory();
                } else {
                    app.thread.processInBackground();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final boolean canGcNowLocked() {
        boolean processingBroadcasts = false;
        for (BroadcastQueue q : this.mBroadcastQueues) {
            if (q.mParallelBroadcasts.size() == 0 && q.mOrderedBroadcasts.size() == 0) continue;
            processingBroadcasts = true;
        }
        return !processingBroadcasts && (this.isSleeping() || this.mStackSupervisor.allResumedActivitiesIdle());
    }

    final void performAppGcsLocked() {
        int N = this.mProcessesToGc.size();
        if (N <= 0) {
            return;
        }
        if (this.canGcNowLocked()) {
            while (this.mProcessesToGc.size() > 0) {
                ProcessRecord proc = this.mProcessesToGc.remove(0);
                if (proc.curRawAdj <= 2 && !proc.reportLowMemory) continue;
                if (proc.lastRequestedGc + 60000L <= SystemClock.uptimeMillis()) {
                    this.performAppGcLocked(proc);
                    this.scheduleAppGcsLocked();
                    return;
                }
                this.addProcessToGcListLocked(proc);
                break;
            }
            this.scheduleAppGcsLocked();
        }
    }

    final void performAppGcsIfAppropriateLocked() {
        if (this.canGcNowLocked()) {
            this.performAppGcsLocked();
            return;
        }
        this.scheduleAppGcsLocked();
    }

    final void scheduleAppGcsLocked() {
        this.mHandler.removeMessages(5);
        if (this.mProcessesToGc.size() > 0) {
            ProcessRecord proc = this.mProcessesToGc.get(0);
            Message msg = this.mHandler.obtainMessage(5);
            long when = proc.lastRequestedGc + 60000L;
            long now = SystemClock.uptimeMillis();
            if (when < now + 5000L) {
                when = now + 5000L;
            }
            this.mHandler.sendMessageAtTime(msg, when);
        }
    }

    final void addProcessToGcListLocked(ProcessRecord proc) {
        boolean added = false;
        for (int i = this.mProcessesToGc.size() - 1; i >= 0; --i) {
            if (this.mProcessesToGc.get((int)i).lastRequestedGc >= proc.lastRequestedGc) continue;
            added = true;
            this.mProcessesToGc.add(i + 1, proc);
            break;
        }
        if (!added) {
            this.mProcessesToGc.add(0, proc);
        }
    }

    final void scheduleAppGcLocked(ProcessRecord app) {
        long now = SystemClock.uptimeMillis();
        if (app.lastRequestedGc + 60000L > now) {
            return;
        }
        if (!this.mProcessesToGc.contains(app)) {
            this.addProcessToGcListLocked(app);
            this.scheduleAppGcsLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void checkExcessivePowerUsageLocked(boolean doKills) {
        this.updateCpuStatsNow();
        BatteryStatsImpl stats = this.mBatteryStatsService.getActiveStatistics();
        boolean doWakeKills = doKills;
        boolean doCpuKills = doKills;
        if (this.mLastPowerCheckRealtime == 0L) {
            doWakeKills = false;
        }
        if (this.mLastPowerCheckUptime == 0L) {
            doCpuKills = false;
        }
        if (stats.isScreenOn()) {
            doWakeKills = false;
        }
        long curRealtime = SystemClock.elapsedRealtime();
        long realtimeSince = curRealtime - this.mLastPowerCheckRealtime;
        long curUptime = SystemClock.uptimeMillis();
        long uptimeSince = curUptime - this.mLastPowerCheckUptime;
        this.mLastPowerCheckRealtime = curRealtime;
        this.mLastPowerCheckUptime = curUptime;
        if (realtimeSince < 300000L) {
            doWakeKills = false;
        }
        if (uptimeSince < 300000L) {
            doCpuKills = false;
        }
        int i = this.mLruProcesses.size();
        while (i > 0) {
            BatteryStatsImpl batteryStatsImpl;
            long wtime;
            ProcessRecord app = this.mLruProcesses.get(--i);
            if (app.setProcState < 12) continue;
            BatteryStatsImpl batteryStatsImpl2 = stats;
            synchronized (batteryStatsImpl2) {
                wtime = stats.getProcessWakeTime(app.info.uid, app.pid, curRealtime);
            }
            long wtimeUsed = wtime - app.lastWakeTime;
            long cputimeUsed = app.curCpuTime - app.lastCpuTime;
            if (doWakeKills && realtimeSince > 0L && wtimeUsed * 100L / realtimeSince >= 50L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveWakeLocked(app.info.uid, app.processName, realtimeSince, wtimeUsed);
                }
                app.kill("excessive wake held " + wtimeUsed + " during " + realtimeSince, true);
                app.baseProcessTracker.reportExcessiveWake(app.pkgList);
                continue;
            }
            if (doCpuKills && uptimeSince > 0L && cputimeUsed * 100L / uptimeSince >= 25L) {
                batteryStatsImpl = stats;
                synchronized (batteryStatsImpl) {
                    stats.reportExcessiveCpuLocked(app.info.uid, app.processName, uptimeSince, cputimeUsed);
                }
                app.kill("excessive cpu " + cputimeUsed + " during " + uptimeSince, true);
                app.baseProcessTracker.reportExcessiveCpu(app.pkgList);
                continue;
            }
            app.lastWakeTime = wtime;
            app.lastCpuTime = app.curCpuTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean applyOomAdjLocked(ProcessRecord app, boolean doingAll, long now) {
        boolean success = true;
        if (app.curRawAdj != app.setRawAdj) {
            app.setRawAdj = app.curRawAdj;
        }
        int changes = 0;
        if (app.curAdj != app.setAdj) {
            ProcessList.setOomAdj(app.pid, app.info.uid, app.curAdj);
            app.setAdj = app.curAdj;
        }
        if (app.setSchedGroup != app.curSchedGroup) {
            app.setSchedGroup = app.curSchedGroup;
            if (app.waitingToKill != null && app.curReceiver == null && app.setSchedGroup == 0) {
                app.kill(app.waitingToKill, true);
                success = false;
            } else {
                long oldId = Binder.clearCallingIdentity();
                try {
                    android.os.Process.setProcessGroup(app.pid, app.curSchedGroup);
                }
                catch (Exception e) {
                    Slog.w("ActivityManager", "Failed setting process group of " + app.pid + " to " + app.curSchedGroup);
                    e.printStackTrace();
                }
                finally {
                    Binder.restoreCallingIdentity(oldId);
                }
                android.os.Process.setSwappiness(app.pid, app.curSchedGroup <= 0);
            }
        }
        if (app.repForegroundActivities != app.foregroundActivities) {
            app.repForegroundActivities = app.foregroundActivities;
            changes |= 1;
        }
        if (app.repProcState != app.curProcState) {
            app.repProcState = app.curProcState;
            changes |= 2;
            if (app.thread != null) {
                try {
                    app.thread.setProcessState(app.repProcState);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        }
        if (app.setProcState == -1 || ProcessList.procStatesDifferForMem(app.curProcState, app.setProcState)) {
            app.lastStateTime = now;
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, true, this.mTestPssMode, this.isSleeping(), now);
        } else if (now > app.nextPssTime || now > app.lastPssTime + 1800000L && now > app.lastStateTime + ProcessList.minTimeFromStateChange(this.mTestPssMode)) {
            this.requestPssLocked(app, app.setProcState);
            app.nextPssTime = ProcessList.computeNextPssTime(app.curProcState, false, this.mTestPssMode, this.isSleeping(), now);
        }
        if (app.setProcState != app.curProcState) {
            boolean curImportant;
            boolean setImportant = app.setProcState < 10;
            boolean bl = curImportant = app.curProcState < 10;
            if (setImportant && !curImportant) {
                BatteryStatsImpl stats;
                BatteryStatsImpl batteryStatsImpl = stats = this.mBatteryStatsService.getActiveStatistics();
                synchronized (batteryStatsImpl) {
                    app.lastWakeTime = stats.getProcessWakeTime(app.info.uid, app.pid, SystemClock.elapsedRealtime());
                }
                app.lastCpuTime = app.curCpuTime;
            }
            this.maybeUpdateUsageStatsLocked(app);
            app.setProcState = app.curProcState;
            if (app.setProcState >= 12) {
                app.notCachedSinceIdle = false;
            }
            if (!doingAll) {
                this.setProcessTrackerStateLocked(app, this.mProcessStats.getMemFactorLocked(), now);
            } else {
                app.procStateChanged = true;
            }
        }
        if (changes != 0) {
            int i;
            ProcessChangeItem item = null;
            for (i = this.mPendingProcessChanges.size() - 1; i >= 0; --i) {
                item = this.mPendingProcessChanges.get(i);
                if (item.pid == app.pid) break;
            }
            if (i < 0) {
                int NA = this.mAvailProcessChanges.size();
                item = NA > 0 ? this.mAvailProcessChanges.remove(NA - 1) : new ProcessChangeItem();
                item.changes = 0;
                item.pid = app.pid;
                item.uid = app.info.uid;
                if (this.mPendingProcessChanges.size() == 0) {
                    this.mUiHandler.obtainMessage(31).sendToTarget();
                }
                this.mPendingProcessChanges.add(item);
            }
            item.changes |= changes;
            item.processState = app.repProcState;
            item.foregroundActivities = app.repForegroundActivities;
        }
        return success;
    }

    private final void enqueueUidChangeLocked(UidRecord uidRec, boolean gone) {
        if (uidRec.pendingChange == null) {
            int NA;
            if (this.mPendingUidChanges.size() == 0) {
                this.mUiHandler.obtainMessage(54).sendToTarget();
            }
            uidRec.pendingChange = (NA = this.mAvailUidChanges.size()) > 0 ? this.mAvailUidChanges.remove(NA - 1) : new UidRecord.ChangeItem();
            uidRec.pendingChange.uidRecord = uidRec;
            uidRec.pendingChange.uid = uidRec.uid;
            this.mPendingUidChanges.add(uidRec.pendingChange);
        }
        uidRec.pendingChange.gone = gone;
        uidRec.pendingChange.processState = uidRec.setProcState;
    }

    private void maybeUpdateProviderUsageStatsLocked(ProcessRecord app, String providerPkgName, String authority) {
        if (app == null) {
            return;
        }
        if (app.curProcState <= 6) {
            UserState userState = this.mStartedUsers.get(app.userId);
            if (userState == null) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            Long lastReported = userState.mProviderLastReportedFg.get(authority);
            if (lastReported == null || lastReported < now - 60000L) {
                this.mUsageStatsService.reportContentProviderUsage(authority, providerPkgName, app.userId);
                userState.mProviderLastReportedFg.put(authority, now);
            }
        }
    }

    private void maybeUpdateUsageStatsLocked(ProcessRecord app) {
        String[] packages;
        boolean isInteraction;
        if (this.mUsageStatsService == null) {
            return;
        }
        if (app.curProcState <= 3) {
            isInteraction = true;
            app.fgInteractionTime = 0L;
        } else if (app.curProcState <= 5) {
            long now = SystemClock.elapsedRealtime();
            if (app.fgInteractionTime == 0L) {
                app.fgInteractionTime = now;
                isInteraction = false;
            } else {
                isInteraction = now > app.fgInteractionTime + 1800000L;
            }
        } else {
            isInteraction = app.curProcState <= 6;
            app.fgInteractionTime = 0L;
        }
        if (isInteraction && !app.reportedInteraction && (packages = app.getPackageList()) != null) {
            for (int i = 0; i < packages.length; ++i) {
                this.mUsageStatsService.reportEvent(packages[i], app.userId, 6);
            }
        }
        app.reportedInteraction = isInteraction;
    }

    private final void setProcessTrackerStateLocked(ProcessRecord proc, int memFactor, long now) {
        if (proc.thread != null) {
            if (proc.baseProcessTracker != null) {
                proc.baseProcessTracker.setState(proc.repProcState, memFactor, now, proc.pkgList);
            }
            if (proc.repProcState >= 0) {
                this.mBatteryStatsService.noteProcessState(proc.processName, proc.info.uid, proc.repProcState);
            }
        }
    }

    private final boolean updateOomAdjLocked(ProcessRecord app, int cachedAdj, ProcessRecord TOP_APP, boolean doingAll, long now) {
        if (app.thread == null) {
            return false;
        }
        this.computeOomAdjLocked(app, cachedAdj, TOP_APP, doingAll, now);
        return this.applyOomAdjLocked(app, doingAll, now);
    }

    final void updateProcessForegroundLocked(ProcessRecord proc, boolean isForeground, boolean oomAdj) {
        if (isForeground != proc.foregroundServices) {
            proc.foregroundServices = isForeground;
            ArrayList<ProcessRecord> curProcs = this.mForegroundPackages.get(proc.info.packageName, proc.info.uid);
            if (isForeground) {
                if (curProcs == null) {
                    curProcs = new ArrayList();
                    this.mForegroundPackages.put(proc.info.packageName, proc.info.uid, curProcs);
                }
                if (!curProcs.contains(proc)) {
                    curProcs.add(proc);
                    this.mBatteryStatsService.noteEvent(32770, proc.info.packageName, proc.info.uid);
                }
            } else if (curProcs != null && curProcs.remove(proc)) {
                this.mBatteryStatsService.noteEvent(16386, proc.info.packageName, proc.info.uid);
                if (curProcs.size() <= 0) {
                    this.mForegroundPackages.remove(proc.info.packageName, proc.info.uid);
                }
            }
            if (oomAdj) {
                this.updateOomAdjLocked();
            }
        }
    }

    private final ActivityRecord resumedAppLocked() {
        int uid;
        String pkg;
        ActivityRecord act = this.mStackSupervisor.resumedAppLocked();
        if (act != null) {
            pkg = act.packageName;
            uid = act.info.applicationInfo.uid;
        } else {
            pkg = null;
            uid = -1;
        }
        if (uid != this.mCurResumedUid || pkg != this.mCurResumedPackage && (pkg == null || !pkg.equals(this.mCurResumedPackage))) {
            if (this.mCurResumedPackage != null) {
                this.mBatteryStatsService.noteEvent(16387, this.mCurResumedPackage, this.mCurResumedUid);
            }
            this.mCurResumedPackage = pkg;
            this.mCurResumedUid = uid;
            if (this.mCurResumedPackage != null) {
                this.mBatteryStatsService.noteEvent(32771, this.mCurResumedPackage, this.mCurResumedUid);
            }
        }
        return act;
    }

    final boolean updateOomAdjLocked(ProcessRecord app) {
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        boolean wasCached = app.cached;
        ++this.mAdjSeq;
        int cachedAdj = app.curRawAdj >= 9 ? app.curRawAdj : 16;
        boolean success = this.updateOomAdjLocked(app, cachedAdj, TOP_APP, false, SystemClock.uptimeMillis());
        if (wasCached != app.cached || app.curRawAdj == 16) {
            this.updateOomAdjLocked();
        }
        return success;
    }

    final void updateOomAdjLocked() {
        int i;
        int cachedFactor;
        int emptyFactor;
        int emptyProcessLimit;
        int cachedProcessLimit;
        ActivityRecord TOP_ACT = this.resumedAppLocked();
        ProcessRecord TOP_APP = TOP_ACT != null ? TOP_ACT.app : null;
        long now = SystemClock.uptimeMillis();
        long oldTime = now - 1800000L;
        int N = this.mLruProcesses.size();
        for (int i2 = this.mActiveUids.size() - 1; i2 >= 0; --i2) {
            UidRecord uidRec = this.mActiveUids.valueAt(i2);
            uidRec.reset();
        }
        ++this.mAdjSeq;
        this.mNewNumServiceProcs = 0;
        this.mNewNumAServiceProcs = 0;
        if (this.mProcessLimit <= 0) {
            cachedProcessLimit = 0;
            emptyProcessLimit = 0;
        } else if (this.mProcessLimit == 1) {
            emptyProcessLimit = 1;
            cachedProcessLimit = 0;
        } else {
            emptyProcessLimit = ProcessList.computeEmptyProcessLimit(this.mProcessLimit);
            cachedProcessLimit = this.mProcessLimit - emptyProcessLimit;
        }
        int numSlots = 3;
        int numEmptyProcs = N - this.mNumNonCachedProcs - this.mNumCachedHiddenProcs;
        if (numEmptyProcs > cachedProcessLimit) {
            numEmptyProcs = cachedProcessLimit;
        }
        if ((emptyFactor = numEmptyProcs / numSlots) < 1) {
            emptyFactor = 1;
        }
        if ((cachedFactor = (this.mNumCachedHiddenProcs > 0 ? this.mNumCachedHiddenProcs : 1) / numSlots) < 1) {
            cachedFactor = 1;
        }
        int stepCached = 0;
        int stepEmpty = 0;
        int numCached = 0;
        int numEmpty = 0;
        int numTrimming = 0;
        this.mNumNonCachedProcs = 0;
        this.mNumCachedHiddenProcs = 0;
        int curCachedAdj = 9;
        int nextCachedAdj = curCachedAdj + 1;
        int curEmptyAdj = 9;
        int nextEmptyAdj = curEmptyAdj + 2;
        for (int i3 = N - 1; i3 >= 0; --i3) {
            ProcessRecord app = this.mLruProcesses.get(i3);
            if (app.killedByAm || app.thread == null) continue;
            app.procStateChanged = false;
            this.computeOomAdjLocked(app, 16, TOP_APP, true, now);
            if (app.curAdj >= 16) {
                switch (app.curProcState) {
                    case 14: 
                    case 15: {
                        app.curRawAdj = curCachedAdj;
                        app.curAdj = app.modifyRawOomAdj(curCachedAdj);
                        if (curCachedAdj == nextCachedAdj || ++stepCached < cachedFactor) break;
                        stepCached = 0;
                        curCachedAdj = nextCachedAdj;
                        if ((nextCachedAdj += 2) <= 15) break;
                        nextCachedAdj = 15;
                        break;
                    }
                    default: {
                        app.curRawAdj = curEmptyAdj;
                        app.curAdj = app.modifyRawOomAdj(curEmptyAdj);
                        if (curEmptyAdj == nextEmptyAdj || ++stepEmpty < emptyFactor) break;
                        stepEmpty = 0;
                        curEmptyAdj = nextEmptyAdj;
                        if ((nextEmptyAdj += 2) <= 15) break;
                        nextEmptyAdj = 15;
                    }
                }
            }
            this.applyOomAdjLocked(app, true, now);
            switch (app.curProcState) {
                case 14: 
                case 15: {
                    ++this.mNumCachedHiddenProcs;
                    if (++numCached <= cachedProcessLimit) break;
                    app.kill("cached #" + numCached, true);
                    break;
                }
                case 16: {
                    if (numEmpty > ProcessList.TRIM_EMPTY_APPS && app.lastActivityTime < oldTime) {
                        app.kill("empty for " + (oldTime + 1800000L - app.lastActivityTime) / 1000L + "s", true);
                        break;
                    }
                    if (++numEmpty <= emptyProcessLimit) break;
                    app.kill("empty #" + numEmpty, true);
                    break;
                }
                default: {
                    ++this.mNumNonCachedProcs;
                }
            }
            if (app.isolated && app.services.size() <= 0) {
                app.kill("isolated not needed", true);
            } else {
                UidRecord uidRec = app.uidRecord;
                if (uidRec != null && uidRec.curProcState > app.curProcState) {
                    uidRec.curProcState = app.curProcState;
                }
            }
            if (app.curProcState < 12 || app.killedByAm) continue;
            ++numTrimming;
        }
        this.mNumServiceProcs = this.mNewNumServiceProcs;
        int numCachedAndEmpty = numCached + numEmpty;
        int memFactor = numCached <= ProcessList.TRIM_CACHED_APPS && numEmpty <= ProcessList.TRIM_EMPTY_APPS ? (numCachedAndEmpty <= 3 ? 3 : (numCachedAndEmpty <= 5 ? 2 : 1)) : 0;
        if (!(memFactor <= this.mLastMemoryLevel || this.mAllowLowerMemLevel && this.mLruProcesses.size() < this.mLastNumProcesses)) {
            memFactor = this.mLastMemoryLevel;
        }
        this.mLastMemoryLevel = memFactor;
        this.mLastNumProcesses = this.mLruProcesses.size();
        boolean allChanged = this.mProcessStats.setMemFactorLocked(memFactor, !this.isSleeping(), now);
        int trackerMemFactor = this.mProcessStats.getMemFactorLocked();
        if (memFactor != 0) {
            int fgTrimLevel;
            if (this.mLowRamStartTime == 0L) {
                this.mLowRamStartTime = now;
            }
            int step = 0;
            switch (memFactor) {
                case 3: {
                    fgTrimLevel = 15;
                    break;
                }
                case 2: {
                    fgTrimLevel = 10;
                    break;
                }
                default: {
                    fgTrimLevel = 5;
                }
            }
            int factor = numTrimming / 3;
            int minFactor = 2;
            if (this.mHomeProcess != null) {
                ++minFactor;
            }
            if (this.mPreviousProcess != null) {
                ++minFactor;
            }
            if (factor < minFactor) {
                factor = minFactor;
            }
            int curLevel = 80;
            for (int i4 = N - 1; i4 >= 0; --i4) {
                ProcessRecord app = this.mLruProcesses.get(i4);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if (app.curProcState >= 12 && !app.killedByAm) {
                    if (app.trimMemoryLevel < curLevel && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(curLevel);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = curLevel;
                    if (++step < factor) continue;
                    step = 0;
                    switch (curLevel) {
                        case 80: {
                            curLevel = 60;
                            break;
                        }
                        case 60: {
                            curLevel = 40;
                        }
                    }
                    continue;
                }
                if (app.curProcState == 9) {
                    if (app.trimMemoryLevel < 40 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(40);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.trimMemoryLevel = 40;
                    continue;
                }
                if ((app.curProcState >= 7 || app.systemNoUi) && app.pendingUiClean) {
                    int level = 20;
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                if (app.trimMemoryLevel < fgTrimLevel && app.thread != null) {
                    try {
                        app.thread.scheduleTrimMemory(fgTrimLevel);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                app.trimMemoryLevel = fgTrimLevel;
            }
        } else {
            if (this.mLowRamStartTime != 0L) {
                this.mLowRamTimeSinceLastIdle += now - this.mLowRamStartTime;
                this.mLowRamStartTime = 0L;
            }
            for (i = N - 1; i >= 0; --i) {
                ProcessRecord app = this.mLruProcesses.get(i);
                if (allChanged || app.procStateChanged) {
                    this.setProcessTrackerStateLocked(app, trackerMemFactor, now);
                    app.procStateChanged = false;
                }
                if ((app.curProcState >= 7 || app.systemNoUi) && app.pendingUiClean) {
                    if (app.trimMemoryLevel < 20 && app.thread != null) {
                        try {
                            app.thread.scheduleTrimMemory(20);
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                    }
                    app.pendingUiClean = false;
                }
                app.trimMemoryLevel = 0;
            }
        }
        if (this.mAlwaysFinishActivities) {
            this.mStackSupervisor.scheduleDestroyAllActivities(null, "always-finish");
        }
        if (allChanged) {
            this.requestPssAllProcsLocked(now, false, this.mProcessStats.isMemFactorLowered());
        }
        for (i = this.mActiveUids.size() - 1; i >= 0; --i) {
            UidRecord uidRec = this.mActiveUids.valueAt(i);
            if (uidRec.setProcState == uidRec.curProcState) continue;
            uidRec.setProcState = uidRec.curProcState;
            this.enqueueUidChangeLocked(uidRec, false);
        }
        if (this.mProcessStats.shouldWriteNowLocked(now)) {
            this.mHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ActivityManagerService.this.mProcessStats.writeStateAsyncLocked();
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trimApplications() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            for (int i = this.mRemovedProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord app = this.mRemovedProcesses.get(i);
                if (app.activities.size() != 0 || app.curReceiver != null || app.services.size() != 0) continue;
                Slog.i("ActivityManager", "Exiting empty application process " + app.processName + " (" + (app.thread != null ? app.thread.asBinder() : null) + ")\n");
                if (app.pid > 0 && app.pid != MY_PID) {
                    app.kill("empty", false);
                } else {
                    try {
                        app.thread.scheduleExit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                this.cleanUpApplicationRecordLocked(app, false, true, -1);
                this.mRemovedProcesses.remove(i);
                if (!app.persistent) continue;
                this.addAppLocked(app.info, false, null);
            }
            this.updateOomAdjLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalPersistentProcesses(int sig) throws RemoteException {
        if (sig != 10) {
            throw new SecurityException("Only SIGNAL_USR1 is allowed");
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (this.checkCallingPermission("android.permission.SIGNAL_PERSISTENT_PROCESSES") != 0) {
                throw new SecurityException("Requires permission android.permission.SIGNAL_PERSISTENT_PROCESSES");
            }
            for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
                ProcessRecord r = this.mLruProcesses.get(i);
                if (r.thread == null || !r.persistent) continue;
                android.os.Process.sendSignal(r.pid, sig);
            }
        }
    }

    private void stopProfilerLocked(ProcessRecord proc, int profileType) {
        if (proc == null || proc == this.mProfileProc) {
            proc = this.mProfileProc;
            profileType = this.mProfileType;
            this.clearProfilerLocked();
        }
        if (proc == null) {
            return;
        }
        try {
            proc.thread.profilerControl(false, null, profileType);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("Process disappeared");
        }
    }

    private void clearProfilerLocked() {
        if (this.mProfileFd != null) {
            try {
                this.mProfileFd.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mProfileApp = null;
        this.mProfileProc = null;
        this.mProfileFile = null;
        this.mProfileType = 0;
        this.mAutoStopProfiler = false;
        this.mSamplingInterval = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean profileControl(String process, int userId, boolean start, ProfilerInfo profilerInfo, int profileType) throws RemoteException {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (start && (profilerInfo == null || profilerInfo.profileFd == null)) {
                        throw new IllegalArgumentException("null profile info or fd");
                    }
                    ProcessRecord proc = null;
                    if (process != null) {
                        proc = this.findProcessLocked(process, userId, "profileControl");
                    }
                    if (start && (proc == null || proc.thread == null)) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    if (start) {
                        this.stopProfilerLocked(null, 0);
                        this.setProfileApp(proc.info, proc.processName, profilerInfo);
                        this.mProfileProc = proc;
                        this.mProfileType = profileType;
                        ParcelFileDescriptor fd = profilerInfo.profileFd;
                        try {
                            fd = fd.dup();
                        }
                        catch (IOException e) {
                            fd = null;
                        }
                        profilerInfo.profileFd = fd;
                        proc.thread.profilerControl(start, profilerInfo, profileType);
                        fd = null;
                        this.mProfileFd = null;
                    } else {
                        this.stopProfilerLocked(proc, profileType);
                        if (profilerInfo != null && profilerInfo.profileFd != null) {
                            try {
                                profilerInfo.profileFd.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Process disappeared");
                    }
                }
            }
        }
        finally {
            if (profilerInfo != null && profilerInfo.profileFd != null) {
                try {
                    profilerInfo.profileFd.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessRecord findProcessLocked(String process, int userId, String callName) {
        ArrayMap<String, SparseArray<ProcessRecord>> all;
        SparseArray<ProcessRecord> procs;
        userId = this.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), userId, true, 2, callName, null);
        ProcessRecord proc = null;
        try {
            int pid = Integer.parseInt(process);
            SparseArray<ProcessRecord> sparseArray = this.mPidsSelfLocked;
            synchronized (sparseArray) {
                proc = this.mPidsSelfLocked.get(pid);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (proc == null && (procs = (all = this.mProcessNames.getMap()).get(process)) != null && procs.size() > 0) {
            proc = procs.valueAt(0);
            if (userId != -1 && proc.userId != userId) {
                for (int i = 1; i < procs.size(); ++i) {
                    ProcessRecord thisProc = procs.valueAt(i);
                    if (thisProc.userId != userId) continue;
                    proc = thisProc;
                    break;
                }
            }
        }
        return proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dumpHeap(String process, int userId, boolean managed, String path, ParcelFileDescriptor fd) throws RemoteException {
        try {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                try {
                    if (this.checkCallingPermission("android.permission.SET_ACTIVITY_WATCHER") != 0) {
                        throw new SecurityException("Requires permission android.permission.SET_ACTIVITY_WATCHER");
                    }
                    if (fd == null) {
                        throw new IllegalArgumentException("null fd");
                    }
                    ProcessRecord proc = this.findProcessLocked(process, userId, "dumpHeap");
                    if (proc == null || proc.thread == null) {
                        throw new IllegalArgumentException("Unknown process: " + process);
                    }
                    boolean isDebuggable = "1".equals(SystemProperties.get(SYSTEM_DEBUGGABLE, "0"));
                    if (!isDebuggable && (proc.info.flags & 2) == 0) {
                        throw new SecurityException("Process not debuggable: " + proc);
                    }
                    proc.thread.dumpHeap(managed, path, fd);
                    fd = null;
                    boolean bl = true;
                    return bl;
                }
                catch (Throwable throwable) {
                    try {
                        throw throwable;
                    }
                    catch (RemoteException e) {
                        throw new IllegalStateException("Process disappeared");
                    }
                }
            }
        }
        finally {
            if (fd != null) {
                try {
                    fd.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDumpHeapDebugLimit(String processName, int uid, long maxMemSize, String reportPackage) {
        Object object;
        if (processName != null) {
            this.enforceCallingPermission("android.permission.SET_DEBUG_APP", "setDumpHeapDebugLimit()");
        } else {
            object = this.mPidsSelfLocked;
            synchronized (object) {
                ProcessRecord proc = this.mPidsSelfLocked.get(Binder.getCallingPid());
                if (proc == null) {
                    throw new SecurityException("No process found for calling pid " + Binder.getCallingPid());
                }
                if (!Build.IS_DEBUGGABLE && (proc.info.flags & 2) == 0) {
                    throw new SecurityException("Not running a debuggable build");
                }
                processName = proc.processName;
                uid = proc.uid;
                if (reportPackage != null && !proc.pkgList.containsKey(reportPackage)) {
                    throw new SecurityException("Package " + reportPackage + " is not running in " + proc);
                }
            }
        }
        object = this;
        synchronized (object) {
            if (maxMemSize > 0L) {
                this.mMemWatchProcesses.put(processName, uid, new Pair<Long, String>(maxMemSize, reportPackage));
            } else if (uid != 0) {
                this.mMemWatchProcesses.remove(processName, uid);
            } else {
                this.mMemWatchProcesses.getMap().remove(processName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpHeapFinished(String path) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (Binder.getCallingPid() != this.mMemWatchDumpPid) {
                Slog.w("ActivityManager", "dumpHeapFinished: Calling pid " + Binder.getCallingPid() + " does not match last pid " + this.mMemWatchDumpPid);
                return;
            }
            if (this.mMemWatchDumpFile == null || !this.mMemWatchDumpFile.equals(path)) {
                Slog.w("ActivityManager", "dumpHeapFinished: Calling path " + path + " does not match last path " + this.mMemWatchDumpFile);
                return;
            }
            this.mHandler.sendEmptyMessage(51);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
        }
    }

    void onCoreSettingsChange(Bundle settings) {
        for (int i = this.mLruProcesses.size() - 1; i >= 0; --i) {
            ProcessRecord processRecord = this.mLruProcesses.get(i);
            try {
                if (processRecord.thread == null) continue;
                processRecord.thread.setCoreSettings(settings);
                continue;
            }
            catch (RemoteException re) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean startUserInBackground(int userId) {
        return this.startUser(userId, false);
    }

    boolean startUserInForeground(int userId, Dialog dlg) {
        boolean result = this.startUser(userId, true);
        dlg.dismiss();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentProfileIdsLocked() {
        List<UserInfo> profiles = this.getUserManagerLocked().getProfiles(this.mCurrentUserId, false);
        int[] currentProfileIds = new int[profiles.size()];
        for (int i = 0; i < currentProfileIds.length; ++i) {
            currentProfileIds[i] = profiles.get((int)i).id;
        }
        this.mCurrentProfileIds = currentProfileIds;
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            this.mUserProfileGroupIdsSelfLocked.clear();
            List<UserInfo> users = this.getUserManagerLocked().getUsers(false);
            for (int i = 0; i < users.size(); ++i) {
                UserInfo user = users.get(i);
                if (user.profileGroupId == -1) continue;
                this.mUserProfileGroupIdsSelfLocked.put(user.id, user.profileGroupId);
            }
        }
    }

    private Set<Integer> getProfileIdsLocked(int userId) {
        HashSet<Integer> userIds = new HashSet<Integer>();
        List<UserInfo> profiles = this.getUserManagerLocked().getProfiles(userId, false);
        for (UserInfo user : profiles) {
            userIds.add(user.id);
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean switchUser(int userId) {
        String userName;
        this.enforceShellRestriction("no_debugging_features", userId);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            UserInfo userInfo = this.getUserManagerLocked().getUserInfo(userId);
            if (userInfo == null) {
                Slog.w("ActivityManager", "No user info for user #" + userId);
                return false;
            }
            if (userInfo.isManagedProfile()) {
                Slog.w("ActivityManager", "Cannot switch to User #" + userId + ": not a full user");
                return false;
            }
            userName = userInfo.name;
            this.mTargetUserId = userId;
        }
        this.mUiHandler.removeMessages(46);
        this.mUiHandler.sendMessage(this.mUiHandler.obtainMessage(46, userId, 0, userName));
        return true;
    }

    private void showUserSwitchDialog(int userId, String userName) {
        UserSwitchingDialog d = new UserSwitchingDialog(this, this.mContext, userId, userName, true);
        ((Dialog)d).show();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean startUser(final int userId, final boolean foreground) {
        int oldUserId;
        long ident;
        block29: {
            if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
                String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            ident = Binder.clearCallingIdentity();
            ActivityManagerService activityManagerService = this;
            // MONITORENTER : activityManagerService
            oldUserId = this.mCurrentUserId;
            if (oldUserId != userId) break block29;
            boolean bl = true;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        this.mStackSupervisor.setLockTaskModeLocked(null, 0, "startUser", false);
        UserInfo userInfo = this.getUserManagerLocked().getUserInfo(userId);
        if (userInfo == null) {
            Slog.w("ActivityManager", "No user info for user #" + userId);
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (foreground && userInfo.isManagedProfile()) {
            Slog.w("ActivityManager", "Cannot switch to User #" + userId + ": not a full user");
            boolean bl = false;
            // MONITOREXIT : activityManagerService
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            Intent intent;
            if (foreground) {
                this.mWindowManager.startFreezingScreen(17432672, 17432671);
            }
            boolean needStart = false;
            if (this.mStartedUsers.get(userId) == null) {
                this.mStartedUsers.put(userId, new UserState(new UserHandle(userId), false));
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            Integer userIdInt = userId;
            this.mUserLru.remove(userIdInt);
            this.mUserLru.add(userIdInt);
            if (foreground) {
                this.mCurrentUserId = userId;
                this.mTargetUserId = -10000;
                this.updateCurrentProfileIdsLocked();
                this.mWindowManager.setCurrentUser(userId, this.mCurrentProfileIds);
                this.mWindowManager.lockNow(null);
            } else {
                Integer currentUserIdInt = this.mCurrentUserId;
                this.updateCurrentProfileIdsLocked();
                this.mWindowManager.setCurrentProfileIds(this.mCurrentProfileIds);
                this.mUserLru.remove(currentUserIdInt);
                this.mUserLru.add(currentUserIdInt);
            }
            final UserState uss = this.mStartedUsers.get(userId);
            if (uss.mState == 2) {
                uss.mState = 1;
                this.updateStartedUserArrayLocked();
                needStart = true;
            } else if (uss.mState == 3) {
                uss.mState = 0;
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            if (uss.mState == 0) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(42, userId, 0));
            }
            if (foreground) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(43, userId, oldUserId));
                this.mHandler.removeMessages(34);
                this.mHandler.removeMessages(36);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(34, oldUserId, userId, uss));
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(36, oldUserId, userId, uss), 2000L);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, userId);
            }
            if ((userInfo.flags & 0x10) == 0) {
                if (userId != 0) {
                    intent = new Intent("android.intent.action.USER_INITIALIZE");
                    intent.addFlags(0x10000000);
                    this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                        @Override
                        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                            ActivityManagerService.this.onUserInitialized(uss, foreground, oldUserId, userId);
                        }
                    }, 0, null, null, null, -1, null, true, false, MY_PID, 1000, userId);
                    uss.initializing = true;
                } else {
                    this.getUserManagerLocked().makeInitialized(userInfo.id);
                }
            }
            if (foreground) {
                if (!uss.initializing) {
                    this.moveUserToForeground(uss, oldUserId, userId);
                }
            } else {
                this.mStackSupervisor.startBackgroundUserLocked(userId, uss);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.broadcastIntentLocked(null, null, intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, MY_PID, 1000, -1);
            }
            // MONITOREXIT : activityManagerService
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void dispatchForegroundProfileChanged(int userId) {
        int N = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < N; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onForegroundProfileSwitch(userId);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUserSwitchBroadcastsLocked(int oldUserId, int newUserId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            int profileUserId;
            int i;
            int count;
            List<UserInfo> profiles;
            if (oldUserId >= 0) {
                profiles = this.mUserManager.getProfiles(oldUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_BACKGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, profileUserId);
                }
            }
            if (newUserId >= 0) {
                profiles = this.mUserManager.getProfiles(newUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_FOREGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, profileUserId);
                }
                intent = new Intent("android.intent.action.USER_SWITCHED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, new String[]{"android.permission.MANAGE_USERS"}, -1, null, false, false, MY_PID, 1000, -1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUserSwitch(final UserState uss, final int oldUserId, final int newUserId) {
        final int N = this.mUserSwitchObservers.beginBroadcast();
        if (N > 0) {
            IRemoteCallback.Stub callback = new IRemoteCallback.Stub(){
                int mCount = 0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendResult(Bundle data) throws RemoteException {
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        if (ActivityManagerService.this.mCurUserSwitchCallback == this) {
                            ++this.mCount;
                            if (this.mCount == N) {
                                ActivityManagerService.this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
                            }
                        }
                    }
                }
            };
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                uss.switching = true;
                this.mCurUserSwitchCallback = callback;
            }
            for (int i = 0; i < N; ++i) {
                try {
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitching(newUserId, callback);
                    continue;
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
        } else {
            ActivityManagerService activityManagerService = this;
            synchronized (activityManagerService) {
                this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeoutUserSwitch(UserState uss, int oldUserId, int newUserId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            Slog.w("ActivityManager", "User switch timeout: from " + oldUserId + " to " + newUserId);
            this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
        }
    }

    void sendContinueUserSwitchLocked(UserState uss, int oldUserId, int newUserId) {
        this.mCurUserSwitchCallback = null;
        this.mHandler.removeMessages(36);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, oldUserId, newUserId, uss));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUserInitialized(UserState uss, boolean foreground, int oldUserId, int newUserId) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (foreground) {
                this.moveUserToForeground(uss, oldUserId, newUserId);
            }
        }
        this.completeSwitchAndInitialize(uss, newUserId, true, false);
    }

    void moveUserToForeground(UserState uss, int oldUserId, int newUserId) {
        boolean homeInFront = this.mStackSupervisor.switchUserLocked(newUserId, uss);
        if (homeInFront) {
            this.startHomeActivityLocked(newUserId, "moveUserToFroreground");
        } else {
            this.mStackSupervisor.resumeTopActivitiesLocked();
        }
        EventLogTags.writeAmSwitchUser(newUserId);
        this.getUserManagerLocked().onUserForeground(newUserId);
        this.sendUserSwitchBroadcastsLocked(oldUserId, newUserId);
    }

    void continueUserSwitch(UserState uss, int oldUserId, int newUserId) {
        this.completeSwitchAndInitialize(uss, newUserId, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void completeSwitchAndInitialize(UserState uss, int newUserId, boolean clearInitializing, boolean clearSwitching) {
        boolean unfrozen = false;
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (clearInitializing) {
                uss.initializing = false;
                this.getUserManagerLocked().makeInitialized(uss.mHandle.getIdentifier());
            }
            if (clearSwitching) {
                uss.switching = false;
            }
            if (!uss.switching && !uss.initializing) {
                this.mWindowManager.stopFreezingScreen();
                unfrozen = true;
            }
        }
        if (unfrozen) {
            this.mHandler.removeMessages(56);
            this.mHandler.sendMessage(this.mHandler.obtainMessage(56, newUserId, 0));
        }
        this.stopGuestUserIfBackground();
    }

    void dispatchUserSwitchComplete(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitchComplete(userId);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopGuestUserIfBackground() {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int num = this.mUserLru.size();
            for (int i = 0; i < num; ++i) {
                UserInfo userInfo;
                Integer oldUserId = this.mUserLru.get(i);
                UserState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId || oldUss.mState == 2 || oldUss.mState == 3 || !(userInfo = this.mUserManager.getUserInfo(oldUserId)).isGuest()) continue;
                this.stopUserLocked(oldUserId, null);
                break;
            }
        }
    }

    void scheduleStartProfilesLocked() {
        if (!this.mHandler.hasMessages(40)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(40), 1000L);
        }
    }

    void startProfilesLocked() {
        int i;
        List<UserInfo> profiles = this.getUserManagerLocked().getProfiles(this.mCurrentUserId, false);
        ArrayList<UserInfo> toStart = new ArrayList<UserInfo>(profiles.size());
        for (UserInfo user : profiles) {
            if ((user.flags & 0x10) != 16 || user.id == this.mCurrentUserId) continue;
            toStart.add(user);
        }
        int n = toStart.size();
        for (i = 0; i < n && i < 2; ++i) {
            this.startUserInBackground(((UserInfo)toStart.get((int)i)).id);
        }
        if (i < n) {
            Slog.w(TAG_MU, "More profiles than MAX_RUNNING_USERS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserBoot(UserState uss) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            if (uss.mState == 0 && this.mStartedUsers.get(uss.mHandle.getIdentifier()) == uss) {
                uss.mState = 1;
                int userId = uss.mHandle.getIdentifier();
                Intent intent = new Intent("android.intent.action.BOOT_COMPLETED", null);
                intent.putExtra("android.intent.extra.user_handle", userId);
                intent.addFlags(0x8000000);
                this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, MY_PID, 1000, userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserSwitch(UserState uss) {
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            this.finishUserBoot(uss);
            this.startProfilesLocked();
            int num = this.mUserLru.size();
            int i = 0;
            while (num > 3 && i < this.mUserLru.size()) {
                Integer oldUserId = this.mUserLru.get(i);
                UserState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUss == null) {
                    this.mUserLru.remove(i);
                    --num;
                    continue;
                }
                if (oldUss.mState == 2 || oldUss.mState == 3) {
                    --num;
                    ++i;
                    continue;
                }
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId) {
                    ++i;
                    continue;
                }
                this.stopUserLocked(oldUserId, null);
                --num;
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopUser(int userId, IStopUserCallback callback) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        if (userId < 0 || userId == 0) {
            throw new IllegalArgumentException("Can't stop primary user " + userId);
        }
        this.enforceShellRestriction("no_debugging_features", userId);
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.stopUserLocked(userId, callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stopUserLocked(final int userId, final IStopUserCallback callback) {
        if (this.mCurrentUserId == userId && this.mTargetUserId == -10000) {
            return -2;
        }
        final UserState uss = this.mStartedUsers.get(userId);
        if (uss == null) {
            if (callback != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.userStopped(userId);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            return 0;
        }
        if (callback != null) {
            uss.mStopCallbacks.add(callback);
        }
        if (uss.mState != 2 && uss.mState != 3) {
            uss.mState = 2;
            this.updateStartedUserArrayLocked();
            long ident = Binder.clearCallingIdentity();
            try {
                Intent stoppingIntent = new Intent("android.intent.action.USER_STOPPING");
                stoppingIntent.addFlags(0x40000000);
                stoppingIntent.putExtra("android.intent.extra.user_handle", userId);
                stoppingIntent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
                final Intent shutdownIntent = new Intent("android.intent.action.ACTION_SHUTDOWN");
                final IIntentReceiver.Stub shutdownReceiver = new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        ActivityManagerService.this.finishUserStop(uss);
                    }
                };
                IIntentReceiver.Stub stoppingReceiver = new IIntentReceiver.Stub(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        ActivityManagerService activityManagerService = ActivityManagerService.this;
                        synchronized (activityManagerService) {
                            if (uss.mState != 2) {
                                return;
                            }
                            uss.mState = 3;
                        }
                        ActivityManagerService.this.mBatteryStatsService.noteEvent(16391, Integer.toString(userId), userId);
                        ActivityManagerService.this.mSystemServiceManager.stopUser(userId);
                        ActivityManagerService.this.broadcastIntentLocked(null, null, shutdownIntent, null, shutdownReceiver, 0, null, null, null, -1, null, true, false, MY_PID, 1000, userId);
                    }
                };
                this.broadcastIntentLocked(null, null, stoppingIntent, null, stoppingReceiver, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, MY_PID, 1000, -1);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStop(UserState uss) {
        boolean stopped;
        ArrayList<IStopUserCallback> callbacks;
        int userId = uss.mHandle.getIdentifier();
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            callbacks = new ArrayList<IStopUserCallback>(uss.mStopCallbacks);
            if (this.mStartedUsers.get(userId) != uss) {
                stopped = false;
            } else if (uss.mState != 3) {
                stopped = false;
            } else {
                stopped = true;
                this.mStartedUsers.remove(userId);
                this.mUserLru.remove((Object)userId);
                this.updateStartedUserArrayLocked();
                this.forceStopUserLocked(userId, "finish user");
            }
            this.mRecentTasks.removeTasksForUserLocked(userId);
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                if (stopped) {
                    callbacks.get(i).userStopped(userId);
                    continue;
                }
                callbacks.get(i).userStopAborted(userId);
                continue;
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        if (stopped) {
            this.mSystemServiceManager.cleanupUser(userId);
            ActivityManagerService activityManagerService2 = this;
            synchronized (activityManagerService2) {
                this.mStackSupervisor.removeUserLocked(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserInfo getCurrentUser() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: getCurrentUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            int userId = this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
            return this.getUserManagerLocked().getUserInfo(userId);
        }
    }

    int getCurrentUserIdLocked() {
        return this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUserRunning(int userId, boolean orStopped) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.isUserRunningLocked(userId, orStopped);
        }
    }

    boolean isUserRunningLocked(int userId, boolean orStopped) {
        UserState state = this.mStartedUsers.get(userId);
        if (state == null) {
            return false;
        }
        if (orStopped) {
            return true;
        }
        return state.mState != 2 && state.mState != 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getRunningUserIds() {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0) {
            String msg = "Permission Denial: isUserRunning() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        ActivityManagerService activityManagerService = this;
        synchronized (activityManagerService) {
            return this.mStartedUserArray;
        }
    }

    private void updateStartedUserArrayLocked() {
        UserState uss;
        int i;
        int num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.mState == 2 || uss.mState == 3) continue;
            ++num;
        }
        this.mStartedUserArray = new int[num];
        num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.mState == 2 || uss.mState == 3) continue;
            this.mStartedUserArray[num] = this.mStartedUsers.keyAt(i);
            ++num;
        }
    }

    @Override
    public void registerUserSwitchObserver(IUserSwitchObserver observer) {
        if (this.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: registerUserSwitchObserver() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w("ActivityManager", msg);
            throw new SecurityException(msg);
        }
        this.mUserSwitchObservers.register(observer);
    }

    @Override
    public void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserSwitchObservers.unregister(observer);
    }

    int[] getUsersLocked() {
        int[] nArray;
        UserManagerService ums = this.getUserManagerLocked();
        if (ums != null) {
            nArray = ums.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    UserManagerService getUserManagerLocked() {
        if (this.mUserManager == null) {
            IBinder b = ServiceManager.getService("user");
            this.mUserManager = (UserManagerService)IUserManager.Stub.asInterface(b);
        }
        return this.mUserManager;
    }

    private int applyUserId(int uid, int userId) {
        return UserHandle.getUid(userId, uid);
    }

    ApplicationInfo getAppInfoForUser(ApplicationInfo info, int userId) {
        if (info == null) {
            return null;
        }
        ApplicationInfo newInfo = new ApplicationInfo(info);
        newInfo.uid = this.applyUserId(info.uid, userId);
        newInfo.dataDir = Environment.getDataUserPackageDirectory(info.volumeUuid, userId, info.packageName).getAbsolutePath();
        return newInfo;
    }

    ActivityInfo getActivityInfoForUser(ActivityInfo aInfo, int userId) {
        if (aInfo == null || userId < 1 && aInfo.applicationInfo.uid < 100000) {
            return aInfo;
        }
        ActivityInfo info = new ActivityInfo(aInfo);
        info.applicationInfo = this.getAppInfoForUser(info.applicationInfo, userId);
        return info;
    }

    class AppTaskImpl
    extends IAppTask.Stub {
        private int mTaskId;
        private int mCallingUid;

        public AppTaskImpl(int taskId, int callingUid) {
            this.mTaskId = taskId;
            this.mCallingUid = callingUid;
        }

        private void checkCaller() {
            if (this.mCallingUid != Binder.getCallingUid()) {
                throw new SecurityException("Caller " + this.mCallingUid + " does not match caller of getAppTasks(): " + Binder.getCallingUid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finishAndRemoveTask() {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    if (!ActivityManagerService.this.removeTaskByIdLocked(this.mTaskId, false)) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityManager.RecentTaskInfo getTaskInfo() {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManager.RecentTaskInfo recentTaskInfo;
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    recentTaskInfo = ActivityManagerService.this.createRecentTaskInfoFromTaskRecord(tr);
                }
                catch (Throwable throwable) {
                    Binder.restoreCallingIdentity(origId);
                    throw throwable;
                }
                Binder.restoreCallingIdentity(origId);
                return recentTaskInfo;
            }
        }

        @Override
        public void moveToFront() {
            this.checkCaller();
            ActivityManagerService.this.startActivityFromRecentsInner(this.mTaskId, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int startActivity(IBinder whoThread, String callingPackage, Intent intent, String resolvedType, Bundle options) {
            IApplicationThread appThread;
            TaskRecord tr;
            this.checkCaller();
            int callingUser = UserHandle.getCallingUserId();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                if (tr == null) {
                    throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                }
                appThread = ApplicationThreadNative.asInterface(whoThread);
                if (appThread == null) {
                    throw new IllegalArgumentException("Bad app thread " + appThread);
                }
            }
            return ActivityManagerService.this.mStackSupervisor.startActivityMayWait(appThread, -1, callingPackage, intent, resolvedType, null, null, null, null, 0, 0, null, null, null, options, false, callingUser, null, tr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setExcludeFromRecents(boolean exclude) {
            this.checkCaller();
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    TaskRecord tr = ActivityManagerService.this.mStackSupervisor.anyTaskForIdLocked(this.mTaskId);
                    if (tr == null) {
                        throw new IllegalArgumentException("Unable to find task ID " + this.mTaskId);
                    }
                    Intent intent = tr.getBaseIntent();
                    if (exclude) {
                        intent.addFlags(0x800000);
                    } else {
                        intent.setFlags(intent.getFlags() & 0xFF7FFFFF);
                    }
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }
    }

    private final class SleepTokenImpl
    extends ActivityManagerInternal.SleepToken {
        private final String mTag;
        private final long mAcquireTime;

        public SleepTokenImpl(String tag) {
            this.mTag = tag;
            this.mAcquireTime = SystemClock.uptimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                if (ActivityManagerService.this.mSleepTokens.remove(this)) {
                    ActivityManagerService.this.updateSleepIfNeededLocked();
                }
            }
        }

        public String toString() {
            return "{\"" + this.mTag + "\", acquire at " + TimeUtils.formatUptime(this.mAcquireTime) + "}";
        }
    }

    private final class LocalService
    extends ActivityManagerInternal {
        private LocalService() {
        }

        @Override
        public void onWakefulnessChanged(int wakefulness) {
            ActivityManagerService.this.onWakefulnessChanged(wakefulness);
        }

        @Override
        public int startIsolatedProcess(String entryPoint, String[] entryPointArgs, String processName, String abiOverride, int uid, Runnable crashHandler) {
            return ActivityManagerService.this.startIsolatedProcess(entryPoint, entryPointArgs, processName, abiOverride, uid, crashHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ActivityManagerInternal.SleepToken acquireSleepToken(String tag) {
            Preconditions.checkNotNull(tag);
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                SleepTokenImpl token = new SleepTokenImpl(tag);
                ActivityManagerService.this.mSleepTokens.add(token);
                ActivityManagerService.this.updateSleepIfNeededLocked();
                return token;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ComponentName getHomeActivityForUser(int userId) {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityRecord homeActivity = ActivityManagerService.this.mStackSupervisor.getHomeActivityForUser(userId);
                return homeActivity == null ? null : homeActivity.realActivity;
            }
        }
    }

    static final class MemItem {
        final boolean isProc;
        final String label;
        final String shortLabel;
        final long pss;
        final int id;
        final boolean hasActivities;
        ArrayList<MemItem> subitems;

        public MemItem(String _label, String _shortLabel, long _pss, int _id, boolean _hasActivities) {
            this.isProc = true;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.id = _id;
            this.hasActivities = _hasActivities;
        }

        public MemItem(String _label, String _shortLabel, long _pss, int _id) {
            this.isProc = false;
            this.label = _label;
            this.shortLabel = _shortLabel;
            this.pss = _pss;
            this.id = _id;
            this.hasActivities = false;
        }
    }

    static class ItemMatcher {
        ArrayList<ComponentName> components;
        ArrayList<String> strings;
        ArrayList<Integer> objects;
        boolean all = true;

        ItemMatcher() {
        }

        void build(String name) {
            ComponentName componentName = ComponentName.unflattenFromString(name);
            if (componentName != null) {
                if (this.components == null) {
                    this.components = new ArrayList();
                }
                this.components.add(componentName);
                this.all = false;
            } else {
                int objectId = 0;
                try {
                    objectId = Integer.parseInt(name, 16);
                    if (this.objects == null) {
                        this.objects = new ArrayList();
                    }
                    this.objects.add(objectId);
                    this.all = false;
                }
                catch (RuntimeException e) {
                    if (this.strings == null) {
                        this.strings = new ArrayList();
                    }
                    this.strings.add(name);
                    this.all = false;
                }
            }
        }

        int build(String[] args, int opti) {
            while (opti < args.length) {
                String name = args[opti];
                if ("--".equals(name)) {
                    return opti + 1;
                }
                this.build(name);
                ++opti;
            }
            return opti;
        }

        boolean match(Object object, ComponentName comp) {
            int i;
            if (this.all) {
                return true;
            }
            if (this.components != null) {
                for (i = 0; i < this.components.size(); ++i) {
                    if (!this.components.get(i).equals(comp)) continue;
                    return true;
                }
            }
            if (this.objects != null) {
                for (i = 0; i < this.objects.size(); ++i) {
                    if (System.identityHashCode(object) != this.objects.get(i)) continue;
                    return true;
                }
            }
            if (this.strings != null) {
                String flat = comp.flattenToString();
                for (int i2 = 0; i2 < this.strings.size(); ++i2) {
                    if (!flat.contains(this.strings.get(i2))) continue;
                    return true;
                }
            }
            return false;
        }
    }

    final class PreBootContinuation
    extends IIntentReceiver.Stub {
        final Intent intent;
        final Runnable onFinishCallback;
        final ArrayList<ComponentName> doneReceivers;
        final List<ResolveInfo> ris;
        final int[] users;
        int lastRi = -1;
        int curRi = 0;
        int curUser = 0;

        PreBootContinuation(Intent _intent, Runnable _onFinishCallback, ArrayList<ComponentName> _doneReceivers, List<ResolveInfo> _ris, int[] _users) {
            this.intent = _intent;
            this.onFinishCallback = _onFinishCallback;
            this.doneReceivers = _doneReceivers;
            this.ris = _ris;
            this.users = _users;
        }

        void go() {
            if (this.lastRi != this.curRi) {
                ActivityInfo ai = this.ris.get((int)this.curRi).activityInfo;
                ComponentName comp = new ComponentName(ai.packageName, ai.name);
                this.intent.setComponent(comp);
                this.doneReceivers.add(comp);
                this.lastRi = this.curRi;
                CharSequence label = ai.loadLabel(ActivityManagerService.this.mContext.getPackageManager());
                ActivityManagerService.this.showBootMessage(ActivityManagerService.this.mContext.getString(17040239, label), false);
            }
            Slog.i("ActivityManager", "Pre-boot of " + this.intent.getComponent().toShortString() + " for user " + this.users[this.curUser]);
            EventLogTags.writeAmPreBoot(this.users[this.curUser], this.intent.getComponent().getPackageName());
            ActivityManagerService.this.broadcastIntentLocked(null, null, this.intent, null, this, 0, null, null, null, -1, null, true, false, MY_PID, 1000, this.users[this.curUser]);
        }

        @Override
        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
            ++this.curUser;
            if (this.curUser >= this.users.length) {
                this.curUser = 0;
                ++this.curRi;
                if (this.curRi >= this.ris.size()) {
                    if (this.onFinishCallback != null) {
                        ActivityManagerService.this.mHandler.post(this.onFinishCallback);
                    }
                    return;
                }
            }
            this.go();
        }
    }

    static class NeededUriGrants
    extends ArrayList<GrantUri> {
        final String targetPkg;
        final int targetUid;
        final int flags;

        NeededUriGrants(String targetPkg, int targetUid, int flags) {
            this.targetPkg = targetPkg;
            this.targetUid = targetUid;
            this.flags = flags;
        }
    }

    class IntentFirewallInterface
    implements IntentFirewall.AMSInterface {
        IntentFirewallInterface() {
        }

        @Override
        public int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return ActivityManagerService.this.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        @Override
        public Object getAMSLock() {
            return ActivityManagerService.this;
        }
    }

    static class PermissionController
    extends IPermissionController.Stub {
        ActivityManagerService mActivityManagerService;

        PermissionController(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public boolean checkPermission(String permission2, int pid, int uid) {
            return this.mActivityManagerService.checkPermission(permission2, pid, uid) == 0;
        }

        @Override
        public String[] getPackagesForUid(int uid) {
            return this.mActivityManagerService.mContext.getPackageManager().getPackagesForUid(uid);
        }

        @Override
        public boolean isRuntimePermission(String permission2) {
            try {
                PermissionInfo info = this.mActivityManagerService.mContext.getPackageManager().getPermissionInfo(permission2, 0);
                return info.protectionLevel == 1;
            }
            catch (PackageManager.NameNotFoundException nnfe) {
                Slog.e("ActivityManager", "No such permission: " + permission2, nnfe);
                return false;
            }
        }
    }

    static class ProcessInfoService
    extends IProcessInfoService.Stub {
        final ActivityManagerService mActivityManagerService;

        ProcessInfoService(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        public void getProcessStatesFromPids(int[] pids, int[] states) {
            this.mActivityManagerService.getProcessStatesForPIDs(pids, states);
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final ActivityManagerService mService;

        public Lifecycle(Context context) {
            super(context);
            this.mService = new ActivityManagerService(context);
        }

        @Override
        public void onStart() {
            this.mService.start();
        }

        public ActivityManagerService getService() {
            return this.mService;
        }
    }

    static class CpuBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        CpuBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump cpuinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            ProcessCpuTracker processCpuTracker = this.mActivityManagerService.mProcessCpuTracker;
            synchronized (processCpuTracker) {
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentLoad());
                pw.print(this.mActivityManagerService.mProcessCpuTracker.printCurrentState(SystemClock.uptimeMillis()));
            }
        }
    }

    static class DbBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        DbBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump dbinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpDbInfo(fd, pw, args);
        }
    }

    static class GraphicsBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        GraphicsBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump gfxinfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpGraphicsHardwareUsage(fd, pw, args);
        }
    }

    static class MemBinder
    extends Binder {
        ActivityManagerService mActivityManagerService;

        MemBinder(ActivityManagerService activityManagerService) {
            this.mActivityManagerService = activityManagerService;
        }

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (this.mActivityManagerService.checkCallingPermission("android.permission.DUMP") != 0) {
                pw.println("Permission Denial: can't dump meminfo from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
                return;
            }
            this.mActivityManagerService.dumpApplicationMemoryUsage(fd, pw, "  ", args, false, null);
        }
    }

    final class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 4: {
                    ContentResolver resolver = ActivityManagerService.this.mContext.getContentResolver();
                    Settings.System.putConfiguration(resolver, (Configuration)msg.obj);
                    break;
                }
                case 5: {
                    ActivityManagerService resolver = ActivityManagerService.this;
                    synchronized (resolver) {
                        ActivityManagerService.this.performAppGcsIfAppropriateLocked();
                        break;
                    }
                }
                case 12: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(12);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 20000L);
                        return;
                    }
                    ActivityManagerService.this.mServices.serviceTimeout((ProcessRecord)msg.obj);
                    break;
                }
                case 13: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.updateTimeZone();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update time zone for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 28: {
                    ActivityManagerService nmsg = ActivityManagerService.this;
                    synchronized (nmsg) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.clearDnsCache();
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to clear dns cache for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 29: {
                    ProxyInfo proxy = (ProxyInfo)msg.obj;
                    String host = "";
                    String port = "";
                    String exclList = "";
                    Uri pacFileUrl = Uri.EMPTY;
                    if (proxy != null) {
                        host = proxy.getHost();
                        port = Integer.toString(proxy.getPort());
                        exclList = proxy.getExclusionListAsString();
                        pacFileUrl = proxy.getPacFileUrl();
                    }
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.setHttpProxy(host, port, exclList, pacFileUrl);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update http proxy for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 20: {
                    if (ActivityManagerService.this.mDidDexOpt) {
                        ActivityManagerService.this.mDidDexOpt = false;
                        Message nmsg = ActivityManagerService.this.mHandler.obtainMessage(20);
                        nmsg.obj = msg.obj;
                        ActivityManagerService.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    ProcessRecord app = (ProcessRecord)msg.obj;
                    ActivityManagerService host = ActivityManagerService.this;
                    synchronized (host) {
                        ActivityManagerService.this.processStartTimedOutLocked(app);
                        break;
                    }
                }
                case 21: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        ActivityManagerService.this.mStackSupervisor.doPendingActivityLaunchesLocked(true);
                        break;
                    }
                }
                case 22: {
                    ActivityManagerService app = ActivityManagerService.this;
                    synchronized (app) {
                        int appid = msg.arg1;
                        boolean restart = msg.arg2 == 1;
                        Bundle bundle = (Bundle)msg.obj;
                        String pkg = bundle.getString("pkg");
                        String reason = bundle.getString("reason");
                        ActivityManagerService.this.forceStopPackageLocked(pkg, appid, restart, false, true, false, false, -1, reason);
                        break;
                    }
                }
                case 23: {
                    ((PendingIntentRecord)msg.obj).completeFinalize();
                    break;
                }
                case 24: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    ActivityRecord root = (ActivityRecord)msg.obj;
                    ProcessRecord process = root.app;
                    if (process == null) {
                        return;
                    }
                    try {
                        Context context = ActivityManagerService.this.mContext.createPackageContext(process.info.packageName, 0);
                        String text = ActivityManagerService.this.mContext.getString(17040242, context.getApplicationInfo().loadLabel(context.getPackageManager()));
                        Notification notification = new Notification.Builder(context).setSmallIcon(17303106).setWhen(0L).setOngoing(true).setTicker(text).setColor(ActivityManagerService.this.mContext.getColor(17170521)).setContentTitle(text).setContentText(ActivityManagerService.this.mContext.getText(17040243)).setContentIntent(PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, root.intent, 0x10000000, null, new UserHandle(root.userId))).build();
                        try {
                            int[] outId = new int[1];
                            inm.enqueueNotificationWithTag("android", "android", null, 17040242, notification, outId, root.userId);
                        }
                        catch (RuntimeException e) {
                            Slog.w("ActivityManager", "Error showing notification for heavy-weight app", e);
                        }
                        catch (RemoteException e) {
                        }
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w("ActivityManager", "Unable to create context for heavy notification", e);
                    }
                    break;
                }
                case 25: {
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    try {
                        inm.cancelNotificationWithTag("android", null, 17040242, msg.arg1);
                    }
                    catch (RuntimeException e) {
                        Slog.w("ActivityManager", "Error canceling notification for service", e);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 27: {
                    ActivityManagerService inm = ActivityManagerService.this;
                    synchronized (inm) {
                        ActivityManagerService.this.checkExcessivePowerUsageLocked(true);
                        this.removeMessages(27);
                        Message nmsg = this.obtainMessage(27);
                        this.sendMessageDelayed(nmsg, 900000L);
                        break;
                    }
                }
                case 33: {
                    final ArrayList memInfos = (ArrayList)msg.obj;
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            ActivityManagerService.this.reportMemUsage(memInfos);
                        }
                    };
                    thread.start();
                    break;
                }
                case 34: {
                    ActivityManagerService.this.dispatchUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 35: {
                    ActivityManagerService.this.continueUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 36: {
                    ActivityManagerService.this.timeoutUserSwitch((UserState)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 37: {
                    boolean nextState;
                    boolean bl = nextState = msg.arg1 != 0;
                    if (ActivityManagerService.this.mUpdateLock.isHeld() == nextState) break;
                    if (nextState) {
                        ActivityManagerService.this.mUpdateLock.acquire();
                        break;
                    }
                    ActivityManagerService.this.mUpdateLock.release();
                    break;
                }
                case 38: {
                    ActivityManagerService.this.writeGrantedUriPermissions();
                    break;
                }
                case 39: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        ActivityManagerService.this.requestPssAllProcsLocked(SystemClock.uptimeMillis(), true, false);
                        break;
                    }
                }
                case 40: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        ActivityManagerService.this.startProfilesLocked();
                        break;
                    }
                }
                case 41: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        for (int i = ActivityManagerService.this.mLruProcesses.size() - 1; i >= 0; --i) {
                            ProcessRecord r = ActivityManagerService.this.mLruProcesses.get(i);
                            if (r.thread == null) continue;
                            try {
                                r.thread.updateTimePrefs(msg.arg1 != 0);
                                continue;
                            }
                            catch (RemoteException ex) {
                                Slog.w("ActivityManager", "Failed to update preferences for: " + r.info.processName);
                            }
                        }
                        break;
                    }
                }
                case 42: {
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(32775, Integer.toString(msg.arg1), msg.arg1);
                    ActivityManagerService.this.mSystemServiceManager.startUser(msg.arg1);
                    break;
                }
                case 43: {
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(16392, Integer.toString(msg.arg2), msg.arg2);
                    ActivityManagerService.this.mBatteryStatsService.noteEvent(32776, Integer.toString(msg.arg1), msg.arg1);
                    ActivityManagerService.this.mSystemServiceManager.switchUser(msg.arg1);
                    break;
                }
                case 44: {
                    ActivityManagerService nextState = ActivityManagerService.this;
                    synchronized (nextState) {
                        ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                        if (r != null && r.app != null && r.app.thread != null) {
                            try {
                                r.app.thread.scheduleEnterAnimationComplete(r.appToken);
                            }
                            catch (RemoteException e) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                }
                case 45: {
                    if (msg.arg1 != 0) {
                        ActivityManagerService.this.finishBooting();
                    }
                    if (msg.arg2 == 0) break;
                    ActivityManagerService.this.enableScreenAfterBoot();
                    break;
                }
                case 47: {
                    try {
                        Locale l = (Locale)msg.obj;
                        IBinder service = ServiceManager.getService("mount");
                        IMountService mountService = IMountService.Stub.asInterface(service);
                        Log.d("ActivityManager", "Storing locale " + l.toLanguageTag() + " for decryption UI");
                        mountService.setField("SystemLocale", l.toLanguageTag());
                    }
                    catch (RemoteException e) {
                        Log.e("ActivityManager", "Error storing locale for decryption UI", e);
                    }
                    break;
                }
                case 49: {
                    ActivityManagerService e = ActivityManagerService.this;
                    synchronized (e) {
                        int i = ActivityManagerService.this.mTaskStackListeners.beginBroadcast();
                        while (i > 0) {
                            --i;
                            try {
                                ((ITaskStackListener)ActivityManagerService.this.mTaskStackListeners.getBroadcastItem(i)).onTaskStackChanged();
                            }
                            catch (RemoteException e2) {}
                        }
                        ActivityManagerService.this.mTaskStackListeners.finishBroadcast();
                        break;
                    }
                }
                case 50: {
                    int uid = msg.arg1;
                    byte[] firstPacket = (byte[])msg.obj;
                    SparseArray<ProcessRecord> e2 = ActivityManagerService.this.mPidsSelfLocked;
                    synchronized (e2) {
                        for (int i = 0; i < ActivityManagerService.this.mPidsSelfLocked.size(); ++i) {
                            ProcessRecord p = ActivityManagerService.this.mPidsSelfLocked.valueAt(i);
                            if (p.uid != uid) continue;
                            try {
                                p.thread.notifyCleartextNetwork(firstPacket);
                                continue;
                            }
                            catch (RemoteException ignored) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                }
                case 51: {
                    String reportPackage;
                    long memLimit;
                    int uid;
                    String procName;
                    ActivityManagerService ignored = ActivityManagerService.this;
                    synchronized (ignored) {
                        procName = ActivityManagerService.this.mMemWatchDumpProcName;
                        uid = ActivityManagerService.this.mMemWatchDumpUid;
                        Pair<Long, String> val = ActivityManagerService.this.mMemWatchProcesses.get(procName, uid);
                        if (val == null) {
                            val = ActivityManagerService.this.mMemWatchProcesses.get(procName, 0);
                        }
                        if (val != null) {
                            memLimit = (Long)val.first;
                            reportPackage = (String)val.second;
                        } else {
                            memLimit = 0L;
                            reportPackage = null;
                        }
                    }
                    if (procName == null) {
                        return;
                    }
                    INotificationManager inm = NotificationManager.getService();
                    if (inm == null) {
                        return;
                    }
                    String text = ActivityManagerService.this.mContext.getString(17040250, procName);
                    Intent deleteIntent = new Intent();
                    deleteIntent.setAction("com.android.server.am.DELETE_DUMPHEAP");
                    Intent intent = new Intent();
                    intent.setClassName("android", DumpHeapActivity.class.getName());
                    intent.putExtra("process", procName);
                    intent.putExtra("size", memLimit);
                    if (reportPackage != null) {
                        intent.putExtra("direct_launch", reportPackage);
                    }
                    int userId = UserHandle.getUserId(uid);
                    Notification notification = new Notification.Builder(ActivityManagerService.this.mContext).setSmallIcon(17303106).setWhen(0L).setOngoing(true).setAutoCancel(true).setTicker(text).setColor(ActivityManagerService.this.mContext.getColor(17170521)).setContentTitle(text).setContentText(ActivityManagerService.this.mContext.getText(17040251)).setContentIntent(PendingIntent.getActivityAsUser(ActivityManagerService.this.mContext, 0, intent, 0x10000000, null, new UserHandle(userId))).setDeleteIntent(PendingIntent.getBroadcastAsUser(ActivityManagerService.this.mContext, 0, deleteIntent, 0, UserHandle.OWNER)).build();
                    try {
                        int[] outId = new int[1];
                        inm.enqueueNotificationWithTag("android", "android", null, 17040250, notification, outId, userId);
                    }
                    catch (RuntimeException e) {
                        Slog.w("ActivityManager", "Error showing notification for dump heap", e);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 52: {
                    ActivityManagerService.this.revokeUriPermission(ActivityThread.currentActivityThread().getApplicationThread(), DumpHeapActivity.JAVA_URI, 3, UserHandle.myUserId());
                    ActivityManagerService procName = ActivityManagerService.this;
                    synchronized (procName) {
                        ActivityManagerService.this.mMemWatchDumpFile = null;
                        ActivityManagerService.this.mMemWatchDumpProcName = null;
                        ActivityManagerService.this.mMemWatchDumpPid = -1;
                        ActivityManagerService.this.mMemWatchDumpUid = -1;
                        break;
                    }
                }
                case 53: {
                    ActivityManagerService.this.dispatchForegroundProfileChanged(msg.arg1);
                    break;
                }
                case 55: {
                    AppTimeTracker tracker = (AppTimeTracker)msg.obj;
                    tracker.deliverResult(ActivityManagerService.this.mContext);
                    break;
                }
                case 56: {
                    ActivityManagerService.this.dispatchUserSwitchComplete(msg.arg1);
                    break;
                }
                case 57: {
                    IUiAutomationConnection connection = (IUiAutomationConnection)msg.obj;
                    try {
                        connection.shutdown();
                    }
                    catch (RemoteException e) {
                        Slog.w("ActivityManager", "Error shutting down UiAutomationConnection");
                    }
                    ActivityManagerService.this.mUserIsMonkey = false;
                }
            }
        }
    }

    final class UiHandler
    extends Handler {
        public UiHandler() {
            super(UiThread.get().getLooper(), null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    HashMap data = (HashMap)msg.obj;
                    boolean showBackground = Settings.Secure.getInt(ActivityManagerService.this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
                    ActivityManagerService activityManagerService = ActivityManagerService.this;
                    synchronized (activityManagerService) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (proc != null && proc.crashDialog != null) {
                            Slog.e("ActivityManager", "App already has crash dialog: " + proc);
                            if (res != null) {
                                res.set(0);
                            }
                            return;
                        }
                        boolean isBackground = UserHandle.getAppId(proc.uid) >= 10000 && proc.pid != MY_PID;
                        for (int userId : ActivityManagerService.this.mCurrentProfileIds) {
                            isBackground &= proc.userId != userId;
                        }
                        if (isBackground && !showBackground) {
                            Slog.w("ActivityManager", "Skipping crash dialog of " + proc + ": background");
                            if (res != null) {
                                res.set(0);
                            }
                            return;
                        }
                        if (ActivityManagerService.this.mShowDialogs && !ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            AppErrorDialog d = new AppErrorDialog(ActivityManagerService.this.mContext, ActivityManagerService.this, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else if (res != null) {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 2: {
                    ActivityManagerService data = ActivityManagerService.this;
                    synchronized (data) {
                        HashMap data2 = (HashMap)msg.obj;
                        ProcessRecord proc = (ProcessRecord)data2.get("app");
                        if (proc != null && proc.anrDialog != null) {
                            Slog.e("ActivityManager", "App already has anr dialog: " + proc);
                            return;
                        }
                        Intent intent = new Intent("android.intent.action.ANR");
                        if (!ActivityManagerService.this.mProcessesReady) {
                            intent.addFlags(0x50000000);
                        }
                        ActivityManagerService.this.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, MY_PID, 1000, 0);
                        if (ActivityManagerService.this.mShowDialogs) {
                            AppNotRespondingDialog d = new AppNotRespondingDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, proc, (ActivityRecord)data2.get("activity"), msg.arg1 != 0);
                            d.show();
                            proc.anrDialog = d;
                        } else {
                            ActivityManagerService.this.killAppAtUsersRequest(proc, null);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 26: {
                    HashMap data = (HashMap)msg.obj;
                    ActivityManagerService data2 = ActivityManagerService.this;
                    synchronized (data2) {
                        ProcessRecord proc = (ProcessRecord)data.get("app");
                        if (proc == null) {
                            Slog.e("ActivityManager", "App not found when showing strict mode dialog.");
                            break;
                        }
                        if (proc.crashDialog != null) {
                            Slog.e("ActivityManager", "App already has strict mode dialog: " + proc);
                            return;
                        }
                        AppErrorResult res = (AppErrorResult)data.get("result");
                        if (ActivityManagerService.this.mShowDialogs && !ActivityManagerService.this.mSleeping && !ActivityManagerService.this.mShuttingDown) {
                            StrictModeViolationDialog d = new StrictModeViolationDialog(ActivityManagerService.this.mContext, ActivityManagerService.this, res, proc);
                            d.show();
                            proc.crashDialog = d;
                        } else {
                            res.set(0);
                        }
                    }
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 3: {
                    FactoryErrorDialog d = new FactoryErrorDialog(ActivityManagerService.this.mContext, msg.getData().getCharSequence("msg"));
                    d.show();
                    ActivityManagerService.this.ensureBootCompleted();
                    break;
                }
                case 6: {
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        ProcessRecord app = (ProcessRecord)msg.obj;
                        if (msg.arg1 != 0) {
                            if (!app.waitedForDebugger) {
                                AppWaitingForDebuggerDialog d2 = new AppWaitingForDebuggerDialog(ActivityManagerService.this, ActivityManagerService.this.mContext, app);
                                app.waitDialog = d2;
                                app.waitedForDebugger = true;
                                d2.show();
                            }
                        } else if (app.waitDialog != null) {
                            app.waitDialog.dismiss();
                            app.waitDialog = null;
                        }
                        break;
                    }
                }
                case 14: {
                    if (!ActivityManagerService.this.mShowDialogs) break;
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle(ActivityManagerService.this.mContext.getText(17039641));
                    d.setMessage(ActivityManagerService.this.mContext.getText(17040764));
                    d.setButton(-1, ActivityManagerService.this.mContext.getText(17039370), this.obtainMessage(48, d));
                    d.show();
                    break;
                }
                case 15: {
                    if (!ActivityManagerService.this.mShowDialogs) break;
                    BaseErrorDialog d = new BaseErrorDialog(ActivityManagerService.this.mContext);
                    d.getWindow().setType(2010);
                    d.setCancelable(false);
                    d.setTitle(ActivityManagerService.this.mContext.getText(17039641));
                    d.setMessage(ActivityManagerService.this.mContext.getText(17040765));
                    d.setButton(-1, ActivityManagerService.this.mContext.getText(17039370), this.obtainMessage(48, d));
                    d.show();
                    break;
                }
                case 30: {
                    ActivityManagerService d = ActivityManagerService.this;
                    synchronized (d) {
                        ActivityRecord ar = (ActivityRecord)msg.obj;
                        if (ActivityManagerService.this.mCompatModeDialog != null) {
                            if (ActivityManagerService.this.mCompatModeDialog.mAppInfo.packageName.equals(ar.info.applicationInfo.packageName)) {
                                return;
                            }
                            ActivityManagerService.this.mCompatModeDialog.dismiss();
                            ActivityManagerService.this.mCompatModeDialog = null;
                        }
                        if (ar != null) {
                            // empty if block
                        }
                        break;
                    }
                }
                case 46: {
                    ActivityManagerService.this.showUserSwitchDialog(msg.arg1, (String)msg.obj);
                    break;
                }
                case 48: {
                    Dialog d = (Dialog)msg.obj;
                    d.dismiss();
                    break;
                }
                case 31: {
                    ActivityManagerService.this.dispatchProcessesChanged();
                    break;
                }
                case 32: {
                    int pid = msg.arg1;
                    int uid = msg.arg2;
                    ActivityManagerService.this.dispatchProcessDied(pid, uid);
                    break;
                }
                case 54: {
                    ActivityManagerService.this.dispatchUidsChanged();
                }
            }
        }
    }

    private final class AppDeathRecipient
    implements IBinder.DeathRecipient {
        final ProcessRecord mApp;
        final int mPid;
        final IApplicationThread mAppThread;

        AppDeathRecipient(ProcessRecord app, int pid, IApplicationThread thread) {
            this.mApp = app;
            this.mPid = pid;
            this.mAppThread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            ActivityManagerService activityManagerService = ActivityManagerService.this;
            synchronized (activityManagerService) {
                ActivityManagerService.this.appDiedLocked(this.mApp, this.mPid, this.mAppThread, true);
            }
        }
    }

    static final class ProcessChangeItem {
        static final int CHANGE_ACTIVITIES = 1;
        static final int CHANGE_PROCESS_STATE = 2;
        int changes;
        int uid;
        int pid;
        int processState;
        boolean foregroundActivities;

        ProcessChangeItem() {
        }
    }

    private class Identity {
        public final IBinder token;
        public final int pid;
        public final int uid;

        Identity(IBinder _token, int _pid, int _uid) {
            this.token = _token;
            this.pid = _pid;
            this.uid = _uid;
        }
    }

    public static class GrantUri {
        public final int sourceUserId;
        public final Uri uri;
        public boolean prefix;

        public GrantUri(int sourceUserId, Uri uri, boolean prefix) {
            this.sourceUserId = sourceUserId;
            this.uri = uri;
            this.prefix = prefix;
        }

        public int hashCode() {
            int hashCode = 1;
            hashCode = 31 * hashCode + this.sourceUserId;
            hashCode = 31 * hashCode + this.uri.hashCode();
            hashCode = 31 * hashCode + (this.prefix ? 1231 : 1237);
            return hashCode;
        }

        public boolean equals(Object o) {
            if (o instanceof GrantUri) {
                GrantUri other = (GrantUri)o;
                return this.uri.equals(other.uri) && this.sourceUserId == other.sourceUserId && this.prefix == other.prefix;
            }
            return false;
        }

        public String toString() {
            String result = Integer.toString(this.sourceUserId) + " @ " + this.uri.toString();
            if (this.prefix) {
                result = result + " [prefix]";
            }
            return result;
        }

        public String toSafeString() {
            String result = Integer.toString(this.sourceUserId) + " @ " + this.uri.toSafeString();
            if (this.prefix) {
                result = result + " [prefix]";
            }
            return result;
        }

        public static GrantUri resolve(int defaultSourceUserHandle, Uri uri) {
            return new GrantUri(ContentProvider.getUserIdFromUri(uri, defaultSourceUserHandle), ContentProvider.getUriWithoutUserId(uri), false);
        }
    }

    static final class Association {
        final int mSourceUid;
        final String mSourceProcess;
        final int mTargetUid;
        final ComponentName mTargetComponent;
        final String mTargetProcess;
        int mCount;
        long mTime;
        int mNesting;
        long mStartTime;

        Association(int sourceUid, String sourceProcess, int targetUid, ComponentName targetComponent, String targetProcess) {
            this.mSourceUid = sourceUid;
            this.mSourceProcess = sourceProcess;
            this.mTargetUid = targetUid;
            this.mTargetComponent = targetComponent;
            this.mTargetProcess = targetProcess;
        }
    }

    abstract class ForegroundToken
    implements IBinder.DeathRecipient {
        int pid;
        IBinder token;

        ForegroundToken() {
        }
    }

    static final class BadProcessInfo {
        final long time;
        final String shortMsg;
        final String longMsg;
        final String stack;

        BadProcessInfo(long time, String shortMsg, String longMsg, String stack) {
            this.time = time;
            this.shortMsg = shortMsg;
            this.longMsg = longMsg;
            this.stack = stack;
        }
    }

    public class PendingAssistExtras
    extends Binder
    implements Runnable {
        public final ActivityRecord activity;
        public final Bundle extras;
        public final Intent intent;
        public final String hint;
        public final IResultReceiver receiver;
        public final int userHandle;
        public boolean haveResult = false;
        public Bundle result = null;
        public AssistStructure structure = null;
        public AssistContent content = null;

        public PendingAssistExtras(ActivityRecord _activity, Bundle _extras, Intent _intent, String _hint, IResultReceiver _receiver, int _userHandle) {
            this.activity = _activity;
            this.extras = _extras;
            this.intent = _intent;
            this.hint = _hint;
            this.receiver = _receiver;
            this.userHandle = _userHandle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Slog.w("ActivityManager", "getAssistContextExtras failed: timeout retrieving from " + this.activity);
            PendingAssistExtras pendingAssistExtras = this;
            synchronized (pendingAssistExtras) {
                this.haveResult = true;
                this.notifyAll();
            }
            ActivityManagerService.this.pendingAssistExtrasTimedOut(this);
        }
    }
}

