/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.IActivityManager;
import android.app.IApplicationThread;
import android.app.ProfilerInfo;
import android.app.ResultInfo;
import android.app.admin.IDevicePolicyManager;
import android.content.ComponentName;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Configuration;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.hardware.display.DisplayManagerGlobal;
import android.hardware.display.VirtualDisplay;
import android.hardware.input.InputManagerInternal;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.TransactionTooLargeException;
import android.os.UserHandle;
import android.os.WorkSource;
import android.provider.Settings;
import android.service.voice.IVoiceInteractionSession;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.DisplayInfo;
import android.view.InputEvent;
import android.view.Surface;
import com.android.internal.app.HeavyWeightSwitcherActivity;
import com.android.internal.app.IVoiceInteractor;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.os.TransferPipe;
import com.android.internal.statusbar.IStatusBarService;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.LockTaskNotify;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.RecentTasks;
import com.android.server.am.TaskRecord;
import com.android.server.am.UserState;
import com.android.server.wm.WindowManagerService;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public final class ActivityStackSupervisor
implements DisplayManager.DisplayListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_CONTAINERS = "ActivityManager";
    private static final String TAG_FOCUS = "ActivityManager";
    private static final String TAG_IDLE = "ActivityManager";
    private static final String TAG_LOCKTASK = "ActivityManager";
    private static final String TAG_PAUSE = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_RELEASE = "ActivityManager";
    private static final String TAG_RESULTS = "ActivityManager";
    private static final String TAG_STACK = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final String TAG_VISIBLE_BEHIND = "ActivityManager";
    private static final String TAG_USER_LEAVING = "ActivityManager";
    public static final int HOME_STACK_ID = 0;
    static final int IDLE_TIMEOUT = 10000;
    static final int SLEEP_TIMEOUT = 5000;
    static final int LAUNCH_TIMEOUT = 10000;
    static final int IDLE_TIMEOUT_MSG = 100;
    static final int IDLE_NOW_MSG = 101;
    static final int RESUME_TOP_ACTIVITY_MSG = 102;
    static final int SLEEP_TIMEOUT_MSG = 103;
    static final int LAUNCH_TIMEOUT_MSG = 104;
    static final int HANDLE_DISPLAY_ADDED = 105;
    static final int HANDLE_DISPLAY_CHANGED = 106;
    static final int HANDLE_DISPLAY_REMOVED = 107;
    static final int CONTAINER_CALLBACK_VISIBILITY = 108;
    static final int LOCK_TASK_START_MSG = 109;
    static final int LOCK_TASK_END_MSG = 110;
    static final int CONTAINER_CALLBACK_TASK_LIST_EMPTY = 111;
    static final int LAUNCH_TASK_BEHIND_COMPLETE = 112;
    static final int SHOW_LOCK_TASK_ESCAPE_MESSAGE_MSG = 113;
    private static final String VIRTUAL_DISPLAY_BASE_NAME = "ActivityViewVirtualDisplay";
    private static final String LOCK_TASK_TAG = "Lock-to-App";
    private static final ArrayMap<String, String> ACTION_TO_RUNTIME_PERMISSION = new ArrayMap();
    private static final int ACTIVITY_RESTRICTION_NONE = 0;
    private static final int ACTIVITY_RESTRICTION_PERMISSION = 1;
    private static final int ACTIVITY_RESTRICTION_APPOP = 2;
    private IBinder mToken = new Binder();
    private IStatusBarService mStatusBarService;
    private IDevicePolicyManager mDevicePolicyManager;
    static final boolean VALIDATE_WAKE_LOCK_CALLER = false;
    final ActivityManagerService mService;
    private final RecentTasks mRecentTasks;
    final ActivityStackSupervisorHandler mHandler;
    WindowManagerService mWindowManager;
    DisplayManager mDisplayManager;
    private int mLastStackId = 0;
    private int mCurTaskId = 0;
    private int mCurrentUser;
    private ActivityStack mHomeStack;
    private ActivityStack mFocusedStack;
    private ActivityStack mLastFocusedStack;
    final ArrayList<ActivityRecord> mWaitingVisibleActivities = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityVisible = new ArrayList();
    final ArrayList<IActivityManager.WaitResult> mWaitingActivityLaunched = new ArrayList();
    final ArrayList<ActivityRecord> mStoppingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mFinishingActivities = new ArrayList();
    final ArrayList<ActivityRecord> mGoingToSleepActivities = new ArrayList();
    final ArrayList<UserState> mStartingUsers = new ArrayList();
    final ArrayList<UserState> mStartingBackgroundUsers = new ArrayList();
    boolean mUserLeaving = false;
    boolean mSleepTimeout = false;
    private boolean mLeanbackOnlyDevice;
    PowerManager.WakeLock mLaunchingActivity;
    PowerManager.WakeLock mGoingToSleep;
    SparseIntArray mUserStackInFront = new SparseIntArray(2);
    private SparseArray<ActivityContainer> mActivityContainers = new SparseArray();
    private final SparseArray<ActivityDisplay> mActivityDisplays = new SparseArray();
    InputManagerInternal mInputManagerInternal;
    ArrayList<TaskRecord> mLockTaskModeTasks = new ArrayList();
    private int mLockTaskModeState;
    private LockTaskNotify mLockTaskNotify;
    final ArrayList<PendingActivityLaunch> mPendingActivityLaunches = new ArrayList();
    boolean inResumeTopActivity;

    public ActivityStackSupervisor(ActivityManagerService service, RecentTasks recentTasks) {
        this.mService = service;
        this.mRecentTasks = recentTasks;
        this.mHandler = new ActivityStackSupervisorHandler(this.mService.mHandler.getLooper());
    }

    void initPowerManagement() {
        PowerManager pm = (PowerManager)this.mService.mContext.getSystemService("power");
        this.mGoingToSleep = pm.newWakeLock(1, "ActivityManager-Sleep");
        this.mLaunchingActivity = pm.newWakeLock(1, "*launch*");
        this.mLaunchingActivity.setReferenceCounted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatusBarService getStatusBarService() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mStatusBarService == null) {
                this.mStatusBarService = IStatusBarService.Stub.asInterface(ServiceManager.checkService("statusbar"));
                if (this.mStatusBarService == null) {
                    Slog.w("StatusBarManager", "warning: no STATUS_BAR_SERVICE");
                }
            }
            return this.mStatusBarService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IDevicePolicyManager getDevicePolicyManager() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (this.mDevicePolicyManager == null) {
                this.mDevicePolicyManager = IDevicePolicyManager.Stub.asInterface(ServiceManager.checkService("device_policy"));
                if (this.mDevicePolicyManager == null) {
                    Slog.w("ActivityManager", "warning: no DEVICE_POLICY_SERVICE");
                }
            }
            return this.mDevicePolicyManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWindowManager(WindowManagerService wm) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            this.mWindowManager = wm;
            this.mDisplayManager = (DisplayManager)this.mService.mContext.getSystemService("display");
            this.mDisplayManager.registerDisplayListener(this, null);
            Display[] displays = this.mDisplayManager.getDisplays();
            for (int displayNdx = displays.length - 1; displayNdx >= 0; --displayNdx) {
                int displayId = displays[displayNdx].getDisplayId();
                ActivityDisplay activityDisplay = new ActivityDisplay(displayId);
                if (activityDisplay.mDisplay == null) {
                    throw new IllegalStateException("Default Display does not exist");
                }
                this.mActivityDisplays.put(displayId, activityDisplay);
            }
            this.createStackOnDisplay(0, 0);
            this.mFocusedStack = this.mLastFocusedStack = this.getStack(0);
            this.mHomeStack = this.mLastFocusedStack;
            this.mInputManagerInternal = LocalServices.getService(InputManagerInternal.class);
            this.mLeanbackOnlyDevice = this.isLeanbackOnlyDevice();
        }
    }

    void notifyActivityDrawnForKeyguard() {
        this.mWindowManager.notifyActivityDrawnForKeyguard();
    }

    ActivityStack getFocusedStack() {
        return this.mFocusedStack;
    }

    ActivityStack getLastStack() {
        return this.mLastFocusedStack;
    }

    boolean isFrontStack(ActivityStack stack) {
        if (stack == null) {
            return false;
        }
        ActivityRecord parent = stack.mActivityContainer.mParentActivity;
        if (parent != null) {
            stack = parent.task.stack;
        }
        return stack == this.mFocusedStack;
    }

    void moveHomeStack(boolean toFront, String reason) {
        this.moveHomeStack(toFront, reason, null);
    }

    void moveHomeStack(boolean toFront, String reason, ActivityStack lastFocusedStack) {
        ActivityRecord r;
        ArrayList<ActivityStack> stacks = this.mHomeStack.mStacks;
        int topNdx = stacks.size() - 1;
        if (topNdx <= 0) {
            return;
        }
        if (toFront && stacks.get(topNdx) != this.mHomeStack || !toFront && stacks.get(0) != this.mHomeStack) {
            stacks.remove(this.mHomeStack);
            stacks.add(toFront ? topNdx : 0, this.mHomeStack);
        }
        if (lastFocusedStack != null) {
            this.mLastFocusedStack = lastFocusedStack;
        }
        this.mFocusedStack = stacks.get(topNdx);
        EventLog.writeEvent(30044, this.mCurrentUser, toFront ? 1 : 0, stacks.get(topNdx).getStackId(), this.mFocusedStack == null ? -1 : this.mFocusedStack.getStackId(), reason);
        if ((this.mService.mBooting || !this.mService.mBooted) && (r = this.topRunningActivityLocked()) != null && r.idle) {
            this.checkFinishBootingLocked();
        }
    }

    boolean moveHomeStackTaskToTop(int homeStackTaskType, String reason) {
        if (homeStackTaskType == 2) {
            this.mWindowManager.showRecentApps();
            return false;
        }
        this.mHomeStack.moveHomeStackTaskToTop(homeStackTaskType);
        ActivityRecord top = this.getHomeActivity();
        if (top == null) {
            return false;
        }
        this.mService.setFocusedActivityLocked(top, reason);
        return true;
    }

    boolean resumeHomeStackTask(int homeStackTaskType, ActivityRecord prev, String reason) {
        if (!this.mService.mBooting && !this.mService.mBooted) {
            return false;
        }
        if (homeStackTaskType == 2) {
            this.mWindowManager.showRecentApps();
            return false;
        }
        if (prev != null) {
            prev.task.setTaskToReturnTo(0);
        }
        this.mHomeStack.moveHomeStackTaskToTop(homeStackTaskType);
        ActivityRecord r = this.getHomeActivity();
        if (r != null) {
            this.mService.setFocusedActivityLocked(r, reason);
            return this.resumeTopActivitiesLocked(this.mHomeStack, prev, null);
        }
        return this.mService.startHomeActivityLocked(this.mCurrentUser, reason);
    }

    TaskRecord anyTaskForIdLocked(int id2) {
        return this.anyTaskForIdLocked(id2, true);
    }

    TaskRecord anyTaskForIdLocked(int id2, boolean restoreFromRecents) {
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                TaskRecord task = stack.taskForIdLocked(id2);
                if (task == null) continue;
                return task;
            }
        }
        TaskRecord task = this.mRecentTasks.taskForIdLocked(id2);
        if (task == null) {
            return null;
        }
        if (!restoreFromRecents) {
            return task;
        }
        if (!this.restoreRecentTaskLocked(task)) {
            return null;
        }
        return task;
    }

    ActivityRecord isInAnyStackLocked(IBinder token) {
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord r = stacks.get(stackNdx).isInStackLocked(token);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    void setNextTaskId(int taskId) {
        if (taskId > this.mCurTaskId) {
            this.mCurTaskId = taskId;
        }
    }

    int getNextTaskId() {
        do {
            ++this.mCurTaskId;
            if (this.mCurTaskId > 0) continue;
            this.mCurTaskId = 1;
        } while (this.anyTaskForIdLocked(this.mCurTaskId, false) != null);
        return this.mCurTaskId;
    }

    ActivityRecord resumedAppLocked() {
        ActivityStack stack = this.mFocusedStack;
        if (stack == null) {
            return null;
        }
        ActivityRecord resumedActivity = stack.mResumedActivity;
        if (!(resumedActivity != null && resumedActivity.app != null || (resumedActivity = stack.mPausingActivity) != null && resumedActivity.app != null)) {
            resumedActivity = stack.topRunningActivityLocked(null);
        }
        return resumedActivity;
    }

    boolean attachApplicationLocked(ProcessRecord app) throws RemoteException {
        String processName = app.processName;
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord hr;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFrontStack(stack) || (hr = stack.topRunningActivityLocked(null)) == null || hr.app != null || app.uid != hr.info.applicationInfo.uid || !processName.equals(hr.processName)) continue;
                try {
                    if (!this.realStartActivityLocked(hr, app, true, true)) continue;
                    didSomething = true;
                    continue;
                }
                catch (RemoteException e) {
                    Slog.w("ActivityManager", "Exception in new application when starting activity " + hr.intent.getComponent().flattenToShortString(), e);
                    throw e;
                }
            }
        }
        if (!didSomething) {
            this.ensureActivitiesVisibleLocked(null, 0);
        }
        return didSomething;
    }

    boolean allResumedActivitiesIdle() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord resumedActivity;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFrontStack(stack) || stack.numActivities() == 0 || (resumedActivity = stack.mResumedActivity) != null && resumedActivity.idle) continue;
                return false;
            }
        }
        return true;
    }

    boolean allResumedActivitiesComplete() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord r;
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFrontStack(stack) || (r = stack.mResumedActivity) == null || r.state == ActivityStack.ActivityState.RESUMED) continue;
                return false;
            }
        }
        this.mLastFocusedStack = this.mFocusedStack;
        return true;
    }

    boolean allResumedActivitiesVisible() {
        boolean foundResumed = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.mResumedActivity;
                if (r == null) continue;
                if (!r.nowVisible || this.mWaitingVisibleActivities.contains(r)) {
                    return false;
                }
                foundResumed = true;
            }
        }
        return foundResumed;
    }

    boolean pauseBackStacks(boolean userLeaving, boolean resuming, boolean dontWait) {
        boolean someActivityPaused = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (this.isFrontStack(stack) || stack.mResumedActivity == null) continue;
                someActivityPaused |= stack.startPausingLocked(userLeaving, false, resuming, dontWait);
            }
        }
        return someActivityPaused;
    }

    boolean allPausedActivitiesComplete() {
        boolean pausing = true;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.mPausingActivity;
                if (r == null || r.state == ActivityStack.ActivityState.PAUSED || r.state == ActivityStack.ActivityState.STOPPED || r.state == ActivityStack.ActivityState.STOPPING) continue;
                return false;
            }
        }
        return pausing;
    }

    void pauseChildStacks(ActivityRecord parent, boolean userLeaving, boolean uiSleeping, boolean resuming, boolean dontWait) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (stack.mResumedActivity == null || stack.mActivityContainer.mParentActivity != parent) continue;
                stack.startPausingLocked(userLeaving, uiSleeping, resuming, dontWait);
            }
        }
    }

    void reportActivityVisibleLocked(ActivityRecord r) {
        this.sendWaitingVisibleReportLocked(r);
    }

    void sendWaitingVisibleReportLocked(ActivityRecord r) {
        boolean changed = false;
        for (int i = this.mWaitingActivityVisible.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityVisible.get(i);
            if (w.who != null) continue;
            changed = true;
            w.timeout = false;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = w.totalTime = SystemClock.uptimeMillis() - w.thisTime;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    void reportActivityLaunchedLocked(boolean timeout, ActivityRecord r, long thisTime, long totalTime) {
        boolean changed = false;
        for (int i = this.mWaitingActivityLaunched.size() - 1; i >= 0; --i) {
            IActivityManager.WaitResult w = this.mWaitingActivityLaunched.remove(i);
            if (w.who != null) continue;
            changed = true;
            w.timeout = timeout;
            if (r != null) {
                w.who = new ComponentName(r.info.packageName, r.info.name);
            }
            w.thisTime = thisTime;
            w.totalTime = totalTime;
        }
        if (changed) {
            this.mService.notifyAll();
        }
    }

    ActivityRecord topRunningActivityLocked() {
        ActivityStack focusedStack = this.mFocusedStack;
        ActivityRecord r = focusedStack.topRunningActivityLocked(null);
        if (r != null) {
            return r;
        }
        ArrayList<ActivityStack> stacks = this.mHomeStack.mStacks;
        for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
            ActivityStack stack = stacks.get(stackNdx);
            if (stack == focusedStack || !this.isFrontStack(stack) || (r = stack.topRunningActivityLocked(null)) == null) continue;
            return r;
        }
        return null;
    }

    void getTasksLocked(int maxNum, List<ActivityManager.RunningTaskInfo> list, int callingUid, boolean allowed) {
        ArrayList<ArrayList<ActivityManager.RunningTaskInfo>> runningTaskLists = new ArrayList<ArrayList<ActivityManager.RunningTaskInfo>>();
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                ArrayList<ActivityManager.RunningTaskInfo> stackTaskList = new ArrayList<ActivityManager.RunningTaskInfo>();
                runningTaskLists.add(stackTaskList);
                stack.getTasksLocked(stackTaskList, callingUid, allowed);
            }
        }
        while (maxNum > 0) {
            long mostRecentActiveTime = Long.MIN_VALUE;
            ArrayList selectedStackList = null;
            int numTaskLists = runningTaskLists.size();
            for (int stackNdx = 0; stackNdx < numTaskLists; ++stackNdx) {
                long lastActiveTime;
                ArrayList stackTaskList = (ArrayList)runningTaskLists.get(stackNdx);
                if (stackTaskList.isEmpty() || (lastActiveTime = ((ActivityManager.RunningTaskInfo)stackTaskList.get((int)0)).lastActiveTime) <= mostRecentActiveTime) continue;
                mostRecentActiveTime = lastActiveTime;
                selectedStackList = stackTaskList;
            }
            if (selectedStackList == null) break;
            list.add((ActivityManager.RunningTaskInfo)selectedStackList.remove(0));
            --maxNum;
        }
    }

    ActivityInfo resolveActivity(Intent intent, String resolvedType, int startFlags, ProfilerInfo profilerInfo, int userId) {
        ActivityInfo aInfo;
        try {
            ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, resolvedType, 66560, userId);
            aInfo = rInfo != null ? rInfo.activityInfo : null;
        }
        catch (RemoteException e) {
            aInfo = null;
        }
        if (aInfo != null) {
            intent.setComponent(new ComponentName(aInfo.applicationInfo.packageName, aInfo.name));
            if ((startFlags & 2) != 0 && !aInfo.processName.equals("system")) {
                this.mService.setDebugApp(aInfo.processName, true, false);
            }
            if ((startFlags & 4) != 0 && !aInfo.processName.equals("system")) {
                this.mService.setOpenGlTraceApp(aInfo.applicationInfo, aInfo.processName);
            }
            if (profilerInfo != null && !aInfo.processName.equals("system")) {
                this.mService.setProfileApp(aInfo.applicationInfo, aInfo.processName, profilerInfo);
            }
        }
        return aInfo;
    }

    void startHomeActivity(Intent intent, ActivityInfo aInfo, String reason) {
        this.moveHomeStackTaskToTop(1, reason);
        this.startActivityLocked(null, intent, null, aInfo, null, null, null, null, 0, 0, 0, null, 0, 0, 0, null, false, false, null, null, null);
        if (this.inResumeTopActivity) {
            this.scheduleResumeTopActivities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivityMayWait(IApplicationThread caller, int callingUid, String callingPackage, Intent intent, String resolvedType, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int startFlags, ProfilerInfo profilerInfo, IActivityManager.WaitResult outResult, Configuration config, Bundle options, boolean ignoreTargetSecurity, int userId, IActivityContainer iContainer, TaskRecord inTask) {
        if (intent != null && intent.hasFileDescriptors()) {
            throw new IllegalArgumentException("File descriptors passed in Intent");
        }
        boolean componentSpecified = intent.getComponent() != null;
        intent = new Intent(intent);
        ActivityInfo aInfo = this.resolveActivity(intent, resolvedType, startFlags, profilerInfo, userId);
        ActivityContainer container = (ActivityContainer)iContainer;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int callingPid;
            if (container != null && container.mParentActivity != null && container.mParentActivity.state != ActivityStack.ActivityState.RESUMED) {
                return -6;
            }
            int realCallingPid = Binder.getCallingPid();
            int realCallingUid = Binder.getCallingUid();
            if (callingUid >= 0) {
                callingPid = -1;
            } else if (caller == null) {
                callingPid = realCallingPid;
                callingUid = realCallingUid;
            } else {
                callingUid = -1;
                callingPid = -1;
            }
            ActivityStack stack = container == null || container.mStack.isOnHomeDisplay() ? this.mFocusedStack : container.mStack;
            stack.mConfigWillChange = config != null && this.mService.mConfiguration.diff(config) != 0;
            long origId = Binder.clearCallingIdentity();
            if (aInfo != null && (aInfo.applicationInfo.privateFlags & 2) != 0 && aInfo.processName.equals(aInfo.applicationInfo.packageName) && this.mService.mHeavyWeightProcess != null && (this.mService.mHeavyWeightProcess.info.uid != aInfo.applicationInfo.uid || !this.mService.mHeavyWeightProcess.processName.equals(aInfo.processName))) {
                int appCallingUid = callingUid;
                if (caller != null) {
                    ProcessRecord callerApp = this.mService.getRecordForAppLocked(caller);
                    if (callerApp != null) {
                        appCallingUid = callerApp.info.uid;
                    } else {
                        Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                        ActivityOptions.abort(options);
                        return -4;
                    }
                }
                IIntentSender target = this.mService.getIntentSenderLocked(2, "android", appCallingUid, userId, null, null, 0, new Intent[]{intent}, new String[]{resolvedType}, 0x50000000, null);
                Intent newIntent = new Intent();
                if (requestCode >= 0) {
                    newIntent.putExtra("has_result", true);
                }
                newIntent.putExtra("intent", new IntentSender(target));
                if (this.mService.mHeavyWeightProcess.activities.size() > 0) {
                    ActivityRecord hist = this.mService.mHeavyWeightProcess.activities.get(0);
                    newIntent.putExtra("cur_app", hist.packageName);
                    newIntent.putExtra("cur_task", hist.task.taskId);
                }
                newIntent.putExtra("new_app", aInfo.packageName);
                newIntent.setFlags(intent.getFlags());
                newIntent.setClassName("android", HeavyWeightSwitcherActivity.class.getName());
                intent = newIntent;
                resolvedType = null;
                caller = null;
                callingUid = Binder.getCallingUid();
                callingPid = Binder.getCallingPid();
                componentSpecified = true;
                try {
                    ResolveInfo rInfo = AppGlobals.getPackageManager().resolveIntent(intent, null, 66560, userId);
                    aInfo = rInfo != null ? rInfo.activityInfo : null;
                    aInfo = this.mService.getActivityInfoForUser(aInfo, userId);
                }
                catch (RemoteException e) {
                    aInfo = null;
                }
            }
            int res = this.startActivityLocked(caller, intent, resolvedType, aInfo, voiceSession, voiceInteractor, resultTo, resultWho, requestCode, callingPid, callingUid, callingPackage, realCallingPid, realCallingUid, startFlags, options, ignoreTargetSecurity, componentSpecified, null, container, inTask);
            Binder.restoreCallingIdentity(origId);
            if (stack.mConfigWillChange) {
                this.mService.enforceCallingPermission("android.permission.CHANGE_CONFIGURATION", "updateConfiguration()");
                stack.mConfigWillChange = false;
                this.mService.updateConfigurationLocked(config, null, false, false);
            }
            if (outResult != null) {
                outResult.result = res;
                if (res == 0) {
                    this.mWaitingActivityLaunched.add(outResult);
                    do {
                        try {
                            this.mService.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    } while (!outResult.timeout && outResult.who == null);
                } else if (res == 2) {
                    ActivityRecord r = stack.topRunningActivityLocked(null);
                    if (r.nowVisible && r.state == ActivityStack.ActivityState.RESUMED) {
                        outResult.timeout = false;
                        outResult.who = new ComponentName(r.info.packageName, r.info.name);
                        outResult.totalTime = 0L;
                        outResult.thisTime = 0L;
                    } else {
                        outResult.thisTime = SystemClock.uptimeMillis();
                        this.mWaitingActivityVisible.add(outResult);
                        do {
                            try {
                                this.mService.wait();
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                        } while (!outResult.timeout && outResult.who == null);
                    }
                }
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int startActivities(IApplicationThread caller, int callingUid, String callingPackage, Intent[] intents, String[] resolvedTypes, IBinder resultTo, Bundle options, int userId) {
        int callingPid;
        if (intents == null) {
            throw new NullPointerException("intents is null");
        }
        if (resolvedTypes == null) {
            throw new NullPointerException("resolvedTypes is null");
        }
        if (intents.length != resolvedTypes.length) {
            throw new IllegalArgumentException("intents are length different than resolvedTypes");
        }
        if (callingUid >= 0) {
            callingPid = -1;
        } else if (caller == null) {
            callingPid = Binder.getCallingPid();
            callingUid = Binder.getCallingUid();
        } else {
            callingUid = -1;
            callingPid = -1;
        }
        long origId = Binder.clearCallingIdentity();
        try {
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                ActivityRecord[] outActivity = new ActivityRecord[1];
                for (int i = 0; i < intents.length; ++i) {
                    Intent intent = intents[i];
                    if (intent == null) continue;
                    if (intent != null && intent.hasFileDescriptors()) {
                        throw new IllegalArgumentException("File descriptors passed in Intent");
                    }
                    boolean componentSpecified = intent.getComponent() != null;
                    intent = new Intent(intent);
                    ActivityInfo aInfo = this.resolveActivity(intent, resolvedTypes[i], 0, null, userId);
                    if ((aInfo = this.mService.getActivityInfoForUser(aInfo, userId)) != null && (aInfo.applicationInfo.privateFlags & 2) != 0) {
                        throw new IllegalArgumentException("FLAG_CANT_SAVE_STATE not supported here");
                    }
                    Bundle theseOptions = options != null && i == intents.length - 1 ? options : null;
                    int res = this.startActivityLocked(caller, intent, resolvedTypes[i], aInfo, null, null, resultTo, null, -1, callingPid, callingUid, callingPackage, callingPid, callingUid, 0, theseOptions, false, componentSpecified, outActivity, null, null);
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    resultTo = outActivity[0] != null ? outActivity[0].appToken : null;
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
        {
            return 0;
        }
    }

    final boolean realStartActivityLocked(ActivityRecord r, ProcessRecord app, boolean andResume, boolean checkConfig) throws RemoteException {
        if (andResume) {
            r.startFreezingScreenLocked(app, 0);
            this.mWindowManager.setAppVisibility(r.appToken, true);
            r.startLaunchTickingLocked();
        }
        if (checkConfig) {
            Configuration config = this.mWindowManager.updateOrientationFromAppTokens(this.mService.mConfiguration, r.mayFreezeScreenLocked(app) ? r.appToken : null);
            this.mService.updateConfigurationLocked(config, r, false, false);
        }
        r.app = app;
        app.waitingToKill = null;
        ++r.launchCount;
        r.lastLaunchTime = SystemClock.uptimeMillis();
        int idx = app.activities.indexOf(r);
        if (idx < 0) {
            app.activities.add(r);
        }
        this.mService.updateLruProcessLocked(app, true, null);
        this.mService.updateOomAdjLocked();
        TaskRecord task = r.task;
        if (task.mLockTaskAuth == 2 || task.mLockTaskAuth == 4) {
            this.setLockTaskModeLocked(task, 1, "mLockTaskAuth==LAUNCHABLE", false);
        }
        ActivityStack stack = task.stack;
        try {
            if (app.thread == null) {
                throw new RemoteException();
            }
            ArrayList<ResultInfo> results = null;
            ArrayList<ReferrerIntent> newIntents = null;
            if (andResume) {
                results = r.results;
                newIntents = r.newIntents;
            }
            if (andResume) {
                EventLog.writeEvent(30006, r.userId, System.identityHashCode(r), task.taskId, r.shortComponentName);
            }
            if (r.isHomeActivity() && r.isNotResolverActivity()) {
                this.mService.mHomeProcess = task.mActivities.get((int)0).app;
            }
            this.mService.ensurePackageDexOpt(r.intent.getComponent().getPackageName());
            r.sleeping = false;
            r.forceNewConfig = false;
            this.mService.showAskCompatModeDialogLocked(r);
            r.compat = this.mService.compatibilityInfoForPackageLocked(r.info.applicationInfo);
            ProfilerInfo profilerInfo = null;
            if (this.mService.mProfileApp != null && this.mService.mProfileApp.equals(app.processName) && (this.mService.mProfileProc == null || this.mService.mProfileProc == app)) {
                this.mService.mProfileProc = app;
                String profileFile = this.mService.mProfileFile;
                if (profileFile != null) {
                    ParcelFileDescriptor profileFd;
                    block25: {
                        profileFd = this.mService.mProfileFd;
                        if (profileFd != null) {
                            try {
                                profileFd = profileFd.dup();
                            }
                            catch (IOException e) {
                                if (profileFd == null) break block25;
                                try {
                                    profileFd.close();
                                }
                                catch (IOException o) {
                                    // empty catch block
                                }
                                profileFd = null;
                            }
                        }
                    }
                    profilerInfo = new ProfilerInfo(profileFile, profileFd, this.mService.mSamplingInterval, this.mService.mAutoStopProfiler);
                }
            }
            if (andResume) {
                app.hasShownUi = true;
                app.pendingUiClean = true;
            }
            app.forceProcessStateUpTo(this.mService.mTopProcessState);
            app.thread.scheduleLaunchActivity(new Intent(r.intent), r.appToken, System.identityHashCode(r), r.info, new Configuration(this.mService.mConfiguration), new Configuration(stack.mOverrideConfig), r.compat, r.launchedFromPackage, task.voiceInteractor, app.repProcState, r.icicle, r.persistentState, results, newIntents, !andResume, this.mService.isNextTransitionForward(), profilerInfo);
            if ((app.info.privateFlags & 2) != 0 && app.processName.equals(app.info.packageName)) {
                if (this.mService.mHeavyWeightProcess != null && this.mService.mHeavyWeightProcess != app) {
                    Slog.w("ActivityManager", "Starting new heavy weight process " + app + " when already running " + this.mService.mHeavyWeightProcess);
                }
                this.mService.mHeavyWeightProcess = app;
                Message msg = this.mService.mHandler.obtainMessage(24);
                msg.obj = r;
                this.mService.mHandler.sendMessage(msg);
            }
        }
        catch (RemoteException e) {
            if (r.launchFailed) {
                Slog.e("ActivityManager", "Second failure launching " + r.intent.getComponent().flattenToShortString() + ", giving up", e);
                this.mService.appDiedLocked(app);
                stack.requestFinishActivityLocked(r.appToken, 0, null, "2nd-crash", false);
                return false;
            }
            app.activities.remove(r);
            throw e;
        }
        r.launchFailed = false;
        if (stack.updateLRUListLocked(r)) {
            Slog.w("ActivityManager", "Activity " + r + " being launched, but already in LRU list");
        }
        if (andResume) {
            stack.minimalResumeActivityLocked(r);
        } else {
            r.state = ActivityStack.ActivityState.STOPPED;
            r.stopped = true;
        }
        if (this.isFrontStack(stack)) {
            this.mService.startSetupActivityLocked();
        }
        this.mService.mServices.updateServiceConnectionActivitiesLocked(r.app);
        return true;
    }

    void startSpecificActivityLocked(ActivityRecord r, boolean andResume, boolean checkConfig) {
        ProcessRecord app = this.mService.getProcessRecordLocked(r.processName, r.info.applicationInfo.uid, true);
        r.task.stack.setLaunchTime(r);
        if (app != null && app.thread != null) {
            try {
                if ((r.info.flags & 1) == 0 || !"android".equals(r.info.packageName)) {
                    app.addPackage(r.info.packageName, r.info.applicationInfo.versionCode, this.mService.mProcessStats);
                }
                this.realStartActivityLocked(r, app, andResume, checkConfig);
                return;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception when starting activity " + r.intent.getComponent().flattenToShortString(), e);
            }
        }
        this.mService.startProcessLocked(r.processName, r.info.applicationInfo, true, 0, "activity", r.intent.getComponent(), false, false, true);
    }

    final int startActivityLocked(IApplicationThread caller, Intent intent, String resolvedType, ActivityInfo aInfo, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, IBinder resultTo, String resultWho, int requestCode, int callingPid, int callingUid, String callingPackage, int realCallingPid, int realCallingUid, int startFlags, Bundle options, boolean ignoreTargetSecurity, boolean componentSpecified, ActivityRecord[] outActivity, ActivityContainer container, TaskRecord inTask) {
        ActivityStack resultStack;
        int launchFlags;
        int userId;
        int err = 0;
        ProcessRecord callerApp = null;
        if (caller != null) {
            callerApp = this.mService.getRecordForAppLocked(caller);
            if (callerApp != null) {
                callingPid = callerApp.pid;
                callingUid = callerApp.info.uid;
            } else {
                Slog.w("ActivityManager", "Unable to find app for caller " + caller + " (pid=" + callingPid + ") when starting: " + intent.toString());
                err = -4;
            }
        }
        int n = userId = aInfo != null ? UserHandle.getUserId(aInfo.applicationInfo.uid) : 0;
        if (err == 0) {
            Slog.i("ActivityManager", "START u" + userId + " {" + intent.toShortString(true, true, true, false) + "} from uid " + callingUid + " on display " + (container == null ? (this.mFocusedStack == null ? 0 : this.mFocusedStack.mDisplayId) : (container.mActivityDisplay == null ? 0 : container.mActivityDisplay.mDisplayId)));
        }
        ActivityRecord sourceRecord = null;
        ActivityRecord resultRecord = null;
        if (resultTo != null && (sourceRecord = this.isInAnyStackLocked(resultTo)) != null && requestCode >= 0 && !sourceRecord.finishing) {
            resultRecord = sourceRecord;
        }
        if (((launchFlags = intent.getFlags()) & 0x2000000) != 0 && sourceRecord != null) {
            if (requestCode >= 0) {
                ActivityOptions.abort(options);
                return -3;
            }
            resultRecord = sourceRecord.resultTo;
            if (resultRecord != null && !resultRecord.isInStackLocked()) {
                resultRecord = null;
            }
            resultWho = sourceRecord.resultWho;
            requestCode = sourceRecord.requestCode;
            sourceRecord.resultTo = null;
            if (resultRecord != null) {
                resultRecord.removeResultsLocked(sourceRecord, resultWho, requestCode);
            }
            if (sourceRecord.launchedFromUid == callingUid) {
                callingPackage = sourceRecord.launchedFromPackage;
            }
        }
        if (err == 0 && intent.getComponent() == null) {
            err = -1;
        }
        if (err == 0 && aInfo == null) {
            err = -2;
        }
        if (err == 0 && !this.isCurrentProfileLocked(userId) && (aInfo.flags & 0x400) == 0) {
            err = -8;
        }
        if (err == 0 && sourceRecord != null && sourceRecord.task.voiceSession != null && (launchFlags & 0x10000000) == 0 && sourceRecord.info.applicationInfo.uid != aInfo.applicationInfo.uid) {
            try {
                intent.addCategory("android.intent.category.VOICE");
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in current voice task does not support voice: " + intent);
                    err = -7;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -7;
            }
        }
        if (err == 0 && voiceSession != null) {
            try {
                if (!AppGlobals.getPackageManager().activitySupportsIntent(intent.getComponent(), intent, resolvedType)) {
                    Slog.w("ActivityManager", "Activity being started in new voice task does not support: " + intent);
                    err = -7;
                }
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Failure checking voice capabilities", e);
                err = -7;
            }
        }
        ActivityStack activityStack = resultStack = resultRecord == null ? null : resultRecord.task.stack;
        if (err != 0) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return err;
        }
        boolean abort = false;
        int startAnyPerm = this.mService.checkPermission("android.permission.START_ANY_ACTIVITY", callingPid, callingUid);
        if (startAnyPerm != 0) {
            String message;
            int componentRestriction = this.getComponentRestrictionForCallingPackage(aInfo, callingPackage, callingPid, callingUid, ignoreTargetSecurity);
            int actionRestriction = this.getActionRestrictionForCallingPackage(intent.getAction(), callingPackage, callingPid, callingUid);
            if (componentRestriction == 1 || actionRestriction == 1) {
                if (resultRecord != null) {
                    resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
                }
                String msg = actionRestriction == 1 ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " with revoked permission " + ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()) : (!aInfo.exported ? "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " not exported from uid " + aInfo.applicationInfo.uid : "Permission Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + aInfo.permission);
                Slog.w("ActivityManager", msg);
                throw new SecurityException(msg);
            }
            if (actionRestriction == 2) {
                message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires " + AppOpsManager.permissionToOp(ACTION_TO_RUNTIME_PERMISSION.get(intent.getAction()));
                Slog.w("ActivityManager", message);
                abort = true;
            } else if (componentRestriction == 2) {
                message = "Appop Denial: starting " + intent.toString() + " from " + callerApp + " (pid=" + callingPid + ", uid=" + callingUid + ")" + " requires appop " + AppOpsManager.permissionToOp(aInfo.permission);
                Slog.w("ActivityManager", message);
                abort = true;
            }
        }
        abort |= !this.mService.mIntentFirewall.checkStartActivity(intent, callingUid, callingPid, resolvedType, aInfo.applicationInfo);
        if (this.mService.mController != null) {
            try {
                Intent watchIntent = intent.cloneFilter();
                abort |= !this.mService.mController.activityStarting(watchIntent, aInfo.applicationInfo.packageName);
            }
            catch (RemoteException e) {
                this.mService.mController = null;
            }
        }
        if (abort) {
            if (resultRecord != null) {
                resultStack.sendActivityResultLocked(-1, resultRecord, resultWho, requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return 0;
        }
        ActivityRecord r = new ActivityRecord(this.mService, callerApp, callingUid, callingPackage, intent, resolvedType, aInfo, this.mService.mConfiguration, resultRecord, resultWho, requestCode, componentSpecified, voiceSession != null, this, container, options);
        if (outActivity != null) {
            outActivity[0] = r;
        }
        if (r.appTimeTracker == null && sourceRecord != null) {
            r.appTimeTracker = sourceRecord.appTimeTracker;
        }
        ActivityStack stack = this.mFocusedStack;
        if (!(voiceSession != null || stack.mResumedActivity != null && stack.mResumedActivity.info.applicationInfo.uid == callingUid || this.mService.checkAppSwitchAllowedLocked(callingPid, callingUid, realCallingPid, realCallingUid, "Activity start"))) {
            PendingActivityLaunch pal = new PendingActivityLaunch(r, sourceRecord, startFlags, stack);
            this.mPendingActivityLaunches.add(pal);
            ActivityOptions.abort(options);
            return 4;
        }
        if (this.mService.mDidAppSwitch) {
            this.mService.mAppSwitchesAllowedTime = 0L;
        } else {
            this.mService.mDidAppSwitch = true;
        }
        this.doPendingActivityLaunchesLocked(false);
        err = this.startActivityUncheckedLocked(r, sourceRecord, voiceSession, voiceInteractor, startFlags, true, options, inTask);
        if (err < 0) {
            this.notifyActivityDrawnForKeyguard();
        }
        return err;
    }

    private int getComponentRestrictionForCallingPackage(ActivityInfo activityInfo, String callingPackage, int callingPid, int callingUid, boolean ignoreTargetSecurity) {
        if (!ignoreTargetSecurity && this.mService.checkComponentPermission(activityInfo.permission, callingPid, callingUid, activityInfo.applicationInfo.uid, activityInfo.exported) == -1) {
            return 1;
        }
        if (activityInfo.permission == null) {
            return 0;
        }
        int opCode = AppOpsManager.permissionToOpCode(activityInfo.permission);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0 && !ignoreTargetSecurity) {
            return 2;
        }
        return 0;
    }

    private int getActionRestrictionForCallingPackage(String action, String callingPackage, int callingPid, int callingUid) {
        PackageInfo packageInfo;
        if (action == null) {
            return 0;
        }
        String permission2 = ACTION_TO_RUNTIME_PERMISSION.get(action);
        if (permission2 == null) {
            return 0;
        }
        try {
            packageInfo = this.mService.mContext.getPackageManager().getPackageInfo(callingPackage, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.i("ActivityManager", "Cannot find package info for " + callingPackage);
            return 0;
        }
        if (!ArrayUtils.contains(packageInfo.requestedPermissions, permission2)) {
            return 0;
        }
        if (this.mService.checkPermission(permission2, callingPid, callingUid) == -1) {
            return 1;
        }
        int opCode = AppOpsManager.permissionToOpCode(permission2);
        if (opCode == -1) {
            return 0;
        }
        if (this.mService.mAppOpsService.noteOperation(opCode, callingUid, callingPackage) != 0) {
            return 2;
        }
        return 0;
    }

    ActivityStack computeStackFocus(ActivityRecord r, boolean newTask) {
        TaskRecord task = r.task;
        if (!this.mLeanbackOnlyDevice && (r.isApplicationActivity() || task != null && task.isApplicationTask())) {
            ActivityStack stack;
            if (task != null && task.stack != null) {
                ActivityStack stack2 = task.stack;
                if (!stack2.isOnHomeDisplay() || this.mFocusedStack != stack2) {
                    // empty if block
                }
                return stack2;
            }
            ActivityContainer container = r.mInitialActivityContainer;
            if (container != null) {
                r.mInitialActivityContainer = null;
                return container.mStack;
            }
            if (this.mFocusedStack != this.mHomeStack && (!newTask || this.mFocusedStack.mActivityContainer.isEligibleForNewTasks())) {
                return this.mFocusedStack;
            }
            ArrayList<ActivityStack> homeDisplayStacks = this.mHomeStack.mStacks;
            for (int stackNdx = homeDisplayStacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stack = homeDisplayStacks.get(stackNdx);
                if (stack.isHomeStack()) continue;
                return stack;
            }
            stack = this.createStackOnDisplay(this.getNextStackId(), 0);
            return stack;
        }
        return this.mHomeStack;
    }

    boolean setFocusedStack(ActivityRecord r, String reason) {
        if (r == null) {
            return false;
        }
        TaskRecord task = r.task;
        if (task == null || task.stack == null) {
            Slog.w("ActivityManager", "Can't set focus stack for r=" + r + " task=" + task);
            return false;
        }
        task.stack.moveToFront(reason);
        return true;
    }

    final int startActivityUncheckedLocked(ActivityRecord r, ActivityRecord sourceRecord, IVoiceInteractionSession voiceSession, IVoiceInteractor voiceInteractor, int startFlags, boolean doResume, Bundle options, TaskRecord inTask) {
        TaskRecord taskToAffiliate;
        ActivityStack targetStack;
        boolean noAnimation;
        ActivityStack sourceStack;
        ActivityRecord notTop;
        boolean launchTaskBehind;
        Intent intent = r.intent;
        int callingUid = r.launchedFromUid;
        if (inTask != null && !inTask.inRecents) {
            Slog.w("ActivityManager", "Starting activity in task not in recents: " + inTask);
            inTask = null;
        }
        boolean launchSingleTop = r.launchMode == 1;
        boolean launchSingleInstance = r.launchMode == 3;
        boolean launchSingleTask = r.launchMode == 2;
        int launchFlags = intent.getFlags();
        if ((launchFlags & 0x80000) != 0 && (launchSingleInstance || launchSingleTask)) {
            Slog.i("ActivityManager", "Ignoring FLAG_ACTIVITY_NEW_DOCUMENT, launchMode is \"singleInstance\" or \"singleTask\"");
            launchFlags &= 0xF7F7FFFF;
        } else {
            switch (r.info.documentLaunchMode) {
                case 0: {
                    break;
                }
                case 1: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 2: {
                    launchFlags |= 0x80000;
                    break;
                }
                case 3: {
                    launchFlags &= 0xF7FFFFFF;
                }
            }
        }
        boolean bl = launchTaskBehind = r.mLaunchTaskBehind && !launchSingleTask && !launchSingleInstance && (launchFlags & 0x80000) != 0;
        if (r.resultTo != null && (launchFlags & 0x10000000) != 0 && r.resultTo.task.stack != null) {
            Slog.w("ActivityManager", "Activity is launching as a new task, so cancelling activity result.");
            r.resultTo.task.stack.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            r.resultTo = null;
        }
        if ((launchFlags & 0x80000) != 0 && r.resultTo == null) {
            launchFlags |= 0x10000000;
        }
        if ((launchFlags & 0x10000000) != 0 && (launchTaskBehind || r.info.documentLaunchMode == 2)) {
            launchFlags |= 0x8000000;
        }
        boolean bl2 = this.mUserLeaving = (launchFlags & 0x40000) == 0;
        if (!doResume) {
            r.delayedResume = true;
        }
        ActivityRecord activityRecord = notTop = (launchFlags & 0x1000000) != 0 ? r : null;
        if ((startFlags & 1) != 0) {
            ActivityRecord checkedCaller = sourceRecord;
            if (checkedCaller == null) {
                checkedCaller = this.mFocusedStack.topRunningNonDelayedActivityLocked(notTop);
            }
            if (!checkedCaller.realActivity.equals(r.realActivity)) {
                startFlags &= 0xFFFFFFFE;
            }
        }
        boolean addingToTask = false;
        TaskRecord reuseTask = null;
        if (sourceRecord == null && inTask != null && inTask.stack != null) {
            Intent baseIntent = inTask.getBaseIntent();
            ActivityRecord root = inTask.getRootActivity();
            if (baseIntent == null) {
                ActivityOptions.abort(options);
                throw new IllegalArgumentException("Launching into task without base intent: " + inTask);
            }
            if (launchSingleInstance || launchSingleTask) {
                if (!baseIntent.getComponent().equals(r.intent.getComponent())) {
                    ActivityOptions.abort(options);
                    throw new IllegalArgumentException("Trying to launch singleInstance/Task " + r + " into different task " + inTask);
                }
                if (root != null) {
                    ActivityOptions.abort(options);
                    throw new IllegalArgumentException("Caller with inTask " + inTask + " has root " + root + " but target is singleInstance/Task");
                }
            }
            if (root == null) {
                int flagsOfInterest = 403185664;
                launchFlags = launchFlags & 0xE7F7DFFF | baseIntent.getFlags() & 0x18082000;
                intent.setFlags(launchFlags);
                inTask.setIntent(r);
                addingToTask = true;
            } else {
                addingToTask = (launchFlags & 0x10000000) == 0;
            }
            reuseTask = inTask;
        } else {
            inTask = null;
        }
        if (inTask == null) {
            if (sourceRecord == null) {
                if ((launchFlags & 0x10000000) == 0 && inTask == null) {
                    Slog.w("ActivityManager", "startActivity called from non-Activity context; forcing Intent.FLAG_ACTIVITY_NEW_TASK for: " + intent);
                    launchFlags |= 0x10000000;
                }
            } else if (sourceRecord.launchMode == 3) {
                launchFlags |= 0x10000000;
            } else if (launchSingleInstance || launchSingleTask) {
                launchFlags |= 0x10000000;
            }
        }
        ActivityInfo newTaskInfo = null;
        Intent newTaskIntent = null;
        if (sourceRecord != null) {
            if (sourceRecord.finishing) {
                if ((launchFlags & 0x10000000) == 0) {
                    Slog.w("ActivityManager", "startActivity called from finishing " + sourceRecord + "; forcing " + "Intent.FLAG_ACTIVITY_NEW_TASK for: " + intent);
                    launchFlags |= 0x10000000;
                    newTaskInfo = sourceRecord.info;
                    newTaskIntent = sourceRecord.task.intent;
                }
                sourceRecord = null;
                sourceStack = null;
            } else {
                sourceStack = sourceRecord.task.stack;
            }
        } else {
            sourceStack = null;
        }
        boolean movedHome = false;
        intent.setFlags(launchFlags);
        boolean bl3 = noAnimation = (launchFlags & 0x10000) != 0;
        if (((launchFlags & 0x10000000) != 0 && (launchFlags & 0x8000000) == 0 || launchSingleInstance || launchSingleTask) && inTask == null && r.resultTo == null) {
            ActivityRecord intentActivity;
            ActivityRecord activityRecord2 = intentActivity = !launchSingleInstance ? this.findTaskLocked(r) : this.findActivityLocked(intent, r.info);
            if (intentActivity != null) {
                if (this.isLockTaskModeViolation(intentActivity.task, (launchFlags & 0x10008000) == 0x10008000)) {
                    this.showLockTaskToast();
                    Slog.e("ActivityManager", "startActivityUnchecked: Attempt to violate Lock Task Mode");
                    return 5;
                }
                if (r.task == null) {
                    r.task = intentActivity.task;
                }
                if (intentActivity.task.intent == null) {
                    intentActivity.task.setIntent(r);
                }
                targetStack = intentActivity.task.stack;
                targetStack.mLastPausedActivity = null;
                ActivityStack focusStack = this.getFocusedStack();
                ActivityRecord curTop = focusStack == null ? null : focusStack.topRunningNonDelayedActivityLocked(notTop);
                boolean movedToFront = false;
                if (curTop != null && (curTop.task != intentActivity.task || curTop.task != focusStack.topTask())) {
                    r.intent.addFlags(0x400000);
                    if (sourceRecord == null || sourceStack.topActivity() != null && sourceStack.topActivity().task == sourceRecord.task) {
                        if (launchTaskBehind && sourceRecord != null) {
                            intentActivity.setTaskToAffiliateWith(sourceRecord.task);
                        }
                        movedHome = true;
                        targetStack.moveTaskToFrontLocked(intentActivity.task, noAnimation, options, r.appTimeTracker, "bringingFoundTaskToFront");
                        movedToFront = true;
                        if ((launchFlags & 0x10004000) == 0x10004000) {
                            intentActivity.task.setTaskToReturnTo(1);
                        }
                        options = null;
                    }
                }
                if (!movedToFront) {
                    targetStack.moveToFront("intentActivityFound");
                }
                if ((launchFlags & 0x200000) != 0) {
                    intentActivity = targetStack.resetTaskIfNeededLocked(intentActivity, r);
                }
                if ((startFlags & 1) != 0) {
                    if (doResume) {
                        this.resumeTopActivitiesLocked(targetStack, null, options);
                        if (!movedToFront) {
                            this.notifyActivityDrawnForKeyguard();
                        }
                    } else {
                        ActivityOptions.abort(options);
                    }
                    return 1;
                }
                if ((launchFlags & 0x10008000) == 0x10008000) {
                    reuseTask = intentActivity.task;
                    reuseTask.performClearTaskLocked();
                    reuseTask.setIntent(r);
                } else if ((launchFlags & 0x4000000) != 0 || launchSingleInstance || launchSingleTask) {
                    ActivityRecord top = intentActivity.task.performClearTaskLocked(r, launchFlags);
                    if (top != null) {
                        if (top.frontOfTask) {
                            top.task.setIntent(r);
                        }
                        ActivityStack.logStartActivity(30003, r, top.task);
                        top.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                    } else {
                        addingToTask = true;
                        sourceRecord = intentActivity;
                        TaskRecord task = sourceRecord.task;
                        if (task != null && task.stack == null) {
                            targetStack = this.computeStackFocus(sourceRecord, false);
                            targetStack.addTask(task, !launchTaskBehind, false);
                        }
                    }
                } else if (r.realActivity.equals(intentActivity.task.realActivity)) {
                    if (((launchFlags & 0x20000000) != 0 || launchSingleTop) && intentActivity.realActivity.equals(r.realActivity)) {
                        ActivityStack.logStartActivity(30003, r, intentActivity.task);
                        if (intentActivity.frontOfTask) {
                            intentActivity.task.setIntent(r);
                        }
                        intentActivity.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                    } else if (!r.intent.filterEquals(intentActivity.task.intent)) {
                        addingToTask = true;
                        sourceRecord = intentActivity;
                    }
                } else if ((launchFlags & 0x200000) == 0) {
                    addingToTask = true;
                    sourceRecord = intentActivity;
                } else if (!intentActivity.task.rootWasReset) {
                    intentActivity.task.setIntent(r);
                }
                if (!addingToTask && reuseTask == null) {
                    if (doResume) {
                        targetStack.resumeTopActivityLocked(null, options);
                        if (!movedToFront) {
                            this.notifyActivityDrawnForKeyguard();
                        }
                    } else {
                        ActivityOptions.abort(options);
                    }
                    return 2;
                }
            }
        }
        if (r.packageName != null) {
            ActivityStack topStack = this.mFocusedStack;
            ActivityRecord top = topStack.topRunningNonDelayedActivityLocked(notTop);
            if (top != null && r.resultTo == null && top.realActivity.equals(r.realActivity) && top.userId == r.userId && top.app != null && top.app.thread != null && ((launchFlags & 0x20000000) != 0 || launchSingleTop || launchSingleTask)) {
                ActivityStack.logStartActivity(30003, top, top.task);
                topStack.mLastPausedActivity = null;
                if (doResume) {
                    this.resumeTopActivitiesLocked();
                }
                ActivityOptions.abort(options);
                if ((startFlags & 1) != 0) {
                    return 1;
                }
                top.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                return 3;
            }
        } else {
            if (r.resultTo != null && r.resultTo.task.stack != null) {
                r.resultTo.task.stack.sendActivityResultLocked(-1, r.resultTo, r.resultWho, r.requestCode, 0, null);
            }
            ActivityOptions.abort(options);
            return -2;
        }
        boolean newTask = false;
        boolean keepCurTransition = false;
        TaskRecord taskRecord = taskToAffiliate = launchTaskBehind && sourceRecord != null ? sourceRecord.task : null;
        if (r.resultTo == null && inTask == null && !addingToTask && (launchFlags & 0x10000000) != 0) {
            newTask = true;
            targetStack = this.computeStackFocus(r, newTask);
            targetStack.moveToFront("startingNewTask");
            if (reuseTask == null) {
                r.setTask(targetStack.createTaskRecord(this.getNextTaskId(), newTaskInfo != null ? newTaskInfo : r.info, newTaskIntent != null ? newTaskIntent : intent, voiceSession, voiceInteractor, !launchTaskBehind), taskToAffiliate);
            } else {
                r.setTask(reuseTask, taskToAffiliate);
            }
            if (this.isLockTaskModeViolation(r.task)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation r=" + r);
                return 5;
            }
            if (!movedHome && (launchFlags & 0x10004000) == 0x10004000) {
                r.task.setTaskToReturnTo(1);
            }
        } else if (sourceRecord != null) {
            ActivityRecord top;
            TaskRecord sourceTask = sourceRecord.task;
            if (this.isLockTaskModeViolation(sourceTask)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation r=" + r);
                return 5;
            }
            targetStack = sourceTask.stack;
            targetStack.moveToFront("sourceStackToFront");
            TaskRecord topTask = targetStack.topTask();
            if (topTask != sourceTask) {
                targetStack.moveTaskToFrontLocked(sourceTask, noAnimation, options, r.appTimeTracker, "sourceTaskToFront");
            }
            if (!addingToTask && (launchFlags & 0x4000000) != 0) {
                top = sourceTask.performClearTaskLocked(r, launchFlags);
                keepCurTransition = true;
                if (top != null) {
                    ActivityStack.logStartActivity(30003, r, top.task);
                    top.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                    targetStack.mLastPausedActivity = null;
                    if (doResume) {
                        targetStack.resumeTopActivityLocked(null);
                    }
                    ActivityOptions.abort(options);
                    return 3;
                }
            } else if (!addingToTask && (launchFlags & 0x20000) != 0 && (top = sourceTask.findActivityInHistoryLocked(r)) != null) {
                TaskRecord task = top.task;
                task.moveActivityToFrontLocked(top);
                ActivityStack.logStartActivity(30003, r, task);
                top.updateOptionsLocked(options);
                top.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                targetStack.mLastPausedActivity = null;
                if (doResume) {
                    targetStack.resumeTopActivityLocked(null);
                }
                return 3;
            }
            r.setTask(sourceTask, null);
        } else if (inTask != null) {
            if (this.isLockTaskModeViolation(inTask)) {
                Slog.e("ActivityManager", "Attempted Lock Task Mode violation r=" + r);
                return 5;
            }
            targetStack = inTask.stack;
            targetStack.moveTaskToFrontLocked(inTask, noAnimation, options, r.appTimeTracker, "inTaskToFront");
            ActivityRecord top = inTask.getTopActivity();
            if (top != null && top.realActivity.equals(r.realActivity) && top.userId == r.userId && ((launchFlags & 0x20000000) != 0 || launchSingleTop || launchSingleTask)) {
                ActivityStack.logStartActivity(30003, top, top.task);
                if ((startFlags & 1) != 0) {
                    return 1;
                }
                top.deliverNewIntentLocked(callingUid, r.intent, r.launchedFromPackage);
                return 3;
            }
            if (!addingToTask) {
                ActivityOptions.abort(options);
                return 2;
            }
            r.setTask(inTask, null);
        } else {
            targetStack = this.computeStackFocus(r, newTask);
            targetStack.moveToFront("addingToTopTask");
            ActivityRecord prev = targetStack.topActivity();
            r.setTask(prev != null ? prev.task : targetStack.createTaskRecord(this.getNextTaskId(), r.info, intent, null, null, true), null);
            this.mWindowManager.moveTaskToTop(r.task.taskId);
        }
        this.mService.grantUriPermissionFromIntentLocked(callingUid, r.packageName, intent, r.getUriPermissionsLocked(), r.userId);
        if (sourceRecord != null && sourceRecord.isRecentsActivity()) {
            r.task.setTaskToReturnTo(2);
        }
        if (newTask) {
            EventLog.writeEvent(30004, r.userId, r.task.taskId);
        }
        ActivityStack.logStartActivity(30005, r, r.task);
        targetStack.mLastPausedActivity = null;
        targetStack.startActivityLocked(r, newTask, doResume, keepCurTransition, options);
        if (!launchTaskBehind) {
            this.mService.setFocusedActivityLocked(r, "startedActivity");
        }
        return 0;
    }

    final void doPendingActivityLaunchesLocked(boolean doResume) {
        while (!this.mPendingActivityLaunches.isEmpty()) {
            PendingActivityLaunch pal = this.mPendingActivityLaunches.remove(0);
            this.startActivityUncheckedLocked(pal.r, pal.sourceRecord, null, null, pal.startFlags, doResume && this.mPendingActivityLaunches.isEmpty(), null, null);
        }
    }

    void removePendingActivityLaunchesLocked(ActivityStack stack) {
        for (int palNdx = this.mPendingActivityLaunches.size() - 1; palNdx >= 0; --palNdx) {
            PendingActivityLaunch pal = this.mPendingActivityLaunches.get(palNdx);
            if (pal.stack != stack) continue;
            this.mPendingActivityLaunches.remove(palNdx);
        }
    }

    void setLaunchSource(int uid) {
        this.mLaunchingActivity.setWorkSource(new WorkSource(uid));
    }

    void acquireLaunchWakelock() {
        this.mLaunchingActivity.acquire();
        if (!this.mHandler.hasMessages(104)) {
            this.mHandler.sendEmptyMessageDelayed(104, 10000L);
        }
    }

    private boolean checkFinishBootingLocked() {
        boolean booting = this.mService.mBooting;
        boolean enableScreen = false;
        this.mService.mBooting = false;
        if (!this.mService.mBooted) {
            this.mService.mBooted = true;
            enableScreen = true;
        }
        if (booting || enableScreen) {
            this.mService.postFinishBooting(booting, enableScreen);
        }
        return booting;
    }

    final ActivityRecord activityIdleInternalLocked(IBinder token, boolean fromTimeout, Configuration config) {
        ActivityStack stack;
        int i;
        ArrayList<ActivityRecord> stops = null;
        ArrayList<ActivityRecord> finishes = null;
        ArrayList<UserState> startingUsers = null;
        int NS = 0;
        int NF = 0;
        boolean booting = false;
        boolean activityRemoved = false;
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            this.mHandler.removeMessages(100, r);
            r.finishLaunchTickingLocked();
            if (fromTimeout) {
                this.reportActivityLaunchedLocked(fromTimeout, r, -1L, -1L);
            }
            if (config != null) {
                r.configuration = config;
            }
            r.idle = true;
            if (this.isFrontStack(r.task.stack) || fromTimeout) {
                booting = this.checkFinishBootingLocked();
            }
        }
        if (this.allResumedActivitiesIdle()) {
            if (r != null) {
                this.mService.scheduleAppGcsLocked();
            }
            if (this.mLaunchingActivity.isHeld()) {
                this.mHandler.removeMessages(104);
                this.mLaunchingActivity.release();
            }
            this.ensureActivitiesVisibleLocked(null, 0);
        }
        NS = (stops = this.processStoppingActivitiesLocked(true)) != null ? stops.size() : 0;
        NF = this.mFinishingActivities.size();
        if (NF > 0) {
            finishes = new ArrayList<ActivityRecord>(this.mFinishingActivities);
            this.mFinishingActivities.clear();
        }
        if (this.mStartingUsers.size() > 0) {
            startingUsers = new ArrayList<UserState>(this.mStartingUsers);
            this.mStartingUsers.clear();
        }
        for (i = 0; i < NS; ++i) {
            r = stops.get(i);
            stack = r.task.stack;
            if (stack == null) continue;
            if (r.finishing) {
                stack.finishCurrentActivityLocked(r, 0, false);
                continue;
            }
            stack.stopActivityLocked(r);
        }
        for (i = 0; i < NF; ++i) {
            r = finishes.get(i);
            stack = r.task.stack;
            if (stack == null) continue;
            activityRemoved |= stack.destroyActivityLocked(r, true, "finish-idle");
        }
        if (!booting) {
            if (startingUsers != null) {
                for (i = 0; i < startingUsers.size(); ++i) {
                    this.mService.finishUserSwitch(startingUsers.get(i));
                }
            }
            if (this.mStartingBackgroundUsers.size() > 0) {
                startingUsers = new ArrayList<UserState>(this.mStartingBackgroundUsers);
                this.mStartingBackgroundUsers.clear();
                for (i = 0; i < startingUsers.size(); ++i) {
                    this.mService.finishUserBoot(startingUsers.get(i));
                }
            }
        }
        this.mService.trimApplications();
        if (activityRemoved) {
            this.resumeTopActivitiesLocked();
        }
        return r;
    }

    boolean handleAppDiedLocked(ProcessRecord app) {
        boolean hasVisibleActivities = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                hasVisibleActivities |= stacks.get(stackNdx).handleAppDiedLocked(app);
            }
        }
        return hasVisibleActivities;
    }

    void closeSystemDialogsLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).closeSystemDialogsLocked();
            }
        }
    }

    void removeUserLocked(int userId) {
        this.mUserStackInFront.delete(userId);
    }

    boolean finishDisabledPackageActivitiesLocked(String packageName, Set<String> filterByClasses, boolean doit, boolean evenPersistent, int userId) {
        boolean didSomething = false;
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (!stack.finishDisabledPackageActivitiesLocked(packageName, filterByClasses, doit, evenPersistent, userId)) continue;
                didSomething = true;
            }
        }
        return didSomething;
    }

    void updatePreviousProcessLocked(ActivityRecord r) {
        ProcessRecord fgApp = null;
        block0: for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (!this.isFrontStack(stack)) continue;
                if (stack.mResumedActivity != null) {
                    fgApp = stack.mResumedActivity.app;
                    continue block0;
                }
                if (stack.mPausingActivity == null) continue block0;
                fgApp = stack.mPausingActivity.app;
                continue block0;
            }
        }
        if (r.app != null && fgApp != null && r.app != fgApp && r.lastVisibleTime > this.mService.mPreviousProcessVisibleTime && r.app != this.mService.mHomeProcess) {
            this.mService.mPreviousProcess = r.app;
            this.mService.mPreviousProcessVisibleTime = r.lastVisibleTime;
        }
    }

    boolean resumeTopActivitiesLocked() {
        return this.resumeTopActivitiesLocked(null, null, null);
    }

    boolean resumeTopActivitiesLocked(ActivityStack targetStack, ActivityRecord target, Bundle targetOptions) {
        if (targetStack == null) {
            targetStack = this.mFocusedStack;
        }
        boolean result = false;
        if (this.isFrontStack(targetStack)) {
            result = targetStack.resumeTopActivityLocked(target, targetOptions);
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (stack == targetStack || !this.isFrontStack(stack)) continue;
                stack.resumeTopActivityLocked(null);
            }
        }
        return result;
    }

    void finishTopRunningActivityLocked(ProcessRecord app, String reason) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.finishTopRunningActivityLocked(app, reason);
            }
        }
    }

    void finishVoiceTask(IVoiceInteractionSession session) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.finishVoiceTask(session);
            }
        }
    }

    void findTaskToMoveToFrontLocked(TaskRecord task, int flags, Bundle options, String reason) {
        if ((flags & 2) == 0) {
            this.mUserLeaving = true;
        }
        if ((flags & 1) != 0) {
            task.setTaskToReturnTo(1);
        }
        if (task.stack == null) {
            Slog.e("ActivityManager", "findTaskToMoveToFrontLocked: can't move task=" + task + " to front. Stack is null");
            return;
        }
        task.stack.moveTaskToFrontLocked(task, false, options, task.getTopActivity() == null ? null : task.getTopActivity().appTimeTracker, reason);
    }

    ActivityStack getStack(int stackId) {
        ActivityContainer activityContainer = this.mActivityContainers.get(stackId);
        if (activityContainer != null) {
            return activityContainer.mStack;
        }
        return null;
    }

    ArrayList<ActivityStack> getStacks() {
        ArrayList<ActivityStack> allStacks = new ArrayList<ActivityStack>();
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            allStacks.addAll(this.mActivityDisplays.valueAt((int)displayNdx).mStacks);
        }
        return allStacks;
    }

    IBinder getHomeActivityToken() {
        ActivityRecord homeActivity = this.getHomeActivity();
        if (homeActivity != null) {
            return homeActivity.appToken;
        }
        return null;
    }

    ActivityRecord getHomeActivity() {
        return this.getHomeActivityForUser(this.mCurrentUser);
    }

    ActivityRecord getHomeActivityForUser(int userId) {
        ArrayList<TaskRecord> tasks = this.mHomeStack.getAllTasks();
        for (int taskNdx = tasks.size() - 1; taskNdx >= 0; --taskNdx) {
            TaskRecord task = tasks.get(taskNdx);
            if (!task.isHomeTask()) continue;
            ArrayList<ActivityRecord> activities = task.mActivities;
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isHomeActivity() || userId != -1 && r.userId != userId) continue;
                return r;
            }
        }
        return null;
    }

    ActivityContainer createVirtualActivityContainer(ActivityRecord parentActivity, IActivityContainerCallback callback) {
        VirtualActivityContainer activityContainer = new VirtualActivityContainer(parentActivity, callback);
        this.mActivityContainers.put(activityContainer.mStackId, activityContainer);
        parentActivity.mChildContainers.add(activityContainer);
        return activityContainer;
    }

    void removeChildActivityContainers(ActivityRecord parentActivity) {
        ArrayList<ActivityContainer> childStacks = parentActivity.mChildContainers;
        for (int containerNdx = childStacks.size() - 1; containerNdx >= 0; --containerNdx) {
            ActivityContainer container = childStacks.remove(containerNdx);
            container.release();
        }
    }

    void deleteActivityContainer(IActivityContainer container) {
        ActivityContainer activityContainer = (ActivityContainer)container;
        if (activityContainer != null) {
            int stackId = activityContainer.mStackId;
            this.mActivityContainers.remove(stackId);
            this.mWindowManager.removeStack(stackId);
        }
    }

    void resizeStackLocked(int stackId, Rect bounds) {
        ActivityStack stack = this.getStack(stackId);
        if (stack == null) {
            Slog.w("ActivityManager", "resizeStack: stackId " + stackId + " not found.");
            return;
        }
        ActivityRecord r = stack.topRunningActivityLocked(null);
        if (r != null && !r.task.mResizeable) {
            Slog.w("ActivityManager", "resizeStack: top task " + r.task + " not resizeable.");
            return;
        }
        Configuration overrideConfig = this.mWindowManager.resizeStack(stackId, bounds);
        if (stack.updateOverrideConfiguration(overrideConfig) && r != null) {
            boolean updated = stack.ensureActivityConfigurationLocked(r, 0);
            this.ensureActivitiesVisibleLocked(r, 0);
            if (!updated) {
                this.resumeTopActivitiesLocked(stack, null, null);
            }
        }
    }

    void resizeTaskLocked(TaskRecord task, Rect bounds) {
        task.mResizeable = true;
        ActivityStack currentStack = task.stack;
        if (currentStack.isHomeStack()) {
            return;
        }
        int matchingStackId = this.mWindowManager.getStackIdWithBounds(bounds);
        if (matchingStackId != -1) {
            if (currentStack != null && currentStack.mStackId == matchingStackId) {
                return;
            }
            this.moveTaskToStackLocked(task.taskId, matchingStackId, true);
            return;
        }
        if (currentStack != null && currentStack.numTasks() == 1) {
            this.resizeStackLocked(currentStack.mStackId, bounds);
            return;
        }
        int displayId = currentStack != null && currentStack.mDisplayId != -1 ? currentStack.mDisplayId : 0;
        ActivityStack newStack = this.createStackOnDisplay(this.getNextStackId(), displayId);
        if (newStack == null) {
            Slog.e("ActivityManager", "resizeTaskLocked: Can't create stack for task=" + task);
            return;
        }
        this.moveTaskToStackLocked(task.taskId, newStack.mStackId, true);
        this.resizeStackLocked(newStack.mStackId, bounds);
    }

    ActivityStack createStackOnDisplay(int stackId, int displayId) {
        ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
        if (activityDisplay == null) {
            return null;
        }
        ActivityContainer activityContainer = new ActivityContainer(stackId);
        this.mActivityContainers.put(stackId, activityContainer);
        activityContainer.attachToDisplayLocked(activityDisplay);
        return activityContainer.mStack;
    }

    int getNextStackId() {
        do {
            if (++this.mLastStackId > 0) continue;
            this.mLastStackId = 1;
        } while (this.getStack(this.mLastStackId) != null);
        return this.mLastStackId;
    }

    private boolean restoreRecentTaskLocked(TaskRecord task) {
        ActivityStack stack = null;
        if (this.mLeanbackOnlyDevice) {
            stack = this.mHomeStack;
        } else {
            ArrayList<ActivityStack> homeDisplayStacks = this.mHomeStack.mStacks;
            for (int stackNdx = homeDisplayStacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack tmpStack = homeDisplayStacks.get(stackNdx);
                if (tmpStack.isHomeStack() || !tmpStack.mFullscreen) continue;
                stack = tmpStack;
                break;
            }
        }
        if (stack == null) {
            stack = this.createStackOnDisplay(this.getNextStackId(), 0);
            this.moveHomeStack(true, "restoreRecentTask");
        }
        if (stack == null) {
            return false;
        }
        stack.addTask(task, false, false);
        ArrayList<ActivityRecord> activities = task.mActivities;
        for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord r = activities.get(activityNdx);
            this.mWindowManager.addAppToken(0, r.appToken, task.taskId, stack.mStackId, r.info.screenOrientation, r.fullscreen, (r.info.flags & 0x400) != 0, r.userId, r.info.configChanges, task.voiceSession != null, r.mLaunchTaskBehind);
        }
        return true;
    }

    void moveTaskToStackLocked(int taskId, int stackId, boolean toTop) {
        TaskRecord task = this.anyTaskForIdLocked(taskId);
        if (task == null) {
            Slog.w("ActivityManager", "moveTaskToStack: no task for id=" + taskId);
            return;
        }
        ActivityStack stack = this.getStack(stackId);
        if (stack == null) {
            Slog.w("ActivityManager", "moveTaskToStack: no stack for id=" + stackId);
            return;
        }
        this.mWindowManager.moveTaskToStack(taskId, stackId, toTop);
        if (task.stack != null) {
            task.stack.removeTask(task, "moveTaskToStack", false);
        }
        stack.addTask(task, toTop, true);
        stack.ensureActivitiesVisibleLocked(null, 0);
        this.resumeTopActivitiesLocked();
    }

    ActivityRecord findTaskLocked(ActivityRecord r) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord ar;
                ActivityStack stack = stacks.get(stackNdx);
                if (!r.isApplicationActivity() && !stack.isHomeStack() || !stack.mActivityContainer.isEligibleForNewTasks() || (ar = stack.findTaskLocked(r)) == null) continue;
                return ar;
            }
        }
        return null;
    }

    ActivityRecord findActivityLocked(Intent intent, ActivityInfo info) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityRecord ar = stacks.get(stackNdx).findActivityLocked(intent, info);
                if (ar == null) continue;
                return ar;
            }
        }
        return null;
    }

    void goingToSleepLocked() {
        this.scheduleSleepTimeout();
        if (!this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.acquire();
            if (this.mLaunchingActivity.isHeld()) {
                this.mLaunchingActivity.release();
                this.mService.mHandler.removeMessages(104);
            }
        }
        this.checkReadyForSleepLocked();
    }

    boolean shutdownLocked(int timeout) {
        boolean timedout;
        block5: {
            this.goingToSleepLocked();
            timedout = false;
            long endTime = System.currentTimeMillis() + (long)timeout;
            while (true) {
                boolean cantShutdown = false;
                for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                    ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
                    for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                        cantShutdown |= stacks.get(stackNdx).checkReadyForSleepLocked();
                    }
                }
                if (!cantShutdown) break block5;
                long timeRemaining = endTime - System.currentTimeMillis();
                if (timeRemaining <= 0L) break;
                try {
                    this.mService.wait(timeRemaining);
                }
                catch (InterruptedException e) {}
            }
            Slog.w("ActivityManager", "Activity manager shutdown timed out");
            timedout = true;
        }
        this.mSleepTimeout = true;
        this.checkReadyForSleepLocked();
        return timedout;
    }

    void comeOutOfSleepIfNeededLocked() {
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.awakeFromSleepingLocked();
                if (!this.isFrontStack(stack)) continue;
                this.resumeTopActivitiesLocked();
            }
        }
        this.mGoingToSleepActivities.clear();
    }

    void activitySleptLocked(ActivityRecord r) {
        this.mGoingToSleepActivities.remove(r);
        this.checkReadyForSleepLocked();
    }

    void checkReadyForSleepLocked() {
        if (!this.mService.isSleepingOrShuttingDown()) {
            return;
        }
        if (!this.mSleepTimeout) {
            boolean dontSleep = false;
            for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
                ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
                for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                    dontSleep |= stacks.get(stackNdx).checkReadyForSleepLocked();
                }
            }
            if (this.mStoppingActivities.size() > 0) {
                this.scheduleIdleLocked();
                dontSleep = true;
            }
            if (this.mGoingToSleepActivities.size() > 0) {
                dontSleep = true;
            }
            if (dontSleep) {
                return;
            }
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).goToSleep();
            }
        }
        this.removeSleepTimeouts();
        if (this.mGoingToSleep.isHeld()) {
            this.mGoingToSleep.release();
        }
        if (this.mService.mShuttingDown) {
            this.mService.notifyAll();
        }
    }

    boolean reportResumedActivityLocked(ActivityRecord r) {
        ActivityStack stack = r.task.stack;
        if (this.isFrontStack(stack)) {
            this.mService.updateUsageStats(r, true);
        }
        if (this.allResumedActivitiesComplete()) {
            this.ensureActivitiesVisibleLocked(null, 0);
            this.mWindowManager.executeAppTransition();
            return true;
        }
        return false;
    }

    void handleAppCrashLocked(ProcessRecord app) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                stacks.get(stackNdx).handleAppCrashLocked(app);
            }
        }
    }

    boolean requestVisibleBehindLocked(ActivityRecord r, boolean visible) {
        ActivityRecord next;
        ActivityStack stack = r.task.stack;
        if (stack == null) {
            return false;
        }
        boolean isVisible = stack.hasVisibleBehindActivity();
        ActivityRecord top = this.topRunningActivityLocked();
        if (top == null || top == r || visible == isVisible) {
            stack.setVisibleBehindActivity(visible ? r : null);
            return true;
        }
        if (visible && top.fullscreen) {
            return false;
        }
        if (!visible && stack.getVisibleBehindActivity() != r) {
            return false;
        }
        stack.setVisibleBehindActivity(visible ? r : null);
        if (!visible && (next = stack.findNextTranslucentActivity(r)) != null) {
            this.mService.convertFromTranslucent(next.appToken);
        }
        if (top.app != null && top.app.thread != null) {
            try {
                top.app.thread.scheduleBackgroundVisibleBehindChanged(top.appToken, visible);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
        return true;
    }

    void handleLaunchTaskBehindCompleteLocked(ActivityRecord r) {
        r.mLaunchTaskBehind = false;
        TaskRecord task = r.task;
        task.setLastThumbnail(task.stack.screenshotActivities(r));
        this.mRecentTasks.addLocked(task);
        this.mService.notifyTaskStackChangedLocked();
        this.mWindowManager.setAppVisibility(r.appToken, false);
    }

    void scheduleLaunchTaskBehindComplete(IBinder token) {
        this.mHandler.obtainMessage(112, token).sendToTarget();
    }

    void ensureActivitiesVisibleLocked(ActivityRecord starting, int configChanges) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            int topStackNdx;
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = topStackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.ensureActivitiesVisibleLocked(starting, configChanges);
            }
        }
    }

    void clearOtherAppTimeTrackers(AppTimeTracker except) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            int topStackNdx;
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = topStackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.clearOtherAppTimeTrackers(except);
            }
        }
    }

    void scheduleDestroyAllActivities(ProcessRecord app, String reason) {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            int numStacks = stacks.size();
            for (int stackNdx = 0; stackNdx < numStacks; ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.scheduleDestroyActivities(app, reason);
            }
        }
    }

    void releaseSomeActivitiesLocked(ProcessRecord app, String reason) {
        TaskRecord firstTask = null;
        ArraySet<TaskRecord> tasks = null;
        for (int i = 0; i < app.activities.size(); ++i) {
            ActivityRecord r = app.activities.get(i);
            if (r.finishing || r.state == ActivityStack.ActivityState.DESTROYING || r.state == ActivityStack.ActivityState.DESTROYED) {
                return;
            }
            if (r.visible || !r.stopped || !r.haveState || r.state == ActivityStack.ActivityState.RESUMED || r.state == ActivityStack.ActivityState.PAUSING || r.state == ActivityStack.ActivityState.PAUSED || r.state == ActivityStack.ActivityState.STOPPING || r.task == null) continue;
            if (firstTask == null) {
                firstTask = r.task;
                continue;
            }
            if (firstTask == r.task) continue;
            if (tasks == null) {
                tasks = new ArraySet<TaskRecord>();
                tasks.add(firstTask);
            }
            tasks.add(r.task);
        }
        if (tasks == null) {
            return;
        }
        int numDisplays = this.mActivityDisplays.size();
        for (int displayNdx = 0; displayNdx < numDisplays; ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = 0; stackNdx < stacks.size(); ++stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                if (stack.releaseSomeActivitiesLocked(app, tasks, reason) <= 0) continue;
                return;
            }
        }
    }

    boolean switchUserLocked(int userId, UserState uss) {
        this.mUserStackInFront.put(this.mCurrentUser, this.mFocusedStack.getStackId());
        int restoreStackId = this.mUserStackInFront.get(userId, 0);
        this.mCurrentUser = userId;
        this.mStartingUsers.add(uss);
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.switchUserLocked(userId);
                TaskRecord task = stack.topTask();
                if (task == null) continue;
                this.mWindowManager.moveTaskToTop(task.taskId);
            }
        }
        ActivityStack stack = this.getStack(restoreStackId);
        if (stack == null) {
            stack = this.mHomeStack;
        }
        boolean homeInFront = stack.isHomeStack();
        if (stack.isOnHomeDisplay()) {
            this.moveHomeStack(homeInFront, "switchUserOnHomeDisplay");
            TaskRecord task = stack.topTask();
            if (task != null) {
                this.mWindowManager.moveTaskToTop(task.taskId);
            }
        } else {
            this.resumeHomeStackTask(1, null, "switchUserOnOtherDisplay");
        }
        return homeInFront;
    }

    public void startBackgroundUserLocked(int userId, UserState uss) {
        this.mStartingBackgroundUsers.add(uss);
    }

    boolean isCurrentProfileLocked(int userId) {
        if (userId == this.mCurrentUser) {
            return true;
        }
        for (int i = 0; i < this.mService.mCurrentProfileIds.length; ++i) {
            if (this.mService.mCurrentProfileIds[i] != userId) continue;
            return true;
        }
        return false;
    }

    final ArrayList<ActivityRecord> processStoppingActivitiesLocked(boolean remove) {
        ArrayList<ActivityRecord> stops = null;
        boolean nowVisible = this.allResumedActivitiesVisible();
        for (int activityNdx = this.mStoppingActivities.size() - 1; activityNdx >= 0; --activityNdx) {
            ActivityRecord s = this.mStoppingActivities.get(activityNdx);
            boolean waitingVisible = this.mWaitingVisibleActivities.contains(s);
            if (waitingVisible && nowVisible) {
                this.mWaitingVisibleActivities.remove(s);
                if (s.finishing) {
                    this.mWindowManager.setAppVisibility(s.appToken, false);
                }
            }
            if (waitingVisible && !this.mService.isSleepingOrShuttingDown() || !remove) continue;
            if (stops == null) {
                stops = new ArrayList<ActivityRecord>();
            }
            stops.add(s);
            this.mStoppingActivities.remove(activityNdx);
        }
        return stops;
    }

    void validateTopActivitiesLocked() {
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack.ActivityState state;
                ActivityStack stack = stacks.get(stackNdx);
                ActivityRecord r = stack.topRunningActivityLocked(null);
                ActivityStack.ActivityState activityState = state = r == null ? ActivityStack.ActivityState.DESTROYED : r.state;
                if (this.isFrontStack(stack)) {
                    if (r == null) {
                        Slog.e("ActivityManager", "validateTop...: null top activity, stack=" + stack);
                        continue;
                    }
                    ActivityRecord pausing = stack.mPausingActivity;
                    if (pausing != null && pausing == r) {
                        Slog.e("ActivityManager", "validateTop...: top stack has pausing activity r=" + r + " state=" + (Object)((Object)state));
                    }
                    if (state == ActivityStack.ActivityState.INITIALIZING || state == ActivityStack.ActivityState.RESUMED) continue;
                    Slog.e("ActivityManager", "validateTop...: activity in front not resumed r=" + r + " state=" + (Object)((Object)state));
                    continue;
                }
                ActivityRecord resumed = stack.mResumedActivity;
                if (resumed != null && resumed == r) {
                    Slog.e("ActivityManager", "validateTop...: back stack has resumed activity r=" + r + " state=" + (Object)((Object)state));
                }
                if (r == null || state != ActivityStack.ActivityState.INITIALIZING && state != ActivityStack.ActivityState.RESUMED) continue;
                Slog.e("ActivityManager", "validateTop...: activity in back resumed r=" + r + " state=" + (Object)((Object)state));
            }
        }
    }

    private String lockTaskModeToString() {
        switch (this.mLockTaskModeState) {
            case 1: {
                return "LOCKED";
            }
            case 2: {
                return "PINNED";
            }
            case 0: {
                return "NONE";
            }
        }
        return "unknown=" + this.mLockTaskModeState;
    }

    public void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("mFocusedStack=" + this.mFocusedStack);
        pw.print(" mLastFocusedStack=");
        pw.println(this.mLastFocusedStack);
        pw.print(prefix);
        pw.println("mSleepTimeout=" + this.mSleepTimeout);
        pw.print(prefix);
        pw.println("mCurTaskId=" + this.mCurTaskId);
        pw.print(prefix);
        pw.println("mUserStackInFront=" + this.mUserStackInFront);
        pw.print(prefix);
        pw.println("mActivityContainers=" + this.mActivityContainers);
        pw.print(prefix);
        pw.print("mLockTaskModeState=" + this.lockTaskModeToString());
        SparseArray<String[]> packages = this.mService.mLockTaskPackages;
        if (packages.size() > 0) {
            pw.println(" mLockTaskPackages (userId:packages)=");
            for (int i = 0; i < packages.size(); ++i) {
                pw.print(prefix);
                pw.print(prefix);
                pw.print(packages.keyAt(i));
                pw.print(":");
                pw.println(Arrays.toString(packages.valueAt(i)));
            }
        }
        pw.println(" mLockTaskModeTasks" + this.mLockTaskModeTasks);
    }

    ArrayList<ActivityRecord> getDumpActivitiesLocked(String name) {
        return this.mFocusedStack.getDumpActivitiesLocked(name);
    }

    static boolean printThisActivity(PrintWriter pw, ActivityRecord activity, String dumpPackage, boolean needSep, String prefix) {
        if (activity != null && (dumpPackage == null || dumpPackage.equals(activity.packageName))) {
            if (needSep) {
                pw.println();
            }
            pw.print(prefix);
            pw.println(activity);
            return true;
        }
        return false;
    }

    boolean dumpActivitiesLocked(FileDescriptor fd, PrintWriter pw, boolean dumpAll, boolean dumpClient, String dumpPackage) {
        boolean printed = false;
        boolean needSep = false;
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.valueAt(displayNdx);
            pw.print("Display #");
            pw.print(activityDisplay.mDisplayId);
            pw.println(" (activities from top to bottom):");
            ArrayList<ActivityStack> stacks = activityDisplay.mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                StringBuilder stackHeader = new StringBuilder(128);
                stackHeader.append("  Stack #");
                stackHeader.append(stack.mStackId);
                stackHeader.append(":");
                printed |= stack.dumpActivitiesLocked(fd, pw, dumpAll, dumpClient, dumpPackage, needSep, stackHeader.toString());
                needSep = printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, stack.mLRUActivities, "    ", "Run", false, !dumpAll, false, dumpPackage, true, "    Running activities (most recent first):", null);
                boolean pr = ActivityStackSupervisor.printThisActivity(pw, stack.mPausingActivity, dumpPackage, needSep, "    mPausingActivity: ");
                if (pr) {
                    printed = true;
                    needSep = false;
                }
                if (pr = ActivityStackSupervisor.printThisActivity(pw, stack.mResumedActivity, dumpPackage, needSep, "    mResumedActivity: ")) {
                    printed = true;
                    needSep = false;
                }
                if (dumpAll) {
                    pr = ActivityStackSupervisor.printThisActivity(pw, stack.mLastPausedActivity, dumpPackage, needSep, "    mLastPausedActivity: ");
                    if (pr) {
                        printed = true;
                        needSep = true;
                    }
                    printed |= ActivityStackSupervisor.printThisActivity(pw, stack.mLastNoHistoryActivity, dumpPackage, needSep, "    mLastNoHistoryActivity: ");
                }
                needSep = printed;
            }
        }
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mFinishingActivities, "  ", "Fin", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to finish:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mStoppingActivities, "  ", "Stop", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to stop:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mWaitingVisibleActivities, "  ", "Wait", false, !dumpAll, false, dumpPackage, true, "  Activities waiting for another to become visible:", null);
        printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
        return printed |= ActivityStackSupervisor.dumpHistoryList(fd, pw, this.mGoingToSleepActivities, "  ", "Sleep", false, !dumpAll, false, dumpPackage, true, "  Activities waiting to sleep:", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dumpHistoryList(FileDescriptor fd, PrintWriter pw, List<ActivityRecord> list, String prefix, String label, boolean complete, boolean brief, boolean client, String dumpPackage, boolean needNL, String header1, String header2) {
        TaskRecord lastTask = null;
        String innerPrefix = null;
        String[] args = null;
        boolean printed = false;
        for (int i = list.size() - 1; i >= 0; --i) {
            boolean full;
            ActivityRecord r = list.get(i);
            if (dumpPackage != null && !dumpPackage.equals(r.packageName)) continue;
            if (innerPrefix == null) {
                innerPrefix = prefix + "      ";
                args = new String[]{};
            }
            printed = true;
            boolean bl = full = !brief && (complete || !r.isInHistory());
            if (needNL) {
                pw.println("");
                needNL = false;
            }
            if (header1 != null) {
                pw.println(header1);
                header1 = null;
            }
            if (header2 != null) {
                pw.println(header2);
                header2 = null;
            }
            if (lastTask != r.task) {
                lastTask = r.task;
                pw.print(prefix);
                pw.print(full ? "* " : "  ");
                pw.println(lastTask);
                if (full) {
                    lastTask.dump(pw, prefix + "  ");
                } else if (complete && lastTask.intent != null) {
                    pw.print(prefix);
                    pw.print("  ");
                    pw.println(lastTask.intent.toInsecureStringWithClip());
                }
            }
            pw.print(prefix);
            pw.print(full ? "  * " : "    ");
            pw.print(label);
            pw.print(" #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            if (full) {
                r.dump(pw, innerPrefix);
            } else if (complete) {
                pw.print(innerPrefix);
                pw.println(r.intent.toInsecureString());
                if (r.app != null) {
                    pw.print(innerPrefix);
                    pw.println(r.app);
                }
            }
            if (!client || r.app == null || r.app.thread == null) continue;
            pw.flush();
            try {
                TransferPipe tp = new TransferPipe();
                try {
                    r.app.thread.dumpActivity(tp.getWriteFd().getFileDescriptor(), r.appToken, innerPrefix, args);
                    tp.go(fd, 2000L);
                }
                finally {
                    tp.kill();
                }
            }
            catch (IOException e) {
                pw.println(innerPrefix + "Failure while dumping the activity: " + e);
            }
            catch (RemoteException e) {
                pw.println(innerPrefix + "Got a RemoteException while dumping the activity");
            }
            needNL = true;
        }
        return printed;
    }

    void scheduleIdleTimeoutLocked(ActivityRecord next) {
        Message msg = this.mHandler.obtainMessage(100, next);
        this.mHandler.sendMessageDelayed(msg, 10000L);
    }

    final void scheduleIdleLocked() {
        this.mHandler.sendEmptyMessage(101);
    }

    void removeTimeoutsForActivityLocked(ActivityRecord r) {
        this.mHandler.removeMessages(100, r);
    }

    final void scheduleResumeTopActivities() {
        if (!this.mHandler.hasMessages(102)) {
            this.mHandler.sendEmptyMessage(102);
        }
    }

    void removeSleepTimeouts() {
        this.mSleepTimeout = false;
        this.mHandler.removeMessages(103);
    }

    final void scheduleSleepTimeout() {
        this.removeSleepTimeouts();
        this.mHandler.sendEmptyMessageDelayed(103, 5000L);
    }

    @Override
    public void onDisplayAdded(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(105, displayId, 0));
    }

    @Override
    public void onDisplayRemoved(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(107, displayId, 0));
    }

    @Override
    public void onDisplayChanged(int displayId) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(106, displayId, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayAdded(int displayId) {
        boolean newDisplay;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            boolean bl = newDisplay = this.mActivityDisplays.get(displayId) == null;
            if (newDisplay) {
                ActivityDisplay activityDisplay = new ActivityDisplay(displayId);
                if (activityDisplay.mDisplay == null) {
                    Slog.w("ActivityManager", "Display " + displayId + " gone before initialization complete");
                    return;
                }
                this.mActivityDisplays.put(displayId, activityDisplay);
            }
        }
        if (newDisplay) {
            this.mWindowManager.onDisplayAdded(displayId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayRemoved(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
            if (activityDisplay != null) {
                ArrayList<ActivityStack> stacks = activityDisplay.mStacks;
                for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                    stacks.get((int)stackNdx).mActivityContainer.detachLocked();
                }
                this.mActivityDisplays.remove(displayId);
            }
        }
        this.mWindowManager.onDisplayRemoved(displayId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisplayChanged(int displayId) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            ActivityDisplay activityDisplay = this.mActivityDisplays.get(displayId);
            if (activityDisplay != null) {
                // empty if block
            }
        }
        this.mWindowManager.onDisplayChanged(displayId);
    }

    private ActivityManager.StackInfo getStackInfoLocked(ActivityStack stack) {
        ActivityManager.StackInfo info = new ActivityManager.StackInfo();
        this.mWindowManager.getStackBounds(stack.mStackId, info.bounds);
        info.displayId = 0;
        info.stackId = stack.mStackId;
        ArrayList<TaskRecord> tasks = stack.getAllTasks();
        int numTasks = tasks.size();
        int[] taskIds = new int[numTasks];
        String[] taskNames = new String[numTasks];
        for (int i = 0; i < numTasks; ++i) {
            TaskRecord task = tasks.get(i);
            taskIds[i] = task.taskId;
            taskNames[i] = task.origActivity != null ? task.origActivity.flattenToString() : (task.realActivity != null ? task.realActivity.flattenToString() : (task.getTopActivity() != null ? task.getTopActivity().packageName : "unknown"));
        }
        info.taskIds = taskIds;
        info.taskNames = taskNames;
        return info;
    }

    ActivityManager.StackInfo getStackInfoLocked(int stackId) {
        ActivityStack stack = this.getStack(stackId);
        if (stack != null) {
            return this.getStackInfoLocked(stack);
        }
        return null;
    }

    ArrayList<ActivityManager.StackInfo> getAllStackInfosLocked() {
        ArrayList<ActivityManager.StackInfo> list = new ArrayList<ActivityManager.StackInfo>();
        for (int displayNdx = 0; displayNdx < this.mActivityDisplays.size(); ++displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int ndx = stacks.size() - 1; ndx >= 0; --ndx) {
                list.add(this.getStackInfoLocked(stacks.get(ndx)));
            }
        }
        return list;
    }

    TaskRecord getLockedTaskLocked() {
        int top = this.mLockTaskModeTasks.size() - 1;
        if (top >= 0) {
            return this.mLockTaskModeTasks.get(top);
        }
        return null;
    }

    boolean isLockedTask(TaskRecord task) {
        return this.mLockTaskModeTasks.contains(task);
    }

    boolean isLastLockedTask(TaskRecord task) {
        return this.mLockTaskModeTasks.size() == 1 && this.mLockTaskModeTasks.contains(task);
    }

    void removeLockedTaskLocked(TaskRecord task) {
        if (!this.mLockTaskModeTasks.remove(task)) {
            return;
        }
        if (this.mLockTaskModeTasks.isEmpty()) {
            Message lockTaskMsg = Message.obtain();
            lockTaskMsg.arg1 = task.userId;
            lockTaskMsg.what = 110;
            this.mHandler.sendMessage(lockTaskMsg);
        }
    }

    void showLockTaskToast() {
        this.mLockTaskNotify.showToast(this.mLockTaskModeState);
    }

    void showLockTaskEscapeMessageLocked(TaskRecord task) {
        if (this.mLockTaskModeTasks.contains(task)) {
            this.mHandler.sendEmptyMessage(113);
        }
    }

    void setLockTaskModeLocked(TaskRecord task, int lockTaskModeState, String reason, boolean andResume) {
        if (task == null) {
            TaskRecord lockedTask = this.getLockedTaskLocked();
            if (lockedTask != null) {
                this.removeLockedTaskLocked(lockedTask);
                if (!this.mLockTaskModeTasks.isEmpty()) {
                    lockedTask.performClearTaskLocked();
                    this.resumeTopActivitiesLocked();
                    return;
                }
            }
            return;
        }
        if (task.mLockTaskAuth == 0) {
            return;
        }
        if (this.isLockTaskModeViolation(task)) {
            Slog.e("ActivityManager", "setLockTaskMode: Attempt to start an unauthorized lock task.");
            return;
        }
        if (this.mLockTaskModeTasks.isEmpty()) {
            Message lockTaskMsg = Message.obtain();
            lockTaskMsg.obj = task.intent.getComponent().getPackageName();
            lockTaskMsg.arg1 = task.userId;
            lockTaskMsg.what = 109;
            lockTaskMsg.arg2 = lockTaskModeState;
            this.mHandler.sendMessage(lockTaskMsg);
        }
        this.mLockTaskModeTasks.remove(task);
        this.mLockTaskModeTasks.add(task);
        if (task.mLockTaskUid == -1) {
            task.mLockTaskUid = task.mCallingUid;
        }
        if (andResume) {
            this.findTaskToMoveToFrontLocked(task, 0, null, reason);
            this.resumeTopActivitiesLocked();
        }
    }

    boolean isLockTaskModeViolation(TaskRecord task) {
        return this.isLockTaskModeViolation(task, false);
    }

    boolean isLockTaskModeViolation(TaskRecord task, boolean isNewClearTask) {
        if (this.getLockedTaskLocked() == task && !isNewClearTask) {
            return false;
        }
        int lockTaskAuth = task.mLockTaskAuth;
        switch (lockTaskAuth) {
            case 0: {
                return !this.mLockTaskModeTasks.isEmpty();
            }
            case 2: 
            case 3: 
            case 4: {
                return false;
            }
            case 1: {
                return !this.mLockTaskModeTasks.isEmpty();
            }
        }
        Slog.w("ActivityManager", "isLockTaskModeViolation: invalid lockTaskAuth value=" + lockTaskAuth);
        return true;
    }

    void onLockTaskPackagesUpdatedLocked() {
        TaskRecord task;
        boolean didSomething = false;
        for (int taskNdx = this.mLockTaskModeTasks.size() - 1; taskNdx >= 0; --taskNdx) {
            boolean isWhitelisted;
            TaskRecord lockedTask = this.mLockTaskModeTasks.get(taskNdx);
            boolean wasWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            lockedTask.setLockTaskAuth();
            boolean bl = isWhitelisted = lockedTask.mLockTaskAuth == 2 || lockedTask.mLockTaskAuth == 3;
            if (!wasWhitelisted || isWhitelisted) continue;
            this.removeLockedTaskLocked(lockedTask);
            lockedTask.performClearTaskLocked();
            didSomething = true;
        }
        for (int displayNdx = this.mActivityDisplays.size() - 1; displayNdx >= 0; --displayNdx) {
            ArrayList<ActivityStack> stacks = this.mActivityDisplays.valueAt((int)displayNdx).mStacks;
            for (int stackNdx = stacks.size() - 1; stackNdx >= 0; --stackNdx) {
                ActivityStack stack = stacks.get(stackNdx);
                stack.onLockTaskPackagesUpdatedLocked();
            }
        }
        ActivityRecord r = this.topRunningActivityLocked();
        TaskRecord taskRecord = task = r != null ? r.task : null;
        if (this.mLockTaskModeTasks.isEmpty() && task != null && task.mLockTaskAuth == 2) {
            this.setLockTaskModeLocked(task, 1, "package updated", false);
            didSomething = true;
        }
        if (didSomething) {
            this.resumeTopActivitiesLocked();
        }
    }

    int getLockTaskModeState() {
        return this.mLockTaskModeState;
    }

    private boolean isLeanbackOnlyDevice() {
        boolean onLeanbackOnly = false;
        try {
            onLeanbackOnly = AppGlobals.getPackageManager().hasSystemFeature("android.software.leanback_only");
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return onLeanbackOnly;
    }

    static {
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.IMAGE_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.media.action.VIDEO_CAPTURE", "android.permission.CAMERA");
        ACTION_TO_RUNTIME_PERMISSION.put("android.intent.action.CALL", "android.permission.CALL_PHONE");
    }

    class VirtualActivityDisplay
    extends ActivityDisplay {
        VirtualDisplay mVirtualDisplay;

        VirtualActivityDisplay(int width, int height, int density) {
            DisplayManagerGlobal dm = DisplayManagerGlobal.getInstance();
            this.mVirtualDisplay = dm.createVirtualDisplay(ActivityStackSupervisor.this.mService.mContext, null, ActivityStackSupervisor.VIRTUAL_DISPLAY_BASE_NAME, width, height, density, null, 9, null, null);
            this.init(this.mVirtualDisplay.getDisplay());
            ActivityStackSupervisor.this.mWindowManager.handleDisplayAdded(this.mDisplayId);
        }

        void setSurface(Surface surface) {
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.setSurface(surface);
            }
        }

        @Override
        void detachActivitiesLocked(ActivityStack stack) {
            super.detachActivitiesLocked(stack);
            if (this.mVirtualDisplay != null) {
                this.mVirtualDisplay.release();
                this.mVirtualDisplay = null;
            }
        }

        @Override
        public String toString() {
            return "VirtualActivityDisplay={" + this.mDisplayId + "}";
        }
    }

    class ActivityDisplay {
        int mDisplayId;
        Display mDisplay;
        DisplayInfo mDisplayInfo = new DisplayInfo();
        final ArrayList<ActivityStack> mStacks = new ArrayList();
        ActivityRecord mVisibleBehindActivity;

        ActivityDisplay() {
        }

        ActivityDisplay(int displayId) {
            Display display = ActivityStackSupervisor.this.mDisplayManager.getDisplay(displayId);
            if (display == null) {
                return;
            }
            this.init(display);
        }

        void init(Display display) {
            this.mDisplay = display;
            this.mDisplayId = display.getDisplayId();
            this.mDisplay.getDisplayInfo(this.mDisplayInfo);
        }

        void attachActivities(ActivityStack stack) {
            this.mStacks.add(stack);
        }

        void detachActivitiesLocked(ActivityStack stack) {
            this.mStacks.remove(stack);
        }

        void getBounds(Point bounds) {
            this.mDisplay.getDisplayInfo(this.mDisplayInfo);
            bounds.x = this.mDisplayInfo.appWidth;
            bounds.y = this.mDisplayInfo.appHeight;
        }

        void setVisibleBehindActivity(ActivityRecord r) {
            this.mVisibleBehindActivity = r;
        }

        boolean hasVisibleBehindActivity() {
            return this.mVisibleBehindActivity != null;
        }

        public String toString() {
            return "ActivityDisplay={" + this.mDisplayId + " numStacks=" + this.mStacks.size() + "}";
        }
    }

    private class VirtualActivityContainer
    extends ActivityContainer {
        Surface mSurface;
        boolean mDrawn;

        VirtualActivityContainer(ActivityRecord parent, IActivityContainerCallback callback) {
            super(ActivityStackSupervisor.this.getNextStackId());
            this.mDrawn = false;
            this.mParentActivity = parent;
            this.mCallback = callback;
            this.mContainerState = 1;
            this.mIdString = "VirtualActivityContainer{" + this.mStackId + ", parent=" + this.mParentActivity + "}";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSurface(Surface surface, int width, int height, int density) {
            super.setSurface(surface, width, height, density);
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                long origId = Binder.clearCallingIdentity();
                try {
                    this.setSurfaceLocked(surface, width, height, density);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        private void setSurfaceLocked(Surface surface, int width, int height, int density) {
            if (this.mContainerState == 2) {
                return;
            }
            VirtualActivityDisplay virtualActivityDisplay = (VirtualActivityDisplay)this.mActivityDisplay;
            if (virtualActivityDisplay == null) {
                virtualActivityDisplay = new VirtualActivityDisplay(width, height, density);
                this.mActivityDisplay = virtualActivityDisplay;
                ActivityStackSupervisor.this.mActivityDisplays.put(virtualActivityDisplay.mDisplayId, virtualActivityDisplay);
                this.attachToDisplayLocked(virtualActivityDisplay);
            }
            if (this.mSurface != null) {
                this.mSurface.release();
            }
            this.mSurface = surface;
            if (surface != null) {
                this.mStack.resumeTopActivityLocked(null);
            } else {
                this.mContainerState = 1;
                ((VirtualActivityDisplay)this.mActivityDisplay).setSurface(null);
                if (this.mStack.mPausingActivity == null && this.mStack.mResumedActivity != null) {
                    this.mStack.startPausingLocked(false, true, false, false);
                }
            }
            this.setSurfaceIfReadyLocked();
        }

        @Override
        boolean isAttachedLocked() {
            return this.mSurface != null && super.isAttachedLocked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void setDrawn() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                this.mDrawn = true;
                this.setSurfaceIfReadyLocked();
            }
        }

        @Override
        boolean isEligibleForNewTasks() {
            return false;
        }

        private void setSurfaceIfReadyLocked() {
            if (this.mDrawn && this.mSurface != null && this.mContainerState == 1) {
                ((VirtualActivityDisplay)this.mActivityDisplay).setSurface(this.mSurface);
                this.mContainerState = 0;
            }
        }
    }

    class ActivityContainer
    extends IActivityContainer.Stub {
        static final int FORCE_NEW_TASK_FLAGS = 0x18010000;
        final int mStackId;
        IActivityContainerCallback mCallback = null;
        final ActivityStack mStack;
        ActivityRecord mParentActivity = null;
        String mIdString;
        boolean mVisible = true;
        ActivityDisplay mActivityDisplay;
        static final int CONTAINER_STATE_HAS_SURFACE = 0;
        static final int CONTAINER_STATE_NO_SURFACE = 1;
        static final int CONTAINER_STATE_FINISHING = 2;
        int mContainerState = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ActivityContainer(int stackId) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                this.mStackId = stackId;
                this.mStack = new ActivityStack(this, ActivityStackSupervisor.this.mRecentTasks);
                this.mIdString = "ActivtyContainer{" + this.mStackId + "}";
            }
        }

        void attachToDisplayLocked(ActivityDisplay activityDisplay) {
            this.mActivityDisplay = activityDisplay;
            this.mStack.mDisplayId = activityDisplay.mDisplayId;
            this.mStack.mStacks = activityDisplay.mStacks;
            activityDisplay.attachActivities(this.mStack);
            ActivityStackSupervisor.this.mWindowManager.attachStack(this.mStackId, activityDisplay.mDisplayId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void attachToDisplay(int displayId) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                ActivityDisplay activityDisplay = (ActivityDisplay)ActivityStackSupervisor.this.mActivityDisplays.get(displayId);
                if (activityDisplay == null) {
                    return;
                }
                this.attachToDisplayLocked(activityDisplay);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getDisplayId() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                if (this.mActivityDisplay != null) {
                    return this.mActivityDisplay.mDisplayId;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getStackId() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                return this.mStackId;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean injectEvent(InputEvent event) {
            long origId = Binder.clearCallingIdentity();
            try {
                ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                synchronized (activityManagerService) {
                    if (this.mActivityDisplay != null) {
                        boolean bl = ActivityStackSupervisor.this.mInputManagerInternal.injectInputEvent(event, this.mActivityDisplay.mDisplayId, 0);
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(origId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                if (this.mContainerState == 2) {
                    return;
                }
                this.mContainerState = 2;
                long origId = Binder.clearCallingIdentity();
                try {
                    this.mStack.finishAllActivitiesLocked(false);
                    ActivityStackSupervisor.this.removePendingActivityLaunchesLocked(this.mStack);
                }
                finally {
                    Binder.restoreCallingIdentity(origId);
                }
            }
        }

        protected void detachLocked() {
            if (this.mActivityDisplay != null) {
                this.mActivityDisplay.detachActivitiesLocked(this.mStack);
                this.mActivityDisplay = null;
                this.mStack.mDisplayId = -1;
                this.mStack.mStacks = null;
                ActivityStackSupervisor.this.mWindowManager.detachStack(this.mStackId);
            }
        }

        @Override
        public final int startActivity(Intent intent) {
            ActivityStackSupervisor.this.mService.enforceNotIsolatedCaller("ActivityContainer.startActivity");
            int userId = ActivityStackSupervisor.this.mService.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), ActivityStackSupervisor.this.mCurrentUser, false, 2, "ActivityContainer", null);
            String mimeType = intent.getType();
            Uri data = intent.getData();
            if (mimeType == null && data != null && "content".equals(data.getScheme())) {
                mimeType = ActivityStackSupervisor.this.mService.getProviderMimeType(data, userId);
            }
            this.checkEmbeddedAllowedInner(userId, intent, mimeType);
            intent.addFlags(0x18010000);
            return ActivityStackSupervisor.this.startActivityMayWait(null, -1, null, intent, mimeType, null, null, null, null, 0, 0, null, null, null, null, false, userId, this, null);
        }

        @Override
        public final int startActivityIntentSender(IIntentSender intentSender) throws TransactionTooLargeException {
            ActivityStackSupervisor.this.mService.enforceNotIsolatedCaller("ActivityContainer.startActivityIntentSender");
            if (!(intentSender instanceof PendingIntentRecord)) {
                throw new IllegalArgumentException("Bad PendingIntent object");
            }
            int userId = ActivityStackSupervisor.this.mService.handleIncomingUser(Binder.getCallingPid(), Binder.getCallingUid(), ActivityStackSupervisor.this.mCurrentUser, false, 2, "ActivityContainer", null);
            PendingIntentRecord pendingIntent = (PendingIntentRecord)intentSender;
            this.checkEmbeddedAllowedInner(userId, pendingIntent.key.requestIntent, pendingIntent.key.requestResolvedType);
            return pendingIntent.sendInner(0, null, null, null, null, null, null, 0, 0x18010000, 0x18010000, null, this);
        }

        private void checkEmbeddedAllowedInner(int userId, Intent intent, String resolvedType) {
            ActivityInfo aInfo = ActivityStackSupervisor.this.resolveActivity(intent, resolvedType, 0, null, userId);
            if (aInfo != null && (aInfo.flags & Integer.MIN_VALUE) == 0) {
                throw new SecurityException("Attempt to embed activity that has not set allowEmbedded=\"true\"");
            }
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public void setSurface(Surface surface, int width, int height, int density) {
            ActivityStackSupervisor.this.mService.enforceNotIsolatedCaller("ActivityContainer.attachToSurface");
        }

        ActivityStackSupervisor getOuter() {
            return ActivityStackSupervisor.this;
        }

        boolean isAttachedLocked() {
            return this.mActivityDisplay != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void getBounds(Point outBounds) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                if (this.mActivityDisplay != null) {
                    this.mActivityDisplay.getBounds(outBounds);
                } else {
                    outBounds.set(0, 0);
                }
            }
        }

        void setVisible(boolean visible) {
            if (this.mVisible != visible) {
                this.mVisible = visible;
                if (this.mCallback != null) {
                    ActivityStackSupervisor.this.mHandler.obtainMessage(108, visible ? 1 : 0, 0, this).sendToTarget();
                }
            }
        }

        void setDrawn() {
        }

        boolean isEligibleForNewTasks() {
            return true;
        }

        void onTaskListEmptyLocked() {
            this.detachLocked();
            ActivityStackSupervisor.this.deleteActivityContainer(this);
            ActivityStackSupervisor.this.mHandler.obtainMessage(111, this).sendToTarget();
        }

        public String toString() {
            return this.mIdString + (this.mActivityDisplay == null ? "N" : "A");
        }
    }

    private final class ActivityStackSupervisorHandler
    extends Handler {
        public ActivityStackSupervisorHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void activityIdleInternal(ActivityRecord r) {
            ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
            synchronized (activityManagerService) {
                ActivityStackSupervisor.this.activityIdleInternalLocked(r != null ? r.appToken : null, true, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 100: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        Message nmsg = ActivityStackSupervisor.this.mHandler.obtainMessage(100);
                        nmsg.obj = msg.obj;
                        ActivityStackSupervisor.this.mHandler.sendMessageDelayed(nmsg, 10000L);
                        return;
                    }
                    this.activityIdleInternal((ActivityRecord)msg.obj);
                    break;
                }
                case 101: {
                    this.activityIdleInternal((ActivityRecord)msg.obj);
                    break;
                }
                case 102: {
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        ActivityStackSupervisor.this.resumeTopActivitiesLocked();
                        break;
                    }
                }
                case 103: {
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        if (ActivityStackSupervisor.this.mService.isSleepingOrShuttingDown()) {
                            Slog.w("ActivityManager", "Sleep timeout!  Sleeping now.");
                            ActivityStackSupervisor.this.mSleepTimeout = true;
                            ActivityStackSupervisor.this.checkReadyForSleepLocked();
                        }
                        break;
                    }
                }
                case 104: {
                    if (ActivityStackSupervisor.this.mService.mDidDexOpt) {
                        ActivityStackSupervisor.this.mService.mDidDexOpt = false;
                        ActivityStackSupervisor.this.mHandler.sendEmptyMessageDelayed(104, 10000L);
                        return;
                    }
                    ActivityManagerService nmsg = ActivityStackSupervisor.this.mService;
                    synchronized (nmsg) {
                        if (ActivityStackSupervisor.this.mLaunchingActivity.isHeld()) {
                            Slog.w("ActivityManager", "Launch timeout has expired, giving up wake lock!");
                            ActivityStackSupervisor.this.mLaunchingActivity.release();
                        }
                        break;
                    }
                }
                case 105: {
                    ActivityStackSupervisor.this.handleDisplayAdded(msg.arg1);
                    break;
                }
                case 106: {
                    ActivityStackSupervisor.this.handleDisplayChanged(msg.arg1);
                    break;
                }
                case 107: {
                    ActivityStackSupervisor.this.handleDisplayRemoved(msg.arg1);
                    break;
                }
                case 108: {
                    ActivityContainer container = (ActivityContainer)msg.obj;
                    IActivityContainerCallback callback = container.mCallback;
                    if (callback == null) break;
                    try {
                        callback.setVisible(container.asBinder(), msg.arg1 == 1);
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 109: {
                    try {
                        if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                            ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                        }
                        ActivityStackSupervisor.this.mLockTaskNotify.show(true);
                        ActivityStackSupervisor.this.mLockTaskModeState = msg.arg2;
                        if (ActivityStackSupervisor.this.getStatusBarService() != null) {
                            int flags = 0;
                            if (ActivityStackSupervisor.this.mLockTaskModeState == 1) {
                                flags = 62849024;
                            } else if (ActivityStackSupervisor.this.mLockTaskModeState == 2) {
                                flags = 43974656;
                            }
                            ActivityStackSupervisor.this.getStatusBarService().disable(flags, ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.this.mService.mContext.getPackageName());
                        }
                        ActivityStackSupervisor.this.mWindowManager.disableKeyguard(ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.LOCK_TASK_TAG);
                        if (ActivityStackSupervisor.this.getDevicePolicyManager() == null) break;
                        ActivityStackSupervisor.this.getDevicePolicyManager().notifyLockTaskModeChanged(true, (String)msg.obj, msg.arg1);
                        break;
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                case 110: {
                    try {
                        if (ActivityStackSupervisor.this.getStatusBarService() != null) {
                            ActivityStackSupervisor.this.getStatusBarService().disable(0, ActivityStackSupervisor.this.mToken, ActivityStackSupervisor.this.mService.mContext.getPackageName());
                        }
                        ActivityStackSupervisor.this.mWindowManager.reenableKeyguard(ActivityStackSupervisor.this.mToken);
                        if (ActivityStackSupervisor.this.getDevicePolicyManager() != null) {
                            ActivityStackSupervisor.this.getDevicePolicyManager().notifyLockTaskModeChanged(false, null, msg.arg1);
                        }
                        if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                            ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                        }
                        ActivityStackSupervisor.this.mLockTaskNotify.show(false);
                        try {
                            boolean shouldLockKeyguard;
                            boolean bl = shouldLockKeyguard = Settings.Secure.getInt(ActivityStackSupervisor.this.mService.mContext.getContentResolver(), "lock_to_app_exit_locked") != 0;
                            if (ActivityStackSupervisor.this.mLockTaskModeState != 2 || !shouldLockKeyguard) break;
                            ActivityStackSupervisor.this.mWindowManager.lockNow(null);
                            ActivityStackSupervisor.this.mWindowManager.dismissKeyguard();
                            new LockPatternUtils(ActivityStackSupervisor.this.mService.mContext).requireCredentialEntry(-1);
                        }
                        catch (Settings.SettingNotFoundException e) {
                            // empty catch block
                        }
                        break;
                    }
                    catch (RemoteException ex) {
                        throw new RuntimeException(ex);
                    }
                    finally {
                        ActivityStackSupervisor.this.mLockTaskModeState = 0;
                    }
                }
                case 113: {
                    if (ActivityStackSupervisor.this.mLockTaskNotify == null) {
                        ActivityStackSupervisor.this.mLockTaskNotify = new LockTaskNotify(ActivityStackSupervisor.this.mService.mContext);
                    }
                    ActivityStackSupervisor.this.mLockTaskNotify.showToast(2);
                    break;
                }
                case 111: {
                    ActivityContainer container = (ActivityContainer)msg.obj;
                    IActivityContainerCallback callback = container.mCallback;
                    if (callback == null) break;
                    try {
                        callback.onAllActivitiesComplete(container.asBinder());
                    }
                    catch (RemoteException e) {}
                    break;
                }
                case 112: {
                    ActivityManagerService activityManagerService = ActivityStackSupervisor.this.mService;
                    synchronized (activityManagerService) {
                        ActivityRecord r = ActivityRecord.forTokenLocked((IBinder)msg.obj);
                        if (r != null) {
                            ActivityStackSupervisor.this.handleLaunchTaskBehindCompleteLocked(r);
                        }
                        break;
                    }
                }
            }
        }
    }

    static class PendingActivityLaunch {
        final ActivityRecord r;
        final ActivityRecord sourceRecord;
        final int startFlags;
        final ActivityStack stack;

        PendingActivityLaunch(ActivityRecord _r, ActivityRecord _sourceRecord, int _startFlags, ActivityStack _stack) {
            this.r = _r;
            this.sourceRecord = _sourceRecord;
            this.startFlags = _startFlags;
            this.stack = _stack;
        }
    }
}

