/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.wifi.IWifiManager;
import android.net.wifi.WifiActivityEnergyInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelFormatException;
import android.os.PowerManagerInternal;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.WorkSource;
import android.telephony.DataConnectionRealTimeInfo;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import android.util.IntArray;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatteryStatsHelper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.PowerProfile;
import com.android.server.FgThread;
import com.android.server.LocalServices;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class BatteryStatsService
extends IBatteryStats.Stub
implements PowerManagerInternal.LowPowerModeListener {
    static final String TAG = "BatteryStatsService";
    static IBatteryStats sService;
    final BatteryStatsImpl mStats;
    final BatteryStatsHandler mHandler;
    Context mContext;
    PowerManagerInternal mPowerManagerInternal;
    final int UPDATE_CPU = 1;
    final int UPDATE_WIFI = 2;
    final int UPDATE_RADIO = 4;
    final int UPDATE_BT = 8;
    final int UPDATE_ALL = 15;
    private final Object mExternalStatsLock = new Object();
    @GuardedBy(value="mExternalStatsLock")
    private IWifiManager mWifiManager;
    @GuardedBy(value="mExternalStatsLock")
    private WifiActivityEnergyInfo mLastInfo = new WifiActivityEnergyInfo(0L, 0, 0L, 0L, 0L, 0L);

    BatteryStatsService(File systemDir, Handler handler) {
        this.mHandler = new BatteryStatsHandler(FgThread.getHandler().getLooper());
        this.mStats = new BatteryStatsImpl(systemDir, handler, this.mHandler);
    }

    public void publish(Context context) {
        this.mContext = context;
        ServiceManager.addService("batterystats", this.asBinder());
        this.mStats.setNumSpeedSteps(new PowerProfile(this.mContext).getNumSpeedSteps());
        this.mStats.setRadioScanningTimeout((long)this.mContext.getResources().getInteger(17694732) * 1000L);
        this.mStats.setPowerProfile(new PowerProfile(context));
    }

    public void initPowerManagement() {
        this.mPowerManagerInternal = LocalServices.getService(PowerManagerInternal.class);
        this.mPowerManagerInternal.registerLowPowerModeObserver(this);
        this.mStats.notePowerSaveMode(this.mPowerManagerInternal.getLowPowerModeEnabled());
        new WakeupReasonThread().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Slog.w("BatteryStats", "Writing battery stats before shutdown...");
        this.updateExternalStats("shutdown", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.shutdownLocked();
        }
    }

    public static IBatteryStats getService() {
        if (sService != null) {
            return sService;
        }
        IBinder b = ServiceManager.getService("batterystats");
        sService = BatteryStatsService.asInterface(b);
        return sService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onLowPowerModeChanged(boolean enabled) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePowerSaveMode(enabled);
        }
    }

    public BatteryStatsImpl getActiveStatistics() {
        return this.mStats;
    }

    public void scheduleWriteToDisk() {
        this.mHandler.sendEmptyMessage(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeUid(int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.removeUidStatsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.addIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeIsolatedUid(int isolatedUid, int appUid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.scheduleRemoveIsolatedUidLocked(isolatedUid, appUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessStart(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessCrash(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessCrashLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessAnr(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessAnrLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessState(String name, int uid, int state) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessStateLocked(name, uid, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void noteProcessFinish(String name, int uid) {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteProcessFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getStatistics() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.updateExternalStats("get-stats", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor getStatisticsStream() {
        this.mContext.enforceCallingPermission("android.permission.BATTERY_STATS", null);
        Parcel out = Parcel.obtain();
        this.updateExternalStats("get-stats", 15);
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.writeToParcel(out, 0);
        }
        byte[] data = out.marshall();
        out.recycle();
        try {
            return ParcelFileDescriptor.fromData(data, "battery-stats");
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to create shared memory", e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCharging() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            return this.mStats.isCharging();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeBatteryTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeBatteryTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long computeChargeTimeRemaining() {
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            long time = this.mStats.computeChargeTimeRemaining(SystemClock.elapsedRealtime());
            return time >= 0L ? time / 1000L : time;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteEvent(int code, String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteEventLocked(code, name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteSyncFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteSyncFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteJobFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteJobFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmStart(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmStartLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noteAlarmFinish(String name, int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAlarmFinishLocked(name, uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelock(int uid, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeLocked(uid, pid, name, historyName, type, unimportantForLogging, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelock(int uid, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeLocked(uid, pid, name, historyName, type, SystemClock.elapsedRealtime(), SystemClock.uptimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, boolean unimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartWakeFromSourceLocked(ws, pid, name, historyName, type, unimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteChangeWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type, WorkSource newWs, int newPid, String newName, String newHistoryName, int newType, boolean newUnimportantForLogging) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteChangeWakelockFromSourceLocked(ws, pid, name, historyName, type, newWs, newPid, newName, newHistoryName, newType, newUnimportantForLogging);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopWakelockFromSource(WorkSource ws, int pid, String name, String historyName, int type) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopWakeFromSourceLocked(ws, pid, name, historyName, type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopSensor(int uid, int sensor) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopSensorLocked(uid, sensor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOn(int uid, long durationMillis) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOnLocked(uid, durationMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteVibratorOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVibratorOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStartGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopGps(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteStopGpsLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenState(int state) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenStateLocked(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteScreenBrightness(int brightness) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteScreenBrightnessLocked(brightness);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteUserActivity(int uid, int event) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteUserActivityLocked(uid, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWakeUp(String reason, int reasonUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWakeUpLocked(reason, reasonUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteInteractive(boolean interactive) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteInteractiveLocked(interactive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteConnectivityChanged(int type, String extra) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteConnectivityChangedLocked(type, extra);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteMobileRadioPowerState(int powerState, long timestampNs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteMobileRadioPowerState(powerState, timestampNs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneSignalStrength(SignalStrength signalStrength) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneSignalStrengthLocked(signalStrength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneDataConnectionState(int dataType, boolean hasData) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneDataConnectionStateLocked(dataType, hasData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notePhoneState(int state) {
        this.enforceCallingPermission();
        int simState = TelephonyManager.getDefault().getSimState();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePhoneStateLocked(state, simState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOn() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOnLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiOff() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiOffLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopAudio(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteAudioOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopVideo(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteVideoOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetAudio() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetAudioLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetVideo() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetVideoLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOn(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFlashlightOff(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFlashlightOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStartCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOnLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteStopCamera(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteCameraOffLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetCamera() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetCameraLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteResetFlashlight() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteResetFlashlightLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRadioPowerState(int powerState, long tsNanos) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            if (this.mStats.isOnBattery()) {
                String type = powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_HIGH || powerState == DataConnectionRealTimeInfo.DC_POWER_STATE_MEDIUM ? "active" : "inactive";
                this.mHandler.scheduleWifiSync("wifi-data: " + type);
            }
            this.mStats.noteWifiRadioPowerState(powerState, tsNanos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunning(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRunningChanged(WorkSource oldWs, WorkSource newWs) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRunningChangedLocked(oldWs, newWs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiStopped(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStoppedLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiState(int wifiState, String accessPoint) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiStateLocked(wifiState, accessPoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiSupplicantStateChanged(int supplState, boolean failedAuth) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiSupplicantStateChangedLocked(supplState, failedAuth);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiRssiChanged(int newRssi) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiRssiChangedLocked(newRssi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquired(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleased(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStarted(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStopped(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabled(int uid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledLocked(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockAcquiredFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockAcquiredFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteFullWifiLockReleasedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteFullWifiLockReleasedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStartedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStartedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStartedFromSource(WorkSource ws, int csph) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStartedFromSourceLocked(ws, csph);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiBatchedScanStoppedFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiBatchedScanStoppedFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastEnabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastEnabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteWifiMulticastDisabledFromSource(WorkSource ws) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteWifiMulticastDisabledFromSourceLocked(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkInterfaceType(String iface, int networkType) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkInterfaceTypeLocked(iface, networkType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteNetworkStatsEnabled() {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteNetworkStatsEnabledLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void noteDeviceIdleMode(boolean enabled, String activeReason, int activeUid) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.noteDeviceIdleModeLocked(enabled, activeReason, activeUid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageInstalled(String pkgName, int versionCode) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageInstalledLocked(pkgName, versionCode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notePackageUninstalled(String pkgName) {
        this.enforceCallingPermission();
        BatteryStatsImpl batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.notePackageUninstalledLocked(pkgName);
        }
    }

    public boolean isOnBattery() {
        return this.mStats.isOnBattery();
    }

    @Override
    public void setBatteryState(final int status, final int health, final int plugType, final int level, final int temp, final int volt) {
        this.enforceCallingPermission();
        this.mHandler.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                synchronized (batteryStatsImpl) {
                    boolean onBattery;
                    boolean bl = onBattery = plugType == 0;
                    if (BatteryStatsService.this.mStats.isOnBattery() == onBattery) {
                        BatteryStatsService.this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt);
                        return;
                    }
                }
                BatteryStatsService.this.updateExternalStats("battery-state", 15);
                batteryStatsImpl = BatteryStatsService.this.mStats;
                synchronized (batteryStatsImpl) {
                    BatteryStatsService.this.mStats.setBatteryStateLocked(status, health, plugType, level, temp, volt);
                }
            }
        });
    }

    @Override
    public long getAwakeTimeBattery() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimeBattery();
    }

    @Override
    public long getAwakeTimePlugged() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BATTERY_STATS", null);
        return this.mStats.getAwakeTimePlugged();
    }

    public void enforceCallingPermission() {
        if (Binder.getCallingPid() == Process.myPid()) {
            return;
        }
        this.mContext.enforcePermission("android.permission.UPDATE_DEVICE_STATS", Binder.getCallingPid(), Binder.getCallingUid(), null);
    }

    private static native int nativeWaitWakeup(ByteBuffer var0);

    private void dumpHelp(PrintWriter pw) {
        pw.println("Battery stats (batterystats) dump options:");
        pw.println("  [--checkin] [--history] [--history-start] [--charged] [-c]");
        pw.println("  [--daily] [--reset] [--write] [--new-daily] [--read-daily] [-h] [<package.name>]");
        pw.println("  --checkin: generate output for a checkin report; will write (and clear) the");
        pw.println("             last old completed stats when they had been reset.");
        pw.println("  --c: write the current stats in checkin format.");
        pw.println("  --history: show only history data.");
        pw.println("  --history-start <num>: show only history data starting at given time offset.");
        pw.println("  --charged: only output data since last charged.");
        pw.println("  --daily: only output full daily data.");
        pw.println("  --reset: reset the stats, clearing all current data.");
        pw.println("  --write: force write current collected stats to disk.");
        pw.println("  --new-daily: immediately create and write new daily stats record.");
        pw.println("  --read-daily: read-load last written daily stats.");
        pw.println("  <package.name>: optional name of package to filter output by.");
        pw.println("  -h: print this help text.");
        pw.println("Battery stats (batterystats) commands:");
        pw.println("  enable|disable <option>");
        pw.println("    Enable or disable a running option.  Option state is not saved across boots.");
        pw.println("    Options are:");
        pw.println("      full-history: include additional detailed events in battery history:");
        pw.println("          wake_lock_in, alarms and proc events");
        pw.println("      no-auto-reset: don't automatically reset stats when unplugged");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doEnableOrDisable(PrintWriter pw, int i, String[] args, boolean enable) {
        if (++i >= args.length) {
            pw.println("Missing option argument for " + (enable ? "--enable" : "--disable"));
            this.dumpHelp(pw);
            return -1;
        }
        if ("full-wake-history".equals(args[i]) || "full-history".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setRecordAllHistoryLocked(enable);
            }
        } else if ("no-auto-reset".equals(args[i])) {
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                this.mStats.setNoAutoReset(enable);
            }
        } else {
            pw.println("Unknown enable/disable option: " + args[i]);
            this.dumpHelp(pw);
            return -1;
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        BatteryStatsImpl batteryStatsImpl;
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump BatteryStats from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " without permission " + "android.permission.DUMP");
            return;
        }
        int flags = 0;
        boolean useCheckinFormat = false;
        boolean isRealCheckin = false;
        boolean noOutput = false;
        boolean writeData = false;
        long historyStart = -1L;
        int reqUid = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                String arg = args[i];
                if ("--checkin".equals(arg)) {
                    useCheckinFormat = true;
                    isRealCheckin = true;
                    continue;
                }
                if ("--history".equals(arg)) {
                    flags |= 8;
                    continue;
                }
                if ("--history-start".equals(arg)) {
                    flags |= 8;
                    if (++i >= args.length) {
                        pw.println("Missing time argument for --history-since");
                        this.dumpHelp(pw);
                        return;
                    }
                    historyStart = Long.parseLong(args[i]);
                    writeData = true;
                    continue;
                }
                if ("-c".equals(arg)) {
                    useCheckinFormat = true;
                    flags |= 0x10;
                    continue;
                }
                if ("--charged".equals(arg)) {
                    flags |= 2;
                    continue;
                }
                if ("--daily".equals(arg)) {
                    flags |= 4;
                    continue;
                }
                if ("--reset".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.resetAllStatsCmdLocked();
                        pw.println("Battery stats reset.");
                        noOutput = true;
                    }
                    this.updateExternalStats("dump", 15);
                    continue;
                }
                if ("--write".equals(arg)) {
                    this.updateExternalStats("dump", 15);
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.writeSyncLocked();
                        pw.println("Battery stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--new-daily".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.recordDailyStatsLocked();
                        pw.println("New daily stats written.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--read-daily".equals(arg)) {
                    batteryStatsImpl = this.mStats;
                    synchronized (batteryStatsImpl) {
                        this.mStats.readDailyStatsLocked();
                        pw.println("Last daily stats read.");
                        noOutput = true;
                        continue;
                    }
                }
                if ("--enable".equals(arg) || "enable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, true)) < 0) {
                        return;
                    }
                    pw.println("Enabled: " + args[i]);
                    return;
                }
                if ("--disable".equals(arg) || "disable".equals(arg)) {
                    if ((i = this.doEnableOrDisable(pw, i, args, false)) < 0) {
                        return;
                    }
                    pw.println("Disabled: " + args[i]);
                    return;
                }
                if ("-h".equals(arg)) {
                    this.dumpHelp(pw);
                    return;
                }
                if ("-a".equals(arg)) {
                    flags |= 0x20;
                    continue;
                }
                if (arg.length() > 0 && arg.charAt(0) == '-') {
                    pw.println("Unknown option: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
                try {
                    reqUid = this.mContext.getPackageManager().getPackageUid(arg, UserHandle.getCallingUserId());
                    continue;
                }
                catch (PackageManager.NameNotFoundException e) {
                    pw.println("Unknown package: " + arg);
                    this.dumpHelp(pw);
                    return;
                }
            }
        }
        if (noOutput) {
            return;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (BatteryStatsHelper.checkWifiOnly(this.mContext)) {
                flags |= 0x40;
            }
            this.updateExternalStats("dump", 15);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        if (reqUid >= 0 && (flags & 0xA) == 0) {
            flags |= 2;
            flags &= 0xFFFFFFEF;
        }
        if (useCheckinFormat) {
            Object object;
            List<ApplicationInfo> apps = this.mContext.getPackageManager().getInstalledApplications(0);
            if (isRealCheckin) {
                object = this.mStats.mCheckinFile;
                synchronized (object) {
                    if (this.mStats.mCheckinFile.exists()) {
                        try {
                            byte[] raw2 = this.mStats.mCheckinFile.readFully();
                            if (raw2 != null) {
                                Parcel in = Parcel.obtain();
                                in.unmarshall(raw2, 0, raw2.length);
                                in.setDataPosition(0);
                                BatteryStatsImpl checkinStats = new BatteryStatsImpl(null, this.mStats.mHandler, null);
                                checkinStats.readSummaryFromParcel(in);
                                in.recycle();
                                checkinStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                                this.mStats.mCheckinFile.delete();
                                return;
                            }
                        }
                        catch (ParcelFormatException | IOException e) {
                            Slog.w(TAG, "Failure reading checkin file " + this.mStats.mCheckinFile.getBaseFile(), e);
                        }
                    }
                }
            }
            object = this.mStats;
            synchronized (object) {
                this.mStats.dumpCheckinLocked(this.mContext, pw, apps, flags, historyStart);
                if (writeData) {
                    this.mStats.writeAsyncLocked();
                }
            }
        }
        batteryStatsImpl = this.mStats;
        synchronized (batteryStatsImpl) {
            this.mStats.dumpLocked(this.mContext, pw, flags, reqUid, historyStart);
            if (writeData) {
                this.mStats.writeAsyncLocked();
            }
        }
    }

    @GuardedBy(value="mExternalStatsLock")
    private WifiActivityEnergyInfo pullWifiEnergyInfoLocked() {
        if (this.mWifiManager == null) {
            this.mWifiManager = IWifiManager.Stub.asInterface(ServiceManager.getService("wifi"));
            if (this.mWifiManager == null) {
                return null;
            }
        }
        try {
            WifiActivityEnergyInfo info = this.mWifiManager.reportActivityInfo();
            if (info != null && info.isValid()) {
                if (info.mControllerEnergyUsed < 0L || info.mControllerIdleTimeMs < 0L || info.mControllerRxTimeMs < 0L || info.mControllerTxTimeMs < 0L) {
                    Slog.wtf(TAG, "Reported WiFi energy data is invalid: " + info);
                    return null;
                }
                long timePeriodMs = info.mTimestamp - this.mLastInfo.mTimestamp;
                long lastIdleMs = this.mLastInfo.mControllerIdleTimeMs;
                long lastTxMs = this.mLastInfo.mControllerTxTimeMs;
                long lastRxMs = this.mLastInfo.mControllerRxTimeMs;
                long lastEnergy = this.mLastInfo.mControllerEnergyUsed;
                WifiActivityEnergyInfo result = this.mLastInfo;
                result.mTimestamp = info.getTimeStamp();
                result.mStackState = info.getStackState();
                result.mControllerTxTimeMs = info.mControllerTxTimeMs - lastTxMs;
                result.mControllerRxTimeMs = info.mControllerRxTimeMs - lastRxMs;
                result.mControllerIdleTimeMs = Math.max(0L, info.mControllerIdleTimeMs - lastIdleMs);
                result.mControllerEnergyUsed = Math.max(0L, info.mControllerEnergyUsed - lastEnergy);
                if (result.mControllerTxTimeMs < 0L || result.mControllerRxTimeMs < 0L) {
                    result.mControllerEnergyUsed = info.mControllerEnergyUsed;
                    result.mControllerRxTimeMs = info.mControllerRxTimeMs;
                    result.mControllerTxTimeMs = info.mControllerTxTimeMs;
                    result.mControllerIdleTimeMs = info.mControllerIdleTimeMs;
                    Slog.v(TAG, "WiFi energy data was reset, new WiFi energy data is " + result);
                }
                long SAMPLE_ERROR_MILLIS = 750L;
                long totalTimeMs = result.mControllerIdleTimeMs + result.mControllerRxTimeMs + result.mControllerTxTimeMs;
                if (totalTimeMs > timePeriodMs + 750L) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Total time ");
                    TimeUtils.formatDuration(totalTimeMs, sb);
                    sb.append(" is longer than sample period ");
                    TimeUtils.formatDuration(timePeriodMs, sb);
                    sb.append(".\n");
                    sb.append("Previous WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(lastIdleMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(lastRxMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(lastTxMs, sb);
                    sb.append(" e=").append(lastEnergy);
                    sb.append("\n");
                    sb.append("Current WiFi snapshot: ").append("idle=");
                    TimeUtils.formatDuration(info.mControllerIdleTimeMs, sb);
                    sb.append(" rx=");
                    TimeUtils.formatDuration(info.mControllerRxTimeMs, sb);
                    sb.append(" tx=");
                    TimeUtils.formatDuration(info.mControllerTxTimeMs, sb);
                    sb.append(" e=").append(info.mControllerEnergyUsed);
                    Slog.wtf(TAG, sb.toString());
                }
                this.mLastInfo = info;
                return result;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    @GuardedBy(value="mExternalStatsLock")
    private BluetoothActivityEnergyInfo pullBluetoothEnergyInfoLocked() {
        BluetoothActivityEnergyInfo info;
        BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null && (info = adapter.getControllerActivityEnergyInfo(1)) != null && info.isValid()) {
            if (info.getControllerEnergyUsed() < 0L || info.getControllerIdleTimeMillis() < 0L || info.getControllerRxTimeMillis() < 0L || info.getControllerTxTimeMillis() < 0L) {
                Slog.wtf(TAG, "Bluetooth energy data is invalid: " + info);
            }
            return info;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateExternalStats(String reason, int updateFlags) {
        Object object = this.mExternalStatsLock;
        synchronized (object) {
            if (this.mContext == null) {
                return;
            }
            WifiActivityEnergyInfo wifiEnergyInfo = null;
            if ((updateFlags & 2) != 0) {
                wifiEnergyInfo = this.pullWifiEnergyInfoLocked();
            }
            BluetoothActivityEnergyInfo bluetoothEnergyInfo = null;
            if ((updateFlags & 8) != 0) {
                bluetoothEnergyInfo = this.pullBluetoothEnergyInfoLocked();
            }
            BatteryStatsImpl batteryStatsImpl = this.mStats;
            synchronized (batteryStatsImpl) {
                long elapsedRealtime = SystemClock.elapsedRealtime();
                long uptime = SystemClock.uptimeMillis();
                if (this.mStats.mRecordAllHistory) {
                    this.mStats.addHistoryEventLocked(elapsedRealtime, uptime, 14, reason, 0);
                }
                if ((updateFlags & 1) != 0) {
                    this.mStats.updateCpuTimeLocked();
                    this.mStats.updateKernelWakelocksLocked();
                }
                if ((updateFlags & 4) != 0) {
                    this.mStats.updateMobileRadioStateLocked(elapsedRealtime);
                }
                if ((updateFlags & 2) != 0) {
                    this.mStats.updateWifiStateLocked(wifiEnergyInfo);
                }
                if ((updateFlags & 8) != 0) {
                    this.mStats.updateBluetoothStateLocked(bluetoothEnergyInfo);
                }
            }
        }
    }

    final class WakeupReasonThread
    extends Thread {
        private static final int MAX_REASON_SIZE = 512;
        private CharsetDecoder mDecoder;
        private ByteBuffer mUtf8Buffer;
        private CharBuffer mUtf16Buffer;

        WakeupReasonThread() {
            super("BatteryStats_wakeupReason");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Process.setThreadPriority(-2);
            this.mDecoder = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            this.mUtf8Buffer = ByteBuffer.allocateDirect(512);
            this.mUtf16Buffer = CharBuffer.allocate(512);
            try {
                String reason;
                while ((reason = this.waitWakeup()) != null) {
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsService.this.mStats.noteWakeupReasonLocked(reason);
                    }
                }
                return;
            }
            catch (RuntimeException e) {
                Slog.e(BatteryStatsService.TAG, "Failure reading wakeup reasons", e);
            }
        }

        private String waitWakeup() {
            this.mUtf8Buffer.clear();
            this.mUtf16Buffer.clear();
            this.mDecoder.reset();
            int bytesWritten = BatteryStatsService.nativeWaitWakeup(this.mUtf8Buffer);
            if (bytesWritten < 0) {
                return null;
            }
            if (bytesWritten == 0) {
                return "unknown";
            }
            this.mUtf8Buffer.limit(bytesWritten);
            this.mDecoder.decode(this.mUtf8Buffer, this.mUtf16Buffer, true);
            this.mUtf16Buffer.flip();
            return this.mUtf16Buffer.toString();
        }
    }

    class BatteryStatsHandler
    extends Handler
    implements BatteryStatsImpl.ExternalStatsSync {
        public static final int MSG_SYNC_EXTERNAL_STATS = 1;
        public static final int MSG_WRITE_TO_DISK = 2;
        private int mUpdateFlags;
        private IntArray mUidsToRemove;

        public BatteryStatsHandler(Looper looper) {
            super(looper);
            this.mUpdateFlags = 0;
            this.mUidsToRemove = new IntArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    int updateFlags;
                    Object object = this;
                    synchronized (object) {
                        this.removeMessages(1);
                        updateFlags = this.mUpdateFlags;
                        this.mUpdateFlags = 0;
                    }
                    BatteryStatsService.this.updateExternalStats((String)msg.obj, updateFlags);
                    object = BatteryStatsService.this.mStats;
                    synchronized (object) {
                        BatteryStatsHandler batteryStatsHandler = this;
                        synchronized (batteryStatsHandler) {
                            int numUidsToRemove = this.mUidsToRemove.size();
                            for (int i = 0; i < numUidsToRemove; ++i) {
                                BatteryStatsService.this.mStats.removeIsolatedUidLocked(this.mUidsToRemove.get(i));
                            }
                        }
                        this.mUidsToRemove.clear();
                        break;
                    }
                }
                case 2: {
                    BatteryStatsService.this.updateExternalStats("write", 15);
                    BatteryStatsImpl batteryStatsImpl = BatteryStatsService.this.mStats;
                    synchronized (batteryStatsImpl) {
                        BatteryStatsService.this.mStats.writeAsyncLocked();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleSync(String reason) {
            BatteryStatsHandler batteryStatsHandler = this;
            synchronized (batteryStatsHandler) {
                this.scheduleSyncLocked(reason, 15);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleWifiSync(String reason) {
            BatteryStatsHandler batteryStatsHandler = this;
            synchronized (batteryStatsHandler) {
                this.scheduleSyncLocked(reason, 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scheduleCpuSyncDueToRemovedUid(int uid) {
            BatteryStatsHandler batteryStatsHandler = this;
            synchronized (batteryStatsHandler) {
                this.scheduleSyncLocked("remove-uid", 1);
                this.mUidsToRemove.add(uid);
            }
        }

        private void scheduleSyncLocked(String reason, int updateFlags) {
            if (this.mUpdateFlags == 0) {
                this.sendMessage(Message.obtain(this, 1, reason));
            }
            this.mUpdateFlags |= updateFlags;
        }
    }
}

