/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.IActivityContainer;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.TransactionTooLargeException;
import android.util.Slog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;

final class PendingIntentRecord
extends IIntentSender.Stub {
    private static final String TAG = "ActivityManager";
    final ActivityManagerService owner;
    final Key key;
    final int uid;
    final WeakReference<PendingIntentRecord> ref;
    boolean sent = false;
    boolean canceled = false;
    String stringName;
    String lastTagPrefix;
    String lastTag;

    PendingIntentRecord(ActivityManagerService _owner, Key _k, int _u) {
        this.owner = _owner;
        this.key = _k;
        this.uid = _u;
        this.ref = new WeakReference<PendingIntentRecord>(this);
    }

    @Override
    public int send(int code, Intent intent, String resolvedType, IIntentReceiver finishedReceiver, String requiredPermission, Bundle options) throws TransactionTooLargeException {
        return this.sendInner(code, intent, resolvedType, finishedReceiver, requiredPermission, null, null, 0, 0, 0, options, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int sendInner(int code, Intent intent, String resolvedType, IIntentReceiver finishedReceiver, String requiredPermission, IBinder resultTo, String resultWho, int requestCode, int flagsMask, int flagsValues, Bundle options, IActivityContainer container) throws TransactionTooLargeException {
        ActivityManagerService activityManagerService = this.owner;
        synchronized (activityManagerService) {
            ActivityStackSupervisor.ActivityContainer activityContainer = (ActivityStackSupervisor.ActivityContainer)container;
            if (activityContainer != null && activityContainer.mParentActivity != null && activityContainer.mParentActivity.state != ActivityStack.ActivityState.RESUMED) {
                return -6;
            }
            if (!this.canceled) {
                boolean immutable;
                this.sent = true;
                if ((this.key.flags & 0x40000000) != 0) {
                    this.owner.cancelIntentSenderLocked(this, true);
                    this.canceled = true;
                }
                Intent finalIntent = this.key.requestIntent != null ? new Intent(this.key.requestIntent) : new Intent();
                boolean bl = immutable = (this.key.flags & 0x4000000) != 0;
                if (!immutable) {
                    if (intent != null) {
                        int changes = finalIntent.fillIn(intent, this.key.flags);
                        if ((changes & 2) == 0) {
                            resolvedType = this.key.requestResolvedType;
                        }
                    } else {
                        resolvedType = this.key.requestResolvedType;
                    }
                    finalIntent.setFlags(finalIntent.getFlags() & ~flagsMask | (flagsValues &= (flagsMask &= 0xFFFFFF3C)));
                } else {
                    resolvedType = this.key.requestResolvedType;
                }
                long origId = Binder.clearCallingIdentity();
                boolean sendFinish = finishedReceiver != null;
                int userId = this.key.userId;
                if (userId == -2) {
                    userId = this.owner.getCurrentUserIdLocked();
                }
                switch (this.key.type) {
                    case 2: {
                        if (options == null) {
                            options = this.key.options;
                        } else if (this.key.options != null) {
                            Bundle opts = new Bundle(this.key.options);
                            opts.putAll(options);
                            options = opts;
                        }
                        try {
                            if (this.key.allIntents != null && this.key.allIntents.length > 1) {
                                Intent[] allIntents = new Intent[this.key.allIntents.length];
                                String[] allResolvedTypes = new String[this.key.allIntents.length];
                                System.arraycopy(this.key.allIntents, 0, allIntents, 0, this.key.allIntents.length);
                                if (this.key.allResolvedTypes != null) {
                                    System.arraycopy(this.key.allResolvedTypes, 0, allResolvedTypes, 0, this.key.allResolvedTypes.length);
                                }
                                allIntents[allIntents.length - 1] = finalIntent;
                                allResolvedTypes[allResolvedTypes.length - 1] = resolvedType;
                                this.owner.startActivitiesInPackage(this.uid, this.key.packageName, allIntents, allResolvedTypes, resultTo, options, userId);
                                break;
                            }
                            this.owner.startActivityInPackage(this.uid, this.key.packageName, finalIntent, resolvedType, resultTo, resultWho, requestCode, 0, options, userId, container, null);
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startActivity intent", e);
                        }
                        break;
                    }
                    case 3: {
                        if (this.key.activity.task.stack == null) break;
                        this.key.activity.task.stack.sendActivityResultLocked(-1, this.key.activity, this.key.who, this.key.requestCode, code, finalIntent);
                        break;
                    }
                    case 1: {
                        try {
                            int sent = this.owner.broadcastIntentInPackage(this.key.packageName, this.uid, finalIntent, resolvedType, finishedReceiver, code, null, null, requiredPermission, options, finishedReceiver != null, false, userId);
                            if (sent != 0) break;
                            sendFinish = false;
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startActivity intent", e);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            this.owner.startServiceInPackage(this.uid, finalIntent, resolvedType, this.key.packageName, userId);
                            break;
                        }
                        catch (RuntimeException e) {
                            Slog.w(TAG, "Unable to send startService intent", e);
                        }
                    }
                }
                if (sendFinish) {
                    try {
                        finishedReceiver.performReceive(new Intent(finalIntent), 0, null, null, false, false, this.key.userId);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                Binder.restoreCallingIdentity(origId);
                return 0;
            }
        }
        return -6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void finalize() throws Throwable {
        try {
            if (!this.canceled) {
                this.owner.mHandler.sendMessage(this.owner.mHandler.obtainMessage(23, this));
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeFinalize() {
        ActivityManagerService activityManagerService = this.owner;
        synchronized (activityManagerService) {
            WeakReference<PendingIntentRecord> current = this.owner.mIntentSenderRecords.get(this.key);
            if (current == this.ref) {
                this.owner.mIntentSenderRecords.remove(this.key);
            }
        }
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("uid=");
        pw.print(this.uid);
        pw.print(" packageName=");
        pw.print(this.key.packageName);
        pw.print(" type=");
        pw.print(this.key.typeName());
        pw.print(" flags=0x");
        pw.println(Integer.toHexString(this.key.flags));
        if (this.key.activity != null || this.key.who != null) {
            pw.print(prefix);
            pw.print("activity=");
            pw.print(this.key.activity);
            pw.print(" who=");
            pw.println(this.key.who);
        }
        if (this.key.requestCode != 0 || this.key.requestResolvedType != null) {
            pw.print(prefix);
            pw.print("requestCode=");
            pw.print(this.key.requestCode);
            pw.print(" requestResolvedType=");
            pw.println(this.key.requestResolvedType);
        }
        if (this.key.requestIntent != null) {
            pw.print(prefix);
            pw.print("requestIntent=");
            pw.println(this.key.requestIntent.toShortString(false, true, true, true));
        }
        if (this.sent || this.canceled) {
            pw.print(prefix);
            pw.print("sent=");
            pw.print(this.sent);
            pw.print(" canceled=");
            pw.println(this.canceled);
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("PendingIntentRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        sb.append(this.key.packageName);
        sb.append(' ');
        sb.append(this.key.typeName());
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    static final class Key {
        final int type;
        final String packageName;
        final ActivityRecord activity;
        final String who;
        final int requestCode;
        final Intent requestIntent;
        final String requestResolvedType;
        final Bundle options;
        Intent[] allIntents;
        String[] allResolvedTypes;
        final int flags;
        final int hashCode;
        final int userId;
        private static final int ODD_PRIME_NUMBER = 37;

        Key(int _t, String _p, ActivityRecord _a, String _w, int _r, Intent[] _i, String[] _it, int _f, Bundle _o, int _userId) {
            this.type = _t;
            this.packageName = _p;
            this.activity = _a;
            this.who = _w;
            this.requestCode = _r;
            this.requestIntent = _i != null ? _i[_i.length - 1] : null;
            this.requestResolvedType = _it != null ? _it[_it.length - 1] : null;
            this.allIntents = _i;
            this.allResolvedTypes = _it;
            this.flags = _f;
            this.options = _o;
            this.userId = _userId;
            int hash = 23;
            hash = 37 * hash + _f;
            hash = 37 * hash + _r;
            hash = 37 * hash + _userId;
            if (_w != null) {
                hash = 37 * hash + _w.hashCode();
            }
            if (_a != null) {
                hash = 37 * hash + _a.hashCode();
            }
            if (this.requestIntent != null) {
                hash = 37 * hash + this.requestIntent.filterHashCode();
            }
            if (this.requestResolvedType != null) {
                hash = 37 * hash + this.requestResolvedType.hashCode();
            }
            hash = 37 * hash + _p.hashCode();
            this.hashCode = hash = 37 * hash + _t;
        }

        public boolean equals(Object otherObj) {
            if (otherObj == null) {
                return false;
            }
            try {
                Key other = (Key)otherObj;
                if (this.type != other.type) {
                    return false;
                }
                if (this.userId != other.userId) {
                    return false;
                }
                if (!this.packageName.equals(other.packageName)) {
                    return false;
                }
                if (this.activity != other.activity) {
                    return false;
                }
                if (this.who != other.who && (this.who != null ? !this.who.equals(other.who) : other.who != null)) {
                    return false;
                }
                if (this.requestCode != other.requestCode) {
                    return false;
                }
                if (this.requestIntent != other.requestIntent && (this.requestIntent != null ? !this.requestIntent.filterEquals(other.requestIntent) : other.requestIntent != null)) {
                    return false;
                }
                if (this.requestResolvedType != other.requestResolvedType && (this.requestResolvedType != null ? !this.requestResolvedType.equals(other.requestResolvedType) : other.requestResolvedType != null)) {
                    return false;
                }
                return this.flags == other.flags;
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "Key{" + this.typeName() + " pkg=" + this.packageName + " intent=" + (this.requestIntent != null ? this.requestIntent.toShortString(false, true, false, false) : "<null>") + " flags=0x" + Integer.toHexString(this.flags) + " u=" + this.userId + "}";
        }

        String typeName() {
            switch (this.type) {
                case 2: {
                    return "startActivity";
                }
                case 1: {
                    return "broadcastIntent";
                }
                case 4: {
                    return "startService";
                }
                case 3: {
                    return "activityResult";
                }
            }
            return Integer.toString(this.type);
        }
    }
}

