/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.TaskRecord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

class RecentTasks
extends ArrayList<TaskRecord> {
    private static final String TAG = "ActivityManager";
    private static final String TAG_RECENTS = "ActivityManager";
    private static final String TAG_TASKS = "ActivityManager";
    private static final int MAX_RECENT_BITMAPS = 3;
    private final ActivityManagerService mService;
    private final ArrayList<TaskRecord> mTmpRecents = new ArrayList();
    private final HashMap<ComponentName, ActivityInfo> tmpAvailActCache = new HashMap();
    private final HashMap<String, ApplicationInfo> tmpAvailAppCache = new HashMap();
    private final ActivityInfo tmpActivityInfo = new ActivityInfo();
    private final ApplicationInfo tmpAppInfo = new ApplicationInfo();
    private static Comparator<TaskRecord> sTaskRecordComparator = new Comparator<TaskRecord>(){

        @Override
        public int compare(TaskRecord lhs, TaskRecord rhs) {
            return rhs.taskId - lhs.taskId;
        }
    };

    RecentTasks(ActivityManagerService service) {
        this.mService = service;
    }

    TaskRecord taskForIdLocked(int id2) {
        int recentsCount = this.size();
        for (int i = 0; i < recentsCount; ++i) {
            TaskRecord tr = (TaskRecord)this.get(i);
            if (tr.taskId != id2) continue;
            return tr;
        }
        return null;
    }

    void removeTasksForUserLocked(int userId) {
        if (userId <= 0) {
            Slog.i("ActivityManager", "Can't remove recent task on user " + userId);
            return;
        }
        for (int i = this.size() - 1; i >= 0; --i) {
            TaskRecord tr = (TaskRecord)this.get(i);
            if (tr.userId != userId) continue;
            this.remove(i);
            tr.removedFromRecents();
        }
        this.mService.notifyTaskPersisterLocked(null, true);
    }

    void cleanupLocked(int userId) {
        int[] nArray;
        int recentsCount = this.size();
        if (recentsCount == 0) {
            return;
        }
        IPackageManager pm = AppGlobals.getPackageManager();
        if (userId == -1) {
            nArray = this.mService.getUsersLocked();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = userId;
        }
        int[] users = nArray;
        for (int userIdx = 0; userIdx < users.length; ++userIdx) {
            int user = users[userIdx];
            for (int i = recentsCount = this.size() - 1; i >= 0; --i) {
                TaskRecord task = (TaskRecord)this.get(i);
                if (task.userId != user) continue;
                if (task.autoRemoveRecents && task.getTopActivity() == null) {
                    this.remove(i);
                    task.removedFromRecents();
                    Slog.w("ActivityManager", "Removing auto-remove without activity: " + task);
                    continue;
                }
                if (task.realActivity == null) continue;
                ActivityInfo ai = this.tmpAvailActCache.get(task.realActivity);
                if (ai == null) {
                    try {
                        ai = pm.getActivityInfo(task.realActivity, 8704, user);
                    }
                    catch (RemoteException e) {
                        continue;
                    }
                    if (ai == null) {
                        ai = this.tmpActivityInfo;
                    }
                    this.tmpAvailActCache.put(task.realActivity, ai);
                }
                if (ai == this.tmpActivityInfo) {
                    ApplicationInfo app = this.tmpAvailAppCache.get(task.realActivity.getPackageName());
                    if (app == null) {
                        try {
                            app = pm.getApplicationInfo(task.realActivity.getPackageName(), 8704, user);
                        }
                        catch (RemoteException e) {
                            continue;
                        }
                        if (app == null) {
                            app = this.tmpAppInfo;
                        }
                        this.tmpAvailAppCache.put(task.realActivity.getPackageName(), app);
                    }
                    if (app == this.tmpAppInfo || (app.flags & 0x800000) == 0) {
                        this.remove(i);
                        task.removedFromRecents();
                        Slog.w("ActivityManager", "Removing no longer valid recent: " + task);
                        continue;
                    }
                    task.isAvailable = false;
                    continue;
                }
                task.isAvailable = ai.enabled && ai.applicationInfo.enabled && (ai.applicationInfo.flags & 0x800000) != 0;
            }
        }
        int i = 0;
        recentsCount = this.size();
        while (i < recentsCount) {
            i = this.processNextAffiliateChainLocked(i);
        }
    }

    private final boolean moveAffiliatedTasksToFront(TaskRecord task, int taskIndex) {
        int topIndex;
        int recentsCount = this.size();
        TaskRecord top = task;
        for (topIndex = taskIndex; top.mNextAffiliate != null && topIndex > 0; --topIndex) {
            top = top.mNextAffiliate;
        }
        boolean sane = top.mAffiliatedTaskId == task.mAffiliatedTaskId;
        int endIndex = topIndex;
        TaskRecord prev = top;
        while (endIndex < recentsCount) {
            TaskRecord cur = (TaskRecord)this.get(endIndex);
            if (cur == top) {
                if (cur.mNextAffiliate != null || cur.mNextAffiliateTaskId != -1) {
                    Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": first task has next affiliate: " + prev);
                    sane = false;
                    break;
                }
            } else if (cur.mNextAffiliate != prev || cur.mNextAffiliateTaskId != prev.taskId) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": middle task " + cur + " @" + endIndex + " has bad next affiliate " + cur.mNextAffiliate + " id " + cur.mNextAffiliateTaskId + ", expected " + prev);
                sane = false;
                break;
            }
            if (cur.mPrevAffiliateTaskId == -1) {
                if (cur.mPrevAffiliate == null) break;
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": last task " + cur + " has previous affiliate " + cur.mPrevAffiliate);
                sane = false;
                break;
            }
            if (cur.mPrevAffiliate == null) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": task " + cur + " has previous affiliate " + cur.mPrevAffiliate + " but should be id " + cur.mPrevAffiliate);
                sane = false;
                break;
            }
            if (cur.mAffiliatedTaskId != task.mAffiliatedTaskId) {
                Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": task " + cur + " has affiliated id " + cur.mAffiliatedTaskId + " but should be " + task.mAffiliatedTaskId);
                sane = false;
                break;
            }
            prev = cur;
            if (++endIndex < recentsCount) continue;
            Slog.wtf("ActivityManager", "Bad chain ran off index " + endIndex + ": last task " + prev);
            sane = false;
            break;
        }
        if (sane && endIndex < taskIndex) {
            Slog.wtf("ActivityManager", "Bad chain @" + endIndex + ": did not extend to task " + task + " @" + taskIndex);
            sane = false;
        }
        if (sane) {
            for (int i = topIndex; i <= endIndex; ++i) {
                TaskRecord cur = (TaskRecord)this.remove(i);
                this.add(i - topIndex, cur);
            }
            return true;
        }
        return false;
    }

    final void addLocked(TaskRecord task) {
        boolean isAffiliated = task.mAffiliatedTaskId != task.taskId || task.mNextAffiliateTaskId != -1 || task.mPrevAffiliateTaskId != -1;
        int recentsCount = this.size();
        if (task.voiceSession != null) {
            return;
        }
        if (!isAffiliated && recentsCount > 0 && this.get(0) == task) {
            return;
        }
        if (isAffiliated && recentsCount > 0 && task.inRecents && task.mAffiliatedTaskId == ((TaskRecord)this.get((int)0)).mAffiliatedTaskId) {
            return;
        }
        boolean needAffiliationFix = false;
        if (task.inRecents) {
            int taskIndex = this.indexOf(task);
            if (taskIndex >= 0) {
                if (!isAffiliated) {
                    this.remove(taskIndex);
                    this.add(0, task);
                    this.mService.notifyTaskPersisterLocked(task, false);
                    return;
                }
                if (this.moveAffiliatedTasksToFront(task, taskIndex)) {
                    return;
                }
                needAffiliationFix = true;
            } else {
                Slog.wtf("ActivityManager", "Task with inRecent not in recents: " + task);
                needAffiliationFix = true;
            }
        }
        this.trimForTaskLocked(task, true);
        int maxRecents = ActivityManager.getMaxRecentTasksStatic();
        for (recentsCount = this.size(); recentsCount >= maxRecents; --recentsCount) {
            TaskRecord tr = (TaskRecord)this.remove(recentsCount - 1);
            tr.removedFromRecents();
        }
        task.inRecents = true;
        if (!isAffiliated || needAffiliationFix) {
            this.add(0, task);
        } else if (isAffiliated) {
            TaskRecord other = task.mNextAffiliate;
            if (other == null) {
                other = task.mPrevAffiliate;
            }
            if (other != null) {
                int otherIndex = this.indexOf(other);
                if (otherIndex >= 0) {
                    int taskIndex = other == task.mNextAffiliate ? otherIndex + 1 : otherIndex;
                    this.add(taskIndex, task);
                    if (this.moveAffiliatedTasksToFront(task, taskIndex)) {
                        return;
                    }
                    needAffiliationFix = true;
                } else {
                    needAffiliationFix = true;
                }
            } else {
                needAffiliationFix = true;
            }
        }
        if (needAffiliationFix) {
            this.cleanupLocked(task.userId);
        }
    }

    int trimForTaskLocked(TaskRecord task, boolean doTrim) {
        int recentsCount = this.size();
        Intent intent = task.intent;
        boolean document = intent != null && intent.isDocument();
        int maxRecents = task.maxRecents - 1;
        for (int i = 0; i < recentsCount; ++i) {
            TaskRecord tr = (TaskRecord)this.get(i);
            if (task != tr) {
                boolean bothDocuments;
                if (task.userId != tr.userId) continue;
                if (i > 3) {
                    tr.freeLastThumbnail();
                }
                Intent trIntent = tr.intent;
                boolean sameAffinity = task.affinity != null && task.affinity.equals(tr.affinity);
                boolean sameIntent = intent != null && intent.filterEquals(trIntent);
                boolean trIsDocument = trIntent != null && trIntent.isDocument();
                boolean bl = bothDocuments = document && trIsDocument;
                if (!sameAffinity && !sameIntent && !bothDocuments) continue;
                if (bothDocuments) {
                    boolean sameActivity;
                    boolean bl2 = sameActivity = task.realActivity != null && tr.realActivity != null && task.realActivity.equals(tr.realActivity);
                    if (!sameActivity) continue;
                    if (maxRecents > 0) {
                        --maxRecents;
                        continue;
                    }
                } else if (document || trIsDocument) continue;
            }
            if (!doTrim) {
                return i;
            }
            tr.disposeThumbnail();
            this.remove(i);
            if (task != tr) {
                tr.removedFromRecents();
            }
            --i;
            --recentsCount;
            if (task.intent == null) {
                task = tr;
            }
            this.mService.notifyTaskPersisterLocked(tr, false);
        }
        return -1;
    }

    private int processNextAffiliateChainLocked(int start) {
        TaskRecord startTask = (TaskRecord)this.get(start);
        int affiliateId = startTask.mAffiliatedTaskId;
        if (startTask.taskId == affiliateId && startTask.mPrevAffiliate == null && startTask.mNextAffiliate == null) {
            startTask.inRecents = true;
            return start + 1;
        }
        this.mTmpRecents.clear();
        for (int i = this.size() - 1; i >= start; --i) {
            TaskRecord task = (TaskRecord)this.get(i);
            if (task.mAffiliatedTaskId != affiliateId) continue;
            this.remove(i);
            this.mTmpRecents.add(task);
        }
        Collections.sort(this.mTmpRecents, sTaskRecordComparator);
        TaskRecord first = this.mTmpRecents.get(0);
        first.inRecents = true;
        if (first.mNextAffiliate != null) {
            Slog.w("ActivityManager", "Link error 1 first.next=" + first.mNextAffiliate);
            first.setNextAffiliate(null);
            this.mService.notifyTaskPersisterLocked(first, false);
        }
        int tmpSize = this.mTmpRecents.size();
        for (int i = 0; i < tmpSize - 1; ++i) {
            TaskRecord next = this.mTmpRecents.get(i);
            TaskRecord prev = this.mTmpRecents.get(i + 1);
            if (next.mPrevAffiliate != prev) {
                Slog.w("ActivityManager", "Link error 2 next=" + next + " prev=" + next.mPrevAffiliate + " setting prev=" + prev);
                next.setPrevAffiliate(prev);
                this.mService.notifyTaskPersisterLocked(next, false);
            }
            if (prev.mNextAffiliate != next) {
                Slog.w("ActivityManager", "Link error 3 prev=" + prev + " next=" + prev.mNextAffiliate + " setting next=" + next);
                prev.setNextAffiliate(next);
                this.mService.notifyTaskPersisterLocked(prev, false);
            }
            prev.inRecents = true;
        }
        TaskRecord last = this.mTmpRecents.get(tmpSize - 1);
        if (last.mPrevAffiliate != null) {
            Slog.w("ActivityManager", "Link error 4 last.prev=" + last.mPrevAffiliate);
            last.setPrevAffiliate(null);
            this.mService.notifyTaskPersisterLocked(last, false);
        }
        this.addAll(start, this.mTmpRecents);
        this.mTmpRecents.clear();
        return start + tmpSize;
    }
}

