/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AlertDialog;
import android.content.Context;
import android.content.res.Resources;
import android.os.Handler;
import android.os.Message;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.widget.TextView;
import com.android.internal.annotations.GuardedBy;
import com.android.server.am.ActivityManagerService;

final class UserSwitchingDialog
extends AlertDialog
implements ViewTreeObserver.OnWindowShownListener {
    private static final String TAG = "ActivityManagerUserSwitchingDialog";
    private static final int WINDOW_SHOWN_TIMEOUT_MS = 3000;
    private final ActivityManagerService mService;
    private final int mUserId;
    private static final int MSG_START_USER = 1;
    @GuardedBy(value="this")
    private boolean mStartedUser;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    UserSwitchingDialog.this.startUser();
                }
            }
        }
    };

    public UserSwitchingDialog(ActivityManagerService service, Context context, int userId, String userName, boolean aboveSystem) {
        super(context);
        this.mService = service;
        this.mUserId = userId;
        this.setCancelable(false);
        Resources res = this.getContext().getResources();
        View view = LayoutInflater.from(this.getContext()).inflate(17367289, null);
        ((TextView)view.findViewById(16908299)).setText(res.getString(17040618, userName));
        this.setView(view);
        if (aboveSystem) {
            this.getWindow().setType(2010);
        }
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.privateFlags = 272;
        this.getWindow().setAttributes(attrs);
    }

    @Override
    public void show() {
        super.show();
        View decorView = this.getWindow().getDecorView();
        if (decorView != null) {
            decorView.getViewTreeObserver().addOnWindowShownListener(this);
        }
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 3000L);
    }

    @Override
    public void onWindowShown() {
        this.startUser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startUser() {
        UserSwitchingDialog userSwitchingDialog = this;
        synchronized (userSwitchingDialog) {
            if (!this.mStartedUser) {
                this.mService.startUserInForeground(this.mUserId, this);
                this.mStartedUser = true;
                View decorView = this.getWindow().getDecorView();
                if (decorView != null) {
                    decorView.getViewTreeObserver().removeOnWindowShownListener(this);
                }
                this.mHandler.removeMessages(1);
            }
        }
    }
}

