/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.app.ActivityManager;
import android.app.AppOpsManager;
import android.app.KeyguardManager;
import android.app.PendingIntent;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioFocusInfo;
import android.media.IAudioFocusDispatcher;
import android.media.IRemoteControlClient;
import android.media.IRemoteControlDisplay;
import android.media.IRemoteVolumeObserver;
import android.media.audiopolicy.IAudioPolicyCallback;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IDeviceIdleController;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.PhoneStateListener;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Slog;
import android.view.KeyEvent;
import com.android.server.audio.AudioService;
import com.android.server.audio.FocusRequester;
import com.android.server.audio.PlayerRecord;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public class MediaFocusControl
implements PendingIntent.OnFinished {
    private static final String TAG = "MediaFocusControl";
    protected static final boolean DEBUG_RC = false;
    protected static final boolean DEBUG_VOL = false;
    private boolean mIsRinging = false;
    private final PowerManager.WakeLock mMediaEventWakeLock;
    private final MediaEventHandler mEventHandler;
    private final Context mContext;
    private final ContentResolver mContentResolver;
    private final AudioService.VolumeController mVolumeController;
    private final AppOpsManager mAppOps;
    private final KeyguardManager mKeyguardManager;
    private final AudioService mAudioService;
    private final NotificationListenerObserver mNotifListenerObserver;
    private static final Uri ENABLED_NOTIFICATION_LISTENERS_URI = Settings.Secure.getUriFor("enabled_notification_listeners");
    private static final int RCD_REG_FAILURE = 0;
    private static final int RCD_REG_SUCCESS_PERMISSION = 1;
    private static final int RCD_REG_SUCCESS_ENABLED_NOTIF = 2;
    private static final int MSG_RCDISPLAY_CLEAR = 1;
    private static final int MSG_RCDISPLAY_UPDATE = 2;
    private static final int MSG_REEVALUATE_REMOTE = 3;
    private static final int MSG_RCC_NEW_PLAYBACK_INFO = 4;
    private static final int MSG_RCC_NEW_VOLUME_OBS = 5;
    private static final int MSG_RCC_NEW_PLAYBACK_STATE = 6;
    private static final int MSG_RCC_SEEK_REQUEST = 7;
    private static final int MSG_RCC_UPDATE_METADATA = 8;
    private static final int MSG_RCDISPLAY_INIT_INFO = 9;
    private static final int MSG_REEVALUATE_RCD = 10;
    private static final int MSG_UNREGISTER_MEDIABUTTONINTENT = 11;
    private static final int SENDMSG_REPLACE = 0;
    private static final int SENDMSG_NOOP = 1;
    private static final int SENDMSG_QUEUE = 2;
    private static final Object mAudioFocusLock = new Object();
    private static final Object mRingingLock = new Object();
    private PhoneStateListener mPhoneStateListener = new PhoneStateListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCallStateChanged(int state, String incomingNumber) {
            if (state == 1) {
                Object object = mRingingLock;
                synchronized (object) {
                    MediaFocusControl.this.mIsRinging = true;
                }
            }
            if (state == 2 || state == 0) {
                Object object = mRingingLock;
                synchronized (object) {
                    MediaFocusControl.this.mIsRinging = false;
                }
            }
        }
    };
    private final Stack<FocusRequester> mFocusStack = new Stack();
    private boolean mNotifyFocusOwnerOnDuck = true;
    private ArrayList<IAudioPolicyCallback> mFocusFollowers = new ArrayList();
    private static final int VOICEBUTTON_ACTION_DISCARD_CURRENT_KEY_PRESS = 1;
    private static final int VOICEBUTTON_ACTION_START_VOICE_INPUT = 2;
    private static final int VOICEBUTTON_ACTION_SIMULATE_KEY_PRESS = 3;
    private final Object mVoiceEventLock = new Object();
    private boolean mVoiceButtonDown;
    private boolean mVoiceButtonHandled;
    private static final int WAKELOCK_RELEASE_ON_FINISHED = 1980;
    private static final String EXTRA_WAKELOCK_ACQUIRED = "android.media.AudioService.WAKELOCK_ACQUIRED";
    BroadcastReceiver mKeyEventDone = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent == null) {
                return;
            }
            Bundle extras = intent.getExtras();
            if (extras == null) {
                return;
            }
            if (extras.containsKey(MediaFocusControl.EXTRA_WAKELOCK_ACQUIRED)) {
                MediaFocusControl.this.mMediaEventWakeLock.release();
            }
        }
    };
    private final Object mCurrentRcLock = new Object();
    private IRemoteControlClient mCurrentRcClient = null;
    private PendingIntent mCurrentRcClientIntent = null;
    private static final int RC_INFO_NONE = 0;
    private static final int RC_INFO_ALL = 15;
    private int mCurrentRcClientGen = 0;
    private PlayerRecord.RemotePlaybackState mMainRemote;
    private boolean mMainRemoteIsActive;
    private boolean mHasRemotePlayback;
    private final Stack<PlayerRecord> mPRStack = new Stack();
    private ComponentName mMediaReceiverForCalls = null;
    private ArrayList<DisplayInfoForServer> mRcDisplays = new ArrayList(1);

    protected MediaFocusControl(Looper looper, Context cntxt, AudioService.VolumeController volumeCtrl, AudioService as) {
        this.mEventHandler = new MediaEventHandler(looper);
        this.mContext = cntxt;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mVolumeController = volumeCtrl;
        this.mAudioService = as;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mMediaEventWakeLock = pm.newWakeLock(1, "handleMediaEvent");
        int maxMusicLevel = as.getStreamMaxVolume(3);
        this.mMainRemote = new PlayerRecord.RemotePlaybackState(-1, maxMusicLevel, maxMusicLevel);
        TelephonyManager tmgr = (TelephonyManager)this.mContext.getSystemService("phone");
        tmgr.listen(this.mPhoneStateListener, 32);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mKeyguardManager = (KeyguardManager)this.mContext.getSystemService("keyguard");
        this.mNotifListenerObserver = new NotificationListenerObserver();
        this.mHasRemotePlayback = false;
        this.mMainRemoteIsActive = false;
        PlayerRecord.setMediaFocusControl(this);
        this.postReevaluateRemote();
    }

    protected void dump(PrintWriter pw) {
        pw.println("\nMediaFocusControl dump time: " + DateFormat.getTimeInstance().format(new Date()));
        this.dumpFocusStack(pw);
        this.dumpRCStack(pw);
        this.dumpRCCStack(pw);
        this.dumpRCDList(pw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int checkRcdRegistrationAuthorization(ComponentName listenerComp) {
        if (0 == this.mContext.checkCallingOrSelfPermission("android.permission.MEDIA_CONTENT_CONTROL")) {
            return 1;
        }
        if (listenerComp != null) {
            long ident = Binder.clearCallingIdentity();
            try {
                int currentUser = ActivityManager.getCurrentUser();
                String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
                if (enabledNotifListeners != null) {
                    String[] components = enabledNotifListeners.split(":");
                    for (int i = 0; i < components.length; ++i) {
                        ComponentName component = ComponentName.unflattenFromString(components[i]);
                        if (component == null || !listenerComp.equals(component)) continue;
                        int n = 2;
                        return n;
                    }
                }
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
        return 0;
    }

    protected boolean registerRemoteController(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        int reg = this.checkRcdRegistrationAuthorization(listenerComp);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, listenerComp);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " or be an enabled NotificationListenerService for registerRemoteController");
        return false;
    }

    protected boolean registerRemoteControlDisplay(IRemoteControlDisplay rcd, int w, int h) {
        int reg = this.checkRcdRegistrationAuthorization(null);
        if (reg != 0) {
            this.registerRemoteControlDisplay_int(rcd, w, h, null);
            return true;
        }
        Slog.w(TAG, "Access denied to process: " + Binder.getCallingPid() + ", must have permission " + "android.permission.MEDIA_CONTENT_CONTROL" + " to register IRemoteControlDisplay");
        return false;
    }

    private void postReevaluateRemoteControlDisplays() {
        MediaFocusControl.sendMsg(this.mEventHandler, 10, 2, 0, 0, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReevaluateRemoteControlDisplays() {
        int currentUser = ActivityManager.getCurrentUser();
        String enabledNotifListeners = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_notification_listeners", currentUser);
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                String[] enabledComponents = enabledNotifListeners == null ? null : enabledNotifListeners.split(":");
                for (DisplayInfoForServer di : this.mRcDisplays) {
                    if (di.mClientNotifListComp == null) continue;
                    boolean wasEnabled = di.mEnabled;
                    di.mEnabled = this.isComponentInStringArray(di.mClientNotifListComp, enabledComponents);
                    if (wasEnabled == di.mEnabled) continue;
                    try {
                        di.mRcDisplay.setEnabled(di.mEnabled);
                        this.enableRemoteControlDisplayForClient_syncRcStack(di.mRcDisplay, di.mEnabled);
                        if (!di.mEnabled) continue;
                        MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight, di.mRcDisplay, 0);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error en/disabling RCD: ", e);
                    }
                }
            }
        }
    }

    private boolean isComponentInStringArray(ComponentName comp, String[] enabledArray) {
        if (enabledArray == null || enabledArray.length == 0) {
            return false;
        }
        String compString = comp.flattenToString();
        for (int i = 0; i < enabledArray.length; ++i) {
            if (!compString.equals(enabledArray[i])) continue;
            return true;
        }
        return false;
    }

    private static void sendMsg(Handler handler, int msg, int existingMsgPolicy, int arg1, int arg2, Object obj, int delay) {
        if (existingMsgPolicy == 0) {
            handler.removeMessages(msg);
        } else if (existingMsgPolicy == 1 && handler.hasMessages(msg)) {
            return;
        }
        handler.sendMessageDelayed(handler.obtainMessage(msg, arg1, arg2, obj), delay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void discardAudioFocusOwner() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (!this.mFocusStack.empty()) {
                FocusRequester exFocusOwner = this.mFocusStack.pop();
                exFocusOwner.handleFocusLoss(-1);
                exFocusOwner.release();
            }
        }
    }

    private void notifyTopOfAudioFocusStack() {
        if (!this.mFocusStack.empty() && this.canReassignAudioFocus()) {
            this.mFocusStack.peek().handleFocusGain(1);
        }
    }

    private void propagateFocusLossFromGain_syncAf(int focusGain) {
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            ((FocusRequester)stackIterator.next()).handleExternalFocusGain(focusGain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpFocusStack(PrintWriter pw) {
        pw.println("\nAudio Focus stack entries (last is top of stack):");
        Object object = mAudioFocusLock;
        synchronized (object) {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                ((FocusRequester)stackIterator.next()).dump(pw);
            }
        }
        pw.println("\n Notify on duck: " + this.mNotifyFocusOwnerOnDuck + "\n");
    }

    private void removeFocusStackEntry(String clientToRemove, boolean signal, boolean notifyFocusFollowers) {
        if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientToRemove)) {
            FocusRequester fr = this.mFocusStack.pop();
            fr.release();
            if (notifyFocusFollowers) {
                AudioFocusInfo afi = fr.toAudioFocusInfo();
                afi.clearLossReceived();
                this.notifyExtPolicyFocusLoss_syncAf(afi, false);
            }
            if (signal) {
                this.notifyTopOfAudioFocusStack();
            }
        } else {
            Iterator stackIterator = this.mFocusStack.iterator();
            while (stackIterator.hasNext()) {
                FocusRequester fr = (FocusRequester)stackIterator.next();
                if (!fr.hasSameClient(clientToRemove)) continue;
                Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + clientToRemove);
                stackIterator.remove();
                fr.release();
            }
        }
    }

    private void removeFocusStackEntryForClient(IBinder cb) {
        boolean isTopOfStackForClientToRemove = !this.mFocusStack.isEmpty() && this.mFocusStack.peek().hasSameBinder(cb);
        Iterator stackIterator = this.mFocusStack.iterator();
        while (stackIterator.hasNext()) {
            FocusRequester fr = (FocusRequester)stackIterator.next();
            if (!fr.hasSameBinder(cb)) continue;
            Log.i(TAG, "AudioFocus  removeFocusStackEntry(): removing entry for " + cb);
            stackIterator.remove();
        }
        if (isTopOfStackForClientToRemove) {
            this.notifyTopOfAudioFocusStack();
        }
    }

    private boolean canReassignAudioFocus() {
        return this.mFocusStack.isEmpty() || !this.isLockedFocusOwner(this.mFocusStack.peek());
    }

    private boolean isLockedFocusOwner(FocusRequester fr) {
        return fr.hasSameClient("AudioFocus_For_Phone_Ring_And_Calls") || fr.isLockedFocusOwner();
    }

    private int pushBelowLockedFocusOwners(FocusRequester nfr) {
        int lastLockedFocusOwnerIndex = this.mFocusStack.size();
        for (int index = this.mFocusStack.size() - 1; index >= 0; --index) {
            if (!this.isLockedFocusOwner((FocusRequester)this.mFocusStack.elementAt(index))) continue;
            lastLockedFocusOwnerIndex = index;
        }
        if (lastLockedFocusOwnerIndex == this.mFocusStack.size()) {
            Log.e(TAG, "No exclusive focus owner found in propagateFocusLossFromGain_syncAf()", new Exception());
            this.propagateFocusLossFromGain_syncAf(nfr.getGainRequest());
            this.mFocusStack.push(nfr);
            return 1;
        }
        this.mFocusStack.insertElementAt(nfr, lastLockedFocusOwnerIndex);
        return 2;
    }

    protected void setDuckingInExtPolicyAvailable(boolean available) {
        this.mNotifyFocusOwnerOnDuck = !available;
    }

    boolean mustNotifyFocusOwnerOnDuck() {
        return this.mNotifyFocusOwnerOnDuck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFocusFollower(IAudioPolicyCallback ff) {
        if (ff == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            boolean found = false;
            for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
                if (!pcb.asBinder().equals(ff.asBinder())) continue;
                found = true;
                break;
            }
            if (found) {
                return;
            }
            this.mFocusFollowers.add(ff);
            this.notifyExtPolicyCurrentFocusAsync(ff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFocusFollower(IAudioPolicyCallback ff) {
        if (ff == null) {
            return;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
                if (!pcb.asBinder().equals(ff.asBinder())) continue;
                this.mFocusFollowers.remove(pcb);
                break;
            }
        }
    }

    void notifyExtPolicyCurrentFocusAsync(IAudioPolicyCallback pcb) {
        final IAudioPolicyCallback pcb2 = pcb;
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = mAudioFocusLock;
                synchronized (object) {
                    if (MediaFocusControl.this.mFocusStack.isEmpty()) {
                        return;
                    }
                    try {
                        pcb2.notifyAudioFocusGrant(((FocusRequester)MediaFocusControl.this.mFocusStack.peek()).toAudioFocusInfo(), 1);
                    }
                    catch (RemoteException e) {
                        Log.e(MediaFocusControl.TAG, "Can't call notifyAudioFocusGrant() on IAudioPolicyCallback " + pcb2.asBinder(), e);
                    }
                }
            }
        };
        thread.start();
    }

    void notifyExtPolicyFocusGrant_syncAf(AudioFocusInfo afi, int requestResult) {
        for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
            try {
                pcb.notifyAudioFocusGrant(afi, requestResult);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyAudioFocusGrant() on IAudioPolicyCallback " + pcb.asBinder(), e);
            }
        }
    }

    void notifyExtPolicyFocusLoss_syncAf(AudioFocusInfo afi, boolean wasDispatched) {
        for (IAudioPolicyCallback pcb : this.mFocusFollowers) {
            try {
                pcb.notifyAudioFocusLoss(afi, wasDispatched);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Can't call notifyAudioFocusLoss() on IAudioPolicyCallback " + pcb.asBinder(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getCurrentAudioFocus() {
        Object object = mAudioFocusLock;
        synchronized (object) {
            if (this.mFocusStack.empty()) {
                return 0;
            }
            return this.mFocusStack.peek().getGainRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int requestAudioFocus(AudioAttributes aa, int focusChangeHint, IBinder cb, IAudioFocusDispatcher fd, String clientId, String callingPackageName, int flags) {
        Log.i(TAG, " AudioFocus  requestAudioFocus() from " + clientId + " req=" + focusChangeHint + "flags=0x" + Integer.toHexString(flags));
        if (!cb.pingBinder()) {
            Log.e(TAG, " AudioFocus DOA client for requestAudioFocus(), aborting.");
            return 0;
        }
        if (this.mAppOps.noteOp(32, Binder.getCallingUid(), callingPackageName) != 0) {
            return 0;
        }
        Object object = mAudioFocusLock;
        synchronized (object) {
            boolean focusGrantDelayed = false;
            if (!this.canReassignAudioFocus()) {
                if ((flags & 1) == 0) {
                    return 0;
                }
                focusGrantDelayed = true;
            }
            AudioFocusDeathHandler afdh = new AudioFocusDeathHandler(cb);
            try {
                cb.linkToDeath(afdh, 0);
            }
            catch (RemoteException e) {
                Log.w(TAG, "AudioFocus  requestAudioFocus() could not link to " + cb + " binder death");
                return 0;
            }
            if (!this.mFocusStack.empty() && this.mFocusStack.peek().hasSameClient(clientId)) {
                FocusRequester fr = this.mFocusStack.peek();
                if (fr.getGainRequest() == focusChangeHint && fr.getGrantFlags() == flags) {
                    cb.unlinkToDeath(afdh, 0);
                    this.notifyExtPolicyFocusGrant_syncAf(fr.toAudioFocusInfo(), 1);
                    return 1;
                }
                if (!focusGrantDelayed) {
                    this.mFocusStack.pop();
                    fr.release();
                }
            }
            this.removeFocusStackEntry(clientId, false, false);
            FocusRequester nfr = new FocusRequester(aa, focusChangeHint, flags, fd, cb, clientId, afdh, callingPackageName, Binder.getCallingUid(), this);
            if (focusGrantDelayed) {
                int requestResult = this.pushBelowLockedFocusOwners(nfr);
                if (requestResult != 0) {
                    this.notifyExtPolicyFocusGrant_syncAf(nfr.toAudioFocusInfo(), requestResult);
                }
                return requestResult;
            }
            if (!this.mFocusStack.empty()) {
                this.propagateFocusLossFromGain_syncAf(focusChangeHint);
            }
            this.mFocusStack.push(nfr);
            this.notifyExtPolicyFocusGrant_syncAf(nfr.toAudioFocusInfo(), 1);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int abandonAudioFocus(IAudioFocusDispatcher fl, String clientId, AudioAttributes aa) {
        Log.i(TAG, " AudioFocus  abandonAudioFocus() from " + clientId);
        try {
            Object object = mAudioFocusLock;
            synchronized (object) {
                this.removeFocusStackEntry(clientId, true, true);
            }
        }
        catch (ConcurrentModificationException cme) {
            Log.e(TAG, "FATAL EXCEPTION AudioFocus  abandonAudioFocus() caused " + cme);
            cme.printStackTrace();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAudioFocusClient(String clientId) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            this.removeFocusStackEntry(clientId, false, true);
        }
    }

    protected void dispatchMediaKeyEvent(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, false);
    }

    protected void dispatchMediaKeyEventUnderWakelock(KeyEvent keyEvent) {
        this.filterMediaKeyEvent(keyEvent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (!MediaFocusControl.isValidMediaKeyEvent(keyEvent)) {
            Log.e(TAG, "not dispatching invalid media key event " + keyEvent);
            return;
        }
        Object object = mRingingLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                if (this.mMediaReceiverForCalls != null && (this.mIsRinging || this.mAudioService.getMode() == 2)) {
                    this.dispatchMediaKeyEventForCalls(keyEvent, needWakeLock);
                    return;
                }
            }
        }
        if (MediaFocusControl.isValidVoiceInputKeyCode(keyEvent.getKeyCode())) {
            this.filterVoiceInputKeyEvent(keyEvent, needWakeLock);
        } else {
            this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMediaKeyEventForCalls(KeyEvent keyEvent, boolean needWakeLock) {
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        keyIntent.setPackage(this.mMediaReceiverForCalls.getPackageName());
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
            keyIntent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
        }
        long ident = Binder.clearCallingIdentity();
        try {
            this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchMediaKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        Intent keyIntent = new Intent("android.intent.action.MEDIA_BUTTON", null);
        keyIntent.putExtra("android.intent.extra.KEY_EVENT", keyEvent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (!this.mPRStack.empty()) {
                try {
                    this.mPRStack.peek().getMediaButtonIntent().send(this.mContext, needWakeLock ? 1980 : 0, keyIntent, this, this.mEventHandler);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.e(TAG, "Error sending pending intent " + this.mPRStack.peek());
                    e.printStackTrace();
                }
            } else {
                if (needWakeLock) {
                    keyIntent.putExtra(EXTRA_WAKELOCK_ACQUIRED, 1980);
                }
                long ident = Binder.clearCallingIdentity();
                try {
                    this.mContext.sendOrderedBroadcastAsUser(keyIntent, UserHandle.ALL, null, this.mKeyEventDone, this.mEventHandler, -1, null, null);
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterVoiceInputKeyEvent(KeyEvent keyEvent, boolean needWakeLock) {
        int voiceButtonAction = 1;
        int keyAction = keyEvent.getAction();
        Object object = this.mVoiceEventLock;
        synchronized (object) {
            if (keyAction == 0) {
                if (keyEvent.getRepeatCount() == 0) {
                    this.mVoiceButtonDown = true;
                    this.mVoiceButtonHandled = false;
                } else if (this.mVoiceButtonDown && !this.mVoiceButtonHandled && (keyEvent.getFlags() & 0x80) != 0) {
                    this.mVoiceButtonHandled = true;
                    voiceButtonAction = 2;
                }
            } else if (keyAction == 1 && this.mVoiceButtonDown) {
                this.mVoiceButtonDown = false;
                if (!this.mVoiceButtonHandled && !keyEvent.isCanceled()) {
                    voiceButtonAction = 3;
                }
            }
        }
        switch (voiceButtonAction) {
            case 1: {
                break;
            }
            case 2: {
                this.startVoiceBasedInteractions(needWakeLock);
                break;
            }
            case 3: {
                this.sendSimulatedMediaButtonEvent(keyEvent, needWakeLock);
            }
        }
    }

    private void sendSimulatedMediaButtonEvent(KeyEvent originalKeyEvent, boolean needWakeLock) {
        KeyEvent keyEvent = KeyEvent.changeAction(originalKeyEvent, 0);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
        keyEvent = KeyEvent.changeAction(originalKeyEvent, 1);
        this.dispatchMediaKeyEvent(keyEvent, needWakeLock);
    }

    private static boolean isValidMediaKeyEvent(KeyEvent keyEvent) {
        if (keyEvent == null) {
            return false;
        }
        return KeyEvent.isMediaKey(keyEvent.getKeyCode());
    }

    private static boolean isValidVoiceInputKeyCode(int keyCode) {
        return keyCode == 79;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startVoiceBasedInteractions(boolean needWakeLock) {
        boolean isLocked;
        Intent voiceIntent = null;
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        boolean bl = isLocked = this.mKeyguardManager != null && this.mKeyguardManager.isKeyguardLocked();
        if (!isLocked && pm.isScreenOn()) {
            voiceIntent = new Intent("android.speech.action.WEB_SEARCH");
            Log.i(TAG, "voice-based interactions: about to use ACTION_WEB_SEARCH");
        } else {
            IDeviceIdleController dic = IDeviceIdleController.Stub.asInterface(ServiceManager.getService("deviceidle"));
            if (dic != null) {
                try {
                    dic.exitIdle("voice-search");
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            voiceIntent = new Intent("android.speech.action.VOICE_SEARCH_HANDS_FREE");
            voiceIntent.putExtra("android.speech.extras.EXTRA_SECURE", isLocked && this.mKeyguardManager.isKeyguardSecure());
            Log.i(TAG, "voice-based interactions: about to use ACTION_VOICE_SEARCH_HANDS_FREE");
        }
        if (needWakeLock) {
            this.mMediaEventWakeLock.acquire();
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (voiceIntent != null) {
                voiceIntent.setFlags(0x10800000);
                this.mContext.startActivityAsUser(voiceIntent, UserHandle.CURRENT);
            }
        }
        catch (ActivityNotFoundException e) {
            Log.w(TAG, "No activity for search: " + e);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
            if (needWakeLock) {
                this.mMediaEventWakeLock.release();
            }
        }
    }

    @Override
    public void onSendFinished(PendingIntent pendingIntent, Intent intent, int resultCode, String resultData, Bundle resultExtras) {
        if (resultCode == 1980) {
            this.mMediaEventWakeLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCStack(PrintWriter pw) {
        pw.println("\nRemote Control stack entries (last is top of stack):");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator stackIterator = this.mPRStack.iterator();
            while (stackIterator.hasNext()) {
                ((PlayerRecord)stackIterator.next()).dump(pw, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCCStack(PrintWriter pw) {
        pw.println("\nRemote Control Client stack entries (last is top of stack):");
        Object object = this.mPRStack;
        synchronized (object) {
            Iterator stackIterator = this.mPRStack.iterator();
            while (stackIterator.hasNext()) {
                ((PlayerRecord)stackIterator.next()).dump(pw, false);
            }
            Object object2 = this.mCurrentRcLock;
            synchronized (object2) {
                pw.println("\nCurrent remote control generation ID = " + this.mCurrentRcClientGen);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            pw.println("\nRemote Volume State:");
            pw.println("  has remote: " + this.mHasRemotePlayback);
            pw.println("  is remote active: " + this.mMainRemoteIsActive);
            pw.println("  rccId: " + this.mMainRemote.mRccId);
            pw.println("  volume handling: " + (this.mMainRemote.mVolumeHandling == 0 ? "PLAYBACK_VOLUME_FIXED(0)" : "PLAYBACK_VOLUME_VARIABLE(1)"));
            pw.println("  volume: " + this.mMainRemote.mVolume);
            pw.println("  volume steps: " + this.mMainRemote.mVolumeMax);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpRCDList(PrintWriter pw) {
        pw.println("\nRemote Control Display list entries:");
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            for (DisplayInfoForServer di : this.mRcDisplays) {
                pw.println("  IRCD: " + di.mRcDisplay + "  -- w:" + di.mArtworkExpectedWidth + "  -- h:" + di.mArtworkExpectedHeight + "  -- wantsPosSync:" + di.mWantsPositionSync + "  -- " + (di.mEnabled ? "enabled" : "disabled"));
            }
        }
    }

    private boolean pushMediaButtonReceiver_syncPrs(PendingIntent mediaIntent, ComponentName target, IBinder token) {
        if (this.mPRStack.empty()) {
            this.mPRStack.push(new PlayerRecord(mediaIntent, target, token));
            return true;
        }
        if (this.mPRStack.peek().hasMatchingMediaButtonIntent(mediaIntent)) {
            return false;
        }
        if (this.mAppOps.noteOp(31, Binder.getCallingUid(), mediaIntent.getCreatorPackage()) != 0) {
            return false;
        }
        PlayerRecord oldTopPrse = (PlayerRecord)this.mPRStack.lastElement();
        boolean topChanged = false;
        PlayerRecord prse = null;
        int lastPlayingIndex = this.mPRStack.size();
        int inStackIndex = -1;
        try {
            for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                prse = (PlayerRecord)this.mPRStack.elementAt(index);
                if (prse.isPlaybackActive()) {
                    lastPlayingIndex = index;
                }
                if (!prse.hasMatchingMediaButtonIntent(mediaIntent)) continue;
                inStackIndex = index;
            }
            if (inStackIndex == -1) {
                prse = new PlayerRecord(mediaIntent, target, token);
                this.mPRStack.add(lastPlayingIndex, prse);
            } else if (this.mPRStack.size() > 1) {
                prse = (PlayerRecord)this.mPRStack.elementAt(inStackIndex);
                this.mPRStack.removeElementAt(inStackIndex);
                if (prse.isPlaybackActive()) {
                    this.mPRStack.push(prse);
                } else if (inStackIndex > lastPlayingIndex) {
                    this.mPRStack.add(lastPlayingIndex, prse);
                } else {
                    this.mPRStack.add(lastPlayingIndex - 1, prse);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, "Wrong index (inStack=" + inStackIndex + " lastPlaying=" + lastPlayingIndex + " size=" + this.mPRStack.size() + " accessing media button stack", e);
        }
        return topChanged;
    }

    private void removeMediaButtonReceiver_syncPrs(PendingIntent pi) {
        try {
            for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                if (!prse.hasMatchingMediaButtonIntent(pi)) continue;
                prse.destroy();
                this.mPRStack.removeElementAt(index);
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
        }
    }

    private boolean isCurrentRcController(PendingIntent pi) {
        return !this.mPRStack.empty() && this.mPRStack.peek().hasMatchingMediaButtonIntent(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNewRcClientOnDisplays_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.mRcDisplays.size() > 0) {
                Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = displayIterator.next();
                    try {
                        di.mRcDisplay.setCurrentClientId(newClientGeneration, newMediaIntent, clearing);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Dead display in setNewRcClientOnDisplays_syncRcsCurrc()", e);
                        di.release();
                        displayIterator.remove();
                    }
                }
            }
        }
    }

    private void setNewRcClientGenerationOnClients_syncRcsCurrc(int newClientGeneration) {
        Iterator stackIterator = this.mPRStack.iterator();
        while (stackIterator.hasNext()) {
            PlayerRecord se = (PlayerRecord)stackIterator.next();
            if (se == null || se.getRcc() == null) continue;
            try {
                se.getRcc().setCurrentClientGenerationId(newClientGeneration);
            }
            catch (RemoteException e) {
                Log.w(TAG, "Dead client in setNewRcClientGenerationOnClients_syncRcsCurrc()", e);
                stackIterator.remove();
                se.unlinkToRcClientDeath();
            }
        }
    }

    private void setNewRcClient_syncRcsCurrc(int newClientGeneration, PendingIntent newMediaIntent, boolean clearing) {
        this.setNewRcClientOnDisplays_syncRcsCurrc(newClientGeneration, newMediaIntent, clearing);
        this.setNewRcClientGenerationOnClients_syncRcsCurrc(newClientGeneration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayClear() {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                ++this.mCurrentRcClientGen;
                this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayUpdate(PlayerRecord prse, int flags) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null && this.mCurrentRcClient.equals(prse.getRcc())) {
                    ++this.mCurrentRcClientGen;
                    this.setNewRcClient_syncRcsCurrc(this.mCurrentRcClientGen, prse.getMediaButtonIntent(), false);
                    try {
                        this.mCurrentRcClient.onInformationRequested(this.mCurrentRcClientGen, flags);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Current valid remote client is dead: " + e);
                        this.mCurrentRcClient = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRcDisplayInitInfo(IRemoteControlDisplay newRcd, int w, int h) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Object object = this.mCurrentRcLock;
            synchronized (object) {
                if (this.mCurrentRcClient != null) {
                    try {
                        newRcd.setCurrentClientId(this.mCurrentRcClientGen, this.mCurrentRcClientIntent, false);
                        try {
                            this.mCurrentRcClient.informationRequestForDisplay(newRcd, w, h);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Current valid remote client is dead: ", e);
                            this.mCurrentRcClient = null;
                        }
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Dead display in onRcDisplayInitInfo()", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearRemoteControlDisplay_syncPrs() {
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            this.mCurrentRcClient = null;
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteControlDisplay_syncPrs(int infoChangedFlags) {
        PlayerRecord prse = this.mPRStack.peek();
        int infoFlagsAboutToBeUsed = infoChangedFlags;
        if (prse.getRcc() == null) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        Object object = this.mCurrentRcLock;
        synchronized (object) {
            if (!prse.getRcc().equals(this.mCurrentRcClient)) {
                infoFlagsAboutToBeUsed = 15;
            }
            this.mCurrentRcClient = prse.getRcc();
            this.mCurrentRcClientIntent = prse.getMediaButtonIntent();
        }
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(2, infoFlagsAboutToBeUsed, 0, prse));
    }

    private void checkUpdateRemoteControlDisplay_syncPrs(int infoChangedFlags) {
        if (this.mPRStack.isEmpty()) {
            this.clearRemoteControlDisplay_syncPrs();
            return;
        }
        this.updateRemoteControlDisplay_syncPrs(infoChangedFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMediaButtonIntent(PendingIntent mediaIntent, ComponentName eventReceiver, IBinder token) {
        Log.i(TAG, "  Remote Control   registerMediaButtonIntent() for " + mediaIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (this.pushMediaButtonReceiver_syncPrs(mediaIntent, eventReceiver, token)) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterMediaButtonIntent(PendingIntent mediaIntent) {
        Log.i(TAG, "  Remote Control   unregisterMediaButtonIntent() for " + mediaIntent);
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean topOfStackWillChange = this.isCurrentRcController(mediaIntent);
            this.removeMediaButtonReceiver_syncPrs(mediaIntent);
            if (topOfStackWillChange) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    protected void unregisterMediaButtonIntentAsync(PendingIntent mediaIntent) {
        this.mEventHandler.sendMessage(this.mEventHandler.obtainMessage(11, 0, 0, mediaIntent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerMediaButtonEventReceiverForCalls(ComponentName c) {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to register media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterMediaButtonEventReceiverForCalls() {
        if (this.mContext.checkCallingPermission("android.permission.MODIFY_PHONE_STATE") != 0) {
            Log.e(TAG, "Invalid permissions to unregister media button receiver for calls");
            return;
        }
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            this.mMediaReceiverForCalls = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int registerRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient, String callingPackageName) {
        int rccId = -1;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (!prse.hasMatchingMediaButtonIntent(mediaIntent)) continue;
                    prse.resetControllerInfoForRcc(rcClient, callingPackageName, Binder.getCallingUid());
                    if (rcClient != null) {
                        rccId = prse.getRccId();
                        if (this.mRcDisplays.size() > 0) {
                            this.plugRemoteControlDisplaysIntoClient_syncPrs(prse.getRcc());
                        }
                    }
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
            }
            if (this.isCurrentRcController(mediaIntent)) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
        return rccId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRemoteControlClient(PendingIntent mediaIntent, IRemoteControlClient rcClient) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean topRccChange = false;
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (!prse.hasMatchingMediaButtonIntent(mediaIntent) || !rcClient.equals(prse.getRcc())) continue;
                    prse.resetControllerInfoForNoRcc();
                    topRccChange = index == this.mPRStack.size() - 1;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
            }
            if (topRccChange) {
                this.checkUpdateRemoteControlDisplay_syncPrs(15);
            }
        }
    }

    private void plugRemoteControlDisplaysIntoClient_syncPrs(IRemoteControlClient rcc) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            try {
                rcc.plugRemoteControlDisplay(di.mRcDisplay, di.mArtworkExpectedWidth, di.mArtworkExpectedHeight);
                if (!di.mWantsPositionSync) continue;
                rcc.setWantsSyncForDisplay(di.mRcDisplay, true);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error connecting RCD to RCC in RCC registration", e);
            }
        }
    }

    private void enableRemoteControlDisplayForClient_syncRcStack(IRemoteControlDisplay rcd, boolean enabled) {
        for (PlayerRecord prse : this.mPRStack) {
            if (prse.getRcc() == null) continue;
            try {
                prse.getRcc().enableRemoteControlDisplay(rcd, enabled);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error connecting RCD to client: ", e);
            }
        }
    }

    private boolean rcDisplayIsPluggedIn_syncRcStack(IRemoteControlDisplay rcd) {
        for (DisplayInfoForServer di : this.mRcDisplays) {
            if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerRemoteControlDisplay_int(IRemoteControlDisplay rcd, int w, int h, ComponentName listenerComp) {
        Object object = mAudioFocusLock;
        synchronized (object) {
            Stack<PlayerRecord> stack = this.mPRStack;
            synchronized (stack) {
                if (rcd == null || this.rcDisplayIsPluggedIn_syncRcStack(rcd)) {
                    return;
                }
                DisplayInfoForServer di = new DisplayInfoForServer(rcd, w, h);
                di.mEnabled = true;
                di.mClientNotifListComp = listenerComp;
                if (!di.init()) {
                    return;
                }
                this.mRcDisplays.add(di);
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().plugRemoteControlDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error connecting RCD to client: ", e);
                    }
                }
                MediaFocusControl.sendMsg(this.mEventHandler, 9, 2, w, h, rcd, 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterRemoteControlDisplay(IRemoteControlDisplay rcd) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            if (rcd == null) {
                return;
            }
            boolean displayWasPluggedIn = false;
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            while (displayIterator.hasNext() && !displayWasPluggedIn) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                displayWasPluggedIn = true;
                di.release();
                displayIterator.remove();
            }
            if (displayWasPluggedIn) {
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().unplugRemoteControlDisplay(rcd);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error disconnecting remote control display to client: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteControlDisplayUsesBitmapSize(IRemoteControlDisplay rcd, int w, int h) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            Iterator<DisplayInfoForServer> displayIterator = this.mRcDisplays.iterator();
            boolean artworkSizeUpdate = false;
            while (displayIterator.hasNext() && !artworkSizeUpdate) {
                DisplayInfoForServer di = displayIterator.next();
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder()) || di.mArtworkExpectedWidth == w && di.mArtworkExpectedHeight == h) continue;
                di.mArtworkExpectedWidth = w;
                di.mArtworkExpectedHeight = h;
                artworkSizeUpdate = true;
            }
            if (artworkSizeUpdate) {
                for (PlayerRecord prse : this.mPRStack) {
                    if (prse.getRcc() == null) continue;
                    try {
                        prse.getRcc().setBitmapSizeForDisplay(rcd, w, h);
                    }
                    catch (RemoteException e) {
                        Log.e(TAG, "Error setting bitmap size for RCD on RCC: ", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remoteControlDisplayWantsPlaybackPositionSync(IRemoteControlDisplay rcd, boolean wantsSync) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            boolean rcdRegistered = false;
            for (DisplayInfoForServer di : this.mRcDisplays) {
                if (!di.mRcDisplay.asBinder().equals(rcd.asBinder())) continue;
                di.mWantsPositionSync = wantsSync;
                rcdRegistered = true;
                break;
            }
            if (!rcdRegistered) {
                return;
            }
            for (PlayerRecord prse : this.mPRStack) {
                if (prse.getRcc() == null) continue;
                try {
                    prse.getRcc().setWantsSyncForDisplay(rcd, wantsSync);
                }
                catch (RemoteException e) {
                    Log.e(TAG, "Error setting position sync flag for RCD on RCC: ", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onRegisterVolumeObserverForRcc(int rccId, IRemoteVolumeObserver rvo) {
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    prse.mRemoteVolumeObs = rvo;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkUpdateRemoteStateIfActive(int streamType) {
        Object object = this.mPRStack;
        synchronized (object) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.mPlaybackType != 1 || !MediaFocusControl.isPlaystateActive(prse.mPlaybackState.mState) || prse.mPlaybackStream != streamType) continue;
                    PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
                    synchronized (remotePlaybackState) {
                        this.mMainRemote.mRccId = prse.getRccId();
                        this.mMainRemote.mVolume = prse.mPlaybackVolume;
                        this.mMainRemote.mVolumeMax = prse.mPlaybackVolumeMax;
                        this.mMainRemote.mVolumeHandling = prse.mPlaybackVolumeHandling;
                        this.mMainRemoteIsActive = true;
                    }
                    return true;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing RC stack, lock error? ", e);
            }
        }
        object = this.mMainRemote;
        synchronized (object) {
            this.mMainRemoteIsActive = false;
        }
        return false;
    }

    protected static boolean isPlaystateActive(int playState) {
        switch (playState) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVolumeUpdateToRemote(int rccId, int direction) {
        if (direction == 0) {
            return;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    rvo = prse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(direction, -1);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error dispatching relative volume update", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemoteStreamMaxVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolumeMax;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRemoteStreamVolume() {
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return 0;
            }
            return this.mMainRemote.mVolume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setRemoteStreamVolume(int vol) {
        int rccId = -1;
        PlayerRecord.RemotePlaybackState remotePlaybackState = this.mMainRemote;
        synchronized (remotePlaybackState) {
            if (this.mMainRemote.mRccId == -1) {
                return;
            }
            rccId = this.mMainRemote.mRccId;
        }
        IRemoteVolumeObserver rvo = null;
        Stack<PlayerRecord> stack = this.mPRStack;
        synchronized (stack) {
            try {
                for (int index = this.mPRStack.size() - 1; index >= 0; --index) {
                    PlayerRecord prse = (PlayerRecord)this.mPRStack.elementAt(index);
                    if (prse.getRccId() != rccId) continue;
                    rvo = prse.mRemoteVolumeObs;
                    break;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e(TAG, "Wrong index accessing media button stack, lock error? ", e);
            }
        }
        if (rvo != null) {
            try {
                rvo.dispatchRemoteVolumeUpdate(0, vol);
            }
            catch (RemoteException e) {
                Log.e(TAG, "Error dispatching absolute volume update", e);
            }
        }
    }

    protected void postReevaluateRemote() {
        MediaFocusControl.sendMsg(this.mEventHandler, 3, 2, 0, 0, null, 0);
    }

    private void onReevaluateRemote() {
    }

    private class DisplayInfoForServer
    implements IBinder.DeathRecipient {
        private final IRemoteControlDisplay mRcDisplay;
        private final IBinder mRcDisplayBinder;
        private int mArtworkExpectedWidth = -1;
        private int mArtworkExpectedHeight = -1;
        private boolean mWantsPositionSync = false;
        private ComponentName mClientNotifListComp;
        private boolean mEnabled = true;

        public DisplayInfoForServer(IRemoteControlDisplay rcd, int w, int h) {
            this.mRcDisplay = rcd;
            this.mRcDisplayBinder = rcd.asBinder();
            this.mArtworkExpectedWidth = w;
            this.mArtworkExpectedHeight = h;
        }

        public boolean init() {
            try {
                this.mRcDisplayBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                Log.w(MediaFocusControl.TAG, "registerRemoteControlDisplay() has a dead client " + this.mRcDisplayBinder);
                return false;
            }
            return true;
        }

        public void release() {
            try {
                this.mRcDisplayBinder.unlinkToDeath(this, 0);
            }
            catch (NoSuchElementException e) {
                Log.e(MediaFocusControl.TAG, "Error in DisplaInfoForServer.relase()", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Stack stack = MediaFocusControl.this.mPRStack;
            synchronized (stack) {
                Log.w(MediaFocusControl.TAG, "RemoteControl: display " + this.mRcDisplay + " died");
                Iterator displayIterator = MediaFocusControl.this.mRcDisplays.iterator();
                while (displayIterator.hasNext()) {
                    DisplayInfoForServer di = (DisplayInfoForServer)displayIterator.next();
                    if (di.mRcDisplay != this.mRcDisplay) continue;
                    displayIterator.remove();
                    return;
                }
            }
        }
    }

    protected class AudioFocusDeathHandler
    implements IBinder.DeathRecipient {
        private IBinder mCb;

        AudioFocusDeathHandler(IBinder cb) {
            this.mCb = cb;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = mAudioFocusLock;
            synchronized (object) {
                Log.w(MediaFocusControl.TAG, "  AudioFocus   audio focus client died");
                MediaFocusControl.this.removeFocusStackEntryForClient(this.mCb);
            }
        }

        public IBinder getBinder() {
            return this.mCb;
        }
    }

    private class MediaEventHandler
    extends Handler {
        MediaEventHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MediaFocusControl.this.onRcDisplayClear();
                    break;
                }
                case 2: {
                    MediaFocusControl.this.onRcDisplayUpdate((PlayerRecord)msg.obj, msg.arg1);
                    break;
                }
                case 3: {
                    MediaFocusControl.this.onReevaluateRemote();
                    break;
                }
                case 5: {
                    MediaFocusControl.this.onRegisterVolumeObserverForRcc(msg.arg1, (IRemoteVolumeObserver)msg.obj);
                    break;
                }
                case 9: {
                    MediaFocusControl.this.onRcDisplayInitInfo((IRemoteControlDisplay)msg.obj, msg.arg1, msg.arg2);
                    break;
                }
                case 10: {
                    MediaFocusControl.this.onReevaluateRemoteControlDisplays();
                    break;
                }
                case 11: {
                    MediaFocusControl.this.unregisterMediaButtonIntent((PendingIntent)msg.obj);
                }
            }
        }
    }

    private class NotificationListenerObserver
    extends ContentObserver {
        NotificationListenerObserver() {
            super(MediaFocusControl.this.mEventHandler);
            MediaFocusControl.this.mContentResolver.registerContentObserver(Settings.Secure.getUriFor("enabled_notification_listeners"), false, this);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            if (!ENABLED_NOTIFICATION_LISTENERS_URI.equals(uri) || selfChange) {
                return;
            }
            MediaFocusControl.this.postReevaluateRemoteControlDisplays();
        }
    }
}

