/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.backup.BackupDataInputStream;
import android.app.backup.BackupDataOutput;
import android.app.backup.BackupHelper;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SyncAdapterType;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AccountSyncSettingsBackupHelper
implements BackupHelper {
    private static final String TAG = "AccountSyncSettingsBackupHelper";
    private static final boolean DEBUG = false;
    private static final int STATE_VERSION = 1;
    private static final int MD5_BYTE_SIZE = 16;
    private static final int SYNC_REQUEST_LATCH_TIMEOUT_SECONDS = 1;
    private static final String JSON_FORMAT_HEADER_KEY = "account_data";
    private static final String JSON_FORMAT_ENCODING = "UTF-8";
    private static final int JSON_FORMAT_VERSION = 1;
    private static final String KEY_VERSION = "version";
    private static final String KEY_MASTER_SYNC_ENABLED = "masterSyncEnabled";
    private static final String KEY_ACCOUNTS = "accounts";
    private static final String KEY_ACCOUNT_NAME = "name";
    private static final String KEY_ACCOUNT_TYPE = "type";
    private static final String KEY_ACCOUNT_AUTHORITIES = "authorities";
    private static final String KEY_AUTHORITY_NAME = "name";
    private static final String KEY_AUTHORITY_SYNC_STATE = "syncState";
    private static final String KEY_AUTHORITY_SYNC_ENABLED = "syncEnabled";
    private Context mContext;
    private AccountManager mAccountManager;

    public AccountSyncSettingsBackupHelper(Context context) {
        this.mContext = context;
        this.mAccountManager = AccountManager.get(this.mContext);
    }

    @Override
    public void performBackup(ParcelFileDescriptor oldState, BackupDataOutput output, ParcelFileDescriptor newState) {
        try {
            JSONObject dataJSON = this.serializeAccountSyncSettingsToJSON();
            byte[] dataBytes = dataJSON.toString().getBytes(JSON_FORMAT_ENCODING);
            byte[] oldMd5Checksum = this.readOldMd5Checksum(oldState);
            byte[] newMd5Checksum = this.generateMd5Checksum(dataBytes);
            if (!Arrays.equals(oldMd5Checksum, newMd5Checksum)) {
                int dataSize = dataBytes.length;
                output.writeEntityHeader(JSON_FORMAT_HEADER_KEY, dataSize);
                output.writeEntityData(dataBytes, dataSize);
                Log.i(TAG, "Backup successful.");
            } else {
                Log.i(TAG, "Old and new MD5 checksums match. Skipping backup.");
            }
            this.writeNewMd5Checksum(newState, newMd5Checksum);
        }
        catch (IOException | NoSuchAlgorithmException | JSONException e) {
            Log.e(TAG, "Couldn't backup account sync settings\n" + e);
        }
    }

    private JSONObject serializeAccountSyncSettingsToJSON() throws JSONException {
        Account[] accounts = this.mAccountManager.getAccounts();
        SyncAdapterType[] syncAdapters = ContentResolver.getSyncAdapterTypesAsUser(this.mContext.getUserId());
        HashMap accountTypeToAuthorities = new HashMap();
        for (SyncAdapterType syncAdapter : syncAdapters) {
            if (!syncAdapter.isUserVisible()) continue;
            if (!accountTypeToAuthorities.containsKey(syncAdapter.accountType)) {
                accountTypeToAuthorities.put(syncAdapter.accountType, new ArrayList());
            }
            ((List)accountTypeToAuthorities.get(syncAdapter.accountType)).add(syncAdapter.authority);
        }
        JSONObject backupJSON = new JSONObject();
        backupJSON.put(KEY_VERSION, 1);
        backupJSON.put(KEY_MASTER_SYNC_ENABLED, ContentResolver.getMasterSyncAutomatically());
        JSONArray accountJSONArray = new JSONArray();
        for (Account account : accounts) {
            List authorities = (List)accountTypeToAuthorities.get(account.type);
            if (authorities == null || authorities.isEmpty()) continue;
            JSONObject accountJSON = new JSONObject();
            accountJSON.put("name", account.name);
            accountJSON.put(KEY_ACCOUNT_TYPE, account.type);
            JSONArray authoritiesJSONArray = new JSONArray();
            for (String authority : authorities) {
                int syncState = ContentResolver.getIsSyncable(account, authority);
                boolean syncEnabled = ContentResolver.getSyncAutomatically(account, authority);
                JSONObject authorityJSON = new JSONObject();
                authorityJSON.put("name", authority);
                authorityJSON.put(KEY_AUTHORITY_SYNC_STATE, syncState);
                authorityJSON.put(KEY_AUTHORITY_SYNC_ENABLED, syncEnabled);
                authoritiesJSONArray.put(authorityJSON);
            }
            accountJSON.put(KEY_ACCOUNT_AUTHORITIES, authoritiesJSONArray);
            accountJSONArray.put(accountJSON);
        }
        backupJSON.put(KEY_ACCOUNTS, accountJSONArray);
        return backupJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readOldMd5Checksum(ParcelFileDescriptor oldState) throws IOException {
        byte[] oldMd5Checksum = new byte[16];
        try (DataInputStream dataInput = new DataInputStream(new FileInputStream(oldState.getFileDescriptor()));){
            int stateVersion = dataInput.readInt();
            if (stateVersion <= 1) {
                for (int i = 0; i < 16; ++i) {
                    oldMd5Checksum[i] = dataInput.readByte();
                }
            } else {
                Log.i(TAG, "Backup state version is: " + stateVersion + " (support only up to version " + 1 + ")");
            }
        }
        return oldMd5Checksum;
    }

    private void writeNewMd5Checksum(ParcelFileDescriptor newState, byte[] md5Checksum) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(newState.getFileDescriptor())));
        dataOutput.writeInt(1);
        dataOutput.write(md5Checksum);
        dataOutput.close();
    }

    private byte[] generateMd5Checksum(byte[] data) throws NoSuchAlgorithmException {
        if (data == null) {
            return null;
        }
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return md5.digest(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restoreEntity(BackupDataInputStream data) {
        byte[] dataBytes = new byte[data.size()];
        try {
            data.read(dataBytes);
            String dataString = new String(dataBytes, JSON_FORMAT_ENCODING);
            JSONObject dataJSON = new JSONObject(dataString);
            boolean masterSyncEnabled = dataJSON.getBoolean(KEY_MASTER_SYNC_ENABLED);
            JSONArray accountJSONArray = dataJSON.getJSONArray(KEY_ACCOUNTS);
            boolean currentMasterSyncEnabled = ContentResolver.getMasterSyncAutomatically();
            if (currentMasterSyncEnabled) {
                ContentResolver.setMasterSyncAutomatically(false);
            }
            try {
                HashSet<Account> currentAccounts = this.getAccountsHashSet();
                for (int i = 0; i < accountJSONArray.length(); ++i) {
                    String accountType;
                    JSONObject accountJSON = (JSONObject)accountJSONArray.get(i);
                    String accountName = accountJSON.getString("name");
                    Account account = new Account(accountName, accountType = accountJSON.getString(KEY_ACCOUNT_TYPE));
                    if (!currentAccounts.contains(account)) continue;
                    this.restoreExistingAccountSyncSettingsFromJSON(accountJSON);
                }
            }
            finally {
                ContentResolver.setMasterSyncAutomatically(masterSyncEnabled);
            }
            Log.i(TAG, "Restore successful.");
        }
        catch (IOException | JSONException e) {
            Log.e(TAG, "Couldn't restore account sync settings\n" + e);
        }
    }

    private HashSet<Account> getAccountsHashSet() {
        Account[] accounts = this.mAccountManager.getAccounts();
        HashSet<Account> accountHashSet = new HashSet<Account>();
        for (Account account : accounts) {
            accountHashSet.add(account);
        }
        return accountHashSet;
    }

    private void restoreExistingAccountSyncSettingsFromJSON(JSONObject accountJSON) throws JSONException {
        JSONArray authorities = accountJSON.getJSONArray(KEY_ACCOUNT_AUTHORITIES);
        String accountName = accountJSON.getString("name");
        String accountType = accountJSON.getString(KEY_ACCOUNT_TYPE);
        Account account = new Account(accountName, accountType);
        for (int i = 0; i < authorities.length(); ++i) {
            JSONObject authority = (JSONObject)authorities.get(i);
            String authorityName = authority.getString("name");
            boolean wasSyncEnabled = authority.getBoolean(KEY_AUTHORITY_SYNC_ENABLED);
            int wasSyncable = authority.getInt(KEY_AUTHORITY_SYNC_STATE);
            ContentResolver.setSyncAutomaticallyAsUser(account, authorityName, wasSyncEnabled, 0);
            if (wasSyncEnabled) continue;
            ContentResolver.setIsSyncable(account, authorityName, wasSyncable == 0 ? 0 : 2);
        }
    }

    @Override
    public void writeNewStateDescription(ParcelFileDescriptor newState) {
    }
}

