/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Environment;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Slog;
import com.android.server.backup.BackupManagerService;
import com.android.server.backup.FullBackupJob;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;

public class Trampoline
extends IBackupManager.Stub {
    static final String TAG = "BackupManagerService";
    static final boolean DEBUG_TRAMPOLINE = false;
    static final String BACKUP_SUPPRESS_FILENAME = "backup-suppress";
    static final String BACKUP_DISABLE_PROPERTY = "ro.backup.disable";
    final Context mContext;
    final File mSuppressFile;
    final boolean mGlobalDisable;
    volatile BackupManagerService mService;

    public Trampoline(Context context) {
        this.mContext = context;
        File dir = new File(Environment.getSecureDataDirectory(), "backup");
        dir.mkdirs();
        this.mSuppressFile = new File(dir, BACKUP_SUPPRESS_FILENAME);
        this.mGlobalDisable = SystemProperties.getBoolean(BACKUP_DISABLE_PROPERTY, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(int whichUser) {
        if (whichUser == 0) {
            if (this.mGlobalDisable) {
                Slog.i(TAG, "Backup/restore not supported");
                return;
            }
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (!this.mSuppressFile.exists()) {
                    this.mService = new BackupManagerService(this.mContext, this);
                } else {
                    Slog.i(TAG, "Backup inactive in user " + whichUser);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupServiceActive(int userHandle, boolean makeActive) {
        int caller = Binder.getCallingUid();
        if (caller != 1000 && caller != 0) {
            throw new SecurityException("No permission to configure backup activity");
        }
        if (this.mGlobalDisable) {
            Slog.i(TAG, "Backup/restore not supported");
            return;
        }
        if (userHandle == 0) {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                if (makeActive != this.isBackupServiceActive(userHandle)) {
                    Slog.i(TAG, "Making backup " + (makeActive ? "" : "in") + "active in user " + userHandle);
                    if (makeActive) {
                        this.mService = new BackupManagerService(this.mContext, this);
                        this.mSuppressFile.delete();
                    } else {
                        this.mService = null;
                        try {
                            this.mSuppressFile.createNewFile();
                        }
                        catch (IOException e) {
                            Slog.e(TAG, "Unable to persist backup service inactivity");
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isBackupServiceActive(int userHandle) {
        if (userHandle == 0) {
            Trampoline trampoline = this;
            synchronized (trampoline) {
                return this.mService != null;
            }
        }
        return false;
    }

    @Override
    public void dataChanged(String packageName) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.dataChanged(packageName);
        }
    }

    @Override
    public void clearBackupData(String transportName, String packageName) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.clearBackupData(transportName, packageName);
        }
    }

    @Override
    public void agentConnected(String packageName, IBinder agent) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.agentConnected(packageName, agent);
        }
    }

    @Override
    public void agentDisconnected(String packageName) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.agentDisconnected(packageName);
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.restoreAtInstall(packageName, token);
        }
    }

    @Override
    public void setBackupEnabled(boolean isEnabled) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.setBackupEnabled(isEnabled);
        }
    }

    @Override
    public void setAutoRestore(boolean doAutoRestore) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.setAutoRestore(doAutoRestore);
        }
    }

    @Override
    public void setBackupProvisioned(boolean isProvisioned) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.setBackupProvisioned(isProvisioned);
        }
    }

    @Override
    public boolean isBackupEnabled() throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.isBackupEnabled() : false;
    }

    @Override
    public boolean setBackupPassword(String currentPw, String newPw) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.setBackupPassword(currentPw, newPw) : false;
    }

    @Override
    public boolean hasBackupPassword() throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.hasBackupPassword() : false;
    }

    @Override
    public void backupNow() throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.backupNow();
        }
    }

    @Override
    public void fullBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean allApps, boolean allIncludesSystem, boolean doCompress, String[] packageNames) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.fullBackup(fd, includeApks, includeObbs, includeShared, doWidgets, allApps, allIncludesSystem, doCompress, packageNames);
        }
    }

    @Override
    public void fullTransportBackup(String[] packageNames) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.fullTransportBackup(packageNames);
        }
    }

    @Override
    public void fullRestore(ParcelFileDescriptor fd) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.fullRestore(fd);
        }
    }

    @Override
    public void acknowledgeFullBackupOrRestore(int token, boolean allow, String curPassword, String encryptionPassword, IFullBackupRestoreObserver observer) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.acknowledgeFullBackupOrRestore(token, allow, curPassword, encryptionPassword, observer);
        }
    }

    @Override
    public String getCurrentTransport() throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getCurrentTransport() : null;
    }

    @Override
    public String[] listAllTransports() throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.listAllTransports() : null;
    }

    @Override
    public String selectBackupTransport(String transport) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.selectBackupTransport(transport) : null;
    }

    @Override
    public Intent getConfigurationIntent(String transport) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getConfigurationIntent(transport) : null;
    }

    @Override
    public String getDestinationString(String transport) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getDestinationString(transport) : null;
    }

    @Override
    public Intent getDataManagementIntent(String transport) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getDataManagementIntent(transport) : null;
    }

    @Override
    public String getDataManagementLabel(String transport) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getDataManagementLabel(transport) : null;
    }

    @Override
    public IRestoreSession beginRestoreSession(String packageName, String transportID) throws RemoteException {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.beginRestoreSession(packageName, transportID) : null;
    }

    @Override
    public void opComplete(int token, long result) throws RemoteException {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.opComplete(token, result);
        }
    }

    @Override
    public long getAvailableRestoreToken(String packageName) {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.getAvailableRestoreToken(packageName) : 0L;
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.dump(fd, pw, args);
        } else {
            pw.println("Inactive");
        }
    }

    boolean beginFullBackup(FullBackupJob scheduledJob) {
        BackupManagerService svc = this.mService;
        return svc != null ? svc.beginFullBackup(scheduledJob) : false;
    }

    void endFullBackup() {
        BackupManagerService svc = this.mService;
        if (svc != null) {
            svc.endFullBackup();
        }
    }
}

