/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.camera;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.UserInfo;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceProxy;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.os.UserManager;
import android.util.Slog;
import com.android.server.ServiceThread;
import com.android.server.SystemService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CameraService
extends SystemService
implements Handler.Callback {
    private static final String TAG = "CameraService_proxy";
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    public static final String CAMERA_SERVICE_PROXY_BINDER_NAME = "media.camera.proxy";
    public static final int NO_EVENT = 0;
    public static final int USER_SWITCHED = 1;
    private static final int MSG_SWITCH_USER = 1;
    private static final int RETRY_DELAY_TIME = 20;
    private final Context mContext;
    private final ServiceThread mHandlerThread;
    private final Handler mHandler;
    private UserManager mUserManager;
    private final Object mLock = new Object();
    private Set<Integer> mEnabledCameraUsers;
    private int mLastUser;
    private final BroadcastReceiver mIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            switch (action) {
                case "android.intent.action.USER_ADDED": 
                case "android.intent.action.USER_REMOVED": 
                case "android.intent.action.USER_INFO_CHANGED": 
                case "android.intent.action.MANAGED_PROFILE_ADDED": 
                case "android.intent.action.MANAGED_PROFILE_REMOVED": {
                    Object object = CameraService.this.mLock;
                    synchronized (object) {
                        if (CameraService.this.mEnabledCameraUsers == null) {
                            return;
                        }
                        CameraService.this.switchUserLocked(CameraService.this.mLastUser);
                        break;
                    }
                }
            }
        }
    };
    private final ICameraServiceProxy.Stub mCameraServiceProxy = new ICameraServiceProxy.Stub(){

        @Override
        public void pingForUserUpdate() {
            CameraService.this.notifySwitchWithRetries(30);
        }
    };

    public CameraService(Context context) {
        super(context);
        this.mContext = context;
        this.mHandlerThread = new ServiceThread(TAG, -4, false);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper(), this);
    }

    @Override
    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.notifySwitchWithRetries(msg.arg1);
                break;
            }
            default: {
                Slog.e(TAG, "CameraService error, invalid message: " + msg.what);
            }
        }
        return true;
    }

    @Override
    public void onStart() {
        this.mUserManager = UserManager.get(this.mContext);
        if (this.mUserManager == null) {
            throw new IllegalStateException("UserManagerService must start before CameraService!");
        }
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.USER_ADDED");
        filter.addAction("android.intent.action.USER_REMOVED");
        filter.addAction("android.intent.action.USER_INFO_CHANGED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_ADDED");
        filter.addAction("android.intent.action.MANAGED_PROFILE_REMOVED");
        this.mContext.registerReceiver(this.mIntentReceiver, filter);
        this.publishBinderService(CAMERA_SERVICE_PROXY_BINDER_NAME, this.mCameraServiceProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStartUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                this.switchUserLocked(userHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int userHandle) {
        Object object = this.mLock;
        synchronized (object) {
            this.switchUserLocked(userHandle);
        }
    }

    private void switchUserLocked(int userHandle) {
        Set<Integer> currentUserHandles = this.getEnabledUserHandles(userHandle);
        this.mLastUser = userHandle;
        if (this.mEnabledCameraUsers == null || !this.mEnabledCameraUsers.equals(currentUserHandles)) {
            this.mEnabledCameraUsers = currentUserHandles;
            this.notifyMediaserver(1, currentUserHandles);
        }
    }

    private Set<Integer> getEnabledUserHandles(int currentUserHandle) {
        List<UserInfo> userProfiles = this.mUserManager.getEnabledProfiles(currentUserHandle);
        HashSet<Integer> handles = new HashSet<Integer>(userProfiles.size());
        for (UserInfo i : userProfiles) {
            handles.add(i.id);
        }
        return handles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySwitchWithRetries(int retries) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mEnabledCameraUsers == null) {
                return;
            }
            if (this.notifyMediaserver(1, this.mEnabledCameraUsers)) {
                retries = 0;
            }
        }
        if (retries <= 0) {
            return;
        }
        Slog.i(TAG, "Could not notify camera service of user switch, retrying...");
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1, retries - 1, 0, null), 20L);
    }

    private boolean notifyMediaserver(int eventType, Set<Integer> updatedUserHandles) {
        IBinder cameraServiceBinder = this.getBinderService(CAMERA_SERVICE_BINDER_NAME);
        if (cameraServiceBinder == null) {
            Slog.w(TAG, "Could not notify mediaserver, camera service not available.");
            return false;
        }
        ICameraService cameraServiceRaw = ICameraService.Stub.asInterface(cameraServiceBinder);
        try {
            cameraServiceRaw.notifySystemEvent(eventType, CameraService.toArray(updatedUserHandles));
        }
        catch (RemoteException e) {
            Slog.w(TAG, "Could not notify mediaserver, remote exception: " + e);
            return false;
        }
        return true;
    }

    private static int[] toArray(Collection<Integer> c) {
        int len = c.size();
        int[] ret = new int[len];
        int idx = 0;
        for (Integer i : c) {
            ret[idx++] = i;
        }
        return ret;
    }
}

