/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.Context;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.net.NetworkMisc;
import android.net.NetworkRequest;
import android.os.Handler;
import android.os.Messenger;
import android.util.SparseArray;
import com.android.internal.util.AsyncChannel;
import com.android.server.ConnectivityService;
import com.android.server.connectivity.Nat464Xlat;
import com.android.server.connectivity.NetworkMonitor;
import java.util.ArrayList;

public class NetworkAgentInfo
implements Comparable<NetworkAgentInfo> {
    public NetworkInfo networkInfo;
    public final Network network;
    public LinkProperties linkProperties;
    public NetworkCapabilities networkCapabilities;
    public final NetworkMonitor networkMonitor;
    public final NetworkMisc networkMisc;
    public boolean created;
    public boolean everValidated;
    public boolean lastValidated;
    public boolean everCaptivePortalDetected;
    public boolean lastCaptivePortalDetected;
    public boolean lingering;
    private int currentScore;
    private static final int UNVALIDATED_SCORE_PENALTY = 40;
    private static final int MAXIMUM_NETWORK_SCORE = 100;
    public final SparseArray<NetworkRequest> networkRequests = new SparseArray();
    public final ArrayList<NetworkRequest> networkLingered = new ArrayList();
    public final Messenger messenger;
    public final AsyncChannel asyncChannel;
    public Nat464Xlat clatd;

    public NetworkAgentInfo(Messenger messenger, AsyncChannel ac, Network net, NetworkInfo info, LinkProperties lp, NetworkCapabilities nc, int score, Context context, Handler handler, NetworkMisc misc, NetworkRequest defaultRequest, ConnectivityService connService) {
        this.messenger = messenger;
        this.asyncChannel = ac;
        this.network = net;
        this.networkInfo = info;
        this.linkProperties = lp;
        this.networkCapabilities = nc;
        this.currentScore = score;
        this.networkMonitor = connService.createNetworkMonitor(context, handler, this, defaultRequest);
        this.networkMisc = misc;
    }

    public boolean addRequest(NetworkRequest networkRequest) {
        if (this.networkRequests.get(networkRequest.requestId) == networkRequest) {
            return false;
        }
        this.networkRequests.put(networkRequest.requestId, networkRequest);
        return true;
    }

    public boolean satisfies(NetworkRequest request) {
        return this.created && request.networkCapabilities.satisfiedByNetworkCapabilities(this.networkCapabilities);
    }

    public boolean isVPN() {
        return this.networkCapabilities.hasTransport(4);
    }

    private int getCurrentScore(boolean pretendValidated) {
        if (this.networkMisc.explicitlySelected && (this.networkMisc.acceptUnvalidated || pretendValidated)) {
            return 100;
        }
        int score = this.currentScore;
        if (!this.networkCapabilities.hasCapability(16) && !pretendValidated) {
            score -= 40;
        }
        if (score < 0) {
            score = 0;
        }
        return score;
    }

    public int getCurrentScore() {
        return this.getCurrentScore(false);
    }

    public int getCurrentScoreAsValidated() {
        return this.getCurrentScore(true);
    }

    public void setCurrentScore(int newScore) {
        this.currentScore = newScore;
    }

    public String toString() {
        return "NetworkAgentInfo{ ni{" + this.networkInfo + "}  network{" + this.network + "}  lp{" + this.linkProperties + "}  nc{" + this.networkCapabilities + "}  Score{" + this.getCurrentScore() + "}  " + "everValidated{" + this.everValidated + "}  lastValidated{" + this.lastValidated + "}  " + "created{" + this.created + "} lingering{" + this.lingering + "} " + "explicitlySelected{" + this.networkMisc.explicitlySelected + "} " + "acceptUnvalidated{" + this.networkMisc.acceptUnvalidated + "} " + "everCaptivePortalDetected{" + this.everCaptivePortalDetected + "} " + "lastCaptivePortalDetected{" + this.lastCaptivePortalDetected + "} " + "}";
    }

    public String name() {
        return "NetworkAgentInfo [" + this.networkInfo.getTypeName() + " (" + this.networkInfo.getSubtypeName() + ") - " + (this.network == null ? "null" : this.network.toString()) + "]";
    }

    @Override
    public int compareTo(NetworkAgentInfo other) {
        return other.getCurrentScore() - this.getCurrentScore();
    }
}

