/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.UserInfo;
import android.net.Uri;
import android.os.INetworkManagementService;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PermissionMonitor {
    private static final String TAG = "PermissionMonitor";
    private static final boolean DBG = true;
    private static final boolean SYSTEM = true;
    private static final boolean NETWORK = false;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final UserManager mUserManager;
    private final INetworkManagementService mNetd;
    private final BroadcastReceiver mIntentReceiver;
    private final Set<Integer> mUsers = new HashSet<Integer>();
    private final Map<Integer, Boolean> mApps = new HashMap<Integer, Boolean>();

    public PermissionMonitor(Context context, INetworkManagementService netd) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mUserManager = UserManager.get(context);
        this.mNetd = netd;
        this.mIntentReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                String appName;
                String action = intent.getAction();
                int user = intent.getIntExtra("android.intent.extra.user_handle", -10000);
                int appUid = intent.getIntExtra("android.intent.extra.UID", -1);
                Uri appData = intent.getData();
                String string2 = appName = appData != null ? appData.getSchemeSpecificPart() : null;
                if ("android.intent.action.USER_ADDED".equals(action)) {
                    PermissionMonitor.this.onUserAdded(user);
                } else if ("android.intent.action.USER_REMOVED".equals(action)) {
                    PermissionMonitor.this.onUserRemoved(user);
                } else if ("android.intent.action.PACKAGE_ADDED".equals(action)) {
                    PermissionMonitor.this.onAppAdded(appName, appUid);
                } else if ("android.intent.action.PACKAGE_REMOVED".equals(action)) {
                    PermissionMonitor.this.onAppRemoved(appUid);
                }
            }
        };
    }

    public synchronized void startMonitoring() {
        PermissionMonitor.log("Monitoring");
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_ADDED");
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiverAsUser(this.mIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        List<PackageInfo> apps = this.mPackageManager.getInstalledPackages(4096);
        if (apps == null) {
            PermissionMonitor.loge("No apps");
            return;
        }
        for (PackageInfo app : apps) {
            Boolean permission2;
            int uid;
            int n = uid = app.applicationInfo != null ? app.applicationInfo.uid : -1;
            if (uid < 0) continue;
            boolean isNetwork = this.hasNetworkPermission(app);
            boolean isSystem = this.hasSystemPermission(app);
            if (!isNetwork && !isSystem || (permission2 = this.mApps.get(uid)) != null && permission2.booleanValue()) continue;
            this.mApps.put(uid, isSystem);
        }
        List<UserInfo> users = this.mUserManager.getUsers(true);
        if (users != null) {
            for (UserInfo user : users) {
                this.mUsers.add(user.id);
            }
        }
        PermissionMonitor.log("Users: " + this.mUsers.size() + ", Apps: " + this.mApps.size());
        this.update(this.mUsers, this.mApps, true);
    }

    private boolean hasPermission(PackageInfo app, String permission2) {
        if (app.requestedPermissions != null) {
            for (String p : app.requestedPermissions) {
                if (!permission2.equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNetworkPermission(PackageInfo app) {
        return this.hasPermission(app, "android.permission.CHANGE_NETWORK_STATE");
    }

    private boolean hasSystemPermission(PackageInfo app) {
        int flags;
        int n = flags = app.applicationInfo != null ? app.applicationInfo.flags : 0;
        if ((flags & 1) != 0 || (flags & 0x80) != 0) {
            return true;
        }
        return this.hasPermission(app, "android.permission.CONNECTIVITY_INTERNAL");
    }

    private int[] toIntArray(List<Integer> list) {
        int[] array2 = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            array2[i] = list.get(i);
        }
        return array2;
    }

    private void update(Set<Integer> users, Map<Integer, Boolean> apps, boolean add) {
        ArrayList<Integer> network = new ArrayList<Integer>();
        ArrayList<Integer> system = new ArrayList<Integer>();
        for (Map.Entry<Integer, Boolean> app : apps.entrySet()) {
            ArrayList<Integer> list = app.getValue() != false ? system : network;
            for (int user : users) {
                list.add(UserHandle.getUid(user, app.getKey()));
            }
        }
        try {
            if (add) {
                this.mNetd.setPermission("NETWORK", this.toIntArray(network));
                this.mNetd.setPermission("SYSTEM", this.toIntArray(system));
            } else {
                this.mNetd.clearPermission(this.toIntArray(network));
                this.mNetd.clearPermission(this.toIntArray(system));
            }
        }
        catch (RemoteException e) {
            PermissionMonitor.loge("Exception when updating permissions: " + e);
        }
    }

    private synchronized void onUserAdded(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserAdded: " + user);
            return;
        }
        this.mUsers.add(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, true);
    }

    private synchronized void onUserRemoved(int user) {
        if (user < 0) {
            PermissionMonitor.loge("Invalid user in onUserRemoved: " + user);
            return;
        }
        this.mUsers.remove(user);
        HashSet<Integer> users = new HashSet<Integer>();
        users.add(user);
        this.update(users, this.mApps, false);
    }

    private synchronized void onAppAdded(String appName, int appUid) {
        if (TextUtils.isEmpty(appName) || appUid < 0) {
            PermissionMonitor.loge("Invalid app in onAppAdded: " + appName + " | " + appUid);
            return;
        }
        try {
            Boolean permission2;
            PackageInfo app = this.mPackageManager.getPackageInfo(appName, 4096);
            boolean isNetwork = this.hasNetworkPermission(app);
            boolean isSystem = this.hasSystemPermission(app);
            if (!(!isNetwork && !isSystem || (permission2 = this.mApps.get(appUid)) != null && permission2.booleanValue())) {
                this.mApps.put(appUid, isSystem);
                HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
                apps.put(appUid, isSystem);
                this.update(this.mUsers, apps, true);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            PermissionMonitor.loge("NameNotFoundException in onAppAdded: " + e);
        }
    }

    private synchronized void onAppRemoved(int appUid) {
        if (appUid < 0) {
            PermissionMonitor.loge("Invalid app in onAppRemoved: " + appUid);
            return;
        }
        this.mApps.remove(appUid);
        HashMap<Integer, Boolean> apps = new HashMap<Integer, Boolean>();
        apps.put(appUid, false);
        this.update(this.mUsers, apps, false);
    }

    private static void log(String s) {
        Log.d(TAG, s);
    }

    private static void loge(String s) {
        Log.e(TAG, s);
    }
}

