/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.app.usage.UsageStatsManagerInternal;
import com.android.server.LocalServices;
import com.android.server.content.SyncManager;

class AppIdleMonitor
extends UsageStatsManagerInternal.AppIdleStateChangeListener {
    private final SyncManager mSyncManager;
    private final UsageStatsManagerInternal mUsageStats;
    private boolean mAppIdleParoleOn;

    AppIdleMonitor(SyncManager syncManager) {
        this.mSyncManager = syncManager;
        this.mUsageStats = LocalServices.getService(UsageStatsManagerInternal.class);
        this.mAppIdleParoleOn = this.mUsageStats.isAppIdleParoleOn();
        this.mUsageStats.addAppIdleStateChangeListener(this);
    }

    void setAppIdleParoleOn(boolean appIdleParoleOn) {
        if (this.mAppIdleParoleOn == appIdleParoleOn) {
            return;
        }
        this.mAppIdleParoleOn = appIdleParoleOn;
        if (this.mAppIdleParoleOn) {
            this.mSyncManager.onAppNotIdle(null, -1);
        }
    }

    boolean isAppIdle(String packageName, int userId) {
        return !this.mAppIdleParoleOn && this.mUsageStats.isAppIdle(packageName, userId);
    }

    @Override
    public void onAppIdleStateChanged(String packageName, int userId, boolean idle) {
        if (idle) {
            return;
        }
        this.mSyncManager.onAppNotIdle(packageName, userId);
    }

    @Override
    public void onParoleStateChanged(boolean isParoleOn) {
        this.setAppIdleParoleOn(isParoleOn);
    }
}

