/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.content.pm.PackageManagerInternal;
import android.database.IContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.Slog;
import android.util.SparseIntArray;
import com.android.server.LocalServices;
import com.android.server.content.SyncManager;
import com.android.server.content.SyncStorageEngine;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class ContentService
extends IContentService.Stub {
    private static final String TAG = "ContentService";
    private Context mContext;
    private boolean mFactoryTest;
    private final ObserverNode mRootNode = new ObserverNode("");
    private SyncManager mSyncManager = null;
    private final Object mSyncManagerLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SyncManager getSyncManager() {
        if (SystemProperties.getBoolean("config.disable_network", false)) {
            return null;
        }
        Object object = this.mSyncManagerLock;
        synchronized (object) {
            try {
                if (this.mSyncManager == null) {
                    this.mSyncManager = new SyncManager(this.mContext, this.mFactoryTest);
                }
            }
            catch (SQLiteException e) {
                Log.e(TAG, "Can't create SyncManager", e);
            }
            return this.mSyncManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "caller doesn't have the DUMP permission");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            if (this.mSyncManager == null) {
                pw.println("No SyncManager created!  (Disk full?)");
            } else {
                this.mSyncManager.dump(fd, pw);
            }
            pw.println();
            pw.println("Observer tree:");
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                int i;
                int[] counts = new int[2];
                final SparseIntArray pidCounts = new SparseIntArray();
                this.mRootNode.dumpLocked(fd, pw, args, "", "  ", counts, pidCounts);
                pw.println();
                ArrayList<Integer> sorted = new ArrayList<Integer>();
                for (i = 0; i < pidCounts.size(); ++i) {
                    sorted.add(pidCounts.keyAt(i));
                }
                Collections.sort(sorted, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer lhs, Integer rhs) {
                        int rc;
                        int lc = pidCounts.get(lhs);
                        if (lc < (rc = pidCounts.get(rhs))) {
                            return 1;
                        }
                        if (lc > rc) {
                            return -1;
                        }
                        return 0;
                    }
                });
                for (i = 0; i < sorted.size(); ++i) {
                    int pid = (Integer)sorted.get(i);
                    pw.print("  pid ");
                    pw.print(pid);
                    pw.print(": ");
                    pw.print(pidCounts.get(pid));
                    pw.println(" observers");
                }
                pw.println();
                pw.print(" Total number of nodes: ");
                pw.println(counts[0]);
                pw.print(" Total number of observers: ");
                pw.println(counts[1]);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
        try {
            return super.onTransact(code, data, reply, flags);
        }
        catch (RuntimeException e) {
            if (!(e instanceof SecurityException)) {
                Slog.wtf(TAG, "Content Service Crash", e);
            }
            throw e;
        }
    }

    ContentService(Context context, boolean factoryTest) {
        this.mContext = context;
        this.mFactoryTest = factoryTest;
        PackageManagerInternal packageManagerInternal = LocalServices.getService(PackageManagerInternal.class);
        packageManagerInternal.setSyncAdapterPackagesprovider(new PackageManagerInternal.SyncAdapterPackagesProvider(){

            @Override
            public String[] getPackages(String authority, int userId) {
                return ContentService.this.getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
            }
        });
    }

    public void systemReady() {
        this.getSyncManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer, int userHandle) {
        if (observer == null || uri == null) {
            throw new IllegalArgumentException("You must pass a valid uri and observer");
        }
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != userHandle && this.mContext.checkUriPermission(uri, pid, uid, 1) != 0) {
            this.enforceCrossUserPermission(userHandle, "no permission to observe other users' provider view");
        }
        if (userHandle < 0) {
            if (userHandle == -2) {
                userHandle = ActivityManager.getCurrentUser();
            } else if (userHandle != -1) {
                throw new InvalidParameterException("Bad user handle for registerContentObserver: " + userHandle);
            }
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.addObserverLocked(uri, observer, notifyForDescendants, this.mRootNode, uid, pid, userHandle);
        }
    }

    public void registerContentObserver(Uri uri, boolean notifyForDescendants, IContentObserver observer) {
        this.registerContentObserver(uri, notifyForDescendants, observer, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterContentObserver(IContentObserver observer) {
        if (observer == null) {
            throw new IllegalArgumentException("You must pass a valid observer");
        }
        ObserverNode observerNode = this.mRootNode;
        synchronized (observerNode) {
            this.mRootNode.removeObserverLocked(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork, int userHandle) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "Notifying update of " + uri + " for user " + userHandle + " from observer " + observer + ", syncToNetwork " + syncToNetwork);
        }
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != userHandle && this.mContext.checkUriPermission(uri, pid, uid, 2) != 0) {
            this.enforceCrossUserPermission(userHandle, "no permission to notify other users");
        }
        if (userHandle < 0) {
            if (userHandle == -2) {
                userHandle = ActivityManager.getCurrentUser();
            } else if (userHandle != -1) {
                throw new InvalidParameterException("Bad user handle for notifyChange: " + userHandle);
            }
        }
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager;
            ArrayList<ObserverCall> calls = new ArrayList<ObserverCall>();
            ObserverNode observerNode = this.mRootNode;
            synchronized (observerNode) {
                this.mRootNode.collectObserversLocked(uri, 0, observer, observerWantsSelfNotifications, userHandle, calls);
            }
            int numCalls = calls.size();
            for (int i = 0; i < numCalls; ++i) {
                ObserverCall oc = calls.get(i);
                try {
                    oc.mObserver.onChange(oc.mSelfChange, uri, userHandle);
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "Notified " + oc.mObserver + " of " + "update at " + uri);
                    continue;
                }
                catch (RemoteException ex) {
                    ObserverNode observerNode2 = this.mRootNode;
                    synchronized (observerNode2) {
                        Log.w(TAG, "Found dead observer, removing");
                        IBinder binder = oc.mObserver.asBinder();
                        ArrayList list = oc.mNode.mObservers;
                        int numList = list.size();
                        for (int j = 0; j < numList; ++j) {
                            ObserverNode.ObserverEntry oe = (ObserverNode.ObserverEntry)list.get(j);
                            if (oe.observer.asBinder() != binder) continue;
                            list.remove(j);
                            --j;
                            --numList;
                        }
                        continue;
                    }
                }
            }
            if (syncToNetwork && (syncManager = this.getSyncManager()) != null) {
                syncManager.scheduleLocalSync(null, callingUserHandle, uid, uri.getAuthority());
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    public void notifyChange(Uri uri, IContentObserver observer, boolean observerWantsSelfNotifications, boolean syncToNetwork) {
        this.notifyChange(uri, observer, observerWantsSelfNotifications, syncToNetwork, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestSync(Account account, String authority, Bundle extras) {
        ContentResolver.validateSyncExtrasBundle(extras);
        int userId = UserHandle.getCallingUserId();
        int uId = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.scheduleSync(account, userId, uId, authority, extras, 0L, 0L, false);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public void sync(SyncRequest request) {
        this.syncAsUser(request, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void syncAsUser(SyncRequest request, int userId) {
        this.enforceCrossUserPermission(userId, "no permission to request sync as user: " + userId);
        int callerUid = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) {
                return;
            }
            Bundle extras = request.getBundle();
            long flextime = request.getSyncFlexTime();
            long runAtTime = request.getSyncRunTime();
            if (request.isPeriodic()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
                SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(request.getAccount(), request.getProvider(), userId);
                if (runAtTime < 60L) {
                    Slog.w(TAG, "Requested poll frequency of " + runAtTime + " seconds being rounded up to 60 seconds.");
                    runAtTime = 60L;
                }
                this.getSyncManager().getSyncStorageEngine().updateOrAddPeriodicSync(info, runAtTime, flextime, extras);
            } else {
                long beforeRuntimeMillis = flextime * 1000L;
                long runtimeMillis = runAtTime * 1000L;
                syncManager.scheduleSync(request.getAccount(), userId, callerUid, request.getProvider(), extras, beforeRuntimeMillis, runtimeMillis, false);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public void cancelSync(Account account, String authority, ComponentName cname) {
        this.cancelSyncAsUser(account, authority, cname, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSyncAsUser(Account account, String authority, ComponentName cname, int userId) {
        if (authority != null && authority.length() == 0) {
            throw new IllegalArgumentException("Authority must be non-empty");
        }
        this.enforceCrossUserPermission(userId, "no permission to modify the sync settings for user " + userId);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                SyncStorageEngine.EndPoint info = cname == null ? new SyncStorageEngine.EndPoint(account, authority, userId) : new SyncStorageEngine.EndPoint(cname, userId);
                syncManager.clearScheduledSyncOperations(info);
                syncManager.cancelActiveSync(info, null);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelRequest(SyncRequest request) {
        SyncManager syncManager = this.getSyncManager();
        if (syncManager == null) {
            return;
        }
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            Bundle extras = new Bundle(request.getBundle());
            Account account = request.getAccount();
            String provider = request.getProvider();
            SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account, provider, userId);
            if (request.isPeriodic()) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
                this.getSyncManager().getSyncStorageEngine().removePeriodicSync(info, extras);
            }
            syncManager.cancelScheduledSyncOperation(info, extras);
            syncManager.cancelActiveSync(info, extras);
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public SyncAdapterType[] getSyncAdapterTypes() {
        return this.getSyncAdapterTypesAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncAdapterType[] getSyncAdapterTypesAsUser(int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read sync settings for user " + userId);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            SyncAdapterType[] syncAdapterTypeArray = syncManager.getSyncAdapterTypes(userId);
            return syncAdapterTypeArray;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read sync settings for user " + userId);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            String[] stringArray = syncManager.getSyncAdapterPackagesForAuthorityAsUser(authority, userId);
            return stringArray;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean getSyncAutomatically(Account account, String providerName) {
        return this.getSyncAutomaticallyAsUser(account, providerName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getSyncAutomaticallyAsUser(Account account, String providerName, int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read the sync settings for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().getSyncAutomatically(account, userId, providerName);
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    @Override
    public void setSyncAutomatically(Account account, String providerName, boolean sync) {
        this.setSyncAutomaticallyAsUser(account, providerName, sync, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncAutomaticallyAsUser(Account account, String providerName, boolean sync, int userId) {
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must be non-empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        this.enforceCrossUserPermission(userId, "no permission to modify the sync settings for user " + userId);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setSyncAutomatically(account, userId, providerName, sync);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPeriodicSync(Account account, String authority, Bundle extras, long pollFrequency) {
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("Authority must not be empty.");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        if (pollFrequency < 60L) {
            Slog.w(TAG, "Requested poll frequency of " + pollFrequency + " seconds being rounded up to 60 seconds.");
            pollFrequency = 60L;
        }
        long defaultFlex = SyncStorageEngine.calculateDefaultFlexTime(pollFrequency);
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account, authority, userId);
            this.getSyncManager().getSyncStorageEngine().updateOrAddPeriodicSync(info, pollFrequency, defaultFlex, extras);
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePeriodicSync(Account account, String authority, Bundle extras) {
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            this.getSyncManager().getSyncStorageEngine().removePeriodicSync(new SyncStorageEngine.EndPoint(account, authority, userId), extras);
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodicSync> getPeriodicSyncs(Account account, String providerName, ComponentName cname) {
        if (account == null) {
            throw new IllegalArgumentException("Account must not be null");
        }
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            List<PeriodicSync> list = this.getSyncManager().getSyncStorageEngine().getPeriodicSyncs(new SyncStorageEngine.EndPoint(account, providerName, userId));
            return list;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public int getIsSyncable(Account account, String providerName) {
        return this.getIsSyncableAsUser(account, providerName, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getIsSyncableAsUser(Account account, String providerName, int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read the sync settings for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                int n = syncManager.getIsSyncable(account, userId, providerName);
                return n;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setIsSyncable(Account account, String providerName, int syncable) {
        if (TextUtils.isEmpty(providerName)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        int userId = UserHandle.getCallingUserId();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setIsSyncable(account, userId, providerName, syncable);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean getMasterSyncAutomatically() {
        return this.getMasterSyncAutomaticallyAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getMasterSyncAutomaticallyAsUser(int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read the sync settings for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_SETTINGS", "no permission to read the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                boolean bl = syncManager.getSyncStorageEngine().getMasterSyncAutomatically(userId);
                return bl;
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
        return false;
    }

    @Override
    public void setMasterSyncAutomatically(boolean flag) {
        this.setMasterSyncAutomaticallyAsUser(flag, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMasterSyncAutomaticallyAsUser(boolean flag, int userId) {
        this.enforceCrossUserPermission(userId, "no permission to set the sync status for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.WRITE_SYNC_SETTINGS", "no permission to write the sync settings");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null) {
                syncManager.getSyncStorageEngine().setMasterSyncAutomatically(flag, userId);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncActive(Account account, String authority, ComponentName cname) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        int userId = UserHandle.getCallingUserId();
        int callingUid = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) {
                boolean bl = false;
                return bl;
            }
            boolean bl = syncManager.getSyncStorageEngine().isSyncActive(new SyncStorageEngine.EndPoint(account, authority, userId));
            return bl;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public List<SyncInfo> getCurrentSyncs() {
        return this.getCurrentSyncsAsUser(UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SyncInfo> getCurrentSyncsAsUser(int userId) {
        this.enforceCrossUserPermission(userId, "no permission to read the sync settings for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        long identityToken = ContentService.clearCallingIdentity();
        try {
            List<SyncInfo> list = this.getSyncManager().getSyncStorageEngine().getCurrentSyncsCopy(userId);
            return list;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public SyncStatusInfo getSyncStatus(Account account, String authority, ComponentName cname) {
        return this.getSyncStatusAsUser(account, authority, cname, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SyncStatusInfo getSyncStatusAsUser(Account account, String authority, ComponentName cname, int userId) {
        if (TextUtils.isEmpty(authority)) {
            throw new IllegalArgumentException("Authority must not be empty");
        }
        this.enforceCrossUserPermission(userId, "no permission to read the sync stats for user " + userId);
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        int callerUid = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager == null) {
                SyncStatusInfo syncStatusInfo = null;
                return syncStatusInfo;
            }
            if (account == null || authority == null) {
                throw new IllegalArgumentException("Must call sync status with valid authority");
            }
            SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account, authority, userId);
            SyncStatusInfo syncStatusInfo = syncManager.getSyncStorageEngine().getStatusByAuthority(info);
            return syncStatusInfo;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    @Override
    public boolean isSyncPending(Account account, String authority, ComponentName cname) {
        return this.isSyncPendingAsUser(account, authority, cname, UserHandle.getCallingUserId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSyncPendingAsUser(Account account, String authority, ComponentName cname, int userId) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.READ_SYNC_STATS", "no permission to read the sync stats");
        this.enforceCrossUserPermission(userId, "no permission to retrieve the sync settings for user " + userId);
        int callerUid = Binder.getCallingUid();
        long identityToken = ContentService.clearCallingIdentity();
        SyncManager syncManager = this.getSyncManager();
        if (syncManager == null) {
            return false;
        }
        try {
            if (account == null || authority == null) {
                throw new IllegalArgumentException("Invalid authority specified");
            }
            SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account, authority, userId);
            boolean bl = syncManager.getSyncStorageEngine().isSyncPending(info);
            return bl;
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatusChangeListener(int mask, ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().addStatusChangeListener(mask, callback);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatusChangeListener(ISyncStatusObserver callback) {
        long identityToken = ContentService.clearCallingIdentity();
        try {
            SyncManager syncManager = this.getSyncManager();
            if (syncManager != null && callback != null) {
                syncManager.getSyncStorageEngine().removeStatusChangeListener(callback);
            }
        }
        finally {
            ContentService.restoreCallingIdentity(identityToken);
        }
    }

    public static ContentService main(Context context, boolean factoryTest) {
        ContentService service = new ContentService(context, factoryTest);
        ServiceManager.addService("content", service);
        return service;
    }

    private void enforceCrossUserPermission(int userHandle, String message) {
        int callingUser = UserHandle.getCallingUserId();
        if (callingUser != userHandle) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.INTERACT_ACROSS_USERS_FULL", message);
        }
    }

    public static final class ObserverNode {
        public static final int INSERT_TYPE = 0;
        public static final int UPDATE_TYPE = 1;
        public static final int DELETE_TYPE = 2;
        private String mName;
        private ArrayList<ObserverNode> mChildren = new ArrayList();
        private ArrayList<ObserverEntry> mObservers = new ArrayList();

        public ObserverNode(String name) {
            this.mName = name;
        }

        public void dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, String name, String prefix, int[] counts, SparseIntArray pidCounts) {
            int i;
            String innerName = null;
            if (this.mObservers.size() > 0) {
                innerName = "".equals(name) ? this.mName : name + "/" + this.mName;
                for (i = 0; i < this.mObservers.size(); ++i) {
                    counts[1] = counts[1] + 1;
                    this.mObservers.get(i).dumpLocked(fd, pw, args, innerName, prefix, pidCounts);
                }
            }
            if (this.mChildren.size() > 0) {
                if (innerName == null) {
                    innerName = "".equals(name) ? this.mName : name + "/" + this.mName;
                }
                for (i = 0; i < this.mChildren.size(); ++i) {
                    counts[0] = counts[0] + 1;
                    this.mChildren.get(i).dumpLocked(fd, pw, args, innerName, prefix, counts, pidCounts);
                }
            }
        }

        private String getUriSegment(Uri uri, int index) {
            if (uri != null) {
                if (index == 0) {
                    return uri.getAuthority();
                }
                return uri.getPathSegments().get(index - 1);
            }
            return null;
        }

        private int countUriSegments(Uri uri) {
            if (uri == null) {
                return 0;
            }
            return uri.getPathSegments().size() + 1;
        }

        public void addObserverLocked(Uri uri, IContentObserver observer, boolean notifyForDescendants, Object observersLock, int uid, int pid, int userHandle) {
            this.addObserverLocked(uri, 0, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
        }

        private void addObserverLocked(Uri uri, int index, IContentObserver observer, boolean notifyForDescendants, Object observersLock, int uid, int pid, int userHandle) {
            if (index == this.countUriSegments(uri)) {
                this.mObservers.add(new ObserverEntry(observer, notifyForDescendants, observersLock, uid, pid, userHandle));
                return;
            }
            String segment = this.getUriSegment(uri, index);
            if (segment == null) {
                throw new IllegalArgumentException("Invalid Uri (" + uri + ") used for observer");
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (!node.mName.equals(segment)) continue;
                node.addObserverLocked(uri, index + 1, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
                return;
            }
            ObserverNode node = new ObserverNode(segment);
            this.mChildren.add(node);
            node.addObserverLocked(uri, index + 1, observer, notifyForDescendants, observersLock, uid, pid, userHandle);
        }

        public boolean removeObserverLocked(IContentObserver observer) {
            int size = this.mChildren.size();
            for (int i = 0; i < size; ++i) {
                boolean empty = this.mChildren.get(i).removeObserverLocked(observer);
                if (!empty) continue;
                this.mChildren.remove(i);
                --i;
                --size;
            }
            IBinder observerBinder = observer.asBinder();
            size = this.mObservers.size();
            for (int i = 0; i < size; ++i) {
                ObserverEntry entry = this.mObservers.get(i);
                if (entry.observer.asBinder() != observerBinder) continue;
                this.mObservers.remove(i);
                observerBinder.unlinkToDeath(entry, 0);
                break;
            }
            return this.mChildren.size() == 0 && this.mObservers.size() == 0;
        }

        private void collectMyObserversLocked(boolean leaf, IContentObserver observer, boolean observerWantsSelfNotifications, int targetUserHandle, ArrayList<ObserverCall> calls) {
            int N = this.mObservers.size();
            IBinder observerBinder = observer == null ? null : observer.asBinder();
            for (int i = 0; i < N; ++i) {
                boolean selfChange;
                ObserverEntry entry = this.mObservers.get(i);
                boolean bl = selfChange = entry.observer.asBinder() == observerBinder;
                if (selfChange && !observerWantsSelfNotifications || targetUserHandle != -1 && entry.userHandle != -1 && targetUserHandle != entry.userHandle || !leaf && (leaf || !entry.notifyForDescendants)) continue;
                calls.add(new ObserverCall(this, entry.observer, selfChange));
            }
        }

        public void collectObserversLocked(Uri uri, int index, IContentObserver observer, boolean observerWantsSelfNotifications, int targetUserHandle, ArrayList<ObserverCall> calls) {
            String segment = null;
            int segmentCount = this.countUriSegments(uri);
            if (index >= segmentCount) {
                this.collectMyObserversLocked(true, observer, observerWantsSelfNotifications, targetUserHandle, calls);
            } else if (index < segmentCount) {
                segment = this.getUriSegment(uri, index);
                this.collectMyObserversLocked(false, observer, observerWantsSelfNotifications, targetUserHandle, calls);
            }
            int N = this.mChildren.size();
            for (int i = 0; i < N; ++i) {
                ObserverNode node = this.mChildren.get(i);
                if (segment != null && !node.mName.equals(segment)) continue;
                node.collectObserversLocked(uri, index + 1, observer, observerWantsSelfNotifications, targetUserHandle, calls);
                if (segment != null) break;
            }
        }

        private class ObserverEntry
        implements IBinder.DeathRecipient {
            public final IContentObserver observer;
            public final int uid;
            public final int pid;
            public final boolean notifyForDescendants;
            private final int userHandle;
            private final Object observersLock;

            public ObserverEntry(IContentObserver o, boolean n, Object observersLock, int _uid, int _pid, int _userHandle) {
                this.observersLock = observersLock;
                this.observer = o;
                this.uid = _uid;
                this.pid = _pid;
                this.userHandle = _userHandle;
                this.notifyForDescendants = n;
                try {
                    this.observer.asBinder().linkToDeath(this, 0);
                }
                catch (RemoteException e) {
                    this.binderDied();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void binderDied() {
                Object object = this.observersLock;
                synchronized (object) {
                    ObserverNode.this.removeObserverLocked(this.observer);
                }
            }

            public void dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, String name, String prefix, SparseIntArray pidCounts) {
                pidCounts.put(this.pid, pidCounts.get(this.pid) + 1);
                pw.print(prefix);
                pw.print(name);
                pw.print(": pid=");
                pw.print(this.pid);
                pw.print(" uid=");
                pw.print(this.uid);
                pw.print(" user=");
                pw.print(this.userHandle);
                pw.print(" target=");
                pw.println(Integer.toHexString(System.identityHashCode(this.observer != null ? this.observer.asBinder() : null)));
            }
        }
    }

    public static final class ObserverCall {
        final ObserverNode mNode;
        final IContentObserver mObserver;
        final boolean mSelfChange;

        ObserverCall(ObserverNode node, IContentObserver observer, boolean selfChange) {
            this.mNode = node;
            this.mObserver = observer;
            this.mSelfChange = selfChange;
        }
    }
}

