/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.content;

import android.accounts.Account;
import android.accounts.AccountAndUser;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.ISyncAdapter;
import android.content.ISyncContext;
import android.content.ISyncServiceAdapter;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.PeriodicSync;
import android.content.ServiceConnection;
import android.content.SyncActivityTooManyDeletes;
import android.content.SyncAdapterType;
import android.content.SyncAdaptersCache;
import android.content.SyncInfo;
import android.content.SyncResult;
import android.content.SyncStatusInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.RegisteredServicesCache;
import android.content.pm.RegisteredServicesCacheListener;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.WorkSource;
import android.provider.Settings;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.EventLog;
import android.util.Log;
import android.util.Pair;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BackgroundThread;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.accounts.AccountManagerService;
import com.android.server.content.AppIdleMonitor;
import com.android.server.content.SyncOperation;
import com.android.server.content.SyncQueue;
import com.android.server.content.SyncStorageEngine;
import com.google.android.collect.Lists;
import com.google.android.collect.Maps;
import com.google.android.collect.Sets;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class SyncManager {
    static final String TAG = "SyncManager";
    private static final long LOCAL_SYNC_DELAY;
    private static final long MAX_TIME_PER_SYNC;
    private static final long SYNC_NOTIFICATION_DELAY;
    private static final long INITIAL_SYNC_RETRY_TIME_IN_MS = 30000L;
    private static final long DEFAULT_MAX_SYNC_RETRY_TIME_IN_SECONDS = 3600L;
    private static final int DELAY_RETRY_SYNC_IN_PROGRESS_IN_SECONDS = 10;
    private static final long ACTIVE_SYNC_TIMEOUT_MILLIS = 1800000L;
    private static final long SYNC_MONITOR_WINDOW_LENGTH_MILLIS = 60000L;
    private static final int SYNC_MONITOR_PROGRESS_THRESHOLD_BYTES = 10;
    private static final long PER_SYNC_BOOT_DELAY_MILLIS = 3000L;
    private static final long MAX_SYNC_BOOT_DELAY_MILLIS = 120000L;
    private static final String SYNC_WAKE_LOCK_PREFIX = "*sync*/";
    private static final String HANDLE_SYNC_ALARM_WAKE_LOCK = "SyncManagerHandleSyncAlarm";
    private static final String SYNC_LOOP_WAKE_LOCK = "SyncLoopWakeLock";
    private static final int MAX_SIMULTANEOUS_REGULAR_SYNCS;
    private static final int MAX_SIMULTANEOUS_INITIALIZATION_SYNCS;
    private Context mContext;
    private static final AccountAndUser[] INITIAL_ACCOUNTS_ARRAY;
    private volatile AccountAndUser[] mRunningAccounts = INITIAL_ACCOUNTS_ARRAY;
    private volatile PowerManager.WakeLock mHandleAlarmWakeLock;
    private volatile PowerManager.WakeLock mSyncManagerWakeLock;
    private volatile boolean mDataConnectionIsConnected = false;
    private volatile boolean mStorageIsLow = false;
    private volatile boolean mDeviceIsIdle = false;
    private final NotificationManager mNotificationMgr;
    private AlarmManager mAlarmService = null;
    private final IBatteryStats mBatteryStats;
    private SyncStorageEngine mSyncStorageEngine;
    @GuardedBy(value="mSyncQueue")
    private final SyncQueue mSyncQueue;
    protected final ArrayList<ActiveSyncContext> mActiveSyncContexts = Lists.newArrayList();
    private boolean mNeedSyncActiveNotification = false;
    private final PendingIntent mSyncAlarmIntent;
    private ConnectivityManager mConnManagerDoNotUseDirectly;
    private boolean mProvisioned;
    protected SyncAdaptersCache mSyncAdapters;
    private final AppIdleMonitor mAppIdleMonitor;
    private BroadcastReceiver mStorageIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.intent.action.DEVICE_STORAGE_LOW".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is low.");
                }
                SyncManager.this.mStorageIsLow = true;
                SyncManager.this.cancelActiveSync(SyncStorageEngine.EndPoint.USER_ALL_PROVIDER_ALL_ACCOUNTS_ALL, null);
            } else if ("android.intent.action.DEVICE_STORAGE_OK".equals(action)) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "Internal storage is ok.");
                }
                SyncManager.this.mStorageIsLow = false;
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    private BroadcastReceiver mDeviceIdleReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            boolean idle = SyncManager.this.mPowerManager.isDeviceIdleMode();
            SyncManager.this.mDeviceIsIdle = idle;
            if (idle) {
                SyncManager.this.cancelActiveSync(SyncStorageEngine.EndPoint.USER_ALL_PROVIDER_ALL_ACCOUNTS_ALL, null);
            } else {
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    private BroadcastReceiver mBootCompletedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mBootCompleted = true;
            SyncManager.this.mSyncHandler.onBootCompleted();
        }
    };
    private BroadcastReceiver mAccountsUpdatedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.updateRunningAccounts();
            SyncManager.this.scheduleSync(null, -1, -2, null, null, 0L, 0L, false);
        }
    };
    private final PowerManager mPowerManager;
    private int mSyncRandomOffsetMillis;
    private final UserManager mUserManager;
    private static final long SYNC_ALARM_TIMEOUT_MIN = 30000L;
    private BroadcastReceiver mConnectivityIntentReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            boolean wasConnected = SyncManager.this.mDataConnectionIsConnected;
            SyncManager.this.mDataConnectionIsConnected = SyncManager.this.readDataConnectionState();
            if (SyncManager.this.mDataConnectionIsConnected) {
                if (!wasConnected) {
                    if (Log.isLoggable(SyncManager.TAG, 2)) {
                        Log.v(SyncManager.TAG, "Reconnection detected: clearing all backoffs");
                    }
                    SyncQueue syncQueue = SyncManager.this.mSyncQueue;
                    synchronized (syncQueue) {
                        SyncManager.this.mSyncStorageEngine.clearAllBackoffsLocked(SyncManager.this.mSyncQueue);
                    }
                }
                SyncManager.this.sendCheckAlarmsMessage();
            }
        }
    };
    private BroadcastReceiver mShutdownIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            Log.w(SyncManager.TAG, "Writing sync state before shutdown...");
            SyncManager.this.getSyncStorageEngine().writeAllState();
        }
    };
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_REMOVED".equals(action)) {
                SyncManager.this.onUserRemoved(userId);
            } else if ("android.intent.action.USER_STARTING".equals(action)) {
                SyncManager.this.onUserStarting(userId);
            } else if ("android.intent.action.USER_STOPPING".equals(action)) {
                SyncManager.this.onUserStopping(userId);
            }
        }
    };
    private static final String ACTION_SYNC_ALARM = "android.content.syncmanager.SYNC_ALARM";
    private final SyncHandler mSyncHandler;
    private volatile boolean mBootCompleted = false;

    private List<UserInfo> getAllUsers() {
        return this.mUserManager.getUsers();
    }

    private boolean containsAccountAndUser(AccountAndUser[] accounts, Account account, int userId) {
        boolean found = false;
        for (int i = 0; i < accounts.length; ++i) {
            if (accounts[i].userId != userId || !accounts[i].account.equals(account)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void updateRunningAccounts() {
        this.mRunningAccounts = AccountManagerService.getSingleton().getRunningAccounts();
        if (this.mBootCompleted) {
            this.doDatabaseCleanup();
        }
        AccountAndUser[] accounts = this.mRunningAccounts;
        for (ActiveSyncContext currentSyncContext : this.mActiveSyncContexts) {
            if (this.containsAccountAndUser(accounts, currentSyncContext.mSyncOperation.target.account, currentSyncContext.mSyncOperation.target.userId)) continue;
            Log.d(TAG, "canceling sync since the account is no longer running");
            this.sendSyncFinishedOrCanceledMessage(currentSyncContext, null);
        }
        this.sendCheckAlarmsMessage();
    }

    private void doDatabaseCleanup() {
        for (UserInfo user : this.mUserManager.getUsers(true)) {
            if (user.partial) continue;
            Account[] accountsForUser = AccountManagerService.getSingleton().getAccounts(user.id, this.mContext.getOpPackageName());
            this.mSyncStorageEngine.doDatabaseCleanup(accountsForUser, user.id);
        }
    }

    private boolean readDataConnectionState() {
        NetworkInfo networkInfo = this.getConnectivityManager().getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectivityManager getConnectivityManager() {
        SyncManager syncManager = this;
        synchronized (syncManager) {
            if (this.mConnManagerDoNotUseDirectly == null) {
                this.mConnManagerDoNotUseDirectly = (ConnectivityManager)this.mContext.getSystemService("connectivity");
            }
            return this.mConnManagerDoNotUseDirectly;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SyncManager(Context context, boolean factoryTest) {
        this.mContext = context;
        SyncStorageEngine.init(context);
        this.mSyncStorageEngine = SyncStorageEngine.getSingleton();
        this.mSyncStorageEngine.setOnSyncRequestListener(new SyncStorageEngine.OnSyncRequestListener(){

            @Override
            public void onSyncRequest(SyncStorageEngine.EndPoint info, int reason, Bundle extras) {
                if (info.target_provider) {
                    SyncManager.this.scheduleSync(info.account, info.userId, reason, info.provider, extras, 0L, 0L, false);
                } else if (info.target_service) {
                    SyncManager.this.scheduleSync(info.service, info.userId, reason, extras, 0L, 0L);
                }
            }
        });
        this.mSyncAdapters = new SyncAdaptersCache(this.mContext);
        this.mSyncQueue = new SyncQueue(this.mContext.getPackageManager(), this.mSyncStorageEngine, this.mSyncAdapters);
        this.mSyncHandler = new SyncHandler(BackgroundThread.get().getLooper());
        this.mSyncAdapters.setListener(new RegisteredServicesCacheListener<SyncAdapterType>(){

            @Override
            public void onServiceChanged(SyncAdapterType type, int userId, boolean removed) {
                if (!removed) {
                    SyncManager.this.scheduleSync(null, -1, -3, type.authority, null, 0L, 0L, false);
                }
            }
        }, this.mSyncHandler);
        this.mSyncAlarmIntent = PendingIntent.getBroadcast(this.mContext, 0, new Intent(ACTION_SYNC_ALARM), 0);
        this.mAppIdleMonitor = new AppIdleMonitor(this);
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver(this.mConnectivityIntentReceiver, intentFilter);
        if (!factoryTest) {
            intentFilter = new IntentFilter("android.intent.action.BOOT_COMPLETED");
            intentFilter.setPriority(1000);
            context.registerReceiver(this.mBootCompletedReceiver, intentFilter);
        }
        intentFilter = new IntentFilter("android.intent.action.DEVICE_STORAGE_LOW");
        intentFilter.addAction("android.intent.action.DEVICE_STORAGE_OK");
        context.registerReceiver(this.mStorageIntentReceiver, intentFilter);
        intentFilter = new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        context.registerReceiver(this.mDeviceIdleReceiver, intentFilter);
        intentFilter = new IntentFilter("android.intent.action.ACTION_SHUTDOWN");
        intentFilter.setPriority(100);
        context.registerReceiver(this.mShutdownIntentReceiver, intentFilter);
        intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.USER_REMOVED");
        intentFilter.addAction("android.intent.action.USER_STARTING");
        intentFilter.addAction("android.intent.action.USER_STOPPING");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.ALL, intentFilter, null, null);
        if (!factoryTest) {
            this.mNotificationMgr = (NotificationManager)context.getSystemService("notification");
            context.registerReceiver(new SyncAlarmIntentReceiver(), new IntentFilter(ACTION_SYNC_ALARM));
        } else {
            this.mNotificationMgr = null;
        }
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mUserManager = (UserManager)this.mContext.getSystemService("user");
        this.mBatteryStats = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mHandleAlarmWakeLock = this.mPowerManager.newWakeLock(1, HANDLE_SYNC_ALARM_WAKE_LOCK);
        this.mHandleAlarmWakeLock.setReferenceCounted(false);
        this.mSyncManagerWakeLock = this.mPowerManager.newWakeLock(1, SYNC_LOOP_WAKE_LOCK);
        this.mSyncManagerWakeLock.setReferenceCounted(false);
        this.mSyncStorageEngine.addStatusChangeListener(1, new ISyncStatusObserver.Stub(){

            @Override
            public void onStatusChanged(int which) {
                SyncManager.this.sendCheckAlarmsMessage();
            }
        });
        this.mProvisioned = this.isDeviceProvisioned();
        if (!this.mProvisioned) {
            final ContentResolver resolver = context.getContentResolver();
            ContentObserver provisionedObserver = new ContentObserver(null){

                @Override
                public void onChange(boolean selfChange) {
                    SyncManager.this.mProvisioned = (byte)(SyncManager.this.mProvisioned | (SyncManager.this.isDeviceProvisioned() ? 1 : 0));
                    if (SyncManager.this.mProvisioned) {
                        SyncManager.this.mSyncHandler.onDeviceProvisioned();
                        resolver.unregisterContentObserver(this);
                    }
                }
            };
            SyncHandler syncHandler = this.mSyncHandler;
            synchronized (syncHandler) {
                resolver.registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, provisionedObserver);
                this.mProvisioned |= this.isDeviceProvisioned();
                if (this.mProvisioned) {
                    resolver.unregisterContentObserver(provisionedObserver);
                }
            }
        }
        if (!factoryTest) {
            this.mContext.registerReceiverAsUser(this.mAccountsUpdatedReceiver, UserHandle.ALL, new IntentFilter("android.accounts.LOGIN_ACCOUNTS_CHANGED"), null, null);
        }
        this.mSyncRandomOffsetMillis = this.mSyncStorageEngine.getSyncRandomOffset() * 1000;
    }

    private boolean isDeviceProvisioned() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
    }

    private long jitterize(long minValue, long maxValue) {
        Random random = new Random(SystemClock.elapsedRealtime());
        long spread = maxValue - minValue;
        if (spread > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("the difference between the maxValue and the minValue must be less than 2147483647");
        }
        return minValue + (long)random.nextInt((int)spread);
    }

    public SyncStorageEngine getSyncStorageEngine() {
        return this.mSyncStorageEngine;
    }

    public int getIsSyncable(Account account, int userId, String providerName) {
        int isSyncable = this.mSyncStorageEngine.getIsSyncable(account, userId, providerName);
        UserInfo userInfo = UserManager.get(this.mContext).getUserInfo(userId);
        if (userInfo == null || !userInfo.isRestricted()) {
            return isSyncable;
        }
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(providerName, account.type), userId);
        if (syncAdapterInfo == null) {
            return isSyncable;
        }
        PackageInfo pInfo = null;
        try {
            pInfo = AppGlobals.getPackageManager().getPackageInfo(syncAdapterInfo.componentName.getPackageName(), 0, userId);
            if (pInfo == null) {
                return isSyncable;
            }
        }
        catch (RemoteException re) {
            return isSyncable;
        }
        if (pInfo.restrictedAccountType != null && pInfo.restrictedAccountType.equals(account.type)) {
            return isSyncable;
        }
        return 0;
    }

    private void ensureAlarmService() {
        if (this.mAlarmService == null) {
            this.mAlarmService = (AlarmManager)this.mContext.getSystemService("alarm");
        }
    }

    public void scheduleSync(ComponentName cname, int userId, int uid, Bundle extras, long beforeRunTimeMillis, long runtimeMillis) {
        long backoffTime;
        boolean syncAllowed;
        Boolean expedited;
        boolean isLoggable = Log.isLoggable(TAG, 2);
        if (isLoggable) {
            Log.d(TAG, "one off sync for: " + cname + " " + extras.toString());
        }
        if ((expedited = Boolean.valueOf(extras.getBoolean("expedited", false))).booleanValue()) {
            runtimeMillis = -1L;
        }
        boolean ignoreSettings = extras.getBoolean("ignore_settings", false);
        int source = 5;
        boolean isEnabled = this.mSyncStorageEngine.getIsTargetServiceActive(cname, userId);
        boolean bl = syncAllowed = ignoreSettings || this.mSyncStorageEngine.getMasterSyncAutomatically(userId);
        if (!syncAllowed) {
            if (isLoggable) {
                Log.d(TAG, "scheduleSync: sync of " + cname + " not allowed, dropping request.");
            }
            return;
        }
        if (!isEnabled) {
            if (isLoggable) {
                Log.d(TAG, "scheduleSync: " + cname + " is not enabled, dropping request");
            }
            return;
        }
        SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(cname, userId);
        Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(info);
        long delayUntil = this.mSyncStorageEngine.getDelayUntilTime(info);
        long l = backoffTime = backoff != null ? (Long)backoff.first : 0L;
        if (isLoggable) {
            Log.v(TAG, "schedule Sync:, delay until " + delayUntil + ", run by " + runtimeMillis + ", flex " + beforeRunTimeMillis + ", source " + source + ", sync service " + cname + ", extras " + extras);
        }
        this.scheduleSyncOperation(new SyncOperation(cname, userId, uid, source, extras, runtimeMillis, beforeRunTimeMillis, backoffTime, delayUntil));
    }

    public void scheduleSync(Account requestedAccount, int userId, int reason, String requestedAuthority, Bundle extras, long beforeRuntimeMillis, long runtimeMillis, boolean onlyThoseWithUnkownSyncableState) {
        AccountAndUser[] accounts;
        Boolean expedited;
        boolean isLoggable = Log.isLoggable(TAG, 2);
        if (extras == null) {
            extras = new Bundle();
        }
        if (isLoggable) {
            Log.d(TAG, "one-time sync for: " + requestedAccount + " " + extras.toString() + " " + requestedAuthority);
        }
        if ((expedited = Boolean.valueOf(extras.getBoolean("expedited", false))).booleanValue()) {
            runtimeMillis = -1L;
        }
        if (requestedAccount != null && userId != -1) {
            accounts = new AccountAndUser[]{new AccountAndUser(requestedAccount, userId)};
        } else {
            accounts = this.mRunningAccounts;
            if (accounts.length == 0) {
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: no accounts configured, dropping");
                }
                return;
            }
        }
        boolean uploadOnly = extras.getBoolean("upload", false);
        boolean manualSync = extras.getBoolean("force", false);
        if (manualSync) {
            extras.putBoolean("ignore_backoff", true);
            extras.putBoolean("ignore_settings", true);
        }
        boolean ignoreSettings = extras.getBoolean("ignore_settings", false);
        int source = uploadOnly ? 1 : (manualSync ? 3 : (requestedAuthority == null ? 2 : 0));
        for (AccountAndUser account : accounts) {
            if (userId >= 0 && account.userId >= 0 && userId != account.userId) continue;
            HashSet<String> syncableAuthorities = new HashSet<String>();
            for (RegisteredServicesCache.ServiceInfo syncAdapter : this.mSyncAdapters.getAllServices(account.userId)) {
                syncableAuthorities.add(((SyncAdapterType)syncAdapter.type).authority);
            }
            if (requestedAuthority != null) {
                boolean hasSyncAdapter = syncableAuthorities.contains(requestedAuthority);
                syncableAuthorities.clear();
                if (hasSyncAdapter) {
                    syncableAuthorities.add(requestedAuthority);
                }
            }
            for (String authority : syncableAuthorities) {
                long backoffTime;
                boolean syncAllowed;
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo;
                int isSyncable = this.getIsSyncable(account.account, account.userId, authority);
                if (isSyncable == 0 || (syncAdapterInfo = this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(authority, account.account.type), account.userId)) == null) continue;
                boolean allowParallelSyncs = ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs();
                boolean isAlwaysSyncable = ((SyncAdapterType)syncAdapterInfo.type).isAlwaysSyncable();
                if (isSyncable < 0 && isAlwaysSyncable) {
                    this.mSyncStorageEngine.setIsSyncable(account.account, account.userId, authority, 1);
                    isSyncable = 1;
                }
                if (onlyThoseWithUnkownSyncableState && isSyncable >= 0 || !((SyncAdapterType)syncAdapterInfo.type).supportsUploading() && uploadOnly) continue;
                boolean bl = syncAllowed = isSyncable < 0 || ignoreSettings || this.mSyncStorageEngine.getMasterSyncAutomatically(account.userId) && this.mSyncStorageEngine.getSyncAutomatically(account.account, account.userId, authority);
                if (!syncAllowed) {
                    if (!isLoggable) continue;
                    Log.d(TAG, "scheduleSync: sync of " + account + ", " + authority + " is not allowed, dropping request");
                    continue;
                }
                SyncStorageEngine.EndPoint info = new SyncStorageEngine.EndPoint(account.account, authority, account.userId);
                Pair<Long, Long> backoff = this.mSyncStorageEngine.getBackoff(info);
                long delayUntil = this.mSyncStorageEngine.getDelayUntilTime(info);
                long l = backoffTime = backoff != null ? (Long)backoff.first : 0L;
                if (isSyncable < 0) {
                    Bundle newExtras = new Bundle();
                    newExtras.putBoolean("initialize", true);
                    if (isLoggable) {
                        Log.v(TAG, "schedule initialisation Sync:, delay until " + delayUntil + ", run by " + 0 + ", flex " + 0 + ", source " + source + ", account " + account + ", authority " + authority + ", extras " + newExtras);
                    }
                    this.scheduleSyncOperation(new SyncOperation(account.account, account.userId, reason, source, authority, newExtras, 0L, 0L, backoffTime, delayUntil, allowParallelSyncs));
                }
                if (onlyThoseWithUnkownSyncableState) continue;
                if (isLoggable) {
                    Log.v(TAG, "scheduleSync: delay until " + delayUntil + " run by " + runtimeMillis + " flex " + beforeRuntimeMillis + ", source " + source + ", account " + account + ", authority " + authority + ", extras " + extras);
                }
                this.scheduleSyncOperation(new SyncOperation(account.account, account.userId, reason, source, authority, extras, runtimeMillis, beforeRuntimeMillis, backoffTime, delayUntil, allowParallelSyncs));
            }
        }
    }

    public void scheduleLocalSync(Account account, int userId, int reason, String authority) {
        Bundle extras = new Bundle();
        extras.putBoolean("upload", true);
        this.scheduleSync(account, userId, reason, authority, extras, LOCAL_SYNC_DELAY, 2L * LOCAL_SYNC_DELAY, false);
    }

    public SyncAdapterType[] getSyncAdapterTypes(int userId) {
        Collection serviceInfos = this.mSyncAdapters.getAllServices(userId);
        SyncAdapterType[] types = new SyncAdapterType[serviceInfos.size()];
        int i = 0;
        for (RegisteredServicesCache.ServiceInfo serviceInfo : serviceInfos) {
            types[i] = (SyncAdapterType)serviceInfo.type;
            ++i;
        }
        return types;
    }

    public String[] getSyncAdapterPackagesForAuthorityAsUser(String authority, int userId) {
        return this.mSyncAdapters.getSyncAdapterPackagesForAuthority(authority, userId);
    }

    private void sendSyncAlarmMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_ALARM");
        }
        this.mSyncHandler.sendEmptyMessage(2);
    }

    private void sendCheckAlarmsMessage() {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_CHECK_ALARMS");
        }
        this.mSyncHandler.removeMessages(3);
        this.mSyncHandler.sendEmptyMessage(3);
    }

    private void sendSyncFinishedOrCanceledMessage(ActiveSyncContext syncContext, SyncResult syncResult) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_SYNC_FINISHED");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 1;
        msg.obj = new SyncHandlerMessagePayload(syncContext, syncResult);
        this.mSyncHandler.sendMessage(msg);
    }

    private void sendCancelSyncsMessage(SyncStorageEngine.EndPoint info, Bundle extras) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "sending MESSAGE_CANCEL");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 6;
        msg.setData(extras);
        msg.obj = info;
        this.mSyncHandler.sendMessage(msg);
    }

    private void postSyncExpiryMessage(ActiveSyncContext activeSyncContext) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "posting MESSAGE_SYNC_EXPIRED in 1800s");
        }
        Message msg = this.mSyncHandler.obtainMessage();
        msg.what = 7;
        msg.obj = activeSyncContext;
        this.mSyncHandler.sendMessageDelayed(msg, 1800000L);
    }

    private void postMonitorSyncProgressMessage(ActiveSyncContext activeSyncContext) {
        if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "posting MESSAGE_SYNC_MONITOR in 60s");
        }
        activeSyncContext.mBytesTransferredAtLastPoll = this.getTotalBytesTransferredByUid(activeSyncContext.mSyncAdapterUid);
        activeSyncContext.mLastPolledTimeElapsed = SystemClock.elapsedRealtime();
        Message monitorMessage = this.mSyncHandler.obtainMessage(8, activeSyncContext);
        this.mSyncHandler.sendMessageDelayed(monitorMessage, 60000L);
    }

    private long getTotalBytesTransferredByUid(int uid) {
        return TrafficStats.getUidRxBytes(uid) + TrafficStats.getUidTxBytes(uid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearBackoffSetting(SyncOperation op) {
        this.mSyncStorageEngine.setBackoff(op.target, -1L, -1L);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.onBackoffChanged(op.target, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void increaseBackoffSetting(SyncOperation op) {
        long maxSyncRetryTimeInSeconds;
        long now = SystemClock.elapsedRealtime();
        Pair<Long, Long> previousSettings = this.mSyncStorageEngine.getBackoff(op.target);
        long newDelayInMs = -1L;
        if (previousSettings != null) {
            if (now < (Long)previousSettings.first) {
                if (Log.isLoggable(TAG, 2)) {
                    Log.v(TAG, "Still in backoff, do not increase it. Remaining: " + ((Long)previousSettings.first - now) / 1000L + " seconds.");
                }
                return;
            }
            newDelayInMs = (Long)previousSettings.second * 2L;
        }
        if (newDelayInMs <= 0L) {
            newDelayInMs = this.jitterize(30000L, 33000L);
        }
        if (newDelayInMs > (maxSyncRetryTimeInSeconds = Settings.Global.getLong(this.mContext.getContentResolver(), "sync_max_retry_delay_in_seconds", 3600L)) * 1000L) {
            newDelayInMs = maxSyncRetryTimeInSeconds * 1000L;
        }
        long backoff = now + newDelayInMs;
        this.mSyncStorageEngine.setBackoff(op.target, backoff, newDelayInMs);
        op.backoff = backoff;
        op.updateEffectiveRunTime();
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.onBackoffChanged(op.target, backoff);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDelayUntilTime(SyncOperation op, long delayUntilSeconds) {
        long delayUntil = delayUntilSeconds * 1000L;
        long absoluteNow = System.currentTimeMillis();
        long newDelayUntilTime = delayUntil > absoluteNow ? SystemClock.elapsedRealtime() + (delayUntil - absoluteNow) : 0L;
        this.mSyncStorageEngine.setDelayUntilTime(op.target, newDelayUntilTime);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.onDelayUntilTimeChanged(op.target, newDelayUntilTime);
        }
    }

    public void cancelActiveSync(SyncStorageEngine.EndPoint info, Bundle extras) {
        this.sendCancelSyncsMessage(info, extras);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSyncOperation(SyncOperation syncOperation) {
        boolean queueChanged;
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            queueChanged = this.mSyncQueue.add(syncOperation);
        }
        if (queueChanged) {
            if (Log.isLoggable(TAG, 2)) {
                Log.v(TAG, "scheduleSyncOperation: enqueued " + syncOperation);
            }
            this.sendCheckAlarmsMessage();
        } else if (Log.isLoggable(TAG, 2)) {
            Log.v(TAG, "scheduleSyncOperation: dropping duplicate sync operation " + syncOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScheduledSyncOperations(SyncStorageEngine.EndPoint info) {
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.remove(info, null);
        }
        this.mSyncStorageEngine.setBackoff(info, -1L, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelScheduledSyncOperation(SyncStorageEngine.EndPoint info, Bundle extras) {
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.remove(info, extras);
        }
        if (!this.mSyncStorageEngine.isSyncPending(info)) {
            this.mSyncStorageEngine.setBackoff(info, -1L, -1L);
        }
    }

    void maybeRescheduleSync(SyncResult syncResult, SyncOperation operation) {
        boolean isLoggable = Log.isLoggable(TAG, 3);
        if (isLoggable) {
            Log.d(TAG, "encountered error(s) during the sync: " + syncResult + ", " + operation);
        }
        operation = new SyncOperation(operation, 0L);
        if (operation.extras.getBoolean("ignore_backoff", false)) {
            operation.extras.remove("ignore_backoff");
        }
        if (operation.extras.getBoolean("do_not_retry", false)) {
            if (isLoggable) {
                Log.d(TAG, "not retrying sync operation because SYNC_EXTRAS_DO_NOT_RETRY was specified " + operation);
            }
        } else if (operation.extras.getBoolean("upload", false) && !syncResult.syncAlreadyInProgress) {
            operation.extras.remove("upload");
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation as a two-way sync because an upload-only sync encountered an error: " + operation);
            }
            this.scheduleSyncOperation(operation);
        } else if (syncResult.tooManyRetries) {
            if (isLoggable) {
                Log.d(TAG, "not retrying sync operation because it retried too many times: " + operation);
            }
        } else if (syncResult.madeSomeProgress()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because even though it had an error it achieved some success");
            }
            this.scheduleSyncOperation(operation);
        } else if (syncResult.syncAlreadyInProgress) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation that failed because there was already a sync in progress: " + operation);
            }
            this.scheduleSyncOperation(new SyncOperation(operation, 10000L));
        } else if (syncResult.hasSoftError()) {
            if (isLoggable) {
                Log.d(TAG, "retrying sync operation because it encountered a soft error: " + operation);
            }
            this.scheduleSyncOperation(operation);
        } else {
            Log.d(TAG, "not retrying sync operation because the error is a hard error: " + operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserStarting(int userId) {
        Account[] accounts;
        AccountManagerService.getSingleton().validateAccounts(userId);
        this.mSyncAdapters.invalidateCache(userId);
        this.updateRunningAccounts();
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.addPendingOperations(userId);
        }
        for (Account account : accounts = AccountManagerService.getSingleton().getAccounts(userId, this.mContext.getOpPackageName())) {
            this.scheduleSync(account, userId, -8, null, null, 0L, 0L, true);
        }
        this.sendCheckAlarmsMessage();
    }

    private void onUserStopping(int userId) {
        this.updateRunningAccounts();
        this.cancelActiveSync(new SyncStorageEngine.EndPoint(null, null, userId), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onUserRemoved(int userId) {
        this.updateRunningAccounts();
        this.mSyncStorageEngine.doDatabaseCleanup(new Account[0], userId);
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.removeUserLocked(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onAppNotIdle(String packageName, int userId) {
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            Iterator<SyncOperation> operationIterator = this.mSyncQueue.getOperations().iterator();
            boolean changed = false;
            while (operationIterator.hasNext()) {
                SyncOperation op = operationIterator.next();
                if (!op.appIdle || packageName != null && !this.getPackageName(op.target).equals(packageName) || userId != -1 && op.target.userId != userId) continue;
                op.appIdle = false;
                this.clearBackoffSetting(op);
                changed = true;
            }
            if (changed) {
                this.sendCheckAlarmsMessage();
            }
        }
    }

    protected void dump(FileDescriptor fd, PrintWriter pw) {
        IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
        this.dumpSyncState(ipw);
        this.dumpSyncHistory(ipw);
        this.dumpSyncAdapters(ipw);
    }

    static String formatTime(long time) {
        Time tobj = new Time();
        tobj.set(time);
        return tobj.format("%Y-%m-%d %H:%M:%S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpSyncState(PrintWriter pw) {
        pw.print("data connected: ");
        pw.println(this.mDataConnectionIsConnected);
        pw.print("auto sync: ");
        List<UserInfo> users = this.getAllUsers();
        if (users != null) {
            for (UserInfo user : users) {
                pw.print("u" + user.id + "=" + this.mSyncStorageEngine.getMasterSyncAutomatically(user.id) + " ");
            }
            pw.println();
        }
        pw.print("memory low: ");
        pw.println(this.mStorageIsLow);
        pw.print("device idle: ");
        pw.println(this.mDeviceIsIdle);
        AccountAndUser[] accounts = AccountManagerService.getSingleton().getAllAccounts();
        pw.print("accounts: ");
        if (accounts != INITIAL_ACCOUNTS_ARRAY) {
            pw.println(accounts.length);
        } else {
            pw.println("not known yet");
        }
        long now = SystemClock.elapsedRealtime();
        pw.print("now: ");
        pw.print(now);
        pw.println(" (" + SyncManager.formatTime(System.currentTimeMillis()) + ")");
        pw.print("offset: ");
        pw.print(DateUtils.formatElapsedTime(this.mSyncRandomOffsetMillis / 1000));
        pw.println(" (HH:MM:SS)");
        pw.print("uptime: ");
        pw.print(DateUtils.formatElapsedTime(now / 1000L));
        pw.println(" (HH:MM:SS)");
        pw.print("time spent syncing: ");
        pw.print(DateUtils.formatElapsedTime(this.mSyncHandler.mSyncTimeTracker.timeSpentSyncing() / 1000L));
        pw.print(" (HH:MM:SS), sync ");
        pw.print(this.mSyncHandler.mSyncTimeTracker.mLastWasSyncing ? "" : "not ");
        pw.println("in progress");
        if (this.mSyncHandler.mAlarmScheduleTime != null) {
            pw.print("next alarm time: ");
            pw.print(this.mSyncHandler.mAlarmScheduleTime);
            pw.print(" (");
            pw.print(DateUtils.formatElapsedTime((this.mSyncHandler.mAlarmScheduleTime - now) / 1000L));
            pw.println(" (HH:MM:SS) from now)");
        } else {
            pw.println("no alarm is scheduled (there had better not be any pending syncs)");
        }
        pw.println();
        pw.println("Active Syncs: " + this.mActiveSyncContexts.size());
        PackageManager pm = this.mContext.getPackageManager();
        for (ActiveSyncContext activeSyncContext : this.mActiveSyncContexts) {
            long durationInSeconds = (now - activeSyncContext.mStartTime) / 1000L;
            pw.print("  ");
            pw.print(DateUtils.formatElapsedTime(durationInSeconds));
            pw.print(" - ");
            pw.print(activeSyncContext.mSyncOperation.dump(pm, false));
            pw.println();
        }
        StringBuilder sb = new StringBuilder();
        SyncQueue syncQueue = this.mSyncQueue;
        synchronized (syncQueue) {
            this.mSyncQueue.dump(sb);
            this.getSyncStorageEngine().dumpPendingOperations(sb);
        }
        pw.println();
        pw.print(sb.toString());
        pw.println();
        pw.println("Sync Status");
        for (AccountAndUser account : accounts) {
            pw.printf("Account %s u%d %s\n", account.account.name, account.userId, account.account.type);
            pw.println("=======================================================================");
            PrintTable table = new PrintTable(13);
            table.set(0, 0, "Authority", "Syncable", "Enabled", "Delay", "Loc", "Poll", "Per", "Serv", "User", "Tot", "Time", "Last Sync", "Periodic");
            ArrayList sorted = Lists.newArrayList();
            sorted.addAll(this.mSyncAdapters.getAllServices(account.userId));
            Collections.sort(sorted, new Comparator<RegisteredServicesCache.ServiceInfo<SyncAdapterType>>(){

                @Override
                public int compare(RegisteredServicesCache.ServiceInfo<SyncAdapterType> lhs, RegisteredServicesCache.ServiceInfo<SyncAdapterType> rhs) {
                    return ((SyncAdapterType)lhs.type).authority.compareTo(((SyncAdapterType)rhs.type).authority);
                }
            });
            for (RegisteredServicesCache.ServiceInfo serviceInfo : sorted) {
                if (!((SyncAdapterType)serviceInfo.type).accountType.equals(account.account.type)) continue;
                int row = table.getNumRows();
                Pair<SyncStorageEngine.AuthorityInfo, SyncStatusInfo> syncAuthoritySyncStatus = this.mSyncStorageEngine.getCopyOfAuthorityWithSyncStatus(new SyncStorageEngine.EndPoint(account.account, ((SyncAdapterType)serviceInfo.type).authority, account.userId));
                SyncStorageEngine.AuthorityInfo settings = (SyncStorageEngine.AuthorityInfo)syncAuthoritySyncStatus.first;
                SyncStatusInfo status = (SyncStatusInfo)syncAuthoritySyncStatus.second;
                String authority = settings.target.provider;
                if (authority.length() > 50) {
                    authority = authority.substring(authority.length() - 50);
                }
                table.set(row, 0, authority, settings.syncable, settings.enabled);
                table.set(row, 4, status.numSourceLocal, status.numSourcePoll, status.numSourcePeriodic, status.numSourceServer, status.numSourceUser, status.numSyncs, DateUtils.formatElapsedTime(status.totalElapsedTime / 1000L));
                for (int i = 0; i < settings.periodicSyncs.size(); ++i) {
                    PeriodicSync sync = settings.periodicSyncs.get(i);
                    String period = String.format("[p:%d s, f: %d s]", sync.period, sync.flexTime);
                    String extras = sync.extras.size() > 0 ? sync.extras.toString() : "Bundle[]";
                    String next = "Next sync: " + SyncManager.formatTime(status.getPeriodicSyncTime(i) + sync.period * 1000L);
                    table.set(row + i * 2, 12, period + " " + extras);
                    table.set(row + i * 2 + 1, 12, next);
                }
                int row1 = row;
                if (settings.delayUntil > now) {
                    table.set(row1++, 12, "D: " + (settings.delayUntil - now) / 1000L);
                    if (settings.backoffTime > now) {
                        table.set(row1++, 12, "B: " + (settings.backoffTime - now) / 1000L);
                        table.set(row1++, 12, settings.backoffDelay / 1000L);
                    }
                }
                if (status.lastSuccessTime != 0L) {
                    table.set(row1++, 11, SyncStorageEngine.SOURCES[status.lastSuccessSource] + " " + "SUCCESS");
                    table.set(row1++, 11, SyncManager.formatTime(status.lastSuccessTime));
                }
                if (status.lastFailureTime == 0L) continue;
                table.set(row1++, 11, SyncStorageEngine.SOURCES[status.lastFailureSource] + " " + "FAILURE");
                table.set(row1++, 11, SyncManager.formatTime(status.lastFailureTime));
                table.set(row1++, 11, status.lastFailureMesg);
            }
            table.writeTo(pw);
        }
    }

    private String getLastFailureMessage(int code) {
        switch (code) {
            case 1: {
                return "sync already in progress";
            }
            case 2: {
                return "authentication error";
            }
            case 3: {
                return "I/O error";
            }
            case 4: {
                return "parse error";
            }
            case 5: {
                return "conflict error";
            }
            case 6: {
                return "too many deletions error";
            }
            case 7: {
                return "too many retries error";
            }
            case 8: {
                return "internal error";
            }
        }
        return "unknown";
    }

    private void dumpTimeSec(PrintWriter pw, long time) {
        pw.print(time / 1000L);
        pw.print('.');
        pw.print(time / 100L % 10L);
        pw.print('s');
    }

    private void dumpDayStatistic(PrintWriter pw, SyncStorageEngine.DayStats ds) {
        pw.print("Success (");
        pw.print(ds.successCount);
        if (ds.successCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.successTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.successTime / (long)ds.successCount);
        }
        pw.print(") Failure (");
        pw.print(ds.failureCount);
        if (ds.failureCount > 0) {
            pw.print(" for ");
            this.dumpTimeSec(pw, ds.failureTime);
            pw.print(" avg=");
            this.dumpTimeSec(pw, ds.failureTime / (long)ds.failureCount);
        }
        pw.println(")");
    }

    protected void dumpSyncHistory(PrintWriter pw) {
        this.dumpRecentHistory(pw);
        this.dumpDayStatistics(pw);
    }

    private void dumpRecentHistory(PrintWriter pw) {
        ArrayList<SyncStorageEngine.SyncHistoryItem> items = this.mSyncStorageEngine.getSyncHistory();
        if (items != null && items.size() > 0) {
            SyncStorageEngine.SyncHistoryItem item;
            int i;
            HashMap<String, AuthoritySyncStats> authorityMap = Maps.newHashMap();
            long totalElapsedTime = 0L;
            long totalTimes = 0L;
            int N = items.size();
            int maxAuthority = 0;
            int maxAccount = 0;
            for (SyncStorageEngine.SyncHistoryItem item2 : items) {
                String accountKey;
                String authorityName;
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item2.authorityId);
                if (authorityInfo != null) {
                    if (authorityInfo.target.target_provider) {
                        authorityName = authorityInfo.target.provider;
                        accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                    } else if (authorityInfo.target.target_service) {
                        authorityName = authorityInfo.target.service.getPackageName() + "/" + authorityInfo.target.service.getClassName() + " u" + authorityInfo.target.userId;
                        accountKey = "no account";
                    } else {
                        authorityName = "Unknown";
                        accountKey = "Unknown";
                    }
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                int length = authorityName.length();
                if (length > maxAuthority) {
                    maxAuthority = length;
                }
                if ((length = accountKey.length()) > maxAccount) {
                    maxAccount = length;
                }
                long elapsedTime = item2.elapsedTime;
                totalElapsedTime += elapsedTime;
                ++totalTimes;
                AuthoritySyncStats authoritySyncStats = (AuthoritySyncStats)authorityMap.get(authorityName);
                if (authoritySyncStats == null) {
                    authoritySyncStats = new AuthoritySyncStats(authorityName);
                    authorityMap.put(authorityName, authoritySyncStats);
                }
                authoritySyncStats.elapsedTime += elapsedTime;
                ++authoritySyncStats.times;
                Map<String, AccountSyncStats> accountMap = authoritySyncStats.accountMap;
                AccountSyncStats accountSyncStats = accountMap.get(accountKey);
                if (accountSyncStats == null) {
                    accountSyncStats = new AccountSyncStats(accountKey);
                    accountMap.put(accountKey, accountSyncStats);
                }
                accountSyncStats.elapsedTime += elapsedTime;
                ++accountSyncStats.times;
            }
            if (totalElapsedTime > 0L) {
                pw.println();
                pw.printf("Detailed Statistics (Recent history):  %d (# of times) %ds (sync time)\n", totalTimes, totalElapsedTime / 1000L);
                ArrayList sortedAuthorities = new ArrayList(authorityMap.values());
                Collections.sort(sortedAuthorities, new Comparator<AuthoritySyncStats>(){

                    @Override
                    public int compare(AuthoritySyncStats lhs, AuthoritySyncStats rhs) {
                        int compare = Integer.compare(rhs.times, lhs.times);
                        if (compare == 0) {
                            compare = Long.compare(rhs.elapsedTime, lhs.elapsedTime);
                        }
                        return compare;
                    }
                });
                int maxLength = Math.max(maxAuthority, maxAccount + 3);
                int padLength = 4 + maxLength + 2 + 10 + 11;
                char[] chars = new char[padLength];
                Arrays.fill(chars, '-');
                String separator = new String(chars);
                String authorityFormat = String.format("  %%-%ds: %%-9s  %%-11s\n", maxLength + 2);
                String accountFormat = String.format("    %%-%ds:   %%-9s  %%-11s\n", maxLength);
                pw.println(separator);
                for (AuthoritySyncStats authoritySyncStats : sortedAuthorities) {
                    String name = authoritySyncStats.name;
                    long elapsedTime = authoritySyncStats.elapsedTime;
                    int times = authoritySyncStats.times;
                    String timeStr = String.format("%ds/%d%%", elapsedTime / 1000L, elapsedTime * 100L / totalElapsedTime);
                    String timesStr = String.format("%d/%d%%", times, (long)(times * 100) / totalTimes);
                    pw.printf(authorityFormat, name, timesStr, timeStr);
                    ArrayList<AccountSyncStats> sortedAccounts = new ArrayList<AccountSyncStats>(authoritySyncStats.accountMap.values());
                    Collections.sort(sortedAccounts, new Comparator<AccountSyncStats>(){

                        @Override
                        public int compare(AccountSyncStats lhs, AccountSyncStats rhs) {
                            int compare = Integer.compare(rhs.times, lhs.times);
                            if (compare == 0) {
                                compare = Long.compare(rhs.elapsedTime, lhs.elapsedTime);
                            }
                            return compare;
                        }
                    });
                    for (AccountSyncStats stats : sortedAccounts) {
                        elapsedTime = stats.elapsedTime;
                        times = stats.times;
                        timeStr = String.format("%ds/%d%%", elapsedTime / 1000L, elapsedTime * 100L / totalElapsedTime);
                        timesStr = String.format("%d/%d%%", times, (long)(times * 100) / totalTimes);
                        pw.printf(accountFormat, stats.name, timesStr, timeStr);
                    }
                    pw.println(separator);
                }
            }
            pw.println();
            pw.println("Recent Sync History");
            String format = "  %-" + maxAccount + "s  %-" + maxAuthority + "s %s\n";
            HashMap<String, Long> lastTimeMap = Maps.newHashMap();
            PackageManager pm = this.mContext.getPackageManager();
            for (i = 0; i < N; ++i) {
                String diffString;
                String accountKey;
                String authorityName;
                item = items.get(i);
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item.authorityId);
                if (authorityInfo != null) {
                    if (authorityInfo.target.target_provider) {
                        authorityName = authorityInfo.target.provider;
                        accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                    } else if (authorityInfo.target.target_service) {
                        authorityName = authorityInfo.target.service.getPackageName() + "/" + authorityInfo.target.service.getClassName() + " u" + authorityInfo.target.userId;
                        accountKey = "none";
                    } else {
                        authorityName = "Unknown";
                        accountKey = "Unknown";
                    }
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                long elapsedTime = item.elapsedTime;
                Time time = new Time();
                long eventTime = item.eventTime;
                time.set(eventTime);
                String key = authorityName + "/" + accountKey;
                Long lastEventTime = (Long)lastTimeMap.get(key);
                if (lastEventTime == null) {
                    diffString = "";
                } else {
                    long diff = (lastEventTime - eventTime) / 1000L;
                    if (diff < 60L) {
                        diffString = String.valueOf(diff);
                    } else if (diff < 3600L) {
                        diffString = String.format("%02d:%02d", diff / 60L, diff % 60L);
                    } else {
                        long sec = diff % 3600L;
                        diffString = String.format("%02d:%02d:%02d", diff / 3600L, sec / 60L, sec % 60L);
                    }
                }
                lastTimeMap.put(key, eventTime);
                pw.printf("  #%-3d: %s %8s  %5.1fs  %8s", i + 1, SyncManager.formatTime(eventTime), SyncStorageEngine.SOURCES[item.source], Float.valueOf((float)elapsedTime / 1000.0f), diffString);
                pw.printf(format, accountKey, authorityName, SyncOperation.reasonToString(pm, item.reason));
                if (item.event != 1 || item.upstreamActivity != 0L || item.downstreamActivity != 0L) {
                    pw.printf("    event=%d upstreamActivity=%d downstreamActivity=%d\n", item.event, item.upstreamActivity, item.downstreamActivity);
                }
                if (item.mesg == null || "success".equals(item.mesg)) continue;
                pw.printf("    mesg=%s\n", item.mesg);
            }
            pw.println();
            pw.println("Recent Sync History Extras");
            for (i = 0; i < N; ++i) {
                String accountKey;
                String authorityName;
                item = items.get(i);
                Bundle extras = item.extras;
                if (extras == null || extras.size() == 0) continue;
                SyncStorageEngine.AuthorityInfo authorityInfo = this.mSyncStorageEngine.getAuthority(item.authorityId);
                if (authorityInfo != null) {
                    if (authorityInfo.target.target_provider) {
                        authorityName = authorityInfo.target.provider;
                        accountKey = authorityInfo.target.account.name + "/" + authorityInfo.target.account.type + " u" + authorityInfo.target.userId;
                    } else if (authorityInfo.target.target_service) {
                        authorityName = authorityInfo.target.service.getPackageName() + "/" + authorityInfo.target.service.getClassName() + " u" + authorityInfo.target.userId;
                        accountKey = "none";
                    } else {
                        authorityName = "Unknown";
                        accountKey = "Unknown";
                    }
                } else {
                    authorityName = "Unknown";
                    accountKey = "Unknown";
                }
                Time time = new Time();
                long eventTime = item.eventTime;
                time.set(eventTime);
                pw.printf("  #%-3d: %s %8s ", i + 1, SyncManager.formatTime(eventTime), SyncStorageEngine.SOURCES[item.source]);
                pw.printf(format, accountKey, authorityName, extras);
            }
        }
    }

    private void dumpDayStatistics(PrintWriter pw) {
        SyncStorageEngine.DayStats[] dses = this.mSyncStorageEngine.getDayStatistics();
        if (dses != null && dses[0] != null) {
            int delta;
            SyncStorageEngine.DayStats ds;
            int i;
            pw.println();
            pw.println("Sync Statistics");
            pw.print("  Today:  ");
            this.dumpDayStatistic(pw, dses[0]);
            int today = dses[0].day;
            for (i = 1; i <= 6 && i < dses.length && (ds = dses[i]) != null && (delta = today - ds.day) <= 6; ++i) {
                pw.print("  Day-");
                pw.print(delta);
                pw.print(":  ");
                this.dumpDayStatistic(pw, ds);
            }
            int weekDay = today;
            while (i < dses.length) {
                SyncStorageEngine.DayStats aggr = null;
                weekDay -= 7;
                while (i < dses.length) {
                    ds = dses[i];
                    if (ds == null) {
                        i = dses.length;
                        break;
                    }
                    int delta2 = weekDay - ds.day;
                    if (delta2 > 6) break;
                    ++i;
                    if (aggr == null) {
                        aggr = new SyncStorageEngine.DayStats(weekDay);
                    }
                    aggr.successCount += ds.successCount;
                    aggr.successTime += ds.successTime;
                    aggr.failureCount += ds.failureCount;
                    aggr.failureTime += ds.failureTime;
                }
                if (aggr == null) continue;
                pw.print("  Week-");
                pw.print((today - weekDay) / 7);
                pw.print(": ");
                this.dumpDayStatistic(pw, aggr);
            }
        }
    }

    private void dumpSyncAdapters(IndentingPrintWriter pw) {
        pw.println();
        List<UserInfo> users = this.getAllUsers();
        if (users != null) {
            for (UserInfo user : users) {
                pw.println("Sync adapters for " + user + ":");
                pw.increaseIndent();
                for (RegisteredServicesCache.ServiceInfo info : this.mSyncAdapters.getAllServices(user.id)) {
                    pw.println(info);
                }
                pw.decreaseIndent();
                pw.println();
            }
        }
    }

    String getPackageName(SyncStorageEngine.EndPoint endpoint) {
        if (endpoint.target_service) {
            return endpoint.service.getPackageName();
        }
        SyncAdapterType syncAdapterType = SyncAdapterType.newKey(endpoint.provider, endpoint.account.type);
        RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = this.mSyncAdapters.getServiceInfo(syncAdapterType, endpoint.userId);
        if (syncAdapterInfo == null) {
            return null;
        }
        return syncAdapterInfo.componentName.getPackageName();
    }

    private boolean isSyncStillActiveH(ActiveSyncContext activeSyncContext) {
        for (ActiveSyncContext sync : this.mActiveSyncContexts) {
            if (sync != activeSyncContext) continue;
            return true;
        }
        return false;
    }

    public static boolean syncExtrasEquals(Bundle b1, Bundle b2, boolean includeSyncSettings) {
        if (b1 == b2) {
            return true;
        }
        if (includeSyncSettings && b1.size() != b2.size()) {
            return false;
        }
        Bundle bigger = b1.size() > b2.size() ? b1 : b2;
        Bundle smaller = b1.size() > b2.size() ? b2 : b1;
        for (String key : bigger.keySet()) {
            if (!includeSyncSettings && SyncManager.isSyncSetting(key)) continue;
            if (!smaller.containsKey(key)) {
                return false;
            }
            if (bigger.get(key).equals(smaller.get(key))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSyncSetting(String key) {
        if (key.equals("expedited")) {
            return true;
        }
        if (key.equals("ignore_settings")) {
            return true;
        }
        if (key.equals("ignore_backoff")) {
            return true;
        }
        if (key.equals("do_not_retry")) {
            return true;
        }
        if (key.equals("force")) {
            return true;
        }
        if (key.equals("upload")) {
            return true;
        }
        if (key.equals("deletions_override")) {
            return true;
        }
        if (key.equals("discard_deletions")) {
            return true;
        }
        if (key.equals("expected_upload")) {
            return true;
        }
        if (key.equals("expected_download")) {
            return true;
        }
        if (key.equals("sync_priority")) {
            return true;
        }
        if (key.equals("allow_metered")) {
            return true;
        }
        return key.equals("initialize");
    }

    private Context getContextForUser(UserHandle user) {
        try {
            return this.mContext.createPackageContextAsUser(this.mContext.getPackageName(), 0, user);
        }
        catch (PackageManager.NameNotFoundException e) {
            return this.mContext;
        }
    }

    static /* synthetic */ PowerManager.WakeLock access$2600(SyncManager x0) {
        return x0.mSyncManagerWakeLock;
    }

    static /* synthetic */ boolean access$2700(SyncManager x0, ActiveSyncContext x1) {
        return x0.isSyncStillActiveH(x1);
    }

    static {
        boolean isLargeRAM = !ActivityManager.isLowRamDeviceStatic();
        int defaultMaxInitSyncs = isLargeRAM ? 5 : 2;
        int defaultMaxRegularSyncs = isLargeRAM ? 2 : 1;
        MAX_SIMULTANEOUS_INITIALIZATION_SYNCS = SystemProperties.getInt("sync.max_init_syncs", defaultMaxInitSyncs);
        MAX_SIMULTANEOUS_REGULAR_SYNCS = SystemProperties.getInt("sync.max_regular_syncs", defaultMaxRegularSyncs);
        LOCAL_SYNC_DELAY = SystemProperties.getLong("sync.local_sync_delay", 30000L);
        MAX_TIME_PER_SYNC = SystemProperties.getLong("sync.max_time_per_sync", 300000L);
        SYNC_NOTIFICATION_DELAY = SystemProperties.getLong("sync.notification_delay", 30000L);
        INITIAL_ACCOUNTS_ARRAY = new AccountAndUser[0];
    }

    static class PrintTable {
        private ArrayList<Object[]> mTable = Lists.newArrayList();
        private final int mCols;

        PrintTable(int cols) {
            this.mCols = cols;
        }

        void set(int row, int col, Object ... values) {
            if (col + values.length > this.mCols) {
                throw new IndexOutOfBoundsException("Table only has " + this.mCols + " columns. can't set " + values.length + " at column " + col);
            }
            for (int i = this.mTable.size(); i <= row; ++i) {
                Object[] list = new Object[this.mCols];
                this.mTable.add(list);
                for (int j = 0; j < this.mCols; ++j) {
                    list[j] = "";
                }
            }
            System.arraycopy(values, 0, this.mTable.get(row), col, values.length);
        }

        void writeTo(PrintWriter out) {
            int i;
            String[] formats = new String[this.mCols];
            int totalLength = 0;
            for (int col = 0; col < this.mCols; ++col) {
                int maxLength = 0;
                for (Object[] row : this.mTable) {
                    int length = row[col].toString().length();
                    if (length <= maxLength) continue;
                    maxLength = length;
                }
                totalLength += maxLength;
                formats[col] = String.format("%%-%ds", maxLength);
            }
            formats[this.mCols - 1] = "%s";
            this.printRow(out, formats, this.mTable.get(0));
            totalLength += (this.mCols - 1) * 2;
            for (i = 0; i < totalLength; ++i) {
                out.print("-");
            }
            out.println();
            int mTableSize = this.mTable.size();
            for (i = 1; i < mTableSize; ++i) {
                Object[] row = this.mTable.get(i);
                this.printRow(out, formats, row);
            }
        }

        private void printRow(PrintWriter out, String[] formats, Object[] row) {
            int rowLength = row.length;
            for (int j = 0; j < rowLength; ++j) {
                out.printf(String.format(formats[j], row[j].toString()), new Object[0]);
                out.print("  ");
            }
            out.println();
        }

        public int getNumRows() {
            return this.mTable.size();
        }
    }

    class SyncHandler
    extends Handler {
        private static final int MESSAGE_SYNC_FINISHED = 1;
        private static final int MESSAGE_SYNC_ALARM = 2;
        private static final int MESSAGE_CHECK_ALARMS = 3;
        private static final int MESSAGE_SERVICE_CONNECTED = 4;
        private static final int MESSAGE_SERVICE_DISCONNECTED = 5;
        private static final int MESSAGE_CANCEL = 6;
        private static final int MESSAGE_SYNC_EXPIRED = 7;
        private static final int MESSAGE_MONITOR_SYNC = 8;
        public final SyncNotificationInfo mSyncNotificationInfo;
        private Long mAlarmScheduleTime;
        public final SyncTimeTracker mSyncTimeTracker;
        private final HashMap<String, PowerManager.WakeLock> mWakeLocks;
        private List<Message> mUnreadyQueue;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onBootCompleted() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "Boot completed, clearing boot queue.");
            }
            SyncManager.this.doDatabaseCleanup();
            SyncHandler syncHandler = this;
            synchronized (syncHandler) {
                this.maybeEmptyUnreadyQueueLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onDeviceProvisioned() {
            if (Log.isLoggable(SyncManager.TAG, 3)) {
                Log.d(SyncManager.TAG, "mProvisioned=" + SyncManager.this.mProvisioned);
            }
            SyncHandler syncHandler = this;
            synchronized (syncHandler) {
                this.maybeEmptyUnreadyQueueLocked();
            }
        }

        private void maybeEmptyUnreadyQueueLocked() {
            if (SyncManager.this.mProvisioned && SyncManager.this.mBootCompleted) {
                for (int i = 0; i < this.mUnreadyQueue.size(); ++i) {
                    this.sendMessageDelayed(this.mUnreadyQueue.get(i), Math.max(3000L * (long)i, 120000L));
                }
                this.mUnreadyQueue = null;
            }
        }

        private PowerManager.WakeLock getSyncWakeLock(SyncOperation operation) {
            String wakeLockKey = operation.wakeLockName();
            PowerManager.WakeLock wakeLock = this.mWakeLocks.get(wakeLockKey);
            if (wakeLock == null) {
                String name = SyncManager.SYNC_WAKE_LOCK_PREFIX + wakeLockKey;
                wakeLock = SyncManager.this.mPowerManager.newWakeLock(1, name);
                wakeLock.setReferenceCounted(false);
                this.mWakeLocks.put(wakeLockKey, wakeLock);
            }
            return wakeLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean tryEnqueueMessageUntilReadyToRun(Message msg) {
            SyncHandler syncHandler = this;
            synchronized (syncHandler) {
                if (!SyncManager.this.mBootCompleted || !SyncManager.this.mProvisioned) {
                    this.mUnreadyQueue.add(Message.obtain(msg));
                    return true;
                }
                return false;
            }
        }

        public SyncHandler(Looper looper) {
            super(looper);
            this.mSyncNotificationInfo = new SyncNotificationInfo();
            this.mAlarmScheduleTime = null;
            this.mSyncTimeTracker = new SyncTimeTracker();
            this.mWakeLocks = Maps.newHashMap();
            this.mUnreadyQueue = new ArrayList<Message>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void handleMessage(Message msg) {
            if (this.tryEnqueueMessageUntilReadyToRun(msg)) {
                return;
            }
            earliestFuturePollTime = 0x7FFFFFFFFFFFFFFFL;
            nextPendingSyncTime = 0x7FFFFFFFFFFFFFFFL;
            try {
                SyncManager.access$602(SyncManager.this, SyncManager.access$700(SyncManager.this));
                SyncManager.access$2600(SyncManager.this).acquire();
                earliestFuturePollTime = this.scheduleReadyPeriodicSyncs();
                switch (msg.what) {
                    case 6: {
                        endpoint = (SyncStorageEngine.EndPoint)msg.obj;
                        extras = msg.peekData();
                        if (Log.isLoggable("SyncManager", 3)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: MESSAGE_CANCEL: " + endpoint + " bundle: " + extras);
                        }
                        this.cancelActiveSyncH(endpoint, extras);
                        nextPendingSyncTime = this.maybeStartNextSyncH();
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        if (Log.isLoggable("SyncManager", 2)) {
                            Log.v("SyncManager", "handleSyncHandlerMessage: MESSAGE_SYNC_FINISHED");
                        }
                        payload = (SyncHandlerMessagePayload)msg.obj;
                        if (!SyncManager.access$2700(SyncManager.this, payload.activeSyncContext)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: dropping since the sync is no longer active: " + payload.activeSyncContext);
                            ** break;
lbl30:
                            // 1 sources

                        } else {
                            this.runSyncFinishedOrCanceledH(payload.syncResult, payload.activeSyncContext);
                            nextPendingSyncTime = this.maybeStartNextSyncH();
                            ** break;
                        }
lbl34:
                        // 1 sources

                        break;
                    }
                    case 4: {
                        msgData = (ServiceConnectionData)msg.obj;
                        if (Log.isLoggable("SyncManager", 2)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: MESSAGE_SERVICE_CONNECTED: " + msgData.activeSyncContext);
                        }
                        if (!SyncManager.access$2700(SyncManager.this, msgData.activeSyncContext)) ** break;
                        this.runBoundToAdapter(msgData.activeSyncContext, msgData.adapter);
                        ** break;
lbl43:
                        // 1 sources

                        break;
                    }
                    case 5: {
                        currentSyncContext = ((ServiceConnectionData)msg.obj).activeSyncContext;
                        if (Log.isLoggable("SyncManager", 2)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: MESSAGE_SERVICE_DISCONNECTED: " + currentSyncContext);
                        }
                        if (!SyncManager.access$2700(SyncManager.this, currentSyncContext)) ** break;
                        try {
                            if (currentSyncContext.mSyncAdapter != null) {
                                currentSyncContext.mSyncAdapter.cancelSync(currentSyncContext);
                            } else if (currentSyncContext.mSyncServiceAdapter != null) {
                                currentSyncContext.mSyncServiceAdapter.cancelSync(currentSyncContext);
                            }
                        }
                        catch (RemoteException e) {
                            // empty catch block
                        }
                        syncResult = new SyncResult();
                        ++syncResult.stats.numIoExceptions;
                        this.runSyncFinishedOrCanceledH(syncResult, currentSyncContext);
                        nextPendingSyncTime = this.maybeStartNextSyncH();
                        ** break;
lbl64:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        isLoggable = Log.isLoggable("SyncManager", 2);
                        if (isLoggable) {
                            Log.v("SyncManager", "handleSyncHandlerMessage: MESSAGE_SYNC_ALARM");
                        }
                        this.mAlarmScheduleTime = null;
                        try {
                            nextPendingSyncTime = this.maybeStartNextSyncH();
                            break;
                        }
                        finally {
                            SyncManager.access$1500(SyncManager.this).release();
                        }
                    }
                    case 3: {
                        if (Log.isLoggable("SyncManager", 2)) {
                            Log.v("SyncManager", "handleSyncHandlerMessage: MESSAGE_CHECK_ALARMS");
                        }
                        nextPendingSyncTime = this.maybeStartNextSyncH();
                        ** break;
lbl83:
                        // 1 sources

                        break;
                    }
                    case 7: {
                        expiredContext = (ActiveSyncContext)msg.obj;
                        if (Log.isLoggable("SyncManager", 3)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: MESSAGE_SYNC_EXPIRED: cancelling " + expiredContext);
                        }
                        this.runSyncFinishedOrCanceledH(null, expiredContext);
                        nextPendingSyncTime = this.maybeStartNextSyncH();
                        ** break;
lbl92:
                        // 1 sources

                        break;
                    }
                    case 8: {
                        monitoredSyncContext = (ActiveSyncContext)msg.obj;
                        if (Log.isLoggable("SyncManager", 3)) {
                            Log.d("SyncManager", "handleSyncHandlerMessage: MESSAGE_MONITOR_SYNC: " + monitoredSyncContext.mSyncOperation.target);
                        }
                        if (this.isSyncNotUsingNetworkH(monitoredSyncContext)) {
                            Log.w("SyncManager", String.format("Detected sync making no progress for %s. cancelling.", new Object[]{monitoredSyncContext}));
                            this.runSyncFinishedOrCanceledH(null, monitoredSyncContext);
                            ** break;
lbl103:
                            // 1 sources

                        } else {
                            SyncManager.access$2800(SyncManager.this, monitoredSyncContext);
                        }
                        break;
                    }
                    ** default:
lbl107:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.manageSyncAlarmLocked(earliestFuturePollTime, nextPendingSyncTime);
                this.mSyncTimeTracker.update();
                SyncManager.access$2600(SyncManager.this).release();
            }
        }

        private boolean isDispatchable(SyncStorageEngine.EndPoint target) {
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (target.target_provider) {
                AccountAndUser[] accounts = SyncManager.this.mRunningAccounts;
                if (!SyncManager.this.containsAccountAndUser(accounts, target.account, target.userId)) {
                    return false;
                }
                if (!SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically(target.userId) || !SyncManager.this.mSyncStorageEngine.getSyncAutomatically(target.account, target.userId, target.provider)) {
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "    Not scheduling periodic operation: sync turned off.");
                    }
                    return false;
                }
                if (SyncManager.this.getIsSyncable(target.account, target.userId, target.provider) == 0) {
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "    Not scheduling periodic operation: isSyncable == 0.");
                    }
                    return false;
                }
            } else if (target.target_service && SyncManager.this.mSyncStorageEngine.getIsTargetServiceActive(target.service, target.userId)) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "   Not scheduling periodic operation: isEnabled == 0.");
                }
                return false;
            }
            return true;
        }

        private long scheduleReadyPeriodicSyncs() {
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "scheduleReadyPeriodicSyncs");
            }
            long earliestFuturePollTime = Long.MAX_VALUE;
            long nowAbsolute = System.currentTimeMillis();
            long shiftedNowAbsolute = 0L < nowAbsolute - (long)SyncManager.this.mSyncRandomOffsetMillis ? nowAbsolute - (long)SyncManager.this.mSyncRandomOffsetMillis : 0L;
            ArrayList<Pair<SyncStorageEngine.AuthorityInfo, SyncStatusInfo>> infos = SyncManager.this.mSyncStorageEngine.getCopyOfAllAuthoritiesWithSyncStatus();
            for (Pair<SyncStorageEngine.AuthorityInfo, SyncStatusInfo> info : infos) {
                SyncStorageEngine.AuthorityInfo authorityInfo = (SyncStorageEngine.AuthorityInfo)info.first;
                SyncStatusInfo status = (SyncStatusInfo)info.second;
                if (TextUtils.isEmpty(authorityInfo.target.provider)) {
                    Log.e(SyncManager.TAG, "Got an empty provider string. Skipping: " + authorityInfo.target.provider);
                    continue;
                }
                if (!this.isDispatchable(authorityInfo.target)) continue;
                int N = authorityInfo.periodicSyncs.size();
                for (int i = 0; i < N; ++i) {
                    long nextPollTimeAbsolute;
                    boolean runEarly;
                    PeriodicSync sync = authorityInfo.periodicSyncs.get(i);
                    Bundle extras = sync.extras;
                    Long periodInMillis = sync.period * 1000L;
                    Long flexInMillis = sync.flexTime * 1000L;
                    if (periodInMillis <= 0L) continue;
                    long lastPollTimeAbsolute = status.getPeriodicSyncTime(i);
                    long shiftedLastPollTimeAbsolute = 0L < lastPollTimeAbsolute - (long)SyncManager.this.mSyncRandomOffsetMillis ? lastPollTimeAbsolute - (long)SyncManager.this.mSyncRandomOffsetMillis : 0L;
                    long remainingMillis = periodInMillis - shiftedNowAbsolute % periodInMillis;
                    long timeSinceLastRunMillis = nowAbsolute - lastPollTimeAbsolute;
                    boolean bl = runEarly = remainingMillis <= flexInMillis && timeSinceLastRunMillis > periodInMillis - flexInMillis;
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "sync: " + i + " for " + authorityInfo.target + "." + " period: " + periodInMillis + " flex: " + flexInMillis + " remaining: " + remainingMillis + " time_since_last: " + timeSinceLastRunMillis + " last poll absol: " + lastPollTimeAbsolute + " last poll shifed: " + shiftedLastPollTimeAbsolute + " shifted now: " + shiftedNowAbsolute + " run_early: " + runEarly);
                    }
                    if (remainingMillis == periodInMillis || lastPollTimeAbsolute > nowAbsolute || timeSinceLastRunMillis >= periodInMillis || runEarly) {
                        SyncStorageEngine.EndPoint target = authorityInfo.target;
                        Pair<Long, Long> backoff = SyncManager.this.mSyncStorageEngine.getBackoff(target);
                        SyncManager.this.mSyncStorageEngine.setPeriodicSyncTime(authorityInfo.ident, authorityInfo.periodicSyncs.get(i), nowAbsolute);
                        if (target.target_provider) {
                            RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(target.provider, target.account.type), target.userId);
                            if (syncAdapterInfo == null) continue;
                            SyncManager.this.scheduleSyncOperation(new SyncOperation(target.account, target.userId, -4, 4, target.provider, extras, 0L, 0L, backoff != null ? (Long)backoff.first : 0L, SyncManager.this.mSyncStorageEngine.getDelayUntilTime(target), ((SyncAdapterType)syncAdapterInfo.type).allowParallelSyncs()));
                        } else if (target.target_service) {
                            SyncManager.this.scheduleSyncOperation(new SyncOperation(target.service, target.userId, -4, 4, extras, 0L, 0L, backoff != null ? (Long)backoff.first : 0L, SyncManager.this.mSyncStorageEngine.getDelayUntilTime(target)));
                        }
                    }
                    if ((nextPollTimeAbsolute = runEarly ? nowAbsolute + periodInMillis + remainingMillis : nowAbsolute + remainingMillis) >= earliestFuturePollTime) continue;
                    earliestFuturePollTime = nextPollTimeAbsolute;
                }
            }
            if (earliestFuturePollTime == Long.MAX_VALUE) {
                return Long.MAX_VALUE;
            }
            return SystemClock.elapsedRealtime() + (earliestFuturePollTime < nowAbsolute ? 0L : earliestFuturePollTime - nowAbsolute);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long maybeStartNextSyncH() {
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "maybeStartNextSync");
            }
            if (!SyncManager.this.mDataConnectionIsConnected) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "maybeStartNextSync: no data connection, skipping");
                }
                return Long.MAX_VALUE;
            }
            if (SyncManager.this.mStorageIsLow) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "maybeStartNextSync: memory low, skipping");
                }
                return Long.MAX_VALUE;
            }
            if (SyncManager.this.mDeviceIsIdle) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "maybeStartNextSync: device idle, skipping");
                }
                return Long.MAX_VALUE;
            }
            if (SyncManager.this.mRunningAccounts == INITIAL_ACCOUNTS_ARRAY) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "maybeStartNextSync: accounts not known, skipping");
                }
                return Long.MAX_VALUE;
            }
            long now = SystemClock.elapsedRealtime();
            long nextReadyToRunTime = Long.MAX_VALUE;
            ArrayList<SyncOperation> operations = new ArrayList<SyncOperation>();
            SyncQueue syncQueue = SyncManager.this.mSyncQueue;
            synchronized (syncQueue) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "build the operation array, syncQueue size is " + SyncManager.this.mSyncQueue.getOperations().size());
                }
                Iterator<SyncOperation> operationIterator = SyncManager.this.mSyncQueue.getOperations().iterator();
                ActivityManager activityManager = (ActivityManager)SyncManager.this.mContext.getSystemService("activity");
                HashSet<Integer> removedUsers = Sets.newHashSet();
                while (operationIterator.hasNext()) {
                    SyncOperation op = operationIterator.next();
                    if (!activityManager.isUserRunning(op.target.userId)) {
                        UserInfo userInfo = SyncManager.this.mUserManager.getUserInfo(op.target.userId);
                        if (userInfo == null) {
                            removedUsers.add(op.target.userId);
                        }
                        if (!isLoggable) continue;
                        Log.v(SyncManager.TAG, "    Dropping all sync operations for + " + op.target.userId + ": user not running.");
                        continue;
                    }
                    if (!this.isOperationValidLocked(op)) {
                        operationIterator.remove();
                        SyncManager.this.mSyncStorageEngine.deleteFromPending(op.pendingOperation);
                        continue;
                    }
                    if (op.effectiveRunTime - op.flexTime > now) {
                        if (nextReadyToRunTime > op.effectiveRunTime) {
                            nextReadyToRunTime = op.effectiveRunTime;
                        }
                        if (!isLoggable) continue;
                        Log.v(SyncManager.TAG, "    Not running sync operation: Sync too far in future.effective: " + op.effectiveRunTime + " flex: " + op.flexTime + " now: " + now);
                        continue;
                    }
                    String packageName = SyncManager.this.getPackageName(op.target);
                    if (packageName != null && SyncManager.this.mAppIdleMonitor.isAppIdle(packageName, op.target.userId)) {
                        SyncManager.this.increaseBackoffSetting(op);
                        op.appIdle = true;
                        if (!isLoggable) continue;
                        Log.v(SyncManager.TAG, "Sync backing off idle app " + packageName);
                        continue;
                    }
                    op.appIdle = false;
                    operations.add(op);
                }
                for (Integer user : removedUsers) {
                    if (SyncManager.this.mUserManager.getUserInfo(user) != null) continue;
                    SyncManager.this.onUserRemoved(user);
                }
            }
            if (isLoggable) {
                Log.v(SyncManager.TAG, "sort the candidate operations, size " + operations.size());
            }
            Collections.sort(operations);
            if (isLoggable) {
                Log.v(SyncManager.TAG, "dispatch all ready sync operations");
            }
            int N = operations.size();
            for (int i = 0; i < N; ++i) {
                boolean roomAvailable;
                SyncOperation candidate = (SyncOperation)operations.get(i);
                boolean candidateIsInitialization = candidate.isInitialization();
                int numInit = 0;
                int numRegular = 0;
                ActiveSyncContext conflict = null;
                ActiveSyncContext longRunning = null;
                ActiveSyncContext toReschedule = null;
                ActiveSyncContext oldestNonExpeditedRegular = null;
                for (ActiveSyncContext activeSyncContext : SyncManager.this.mActiveSyncContexts) {
                    SyncOperation activeOp = activeSyncContext.mSyncOperation;
                    if (activeOp.isInitialization()) {
                        ++numInit;
                    } else {
                        ++numRegular;
                        if (!(activeOp.isExpedited() || oldestNonExpeditedRegular != null && oldestNonExpeditedRegular.mStartTime <= activeSyncContext.mStartTime)) {
                            oldestNonExpeditedRegular = activeSyncContext;
                        }
                    }
                    if (activeOp.isConflict(candidate)) {
                        conflict = activeSyncContext;
                        continue;
                    }
                    if (candidateIsInitialization != activeOp.isInitialization() || activeSyncContext.mStartTime + MAX_TIME_PER_SYNC >= now) continue;
                    longRunning = activeSyncContext;
                }
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "candidate " + (i + 1) + " of " + N + ": " + candidate);
                    Log.v(SyncManager.TAG, "  numActiveInit=" + numInit + ", numActiveRegular=" + numRegular);
                    Log.v(SyncManager.TAG, "  longRunning: " + longRunning);
                    Log.v(SyncManager.TAG, "  conflict: " + conflict);
                    Log.v(SyncManager.TAG, "  oldestNonExpeditedRegular: " + oldestNonExpeditedRegular);
                }
                boolean bl = candidateIsInitialization ? numInit < MAX_SIMULTANEOUS_INITIALIZATION_SYNCS : (roomAvailable = numRegular < MAX_SIMULTANEOUS_REGULAR_SYNCS);
                if (conflict != null) {
                    if (candidateIsInitialization && !conflict.mSyncOperation.isInitialization() && numInit < MAX_SIMULTANEOUS_INITIALIZATION_SYNCS) {
                        toReschedule = conflict;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.v(SyncManager.TAG, "canceling and rescheduling sync since an initialization takes higher priority, " + conflict);
                        }
                    } else {
                        if (!candidate.isExpedited() || conflict.mSyncOperation.isExpedited() || candidateIsInitialization != conflict.mSyncOperation.isInitialization()) continue;
                        toReschedule = conflict;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.v(SyncManager.TAG, "canceling and rescheduling sync since an expedited takes higher priority, " + conflict);
                        }
                    }
                } else if (!roomAvailable) {
                    if (candidate.isExpedited() && oldestNonExpeditedRegular != null && !candidateIsInitialization) {
                        toReschedule = oldestNonExpeditedRegular;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.v(SyncManager.TAG, "canceling and rescheduling sync since an expedited is ready to run, " + oldestNonExpeditedRegular);
                        }
                    } else {
                        if (longRunning == null || candidateIsInitialization != longRunning.mSyncOperation.isInitialization()) continue;
                        toReschedule = longRunning;
                        if (Log.isLoggable(SyncManager.TAG, 2)) {
                            Log.v(SyncManager.TAG, "canceling and rescheduling sync since it ran roo long, " + longRunning);
                        }
                    }
                }
                if (toReschedule != null) {
                    this.runSyncFinishedOrCanceledH(null, toReschedule);
                    SyncManager.this.scheduleSyncOperation(toReschedule.mSyncOperation);
                }
                SyncQueue syncQueue2 = SyncManager.this.mSyncQueue;
                synchronized (syncQueue2) {
                    SyncManager.this.mSyncQueue.remove(candidate);
                }
                this.dispatchSyncOperation(candidate);
            }
            return nextReadyToRunTime;
        }

        private boolean isSyncNotUsingNetworkH(ActiveSyncContext activeSyncContext) {
            long bytesTransferredCurrent = SyncManager.this.getTotalBytesTransferredByUid(activeSyncContext.mSyncAdapterUid);
            long deltaBytesTransferred = bytesTransferredCurrent - activeSyncContext.mBytesTransferredAtLastPoll;
            if (Log.isLoggable(SyncManager.TAG, 3)) {
                long remainder = deltaBytesTransferred;
                long mb = remainder / 0x100000L;
                long kb = (remainder %= 0x100000L) / 1024L;
                long b = remainder %= 1024L;
                Log.d(SyncManager.TAG, String.format("Time since last update: %ds. Delta transferred: %dMBs,%dKBs,%dBs", (SystemClock.elapsedRealtime() - activeSyncContext.mLastPolledTimeElapsed) / 1000L, mb, kb, b));
            }
            return deltaBytesTransferred <= 10L;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isOperationValidLocked(SyncOperation op) {
            boolean uidNetworkConnected;
            boolean ignoreSystemConfiguration;
            int targetUid;
            int state;
            boolean syncEnabled;
            boolean isLoggable;
            block20: {
                isLoggable = Log.isLoggable(SyncManager.TAG, 2);
                SyncStorageEngine.EndPoint target = op.target;
                syncEnabled = SyncManager.this.mSyncStorageEngine.getMasterSyncAutomatically(target.userId);
                if (target.target_provider) {
                    AccountAndUser[] accounts = SyncManager.this.mRunningAccounts;
                    if (!SyncManager.this.containsAccountAndUser(accounts, target.account, target.userId)) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "    Dropping sync operation: account doesn't exist.");
                        }
                        return false;
                    }
                    state = SyncManager.this.getIsSyncable(target.account, target.userId, target.provider);
                    if (state == 0) {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "    Dropping sync operation: isSyncable == 0.");
                        }
                        return false;
                    }
                    syncEnabled = syncEnabled && SyncManager.this.mSyncStorageEngine.getSyncAutomatically(target.account, target.userId, target.provider);
                    RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(SyncAdapterType.newKey(target.provider, target.account.type), target.userId);
                    if (syncAdapterInfo != null) {
                        targetUid = syncAdapterInfo.uid;
                        break block20;
                    } else {
                        if (isLoggable) {
                            Log.v(SyncManager.TAG, "    Dropping sync operation: No sync adapter registeredfor: " + target);
                        }
                        return false;
                    }
                }
                if (!target.target_service) {
                    Log.e(SyncManager.TAG, "Unknown target for Sync Op: " + target);
                    return false;
                }
                int n = state = SyncManager.this.mSyncStorageEngine.getIsTargetServiceActive(target.service, target.userId) ? 1 : 0;
                if (state == 0) {
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "    Dropping sync operation: isActive == 0.");
                    }
                    return false;
                }
                try {
                    targetUid = ((SyncManager)SyncManager.this).mContext.getPackageManager().getServiceInfo((ComponentName)target.service, (int)0).applicationInfo.uid;
                }
                catch (PackageManager.NameNotFoundException e) {
                    if (isLoggable) {
                        Log.v(SyncManager.TAG, "    Dropping sync operation: No service registered for: " + target.service);
                    }
                    return false;
                }
            }
            boolean bl = ignoreSystemConfiguration = op.extras.getBoolean("ignore_settings", false) || state < 0;
            if (!syncEnabled && !ignoreSystemConfiguration) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "    Dropping sync operation: disallowed by settings/network.");
                }
                return false;
            }
            NetworkInfo networkInfo = SyncManager.this.getConnectivityManager().getActiveNetworkInfoForUid(targetUid);
            boolean bl2 = uidNetworkConnected = networkInfo != null && networkInfo.isConnected();
            if (!uidNetworkConnected && !ignoreSystemConfiguration) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "    Dropping sync operation: disallowed by settings/network.");
                }
                return false;
            }
            if (op.isNotAllowedOnMetered() && SyncManager.this.getConnectivityManager().isActiveNetworkMetered() && !ignoreSystemConfiguration) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "    Dropping sync operation: not allowed on metered network.");
                }
                return false;
            }
            return true;
        }

        private boolean dispatchSyncOperation(SyncOperation op) {
            ComponentName targetComponent;
            int targetUid;
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "dispatchSyncOperation: we are going to sync " + op);
                Log.v(SyncManager.TAG, "num active syncs: " + SyncManager.this.mActiveSyncContexts.size());
                for (ActiveSyncContext syncContext : SyncManager.this.mActiveSyncContexts) {
                    Log.v(SyncManager.TAG, syncContext.toString());
                }
            }
            SyncStorageEngine.EndPoint info = op.target;
            if (info.target_provider) {
                SyncAdapterType syncAdapterType = SyncAdapterType.newKey(info.provider, info.account.type);
                RegisteredServicesCache.ServiceInfo<SyncAdapterType> syncAdapterInfo = SyncManager.this.mSyncAdapters.getServiceInfo(syncAdapterType, info.userId);
                if (syncAdapterInfo == null) {
                    Log.d(SyncManager.TAG, "can't find a sync adapter for " + syncAdapterType + ", removing settings for it");
                    SyncManager.this.mSyncStorageEngine.removeAuthority(info);
                    return false;
                }
                targetUid = syncAdapterInfo.uid;
                targetComponent = syncAdapterInfo.componentName;
            } else {
                try {
                    targetUid = ((SyncManager)SyncManager.this).mContext.getPackageManager().getServiceInfo((ComponentName)info.service, (int)0).applicationInfo.uid;
                    targetComponent = info.service;
                }
                catch (PackageManager.NameNotFoundException e) {
                    Log.d(SyncManager.TAG, "Can't find a service for " + info.service + ", removing settings for it");
                    SyncManager.this.mSyncStorageEngine.removeAuthority(info);
                    return false;
                }
            }
            ActiveSyncContext activeSyncContext = new ActiveSyncContext(op, this.insertStartSyncEvent(op), targetUid);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "dispatchSyncOperation: starting " + activeSyncContext);
            }
            activeSyncContext.mSyncInfo = SyncManager.this.mSyncStorageEngine.addActiveSync(activeSyncContext);
            SyncManager.this.mActiveSyncContexts.add(activeSyncContext);
            if (!(activeSyncContext.mSyncOperation.isExpedited() || activeSyncContext.mSyncOperation.isManual() || activeSyncContext.mSyncOperation.isIgnoreSettings())) {
                SyncManager.this.postSyncExpiryMessage(activeSyncContext);
            }
            SyncManager.this.postMonitorSyncProgressMessage(activeSyncContext);
            if (!activeSyncContext.bindToSyncAdapter(targetComponent, info.userId)) {
                Log.e(SyncManager.TAG, "Bind attempt failed - target: " + targetComponent);
                this.closeActiveSyncContext(activeSyncContext);
                return false;
            }
            return true;
        }

        private void runBoundToAdapter(ActiveSyncContext activeSyncContext, IBinder syncAdapter) {
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            try {
                activeSyncContext.mIsLinkedToDeath = true;
                syncAdapter.linkToDeath(activeSyncContext, 0);
                if (syncOperation.target.target_provider) {
                    activeSyncContext.mSyncAdapter = ISyncAdapter.Stub.asInterface(syncAdapter);
                    activeSyncContext.mSyncAdapter.startSync(activeSyncContext, syncOperation.target.provider, syncOperation.target.account, syncOperation.extras);
                } else if (syncOperation.target.target_service) {
                    activeSyncContext.mSyncServiceAdapter = ISyncServiceAdapter.Stub.asInterface(syncAdapter);
                    activeSyncContext.mSyncServiceAdapter.startSync(activeSyncContext, syncOperation.extras);
                }
            }
            catch (RemoteException remoteExc) {
                Log.d(SyncManager.TAG, "maybeStartNextSync: caught a RemoteException, rescheduling", remoteExc);
                this.closeActiveSyncContext(activeSyncContext);
                SyncManager.this.increaseBackoffSetting(syncOperation);
                SyncManager.this.scheduleSyncOperation(new SyncOperation(syncOperation, 0L));
            }
            catch (RuntimeException exc) {
                this.closeActiveSyncContext(activeSyncContext);
                Log.e(SyncManager.TAG, "Caught RuntimeException while starting the sync " + syncOperation, exc);
            }
        }

        private void cancelActiveSyncH(SyncStorageEngine.EndPoint info, Bundle extras) {
            ArrayList<ActiveSyncContext> activeSyncs = new ArrayList<ActiveSyncContext>(SyncManager.this.mActiveSyncContexts);
            for (ActiveSyncContext activeSyncContext : activeSyncs) {
                SyncStorageEngine.EndPoint opInfo;
                if (activeSyncContext == null || !(opInfo = activeSyncContext.mSyncOperation.target).matchesSpec(info) || extras != null && !SyncManager.syncExtrasEquals(activeSyncContext.mSyncOperation.extras, extras, false)) continue;
                this.runSyncFinishedOrCanceledH(null, activeSyncContext);
            }
        }

        private void runSyncFinishedOrCanceledH(SyncResult syncResult, ActiveSyncContext activeSyncContext) {
            int upstreamActivity;
            int downstreamActivity;
            String historyMessage;
            boolean isLoggable = Log.isLoggable(SyncManager.TAG, 2);
            SyncOperation syncOperation = activeSyncContext.mSyncOperation;
            SyncStorageEngine.EndPoint info = syncOperation.target;
            if (activeSyncContext.mIsLinkedToDeath) {
                if (info.target_provider) {
                    activeSyncContext.mSyncAdapter.asBinder().unlinkToDeath(activeSyncContext, 0);
                } else {
                    activeSyncContext.mSyncServiceAdapter.asBinder().unlinkToDeath(activeSyncContext, 0);
                }
                activeSyncContext.mIsLinkedToDeath = false;
            }
            this.closeActiveSyncContext(activeSyncContext);
            long elapsedTime = SystemClock.elapsedRealtime() - activeSyncContext.mStartTime;
            if (syncResult != null) {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [finished]: " + syncOperation + ", result " + syncResult);
                }
                if (!syncResult.hasError()) {
                    historyMessage = "success";
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                    SyncManager.this.clearBackoffSetting(syncOperation);
                } else {
                    Log.d(SyncManager.TAG, "failed sync operation " + syncOperation + ", " + syncResult);
                    SyncManager.this.increaseBackoffSetting(syncOperation);
                    SyncManager.this.maybeRescheduleSync(syncResult, syncOperation);
                    historyMessage = ContentResolver.syncErrorToString(this.syncResultToErrorNumber(syncResult));
                    downstreamActivity = 0;
                    upstreamActivity = 0;
                }
                SyncManager.this.setDelayUntilTime(syncOperation, syncResult.delayUntil);
            } else {
                if (isLoggable) {
                    Log.v(SyncManager.TAG, "runSyncFinishedOrCanceled [canceled]: " + syncOperation);
                }
                if (activeSyncContext.mSyncAdapter != null) {
                    try {
                        activeSyncContext.mSyncAdapter.cancelSync(activeSyncContext);
                    }
                    catch (RemoteException e) {}
                } else if (activeSyncContext.mSyncServiceAdapter != null) {
                    try {
                        activeSyncContext.mSyncServiceAdapter.cancelSync(activeSyncContext);
                    }
                    catch (RemoteException e) {
                        // empty catch block
                    }
                }
                historyMessage = "canceled";
                downstreamActivity = 0;
                upstreamActivity = 0;
            }
            this.stopSyncEvent(activeSyncContext.mHistoryRowId, syncOperation, historyMessage, upstreamActivity, downstreamActivity, elapsedTime);
            if (info.target_provider) {
                if (syncResult != null && syncResult.tooManyDeletions) {
                    this.installHandleTooManyDeletesNotification(info.account, info.provider, syncResult.stats.numDeletes, info.userId);
                } else {
                    SyncManager.this.mNotificationMgr.cancelAsUser(null, info.account.hashCode() ^ info.provider.hashCode(), new UserHandle(info.userId));
                }
                if (syncResult != null && syncResult.fullSyncRequested) {
                    SyncManager.this.scheduleSyncOperation(new SyncOperation(info.account, info.userId, syncOperation.reason, syncOperation.syncSource, info.provider, new Bundle(), 0L, 0L, syncOperation.backoff, syncOperation.delayUntil, syncOperation.allowParallelSyncs));
                }
            } else if (syncResult != null && syncResult.fullSyncRequested) {
                SyncManager.this.scheduleSyncOperation(new SyncOperation(info.service, info.userId, syncOperation.reason, syncOperation.syncSource, new Bundle(), 0L, 0L, syncOperation.backoff, syncOperation.delayUntil));
            }
        }

        private void closeActiveSyncContext(ActiveSyncContext activeSyncContext) {
            activeSyncContext.close();
            SyncManager.this.mActiveSyncContexts.remove(activeSyncContext);
            SyncManager.this.mSyncStorageEngine.removeActiveSync(activeSyncContext.mSyncInfo, activeSyncContext.mSyncOperation.target.userId);
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "removing all MESSAGE_MONITOR_SYNC & MESSAGE_SYNC_EXPIRED for " + activeSyncContext.toString());
            }
            SyncManager.this.mSyncHandler.removeMessages(7, activeSyncContext);
            SyncManager.this.mSyncHandler.removeMessages(8, activeSyncContext);
        }

        private int syncResultToErrorNumber(SyncResult syncResult) {
            if (syncResult.syncAlreadyInProgress) {
                return 1;
            }
            if (syncResult.stats.numAuthExceptions > 0L) {
                return 2;
            }
            if (syncResult.stats.numIoExceptions > 0L) {
                return 3;
            }
            if (syncResult.stats.numParseExceptions > 0L) {
                return 4;
            }
            if (syncResult.stats.numConflictDetectedExceptions > 0L) {
                return 5;
            }
            if (syncResult.tooManyDeletions) {
                return 6;
            }
            if (syncResult.tooManyRetries) {
                return 7;
            }
            if (syncResult.databaseError) {
                return 8;
            }
            throw new IllegalStateException("we are not in an error state, " + syncResult);
        }

        private void manageSyncAlarmLocked(long nextPeriodicEventElapsedTime, long nextPendingEventElapsedTime) {
            boolean alarmIsActive;
            long now;
            if (!SyncManager.this.mDataConnectionIsConnected) {
                return;
            }
            if (SyncManager.this.mStorageIsLow) {
                return;
            }
            if (SyncManager.this.mDeviceIsIdle) {
                return;
            }
            long earliestTimeoutTime = Long.MAX_VALUE;
            for (ActiveSyncContext currentSyncContext : SyncManager.this.mActiveSyncContexts) {
                long currentSyncTimeoutTime = currentSyncContext.mTimeoutStartTime + MAX_TIME_PER_SYNC;
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "manageSyncAlarm: active sync, mTimeoutStartTime + MAX is " + currentSyncTimeoutTime);
                }
                if (earliestTimeoutTime <= currentSyncTimeoutTime) continue;
                earliestTimeoutTime = currentSyncTimeoutTime;
            }
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "manageSyncAlarm: earliestTimeoutTime is " + earliestTimeoutTime);
                Log.v(SyncManager.TAG, "manageSyncAlarm: nextPeriodicEventElapsedTime is " + nextPeriodicEventElapsedTime);
                Log.v(SyncManager.TAG, "manageSyncAlarm: nextPendingEventElapsedTime is " + nextPendingEventElapsedTime);
            }
            long alarmTime = Math.min(earliestTimeoutTime, nextPeriodicEventElapsedTime);
            if ((alarmTime = Math.min(alarmTime, nextPendingEventElapsedTime)) < (now = SystemClock.elapsedRealtime()) + 30000L) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "manageSyncAlarm: the alarmTime is too small, " + alarmTime + ", setting to " + (now + 30000L));
                }
                alarmTime = now + 30000L;
            }
            boolean shouldSet = false;
            boolean shouldCancel = false;
            boolean bl = alarmIsActive = this.mAlarmScheduleTime != null && now < this.mAlarmScheduleTime;
            if (alarmTime != Long.MAX_VALUE) {
                if (!alarmIsActive || alarmTime != this.mAlarmScheduleTime) {
                    shouldSet = true;
                }
            } else {
                shouldCancel = alarmIsActive;
            }
            SyncManager.this.ensureAlarmService();
            if (shouldSet) {
                if (Log.isLoggable(SyncManager.TAG, 2)) {
                    Log.v(SyncManager.TAG, "requesting that the alarm manager wake us up at elapsed time " + alarmTime + ", now is " + now + ", " + (alarmTime - now) / 1000L + " secs from now");
                }
                this.mAlarmScheduleTime = alarmTime;
                SyncManager.this.mAlarmService.setExact(2, alarmTime, SyncManager.this.mSyncAlarmIntent);
            } else if (shouldCancel) {
                this.mAlarmScheduleTime = null;
                SyncManager.this.mAlarmService.cancel(SyncManager.this.mSyncAlarmIntent);
            }
        }

        private void installHandleTooManyDeletesNotification(Account account, String authority, long numDeletes, int userId) {
            if (SyncManager.this.mNotificationMgr == null) {
                return;
            }
            ProviderInfo providerInfo = SyncManager.this.mContext.getPackageManager().resolveContentProvider(authority, 0);
            if (providerInfo == null) {
                return;
            }
            CharSequence authorityName = providerInfo.loadLabel(SyncManager.this.mContext.getPackageManager());
            Intent clickIntent = new Intent(SyncManager.this.mContext, SyncActivityTooManyDeletes.class);
            clickIntent.putExtra("account", account);
            clickIntent.putExtra("authority", authority);
            clickIntent.putExtra("provider", authorityName.toString());
            clickIntent.putExtra("numDeletes", numDeletes);
            if (!this.isActivityAvailable(clickIntent)) {
                Log.w(SyncManager.TAG, "No activity found to handle too many deletes.");
                return;
            }
            UserHandle user = new UserHandle(userId);
            PendingIntent pendingIntent = PendingIntent.getActivityAsUser(SyncManager.this.mContext, 0, clickIntent, 0x10000000, null, user);
            CharSequence tooManyDeletesDescFormat = SyncManager.this.mContext.getResources().getText(17039588);
            Context contextForUser = SyncManager.this.getContextForUser(user);
            Notification notification = new Notification.Builder(contextForUser).setSmallIcon(17303104).setTicker(SyncManager.this.mContext.getString(17039586)).setWhen(System.currentTimeMillis()).setColor(contextForUser.getColor(17170521)).setContentTitle(contextForUser.getString(17039587)).setContentText(String.format(tooManyDeletesDescFormat.toString(), authorityName)).setContentIntent(pendingIntent).build();
            notification.flags |= 2;
            SyncManager.this.mNotificationMgr.notifyAsUser(null, account.hashCode() ^ authority.hashCode(), notification, user);
        }

        private boolean isActivityAvailable(Intent intent) {
            PackageManager pm = SyncManager.this.mContext.getPackageManager();
            List<ResolveInfo> list = pm.queryIntentActivities(intent, 0);
            int listSize = list.size();
            for (int i = 0; i < listSize; ++i) {
                ResolveInfo resolveInfo = list.get(i);
                if ((resolveInfo.activityInfo.applicationInfo.flags & 1) == 0) continue;
                return true;
            }
            return false;
        }

        public long insertStartSyncEvent(SyncOperation syncOperation) {
            long now = System.currentTimeMillis();
            EventLog.writeEvent(2720, syncOperation.toEventLog(0));
            return SyncManager.this.mSyncStorageEngine.insertStartSyncEvent(syncOperation, now);
        }

        public void stopSyncEvent(long rowId, SyncOperation syncOperation, String resultMessage, int upstreamActivity, int downstreamActivity, long elapsedTime) {
            EventLog.writeEvent(2720, syncOperation.toEventLog(1));
            SyncManager.this.mSyncStorageEngine.stopSyncEvent(rowId, elapsedTime, resultMessage, downstreamActivity, upstreamActivity);
        }

        class SyncNotificationInfo {
            public boolean isActive = false;
            public Long startTime = null;

            SyncNotificationInfo() {
            }

            public void toString(StringBuilder sb) {
                sb.append("isActive ").append(this.isActive).append(", startTime ").append(this.startTime);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                this.toString(sb);
                return sb.toString();
            }
        }
    }

    class ServiceConnectionData {
        public final ActiveSyncContext activeSyncContext;
        public final IBinder adapter;

        ServiceConnectionData(ActiveSyncContext activeSyncContext, IBinder adapter) {
            this.activeSyncContext = activeSyncContext;
            this.adapter = adapter;
        }
    }

    private class SyncTimeTracker {
        boolean mLastWasSyncing = false;
        long mWhenSyncStarted = 0L;
        private long mTimeSpentSyncing;

        private SyncTimeTracker() {
        }

        public synchronized void update() {
            boolean isSyncInProgress;
            boolean bl = isSyncInProgress = !SyncManager.this.mActiveSyncContexts.isEmpty();
            if (isSyncInProgress == this.mLastWasSyncing) {
                return;
            }
            long now = SystemClock.elapsedRealtime();
            if (isSyncInProgress) {
                this.mWhenSyncStarted = now;
            } else {
                this.mTimeSpentSyncing += now - this.mWhenSyncStarted;
            }
            this.mLastWasSyncing = isSyncInProgress;
        }

        public synchronized long timeSpentSyncing() {
            if (!this.mLastWasSyncing) {
                return this.mTimeSpentSyncing;
            }
            long now = SystemClock.elapsedRealtime();
            return this.mTimeSpentSyncing + (now - this.mWhenSyncStarted);
        }
    }

    private static class AccountSyncStats {
        String name;
        long elapsedTime;
        int times;

        private AccountSyncStats(String name) {
            this.name = name;
        }
    }

    private static class AuthoritySyncStats {
        String name;
        long elapsedTime;
        int times;
        Map<String, AccountSyncStats> accountMap = Maps.newHashMap();

        private AuthoritySyncStats(String name) {
            this.name = name;
        }
    }

    class ActiveSyncContext
    extends ISyncContext.Stub
    implements ServiceConnection,
    IBinder.DeathRecipient {
        final SyncOperation mSyncOperation;
        final long mHistoryRowId;
        ISyncAdapter mSyncAdapter;
        ISyncServiceAdapter mSyncServiceAdapter;
        final long mStartTime;
        long mTimeoutStartTime;
        boolean mBound;
        final PowerManager.WakeLock mSyncWakeLock;
        final int mSyncAdapterUid;
        SyncInfo mSyncInfo;
        boolean mIsLinkedToDeath = false;
        String mEventName;
        long mBytesTransferredAtLastPoll;
        long mLastPolledTimeElapsed;

        public ActiveSyncContext(SyncOperation syncOperation, long historyRowId, int syncAdapterUid) {
            this.mSyncAdapterUid = syncAdapterUid;
            this.mSyncOperation = syncOperation;
            this.mHistoryRowId = historyRowId;
            this.mSyncAdapter = null;
            this.mSyncServiceAdapter = null;
            this.mTimeoutStartTime = this.mStartTime = SystemClock.elapsedRealtime();
            this.mSyncWakeLock = SyncManager.this.mSyncHandler.getSyncWakeLock(this.mSyncOperation);
            this.mSyncWakeLock.setWorkSource(new WorkSource(syncAdapterUid));
            this.mSyncWakeLock.acquire();
        }

        @Override
        public void sendHeartbeat() {
        }

        @Override
        public void onFinished(SyncResult result) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.v(SyncManager.TAG, "onFinished: " + this);
            }
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, result);
        }

        public void toString(StringBuilder sb) {
            sb.append("startTime ").append(this.mStartTime).append(", mTimeoutStartTime ").append(this.mTimeoutStartTime).append(", mHistoryRowId ").append(this.mHistoryRowId).append(", syncOperation ").append(this.mSyncOperation);
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 4;
            msg.obj = new ServiceConnectionData(this, service);
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            Message msg = SyncManager.this.mSyncHandler.obtainMessage();
            msg.what = 5;
            msg.obj = new ServiceConnectionData(this, null);
            SyncManager.this.mSyncHandler.sendMessage(msg);
        }

        boolean bindToSyncAdapter(ComponentName serviceComponent, int userId) {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "bindToSyncAdapter: " + serviceComponent + ", connection " + this);
            }
            Intent intent = new Intent();
            intent.setAction("android.content.SyncAdapter");
            intent.setComponent(serviceComponent);
            intent.putExtra("android.intent.extra.client_label", 17040426);
            intent.putExtra("android.intent.extra.client_intent", PendingIntent.getActivityAsUser(SyncManager.this.mContext, 0, new Intent("android.settings.SYNC_SETTINGS"), 0, null, new UserHandle(userId)));
            this.mBound = true;
            boolean bindResult = SyncManager.this.mContext.bindServiceAsUser(intent, this, 21, new UserHandle(this.mSyncOperation.target.userId));
            if (!bindResult) {
                this.mBound = false;
            } else {
                try {
                    this.mEventName = this.mSyncOperation.wakeLockName();
                    SyncManager.this.mBatteryStats.noteSyncStart(this.mEventName, this.mSyncAdapterUid);
                }
                catch (RemoteException e) {
                    // empty catch block
                }
            }
            return bindResult;
        }

        protected void close() {
            if (Log.isLoggable(SyncManager.TAG, 2)) {
                Log.d(SyncManager.TAG, "unBindFromSyncAdapter: connection " + this);
            }
            if (this.mBound) {
                this.mBound = false;
                SyncManager.this.mContext.unbindService(this);
                try {
                    SyncManager.this.mBatteryStats.noteSyncFinish(this.mEventName, this.mSyncAdapterUid);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSyncWakeLock.release();
            this.mSyncWakeLock.setWorkSource(null);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb);
            return sb.toString();
        }

        @Override
        public void binderDied() {
            SyncManager.this.sendSyncFinishedOrCanceledMessage(this, null);
        }
    }

    class SyncAlarmIntentReceiver
    extends BroadcastReceiver {
        SyncAlarmIntentReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            SyncManager.this.mHandleAlarmWakeLock.acquire();
            SyncManager.this.sendSyncAlarmMessage();
        }
    }

    class SyncHandlerMessagePayload {
        public final ActiveSyncContext activeSyncContext;
        public final SyncResult syncResult;

        SyncHandlerMessagePayload(ActiveSyncContext syncContext, SyncResult syncResult) {
            this.activeSyncContext = syncContext;
            this.syncResult = syncResult;
        }
    }
}

